import fragmentReportModel from "../models/fragmentReportModel.js"


const addFragmentReport = async (req, res) => {
    try {

        const { totalGram, totalAmount, toWareHouse, toPasa, detail, date } = req.body

        if (!totalGram || !totalAmount || !detail) {
            return res.json({ success: false, message: "لطفا موارد مهم را پر نمایید" })
        }

        const fragmentReport = {
            totalGram,
            totalAmount,
            toWareHouse,
            toPasa,
            detail,
            date
        }

        const newFragmentReport = new fragmentReportModel(fragmentReport)
        await newFragmentReport.save()

        res.json({ success: true, message: "دیتا موفقانه ثبت شد" })

    } catch (error) {
        console.log(error);
        res.json({ success: false, message: error.message });
    }
}

const getDailyReport = async(req, res)=>{
    try {
        const daily = await fragmentReportModel.find({}).sort({createdAt:-1})
        if(!daily){
            return res.json({success:false , message:"دیتا وجود ندارد"})
        }

        res.json({success:true , daily})

    } catch (error) {
        console.log(error);
        res.json({ success: false, message: error.message });
    }
}

const getTodayReport = async(req, res)=>{

    const startOfDay = new Date()
    startOfDay.setHours(0, 0, 0, 0)

    const endOfDay = new Date()
    endOfDay.setHours(23, 59, 59, 999)

    try {
        const today = await fragmentReportModel.find({createdAt:{$gte:startOfDay , $lte:endOfDay}}).sort({createdAt:-1})
        if(!today){
            return res.json({success:false , message:"دیتا وجود ندارد"})
        }

        res.json({success:true , today})

    } catch (error) {
        console.log(error);
        res.json({ success: false, message: error.message });
    }
}

export {addFragmentReport , getDailyReport, getTodayReport}