import customerModel from "../../models/customerModel.js"
import loanReportModel from "../../models/LoanReport/loanReportModel.js"


const addLoanReport = async (req, res) => {
    try {
        const { amount, currency, detail, date } = req.body
        const { cId } = req.query

        if ( !amount || !currency || !detail) {
            return res.json({ success: false, message: "لطفا موارد مهم را پر نمایید" })
        }
        if (!cId) {
            return res.json({ success: false, message: "آیدی شناسایی نشد" })
        }

        const { customerName } = await customerModel.findById(cId)

        const report = await loanReportModel.create({
            cName: customerName,
            cId,
            amount,
            currency,
            detail,
            date
        })

        res.json({ success: true, message: "دیتا ثبت شد" })

    } catch (error) {
        console.log(error);
        res.json({ success: false , message:error.message });
    }
}

const getLoanReport = async(req , res)=>{
    try {
        const report = await loanReportModel.find({}).sort({createdAt:-1})
        if(!report){
            return res.json({success:false , message:"دیتا وجود ندارد"})
        }
        res.json({success:true , report})
    } catch (error) {
        console.log(error);
        res.json({ success: false , message:error.message });
    }
}

const getTotal = async (req, res) => {
    try {
        const today = new Date().toISOString().split("T")[0]

        const startOfDay = new Date(`${today}T00:00:00.000Z`)
        const endOfDay   = new Date(`${today}T23:59:59.999Z`)

        const total = await loanReportModel.aggregate([
            {
                $match: {
                    date: {
                        $gte: startOfDay,
                        $lte: endOfDay
                    }
                }
            },
            {
                $group: {
                    _id: "$currency",
                    amount: { $sum: "$amount" }
                }
            },
            {
                $project: {
                    _id: 0,
                    currency: "$_id",
                    amount: 1
                }
            }
        ])

        if (total.length === 0) {
            return res.json({
                success: false,
                message: "دیتا وجود ندارد"
            })
        }

      
        return res.json({
            success: true,
            total
        })

    } catch (error) {
        console.log(error)
        return res.json({success: false, message: error.message})
    }
}


export {addLoanReport , getLoanReport , getTotal}