import { exec } from "child_process";
import path from "path";
import fs from "fs";

const backup = async (req, res) => {
  try {
    // مسیر mongodump (اگر نسخه‌ات فرق داشت، فقط این خط را عوض کن)
    const mongoDumpPath =
      `"C:\\Users\\HALEEM\\Desktop\\mongodb-database-tools-windows-x86_64-100.14.0\\bin\\mongodump.exe"`;

    // مسیر ریشه پروژه
    const projectRoot = process.cwd();

    // مسیر backups داخل پروژه
    const backupsRoot = path.join(projectRoot, "backups");

    // اگر فولدر backups نبود، بساز
    if (!fs.existsSync(backupsRoot)) {
      fs.mkdirSync(backupsRoot, { recursive: true });
    }

    // فولدر بکاپ با timestamp
    const backupFolder = `backup-${Date.now()}`;
    const backupPath = path.join(backupsRoot, backupFolder);

    // دستور بکاپ
    const command = `${mongoDumpPath} --db Jwelry --out "${backupPath}"`;

    exec(command, (error, stdout, stderr) => {
      if (error) {
        console.error("Backup error:", error);
        return res.json({
          success: false,
          message: "مشکلی رخ داد",
          error: error.message
        });
      }

      if (stderr) {
        console.error("Backup stderr:", stderr);
      }

      console.log(stdout);

      res.json({
        success: true,
        message: "دیتا موفقانه بک آپ گرفته شد",
        path: `backups/${backupFolder}`
      });
    });

  } catch (error) {
    console.error(error);
    res.json({ success: false, message: error.message });
  }
};

export { backup };
