import path from 'path'
import companyInfo from '../models/companyInfo.js'


const editCompanyInfo = async (req, res) => {
    try {
        const { companyName, slogan, phone, email, address, date } = req.body
        let imageFile = req.file

        if (!companyName || !phone || !address) {
            return res.json({ success: false, message: "لطفا موارد مهم را خانه پری نمایید" })
        }


        if(imageFile){
            imageFile = req.file.path
        }

        const companyInformation = {
            companyName,
            slogan,
            phone,
            email,
            address,
            date,
            image: imageFile
        }

        const newInfo = await companyInfo(companyInformation)
        await newInfo.save()

        res.json({ success: true, message: "اطلاعات شرکت موفقانه ویرایش شد", data:{company:companyInformation} })

    } catch (error) {
        console.log(error);
        res.json({ success: false, message: error.message })
    }
}

const companyData = async(req , res)=>{
    try {
        
        const companyData = await companyInfo.findOne({}).sort({_id:-1})
        if(!companyData){
            return res.json({success:false , message:"دیتا وجود ندارد"})
        }
        res.json({success:true , companyData})
        
    } catch (error) {
        console.log(error);
        res.json({ success: false, message: error.message })
    }
}



export { editCompanyInfo , companyData}