import currencyModel from "../models/currencyModel.js"


const setTodayRate = async(req , res)=>{
    try {

        const {usdToAfn} = req.body

        const today = new Date().toISOString().split("T")[0]

        const rate = await currencyModel.findOneAndUpdate(
            {date:today} ,
            {usdToAfn},
            {upsert:true , new:true}
        )
        
        res.json({success: true , rate})
    } catch (error) {
        console.log(error);
    res.json({ success: false , message:error.message });
    }
}

const getTodayRate = async(req , res)=>{
    try {

        const today = new Date().toISOString().split("T")[0]

        const rate = await currencyModel.findOne({date:today})

        if(!rate){
            return res.json({success:false , message:"نرخ را تعیین کنید"})
        }

        res.json({success:true , rate})
        
    } catch (error) {
        console.log(error);
        res.json({ success: false, message: error.message })
    }
}

export {setTodayRate , getTodayRate}