import customerModel from "../models/customerModel.js"



const addNewCustomer = async (req, res) => {
    try {

        const { customerName, phone, email, address, date } = req.body

        if (!customerName || !phone) {
            res.json({ success: false, message: "لطفا موارد مهم را خانه پری نمایید" })
        }
        console.log(req.body)

        const customer = {
            customerName,
            phone,
            email,
            address,
            date
        }

        const newCustomer = new customerModel(customer)
        await newCustomer.save()

        return res.json({ success: true, message: "دیتا موفقانه ثبت شد", newCustomer })


    } catch (error) {
        console.log(error);
        res.json({ success: false, message: error.message })

    }
}

const getCustomers = async (req, res) => {
    try {

        const customers = await customerModel.find({})

        if (!customers) {
            res.json({ success: false, message: "دیتا وجود ندارد" })
        } else {
            return res.json({ success: true, customers })
        }

    } catch (error) {
        console.log(error);
        res.json({ success: false, message: error.message })
    }
}
const searchCustomer = async (req, res) => {
    try {
        const q = req.query.q?.trim()

        if(!q) {
            return res.json({ success: false, message: "لطفا چیزی بنویسید" })
        }

        const result = await customerModel.find(
            {customerName : {$regex : q , $options:'i'}}
        )

        res.json({ success: true, result })
        
    } catch (error) {
        console.log(error);
        res.json({ success: false, message: error.message })
    }
}

const updateCustomer = async (req , res)=>{

    const id = req.params.customerId

    if(!id){

        console.log("مشتری انتخاب نشد")
    }

    try {

        const {customerName , phone , email , address} = req.body

        const {newUpdatedCustomer} = await customerModel.findByIdAndUpdate(id , {customerName , phone , email, address} , {new : true})

        if(!newUpdatedCustomer){
            console.log("مشتری یافت نشد")
        }

        res.json({success:true , message:"اطلاعات مشتری آپدیت شد" , newUpdatedCustomer})
        
    } catch (error) {
        console.log(error);
        res.json({ success: false, message: error.message })
    }

    
}

const deleteCustomer = async(req , res)=>{
    const id = req.params.customerId
    try {

        await customerModel.findByIdAndDelete(id)
        
        res.json({success:true , message:"مشتری حذف شد"} )
        
    } catch (error) {
        console.log(error);
        res.json({ success: false, message: error.message })
    }
}


export { addNewCustomer, getCustomers, searchCustomer , updateCustomer , deleteCustomer}