import expensesModel from "../models/expensesModel.js"


const addExpense = async (req, res) => {
    try {

        const { type, detail, price, currency, date } = req.body

        if (!type || !detail || !price || !currency) {
            return res.json({ success: false, message: "لطفا خانه های خالی را پر نمایید" })
        }

        const expense = {
            type,
            detail,
            price,
            currency,
            date
        }

        const newExpense = new expensesModel(expense)
        await newExpense.save()
        res.json({ success: true, message: "دیتا موفقانه ثبت شد" })

    } catch (error) {
        console.log(error);
        res.json({ success: false, message: error.message })
    }
}

const getSpent = async (req, res) => {

    try {

        const spent = await expensesModel.find({})

        if (!spent) {
            return res.json({ success: false, message: "دیتا وجود ندارد" })
        } else {
            res.json({ success: true, spent })
        }

    } catch (error) {
        console.log(error);
        res.json({ success: false, message: error.message })
    }
}
const updateSpent = async (req, res) => {
    try {
        const { type, detail, quantity, sum, currency, rate, date } = req.body
        const expenseId = req.params.id
        console.log("req", req.body)

        const { newUpdatedSpent } = await expensesModel.findByIdAndUpdate(expenseId, { type, detail, quantity, sum, currency, rate, date }, { new: true })
        if (!newUpdatedSpent) {
            console.log("data is empty")
        }

        res.json({ success: true, message: "موفقانه آپدیت شده است", newUpdatedSpent })

    } catch (error) {
        console.log(error);
        res.json({ success: false, message: error.message })
    }
}

const deleteSpent = async (req, res) => {

    try {
        const id = req.params.spentId
        await expensesModel.findByIdAndDelete(id)

        res.json({ success: true, message: "دیتا حذف شد" })

    } catch (error) {
        console.log(error);
        res.json({ success: false, message: error.message })
    }
}

const handleSearch = async (req, res) => {
    try {
        const { search } = req.query;

        let query = {};

        if (search) {
            query.type = { $regex: search, $options: "i" };
        }

        const expense = await expensesModel.find(query);

        res.json({
            success: true,
            data: expense
        });

    } catch (error) {
        console.log(error);
        res.json({ success: false, message: error.message });
    }
};

const getDaily = async (req, res) => {
  const startOfDay = new Date()
  startOfDay.setHours(0, 0, 0, 0)

  const endOfDay = new Date()
  endOfDay.setHours(23, 59, 59, 999)

  try {
    const daily = await expensesModel
      .find({ date: { $gte: startOfDay, $lte: endOfDay } })
      .sort({ date: -1 })

    if (daily.length === 0) {
      return res.json({ success: false, message: "دیتا وجود ندارد" }) // ✅ return خیلی مهم
    }

    const total = await expensesModel.aggregate([
      {
        $match: { date: { $gte: startOfDay, $lte: endOfDay } }
      },
      {
        $group: {
          _id: "$currency",
          currency: { $first: "$currency" },
          price: { $sum: "$price" }
        }
      }
    ])

    return res.json({ success: true, daily, total }) // ✅ فقط یک پاسخ نهایی
  } catch (error) {
    console.log(error)
    return res.json({ success: false, message: error.message })
  }
}


const getAll = async (req, res) => {

    try {
        const all = await expensesModel.find({}).sort({ date: -1 })
        if (all.length === 0) {
            res.json({ success: false, message: "دیتا وجود ندارد" })

        }

        const total = await expensesModel.aggregate([

            {
                $group: {
                    _id: "$currency",
                    currency: { $first: "$currency" },
                    price: { $sum: "$price" }
                }
            },
            {
                $sort: { date: -1 }
            }
        ])

        res.json({ success: true, all, total })
    } catch (error) {
        console.log(error);
        res.json({ success: false, message: error.message });
    }
}

const getTotal = async (req, res) => {
    try {
        const total = await expensesModel.aggregate([
            {
                $group: {
                    _id: {
                        type: "$type",
                        currency: "$currency"
                    },
                    price: { $sum: "$price" }
                }
            }
        ])

        if (total.length === 0) {
            return res.json({ success: false, message: "دیتا وجود ندارد" })
        }

        res.json({ success: true, total })
    } catch (error) {
        console.log(error);
        res.json({ success: false, message: error.message });
    }
}


export { addExpense, getSpent, updateSpent, deleteSpent, handleSearch, getDaily, getAll ,getTotal }