import fragmentModel from "../models/fragmentModel.js"

const addFragment = async (req, res) => {
  try {
    const { gram, amount, detail, date } = req.body
    if (!gram || !amount || !date) {
      return res.json({ success: false, message:"لطفا موارد مهم را خانه پری نمایید" })
    }

    const fragment = {
      gram,
      remain: gram,
      amount,
      detail,
      date
    }

    const newFragment = new fragmentModel(fragment)
    await newFragment.save()

    res.json({ success: true, message: "دیتا ثبت شد" })
  } catch (error) {
    console.log(error);
    res.json({ success: false, message: error.message });
  }
}

const search = async (req, res) => {
  try {
    const { search } = req.query;

    if (!search) {
      return res.json({ success: true, data: [] });
    }

    const startOfDay = new Date(search);
    startOfDay.setHours(0, 0, 0, 0);

    const endOfDay = new Date(search);
    endOfDay.setHours(23, 59, 59, 999);

    console.log("START:", startOfDay);
    console.log("END:", endOfDay);

    const data = await fragmentModel.find({
      createdAt: {
        $gte: startOfDay,
        $lte: endOfDay
      }
    });

    res.json({ success: true, data });

  } catch (error) {
    console.log(error);
    res.json({ success: false, message: error.message });
  }
};

const updateState = async (req, res) => {
  try {
    const { id } = req.query
    const { gram } = req.body

    if (!id) {
      return res.json({ success: false, message: "آیدی شناسایی نشد" })
    }

    if (!gram || gram <= 0) {
      return res.json({ success: false, message: "گرام نامعتبر است" })
    }

    const toChange = await fragmentModel.findById(id)

    if (!toChange) {
      return res.json({ success: false, message: "دیتا وجود ندارد" })
    }

    //  جلوگیری از بیشتر شدن از باقی
    if (gram > toChange.remain) {
      return res.json({
        success: false,
        message: "مقدار واردشده از باقی بیشتر است"
      })
    }

    //  آپدیت مقادیر
    toChange.wareHouse += gram
    toChange.remain -= gram

    // اگر همه انتقال شد
    if (toChange.remain === 0) {
      toChange.isCompleted = true
    }

    await toChange.save()

    res.json({
      success: true,
      message: "موفقانه ثبت شد",
      data: toChange
    })

  } catch (error) {
    console.log(error)
    res.json({ success: false, message: error.message })
  }
}


const getNotCompleted = async (req, res) => {
  const startOfDay = new Date();
  startOfDay.setHours(0, 0, 0, 0);

  const endOfDay = new Date();
  endOfDay.setHours(23, 59, 59, 999);

  try {
    const notCompleted = await fragmentModel.find({
      createdAt:{
        $gte:startOfDay,
        $lte:endOfDay
      }
    })
    if (!notCompleted) {
      return res.json({ success: false, message: "دیتا وجود ندارد" })
    }
    res.json({ success: true, notCompleted })
  } catch (error) {
    console.log(error);
    res.json({ success: false, message: error.message });
  }
}

const getTotal = async (req, res) => {

  const startOfDay = new Date();
  startOfDay.setHours(0, 0, 0, 0);

  const endOfDay = new Date();
  endOfDay.setHours(23, 59, 59, 999);

  try {
    const total = await fragmentModel.aggregate([
      {
        $match: {
          "createdAt":{
          $gte: startOfDay,
          $lte: endOfDay
        }}
      },
      {
        $group: {
          _id: null,
          gram:{$sum:"$gram"} ,
          amount:{$sum:"$amount"} 
        }
      },
      {
        $project: {
          gram: 1,
          amount: 1
        }
      }
    ])

    if (total.length === 0 ) {
      return res.json({ success: false, message: "دیتا وجود ندارد" })
    }

    res.json({ success: true, total })
  } catch (error) {
    console.log(error);
    res.json({ success: false, message: error.message });
  }
}

const handleDelete = async(req , res)=>{
  try {
    const {id} = req.query
    const deleted = await fragmentModel.findByIdAndDelete(id)
    res.json({success:true , message:"موفقانه دلیت شد"})

  } catch (error) {
    console.log(error);
    res.json({ success: false, message: error.message });
  }
}


export { addFragment, search, updateState, getNotCompleted , getTotal , handleDelete}