import pasaModel from "../models/pasaModel.js"


const addPasa = async (req, res) => {
    try {
        const { gram, toPasa, detail, date } = req.body

        if (!gram || !toPasa) {
            return res.json({ success: false, message: "لطفا موارد مهم را خانه پری نمایید" })
        }

        const pasa = {
            gram,
            toPasa,
            detail,
            date
        }

        const newPasa = await pasaModel(pasa)
        await newPasa.save()

        res.json({ success: true, message: "دیتا موفقانه ثبت شد" })

    } catch (error) {
        console.log(error);
        res.json({ success: false, message: error.message });
    }
}


