import personModel from "../../models/personally/personModel.js"

const addPerson = async (req, res) => {
    try {
        const { name, phone } = req.body
        if (!name || !phone) {
            return res.json({ success: false, message: "لطفا موارد مهم را خانه پری نمایید" })
        }
        const person = await personModel.create({
            name,
            phone
        })
        res.json({ success: true, message: "دیتا موفقانه ثبت شد" })
    } catch (error) {
        console.log(error);
        res.json({ success: false, message: error.message });
    }
}

const searchPerson = async (req, res) => {
    try {
        const { search } = req.query

        if (!search) {
            return res.json({ success: false, message: "جستجو کنید" })
        }

        const query = {
            name: { $regex: search, $options: "i" }
        }

        const person = await personModel.find(query).limit(10)

        if (person.length === 0) {
            return res.json({ success: false, message: "شخص پیدا نشد" })
        }

        res.json({ success: true, person })


    } catch (error) {
        console.log(error);
        res.json({ success: false, message: error.message });
    }
}

const getPerson = async(req , res) =>{
    try {
        const person = await personModel.find({}).sort({createdAt:-1})
        res.json({success:true , person})
    } catch (error) {
        console.log(error);
        res.json({ success: false, message: error.message });
    }
}

export { addPerson  , searchPerson , getPerson}