import personalExpenseModel from "../../models/personally/personalExpenseModel.js"
import personModel from "../../models/personally/personModel.js"
import mongoose from 'mongoose'

const addExpense = async (req, res) => {
    try {
        const { amount, currency, detail } = req.body
        const { personId } = req.query

        if (!amount || !currency) {
            return res.json({ success: false, message: "لطفا موارد مهم را پر نمایید" })
        }
        if (!personId) {
            return res.json({ success: false, message: "آیدی شناسایی نشد" })
        }

        const { name } = await personModel.findById(personId)

        const expense = await personalExpenseModel.create({
            personId, name, amount, currency, detail
        })

        res.json({ success: true, message: "دیتا ثبت شد" })
    } catch (error) {
        console.log(error);
        res.json({ success: false, message: error.message });
    }
}

const getExpense = async (req, res) => {
    try {
        const expense = await personalExpenseModel.find({})
        if (!expense) {
            return res.json({ success: false, message: "دیتا وجود ندارد" })
        }
        res.json({ success: true, expense })
    } catch (error) {
        console.log(error);
        res.json({ success: false, message: error.message });
    }
}

const getBalance = async (req, res) => {
    try {
        const { id } = req.query

        if (!id) {
            return res.json({ success: false, message: "آیدی شناسایی نشد" })
        }
        const balance = await personalExpenseModel.find({ personId: new mongoose.Types.ObjectId(id) })
        if (!balance) {
            return res.json({ success: false, message: "بلانس خالی است" })
        }

        res.json({ success: true, balance })
    } catch (error) {
        console.log(error);
        res.json({ success: false, message: error.message });
    }
}

const handleTotal = async (req, res) => {
    try {
        const { id } = req.query
        if (!id) {
            return res.json({ success: false, message: "آیدی شناسایی نشد" })
        }

        console.log("ID FROM FRONT:", id)
        console.log("IS VALID OBJECTID:", mongoose.Types.ObjectId.isValid(id))

        const total = await personalExpenseModel.aggregate([
            {
                $match: {
                    personId: new mongoose.Types.ObjectId(id)
                }
            },
            {
                $group: {
                    _id: "$currency",
                    amount: { $sum: "$amount" }

                }
            },
            {
                $project: {
                    _id: 1,
                    amount: 1
                }
            }
        ])

        if (total.length === 0) {
            return res.json({ success: false, message: "دیتا وجود ندارد" })
        }

        res.json({ success: true, total })

    } catch (error) {
        console.log(error);
        res.json({ success: false, message: error.message });
    }

}

const getDailyTotal = async (req, res) => {
    const startOfDay = new Date();
    startOfDay.setHours(0, 0, 0, 0);

    const endOfDay = new Date();
    endOfDay.setHours(23, 59, 59, 999);

    try {
        const total = await personalExpenseModel.aggregate([
            {
                $match: {
                    createdAt: {
                        $gte: startOfDay,
                        $lte: endOfDay
                    }
                }
            },
            {
                $group: {
                    _id: '$currency',
                    amount: { $sum: "$amount" }
                }
            },
            {
                $project: {
                    _id: 1,
                    amount: 1
                }
            }
        ])

        if (total.length === 0) {
            return res.json({ success: false, message: "دیتا وجود ندارد" })
        }
        return res.json({ success: true, total })
    } catch (error) {
        console.log(error);
        res.json({ success: false, message: error.message });
    }
}

export { addExpense, getExpense, getBalance, handleTotal , getDailyTotal }
