import productMasterModel from "../models/productMasterModel.js"


const createProductMaster = async(req , res)=>{
    try {

        const {name , type , gram , karat} = req.body

        if(!name || !type||!gram || !karat){
            return res.json({success:false , message:"لطفا موارد مهم را خانه پری نمایید"})
        }

        const productMaster = {
            name , 
            type ,
            gram,
            karat
        }

        const newProductMaster = new productMasterModel(productMaster)
        await newProductMaster.save()

        res.json({success:true , message:"دیتا ثبت شد"})
        
    } catch (error) {
        console.log(error);
        res.json({ success: false, message: error.message })
    }
}

const getProductMaster = async (req, res) => {
  try {
    const { search } = req.query;

    const filter = { isActive: true };

    if (search) {
      filter.name = { $regex: search, $options: "i" };
    }

    const productMaster = await productMasterModel.find(filter).limit(10);

    const productMasterList = await productMasterModel.find({isActive:true})

    if (productMaster.length === 0) {
 
      return res.json({ success: false, message: "دیتا یافت نشد" });
    }

    res.json({ success: true, productMaster  , productMasterList});

  } catch (error) {
    console.log(error);
    return res.status(500).json({ success: false, message: error.message });
  }
};

const getAllproductMaster = async(req , res)=>{

  try {

    const allProductMaster = await productMasterModel.find({})

    if(!allProductMaster || allProductMaster.length === 0){
      return res.json({success:true , message:"دیتا وجود ندارد"})
    }

    res.json({success:true , allProductMaster})
    
  } catch (error) {
    console.log(error);
    return res.status(500).json({ success: false, message: error.message });
  }
}

const updateProducList = async(req , res)=>{
  try {

    const updatedProduct = await productMasterModel.findByIdAndUpdate(req.params.id , req.body)

    res.json({success:true , message:"محصول موفقانه آپدیت شده است" , updatedProduct})

  } catch (error) {
    console.log(error);
    return res.json({ success: false, message: error.message });
  }
}

const deleteProduct = async(req , res)=>{
  try {

    const deleted = await productMasterModel.findByIdAndDelete(req.params.id)

    res.json({success:true , message:"محصول موفقانه حذف شد"})
  } catch (error) {
    
  }
  
  
}

export {createProductMaster , getProductMaster , getAllproductMaster , updateProducList}