import storageModel from "../models/storageModel.js"

const setTodayStorage = async(req , res)=>{
    try {

        const {usd , afn} = req.body

        const today = new Date().toISOString().split("T")[0]

        const storage = await storageModel.findOneAndUpdate(
            {date:today} ,
            {usd , afn},
            {upsert:true , new:true}
        )
        
        res.json({success: true , storage})
    } catch (error) {
        console.log(error);
    res.json({ success: false , message:error.message });
    }
}

const getTodaystorage = async(req , res)=>{
    try {

        const today = new Date().toISOString().split("T")[0]

        const storage = await storageModel.findOne({date:today})

        if(!storage){
            return res.json({success:false , message:"نرخ را تعیین کنید"})
        }

        res.json({success:true , storage})
        
    } catch (error) {
        console.log(error);
        res.json({ success: false, message: error.message })
    }
}

export {setTodayStorage , getTodaystorage}