import supplierModel from "../models/supplierModel.js"


const createSupplier = async (req, res) => {
    try {

        const { name, phone, address } = req.body

        if (!name || !phone) {
            return res.json({ success: false, message: "لطفا موارد مهم را خانه پری نمایید" })
        }

        const supplier = {
            name,
            phone,
            address
        }

        const newSupplier = new supplierModel(supplier)
        await newSupplier.save()

        if (!supplier) {
            return res.json({ success: false, message: "ذخیره نشد" })
        }

        res.json({ success: true, message: "ذخیره شد" })
    } catch (error) {
        console.log(error);
        res.json({ success: false, message: error.message })
    }
}

const getSupplier = async (req, res) => {
    try {

        const { search } = req.query

        const filter = {
            isActive: true
        }

        if (search) {
            filter.name = { $regex: search, $options: "i" }
        }

        const supplier = await supplierModel.find(filter).limit(10)

        if (!supplier) {
            return res.json({ success: false, message: "خطا رخ داد" })
        }

        if (supplier.length === 0) {
            return res.json({ success: false, message: "دیتا وجود ندارد" })
        }
        console.log(supplier)

        res.json({ success: true, supplier })

    } catch (error) {
        console.log(error);
        res.json({ success: false, message: error.message })
    }
}

const deactivateSupplier = async (req, res) => {
    try {

        await supplierModel.findByIdAndUpdate(req.params.id, { isActive: false })

        res.json({ success: true, message: "تمویل کننده غیر فعال شد" })

    } catch (error) {
        console.log(error);
        res.json({ success: false, message: error.message })
    }
}

const getAllSuppliers = async (req, res) => {
    try {

        const data = await supplierModel.find({})

        if (!data) {
            return res.json({ success: true, message: "هیچ اطلاعاتی یافت نشد" })
        }

        res.json({ success: true, data })

    } catch (error) {
        console.log(error);
        res.json({ success: false, message: error.message })
    }
}

const updateSupplier = async (req, res) => {
    try {

        const updated = await supplierModel.findByIdAndUpdate(req.params.id, req.body, { new: true })
        res.json({ success: true, supplier: updated });

    } catch (error) {
        console.log(error);
        res.json({ success: false, message: error.message })
    }
}

const deleteSupplier = async(req , res)=>{
    try {
        const deletedSupplier = await supplierModel.findByIdAndDelete(req.params.id)
        res.json({success:true  , message:"تمویل کننده موفقانه حذف شد" , deletedSupplier})
    } catch (error) {
        console.log(error);
        res.json({ success: true , message: error.message })
    }
}

export { createSupplier, getSupplier, deactivateSupplier, getAllSuppliers , updateSupplier , deleteSupplier }