import traderModel from "../models/tradersModel.js"


const addTrader = async (req, res) => {
    try {
        const { name, phone, address } = req.body
        if (!name || !phone) {
            return res.json({ success: false, message: "لطفا موارد مهم را خانه پری نمایید" })
        }

        const trader = {
            name,
            phone,
            address
        }

        const newTrader = new traderModel(trader)
        await newTrader.save()

        res.json({ success: true, message: "اطلاعات ثبت شد" })

    } catch (error) {
        console.log(error);
        res.json({ success: false, message: error.message });
    }
}

const getTrader = async (req, res) => {
    try {
        const trader = await traderModel.find({})
        res.json({ success: true, trader })
    } catch (error) {
        console.log(error);
        res.json({ success: false, message: error.message });
    }
}

export { addTrader , getTrader }