import express from 'express'
import cors from 'cors'
import 'dotenv/config'
import connectDB from './config/mongodb.js'
import path from 'path'
import companyRoute from './route/companyRoute.js'
import productRoute from './route/productRoute.js'
import customerRoute from './route/customerRoute.js'
import expensesRoute from './route/expensesRoute.js'
import transactionRoute from './route/transactionRoute.js'
import { loginAdmin } from './controllers/adminController.js'
import adminRoute from './route/adminRoute.js'
import currencyRateRoute from './route/currencyRateRoute.js'
import supplierRoute from './route/supplierRoute.js'
import productMasterRoute from './route/productMasterRoute.js'
import purchaseRoute from './route/purchaseRoute.js'
import backupRoute from './route/backupRoute.js'
import supplierProductRoute from './route/supplierModelRoute.js'
import traderModel from './models/tradersModel.js'
import traderRoute from './route/traderRoute.js'
import tradeModel from './models/tradeModel.js'
import tradeRoute from './route/tradeRoute.js'
import storageRoute from './route/storageRoute.js'
import fragmentRoute from './route/fragmentRoute.js'
import fragmentReportRoute from './route/fragmentReportRoute.js'
import personRoute from './route/personally/personRoute.js'
import personalExpenseRoute from './route/personally/personalExpenseRoute.js'
import loanReportRoute from './route/LoanReport/loanReportRoute.js'



//app config
const app = express()
const port = process.env.PORT || 4000;
connectDB()

//midlewares
app.use(express.json())
app.use(express.urlencoded({ extended: true }));
app.use(cors())
app.use('/uploads',express.static('uploads'))

//api endpoints
app.use('/api/company' , companyRoute)
app.use('/api/product' , productRoute)
app.use('/api/customer' , customerRoute)
app.use('/api/expense' , expensesRoute)
app.use('/api/transaction' , transactionRoute)
app.use('/api/admin' , adminRoute)
app.use('/api/currency' , currencyRateRoute)
app.use('/api/supplier' , supplierRoute)
app.use('/api/product-master' , productMasterRoute)
app.use('/api/purchase' , purchaseRoute)
app.use('/api/backup' , backupRoute)
app.use('/api/supplier-product' , supplierProductRoute)
app.use('/api/trader' , traderRoute)
app.use('/api/trade', tradeRoute)
app.use('/api/storage', storageRoute)
app.use('/api/fragment', fragmentRoute)
app.use('/api/fragment-report', fragmentReportRoute)
app.use('/api/person', personRoute)
app.use('/api/personal-expense', personalExpenseRoute)
app.use('/api/loan-report', loanReportRoute)

// localhost:4000/api/admin

app.get('/' , (req , res)=>{
    res.send("API Working")
})

app.listen(port , ()=>console.log('Server Started' , port))