import mongoose from 'mongoose'

const expensesSchema = new mongoose.Schema({

    type:{type:String , required:true},
    detail:{type:String , required:true},
    price:{type:Number , required:true },
    currency:{type:String , required:true ,enum:['دالر' , 'افغانی']},
    date:{type:Date , default:Date.now()},

})
expensesSchema.index({
    name:"text",
    phone:"text"
})

const expensesModel = mongoose.model('Expenses' , expensesSchema)

export default expensesModel