import mongoose from 'mongoose'

const personalExpenseSchema = new mongoose.Schema({
    name:{type:String , required:true},
    personId:{type:mongoose.Schema.Types.ObjectId , required:true , ref: "Person"},
    amount:{type:Number , required:true},
    currency:{type:String , required:true},
    detail:{type:String}
},
{
    timestamps:true
})

const personalExpenseModel = mongoose.model('personal-expense' , personalExpenseSchema)
export default personalExpenseModel