import mongoose from 'mongoose'

const purchaseItemSchema = new mongoose.Schema({
  productMasterId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: "ProductMaster",
    required: true
  },

  name: {
    type: String,
    required: true
  },
  type: {
    type: String,
    required: true
  },

gram: {
    type: Number,
    required: true
  },

  karat: {
    type: Number,
    required: true
  },


  quantity: {
    type: Number,
    required: true,
    min: 1
  },

  registeredQty: {
    type: Number,
    default: 0
  },

  remainingQty: {
    type: Number,
    required: true
  },

  price: {
    type: Number,
    required: true
  },

  isCompleted: {
    type: Boolean,
    default: false
  }
});


const purchaseSchema = new mongoose.Schema({
  supplierId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: "Supplier",
    required: true
  },

  supplierName: {
    type:String,
    required:true
  } ,

  items: {
    type: [purchaseItemSchema],
    required: true,
    validate: v => v.length > 0
  },

  totalAmount: {
    type: Number
  },

  date: {
    type: Date,
    default: Date.now
  },

  bellNumber: {
    type: Number,
    required: true,
    unique:true
  },
  currency: {
    type:String,
    required:true
  },
  paidAmount:{
    type:Number,
    required:true
  }
},{
  timestamps:true
})

const purchaseModel = mongoose.model('Purchase', purchaseSchema)
export default purchaseModel