import mongoose from 'mongoose';

// یک محصول تمویل‌کننده
const supplierProductItemSchema = new mongoose.Schema({
  name: { type: String, required: true },
  type: { type: String, },
  karat: { type: Number },
  weight: { type: Number, required: true },
  registeredWeight : {type : Number , default:0},
  remainWeight : {type : Number},
  pasa: { type: Number, required: true },
  pasaReceipt: { type: Number , default:0 },
  pasaRemaining: { type: Number, required: true },
  wagePerGram: { type: Number },
  totalWage: { type: Number, required: true },
  wageReceipt: { type: Number, default:0 },
  wageRemaining: { type: Number, required: true },
  isCompleted:{type:Boolean , default:false}
});

// سند محصولات تمویل‌کننده
const supplierProductSchema = new mongoose.Schema({
  products: { type: [supplierProductItemSchema], required: true }, // چند محصول
  supplierId: { type: mongoose.Schema.Types.ObjectId, required: true, ref: "Supplier" },
  supplierName: { type: String, required: true },
  bellNumber: { type: Number, },
  detail:{type:String}
}, { timestamps: true }); // timestamps: createdAt و updatedAt

const supplierProductModel = mongoose.model('SupplierProduct', supplierProductSchema);

export default supplierProductModel;
