import mongoose from 'mongoose'

const transactionSchema = new mongoose.Schema({
  customerId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: "Customer",
    required: true
  },
  customerName: { type: String, required: true },
  customerPhone: { type: String, required: true },
  product: { type: Array, required: true },
  receipt: {type:Object , required:true},
  bellNumber: { type: Number, required: true , unique:true},
  note: { type: String }
},
{
  timestamps:true
});


const transactionModel = mongoose.models.transaction|| mongoose.model('Transaction', transactionSchema)

export default transactionModel