import express from 'express'
import { addExpense, deleteSpent, getAll, getDaily, getSpent, getTotal, handleSearch, updateSpent } from '../controllers/expensesController.js'

const expensesRoute = express.Router()

expensesRoute.post('/add-expense', addExpense)
expensesRoute.get('/get-spent' , getSpent)
expensesRoute.put('/update-spent/:id' , updateSpent)
expensesRoute.delete('/delete-spent/:spentId' , deleteSpent)
expensesRoute.get('/search' , handleSearch)
expensesRoute.get('/daily' , getDaily)
expensesRoute.get('/all' , getAll)
expensesRoute.get('/total' , getTotal)

export default expensesRoute