import express from 'express'
import { addFragment, getNotCompleted, getTotal, handleDelete, search, updateState } from '../controllers/fragmentController.js'
import { getDailyFragment } from '../controllers/productController.js'

const fragmentRoute = express.Router()

fragmentRoute.post('/add' , addFragment)
fragmentRoute.get('/search' , search)
fragmentRoute.put('/update' , updateState)
fragmentRoute.get('/daily' , getDailyFragment)
fragmentRoute.get('/notCompleted' , getNotCompleted)
fragmentRoute.get('/total' , getTotal)
fragmentRoute.delete('/delete' , handleDelete)

export default fragmentRoute