import express from 'express'
import upload from '../middlewares/multer.js'
import { addFromFragment, addNewProduct, deleteProduct, existProduct, getTotalOfWarehouse, isSold, searchByBarcode, todayRegistredProduct, updateProduct } from '../controllers/productController.js'
import { handleSearch } from '../controllers/expensesController.js'


const productRoute = express.Router()

productRoute.post('/new-product' , upload.single('image') , addNewProduct)
productRoute.get('/exist-product' , existProduct)
productRoute.get('/search-barcode/:code' , searchByBarcode)
productRoute.post('/:id/sold' , isSold)
productRoute.put('/:id' , updateProduct)
productRoute.delete('/delete-product/:id' ,deleteProduct )
productRoute.get('/today' ,todayRegistredProduct )
productRoute.get('/total' ,getTotalOfWarehouse )
productRoute.post('/add-fragment' ,upload.single('image'), addFromFragment)

export default productRoute