import express from 'express'
import {addOldTransaction, addSupplierProduct, getBySupplier, getDailyTotal, getSupplierProduct, getTotal, remain, searchToSave, updateLoan, updateWeight} from '../controllers/supplierProductController.js'

const supplierProductRoute = express.Router()

supplierProductRoute.post('/add' , addSupplierProduct)
supplierProductRoute.get('/get' , getSupplierProduct)
supplierProductRoute.get('/search' , searchToSave)
supplierProductRoute.put('/update' , updateWeight)
supplierProductRoute.put('/update-loan' , updateLoan)
supplierProductRoute.get('/total' , getTotal)
supplierProductRoute.get('/daily-total' , getDailyTotal)
supplierProductRoute.get('/remain' , remain)
supplierProductRoute.get('/get-by-supplier' , getBySupplier)
supplierProductRoute.post('/add-old' , addOldTransaction)
export default supplierProductRoute