import express from 'express'
import { createSupplier, deactivateSupplier, deleteSupplier, getAllSuppliers, getSupplier, updateSupplier } from '../controllers/supplierController.js'

const supplierRoute = express.Router()

supplierRoute.post('/create' , createSupplier)
supplierRoute.get('/get' , getSupplier)
supplierRoute.put('/update' , deactivateSupplier)
supplierRoute.get('/get-all' , getAllSuppliers)
supplierRoute.put('/update/:id' , updateSupplier)
supplierRoute.delete('/delete/:id' , deleteSupplier)

export default supplierRoute