import express from 'express'
import { addTrade, getAllTotal, getDaily, getPersonTrade, getTotal, search } from '../controllers/tradeController.js'


const tradeRoute = express.Router()

tradeRoute.get('/search' , search)
tradeRoute.post('/add' , addTrade)
tradeRoute.get('/person' , getPersonTrade)
tradeRoute.get('/total' , getTotal)
tradeRoute.get('/daily' , getDaily)
tradeRoute.get('/all' , getAllTotal)

export default tradeRoute
