import express from 'express'
import { createTransaction, dailyReport, dailySumReport, deleteProductFromTransaction, getAllSaleReport, getLoanToPay, getLoanTransaction, getSoldProduct, payLoan } from '../controllers/transactionController.js'

const transactionRoute = express.Router()

transactionRoute.post('/create-transaction' , createTransaction)
transactionRoute.get('/loan-transaction' , getLoanTransaction)
transactionRoute.get('/sale-report' , getAllSaleReport)
transactionRoute.get('/sold' , getSoldProduct)
transactionRoute.get('/daily-report' , dailyReport)
transactionRoute.get('/daily-sum' , dailySumReport)
transactionRoute.post('/return' , deleteProductFromTransaction)
transactionRoute.get('/to-pay' , getLoanToPay)
transactionRoute.post('/pay-loan' , payLoan)

export default transactionRoute