// This file is part of the bwip-js project available at:
//
//    http://metafloor.github.io/bwip-js
//
// Copyright (c) 2011-2025 Mark Warren
//
// This file contains code automatically generated from:
// Barcode Writer in Pure PostScript - Version 2025-10-24
// Copyright (c) 2004-2024 Terry Burton
//
// The MIT License
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
//
"use strict";

(function (root, factory) {
    if (typeof define === 'function' && define.amd) {
        define([], factory);
    } else if (typeof module === 'object' && module.exports) {
        module.exports = factory();
    } else {
        root.bwipjs = factory();
    }
}(typeof self !== 'undefined' ? self : this, function () {
var $$=null;var $j=0;var $k=[];var $_={};const $abs=Math.abs;const $ceil=Math.ceil;const $floor=Math.floor;const $log=Math.log;const $pow=Math.pow;const $round=Math.round;const $sqrt=Math.sqrt;const $metrics={};function $a(a){if(!arguments.length){for(var i=$j-1;i>=0&&$k[i]!==Infinity;i--);if(i<0){throw new Error("array-marker-not-found")}a=$k.splice(i+1,$j-1-i);$j=i}else if(!(a instanceof Array)){a=new Array(+arguments[0]);for(var i=0,l=a.length;i<l;i++){a[i]=null}}a.b=a;a.o=0;return a}function $d(){for(var mark=$j-1;mark>=0&&$k[mark]!==Infinity;mark-=2){if($k[mark-1]===Infinity){throw new Error("dict-malformed-stack")}}if(mark<0){throw new Error("dict-marker-not-found")}var d=new Map;for(var i=mark+1;i<$j;i+=2){var k=$k[i];var t=typeof k;if(t=="number"||t=="string"){d.set(k,$k[i+1])}else if(k instanceof Uint8Array){d.set($z(k),$k[i+1])}else{throw new Error("dict-not-a-valid-key("+k+")")}}$j=mark;return d}function $s(v){var t=typeof v;if(t==="number"){return new Uint8Array(v)}if(t!=="string"){v=""+v}var s=new Uint8Array(v.length);for(var i=0,l=v.length;i<l;i++){s[i]=v.charCodeAt(i)}return s}function $r(n,c){if($j<n){throw new Error("roll: --stack-underflow--")}if(!c){return}if(c<0){var t=$k.splice($j-n,-c)}else{var t=$k.splice($j-n,n-c)}$k.splice.apply($k,[$j-t.length,0].concat(t))}function $z(s){if(s instanceof Uint8Array){return String.fromCharCode.apply(null,s)}return""+s}function $Z(dst,src){if(typeof dst==="string"){dst=$s(dst)}if(src instanceof Uint8Array){for(var i=0,l=src.length;i<l;i++){dst[i]=src[i]}}else{for(var i=0,l=src.length;i<l;i++){dst[i]=src.charCodeAt(i)}}return src.length<dst.length?dst.subarray(0,src.length):dst}function $A(dst,src){for(var i=0,l=src.length;i<l;i++){dst[i]=src[i]}dst.length=src.length;return dst}function $c(s,v){var t=typeof v;if(t=="number"||t=="boolean"||v===null){v=""+v}else if(t!=="string"){v="--nostringval--"}for(var i=0,l=v.length;i<l;i++){s[i]=v.charCodeAt(i)}$k[$j++]=i<s.length?s.subarray(0,i):s}function $i(s){if(s instanceof Uint8Array){return $floor(String.fromCharCode.apply(null,s).replace(/\0+$/,""))}return $floor(""+s)}function $R(s,n,r){return $Z(s,(~~n).toString(r).toUpperCase())}function $g(s,k){if(s instanceof Uint8Array){return s[k]}if(typeof s==="string"){return s.charCodeAt(k)}if(s instanceof Array){return s.b[s.o+k]}if(k instanceof Uint8Array){k=$z(k)}if(s instanceof Map){return s.get(k)}return s[k]}function $p(d,k,v){if(d instanceof Uint8Array){d[k]=v}else if(d instanceof Array){d.b[d.o+k]=v}else if(typeof d=="object"){if(k instanceof Uint8Array){d.set($z(k),v)}else{d.set(k,v)}}else{throw new Error("put-not-writable-"+typeof d)}}function $G(s,o,l){if(s instanceof Uint8Array){return s.subarray(o,o+l)}if(s instanceof Array){var a=new Array(l);a.b=s.b;a.o=s.o+o;return a}return s.substr(o,l)}function $P(d,o,s){if(d instanceof Uint8Array){if(typeof s=="string"){for(var i=0,l=s.length;i<l;i++){d[o+i]=s.charCodeAt(i)}}else{for(var i=s.length-1;i>=0;i--){d[o+i]=s[i]}}}else if(d instanceof Array){var darr=d.b;var doff=o+d.o;var sarr=s.b;var soff=s.o;for(var i=0,l=s.length;i<l;i++){darr[doff+i]=sarr[soff+i]}}else{throw new Error("putinterval-not-writable-"+typeof d)}}function $t(v){if(v==null){return"nulltype"}var t=typeof v;if(t=="number"){return v%1?"realtype":"integertype"}if(t=="boolean"){return"booleantype"}if(t=="string"||v instanceof Uint8Array){return"stringtype"}if(t=="function"){return"operatortype"}if(v instanceof Array){return"arraytype"}return"dicttype"}function $ax(str,seek){if(!(str instanceof Uint8Array)){str=$s(str)}var i=0,ls=str.length,lk=seek.length;if(lk==1){var cd=seek instanceof Uint8Array?seek[0]:seek.charCodeAt(0);i=str[0]==cd?1:ls}else if(seek.length<=ls){if(!(seek instanceof Uint8Array)){seek=$s(seek)}for(;i<lk&&str[i]==seek[i];i++);}if(i==lk){$k[$j++]=str.subarray(lk);$k[$j++]=str.subarray(0,lk);$k[$j++]=true}else{$k[$j++]=str;$k[$j++]=false}}function $X(str,seek){if(!(str instanceof Uint8Array)){str=$s(str)}var ls=str.length;if(seek.length==1){var lk=1;var cd=seek instanceof Uint8Array?seek[0]:seek.charCodeAt(0);for(var i=0;i<ls&&str[i]!=cd;i++);}else{if(!(seek instanceof Uint8Array)){seek=$s(seek)}var lk=seek.length;var cd=seek[0];for(var i=0;i<ls&&str[i]!=cd;i++);while(i<ls){for(var j=1;j<lk&&str[i+j]===seek[j];j++);if(j===lk){break}for(i++;i<ls&&str[i]!=cd;i++);}}if(i<ls){$k[$j++]=str.subarray(i+lk);$k[$j++]=str.subarray(i,i+lk);$k[$j++]=str.subarray(0,i);$k[$j++]=true}else{$k[$j++]=str;$k[$j++]=false}}function $F(o,cb){if(o instanceof Uint8Array){for(var i=0,l=o.length;i<l;i++){$k[$j++]=o[i];if(cb&&cb())break}}else if(o instanceof Array){for(var a=o.b,i=o.o,l=o.o+o.length;i<l;i++){$k[$j++]=a[i];if(cb&&cb())break}}else if(typeof o==="string"){for(var i=0,l=o.length;i<l;i++){$k[$j++]=o.charCodeAt(i);if(cb&&cb())break}}else if(o instanceof Map){for(var keys=o.keys(),i=0,l=o.size;i<l;i++){var id=keys.next().value;$k[$j++]=id;$k[$j++]=o.get(id);if(cb&&cb())break}}else{for(var id in o){$k[$j++]=id;$k[$j++]=o[id];if(cb&&cb())break}}}function $l(){while($j>0&&$k[--$j]!==Infinity);}function $m(){for(var i=$j-1;i>=0&&$k[i]!==Infinity;i--);return $j-i-1}function $q(a){for(var i=0,l=a.length,b=a.b,o=a.o;i<l;i++){$k[$j++]=b[o+i]}}function $as(a){for(var i=0,l=a.length,b=a.b,o=a.o+l-1;i<l;i++){b[o-i]=$k[--$j]}$k[$j++]=a}function $eq(a,b){if(typeof a==="string"&&typeof b==="string"){return a==b}if(a instanceof Uint8Array&&b instanceof Uint8Array){if(a.length!=b.length){return false}for(var i=0,l=a.length;i<l;i++){if(a[i]!=b[i]){return false}}return true}if(a instanceof Uint8Array&&typeof b==="string"||b instanceof Uint8Array&&typeof a==="string"){if(a instanceof Uint8Array){a=$z(a)}else{b=$z(b)}return a==b}return a==b}function $ne(a,b){return!$eq(a,b)}function $lt(a,b){if(a instanceof Uint8Array){a=$z(a)}if(b instanceof Uint8Array){b=$z(b)}return a<b}function $le(a,b){if(a instanceof Uint8Array){a=$z(a)}if(b instanceof Uint8Array){b=$z(b)}return a<=b}function $gt(a,b){if(a instanceof Uint8Array){a=$z(a)}if(b instanceof Uint8Array){b=$z(b)}return a>b}function $ge(a,b){if(a instanceof Uint8Array){a=$z(a)}if(b instanceof Uint8Array){b=$z(b)}return a>=b}function $an(a,b){return typeof a==="boolean"?a&&b:a&b}function $or(a,b){return typeof a==="boolean"?a||b:a|b}function $xo(a,b){return typeof a==="boolean"?a!=b:a^b}function $nt(a){return typeof a=="boolean"?!a:~a}var $f=function(fa){return v=>{return(v|0)==v?v:(fa[0]=v,fa[0])}}(new Float32Array(1));function bwipp_raiseerror(){var info=$k[--$j];var name=$k[--$j];if(typeof info=="string"||info instanceof Uint8Array){throw new Error($z(name)+": "+$z(info))}else{$k[$j++]=info;throw $z(name)+"\nAdditional information: "+tostring(info)}function tostring(v){if(v instanceof Array){let s="";for(let i=v.o,l=v.o+v.length;i<l;i++){s+=" "+tostring(v.b[i])}return"["+s.substr(1)+"]"}else if(v instanceof Uint8Array){return String.fromCharCode.apply(String,v)}else if(v instanceof Map){let s="";for(const[key,val]of v){s+=" "+tostring(key)+" "+tostring(val)}return"<<"+s.substr(1)+">>"}else if(v&&typeof v=="object"){let s="";for(let id in v){s+=" "+tostring(id)+" "+tostring(v[id])}return"<<"+s.substr(1)+">>"}else{return""+v}}}function bwipp_processoptions(){var dict=$k[--$j];var opts=$k[$j-1];if(opts instanceof Uint8Array){opts=$z(opts)}if(typeof opts=="string"){let vals=opts.trim().split(/ +/g);$k[$j-1]=opts=new Map;for(let i=0;i<vals.length;i++){let pair=vals[i].split("=");if(pair.length==1){opts.set(pair[0],true)}else{opts.set(pair[0],pair[1])}}}for(var id in dict){var val;if(!opts.has(id)){continue}val=opts.get(id);var def=dict[id];var typ=typeof def;if(def==null||typ=="number"){if(!isFinite(+val)){throw new Error("bwipp.invalidOptionType: "+id+": not a realtype: "+val)}if(typeof val=="string"){val=+val;opts.set(id,val)}}else if(typ=="boolean"){if(val!==true&&val!==false){if(val==null||(val|0)===val){val=!!val}else if(val=="true"){val=true}else if(val=="false"){val=false}else{throw new Error("bwipp.invalidOptionType: "+id+": not a booleantype: "+val)}opts.set(id,val)}}else if(typ=="string"||def instanceof Uint8Array){if(typeof val=="number"){val=""+val;opts.set(id,val)}else if((id==="extratext"||id==="alttext")&&typeof val==="string"){val=$s(val);opts.set(id,val)}else if(typeof val!="string"&&!(val instanceof Uint8Array)){throw new Error("bwipp.invalidOptionType: "+id+": not a stringtype: "+val)}}dict[id]=val}}function bwipp_parseinput(){var $__=$_;$_=Object.assign({},$_);$_.fncvals=$k[--$j];$_.barcode=$k[--$j];var _2="parse";$_[_2]=$g($_.fncvals,_2);delete $_.fncvals[_2];var _6="parsefnc";$_[_6]=$g($_.fncvals,_6);delete $_.fncvals[_6];var _A="parseonly";var _C=$g($_.fncvals,_A)!==undefined;$_[_A]=_C;delete $_.fncvals[_A];var _E="eci";var _G=$g($_.fncvals,_E)!==undefined;$_[_E]=_G;delete $_.fncvals[_E];$k[$j++]=Infinity;var _I=$a(["NUL","SOH","STX","ETX","EOT","ENQ","ACK","BEL","BS","TAB","LF","VT","FF","CR","","","DLE","DC1","DC2","DC3","DC4","NAK","SYN","ETB","CAN","EM","SUB","ESC","FS","GS","RS","US"]);$k[$j++]=0;for(var _J=0,_K=_I.length;_J<_K;_J++){var _M=$k[--$j];$k[$j++]=$g(_I,_J);$k[$j++]=_M;$k[$j++]=_M+1}$j--;$_.ctrl=$d();$_.msg=$a($_.barcode.length);$_.j=0;$k[$j++]=$_.barcode;for(;;){$X($k[--$j],"^");var _T=$k[--$j];var _U=$k[--$j];$k[$j++]=_T;$k[$j++]=_U.length;$k[$j++]=$_.msg;$k[$j++]=$_.j;var _X=Infinity;var _Y=_U;$k[$j++]=_X;$F(_Y);var _Z=$a();var _a=$k[--$j];$P($k[--$j],_a,_Z);$_.j=$f($k[--$j]+$_.j);if($k[--$j]){$j--;for(var _f=0;_f<1;_f++){if(!$_.parse&&!$_.parsefnc){$p($_.msg,$_.j,94);$_.j=$_.j+1;break}$p($_.msg,$_.j,94);$_.j=$_.j+1;if($_.parse){var _p=$k[$j-1];if(_p.length>=3){var _q=$k[$j-1];var _r=$G(_q,0,3);var _s=$_.ctrl;var _t=$g(_s,_r)!==undefined;$k[$j++]=_s;$k[$j++]=_r;if(_t){$_.j=$_.j-1;var _v=$k[--$j];$p($_.msg,$_.j,$g($k[--$j],_v));$_.j=$_.j+1;var _11=$k[--$j];$k[$j++]=$G(_11,3,_11.length-3);break}else{$j-=2}}var _13=$k[$j-1];if(_13.length>=2){var _14=$k[$j-1];var _15=$G(_14,0,2);var _16=$_.ctrl;var _17=$g(_16,_15)!==undefined;$k[$j++]=_16;$k[$j++]=_15;if(_17){$_.j=$_.j-1;var _19=$k[--$j];$p($_.msg,$_.j,$g($k[--$j],_19));$_.j=$_.j+1;var _1F=$k[--$j];$k[$j++]=$G(_1F,2,_1F.length-2);break}else{$j-=2}}var _1H=$k[$j-1];if(_1H.length>=3){var _1I=$k[$j-1];var _1J=$G(_1I,0,3);$k[$j++]=true;for(var _1K=0,_1L=_1J.length;_1K<_1L;_1K++){var _1M=$g(_1J,_1K);if(_1M<48||_1M>57){$k[$j-1]=false}}if($k[--$j]){var _1O=$k[$j-1];var _1Q=$i($G(_1O,0,3));$k[$j++]=_1Q;if(_1Q>255){$j-=2;$k[$j++]="bwipp.invalidOrdinal#282";$k[$j++]="Ordinal must be 000 to 255";bwipp_raiseerror()}$_.j=$_.j-1;$p($_.msg,$_.j,$k[--$j]);$_.j=$_.j+1;var _1W=$k[--$j];$k[$j++]=$G(_1W,3,_1W.length-3)}}}if($_.parseonly||!$_.parsefnc||$g($_.msg,$_.j-1)!=94){break}$_.j=$_.j-1;var _1e=$k[$j-1];if(_1e.length<1){$j--;$k[$j++]="bwipp.truncatedCaret#301";$k[$j++]="Caret character truncated";bwipp_raiseerror()}var _1f=$k[$j-1];if($g(_1f,0)==94){$p($_.msg,$_.j,94);$_.j=$_.j+1;var _1k=$k[--$j];$k[$j++]=$G(_1k,1,_1k.length-1);break}var _1m=$k[$j-1];if(_1m.length<3){$j--;$k[$j++]="bwipp.truncatedFNC#311";$k[$j++]="Function character truncated";bwipp_raiseerror()}var _1n=$k[$j-1];if($eq($G(_1n,0,3),"ECI")&&$_.eci){var _1q=$k[$j-1];if(_1q.length<9){$j--;$k[$j++]="bwipp.truncatedECI#316";$k[$j++]="ECI truncated";bwipp_raiseerror()}var _1r=$k[$j-1];var _1s=$G(_1r,3,6);$k[$j++]=_1s;for(var _1t=0,_1u=_1s.length;_1t<_1u;_1t++){var _1v=$g(_1s,_1t);if(_1v<48||_1v>57){$j-=2;$k[$j++]="bwipp.invalidECI#322";$k[$j++]="ECI must be 000000 to 999999";bwipp_raiseerror()}}var _1w=$k[--$j];$k[$j++]=0;$F(_1w,function(){var _1x=$k[--$j];var _1y=$k[--$j];$k[$j++]=$f(_1y-(_1x-48))*10});$p($_.msg,$_.j,~~($k[--$j]/10)-1e6);$_.j=$_.j+1;var _23=$k[--$j];$k[$j++]=$G(_23,9,_23.length-9);break}var _25=$k[$j-1];if(_25.length<4){$j--;$k[$j++]="bwipp.truncatedFNC#333";$k[$j++]="Function character truncated";bwipp_raiseerror()}var _26=$k[$j-1];var _27=$G(_26,0,4);var _29=$g($_.fncvals,_27)!==undefined;$k[$j++]=_27;if(!_29){var _2A=$k[--$j];var _2B=$s(_2A.length+28);$P(_2B,28,_2A);$P(_2B,0,"Unknown function character: ");$k[$j-1]=_2B;var _2D=$k[--$j];$k[$j++]="bwipp.unknownFNC#339";$k[$j++]=_2D;bwipp_raiseerror()}$p($_.msg,$_.j,$g($_.fncvals,$k[--$j]));$_.j=$_.j+1;var _2K=$k[--$j];$k[$j++]=$G(_2K,4,_2K.length-4);break}}else{break}}if(!$_.parseonly){$k[$j++]=$G($_.msg,0,$_.j)}else{$k[$j++]=$s($_.j);for(var _2U=0,_2T=$_.j-1;_2U<=_2T;_2U+=1){var _2V=$k[$j-1];$p(_2V,_2U,$g($_.msg,_2U))}}$_=$__}function bwipp_gs1process(){var $__=$_;$_=Object.assign({},$_);var _1=new Map([["cset","N"],["min",18],["max",18],["opt",false],["linters",$a(["lintcsum","lintgcppos2"])]]);var _2=$a([_1]);var _3=$a([]);var _4=new Map([["parts",_2],["dlpkey",_3]]);var _5=$a(["lintcsum","lintgcppos2"]);var _6=new Map([["cset","N"],["min",14],["max",14],["opt",false],["linters",_5]]);var _7=$a([_6]);var _8=$a(["255","37"]);var _9=$a(["22","10","21"]);var _A=$a(["235"]);var _B=$a([_9,_A]);var _C=new Map([["parts",_7],["ex",_8],["dlpkey",_B]]);var _D=$a(["lintcsum","lintgcppos2"]);var _E=new Map([["cset","N"],["min",14],["max",14],["opt",false],["linters",_D]]);var _F=$a([_E]);var _G=$a(["01","03"]);var _H=$a(["37"]);var _I=$a([_H]);var _J=$a([_I]);var _K=new Map([["parts",_F],["ex",_G],["req",_J]]);var _L=$a(["lintcsum","lintgcppos2"]);var _M=new Map([["cset","N"],["min",14],["max",14],["opt",false],["linters",_L]]);var _N=$a([_M]);var _O=$a(["01","02","37"]);var _P=new Map([["parts",_N],["ex",_O],["dlattr",false]]);var _R=new Map([["cset","X"],["min",1],["max",20],["opt",false],["linters",$a([])]]);var _a=new Map([["parts",$a([_R])],["req",$a([$a([$a(["01"]),$a(["02"]),$a(["03"]),$a(["8006"]),$a(["8026"])])])]]);var _c=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a(["lintyymmd0"])]]);var _l=new Map([["parts",$a([_c])],["req",$a([$a([$a(["01"]),$a(["02"]),$a(["03"]),$a(["8006"]),$a(["8026"])])])]]);var _n=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a(["lintyymmd0"])]]);var _r=$a([$a([$a(["8020"])])]);var _s=new Map([["parts",$a([_n])],["req",_r]]);var _u=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a(["lintyymmd0"])]]);var _13=new Map([["parts",$a([_u])],["req",$a([$a([$a(["01"]),$a(["02"]),$a(["03"]),$a(["8006"]),$a(["8026"])])])]]);var _15=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a(["lintyymmd0"])]]);var _1F=new Map([["parts",$a([_15])],["req",$a([$a([$a(["01"]),$a(["02"]),$a(["03"]),$a(["255"]),$a(["8006"]),$a(["8026"])])])]]);var _1H=new Map([["cset","N"],["min",2],["max",2],["opt",false],["linters",$a([])]]);var _1P=new Map([["parts",$a([_1H])],["req",$a([$a([$a(["01"]),$a(["02"]),$a(["8006"]),$a(["8026"])])])]]);var _1R=new Map([["cset","X"],["min",1],["max",20],["opt",false],["linters",$a([])]]);var _1Z=new Map([["parts",$a([_1R])],["ex",$a(["235"])],["req",$a([$a([$a(["01"]),$a(["03"]),$a(["8006"])])])],["dlattr",false]]);var _1b=new Map([["cset","X"],["min",1],["max",20],["opt",false],["linters",$a([])]]);var _1g=new Map([["parts",$a([_1b])],["req",$a([$a([$a(["01"])])])],["dlattr",false]]);var _1i=new Map([["cset","X"],["min",1],["max",28],["opt",false],["linters",$a([])]]);var _1n=new Map([["parts",$a([_1i])],["req",$a([$a([$a(["01"])])])],["dlattr",false]]);var _1p=new Map([["cset","X"],["min",1],["max",30],["opt",false],["linters",$a([])]]);var _1x=new Map([["parts",$a([_1p])],["req",$a([$a([$a(["01"]),$a(["02"]),$a(["8006"]),$a(["8026"])])])]]);var _1z=new Map([["cset","N"],["min",1],["max",6],["opt",false],["linters",$a([])]]);var _27=new Map([["parts",$a([_1z])],["req",$a([$a([$a(["01"]),$a(["02"]),$a(["8006"]),$a(["8026"])])])]]);var _29=new Map([["cset","X"],["min",1],["max",20],["opt",false],["linters",$a([])]]);var _2E=new Map([["parts",$a([_29])],["req",$a([$a([$a(["01"])])])]]);var _2G=new Map([["cset","X"],["min",1],["max",30],["opt",false],["linters",$a([])]]);var _2O=new Map([["parts",$a([_2G])],["req",$a([$a([$a(["01"]),$a(["8006"])]),$a([$a(["21"])])])]]);var _2Q=new Map([["cset","X"],["min",1],["max",30],["opt",false],["linters",$a([])]]);var _2W=new Map([["parts",$a([_2Q])],["req",$a([$a([$a(["01"]),$a(["8006"])])])]]);var _2Y=new Map([["cset","N"],["min",13],["max",13],["opt",false],["linters",$a(["lintcsum","lintgcppos1"])]]);var _2a=new Map([["cset","X"],["min",1],["max",17],["opt",true],["linters",$a([])]]);var _2d=new Map([["parts",$a([_2Y,_2a])],["dlpkey",$a([])]]);var _2f=new Map([["cset","X"],["min",1],["max",20],["opt",false],["linters",$a([])]]);var _2k=new Map([["parts",$a([_2f])],["req",$a([$a([$a(["414"])])])],["dlattr",false]]);var _2m=new Map([["cset","N"],["min",13],["max",13],["opt",false],["linters",$a(["lintcsum","lintgcppos1"])]]);var _2o=new Map([["cset","N"],["min",1],["max",12],["opt",true],["linters",$a([])]]);var _2s=new Map([["parts",$a([_2m,_2o])],["ex",$a(["01","02","415","8006","8020","8026"])],["dlpkey",$a([])]]);var _2u=new Map([["cset","N"],["min",1],["max",8],["opt",false],["linters",$a([])]]);var _30=new Map([["parts",$a([_2u])],["req",$a([$a([$a(["01"]),$a(["02"])])])]]);var _32=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _39=new Map([["parts",$a([_32])],["ex",$a(["310n"])],["req",$a([$a([$a(["01"]),$a(["02"])])])]]);var _3B=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _3I=new Map([["parts",$a([_3B])],["ex",$a(["311n"])],["req",$a([$a([$a(["01"]),$a(["02"])])])]]);var _3K=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _3R=new Map([["parts",$a([_3K])],["ex",$a(["312n"])],["req",$a([$a([$a(["01"]),$a(["02"])])])]]);var _3T=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _3a=new Map([["parts",$a([_3T])],["ex",$a(["313n"])],["req",$a([$a([$a(["01"]),$a(["02"])])])]]);var _3c=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _3j=new Map([["parts",$a([_3c])],["ex",$a(["314n"])],["req",$a([$a([$a(["01"]),$a(["02"])])])]]);var _3l=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _3s=new Map([["parts",$a([_3l])],["ex",$a(["315n"])],["req",$a([$a([$a(["01"]),$a(["02"])])])]]);var _3u=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _41=new Map([["parts",$a([_3u])],["ex",$a(["316n"])],["req",$a([$a([$a(["01"]),$a(["02"])])])]]);var _43=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _4A=new Map([["parts",$a([_43])],["ex",$a(["320n"])],["req",$a([$a([$a(["01"]),$a(["02"])])])]]);var _4C=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _4J=new Map([["parts",$a([_4C])],["ex",$a(["321n"])],["req",$a([$a([$a(["01"]),$a(["02"])])])]]);var _4L=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _4S=new Map([["parts",$a([_4L])],["ex",$a(["322n"])],["req",$a([$a([$a(["01"]),$a(["02"])])])]]);var _4U=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _4b=new Map([["parts",$a([_4U])],["ex",$a(["323n"])],["req",$a([$a([$a(["01"]),$a(["02"])])])]]);var _4d=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _4k=new Map([["parts",$a([_4d])],["ex",$a(["324n"])],["req",$a([$a([$a(["01"]),$a(["02"])])])]]);var _4m=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _4t=new Map([["parts",$a([_4m])],["ex",$a(["325n"])],["req",$a([$a([$a(["01"]),$a(["02"])])])]]);var _4v=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _52=new Map([["parts",$a([_4v])],["ex",$a(["326n"])],["req",$a([$a([$a(["01"]),$a(["02"])])])]]);var _54=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _5B=new Map([["parts",$a([_54])],["ex",$a(["327n"])],["req",$a([$a([$a(["01"]),$a(["02"])])])]]);var _5D=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _5K=new Map([["parts",$a([_5D])],["ex",$a(["328n"])],["req",$a([$a([$a(["01"]),$a(["02"])])])]]);var _5M=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _5T=new Map([["parts",$a([_5M])],["ex",$a(["329n"])],["req",$a([$a([$a(["01"]),$a(["02"])])])]]);var _5V=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _5c=new Map([["parts",$a([_5V])],["ex",$a(["330n"])],["req",$a([$a([$a(["00"]),$a(["01"])])])]]);var _5e=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _5l=new Map([["parts",$a([_5e])],["ex",$a(["331n"])],["req",$a([$a([$a(["00"]),$a(["01"])])])]]);var _5n=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _5u=new Map([["parts",$a([_5n])],["ex",$a(["332n"])],["req",$a([$a([$a(["00"]),$a(["01"])])])]]);var _5w=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _63=new Map([["parts",$a([_5w])],["ex",$a(["333n"])],["req",$a([$a([$a(["00"]),$a(["01"])])])]]);var _65=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _6C=new Map([["parts",$a([_65])],["ex",$a(["334n"])],["req",$a([$a([$a(["00"]),$a(["01"])])])]]);var _6E=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _6L=new Map([["parts",$a([_6E])],["ex",$a(["335n"])],["req",$a([$a([$a(["00"]),$a(["01"])])])]]);var _6N=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _6U=new Map([["parts",$a([_6N])],["ex",$a(["336n"])],["req",$a([$a([$a(["00"]),$a(["01"])])])]]);var _6W=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _6c=new Map([["parts",$a([_6W])],["ex",$a(["337n"])],["req",$a([$a([$a(["01"])])])]]);var _6e=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _6l=new Map([["parts",$a([_6e])],["ex",$a(["340n"])],["req",$a([$a([$a(["00"]),$a(["01"])])])]]);var _6n=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _6u=new Map([["parts",$a([_6n])],["ex",$a(["341n"])],["req",$a([$a([$a(["00"]),$a(["01"])])])]]);var _6w=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _73=new Map([["parts",$a([_6w])],["ex",$a(["342n"])],["req",$a([$a([$a(["00"]),$a(["01"])])])]]);var _75=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _7C=new Map([["parts",$a([_75])],["ex",$a(["343n"])],["req",$a([$a([$a(["00"]),$a(["01"])])])]]);var _7E=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _7L=new Map([["parts",$a([_7E])],["ex",$a(["344n"])],["req",$a([$a([$a(["00"]),$a(["01"])])])]]);var _7N=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _7U=new Map([["parts",$a([_7N])],["ex",$a(["345n"])],["req",$a([$a([$a(["00"]),$a(["01"])])])]]);var _7W=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _7d=new Map([["parts",$a([_7W])],["ex",$a(["346n"])],["req",$a([$a([$a(["00"]),$a(["01"])])])]]);var _7f=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _7m=new Map([["parts",$a([_7f])],["ex",$a(["347n"])],["req",$a([$a([$a(["00"]),$a(["01"])])])]]);var _7o=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _7v=new Map([["parts",$a([_7o])],["ex",$a(["348n"])],["req",$a([$a([$a(["00"]),$a(["01"])])])]]);var _7x=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _84=new Map([["parts",$a([_7x])],["ex",$a(["349n"])],["req",$a([$a([$a(["00"]),$a(["01"])])])]]);var _86=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _8D=new Map([["parts",$a([_86])],["ex",$a(["350n"])],["req",$a([$a([$a(["01"]),$a(["02"])])])]]);var _8F=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _8M=new Map([["parts",$a([_8F])],["ex",$a(["351n"])],["req",$a([$a([$a(["01"]),$a(["02"])])])]]);var _8O=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _8V=new Map([["parts",$a([_8O])],["ex",$a(["352n"])],["req",$a([$a([$a(["01"]),$a(["02"])])])]]);var _8X=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _8e=new Map([["parts",$a([_8X])],["ex",$a(["353n"])],["req",$a([$a([$a(["00"]),$a(["01"])])])]]);var _8g=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _8n=new Map([["parts",$a([_8g])],["ex",$a(["354n"])],["req",$a([$a([$a(["00"]),$a(["01"])])])]]);var _8p=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _8w=new Map([["parts",$a([_8p])],["ex",$a(["355n"])],["req",$a([$a([$a(["00"]),$a(["01"])])])]]);var _8y=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _95=new Map([["parts",$a([_8y])],["ex",$a(["356n"])],["req",$a([$a([$a(["01"]),$a(["02"])])])]]);var _97=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _9E=new Map([["parts",$a([_97])],["ex",$a(["357n"])],["req",$a([$a([$a(["01"]),$a(["02"])])])]]);var _9G=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _9N=new Map([["parts",$a([_9G])],["ex",$a(["360n"])],["req",$a([$a([$a(["01"]),$a(["02"])])])]]);var _9P=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _9W=new Map([["parts",$a([_9P])],["ex",$a(["361n"])],["req",$a([$a([$a(["01"]),$a(["02"])])])]]);var _9Y=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _9f=new Map([["parts",$a([_9Y])],["ex",$a(["362n"])],["req",$a([$a([$a(["00"]),$a(["01"])])])]]);var _9h=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _9o=new Map([["parts",$a([_9h])],["ex",$a(["363n"])],["req",$a([$a([$a(["00"]),$a(["01"])])])]]);var _9q=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _9x=new Map([["parts",$a([_9q])],["ex",$a(["364n"])],["req",$a([$a([$a(["01"]),$a(["02"])])])]]);var _9z=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _A6=new Map([["parts",$a([_9z])],["ex",$a(["365n"])],["req",$a([$a([$a(["01"]),$a(["02"])])])]]);var _A8=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _AF=new Map([["parts",$a([_A8])],["ex",$a(["366n"])],["req",$a([$a([$a(["01"]),$a(["02"])])])]]);var _AH=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _AO=new Map([["parts",$a([_AH])],["ex",$a(["367n"])],["req",$a([$a([$a(["00"]),$a(["01"])])])]]);var _AQ=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _AX=new Map([["parts",$a([_AQ])],["ex",$a(["368n"])],["req",$a([$a([$a(["00"]),$a(["01"])])])]]);var _AZ=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _Ag=new Map([["parts",$a([_AZ])],["ex",$a(["369n"])],["req",$a([$a([$a(["00"]),$a(["01"])])])]]);var _Ai=new Map([["cset","N"],["min",1],["max",8],["opt",false],["linters",$a([])]]);var _Aq=new Map([["parts",$a([_Ai])],["req",$a([$a([$a(["00"])]),$a([$a(["02"]),$a(["8026"])])])]]);var _As=new Map([["cset","N"],["min",1],["max",15],["opt",false],["linters",$a([])]]);var _Az=new Map([["parts",$a([_As])],["ex",$a(["390n","391n","394n","8111"])],["req",$a([$a([$a(["255"]),$a(["8020"])])])]]);var _B1=new Map([["cset","N"],["min",3],["max",3],["opt",false],["linters",$a(["lintiso4217"])]]);var _B3=new Map([["cset","N"],["min",1],["max",15],["opt",false],["linters",$a([])]]);var _B9=new Map([["parts",$a([_B1,_B3])],["ex",$a(["391n"])],["req",$a([$a([$a(["8020"])])])]]);var _BB=new Map([["cset","N"],["min",1],["max",15],["opt",false],["linters",$a([])]]);var _BN=new Map([["parts",$a([_BB])],["ex",$a(["392n","393n"])],["req",$a([$a([$a(["01"])]),$a([$a(["30"]),$a(["31nn"]),$a(["32nn"]),$a(["35nn"]),$a(["36nn"])])])]]);var _BP=new Map([["cset","N"],["min",3],["max",3],["opt",false],["linters",$a(["lintiso4217"])]]);var _BR=new Map([["cset","N"],["min",1],["max",15],["opt",false],["linters",$a([])]]);var _Bb=new Map([["parts",$a([_BP,_BR])],["ex",$a(["393n"])],["req",$a([$a([$a(["30"]),$a(["31nn"]),$a(["32nn"]),$a(["35nn"]),$a(["36nn"])])])]]);var _Bd=new Map([["cset","N"],["min",4],["max",4],["opt",false],["linters",$a([])]]);var _Bj=new Map([["parts",$a([_Bd])],["ex",$a(["394n","8111"])],["req",$a([$a([$a(["255"])])])]]);var _Bl=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _Bv=new Map([["parts",$a([_Bl])],["ex",$a(["392n","393n","395n","8005"])],["req",$a([$a([$a(["30"]),$a(["31nn"]),$a(["32nn"]),$a(["35nn"]),$a(["36nn"])])])]]);var _Bx=new Map([["cset","X"],["min",1],["max",30],["opt",false],["linters",$a([])]]);var _Bz=new Map([["parts",$a([_Bx])]]);var _C1=new Map([["cset","X"],["min",1],["max",30],["opt",false],["linters",$a(["lintgcppos1"])]]);var _C4=new Map([["parts",$a([_C1])],["dlpkey",$a([])]]);var _C6=new Map([["cset","N"],["min",17],["max",17],["opt",false],["linters",$a(["lintcsum","lintgcppos1"])]]);var _C9=new Map([["parts",$a([_C6])],["dlpkey",$a([])]]);var _CB=new Map([["cset","X"],["min",1],["max",30],["opt",false],["linters",$a([])]]);var _CG=new Map([["parts",$a([_CB])],["req",$a([$a([$a(["00"])])])]]);var _CI=new Map([["cset","N"],["min",13],["max",13],["opt",false],["linters",$a(["lintcsum","lintgcppos1"])]]);var _CK=new Map([["parts",$a([_CI])]]);var _CM=new Map([["cset","N"],["min",13],["max",13],["opt",false],["linters",$a(["lintcsum","lintgcppos1"])]]);var _CR=new Map([["parts",$a([_CM])],["dlpkey",$a([$a(["254"]),$a(["7040"])])]]);var _CT=new Map([["cset","N"],["min",13],["max",13],["opt",false],["linters",$a(["lintcsum","lintgcppos1"])]]);var _Ca=new Map([["parts",$a([_CT])],["req",$a([$a([$a(["8020"])])])],["dlpkey",$a([$a(["8020"])])]]);var _Cc=new Map([["cset","N"],["min",13],["max",13],["opt",false],["linters",$a(["lintcsum","lintgcppos1"])]]);var _Ce=new Map([["parts",$a([_Cc])]]);var _Cg=new Map([["cset","N"],["min",13],["max",13],["opt",false],["linters",$a(["lintcsum","lintgcppos1"])]]);var _Ck=new Map([["parts",$a([_Cg])],["dlpkey",$a([$a(["7040"])])]]);var _Cm=new Map([["cset","X"],["min",1],["max",20],["opt",false],["linters",$a([])]]);var _Cp=new Map([["parts",$a([_Cm])],["ex",$a(["421"])]]);var _Cr=new Map([["cset","N"],["min",3],["max",3],["opt",false],["linters",$a(["lintiso3166"])]]);var _Ct=new Map([["cset","X"],["min",1],["max",9],["opt",false],["linters",$a([])]]);var _Cw=new Map([["parts",$a([_Cr,_Ct])],["ex",$a(["4307"])]]);var _Cy=new Map([["cset","N"],["min",3],["max",3],["opt",false],["linters",$a(["lintiso3166"])]]);var _D7=new Map([["parts",$a([_Cy])],["ex",$a(["426"])],["req",$a([$a([$a(["01"]),$a(["02"]),$a(["8006"]),$a(["8026"])])])]]);var _D9=new Map([["cset","N"],["min",3],["max",3],["opt",false],["linters",$a(["lintiso3166"])]]);var _DB=new Map([["cset","N"],["min",3],["max",3],["opt",true],["linters",$a(["lintiso3166"])]]);var _DD=new Map([["cset","N"],["min",3],["max",3],["opt",true],["linters",$a(["lintiso3166"])]]);var _DF=new Map([["cset","N"],["min",3],["max",3],["opt",true],["linters",$a(["lintiso3166"])]]);var _DH=new Map([["cset","N"],["min",3],["max",3],["opt",true],["linters",$a(["lintiso3166"])]]);var _DO=new Map([["parts",$a([_D9,_DB,_DD,_DF,_DH])],["ex",$a(["426"])],["req",$a([$a([$a(["01"]),$a(["02"])])])]]);var _DQ=new Map([["cset","N"],["min",3],["max",3],["opt",false],["linters",$a(["lintiso3166"])]]);var _DX=new Map([["parts",$a([_DQ])],["ex",$a(["426"])],["req",$a([$a([$a(["01"]),$a(["02"])])])]]);var _DZ=new Map([["cset","N"],["min",3],["max",3],["opt",false],["linters",$a(["lintiso3166"])]]);var _Db=new Map([["cset","N"],["min",3],["max",3],["opt",true],["linters",$a(["lintiso3166"])]]);var _Dd=new Map([["cset","N"],["min",3],["max",3],["opt",true],["linters",$a(["lintiso3166"])]]);var _Df=new Map([["cset","N"],["min",3],["max",3],["opt",true],["linters",$a(["lintiso3166"])]]);var _Dh=new Map([["cset","N"],["min",3],["max",3],["opt",true],["linters",$a(["lintiso3166"])]]);var _Do=new Map([["parts",$a([_DZ,_Db,_Dd,_Df,_Dh])],["ex",$a(["426"])],["req",$a([$a([$a(["01"]),$a(["02"])])])]]);var _Dq=new Map([["cset","N"],["min",3],["max",3],["opt",false],["linters",$a(["lintiso3166"])]]);var _Dw=new Map([["parts",$a([_Dq])],["req",$a([$a([$a(["01"]),$a(["02"])])])]]);var _Dy=new Map([["cset","X"],["min",1],["max",3],["opt",false],["linters",$a([])]]);var _E6=new Map([["parts",$a([_Dy])],["req",$a([$a([$a(["01"]),$a(["02"])]),$a([$a(["422"])])])]]);var _E8=new Map([["cset","X"],["min",1],["max",35],["opt",false],["linters",$a(["lintpcenc"])]]);var _ED=new Map([["parts",$a([_E8])],["req",$a([$a([$a(["00"])])])]]);var _EF=new Map([["cset","X"],["min",1],["max",70],["opt",false],["linters",$a(["lintpcenc"])]]);var _EK=new Map([["parts",$a([_EF])],["req",$a([$a([$a(["00"])])])]]);var _EM=new Map([["cset","X"],["min",1],["max",70],["opt",false],["linters",$a(["lintpcenc"])]]);var _ER=new Map([["parts",$a([_EM])],["req",$a([$a([$a(["4302"])])])]]);var _ET=new Map([["cset","X"],["min",1],["max",70],["opt",false],["linters",$a(["lintpcenc"])]]);var _EY=new Map([["parts",$a([_ET])],["req",$a([$a([$a(["00"])])])]]);var _Ea=new Map([["cset","X"],["min",2],["max",2],["opt",false],["linters",$a(["lintiso3166alpha2"])]]);var _Ef=new Map([["parts",$a([_Ea])],["req",$a([$a([$a(["00"])])])]]);var _Eh=new Map([["cset","X"],["min",1],["max",30],["opt",false],["linters",$a([])]]);var _Em=new Map([["parts",$a([_Eh])],["req",$a([$a([$a(["00"])])])]]);var _Eo=new Map([["cset","N"],["min",10],["max",10],["opt",false],["linters",$a(["lintlatitude"])]]);var _Eq=new Map([["cset","N"],["min",10],["max",10],["opt",false],["linters",$a(["lintlongitude"])]]);var _Ev=new Map([["parts",$a([_Eo,_Eq])],["req",$a([$a([$a(["00"])])])]]);var _Ex=new Map([["cset","X"],["min",1],["max",35],["opt",false],["linters",$a(["lintpcenc"])]]);var _F2=new Map([["parts",$a([_Ex])],["req",$a([$a([$a(["00"])])])]]);var _F4=new Map([["cset","X"],["min",1],["max",70],["opt",false],["linters",$a(["lintpcenc"])]]);var _F9=new Map([["parts",$a([_F4])],["req",$a([$a([$a(["00"])])])]]);var _FB=new Map([["cset","X"],["min",1],["max",70],["opt",false],["linters",$a(["lintpcenc"])]]);var _FG=new Map([["parts",$a([_FB])],["req",$a([$a([$a(["4312"])])])]]);var _FI=new Map([["cset","X"],["min",1],["max",70],["opt",false],["linters",$a(["lintpcenc"])]]);var _FN=new Map([["parts",$a([_FI])],["req",$a([$a([$a(["00"])])])]]);var _FP=new Map([["cset","X"],["min",2],["max",2],["opt",false],["linters",$a(["lintiso3166alpha2"])]]);var _FU=new Map([["parts",$a([_FP])],["req",$a([$a([$a(["00"])])])]]);var _FW=new Map([["cset","X"],["min",1],["max",20],["opt",false],["linters",$a([])]]);var _Fb=new Map([["parts",$a([_FW])],["req",$a([$a([$a(["00"])])])]]);var _Fd=new Map([["cset","X"],["min",1],["max",30],["opt",false],["linters",$a([])]]);var _Fi=new Map([["parts",$a([_Fd])],["req",$a([$a([$a(["00"])])])]]);var _Fk=new Map([["cset","X"],["min",1],["max",35],["opt",false],["linters",$a(["lintpcenc"])]]);var _Fp=new Map([["parts",$a([_Fk])],["req",$a([$a([$a(["00"])])])]]);var _Fr=new Map([["cset","N"],["min",1],["max",1],["opt",false],["linters",$a(["lintyesno"])]]);var _Fw=new Map([["parts",$a([_Fr])],["req",$a([$a([$a(["00"])])])]]);var _Fy=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a(["lintyymmd0"])]]);var _G0=new Map([["cset","N"],["min",4],["max",4],["opt",false],["linters",$a(["linthhmi"])]]);var _G5=new Map([["parts",$a([_Fy,_G0])],["req",$a([$a([$a(["00"])])])]]);var _G7=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a(["lintyymmdd"])]]);var _GC=new Map([["parts",$a([_G7])],["req",$a([$a([$a(["00"])])])]]);var _GE=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _GG=new Map([["cset","X"],["min",1],["max",1],["opt",true],["linters",$a(["linthyphen"])]]);var _GM=new Map([["parts",$a([_GE,_GG])],["ex",$a(["4331"])],["req",$a([$a([$a(["00"])])])]]);var _GO=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _GQ=new Map([["cset","X"],["min",1],["max",1],["opt",true],["linters",$a(["linthyphen"])]]);var _GW=new Map([["parts",$a([_GO,_GQ])],["ex",$a(["4330"])],["req",$a([$a([$a(["00"])])])]]);var _GY=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _Ga=new Map([["cset","X"],["min",1],["max",1],["opt",true],["linters",$a(["linthyphen"])]]);var _Gg=new Map([["parts",$a([_GY,_Ga])],["ex",$a(["4333"])],["req",$a([$a([$a(["00"])])])]]);var _Gi=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _Gk=new Map([["cset","X"],["min",1],["max",1],["opt",true],["linters",$a(["linthyphen"])]]);var _Gq=new Map([["parts",$a([_Gi,_Gk])],["ex",$a(["4332"])],["req",$a([$a([$a(["00"])])])]]);var _Gs=new Map([["cset","N"],["min",13],["max",13],["opt",false],["linters",$a([])]]);var _H0=new Map([["parts",$a([_Gs])],["req",$a([$a([$a(["01"]),$a(["02"]),$a(["8006"]),$a(["8026"])])])]]);var _H2=new Map([["cset","X"],["min",1],["max",30],["opt",false],["linters",$a([])]]);var _H8=new Map([["parts",$a([_H2])],["req",$a([$a([$a(["01"]),$a(["02"])])])]]);var _HA=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a(["lintyymmdd"])]]);var _HC=new Map([["cset","N"],["min",4],["max",4],["opt",false],["linters",$a(["linthhmi"])]]);var _HI=new Map([["parts",$a([_HA,_HC])],["req",$a([$a([$a(["01"]),$a(["02"])])])]]);var _HK=new Map([["cset","N"],["min",1],["max",4],["opt",false],["linters",$a([])]]);var _HR=new Map([["parts",$a([_HK])],["req",$a([$a([$a(["01"])]),$a([$a(["10"])])])]]);var _HT=new Map([["cset","X"],["min",1],["max",12],["opt",false],["linters",$a([])]]);var _HZ=new Map([["parts",$a([_HT])],["req",$a([$a([$a(["01"]),$a(["02"])])])]]);var _Hb=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a(["lintyymmdd"])]]);var _Hh=new Map([["parts",$a([_Hb])],["req",$a([$a([$a(["01"]),$a(["02"])])])]]);var _Hj=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a(["lintyymmdd"])]]);var _Hl=new Map([["cset","N"],["min",6],["max",6],["opt",true],["linters",$a(["lintyymmdd"])]]);var _Hr=new Map([["parts",$a([_Hj,_Hl])],["req",$a([$a([$a(["01"]),$a(["02"])])])]]);var _Ht=new Map([["cset","X"],["min",1],["max",3],["opt",false],["linters",$a([])]]);var _Hz=new Map([["parts",$a([_Ht])],["req",$a([$a([$a(["01"]),$a(["02"])])])]]);var _I1=new Map([["cset","X"],["min",1],["max",10],["opt",false],["linters",$a([])]]);var _I7=new Map([["parts",$a([_I1])],["req",$a([$a([$a(["01"]),$a(["02"])])])]]);var _I9=new Map([["cset","X"],["min",1],["max",2],["opt",false],["linters",$a([])]]);var _IF=new Map([["parts",$a([_I9])],["req",$a([$a([$a(["01"]),$a(["02"])])])]]);var _IH=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a(["lintyymmdd"])]]);var _IJ=new Map([["cset","N"],["min",4],["max",4],["opt",true],["linters",$a(["linthhmi"])]]);var _IP=new Map([["parts",$a([_IH,_IJ])],["req",$a([$a([$a(["01"]),$a(["02"])])])]]);var _IR=new Map([["cset","X"],["min",1],["max",20],["opt",false],["linters",$a([])]]);var _IZ=new Map([["parts",$a([_IR])],["req",$a([$a([$a(["01"]),$a(["8006"])]),$a([$a(["416"])])])]]);var _Ib=new Map([["cset","X"],["min",1],["max",20],["opt",false],["linters",$a([])]]);var _Ih=new Map([["parts",$a([_Ib])],["req",$a([$a([$a(["01"]),$a(["8006"])])])]]);var _Ij=new Map([["cset","X"],["min",1],["max",20],["opt",false],["linters",$a([])]]);var _Io=new Map([["parts",$a([_Ij])],["req",$a([$a([$a(["7021"])])])]]);var _Iq=new Map([["cset","X"],["min",1],["max",30],["opt",false],["linters",$a(["lintgcppos1"])]]);var _Is=new Map([["parts",$a([_Iq])]]);var _Iu=new Map([["cset","N"],["min",3],["max",3],["opt",false],["linters",$a(["lintiso3166999"])]]);var _Iw=new Map([["cset","X"],["min",1],["max",27],["opt",false],["linters",$a([])]]);var _J2=new Map([["parts",$a([_Iu,_Iw])],["req",$a([$a([$a(["01"]),$a(["02"])])])]]);var _J4=new Map([["cset","N"],["min",1],["max",1],["opt",false],["linters",$a([])]]);var _J6=new Map([["cset","X"],["min",1],["max",1],["opt",false],["linters",$a([])]]);var _J8=new Map([["cset","X"],["min",1],["max",1],["opt",false],["linters",$a([])]]);var _JA=new Map([["cset","X"],["min",1],["max",1],["opt",false],["linters",$a(["lintimporteridx"])]]);var _JC=new Map([["parts",$a([_J4,_J6,_J8,_JA])],["dlattr",false]]);var _JE=new Map([["cset","X"],["min",1],["max",4],["opt",false],["linters",$a(["lintpackagetype"])]]);var _JJ=new Map([["parts",$a([_JE])],["req",$a([$a([$a(["00"])])])],["dlattr",false]]);var _JL=new Map([["cset","X"],["min",1],["max",20],["opt",false],["linters",$a([])]]);var _JQ=new Map([["parts",$a([_JL])],["req",$a([$a([$a(["01"])])])]]);var _JS=new Map([["cset","X"],["min",2],["max",2],["opt",false],["linters",$a([])]]);var _JU=new Map([["cset","X"],["min",1],["max",28],["opt",false],["linters",$a([])]]);var _Ja=new Map([["parts",$a([_JS,_JU])],["req",$a([$a([$a(["01"]),$a(["8004"])])])]]);var _Jc=new Map([["cset","X"],["min",1],["max",20],["opt",false],["linters",$a([])]]);var _Ji=new Map([["parts",$a([_Jc])],["req",$a([$a([$a(["01"]),$a(["8006"])])])]]);var _Jk=new Map([["cset","N"],["min",2],["max",2],["opt",false],["linters",$a(["lintmediatype"])]]);var _Jq=new Map([["parts",$a([_Jk])],["req",$a([$a([$a(["8017"]),$a(["8018"])])])]]);var _Js=new Map([["cset","X"],["min",1],["max",25],["opt",false],["linters",$a([])]]);var _Jy=new Map([["parts",$a([_Js])],["req",$a([$a([$a(["8017"]),$a(["8018"])])])]]);var _K0=new Map([["cset","N"],["min",8],["max",8],["opt",false],["linters",$a(["lintyyyymmdd"])]]);var _K6=new Map([["parts",$a([_K0])],["ex",$a(["7251"])],["req",$a([$a([$a(["8018"])])])]]);var _K8=new Map([["cset","N"],["min",8],["max",8],["opt",false],["linters",$a(["lintyyyymmdd"])]]);var _KA=new Map([["cset","N"],["min",4],["max",4],["opt",false],["linters",$a(["linthhmi"])]]);var _KG=new Map([["parts",$a([_K8,_KA])],["ex",$a(["7250"])],["req",$a([$a([$a(["8018"])])])]]);var _KI=new Map([["cset","N"],["min",1],["max",1],["opt",false],["linters",$a(["lintiso5218"])]]);var _KN=new Map([["parts",$a([_KI])],["req",$a([$a([$a(["8018"])])])]]);var _KP=new Map([["cset","X"],["min",1],["max",40],["opt",false],["linters",$a(["lintpcenc"])]]);var _KW=new Map([["parts",$a([_KP])],["ex",$a(["7256","7259"])],["req",$a([$a([$a(["8017"]),$a(["8018"])])])]]);var _KY=new Map([["cset","X"],["min",1],["max",10],["opt",false],["linters",$a([])]]);var _Kf=new Map([["parts",$a([_KY])],["ex",$a(["7256","7259"])],["req",$a([$a([$a(["8017"]),$a(["8018"])])])]]);var _Kh=new Map([["cset","X"],["min",1],["max",90],["opt",false],["linters",$a(["lintpcenc"])]]);var _Kn=new Map([["parts",$a([_Kh])],["req",$a([$a([$a(["8017"]),$a(["8018"])])])]]);var _Kp=new Map([["cset","X"],["min",1],["max",70],["opt",false],["linters",$a(["lintpcenc"])]]);var _Ku=new Map([["parts",$a([_Kp])],["req",$a([$a([$a(["8018"])])])]]);var _Kw=new Map([["cset","X"],["min",3],["max",3],["opt",false],["linters",$a(["lintposinseqslash"])]]);var _L1=new Map([["parts",$a([_Kw])],["req",$a([$a([$a(["8018","7259"])])])]]);var _L3=new Map([["cset","X"],["min",1],["max",40],["opt",false],["linters",$a(["lintpcenc"])]]);var _L9=new Map([["parts",$a([_L3])],["ex",$a(["7256"])],["req",$a([$a([$a(["8018"])])])]]);var _LB=new Map([["cset","N"],["min",4],["max",4],["opt",false],["linters",$a(["lintnonzero"])]]);var _LD=new Map([["cset","N"],["min",5],["max",5],["opt",false],["linters",$a(["lintnonzero"])]]);var _LF=new Map([["cset","N"],["min",3],["max",3],["opt",false],["linters",$a(["lintnonzero"])]]);var _LH=new Map([["cset","N"],["min",1],["max",1],["opt",false],["linters",$a(["lintwinding"])]]);var _LJ=new Map([["cset","N"],["min",1],["max",1],["opt",false],["linters",$a([])]]);var _LO=new Map([["parts",$a([_LB,_LD,_LF,_LH,_LJ])],["req",$a([$a([$a(["01"])])])]]);var _LQ=new Map([["cset","X"],["min",1],["max",20],["opt",false],["linters",$a([])]]);var _LS=new Map([["parts",$a([_LQ])]]);var _LU=new Map([["cset","N"],["min",1],["max",1],["opt",false],["linters",$a(["lintzero"])]]);var _LW=new Map([["cset","N"],["min",13],["max",13],["opt",false],["linters",$a(["lintcsum","lintgcppos1"])]]);var _LY=new Map([["cset","X"],["min",1],["max",16],["opt",true],["linters",$a([])]]);var _Lb=new Map([["parts",$a([_LU,_LW,_LY])],["dlpkey",$a([])]]);var _Ld=new Map([["cset","X"],["min",1],["max",30],["opt",false],["linters",$a(["lintgcppos1"])]]);var _Lh=new Map([["parts",$a([_Ld])],["dlpkey",$a([$a(["7040"])])]]);var _Lj=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a([])]]);var _Lp=new Map([["parts",$a([_Lj])],["req",$a([$a([$a(["01"]),$a(["02"])])])]]);var _Lr=new Map([["cset","N"],["min",14],["max",14],["opt",false],["linters",$a(["lintcsum","lintgcppos2"])]]);var _Lt=new Map([["cset","N"],["min",4],["max",4],["opt",false],["linters",$a(["lintpieceoftotal"])]]);var _Ly=new Map([["parts",$a([_Lr,_Lt])],["ex",$a(["01","37"])],["dlpkey",$a([$a(["22","10","21"])])]]);var _M0=new Map([["cset","X"],["min",1],["max",34],["opt",false],["linters",$a(["lintiban"])]]);var _M5=new Map([["parts",$a([_M0])],["req",$a([$a([$a(["415"])])])]]);var _M7=new Map([["cset","N"],["min",6],["max",6],["opt",false],["linters",$a(["lintyymmdd"])]]);var _M9=new Map([["cset","N"],["min",2],["max",2],["opt",false],["linters",$a(["linthh"])]]);var _MB=new Map([["cset","N"],["min",2],["max",2],["opt",true],["linters",$a(["lintmi"])]]);var _MD=new Map([["cset","N"],["min",2],["max",2],["opt",true],["linters",$a(["lintss"])]]);var _MJ=new Map([["parts",$a([_M7,_M9,_MB,_MD])],["req",$a([$a([$a(["01"]),$a(["02"])])])]]);var _ML=new Map([["cset","X"],["min",1],["max",50],["opt",false],["linters",$a([])]]);var _MR=new Map([["parts",$a([_ML])],["req",$a([$a([$a(["00"]),$a(["01"])])])]]);var _MT=new Map([["cset","Y"],["min",1],["max",30],["opt",false],["linters",$a(["lintgcppos1"])]]);var _MX=new Map([["parts",$a([_MT])],["dlpkey",$a([$a(["8011"])])]]);var _MZ=new Map([["cset","N"],["min",1],["max",12],["opt",false],["linters",$a(["lintnozeroprefix"])]]);var _Me=new Map([["parts",$a([_MZ])],["req",$a([$a([$a(["8010"])])])],["dlattr",false]]);var _Mg=new Map([["cset","X"],["min",1],["max",20],["opt",false],["linters",$a([])]]);var _Mm=new Map([["parts",$a([_Mg])],["req",$a([$a([$a(["01"]),$a(["8006"])])])]]);var _Mo=new Map([["cset","X"],["min",1],["max",25],["opt",false],["linters",$a(["lintcsumalpha","lintgcppos1"])]]);var _Mr=new Map([["parts",$a([_Mo])],["dlpkey",$a([])]]);var _Mt=new Map([["cset","X"],["min",1],["max",25],["opt",false],["linters",$a(["lintcsumalpha","lintgcppos1","linthasnondigit"])]]);var _My=new Map([["parts",$a([_Mt])],["req",$a([$a([$a(["01"])])])],["dlattr",false]]);var _N0=new Map([["cset","N"],["min",18],["max",18],["opt",false],["linters",$a(["lintcsum","lintgcppos1"])]]);var _N5=new Map([["parts",$a([_N0])],["ex",$a(["8018"])],["dlpkey",$a([$a(["8019"])])]]);var _N7=new Map([["cset","N"],["min",18],["max",18],["opt",false],["linters",$a(["lintcsum","lintgcppos1"])]]);var _NC=new Map([["parts",$a([_N7])],["ex",$a(["8017"])],["dlpkey",$a([$a(["8019"])])]]);var _NE=new Map([["cset","N"],["min",1],["max",10],["opt",false],["linters",$a([])]]);var _NK=new Map([["parts",$a([_NE])],["req",$a([$a([$a(["8017"]),$a(["8018"])])])],["dlattr",false]]);var _NM=new Map([["cset","X"],["min",1],["max",25],["opt",false],["linters",$a([])]]);var _NR=new Map([["parts",$a([_NM])],["req",$a([$a([$a(["415"])])])],["dlattr",false]]);var _NT=new Map([["cset","N"],["min",14],["max",14],["opt",false],["linters",$a(["lintcsum","lintgcppos2"])]]);var _NV=new Map([["cset","N"],["min",4],["max",4],["opt",false],["linters",$a(["lintpieceoftotal"])]]);var _Nb=new Map([["parts",$a([_NT,_NV])],["ex",$a(["02","8006"])],["req",$a([$a([$a(["37"])])])]]);var _Nd=new Map([["cset","Z"],["min",1],["max",90],["opt",false],["linters",$a([])]]);var _Nr=new Map([["parts",$a([_Nd])],["req",$a([$a([$a(["00"]),$a(["01","21"]),$a(["253"]),$a(["255"]),$a(["8003"]),$a(["8004"]),$a(["8006","21"]),$a(["8010","8011"]),$a(["8017"]),$a(["8018"])])])]]);var _Nt=new Map([["cset","X"],["min",1],["max",70],["opt",false],["linters",$a(["lintcouponcode"])]]);var _Nv=new Map([["parts",$a([_Nt])]]);var _Nx=new Map([["cset","N"],["min",4],["max",4],["opt",false],["linters",$a([])]]);var _O2=new Map([["parts",$a([_Nx])],["req",$a([$a([$a(["255"])])])]]);var _O4=new Map([["cset","X"],["min",1],["max",70],["opt",false],["linters",$a(["lintcouponposoffer"])]]);var _O6=new Map([["parts",$a([_O4])]]);var _O8=new Map([["cset","X"],["min",1],["max",70],["opt",false],["linters",$a([])]]);var _OD=new Map([["parts",$a([_O8])],["req",$a([$a([$a(["01"])])])],["dlattr",false]]);var _OF=new Map([["cset","X"],["min",1],["max",30],["opt",false],["linters",$a([])]]);var _OH=new Map([["parts",$a([_OF])]]);var _OJ=new Map([["cset","X"],["min",1],["max",90],["opt",false],["linters",$a([])]]);var _OL=new Map([["parts",$a([_OJ])]]);var _OM=new Map([["00",_4],["01",_C],["02",_K],["03",_P],["10",_a],["11",_l],["12",_s],["13",_13],["15",_13],["16",_13],["17",_1F],["20",_1P],["21",_1Z],["22",_1g],["235",_1n],["240",_1x],["241",_1x],["242",_27],["243",_2E],["250",_2O],["251",_2W],["253",_2d],["254",_2k],["255",_2s],["30",_30],["3100",_39],["3101",_39],["3102",_39],["3103",_39],["3104",_39],["3105",_39],["3110",_3I],["3111",_3I],["3112",_3I],["3113",_3I],["3114",_3I],["3115",_3I],["3120",_3R],["3121",_3R],["3122",_3R],["3123",_3R],["3124",_3R],["3125",_3R],["3130",_3a],["3131",_3a],["3132",_3a],["3133",_3a],["3134",_3a],["3135",_3a],["3140",_3j],["3141",_3j],["3142",_3j],["3143",_3j],["3144",_3j],["3145",_3j],["3150",_3s],["3151",_3s],["3152",_3s],["3153",_3s],["3154",_3s],["3155",_3s],["3160",_41],["3161",_41],["3162",_41],["3163",_41],["3164",_41],["3165",_41],["3200",_4A],["3201",_4A],["3202",_4A],["3203",_4A],["3204",_4A],["3205",_4A],["3210",_4J],["3211",_4J],["3212",_4J],["3213",_4J],["3214",_4J],["3215",_4J],["3220",_4S],["3221",_4S],["3222",_4S],["3223",_4S],["3224",_4S],["3225",_4S],["3230",_4b],["3231",_4b],["3232",_4b],["3233",_4b],["3234",_4b],["3235",_4b],["3240",_4k],["3241",_4k],["3242",_4k],["3243",_4k],["3244",_4k],["3245",_4k],["3250",_4t],["3251",_4t],["3252",_4t],["3253",_4t],["3254",_4t],["3255",_4t],["3260",_52],["3261",_52],["3262",_52],["3263",_52],["3264",_52],["3265",_52],["3270",_5B],["3271",_5B],["3272",_5B],["3273",_5B],["3274",_5B],["3275",_5B],["3280",_5K],["3281",_5K],["3282",_5K],["3283",_5K],["3284",_5K],["3285",_5K],["3290",_5T],["3291",_5T],["3292",_5T],["3293",_5T],["3294",_5T],["3295",_5T],["3300",_5c],["3301",_5c],["3302",_5c],["3303",_5c],["3304",_5c],["3305",_5c],["3310",_5l],["3311",_5l],["3312",_5l],["3313",_5l],["3314",_5l],["3315",_5l],["3320",_5u],["3321",_5u],["3322",_5u],["3323",_5u],["3324",_5u],["3325",_5u],["3330",_63],["3331",_63],["3332",_63],["3333",_63],["3334",_63],["3335",_63],["3340",_6C],["3341",_6C],["3342",_6C],["3343",_6C],["3344",_6C],["3345",_6C],["3350",_6L],["3351",_6L],["3352",_6L],["3353",_6L],["3354",_6L],["3355",_6L],["3360",_6U],["3361",_6U],["3362",_6U],["3363",_6U],["3364",_6U],["3365",_6U],["3370",_6c],["3371",_6c],["3372",_6c],["3373",_6c],["3374",_6c],["3375",_6c],["3400",_6l],["3401",_6l],["3402",_6l],["3403",_6l],["3404",_6l],["3405",_6l],["3410",_6u],["3411",_6u],["3412",_6u],["3413",_6u],["3414",_6u],["3415",_6u],["3420",_73],["3421",_73],["3422",_73],["3423",_73],["3424",_73],["3425",_73],["3430",_7C],["3431",_7C],["3432",_7C],["3433",_7C],["3434",_7C],["3435",_7C],["3440",_7L],["3441",_7L],["3442",_7L],["3443",_7L],["3444",_7L],["3445",_7L],["3450",_7U],["3451",_7U],["3452",_7U],["3453",_7U],["3454",_7U],["3455",_7U],["3460",_7d],["3461",_7d],["3462",_7d],["3463",_7d],["3464",_7d],["3465",_7d],["3470",_7m],["3471",_7m],["3472",_7m],["3473",_7m],["3474",_7m],["3475",_7m],["3480",_7v],["3481",_7v],["3482",_7v],["3483",_7v],["3484",_7v],["3485",_7v],["3490",_84],["3491",_84],["3492",_84],["3493",_84],["3494",_84],["3495",_84],["3500",_8D],["3501",_8D],["3502",_8D],["3503",_8D],["3504",_8D],["3505",_8D],["3510",_8M],["3511",_8M],["3512",_8M],["3513",_8M],["3514",_8M],["3515",_8M],["3520",_8V],["3521",_8V],["3522",_8V],["3523",_8V],["3524",_8V],["3525",_8V],["3530",_8e],["3531",_8e],["3532",_8e],["3533",_8e],["3534",_8e],["3535",_8e],["3540",_8n],["3541",_8n],["3542",_8n],["3543",_8n],["3544",_8n],["3545",_8n],["3550",_8w],["3551",_8w],["3552",_8w],["3553",_8w],["3554",_8w],["3555",_8w],["3560",_95],["3561",_95],["3562",_95],["3563",_95],["3564",_95],["3565",_95],["3570",_9E],["3571",_9E],["3572",_9E],["3573",_9E],["3574",_9E],["3575",_9E],["3600",_9N],["3601",_9N],["3602",_9N],["3603",_9N],["3604",_9N],["3605",_9N],["3610",_9W],["3611",_9W],["3612",_9W],["3613",_9W],["3614",_9W],["3615",_9W],["3620",_9f],["3621",_9f],["3622",_9f],["3623",_9f],["3624",_9f],["3625",_9f],["3630",_9o],["3631",_9o],["3632",_9o],["3633",_9o],["3634",_9o],["3635",_9o],["3640",_9x],["3641",_9x],["3642",_9x],["3643",_9x],["3644",_9x],["3645",_9x],["3650",_A6],["3651",_A6],["3652",_A6],["3653",_A6],["3654",_A6],["3655",_A6],["3660",_AF],["3661",_AF],["3662",_AF],["3663",_AF],["3664",_AF],["3665",_AF],["3670",_AO],["3671",_AO],["3672",_AO],["3673",_AO],["3674",_AO],["3675",_AO],["3680",_AX],["3681",_AX],["3682",_AX],["3683",_AX],["3684",_AX],["3685",_AX],["3690",_Ag],["3691",_Ag],["3692",_Ag],["3693",_Ag],["3694",_Ag],["3695",_Ag],["37",_Aq],["3900",_Az],["3901",_Az],["3902",_Az],["3903",_Az],["3904",_Az],["3905",_Az],["3906",_Az],["3907",_Az],["3908",_Az],["3909",_Az],["3910",_B9],["3911",_B9],["3912",_B9],["3913",_B9],["3914",_B9],["3915",_B9],["3916",_B9],["3917",_B9],["3918",_B9],["3919",_B9],["3920",_BN],["3921",_BN],["3922",_BN],["3923",_BN],["3924",_BN],["3925",_BN],["3926",_BN],["3927",_BN],["3928",_BN],["3929",_BN],["3930",_Bb],["3931",_Bb],["3932",_Bb],["3933",_Bb],["3934",_Bb],["3935",_Bb],["3936",_Bb],["3937",_Bb],["3938",_Bb],["3939",_Bb],["3940",_Bj],["3941",_Bj],["3942",_Bj],["3943",_Bj],["3950",_Bv],["3951",_Bv],["3952",_Bv],["3953",_Bv],["3954",_Bv],["3955",_Bv],["400",_Bz],["401",_C4],["402",_C9],["403",_CG],["410",_CK],["411",_CK],["412",_CK],["413",_CK],["414",_CR],["415",_Ca],["416",_Ce],["417",_Ck],["420",_Cp],["421",_Cw],["422",_D7],["423",_DO],["424",_DX],["425",_Do],["426",_Dw],["427",_E6],["4300",_ED],["4301",_ED],["4302",_EK],["4303",_ER],["4304",_EY],["4305",_EY],["4306",_EY],["4307",_Ef],["4308",_Em],["4309",_Ev],["4310",_F2],["4311",_F2],["4312",_F9],["4313",_FG],["4314",_FN],["4315",_FN],["4316",_FN],["4317",_FU],["4318",_Fb],["4319",_Fi],["4320",_Fp],["4321",_Fw],["4322",_Fw],["4323",_Fw],["4324",_G5],["4325",_G5],["4326",_GC],["4330",_GM],["4331",_GW],["4332",_Gg],["4333",_Gq],["7001",_H0],["7002",_H8],["7003",_HI],["7004",_HR],["7005",_HZ],["7006",_Hh],["7007",_Hr],["7008",_Hz],["7009",_I7],["7010",_IF],["7011",_IP],["7020",_IZ],["7021",_Ih],["7022",_Io],["7023",_Is],["7030",_J2],["7031",_J2],["7032",_J2],["7033",_J2],["7034",_J2],["7035",_J2],["7036",_J2],["7037",_J2],["7038",_J2],["7039",_J2],["7040",_JC],["7041",_JJ],["710",_JQ],["711",_JQ],["712",_JQ],["713",_JQ],["714",_JQ],["715",_JQ],["716",_JQ],["7230",_Ja],["7231",_Ja],["7232",_Ja],["7233",_Ja],["7234",_Ja],["7235",_Ja],["7236",_Ja],["7237",_Ja],["7238",_Ja],["7239",_Ja],["7240",_Ji],["7241",_Jq],["7242",_Jy],["7250",_K6],["7251",_KG],["7252",_KN],["7253",_KW],["7254",_KW],["7255",_Kf],["7256",_Kn],["7257",_Ku],["7258",_L1],["7259",_L9],["8001",_LO],["8002",_LS],["8003",_Lb],["8004",_Lh],["8005",_Lp],["8006",_Ly],["8007",_M5],["8008",_MJ],["8009",_MR],["8010",_MX],["8011",_Me],["8012",_Mm],["8013",_Mr],["8014",_My],["8017",_N5],["8018",_NC],["8019",_NK],["8020",_NR],["8026",_Nb],["8030",_Nr],["8110",_Nv],["8111",_O2],["8112",_O6],["8200",_OD],["90",_OH],["91",_OL],["92",_OL],["93",_OL],["94",_OL],["95",_OL],["96",_OL],["97",_OL],["98",_OL],["99",_OL]]);$_.gs1syntax=_OM;if($eq($k[--$j],"ai")){$ax($k[--$j],"(");if(!$k[--$j]){$j--;$k[$j++]="bwipp.GS1aiMissingOpenParen#2494";$k[$j++]="AIs must start with '('";bwipp_raiseerror()}$k[$j-1]=Infinity;var _OR=$k[--$j];var _OS=$k[--$j];$k[$j++]=_OR;$k[$j++]=_OS;for(;;){var _OT=$k[$j-1];if(_OT.length==0){$j--;break}$X($k[--$j],")");if(!$k[--$j]){$l();$k[$j++]="bwipp.GS1aiMissingCloseParen#2500";$k[$j++]="AIs must end with ')'";bwipp_raiseerror()}var _OW=$k[--$j];$k[$j-1]=_OW;var _OY=$k[--$j];var _OZ=$k[--$j];$k[$j++]=_OY;$X(_OZ,"(");if($k[--$j]){var _Ob=$k[--$j];$k[$j-1]=_Ob;var _Od=$k[--$j];var _Oe=$k[--$j];$k[$j++]=_Od;$k[$j++]=_Oe}else{$k[$j++]=""}}var _Of=$m();$k[$j++]=_Of;if(_Of>0){var _Og=$k[--$j];for(var _Oi=_Og,_Oh=~~(_Og/2)+1;_Oi>=_Oh;_Oi-=1){$r(_Oi,-1)}}else{$j--}$as($a(~~($m()/2)));$_.ais=$k[--$j];$as($a($m()));$k[$j++]=Infinity;var _Oo=$k[--$j];var _Op=$k[--$j];$k[$j++]=_Oo;$F(_Op,function(){var _Or=new Map([["parse",$_.parse],["parseonly",true],["parsefnc",false]]);$k[$j++]=_Or;bwipp_parseinput()});$_.vals=$a();$j--}else{$ax($k[--$j],"http://");if(!$k[--$j]){$ax($k[--$j],"HTTP://");if(!$k[--$j]){$ax($k[--$j],"https://");if(!$k[--$j]){$ax($k[--$j],"HTTPS://");if(!$k[--$j]){$j--;$k[$j++]="bwipp.GS1dlURIbadScheme#2519";$k[$j++]="Scheme must be http:// HTTP:// https:// or HTTPS://";bwipp_raiseerror()}}}}$j--;$X($k[--$j],"/");if(!$k[--$j]){$j--;$k[$j++]="bwipp.GS1dlMissingDomainOrPathInfo#2525";$k[$j++]="URI must contain a domain and path info";bwipp_raiseerror()}$j-=2;$X($k[--$j],"#");if($k[--$j]){var _P5=$k[--$j];$k[$j-1]=_P5;var _P7=$k[--$j];$k[$j-1]=_P7}$X($k[--$j],"?");if(!$k[--$j]){var _PB=$k[--$j];$k[$j++]="";$k[$j++]=null;$k[$j++]=_PB}$_.pp=$k[--$j];$j--;$_.qp=$k[--$j];$k[$j++]=Infinity;$k[$j++]=0;$k[$j++]=0;$k[$j++]=$_.pp;for(;;){$X($k[--$j],"/");if(!$k[--$j]){$j--;break}var _PH=$k[--$j];$k[$j-1]=_PH.length+1;var _PJ=$k[--$j];var _PK=$k[--$j];var _PL=$k[$j-1];$k[$j++]=$f(_PJ+_PL);$k[$j++]=_PK}$as($a($m()-1));$_.pipos=$k[--$j];$j-=2;if($_.pipos.length<=1){$k[$j++]="bwipp.GS1dlNoAIinfo#2550";$k[$j++]="The path was too short to contain AI info";bwipp_raiseerror()}$k[$j++]=false;for(var _PR=$_.pipos.length-2;_PR>=0;_PR-=2){var _PT=$g($_.pipos,_PR);var _PX=$G($_.pp,_PT,$f($g($_.pipos,_PR+1)-_PT)-1);var _PZ=$g($_.gs1syntax,_PX)!==undefined;$k[$j++]=_PR;$k[$j++]=_PX;if(_PZ){var _Pd=$g($g($_.gs1syntax,$k[--$j]),"dlpkey")!==undefined;if(_Pd){var _Pe=$k[--$j];$k[$j-1]=_Pe;$k[$j++]=true;break}}else{$j--}$j--}if(!$k[--$j]){$k[$j++]="bwipp.GS1dlNoAIinfo#2569";$k[$j++]="The path does not contain a valid primary key";bwipp_raiseerror()}var _Pj=$g($_.pipos,$k[--$j]);$_.pp=$G($_.pp,_Pj,$f($_.pp.length-_Pj));$_.uriunescape=function(){$_.qq=$k[--$j];$_.in=$k[--$j];$_.out=$s($_.in.length);$k[$j++]=0;$k[$j++]=0;for(;;){var _Ps=$k[$j-2];if(_Ps>=$_.in.length){break}var _Pw=$k[$j-2];var _Px=$g($_.in,_Pw);$k[$j++]=_Px;if(_Px==43&&$_.qq){$j--;var _Q0=$k[--$j];$p($_.out,_Q0,32);var _Q1=$k[--$j];$k[$j++]=_Q1+1;$k[$j++]=_Q0+1}else{var _Q2=$k[$j-1];var _Q4=$k[$j-3];if(_Q2==37&&_Q4<$_.in.length-2){$j--;var _Q8=$k[$j-2];var _Q9=$G($_.in,_Q8+1,2);$k[$j++]=0;for(var _QA=0,_QB=_Q9.length;_QA<_QB;_QA++){var _QC=$g(_Q9,_QA);$k[$j++]=_QC;if(_QC>=48&&_QC<=57){var _QD=$k[--$j];$k[$j++]=_QD-48}else{var _QE=$k[$j-1];if(_QE>=65&&_QE<=70){var _QF=$k[--$j];$k[$j++]=_QF-55}else{var _QG=$k[$j-1];if(_QG>=97&&_QG<=102){var _QH=$k[--$j];$k[$j++]=_QH-87}else{$j-=2;$k[$j++]="bwipp.GS1dlBadHexCharacter#2590";$k[$j++]="Invalid hex character";bwipp_raiseerror()}}}var _QI=$k[--$j];var _QJ=$k[--$j];$k[$j++]=$f(_QI+_QJ*16)}var _QL=$k[--$j];var _QM=$k[--$j];$p($_.out,_QM,_QL);var _QN=$k[--$j];$k[$j++]=_QN+3;$k[$j++]=_QM+1}else{var _QP=$k[--$j];var _QQ=$k[--$j];$p($_.out,_QQ,_QP);var _QR=$k[--$j];$k[$j++]=_QR+1;$k[$j++]=_QQ+1}}}$_.out=$G($_.out,0,$k[--$j]);$k[$j-1]=$_.out};$_.isvaliddlpkeyseq=function(){$_.in=$k[--$j];$k[$j++]=false;$F($g($g($_.gs1syntax,$g($_.in,0)),"dlpkey"),function(){$_.seq=$k[--$j];$_.i=1;$_.j=0;for(;;){if($_.i>=$_.in.length){break}if($_.j>=$_.seq.length){break}if($eq($g($_.in,$_.i),$g($_.seq,$_.j))){$_.i=$_.i+1}$_.j=$_.j+1}if($_.i==$_.in.length){$k[$j-1]=true;return true}})};$_.ais=$a(99);$_.vals=$a(99);$k[$j++]=0;$k[$j++]=$_.pp;for(;;){$X($k[--$j],"/");if($k[--$j]){var _Qx=$k[--$j];$j--;var _Qz=$k[--$j];var _R0=$k[$j-1];$p($_.ais,_R0,_Qx);$X(_Qz,"/");if($k[--$j]){var _R2=$k[--$j];$k[$j-1]=_R2}else{var _R4=$k[--$j];$k[$j++]="";$k[$j++]=_R4}var _R6=$k[--$j];var _R8=$k[$j-2];$k[$j++]=$_.vals;$k[$j++]=_R8;$k[$j++]=_R6;$k[$j++]=false;$_.uriunescape();var _R9=$k[--$j];var _RA=$k[--$j];$p($k[--$j],_RA,_R9)}else{$j--;break}var _RC=$k[--$j];var _RD=$k[--$j];$k[$j++]=_RD+1;$k[$j++]=_RC}var _RE=$k[--$j];$_.plen=_RE;$k[$j++]=_RE;if(_RE>1){$k[$j++]=$G($_.ais,0,$_.plen);$_.isvaliddlpkeyseq();if(!$k[--$j]){$j--;$k[$j++]="bwipp.GS1dlBadPathInfo#2645";$k[$j++]="The AIs in the path are not a valid key-qualifier sequence for the key";bwipp_raiseerror()}}$k[$j++]=$_.qp;for(;;){var _RK=$k[$j-1];if(_RK.length==0){$j--;break}$X($k[--$j],"&");if($k[--$j]){var _RN=$k[--$j];$k[$j-1]=_RN}else{var _RP=$k[--$j];$k[$j++]="";$k[$j++]=_RP}$X($k[--$j],"=");if($k[--$j]){var _RS=$k[$j-1];$k[$j++]=true;$F(_RS,function(){var _RT=$k[--$j];var _RU=$k[--$j];$k[$j++]=_RU&&(_RT>=48&&_RT<=57)});if($k[--$j]){var _RX=$k[--$j];$j--;var _RZ=$k[--$j];var _Rb=$k[$j-2];$p($_.ais,_Rb,_RX);$k[$j++]=$_.vals;$k[$j++]=_Rb;$k[$j++]=_RZ;$k[$j++]=true;$_.uriunescape();var _Rd=$k[--$j];var _Re=$k[--$j];$p($k[--$j],_Re,_Rd);var _Rg=$k[--$j];var _Rh=$k[--$j];$k[$j++]=_Rh+1;$k[$j++]=_Rg}else{$j-=3}}else{$j--}}var _Rk=$k[$j-1];var _Rm=$G($_.ais,$_.plen,$f(_Rk-$_.plen));for(var _Rn=0,_Ro=_Rm.length;_Rn<_Ro;_Rn++){var _Rp=$g(_Rm,_Rn);var _Rr=$g($_.gs1syntax,_Rp)!==undefined;$k[$j++]=_Rp;if(_Rr){var _Rt=$k[$j-1];var _Ru=$g($_.gs1syntax,_Rt);var _Rv=$g(_Ru,"dlattr")!==undefined;$k[$j++]=_Ru;$k[$j++]="dlattr";if(_Rv){var _Rw=$k[--$j];var _Ry=$g($k[--$j],_Rw);$k[$j++]=_Ry}else{$j-=2;$k[$j++]=true}}else{$k[$j++]=$_.dontlint}if(!$k[--$j]){var _S1=$k[$j-1];var _S2=_S1.length;var _S3=$s(_S2+46);$P(_S3,0,"AI (");$P(_S3,4,_S1);$P(_S3,_S2+4,") is not a valid GS1 DL URI data attribute");$k[$j++]=_S3;var _S4=$k[--$j];$k[$j-1]=_S4;var _S6=$k[--$j];$k[$j++]="bwipp.GS1dlInvalidDataAttribute#2679";$k[$j++]=_S6;bwipp_raiseerror()}$j--}var _S9=$k[$j-1];var _SB=$G($_.ais,$_.plen,$f(_S9-$_.plen));for(var _SC=0,_SD=_SB.length;_SC<_SD;_SC++){$k[$j++]=$g(_SB,_SC);for(var _SG=$_.plen;_SG>=1;_SG-=1){var _SH=$k[$j-1];$k[$j++]=_SG;$k[$j++]=_SH;$k[$j++]=Infinity;$q($G($_.ais,0,$_.plen));$r($m()+3,-2);var _SM=$k[--$j];var _SN=$k[--$j];$k[$j++]=_SM;$r(_SN,1);var _SO=$a();$k[$j++]=_SO;$_.isvaliddlpkeyseq();if($k[--$j]){var _SQ=$k[--$j];$k[$j-1]=_SQ;var _SS=$k[$j-1];var _ST=_SS.length;var _SU=$s(_ST+50);$P(_SU,0,"AI (");$P(_SU,4,_SS);$P(_SU,_ST+4,") from query params should be in the path info");$k[$j++]=_SU;var _SV=$k[--$j];$k[$j-1]=_SV;var _SX=$k[--$j];$k[$j++]="bwipp.GS1dlAttributeMustBeQualifier#2696";$k[$j++]=_SX;bwipp_raiseerror()}}$j--}var _SZ=$k[--$j];$_.ais=$G($_.ais,0,_SZ);$_.vals=$G($_.vals,0,_SZ);for(var _Sf=0,_Se=$_.ais.length-1;_Sf<=_Se;_Sf+=1){$k[$j++]=_Sf;if($eq($g($_.ais,_Sf),"01")){var _Si=$k[$j-1];var _Sk=$g($_.vals,_Si);var _Sl=_Sk.length;$k[$j++]=_Sk;if(_Sl==8||(_Sl==12||_Sl==13)){var _Sn=$Z($s(14),"00000000000000");$k[$j++]=_Sn;$k[$j++]=_Sn;var _So=$k[$j-3];$P($k[$j-1],14-_So.length,_So);var _Sr=$k[$j-2];$j-=3;var _Ss=$k[$j-1];$p($_.vals,_Ss,_Sr)}else{$j--}}$j--}}$k[$j++]=Infinity;var _St=$a(["00","01","02","03","04","11","12","13","14","15","16","17","18","19","20","31","32","33","34","35","36","41"]);for(var _Su=0,_Sv=_St.length;_Su<_Sv;_Su++){var _Sw=$g(_St,_Su);$k[$j++]=_Sw;$k[$j++]=_Sw}$_.aifixed=$d();$k[$j++]=Infinity;var _Sz=$_.ais;for(var _T0=0,_T1=_Sz.length;_T0<_T1;_T0++){var _T2=$g(_Sz,_T0);$k[$j++]=true;$k[$j++]=_T2;if(_T2.length>=2){var _T6=$g($_.aifixed,$G($k[--$j],0,2))!==undefined;if(_T6){$k[$j-1]=false}}else{$j--}}$_.fncs=$a();$k[$j++]=Infinity;$k[$j++]=0;for(var _T8=0,_T9="!\"%&'()*+,-./0123456789:;<=>?ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz".length;_T8<_T9;_T8++){var _TB=$k[--$j];$k[$j++]=$g("!\"%&'()*+,-./0123456789:;<=>?ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz",_T8);$k[$j++]=_TB;$k[$j++]=_TB+1}$j--;$_.cset82=$d();$k[$j++]=Infinity;$k[$j++]=0;for(var _TD=0,_TE="#-/0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".length;_TD<_TE;_TD++){var _TG=$k[--$j];$k[$j++]=$g("#-/0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ",_TD);$k[$j++]=_TG;$k[$j++]=_TG+1}$j--;$_.cset39=$d();$k[$j++]=Infinity;$k[$j++]=0;for(var _TI=0,_TJ="23456789ABCDEFGHJKLMNPQRSTUVWXYZ".length;_TI<_TJ;_TI++){var _TL=$k[--$j];$k[$j++]=$g("23456789ABCDEFGHJKLMNPQRSTUVWXYZ",_TI);$k[$j++]=_TL;$k[$j++]=_TL+1}$j--;$_.cset32=$d();$k[$j++]=Infinity;$k[$j++]=0;for(var _TN=0,_TO="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_".length;_TN<_TO;_TN++){var _TQ=$k[--$j];$k[$j++]=$g("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_",_TN);$k[$j++]=_TQ;$k[$j++]=_TQ+1}$j--;$_.cset64=$d();$_.lintnumeric=function(){var _TT=$k[--$j];$k[$j++]=true;$F(_TT,function(){var _TU=$k[--$j];if(_TU<48||_TU>57){$k[$j-1]=false;return true}});if(!$k[--$j]){$j--;$k[$j++]="bwipp.GS1notNumeric#2770";$k[$j++]="Not numeric";$k[$j++]=false;return true}};$_.lintcset82=function(){var _TW=$k[--$j];$k[$j++]=true;$F(_TW,function(){var _TZ=$g($_.cset82,$k[--$j])!==undefined;if(!_TZ){$k[$j-1]=false;return true}});if(!$k[--$j]){$j--;$k[$j++]="bwipp.GS1badCSET82character#2775";$k[$j++]="Invalid CSET 82 character";$k[$j++]=false;return true}};$_.lintcset39=function(){var _Tb=$k[--$j];$k[$j++]=true;$F(_Tb,function(){var _Te=$g($_.cset39,$k[--$j])!==undefined;if(!_Te){$k[$j-1]=false;return true}});if(!$k[--$j]){$j--;$k[$j++]="bwipp.GS1badCSET39character#2780";$k[$j++]="Invalid CSET 39 character";$k[$j++]=false;return true}};$_.lintcset64=function(){var _Tg=$k[$j-1];$X(_Tg,"=");if($k[--$j]){var _Ti=$k[--$j];$k[$j-1]=_Ti;var _Tk=$k[--$j];$k[$j++]=_Tk.length%3;$k[$j++]=_Tk;var _Tl=$k[$j-2];var _Tm=$k[$j-3];$k[$j-3]=$k[$j-1];$j-=2;$k[$j++]=_Tm;$k[$j++]=_Tl;$k[$j++]=false;if(_Tl==1&&$eq(_Tm,"=")){$k[$j-1]=true}var _To=$k[$j-2];var _Tp=$k[$j-3];if(_To==2&&_Tp.length==0){$k[$j-1]=true}if(!$k[--$j]){$j-=5;$k[$j++]="bwipp.GS1badCSET64padding#2789";$k[$j++]="Invalid CSET 64 padding";$k[$j++]=false;return true}$j-=2;var _Tr=$k[--$j];var _Ts=$k[--$j];$k[$j++]=_Tr;$k[$j++]=_Ts}$j--;var _Tt=$k[--$j];$k[$j++]=true;$F(_Tt,function(){var _Tw=$g($_.cset64,$k[--$j])!==undefined;if(!_Tw){$k[$j-1]=false;return true}});if(!$k[--$j]){$j--;$k[$j++]="bwipp.GS1badCSET64character#2795";$k[$j++]="Invalid CSET 64 character";$k[$j++]=false;return true}};$_.lintgcppos1=function(){var _Ty=$k[$j-1];if(_Ty.length<2){$j-=2;$k[$j++]="bwipp.GS1gcpTooShort#2799";$k[$j++]="Value is too short to contain a GS1 Company Prefix";$k[$j++]=false;return true}var _Tz=$k[--$j];var _U0=$g(_Tz,0);var _U1=$g(_Tz,1);if(_U0<48||_U0>57||(_U1<48||_U1>57)){$j--;$k[$j++]="bwipp.GS1badGCP#2802";$k[$j++]="Non-numeric GS1 Company Prefix";$k[$j++]=false;return true}};$_.lintgcppos2=function(){var _U2=$k[$j-1];if(_U2.length<1){$j-=2;$k[$j++]="bwipp.GS1valueTooShortForOffsetGCP#2807";$k[$j++]="Value is too short to contain an offset GS1 Company Prefix";$k[$j++]=false;return true}var _U3=$k[--$j];$k[$j++]=$G(_U3,1,_U3.length-1);$_.lintgcppos1()};$_.lintimporteridx=function(){$X("-0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz",$k[--$j]);if(!$k[--$j]){$j-=2;$k[$j++]="bwipp.GS1badImporterIndex#2813";$k[$j++]="Invalid importer index";$k[$j++]=false;return true}$j-=3};$_.lintcsum=function(){$k[$j++]=Infinity;var _U7=$k[--$j];var _U8=$k[--$j];var _U9=_U8.length%2==0?3:1;$k[$j++]=_U7;$k[$j++]=_U9;$F(_U8,function(){var _UA=$k[--$j];var _UB=$k[--$j];$k[$j++]=(_UA-48)*_UB;$k[$j++]=4-_UB});$j--;var _UC=$m()+1;$k[$j++]=0;for(var _UD=0,_UE=_UC-1;_UD<_UE;_UD++){var _UF=$k[--$j];var _UG=$k[--$j];$k[$j++]=$f(_UG+_UF)}var _UH=$k[--$j];$k[$j-1]=_UH;if($k[--$j]%10!=0){$j--;$k[$j++]="bwipp.GS1badChecksum#2822";$k[$j++]="Bad checksum";$k[$j++]=false;return true}};$_.lintcsumalpha=function(){var _UK=$k[$j-1];if(_UK.length<2){$j-=2;$k[$j++]="bwipp.GS1alphaTooShort#2826";$k[$j++]="Alphanumeric string is too short to check";$k[$j++]=false;return true}var _UL=$k[$j-1];$k[$j++]=_UL.length-2;var _UN=Infinity;var _UO=$G(_UL,0,_UL.length-2);$k[$j++]=_UN;$F(_UO,function(){var _UP=$k[$j-1];var _UR=$g($_.cset82,_UP)!==undefined;if(_UR){var _UU=$g($_.cset82,$k[--$j]);$k[$j++]=_UU}else{$k[$j++]=-1;return true}});var _UV=$k[$j-1];if(_UV==-1){$l();$j-=3;$k[$j++]="bwipp.GS1UnknownCSET82Character#2832";$k[$j++]="Unknown CSET 82 character";$k[$j++]=false;return true}$as($a($m()));var _UY=$k[--$j];$k[$j-1]=_UY;var _Ua=$k[$j-2];var _Uc=$G($k[$j-3],_Ua,2);$k[$j-3]=$k[$j-1];$j-=2;var _Ud=Infinity;var _Ue=_Uc;$k[$j++]=_Ud;$F(_Ue,function(){var _Uf=$k[$j-1];var _Uh=$g($_.cset32,_Uf)!==undefined;if(_Uh){var _Uk=$g($_.cset32,$k[--$j]);$k[$j++]=_Uk}else{$k[$j++]=-1;return true}});var _Ul=$k[$j-1];if(_Ul==-1){$l();$j-=2;$k[$j++]="bwipp.GS1UnknownCSET32Character#2838";$k[$j++]="Unknown CSET 32 character";$k[$j++]=false;return true}$as($a($m()));var _Uo=$k[--$j];$k[$j-1]=_Uo;var _Uq=$k[--$j];var _Ut=$k[--$j];var _Uu=$a([2,3,5,7,11,13,17,19,23,29,31,37,41,43,47,53,59,61,67,71,73,79,83]);var _Uv=_Ut.length;$k[$j++]=$f(($g(_Uq,0)<<5)+$g(_Uq,1));$k[$j++]=_Ut;$k[$j++]=_Uu;$k[$j++]=_Uv;if(_Uv>_Uu.length){$j-=5;$k[$j++]="bwipp.GS1alphaTooLong#2843";$k[$j++]="Alphanumeric string is too long to check";$k[$j++]=false;return true}var _Uw=$k[--$j];var _Uy=$G($k[--$j],0,_Uw);for(var _Uz=0,_V0=_Uy.length;_Uz<_V0;_Uz++){var _V2=$k[--$j];$k[$j++]=$g(_Uy,_Uz);$k[$j++]=_V2}var _V3=$k[--$j];$k[$j++]=0;$F(_V3,function(){var _V4=$k[$j-3];var _V5=$k[$j-1];var _V6=$k[$j-2];$j-=3;$k[$j++]=$f(_V6+_V4*_V5)});var _V7=$k[--$j];if($k[--$j]!=_V7%1021){$j--;$k[$j++]="bwipp.GS1badAlphaCheckCharacters#2846";$k[$j++]="Bad alphanumeric check characters";$k[$j++]=false;return true}};$k[$j++]=Infinity;var _V9=$a(["004","008","010","012","016","020","024","028","031","032","036","040","044","048","050","051","052","056","060","064","068","070","072","074","076","084","086","090","092","096","100","104","108","112","116","120","124","132","136","140","144","148","152","156","158","162","166","170","174","175","178","180","184","188","191","192","196","203","204","208","212","214","218","222","226","231","232","233","234","238","239","242","246","248","250","254","258","260","262","266","268","270","275","276","288","292","296","300","304","308","312","316","320","324","328","332","334","336","340","344","348","352","356","360","364","368","372","376","380","384","388","392","398","400","404","408","410","414","417","418","422","426","428","430","434","438","440","442","446","450","454","458","462","466","470","474","478","480","484","492","496","498","499","500","504","508","512","516","520","524","528","531","533","534","535","540","548","554","558","562","566","570","574","578","580","581","583","584","585","586","591","598","600","604","608","612","616","620","624","626","630","634","638","642","643","646","652","654","659","660","662","663","666","670","674","678","682","686","688","690","694","702","703","704","705","706","710","716","724","728","729","732","740","744","748","752","756","760","762","764","768","772","776","780","784","788","792","795","796","798","800","804","807","818","826","831","832","833","834","840","850","854","858","860","862","876","882","887","894"]);for(var _VA=0,_VB=_V9.length;_VA<_VB;_VA++){var _VC=$g(_V9,_VA);$k[$j++]=_VC;$k[$j++]=_VC}$_.iso3166=$d();$_.lintiso3166=function(){var _VH=$g($_.iso3166,$k[--$j])!==undefined;if(!_VH){$j--;$k[$j++]="bwipp.GS1UnknownCountry#2873";$k[$j++]="Unknown country code";$k[$j++]=false;return true}};$_.lintiso3166999=function(){var _VI=$k[$j-1];if($ne(_VI,"999")){var _VL=$g($_.iso3166,$k[--$j])!==undefined;if(!_VL){$j--;$k[$j++]="bwipp.GS1UnknownCountryOr999#2878";$k[$j++]="Unknown country code or not 999";$k[$j++]=false;return true}}else{$j--}};$k[$j++]=Infinity;var _VM=$a(["AD","AE","AF","AG","AI","AL","AM","AO","AQ","AR","AS","AT","AU","AW","AX","AZ","BA","BB","BD","BE","BF","BG","BH","BI","BJ","BL","BM","BN","BO","BQ","BR","BS","BT","BV","BW","BY","BZ","CA","CC","CD","CF","CG","CH","CI","CK","CL","CM","CN","CO","CR","CU","CV","CW","CX","CY","CZ","DE","DJ","DK","DM","DO","DZ","EC","EE","EG","EH","ER","ES","ET","FI","FJ","FK","FM","FO","FR","GA","GB","GD","GE","GF","GG","GH","GI","GL","GM","GN","GP","GQ","GR","GS","GT","GU","GW","GY","HK","HM","HN","HR","HT","HU","ID","IE","IL","IM","IN","IO","IQ","IR","IS","IT","JE","JM","JO","JP","KE","KG","KH","KI","KM","KN","KP","KR","KW","KY","KZ","LA","LB","LC","LI","LK","LR","LS","LT","LU","LV","LY","MA","MC","MD","ME","MF","MG","MH","MK","ML","MM","MN","MO","MP","MQ","MR","MS","MT","MU","MV","MW","MX","MY","MZ","NA","NC","NE","NF","NG","NI","NL","NO","NP","NR","NU","NZ","OM","PA","PE","PF","PG","PH","PK","PL","PM","PN","PR","PS","PT","PW","PY","QA","RE","RO","RS","RU","RW","SA","SB","SC","SD","SE","SG","SH","SI","SJ","SK","SL","SM","SN","SO","SR","SS","ST","SV","SX","SY","SZ","TC","TD","TF","TG","TH","TJ","TK","TL","TM","TN","TO","TR","TT","TV","TW","TZ","UA","UG","UM","US","UY","UZ","VA","VC","VE","VG","VI","VN","VU","WF","WS","YE","YT","ZA","ZM","ZW"]);for(var _VN=0,_VO=_VM.length;_VN<_VO;_VN++){var _VP=$g(_VM,_VN);$k[$j++]=_VP;$k[$j++]=_VP}$_.iso3166alpha2=$d();$_.lintiso3166alpha2=function(){var _VU=$g($_.iso3166alpha2,$k[--$j])!==undefined;if(!_VU){$j--;$k[$j++]="bwipp.GS1UnknownCountryAlpha#2914";$k[$j++]="Unknown country alpha code";$k[$j++]=false;return true}};$k[$j++]=Infinity;var _VV=$a(["008","012","032","036","044","048","050","051","052","060","064","068","072","084","090","096","104","108","116","124","132","136","144","152","156","170","174","188","191","192","203","208","214","222","230","232","238","242","262","270","292","320","324","328","332","340","344","348","352","356","360","364","368","376","388","392","396","398","400","404","408","410","414","417","418","422","426","430","434","446","454","458","462","480","484","496","498","504","512","516","524","532","533","548","554","558","566","578","586","590","598","600","604","608","634","643","646","654","682","690","694","702","704","706","710","728","748","752","756","760","764","776","780","784","788","800","807","818","826","834","840","858","860","882","886","901","925","927","928","929","930","931","932","933","934","936","938","940","941","943","944","946","947","948","949","950","951","952","953","955","956","957","958","959","960","961","962","963","964","965","967","968","969","970","971","972","973","975","976","977","978","979","980","981","984","985","986","990","994","997","999"]);for(var _VW=0,_VX=_VV.length;_VW<_VX;_VW++){var _VY=$g(_VV,_VW);$k[$j++]=_VY;$k[$j++]=_VY}$_.iso4217=$d();$_.lintiso4217=function(){var _Vd=$g($_.iso4217,$k[--$j])!==undefined;if(!_Vd){$j--;$k[$j++]="bwipp.GS1UnknownCurrency#2945";$k[$j++]="Unknown currency code";$k[$j++]=false;return true}};$_.lintiso5218=function(){var _Ve=$k[--$j];if($ne(_Ve,"0")&&($ne(_Ve,"1")&&($ne(_Ve,"2")&&$ne(_Ve,"9")))){$j--;$k[$j++]="bwipp.GS1biologicalSexCode#2950";$k[$j++]="Invalid biological sex code";$k[$j++]=false;return true}};$_.lintiban=function(){var _Vf=$k[$j-1];if(_Vf.length<=4){$j-=2;$k[$j++]="bwipp.GS1tooShort#2955";$k[$j++]="IBAN too short";$k[$j++]=false;return true}var _Vg=$k[$j-1];$k[$j++]=true;$F(_Vg,function(){var _Vh=$s(1);$k[$j++]=_Vh;$k[$j++]=_Vh;$k[$j++]=0;$r(4,-1);var _Vi=$k[--$j];var _Vj=$k[--$j];$p($k[--$j],_Vj,_Vi);$X("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ",$k[--$j]);if(!$k[--$j]){$j-=2;$k[$j++]=false;return true}$j-=3});if(!$k[--$j]){$j--;$k[$j++]="bwipp.GS1badIBANcharacter#2962";$k[$j++]="Invalid IBAN character";$k[$j++]=false;return true}var _Vo=$k[$j-1];var _Vp=Infinity;var _Vq=_Vo;$k[$j++]=_Vp;var _Vr=Infinity;var _Vs=_Vq;$k[$j++]=_Vr;$F(_Vs);$r($m(),-4);$as($a($m()));var _Vw=$k[--$j];$k[$j-1]=_Vw;$F($k[--$j],function(){var _W0=$k[--$j]-48;$k[$j++]=_W0;if(_W0>9){var _W2=$k[--$j]-7;$k[$j++]=~~(_W2/10);$k[$j++]=_W2%10}});$as($a($m()));var _W5=$k[--$j];$k[$j-1]=_W5;var _W7=$k[--$j];$k[$j++]=0;$F(_W7,function(){var _W8=$k[--$j];var _W9=$k[--$j];$k[$j++]=$f(_W8+_W9*10)%97});if($k[--$j]!=1){$j-=2;$k[$j++]="bwipp.GS1badIBANchecksum#2967";$k[$j++]="IBAN checksum incorrect";$k[$j++]=false;return true}var _WC=$G($k[--$j],0,2);$k[$j++]=_WC;$_.lintiso3166alpha2()};$_.lintzero=function(){if($ne($k[--$j],"0")){$j--;$k[$j++]="bwipp.GS1zeroRequired#2972";$k[$j++]="Zero is required";$k[$j++]=false;return true}};$_.lintnonzero=function(){var _WE=$k[--$j];$k[$j++]=false;$F(_WE,function(){if($k[--$j]!=48){$k[$j-1]=true}});if(!$k[--$j]){$j--;$k[$j++]="bwipp.GS1zeroNotPermitted#2977";$k[$j++]="Zero not permitted";$k[$j++]=false;return true}};$_.lintnozeroprefix=function(){var _WH=$k[--$j];if(_WH.length>1&&$g(_WH,0)==48){$j--;$k[$j++]="bwipp.GS1badZeroPrefix#2982";$k[$j++]="Zero prefix is not permitted";$k[$j++]=false;return true}};$_.linthasnondigit=function(){var _WJ=$k[--$j];$k[$j++]=false;$F(_WJ,function(){var _WK=$k[--$j];if(_WK<48||_WK>57){$k[$j-1]=true;return true}});if(!$k[--$j]){$k[$j++]="bwipp.GS1requiresNonDigit#2988";$k[$j++]="A non-digit character is required";$k[$j++]=false;return true}};$_.linthyphen=function(){if($ne($k[--$j],"-")){$j--;$k[$j++]="bwipp.GS1hyphenRequired#2992";$k[$j++]="A hyphen is required";$k[$j++]=false;return true}};$_.lintyyyymmd0=function(){var _WN=$k[$j-1];var _WP=$i($G(_WN,4,2));if(_WP<1||_WP>12){$j--;$k[$j++]="bwipp.GS1badMonth#2996";$k[$j++]="Invalid month";$k[$j++]=false;return true}var _WQ=$k[$j-1];var _WS=$i($G(_WQ,0,4));$k[$j++]=_WS%400==0||_WS%4==0&&_WS%100!=0;$k[$j++]=Infinity;$k[$j++]=31;$r(3,-1);var _WU=$k[--$j]?29:28;$k[$j++]=_WU;$k[$j++]=31;$k[$j++]=30;$k[$j++]=31;$k[$j++]=30;$k[$j++]=31;$k[$j++]=31;$k[$j++]=30;$k[$j++]=31;$k[$j++]=30;$k[$j++]=31;var _WV=$a();var _WW=$k[--$j];if($g(_WV,$i($G(_WW,4,2))-1)<$i($G(_WW,6,2))){$j--;$k[$j++]="bwipp.GS1badDay#3000";$k[$j++]="Invalid day of month";$k[$j++]=false;return true}};$_.lintyyyymmdd=function(){var _Wa=$k[$j-1];if(_Wa.length!=8){$j--;$k[$j++]="bwipp.GS1badDateLength#3004";$k[$j++]="Invalid length for yyyymmdd date";$k[$j++]=false;return true}var _Wb=$k[$j-1];if($i($G(_Wb,6,2))<1){$j--;$k[$j++]="bwipp.GS1badDay#3005";$k[$j++]="Invalid day of month";$k[$j++]=false;return true}$_.lintyyyymmd0()};$_.lintyymmd0=function(){var _Wd=$k[$j-1];var _Wf=$i($G(_Wd,0,2));var _Wg=_Wf-21;$k[$j++]=_Wf;$k[$j++]=_Wg;if(_Wg>=51){$k[$j-1]="19"}else{if($k[--$j]<=-50){$k[$j++]="21"}else{$k[$j++]="20"}}var _Wi=$k[--$j];$k[$j-1]=_Wi;var _Wk=$s(8);$k[$j++]=_Wk;$k[$j++]=_Wk;$k[$j++]=0;$r(4,-1);var _Wl=$k[--$j];var _Wm=$k[--$j];$P($k[--$j],_Wm,_Wl);var _Wo=$k[$j-1];$k[$j++]=_Wo;$k[$j++]=2;$r(4,-1);var _Wp=$k[--$j];var _Wq=$k[--$j];$P($k[--$j],_Wq,_Wp);$_.lintyyyymmd0()};$_.lintyymmdd=function(){var _Ws=$k[$j-1];if(_Ws.length!=6){$j--;$k[$j++]="bwipp.GS1badDateLength#3017";$k[$j++]="Invalid length for yymmdd date";$k[$j++]=false;return true}var _Wt=$k[$j-1];if($i($G(_Wt,4,2))<1){$j--;$k[$j++]="bwipp.GS1badDay#3018";$k[$j++]="Invalid day of month";$k[$j++]=false;return true}$_.lintyymmd0()};$_.linthh=function(){if($i($G($k[--$j],0,2))>23){$j-=2;$k[$j++]="bwipp.GS1badHour#3023";$k[$j++]="Invalid hour of day";$k[$j++]=false;return true}};$_.lintmi=function(){if($i($G($k[--$j],0,2))>59){$j--;$k[$j++]="bwipp.GS1badMinute#3027";$k[$j++]="Invalid minute in the hour";$k[$j++]=false;return true}};$_.lintss=function(){if($i($G($k[--$j],0,2))>59){$j--;$k[$j++]="bwipp.GS1badSecond#3031";$k[$j++]="Invalid second in the minute";$k[$j++]=false;return true}};$_.linthhmi=function(){var _X1=$k[$j-1];if($i($G(_X1,0,2))>23){$j-=2;$k[$j++]="bwipp.GS1badHour#3035";$k[$j++]="Invalid hour of day";$k[$j++]=false;return true}if($i($G($k[--$j],2,2))>59){$j--;$k[$j++]="bwipp.GS1badMinute#3036";$k[$j++]="Invalid minute in the hour";$k[$j++]=false;return true}};$_.lintmmoptss=function(){var _X5=$k[$j-1];var _X6=_X5.length;if(_X6!=2&&_X6!=4){$j--;$k[$j++]="bwipp.GS1badTimeLength#3041";$k[$j++]="Invalid length for optional minutes and seconds";$k[$j++]=false;return true}var _X7=$k[$j-1];if($i($G(_X7,0,2))>59){$j-=2;$k[$j++]="bwipp.GS1badMinute#3043";$k[$j++]="Invalid minute in the hour";$k[$j++]=false;return true}var _X9=$k[$j-1];if(_X9.length>=4){var _XA=$k[$j-1];if($i($G(_XA,2,2))>59){$j-=2;$k[$j++]="bwipp.GS1badSecond#3045";$k[$j++]="Invalid second in the minute";$k[$j++]=false;return true}}$j--};$_.lintyesno=function(){var _XC=$k[--$j];if($ne(_XC,"0")&&$ne(_XC,"1")){$j--;$k[$j++]="bwipp.GS1badBoolean#3052";$k[$j++]="Neither 0 nor 1 for yes or no";$k[$j++]=false;return true}};$_.lintwinding=function(){var _XD=$k[--$j];if($ne(_XD,"0")&&($ne(_XD,"1")&&$ne(_XD,"9"))){$j--;$k[$j++]="bwipp.GS1badWinding#3058";$k[$j++]="Invalid winding direction";$k[$j++]=false;return true}};$_.lintpieceoftotal=function(){var _XE=$k[$j-1];if(_XE.length%2!=0){$j-=2;$k[$j++]="bwipp.GS1badPieceTotalLength#3063";$k[$j++]="Invalid piece/total length";$k[$j++]=false;return true}var _XF=$k[$j-1];var _XH=$i($G(_XF,0,~~(_XF.length/2)));$k[$j++]=_XH;if(_XH==0){$j-=3;$k[$j++]="bwipp.GS1badPieceNumber#3065";$k[$j++]="Invalid piece number";$k[$j++]=false;return true}var _XI=$k[--$j];var _XJ=$k[--$j];var _XK=~~(_XJ.length/2);var _XM=$i($G(_XJ,_XK,_XK));$k[$j++]=_XI;$k[$j++]=_XM;if(_XM==0){$j-=3;$k[$j++]="bwipp.GS1badPieceTotal#3067";$k[$j++]="Invalid total number";$k[$j++]=false;return true}var _XN=$k[--$j];if($gt($k[--$j],_XN)){$j--;$k[$j++]="bwipp.GS1pieceExceedsTotal#3068";$k[$j++]="Piece number exceeds total";$k[$j++]=false;return true}};$_.lintposinseqslash=function(){$X($k[--$j],"/");if(!$k[--$j]){$j--;$k[$j++]="bwipp.invalidPosInSeqFormat#3073";$k[$j++]="Invalid <pos>/<end> format";$k[$j++]=false;return true}var _XR=$k[--$j];$k[$j-1]=_XR;var _XT=$k[$j-1];if(_XT.length==0){$j-=2;$k[$j++]="bwipp.invalidPosInSeqFormat#3077";$k[$j++]="Invalid <pos>/<end> format";$k[$j++]=false;return true}var _XV=$k[$j-2];if(_XV.length==0){$j-=2;$k[$j++]="bwipp.invalidPosInSeqFormat#3080";$k[$j++]="Invalid <pos>/<end> format";$k[$j++]=false;return true}var _XW=$k[$j-1];$k[$j++]=true;$F(_XW,function(){var _XX=$k[--$j];if(_XX<48||_XX>57){$k[$j-1]=false;return true}});if(!$k[--$j]){$j-=2;$k[$j++]="bwipp.positionNotNumeric#3085";$k[$j++]="Position is not numeric";$k[$j++]=false;return true}var _Xa=$k[$j-2];$k[$j++]=true;$F(_Xa,function(){var _Xb=$k[--$j];if(_Xb<48||_Xb>57){$k[$j-1]=false;return true}});if(!$k[--$j]){$j-=2;$k[$j++]="bwipp.endNotNumeric#3089";$k[$j++]="End is not numeric";$k[$j++]=false;return true}var _Xd=$k[$j-1];if($g(_Xd,0)==48){$j-=2;$k[$j++]="bwipp.positionZeroPrefix#3090";$k[$j++]="Position cannot have zero prefix";$k[$j++]=false;return true}var _Xg=$k[$j-2];if($g(_Xg,0)==48){$j-=2;$k[$j++]="bwipp.endZeroPrefix#3091";$k[$j++]="End cannot have zero prefix";$k[$j++]=false;return true}var _Xi=$k[--$j];if($i($k[--$j])<$i(_Xi)){$k[$j++]="bwipp.positionExceedsEnd#3093";$k[$j++]="Position exceeds end";$k[$j++]=false;return true}};$_.lintpcenc=function(){for(;;){$X($k[--$j],"%");if(!$k[--$j]){$j--;break}$j-=2;var _Xm=$k[$j-1];if(_Xm.length<2){$j-=2;$k[$j++]="bwipp.GS1badPercentEscape#3099";$k[$j++]="Invalid % escape";$k[$j++]=false;break}var _Xn=$k[$j-1];var _Xo=$G(_Xn,0,2);$k[$j++]=true;for(var _Xp=0,_Xq=_Xo.length;_Xp<_Xq;_Xp++){var _Xs=$s(1);$p(_Xs,0,$g(_Xo,_Xp));$X("0123456789ABCDEFabcdef",_Xs);if(!$k[--$j]){$j-=2;$k[$j++]=false;break}$j-=3}if(!$k[--$j]){$j-=2;$k[$j++]="bwipp.GS1badPercentChars#3106";$k[$j++]="Invalid characters for percent encoding";$k[$j++]=false;break}}};$_.lintcouponcode=function(){var _Xv=$k[$j-1];$k[$j++]=true;$F(_Xv,function(){var _Xw=$k[--$j];if(_Xw<48||_Xw>57){$k[$j-1]=false;return true}});if(!$k[--$j]){$j-=2;$k[$j++]="bwipp.GS1couponNotNumeric#3114";$k[$j++]="Coupon not numeric";$k[$j++]=false;return true}var _Xy=$k[$j-1];if(_Xy.length<1){$j-=2;$k[$j++]="bwipp.GS1couponTooShortGCPVLI#3118";$k[$j++]="Coupon too short: Missing GCP VLI";$k[$j++]=false;return true}var _Xz=$k[$j-1];var _Y1=$i($G(_Xz,0,1));$k[$j++]=_Y1;if(_Y1>6){$j-=2;$k[$j++]="bwipp.GS1couponBadGCPVLI#3121";$k[$j++]="Coupon GCP length indicator must be 0-6";$k[$j++]=false;return true}var _Y2=$k[--$j];var _Y3=$k[$j-1];$k[$j++]=_Y2+6+1;if(_Y2+6+1>_Y3.length){$j-=3;$k[$j++]="bwipp.GS1couponTooShortGCP#3125";$k[$j++]="Coupon too short: GCP truncated";$k[$j++]=false;return true}var _Y4=$k[--$j];var _Y5=$k[--$j];var _Y6=$G(_Y5,_Y4,$f(_Y5.length-_Y4));$k[$j++]=_Y6;if(_Y6.length<6){$j-=2;$k[$j++]="bwipp.GS1couponTooShortOfferCode#3131";$k[$j++]="Coupon too short: Offer Code truncated";$k[$j++]=false;return true}var _Y7=$k[--$j];var _Y8=$G(_Y7,6,_Y7.length-6);$k[$j++]=_Y8;if(_Y8.length<1){$j-=2;$k[$j++]="bwipp.GS1couponTooShortSaveValueVLI#3137";$k[$j++]="Coupon too short: Missing Save Value VLI";$k[$j++]=false;return true}var _Y9=$k[$j-1];var _YB=$i($G(_Y9,0,1));$k[$j++]=_YB;if(_YB<1||_YB>5){$j-=2;$k[$j++]="bwipp.GS1couponBadSaveValueVLI#3140";$k[$j++]="Coupon Save Value length indicator must be 1-5";$k[$j++]=false;return true}var _YC=$k[--$j];var _YD=$k[$j-1];$k[$j++]=_YC+1;if(_YC+1>_YD.length){$j-=3;$k[$j++]="bwipp.GS1couponTooShortSaveValue#3144";$k[$j++]="Coupon too short: Save Value truncated";$k[$j++]=false;return true}var _YE=$k[--$j];var _YF=$k[--$j];var _YG=$G(_YF,_YE,$f(_YF.length-_YE));$k[$j++]=_YG;if(_YG.length<1){$j-=2;$k[$j++]="bwipp.GS1couponTooShort1stPurchaseRequirementVLI#3150";$k[$j++]="Coupon too short: Missing 1st Purchase Requirement VLI";$k[$j++]=false;return true}var _YH=$k[$j-1];var _YJ=$i($G(_YH,0,1));$k[$j++]=_YJ;if(_YJ<1||_YJ>5){$j-=2;$k[$j++]="bwipp.GS1couponBad1stPurchaseRequirementVLI#3153";$k[$j++]="Coupon 1st Purchase Requirement length indicator must be 1-5";$k[$j++]=false;return true}var _YK=$k[--$j];var _YL=$k[$j-1];$k[$j++]=_YK+1;if(_YK+1>_YL.length){$j-=3;$k[$j++]="bwipp.GS1couponTooShort1stPurchaseRequirement#3157";$k[$j++]="Coupon too short: 1st Purchase Requirement truncated";$k[$j++]=false;return true}var _YM=$k[--$j];var _YN=$k[--$j];var _YO=$G(_YN,_YM,$f(_YN.length-_YM));$k[$j++]=_YO;if(_YO.length<1){$j-=2;$k[$j++]="bwipp.GS1couponTooShort1stPurchaseRequirementCode#3163";$k[$j++]="Coupon too short: Missing 1st Purchase Requirement Code";$k[$j++]=false;return true}var _YP=$k[$j-1];var _YR=$i($G(_YP,0,1));if(_YR>4&&_YR!=9){$j-=2;$k[$j++]="bwipp.GS1couponBad1stPurchaseRequirementCode#3166";$k[$j++]="Coupon 1st Purchase Requirement Code must be 0-4 or 9";$k[$j++]=false;return true}var _YS=$k[--$j];var _YT=$G(_YS,1,_YS.length-1);$k[$j++]=_YT;if(_YT.length<3){$j-=2;$k[$j++]="bwipp.GS1couponTooShort1stPurchaseFamilyCode#3172";$k[$j++]="Coupon too short: 1st Purchase Family Code truncated";$k[$j++]=false;return true}var _YU=$k[--$j];var _YV=$G(_YU,3,_YU.length-3);$k[$j++]=_YV;if(_YV.length>=1){var _YW=$k[$j-1];if($i($G(_YW,0,1))==1){var _YY=$k[--$j];var _YZ=$G(_YY,1,_YY.length-1);$k[$j++]=_YZ;if(_YZ.length<1){$j-=2;$k[$j++]="bwipp.GS1couponTooShortAdditionalPurchaseRulesCode#3182";$k[$j++]="Coupon too short: Missing Additional Purchase Rules Code";$k[$j++]=false;return true}var _Ya=$k[$j-1];if($i($G(_Ya,0,1))>3){$j-=2;$k[$j++]="bwipp.GS1couponBadAdditionalPurchaseRulesCode#3185";$k[$j++]="Coupon Additional Purchase Rules Code must be 0-3";$k[$j++]=false;return true}var _Yc=$k[--$j];var _Yd=$G(_Yc,1,_Yc.length-1);$k[$j++]=_Yd;if(_Yd.length<1){$j-=2;$k[$j++]="bwipp.GS1couponTooShort2ndPurchaseRequirementVLI#3191";$k[$j++]="Coupon too short: Missing 2nd Purchase Requirement VLI";$k[$j++]=false;return true}var _Ye=$k[$j-1];var _Yg=$i($G(_Ye,0,1));$k[$j++]=_Yg;if(_Yg<1||_Yg>5){$j-=2;$k[$j++]="bwipp.GS1couponBad2ndPurchaseRequirementVLI#3194";$k[$j++]="Coupon 2nd Purchase Requirement length indicator must be 1-5";$k[$j++]=false;return true}var _Yh=$k[--$j];var _Yi=$k[$j-1];$k[$j++]=_Yh+1;if(_Yh+1>_Yi.length){$j-=3;$k[$j++]="bwipp.GS1couponTooShort2ndPurchaseRequirement#3198";$k[$j++]="Coupon too short: 2nd Purchase Requirement truncated";$k[$j++]=false;return true}var _Yj=$k[--$j];var _Yk=$k[--$j];var _Yl=$G(_Yk,_Yj,$f(_Yk.length-_Yj));$k[$j++]=_Yl;if(_Yl.length<1){$j-=2;$k[$j++]="bwipp.GS1couponTooShort2ndPurchaseRequirementCode#3204";$k[$j++]="Coupon too short: Missing 2nd Purchase Requirement Code";$k[$j++]=false;return true}var _Ym=$k[$j-1];var _Yo=$i($G(_Ym,0,1));if(_Yo>4&&_Yo!=9){$j-=2;$k[$j++]="bwipp.GS1couponBad2ndPurchaseRequirementCode#3207";$k[$j++]="Coupon 2nd Purchase Requirement Code must be 0-4 or 9";$k[$j++]=false;return true}var _Yp=$k[--$j];var _Yq=$G(_Yp,1,_Yp.length-1);$k[$j++]=_Yq;if(_Yq.length<3){$j-=2;$k[$j++]="bwipp.GS1couponTooShort2ndPurchaseFamilyCode#3213";$k[$j++]="Coupon too short: 2nd Purchase Family Code truncated";$k[$j++]=false;return true}var _Yr=$k[--$j];var _Ys=$G(_Yr,3,_Yr.length-3);$k[$j++]=_Ys;if(_Ys.length<1){$j-=2;$k[$j++]="bwipp.GS1couponTooShort2ndPurchaseGCPVLI#3219";$k[$j++]="Coupon too short: Missing 2nd Purchase GCP VLI";$k[$j++]=false;return true}var _Yt=$k[$j-1];var _Yv=$i($G(_Yt,0,1));$k[$j++]=_Yv;if(_Yv>6&&_Yv!=9){$j-=2;$k[$j++]="bwipp.GS1couponBad2ndPurchaseGCPVLI#3222";$k[$j++]="Coupon 2nd Purchase GCP length indicator must be 0-6 or 9";$k[$j++]=false;return true}var _Yw=$k[$j-1];if(_Yw!=9){var _Yx=$k[--$j];$k[$j++]=_Yx+6}else{$k[$j-1]=0}var _Yy=$k[--$j];var _Yz=$k[$j-1];$k[$j++]=_Yy+1;if(_Yy+1>_Yz.length){$j-=3;$k[$j++]="bwipp.GS1couponTooShort2ndPurchaseGCP#3226";$k[$j++]="Coupon too short: 2nd Purchase GCP truncated";$k[$j++]=false;return true}var _Z0=$k[--$j];var _Z1=$k[--$j];$k[$j++]=$G(_Z1,_Z0,$f(_Z1.length-_Z0))}}var _Z3=$k[$j-1];if(_Z3.length>=1){var _Z4=$k[$j-1];if($i($G(_Z4,0,1))==2){var _Z6=$k[--$j];var _Z7=$G(_Z6,1,_Z6.length-1);$k[$j++]=_Z7;if(_Z7.length<1){$j-=2;$k[$j++]="bwipp.GS1couponTooShort3rdPurchaseRequirementVLI#3238";$k[$j++]="Coupon too short: Missing 3rd Purchase Requirement VLI";$k[$j++]=false;return true}var _Z8=$k[$j-1];var _ZA=$i($G(_Z8,0,1));$k[$j++]=_ZA;if(_ZA<1||_ZA>5){$j-=2;$k[$j++]="bwipp.GS1couponBad3rdPurchaseRequirementVLI#3241";$k[$j++]="Coupon 3rd Purchase Requirement length indicator must be 1-5";$k[$j++]=false;return true}var _ZB=$k[--$j];var _ZC=$k[$j-1];$k[$j++]=_ZB+1;if(_ZB+1>_ZC.length){$j-=3;$k[$j++]="bwipp.GS1couponTooShort3rdPurchaseRequirement#3245";$k[$j++]="Coupon too short: 3rd Purchase Requirement truncated";$k[$j++]=false;return true}var _ZD=$k[--$j];var _ZE=$k[--$j];var _ZF=$G(_ZE,_ZD,$f(_ZE.length-_ZD));$k[$j++]=_ZF;if(_ZF.length<1){$j-=2;$k[$j++]="bwipp.GS1couponTooShort3rdPurchaseRequirementCode#3251";$k[$j++]="Coupon too short: Missing 3rd Purchase Requirement Code";$k[$j++]=false;return true}var _ZG=$k[$j-1];var _ZI=$i($G(_ZG,0,1));if(_ZI>4&&_ZI!=9){$j-=2;$k[$j++]="bwipp.GS1couponBad3rdPurchaseRequirementCode#3254";$k[$j++]="Coupon 3rd Purchase Requirement Code must be 0-4 or 9";$k[$j++]=false;return true}var _ZJ=$k[--$j];var _ZK=$G(_ZJ,1,_ZJ.length-1);$k[$j++]=_ZK;if(_ZK.length<3){$j-=2;$k[$j++]="bwipp.GS1couponTooShort3rdPurchaseFamilyCode#3260";$k[$j++]="Coupon too short: 3rd Purchase Family Code truncated";$k[$j++]=false;return true}var _ZL=$k[--$j];var _ZM=$G(_ZL,3,_ZL.length-3);$k[$j++]=_ZM;if(_ZM.length<1){$j-=2;$k[$j++]="bwipp.GS1couponTooShort3rdPurchaseGCPVLI#3266";$k[$j++]="Coupon too short: Missing 3rd Purchase GCP VLI";$k[$j++]=false;return true}var _ZN=$k[$j-1];var _ZP=$i($G(_ZN,0,1));$k[$j++]=_ZP;if(_ZP>6&&_ZP!=9){$j-=2;$k[$j++]="bwipp.GS1couponBad3rdPurchaseGCPVLI#3269";$k[$j++]="Coupon 3rd Purchase GCP length indicator must be 0-6 or 9";$k[$j++]=false;return true}var _ZQ=$k[$j-1];if(_ZQ!=9){var _ZR=$k[--$j];$k[$j++]=_ZR+6}else{$k[$j-1]=0}var _ZS=$k[--$j];var _ZT=$k[$j-1];$k[$j++]=_ZS+1;if(_ZS+1>_ZT.length){$j-=3;$k[$j++]="bwipp.GS1couponTooShort3rdPurchaseGCP#3273";$k[$j++]="Coupon too short: 3rd Purchase GCP truncated";$k[$j++]=false;return true}var _ZU=$k[--$j];var _ZV=$k[--$j];$k[$j++]=$G(_ZV,_ZU,$f(_ZV.length-_ZU))}}$_.couponexpire=-1;var _ZX=$k[$j-1];if(_ZX.length>=1){var _ZY=$k[$j-1];if($i($G(_ZY,0,1))==3){var _Za=$k[--$j];var _Zb=$G(_Za,1,_Za.length-1);$k[$j++]=_Zb;if(_Zb.length<6){$j-=2;$k[$j++]="bwipp.GS1couponTooShortExpirationDate#3286";$k[$j++]="Coupon too short: Expiration date";$k[$j++]=false;return true}var _Zc=$k[$j-1];var _Ze=$i($G(_Zc,2,2));if(_Ze<1||_Ze>12){$j-=2;$k[$j++]="bwipp.GS1couponExpirationDateBadMonth#3288";$k[$j++]="Invalid month in expiration date";$k[$j++]=false;return true}var _Zf=$k[$j-1];var _Zh=$i($G(_Zf,0,2));var _Zi=_Zh-21;$k[$j++]=_Zh;$k[$j++]=_Zi;if(_Zi>=51){$j--;var _Zj=$k[--$j];$k[$j++]=_Zj+1900}else{if($k[--$j]<=-50){var _Zl=$k[--$j];$k[$j++]=_Zl+2100}else{var _Zm=$k[--$j];$k[$j++]=_Zm+2e3}}var _Zn=$k[--$j];$k[$j++]=_Zn%400==0||_Zn%4==0&&_Zn%100!=0;$k[$j++]=Infinity;$k[$j++]=31;$r(3,-1);var _Zp=$k[--$j]?29:28;$k[$j++]=_Zp;$k[$j++]=31;$k[$j++]=30;$k[$j++]=31;$k[$j++]=30;$k[$j++]=31;$k[$j++]=31;$k[$j++]=30;$k[$j++]=31;$k[$j++]=30;$k[$j++]=31;var _Zq=$a();var _Zr=$k[$j-1];var _Zv=$i($G(_Zr,4,2));if($g(_Zq,$i($G(_Zr,2,2))-1)<_Zv||_Zv<1){$j-=2;$k[$j++]="bwipp.GS1couponExpirationDateBadDay#3295";$k[$j++]="Invalid day of month in expiration date";$k[$j++]=false;return true}var _Zw=$k[--$j];$_.couponexpire=$i($G(_Zw,0,6));$k[$j++]=$G(_Zw,6,_Zw.length-6)}}var _Zz=$k[$j-1];if(_Zz.length>=1){var _a0=$k[$j-1];if($i($G(_a0,0,1))==4){var _a2=$k[--$j];var _a3=$G(_a2,1,_a2.length-1);$k[$j++]=_a3;if(_a3.length<6){$j-=2;$k[$j++]="bwipp.GS1couponTooShortStartDate#3307";$k[$j++]="Coupon too short: Start date";$k[$j++]=false;return true}var _a4=$k[$j-1];var _a6=$i($G(_a4,2,2));if(_a6<1||_a6>12){$j-=2;$k[$j++]="bwipp.GS1couponStartDateBadMonth#3309";$k[$j++]="Invalid month in start date";$k[$j++]=false;return true}var _a7=$k[$j-1];var _a9=$i($G(_a7,0,2));var _aA=_a9-21;$k[$j++]=_a9;$k[$j++]=_aA;if(_aA>=51){$j--;var _aB=$k[--$j];$k[$j++]=_aB+1900}else{if($k[--$j]<=-50){var _aD=$k[--$j];$k[$j++]=_aD+2100}else{var _aE=$k[--$j];$k[$j++]=_aE+2e3}}var _aF=$k[--$j];$k[$j++]=_aF%400==0||_aF%4==0&&_aF%100!=0;$k[$j++]=Infinity;$k[$j++]=31;$r(3,-1);var _aH=$k[--$j]?29:28;$k[$j++]=_aH;$k[$j++]=31;$k[$j++]=30;$k[$j++]=31;$k[$j++]=30;$k[$j++]=31;$k[$j++]=31;$k[$j++]=30;$k[$j++]=31;$k[$j++]=30;$k[$j++]=31;var _aI=$a();var _aJ=$k[$j-1];var _aN=$i($G(_aJ,4,2));if($g(_aI,$i($G(_aJ,2,2))-1)<_aN||_aN<1){$j-=2;$k[$j++]="bwipp.GS1couponStartDateBadDay#3316";$k[$j++]="Invalid day of month in start date";$k[$j++]=false;return true}var _aO=$k[--$j];$_.couponstart=$i($G(_aO,0,6));$k[$j++]=_aO;if($_.couponexpire!=-1&&$_.couponexpire<$_.couponstart){$j-=2;$k[$j++]="bwipp.GS1couponExpireDateBeforeStartDate#3319";$k[$j++]="Coupon expires before it starts";$k[$j++]=false;return true}var _aT=$k[--$j];$k[$j++]=$G(_aT,6,_aT.length-6)}}var _aV=$k[$j-1];if(_aV.length>=1){var _aW=$k[$j-1];if($i($G(_aW,0,1))==5){var _aY=$k[--$j];var _aZ=$G(_aY,1,_aY.length-1);$k[$j++]=_aZ;if(_aZ.length<1){$j-=2;$k[$j++]="bwipp.GS1couponTooShortSerialNumberVLI#3331";$k[$j++]="Coupon too short: Missing Serial Number VLI";$k[$j++]=false;return true}var _aa=$k[$j-1];var _ab=$G(_aa,0,1);$k[$j++]=$i(_ab)+6+1;if($i(_ab)+6+1>_aa.length){$j-=3;$k[$j++]="bwipp.GS1couponTooShortSerialNumber#3335";$k[$j++]="Coupon too short: Serial Number truncated";$k[$j++]=false;return true}var _ac=$k[--$j];var _ad=$k[--$j];$k[$j++]=$G(_ad,_ac,$f(_ad.length-_ac))}}var _af=$k[$j-1];if(_af.length>=1){var _ag=$k[$j-1];if($i($G(_ag,0,1))==6){var _ai=$k[--$j];var _aj=$G(_ai,1,_ai.length-1);$k[$j++]=_aj;if(_aj.length<1){$j-=2;$k[$j++]="bwipp.GS1couponTooShortRetailerGCPGLNVLI#3347";$k[$j++]="Coupon too short: Missing Retailer GCP/GLN VLI";$k[$j++]=false;return true}var _ak=$k[$j-1];var _am=$i($G(_ak,0,1));$k[$j++]=_am;if(_am<1||_am>7){$j-=2;$k[$j++]="bwipp.GS1couponBadRetailerGCPGLNVLI#3350";$k[$j++]="Coupon Retailer GCP/GLN length indicator must be 1-7";$k[$j++]=false;return true}var _an=$k[--$j];var _ao=$k[$j-1];$k[$j++]=_an+6+1;if(_an+6+1>_ao.length){$j-=3;$k[$j++]="bwipp.GS1couponTooShortRetailerGCPGLN#3354";$k[$j++]="Coupon too short: Retailer GCP/GLN truncated";$k[$j++]=false;return true}var _ap=$k[--$j];var _aq=$k[--$j];$k[$j++]=$G(_aq,_ap,$f(_aq.length-_ap))}}var _as=$k[$j-1];if(_as.length>=1){var _at=$k[$j-1];if($i($G(_at,0,1))==9){var _av=$k[--$j];var _aw=$G(_av,1,_av.length-1);$k[$j++]=_aw;if(_aw.length<1){$j-=2;$k[$j++]="bwipp.GS1couponTooShortSaveValueCode#3366";$k[$j++]="Coupon too short: Missing Save Value Code";$k[$j++]=false;return true}var _ax=$k[$j-1];var _az=$i($G(_ax,0,1));if(_az>6||(_az==3||_az==4)){$j-=2;$k[$j++]="bwipp.GS1couponBadSaveValueCode#3369";$k[$j++]="Coupon Save Value Code must be 0,1,2,5 or 6";$k[$j++]=false;return true}var _b0=$k[--$j];var _b1=$G(_b0,1,_b0.length-1);$k[$j++]=_b1;if(_b1.length<1){$j-=2;$k[$j++]="bwipp.GS1couponTooShortSaveValueAppliesToItem#3375";$k[$j++]="Coupon too short: Missing Save Value Applies to Item";$k[$j++]=false;return true}var _b2=$k[$j-1];if($i($G(_b2,0,1))>2){$j-=2;$k[$j++]="bwipp.GS1couponBadSaveValueAppliesToItem#3378";$k[$j++]="Coupon Save Value Applies to Item must be 0-2";$k[$j++]=false;return true}var _b4=$k[--$j];var _b5=$G(_b4,1,_b4.length-1);$k[$j++]=_b5;if(_b5.length<1){$j-=2;$k[$j++]="bwipp.GS1couponTooShortStoreCouponFlag#3384";$k[$j++]="Coupon too short: Missing Store Coupon Flag";$k[$j++]=false;return true}var _b6=$k[--$j];var _b7=$G(_b6,1,_b6.length-1);$k[$j++]=_b7;if(_b7.length<1){$j-=2;$k[$j++]="bwipp.GS1couponTooShortDontMultiplyFlag#3390";$k[$j++]="Coupon too short: Missing Don't Multiply Flag";$k[$j++]=false;return true}var _b8=$k[$j-1];if($i($G(_b8,0,1))>1){$j-=2;$k[$j++]="bwipp.GS1couponBadDontMultiplyFlag#3393";$k[$j++]="Don't Multiply Flag must be 0 or 1";$k[$j++]=false;return true}var _bA=$k[--$j];$k[$j++]=$G(_bA,1,_bA.length-1)}}var _bC=$k[$j-1];if(_bC.length!=0){$j-=2;$k[$j++]="bwipp.GS1couponUnrecognisedOptionalField#3400";$k[$j++]="Coupon fields must be 1,2,3,4,5,6 or 9, increasing order";$k[$j++]=false;return true}$j--};$_.lintcouponposoffer=function(){var _bD=$k[$j-1];$k[$j++]=true;$F(_bD,function(){var _bE=$k[--$j];if(_bE<48||_bE>57){$k[$j-1]=false;return true}});if(!$k[--$j]){$j-=2;$k[$j++]="bwipp.GS1couponNotNumeric#3409";$k[$j++]="Coupon not numeric";$k[$j++]=false;return true}var _bG=$k[$j-1];if(_bG.length<1){$j-=2;$k[$j++]="bwipp.GS1couponTooShortFormatCode#3412";$k[$j++]="Coupon too short: Missing Format Code";$k[$j++]=false;return true}var _bH=$k[$j-1];var _bI=$G(_bH,0,1);if($ne(_bI,"0")&&$ne(_bI,"1")){$j-=2;$k[$j++]="bwipp.GS1couponBadFormatCode#3415";$k[$j++]="Coupon format must be 0 or 1";$k[$j++]=false;return true}var _bJ=$k[--$j];var _bK=$G(_bJ,1,_bJ.length-1);$k[$j++]=_bK;if(_bK.length<1){$j-=2;$k[$j++]="bwipp.GS1couponTooShortFunderVLI#3420";$k[$j++]="Coupon too short: Missing Funder VLI";$k[$j++]=false;return true}var _bL=$k[$j-1];var _bN=$i($G(_bL,0,1));$k[$j++]=_bN;if(_bN>6){$j-=3;$k[$j++]="bwipp.GS1couponBadFunderVLI#3423";$k[$j++]="Coupon Funder length indicator must be 0-6";$k[$j++]=false;return true}var _bO=$k[--$j];var _bP=$k[$j-1];$k[$j++]=_bO+6+1;if(_bO+6+1>_bP.length){$j-=3;$k[$j++]="bwipp.GS1couponTooShortFunder#3427";$k[$j++]="Coupon too short: Truncated Funder ID";$k[$j++]=false;return true}var _bQ=$k[--$j];var _bR=$k[--$j];var _bS=$G(_bR,_bQ,$f(_bR.length-_bQ));$k[$j++]=_bS;if(_bS.length<6){$j-=2;$k[$j++]="bwipp.GS1couponTooShortOfferCode#3432";$k[$j++]="Coupon too short: Truncated Offer Code";$k[$j++]=false;return true}var _bT=$k[--$j];var _bU=$G(_bT,6,_bT.length-6);$k[$j++]=_bU;if(_bU.length<1){$j-=2;$k[$j++]="bwipp.GS1couponTooShortSnVLI#3437";$k[$j++]="Coupon too short: Missing SN VLI";$k[$j++]=false;return true}var _bV=$k[$j-1];var _bW=$G(_bV,0,1);$k[$j++]=$i(_bW)+6+1;if($i(_bW)+6+1>_bV.length){$j-=3;$k[$j++]="bwipp.GS1couponTooShortSn#3442";$k[$j++]="Coupon too short: Truncated SN";$k[$j++]=false;return true}var _bX=$k[--$j];var _bY=$k[--$j];var _bZ=$G(_bY,_bX,$f(_bY.length-_bX));$k[$j++]=_bZ;if(_bZ.length!=0){$j-=2;$k[$j++]="bwipp.GS1couponTooLong#3446";$k[$j++]="Coupon too long";$k[$j++]=false;return true}$j--};$_.lintlatitude=function(){var _ba=$k[$j-1];if(_ba.length!=10){$j--;$k[$j++]="bwipp.GS1badLatitudeLength#3453";$k[$j++]="Invalid length for a latitude";$k[$j++]=false;return true}if($i($k[--$j])>$i("1800000000")){$j--;$k[$j++]="bwipp.GS1badLatitude#3457";$k[$j++]="Invalid value for latitude";$k[$j++]=false;return true}};$_.lintlongitude=function(){var _bc=$k[$j-1];if(_bc.length!=10){$j--;$k[$j++]="bwipp.GS1badLongitudeLength#3462";$k[$j++]="Invalid length for a longitude";$k[$j++]=false;return true}if($i($k[--$j])>$i("3600000000")){$j--;$k[$j++]="bwipp.GS1badLongitude#3467";$k[$j++]="Invalid value for longitude";$k[$j++]=false;return true}};$k[$j++]=Infinity;var _be=$a(["01","02","03","04","05","06","07","08","09","10","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95","96","97","98","99"]);for(var _bf=0,_bg=_be.length;_bf<_bg;_bf++){var _bh=$g(_be,_bf);$k[$j++]=_bh;$k[$j++]=_bh}$_.aidcmediatype=$d();$_.lintmediatype=function(){var _bm=$g($_.aidcmediatype,$k[--$j])!==undefined;if(!_bm){$j--;$k[$j++]="bwipp.GS1UnknownMediaType#3479";$k[$j++]="Unknown AIDC media type";$k[$j++]=false;return true}};$k[$j++]=Infinity;var _bn=$a(["1A","1B","1D","1F","1G","1W","200","201","202","203","204","205","206","210","211","212","2C","3A","3H","43","44","4A","4B","4C","4D","4F","4G","4H","5H","5L","5M","6H","6P","7A","7B","8","8A","8B","8C","9","AA","AB","AC","AD","AF","AG","AH","AI","AJ","AL","AM","AP","APE/AT","AV","B4","BB","BC","BD","BE","BF","BG","BGE","BH","BI","BJ","BK","BL","BM","BME","BN","BO","BP","BQ","BR","BRI","BS","BT","BU","BV","BW","BX","BY","BZ","CA","CB","CBL","CC","CCE","CD","CE","CF","CG","CH","CI","CJ","CK","CL","CM","CN","CO","CP","CQ","CR","CS","CT","CU","CV","CW","CX","CY","CZ","DA","DB","DC","DG","DH","DI","DJ","DK","DL","DM","DN","DP","DPE","DR","DS","DT","DU","DV","DW","DX","DY","E1","E2","E3","EC","ED","EE","EF","EG","EH","EI","EN","FB","FC","FD","FE","FI","FL","FO","FOB","FP","FPE","FR","FT","FW","FX","GB","GI","GL","GR","GU","GY","GZ","HA","HB","HC","HG","HN","HR","IA","IB","IC","ID","IE","IF","IG","IH","IK","IL","IN","IZ","JB","JC","JG","JR","JT","JY","KG","KI","LAB","LE","LG","LT","LU","LV","LZ","MA","MB","MC","ME","MPE","MR","MS","MT","MW","MX","NA","NE","NF","NG","NS","NT","NU","NV","OA","OB","OC","OD","OE","OF","OK","OPE","OT","OU","P2","PA","PAE","PB","PC","PD","PE","PF","PG","PH","PI","PJ","PK","PL","PLP","PN","PO","POP","PP","PPE","PR","PT","PU","PUE","PV","PX","PY","PZ","QA","QB","QC","QD","QF","QG","QH","QJ","QK","QL","QM","QN","QP","QQ","QR","QS","RB1","RB2","RB3","RCB","RD","RG","RJ","RK","RL","RO","RT","RZ","S1","SA","SB","SC","SD","SE","SEC","SH","SI","SK","SL","SM","SO","SP","SS","ST","STL","SU","SV","SW","SX","SY","SZ","T1","TB","TC","TD","TE","TEV","TG","THE","TI","TK","TL","TN","TO","TR","TRE","TS","TT","TTE","TU","TV","TW","TWE","TY","TZ","UC","UN","UUE","VA","VG","VI","VK","VL","VN","VO","VP","VQ","VR","VS","VY","WA","WB","WC","WD","WF","WG","WH","WJ","WK","WL","WM","WN","WP","WQ","WR","WRP","WS","WT","WU","WV","WW","WX","WY","WZ","X11","X12","X15","X16","X17","X18","X19","X20","X3","XA","XB","XC","XD","XF","XG","XH","XJ","XK","YA","YB","YC","YD","YF","YG","YH","YJ","YK","YL","YM","YN","YP","YQ","YR","YS","YT","YV","YW","YX","YY","YZ","ZA","ZB","ZC","ZD","ZF","ZG","ZH","ZJ","ZK","ZL","ZM","ZN","ZP","ZQ","ZR","ZS","ZT","ZU","ZV","ZW","ZX","ZY","ZZ"]);for(var _bo=0,_bp=_bn.length;_bo<_bp;_bo++){var _bq=$g(_bn,_bo);$k[$j++]=_bq;$k[$j++]=_bq}$_.packagetype=$d();$_.lintpackagetype=function(){var _bv=$g($_.packagetype,$k[--$j])!==undefined;if(!_bv){$j--;$k[$j++]="bwipp.GS1unknownPackageType#3523";$k[$j++]="Unknown package type";$k[$j++]=false;return true}};if(!$_.dontlint){$k[$j++]=true;for(var _bz=0,_by=$_.vals.length-1;_bz<=_by;_bz+=1){$_.ai=$g($_.ais,_bz);$_.val=$g($_.vals,_bz);var _c6=$g($_.gs1syntax,$_.ai)!==undefined;if(_c6){var _cA=$g($g($_.gs1syntax,$_.ai),"parts");$k[$j++]=_cA;$k[$j++]=0;$F(_cA,function(){var _cB=$k[$j-1];if($g(_cB,"opt")){$k[$j-1]=0}else{var _cE=$g($k[--$j],"min");$k[$j++]=_cE}var _cF=$k[--$j];var _cG=$k[--$j];$k[$j++]=$f(_cG+_cF)});if($k[--$j]>$_.val.length){$j--;$k[$j++]="bwipp.GS1valueTooShort#3537";$k[$j++]="Too short";$k[$j++]=false;break}var _cJ=$k[$j-1];$k[$j++]=0;$F(_cJ,function(){var _cL=$g($k[--$j],"max");var _cM=$k[--$j];$k[$j++]=$f(_cM+_cL)});if($k[--$j]<$_.val.length){$j--;$k[$j++]="bwipp.GS1valueTooLong#3540";$k[$j++]="Too long";$k[$j++]=false;break}$F($k[--$j],function(){$_.props=$k[--$j];var _cS=$g($_.props,"max");var _cT=$_.val;var _cU=_cT.length;if(_cS>_cT.length){var _=_cU;_cU=_cS;_cS=_}$_.eval=$G($_.val,0,_cS);var _cZ=$_.eval.length;$_.val=$G($_.val,_cZ,$_.val.length-_cZ);if($_.eval.length==0){if(!$g($_.props,"opt")){$j--;$k[$j++]="bwipp.GS1valueTooShort#3549";$k[$j++]="Too short";$k[$j++]=false;return true}}else{if($_.eval.length<$g($_.props,"min")){$j--;$k[$j++]="bwipp.GS1valueTooShort#3553";$k[$j++]="Too short";$k[$j++]=false;return true}var _ci=new Map([["N","lintnumeric"],["X","lintcset82"],["Y","lintcset39"],["Z","lintcset64"]]);$k[$j++]=$_.eval;if($_[$g(_ci,$g($_.props,"cset"))]()===true){return true}$F($g($_.props,"linters"),function(){var _cs=$_[$k[--$j]];$k[$j++]=$_.eval;if(_cs()===true){return true}})}});var _ct=$k[$j-1];if(!_ct){break}if($_.val.length!=0){$j--;$k[$j++]="bwipp.GS1valueTooLong#3562";$k[$j++]="Too long";$k[$j++]=false;break}}else{$j--;$k[$j++]="bwipp.GS1unknownAI#3565";$k[$j++]="Unrecognised AI";$k[$j++]=false;break}}if(!$k[--$j]){var _cw=$k[--$j];var _cy=$s(_cw.length+$_.ai.length+5);$P(_cy,0,"AI ");$P(_cy,3,$_.ai);$P(_cy,3+$_.ai.length,": ");$P(_cy,5+$_.ai.length,_cw);$k[$j++]=_cy;bwipp_raiseerror()}$_.aiexists=function(){$_.this=$k[--$j];$_.patt=$k[--$j];for(var _d4=0;_d4<1;_d4++){var _d7=$g($_.aivals,$_.patt)!==undefined;if(_d7){$k[$j++]=true;break}if($_.patt.length==4){if($eq($G($_.patt,3,1),"n")){var _dD=$eq($G($_.patt,2,1),"n")?2:3;$_.pfxlen=_dD;var _dE=$_.ais;$k[$j++]=false;for(var _dF=0,_dG=_dE.length;_dF<_dG;_dF++){var _dH=$g(_dE,_dF);$k[$j++]=_dH;if($ne(_dH,$_.this)&&_dH.length==4){if($eq($G($k[--$j],0,$_.pfxlen),$G($_.patt,0,$_.pfxlen))){$k[$j-1]=true}}else{$j--}}break}$k[$j++]=false;break}$k[$j++]=false;break}};var _dP=$_.vals;$_.aivals=new Map;for(var _dS=0,_dR=$_.vals.length-1;_dS<=_dR;_dS+=1){$_.ai=$g($_.ais,_dS);$_.val=$g($_.vals,_dS);var _dZ=$g($_.aivals,$_.ai)!==undefined;if(_dZ){if($ne($g($_.aivals,$_.ai),$_.val)){var _df=$s($_.ai.length+40);$P(_df,0,"Repeated AIs (");$P(_df,14,$_.ai);$P(_df,14+$_.ai.length,") must have the same value");$k[$j++]="bwipp.GS1repeatedDifferingAIs#3615";$k[$j++]=_df;bwipp_raiseerror()}}else{$p($_.aivals,$_.ai,$_.val)}}for(var _dn=0,_dm=$_.vals.length-1;_dn<=_dm;_dn+=1){$_.ai=$g($_.ais,_dn);var _ds=$g($_.gs1syntax,$_.ai);var _dt=$g(_ds,"ex")!==undefined;$k[$j++]=_ds;$k[$j++]="ex";if(_dt){var _du=$k[--$j];$F($g($k[--$j],_du),function(){$_.patt=$k[--$j];$k[$j++]=$_.patt;$k[$j++]=$_.ai;$_.aiexists();if($k[--$j]){var _e3=$s($_.ai.length+$_.patt.length+36);$P(_e3,0,"AIs (");$P(_e3,5,$_.ai);$P(_e3,5+$_.ai.length,") and (");$P(_e3,12+$_.ai.length,$_.patt);$P(_e3,12+$_.ai.length+$_.patt.length,") are mutually exclusive");$k[$j++]="bwipp.GS1exclusiveAIs#3635";$k[$j++]=_e3;bwipp_raiseerror()}})}else{$j-=2}if($_.lintreqs){var _eD=$g($_.gs1syntax,$_.ai);var _eE=$g(_eD,"req")!==undefined;$k[$j++]=_eD;$k[$j++]="req";if(_eE){var _eF=$k[--$j];$F($g($k[--$j],_eF),function(){var _eI=$k[--$j];$k[$j++]=false;$F(_eI,function(){var _eJ=$k[--$j];$k[$j++]=true;$F(_eJ,function(){$k[$j++]=$_.ai;$_.aiexists();if(!$k[--$j]){$k[$j-1]=false}});if($k[--$j]){$k[$j-1]=true;return true}});if(!$k[--$j]){$k[$j++]=Infinity;$F($g($g($_.gs1syntax,$_.ai),"req"),function(){$F($k[--$j],function(){$F($k[--$j],function(){$k[$j++]="+"});$k[$j-1]=" OR "});$k[$j-1]=" WITH "});$j--;var _eU=$a();$k[$j++]=_eU;$k[$j++]=0;for(var _eV=0,_eW=_eU.length;_eV<_eW;_eV++){var _eY=$k[--$j];$k[$j++]=$f(_eY+$g(_eU,_eV).length)}var _ea=$_.ai.length+49;$k[$j++]=_ea;$k[$j++]=_ea;var _eb=$k[$j-3];var _ed=$s($f($k[$j-1]+_eb));var _ee=$k[$j-2];$j-=3;$k[$j++]=_ed;$k[$j++]=_ee;$r(3,-1);$F($k[--$j],function(){var _eg=$k[--$j];var _eh=$k[--$j];var _ei=$k[$j-1];$P(_ei,_eh,_eg);$k[$j++]=$f(_eg.length+_eh)});$j--;var _ej=$k[--$j];$P(_ej,0,"One of more requisite AIs for AI (");$P(_ej,34,$_.ai);$P(_ej,34+$_.ai.length,") are missing: ");$k[$j++]="bwipp.GS1missingAIs#3662";$k[$j++]=_ej;bwipp_raiseerror()}})}else{$j-=2}}}}$k[$j++]=$_.ais;$k[$j++]=$_.vals;$k[$j++]=$_.fncs;$_=$__}function bwipp_ean5(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.includetext=false;$_.textfont="OCR-B";$_.textsize=12;$_.textxoffset=0;$_.textyoffset=null;$_.height=.7;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.textyoffset==null){$_.textyoffset=$_.height*72+1}if($_.barcode.length!=5){$k[$j++]="bwipp.ean5badLength#4997";$k[$j++]="EAN-5 add-on must be 5 digits";bwipp_raiseerror()}$F($_.barcode,function(){var _6=$k[--$j];if(_6<48||_6>57){$k[$j++]="bwipp.ean5badCharacter#5001";$k[$j++]="EAN-5 add-on must contain only digits";bwipp_raiseerror()}});$_.encs=$a(["3211","2221","2122","1411","1132","1231","1114","1312","1213","3112","112","11"]);$_.barchars="0123456789";$_.mirrormaps=$a(["11000","10100","10010","10001","01100","00110","00011","01010","01001","00101"]);$_.checksum=0;for(var _A=0;_A<=4;_A+=1){$_.i=_A;$_.barchar=$g($_.barcode,$_.i)-48;if($_.i%2==0){$_.checksum=$f($_.barchar*3+$_.checksum)}else{$_.checksum=$f($_.barchar*9+$_.checksum)}}$_.checksum=$_.checksum%10;$_.mirrormap=$g($_.mirrormaps,$_.checksum);$_.sbs=$s(31);$_.txt=$a(5);for(var _P=0;_P<=4;_P+=1){$_.i=_P;if($_.i==0){$P($_.sbs,0,$g($_.encs,10))}else{$P($_.sbs,($_.i-1)*6+7,$g($_.encs,11))}$X($_.barchars,$G($_.barcode,$_.i,1));$j--;$_.indx=$k[--$j].length;$j-=2;$_.enc=$g($_.encs,$_.indx);if($g($_.mirrormap,$_.i)==49){$_.enclen=$_.enc.length;$_.revenc=$s($_.enclen);for(var _o=0,_n=$_.enclen-1;_o<=_n;_o+=1){$_.j=_o;$_.char=$g($_.enc,$_.j);$p($_.revenc,$_.enclen-$_.j-1,$_.char)}$_.enc=$_.revenc}$P($_.sbs,$_.i*6+3,$_.enc);$p($_.txt,$_.i,$a([$G($_.barcode,$_.i,1),($_.i-1)*9+10+$_.textxoffset,$_.textyoffset,$_.textfont,$_.textsize]))}$k[$j++]=Infinity;$k[$j++]=Infinity;var _1B=$_.sbs;for(var _1C=0,_1D=_1B.length;_1C<_1D;_1C++){$k[$j++]=$g(_1B,_1C)-48}var _1F=$a();$k[$j++]=Infinity;for(var _1G=0;_1G<16;_1G++){$k[$j++]=$_.height}var _1I=$a();$k[$j++]=Infinity;for(var _1J=0;_1J<16;_1J++){$k[$j++]=0}var _1K=$a();$k[$j++]="ren";$k[$j++]="renlinear";$k[$j++]="sbs";$k[$j++]=_1F;$k[$j++]="bhs";$k[$j++]=_1I;$k[$j++]="bbs";$k[$j++]=_1K;if($_.includetext){$k[$j++]="txt";$k[$j++]=$_.txt}$k[$j++]="opt";$k[$j++]=$_.options;$k[$j++]="guardrightpos";$k[$j++]=5;$k[$j++]="guardrightypos";$k[$j++]=$_.textyoffset+4;$k[$j++]="borderleft";$k[$j++]=12;$k[$j++]="borderright";$k[$j++]=5;$k[$j++]="bordertop";$k[$j++]=10;var _1P=$d();$k[$j++]=_1P;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_ean2(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.includetext=false;$_.textfont="OCR-B";$_.textsize=12;$_.textxoffset=0;$_.textyoffset=null;$_.height=.7;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.textyoffset==null){$_.textyoffset=$_.height*72+1}if($_.barcode.length!=2){$k[$j++]="bwipp.ean2badLength#5142";$k[$j++]="EAN-2 add-on must be 2 digits";bwipp_raiseerror()}$F($_.barcode,function(){var _6=$k[--$j];if(_6<48||_6>57){$k[$j++]="bwipp.ean2badCharacter#5146";$k[$j++]="EAN-2 add-on must contain only digits";bwipp_raiseerror()}});$_.encs=$a(["3211","2221","2122","1411","1132","1231","1114","1312","1213","3112","112","11"]);$_.barchars="0123456789";$_.mirrormaps=$a(["00","01","10","11"]);$_.mirrormap=$g($_.mirrormaps,$i($G($_.barcode,0,2))%4);$_.sbs=$s(13);$_.txt=$a(2);for(var _G=0;_G<=1;_G+=1){$_.i=_G;if($_.i==0){$P($_.sbs,0,$g($_.encs,10))}else{$P($_.sbs,($_.i-1)*6+7,$g($_.encs,11))}$X($_.barchars,$G($_.barcode,$_.i,1));$j--;$_.indx=$k[--$j].length;$j-=2;$_.enc=$g($_.encs,$_.indx);if($g($_.mirrormap,$_.i)==49){$_.enclen=$_.enc.length;$_.revenc=$s($_.enclen);for(var _f=0,_e=$_.enclen-1;_f<=_e;_f+=1){$_.j=_f;$_.char=$g($_.enc,$_.j);$p($_.revenc,$_.enclen-$_.j-1,$_.char)}$_.enc=$_.revenc}$P($_.sbs,$_.i*6+3,$_.enc);$p($_.txt,$_.i,$a([$G($_.barcode,$_.i,1),($_.i-1)*9+10+$_.textxoffset,$_.textyoffset,$_.textfont,$_.textsize]))}$k[$j++]=Infinity;$k[$j++]=Infinity;var _12=$_.sbs;for(var _13=0,_14=_12.length;_13<_14;_13++){$k[$j++]=$g(_12,_13)-48}var _16=$a();$k[$j++]=Infinity;for(var _17=0;_17<12;_17++){$k[$j++]=$_.height}var _19=$a();$k[$j++]=Infinity;for(var _1A=0;_1A<12;_1A++){$k[$j++]=0}var _1B=$a();$k[$j++]="ren";$k[$j++]="renlinear";$k[$j++]="sbs";$k[$j++]=_16;$k[$j++]="bhs";$k[$j++]=_19;$k[$j++]="bbs";$k[$j++]=_1B;if($_.includetext){$k[$j++]="txt";$k[$j++]=$_.txt}$k[$j++]="opt";$k[$j++]=$_.options;$k[$j++]="guardrightpos";$k[$j++]=5;$k[$j++]="guardrightypos";$k[$j++]=$_.textyoffset+4;$k[$j++]="borderleft";$k[$j++]=12;$k[$j++]="borderright";$k[$j++]=5;$k[$j++]="bordertop";$k[$j++]=10;var _1G=$d();$k[$j++]=_1G;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_ean13(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.includetext=false;$_.textfont="OCR-B";$_.textsize=12;$_.textxoffset=-11;$_.textyoffset=-4;$_.height=1;$_.addongap=12;$_.addontextfont="unset";$_.addontextsize=null;$_.addontextxoffset=null;$_.addontextyoffset=null;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];$X($_.barcode," ");if($k[--$j]){$_.barcode=$k[--$j];$j--;$_.addon=$k[--$j]}else{$j--;$_.addon=""}if($_.barcode.length!=12&&$_.barcode.length!=13){$k[$j++]="bwipp.ean13badLength#5286";$k[$j++]="EAN-13 must be 12 or 13 digits";bwipp_raiseerror()}$F($_.barcode,function(){var _9=$k[--$j];if(_9<48||_9>57){$k[$j++]="bwipp.ean13badCharacter#5290";$k[$j++]="EAN-13 must contain only digits";bwipp_raiseerror()}});if($_.addon.length!=0&&$_.addon.length!=2&&$_.addon.length!=5){$k[$j++]="bwipp.ean13badAddOnLength#5294";$k[$j++]="Add-on for EAN-13 must be 2 or 5 digits";bwipp_raiseerror()}$_.pad=$s(13);$_.checksum=0;for(var _E=0;_E<=11;_E+=1){$_.i=_E;$_.barchar=$g($_.barcode,$_.i)-48;if($_.i%2==0){$_.checksum=$f($_.barchar+$_.checksum)}else{$_.checksum=$f($_.barchar*3+$_.checksum)}}$_.checksum=(10-$_.checksum%10)%10;if($_.barcode.length==13){if($g($_.barcode,12)!=$_.checksum+48){$k[$j++]="bwipp.ean13badCheckDigit#5312";$k[$j++]="Incorrect EAN-13 check digit provided";bwipp_raiseerror()}}$P($_.pad,0,$_.barcode);$p($_.pad,12,$_.checksum+48);$_.barcode=$_.pad;$_.encs=$a(["3211","2221","2122","1411","1132","1231","1114","1312","1213","3112","111","11111","111"]);$_.barchars="0123456789";$_.mirrormaps=$a(["000000","001011","001101","001110","010011","011001","011100","010101","010110","011010"]);$_.sbs=$s(59);$_.txt=$a(13);$P($_.sbs,0,$g($_.encs,10));$_.mirrormap=$g($_.mirrormaps,$g($_.barcode,0)-48);$p($_.txt,0,$a([$G($_.barcode,0,1),$_.textxoffset,$_.textyoffset,$_.textfont,$_.textsize]));for(var _r=1;_r<=6;_r+=1){$_.i=_r;$X($_.barchars,$G($_.barcode,$_.i,1));$j--;$_.indx=$k[--$j].length;$j-=2;$_.enc=$g($_.encs,$_.indx);if($g($_.mirrormap,$_.i-1)==49){$_.enclen=$_.enc.length;$_.revenc=$s($_.enclen);for(var _18=0,_17=$_.enclen-1;_18<=_17;_18+=1){$_.j=_18;$_.char=$g($_.enc,$_.j);$p($_.revenc,$_.enclen-$_.j-1,$_.char)}$_.enc=$_.revenc}$P($_.sbs,($_.i-1)*4+3,$_.enc);$p($_.txt,$_.i,$a([$G($_.barcode,$_.i,1),($_.i-1)*7+15+$_.textxoffset,$_.textyoffset,$_.textfont,$_.textsize]))}$P($_.sbs,(7-1)*4+3,$g($_.encs,11));for(var _1Y=7;_1Y<=12;_1Y+=1){$_.i=_1Y;$X($_.barchars,$G($_.barcode,$_.i,1));$j--;$_.indx=$k[--$j].length;$j-=2;$_.enc=$g($_.encs,$_.indx);$P($_.sbs,($_.i-1)*4+8,$_.enc);$p($_.txt,$_.i,$a([$G($_.barcode,$_.i,1),($_.i-1)*7+19+$_.textxoffset,$_.textyoffset,$_.textfont,$_.textsize]))}$P($_.sbs,56,$g($_.encs,12));$k[$j++]=Infinity;var _1y=$_.sbs;for(var _1z=0,_20=_1y.length;_1z<_20;_1z++){$k[$j++]=$g(_1y,_1z)-48}$_.sbs=$a();if($_.includetext){$k[$j++]=Infinity;$k[$j++]=$_.height;$k[$j++]=$_.height;for(var _26=0;_26<12;_26++){$k[$j++]=$f($_.height-.075)}$k[$j++]=$_.height;$k[$j++]=$_.height;for(var _2A=0;_2A<12;_2A++){$k[$j++]=$f($_.height-.075)}$k[$j++]=$_.height;$k[$j++]=$_.height;$_.bhs=$a();$k[$j++]=Infinity;$k[$j++]=0;$k[$j++]=0;for(var _2F=0;_2F<12;_2F++){$k[$j++]=.075}$k[$j++]=0;$k[$j++]=0;for(var _2G=0;_2G<12;_2G++){$k[$j++]=.075}$k[$j++]=0;$k[$j++]=0;$_.bbs=$a()}else{$k[$j++]=Infinity;for(var _2I=0;_2I<30;_2I++){$k[$j++]=$_.height}$_.bhs=$a();$k[$j++]=Infinity;for(var _2L=0;_2L<30;_2L++){$k[$j++]=0}$_.bbs=$a();$_.txt=$a([])}$_.guardrightypos=0;if($_.addon.length!=0){$k[$j++]=Infinity;$k[$j++]="dontdraw";$k[$j++]=true;$k[$j++]="includetext";$k[$j++]=true;$k[$j++]="height";$k[$j++]=$_.height;if($_.includetext){var _2R=$k[--$j];$k[$j++]=$f(_2R-.15)}$k[$j++]="textxoffset";if($_.addontextxoffset!=null){$k[$j++]=$_.addontextxoffset}else{$k[$j++]=95+$_.addongap}if($_.addontextyoffset!=null){$k[$j++]="textyoffset";$k[$j++]=$_.addontextyoffset}$k[$j++]="textsize";if($_.addontextsize!=null){$k[$j++]=$_.addontextsize}else{$k[$j++]=$_.textsize}var _2b=$ne($_.addontextfont,"unset")?$_.addontextfont:$_.textfont;$k[$j++]="textfont";$k[$j++]=_2b;$_.addopts=$d();if($_.addon.length==2){$k[$j++]=$_.addon;$k[$j++]=$_.addopts;bwipp_ean2()}if($_.addon.length==5){$k[$j++]=$_.addon;$k[$j++]=$_.addopts;bwipp_ean5()}$_.addcode=$k[--$j];$k[$j++]=Infinity;$q($_.sbs);$k[$j++]=$_.addongap;$q($g($_.addcode,"sbs"));$_.sbs=$a();$k[$j++]=Infinity;$q($_.bhs);$q($g($_.addcode,"bhs"));$_.bhs=$a();$k[$j++]=Infinity;$q($_.bbs);$q($g($_.addcode,"bbs"));$_.bbs=$a();$k[$j++]=Infinity;$q($_.txt);$q($g($_.addcode,"txt"));$_.txt=$a();$_.guardrightypos=$_.height*72-6}$k[$j++]=Infinity;$k[$j++]="ren";$k[$j++]="renlinear";$k[$j++]="sbs";$k[$j++]=$_.sbs;$k[$j++]="bhs";$k[$j++]=$_.bhs;$k[$j++]="bbs";$k[$j++]=$_.bbs;$k[$j++]="txt";$k[$j++]=$_.txt;$k[$j++]="opt";$k[$j++]=$_.options;$k[$j++]="guardrightpos";if($_.addon.length==0){$k[$j++]=7}else{$k[$j++]=5}$k[$j++]="guardrightypos";$k[$j++]=$_.guardrightypos;$k[$j++]="borderleft";$k[$j++]=11;$k[$j++]="borderright";if($_.addon.length==0){$k[$j++]=7}else{$k[$j++]=5}$k[$j++]="bordertop";$k[$j++]=0;$k[$j++]="borderbottom";$k[$j++]=5;var _3A=$d();$k[$j++]=_3A;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_ean8(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.includetext=false;$_.textfont="OCR-B";$_.textsize=12;$_.textxoffset=4;$_.textyoffset=-4;$_.height=1;$_.permitaddon=false;$_.addongap=12;$_.addontextfont="unset";$_.addontextsize=null;$_.addontextxoffset=null;$_.addontextyoffset=null;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];$X($_.barcode," ");if($k[--$j]){$_.barcode=$k[--$j];$j--;$_.addon=$k[--$j]}else{$j--;$_.addon=""}if($_.barcode.length!=7&&$_.barcode.length!=8){$k[$j++]="bwipp.ean8badLength#5507";$k[$j++]="EAN-8 must be 7 or 8 digits";bwipp_raiseerror()}$F($_.barcode,function(){var _9=$k[--$j];if(_9<48||_9>57){$k[$j++]="bwipp.ean8badCharacter#5511";$k[$j++]="EAN-8 must contain only digits";bwipp_raiseerror()}});if($_.addon.length!=0&&$_.addon.length!=2&&$_.addon.length!=5){$k[$j++]="bwipp.ean8badAddOnLength#5515";$k[$j++]="Add-on for EAN-8 must be 2 or 5 digits";bwipp_raiseerror()}if(!$_.permitaddon&&$_.addon.length!=0){$k[$j++]="bwipp.ean8badAddOnLength#5518";$k[$j++]='Non-standard use of add-on for EAN-8 requires "permitaddon" option';bwipp_raiseerror()}$_.pad=$s(8);$_.checksum=0;for(var _G=0;_G<=6;_G+=1){$_.i=_G;$_.barchar=$g($_.barcode,$_.i)-48;if($_.i%2!=0){$_.checksum=$f($_.barchar+$_.checksum)}else{$_.checksum=$f($_.barchar*3+$_.checksum)}}$_.checksum=(10-$_.checksum%10)%10;if($_.barcode.length==8){if($g($_.barcode,7)!=$_.checksum+48){$k[$j++]="bwipp.ean8badCheckDigit#5536";$k[$j++]="Incorrect EAN-8 check digit provided";bwipp_raiseerror()}}$P($_.pad,0,$_.barcode);$p($_.pad,7,$_.checksum+48);$_.barcode=$_.pad;$_.encs=$a(["3211","2221","2122","1411","1132","1231","1114","1312","1213","3112","111","11111","111"]);$_.barchars="0123456789";$_.sbs=$s(43);$_.txt=$a(8);$P($_.sbs,0,$g($_.encs,10));for(var _g=0;_g<=3;_g+=1){$_.i=_g;$X($_.barchars,$G($_.barcode,$_.i,1));$j--;$_.indx=$k[--$j].length;$j-=2;$_.enc=$g($_.encs,$_.indx);$P($_.sbs,$_.i*4+3,$_.enc);$p($_.txt,$_.i,$a([$G($_.barcode,$_.i,1),$_.i*7+$_.textxoffset,$_.textyoffset,$_.textfont,$_.textsize]))}$P($_.sbs,4*4+3,$g($_.encs,11));for(var _16=4;_16<=7;_16+=1){$_.i=_16;$X($_.barchars,$G($_.barcode,$_.i,1));$j--;$_.indx=$k[--$j].length;$j-=2;$_.enc=$g($_.encs,$_.indx);$P($_.sbs,$_.i*4+8,$_.enc);$p($_.txt,$_.i,$a([$G($_.barcode,$_.i,1),$_.i*7+$_.textxoffset+4,$_.textyoffset,$_.textfont,$_.textsize]))}$P($_.sbs,40,$g($_.encs,12));$k[$j++]=Infinity;var _1W=$_.sbs;for(var _1X=0,_1Y=_1W.length;_1X<_1Y;_1X++){$k[$j++]=$g(_1W,_1X)-48}$_.sbs=$a();if($_.includetext){$k[$j++]=Infinity;$k[$j++]=$_.height;$k[$j++]=$_.height;for(var _1e=0;_1e<8;_1e++){$k[$j++]=$f($_.height-.075)}$k[$j++]=$_.height;$k[$j++]=$_.height;for(var _1i=0;_1i<8;_1i++){$k[$j++]=$f($_.height-.075)}$k[$j++]=$_.height;$k[$j++]=$_.height;$_.bhs=$a();$k[$j++]=Infinity;$k[$j++]=0;$k[$j++]=0;for(var _1n=0;_1n<8;_1n++){$k[$j++]=.075}$k[$j++]=0;$k[$j++]=0;for(var _1o=0;_1o<8;_1o++){$k[$j++]=.075}$k[$j++]=0;$k[$j++]=0;$_.bbs=$a()}else{$k[$j++]=Infinity;for(var _1q=0;_1q<22;_1q++){$k[$j++]=$_.height}$_.bhs=$a();$k[$j++]=Infinity;for(var _1t=0;_1t<22;_1t++){$k[$j++]=0}$_.bbs=$a();$_.txt=$a([])}$_.guardrightypos=0;if($_.addon.length!=0){$k[$j++]=Infinity;$k[$j++]="dontdraw";$k[$j++]=true;$k[$j++]="includetext";$k[$j++]=true;$k[$j++]="height";$k[$j++]=$_.height;if($_.includetext){var _1z=$k[--$j];$k[$j++]=$f(_1z-.15)}$k[$j++]="textxoffset";if($_.addontextxoffset!=null){$k[$j++]=$_.addontextxoffset}else{$k[$j++]=67+$_.addongap}if($_.addontextyoffset!=null){$k[$j++]="textyoffset";$k[$j++]=$_.addontextyoffset}$k[$j++]="textsize";if($_.addontextsize!=null){$k[$j++]=$_.addontextsize}else{$k[$j++]=$_.textsize}var _29=$ne($_.addontextfont,"unset")?$_.addontextfont:$_.textfont;$k[$j++]="textfont";$k[$j++]=_29;$_.addopts=$d();if($_.addon.length==2){$k[$j++]=$_.addon;$k[$j++]=$_.addopts;bwipp_ean2()}if($_.addon.length==5){$k[$j++]=$_.addon;$k[$j++]=$_.addopts;bwipp_ean5()}$_.addcode=$k[--$j];$k[$j++]=Infinity;$q($_.sbs);$k[$j++]=$_.addongap;$q($g($_.addcode,"sbs"));$_.sbs=$a();$k[$j++]=Infinity;$q($_.bhs);$q($g($_.addcode,"bhs"));$_.bhs=$a();$k[$j++]=Infinity;$q($_.bbs);$q($g($_.addcode,"bbs"));$_.bbs=$a();$k[$j++]=Infinity;$q($_.txt);$q($g($_.addcode,"txt"));$_.txt=$a();$_.guardrightypos=$_.height*72-6}$k[$j++]=Infinity;$k[$j++]="ren";$k[$j++]="renlinear";$k[$j++]="sbs";$k[$j++]=$_.sbs;$k[$j++]="bhs";$k[$j++]=$_.bhs;$k[$j++]="bbs";$k[$j++]=$_.bbs;$k[$j++]="txt";$k[$j++]=$_.txt;$k[$j++]="opt";$k[$j++]=$_.options;$k[$j++]="guardleftpos";$k[$j++]=7;$k[$j++]="guardrightpos";if($_.addon.length==0){$k[$j++]=7}else{$k[$j++]=5}$k[$j++]="guardrightypos";$k[$j++]=$_.guardrightypos;$k[$j++]="borderleft";$k[$j++]=7;$k[$j++]="borderright";if($_.addon.length==0){$k[$j++]=7}else{$k[$j++]=5}$k[$j++]="bordertop";$k[$j++]=0;$k[$j++]="borderbottom";$k[$j++]=5;var _2i=$d();$k[$j++]=_2i;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_upca(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.includetext=false;$_.textfont="OCR-B";$_.textsize=12;$_.textxoffset=-9;$_.textyoffset=-4;$_.height=1;$_.addongap=12;$_.addontextfont="unset";$_.addontextsize=null;$_.addontextxoffset=null;$_.addontextyoffset=null;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];$X($_.barcode," ");if($k[--$j]){$_.barcode=$k[--$j];$j--;$_.addon=$k[--$j]}else{$j--;$_.addon=""}if($_.barcode.length==7||$_.barcode.length==8){$F($_.barcode,function(){var _9=$k[--$j];if(_9<48||_9>57){$k[$j++]="bwipp.upcAupcEbadCharacter#5714";$k[$j++]="UPC-E must contain only digits";bwipp_raiseerror()}});var _B=$g($_.barcode,0);if(_B!=48&&_B!=49){$k[$j++]="bwipp.upcAupcEbadNumberSystem#5718";$k[$j++]="UPC-E must have number system 0 or 1";bwipp_raiseerror()}for(var _C=0;_C<1;_C++){var _E=$_.barcode.length==8?12:11;$_.upcacode=$s(_E);if($g($_.barcode,6)-48<=2){$P($_.upcacode,0,$G($_.barcode,0,3));$P($_.upcacode,3,$G($_.barcode,6,1));$P($_.upcacode,4,"0000");$P($_.upcacode,8,$G($_.barcode,3,3));break}if($g($_.barcode,6)-48==3){$P($_.upcacode,0,$G($_.barcode,0,4));$P($_.upcacode,4,"00000");$P($_.upcacode,9,$G($_.barcode,4,2));break}if($g($_.barcode,6)-48==4){$P($_.upcacode,0,$G($_.barcode,0,5));$P($_.upcacode,5,"00000");$P($_.upcacode,10,$G($_.barcode,5,1));break}if($g($_.barcode,6)-48>=5){$P($_.upcacode,0,$G($_.barcode,0,6));$P($_.upcacode,6,"0000");$P($_.upcacode,10,$G($_.barcode,6,1));break}}if($_.barcode.length==8){$P($_.upcacode,11,$G($_.barcode,7,1))}$_.barcode=$_.upcacode}if($_.barcode.length!=11&&$_.barcode.length!=12){$k[$j++]="bwipp.upcAbadLength#5756";$k[$j++]="UPC-A must be 11 or 12 digits";bwipp_raiseerror()}var _10=$_.barcode;for(var _11=0,_12=_10.length;_11<_12;_11++){var _13=$g(_10,_11);if(_13<48||_13>57){$k[$j++]="bwipp.upcAbadCharacter#5760";$k[$j++]="UPC-A must contain only digits";bwipp_raiseerror()}}if($_.addon.length!=0&&$_.addon.length!=2&&$_.addon.length!=5){$k[$j++]="bwipp.upcAbadAddOnLength#5764";$k[$j++]="Add-on for UPC-A must be 2 or 5 digits";bwipp_raiseerror()}$_.pad=$s(12);$_.checksum=0;for(var _18=0;_18<=10;_18+=1){$_.i=_18;$_.barchar=$g($_.barcode,$_.i)-48;if($_.i%2!=0){$_.checksum=$_.checksum+$_.barchar}else{$_.checksum=$_.checksum+$_.barchar*3}}$_.checksum=(10-$_.checksum%10)%10;if($_.barcode.length==12){if($g($_.barcode,11)!=$_.checksum+48){$k[$j++]="bwipp.upcAbadCheckDigit#5782";$k[$j++]="Incorrect UPC check digit provided";bwipp_raiseerror()}}$P($_.pad,0,$_.barcode);$p($_.pad,11,$_.checksum+48);$_.barcode=$_.pad;$_.encs=$a(["3211","2221","2122","1411","1132","1231","1114","1312","1213","3112","111","11111","111"]);$_.barchars="0123456789";$_.sbs=$s(59);$_.txt=$a(12);$P($_.sbs,0,$g($_.encs,10));for(var _1Y=0;_1Y<=5;_1Y+=1){$_.i=_1Y;$X($_.barchars,$G($_.barcode,$_.i,1));$j--;$_.indx=$k[--$j].length;$j-=2;$_.enc=$g($_.encs,$_.indx);$P($_.sbs,$_.i*4+3,$_.enc);if($_.i==0){$p($_.txt,0,$a([$G($_.barcode,0,1),$_.textxoffset,$_.textyoffset,$_.textfont,$_.textsize-2]))}else{$p($_.txt,$_.i,$a([$G($_.barcode,$_.i,1),$_.i*7+13+$_.textxoffset,$_.textyoffset,$_.textfont,$_.textsize]))}}$P($_.sbs,6*4+3,$g($_.encs,11));for(var _27=6;_27<=11;_27+=1){$_.i=_27;$X($_.barchars,$G($_.barcode,$_.i,1));$j--;$_.indx=$k[--$j].length;$j-=2;$_.enc=$g($_.encs,$_.indx);$P($_.sbs,$_.i*4+8,$_.enc);if($_.i==11){$p($_.txt,11,$a([$G($_.barcode,11,1),$_.textxoffset+107,$_.textyoffset,$_.textfont,$_.textsize-2]))}else{$p($_.txt,$_.i,$a([$G($_.barcode,$_.i,1),$_.i*7+$_.textxoffset+17,$_.textyoffset,$_.textfont,$_.textsize]))}}$P($_.sbs,56,$g($_.encs,12));$k[$j++]=Infinity;var _2g=$_.sbs;for(var _2h=0,_2i=_2g.length;_2h<_2i;_2h++){$k[$j++]=$g(_2g,_2h)-48}$_.sbs=$a();if($_.includetext){$k[$j++]=Infinity;for(var _2m=0;_2m<4;_2m++){$k[$j++]=$_.height}for(var _2o=0;_2o<10;_2o++){$k[$j++]=$f($_.height-.075)}$k[$j++]=$_.height;$k[$j++]=$_.height;for(var _2s=0;_2s<10;_2s++){$k[$j++]=$f($_.height-.075)}for(var _2u=0;_2u<4;_2u++){$k[$j++]=$_.height}$_.bhs=$a();$k[$j++]=Infinity;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;for(var _2x=0;_2x<10;_2x++){$k[$j++]=.075}$k[$j++]=0;$k[$j++]=0;for(var _2y=0;_2y<10;_2y++){$k[$j++]=.075}$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$_.bbs=$a()}else{$k[$j++]=Infinity;for(var _30=0;_30<30;_30++){$k[$j++]=$_.height}$_.bhs=$a();$k[$j++]=Infinity;for(var _33=0;_33<30;_33++){$k[$j++]=0}$_.bbs=$a();$_.txt=$a([])}$_.guardrightypos=0;if($_.addon.length!=0){$k[$j++]=Infinity;$k[$j++]="dontdraw";$k[$j++]=true;$k[$j++]="includetext";$k[$j++]=true;$k[$j++]="height";$k[$j++]=$_.height;if($_.includetext){var _39=$k[--$j];$k[$j++]=$f(_39-.15)}$k[$j++]="textxoffset";if($_.addontextxoffset!=null){$k[$j++]=$_.addontextxoffset}else{$k[$j++]=95+$_.addongap}if($_.addontextyoffset!=null){$k[$j++]="textyoffset";$k[$j++]=$_.addontextyoffset}$k[$j++]="textsize";if($_.addontextsize!=null){$k[$j++]=$_.addontextsize}else{$k[$j++]=$_.textsize}var _3J=$ne($_.addontextfont,"unset")?$_.addontextfont:$_.textfont;$k[$j++]="textfont";$k[$j++]=_3J;$_.addopts=$d();if($_.addon.length==2){$k[$j++]=$_.addon;$k[$j++]=$_.addopts;bwipp_ean2()}if($_.addon.length==5){$k[$j++]=$_.addon;$k[$j++]=$_.addopts;bwipp_ean5()}$_.addcode=$k[--$j];$k[$j++]=Infinity;$q($_.sbs);$k[$j++]=$_.addongap;$q($g($_.addcode,"sbs"));$_.sbs=$a();$k[$j++]=Infinity;$q($_.bhs);$q($g($_.addcode,"bhs"));$_.bhs=$a();$k[$j++]=Infinity;$q($_.bbs);$q($g($_.addcode,"bbs"));$_.bbs=$a();$k[$j++]=Infinity;$q($_.txt);$q($g($_.addcode,"txt"));$_.txt=$a();$_.guardrightypos=$_.height*72-6}$k[$j++]=Infinity;$k[$j++]="ren";$k[$j++]="renlinear";$k[$j++]="sbs";$k[$j++]=$_.sbs;$k[$j++]="bhs";$k[$j++]=$_.bhs;$k[$j++]="bbs";$k[$j++]=$_.bbs;$k[$j++]="txt";$k[$j++]=$_.txt;$k[$j++]="opt";$k[$j++]=$_.options;$k[$j++]="guardrightpos";if($_.addon.length==0){$k[$j++]=9}else{$k[$j++]=5}$k[$j++]="guardrightypos";$k[$j++]=$_.guardrightypos;$k[$j++]="borderleft";$k[$j++]=9;$k[$j++]="borderright";if($_.addon.length==0){$k[$j++]=9}else{$k[$j++]=5}$k[$j++]="bordertop";$k[$j++]=0;$k[$j++]="borderbottom";$k[$j++]=5;var _3s=$d();$k[$j++]=_3s;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_upce(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.includetext=false;$_.textfont="OCR-B";$_.textsize=12;$_.textxoffset=-9;$_.textyoffset=-4;$_.height=1;$_.addongap=12;$_.addontextfont="unset";$_.addontextsize=null;$_.addontextxoffset=null;$_.addontextyoffset=null;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];$X($_.barcode," ");if($k[--$j]){$_.barcode=$k[--$j];$j--;$_.addon=$k[--$j]}else{$j--;$_.addon=""}if($_.barcode.length==11||$_.barcode.length==12){$F($_.barcode,function(){var _9=$k[--$j];if(_9<48||_9>57){$k[$j++]="bwipp.upcEupcAbadCharacter#5967";$k[$j++]="UPC-A must contain only digits";bwipp_raiseerror()}});for(var _A=0;_A<1;_A++){var _C=$_.barcode.length==12?8:7;$_.upcecode=$s(_C);if($g($_.barcode,3)-48<=2&&$eq($G($_.barcode,4,4),"0000")){$P($_.upcecode,0,$G($_.barcode,0,3));$P($_.upcecode,3,$G($_.barcode,8,3));$P($_.upcecode,6,$G($_.barcode,3,1));break}if($eq($G($_.barcode,4,5),"00000")){$P($_.upcecode,0,$G($_.barcode,0,4));$P($_.upcecode,4,$G($_.barcode,9,2));$P($_.upcecode,6,"3");break}if($eq($G($_.barcode,5,5),"00000")){$P($_.upcecode,0,$G($_.barcode,0,5));$P($_.upcecode,5,$G($_.barcode,10,1));$P($_.upcecode,6,"4");break}if($g($_.barcode,10)-48>=5&&$eq($G($_.barcode,6,4),"0000")){$P($_.upcecode,0,$G($_.barcode,0,6));$P($_.upcecode,6,$G($_.barcode,10,1));break}$k[$j++]="bwipp.upcEupcAnotCompressible#5995";$k[$j++]="UPC-A cannot be converted to a UPC-E";bwipp_raiseerror()}if($_.barcode.length==12){$P($_.upcecode,7,$G($_.barcode,11,1))}$_.barcode=$_.upcecode}if($_.barcode.length!=7&&$_.barcode.length!=8){$k[$j++]="bwipp.upcEbadLength#6005";$k[$j++]="UPC-E must be 7 or 8 digits";bwipp_raiseerror()}var _10=$_.barcode;for(var _11=0,_12=_10.length;_11<_12;_11++){var _13=$g(_10,_11);if(_13<48||_13>57){$k[$j++]="bwipp.upcEbadCharacter#6009";$k[$j++]="UPC-E must contain only digits";bwipp_raiseerror()}}if($_.addon.length!=0&&$_.addon.length!=2&&$_.addon.length!=5){$k[$j++]="bwipp.upcEbadAddOnLength#6013";$k[$j++]="Add-on for UPC-E must be 2 or 5 digits";bwipp_raiseerror()}var _18=$g($_.barcode,0);if(_18!=48&&_18!=49){$k[$j++]="bwipp.upcEbadNumberSystem#6018";$k[$j++]="UPC-E must have number system 0 or 1";bwipp_raiseerror()}$_.encs=$a(["3211","2221","2122","1411","1132","1231","1114","1312","1213","3112","111","111111"]);$_.barchars="0123456789";$_.mirrormaps=$a(["000111","001011","001101","001110","010011","011001","011100","010101","010110","011010"]);for(var _1C=0;_1C<1;_1C++){$_.upcacode=$s(11);if($g($_.barcode,6)-48<=2){$P($_.upcacode,0,$G($_.barcode,0,3));$P($_.upcacode,3,$G($_.barcode,6,1));$P($_.upcacode,4,"0000");$P($_.upcacode,8,$G($_.barcode,3,3));break}if($g($_.barcode,6)-48==3){$P($_.upcacode,0,$G($_.barcode,0,4));$P($_.upcacode,4,"00000");$P($_.upcacode,9,$G($_.barcode,4,2));break}if($g($_.barcode,6)-48==4){$P($_.upcacode,0,$G($_.barcode,0,5));$P($_.upcacode,5,"00000");$P($_.upcacode,10,$G($_.barcode,5,1));break}if($g($_.barcode,6)-48>=5){$P($_.upcacode,0,$G($_.barcode,0,6));$P($_.upcacode,6,"0000");$P($_.upcacode,10,$G($_.barcode,6,1));break}}$_.checksum=0;for(var _1r=0;_1r<=10;_1r+=1){$_.i=_1r;$_.barchar=$g($_.upcacode,$_.i)-48;if($_.i%2!=0){$_.checksum=$_.checksum+$_.barchar}else{$_.checksum=$_.checksum+$_.barchar*3}}$_.checksum=(10-$_.checksum%10)%10;if($_.barcode.length==8){if($g($_.barcode,7)!=$_.checksum+48){$k[$j++]="bwipp.upcEbadCheckDigit#6080";$k[$j++]="Incorrect UPC check digit provided";bwipp_raiseerror()}}$_.pad=$s(8);$P($_.pad,0,$_.barcode);$p($_.pad,7,$_.checksum+48);$_.barcode=$_.pad;$_.txt=$a(8);$p($_.txt,0,$a([$G($_.barcode,0,1),$_.textxoffset,$_.textyoffset,$_.textfont,$_.textsize-2]));$_.mirrormap=$g($_.mirrormaps,$_.checksum);if($g($_.barcode,0)==48){$_.invt=$s($_.mirrormap.length);for(var _2T=0,_2S=$_.mirrormap.length-1;_2T<=_2S;_2T+=1){$_.i=_2T;if($g($_.mirrormap,$_.i)==48){$p($_.invt,$_.i,49)}else{$p($_.invt,$_.i,48)}}$_.mirrormap=$_.invt}$_.sbs=$s(33);$P($_.sbs,0,$g($_.encs,10));for(var _2g=1;_2g<=6;_2g+=1){$_.i=_2g;$X($_.barchars,$G($_.barcode,$_.i,1));$j--;$_.indx=$k[--$j].length;$j-=2;$_.enc=$g($_.encs,$_.indx);if($g($_.mirrormap,$_.i-1)==49){$_.enclen=$_.enc.length;$_.revenc=$s($_.enclen);for(var _2x=0,_2w=$_.enclen-1;_2x<=_2w;_2x+=1){$_.j=_2x;$_.char=$g($_.enc,$_.j);$p($_.revenc,$_.enclen-$_.j-1,$_.char)}$_.enc=$_.revenc}$P($_.sbs,($_.i-1)*4+3,$_.enc);$p($_.txt,$_.i,$a([$G($_.barcode,$_.i,1),($_.i-1)*7+13+$_.textxoffset,$_.textyoffset,$_.textfont,$_.textsize]))}$p($_.txt,7,$a([$G($_.barcode,7,1),6*7+21+$_.textxoffset,$_.textyoffset,$_.textfont,$_.textsize-2]));$P($_.sbs,27,$g($_.encs,11));$k[$j++]=Infinity;var _3V=$_.sbs;for(var _3W=0,_3X=_3V.length;_3W<_3X;_3W++){$k[$j++]=$g(_3V,_3W)-48}$_.sbs=$a();if($_.includetext){$k[$j++]=Infinity;$k[$j++]=$_.height;$k[$j++]=$_.height;for(var _3d=0;_3d<12;_3d++){$k[$j++]=$f($_.height-.075)}$k[$j++]=$_.height;$k[$j++]=$_.height;$k[$j++]=$_.height;$_.bhs=$a();$k[$j++]=Infinity;$k[$j++]=0;$k[$j++]=0;for(var _3j=0;_3j<12;_3j++){$k[$j++]=.075}$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$_.bbs=$a()}else{$k[$j++]=Infinity;for(var _3l=0;_3l<17;_3l++){$k[$j++]=$_.height}$_.bhs=$a();$k[$j++]=Infinity;for(var _3o=0;_3o<17;_3o++){$k[$j++]=0}$_.bbs=$a();$_.txt=$a([])}$_.guardrightypos=0;if($_.addon.length!=0){$k[$j++]=Infinity;$k[$j++]="dontdraw";$k[$j++]=true;$k[$j++]="includetext";$k[$j++]=true;$k[$j++]="height";$k[$j++]=$_.height;if($_.includetext){var _3u=$k[--$j];$k[$j++]=$f(_3u-.15)}$k[$j++]="textxoffset";if($_.addontextxoffset!=null){$k[$j++]=$_.addontextxoffset}else{$k[$j++]=51+$_.addongap}if($_.addontextyoffset!=null){$k[$j++]="textyoffset";$k[$j++]=$_.addontextyoffset}$k[$j++]="textsize";if($_.addontextsize!=null){$k[$j++]=$_.addontextsize}else{$k[$j++]=$_.textsize}var _44=$ne($_.addontextfont,"unset")?$_.addontextfont:$_.textfont;$k[$j++]="textfont";$k[$j++]=_44;$_.addopts=$d();if($_.addon.length==2){$k[$j++]=$_.addon;$k[$j++]=$_.addopts;bwipp_ean2()}if($_.addon.length==5){$k[$j++]=$_.addon;$k[$j++]=$_.addopts;bwipp_ean5()}$_.addcode=$k[--$j];$k[$j++]=Infinity;$q($_.sbs);$k[$j++]=$_.addongap;$q($g($_.addcode,"sbs"));$_.sbs=$a();$k[$j++]=Infinity;$q($_.bhs);$q($g($_.addcode,"bhs"));$_.bhs=$a();$k[$j++]=Infinity;$q($_.bbs);$q($g($_.addcode,"bbs"));$_.bbs=$a();$k[$j++]=Infinity;$q($_.txt);$q($g($_.addcode,"txt"));$_.txt=$a();$_.guardrightypos=$_.height*72-6}$k[$j++]=Infinity;$k[$j++]="ren";$k[$j++]="renlinear";$k[$j++]="sbs";$k[$j++]=$_.sbs;$k[$j++]="bhs";$k[$j++]=$_.bhs;$k[$j++]="bbs";$k[$j++]=$_.bbs;$k[$j++]="txt";$k[$j++]=$_.txt;$k[$j++]="opt";$k[$j++]=$_.options;$k[$j++]="guardrightpos";if($_.addon.length==0){$k[$j++]=9}else{$k[$j++]=5}$k[$j++]="guardrightypos";$k[$j++]=$_.guardrightypos;$k[$j++]="borderleft";$k[$j++]=9;$k[$j++]="borderright";if($_.addon.length==0){$k[$j++]=9}else{$k[$j++]=5}$k[$j++]="bordertop";$k[$j++]=0;$k[$j++]="borderbottom";$k[$j++]=5;var _4d=$d();$k[$j++]=_4d;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_isbn(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.includetext=false;$_.isbntextfont="OCR-A";$_.isbntextsize=8;$_.isbntextxoffset=null;$_.isbntextyoffset=null;$_.height=1;$_.addongap=12;$_.legacy=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];$X($_.barcode," ");if($k[--$j]){$_.barcode=$k[--$j];$j--;$_.addon=$k[--$j]}else{$j--;$_.addon=""}if($_.barcode.length!=15&&$_.barcode.length!=17&&($_.barcode.length!=11&&$_.barcode.length!=13)){$k[$j++]="bwipp.isbnBadLength#6249";$k[$j++]="ISBN-13 must be 15 or 17 characters including dashes. ISBN-10 must be 11 or 13 characters including dashes";bwipp_raiseerror()}if($_.addon.length!=0&&$_.addon.length!=2&&$_.addon.length!=5){$k[$j++]="bwipp.isbnBadAddOnLength#6252";$k[$j++]="Add-on for ISBN must be 2 or 5 digits";bwipp_raiseerror()}if($_.barcode.length>=15){var _F=$G($_.barcode,0,4);if($ne(_F,"978-")&&$ne(_F,"979-")){$k[$j++]="bwipp.isbn13badPrefix#6256";$k[$j++]="ISBN-13 prefix must be 978- or 979-";bwipp_raiseerror()}$_.wasdash=false;$_.numdash=0;$_.numdigit=0;var _H=$G($_.barcode,5,9);for(var _I=0,_J=_H.length;_I<_J;_I++){var _K=$g(_H,_I);$k[$j++]=_K;if(_K==45){if($_.wasdash){$k[$j++]="bwipp.isbn13adjacentDashes#6263";$k[$j++]="ISBN-13 does not permit adjacent dashes";bwipp_raiseerror()}$_.wasdash=true;$_.numdash=$_.numdash+1}var _N=$k[--$j];if(_N>=48&&_N<=57){$_.wasdash=false;$_.numdigit=$_.numdigit+1}}if($_.numdash!=2||$_.numdigit!=7){$k[$j++]="bwipp.isbn13numDashesDigits#6274";$k[$j++]="Incorrect number of dashes and digits for ISBN-13";bwipp_raiseerror()}var _S=$g($_.barcode,14);if(_S<48||_S>57){$k[$j++]="bwipp.isbn13character15#6277";$k[$j++]="ISBN-13 character 15 must be a digit";bwipp_raiseerror()}if($_.barcode.length==17){if($ne($G($_.barcode,15,1),"-")){$k[$j++]="bwipp.isbn13character16#6281";$k[$j++]="ISBN-13 penultimate character must be a dash";bwipp_raiseerror()}var _X=$g($_.barcode,16);if(_X<48||_X>57){$k[$j++]="bwipp.isbn13character17#6284";$k[$j++]="ISBN-13 final character must be a digit";bwipp_raiseerror()}}}else{var _Z=$g($_.barcode,0);if(_Z<48||_Z>57){$k[$j++]="bwipp.isbn10FirstDigit#6289";$k[$j++]="ISBN-10 first character must be a digit";bwipp_raiseerror()}$_.wasdash=false;$_.numdash=0;$_.numdigit=0;var _b=$G($_.barcode,1,9);for(var _c=0,_d=_b.length;_c<_d;_c++){var _e=$g(_b,_c);$k[$j++]=_e;if(_e==45){if($_.wasdash){$k[$j++]="bwipp.isbn10adjacentDashes#6296";$k[$j++]="ISBN-10 does not permit adjacent dashes";bwipp_raiseerror()}$_.wasdash=true;$_.numdash=$_.numdash+1}var _h=$k[--$j];if(_h>=48&&_h<=57){$_.wasdash=false;$_.numdigit=$_.numdigit+1}}if($_.numdash!=2||$_.numdigit!=7){$k[$j++]="bwipp.isbn10numDashesDigits#6307";$k[$j++]="Incorrect number of dashes and digits for ISBN-10";bwipp_raiseerror()}var _m=$g($_.barcode,10);if(_m<48||_m>57){$k[$j++]="bwipp.isbn10character11#6310";$k[$j++]="ISBN-10 character 11 must be a digit";bwipp_raiseerror()}if($_.barcode.length==13){if($ne($G($_.barcode,11,1),"-")){$k[$j++]="bwipp.isbn10character12#6314";$k[$j++]="ISBN-10 penultimate character must be a dash";bwipp_raiseerror()}var _r=$g($_.barcode,12);if((_r<48||_r>57)&&_r!=88){$k[$j++]="bwipp.isbn10character13#6317";$k[$j++]="ISBN-10 final character must be a digit or X";bwipp_raiseerror()}}}$_.isbntxt=$_.barcode;if($_.isbntxt.length<=13){$_.isbn=$s(10);$_.checksum=0;$_.i=0;$_.n=0;for(;;){$_.isbnchar=$g($_.isbntxt,$_.i)-48;if($_.isbnchar!=-3){$p($_.isbn,$_.n,$_.isbnchar+48);if($_.n<9){$_.checksum=$f($_.checksum+(10-$_.n)*$_.isbnchar)}$_.n=$_.n+1}$_.i=$_.i+1;if($_.i==$_.isbntxt.length){break}}var _1B=(11-$_.checksum%11)%11;$k[$j++]="checksum";$k[$j++]=_1B;if(_1B==10){$k[$j-1]=40}var _1C=$k[--$j];$_[$k[--$j]]=_1C+48;$_.isbn=$G($_.isbn,0,9);if($_.isbntxt.length==13){if($g($_.isbntxt,12)!=$_.checksum){$k[$j++]="bwipp.isbn10badCheckDigit#6345";$k[$j++]="Incorrect ISBN-10 check digit provided";bwipp_raiseerror()}}}if(!$_.legacy||$_.isbntxt.length>=15){if($_.isbntxt.length<=13){$_.pad=$s(15);$P($_.pad,0,"978-");$P($_.pad,4,$G($_.isbntxt,0,11));$_.isbntxt=$_.pad}$_.isbn=$s(13);$_.checksum=0;$_.i=0;$_.n=0;for(;;){$_.isbnchar=$g($_.isbntxt,$_.i)-48;if($_.isbnchar!=-3){$p($_.isbn,$_.n,$_.isbnchar+48);if($_.n<12){$k[$j++]="checksum";$k[$j++]=$_.isbnchar;if($_.n%2!=0){var _1e=$k[--$j];$k[$j++]=_1e*3}var _1g=$k[--$j];$_[$k[--$j]]=$f(_1g+$_.checksum)}$_.n=$_.n+1}$_.i=$_.i+1;if($_.i==$_.isbntxt.length){break}}$_.checksum=(10-$_.checksum%10)%10+48;$_.isbn=$G($_.isbn,0,12);if($_.isbntxt.length==17){if($g($_.isbntxt,16)!=$_.checksum){$k[$j++]="bwipp.isbn13badCheckDigit#6380";$k[$j++]="Incorrect ISBN-13 check digit provided";bwipp_raiseerror()}}}var _1u=$_.isbn.length==12?22:18;$_.pad=$s(_1u);$P($_.pad,0,"ISBN ");$P($_.pad,5,$_.isbntxt);$p($_.pad,$_.pad.length-2,45);$p($_.pad,$_.pad.length-1,$_.checksum);$_.isbntxt=$_.pad;$_.barcode=$s(12);if($_.isbn.length==9){$P($_.barcode,0,"978");$P($_.barcode,3,$_.isbn)}else{$P($_.barcode,0,$_.isbn)}if($_.addon.length!=0){var _2E=$s(12+$_.addon.length+1);$P(_2E,0,$_.barcode);$P(_2E,12," ");$P(_2E,13,$_.addon);$_.barcode=_2E}$p($_.options,"dontdraw",true);$p($_.options,"addongap",$_.addongap);$k[$j++]="args";$k[$j++]=$_.barcode;$k[$j++]=$_.options;bwipp_ean13();var _2M=$k[--$j];$_[$k[--$j]]=_2M;if($_.includetext){if($_.isbntextxoffset==null){$k[$j++]="isbntextxoffset";if($_.isbn.length==9){$k[$j++]=-1}else{$k[$j++]=-12}var _2R=$k[--$j];$_[$k[--$j]]=_2R}if($_.isbntextyoffset==null){$_.isbntextyoffset=$_.height*72+3}var _2W=$g($_.args,"txt")!==undefined;if(_2W){$_.txt=$g($_.args,"txt");$_.newtxt=$a($_.txt.length+1);$P($_.newtxt,0,$_.txt);$p($_.newtxt,$_.newtxt.length-1,$a([$_.isbntxt,$_.isbntextxoffset,$_.isbntextyoffset,$_.isbntextfont,$_.isbntextsize]));$p($_.args,"txt",$_.newtxt)}else{$p($_.args,"txt",$a([$a([$_.isbntxt,$_.isbntextxoffset,$_.isbntextyoffset,$_.isbntextfont,$_.isbntextsize])]))}}$p($_.args,"opt",$_.options);$k[$j++]=$_.args;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_ismn(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.includetext=false;$_.ismntextfont="OCR-A";$_.ismntextsize=8;$_.ismntextxoffset=null;$_.ismntextyoffset=null;$_.height=1;$_.addongap=12;$_.legacy=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];$X($_.barcode," ");if($k[--$j]){$_.barcode=$k[--$j];$j--;$_.addon=$k[--$j]}else{$j--;$_.addon=""}if($_.barcode.length!=15&&$_.barcode.length!=17&&($_.barcode.length!=11&&$_.barcode.length!=13)){$k[$j++]="bwipp.ismnBadLength#6499";$k[$j++]="ISMN-13 must be 15 or 17 characters including dashes. ISMN-10 must be 11 or 13 characters including dashes";bwipp_raiseerror()}if($_.addon.length!=0&&$_.addon.length!=2&&$_.addon.length!=5){$k[$j++]="bwipp.ismnBadAddOnLength#6502";$k[$j++]="Add-on for ISMN must be 2 or 5 digits";bwipp_raiseerror()}if($_.barcode.length>=15){if($ne($G($_.barcode,0,4),"979-")){$k[$j++]="bwipp.ismn13badPrefix#6506";$k[$j++]="ISMN-13 prefix must be 979-";bwipp_raiseerror()}$_.wasdash=false;$_.numdash=0;$_.numdigit=0;var _H=$G($_.barcode,5,9);for(var _I=0,_J=_H.length;_I<_J;_I++){var _K=$g(_H,_I);$k[$j++]=_K;if(_K==45){if($_.wasdash){$k[$j++]="bwipp.ismn13adjacentDashes#6513";$k[$j++]="ISMN-13 does not permit adjacent dashes";bwipp_raiseerror()}$_.wasdash=true;$_.numdash=$_.numdash+1}var _N=$k[--$j];if(_N>=48&&_N<=57){$_.wasdash=false;$_.numdigit=$_.numdigit+1}}if($_.numdash!=2||$_.numdigit!=7){$k[$j++]="bwipp.ismn13numDashesDigits#6524";$k[$j++]="Incorrect number of dashes and digits for ISMN-13";bwipp_raiseerror()}var _S=$g($_.barcode,14);if(_S<48||_S>57){$k[$j++]="bwipp.ismn13character15#6527";$k[$j++]="ISMN-13 character 15 must be a digit";bwipp_raiseerror()}if($_.barcode.length==17){if($ne($G($_.barcode,15,1),"-")){$k[$j++]="bwipp.ismn13character16#6531";$k[$j++]="ISMN-13 penultimate character must be a dash";bwipp_raiseerror()}var _X=$g($_.barcode,16);if(_X<48||_X>57){$k[$j++]="bwipp.ismn13character17#6534";$k[$j++]="ISMN-13 final character must be a digit";bwipp_raiseerror()}}}else{if($ne($G($_.barcode,0,2),"M-")){$k[$j++]="bwipp.ismn10badPrefix#6539";$k[$j++]="ISMN-10 prefix must be M-";bwipp_raiseerror()}var _b=$g($_.barcode,2);if(_b<48||_b>57){$k[$j++]="bwipp.ismn10character3#6542";$k[$j++]="ISMN-10 character 3 must be a digit";bwipp_raiseerror()}$_.wasdash=false;$_.numdash=0;$_.numdigit=0;var _d=$G($_.barcode,3,7);for(var _e=0,_f=_d.length;_e<_f;_e++){var _g=$g(_d,_e);$k[$j++]=_g;if(_g==45){if($_.wasdash){$k[$j++]="bwipp.ismn10adjacentDashes#6549";$k[$j++]="ISMN-10 does not permit adjacent dashes";bwipp_raiseerror()}$_.wasdash=true;$_.numdash=$_.numdash+1}var _j=$k[--$j];if(_j>=48&&_j<=57){$_.wasdash=false;$_.numdigit=$_.numdigit+1}}if($_.numdash!=1||$_.numdigit!=6){$k[$j++]="bwipp.ismn10numDashesDigits#6560";$k[$j++]="Incorrect number of dashes and digits for ISMN-10";bwipp_raiseerror()}var _o=$g($_.barcode,10);if(_o<48||_o>57){$k[$j++]="bwipp.ismn10character11#6563";$k[$j++]="ISMN-10 character 11 must be a digit";bwipp_raiseerror()}if($_.barcode.length==13){var _r=$G($_.barcode,11,1);if($ne(_r,"-")){$k[$j++]="bwipp.ismn10character12#6567";$k[$j++]="ISMN-10 penultimate character must be a dash";bwipp_raiseerror()}var _t=$g($_.barcode,12);if((_t<48||_t>57)&&_t!=88){$k[$j++]="bwipp.ismn10character13#6570";$k[$j++]="ISMN-10 final character must be a digit or X";bwipp_raiseerror()}}}$_.ismntxt=$_.barcode;$_.legacytxt="";if($_.ismntxt.length<=13){$_.legacytxt=$_.ismntxt;$_.pad=$s($_.ismntxt.length+4);$P($_.pad,0,"979-0-");$P($_.pad,6,$G($_.ismntxt,2,$_.ismntxt.length-2));$_.ismntxt=$_.pad}$_.ismn=$s(13);$_.checksum=0;$_.i=0;$_.n=0;for(;;){$_.ismnchar=$g($_.ismntxt,$_.i)-48;if($_.ismnchar!=-3){$p($_.ismn,$_.n,$_.ismnchar+48);if($_.n<12){if($_.n%2==0){$_.checksum=$_.ismnchar+$_.checksum}else{$_.checksum=$_.ismnchar*3+$_.checksum}}$_.n=$_.n+1}$_.i=$_.i+1;if($_.i==$_.ismntxt.length){break}}$_.checksum=(10-$_.checksum%10)%10+48;if($_.barcode.length==13||$_.barcode.length==17){var _1Q=$_.barcode;if($g(_1Q,_1Q.length-1)!=$_.checksum){$k[$j++]="bwipp.ismnBadCheckDigit#6612";$k[$j++]="Incorrect ISMN check digit provided";bwipp_raiseerror()}}if($_.legacy&&$_.legacytxt.length!=0){$_.ismntxt=$_.legacytxt;$_.pad=$s(18)}else{$_.pad=$s(22)}$P($_.pad,0,"ISMN ");$P($_.pad,5,$_.ismntxt);$p($_.pad,$_.pad.length-2,45);$p($_.pad,$_.pad.length-1,$_.checksum);$_.ismntxt=$_.pad;$_.barcode=$G($_.ismn,0,12);if($_.addon.length!=0){var _1l=$s(12+$_.addon.length+1);$P(_1l,0,$_.barcode);$P(_1l,12," ");$P(_1l,13,$_.addon);$_.barcode=_1l}$p($_.options,"dontdraw",true);$p($_.options,"addongap",$_.addongap);$k[$j++]="args";$k[$j++]=$_.barcode;$k[$j++]=$_.options;bwipp_ean13();var _1t=$k[--$j];$_[$k[--$j]]=_1t;if($_.includetext){if($_.ismntextxoffset==null){$k[$j++]="ismntextxoffset";if($_.ismntxt.length==18){$k[$j++]=-1}else{$k[$j++]=-12}var _1y=$k[--$j];$_[$k[--$j]]=_1y}if($_.ismntextyoffset==null){$_.ismntextyoffset=$_.height*72+3}var _23=$g($_.args,"txt")!==undefined;if(_23){$_.txt=$g($_.args,"txt");$_.newtxt=$a($_.txt.length+1);$P($_.newtxt,0,$_.txt);$p($_.newtxt,$_.newtxt.length-1,$a([$_.ismntxt,$_.ismntextxoffset,$_.ismntextyoffset,$_.ismntextfont,$_.ismntextsize]));$p($_.args,"txt",$_.newtxt)}else{$p($_.args,"txt",$a([$a([$_.ismntxt,$_.ismntextxoffset,$_.ismntextyoffset,$_.ismntextfont,$_.ismntextsize])]))}}$p($_.args,"opt",$_.options);$k[$j++]=$_.args;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_issn(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.includetext=false;$_.issntextfont="OCR-A";$_.issntextsize=8;$_.issntextxoffset=null;$_.issntextyoffset=null;$_.height=1;$_.addongap=12;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.issntxt=$k[--$j];$X($_.issntxt," ");if($k[--$j]){$_.issntxt=$k[--$j];$j--;$_.seqvar=$k[--$j]}else{$j--;$_.seqvar="00"}$X($_.seqvar," ");if($k[--$j]){$_.seqvar=$k[--$j];$j--;$_.addon=$k[--$j]}else{$j--;$_.addon=""}if($_.issntxt.length!=8&&$_.issntxt.length!=9){$k[$j++]="bwipp.issnBadLength#6736";$k[$j++]="ISSN must be 8 or 9 characters including dash, in the format XXXX-XXXX";bwipp_raiseerror()}var _D=$G($_.issntxt,0,4);for(var _E=0,_F=_D.length;_E<_F;_E++){var _G=$g(_D,_E);if(_G<48||_G>57){$k[$j++]="bwipp.issnFirstThroughFourthNotNumeric#6740";$k[$j++]="ISSN first four characters must be numeral characters";bwipp_raiseerror()}}if($ne($G($_.issntxt,4,1),"-")){$k[$j++]="bwipp.issnNeedsDash#6744";$k[$j++]="ISSN fifth character must be a dash";bwipp_raiseerror()}var _K=$G($_.issntxt,5,3);for(var _L=0,_M=_K.length;_L<_M;_L++){var _N=$g(_K,_L);if(_N<48||_N>57){$k[$j++]="bwipp.issnSixthThroughEighthNotNumeric#6748";$k[$j++]="ISSN sixth through eighth characters must be numerals";bwipp_raiseerror()}}if($_.issntxt.length==9){var _Q=$g($_.issntxt,8);if((_Q<48||_Q>57)&&_Q!=88){$k[$j++]="bwipp.issnNinthCharacterBadFormat#6753";$k[$j++]="ISSN ninth character must be a number or the character X";bwipp_raiseerror()}}if($_.seqvar.length!=2){$k[$j++]="bwipp.issnBadSequenceVariantLength#6757";$k[$j++]="Sequence variant for ISSN must be 2 digits";bwipp_raiseerror()}$F($_.seqvar,function(){var _T=$k[--$j];if(_T<48||_T>57){$k[$j++]="bwipp.issnSequenceVariantBadCharacter#6761";$k[$j++]="Sequence variant for ISSN must contain only digits";bwipp_raiseerror()}});if($_.addon.length!=0&&$_.addon.length!=2&&$_.addon.length!=5){$k[$j++]="bwipp.issnBadAddOnLength#6765";$k[$j++]="Add-on for ISSN must be 2 or 5 digits";bwipp_raiseerror()}$_.issn=$s(8);$_.checksum=0;$_.i=0;$_.n=0;for(;;){$_.issnchar=$g($_.issntxt,$_.i)-48;if($_.issnchar!=-3){$p($_.issn,$_.n,$_.issnchar+48);if($_.n<7){$_.checksum=$f($_.checksum+$_.issnchar*(8-$_.n))}$_.n=$_.n+1}$_.i=$_.i+1;if($_.i==$_.issntxt.length){break}}$_.checksum=(11-$_.checksum%11)%11;var _p=$_.checksum+48;$k[$j++]="checksum";$k[$j++]=_p;if(_p==58){$k[$j-1]=88}var _q=$k[--$j];var _r=$k[--$j];$_[_r]=_q;if($_.issntxt.length==9){if($g($_.issntxt,8)!=$_.checksum){$k[$j++]="bwipp.issnBadCheckDigit#6788";$k[$j++]="Incorrect ISSN check digit provided";bwipp_raiseerror()}}$_.pad=$s(14);$P($_.pad,0,"ISSN ");$P($_.pad,5,$_.issntxt);$p($_.pad,13,$_.checksum);$_.issntxt=$_.pad;$_.barcode=$G($_.issn,0,7);$_.barcode=$s(12);$P($_.barcode,0,"977");$P($_.barcode,3,$_.issn);$P($_.barcode,10,$_.seqvar);if($_.addon.length!=0){var _1D=$s(12+$_.addon.length+1);$P(_1D,0,$_.barcode);$P(_1D,12," ");$P(_1D,13,$_.addon);$_.barcode=_1D}$p($_.options,"dontdraw",true);$p($_.options,"addongap",$_.addongap);$k[$j++]="args";$k[$j++]=$_.barcode;$k[$j++]=$_.options;bwipp_ean13();var _1L=$k[--$j];$_[$k[--$j]]=_1L;if($_.includetext){if($_.issntextxoffset==null){$_.issntextxoffset=10}if($_.issntextyoffset==null){$_.issntextyoffset=$_.height*72+3}var _1S=$g($_.args,"txt")!==undefined;if(_1S){$_.txt=$g($_.args,"txt");$_.newtxt=$a($_.txt.length+1);$P($_.newtxt,0,$_.txt);$p($_.newtxt,$_.newtxt.length-1,$a([$_.issntxt,$_.issntextxoffset,$_.issntextyoffset,$_.issntextfont,$_.issntextsize]));$p($_.args,"txt",$_.newtxt)}else{$p($_.args,"txt",$a([$a([$_.issntxt,$_.issntextxoffset,$_.issntextyoffset,$_.issntextfont,$_.issntextsize])]))}}$p($_.args,"opt",$_.options);$k[$j++]=$_.args;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_mands(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.includetext=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];$_.barlen=$_.barcode.length;if($_.barlen!=7&&$_.barlen!=8){$k[$j++]="bwipp.MandSbadLength#6884";$k[$j++]="M&S barcode must be 7 or 8 characters";bwipp_raiseerror()}if($_.barlen==7){var _7=$Z($s(8),"00000000");$P(_7,1,$_.barcode);$_.barcode=_7}$p($_.options,"dontdraw",true);$k[$j++]="args";$k[$j++]=$_.barcode;$k[$j++]=$_.options;bwipp_ean8();var _C=$k[--$j];$_[$k[--$j]]=_C;var _F=$g($_.args,"bbs");$p(_F,10,$g(_F,2));$p(_F,11,$g(_F,2));var _J=$g($_.args,"bhs");$p(_J,10,$g(_J,2));$p(_J,11,$g(_J,2));$_.txt=$g($_.args,"txt");if($_.barlen==7){for(var _P=0;_P<=6;_P+=1){var _Q=$_.txt;$P($g($g(_Q,_P),0),0,$g($g(_Q,_P+1),0))}$P($g($g($_.txt,7),0),0," ")}var _Y=$a(10);$P(_Y,0,$_.txt);$_.txt=_Y;var _b=$g($_.txt,0);$p($_.txt,8,$A($a(_b.length),_b));var _g=$g($_.txt,0);$p($_.txt,9,$A($a(_g.length),_g));$p($g($_.txt,8),0,"M");$p($g($_.txt,8),1,-12);$p($g($_.txt,9),0,"S");var _r=$g($_.txt,9);$p(_r,1,69);$p($_.args,"txt",$_.txt);$p($_.args,"opt",$_.options);$k[$j++]=$_.args;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_code128(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.includetext=false;$_.textfont="OCR-B";$_.textsize=10;$_.textxoffset=0;$_.textyoffset=-8;$_.height=1;$_.raw=false;$_.newencoder=false;$_.parse=false;$_.parsefnc=false;$_.suppressc=false;$_.unlatchextbeforec=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];$_.sta=-1;$_.stb=-2;$_.stc=-3;$_.swa=-4;$_.swb=-5;$_.swc=-6;$_.fn1=-7;$_.fn2=-8;$_.fn3=-9;$_.fn4=-10;$_.sft=-11;$_.stp=-12;$_.lka=-13;$_.lkc=-14;var _A=new Map([["parse",$_.parse],["parsefnc",$_.parsefnc],["FNC1",$_.fn1],["FNC2",$_.fn2],["FNC3",$_.fn3],["LNKA",$_.lka],["LNKC",$_.lkc]]);$_.fncvals=_A;$k[$j++]="msg";$k[$j++]=$_.barcode;$k[$j++]=$_.fncvals;bwipp_parseinput();var _D=$k[--$j];$_[$k[--$j]]=_D;$_.msglen=$_.msg.length;$_.encoding="legacy";if($_.newencoder){$_.encoding="new"}if($_.raw){$_.encoding="raw"}if($eq($_.encoding,"raw")){$_.cws=$a($_.barcode.length);$_.i=0;$_.j=0;for(;;){if($_.i==$_.barcode.length){break}$_.cw=$i($G($_.barcode,$_.i+1,3));$p($_.cws,$_.j,$_.cw);$_.i=$_.i+4;$_.j=$_.j+1}$_.cws=$G($_.cws,0,$_.j);$_.text=""}else{$_.text=$s($_.msglen);for(var _c=0,_b=$_.msglen-1;_c<=_b;_c+=1){$_.i=_c;var _h=$g($_.msg,$_.i);$k[$j++]=$_.text;$k[$j++]=$_.i;$k[$j++]=_h;if(_h<0){$k[$j-1]=32}var _i=$k[--$j];var _j=$k[--$j];$p($k[--$j],_j,_i)}}$_.charmaps=$a([$a([32,32,"00"]),$a(["!","!","01"]),$a(['"','"',"02"]),$a(["#","#","03"]),$a(["$","$","04"]),$a(["%","%","05"]),$a(["&","&","06"]),$a(["'","'","07"]),$a([40,40,"08"]),$a([41,41,"09"]),$a(["*","*","10"]),$a(["+","+","11"]),$a([",",",","12"]),$a(["-","-","13"]),$a([".",".","14"]),$a(["/","/","15"]),$a(["0","0","16"]),$a(["1","1","17"]),$a(["2","2","18"]),$a(["3","3","19"]),$a(["4","4","20"]),$a(["5","5","21"]),$a(["6","6","22"]),$a(["7","7","23"]),$a(["8","8","24"]),$a(["9","9","25"]),$a([":",":","26"]),$a([";",";","27"]),$a(["<","<","28"]),$a(["=","=","29"]),$a([">",">","30"]),$a(["?","?","31"]),$a(["@","@","32"]),$a(["A","A","33"]),$a(["B","B","34"]),$a(["C","C","35"]),$a(["D","D","36"]),$a(["E","E","37"]),$a(["F","F","38"]),$a(["G","G","39"]),$a(["H","H","40"]),$a(["I","I","41"]),$a(["J","J","42"]),$a(["K","K","43"]),$a(["L","L","44"]),$a(["M","M","45"]),$a(["N","N","46"]),$a(["O","O","47"]),$a(["P","P","48"]),$a(["Q","Q","49"]),$a(["R","R","50"]),$a(["S","S","51"]),$a(["T","T","52"]),$a(["U","U","53"]),$a(["V","V","54"]),$a(["W","W","55"]),$a(["X","X","56"]),$a(["Y","Y","57"]),$a(["Z","Z","58"]),$a(["[","[","59"]),$a([92,92,"60"]),$a(["]","]","61"]),$a(["^","^","62"]),$a(["_","_","63"]),$a([0,"`","64"]),$a([1,"a","65"]),$a([2,"b","66"]),$a([3,"c","67"]),$a([4,"d","68"]),$a([5,"e","69"]),$a([6,"f","70"]),$a([7,"g","71"]),$a([8,"h","72"]),$a([9,"i","73"]),$a([10,"j","74"]),$a([11,"k","75"]),$a([12,"l","76"]),$a([13,"m","77"]),$a([14,"n","78"]),$a([15,"o","79"]),$a([16,"p","80"]),$a([17,"q","81"]),$a([18,"r","82"]),$a([19,"s","83"]),$a([20,"t","84"]),$a([21,"u","85"]),$a([22,"v","86"]),$a([23,"w","87"]),$a([24,"x","88"]),$a([25,"y","89"]),$a([26,"z","90"]),$a([27,"{","91"]),$a([28,"|","92"]),$a([29,"}","93"]),$a([30,"~","94"]),$a([31,127,"95"]),$a([$_.fn3,$_.fn3,"96"]),$a([$_.fn2,$_.fn2,"97"]),$a([$_.sft,$_.sft,"98"]),$a([$_.swc,$_.swc,"99"]),$a([$_.swb,$_.fn4,$_.swb]),$a([$_.fn4,$_.swa,$_.swa]),$a([$_.fn1,$_.fn1,$_.fn1]),$a([$_.sta,$_.sta,$_.sta]),$a([$_.stb,$_.stb,$_.stb]),$a([$_.stc,$_.stc,$_.stc]),$a([$_.stp,$_.stp,$_.stp])]);$_.charvals=$a([new Map,new Map,new Map]);for(var _31=0,_30=$_.charmaps.length-1;_31<=_30;_31+=1){$_.i=_31;$_.encs=$g($_.charmaps,$_.i);for(var _35=0;_35<=2;_35+=1){$_.j=_35;var _38=$g($_.encs,$_.j);$k[$j++]=_38;if($eq($t(_38),"stringtype")){var _3B=$g($k[--$j],0);$k[$j++]=_3B}$p($g($_.charvals,$_.j),$k[--$j],$_.i)}}if($eq($_.encoding,"legacy")){$_.seta=$g($_.charvals,0);$p($_.seta,$_.lka,$g($_.seta,$_.swb));$p($_.seta,$_.lkc,$g($_.seta,$_.swc));$_.setb=$g($_.charvals,1);$p($_.setb,$_.lka,$g($_.setb,$_.swc));$p($_.setb,$_.lkc,$g($_.setb,$_.swa));$_.setc=$g($_.charvals,2);$p($_.setc,$_.lka,$g($_.setc,$_.swa));$p($_.setc,$_.lkc,$g($_.setc,$_.swb));$k[$j++]=Infinity;for(var _3u=0,_3v=$_.msglen;_3u<_3v;_3u++){$k[$j++]=0}$k[$j++]=0;$_.numSA=$a();$k[$j++]=Infinity;for(var _3y=0,_3z=$_.msglen;_3y<_3z;_3y++){$k[$j++]=0}$k[$j++]=0;$_.numEA=$a();for(var _42=$_.msglen-1;_42>=0;_42-=1){$_.i=_42;if($g($_.msg,$_.i)>=0){if($g($_.msg,$_.i)>=128){$p($_.numEA,$_.i,$g($_.numEA,$_.i+1)+1)}else{$p($_.numSA,$_.i,$g($_.numSA,$_.i+1)+1)}}}$_.ea=false;$_.msgtmp=$a([]);for(var _4M=0,_4L=$_.msglen-1;_4M<=_4L;_4M+=1){$_.i=_4M;$_.c=$g($_.msg,$_.i);if(!($_.ea!=$_.c<128)&&$_.c>=0){if($_.ea){$k[$j++]=$_.numSA}else{$k[$j++]=$_.numEA}var _4Y=$g($k[--$j],$_.i);var _4b=$f(_4Y+$_.i)==$_.msglen?3:5;if(_4Y<_4b){$k[$j++]=Infinity;$q($_.msgtmp);$k[$j++]=$_.fn4;$_.msgtmp=$a()}else{$k[$j++]=Infinity;$q($_.msgtmp);$k[$j++]=$_.fn4;$k[$j++]=$_.fn4;$_.msgtmp=$a();$_.ea=!$_.ea}}$k[$j++]=Infinity;$q($_.msgtmp);if($_.c>=0){$k[$j++]=$_.c&127}else{$k[$j++]=$_.c}$_.msgtmp=$a()}$_.msg=$_.msgtmp;$_.msglen=$_.msg.length;$_.numsscr=function(){$_.s=0;$_.p=$k[--$j];for(;;){if($_.p>=$_.msglen){break}var _4w=$g($_.msg,$_.p);var _4y=$g($_.setc,_4w)!==undefined;$k[$j++]=_4w;if(!_4y){$j--;break}var _4z=$k[$j-1];if(_4z<=-1){var _51=$k[--$j];if(_51==$_.fn1&&$_.s%2==0){$_.s=$_.s+1}else{break}}else{$j--}$_.s=$_.s+1;$_.p=$_.p+1}$k[$j++]=$_.s};$_.enca=function(){$p($_.cws,$_.j,$g($_.seta,$k[--$j]));$_.j=$_.j+1};$_.encb=function(){$p($_.cws,$_.j,$g($_.setb,$k[--$j]));$_.j=$_.j+1};$_.encc=function(){var _5J=$k[$j-1];if($ne($t(_5J),"arraytype")){var _5N=$g($_.setc,$k[--$j]);$k[$j++]=_5N}else{$q($k[--$j]);var _5P=$k[--$j];var _5Q=$k[--$j];$k[$j++]=$f(_5P-48+(_5Q-48)*10)}$p($_.cws,$_.j,$k[--$j]);$_.j=$_.j+1};$_.anotb=function(){var _5V=$k[--$j];var _5X=$g($_.seta,_5V)!==undefined;var _5Z=$g($_.setb,_5V)!==undefined;$k[$j++]=_5X&&!_5Z};$_.bnota=function(){var _5a=$k[--$j];var _5c=$g($_.setb,_5a)!==undefined;var _5e=$g($_.seta,_5a)!==undefined;$k[$j++]=_5c&&!_5e};$k[$j++]=Infinity;for(var _5g=0,_5h=$_.msg.length;_5g<_5h;_5g++){$k[$j++]=0}$k[$j++]=9999;$_.nextanotb=$a();$k[$j++]=Infinity;for(var _5k=0,_5l=$_.msg.length;_5k<_5l;_5k++){$k[$j++]=0}$k[$j++]=9999;$_.nextbnota=$a();for(var _5o=$_.msg.length-1;_5o>=0;_5o-=1){$_.i=_5o;$k[$j++]=$g($_.msg,$_.i);$_.anotb();if($k[--$j]){$p($_.nextanotb,$_.i,0)}else{$p($_.nextanotb,$_.i,$g($_.nextanotb,$_.i+1)+1)}$k[$j++]=$g($_.msg,$_.i);$_.bnota();if($k[--$j]){$p($_.nextbnota,$_.i,0)}else{$p($_.nextbnota,$_.i,$g($_.nextbnota,$_.i+1)+1)}}$_.abeforeb=function(){var _6B=$k[--$j];$k[$j++]=$lt($g($_.nextanotb,_6B),$g($_.nextbnota,_6B))};$_.bbeforea=function(){var _6G=$k[--$j];$k[$j++]=$lt($g($_.nextbnota,_6G),$g($_.nextanotb,_6G))};$_.cws=$a($_.barcode.length*2+3);$_.j=0;if($_.msglen>0){$k[$j++]=0;$_.numsscr()}else{$k[$j++]=-1}$_.nums=$k[--$j];for(;;){if($_.msglen==0){$k[$j++]=$_.stb;$_.enca();$_.cset="setb";break}if($_.msglen==2&&$_.nums==2){$k[$j++]=$_.stc;$_.enca();$_.cset="setc";break}if($_.nums>=4){$k[$j++]=$_.stc;$_.enca();$_.cset="setc";break}$k[$j++]=0;$_.abeforeb();if($k[--$j]){$k[$j++]=$_.sta;$_.enca();$_.cset="seta";break}$k[$j++]=$_.stb;$_.enca();$_.cset="setb";break}$_.i=0;for(;;){if($_.i==$_.msglen){break}$k[$j++]=$_.i;$_.numsscr();$_.nums=$k[--$j];for(;;){if(($eq($_.cset,"seta")||$eq($_.cset,"setb"))&&$_.nums>=4&&$g($_.msg,$_.i)!=$_.fn1){if($_.nums%2==0){$k[$j++]=$_.swc;if($eq($_.cset,"seta")){$_.enca()}else{$_.encb()}$_.cset="setc";break}else{$k[$j++]=$g($_.msg,$_.i);if($eq($_.cset,"seta")){$_.enca()}else{$_.encb()}$_.i=$_.i+1;$k[$j++]=$_.i;$_.numsscr();if($k[--$j]>=4){$k[$j++]=$_.swc;if($eq($_.cset,"seta")){$_.enca()}else{$_.encb()}$_.cset="setc";break}}}$k[$j++]=$eq($_.cset,"setb");$k[$j++]=$g($_.msg,$_.i);$_.anotb();var _70=$k[--$j];if($k[--$j]&&_70){if($_.i<$_.msglen-1){$k[$j++]=$_.i+1;$_.bbeforea();if($k[--$j]){$k[$j++]=$_.sft;$_.encb();$k[$j++]=$g($_.msg,$_.i);$_.enca();$_.i=$_.i+1;break}}$k[$j++]=$_.swa;$_.encb();$_.cset="seta";break}$k[$j++]=$eq($_.cset,"seta");$k[$j++]=$g($_.msg,$_.i);$_.bnota();var _7G=$k[--$j];if($k[--$j]&&_7G){if($_.i<$_.msglen-1){$k[$j++]=$_.i+1;$_.abeforeb();if($k[--$j]){$k[$j++]=$_.sft;$_.enca();$k[$j++]=$g($_.msg,$_.i);$_.encb();$_.i=$_.i+1;break}}$k[$j++]=$_.swb;$_.enca();$_.cset="setb";break}if($eq($_.cset,"setc")&&$_.nums<2&&($g($_.msg,$_.i)>-1||$g($_.msg,$_.i)==$_.fn4)){$k[$j++]=$_.i;$_.abeforeb();if($k[--$j]){$k[$j++]=$_.swa;$_.encc();$_.cset="seta";break}$k[$j++]=$_.swb;$_.encc();$_.cset="setb";break}if($eq($_.cset,"seta")){$k[$j++]=$g($_.msg,$_.i);$_.enca();$_.i=$_.i+1;break}if($eq($_.cset,"setb")){$k[$j++]=$g($_.msg,$_.i);$_.encb();$_.i=$_.i+1;break}if($eq($_.cset,"setc")){if($g($_.msg,$_.i)<=-1){$k[$j++]=$g($_.msg,$_.i);$_.encc();$_.i=$_.i+1}else{$k[$j++]=$G($_.msg,$_.i,2);$_.encc();$_.i=$_.i+2}break}break}}$_.cws=$G($_.cws,0,$_.j)}if($eq($_.encoding,"new")){$k[$j++]=Infinity;$k[$j++]=$_.fn3;$k[$j++]=96;$k[$j++]=$_.fn2;$k[$j++]=97;$k[$j++]=$_.fn1;$k[$j++]=102;$k[$j++]=$_.stp;$k[$j++]=106;$k[$j++]=$_.lka;$k[$j++]=100;$k[$j++]=$_.lkc;$k[$j++]=99;$_.seta=$d();$k[$j++]=Infinity;$k[$j++]=$_.fn3;$k[$j++]=96;$k[$j++]=$_.fn2;$k[$j++]=97;$k[$j++]=$_.fn1;$k[$j++]=102;$k[$j++]=$_.stp;$k[$j++]=106;$k[$j++]=$_.lka;$k[$j++]=99;$k[$j++]=$_.lkc;$k[$j++]=101;$_.setb=$d();$k[$j++]=Infinity;$k[$j++]=$_.fn1;$k[$j++]=102;$k[$j++]=$_.stp;$k[$j++]=106;$k[$j++]=$_.lka;$k[$j++]=101;$k[$j++]=$_.lkc;$k[$j++]=100;$_.setc=$d();$_.latch_a0=$a(["","e","e","ee","eee","eee"]);$_.latch_b0=$a(["d","","d","ddd","dd","ddd"]);$_.latch_c0=$a(["c","c","","eec","ddc","dddc"]);$_.latch_a1=$a(["ee","eee","eee","","e","e"]);$_.latch_b1=$a(["ddd","dd","ddd","d","","d"]);$_.latch_c1=$a(["eec","ddc","dddc","c","c",""]);$k[$j++]=Infinity;var _8U=$_.latch_a0;for(var _8V=0,_8W=_8U.length;_8V<_8W;_8V++){$k[$j++]=$g(_8U,_8V).length}$_.latch_length_a0=$a();$k[$j++]=Infinity;var _8Z=$_.latch_a1;for(var _8a=0,_8b=_8Z.length;_8a<_8b;_8a++){$k[$j++]=$g(_8Z,_8a).length}$_.latch_length_a1=$a();$k[$j++]=Infinity;var _8e=$_.latch_b0;for(var _8f=0,_8g=_8e.length;_8f<_8g;_8f++){$k[$j++]=$g(_8e,_8f).length}$_.latch_length_b0=$a();$k[$j++]=Infinity;var _8j=$_.latch_b1;for(var _8k=0,_8l=_8j.length;_8k<_8l;_8k++){$k[$j++]=$g(_8j,_8k).length}$_.latch_length_b1=$a();$k[$j++]=Infinity;var _8o=$_.latch_c0;for(var _8p=0,_8q=_8o.length;_8p<_8q;_8p++){$k[$j++]=$g(_8o,_8p).length}$_.latch_length_c0=$a();$k[$j++]=Infinity;var _8t=$_.latch_c1;for(var _8u=0,_8v=_8t.length;_8u<_8v;_8u++){$k[$j++]=$g(_8t,_8u).length}$_.latch_length_c1=$a();$_.latch_sequence=$a([$_.latch_a0,$_.latch_b0,$_.latch_c0,$_.latch_a1,$_.latch_b1,$_.latch_c1]);var _95=$a([function(){$_.enc_a0()},function(){$_.enc_b0()},function(){$_.enc_c()},function(){$_.enc_a1()},function(){$_.enc_b1()},function(){$_.enc_c()}]);$_.encode=_95;$_.start_code=$a([103,104,105]);$_.state_priority=$a([1,0,2,4,3,5]);$_.start_state=$a([0,1,2,0,1,2]);$_.start_length=$a([1,1,1,1,1,1]);$k[$j++]=Infinity;var _9A=$a([5,4,3,2,1,0]);for(var _9B=0,_9C=_9A.length;_9B<_9C;_9B++){$k[$j++]=$g($_.state_priority,$g(_9A,_9B))}$_.reverse_priority=$a();$k[$j++]=Infinity;var _9H=$_.reverse_priority;for(var _9I=0,_9J=_9H.length;_9I<_9J;_9I++){var _9K=$g(_9H,_9I);$k[$j++]=_9K;$k[$j++]=$g($_.latch_length_a0,_9K);$k[$j++]=_9K}$_.prioritized_latch_length_a0=$a();$k[$j++]=Infinity;var _9O=$_.reverse_priority;for(var _9P=0,_9Q=_9O.length;_9P<_9Q;_9P++){var _9R=$g(_9O,_9P);$k[$j++]=_9R;$k[$j++]=$g($_.latch_length_a1,_9R);$k[$j++]=_9R}$_.prioritized_latch_length_a1=$a();$k[$j++]=Infinity;var _9V=$_.reverse_priority;for(var _9W=0,_9X=_9V.length;_9W<_9X;_9W++){var _9Y=$g(_9V,_9W);$k[$j++]=_9Y;$k[$j++]=$g($_.latch_length_b0,_9Y);$k[$j++]=_9Y}$_.prioritized_latch_length_b0=$a();$k[$j++]=Infinity;var _9c=$_.reverse_priority;for(var _9d=0,_9e=_9c.length;_9d<_9e;_9d++){var _9f=$g(_9c,_9d);$k[$j++]=_9f;$k[$j++]=$g($_.latch_length_b1,_9f);$k[$j++]=_9f}$_.prioritized_latch_length_b1=$a();$k[$j++]=Infinity;var _9j=$_.reverse_priority;for(var _9k=0,_9l=_9j.length;_9k<_9l;_9k++){var _9m=$g(_9j,_9k);$k[$j++]=_9m;$k[$j++]=$g($_.latch_length_c0,_9m);$k[$j++]=_9m}$_.prioritized_latch_length_c0=$a();$k[$j++]=Infinity;var _9q=$_.reverse_priority;for(var _9r=0,_9s=_9q.length;_9r<_9s;_9r++){var _9t=$g(_9q,_9r);$k[$j++]=_9t;$k[$j++]=$g($_.latch_length_c1,_9t);$k[$j++]=_9t}$_.prioritized_latch_length_c1=$a();$_.max_int=2147483647;$_.can_a=function(){if($_.c>=0){$k[$j++]=true}else{var _A0=$g($_.seta,$_.c)!==undefined;$k[$j++]=_A0}};$_.can_b=function(){if($_.c>=0){$k[$j++]=true}else{var _A4=$g($_.setb,$_.c)!==undefined;$k[$j++]=_A4}};$_.can_c0=function(){if($_.num_digits>=2){$k[$j++]=true}else{var _A8=$g($_.setc,$_.c)!==undefined;$k[$j++]=_A8}};$_.can_c1=function(){if($_.num_digits>=2){$k[$j++]=true}else{var _AC=$g($_.setc,$_.c)!==undefined;$k[$j++]=_AC}};if($_.suppressc){$_.can_c0=function(){$k[$j++]=false}}if($_.suppressc||$_.unlatchextbeforec){$_.can_c1=function(){$k[$j++]=false}}$_.out_a0=function(){$k[$j++]=1;if($_.c>=0){if($_.c>=128){var _AI=$k[--$j];$k[$j++]=_AI+1}if(($_.c&127)>=96){var _AK=$k[--$j];$k[$j++]=_AK+1}}};$_.out_a1=function(){$k[$j++]=1;if($_.c>=0){if($_.c<128){var _AN=$k[--$j];$k[$j++]=_AN+1}if(($_.c&127)>=96){var _AP=$k[--$j];$k[$j++]=_AP+1}}};$_.out_b0=function(){$k[$j++]=1;if($_.c>=0){if($_.c>=128){var _AS=$k[--$j];$k[$j++]=_AS+1}if(($_.c&127)<32){var _AU=$k[--$j];$k[$j++]=_AU+1}}};$_.out_b1=function(){$k[$j++]=1;if($_.c>=0){if($_.c<128){var _AX=$k[--$j];$k[$j++]=_AX+1}if(($_.c&127)<32){var _AZ=$k[--$j];$k[$j++]=_AZ+1}}};$_.map_ab=function(){var _Aa=$k[$j-1];if(_Aa<32){var _Ab=$k[--$j];$k[$j++]=_Ab+64}else{var _Ac=$k[--$j];$k[$j++]=_Ac-32}};$_.enc_a0=function(){$k[$j++]=Infinity;if($_.c<0){$k[$j++]=$g($_.seta,$_.c)}else{if($_.c>=128){$k[$j++]=101}var _Aj=$_.c&127;$k[$j++]=_Aj;if(_Aj>=96){var _Ak=$k[--$j];$k[$j++]=98;$k[$j++]=_Ak}$_.map_ab()}var _Al=$a();$k[$j++]=_Al};$_.enc_a1=function(){$k[$j++]=Infinity;if($_.c<0){$k[$j++]=$g($_.seta,$_.c)}else{if($_.c<128){$k[$j++]=101}var _As=$_.c&127;$k[$j++]=_As;if(_As>=96){var _At=$k[--$j];$k[$j++]=98;$k[$j++]=_At}$_.map_ab()}var _Au=$a();$k[$j++]=_Au};$_.enc_b0=function(){$k[$j++]=Infinity;if($_.c<0){$k[$j++]=$g($_.setb,$_.c)}else{if($_.c>=128){$k[$j++]=100}var _B1=$_.c&127;$k[$j++]=_B1;if(_B1<32){var _B2=$k[--$j];$k[$j++]=98;$k[$j++]=_B2}$_.map_ab()}var _B3=$a();$k[$j++]=_B3};$_.enc_b1=function(){$k[$j++]=Infinity;if($_.c<0){$k[$j++]=$g($_.setb,$_.c)}else{if($_.c<128){$k[$j++]=100}var _BA=$_.c&127;$k[$j++]=_BA;if(_BA<32){var _BB=$k[--$j];$k[$j++]=98;$k[$j++]=_BB}$_.map_ab()}var _BC=$a();$k[$j++]=_BC};$_.enc_c=function(){$k[$j++]=Infinity;if($_.c<0){$k[$j++]=$g($_.setc,$_.c)}else{$k[$j++]=$f(($g($_.msg,$_.n)-48)*10+($g($_.msg,$_.n+1)-48))}var _BN=$a();$k[$j++]=_BN};$_.get_best_prior_state=function(){var _BQ=$g($_.bln_0,$k[--$j]);$_.len=$f($k[--$j]+_BQ);$_.o=$k[--$j];var _BV=$g($_.bln_0,$k[--$j]);var _BX=$f($k[--$j]+_BV);$k[$j++]=_BX;if(_BX<$_.len){$_.len=$k[--$j];$_.o=$k[--$j]}else{$j-=2}var _Bd=$g($_.bln_0,$k[--$j]);var _Bf=$f($k[--$j]+_Bd);$k[$j++]=_Bf;if(_Bf<$_.len){$_.len=$k[--$j];$_.o=$k[--$j]}else{$j-=2}var _Bl=$g($_.bln_0,$k[--$j]);var _Bn=$f($k[--$j]+_Bl);$k[$j++]=_Bn;if(_Bn<$_.len){$_.len=$k[--$j];$_.o=$k[--$j]}else{$j-=2}var _Bt=$g($_.bln_0,$k[--$j]);var _Bv=$f($k[--$j]+_Bt);$k[$j++]=_Bv;if(_Bv<$_.len){$_.len=$k[--$j];$_.o=$k[--$j]}else{$j-=2}var _C1=$g($_.bln_0,$k[--$j]);if($f($k[--$j]+_C1)<$_.len){$_.o=$k[--$j]}else{$j--}$k[$j++]=$_.o};$_.bln_0=$_.start_length;$_.bln_1=$_.start_length;$k[$j++]=Infinity;for(var _C8=0;_C8<4;_C8++){$k[$j++]=$a([0,0,0,0,0,0])}$_.bln=$a();$_.bps_0=$_.start_state;$_.bps_1=$_.start_state;$k[$j++]=Infinity;for(var _CD=0;_CD<4;_CD++){$k[$j++]=$a([0,0,0,0,0,0])}$_.bps=$a();$k[$j++]=Infinity;for(var _CH=0,_CI=$_.msg.length;_CH<_CI;_CH++){$k[$j++]=$a([0,0,0,0,0,0])}$_.path=$a();$_.make_tables=function(){$_.num_digits=0;for(var _CN=0,_CM=$_.msg.length-1;_CN<=_CM;_CN+=1){$_.n=_CN;$_.c=$g($_.msg,$_.n);$k[$j++]="num_digits";if($_.c>=48&&$_.c<58){$k[$j++]=$_.num_digits+1}else{$k[$j++]=0}var _CU=$k[--$j];$_[$k[--$j]]=_CU;$_.bln_2=$_.bln_1;$_.bln_1=$_.bln_0;$_.bln_0=$g($_.bln,$_.n&3);$_.bps_2=$_.bps_1;$_.bps_1=$_.bps_0;$_.bps_0=$g($_.bps,$_.n&3);$k[$j++]="bps_c";if($_.num_digits>=2){$k[$j++]=$_.bps_2}else{$k[$j++]=$_.bps_1}var _Cj=$k[--$j];$_[$k[--$j]]=_Cj;$k[$j++]="bln_c";if($_.num_digits>=2){$k[$j++]=$_.bln_2}else{$k[$j++]=$_.bln_1}var _Co=$k[--$j];$_[$k[--$j]]=_Co;$k[$j++]=$_.bln_0;$k[$j++]=0;$_.can_a();if($k[--$j]){$_.p=$g($_.bps_1,0);$p($g($_.path,$_.n),0,$_.p);$k[$j++]=$f($g($_.bln_1,$_.p)+$g($_.latch_length_a0,$_.p));$_.out_a0();var _D4=$k[--$j];var _D5=$k[--$j];$k[$j++]=$f(_D5+_D4)}else{$k[$j++]=$_.max_int}var _D7=$k[--$j];var _D8=$k[--$j];$p($k[--$j],_D8,_D7);$k[$j++]=$_.bln_0;$k[$j++]=3;$_.can_a();if($k[--$j]){$_.p=$g($_.bps_1,3);$p($g($_.path,$_.n),3,$_.p);$k[$j++]=$f($g($_.bln_1,$_.p)+$g($_.latch_length_a1,$_.p));$_.out_a1();var _DO=$k[--$j];var _DP=$k[--$j];$k[$j++]=$f(_DP+_DO)}else{$k[$j++]=$_.max_int}var _DR=$k[--$j];var _DS=$k[--$j];$p($k[--$j],_DS,_DR);$k[$j++]=$_.bln_0;$k[$j++]=1;$_.can_b();if($k[--$j]){$_.p=$g($_.bps_1,1);$p($g($_.path,$_.n),1,$_.p);$k[$j++]=$f($g($_.bln_1,$_.p)+$g($_.latch_length_b0,$_.p));$_.out_b0();var _Di=$k[--$j];var _Dj=$k[--$j];$k[$j++]=$f(_Dj+_Di)}else{$k[$j++]=$_.max_int}var _Dl=$k[--$j];var _Dm=$k[--$j];$p($k[--$j],_Dm,_Dl);$k[$j++]=$_.bln_0;$k[$j++]=4;$_.can_b();if($k[--$j]){$_.p=$g($_.bps_1,4);$p($g($_.path,$_.n),4,$_.p);$k[$j++]=$f($g($_.bln_1,$_.p)+$g($_.latch_length_b1,$_.p));$_.out_b1();var _E2=$k[--$j];var _E3=$k[--$j];$k[$j++]=$f(_E3+_E2)}else{$k[$j++]=$_.max_int}var _E5=$k[--$j];var _E6=$k[--$j];$p($k[--$j],_E6,_E5);$k[$j++]=$_.bln_0;$k[$j++]=2;$_.can_c0();if($k[--$j]){$_.p=$g($_.bps_c,2);$p($g($_.path,$_.n),2,$_.p);$k[$j++]=$f($g($_.bln_c,$_.p)+$g($_.latch_length_c0,$_.p))+1}else{$k[$j++]=$_.max_int}var _EN=$k[--$j];var _EO=$k[--$j];$p($k[--$j],_EO,_EN);$k[$j++]=$_.bln_0;$k[$j++]=5;$_.can_c1();if($k[--$j]){$_.p=$g($_.bps_c,5);$p($g($_.path,$_.n),5,$_.p);$k[$j++]=$f($g($_.bln_c,$_.p)+$g($_.latch_length_c1,$_.p))+1}else{$k[$j++]=$_.max_int}var _Ef=$k[--$j];var _Eg=$k[--$j];$p($k[--$j],_Eg,_Ef);$k[$j++]=$_.bps_0;$k[$j++]=0;$q($_.prioritized_latch_length_a0);$_.get_best_prior_state();var _Ek=$k[--$j];var _El=$k[--$j];$p($k[--$j],_El,_Ek);$k[$j++]=$_.bps_0;$k[$j++]=3;$q($_.prioritized_latch_length_a1);$_.get_best_prior_state();var _Ep=$k[--$j];var _Eq=$k[--$j];$p($k[--$j],_Eq,_Ep);$k[$j++]=$_.bps_0;$k[$j++]=1;$q($_.prioritized_latch_length_b0);$_.get_best_prior_state();var _Eu=$k[--$j];var _Ev=$k[--$j];$p($k[--$j],_Ev,_Eu);$k[$j++]=$_.bps_0;$k[$j++]=4;$q($_.prioritized_latch_length_b1);$_.get_best_prior_state();var _Ez=$k[--$j];var _F0=$k[--$j];$p($k[--$j],_F0,_Ez);$k[$j++]=$_.bps_0;$k[$j++]=2;$q($_.prioritized_latch_length_c0);$_.get_best_prior_state();var _F4=$k[--$j];var _F5=$k[--$j];$p($k[--$j],_F5,_F4);$k[$j++]=$_.bps_0;$k[$j++]=5;$q($_.prioritized_latch_length_c1);$_.get_best_prior_state();var _F9=$k[--$j];var _FA=$k[--$j];$p($k[--$j],_FA,_F9)}};$_.backtrack=function(){$_.n=$_.msg.length;var _FD=$_.reverse_priority;for(var _FE=0,_FF=_FD.length;_FE<_FF;_FE++){var _FG=$g(_FD,_FE);var _FI=$g($_.bln_0,_FG);$k[$j++]=_FG;$k[$j++]=_FI;$k[$j++]=_FI}$j--;$_.len=$k[--$j];$_.state=$k[--$j];for(var _FL=0;_FL<5;_FL++){if($lt($k[--$j],$_.len)){$_.len=$k[--$j];$_.state=$k[--$j]}else{$j-=2}}$k[$j++]=$a($_.len);for(;;){if($_.n<=0){break}$_.prior_state=$g($g($_.path,$_.n-1),$_.state);$k[$j++]=Infinity;$F($g($g($_.latch_sequence,$_.state),$_.prior_state));$_.latch=$a();var _Fk=($_.state==2||$_.state==5)&&$g($_.msg,$_.n-1)>=48?2:1;$_.n=$_.n-_Fk;$_.c=$g($_.msg,$_.n);$k[$j++]="enc";if($g($_.encode,$_.state)()===true){break}var _Fr=$k[--$j];$_[$k[--$j]]=_Fr;$_.len=$f($_.len-$_.latch.length-$_.enc.length);var _Fw=$k[--$j];var _Fx=$_.len;var _Fy=$_.latch;$P(_Fw,_Fx,_Fy);$P(_Fw,$f(_Fx+_Fy.length),$_.enc);$_.state=$_.prior_state;$k[$j++]=_Fw}var _G1=$k[$j-1];$p(_G1,0,$g($_.start_code,$_.state))};$_.make_tables();$_.backtrack();$_.cws=$k[--$j]}$_.j=$_.cws.length;var _G8=$a($_.j+2);$P(_G8,0,$_.cws);$_.cws=_G8;$_.csum=$g($_.cws,0);for(var _GE=1,_GD=$_.j-1;_GE<=_GD;_GE+=1){$_.i=_GE;$_.csum=$f($_.csum+$g($_.cws,$_.i)*$_.i)}$_.csum=$_.csum%103;$p($_.cws,$_.j,$_.csum);$p($_.cws,$_.j+1,106);var _GR=$g($_.options,"debugcws")!==undefined;if(_GR){$k[$j++]="bwipp.debugcws#7483";$k[$j++]=$_.cws;bwipp_raiseerror()}$_.encs=$a(["212222","222122","222221","121223","121322","131222","122213","122312","132212","221213","221312","231212","112232","122132","122231","113222","123122","123221","223211","221132","221231","213212","223112","312131","311222","321122","321221","312212","322112","322211","212123","212321","232121","111323","131123","131321","112313","132113","132311","211313","231113","231311","112133","112331","132131","113123","113321","133121","313121","211331","231131","213113","213311","213131","311123","311321","331121","312113","312311","332111","314111","221411","431111","111224","111422","121124","121421","141122","141221","112214","112412","122114","122411","142112","142211","241211","221114","413111","241112","134111","111242","121142","121241","114212","124112","124211","411212","421112","421211","212141","214121","412121","111143","111341","131141","114113","114311","411113","411311","113141","114131","311141","411131","211412","211214","211232","2331112"]);$_.sbs=$s($_.cws.length*6+1);for(var _GZ=0,_GY=$_.cws.length-1;_GZ<=_GY;_GZ+=1){$_.i=_GZ;$P($_.sbs,$_.i*6,$g($_.encs,$g($_.cws,$_.i)))}$k[$j++]=Infinity;$k[$j++]=Infinity;var _Gh=$_.sbs;for(var _Gi=0,_Gj=_Gh.length;_Gi<_Gj;_Gi++){$k[$j++]=$g(_Gh,_Gi)-48}var _Gl=$a();$k[$j++]=Infinity;for(var _Gn=0,_Go=~~(($_.sbs.length+1)/2);_Gn<_Go;_Gn++){$k[$j++]=$_.height}var _Gq=$a();$k[$j++]=Infinity;for(var _Gs=0,_Gt=~~(($_.sbs.length+1)/2);_Gs<_Gt;_Gs++){$k[$j++]=0}var _Gu=$a();$k[$j++]="ren";$k[$j++]="renlinear";$k[$j++]="sbs";$k[$j++]=_Gl;$k[$j++]="bhs";$k[$j++]=_Gq;$k[$j++]="bbs";$k[$j++]=_Gu;$k[$j++]="txt";$k[$j++]=$a([$a([$_.text,$_.textxoffset,$_.textyoffset,$_.textfont,$_.textsize])]);$k[$j++]="textxalign";$k[$j++]="center";$k[$j++]="opt";$k[$j++]=$_.options;var _H3=$d();$k[$j++]=_H3;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_gs1_128(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.includetext=false;$_.textfont="OCR-B";$_.textsize=10;$_.textxoffset=0;$_.textyoffset=-8;$_.height=.5;$_.linkagea=false;$_.linkagec=false;$_.parse=false;$_.dontlint=false;$_.lintreqs=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.linkagea&&$_.linkagec){$k[$j++]="bwipp.gs1128badLinkage#7580";$k[$j++]="linkagea and linkagec cannot be used together";bwipp_raiseerror()}$_.text=$_.barcode;$k[$j++]=$_.barcode;$k[$j++]="ai";bwipp_gs1process();$_.fncs=$k[--$j];$_.vals=$k[--$j];$_.ais=$k[--$j];$_.fnc1=-1;$_.c128=$a([$_.fnc1]);for(var _D=0,_C=$_.ais.length-1;_D<=_C;_D+=1){$_.i=_D;$_.ai=$g($_.ais,$_.i);$_.val=$g($_.vals,$_.i);var _N=$a($_.c128.length+$_.ai.length+$_.val.length);$P(_N,0,$_.c128);$k[$j++]=_N;$k[$j++]=_N;$k[$j++]=$_.c128.length;var _R=Infinity;var _S=$_.ai;$k[$j++]=_R;$F(_S);var _T=$a();var _U=$k[--$j];$P($k[--$j],_U,_T);var _W=$k[$j-1];$k[$j++]=_W;$k[$j++]=$_.c128.length+$_.ai.length;var _a=Infinity;var _b=$_.val;$k[$j++]=_a;$F(_b);var _c=$a();var _d=$k[--$j];$P($k[--$j],_d,_c);$_.c128=$k[--$j];if($_.i!=$_.ais.length-1&&$g($_.fncs,$_.i)){var _m=$a($_.c128.length+1);$P(_m,0,$_.c128);$p(_m,$_.c128.length,$_.fnc1);$_.c128=_m}}$_.barcode=$s(($_.c128.length+1)*5);$_.i=0;$_.j=0;for(;;){if($_.i==$_.c128.length){break}var _w=$g($_.c128,$_.i);$k[$j++]=_w;if(_w==$_.fnc1){$j--;$P($_.barcode,$_.j,"^FNC1");$_.j=$_.j+4}else{$p($_.barcode,$_.j,$k[--$j])}$_.i=$_.i+1;$_.j=$_.j+1}if($_.linkagea||$_.linkagec){$k[$j++]=$_.barcode;$k[$j++]=$_.j;if($_.linkagea){$k[$j++]="^LNKA"}else{$k[$j++]="^LNKC"}var _1B=$k[--$j];var _1C=$k[--$j];$P($k[--$j],_1C,_1B);$_.j=$_.j+5}$_.barcode=$G($_.barcode,0,$_.j);delete $_.options["parse"];$p($_.options,"height",$_.height);$p($_.options,"dontdraw",true);$p($_.options,"parsefnc",true);$k[$j++]="args";$k[$j++]=$_.barcode;$k[$j++]=$_.options;bwipp_code128();var _1P=$k[--$j];$_[$k[--$j]]=_1P;$p($_.args,"txt",$a([$a([$_.text,$_.textxoffset,$_.textyoffset,$_.textfont,$_.textsize])]));$p($_.args,"textxalign","center");$p($_.args,"opt",$_.options);$k[$j++]=$_.args;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_ean14(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.includetext=false;$_.textfont="OCR-B";$_.textsize=10;$_.textxoffset=0;$_.textyoffset=-8;$_.height=1;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];$_.text=$_.barcode;var _3=$_.barcode;$k[$j++]=$s(_3.length);$k[$j++]=0;$F(_3,function(){var _5=$k[$j-1];if(_5!=32){var _6=$k[--$j];var _7=$k[--$j];var _8=$k[$j-1];$p(_8,_7,_6);$k[$j++]=_7+1}else{$j--}});var _9=$k[--$j];$_.barcode=$G($k[--$j],0,_9);$_.hasspace=$_.text.length!=$_.barcode.length;if($_.barcode.length!=17&&$_.barcode.length!=18){$k[$j++]="bwipp.ean14badLength#7695";$k[$j++]="EAN-14 must be 13 or 14 digits";bwipp_raiseerror()}if($ne($G($_.barcode,0,4),"(01)")){$k[$j++]="bwipp.ean14badAI#7698";$k[$j++]="EAN-14 must begin with (01) application identifier";bwipp_raiseerror()}var _K=$G($_.barcode,4,$_.barcode.length-4);for(var _L=0,_M=_K.length;_L<_M;_L++){var _N=$g(_K,_L);if(_N<48||_N>57){$k[$j++]="bwipp.ean14badCharacter#7702";$k[$j++]="EAN-14 must contain only digits";bwipp_raiseerror()}}$_.checksum=0;for(var _O=0;_O<=12;_O+=1){$_.i=_O;$k[$j++]="checksum";$k[$j++]=$_.checksum;$k[$j++]=$g($_.barcode,$_.i+4)-48;if($_.i%2==0){var _U=$k[--$j];$k[$j++]=_U*3}var _V=$k[--$j];var _W=$k[--$j];$_[$k[--$j]]=$f(_W+_V)}$_.checksum=(10-$_.checksum%10)%10;if($_.barcode.length==18){if($g($_.barcode,17)!=$_.checksum+48){$k[$j++]="bwipp.ean14badCheckDigit#7715";$k[$j++]="Incorrect EAN-14 check digit provided";bwipp_raiseerror()}}else{var _d=$s(18);$P(_d,0,$_.barcode);$p(_d,17,$_.checksum+48);$_.barcode=_d;var _i=$_.hasspace?2:1;var _j=$s($_.text.length+_i);$P(_j,_j.length-2," ");$p(_j,_j.length-1,$_.checksum+48);$P(_j,0,$_.text);$_.text=_j}$_.gtin=$G($_.barcode,4,14);$_.barcode=$s(21);$P($_.barcode,0,"^FNC101");var _r=$_.gtin;$P($_.barcode,7,_r);$p($_.options,"dontdraw",true);$p($_.options,"parsefnc",true);$k[$j++]="args";$k[$j++]=$_.barcode;$k[$j++]=$_.options;bwipp_code128();var _w=$k[--$j];$_[$k[--$j]]=_w;$p($_.args,"txt",$a([$a([$_.text,$_.textxoffset,$_.textyoffset,$_.textfont,$_.textsize])]));$p($_.args,"textxalign","center");$p($_.args,"opt",$_.options);$k[$j++]=$_.args;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_sscc18(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.includetext=false;$_.textfont="OCR-B";$_.textsize=10;$_.textxoffset=0;$_.textyoffset=-8;$_.height=1;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];$_.text=$_.barcode;var _3=$_.barcode;$k[$j++]=$s(_3.length);$k[$j++]=0;$F(_3,function(){var _5=$k[$j-1];if(_5!=32){var _6=$k[--$j];var _7=$k[--$j];var _8=$k[$j-1];$p(_8,_7,_6);$k[$j++]=_7+1}else{$j--}});var _9=$k[--$j];$_.barcode=$G($k[--$j],0,_9);$_.hasspace=$_.text.length!=$_.barcode.length;if($_.barcode.length!=21&&$_.barcode.length!=22){$k[$j++]="bwipp.sscc18badLength#7799";$k[$j++]="SSCC-18 must be 17 or 18 digits";bwipp_raiseerror()}if($ne($G($_.barcode,0,4),"(00)")){$k[$j++]="bwipp.sscc18badAI#7802";$k[$j++]="SSCC-18 must begin with (00) application identifier";bwipp_raiseerror()}var _K=$G($_.barcode,4,$_.barcode.length-4);for(var _L=0,_M=_K.length;_L<_M;_L++){var _N=$g(_K,_L);if(_N<48||_N>57){$k[$j++]="bwipp.sscc18badCharacter#7806";$k[$j++]="SSCC-18 must contain only digits";bwipp_raiseerror()}}$_.checksum=0;for(var _O=0;_O<=16;_O+=1){$_.i=_O;$k[$j++]="checksum";$k[$j++]=$_.checksum;$k[$j++]=$g($_.barcode,$_.i+4)-48;if($_.i%2==0){var _U=$k[--$j];$k[$j++]=_U*3}var _V=$k[--$j];var _W=$k[--$j];$_[$k[--$j]]=$f(_W+_V)}$_.checksum=(10-$_.checksum%10)%10;if($_.barcode.length==22){if($g($_.barcode,21)!=$_.checksum+48){$k[$j++]="bwipp.sscc18badCheckDigit#7819";$k[$j++]="Incorrect SSCC-18 check digit provided";bwipp_raiseerror()}}else{var _d=$s(22);$P(_d,0,$_.barcode);$p(_d,21,$_.checksum+48);$_.barcode=_d;var _i=$_.hasspace?2:1;var _j=$s($_.text.length+_i);$P(_j,_j.length-2," ");$p(_j,_j.length-1,$_.checksum+48);$P(_j,0,$_.text);$_.text=_j}$_.sscc=$G($_.barcode,4,18);$_.barcode=$s(25);$P($_.barcode,0,"^FNC100");var _r=$_.sscc;$P($_.barcode,7,_r);$p($_.options,"dontdraw",true);$p($_.options,"parsefnc",true);$k[$j++]="args";$k[$j++]=$_.barcode;$k[$j++]=$_.options;bwipp_code128();var _w=$k[--$j];$_[$k[--$j]]=_w;$p($_.args,"txt",$a([$a([$_.text,$_.textxoffset,$_.textyoffset,$_.textfont,$_.textsize])]));$p($_.args,"textxalign","center");$p($_.args,"opt",$_.options);$k[$j++]=$_.args;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_code39(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.includecheck=false;$_.validatecheck=false;$_.includetext=false;$_.includecheckintext=false;$_.hidestars=false;$_.textfont="OCR-B";$_.textsize=10;$_.textyoffset=-8;$_.height=1;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.barcode.length==0){$k[$j++]="bwipp.code39emptyData#7899";$k[$j++]="The data must not be empty";bwipp_raiseerror()}$_.encs=$a(["1113313111","3113111131","1133111131","3133111111","1113311131","3113311111","1133311111","1113113131","3113113111","1133113111","3111131131","1131131131","3131131111","1111331131","3111331111","1131331111","1111133131","3111133111","1131133111","1111333111","3111111331","1131111331","3131111311","1111311331","3111311311","1131311311","1111113331","3111113311","1131113311","1111313311","3311111131","1331111131","3331111111","1311311131","3311311111","1331311111","1311113131","3311113111","1331113111","1313131111","1313111311","1311131311","1113131311","1311313111"]);$_.barchars="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%";$_.charvals=new Map;for(var _4=0;_4<=42;_4+=1){$p($_.charvals,$G($_.barchars,_4,1),_4)}for(var _B=0,_A=$_.barcode.length-1;_B<=_A;_B+=1){var _F=$g($_.charvals,$G($_.barcode,_B,1))!==undefined;if(!_F){$k[$j++]="bwipp.code39badCharacter#7927";$k[$j++]="Code 39 must contain only digits, capital letters, spaces and the symbols -.$/+%";bwipp_raiseerror()}}$k[$j++]="barlen";$k[$j++]=$_.barcode.length;if($_.validatecheck){var _I=$k[--$j];$k[$j++]=_I-1}var _J=$k[--$j];$_[$k[--$j]]=_J;$_.checksum=0;for(var _N=0,_M=$_.barlen-1;_N<=_M;_N+=1){$_.checksum=$f($g($_.charvals,$G($_.barcode,_N,1))+$_.checksum)}$_.checksum=$_.checksum%43;if($_.validatecheck){if($g($_.barcode,$_.barlen)!=$g($_.barchars,$_.checksum)){$k[$j++]="bwipp.code39badCheckDigit#7941";$k[$j++]="Incorrect Code 39 check digit provided";bwipp_raiseerror()}$_.barcode=$G($_.barcode,0,$_.barlen);$_.includecheck=true}var _g=$_.includecheck?3:2;$_.sbs=$s($f($_.barlen+_g)*10);var _k=$_.includecheck?3:2;$_.txt=$a($f($_.barlen+_k));$P($_.sbs,0,$g($_.encs,43));if(!$_.hidestars){$p($_.txt,0,$a(["*",0,$_.textyoffset,$_.textfont,$_.textsize]))}else{$p($_.txt,0,$a(["",0,$_.textyoffset,$_.textfont,$_.textsize]))}for(var _12=0,_11=$_.barlen-1;_12<=_11;_12+=1){$_.i=_12;$_.indx=$g($_.charvals,$G($_.barcode,$_.i,1));$P($_.sbs,$_.i*10+10,$g($_.encs,$_.indx));$p($_.txt,$_.i+1,$a([$G($_.barcode,$_.i,1),($_.i+1)*16,$_.textyoffset,$_.textfont,$_.textsize]))}if($_.includecheck){$P($_.sbs,$_.barlen*10+10,$g($_.encs,$_.checksum));if($_.includecheckintext){$p($_.txt,$_.barlen+1,$a([$G($_.barchars,$_.checksum,1),($_.barlen+1)*16,$_.textyoffset,$_.textfont,$_.textsize]))}else{$p($_.txt,$_.barlen+1,$a(["",($_.barlen+1)*16,$_.textyoffset,$_.textfont,$_.textsize]))}$P($_.sbs,$_.barlen*10+20,$g($_.encs,43));if(!$_.hidestars){$p($_.txt,$_.barlen+2,$a(["*",($_.barlen+2)*16,$_.textyoffset,$_.textfont,$_.textsize]))}else{$p($_.txt,$_.barlen+2,$a(["",($_.barlen+2)*16,$_.textyoffset,$_.textfont,$_.textsize]))}}else{$P($_.sbs,$_.barlen*10+10,$g($_.encs,43));if(!$_.hidestars){$p($_.txt,$_.barlen+1,$a(["*",($_.barlen+1)*16,$_.textyoffset,$_.textfont,$_.textsize]))}else{$p($_.txt,$_.barlen+1,$a(["",($_.barlen+1)*16,$_.textyoffset,$_.textfont,$_.textsize]))}}$k[$j++]=Infinity;$k[$j++]=Infinity;var _2N=$_.sbs;for(var _2O=0,_2P=_2N.length;_2O<_2P;_2O++){$k[$j++]=$g(_2N,_2O)-48}var _2R=$a();$k[$j++]=Infinity;for(var _2T=0,_2U=~~(($_.sbs.length+1)/2);_2T<_2U;_2T++){$k[$j++]=$_.height}var _2W=$a();$k[$j++]=Infinity;for(var _2Y=0,_2Z=~~(($_.sbs.length+1)/2);_2Y<_2Z;_2Y++){$k[$j++]=0}var _2a=$a();$k[$j++]="ren";$k[$j++]="renlinear";$k[$j++]="sbs";$k[$j++]=_2R;$k[$j++]="bhs";$k[$j++]=_2W;$k[$j++]="bbs";$k[$j++]=_2a;if($_.includetext){$k[$j++]="txt";$k[$j++]=$_.txt}$k[$j++]="opt";$k[$j++]=$_.options;var _2e=$d();$k[$j++]=_2e;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_code39ext(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.includetext=false;$_.parse=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];var _3=new Map([["parse",$_.parse],["parseonly",true],["parsefnc",false]]);$_.fncvals=_3;$k[$j++]="barcode";$k[$j++]=$_.barcode;$k[$j++]=$_.fncvals;bwipp_parseinput();var _6=$k[--$j];$_[$k[--$j]]=_6;$_.barlen=$_.barcode.length;delete $_.options["parse"];$F($_.barcode,function(){if($k[--$j]>=128){$k[$j++]="bwipp.code39extBadCharacter#8061";$k[$j++]="Code 39 Extended must contain only ASCII characters";bwipp_raiseerror()}});$_.extencs=$a(["%U","$A","$B","$C","$D","$E","$F","$G","$H","$I","$J","$K","$L","$M","$N","$O","$P","$Q","$R","$S","$T","$U","$V","$W","$X","$Y","$Z","%A","%B","%C","%D","%E"," ","/A","/B","/C","/D","/E","/F","/G","/H","/I","/J","/K","/L","-",".","/O","0","1","2","3","4","5","6","7","8","9","/Z","%F","%G","%H","%I","%J","%V","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z","%K","%L","%M","%N","%O","%W","+A","+B","+C","+D","+E","+F","+G","+H","+I","+J","+K","+L","+M","+N","+O","+P","+Q","+R","+S","+T","+U","+V","+W","+X","+Y","+Z","%P","%Q","%R","%S","%T"]);$_.newcode=$s($_.barlen*2);$_.newtext=$s($_.barlen*2);$_.j=0;for(var _K=0,_J=$_.barlen-1;_K<=_J;_K+=1){$_.i=_K;$_.extchar=$g($_.extencs,$g($_.barcode,$_.i));$P($_.newcode,$_.j,$_.extchar);var _X=$g($_.barcode,$_.i);$k[$j++]=$_.newtext;$k[$j++]=$_.j;$k[$j++]=_X;if(_X<32||_X==127){$k[$j-1]=32}var _Y=$k[--$j];var _Z=$k[--$j];$p($k[--$j],_Z,_Y);if($_.extchar.length!=1){$p($_.newtext,$_.j+1,32)}$_.j=$_.j+$_.extchar.length}$_.newcode=$G($_.newcode,0,$_.j);$_.newtext=$G($_.newtext,0,$_.j);$p($_.options,"dontdraw",true);$k[$j++]="args";$k[$j++]=$_.newcode;$k[$j++]=$_.options;bwipp_code39();var _p=$k[--$j];$_[$k[--$j]]=_p;if($_.includetext){$_.txt=$g($_.args,"txt");for(var _w=0,_v=$_.newtext.length-1;_w<=_v;_w+=1){$_.i=_w;$_.txtentry=$g($_.txt,$_.i+1);$p($_.txtentry,0,$G($_.newtext,$_.i,1));$p($_.txt,$_.i+1,$_.txtentry)}$p($_.args,"txt",$_.txt)}$p($_.args,"opt",$_.options);$k[$j++]=$_.args;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_code32(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.includetext=false;$_.textfont="OCR-B";$_.textsize=10;$_.textyoffset=-8;$_.textxoffset=0;$_.height=1;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.barcode.length!=8&&$_.barcode.length!=9){$k[$j++]="bwipp.code32badLength#8160";$k[$j++]="Italian Pharmacode must be 8 or 9 digits";bwipp_raiseerror()}$F($_.barcode,function(){var _5=$k[--$j];if(_5<48||_5>57){$k[$j++]="bwipp.code32badCharacter#8164";$k[$j++]="Italian Pharmacode must contain only digits";bwipp_raiseerror()}});$_.checksum=0;for(var _6=0;_6<=7;_6+=1){$_.i=_6;$k[$j++]=$g($_.barcode,$_.i)-48;if($_.i%2!=0){var _B=$k[--$j];$k[$j++]=_B*2}var _C=$k[$j-1];if(_C>9){var _D=$k[--$j];$k[$j++]=_D-9}$_.checksum=$f($k[--$j]+$_.checksum)}$_.checksum=$_.checksum%10;if($_.barcode.length==9){if($g($_.barcode,8)!=$_.checksum+48){$k[$j++]="bwipp.code32badCheckDigit#8178";$k[$j++]="Incorrect Italian Pharmacode check digit provided";bwipp_raiseerror()}}var _L=$s(10);$P(_L,0,$_.barcode);$p(_L,8,$_.checksum+48);$_.text=_L;$_.val=$R($s(6),$i($_.text),32);$_.barcode=$s(6);for(var _S=0;_S<=5;_S+=1){$p($_.barcode,_S,48)}$P($_.barcode,6-$_.val.length,$_.val);for(var _X=0;_X<=5;_X+=1){var _Z=$g($_.barcode,_X);$k[$j++]=_X;$k[$j++]=_Z;$k[$j++]=_Z;for(var _a=0,_b="AEIO".length;_a<_b;_a++){if($k[--$j]>=$g("AEIO",_a)){var _e=$k[--$j];$k[$j++]=_e+1}var _f=$k[$j-1];$k[$j++]=_f}$k[$j-1]=$_.barcode;var _h=$k[$j-2];var _i=$k[$j-3];$p($k[$j-1],_i,_h);$j-=3}$P($_.text,1,$G($_.text,0,9));$p($_.text,0,65);$p($_.options,"dontdraw",true);$k[$j++]="args";$k[$j++]=$_.barcode;$k[$j++]=$_.options;bwipp_code39();var _r=$k[--$j];$_[$k[--$j]]=_r;$p($_.args,"txt",$a([$a([$_.text,$_.textxoffset,$_.textyoffset,$_.textfont,$_.textsize])]));$p($_.args,"textxalign","center");$p($_.args,"opt",$_.options);$k[$j++]=$_.args;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_pzn(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.includetext=false;$_.textfont="OCR-B";$_.textsize=10;$_.textyoffset=-8;$_.textxoffset=0;$_.height=1;$_.pzn8=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.pzn8){if($_.barcode.length!=7&&$_.barcode.length!=8){$k[$j++]="bwipp.pzn8badLength#8261";$k[$j++]="PZN8 must be 7 or 8 digits";bwipp_raiseerror()}}else{if($_.barcode.length!=6&&$_.barcode.length!=7){$k[$j++]="bwipp.pzn7badLength#8265";$k[$j++]="PZN7 must be 6 or 7 digits";bwipp_raiseerror()}}$F($_.barcode,function(){var _8=$k[--$j];if(_8<48||_8>57){$k[$j++]="bwipp.pznBadCharacter#8270";$k[$j++]="PZN must contain only digits";bwipp_raiseerror()}});var _A=$_.pzn8?9:8;$_.msglen=_A;$_.checksum=0;for(var _D=0,_C=$_.msglen-3;_D<=_C;_D+=1){$_.i=_D;var _J=$_.pzn8?1:2;$_.checksum=$f(($g($_.barcode,$_.i)-48)*($_.i+_J)+$_.checksum)}$_.checksum=$_.checksum%11;if($_.checksum==10){$k[$j++]="bwipp.pznBadInputSequence#8284";$k[$j++]="Incorrect PZN input sequence provided";bwipp_raiseerror()}if($_.barcode.length==$_.msglen-1){if($g($_.barcode,$_.msglen-2)!=$_.checksum+48){$k[$j++]="bwipp.pznBadCheckDigit#8288";$k[$j++]="Incorrect PZN check digit provided";bwipp_raiseerror()}}var _U=$s($_.msglen);$p(_U,0,45);$P(_U,1,$_.barcode);$p(_U,$_.msglen-1,$_.checksum+48);$_.msg=_U;$p($_.options,"dontdraw",true);$k[$j++]="args";$k[$j++]=$_.msg;$k[$j++]=$_.options;bwipp_code39();var _b=$k[--$j];$_[$k[--$j]]=_b;$_.text=$s($_.msglen+5);$P($_.text,0,"PZN - ");$P($_.text,6,$G($_.msg,1,$_.msglen-1));var _r=$a([$a([$_.text,$_.textxoffset,$_.textyoffset,$_.textfont,$_.textsize])]);$p($_.args,"txt",_r);$p($_.args,"textxalign","center");$p($_.args,"opt",$_.options);$k[$j++]=$_.args;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_code93(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.includecheck=false;$_.includetext=false;$_.textfont="OCR-B";$_.textsize=10;$_.textyoffset=-8;$_.height=1;$_.parse=false;$_.parsefnc=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];$_.encs=$a(["131112","111213","111312","111411","121113","121212","121311","111114","131211","141111","211113","211212","211311","221112","221211","231111","112113","112212","112311","122112","132111","111123","111222","111321","121122","131121","212112","212211","211122","211221","221121","222111","112122","112221","122121","123111","121131","311112","311211","321111","112131","113121","211131","121221","312111","311121","122211","111141","1111411"]);$_.barchars="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%";$_.charvals=new Map;for(var _3=0;_3<=42;_3+=1){$p($_.charvals,$g($_.barchars,_3),_3)}$_.sft1=-1;$_.sft2=-2;$_.sft3=-3;$_.sft4=-4;$p($_.charvals,$_.sft1,43);$p($_.charvals,$_.sft2,44);$p($_.charvals,$_.sft3,45);$p($_.charvals,$_.sft4,46);var _M=new Map([["parse",$_.parse],["parsefnc",$_.parsefnc],["SFT$",$_.sft1],["SFT%",$_.sft2],["SFT/",$_.sft3],["SFT+",$_.sft4]]);$_.fncvals=_M;$k[$j++]="msg";$k[$j++]=$_.barcode;$k[$j++]=$_.fncvals;bwipp_parseinput();var _P=$k[--$j];$_[$k[--$j]]=_P;$_.msglen=$_.msg.length;$F($_.msg,function(){var _V=$g($_.charvals,$k[--$j])!==undefined;if(!_V){$k[$j++]="bwipp.code93BadCharacter#8405";$k[$j++]="Code 93 must only contain digits, capital letters, spaces, the symbols -.$/+ and shift non-data characters";bwipp_raiseerror()}});if($_.includecheck){$_.sbs=$s($_.msglen*6+25)}else{$_.sbs=$s($_.msglen*6+13)}$_.txt=$a($_.msglen);$P($_.sbs,0,$g($_.encs,47));$_.checksum1=0;$_.checksum2=0;for(var _i=0,_h=$_.msglen-1;_i<=_h;_i+=1){$_.i=_i;$_.indx=$g($_.charvals,$g($_.msg,$_.i));$P($_.sbs,$_.i*6+6,$g($_.encs,$_.indx));var _v=$g($_.msg,$_.i);$k[$j++]="char";$k[$j++]=_v;if(_v<0){$k[$j-1]=" "}else{var _w=$s(1);$k[$j++]=_w;$k[$j++]=_w;$k[$j++]=0;$r(4,-1);var _x=$k[--$j];var _y=$k[--$j];$p($k[--$j],_y,_x)}var _10=$k[--$j];$_[$k[--$j]]=_10;$p($_.txt,$_.i,$a([$_.char,$_.i*9+9,$_.textyoffset,$_.textfont,$_.textsize]));$_.checksum1=$f($_.checksum1+(($_.msglen-$_.i-1)%20+1)*$_.indx);$_.checksum2=$f($_.checksum2+(($_.msglen-$_.i)%15+1)*$_.indx)}if($_.includecheck){$_.checksum1=$_.checksum1%47;$_.checksum2=$f($_.checksum2+$_.checksum1)%47;$P($_.sbs,$_.msglen*6+6,$g($_.encs,$_.checksum1));$P($_.sbs,$_.msglen*6+12,$g($_.encs,$_.checksum2));$P($_.sbs,$_.msglen*6+18,$g($_.encs,48))}else{$P($_.sbs,$_.msglen*6+6,$g($_.encs,48))}$k[$j++]=Infinity;$k[$j++]=Infinity;var _1e=$_.sbs;for(var _1f=0,_1g=_1e.length;_1f<_1g;_1f++){$k[$j++]=$g(_1e,_1f)-48}var _1i=$a();$k[$j++]=Infinity;for(var _1k=0,_1l=~~(($_.sbs.length+1)/2);_1k<_1l;_1k++){$k[$j++]=$_.height}var _1n=$a();$k[$j++]=Infinity;for(var _1p=0,_1q=~~(($_.sbs.length+1)/2);_1p<_1q;_1p++){$k[$j++]=0}var _1r=$a();$k[$j++]="ren";$k[$j++]="renlinear";$k[$j++]="sbs";$k[$j++]=_1i;$k[$j++]="bhs";$k[$j++]=_1n;$k[$j++]="bbs";$k[$j++]=_1r;if($_.includetext){$k[$j++]="txt";$k[$j++]=$_.txt}$k[$j++]="opt";$k[$j++]=$_.options;var _1v=$d();$k[$j++]=_1v;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_code93ext(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.includetext=false;$_.parse=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];var _3=new Map([["parse",$_.parse],["parseonly",true],["parsefnc",false]]);$_.fncvals=_3;$k[$j++]="barcode";$k[$j++]=$_.barcode;$k[$j++]=$_.fncvals;bwipp_parseinput();var _6=$k[--$j];$_[$k[--$j]]=_6;$_.barlen=$_.barcode.length;delete $_.options["parse"];$_.extencs=$a(["^SFT%U","^SFT$A","^SFT$B","^SFT$C","^SFT$D","^SFT$E","^SFT$F","^SFT$G","^SFT$H","^SFT$I","^SFT$J","^SFT$K","^SFT$L","^SFT$M","^SFT$N","^SFT$O","^SFT$P","^SFT$Q","^SFT$R","^SFT$S","^SFT$T","^SFT$U","^SFT$V","^SFT$W","^SFT$X","^SFT$Y","^SFT$Z","^SFT%A","^SFT%B","^SFT%C","^SFT%D","^SFT%E"," ","^SFT/A","^SFT/B","^SFT/C","$","%","^SFT/F","^SFT/G","^SFT/H","^SFT/I","^SFT/J","+","^SFT/L","-",".","/","0","1","2","3","4","5","6","7","8","9","^SFT/Z","^SFT%F","^SFT%G","^SFT%H","^SFT%I","^SFT%J","^SFT%V","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z","^SFT%K","^SFT%L","^SFT%M","^SFT%N","^SFT%O","^SFT%W","^SFT+A","^SFT+B","^SFT+C","^SFT+D","^SFT+E","^SFT+F","^SFT+G","^SFT+H","^SFT+I","^SFT+J","^SFT+K","^SFT+L","^SFT+M","^SFT+N","^SFT+O","^SFT+P","^SFT+Q","^SFT+R","^SFT+S","^SFT+T","^SFT+U","^SFT+V","^SFT+W","^SFT+X","^SFT+Y","^SFT+Z","^SFT%P","^SFT%Q","^SFT%R","^SFT%S","^SFT%T"]);$_.newcode=$s($_.barlen*6);$_.newtext=$s($_.barlen*6);$_.j=0;$_.k=0;for(var _I=0,_H=$_.barlen-1;_I<=_H;_I+=1){$_.i=_I;var _L=$g($_.barcode,$_.i);$k[$j++]=_L;if(_L>127){$j--;$k[$j++]="bwipp.code93extbadCharacter#8542";$k[$j++]="Code 93 Extended only support ASCII characters with values 0 to 127";bwipp_raiseerror()}$_.extchar=$g($_.extencs,$k[--$j]);$_.extlen=$_.extchar.length;$P($_.newcode,$_.j,$_.extchar);var _X=$g($_.barcode,$_.i);$k[$j++]=$_.newtext;$k[$j++]=$_.k;$k[$j++]=_X;if(_X<32||_X==127){$k[$j-1]=32}var _Y=$k[--$j];var _Z=$k[--$j];$p($k[--$j],_Z,_Y);if($_.extlen!=1){$p($_.newtext,$_.k+1,32)}$_.j=$_.j+$_.extlen;var _i=$_.extlen==1?1:2;$_.k=$_.k+_i}$_.newcode=$G($_.newcode,0,$_.j);$_.newtext=$G($_.newtext,0,$_.k);$p($_.options,"dontdraw",true);$p($_.options,"parsefnc",true);$k[$j++]="args";$k[$j++]=$_.newcode;$k[$j++]=$_.options;bwipp_code93();var _t=$k[--$j];$_[$k[--$j]]=_t;if($_.includetext){$_.txt=$g($_.args,"txt");for(var _10=0,_z=$_.newtext.length-1;_10<=_z;_10+=1){$_.i=_10;$_.txtentry=$g($_.txt,$_.i);$p($_.txtentry,0,$G($_.newtext,$_.i,1));$p($_.txt,$_.i,$_.txtentry)}$p($_.args,"txt",$_.txt)}$p($_.args,"opt",$_.options);$k[$j++]=$_.args;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_interleaved2of5(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.includecheck=false;$_.includetext=false;$_.includecheckintext=false;$_.textfont="OCR-B";$_.textsize=10;$_.textyoffset=-8;$_.height=1;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];$F($_.barcode,function(){var _3=$k[--$j];if(_3<48||_3>57){$k[$j++]="bwipp.interleaved2of5badCharacter#8628";$k[$j++]="Interleaved 2 of 5 must contain only digits";bwipp_raiseerror()}});$_.barlen=$_.barcode.length;if($_.barlen%2==0&&$_.includecheck||$_.barlen%2!=0&&!$_.includecheck){$_.pad=$s($_.barlen+1);$p($_.pad,0,48);$P($_.pad,1,$_.barcode);$_.barcode=$_.pad;$_.barlen=$_.barlen+1}if($_.includecheck){$_.checksum=0;for(var _J=0,_I=$_.barlen-1;_J<=_I;_J+=1){$_.i=_J;if($_.i%2==0){$_.checksum=$_.checksum+($g($_.barcode,$_.i)-48)*3}else{$_.checksum=$_.checksum+($g($_.barcode,$_.i)-48)}}$_.checksum=(10-$_.checksum%10)%10;$_.pad=$s($_.barlen+1);$P($_.pad,0,$_.barcode);$p($_.pad,$_.barlen,$_.checksum+48);$_.barcode=$_.pad;$_.barlen=$_.barlen+1}$_.encs=$a(["11221","21112","12112","22111","11212","21211","12211","11122","21121","12121","1111","2111"]);$_.barchars="0123456789";$_.sbs=$s($_.barlen*5+8);$_.txt=$a($_.barlen);$P($_.sbs,0,$g($_.encs,10));for(var _o=0,_n=$_.barlen-1;_o<=_n;_o+=2){$_.i=_o;$X($_.barchars,$G($_.barcode,$_.i,1));$j--;$_.indx=$k[--$j].length;$j-=2;$_.enca=$g($_.encs,$_.indx);$X($_.barchars,$G($_.barcode,$_.i+1,1));$j--;$_.indx=$k[--$j].length;$j-=2;$_.encb=$g($_.encs,$_.indx);$_.intl=$s($_.enca.length*2);for(var _19=0,_18=$_.enca.length-1;_19<=_18;_19+=1){$_.j=_19;$_.achar=$g($_.enca,$_.j);$_.bchar=$g($_.encb,$_.j);$p($_.intl,$_.j*2,$_.achar);$p($_.intl,$_.j*2+1,$_.bchar)}$P($_.sbs,$_.i*5+4,$_.intl);$p($_.txt,$_.i,$a([$G($_.barcode,$_.i,1),$_.i*9+4,$_.textyoffset,$_.textfont,$_.textsize]));if($_.includecheck&&!$_.includecheckintext&&$_.barlen-2==$_.i){$p($_.txt,$_.i+1,$a([" ",($_.i+1)*9+4,$_.textyoffset,$_.textfont,$_.textsize]))}else{$p($_.txt,$_.i+1,$a([$G($_.barcode,$_.i+1,1),($_.i+1)*9+4,$_.textyoffset,$_.textfont,$_.textsize]))}}$P($_.sbs,$_.barlen*5+4,$g($_.encs,11));$k[$j++]=Infinity;$k[$j++]=Infinity;var _1y=$_.sbs;for(var _1z=0,_20=_1y.length;_1z<_20;_1z++){$k[$j++]=$g(_1y,_1z)-48}var _22=$a();$k[$j++]=Infinity;for(var _24=0,_25=~~(($_.sbs.length+1)/2);_24<_25;_24++){$k[$j++]=$_.height}var _27=$a();$k[$j++]=Infinity;for(var _29=0,_2A=~~(($_.sbs.length+1)/2);_29<_2A;_29++){$k[$j++]=0}var _2B=$a();$k[$j++]="ren";$k[$j++]="renlinear";$k[$j++]="sbs";$k[$j++]=_22;$k[$j++]="bhs";$k[$j++]=_27;$k[$j++]="bbs";$k[$j++]=_2B;if($_.includetext){$k[$j++]="txt";$k[$j++]=$_.txt}$k[$j++]="barratio";$k[$j++]=2;$k[$j++]="spaceratio";$k[$j++]=2;$k[$j++]="opt";$k[$j++]=$_.options;var _2F=$d();$k[$j++]=_2F;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_itf14(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.includetext=false;$_.includecheckintext=true;$_.textfont="OCR-B";$_.textsize=10;$_.textxoffset=0;$_.textyoffset=-3.5;$_.height=.5;$_.showborder=true;$_.borderwidth=4;$_.borderleft=10;$_.borderright=10;$_.bordertop=-.55;$_.borderbottom=-.55;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];$_.text=$_.barcode;var _3=$_.barcode;$k[$j++]=$s(_3.length);$k[$j++]=0;$F(_3,function(){var _5=$k[$j-1];if(_5!=32){var _6=$k[--$j];var _7=$k[--$j];var _8=$k[$j-1];$p(_8,_7,_6);$k[$j++]=_7+1}else{$j--}});var _9=$k[--$j];$_.barcode=$G($k[--$j],0,_9);$_.hasspace=$_.text.length!=$_.barcode.length;if($_.barcode.length!=13&&$_.barcode.length!=14){$k[$j++]="bwipp.itf14badLength#8796";$k[$j++]="ITF-14 must be 13 or 14 digits";bwipp_raiseerror()}var _G=$_.barcode;for(var _H=0,_I=_G.length;_H<_I;_H++){var _J=$g(_G,_H);if(_J<48||_J>57){$k[$j++]="bwipp.itf14badCharacter#8800";$k[$j++]="ITF-14 must contain only digits";bwipp_raiseerror()}}$_.checksum=0;for(var _K=0;_K<=12;_K+=1){$_.i=_K;$k[$j++]="checksum";$k[$j++]=$_.checksum;$k[$j++]=$g($_.barcode,$_.i)-48;if($_.i%2==0){var _Q=$k[--$j];$k[$j++]=_Q*3}var _R=$k[--$j];var _S=$k[--$j];$_[$k[--$j]]=$f(_S+_R)}$_.checksum=(10-$_.checksum%10)%10;if($_.barcode.length==14){if($g($_.barcode,13)!=$_.checksum+48){$k[$j++]="bwipp.itf14badCheckDigit#8813";$k[$j++]="Incorrect ITF-14 check digit provided";bwipp_raiseerror()}}else{var _Z=$s(14);$P(_Z,0,$_.barcode);$p(_Z,13,$_.checksum+48);$_.barcode=_Z;var _e=$_.hasspace?2:1;var _f=$s($_.text.length+_e);$P(_f,_f.length-2," ");$p(_f,_f.length-1,$_.checksum+48);$P(_f,0,$_.text);$_.text=_f}var _i=$_.options;$p(_i,"dontdraw",true);$p($_.options,"showborder",$_.showborder);$p($_.options,"borderwidth",$_.borderwidth);$p($_.options,"borderleft",$_.borderleft);$p($_.options,"borderright",$_.borderright);var _r=$_.options;$p(_r,"bordertop",$_.bordertop);$p($_.options,"borderbottom",$_.borderbottom);$p($_.options,"height",$_.height);$p($_.options,"textyoffset",$_.textyoffset);$k[$j++]="args";$k[$j++]=$_.barcode;$k[$j++]=$_.options;bwipp_interleaved2of5();var _11=$k[--$j];$_[$k[--$j]]=_11;$p($_.args,"txt",$a([$a([$_.text,$_.textxoffset,$_.textyoffset,$_.textfont,$_.textsize])]));$p($_.args,"textxalign","center");$p($_.args,"opt",$_.options);$k[$j++]=$_.args;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_identcode(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.includetext=false;$_.textfont="OCR-B";$_.textsize=10;$_.textxoffset=0;$_.textyoffset=-8;$_.height=1;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.barcode.length!=11&&$_.barcode.length!=12){$k[$j++]="bwipp.identcodeBadLength#8891";$k[$j++]="Deutsche Post Identcode must be 11 or 12 digits";bwipp_raiseerror()}$F($_.barcode,function(){var _5=$k[--$j];if(_5<48||_5>57){$k[$j++]="bwipp.identcodeBadCharacter#8895";$k[$j++]="Deutsche Post Identcode must contain only digits";bwipp_raiseerror()}});$_.checksum=0;for(var _6=0;_6<=10;_6+=1){$_.i=_6;$k[$j++]="checksum";$k[$j++]=$_.checksum;$k[$j++]=$g($_.barcode,$_.i)-48;if($_.i%2==0){var _C=$k[--$j];$k[$j++]=_C*4}else{var _D=$k[--$j];$k[$j++]=_D*9}var _E=$k[--$j];var _F=$k[--$j];$_[$k[--$j]]=$f(_F+_E)}$_.checksum=(10-$_.checksum%10)%10;if($_.barcode.length==12){if($g($_.barcode,11)!=$_.checksum+48){$k[$j++]="bwipp.identcodeBadCheckDigit#8908";$k[$j++]="Incorrect Deutsche Post Identcode check digit provided";bwipp_raiseerror()}}var _M=$s(12);$P(_M,0,$_.barcode);$p(_M,11,$_.checksum+48);$_.barcode=_M;$_.text=$Z($s(16),"  .       .     ");$P($_.text,0,$G($_.barcode,0,2));$P($_.text,3,$G($_.barcode,2,3));$P($_.text,7,$G($_.barcode,5,3));$P($_.text,11,$G($_.barcode,8,3));$P($_.text,15,$G($_.barcode,11,1));$p($_.options,"dontdraw",true);$p($_.options,"includecheck",false);var _i=$_.barcode;$k[$j++]="args";$k[$j++]=_i;$k[$j++]=$_.options;bwipp_interleaved2of5();var _k=$k[--$j];$_[$k[--$j]]=_k;var _r=$_.textsize;$p($_.args,"txt",$a([$a([$_.text,$_.textxoffset,$_.textyoffset,$_.textfont,_r])]));$p($_.args,"textxalign","center");$p($_.args,"opt",$_.options);$k[$j++]=$_.args;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_leitcode(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.includetext=false;$_.textfont="OCR-B";$_.textsize=10;$_.textxoffset=0;$_.textyoffset=-8;$_.height=1;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.barcode.length!=13&&$_.barcode.length!=14){$k[$j++]="bwipp.leitcodeBadLength#8981";$k[$j++]="Deutsche Post Leitcode must be 13 or 14 digits";bwipp_raiseerror()}$F($_.barcode,function(){var _5=$k[--$j];if(_5<48||_5>57){$k[$j++]="bwipp.leitcodeBadCharacter#8985";$k[$j++]="Deutsche Post Leitcode must contain only digits";bwipp_raiseerror()}});$_.checksum=0;for(var _6=0;_6<=12;_6+=1){$_.i=_6;$k[$j++]="checksum";$k[$j++]=$_.checksum;$k[$j++]=$g($_.barcode,$_.i)-48;if($_.i%2==0){var _C=$k[--$j];$k[$j++]=_C*4}else{var _D=$k[--$j];$k[$j++]=_D*9}var _E=$k[--$j];var _F=$k[--$j];$_[$k[--$j]]=$f(_F+_E)}$_.checksum=(10-$_.checksum%10)%10;if($_.barcode.length==14){if($g($_.barcode,13)!=$_.checksum+48){$k[$j++]="bwipp.leitcodeBadCheckDigit#8998";$k[$j++]="Incorrect Deutsche Post Leitcode check digit provided";bwipp_raiseerror()}}var _M=$s(14);$P(_M,0,$_.barcode);$p(_M,13,$_.checksum+48);$_.barcode=_M;$_.text=$Z($s(18),"     .   .   .    ");$P($_.text,0,$G($_.barcode,0,5));$P($_.text,6,$G($_.barcode,5,3));$P($_.text,10,$G($_.barcode,8,3));$P($_.text,14,$G($_.barcode,11,2));$P($_.text,17,$G($_.barcode,13,1));$p($_.options,"dontdraw",true);$p($_.options,"includecheck",false);var _i=$_.barcode;$k[$j++]="args";$k[$j++]=_i;$k[$j++]=$_.options;bwipp_interleaved2of5();var _k=$k[--$j];$_[$k[--$j]]=_k;var _r=$_.textsize;$p($_.args,"txt",$a([$a([$_.text,$_.textxoffset,$_.textyoffset,$_.textfont,_r])]));$p($_.args,"textxalign","center");$p($_.args,"opt",$_.options);$k[$j++]=$_.args;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_databaromni(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.height=33/72;$_.linkage=false;$_.format="omni";$_.barxmult=33;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.barcode.length!=17&&$_.barcode.length!=18){$k[$j++]="bwipp.databaromniBadLength#9070";$k[$j++]="GS1 DataBar Omnidirectional must be 13 or 14 digits";bwipp_raiseerror()}if($ne($G($_.barcode,0,4),"(01)")){$k[$j++]="bwipp.databaromniBadAI#9073";$k[$j++]="GS1 DataBar Omnidirectional must begin with (01) application identifier";bwipp_raiseerror()}var _8=$G($_.barcode,4,$_.barcode.length-4);for(var _9=0,_A=_8.length;_9<_A;_9++){var _B=$g(_8,_9);if(_B<48||_B>57){$k[$j++]="bwipp.databaromniBadCharacter#9077";$k[$j++]="GS1 DataBar Omnidirectional must contain only digits";bwipp_raiseerror()}}if($_.barxmult<33){$k[$j++]="bwipp.databarStackedOmniBarXmult#9082";$k[$j++]="GS1 DataBar Stacked Omnidirectional must have a barxmult of at least 33";bwipp_raiseerror()}if($ne($_.format,"omni")&&$ne($_.format,"stacked")&&$ne($_.format,"stackedomni")&&$ne($_.format,"truncated")){$k[$j++]="bwipp.databaromniBadFormat#9086";$k[$j++]="Valid formats are omni, stacked, stackedomni and truncated";bwipp_raiseerror()}if($eq($_.format,"truncated")){$_.height=13/72}$_.checksum=0;for(var _I=0;_I<=12;_I+=1){$_.i=_I;$k[$j++]="checksum";$k[$j++]=$_.checksum;$k[$j++]=$g($_.barcode,$_.i+4)-48;if($_.i%2==0){var _O=$k[--$j];$k[$j++]=_O*3}var _P=$k[--$j];var _Q=$k[--$j];$_[$k[--$j]]=$f(_Q+_P)}$_.checksum=(10-$_.checksum%10)%10;if($_.barcode.length==18){if($g($_.barcode,17)!=$_.checksum+48){$k[$j++]="bwipp.databaromniBadCheckDigit#9102";$k[$j++]="Incorrect GS1 DataBar Omnidirectional check digit provided";bwipp_raiseerror()}}var _X=$s(18);$P(_X,0,$_.barcode);$p(_X,17,$_.checksum+48);$_.barcode=_X;$_.txt=$a($_.barcode.length);for(var _e=0,_d=$_.barcode.length-1;_e<=_d;_e+=1){$_.i=_e;$p($_.txt,$_.i,$a([$G($_.barcode,$_.i,1),0,0,"",0]))}$_.ncr=function(){var _l=$k[--$j];var _m=$k[--$j];var _n=$f(_m-_l);if(_l<$f(_m-_l)){var _=_n;_n=_l;_l=_}$k[$j++]=_n;$k[$j++]=1;$k[$j++]=1;for(var _p=_m,_o=_l+1;_p>=_o;_p-=1){var _q=$k[--$j];var _r=$k[$j-1];var _s=$k[$j-2];$k[$j++]=_q*_p;if($le(_r,_s)){var _t=$k[--$j];var _u=$k[--$j];$k[$j++]=_u+1;$k[$j++]=~~(_t/_u)}}for(;;){var _w=$k[$j-2];var _x=$k[$j-3];if($gt(_w,_x)){break}var _y=$k[--$j];var _z=$k[--$j];$k[$j++]=_z+1;$k[$j++]=~~(_y/_z)}var _10=$k[--$j];$k[$j-1]=_10;var _12=$k[--$j];$k[$j-1]=_12};$_.getRSSwidths=function(){$_.oe=$k[--$j];$_.el=$k[--$j];$_.mw=$k[--$j];$_.nm=$k[--$j];$_.val=$k[--$j];$_.out=$a($_.el);$_.mask=0;for(var _1D=0,_1C=$_.el-2;_1D<=_1C;_1D+=1){$_.bar=_1D;$_.ew=1;var _1F=$_.bar;$_.mask=$_.mask|(_1F<0?1>>>-_1F:1<<_1F);for(;;){$k[$j++]="sval";$k[$j++]=$f($_.nm-$_.ew)-1;$k[$j++]=$f($_.el-$_.bar)-2;$_.ncr();var _1K=$k[--$j];$_[$k[--$j]]=_1K;if($_.oe&&$_.mask==0&&$f($_.nm-$_.ew-$_.el*2+$_.bar*2)>=-2){$k[$j++]="sval";$k[$j++]=$_.sval;$k[$j++]=$f($_.nm-$_.ew-$_.el+$_.bar);$k[$j++]=$f($_.el-$_.bar)-2;$_.ncr();var _1Z=$k[--$j];var _1a=$k[--$j];$_[$k[--$j]]=$f(_1a-_1Z)}if($f($_.el-$_.bar)>2){$_.lval=0;for(var _1k=$f($_.nm-$_.ew-$_.el+$_.bar)+2,_1j=$_.mw+1;_1k>=_1j;_1k-=1){$k[$j++]=$f($_.nm-_1k-$_.ew)-1;$k[$j++]=$f($_.el-$_.bar)-3;$_.ncr();$_.lval=$f($k[--$j]+$_.lval)}$_.sval=$f($_.sval-$_.lval*($_.el-$_.bar-1))}else{if($f($_.nm-$_.ew)>$_.mw){$_.sval=$_.sval-1}}$_.val=$f($_.val-$_.sval);if($_.val<0){break}$_.ew=$_.ew+1;var _24=$_.bar;$_.mask=$_.mask&~(_24<0?1>>>-_24:1<<_24)}$_.val=$f($_.val+$_.sval);$_.nm=$f($_.nm-$_.ew);$p($_.out,$_.bar,$_.ew)}$p($_.out,$_.el-1,$_.nm);$k[$j++]=$_.out};$k[$j++]=Infinity;var _2H=$_.linkage?1:0;var _2J=$G($_.barcode,4,13);$k[$j++]=_2H;for(var _2K=0,_2L=_2J.length;_2K<_2L;_2K++){$k[$j++]=$g(_2J,_2K)-48}$_.binval=$a();for(var _2O=0;_2O<=12;_2O+=1){$_.i=_2O;var _2P=$_.binval;var _2Q=$_.i;$p(_2P,_2Q+1,$f($g(_2P,_2Q+1)+$g($_.binval,$_.i)%4537077*10));$p($_.binval,$_.i,~~($g($_.binval,$_.i)/4537077))}$_.right=$g($_.binval,13)%4537077;var _2c=$_.binval;$p(_2c,13,~~($g(_2c,13)/4537077));$_.left=0;$_.i=true;for(var _2e=0;_2e<=13;_2e+=1){$_.j=_2e;var _2h=$g($_.binval,$_.j);$k[$j++]=_2h;if(_2h==0&&$_.i){$j--}else{$_.i=false;$k[$j++]="left";$k[$j++]=$_.left;var _2l=$k[$j-3];var _2m=$k[$j-1];$_[$k[$j-2]]=$f(_2m+_2l*~~$pow(10,13-$_.j));$j-=3}}$_.d1=~~($_.left/1597);$_.d2=$_.left%1597;$_.d3=~~($_.right/1597);$_.d4=$_.right%1597;$_.tab164=$a([160,0,12,4,8,1,161,1,960,161,10,6,6,3,80,10,2014,961,8,8,4,5,31,34,2714,2015,6,10,3,6,10,70,2840,2715,4,12,1,8,1,126]);$_.tab154=$a([335,0,5,10,2,7,4,84,1035,336,7,8,4,5,20,35,1515,1036,9,6,6,3,48,10,1596,1516,11,4,8,1,81,1]);$_.i=0;for(;;){if($_.d1<=$g($_.tab164,$_.i)){$q($G($_.tab164,$_.i+1,7));$_.d1te=$k[--$j];$_.d1to=$k[--$j];$_.d1mwe=$k[--$j];$_.d1mwo=$k[--$j];$_.d1ele=$k[--$j];$_.d1elo=$k[--$j];$_.d1gs=$k[--$j];break}$_.i=$_.i+8}$_.i=0;for(;;){if($_.d2<=$g($_.tab154,$_.i)){$q($G($_.tab154,$_.i+1,7));$_.d2te=$k[--$j];$_.d2to=$k[--$j];$_.d2mwe=$k[--$j];$_.d2mwo=$k[--$j];$_.d2ele=$k[--$j];$_.d2elo=$k[--$j];$_.d2gs=$k[--$j];break}$_.i=$_.i+8}$_.i=0;for(;;){if($_.d3<=$g($_.tab164,$_.i)){$q($G($_.tab164,$_.i+1,7));$_.d3te=$k[--$j];$_.d3to=$k[--$j];$_.d3mwe=$k[--$j];$_.d3mwo=$k[--$j];$_.d3ele=$k[--$j];$_.d3elo=$k[--$j];$_.d3gs=$k[--$j];break}$_.i=$_.i+8}$_.i=0;for(;;){if($_.d4<=$g($_.tab154,$_.i)){$q($G($_.tab154,$_.i+1,7));$_.d4te=$k[--$j];$_.d4to=$k[--$j];$_.d4mwe=$k[--$j];$_.d4mwo=$k[--$j];$_.d4ele=$k[--$j];$_.d4elo=$k[--$j];$_.d4gs=$k[--$j];break}$_.i=$_.i+8}$k[$j++]="d1wo";$k[$j++]=~~($f($_.d1-$_.d1gs)/$_.d1te);$k[$j++]=$_.d1elo;$k[$j++]=$_.d1mwo;$k[$j++]=4;$k[$j++]=false;$_.getRSSwidths();var _3y=$k[--$j];$_[$k[--$j]]=_3y;$k[$j++]="d1we";$k[$j++]=$f($_.d1-$_.d1gs)%$_.d1te;$k[$j++]=$_.d1ele;$k[$j++]=$_.d1mwe;$k[$j++]=4;$k[$j++]=true;$_.getRSSwidths();var _45=$k[--$j];$_[$k[--$j]]=_45;$k[$j++]="d2wo";$k[$j++]=$f($_.d2-$_.d2gs)%$_.d2to;$k[$j++]=$_.d2elo;$k[$j++]=$_.d2mwo;$k[$j++]=4;$k[$j++]=true;$_.getRSSwidths();var _4C=$k[--$j];$_[$k[--$j]]=_4C;$k[$j++]="d2we";$k[$j++]=~~($f($_.d2-$_.d2gs)/$_.d2to);$k[$j++]=$_.d2ele;$k[$j++]=$_.d2mwe;$k[$j++]=4;$k[$j++]=false;$_.getRSSwidths();var _4J=$k[--$j];$_[$k[--$j]]=_4J;$k[$j++]="d3wo";$k[$j++]=~~($f($_.d3-$_.d3gs)/$_.d3te);$k[$j++]=$_.d3elo;$k[$j++]=$_.d3mwo;$k[$j++]=4;$k[$j++]=false;$_.getRSSwidths();var _4Q=$k[--$j];$_[$k[--$j]]=_4Q;$k[$j++]="d3we";$k[$j++]=$f($_.d3-$_.d3gs)%$_.d3te;$k[$j++]=$_.d3ele;$k[$j++]=$_.d3mwe;$k[$j++]=4;$k[$j++]=true;$_.getRSSwidths();var _4X=$k[--$j];$_[$k[--$j]]=_4X;$k[$j++]="d4wo";$k[$j++]=$f($_.d4-$_.d4gs)%$_.d4to;$k[$j++]=$_.d4elo;$k[$j++]=$_.d4mwo;$k[$j++]=4;$k[$j++]=true;$_.getRSSwidths();var _4e=$k[--$j];$_[$k[--$j]]=_4e;$k[$j++]="d4we";$k[$j++]=~~($f($_.d4-$_.d4gs)/$_.d4to);$k[$j++]=$_.d4ele;$k[$j++]=$_.d4mwe;$k[$j++]=4;$k[$j++]=false;$_.getRSSwidths();var _4l=$k[--$j];$_[$k[--$j]]=_4l;$_.d1w=$a(8);for(var _4o=0;_4o<=3;_4o+=1){$_.i=_4o;$p($_.d1w,$_.i*2,$g($_.d1wo,$_.i));$p($_.d1w,$_.i*2+1,$g($_.d1we,$_.i))}$_.d2w=$a(8);for(var _50=0;_50<=3;_50+=1){$_.i=_50;$p($_.d2w,7-$_.i*2,$g($_.d2wo,$_.i));$p($_.d2w,6-$_.i*2,$g($_.d2we,$_.i))}$_.d3w=$a(8);for(var _5C=0;_5C<=3;_5C+=1){$_.i=_5C;$p($_.d3w,7-$_.i*2,$g($_.d3wo,$_.i));$p($_.d3w,6-$_.i*2,$g($_.d3we,$_.i))}$_.d4w=$a(8);for(var _5O=0;_5O<=3;_5O+=1){$_.i=_5O;$p($_.d4w,$_.i*2,$g($_.d4wo,$_.i));$p($_.d4w,$_.i*2+1,$g($_.d4we,$_.i))}$k[$j++]=Infinity;$q($_.d1w);$q($_.d2w);$q($_.d3w);$q($_.d4w);$_.widths=$a();$_.checkweights=$a([1,3,9,27,2,6,18,54,58,72,24,8,29,36,12,4,74,51,17,32,37,65,48,16,64,34,23,69,49,68,46,59]);$_.checkwidths=$a([3,8,2,1,1,3,5,5,1,1,3,3,7,1,1,3,1,9,1,1,2,7,4,1,1,2,5,6,1,1,2,3,8,1,1,1,5,7,1,1,1,3,9,1,1]);$_.checksum=0;for(var _5h=0;_5h<=31;_5h+=1){$_.i=_5h;$_.checksum=$f($_.checksum+$g($_.widths,$_.i)*$g($_.checkweights,$_.i))}$_.checksum=$_.checksum%79;if($_.checksum>=8){$_.checksum=$_.checksum+1}if($_.checksum>=72){$_.checksum=$_.checksum+1}$_.checklt=$G($_.checkwidths,~~($_.checksum/9)*5,5);$_.checkrtrev=$G($_.checkwidths,$_.checksum%9*5,5);$_.checkrt=$a(5);for(var _61=0;_61<=4;_61+=1){$_.i=_61;$p($_.checkrt,$_.i,$g($_.checkrtrev,4-$_.i))}if($eq($_.format,"omni")||$eq($_.format,"truncated")){$k[$j++]=Infinity;$k[$j++]=1;$q($_.d1w);$q($_.checklt);$q($_.d2w);$q($_.d4w);$q($_.checkrt);$q($_.d3w);$k[$j++]=1;$k[$j++]=1;$_.sbs=$a();$k[$j++]=Infinity;var _6G=$_.sbs;$k[$j++]=Infinity;for(var _6I=0,_6J=~~(($_.sbs.length+1)/2);_6I<_6J;_6I++){$k[$j++]=$_.height}var _6L=$a();$k[$j++]=Infinity;for(var _6N=0,_6O=~~(($_.sbs.length+1)/2);_6N<_6O;_6N++){$k[$j++]=0}var _6P=$a();$k[$j++]="ren";$k[$j++]="renlinear";$k[$j++]="sbs";$k[$j++]=_6G;$k[$j++]="bhs";$k[$j++]=_6L;$k[$j++]="bbs";$k[$j++]=_6P;$k[$j++]="txt";$k[$j++]=$_.txt;$k[$j++]="textxalign";$k[$j++]="center";$k[$j++]="borderleft";$k[$j++]=0;$k[$j++]="borderright";$k[$j++]=0;$k[$j++]="opt";$k[$j++]=$_.options;var _6S=$d();$k[$j++]=_6S;if(!$_.dontdraw){bwipp_renlinear()}}else{$k[$j++]=Infinity;$k[$j++]=1;$k[$j++]=1;$q($_.d1w);$q($_.checklt);$q($_.d2w);$k[$j++]=1;$k[$j++]=1;$k[$j++]=0;$_.top=$a();$k[$j++]=Infinity;$k[$j++]=1;$k[$j++]=1;$q($_.d4w);$q($_.checkrt);$q($_.d3w);$k[$j++]=1;$k[$j++]=1;$k[$j++]=0;$_.bot=$a();for(var _6c=0;_6c<=24;_6c+=2){$_.i=_6c;for(var _6g=0,_6h=$g($_.top,$_.i);_6g<_6h;_6g++){$k[$j++]=0}for(var _6l=0,_6m=$g($_.top,$_.i+1);_6l<_6m;_6l++){$k[$j++]=1}}$as($a(50));$_.top=$k[--$j];for(var _6p=0;_6p<=24;_6p+=2){$_.i=_6p;for(var _6t=0,_6u=$g($_.bot,$_.i);_6t<_6u;_6t++){$k[$j++]=1}for(var _6y=0,_6z=$g($_.bot,$_.i+1);_6y<_6z;_6y++){$k[$j++]=0}}$as($a(50));$_.bot=$k[--$j];if($eq($_.format,"stacked")){$_.sep=$a(50);$p($_.sep,0,0);for(var _75=1;_75<=49;_75+=1){$_.i=_75;if($eq($g($_.top,$_.i),$g($_.bot,$_.i))){$p($_.sep,$_.i,1-$g($_.top,$_.i))}else{$p($_.sep,$_.i,1-$g($_.sep,$_.i-1))}}$P($_.sep,0,$a([0,0,0,0]));$P($_.sep,46,$a([0,0,0,0]));$k[$j++]=Infinity;for(var _7Q=0;_7Q<5;_7Q++){$q($_.top)}$q($_.sep);for(var _7T=0;_7T<7;_7T++){$q($_.bot)}$_.pixs=$a();$_.pixy=~~($_.pixs.length/50)}if($eq($_.format,"stackedomni")){$k[$j++]=Infinity;$F($_.top,function(){var _7Z=$k[--$j];$k[$j++]=1-_7Z});$_.sep1=$a();$P($_.sep1,0,$a([0,0,0,0]));$P($_.sep1,46,$a([0,0,0,0]));for(var _7f=18;_7f<=30;_7f+=1){$_.i=_7f;if($g($_.top,$_.i)==0){if($g($_.top,$_.i-1)==1){$k[$j++]=1}else{var _7p=$g($_.sep1,$_.i-1)==0?1:0;$k[$j++]=_7p}}else{$k[$j++]=0}$p($_.sep1,$_.i,$k[--$j])}$k[$j++]=Infinity;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;for(var _7t=0;_7t<21;_7t++){$k[$j++]=0;$k[$j++]=1}$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$_.sep2=$a();$k[$j++]=Infinity;$F($_.bot,function(){var _7w=$k[--$j];$k[$j++]=1-_7w});$_.sep3=$a();$P($_.sep3,0,$a([0,0,0,0]));$P($_.sep3,46,$a([0,0,0,0]));for(var _82=19;_82<=31;_82+=1){$_.i=_82;if($g($_.bot,$_.i)==0){if($g($_.bot,$_.i-1)==1){$k[$j++]=1}else{var _8C=$g($_.sep3,$_.i-1)==0?1:0;$k[$j++]=_8C}}else{$k[$j++]=0}$p($_.sep3,$_.i,$k[--$j])}$_.f3=$a([1,1,1,1,1,1,1,1,1,0,1,1,1]);$k[$j++]=true;for(var _8H=0;_8H<=12;_8H+=1){var _8M=$k[--$j];$k[$j++]=_8M&&$eq($g($_.bot,_8H+19),$g($_.f3,_8H))}if($k[--$j]){$P($_.sep3,19,$a([0,0,0,0,0,0,0,0,0,0,1,0,0]))}$k[$j++]=Infinity;for(var _8R=0,_8S=$_.barxmult;_8R<_8S;_8R++){$q($_.top)}$q($_.sep1);$q($_.sep2);$q($_.sep3);for(var _8Y=0,_8Z=$_.barxmult;_8Y<_8Z;_8Y++){$q($_.bot)}$_.pixs=$a();$_.pixy=~~($_.pixs.length/50)}var _8h=new Map([["ren","renmatrix"],["pixs",$_.pixs],["pixx",50],["pixy",$_.pixy],["height",$_.pixy/72],["width",50/72],["borderleft",0],["borderright",0],["bordertop",0],["borderbottom",0],["opt",$_.options]]);$k[$j++]=_8h;if(!$_.dontdraw){bwipp_renmatrix()}}$_=$__}function bwipp_databarstacked(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.barcode.length!=17&&$_.barcode.length!=18){$k[$j++]="bwipp.databarstackedBadLength#9532";$k[$j++]="GS1 DataBar Stacked must be 13 or 14 digits";bwipp_raiseerror()}if($ne($G($_.barcode,0,4),"(01)")){$k[$j++]="bwipp.databarstackedBadAI#9535";$k[$j++]="GS1 DataBar Stacked must begin with (01) application identifier";bwipp_raiseerror()}var _8=$G($_.barcode,4,$_.barcode.length-4);for(var _9=0,_A=_8.length;_9<_A;_9++){var _B=$g(_8,_9);if(_B<48||_B>57){$k[$j++]="bwipp.databarstackedBadCharacter#9539";$k[$j++]="GS1 DataBar Stacked must contain only digits";bwipp_raiseerror()}}$_.checksum=0;for(var _C=0;_C<=12;_C+=1){$_.i=_C;$k[$j++]="checksum";$k[$j++]=$_.checksum;$k[$j++]=$g($_.barcode,$_.i+4)-48;if($_.i%2==0){var _I=$k[--$j];$k[$j++]=_I*3}var _J=$k[--$j];var _K=$k[--$j];$_[$k[--$j]]=$f(_K+_J)}$_.checksum=(10-$_.checksum%10)%10;if($_.barcode.length==18){if($g($_.barcode,17)!=$_.checksum+48){$k[$j++]="bwipp.databarstackedBadCheckDigit#9552";$k[$j++]="Incorrect GS1 DataBar Stacked check digit provided";bwipp_raiseerror()}}var _R=$s(18);$P(_R,0,$_.barcode);$p(_R,17,$_.checksum+48);$_.barcode=_R;$p($_.options,"dontdraw",true);$p($_.options,"format","stacked");$k[$j++]="args";$k[$j++]=$_.barcode;$k[$j++]=$_.options;bwipp_databaromni();var _Y=$k[--$j];$_[$k[--$j]]=_Y;$p($_.args,"opt",$_.options);$k[$j++]=$_.args;if(!$_.dontdraw){bwipp_renmatrix()}$_=$__}function bwipp_databarstackedomni(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($ne($G($_.barcode,0,4),"(01)")){$k[$j++]="bwipp.databarstackedomniBadAI#9610";$k[$j++]="GS1 DataBar Stacked Omnidirectional must begin with (01) application identifier";bwipp_raiseerror()}if($_.barcode.length!=17&&$_.barcode.length!=18){$k[$j++]="bwipp.databarstackedomniBadLength#9613";$k[$j++]="GS1 DataBar Stacked Omnidirectional must be 13 or 14 digits";bwipp_raiseerror()}var _8=$G($_.barcode,4,$_.barcode.length-4);for(var _9=0,_A=_8.length;_9<_A;_9++){var _B=$g(_8,_9);if(_B<48||_B>57){$k[$j++]="bwipp.databarstackedomniBadCharacter#9617";$k[$j++]="GS1 DataBar Stacked Omnidirectional must contain only digits";bwipp_raiseerror()}}$_.checksum=0;for(var _C=0;_C<=12;_C+=1){$_.i=_C;$k[$j++]="checksum";$k[$j++]=$_.checksum;$k[$j++]=$g($_.barcode,$_.i+4)-48;if($_.i%2==0){var _I=$k[--$j];$k[$j++]=_I*3}var _J=$k[--$j];var _K=$k[--$j];$_[$k[--$j]]=$f(_K+_J)}$_.checksum=(10-$_.checksum%10)%10;if($_.barcode.length==18){if($g($_.barcode,17)!=$_.checksum+48){$k[$j++]="bwipp.databarstackedomniBadCheckDigit#9630";$k[$j++]="Incorrect GS1 DataBar Stacked Omnidirectional check digit provided";bwipp_raiseerror()}}var _R=$s(18);$P(_R,0,$_.barcode);$p(_R,17,$_.checksum+48);$_.barcode=_R;$p($_.options,"dontdraw",true);$p($_.options,"format","stackedomni");$k[$j++]="args";$k[$j++]=$_.barcode;$k[$j++]=$_.options;bwipp_databaromni();var _Y=$k[--$j];$_[$k[--$j]]=_Y;$p($_.args,"opt",$_.options);$k[$j++]=$_.args;if(!$_.dontdraw){bwipp_renmatrix()}$_=$__}function bwipp_databartruncated(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.barcode.length!=17&&$_.barcode.length!=18){$k[$j++]="bwipp.databartruncatedBadLength#9688";$k[$j++]="GS1 DataBar Truncated must be 13 or 14 digits";bwipp_raiseerror()}if($ne($G($_.barcode,0,4),"(01)")){$k[$j++]="bwipp.databartruncatedBadAI#9691";$k[$j++]="GS1 DataBar Truncated must begin with (01) application identifier";bwipp_raiseerror()}var _8=$G($_.barcode,4,$_.barcode.length-4);for(var _9=0,_A=_8.length;_9<_A;_9++){var _B=$g(_8,_9);if(_B<48||_B>57){$k[$j++]="bwipp.databartruncatedBadCharacter#9695";$k[$j++]="GS1 DataBar Truncated must contain only digits";bwipp_raiseerror()}}$_.checksum=0;for(var _C=0;_C<=12;_C+=1){$_.i=_C;$k[$j++]="checksum";$k[$j++]=$_.checksum;$k[$j++]=$g($_.barcode,$_.i+4)-48;if($_.i%2==0){var _I=$k[--$j];$k[$j++]=_I*3}var _J=$k[--$j];var _K=$k[--$j];$_[$k[--$j]]=$f(_K+_J)}$_.checksum=(10-$_.checksum%10)%10;if($_.barcode.length==18){if($g($_.barcode,17)!=$_.checksum+48){$k[$j++]="bwipp.databartruncatedBadCheckDigit#9708";$k[$j++]="Incorrect GS1 DataBar Truncated check digit provided";bwipp_raiseerror()}}var _R=$s(18);$P(_R,0,$_.barcode);$p(_R,17,$_.checksum+48);$_.barcode=_R;$p($_.options,"dontdraw",true);$p($_.options,"format","truncated");$k[$j++]="args";$k[$j++]=$_.barcode;$k[$j++]=$_.options;bwipp_databaromni();var _Y=$k[--$j];$_[$k[--$j]]=_Y;$p($_.args,"opt",$_.options);$k[$j++]=$_.args;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_databarlimited(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.height=10/72;$_.linkage=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.barcode.length!=17&&$_.barcode.length!=18){$k[$j++]="bwipp.databarlimitedBadLength#9771";$k[$j++]="GS1 DataBar Limited must be 13 or 14 digits";bwipp_raiseerror()}if($ne($G($_.barcode,0,4),"(01)")){$k[$j++]="bwipp.databarlimitedBadAI#9774";$k[$j++]="GS1 DataBar Limited must begin with (01) application identifier";bwipp_raiseerror()}var _7=$g($_.barcode,4);if(_7<48||_7>49){$k[$j++]="bwipp.databarlimitedBadStartDigit#9777";$k[$j++]="GS1 DataBar Limited must begin with 0 or 1";bwipp_raiseerror()}var _A=$G($_.barcode,5,$_.barcode.length-5);for(var _B=0,_C=_A.length;_B<_C;_B++){var _D=$g(_A,_B);if(_D<48||_D>57){$k[$j++]="bwipp.databarlimitedBadCharacter#9781";$k[$j++]="GS1 DataBar Limited must contain only digits";bwipp_raiseerror()}}$_.checksum=0;for(var _E=0;_E<=12;_E+=1){$_.i=_E;$k[$j++]="checksum";$k[$j++]=$_.checksum;$k[$j++]=$g($_.barcode,$_.i+4)-48;if($_.i%2==0){var _K=$k[--$j];$k[$j++]=_K*3}var _L=$k[--$j];var _M=$k[--$j];$_[$k[--$j]]=$f(_M+_L)}$_.checksum=(10-$_.checksum%10)%10;if($_.barcode.length==18){if($g($_.barcode,17)!=$_.checksum+48){$k[$j++]="bwipp.databarlimitedBadCheckDigit#9794";$k[$j++]="Incorrect GS1 DataBar Limited check digit provided";bwipp_raiseerror()}}var _T=$s(18);$P(_T,0,$_.barcode);$p(_T,17,$_.checksum+48);$_.barcode=_T;$_.linkval=$a([2,0,1,5,1,3,3,5,3,1,0,9,6]);$k[$j++]=Infinity;var _Z=$G($_.barcode,4,13);for(var _a=0,_b=_Z.length;_a<_b;_a++){$k[$j++]=$g(_Z,_a)-48}$_.binval=$a();if($_.linkage){for(var _h=0,_g=$_.binval.length-1;_h<=_g;_h+=1){$_.i=_h;$p($_.binval,$_.i,$f($g($_.binval,$_.i)+$g($_.linkval,$_.i)))}}$_.txt=$a($_.barcode.length);for(var _u=0,_t=$_.barcode.length-1;_u<=_t;_u+=1){$_.i=_u;$p($_.txt,$_.i,$a([$G($_.barcode,$_.i,1),0,0,"",0]))}$_.ncr=function(){var _11=$k[--$j];var _12=$k[--$j];var _13=$f(_12-_11);if(_11<$f(_12-_11)){var _=_13;_13=_11;_11=_}$k[$j++]=_13;$k[$j++]=1;$k[$j++]=1;for(var _15=_12,_14=_11+1;_15>=_14;_15-=1){var _16=$k[--$j];var _17=$k[$j-1];var _18=$k[$j-2];$k[$j++]=_16*_15;if($le(_17,_18)){var _19=$k[--$j];var _1A=$k[--$j];$k[$j++]=_1A+1;$k[$j++]=~~(_19/_1A)}}for(;;){var _1C=$k[$j-2];var _1D=$k[$j-3];if($gt(_1C,_1D)){break}var _1E=$k[--$j];var _1F=$k[--$j];$k[$j++]=_1F+1;$k[$j++]=~~(_1E/_1F)}var _1G=$k[--$j];$k[$j-1]=_1G;var _1I=$k[--$j];$k[$j-1]=_1I};$_.getRSSwidths=function(){$_.oe=$k[--$j];$_.el=$k[--$j];$_.mw=$k[--$j];$_.nm=$k[--$j];$_.val=$k[--$j];$_.out=$a($_.el);$_.mask=0;for(var _1T=0,_1S=$_.el-2;_1T<=_1S;_1T+=1){$_.bar=_1T;$_.ew=1;var _1V=$_.bar;$_.mask=$_.mask|(_1V<0?1>>>-_1V:1<<_1V);for(;;){$k[$j++]="sval";$k[$j++]=$f($_.nm-$_.ew)-1;$k[$j++]=$f($_.el-$_.bar)-2;$_.ncr();var _1a=$k[--$j];$_[$k[--$j]]=_1a;if($_.oe&&$_.mask==0&&$f($_.nm-$_.ew-$_.el*2+$_.bar*2)>=-2){$k[$j++]="sval";$k[$j++]=$_.sval;$k[$j++]=$f($_.nm-$_.ew-$_.el+$_.bar);$k[$j++]=$f($_.el-$_.bar)-2;$_.ncr();var _1p=$k[--$j];var _1q=$k[--$j];$_[$k[--$j]]=$f(_1q-_1p)}if($f($_.el-$_.bar)>2){$_.lval=0;for(var _20=$f($_.nm-$_.ew-$_.el+$_.bar)+2,_1z=$_.mw+1;_20>=_1z;_20-=1){$k[$j++]=$f($_.nm-_20-$_.ew)-1;$k[$j++]=$f($_.el-$_.bar)-3;$_.ncr();$_.lval=$f($k[--$j]+$_.lval)}$_.sval=$f($_.sval-$_.lval*($_.el-$_.bar-1))}else{if($f($_.nm-$_.ew)>$_.mw){$_.sval=$_.sval-1}}$_.val=$f($_.val-$_.sval);if($_.val<0){break}$_.ew=$_.ew+1;var _2K=$_.bar;$_.mask=$_.mask&~(_2K<0?1>>>-_2K:1<<_2K)}$_.val=$f($_.val+$_.sval);$_.nm=$f($_.nm-$_.ew);$p($_.out,$_.bar,$_.ew)}$p($_.out,$_.el-1,$_.nm);$k[$j++]=$_.out};for(var _2W=0;_2W<=11;_2W+=1){$_.i=_2W;var _2X=$_.binval;var _2Y=$_.i;$p(_2X,_2Y+1,$f($g(_2X,_2Y+1)+$g($_.binval,$_.i)%2013571*10));$p($_.binval,$_.i,~~($g($_.binval,$_.i)/2013571))}$_.d2=$g($_.binval,12)%2013571;var _2k=$_.binval;$p(_2k,12,~~($g(_2k,12)/2013571));$_.d1=0;$_.i=true;for(var _2m=0;_2m<=12;_2m+=1){$_.j=_2m;var _2p=$g($_.binval,$_.j);$k[$j++]=_2p;if(_2p==0&&$_.i){$j--}else{$_.i=false;$k[$j++]="d1";$k[$j++]=$_.d1;var _2t=$k[$j-3];var _2u=$k[$j-1];$_[$k[$j-2]]=$f(_2u+_2t*~~$pow(10,12-$_.j));$j-=3}}$_.tab267=$a([183063,0,17,9,6,3,6538,28,820063,183064,13,13,5,4,875,728,1000775,820064,9,17,3,6,28,6454,1491020,1000776,15,11,5,4,2415,203,1979844,1491021,11,15,4,5,203,2408,1996938,1979845,19,7,8,1,17094,1,2013570,1996939,7,19,1,8,1,16632]);$_.i=0;for(;;){if($_.d1<=$g($_.tab267,$_.i)){$q($G($_.tab267,$_.i+1,7));$_.d1te=$k[--$j];$_.d1to=$k[--$j];$_.d1mwe=$k[--$j];$_.d1mwo=$k[--$j];$_.d1ele=$k[--$j];$_.d1elo=$k[--$j];$_.d1gs=$k[--$j];break}$_.i=$_.i+8}$_.i=0;for(;;){if($_.d2<=$g($_.tab267,$_.i)){$q($G($_.tab267,$_.i+1,7));$_.d2te=$k[--$j];$_.d2to=$k[--$j];$_.d2mwe=$k[--$j];$_.d2mwo=$k[--$j];$_.d2ele=$k[--$j];$_.d2elo=$k[--$j];$_.d2gs=$k[--$j];break}$_.i=$_.i+8}$k[$j++]="d1wo";$k[$j++]=~~($f($_.d1-$_.d1gs)/$_.d1te);$k[$j++]=$_.d1elo;$k[$j++]=$_.d1mwo;$k[$j++]=7;$k[$j++]=false;$_.getRSSwidths();var _3X=$k[--$j];$_[$k[--$j]]=_3X;$k[$j++]="d1we";$k[$j++]=$f($_.d1-$_.d1gs)%$_.d1te;$k[$j++]=$_.d1ele;$k[$j++]=$_.d1mwe;$k[$j++]=7;$k[$j++]=true;$_.getRSSwidths();var _3e=$k[--$j];$_[$k[--$j]]=_3e;$k[$j++]="d2wo";$k[$j++]=~~($f($_.d2-$_.d2gs)/$_.d2te);$k[$j++]=$_.d2elo;$k[$j++]=$_.d2mwo;$k[$j++]=7;$k[$j++]=false;$_.getRSSwidths();var _3l=$k[--$j];$_[$k[--$j]]=_3l;$k[$j++]="d2we";$k[$j++]=$f($_.d2-$_.d2gs)%$_.d2te;$k[$j++]=$_.d2ele;$k[$j++]=$_.d2mwe;$k[$j++]=7;$k[$j++]=true;$_.getRSSwidths();var _3s=$k[--$j];$_[$k[--$j]]=_3s;$_.d1w=$a(14);for(var _3v=0;_3v<=6;_3v+=1){$_.i=_3v;$p($_.d1w,$_.i*2,$g($_.d1wo,$_.i));$p($_.d1w,$_.i*2+1,$g($_.d1we,$_.i))}$_.d2w=$a(14);for(var _47=0;_47<=6;_47+=1){$_.i=_47;$p($_.d2w,$_.i*2,$g($_.d2wo,$_.i));$p($_.d2w,$_.i*2+1,$g($_.d2we,$_.i))}$k[$j++]=Infinity;$q($_.d1w);$q($_.d2w);$_.widths=$a();$_.checkweights=$a([1,3,9,27,81,65,17,51,64,14,42,37,22,66,20,60,2,6,18,54,73,41,34,13,39,28,84,74]);$k[$j++]=Infinity;for(var _4M=0;_4M<=43;_4M+=1){$k[$j++]=_4M}$k[$j++]=45;$k[$j++]=52;$k[$j++]=57;for(var _4N=63;_4N<=66;_4N+=1){$k[$j++]=_4N}for(var _4O=73;_4O<=79;_4O+=1){$k[$j++]=_4O}$k[$j++]=82;for(var _4P=126;_4P<=130;_4P+=1){$k[$j++]=_4P}$k[$j++]=132;for(var _4Q=141;_4Q<=146;_4Q+=1){$k[$j++]=_4Q}for(var _4R=210;_4R<=217;_4R+=1){$k[$j++]=_4R}$k[$j++]=220;for(var _4S=316;_4S<=320;_4S+=1){$k[$j++]=_4S}$k[$j++]=322;$k[$j++]=323;$k[$j++]=326;$k[$j++]=337;$_.checkseq=$a();$_.checksum=0;for(var _4V=0;_4V<=27;_4V+=1){$_.i=_4V;$_.checksum=$f($_.checksum+$g($_.widths,$_.i)*$g($_.checkweights,$_.i))}$_.checksum=$_.checksum%89;$_.seq=$g($_.checkseq,$_.checksum);$k[$j++]="swidths";$k[$j++]=~~($_.seq/21);$k[$j++]=8;$k[$j++]=3;$k[$j++]=6;$k[$j++]=false;$_.getRSSwidths();var _4i=$k[--$j];$_[$k[--$j]]=_4i;$k[$j++]="bwidths";$k[$j++]=$_.seq%21;$k[$j++]=8;$k[$j++]=3;$k[$j++]=6;$k[$j++]=false;$_.getRSSwidths();var _4l=$k[--$j];$_[$k[--$j]]=_4l;$_.checkwidths=$a([0,0,0,0,0,0,0,0,0,0,0,0,1,1]);for(var _4o=0;_4o<=5;_4o+=1){$_.i=_4o;$p($_.checkwidths,$_.i*2,$g($_.swidths,$_.i));$p($_.checkwidths,$_.i*2+1,$g($_.bwidths,$_.i))}$k[$j++]=Infinity;$k[$j++]=1;$q($_.d1w);$q($_.checkwidths);$q($_.d2w);$k[$j++]=1;$k[$j++]=1;$k[$j++]=5;$_.sbs=$a();$k[$j++]=Infinity;var _53=$_.sbs;$k[$j++]=Infinity;for(var _55=0,_56=~~(($_.sbs.length+1)/2);_55<_56;_55++){$k[$j++]=$_.height}var _58=$a();$k[$j++]=Infinity;for(var _5A=0,_5B=~~(($_.sbs.length+1)/2);_5A<_5B;_5A++){$k[$j++]=0}var _5C=$a();$k[$j++]="ren";$k[$j++]="renlinear";$k[$j++]="sbs";$k[$j++]=_53;$k[$j++]="bhs";$k[$j++]=_58;$k[$j++]="bbs";$k[$j++]=_5C;$k[$j++]="txt";$k[$j++]=$_.txt;$k[$j++]="textxalign";$k[$j++]="center";$k[$j++]="borderleft";$k[$j++]=0;$k[$j++]="borderright";$k[$j++]=0;$k[$j++]="opt";$k[$j++]=$_.options;var _5F=$d();$k[$j++]=_5F;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_databarexpanded(){var $__=$_;$_=Object.assign({},$_);$_.parse=false;$_.dontlint=false;$_.lintreqs=true;$_.dontdraw=false;$_.height=34/72;$_.format="expanded";$_.segments=-1;$_.linkage=false;$_.barxmult=34;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.barxmult<34){$k[$j++]="bwipp.databarStackedOmniBarXmult#10075";$k[$j++]="GS1 DataBar Expanded Stacked must have a barxmult of at least 34";bwipp_raiseerror()}if($ne($_.format,"expanded")&&$ne($_.format,"expandedstacked")){$k[$j++]="bwipp.databarexpandedBadFormat#10079";$k[$j++]="Valid formats are expanded and expandedstacked";bwipp_raiseerror()}if($_.segments==-1){var _7=$eq($_.format,"expandedstacked")?4:22;$_.segments=_7}else{if($_.segments<2||$_.segments>22||$_.segments%2!=0){$k[$j++]="bwipp.gs1databarexpandedBadSegments#10086";$k[$j++]="The number of segments must be even from 2 to 22";bwipp_raiseerror()}}$k[$j++]=$_.barcode;$k[$j++]="ai";bwipp_gs1process();$_.fncs=$k[--$j];$_.vals=$k[--$j];$_.ais=$k[--$j];for(;;){if($_.ais.length==2){if($eq($g($_.ais,0),"01")&&$eq($g($_.ais,1),"3103")){if($eq($G($g($_.vals,0),0,1),"9")&&$i($g($_.vals,1))<=32767){$k[$j++]="0100";$k[$j++]=false;break}}}if($_.ais.length==2){if($eq($g($_.ais,0),"01")&&$eq($g($_.ais,1),"3202")){if($eq($G($g($_.vals,0),0,1),"9")&&$i($g($_.vals,1))<=9999){$k[$j++]="0101";$k[$j++]=false;break}}}if($_.ais.length==2){if($eq($g($_.ais,0),"01")&&$eq($g($_.ais,1),"3203")){if($eq($G($g($_.vals,0),0,1),"9")&&$i($g($_.vals,1))<=22767){$k[$j++]="0101";$k[$j++]=false;break}}}var _k=$_.ais.length;if(_k==2||_k==3){$k[$j++]="ai310x";$k[$j++]=false;for(var _l=3100;_l<=3109;_l+=1){var _q=$k[--$j];$k[$j++]=_q||$eq($R($s(4),_l,10),$g($_.ais,1))}var _r=$k[--$j];$_[$k[--$j]]=_r;$k[$j++]="ai320x";$k[$j++]=false;for(var _t=3200;_t<=3209;_t+=1){var _y=$k[--$j];$k[$j++]=_y||$eq($R($s(4),_t,10),$g($_.ais,1))}var _z=$k[--$j];$_[$k[--$j]]=_z;if($_.ais.length==3){var _12=$a(["11","13","15","17"]);$k[$j++]="aibad";$k[$j++]=true;for(var _13=0,_14=_12.length;_13<_14;_13++){var _18=$k[--$j];$k[$j++]=_18&&$ne($g(_12,_13),$g($_.ais,2))}var _19=$k[--$j];$_[$k[--$j]]=_19}else{$_.aibad=false}if($eq($g($_.ais,0),"01")&&($_.ai310x||$_.ai320x)&&!$_.aibad){if($_.ais.length==3){var _1P=$i($G($g($_.vals,2),2,2));var _1T=$i($G($g($_.vals,2),4,2));if($eq($G($g($_.vals,0),0,1),"9")&&$i($g($_.vals,1))<=99999&&(_1P>=1&&_1P<=12)&&(_1T>=0&&_1T<=31)){if($_.ai310x&&$eq($g($_.ais,2),"11")){$k[$j++]="0111000";$k[$j++]=false;break}if($_.ai320x&&$eq($g($_.ais,2),"11")){$k[$j++]="0111001";$k[$j++]=false;break}if($_.ai310x&&$eq($g($_.ais,2),"13")){$k[$j++]="0111010";$k[$j++]=false;break}if($_.ai320x&&$eq($g($_.ais,2),"13")){$k[$j++]="0111011";$k[$j++]=false;break}if($_.ai310x&&$eq($g($_.ais,2),"15")){$k[$j++]="0111100";$k[$j++]=false;break}if($_.ai320x&&$eq($g($_.ais,2),"15")){$k[$j++]="0111101";$k[$j++]=false;break}if($_.ai310x&&$eq($g($_.ais,2),"17")){$k[$j++]="0111110";$k[$j++]=false;break}if($_.ai320x&&$eq($g($_.ais,2),"17")){$k[$j++]="0111111";$k[$j++]=false;break}}}else{if($eq($G($g($_.vals,0),0,1),"9")&&$i($g($_.vals,1))<=99999){if($_.ai310x){$k[$j++]="0111000";$k[$j++]=false;break}if($_.ai320x){$k[$j++]="0111001";$k[$j++]=false;break}}}}}if($_.ais.length>=2){$k[$j++]="ai392x";$k[$j++]=false;for(var _20=3920;_20<=3923;_20+=1){var _25=$k[--$j];$k[$j++]=_25||$eq($R($s(4),_20,10),$g($_.ais,1))}var _26=$k[--$j];$_[$k[--$j]]=_26;if($eq($g($_.ais,0),"01")&&$_.ai392x){if($eq($G($g($_.vals,0),0,1),"9")){$k[$j++]="01100";$k[$j++]=true;break}}}if($_.ais.length>=2){$k[$j++]="ai393x";$k[$j++]=false;for(var _2F=3930;_2F<=3933;_2F+=1){var _2K=$k[--$j];$k[$j++]=_2K||$eq($R($s(4),_2F,10),$g($_.ais,1))}var _2L=$k[--$j];$_[$k[--$j]]=_2L;if($eq($g($_.ais,0),"01")&&$_.ai393x){if($eq($G($g($_.vals,0),0,1),"9")){$k[$j++]="01101";$k[$j++]=true;break}}}if($eq($g($_.ais,0),"01")){$k[$j++]="1";$k[$j++]=true;break}$k[$j++]="00";$k[$j++]=true;break}$_.gpfallow=$k[--$j];$_.method=$k[--$j];$_.conv12to40=function(){var _2Y=$Z($s(40),"0000000000000000000000000000000000000000");var _2Z=$k[--$j];var _2d=$R($s(10),$i($G(_2Z,0,3)),2);$P($G(_2Y,0,10),10-_2d.length,_2d);var _2h=$R($s(10),$i($G(_2Z,3,3)),2);$P($G(_2Y,10,10),10-_2h.length,_2h);var _2l=$R($s(10),$i($G(_2Z,6,3)),2);$P($G(_2Y,20,10),10-_2l.length,_2l);var _2p=$R($s(10),$i($G(_2Z,9,3)),2);$P($G(_2Y,30,10),10-_2p.length,_2p);$k[$j++]=_2Y};$_.conv13to44=function(){var _2r=$Z($s(44),"00000000000000000000000000000000000000000000");var _2s=$k[--$j];var _2w=$R($s(4),$i($G(_2s,0,1)),2);$P($G(_2r,0,4),4-_2w.length,_2w);$k[$j++]=_2r;$k[$j++]=_2r;$k[$j++]=$G(_2s,1,12);$_.conv12to40();var _2y=$k[--$j];$P($k[--$j],4,_2y)};$_.tobin=function(){var _31=$s($k[--$j]);$k[$j++]=_31;for(var _33=0,_32=_31.length-1;_33<=_32;_33+=1){var _34=$k[$j-1];$p(_34,_33,48)}var _35=$k[$j-1];$k[$j++]=_35;var _36=$k[$j-3];var _37=$k[$j-1];$k[$j-3]=$k[$j-2];$j-=2;var _39=$R($s(_37.length),_36,2);$P(_37,_37.length-_39.length,_39)};$_.fnc1=-1;$_.lnumeric=-2;$_.lalphanumeric=-3;$_.liso646=-4;if($eq($_.method,"00")){$_.cdf=$a([]);$_.gpf=$a([])}if($eq($_.method,"1")){$k[$j++]="cdf";$k[$j++]=$G($g($_.vals,0),0,13);$_.conv13to44();var _3H=$k[--$j];$_[$k[--$j]]=_3H;$k[$j++]=Infinity;var _3J=$_.cdf;for(var _3K=0,_3L=_3J.length;_3K<_3L;_3K++){$k[$j++]=$g(_3J,_3K)-48}$_.cdf=$a();$_.gpf=$a([]);$_.ais=$G($_.ais,1,$_.ais.length-1);$_.vals=$G($_.vals,1,$_.vals.length-1);$_.fncs=$G($_.fncs,1,$_.fncs.length-1)}if($eq($_.method,"0100")){$_.cdf=$s(55);$k[$j++]=$_.cdf;$k[$j++]=0;$k[$j++]=$G($g($_.vals,0),1,12);$_.conv12to40();var _3e=$k[--$j];var _3f=$k[--$j];$P($k[--$j],_3f,_3e);$k[$j++]=$_.cdf;$k[$j++]=40;$k[$j++]=$i($g($_.vals,1));$k[$j++]=15;$_.tobin();var _3k=$k[--$j];var _3l=$k[--$j];$P($k[--$j],_3l,_3k);$k[$j++]=Infinity;var _3n=$_.cdf;for(var _3o=0,_3p=_3n.length;_3o<_3p;_3o++){$k[$j++]=$g(_3n,_3o)-48}$_.cdf=$a();$_.gpf=$a([]);$_.ais=$a([]);$_.vals=$a([]);$_.fncs=$a([])}if($eq($_.method,"0101")){$_.cdf=$s(55);$k[$j++]=$_.cdf;$k[$j++]=0;$k[$j++]=$G($g($_.vals,0),1,12);$_.conv12to40();var _42=$k[--$j];var _43=$k[--$j];$P($k[--$j],_43,_42);if($eq($g($_.ais,1),"3202")){$k[$j++]=$i($g($_.vals,1));$k[$j++]=15;$_.tobin()}else{$k[$j++]=$i($g($_.vals,1))+1e4;$k[$j++]=15;$_.tobin()}$P($_.cdf,40,$k[--$j]);$k[$j++]=Infinity;var _4D=$_.cdf;for(var _4E=0,_4F=_4D.length;_4E<_4F;_4E++){$k[$j++]=$g(_4D,_4E)-48}$_.cdf=$a();$_.gpf=$a([]);$_.ais=$a([]);$_.vals=$a([]);$_.fncs=$a([])}if($_.method.length==7){$_.cdf=$s(76);$k[$j++]=$_.cdf;$k[$j++]=0;$k[$j++]=$G($g($_.vals,0),1,12);$_.conv12to40();var _4S=$k[--$j];var _4T=$k[--$j];$P($k[--$j],_4T,_4S);var _4V=$s(6);$P(_4V,0,$G($g($_.ais,1),3,1));$P(_4V,1,$G($g($_.vals,1),1,5));$k[$j++]=$i(_4V);$k[$j++]=20;$_.tobin();$P($_.cdf,40,$k[--$j]);if($_.ais.length==3){var _4g=$g($_.vals,2);$k[$j++]=$i($G(_4g,0,2))*384+(($i($G(_4g,2,2))-1)*32+$i($G(_4g,4,2)))}else{$k[$j++]=38400}$k[$j++]=16;$_.tobin();$P($_.cdf,60,$k[--$j]);$k[$j++]=Infinity;var _4m=$_.cdf;for(var _4n=0,_4o=_4m.length;_4n<_4o;_4n++){$k[$j++]=$g(_4m,_4n)-48}$_.cdf=$a();$_.gpf=$a([]);$_.ais=$a([]);$_.vals=$a([]);$_.fncs=$a([])}if($eq($_.method,"01100")){$_.cdf=$s(42);$k[$j++]=$_.cdf;$k[$j++]=0;$k[$j++]=$G($g($_.vals,0),1,12);$_.conv12to40();var _51=$k[--$j];var _52=$k[--$j];$P($k[--$j],_52,_51);$k[$j++]=$_.cdf;$k[$j++]=40;$k[$j++]=$i($G($g($_.ais,1),3,1));$k[$j++]=2;$_.tobin();var _58=$k[--$j];var _59=$k[--$j];$P($k[--$j],_59,_58);$k[$j++]=Infinity;var _5B=$_.cdf;for(var _5C=0,_5D=_5B.length;_5C<_5D;_5C++){$k[$j++]=$g(_5B,_5C)-48}$_.cdf=$a();$k[$j++]=Infinity;$F($g($_.vals,1));if($_.ais.length>2){$k[$j++]=$_.fnc1}$_.gpf=$a();$_.ais=$G($_.ais,2,$_.ais.length-2);$_.vals=$G($_.vals,2,$_.vals.length-2);$_.fncs=$G($_.fncs,2,$_.fncs.length-2)}if($eq($_.method,"01101")){$_.cdf=$s(52);$k[$j++]=$_.cdf;$k[$j++]=0;$k[$j++]=$G($g($_.vals,0),1,12);$_.conv12to40();var _5a=$k[--$j];var _5b=$k[--$j];$P($k[--$j],_5b,_5a);$k[$j++]=$_.cdf;$k[$j++]=40;$k[$j++]=$i($G($g($_.ais,1),3,1));$k[$j++]=2;$_.tobin();var _5h=$k[--$j];var _5i=$k[--$j];$P($k[--$j],_5i,_5h);$k[$j++]=$_.cdf;$k[$j++]=42;$k[$j++]=$i($G($g($_.vals,1),0,3));$k[$j++]=10;$_.tobin();var _5o=$k[--$j];var _5p=$k[--$j];$P($k[--$j],_5p,_5o);$k[$j++]=Infinity;var _5r=$_.cdf;for(var _5s=0,_5t=_5r.length;_5s<_5t;_5s++){$k[$j++]=$g(_5r,_5s)-48}$_.cdf=$a();$k[$j++]=Infinity;var _5x=$g($_.vals,1);var _5y=$G(_5x,3,_5x.length-3);for(var _5z=0,_60=_5y.length;_5z<_60;_5z++){$k[$j++]=$g(_5y,_5z)}if($_.ais.length>2){$k[$j++]=$_.fnc1}$_.gpf=$a();$_.ais=$G($_.ais,2,$_.ais.length-2);$_.vals=$G($_.vals,2,$_.vals.length-2);$_.fncs=$G($_.fncs,2,$_.fncs.length-2)}if($_.gpfallow){$_.vlf=$a(2)}else{$_.vlf=$a([])}$k[$j++]=Infinity;for(var _6H=0;_6H<=119;_6H+=1){var _6J=$Z($s(2),"00");var _6L=$R($s(2),_6H,11);$P(_6J,2-_6L.length,_6L);$k[$j++]=_6H;$k[$j++]=_6J;if($g(_6J,0)==65){var _6N=$k[$j-1];$p(_6N,0,94)}var _6O=$k[$j-1];if($g(_6O,1)==65){var _6Q=$k[$j-1];$p(_6Q,1,94)}var _6R=$k[--$j];var _6U=$Z($s(7),"0000000");var _6W=$R($s(7),$k[--$j]+8,2);$P(_6U,7-_6W.length,_6W);$k[$j++]=_6R;$k[$j++]=_6U}$k[$j++]=$_.lalphanumeric;$k[$j++]="0000";$_.numeric=$d();$k[$j++]=Infinity;for(var _6Z=48;_6Z<=57;_6Z+=1){$k[$j++]=_6Z;$k[$j++]=_6Z-43;$k[$j++]=5;$_.tobin()}$k[$j++]=$_.fnc1;$k[$j++]="01111";for(var _6b=65;_6b<=90;_6b+=1){$k[$j++]=_6b;$k[$j++]=_6b-33;$k[$j++]=6;$_.tobin()}$k[$j++]=42;$k[$j++]="111010";for(var _6c=44;_6c<=47;_6c+=1){$k[$j++]=_6c;$k[$j++]=_6c+15;$k[$j++]=6;$_.tobin()}$k[$j++]=$_.lnumeric;$k[$j++]="000";$k[$j++]=$_.liso646;$k[$j++]="00100";$_.alphanumeric=$d();$k[$j++]=Infinity;for(var _6g=48;_6g<=57;_6g+=1){$k[$j++]=_6g;$k[$j++]=_6g-43;$k[$j++]=5;$_.tobin()}$k[$j++]=$_.fnc1;$k[$j++]="01111";for(var _6i=65;_6i<=90;_6i+=1){$k[$j++]=_6i;$k[$j++]=_6i-1;$k[$j++]=7;$_.tobin()}for(var _6j=97;_6j<=122;_6j+=1){$k[$j++]=_6j;$k[$j++]=_6j-7;$k[$j++]=7;$_.tobin()}$k[$j++]=33;$k[$j++]="11101000";$k[$j++]=34;$k[$j++]="11101001";for(var _6k=37;_6k<=47;_6k+=1){$k[$j++]=_6k;$k[$j++]=_6k+197;$k[$j++]=8;$_.tobin()}for(var _6l=58;_6l<=63;_6l+=1){$k[$j++]=_6l;$k[$j++]=_6l+187;$k[$j++]=8;$_.tobin()}$k[$j++]=95;$k[$j++]="11111011";$k[$j++]=32;$k[$j++]="11111100";$k[$j++]=$_.lnumeric;$k[$j++]="000";$k[$j++]=$_.lalphanumeric;$k[$j++]="00100";$_.iso646=$d();for(var _6s=0,_6r=$_.ais.length-1;_6s<=_6r;_6s+=1){$_.i=_6s;$_.ai=$g($_.ais,$_.i);$_.val=$g($_.vals,$_.i);var _72=$a($_.gpf.length+$_.ai.length+$_.val.length);$P(_72,0,$_.gpf);$k[$j++]=_72;$k[$j++]=_72;$k[$j++]=$_.gpf.length;var _76=Infinity;var _77=$_.ai;$k[$j++]=_76;$F(_77);var _78=$a();var _79=$k[--$j];$P($k[--$j],_79,_78);var _7B=$k[$j-1];$k[$j++]=_7B;$k[$j++]=$_.gpf.length+$_.ai.length;var _7F=Infinity;var _7G=$_.val;$k[$j++]=_7F;$F(_7G);var _7H=$a();var _7I=$k[--$j];$P($k[--$j],_7I,_7H);$_.gpf=$k[--$j];if($_.i!=$_.ais.length-1&&$g($_.fncs,$_.i)){var _7R=$a($_.gpf.length+1);$P(_7R,0,$_.gpf);$p(_7R,$_.gpf.length,$_.fnc1);$_.gpf=_7R}}$_.rembits=function(){var _7V=$k[--$j];var _7W=48;var _7X=~~$ceil(_7V/12)*12;if(~~$ceil(_7V/12)*12<48){var _=_7W;_7W=_7X;_7X=_}var _7Y=~~(_7X/12);$k[$j++]=_7V;$k[$j++]=_7X;$k[$j++]=_7Y;if(_7Y%$_.segments==1){var _7a=$k[--$j];$k[$j-1]=(_7a+1)*12}else{$j--}var _7c=$k[--$j];var _7d=$k[--$j];$k[$j++]=$f(_7c-_7d)};$_.encode=function(){var _7e=$k[$j-1];if($ne(_7e,"raw")){var _7f=$k[--$j];var _7h=$g(_7f,$k[--$j]);$k[$j++]=_7h}else{$j--}var _7i=$k[$j-1];if(_7i.length+$_.j>=252){$j--;$k[$j++]="bwipp.gs1databarexpandedTooLong#10374";$k[$j++]="Maximum length exceeded";bwipp_raiseerror()}$k[$j++]=Infinity;var _7k=$k[--$j];var _7l=$k[--$j];$k[$j++]=_7k;$F(_7l,function(){var _7m=$k[--$j];$k[$j++]=_7m-48});var _7n=$a();$P($_.gpfenc,$_.j,_7n);$_.j=_7n.length+$_.j};$k[$j++]=Infinity;for(var _7s=0,_7t=$_.gpf.length;_7s<_7t;_7s++){$k[$j++]=0}$k[$j++]=0;$k[$j++]=-1;$_.numericruns=$a();$k[$j++]=Infinity;for(var _7w=0,_7x=$_.gpf.length;_7w<_7x;_7w++){$k[$j++]=0}$k[$j++]=0;$_.alphanumericruns=$a();$k[$j++]=Infinity;for(var _80=0,_81=$_.gpf.length;_80<_81;_80++){$k[$j++]=0}$k[$j++]=9999;$_.nextiso646only=$a();for(var _84=$_.gpf.length-1;_84>=0;_84-=1){$_.i=_84;var _89=$Z($s(2),"00");var _8C=$g($_.gpf,$_.i);$k[$j++]=$g($_.gpf,$_.i);$k[$j++]=_89;$k[$j++]=_89;$k[$j++]=0;$k[$j++]=_8C;if(_8C==$_.fnc1){$k[$j-1]=94}var _8E=$k[--$j];var _8F=$k[--$j];$p($k[--$j],_8F,_8E);if($_.i<$_.gpf.length-1){var _8J=$k[$j-1];var _8M=$g($_.gpf,$_.i+1);$k[$j++]=_8J;$k[$j++]=1;$k[$j++]=_8M;if(_8M==$_.fnc1){$k[$j-1]=94}var _8O=$k[--$j];var _8P=$k[--$j];$p($k[--$j],_8P,_8O)}var _8T=$g($_.numeric,$k[--$j])!==undefined;if(_8T){$p($_.numericruns,$_.i,$g($_.numericruns,$_.i+2)+2)}else{$p($_.numericruns,$_.i,0)}var _8b=$k[$j-1];var _8d=$g($_.alphanumeric,_8b)!==undefined;if(_8d){$p($_.alphanumericruns,$_.i,$g($_.alphanumericruns,$_.i+1)+1)}else{$p($_.alphanumericruns,$_.i,0)}var _8l=$k[--$j];var _8n=$g($_.iso646,_8l)!==undefined;var _8p=$g($_.alphanumeric,_8l)!==undefined;if(_8n&&!_8p){$p($_.nextiso646only,$_.i,0)}else{$p($_.nextiso646only,$_.i,$g($_.nextiso646only,$_.i+1)+1)}}$_.gpfenc=$a(252);$_.i=0;$_.j=0;$_.mode="numeric";for(;;){if($_.i==$_.gpf.length){break}for(;;){if($eq($_.mode,"numeric")){if($_.i<=$_.gpf.length-2){var _93=$s(2);var _96=$g($_.gpf,$_.i);$k[$j++]=_93;$k[$j++]=_93;$k[$j++]=0;$k[$j++]=_96;if(_96==$_.fnc1){$k[$j-1]=94}var _98=$k[--$j];var _99=$k[--$j];$p($k[--$j],_99,_98);var _9B=$k[$j-1];var _9E=$g($_.gpf,$_.i+1);$k[$j++]=_9B;$k[$j++]=1;$k[$j++]=_9E;if(_9E==$_.fnc1){$k[$j-1]=94}var _9G=$k[--$j];var _9H=$k[--$j];$p($k[--$j],_9H,_9G);var _9J=$k[$j-1];var _9L=$g($_.numeric,_9J)!==undefined;if(_9L){$k[$j++]=$_.numeric;$_.encode();$_.i=$_.i+2;break}$k[$j-1]=$_.lalphanumeric;$k[$j++]=$_.numeric;$_.encode();$_.mode="alphanumeric";break}else{var _9S=$g($_.gpf,$_.i);if(_9S<48||_9S>57){$k[$j++]=$_.lalphanumeric;$k[$j++]=$_.numeric;$_.encode();$_.mode="alphanumeric";break}$k[$j++]="rem";$k[$j++]=12+1+$_.method.length+$_.vlf.length+$_.cdf.length+$_.j;$_.rembits();var _9Z=$k[--$j];$_[$k[--$j]]=_9Z;if($_.rem>=4&&$_.rem<=6){var _9g=$G($Z($s(6),"000000"),0,$_.rem);var _9l=$R($s(4),$g($_.gpf,$_.i)-47,2);$P(_9g,4-_9l.length,_9l);$k[$j++]=_9g;$k[$j++]="raw";$_.encode();$_.i=$_.i+1;break}else{var _9n=$s(2);$p(_9n,0,$g($_.gpf,$_.i));$p(_9n,1,94);$k[$j++]=_9n;$k[$j++]=$_.numeric;$_.encode();$_.i=$_.i+1;break}}}if($eq($_.mode,"alphanumeric")){if($g($_.gpf,$_.i)==$_.fnc1){$k[$j++]=$_.fnc1;$k[$j++]=$_.alphanumeric;$_.encode();$_.mode="numeric";$_.i=$_.i+1;break}var _A3=$g($_.gpf,$_.i);var _A5=$g($_.iso646,_A3)!==undefined;var _A7=$g($_.alphanumeric,_A3)!==undefined;if(_A5&&!_A7){$k[$j++]=$_.liso646;$k[$j++]=$_.alphanumeric;$_.encode();$_.mode="iso646";break}if($g($_.numericruns,$_.i)>=6){$k[$j++]=$_.lnumeric;$k[$j++]=$_.alphanumeric;$_.encode();$_.mode="numeric";break}var _AH=$g($_.numericruns,$_.i);if(_AH>=4&&$f(_AH+$_.i)==$_.gpf.length){$k[$j++]=$_.lnumeric;$k[$j++]=$_.alphanumeric;$_.encode();$_.mode="numeric";break}$k[$j++]=$g($_.gpf,$_.i);$k[$j++]=$_.alphanumeric;$_.encode();$_.i=$_.i+1;break}if($eq($_.mode,"iso646")){if($g($_.gpf,$_.i)==$_.fnc1){$k[$j++]=$_.fnc1;$k[$j++]=$_.iso646;$_.encode();$_.mode="numeric";$_.i=$_.i+1;break}if($g($_.numericruns,$_.i)>=4&&$g($_.nextiso646only,$_.i)>=10){$k[$j++]=$_.lnumeric;$k[$j++]=$_.iso646;$_.encode();$_.mode="numeric";break}if($g($_.alphanumericruns,$_.i)>=5&&$g($_.nextiso646only,$_.i)>=10){$k[$j++]=$_.lalphanumeric;$k[$j++]=$_.iso646;$_.encode();$_.mode="alphanumeric";break}$k[$j++]=$g($_.gpf,$_.i);$k[$j++]=$_.iso646;$_.encode();$_.i=$_.i+1;break}}}$_.gpf=$G($_.gpfenc,0,$_.j);var _B1=1+12+$_.method.length+$_.vlf.length+$_.cdf.length+$_.gpf.length;$k[$j++]=_B1;$k[$j++]=_B1;$_.rembits();var _B2=$k[--$j];$_.pad=$a(_B2);$k[$j++]=_B2;if($_.vlf.length!=0){var _B5=$k[--$j];var _B7=~~($f($k[--$j]+_B5)/12);$p($_.vlf,0,_B7%2);var _B9=_B7<=14?0:1;$p($_.vlf,1,_B9)}else{$j-=2}if($_.pad.length>0){for(var _BE=0,_BD=$_.pad.length-1;_BE<=_BD;_BE+=5){$_.i=_BE;var _BF=$_.pad;var _BG=$_.i;var _BH=$a([0,0,1,0,0]);var _BI=$_.pad;var _BJ=$_.i;var _BK=5;var _BL=_BI.length-_BJ;if(_BI.length-_BJ>5){var _=_BK;_BK=_BL;_BL=_}$P(_BF,_BG,$G(_BH,0,_BL))}if($eq($_.mode,"numeric")){$k[$j++]=Infinity;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$q($_.pad);$_.pad=$G($a(),0,$_.pad.length)}}$k[$j++]=Infinity;var _BT=$_.linkage?1:0;$k[$j++]=_BT;$F($_.method,function(){var _BV=$k[--$j];$k[$j++]=_BV-48});$q($_.vlf);$q($_.cdf);$q($_.gpf);$q($_.pad);$_.binval=$a();$_.datalen=~~($_.binval.length/12);$_.ncr=function(){var _Bc=$k[--$j];var _Bd=$k[--$j];var _Be=$f(_Bd-_Bc);if(_Bc<$f(_Bd-_Bc)){var _=_Be;_Be=_Bc;_Bc=_}$k[$j++]=_Be;$k[$j++]=1;$k[$j++]=1;for(var _Bg=_Bd,_Bf=_Bc+1;_Bg>=_Bf;_Bg-=1){var _Bh=$k[--$j];var _Bi=$k[$j-1];var _Bj=$k[$j-2];$k[$j++]=_Bh*_Bg;if($le(_Bi,_Bj)){var _Bk=$k[--$j];var _Bl=$k[--$j];$k[$j++]=_Bl+1;$k[$j++]=~~(_Bk/_Bl)}}for(;;){var _Bn=$k[$j-2];var _Bo=$k[$j-3];if($gt(_Bn,_Bo)){break}var _Bp=$k[--$j];var _Bq=$k[--$j];$k[$j++]=_Bq+1;$k[$j++]=~~(_Bp/_Bq)}var _Br=$k[--$j];$k[$j-1]=_Br;var _Bt=$k[--$j];$k[$j-1]=_Bt};$_.getRSSwidths=function(){$_.oe=$k[--$j];$_.el=$k[--$j];$_.mw=$k[--$j];$_.nm=$k[--$j];$_.val=$k[--$j];$_.out=$a($_.el);$_.mask=0;for(var _C4=0,_C3=$_.el-2;_C4<=_C3;_C4+=1){$_.bar=_C4;$_.ew=1;var _C6=$_.bar;$_.mask=$_.mask|(_C6<0?1>>>-_C6:1<<_C6);for(;;){$k[$j++]="sval";$k[$j++]=$f($_.nm-$_.ew)-1;$k[$j++]=$f($_.el-$_.bar)-2;$_.ncr();var _CB=$k[--$j];$_[$k[--$j]]=_CB;if($_.oe&&$_.mask==0&&$f($_.nm-$_.ew-$_.el*2+$_.bar*2)>=-2){$k[$j++]="sval";$k[$j++]=$_.sval;$k[$j++]=$f($_.nm-$_.ew-$_.el+$_.bar);$k[$j++]=$f($_.el-$_.bar)-2;$_.ncr();var _CQ=$k[--$j];var _CR=$k[--$j];$_[$k[--$j]]=$f(_CR-_CQ)}if($f($_.el-$_.bar)>2){$_.lval=0;for(var _Cb=$f($_.nm-$_.ew-$_.el+$_.bar)+2,_Ca=$_.mw+1;_Cb>=_Ca;_Cb-=1){$k[$j++]=$f($_.nm-_Cb-$_.ew)-1;$k[$j++]=$f($_.el-$_.bar)-3;$_.ncr();$_.lval=$f($k[--$j]+$_.lval)}$_.sval=$f($_.sval-$_.lval*($_.el-$_.bar-1))}else{if($f($_.nm-$_.ew)>$_.mw){$_.sval=$_.sval-1}}$_.val=$f($_.val-$_.sval);if($_.val<0){break}$_.ew=$_.ew+1;var _Cv=$_.bar;$_.mask=$_.mask&~(_Cv<0?1>>>-_Cv:1<<_Cv)}$_.val=$f($_.val+$_.sval);$_.nm=$f($_.nm-$_.ew);$p($_.out,$_.bar,$_.ew)}$p($_.out,$_.el-1,$_.nm);$k[$j++]=$_.out};$_.tab174=$a([347,0,12,5,7,2,87,4,1387,348,10,7,5,4,52,20,2947,1388,8,9,4,5,30,52,3987,2948,6,11,3,6,10,104,4191,3988,4,13,1,8,1,204]);$_.dxw=$a($_.datalen);for(var _DD=0,_DC=$_.datalen-1;_DD<=_DC;_DD+=1){$_.x=_DD;$_.d=$G($_.binval,$_.x*12,12);$k[$j++]="d";$k[$j++]=0;for(var _DH=0;_DH<=11;_DH+=1){$_.j=_DH;var _DM=$k[--$j];$k[$j++]=$f(_DM+~~$pow(2,11-$_.j)*$g($_.d,$_.j))}var _DN=$k[--$j];$_[$k[--$j]]=_DN;$_.j=0;for(;;){if($le($_.d,$g($_.tab174,$_.j))){$q($G($_.tab174,$_.j+1,7));$_.dte=$k[--$j];$_.dto=$k[--$j];$_.dmwe=$k[--$j];$_.dmwo=$k[--$j];$_.dele=$k[--$j];$_.delo=$k[--$j];$_.dgs=$k[--$j];break}$_.j=$_.j+8}$k[$j++]="dwo";$k[$j++]=~~($f($_.d-$_.dgs)/$_.dte);$k[$j++]=$_.delo;$k[$j++]=$_.dmwo;$k[$j++]=4;$k[$j++]=true;$_.getRSSwidths();var _Dj=$k[--$j];$_[$k[--$j]]=_Dj;$k[$j++]="dwe";$k[$j++]=$f($_.d-$_.dgs)%$_.dte;$k[$j++]=$_.dele;$k[$j++]=$_.dmwe;$k[$j++]=4;$k[$j++]=false;$_.getRSSwidths();var _Dq=$k[--$j];$_[$k[--$j]]=_Dq;$_.dw=$a(8);if($_.x%2==0){for(var _Du=0;_Du<=3;_Du+=1){$_.j=_Du;$p($_.dw,7-$_.j*2,$g($_.dwo,$_.j));$p($_.dw,6-$_.j*2,$g($_.dwe,$_.j))}}else{for(var _E5=0;_E5<=3;_E5+=1){$_.j=_E5;$p($_.dw,$_.j*2,$g($_.dwo,$_.j));$p($_.dw,$_.j*2+1,$g($_.dwe,$_.j))}}$p($_.dxw,$_.x,$_.dw)}$_.finderwidths=$a([1,8,4,1,1,1,1,4,8,1,3,6,4,1,1,1,1,4,6,3,3,4,6,1,1,1,1,6,4,3,3,2,8,1,1,1,1,8,2,3,2,6,5,1,1,1,1,5,6,2,2,2,9,1,1,1,1,9,2,2]);$_.finderseq=$a([$a([0,1]),$a([0,3,2]),$a([0,5,2,7]),$a([0,9,2,7,4]),$a([0,9,2,7,6,11]),$a([0,9,2,7,8,11,10]),$a([0,1,2,3,4,5,6,7]),$a([0,1,2,3,4,5,6,9,8]),$a([0,1,2,3,4,5,6,9,10,11]),$a([0,1,2,3,4,7,6,9,8,11,10])]);$_.seq=$g($_.finderseq,~~(($_.datalen-2)/2));$_.fxw=$a($_.seq.length);for(var _Ed=0,_Ec=$_.seq.length-1;_Ed<=_Ec;_Ed+=1){$_.x=_Ed;$p($_.fxw,$_.x,$G($_.finderwidths,$g($_.seq,$_.x)*5,5))}$_.checkweights=$a([-1,-1,-1,-1,-1,-1,-1,-1,77,96,32,81,27,9,3,1,20,60,180,118,143,7,21,63,205,209,140,117,39,13,145,189,193,157,49,147,19,57,171,91,132,44,85,169,197,136,186,62,185,133,188,142,4,12,36,108,50,87,29,80,97,173,128,113,150,28,84,41,123,158,52,156,166,196,206,139,187,203,138,46,76,17,51,153,37,111,122,155,146,119,110,107,106,176,129,43,16,48,144,10,30,90,59,177,164,125,112,178,200,137,116,109,70,210,208,202,184,130,179,115,190,204,68,93,31,151,191,134,148,22,66,198,172,94,71,2,40,154,192,64,162,54,18,6,120,149,25,75,14,42,126,167,175,199,207,69,23,78,26,79,103,98,83,38,114,131,182,124,159,53,88,170,127,183,61,161,55,165,73,8,24,72,5,15,89,100,174,58,160,194,135,45]);$k[$j++]=Infinity;$F($_.seq,function(){$q($G($_.checkweights,$k[--$j]*16,16))});var _Er=$a();$_.checkweightseq=$G(_Er,8,_Er.length-8);$k[$j++]=Infinity;var _Et=$_.dxw;for(var _Eu=0,_Ev=_Et.length;_Eu<_Ev;_Eu++){$q($g(_Et,_Eu))}$_.widths=$a();$_.checksum=0;for(var _F0=0,_Ez=$_.widths.length-1;_F0<=_Ez;_F0+=1){$_.i=_F0;$_.checksum=$f($_.checksum+$g($_.widths,$_.i)*$g($_.checkweightseq,$_.i))}$_.checksum=$f($_.checksum%211+($_.datalen-3)*211);$_.i=0;for(;;){if($_.checksum<=$g($_.tab174,$_.i)){$q($G($_.tab174,$_.i+1,7));$_.cte=$k[--$j];$_.cto=$k[--$j];$_.cmwe=$k[--$j];$_.cmwo=$k[--$j];$_.cele=$k[--$j];$_.celo=$k[--$j];$_.cgs=$k[--$j];break}$_.i=$_.i+8}$k[$j++]="cwo";$k[$j++]=~~($f($_.checksum-$_.cgs)/$_.cte);$k[$j++]=$_.celo;$k[$j++]=$_.cmwo;$k[$j++]=4;$k[$j++]=true;$_.getRSSwidths();var _FU=$k[--$j];$_[$k[--$j]]=_FU;$k[$j++]="cwe";$k[$j++]=$f($_.checksum-$_.cgs)%$_.cte;$k[$j++]=$_.cele;$k[$j++]=$_.cmwe;$k[$j++]=4;$k[$j++]=false;$_.getRSSwidths();var _Fb=$k[--$j];$_[$k[--$j]]=_Fb;$_.cw=$a(8);for(var _Fe=0;_Fe<=3;_Fe+=1){$_.i=_Fe;$p($_.cw,$_.i*2,$g($_.cwo,$_.i));$p($_.cw,$_.i*2+1,$g($_.cwe,$_.i))}var _Fp=$a(22);$p(_Fp,0,$_.cw);$P(_Fp,1,$_.dxw);$_.dxw=$G(_Fp,0,$_.datalen+1);$_.datalen=$_.dxw.length;$_.rows=$a(~~$ceil($_.datalen/$_.segments));$_.numrows=$_.rows.length;for(var _G1=0,_G0=$_.numrows-1;_G1<=_G0;_G1+=1){$_.r=_G1;$k[$j++]=Infinity;if($_.segments%4!=0&&$_.r%2==1){$k[$j++]=0}$k[$j++]=1;$k[$j++]=1;for(var _G6=0,_G5=$_.segments-1;_G6<=_G5;_G6+=1){$_.pos=_G6+$_.r*$_.segments;if($_.pos<$_.datalen){$q($g($_.dxw,$_.pos));if($_.pos%2==0){$q($g($_.fxw,~~($_.pos/2)))}}}var _GI=$m()+2;$k[$j++]=1;$k[$j++]=1;$as($a(_GI));$p($_.rows,$_.r,$k[--$j]);$j--}if($ne($_.format,"expandedstacked")){var _GP=$g($_.rows,0);$_.sbs=$G(_GP,1,_GP.length-1);$k[$j++]=Infinity;$k[$j++]=1;for(var _GT=0,_GS=$_.datalen-1;_GT<=_GS;_GT+=1){$_.i=_GT;$q($g($_.dxw,$_.i));if($_.i%2==0){$q($g($_.fxw,~~($_.i/2)))}}$k[$j++]=1;$k[$j++]=1;$_.sbs=$a();$k[$j++]=Infinity;var _Gc=$_.sbs;$k[$j++]=Infinity;for(var _Ge=0,_Gf=~~(($_.sbs.length+1)/2);_Ge<_Gf;_Ge++){$k[$j++]=$_.height}var _Gh=$a();$k[$j++]=Infinity;for(var _Gj=0,_Gk=~~(($_.sbs.length+1)/2);_Gj<_Gk;_Gj++){$k[$j++]=0}var _Gl=$a();$k[$j++]="ren";$k[$j++]="renlinear";$k[$j++]="sbs";$k[$j++]=_Gc;$k[$j++]="bhs";$k[$j++]=_Gh;$k[$j++]="bbs";$k[$j++]=_Gl;$k[$j++]="borderleft";$k[$j++]=0;$k[$j++]="borderright";$k[$j++]=0;$k[$j++]="bordertop";$k[$j++]=0;$k[$j++]="borderbottom";$k[$j++]=0;$k[$j++]="opt";$k[$j++]=$_.options;var _Gn=$d();$k[$j++]=_Gn;if(!$_.dontdraw){bwipp_renlinear()}}else{$_.seps=$a($_.numrows);for(var _Gt=0,_Gs=$_.numrows-1;_Gt<=_Gs;_Gt+=1){$_.r=_Gt;$_.row=$g($_.rows,$_.r);$k[$j++]=Infinity;for(var _Gz=0,_Gy=$_.row.length-1;_Gz<=_Gy;_Gz+=2){$_.i=_Gz;for(var _H3=0,_H4=$g($_.row,$_.i);_H3<_H4;_H3++){$k[$j++]=0}if($_.i<$_.row.length-1){for(var _HA=0,_HB=$g($_.row,$_.i+1);_HA<_HB;_HA++){$k[$j++]=1}}}$as($a($m()));$_.row=$k[--$j];$k[$j-1]=Infinity;$F($_.row,function(){var _HG=$k[--$j];$k[$j++]=1-_HG});$_.sep=$a();$k[$j++]=Infinity;for(var _HK=19,_HJ=$_.row.length-13;_HK<=_HJ;_HK+=98){$k[$j++]=_HK}for(var _HN=68,_HM=$_.row.length-13;_HN<=_HM;_HN+=98){$k[$j++]=_HN}$_.finderpos=$a();var _HP=$_.finderpos;for(var _HQ=0,_HR=_HP.length;_HQ<_HR;_HQ++){var _HS=$g(_HP,_HQ);for(var _HU=_HS,_HT=_HS+14;_HU<=_HT;_HU+=1){$_.i=_HU;if($g($_.row,$_.i)==0){if($g($_.row,$_.i-1)==1){$k[$j++]=1}else{var _He=$g($_.sep,$_.i-1)==0?1:0;$k[$j++]=_He}}else{$k[$j++]=0}$p($_.sep,$_.i,$k[--$j])}}$P($_.sep,0,$a([0,0,0,0]));$P($_.sep,$_.row.length-4,$a([0,0,0,0]));if($_.segments%4==0&&$_.r%2==1){if($g($_.rows,$_.r).length!=$g($_.rows,0).length&&$_.finderpos.length%2==1){$k[$j++]=Infinity;$k[$j++]=0;$q($_.row);$_.row=$a();$k[$j++]=Infinity;$k[$j++]=0;$q($_.sep);$_.sep=$a()}else{for(var _I0=$_.row.length-1;_I0>=0;_I0-=1){$k[$j++]=$g($_.row,_I0)}$as($_.row);$j--;for(var _I5=$_.sep.length-1;_I5>=0;_I5-=1){$k[$j++]=$g($_.sep,_I5)}$as($_.sep);$j--}}$p($_.rows,$_.r,$_.row);$p($_.seps,$_.r,$_.sep)}$_.pixx=$g($_.rows,0).length;$k[$j++]=Infinity;for(var _II=0,_IJ=$_.pixx;_II<_IJ;_II++){$k[$j++]=0}var _IK=$a();$P(_IK,0,$g($_.rows,$_.numrows-1));$p($_.rows,$_.numrows-1,_IK);$k[$j++]=Infinity;for(var _IR=0,_IS=$_.pixx;_IR<_IS;_IR++){$k[$j++]=0}var _IT=$a();$P(_IT,0,$g($_.seps,$_.numrows-1));$p($_.seps,$_.numrows-1,_IT);$k[$j++]=Infinity;for(var _Ia=0,_Ib=~~($_.pixx/2)+1;_Ia<_Ib;_Ia++){$k[$j++]=0;$k[$j++]=1}$_.sep=$G($a(),0,$_.pixx);$P($_.sep,0,$a([0,0,0,0]));$P($_.sep,$_.pixx-4,$a([0,0,0,0]));$k[$j++]=Infinity;for(var _Im=0,_Il=$_.numrows-1;_Im<=_Il;_Im+=1){$_.r=_Im;if($_.r!=0){$q($g($_.seps,$_.r))}for(var _Is=0,_It=$_.barxmult;_Is<_It;_Is++){$q($g($_.rows,$_.r))}if($_.r!=$_.numrows-1){$q($g($_.seps,$_.r));$q($_.sep)}}$_.pixs=$a();var _JC=new Map([["ren","renmatrix"],["pixs",$_.pixs],["pixx",$_.pixx],["pixy",~~($_.pixs.length/$_.pixx)],["height",~~($_.pixs.length/$_.pixx)/72],["width",$_.pixx/72],["borderleft",0],["borderright",0],["bordertop",0],["borderbottom",0],["opt",$_.options]]);$k[$j++]=_JC;if(!$_.dontdraw){bwipp_renmatrix()}}$_=$__}function bwipp_databarexpandedstacked(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];$p($_.options,"dontdraw",true);$p($_.options,"format","expandedstacked");$k[$j++]="args";$k[$j++]=$_.barcode;$k[$j++]=$_.options;bwipp_databarexpanded();var _6=$k[--$j];$_[$k[--$j]]=_6;$p($_.args,"opt",$_.options);$k[$j++]=$_.args;if(!$_.dontdraw){bwipp_renmatrix()}$_=$__}function bwipp_gs1northamericancoupon(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.includetext=false;$_.coupontextfont="OCR-B";$_.coupontextsize=9;$_.coupontextxoffset=null;$_.coupontextyoffset=null;$_.parse=false;$_.dontlint=false;$_.lintreqs=true;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];$k[$j++]=$_.barcode;$k[$j++]="ai";bwipp_gs1process();$j--;$_.vals=$k[--$j];$_.ais=$k[--$j];if($_.ais.length!=1){$k[$j++]="bwipp.gs1northamericancouponBadAIStructure#11001";$k[$j++]="A GS1 North American Coupon should consist of a single AI (8110)";bwipp_raiseerror()}if($ne($g($_.ais,0),"8110")){$k[$j++]="bwipp.gs1northamericancouponBadAIStructure#11004";$k[$j++]="A GS1 North American Coupon should consist of a single AI (8110)";bwipp_raiseerror()}$_.val=$g($_.vals,0);$_.vli=$g($_.val,0)-48;if($_.vli<0||$_.vli>6){$k[$j++]="bwipp.gs1northamericancouponBadVLI#11011";$k[$j++]="The AI (8110) data should start with a Company Prefix length indicator in the range 0 to 6";bwipp_raiseerror()}$_.gcp=$G($_.val,1,$_.vli+6);$_.cod=$G($_.val,$_.vli+7,6);$_.coupontext=$s($_.gcp.length+7);$P($_.coupontext,0,$_.gcp);$P($_.coupontext,$_.gcp.length,"-");$P($_.coupontext,$_.gcp.length+1,$_.cod);$p($_.options,"dontdraw",true);$k[$j++]="args";$k[$j++]=$_.barcode;$k[$j++]=$_.options;bwipp_databarexpandedstacked();var _W=$k[--$j];$_[$k[--$j]]=_W;if($_.includetext){if($_.coupontextxoffset==null){$_.coupontextxoffset=0}if($_.coupontextyoffset==null){$_.coupontextyoffset=$g($_.args,"height")*72+3}var _e=$g($_.args,"txt")!==undefined;if(_e){$_.txt=$g($_.args,"txt");$_.newtxt=$a($_.txt.length+1);$P($_.newtxt,0,$_.txt);$p($_.newtxt,$_.newtxt.length-1,$a([$_.coupontext,$_.coupontextxoffset,$_.coupontextyoffset,$_.coupontextfont,$_.coupontextsize]));$p($_.args,"txt",$_.newtxt)}else{$p($_.args,"txt",$a([$a([$_.coupontext,$_.coupontextxoffset,$_.coupontextyoffset,$_.coupontextfont,$_.coupontextsize])]))}}$p($_.args,"opt",$_.options);$k[$j++]=$_.args;if(!$_.dontdraw){bwipp_renmatrix()}$_=$__}function bwipp_pharmacode(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.height=8*2.835/72;$_.nwidth=.5*2.835;$_.wwidth=1.5*2.835;$_.swidth=1*2.835;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.barcode.length<1||$_.barcode.length>6){$k[$j++]="bwipp.pharmacodeBadLength#11091";$k[$j++]="Pharmacode must be 1 to 6 digits";bwipp_raiseerror()}$F($_.barcode,function(){var _5=$k[--$j];if(_5<48||_5>57){$k[$j++]="bwipp.pharmacodeBadCharacter#11095";$k[$j++]="Pharmacode must contain only digits";bwipp_raiseerror()}});var _7=$i($_.barcode);if(_7<3||_7>131070){$k[$j++]="bwipp.pharmacodeBadValue#11099";$k[$j++]="Pharmacode value must be between 3 and 131070";bwipp_raiseerror()}$_.txt=$a($_.barcode.length);for(var _C=0,_B=$_.barcode.length-1;_C<=_B;_C+=1){$_.i=_C;$p($_.txt,$_.i,$a([$G($_.barcode,$_.i,1),0,0,"",0]))}$_.barcode=$R($s(17),$i($_.barcode)+1,2);$_.barcode=$G($_.barcode,1,$_.barcode.length-1);$_.barlen=$_.barcode.length;$_.sbs=$a($_.barlen*2);for(var _U=0,_T=$_.barlen-1;_U<=_T;_U+=1){$_.i=_U;$_.enc=$G($_.barcode,$_.i,1);if($eq($_.enc,"0")){$p($_.sbs,$_.i*2,$_.nwidth)}else{$p($_.sbs,$_.i*2,$_.wwidth)}$p($_.sbs,$_.i*2+1,$_.swidth)}$k[$j++]=Infinity;var _i=$_.sbs;$k[$j++]=Infinity;for(var _k=0,_l=~~(($_.sbs.length+1)/2);_k<_l;_k++){$k[$j++]=$_.height}var _n=$a();$k[$j++]=Infinity;for(var _p=0,_q=~~(($_.sbs.length+1)/2);_p<_q;_p++){$k[$j++]=0}var _r=$a();$k[$j++]="ren";$k[$j++]="renlinear";$k[$j++]="sbs";$k[$j++]=_i;$k[$j++]="bhs";$k[$j++]=_n;$k[$j++]="bbs";$k[$j++]=_r;$k[$j++]="txt";$k[$j++]=$_.txt;$k[$j++]="textxalign";$k[$j++]="center";$k[$j++]="opt";$k[$j++]=$_.options;var _u=$d();$k[$j++]=_u;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_pharmacode2(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.includetext=false;$_.height=4;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.barcode.length<1||$_.barcode.length>8){$k[$j++]="bwipp.pharmacode2BadLength#11180";$k[$j++]="Two-track Pharmacode must be 1 to 6 digits";bwipp_raiseerror()}$F($_.barcode,function(){var _5=$k[--$j];if(_5<48||_5>57){$k[$j++]="bwipp.pharmacode2badCharacter#11184";$k[$j++]="Two-track Pharmacode must contain only digits";bwipp_raiseerror()}});var _7=$i($_.barcode);if(_7<4||_7>64570080){$k[$j++]="bwipp.pharmacode2badValue#11188";$k[$j++]="Two-track Pharmacode value must be between 4 and 64570080";bwipp_raiseerror()}$_.txt=$a($_.barcode.length);for(var _C=0,_B=$_.barcode.length-1;_C<=_B;_C+=1){$_.i=_C;$p($_.txt,$_.i,$a([$G($_.barcode,$_.i,1),0,0,"",0]))}$_.encstr=$s(16);$_.sbs=$a(32);$_.bar=1/25.4*$_.height;$_.spc=1/25.4*72;$_.i=15;$_.val=$i($_.barcode);for(;;){if($_.val==0){break}var _P=$_.val%3;$_.val=~~($f($_.val-$g($a([3,1,2]),_P))/3);$p($_.encstr,$_.i,$g($a([2,0,1]),_P));$_.i=$_.i-1}$_.encstr=$G($_.encstr,$_.i+1,15-$_.i);$_.bhs=$a($_.encstr.length);$_.bbs=$a($_.encstr.length);for(var _i=0,_h=$_.encstr.length-1;_i<=_h;_i+=1){$_.i=_i;var _l=$g($_.encstr,$_.i);$p($_.bhs,$_.i,$_.bar*$g($a([1,1,2]),_l));$p($_.bbs,$_.i,$g($a([0,$_.bar,0]),_l))}$k[$j++]=Infinity;var _w=$_.bhs;var _x=$_.bbs;$k[$j++]=Infinity;for(var _z=0,_10=$_.encstr.length*2;_z<_10;_z++){$k[$j++]=$_.spc}var _12=$a();$k[$j++]="ren";$k[$j++]="renlinear";$k[$j++]="bhs";$k[$j++]=_w;$k[$j++]="bbs";$k[$j++]=_x;$k[$j++]="sbs";$k[$j++]=_12;$k[$j++]="txt";$k[$j++]=$_.txt;$k[$j++]="textxalign";$k[$j++]="center";$k[$j++]="textyoffset";$k[$j++]=4;$k[$j++]="opt";$k[$j++]=$_.options;var _15=$d();$k[$j++]=_15;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_code2of5(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.includecheck=false;$_.validatecheck=false;$_.includetext=false;$_.includecheckintext=false;$_.textfont="OCR-B";$_.textsize=10;$_.textyoffset=-8;$_.height=1;$_.version="industrial";$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.barcode.length==0){$k[$j++]="bwipp.code2of5emptyData#11287";$k[$j++]="The data must not be empty";bwipp_raiseerror()}$F($_.barcode,function(){var _4=$k[--$j];if(_4<48||_4>57){$k[$j++]="bwipp.code2of5badCharacter#11295";$k[$j++]="Code 25 must contain only digits";bwipp_raiseerror()}});$k[$j++]="barlen";$k[$j++]=$_.barcode.length;if($_.validatecheck){var _7=$k[--$j];$k[$j++]=_7-1}var _8=$k[--$j];$_[$k[--$j]]=_8;$_.checksum=0;for(var _C=0,_B=$_.barlen-1;_C<=_B;_C+=1){$_.i=_C;$k[$j++]="checksum";$k[$j++]=$_.checksum;$k[$j++]=$g($_.barcode,$_.i)-48;if($f($_.barlen-$_.i)%2!=0){var _J=$k[--$j];$k[$j++]=_J*3}var _K=$k[--$j];var _L=$k[--$j];$_[$k[--$j]]=$f(_L+_K)}$_.checksum=(10-$_.checksum%10)%10;if($_.validatecheck){if($g($_.barcode,$_.barlen)!=$_.checksum+48){$k[$j++]="bwipp.code2of5badCheckDigit#11309";$k[$j++]="Incorrect Code 25 check digit provided";bwipp_raiseerror()}$_.barcode=$G($_.barcode,0,$_.barlen);$_.includecheck=true}var _b=new Map([["industrial",$a(["1111313111","3111111131","1131111131","3131111111","1111311131","3111311111","1131311111","1111113131","3111113111","1131113111","313111","31113"])],["iata",$a(["1111313111","3111111131","1131111131","3131111111","1111311131","3111311111","1131311111","1111113131","3111113111","1131113111","1111","311"])],["matrix",$a(["113311","311131","131131","331111","113131","313111","133111","111331","311311","131311","311111","31111"])],["coop",$a(["331111","111331","113131","113311","131131","131311","133111","311131","311311","313111","3131","133"])],["datalogic",$a(["113311","311131","131131","331111","113131","313111","133111","111331","311311","131311","1111","311"])]]);$_.versions=_b;var _f=$g($_.versions,$_.version)!==undefined;if(!_f){$k[$j++]="bwipp.code2of5badVersion#11344";$k[$j++]="Unrecognised Code 25 version";bwipp_raiseerror()}$_.encs=$g($_.versions,$_.version);$_.cs=$g($_.encs,0).length;$k[$j++]="cw";$k[$j++]=0;$F($g($_.encs,0),function(){var _n=$k[--$j];var _o=$k[--$j];$k[$j++]=$f(_o+(_n-48))});var _p=$k[--$j];$_[$k[--$j]]=_p;$_.ss=$g($_.encs,10).length;$k[$j++]="sw";$k[$j++]=0;$F($g($_.encs,10),function(){var _v=$k[--$j];var _w=$k[--$j];$k[$j++]=$f(_w+(_v-48))});var _x=$k[--$j];$_[$k[--$j]]=_x;$_.es=$g($_.encs,11).length;$_.barchars="0123456789";$k[$j++]="sbs";$k[$j++]=$_.barlen;if($_.includecheck){var _14=$k[--$j];$k[$j++]=_14+1}var _19=$s($f($k[--$j]*$_.cs+$_.ss+$_.es));$_[$k[--$j]]=_19;$k[$j++]="txt";$k[$j++]=$_.barlen;if($_.includecheck){var _1D=$k[--$j];$k[$j++]=_1D+1}var _1F=$a($k[--$j]);$_[$k[--$j]]=_1F;$P($_.sbs,0,$g($_.encs,10));for(var _1M=0,_1L=$_.barlen-1;_1M<=_1L;_1M+=1){$_.i=_1M;$X($_.barchars,$G($_.barcode,$_.i,1));$j--;$_.indx=$k[--$j].length;$j-=2;$_.enc=$g($_.encs,$_.indx);$P($_.sbs,$_.i*$_.cs+$_.ss,$_.enc);$p($_.txt,$_.i,$a([$G($_.barcode,$_.i,1),$f($_.i*$_.cw+$_.sw),$_.textyoffset,$_.textfont,$_.textsize]))}if($_.includecheck){$P($_.sbs,$f($_.barlen*$_.cs+$_.ss),$g($_.encs,$_.checksum));$P($_.sbs,$f($_.barlen*$_.cs+$_.cs+$_.ss),$g($_.encs,11));if($_.includecheckintext){$p($_.txt,$_.barlen,$a([$G($_.barchars,$_.checksum,1),$f($_.barlen*$_.cw+$_.sw),$_.textyoffset,$_.textfont,$_.textsize]))}else{$p($_.txt,$_.barlen,$a([" ",$f($_.barlen*$_.cw+$_.sw),$_.textyoffset,$_.textfont,$_.textsize]))}}else{$P($_.sbs,$f($_.barlen*$_.cs+$_.ss),$g($_.encs,11))}$k[$j++]=Infinity;$k[$j++]=Infinity;$F($_.sbs,function(){var _2U=$k[--$j];$k[$j++]=_2U-48});var _2V=$a();$k[$j++]=Infinity;for(var _2X=0,_2Y=~~(($_.sbs.length+1)/2);_2X<_2Y;_2X++){$k[$j++]=$_.height}var _2a=$a();$k[$j++]=Infinity;for(var _2c=0,_2d=~~(($_.sbs.length+1)/2);_2c<_2d;_2c++){$k[$j++]=0}var _2e=$a();$k[$j++]="ren";$k[$j++]="renlinear";$k[$j++]="sbs";$k[$j++]=_2V;$k[$j++]="bhs";$k[$j++]=_2a;$k[$j++]="bbs";$k[$j++]=_2e;if($_.includetext){$k[$j++]="txt";$k[$j++]=$_.txt}$k[$j++]="opt";$k[$j++]=$_.options;var _2i=$d();$k[$j++]=_2i;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_industrial2of5(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];$p($_.options,"dontdraw",true);$p($_.options,"version","industrial");$k[$j++]="args";$k[$j++]=$_.barcode;$k[$j++]=$_.options;bwipp_code2of5();var _6=$k[--$j];$_[$k[--$j]]=_6;$p($_.args,"opt",$_.options);$k[$j++]=$_.args;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_iata2of5(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];$p($_.options,"dontdraw",true);$p($_.options,"version","iata");$k[$j++]="args";$k[$j++]=$_.barcode;$k[$j++]=$_.options;bwipp_code2of5();var _6=$k[--$j];$_[$k[--$j]]=_6;$p($_.args,"opt",$_.options);$k[$j++]=$_.args;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_matrix2of5(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];$p($_.options,"dontdraw",true);$p($_.options,"version","matrix");$k[$j++]="args";$k[$j++]=$_.barcode;$k[$j++]=$_.options;bwipp_code2of5();var _6=$k[--$j];$_[$k[--$j]]=_6;$p($_.args,"opt",$_.options);$k[$j++]=$_.args;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_coop2of5(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];$p($_.options,"dontdraw",true);$p($_.options,"version","coop");$k[$j++]="args";$k[$j++]=$_.barcode;$k[$j++]=$_.options;bwipp_code2of5();var _6=$k[--$j];$_[$k[--$j]]=_6;$p($_.args,"opt",$_.options);$k[$j++]=$_.args;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_datalogic2of5(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];$p($_.options,"dontdraw",true);$p($_.options,"version","datalogic");$k[$j++]="args";$k[$j++]=$_.barcode;$k[$j++]=$_.options;bwipp_code2of5();var _6=$k[--$j];$_[$k[--$j]]=_6;$p($_.args,"opt",$_.options);$k[$j++]=$_.args;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_code11(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.includecheck=false;$_.validatecheck=false;$_.includetext=false;$_.includecheckintext=false;$_.textfont="OCR-B";$_.textsize=10;$_.textyoffset=-8;$_.height=1;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.barcode.length==0){$k[$j++]="bwipp.code11emptyData#11692";$k[$j++]="The data must not be empty";bwipp_raiseerror()}$_.encs=$a(["111131","311131","131131","331111","113131","313111","133111","111331","311311","311111","113111","113311"]);$_.barchars="0123456789-";$_.charvals=new Map;for(var _4=0;_4<=10;_4+=1){$p($_.charvals,$G($_.barchars,_4,1),_4)}for(var _B=0,_A=$_.barcode.length-1;_B<=_A;_B+=1){var _F=$g($_.charvals,$G($_.barcode,_B,1))!==undefined;if(!_F){$k[$j++]="bwipp.code11badCharacter#11714";$k[$j++]="Code 11 must contain only digits and dashes";bwipp_raiseerror()}}$_.barlen=$_.barcode.length;if($_.validatecheck){if($_.barlen==11){$k[$j++]="bwipp.code11badLength#11721";$k[$j++]="Code 11 cannot be 11 characters using check digits";bwipp_raiseerror()}var _L=$_.barlen<=10?1:2;$_.barlen=$_.barlen-_L}$k[$j++]="numchecks";if($_.includecheck||$_.validatecheck){var _P=$_.barlen>=10?2:1;$k[$j++]=_P}else{$k[$j++]=0}var _Q=$k[--$j];$_[$k[--$j]]=_Q;$_.checksum1=0;$_.checksum2=0;for(var _U=0,_T=$_.barlen-1;_U<=_T;_U+=1){$_.i=_U;$_.indx=$g($_.charvals,$G($_.barcode,$_.i,1));$_.checksum1=$f($_.checksum1+(($_.barlen-$_.i-1)%10+1)*$_.indx);$_.checksum2=$f($_.checksum2+(($_.barlen-$_.i)%9+1)*$_.indx)}$_.checksum1=$_.checksum1%11;$_.checksum2=$f($_.checksum2+$_.checksum1)%11;if($_.validatecheck){if($_.numchecks==1){var _r=$_.checksum1;if($g($_.barcode,$_.barlen)!=$g($_.barchars,_r)){$k[$j++]="bwipp.code11badCheckDigit#11739";$k[$j++]="Incorrect Code 11 check digit provided";bwipp_raiseerror()}}else{if($g($_.barcode,$_.barlen)!=$g($_.barchars,$_.checksum1)||$g($_.barcode,$_.barlen+1)!=$g($_.barchars,$_.checksum2)){$k[$j++]="bwipp.code11badCheckDigits#11744";$k[$j++]="Incorrect Code 11 check digits provided";bwipp_raiseerror()}}$_.barcode=$G($_.barcode,0,$_.barlen);$_.includecheck=true}$_.sbs=$s($f($_.barlen+$_.numchecks)*6+12);$_.txt=$a($f($_.barlen+$_.numchecks));$P($_.sbs,0,$g($_.encs,11));$_.xpos=8;for(var _1J=0,_1I=$_.barlen-1;_1J<=_1I;_1J+=1){$_.i=_1J;$_.indx=$g($_.charvals,$G($_.barcode,$_.i,1));$_.enc=$g($_.encs,$_.indx);$P($_.sbs,$_.i*6+6,$_.enc);$p($_.txt,$_.i,$a([$G($_.barcode,$_.i,1),$_.xpos,$_.textyoffset,$_.textfont,$_.textsize]));for(var _1f=0;_1f<=5;_1f+=1){$_.xpos=$f($g($_.enc,_1f)-48+$_.xpos)}}if($_.includecheck){if($_.barlen>=10){$P($_.sbs,$_.barlen*6+6,$g($_.encs,$_.checksum1));$P($_.sbs,$_.barlen*6+12,$g($_.encs,$_.checksum2));if($_.includecheckintext){$p($_.txt,$_.barlen,$a([$G($_.barchars,$_.checksum1,1),$_.xpos,$_.textyoffset,$_.textfont,$_.textsize]));$_.enc=$g($_.encs,$_.checksum1);for(var _29=0;_29<=5;_29+=1){$_.xpos=$f($g($_.enc,_29)-48+$_.xpos)}$p($_.txt,$_.barlen+1,$a([$G($_.barchars,$_.checksum2,1),$_.xpos,$_.textyoffset,$_.textfont,$_.textsize]))}else{$p($_.txt,$_.barlen,$a(["",$_.xpos,$_.textyoffset,$_.textfont,$_.textsize]));$p($_.txt,$_.barlen+1,$a(["",$_.xpos,$_.textyoffset,$_.textfont,$_.textsize]))}$P($_.sbs,$_.barlen*6+18,$g($_.encs,11))}else{$P($_.sbs,$_.barlen*6+6,$g($_.encs,$_.checksum1));if($_.includecheckintext){$p($_.txt,$_.barlen,$a([$G($_.barchars,$_.checksum1,1),$_.xpos,$_.textyoffset,$_.textfont,$_.textsize]))}else{$p($_.txt,$_.barlen,$a(["",$_.xpos,$_.textyoffset,$_.textfont,$_.textsize]))}$P($_.sbs,$_.barlen*6+12,$g($_.encs,11))}}else{$P($_.sbs,$_.barlen*6+6,$g($_.encs,11))}$k[$j++]=Infinity;$k[$j++]=Infinity;var _3A=$_.sbs;for(var _3B=0,_3C=_3A.length;_3B<_3C;_3B++){$k[$j++]=$g(_3A,_3B)-48}var _3E=$a();$k[$j++]=Infinity;for(var _3G=0,_3H=~~(($_.sbs.length+1)/2);_3G<_3H;_3G++){$k[$j++]=$_.height}var _3J=$a();$k[$j++]=Infinity;for(var _3L=0,_3M=~~(($_.sbs.length+1)/2);_3L<_3M;_3L++){$k[$j++]=0}var _3N=$a();$k[$j++]="ren";$k[$j++]="renlinear";$k[$j++]="sbs";$k[$j++]=_3E;$k[$j++]="bhs";$k[$j++]=_3J;$k[$j++]="bbs";$k[$j++]=_3N;if($_.includetext){$k[$j++]="txt";$k[$j++]=$_.txt}$k[$j++]="opt";$k[$j++]=$_.options;var _3R=$d();$k[$j++]=_3R;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_bc412(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.includecheck=false;$_.validatecheck=false;$_.includetext=false;$_.includecheckintext=false;$_.includestartstop=false;$_.semi=false;$_.textfont="OCR-B";$_.textsize=10;$_.textyoffset=-8;$_.height=1;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.barcode.length==0){$k[$j++]="bwipp.bc412emptyData#11864";$k[$j++]="The data must not be empty";bwipp_raiseerror()}if($_.semi){$_.includestartstop=true}$_.barchars="0R9GLVHA8EZ4NTS1J2Q6C7DYKBUIX3FWP5M";$_.charvals=new Map;for(var _4=0;_4<=34;_4+=1){$p($_.charvals,$G($_.barchars,_4,1),_4)}for(var _B=0,_A=$_.barcode.length-1;_B<=_A;_B+=1){var _F=$g($_.charvals,$G($_.barcode,_B,1))!==undefined;if(!_F){$k[$j++]="bwipp.bc412badCharacter#11884";$k[$j++]="BC412 must contain only digits and capital letters except O";bwipp_raiseerror()}}if($_.semi){if($_.validatecheck){if($_.barcode.length<8||$_.barcode.length>19){$k[$j++]="bwipp.bc412semivalidateBadLength#11892";$k[$j++]="BC412 semi with check digit must be 8 to 19 characters long";bwipp_raiseerror()}}else{if($_.barcode.length<7||$_.barcode.length>18){$k[$j++]="bwipp.bc412semiBadLength#11896";$k[$j++]="BC412 semi must be 7 to 18 characters long";bwipp_raiseerror()}}$_.barlen=$_.barcode.length;if(!$_.validatecheck){$_.barlen=$_.barlen+1;$_.sbarcode=$s($_.barlen);$p($_.sbarcode,0,$g($_.barcode,0));$p($_.sbarcode,1,48);$P($_.sbarcode,2,$G($_.barcode,1,$_.barlen-2));$_.barcode=$_.sbarcode}$_.sumodd=0;$_.sumeven=0;for(var _c=0,_b=$_.barlen-1;_c<=_b;_c+=1){$_.i=_c;$k[$j++]=$g($_.charvals,$G($_.barcode,$_.i,1));if($_.i%2==0){$_.sumodd=$f($k[--$j]+$_.sumodd)}else{$_.sumeven=$f($k[--$j]+$_.sumeven)}}$_.checksum=$f($_.sumodd%35+$_.sumeven%35*2)%35;if($_.validatecheck){if($_.checksum!=0){$k[$j++]="bwipp.bc412semiBadCheckDigit#11922";$k[$j++]="Incorrect BC412 semi check digit provided";bwipp_raiseerror()}}else{$_.checksum=$_.checksum*17%35;$p($_.barcode,1,$g($_.barchars,$_.checksum))}}else{$k[$j++]="barlen";$k[$j++]=$_.barcode.length;if($_.validatecheck){var _y=$k[--$j];$k[$j++]=_y-1}var _z=$k[--$j];$_[$k[--$j]]=_z;$_.checksum=0;for(var _13=0,_12=$_.barlen-1;_13<=_12;_13+=1){$_.checksum=$f($g($_.charvals,$G($_.barcode,_13,1))+$_.checksum)}$_.checksum=$_.checksum%35;if($_.validatecheck){if($g($_.barcode,$_.barlen)!=$g($_.barchars,$_.checksum)){$k[$j++]="bwipp.bc412badCheckDigit#11939";$k[$j++]="Incorrect BC412 check digit provided";bwipp_raiseerror()}$_.barcode=$G($_.barcode,0,$_.barlen);$_.includecheck=true}}$_.encs=$a(["11111115","13111212","11131113","12111213","12121311","13131111","12111312","11131212","11121411","11151111","15111111","11111511","12131211","13121112","13111311","11111214","12121113","11111313","13111113","11121213","11141112","11121312","11141211","14121111","12121212","11131311","13121211","12111411","14111211","11111412","12111114","14111112","12141111","11121114","12131112","12","111"]);$_.sbs=$s(($_.barlen+1)*8+5);if($_.includecheck){$_.txt=$a($_.barlen+1)}else{$_.txt=$a($_.barlen)}if($_.includestartstop){$P($_.sbs,0,$g($_.encs,35));$_.pos=2;$_.txtpos=3}else{$_.pos=0;$_.txtpos=0}for(var _1Z=0,_1Y=$_.barlen-1;_1Z<=_1Y;_1Z+=1){$_.i=_1Z;$_.indx=$g($_.charvals,$G($_.barcode,$_.i,1));$P($_.sbs,$_.pos,$g($_.encs,$_.indx));$p($_.txt,$_.i,$a([$G($_.barcode,$_.i,1),$_.i*12+$_.txtpos,$_.textyoffset,$_.textfont,$_.textsize]));$_.pos=$_.pos+8}if($_.includecheck){$P($_.sbs,$_.pos,$g($_.encs,$_.checksum));if($_.includecheckintext){$p($_.txt,$_.barlen,$a([$G($_.barchars,$_.checksum,1),$_.barlen*12+$_.txtpos,$_.textyoffset,$_.textfont,$_.textsize]))}else{$p($_.txt,$_.barlen,$a(["",$_.barlen*12+$_.txtpos,$_.textyoffset,$_.textfont,$_.textsize]))}$_.pos=$_.pos+8}if($_.includestartstop){$P($_.sbs,$_.pos,$g($_.encs,36));$_.pos=$_.pos+3}$_.sbs=$G($_.sbs,0,$_.pos);$k[$j++]=Infinity;$k[$j++]=Infinity;var _2W=$_.sbs;for(var _2X=0,_2Y=_2W.length;_2X<_2Y;_2X++){$k[$j++]=$g(_2W,_2X)-48}var _2a=$a();$k[$j++]=Infinity;for(var _2c=0,_2d=~~(($_.sbs.length+1)/2);_2c<_2d;_2c++){$k[$j++]=$_.height}var _2f=$a();$k[$j++]=Infinity;for(var _2h=0,_2i=~~(($_.sbs.length+1)/2);_2h<_2i;_2h++){$k[$j++]=0}var _2j=$a();$k[$j++]="ren";$k[$j++]="renlinear";$k[$j++]="sbs";$k[$j++]=_2a;$k[$j++]="bhs";$k[$j++]=_2f;$k[$j++]="bbs";$k[$j++]=_2j;if($_.includetext){$k[$j++]="txt";$k[$j++]=$_.txt}$k[$j++]="opt";$k[$j++]=$_.options;var _2n=$d();$k[$j++]=_2n;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_rationalizedCodabar(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.altstartstop=false;$_.includecheck=false;$_.validatecheck=false;$_.includetext=false;$_.includecheckintext=false;$_.textfont="OCR-B";$_.textsize=10;$_.textyoffset=-8;$_.height=1;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.barcode.length<2||$_.barcode.length<3&&$_.validatecheck){$k[$j++]="bwipp.rationalizedCodabarBadLength#12067";$k[$j++]="Codabar must be at least 2 characters in length excluding any check digit";bwipp_raiseerror()}$_.encs=$a(["11111331","11113311","11131131","33111111","11311311","31111311","13111131","13113111","13311111","31131111","11133111","11331111","31113131","31311131","31313111","11313131","11331311","13131131","11131331","11133311"]);$_.barcharsnormal="0123456789-$:/.+ABCD";$_.barcharsalt="0123456789-$:/.+TN*E";var _8=$_.altstartstop?$_.barcharsalt:$_.barcharsnormal;$_.barchars=_8;$_.charvals=new Map;for(var _9=0;_9<=19;_9+=1){$p($_.charvals,$G($_.barchars,_9,1),_9)}$_.bodyvals=new Map;for(var _D=0;_D<=15;_D+=1){$p($_.bodyvals,$G($_.barchars,_D,1),_D)}$_.ssvals=new Map;for(var _H=16;_H<=19;_H+=1){$p($_.ssvals,$G($_.barchars,_H,1),_H)}var _O=$g($_.ssvals,$G($_.barcode,0,1))!==undefined;var _T=$g($_.ssvals,$G($_.barcode,$_.barcode.length-1,1))!==undefined;if(!_O||!_T){if($_.altstartstop){$k[$j++]="bwipp.rationalizedCodabarBadAltStartStop#12099";$k[$j++]="Codabar start and stop characters must be one of E N T or *";bwipp_raiseerror()}else{$k[$j++]="bwipp.rationalizedCodabarBadStartStop#12101";$k[$j++]="Codabar start and stop characters must be one of A B C or D";bwipp_raiseerror()}}for(var _X=1,_W=$_.barcode.length-2;_X<=_W;_X+=1){var _b=$g($_.bodyvals,$G($_.barcode,_X,1))!==undefined;if(!_b){$k[$j++]="bwipp.rationalizedCodabarBadCharacter#12106";$k[$j++]="Codabar body must contain only digits and symbols - $ : / . +";bwipp_raiseerror()}}$k[$j++]="barlen";$k[$j++]=$_.barcode.length;if($_.validatecheck){var _e=$k[--$j];$k[$j++]=_e-1}var _f=$k[--$j];$_[$k[--$j]]=_f;$_.checksum=0;for(var _j=0,_i=$_.barlen-2;_j<=_i;_j+=1){$_.checksum=$f($g($_.charvals,$G($_.barcode,_j,1))+$_.checksum)}var _r=$G($_.barcode,$_.barcode.length-1,1);$_.checksum=$f($g($_.charvals,_r)+$_.checksum);$_.checksum=(16-$_.checksum%16)%16;if($_.validatecheck){if($g($_.barcode,$_.barlen-1)!=$g($_.barchars,$_.checksum)){$k[$j++]="bwipp.rationalizedCodabarBadCheckDigit#12122";$k[$j++]="Incorrect Codabar check digit provided";bwipp_raiseerror()}var _14=$s($_.barlen);$P(_14,0,$G($_.barcode,0,$_.barlen-1));$P(_14,$_.barlen-1,$G($_.barcode,$_.barlen,1));$_.barcode=_14;$_.includecheck=true}$k[$j++]="sbs";$k[$j++]=$_.barlen;if($_.includecheck){var _1E=$k[--$j];$k[$j++]=_1E+1}var _1G=$s($k[--$j]*8);$_[$k[--$j]]=_1G;$k[$j++]="txt";$k[$j++]=$_.barlen;if($_.includecheck){var _1K=$k[--$j];$k[$j++]=_1K+1}var _1M=$a($k[--$j]);$_[$k[--$j]]=_1M;$_.xpos=0;for(var _1Q=0,_1P=$_.barlen-2;_1Q<=_1P;_1Q+=1){$_.i=_1Q;$_.indx=$g($_.charvals,$G($_.barcode,$_.i,1));$_.enc=$g($_.encs,$_.indx);$P($_.sbs,$_.i*8,$_.enc);$p($_.txt,$_.i,$a([$G($_.barcode,$_.i,1),$_.xpos,$_.textyoffset,$_.textfont,$_.textsize]));for(var _1m=0;_1m<=7;_1m+=1){$_.xpos=$f($g($_.enc,_1m)-48+$_.xpos)}}if($_.includecheck){$P($_.sbs,$_.barlen*8-8,$g($_.encs,$_.checksum));if($_.includecheckintext){$p($_.txt,$_.barlen-1,$a([$G($_.barchars,$_.checksum,1),$_.xpos,$_.textyoffset,$_.textfont,$_.textsize]))}else{$p($_.txt,$_.barlen-1,$a([" ",$_.xpos,$_.textyoffset,$_.textfont,$_.textsize]))}for(var _2E=0;_2E<=7;_2E+=1){$_.xpos=$f($g($g($_.encs,$_.checksum),_2E)-48+$_.xpos)}$_.indx=$g($_.charvals,$G($_.barcode,$_.barlen-1,1));$_.enc=$g($_.encs,$_.indx);$P($_.sbs,$_.barlen*8,$_.enc);$p($_.txt,$_.barlen,$a([$G($_.barcode,$_.barlen-1,1),$_.xpos,$_.textyoffset,$_.textfont,$_.textsize]))}else{$_.indx=$g($_.charvals,$G($_.barcode,$_.barlen-1,1));$_.enc=$g($_.encs,$_.indx);$P($_.sbs,$_.barlen*8-8,$_.enc);$p($_.txt,$_.barlen-1,$a([$G($_.barcode,$_.barlen-1,1),$_.xpos,$_.textyoffset,$_.textfont,$_.textsize]))}$k[$j++]=Infinity;$k[$j++]=Infinity;$F($_.sbs,function(){var _31=$k[--$j];$k[$j++]=_31-48});var _32=$a();$k[$j++]=Infinity;for(var _34=0,_35=~~(($_.sbs.length+1)/2);_34<_35;_34++){$k[$j++]=$_.height}var _37=$a();$k[$j++]=Infinity;for(var _39=0,_3A=~~(($_.sbs.length+1)/2);_39<_3A;_39++){$k[$j++]=0}var _3B=$a();$k[$j++]="ren";$k[$j++]="renlinear";$k[$j++]="sbs";$k[$j++]=_32;$k[$j++]="bhs";$k[$j++]=_37;$k[$j++]="bbs";$k[$j++]=_3B;if($_.includetext){$k[$j++]="txt";$k[$j++]=$_.txt}$k[$j++]="opt";$k[$j++]=$_.options;var _3F=$d();$k[$j++]=_3F;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_onecode(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.height=.15;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];$_.barlen=$_.barcode.length;$F($_.barcode,function(){var _4=$k[--$j];if(_4<48||_4>57){$k[$j++]="bwipp.onecodeBadCharacter#12232";$k[$j++]="The data must contain only digits";bwipp_raiseerror()}});if($_.barlen!=20&&$_.barlen!=25&&$_.barlen!=29&&$_.barlen!=31){$k[$j++]="bwipp.onecodeInvalidLength#12237";$k[$j++]="The data must be 20, 25, 29 or 31 digits";bwipp_raiseerror()}$k[$j++]=Infinity;var _B=$eq($G($_.barcode,5,1),"9")?14:11;$k[$j++]=2;$k[$j++]=2;$k[$j++]=5;$k[$j++]=5;$k[$j++]=_B;$k[$j++]=_B;$k[$j++]=20;$k[$j++]=20;$k[$j++]=25;$k[$j++]=25;$k[$j++]=29;$k[$j++]=29;$_.txtdict=$d();$_.txt=$a($_.barlen+6);$_.spacecnt=0;for(var _H=0,_G=$_.barlen-1;_H<=_G;_H+=1){$_.i=_H;var _K=$g($_.txtdict,$_.i)!==undefined;if(_K){$p($_.txt,$_.i+$_.spacecnt,$a([" ",0,0,"",0]));$_.spacecnt=$_.spacecnt+1}$p($_.txt,$_.i+$_.spacecnt,$a([$G($_.barcode,$_.i,1),0,0,"",0]))}$_.txt=$G($_.txt,0,$_.barcode.length+$_.spacecnt);$_.normalize=function(){$_.base=$k[--$j];$_.num=$k[--$j];for(var _e=$_.num.length-1;_e>=1;_e-=1){$_.i=_e;var _f=$_.num;var _g=$_.i;$p(_f,_g-1,$f($g(_f,_g-1)+~~($g($_.num,$_.i)/$_.base)));$p($_.num,$_.i,$g($_.num,$_.i)%$_.base)}for(;;){if($lt($g($_.num,0),$_.base)){break}$k[$j++]=Infinity;$k[$j++]=0;$q($_.num);$_.num=$a();$p($_.num,0,$f($g($_.num,0)+~~($g($_.num,1)/$_.base)));$p($_.num,1,$g($_.num,1)%$_.base)}$k[$j++]=Infinity;$_.i=true;var _17=$_.num;for(var _18=0,_19=_17.length;_18<_19;_18++){var _1A=$g(_17,_18);$k[$j++]=_1A;if(_1A==0&&$_.i){$j--}else{$_.i=false}}$_.num=$a();if($_.num.length==0){$_.num=$a([0])}$k[$j++]=$_.num};$_.bigadd=function(){var _1G=$k[--$j];var _1H=$k[--$j];$_.offset=$abs(_1G.length-_1H.length);if(_1G.length<_1H.length){var _=_1G;_1G=_1H;_1H=_}$_.a=_1G;$_.b=_1H;for(var _1K=0,_1J=$_.b.length-1;_1K<=_1J;_1K+=1){var _1L=$_.a;var _1M=$_.offset;$p(_1L,_1K+_1M,$f($g(_1L,_1K+_1M)+$g($_.b,_1K)))}$k[$j++]=$_.a};var _1V=new Map([[20,$a([0])],[25,$a([1])],[29,$a([1,0,0,0,0,1])],[31,$a([1,0,0,0,1,0,0,0,0,1])]]);$_.startvals=_1V;$k[$j++]="binval";$k[$j++]=$g($_.startvals,$_.barlen);$k[$j++]=Infinity;var _1c=$G($_.barcode,20,$_.barlen-20);for(var _1d=0,_1e=_1c.length;_1d<_1e;_1d++){$k[$j++]=$g(_1c,_1d)-48}var _1g=$a();$k[$j++]=_1g;$_.bigadd();var _1h=$k[--$j];$_[$k[--$j]]=_1h;$k[$j++]=Infinity;$q($_.binval);$k[$j++]=$g($_.barcode,0)-48;$_.binval=$a();$k[$j++]=Infinity;var _1n=$_.binval;for(var _1o=0,_1p=_1n.length;_1o<_1p;_1o++){$k[$j++]=$g(_1n,_1o)*5}var _1r=$a();$k[$j++]="binval";$k[$j++]=_1r;$k[$j++]=$a([$g($_.barcode,1)-48]);$_.bigadd();$k[$j++]=10;$_.normalize();var _1v=$k[--$j];$_[$k[--$j]]=_1v;$k[$j++]=Infinity;$q($_.binval);var _1z=$G($_.barcode,2,18);for(var _20=0,_21=_1z.length;_20<_21;_20++){$k[$j++]=$g(_1z,_20)-48}$_.binval=$a();$_.bytes=$a(13);var _25=$_.binval;$_.bintmp=$A($a(_25.length),_25);for(var _28=12;_28>=0;_28-=1){$_.i=_28;for(var _2B=0,_2A=$_.bintmp.length-2;_2B<=_2A;_2B+=1){$_.j=_2B;var _2C=$_.bintmp;var _2D=$_.j;$p(_2C,_2D+1,$f($g(_2C,_2D+1)+$g($_.bintmp,$_.j)%256*10));$p($_.bintmp,$_.j,~~($g($_.bintmp,$_.j)/256))}$p($_.bytes,$_.i,$g($_.bintmp,$_.bintmp.length-1)%256);var _2S=$_.bintmp;var _2T=$_.bintmp;$p(_2S,_2T.length-1,~~($g(_2S,_2T.length-1)/256))}$_.fcs=2047;$_.dat=$g($_.bytes,0)<<5;for(var _2X=0;_2X<6;_2X++){if((($_.fcs^$_.dat)&1024)!=0){$_.fcs=$_.fcs<<1^3893}else{$_.fcs=$_.fcs<<1}$_.fcs=$_.fcs&2047;$_.dat=$_.dat<<1}for(var _2e=1;_2e<=12;_2e+=1){$_.dat=$g($_.bytes,_2e)<<3;for(var _2h=0;_2h<8;_2h++){if((($_.fcs^$_.dat)&1024)!=0){$_.fcs=$_.fcs<<1^3893}else{$_.fcs=$_.fcs<<1}$_.fcs=$_.fcs&2047;$_.dat=$_.dat<<1}}$_.codewords=$a(10);for(var _2p=9;_2p>=0;_2p-=1){$_.i=_2p;var _2r=$_.i==9?636:1365;$_.b=_2r;for(var _2u=0,_2t=$_.binval.length-2;_2u<=_2t;_2u+=1){$_.j=_2u;var _2v=$_.binval;var _2w=$_.j;$p(_2v,_2w+1,$f($g(_2v,_2w+1)+$g($_.binval,$_.j)%$_.b*10));$p($_.binval,$_.j,~~($g($_.binval,$_.j)/$_.b))}$p($_.codewords,$_.i,$g($_.binval,$_.binval.length-1)%$_.b);var _3E=$_.binval;var _3F=$_.binval;$p(_3E,_3F.length-1,~~($g(_3E,_3F.length-1)/$_.b))}$p($_.codewords,9,$g($_.codewords,9)*2);if(($_.fcs&1024)!=0){$p($_.codewords,0,$g($_.codewords,0)+659)}$_.tab513=$a([31,7936,47,7808,55,7552,59,7040,61,6016,62,3968,79,7744,87,7488,91,6976,93,5952,94,3904,103,7360,107,6848,109,5824,110,3776,115,6592,117,5568,118,3520,121,5056,122,3008,124,1984,143,7712,151,7456,155,6944,157,5920,158,3872,167,7328,171,6816,173,5792,174,3744,179,6560,181,5536,182,3488,185,5024,186,2976,188,1952,199,7264,203,6752,205,5728,206,3680,211,6496,213,5472,214,3424,217,4960,218,2912,220,1888,227,6368,229,5344,230,3296,233,4832,234,2784,236,1760,241,4576,242,2528,244,1504,248,992,271,7696,279,7440,283,6928,285,5904,286,3856,295,7312,299,6800,301,5776,302,3728,307,6544,309,5520,310,3472,313,5008,314,2960,316,1936,327,7248,331,6736,333,5712,334,3664,339,6480,341,5456,342,3408,345,4944,346,2896,348,1872,355,6352,357,5328,358,3280,361,4816,362,2768,364,1744,369,4560,370,2512,372,1488,376,976,391,7216,395,6704,397,5680,398,3632,403,6448,405,5424,406,3376,409,4912,410,2864,412,1840,419,6320,421,5296,422,3248,425,4784,426,2736,428,1712,433,4528,434,2480,436,1456,440,944,451,6256,453,5232,454,3184,457,4720,458,2672,460,1648,465,4464,466,2416,468,1392,472,880,481,4336,482,2288,484,1264,488,752,527,7688,535,7432,539,6920,541,5896,542,3848,551,7304,555,6792,557,5768,558,3720,563,6536,565,5512,566,3464,569,5e3,570,2952,572,1928,583,7240,587,6728,589,5704,590,3656,595,6472,597,5448,598,3400,601,4936,602,2888,604,1864,611,6344,613,5320,614,3272,617,4808,618,2760,620,1736,625,4552,626,2504,628,1480,632,968,647,7208,651,6696,653,5672,654,3624,659,6440,661,5416,662,3368,665,4904,666,2856,668,1832,675,6312,677,5288,678,3240,681,4776,682,2728,684,1704,689,4520,690,2472,692,1448,696,936,707,6248,709,5224,710,3176,713,4712,714,2664,716,1640,721,4456,722,2408,724,1384,728,872,737,4328,738,2280,740,1256,775,7192,779,6680,781,5656,782,3608,787,6424,789,5400,790,3352,793,4888,794,2840,796,1816,803,6296,805,5272,806,3224,809,4760,810,2712,812,1688,817,4504,818,2456,820,1432,824,920,835,6232,837,5208,838,3160,841,4696,842,2648,844,1624,849,4440,850,2392,852,1368,865,4312,866,2264,868,1240,899,6200,901,5176,902,3128,905,4664,906,2616,908,1592,913,4408,914,2360,916,1336,929,4280,930,2232,932,1208,961,4216,962,2168,964,1144,1039,7684,1047,7428,1051,6916,1053,5892,1054,3844,1063,7300,1067,6788,1069,5764,1070,3716,1075,6532,1077,5508,1078,3460,1081,4996,1082,2948,1084,1924,1095,7236,1099,6724,1101,5700,1102,3652,1107,6468,1109,5444,1110,3396,1113,4932,1114,2884,1116,1860,1123,6340,1125,5316,1126,3268,1129,4804,1130,2756,1132,1732,1137,4548,1138,2500,1140,1476,1159,7204,1163,6692,1165,5668,1166,3620,1171,6436,1173,5412,1174,3364,1177,4900,1178,2852,1180,1828,1187,6308,1189,5284,1190,3236,1193,4772,1194,2724,1196,1700,1201,4516,1202,2468,1204,1444,1219,6244,1221,5220,1222,3172,1225,4708,1226,2660,1228,1636,1233,4452,1234,2404,1236,1380,1249,4324,1250,2276,1287,7188,1291,6676,1293,5652,1294,3604,1299,6420,1301,5396,1302,3348,1305,4884,1306,2836,1308,1812,1315,6292,1317,5268,1318,3220,1321,4756,1322,2708,1324,1684,1329,4500,1330,2452,1332,1428,1347,6228,1349,5204,1350,3156,1353,4692,1354,2644,1356,1620,1361,4436,1362,2388,1377,4308,1378,2260,1411,6196,1413,5172,1414,3124,1417,4660,1418,2612,1420,1588,1425,4404,1426,2356,1441,4276,1442,2228,1473,4212,1474,2164,1543,7180,1547,6668,1549,5644,1550,3596,1555,6412,1557,5388,1558,3340,1561,4876,1562,2828,1564,1804,1571,6284,1573,5260,1574,3212,1577,4748,1578,2700,1580,1676,1585,4492,1586,2444,1603,6220,1605,5196,1606,3148,1609,4684,1610,2636,1617,4428,1618,2380,1633,4300,1634,2252,1667,6188,1669,5164,1670,3116,1673,4652,1674,2604,1681,4396,1682,2348,1697,4268,1698,2220,1729,4204,1730,2156,1795,6172,1797,5148,1798,3100,1801,4636,1802,2588,1809,4380,1810,2332,1825,4252,1826,2204,1857,4188,1858,2140,1921,4156,1922,2108,2063,7682,2071,7426,2075,6914,2077,5890,2078,3842,2087,7298,2091,6786,2093,5762,2094,3714,2099,6530,2101,5506,2102,3458,2105,4994,2106,2946,2119,7234,2123,6722,2125,5698,2126,3650,2131,6466,2133,5442,2134,3394,2137,4930,2138,2882,2147,6338,2149,5314,2150,3266,2153,4802,2154,2754,2161,4546,2162,2498,2183,7202,2187,6690,2189,5666,2190,3618,2195,6434,2197,5410,2198,3362,2201,4898,2202,2850,2211,6306,2213,5282,2214,3234,2217,4770,2218,2722,2225,4514,2226,2466,2243,6242,2245,5218,2246,3170,2249,4706,2250,2658,2257,4450,2258,2402,2273,4322,2311,7186,2315,6674,2317,5650,2318,3602,2323,6418,2325,5394,2326,3346,2329,4882,2330,2834,2339,6290,2341,5266,2342,3218,2345,4754,2346,2706,2353,4498,2354,2450,2371,6226,2373,5202,2374,3154,2377,4690,2378,2642,2385,4434,2401,4306,2435,6194,2437,5170,2438,3122,2441,4658,2442,2610,2449,4402,2465,4274,2497,4210,2567,7178,2571,6666,2573,5642,2574,3594,2579,6410,2581,5386,2582,3338,2585,4874,2586,2826,2595,6282,2597,5258,2598,3210,2601,4746,2602,2698,2609,4490,2627,6218,2629,5194,2630,3146,2633,4682,2641,4426,2657,4298,2691,6186,2693,5162,2694,3114,2697,4650,2705,4394,2721,4266,2753,4202,2819,6170,2821,5146,2822,3098,2825,4634,2833,4378,2849,4250,2881,4186,2945,4154,3079,7174,3083,6662,3085,5638,3086,3590,3091,6406,3093,5382,3094,3334,3097,4870,3107,6278,3109,5254,3110,3206,3113,4742,3121,4486,3139,6214,3141,5190,3145,4678,3153,4422,3169,4294,3203,6182,3205,5158,3209,4646,3217,4390,3233,4262,3265,4198,3331,6166,3333,5142,3337,4630,3345,4374,3361,4246,3393,4182,3457,4150,3587,6158,3589,5134,3593,4622,3601,4366,3617,4238,3649,4174,3713,4142,3841,4126,4111,7681,4119,7425,4123,6913,4125,5889,4135,7297,4139,6785,4141,5761,4147,6529,4149,5505,4153,4993,4167,7233,4171,6721,4173,5697,4179,6465,4181,5441,4185,4929,4195,6337,4197,5313,4201,4801,4209,4545,4231,7201,4235,6689,4237,5665,4243,6433,4245,5409,4249,4897,4259,6305,4261,5281,4265,4769,4273,4513,4291,6241,4293,5217,4297,4705,4305,4449,4359,7185,4363,6673,4365,5649,4371,6417,4373,5393,4377,4881,4387,6289,4389,5265,4393,4753,4401,4497,4419,6225,4421,5201,4425,4689,4483,6193,4485,5169,4489,4657,4615,7177,4619,6665,4621,5641,4627,6409,4629,5385,4633,4873,4643,6281,4645,5257,4649,4745,4675,6217,4677,5193,4739,6185,4741,5161,4867,6169,4869,5145,5127,7173,5131,6661,5133,5637,5139,6405,5141,5381,5155,6277,5157,5253,5187,6213,5251,6181,5379,6165,5635,6157,6151,7171,6155,6659,6163,6403,6179,6275,6211,5189,4681,4433,4321,3142,2634,2386,2274,1612,1364,1252,856,744,496]);$_.tab213=$a([3,6144,5,5120,6,3072,9,4608,10,2560,12,1536,17,4352,18,2304,20,1280,24,768,33,4224,34,2176,36,1152,40,640,48,384,65,4160,66,2112,68,1088,72,576,80,320,96,192,129,4128,130,2080,132,1056,136,544,144,288,257,4112,258,2064,260,1040,264,528,513,4104,514,2056,516,1032,1025,4100,1026,2052,2049,4098,4097,2050,1028,520,272,160]);$_.chars=$a(10);for(var _3T=0;_3T<=9;_3T+=1){$_.i=_3T;var _3W=$g($_.codewords,$_.i);$k[$j++]=_3W;if(_3W<=1286){var _3Z=$g($_.tab513,$k[--$j]);$k[$j++]=_3Z}else{var _3c=$g($_.tab213,$k[--$j]-1287);$k[$j++]=_3c}$k[$j++]=$_.chars;$k[$j++]=$_.i;var _3f=$k[$j-3];var _3g=$k[$j-1];$p($k[$j-2],_3g,_3f);$j-=3}for(var _3i=9;_3i>=0;_3i-=1){$_.i=_3i;if((~~$pow(2,$_.i)&$_.fcs)!=0){$p($_.chars,$_.i,$g($_.chars,$_.i)^8191)}}$_.barmap=$a([7,2,4,3,1,10,0,0,9,12,2,8,5,5,6,11,8,9,3,1,0,1,5,12,2,5,1,8,4,4,9,11,6,3,8,10,3,9,7,6,5,11,1,4,8,5,2,12,9,10,0,2,7,1,6,7,3,6,4,9,0,3,8,6,6,4,2,7,1,1,9,9,7,10,5,2,4,0,3,8,6,2,0,4,8,11,1,0,9,8,3,12,2,6,7,7,5,1,4,10,1,12,6,9,7,3,8,0,5,8,9,7,4,6,2,10,3,4,0,5,8,4,5,7,7,11,1,9,6,0,9,6,0,6,4,8,2,1,3,2,5,9,8,12,4,11,6,1,9,5,7,4,3,3,1,2,0,7,2,0,1,3,4,1,6,10,3,5,8,7,9,4,2,11,5,6,0,8,7,12,4,2,8,1,5,10,3,0,9,3,0,9,6,5,2,4,7,8,1,7,5,0,4,5,2,3,0,10,6,12,9,2,3,11,1,6,8,8,7,9,5,4,0,11,1,5,2,2,9,1,4,12,8,3,6,6,7,0,3,7,4,7,7,5,0,12,1,11,2,9,9,0,6,8,5,3,3,10,8,2]);$_.bbs=$a(65);$_.bhs=$a(65);for(var _3u=0;_3u<=64;_3u+=1){$_.i=_3u;$_.dec=($g($_.chars,$g($_.barmap,$_.i*4))&~~$pow(2,$g($_.barmap,$_.i*4+1)))!=0;$_.asc=($g($_.chars,$g($_.barmap,$_.i*4+2))&~~$pow(2,$g($_.barmap,$_.i*4+3)))!=0;if(!$_.dec&&!$_.asc){$p($_.bbs,$_.i,3*$_.height/8);$p($_.bhs,$_.i,2*$_.height/8)}if(!$_.dec&&$_.asc){$p($_.bbs,$_.i,3*$_.height/8);$p($_.bhs,$_.i,5*$_.height/8)}if($_.dec&&!$_.asc){$p($_.bbs,$_.i,0*$_.height/8);$p($_.bhs,$_.i,5*$_.height/8)}if($_.dec&&$_.asc){$p($_.bbs,$_.i,0*$_.height/8);$p($_.bhs,$_.i,8*$_.height/8)}}$k[$j++]=Infinity;var _4h=$_.bbs;var _4i=$_.bhs;$k[$j++]=Infinity;for(var _4k=0,_4l=$_.bhs.length-1;_4k<_4l;_4k++){$k[$j++]=1.44;$k[$j++]=1.872}$k[$j++]=1.44;var _4m=$a();$k[$j++]="ren";$k[$j++]="renlinear";$k[$j++]="bbs";$k[$j++]=_4h;$k[$j++]="bhs";$k[$j++]=_4i;$k[$j++]="sbs";$k[$j++]=_4m;$k[$j++]="txt";$k[$j++]=$_.txt;$k[$j++]="textxalign";$k[$j++]="left";$k[$j++]="textfont";$k[$j++]="OCR-B";$k[$j++]="textyoffset";$k[$j++]=1;$k[$j++]="textxoffset";$k[$j++]=-.3;$k[$j++]="opt";$k[$j++]=$_.options;var _4p=$d();$k[$j++]=_4p;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_postnet(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.includetext=false;$_.validatecheck=false;$_.includecheckintext=false;$_.textfont="OCR-B";$_.textsize=10;$_.textyoffset=-8;$_.height=.125;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];$k[$j++]="barlen";$k[$j++]=$_.barcode.length;if($_.validatecheck){var _4=$k[--$j];$k[$j++]=_4-1}var _5=$k[--$j];$_[$k[--$j]]=_5;if($_.barlen!=5&&$_.barlen!=9&&$_.barlen!=11){$k[$j++]="bwipp.postnetBadLength#12597";$k[$j++]="USPS POSTNET must be 5, 9 or 11 digits excluding check digit";bwipp_raiseerror()}$F($_.barcode,function(){var _B=$k[--$j];if(_B<48||_B>57){$k[$j++]="bwipp.postnetBadCharacter#12601";$k[$j++]="USPS POSTNET must contain only digits";bwipp_raiseerror()}});$_.barchars="0123456789";$_.encs=$a(["55222","22255","22525","22552","25225","25252","25522","52225","52252","52522","5","5"]);$_.checksum=0;for(var _G=0,_F=$_.barlen-1;_G<=_F;_G+=1){$_.i=_G;$_.checksum=$f($_.checksum+($g($_.barcode,$_.i)-48))}$_.checksum=(10-$_.checksum%10)%10;if($_.validatecheck){if($g($_.barcode,$_.barlen)!=$g($_.barchars,$_.checksum)){$k[$j++]="bwipp.postnetBadCheckDigit#12625";$k[$j++]="Incorrect USPS POSTNET check digit provided";bwipp_raiseerror()}$_.barcode=$G($_.barcode,0,$_.barlen)}$_.bhs=$a($_.barlen*5+7);$_.txt=$a($_.barlen+1);$_.enc=$g($_.encs,10);$_.heights=$a($_.enc.length);for(var _g=0,_f=$_.enc.length-1;_g<=_f;_g+=1){$_.j=_g;$p($_.heights,$_.j,$i($G($_.enc,$_.j,1))*$_.height/5)}$P($_.bhs,0,$_.heights);for(var _r=0,_q=$_.barlen-1;_r<=_q;_r+=1){$_.i=_r;$_.enc=$g($_.encs,$g($_.barcode,$_.i)-48);$_.heights=$a($_.enc.length);for(var _11=0,_10=$_.enc.length-1;_11<=_10;_11+=1){$_.j=_11;$p($_.heights,$_.j,$i($G($_.enc,$_.j,1))*$_.height/5)}$P($_.bhs,$_.i*5+1,$_.heights);$p($_.txt,$_.i,$a([$G($_.barcode,$_.i,1),($_.i*5+1)*3.312,$_.textyoffset,$_.textfont,$_.textsize]))}$_.enc=$g($_.encs,$_.checksum);$_.heights=$a($_.enc.length);for(var _1S=0,_1R=$_.enc.length-1;_1S<=_1R;_1S+=1){$_.j=_1S;$p($_.heights,$_.j,$i($G($_.enc,$_.j,1))*$_.height/5)}$P($_.bhs,$_.barlen*5+1,$_.heights);if($_.includecheckintext){$p($_.txt,$_.barlen,$a([$G($_.barchars,$_.checksum,1),($_.barlen*5+1)*3.312,$_.textyoffset,$_.textfont,$_.textsize]))}else{$p($_.txt,$_.barlen,$a([" ",($_.barlen*5+1)*72/25,$_.textyoffset,$_.textfont,$_.textsize]))}$_.enc=$g($_.encs,11);$_.heights=$a($_.enc.length);for(var _20=0,_1z=$_.enc.length-1;_20<=_1z;_20+=1){$_.j=_20;$p($_.heights,$_.j,$i($G($_.enc,$_.j,1))*$_.height/5)}$P($_.bhs,$_.barlen*5+6,$_.heights);$k[$j++]=Infinity;var _2A=$_.bhs;$k[$j++]=Infinity;for(var _2C=0,_2D=$_.bhs.length;_2C<_2D;_2C++){$k[$j++]=0}var _2E=$a();$k[$j++]=Infinity;for(var _2G=0,_2H=$_.bhs.length-1;_2G<_2H;_2G++){$k[$j++]=1.44;$k[$j++]=1.872}$k[$j++]=1.44;var _2I=$a();$k[$j++]="ren";$k[$j++]="renlinear";$k[$j++]="bhs";$k[$j++]=_2A;$k[$j++]="bbs";$k[$j++]=_2E;$k[$j++]="sbs";$k[$j++]=_2I;if($_.includetext){$k[$j++]="txt";$k[$j++]=$_.txt}$k[$j++]="opt";$k[$j++]=$_.options;var _2M=$d();$k[$j++]=_2M;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_planet(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.includetext=false;$_.validatecheck=false;$_.includecheckintext=false;$_.textfont="OCR-B";$_.textsize=10;$_.textyoffset=-8;$_.height=.125;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];$k[$j++]="barlen";$k[$j++]=$_.barcode.length;if($_.validatecheck){var _4=$k[--$j];$k[$j++]=_4-1}var _5=$k[--$j];$_[$k[--$j]]=_5;if($_.barlen!=11&&$_.barlen!=13){$k[$j++]="bwipp.planetBadLength#12745";$k[$j++]="USPS PLANET must be 11 or 13 digits excluding check digit";bwipp_raiseerror()}$F($_.barcode,function(){var _A=$k[--$j];if(_A<48||_A>57){$k[$j++]="bwipp.planetBadCharacter#12749";$k[$j++]="USPS PLANET must contain only digits";bwipp_raiseerror()}});$_.barchars="0123456789";$_.encs=$a(["22555","55522","55252","55225","52552","52525","52255","25552","25525","25255","5","5"]);$_.checksum=0;for(var _F=0,_E=$_.barlen-1;_F<=_E;_F+=1){$_.i=_F;$_.checksum=$f($_.checksum+($g($_.barcode,$_.i)-48))}$_.checksum=(10-$_.checksum%10)%10;if($_.validatecheck){if($g($_.barcode,$_.barlen)!=$g($_.barchars,$_.checksum)){$k[$j++]="bwipp.planetBadCheckDigit#12774";$k[$j++]="Incorrect USPS PLANET check digit provided";bwipp_raiseerror()}$_.barcode=$G($_.barcode,0,$_.barlen)}$_.bhs=$a($_.barlen*5+7);$_.txt=$a($_.barlen+1);$_.enc=$g($_.encs,10);$_.heights=$a($_.enc.length);for(var _f=0,_e=$_.enc.length-1;_f<=_e;_f+=1){$_.j=_f;$p($_.heights,$_.j,$i($G($_.enc,$_.j,1))*$_.height/5)}$P($_.bhs,0,$_.heights);for(var _q=0,_p=$_.barlen-1;_q<=_p;_q+=1){$_.i=_q;$_.enc=$g($_.encs,$g($_.barcode,$_.i)-48);$_.heights=$a($_.enc.length);for(var _10=0,_z=$_.enc.length-1;_10<=_z;_10+=1){$_.j=_10;$p($_.heights,$_.j,$i($G($_.enc,$_.j,1))*$_.height/5)}$P($_.bhs,$_.i*5+1,$_.heights);$p($_.txt,$_.i,$a([$G($_.barcode,$_.i,1),($_.i*5+1)*3.312,$_.textyoffset,$_.textfont,$_.textsize]))}$_.enc=$g($_.encs,$_.checksum);$_.heights=$a($_.enc.length);for(var _1R=0,_1Q=$_.enc.length-1;_1R<=_1Q;_1R+=1){$_.j=_1R;$p($_.heights,$_.j,$i($G($_.enc,$_.j,1))*$_.height/5)}$P($_.bhs,$_.barlen*5+1,$_.heights);if($_.includecheckintext){$p($_.txt,$_.barlen,$a([$G($_.barchars,$_.checksum,1),($_.barlen*5+1)*3.312,$_.textyoffset,$_.textfont,$_.textsize]))}else{$p($_.txt,$_.barlen,$a([" ",($_.barlen*5+1)*72/25,$_.textyoffset,$_.textfont,$_.textsize]))}$_.enc=$g($_.encs,11);$_.heights=$a($_.enc.length);for(var _1z=0,_1y=$_.enc.length-1;_1z<=_1y;_1z+=1){$_.j=_1z;$p($_.heights,$_.j,$i($G($_.enc,$_.j,1))*$_.height/5)}$P($_.bhs,$_.barlen*5+6,$_.heights);$k[$j++]=Infinity;var _29=$_.bhs;$k[$j++]=Infinity;for(var _2B=0,_2C=$_.bhs.length;_2B<_2C;_2B++){$k[$j++]=0}var _2D=$a();$k[$j++]=Infinity;for(var _2F=0,_2G=$_.bhs.length-1;_2F<_2G;_2F++){$k[$j++]=1.44;$k[$j++]=1.872}$k[$j++]=1.44;var _2H=$a();$k[$j++]="ren";$k[$j++]="renlinear";$k[$j++]="bhs";$k[$j++]=_29;$k[$j++]="bbs";$k[$j++]=_2D;$k[$j++]="sbs";$k[$j++]=_2H;if($_.includetext){$k[$j++]="txt";$k[$j++]=$_.txt}$k[$j++]="opt";$k[$j++]=$_.options;var _2L=$d();$k[$j++]=_2L;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_royalmail(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.includetext=false;$_.validatecheck=false;$_.includecheckintext=false;$_.textfont="OCR-B";$_.textsize=10;$_.textyoffset=-8;$_.height=.175;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.barcode.length==0){$k[$j++]="bwipp.royalmailEmptyData#12889";$k[$j++]="The data must not be empty";bwipp_raiseerror()}$_.barchars="ZUVWXY501234B6789AHCDEFGNIJKLMTOPQRS";$_.charvals=new Map;for(var _3=0;_3<=35;_3+=1){$p($_.charvals,$G($_.barchars,_3,1),_3)}$_.encs=$a(["3300","2211","2301","2310","3201","3210","1122","0033","0123","0132","1023","1032","1302","0213","0303","0312","1203","1212","1320","0231","0321","0330","1221","1230","3102","2013","2103","2112","3003","3012","3120","2031","2121","2130","3021","3030","2","3"]);for(var _B=0,_A=$_.barcode.length-1;_B<=_A;_B+=1){var _F=$g($_.charvals,$G($_.barcode,_B,1))!==undefined;if(!_F){$k[$j++]="bwipp.royalmailBadCharacter#12915";$k[$j++]="RM4SCC must contain only capital letters and digits";bwipp_raiseerror()}}$k[$j++]="barlen";$k[$j++]=$_.barcode.length;if($_.validatecheck){var _I=$k[--$j];$k[$j++]=_I-1}var _J=$k[--$j];$_[$k[--$j]]=_J;$_.checksumrow=0;$_.checksumcol=0;for(var _N=0,_M=$_.barlen-1;_N<=_M;_N+=1){$_.i=_N;$_.indx=$g($_.charvals,$G($_.barcode,$_.i,1));$_.checksumrow=$_.checksumrow+~~($_.indx/6);$_.checksumcol=$f($_.checksumcol+$_.indx%6)}$_.checksum=$f($_.checksumrow%6*6+$_.checksumcol%6);if($_.validatecheck){if($g($_.barcode,$_.barlen)!=$g($_.barchars,$_.checksum)){$k[$j++]="bwipp.royalmailBadCheckDigit#12932";$k[$j++]="Incorrect RM4SCC check digit provided";bwipp_raiseerror()}$_.barcode=$G($_.barcode,0,$_.barlen)}$_.encstr=$s($_.barlen*4+6);$_.txt=$a($_.barlen+1);$P($_.encstr,0,$g($_.encs,36));for(var _s=0,_r=$_.barlen-1;_s<=_r;_s+=1){$_.i=_s;$_.indx=$g($_.charvals,$G($_.barcode,$_.i,1));$P($_.encstr,$_.i*4+1,$g($_.encs,$_.indx));$p($_.txt,$_.i,$a([$G($_.barcode,$_.i,1),($_.i*4+1)*3.312,$_.textyoffset,$_.textfont,$_.textsize]))}$P($_.encstr,$_.barlen*4+1,$g($_.encs,$_.checksum));if($_.includecheckintext){$p($_.txt,$_.barlen,$a([$G($_.barchars,$_.checksum,1),($_.barlen*4+1)*3.312,$_.textyoffset,$_.textfont,$_.textsize]))}else{$p($_.txt,$_.barlen,$a([" ",($_.barlen*4+1)*3.312,$_.textyoffset,$_.textfont,$_.textsize]))}$P($_.encstr,$_.barlen*4+5,$g($_.encs,37));$_.bbs=$a($_.encstr.length);$_.bhs=$a($_.encstr.length);for(var _1k=0,_1j=$_.encstr.length-1;_1k<=_1j;_1k+=1){$_.i=_1k;$_.enc=$G($_.encstr,$_.i,1);if($eq($_.enc,"0")){$p($_.bbs,$_.i,3*$_.height/8);$p($_.bhs,$_.i,2*$_.height/8)}if($eq($_.enc,"1")){$p($_.bbs,$_.i,0*$_.height/8);$p($_.bhs,$_.i,5*$_.height/8)}if($eq($_.enc,"2")){$p($_.bbs,$_.i,3*$_.height/8);$p($_.bhs,$_.i,5*$_.height/8)}if($eq($_.enc,"3")){$p($_.bbs,$_.i,0*$_.height/8);$p($_.bhs,$_.i,8*$_.height/8)}}$k[$j++]=Infinity;var _2G=$_.bbs;var _2H=$_.bhs;$k[$j++]=Infinity;for(var _2J=0,_2K=$_.bhs.length-1;_2J<_2K;_2J++){$k[$j++]=1.44;$k[$j++]=1.872}$k[$j++]=1.44;var _2L=$a();$k[$j++]="ren";$k[$j++]="renlinear";$k[$j++]="bbs";$k[$j++]=_2G;$k[$j++]="bhs";$k[$j++]=_2H;$k[$j++]="sbs";$k[$j++]=_2L;if($_.includetext){$k[$j++]="txt";$k[$j++]=$_.txt}$k[$j++]="opt";$k[$j++]=$_.options;var _2P=$d();$k[$j++]=_2P;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_auspost(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.includetext=false;$_.textfont="OCR-B";$_.textsize=10;$_.textyoffset=-8;$_.height=.175;$_.custinfoenc="character";$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($ne($_.custinfoenc,"character")&&$ne($_.custinfoenc,"numeric")){$k[$j++]="bwipp.auspostBadCustinfoEncoding#13045";$k[$j++]="Customer information encoding must be either character or numeric";bwipp_raiseerror()}$_.encs=$a(["000","001","002","010","011","012","020","021","022","100","101","102","110","111","112","120","121","122","200","201","202","210","211","212","220","221","222","300","301","302","310","311","312","320","321","322","023","030","031","032","033","103","113","123","130","131","132","133","203","213","223","230","231","232","233","303","313","323","330","331","332","333","003","013","00","01","02","10","11","12","20","21","22","30","13","3"]);$_.barchars="ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789abcdefghijklmnopqrstuvwxyz #";var _5=new Map([["11",37],["45",37],["59",52],["62",67]]);$_.fcclen=_5;$_.barlen=$_.barcode.length;if($_.barlen<10){$k[$j++]="bwipp.auspostTooShort#13075";$k[$j++]="The data length must be at least 10";bwipp_raiseerror()}$_.txt=$a($_.barlen-2);$k[$j++]=$_.fcclen;if($_.barlen>=2){$k[$j++]=$G($_.barcode,0,2)}else{$k[$j++]=""}var _F=$k[$j-1];var _G=$k[$j-2];var _H=$g(_G,_F)!==undefined;if(!_H){$j-=2;$k[$j++]="bwipp.auspostBadFCC#13082";$k[$j++]="Must begin with an FCC, either 11, 45, 59 or 62";bwipp_raiseerror()}var _I=$k[--$j];$_.encstr=$s($g($k[--$j],_I));$k[$j++]=true;for(var _M=0;_M<1;_M++){if($_.barlen<10){$k[$j-1]=false;break}var _P=$G($_.barcode,2,8);for(var _Q=0,_R=_P.length;_Q<_R;_Q++){var _S=$g(_P,_Q);if(_S<48||_S>57){$k[$j-1]=false;break}}}if(!$k[--$j]){$k[$j++]="bwipp.auspostIncompleteDPID#13093";$k[$j++]="The DPID must be 8 digits";bwipp_raiseerror()}var _W=$eq($_.custinfoenc,"numeric")?2:3;if(($_.barlen-10)*_W>$_.encstr.length-22-14){$k[$j++]="bwipp.auspostTooLong#13099";$k[$j++]="The message is too long";bwipp_raiseerror()}$P($_.encstr,0,$g($_.encs,74));for(var _b=0;_b<=1;_b+=1){$_.i=_b;$P($_.encstr,$_.i*2+2,$g($_.encs,$i($G($_.barcode,$_.i,1))+64))}for(var _j=2;_j<=9;_j+=1){$_.i=_j;$P($_.encstr,$_.i*2+2,$g($_.encs,$i($G($_.barcode,$_.i,1))+64));$p($_.txt,$_.i-2,$a([$G($_.barcode,$_.i,1),(($_.i-2)*2+6)*3.312,$_.textyoffset,$_.textfont,$_.textsize]))}if($eq($_.custinfoenc,"numeric")){for(var _14=0,_13=$_.barlen-11;_14<=_13;_14+=1){$_.i=_14;var _18=$g($_.barcode,$_.i+10);$k[$j++]=$_.encs;$k[$j++]=_18;if(_18<48||_18>57){$k[$j++]="bwipp.auspostInvalidCustinfoDigit#13126";$k[$j++]="The customer information data contains a non-digit character";bwipp_raiseerror()}var _19=$k[--$j];$P($_.encstr,$_.i*2+22,$g($k[--$j],_19-48+64));$p($_.txt,$_.i+8,$a([$G($_.barcode,$_.i+10,1),($_.i*2+22)*3.312,$_.textyoffset,$_.textfont,$_.textsize]))}$_.ciflen=($_.barlen-10)*2}else{for(var _1R=0,_1Q=$_.barlen-11;_1R<=_1Q;_1R+=1){$_.i=_1R;$X($_.barchars,$G($_.barcode,$_.i+10,1));if(!$k[--$j]){$j--;$k[$j++]="bwipp.auspostInvalidCustinfoCharacter#13138";$k[$j++]="The customer information contains an invalid character";bwipp_raiseerror()}$_.indx=$k[--$j].length;$j-=2;$_.enc=$g($_.encs,$_.indx);$P($_.encstr,$_.i*3+22,$_.enc);$p($_.txt,$_.i+8,$a([$G($_.barcode,$_.i+10,1),($_.i*3+22)*3.312,$_.textyoffset,$_.textfont,$_.textsize]))}$_.ciflen=($_.barlen-10)*3}for(var _1s=22+$_.ciflen,_1r=$_.encstr.length-14;_1s<=_1r;_1s+=1){$P($_.encstr,_1s,$g($_.encs,75))}$_.rstable=$a(64*64);$k[$j++]=$_.rstable;$k[$j++]=0;$k[$j++]=Infinity;for(var _1y=0;_1y<64;_1y++){$k[$j++]=0}var _1z=$a();var _20=$k[--$j];$P($k[--$j],_20,_1z);$k[$j++]=$_.rstable;$k[$j++]=64;$k[$j++]=Infinity;for(var _23=0;_23<=63;_23+=1){$k[$j++]=_23}var _24=$a();var _25=$k[--$j];$P($k[--$j],_25,_24);$_.prev=1;for(var _27=0;_27<64;_27++){$_.next=$_.prev<<1;if(($_.next&64)!=0){$_.next=$_.next^67}for(var _2B=0;_2B<=63;_2B+=1){$_.j=_2B;$_.nextcell=function(){$k[$j++]=$_.rstable;$k[$j++]=64*$_.next+$_.j};$_.nextcell();var _2J=$k[--$j];$p($k[--$j],_2J,$g($_.rstable,64*$_.prev+$_.j)<<1);$_.nextcell();var _2L=$k[--$j];if(($g($k[--$j],_2L)&64)!=0){$_.nextcell();$_.nextcell();var _2O=$k[--$j];var _2Q=$g($k[--$j],_2O);var _2R=$k[--$j];$p($k[--$j],_2R,_2Q^67)}}$_.prev=$_.next}$_.rscodes=$a(~~(($_.encstr.length-16)/3)+4);$k[$j++]=$_.rscodes;$k[$j++]=0;$k[$j++]=Infinity;for(var _2Y=0;_2Y<4;_2Y++){$k[$j++]=0}var _2Z=$a();var _2a=$k[--$j];$P($k[--$j],_2a,_2Z);for(var _2e=2,_2d=$_.encstr.length-16;_2e<=_2d;_2e+=3){$_.i=_2e;$p($_.rscodes,$_.rscodes.length-~~(($_.i-2)/3)-1,$i($G($_.encstr,$_.i,1))*16+$i($G($_.encstr,$_.i+1,1))*4+$i($G($_.encstr,$_.i+2,1)))}for(var _2s=$_.rscodes.length-5;_2s>=0;_2s-=1){$_.i=_2s;for(var _2t=0;_2t<=4;_2t+=1){$_.j=_2t;$p($_.rscodes,$_.i+$_.j,$xo($g($_.rscodes,$_.i+$_.j),$g($_.rstable,$f(64*$g($a([48,17,29,30,1]),$_.j)+$g($_.rscodes,$_.i+4)))))}}$_.checkcode=$Z($s(12),"000000000000");for(var _3B=0;_3B<=3;_3B+=1){$_.i=_3B;$_.enc=$R($s(3),$g($_.rscodes,3-$_.i),4);$P($_.checkcode,$_.i*3+(3-$_.enc.length),$_.enc)}$P($_.encstr,$_.encstr.length-14,$_.checkcode);$P($_.encstr,$_.encstr.length-2,$g($_.encs,74));$_.bbs=$a($_.encstr.length);$_.bhs=$a($_.encstr.length);for(var _3Y=0,_3X=$_.encstr.length-1;_3Y<=_3X;_3Y+=1){$_.i=_3Y;$_.enc=$G($_.encstr,$_.i,1);if($eq($_.enc,"0")){$p($_.bbs,$_.i,0*$_.height/8);$p($_.bhs,$_.i,8*$_.height/8)}if($eq($_.enc,"1")){$p($_.bbs,$_.i,3*$_.height/8);$p($_.bhs,$_.i,5*$_.height/8)}if($eq($_.enc,"2")){$p($_.bbs,$_.i,0*$_.height/8);$p($_.bhs,$_.i,5*$_.height/8)}if($eq($_.enc,"3")){$p($_.bbs,$_.i,3*$_.height/8);$p($_.bhs,$_.i,2*$_.height/8)}}$k[$j++]=Infinity;var _44=$_.bbs;var _45=$_.bhs;$k[$j++]=Infinity;for(var _47=0,_48=$_.bhs.length-1;_47<_48;_47++){$k[$j++]=1.44;$k[$j++]=1.872}$k[$j++]=1.44;var _49=$a();$k[$j++]="ren";$k[$j++]="renlinear";$k[$j++]="bbs";$k[$j++]=_44;$k[$j++]="bhs";$k[$j++]=_45;$k[$j++]="sbs";$k[$j++]=_49;if($_.includetext){$k[$j++]="txt";$k[$j++]=$_.txt}$k[$j++]="opt";$k[$j++]=$_.options;var _4D=$d();$k[$j++]=_4D;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_kix(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.includetext=false;$_.textfont="OCR-B";$_.textsize=10;$_.textyoffset=-8;$_.height=.175;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.barcode.length==0){$k[$j++]="bwipp.kixEmptyData#13291";$k[$j++]="The data must not be empty";bwipp_raiseerror()}$_.encs=$a(["0033","0123","0132","1023","1032","1122","0213","0303","0312","1203","1212","1302","0231","0321","0330","1221","1230","1320","2013","2103","2112","3003","3012","3102","2031","2121","2130","3021","3030","3120","2211","2301","2310","3201","3210","3300"]);$_.barchars="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";$_.charvals=new Map;for(var _4=0;_4<=35;_4+=1){$p($_.charvals,$G($_.barchars,_4,1),_4)}for(var _B=0,_A=$_.barcode.length-1;_B<=_A;_B+=1){var _F=$g($_.charvals,$G($_.barcode,_B,1))!==undefined;if(!_F){$k[$j++]="bwipp.kixBadCharacter#13316";$k[$j++]="KIX must contain only capital letters and digits";bwipp_raiseerror()}}$_.barlen=$_.barcode.length;$_.encstr=$s($_.barlen*4);$_.txt=$a($_.barlen);for(var _N=0,_M=$_.barlen-1;_N<=_M;_N+=1){$_.i=_N;$_.indx=$g($_.charvals,$G($_.barcode,$_.i,1));$P($_.encstr,$_.i*4,$g($_.encs,$_.indx));$p($_.txt,$_.i,$a([$G($_.barcode,$_.i,1),$_.i*4*3.312,$_.textyoffset,$_.textfont,$_.textsize]))}$_.bbs=$a($_.encstr.length);$_.bhs=$a($_.encstr.length);for(var _o=0,_n=$_.encstr.length-1;_o<=_n;_o+=1){$_.i=_o;$_.enc=$G($_.encstr,$_.i,1);if($eq($_.enc,"0")){$p($_.bbs,$_.i,3*$_.height/8);$p($_.bhs,$_.i,2*$_.height/8)}if($eq($_.enc,"1")){$p($_.bbs,$_.i,0*$_.height/8);$p($_.bhs,$_.i,5*$_.height/8)}if($eq($_.enc,"2")){$p($_.bbs,$_.i,3*$_.height/8);$p($_.bhs,$_.i,5*$_.height/8)}if($eq($_.enc,"3")){$p($_.bbs,$_.i,0*$_.height/8);$p($_.bhs,$_.i,8*$_.height/8)}}$k[$j++]=Infinity;var _1K=$_.bbs;var _1L=$_.bhs;$k[$j++]=Infinity;for(var _1N=0,_1O=$_.bhs.length-1;_1N<_1O;_1N++){$k[$j++]=1.44;$k[$j++]=1.872}$k[$j++]=1.44;var _1P=$a();$k[$j++]="ren";$k[$j++]="renlinear";$k[$j++]="bbs";$k[$j++]=_1K;$k[$j++]="bhs";$k[$j++]=_1L;$k[$j++]="sbs";$k[$j++]=_1P;if($_.includetext){$k[$j++]="txt";$k[$j++]=$_.txt}$k[$j++]="opt";$k[$j++]=$_.options;var _1T=$d();$k[$j++]=_1T;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_japanpost(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.includetext=false;$_.includecheckintext=false;$_.textfont="OCR-B";$_.textsize=10;$_.textyoffset=-8;$_.height=.175;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.barcode.length==0){$k[$j++]="bwipp.japanpostEmptyData#13415";$k[$j++]="The data must not be empty";bwipp_raiseerror()}$F($_.barcode,function(){var _4=$k[--$j];if(!(_4>=48&&_4<=57||(_4>=65&&_4<=90||_4==45))){$k[$j++]="bwipp.japanpostBadCharacter#13425";$k[$j++]="Japan Post must contain only digits, capital letters and the dash symbol";bwipp_raiseerror()}});$_.encs=$a(["300","330","312","132","321","303","123","231","213","033","030","120","102","210","012","201","021","003","333","31","13"]);$_.barchars="0123456789-ABCDEFGHIJKLMNOPQRSTUVWXYZ";$_.barlen=$_.barcode.length;$_.encstr=$s((20+1)*3+4);$_.digits=$a(20);$_.txt=$a($_.barlen+1);$P($_.encstr,0,$g($_.encs,19));$_.checksum=0;$_.j=0;$_.i=0;$k[$j++]=true;for(var _H=0,_G=$_.barlen-1;_H<=_G;_H+=1){$_.i=_H;$X($_.barchars,$G($_.barcode,$_.i,1));$j--;$_.indx=$k[--$j].length;$j-=2;if($_.indx>=11&&$_.indx<37){if($_.j>18){$k[$j-1]=false;break}$_.digit=~~(($_.indx-1)/10)+10;$P($_.encstr,$_.j*3+2,$g($_.encs,$_.digit));$_.checksum=$_.checksum+$_.digit;$p($_.digits,$_.j,$_.digit);$_.j=$_.j+1}if($_.j>19){$k[$j-1]=false;break}$_.digit=0;if($_.indx==37){$_.digit=14}if($_.indx>=11&&$_.indx<37){$_.digit=($_.indx-1)%10}if($_.indx<11){$_.digit=$_.indx}$P($_.encstr,$_.j*3+2,$g($_.encs,$_.digit));$_.checksum=$_.checksum+$_.digit;$p($_.digits,$_.j,$_.digit);$p($_.txt,$_.i,$a([$G($_.barcode,$_.i,1),($_.j*3+2)*3.312,$_.textyoffset,$_.textfont,$_.textsize]));$_.j=$_.j+1}if(!$k[--$j]){$k[$j++]="bwipp.japanpostTooLong#13489";$k[$j++]="The input is too long";bwipp_raiseerror()}for(var _17=$_.j,_16=20-1;_17<=_16;_17+=1){$_.k=_17;$P($_.encstr,$_.k*3+2,$g($_.encs,14));$_.checksum=$_.checksum+14;$p($_.digits,$_.k,14)}$_.checksum=19-$_.checksum%19;$P($_.encstr,2+20*3,$g($_.encs,$_.checksum));$P($_.encstr,2+21*3,$g($_.encs,20));$_.checkdigit=" ";if($_.includecheckintext){$_.checkdigit=$G($_.barchars,$_.checksum,1)}$p($_.txt,$_.i+1,$a([$_.checkdigit,(20*3+2)*3.312,$_.textyoffset,$_.textfont,$_.textsize]));$P($_.encstr,(20+1)*3+2,$g($_.encs,20));$_.bbs=$a(21*3+4);$_.bhs=$a($_.bbs.length);for(var _1g=0,_1f=$_.bbs.length-1;_1g<=_1f;_1g+=1){$_.i=_1g;$_.enc=$G($_.encstr,$_.i,1);$_.bunit=0;$_.hunit=0;if($eq($_.enc,"0")){$_.bunit=3;$_.hunit=2}if($eq($_.enc,"1")){$_.bunit=0;$_.hunit=5}if($eq($_.enc,"2")){$_.bunit=3;$_.hunit=5}if($eq($_.enc,"3")){$_.bunit=0;$_.hunit=8}$p($_.bbs,$_.i,$_.bunit*$_.height/8);$p($_.bhs,$_.i,$_.hunit*$_.height/8)}$k[$j++]=Infinity;var _1w=$_.bbs;var _1x=$_.bhs;$k[$j++]=Infinity;for(var _1z=0,_20=$_.bhs.length-1;_1z<_20;_1z++){$k[$j++]=1.44;$k[$j++]=1.872}$k[$j++]=1.44;var _21=$a();$k[$j++]="ren";$k[$j++]="renlinear";$k[$j++]="bbs";$k[$j++]=_1w;$k[$j++]="bhs";$k[$j++]=_1x;$k[$j++]="sbs";$k[$j++]=_21;if($_.includetext){$k[$j++]="txt";$k[$j++]=$_.txt}$k[$j++]="opt";$k[$j++]=$_.options;var _25=$d();$k[$j++]=_25;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_msi(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.includecheck=false;$_.includetext=false;$_.includecheckintext=false;$_.checktype="unset";$_.badmod11=false;$_.textfont="OCR-B";$_.textsize=10;$_.textyoffset=-8;$_.height=1;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($ne($_.checktype,"unset")&&!$_.includecheck){$k[$j++]="bwipp.msiCheckTypeWithoutCheck#13606";$k[$j++]="checktype requires includecheck";bwipp_raiseerror()}if($_.badmod11&&($ne($_.checktype,"mod11")&&$ne($_.checktype,"ncrmod11")&&$ne($_.checktype,"mod1110")&&$ne($_.checktype,"ncrmod1110"))){$k[$j++]="bwipp.msiBadMod11Mismatch#13610";$k[$j++]="badmod11 requires checktype with mod11";bwipp_raiseerror()}if($eq($_.checktype,"unset")){$_.checktype="mod10"}$F($_.barcode,function(){var _B=$k[--$j];if(_B<48||_B>57){$k[$j++]="bwipp.msiBadCharacter#13620";$k[$j++]="MSI must contain only digits";bwipp_raiseerror()}});$_.encs=$a(["12121212","12121221","12122112","12122121","12211212","12211221","12212112","12212121","21121212","21121221","21","121"]);$_.barchars="0123456789";$_.barlen=$_.barcode.length;$_.txtlen=$_.barlen;$_.mod10=function(){$_.code=$k[--$j];$k[$j++]=0;$k[$j++]=0;$F($_.code,function(){var _I=$k[--$j];var _J=$k[--$j];var _K=$k[--$j];$k[$j++]=$f(_I-48+_J*10);$k[$j++]=_K});$j--;var _L=$k[--$j];$k[$j++]=_L*2;$k[$j++]=0;for(;;){var _M=$k[--$j];var _N=$k[--$j];var _O=~~(_N/10);$k[$j++]=$f(_M+_N%10);$k[$j++]=_O;if(_O==0){$j--;break}var _P=$k[--$j];var _Q=$k[--$j];$k[$j++]=_P;$k[$j++]=_Q}$k[$j++]=0;$k[$j++]=0;$F($_.code,function(){var _S=$k[--$j];var _T=$k[--$j];var _U=$k[--$j];$k[$j++]=$f(_T+(_S-48));$k[$j++]=_U});var _V=$k[--$j];$k[$j-1]=_V;var _X=$k[--$j];var _a=$s($_.code.length+1);$P(_a,0,$_.code);$p(_a,$_.code.length,(10-$f($k[--$j]+_X)%10)%10+48);$k[$j++]=_a};$_.mod11=function(){$_.code=$k[--$j];$k[$j++]=$_.code.length-1;$F($_.code,function(){var _g=$k[--$j];var _h=$k[--$j];$k[$j++]=_g-48;$k[$j++]=_h%6+2;$k[$j++]=_h-1});$k[$j-1]=0;for(var _j=0,_k=$_.code.length;_j<_k;_j++){var _l=$k[$j-2];var _m=$k[$j-3];var _n=$k[$j-1];$j-=3;$k[$j++]=$f(_n+_m*_l)}var _p=(11-$k[--$j]%11)%11;$k[$j++]=_p;if(_p==10){if($_.badmod11){$j--;var _s=$s($_.code.length+2);$P(_s,0,$_.code);$P(_s,$_.code.length,"10");$k[$j++]=_s}else{$j--;$k[$j++]="bwipp.msiBadMod11NotSpecified#13657";$k[$j++]="mod11 check digit is 10 but badmod11 not specified";bwipp_raiseerror()}}else{var _w=$s($_.code.length+1);$P(_w,0,$_.code);$k[$j++]=_w;$k[$j++]=_w;$k[$j++]=$_.code.length;$r(4,-1);var _z=$k[--$j];var _10=$k[--$j];$p($k[--$j],_10,_z+48)}};$_.ncrmod11=function(){$_.code=$k[--$j];$k[$j++]=$_.code.length-1;$F($_.code,function(){var _15=$k[--$j];var _16=$k[--$j];$k[$j++]=_15-48;$k[$j++]=_16%8+2;$k[$j++]=_16-1});$k[$j-1]=0;for(var _18=0,_19=$_.code.length;_18<_19;_18++){var _1A=$k[$j-2];var _1B=$k[$j-3];var _1C=$k[$j-1];$j-=3;$k[$j++]=$f(_1C+_1B*_1A)}var _1E=(11-$k[--$j]%11)%11;$k[$j++]=_1E;if(_1E==10){if($_.badmod11){$j--;var _1H=$s($_.code.length+2);$P(_1H,0,$_.code);$P(_1H,$_.code.length,"10");$k[$j++]=_1H}else{$j--;$k[$j++]="bwipp.msiBadMod11NotSpecified#13673";$k[$j++]="mod11 check digit is 10 but badmod11 not specified";bwipp_raiseerror()}}else{var _1L=$s($_.code.length+1);$P(_1L,0,$_.code);$k[$j++]=_1L;$k[$j++]=_1L;$k[$j++]=$_.code.length;$r(4,-1);var _1O=$k[--$j];var _1P=$k[--$j];$p($k[--$j],_1P,_1O+48)}};var _1R=new Map([["mod10",function(){$_.mod10()}],["mod1010",function(){$_.mod10();$_.mod10()}],["mod11",function(){$_.mod11()}],["ncrmod11",function(){$_.ncrmod11()}],["mod1110",function(){$_.mod11();$_.mod10()}],["ncrmod1110",function(){$_.ncrmod11();$_.mod10()}]]);$_.checkfunc=_1R;if($_.includecheck){var _1U=$_.checkfunc;var _1V=$_.checktype;var _1W=$g(_1U,_1V)!==undefined;$k[$j++]=_1U;$k[$j++]=_1V;if(!_1W){$j-=2;$k[$j++]="bwipp.msiBadCharacter#13694";$k[$j++]="MSI checktype must be mod10, mod1010, mod11, ncrmod11, mod1110 or ncrmod1110";bwipp_raiseerror()}var _1X=$k[--$j];var _1Z=$g($k[--$j],_1X);$k[$j++]=$_.barcode;if(_1Z()===true){return true}$_.barcode=$k[--$j];$_.barlen=$_.barcode.length;if($_.includecheckintext){$_.txtlen=$_.barlen}}$_.sbs=$s($_.barlen*8+5);$_.txt=$a($_.barlen);$P($_.sbs,0,$g($_.encs,10));for(var _1o=0,_1n=$_.barlen-1;_1o<=_1n;_1o+=1){$_.i=_1o;$X($_.barchars,$G($_.barcode,$_.i,1));$j--;$_.indx=$k[--$j].length;$j-=2;$_.enc=$g($_.encs,$_.indx);$P($_.sbs,$_.i*8+2,$_.enc);$p($_.txt,$_.i,$a([$G($_.barcode,$_.i,1),$_.i*12+3,$_.textyoffset,$_.textfont,$_.textsize]))}$P($_.sbs,$_.barlen*8+2,$g($_.encs,11));$k[$j++]=Infinity;$k[$j++]=Infinity;var _2E=$_.sbs;for(var _2F=0,_2G=_2E.length;_2F<_2G;_2F++){$k[$j++]=$g(_2E,_2F)-48}var _2I=$a();$k[$j++]=Infinity;for(var _2K=0,_2L=~~(($_.sbs.length+1)/2);_2K<_2L;_2K++){$k[$j++]=$_.height}var _2N=$a();$k[$j++]=Infinity;for(var _2P=0,_2Q=~~(($_.sbs.length+1)/2);_2P<_2Q;_2P++){$k[$j++]=0}var _2R=$a();$k[$j++]="ren";$k[$j++]="renlinear";$k[$j++]="sbs";$k[$j++]=_2I;$k[$j++]="bhs";$k[$j++]=_2N;$k[$j++]="bbs";$k[$j++]=_2R;if($_.includetext){$k[$j++]="txt";$k[$j++]=$G($_.txt,0,$_.txtlen)}$k[$j++]="opt";$k[$j++]=$_.options;var _2X=$d();$k[$j++]=_2X;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_plessey(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.includetext=false;$_.validatecheck=false;$_.includecheckintext=false;$_.unidirectional=false;$_.textfont="OCR-B";$_.textsize=10;$_.textyoffset=-8;$_.height=1;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.barcode.length==0){$k[$j++]="bwipp.plesseyEmptyData#13785";$k[$j++]="The data must not be empty";bwipp_raiseerror()}$_.barchars="0123456789ABCDEF";$_.charvals=new Map;for(var _3=0;_3<=15;_3+=1){$p($_.charvals,$G($_.barchars,_3,1),_3)}$_.encs=$a(["14141414","32141414","14321414","32321414","14143214","32143214","14323214","32323214","14141432","32141432","14321432","32321432","14143232","32143232","14323232","32323232","32321432","541412323","323"]);for(var _B=0,_A=$_.barcode.length-1;_B<=_A;_B+=1){var _F=$g($_.charvals,$G($_.barcode,_B,1))!==undefined;if(!_F){$k[$j++]="bwipp.plesseyBadCharacter#13809";$k[$j++]="Plessey must contain only digits and letters A B C D E F";bwipp_raiseerror()}}$k[$j++]="barlen";$k[$j++]=$_.barcode.length;if($_.validatecheck){var _I=$k[--$j];$k[$j++]=_I-2}var _J=$k[--$j];$_[$k[--$j]]=_J;$_.checkbits=$a($_.barlen*4+8);$P($_.checkbits,$_.barlen*4,$a([0,0,0,0,0,0,0,0]));for(var _S=0,_R=$_.barlen-1;_S<=_R;_S+=1){$_.i=_S;$_.indx=$g($_.charvals,$G($_.barcode,$_.i,1));$P($_.checkbits,$_.i*4,$a([$_.indx&1,$_.indx>>>1&1,$_.indx>>>2&1,$_.indx>>>3]))}$_.checksalt=$a([1,1,1,1,0,1,0,0,1]);for(var _i=0,_h=$_.barlen*4-1;_i<=_h;_i+=1){$_.i=_i;if($g($_.checkbits,$_.i)==1){for(var _m=0;_m<=8;_m+=1){$_.j=_m;$p($_.checkbits,$_.i+$_.j,$xo($g($_.checkbits,$_.i+$_.j),$g($_.checksalt,$_.j)))}}}$_.checkval=0;for(var _x=0;_x<=7;_x+=1){$_.i=_x;$_.checkval=$f($_.checkval+~~$pow(2,$_.i)*$g($_.checkbits,$f($_.barlen*4+$_.i)))}$_.checksum1=$_.checkval&15;$_.checksum2=$_.checkval>>>4;if($_.validatecheck){if($g($_.barcode,$_.barlen)!=$g($_.barchars,$_.checksum1)||$g($_.barcode,$_.barlen+1)!=$g($_.barchars,$_.checksum2)){$k[$j++]="bwipp.plesseyBadCheckDigits#13848";$k[$j++]="Incorrect Plessey check digits provided";bwipp_raiseerror()}$_.barcode=$G($_.barcode,0,$_.barlen)}var _1O=$_.unidirectional?27:33;$_.sbs=$s($f($_.barlen*8+_1O));$_.txt=$a($_.barlen+2);$P($_.sbs,0,$g($_.encs,16));for(var _1X=0,_1W=$_.barlen-1;_1X<=_1W;_1X+=1){$_.i=_1X;$_.indx=$g($_.charvals,$G($_.barcode,$_.i,1));$P($_.sbs,$_.i*8+8,$g($_.encs,$_.indx));$p($_.txt,$_.i,$a([$G($_.barcode,$_.i,1),$_.i*20+20,$_.textyoffset,$_.textfont,$_.textsize]))}$P($_.sbs,$_.barlen*8+8,$g($_.encs,$_.checksum1));$P($_.sbs,$_.barlen*8+16,$g($_.encs,$_.checksum2));if($_.includecheckintext){$p($_.txt,$_.barlen,$a([$G($_.barchars,$_.checksum1,1),$_.barlen*20+20,$_.textyoffset,$_.textfont,$_.textsize]));$p($_.txt,$_.barlen+1,$a([$G($_.barchars,$_.checksum2,1),($_.barlen+1)*20+20,$_.textyoffset,$_.textfont,$_.textsize]))}else{$p($_.txt,$_.barlen,$a([" ",$_.barlen*20+20,$_.textyoffset,$_.textfont,$_.textsize]));$p($_.txt,$_.barlen+1,$a([" ",($_.barlen+1)*20+20,$_.textyoffset,$_.textfont,$_.textsize]))}var _2f=$_.unidirectional?18:17;$P($_.sbs,$_.barlen*8+24,$g($_.encs,_2f));$k[$j++]=Infinity;$k[$j++]=Infinity;var _2h=$_.sbs;for(var _2i=0,_2j=_2h.length;_2i<_2j;_2i++){$k[$j++]=$g(_2h,_2i)-48}var _2l=$a();$k[$j++]=Infinity;for(var _2n=0,_2o=~~(($_.sbs.length+1)/2);_2n<_2o;_2n++){$k[$j++]=$_.height}var _2q=$a();$k[$j++]=Infinity;for(var _2s=0,_2t=~~(($_.sbs.length+1)/2);_2s<_2t;_2s++){$k[$j++]=0}var _2u=$a();$k[$j++]="ren";$k[$j++]="renlinear";$k[$j++]="sbs";$k[$j++]=_2l;$k[$j++]="bhs";$k[$j++]=_2q;$k[$j++]="bbs";$k[$j++]=_2u;if($_.includetext){$k[$j++]="txt";$k[$j++]=$_.txt}$k[$j++]="opt";$k[$j++]=$_.options;var _2y=$d();$k[$j++]=_2y;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_telepen(){var $__=$_;$_=Object.assign({},$_);$_.numeric=false;$_.dontdraw=false;$_.includetext=false;$_.textfont="OCR-B";$_.textsize=10;$_.textyoffset=-8;$_.height=1;$_.parse=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];var _3=new Map([["parse",$_.parse],["parseonly",true],["parsefnc",false]]);$_.fncvals=_3;$k[$j++]="barcode";$k[$j++]=$_.barcode;$k[$j++]=$_.fncvals;bwipp_parseinput();var _6=$k[--$j];$_[$k[--$j]]=_6;$_.barlen=$_.barcode.length;delete $_.options["parse"];if($_.numeric&&$_.barlen%2!=0){$k[$j++]="bwipp.telepenNumericOddLength#13955";$k[$j++]="Telepen Numeric must have an even length";bwipp_raiseerror()}$_.encs=$a(["31313131","1131313111","33313111","1111313131","3111313111","11333131","13133131","111111313111","31333111","1131113131","33113131","1111333111","3111113131","1113133111","1311133111","111111113131","3131113111","11313331","333331","111131113111","31113331","1133113111","1313113111","1111113331","31131331","113111113111","3311113111","1111131331","311111113111","1113111331","1311111331","11111111113111","31313311","1131311131","33311131","1111313311","3111311131","11333311","13133311","111111311131","31331131","1131113311","33113311","1111331131","3111113311","1113131131","1311131131","111111113311","3131111131","1131131311","33131311","111131111131","3111131311","1133111131","1313111131","111111131311","3113111311","113111111131","3311111131","111113111311","311111111131","111311111311","131111111311","11111111111131","3131311111","11313133","333133","111131311111","31113133","1133311111","1313311111","1111113133","313333","113111311111","3311311111","11113333","311111311111","11131333","13111333","11111111311111","31311133","1131331111","33331111","1111311133","3111331111","11331133","13131133","111111331111","3113131111","1131111133","33111133","111113131111","3111111133","111311131111","131111131111","111111111133","31311313","113131111111","3331111111","1111311313","311131111111","11331313","13131313","11111131111111","3133111111","1131111313","33111313","111133111111","3111111313","111313111111","131113111111","111111111313","313111111111","1131131113","33131113","11113111111111","3111131113","113311111111","131311111111","111111131113","3113111113","11311111111111","331111111111","111113111113","31111111111111","111311111113","131111111113","1111111111111111"]);$_.sbs=$s($_.barlen*16+48);$_.txt=$a($_.barlen);$_.enc=$g($_.encs,95);$P($_.sbs,0,$_.enc);$_.l=$_.enc.length;$_.checksum=0;$_.i=0;$_.j=0;for(;;){if($_.i==$_.barlen){break}if($_.numeric){if($g($_.barcode,$_.i)>16){$_.np=$G($_.barcode,$_.i,2);var _X=$g($_.np,0);var _Z=$g($_.np,1);if(_X<48||_X>57||(_Z<48||_Z>57)&&!(_Z==88)){$k[$j++]=-1}else{var _e=$g($_.np,1)-48;$k[$j++]=$g($_.np,0)-48;$k[$j++]=_e;if(_e!=40){var _f=$k[--$j];var _g=$k[--$j];$k[$j++]=$f(_f+_g*10)+10}else{$j--}var _h=$k[--$j];$k[$j++]=_h+17}var _i=$k[$j-1];if(_i==-1){$k[$j++]="bwipp.telepenInvalidNumericCharacter#14021";$k[$j++]="Telepen Numeric may contain only digits, or X in even positions";bwipp_raiseerror()}$_.indx=$k[--$j];$p($_.txt,$_.j,$a([$_.np,$_.j*16+16,$_.textyoffset,$_.textfont,$_.textsize]));$_.i=$_.i+2}else{$_.indx=$g($_.barcode,$_.i);$p($_.txt,$_.j,$a([" ",$_.j*16+16,$_.textyoffset,$_.textfont,$_.textsize]));$_.i=$_.i+1}}else{$_.indx=$g($_.barcode,$_.i);if($_.indx>127){$k[$j++]="bwipp.telepenInvalidAlphaCharacter#14034";$k[$j++]="Telepen Alpha characters must have ordinal values 0 to 127";bwipp_raiseerror()}if($_.indx>=32&&$_.indx<=126){$p($_.txt,$_.j,$a([$G($_.barcode,$_.i,1),$_.j*16+16,$_.textyoffset,$_.textfont,$_.textsize]))}else{$p($_.txt,$_.j,$a([" ",$_.j*16+16,$_.textyoffset,$_.textfont,$_.textsize]))}$_.i=$_.i+1}$_.checksum=$f($_.checksum+$_.indx);$_.enc=$g($_.encs,$_.indx);$P($_.sbs,$_.l,$_.enc);$_.l=$_.l+$_.enc.length;$_.j=$_.j+1}$_.checksum=(127-$_.checksum%127)%127;$_.enc=$g($_.encs,$_.checksum);$P($_.sbs,$_.l,$_.enc);$_.l=$_.l+$_.enc.length;$_.enc=$g($_.encs,122);$P($_.sbs,$_.l,$_.enc);$_.l=$_.l+$_.enc.length;$_.sbs=$G($_.sbs,0,$_.l);$_.txt=$G($_.txt,0,$_.j);$k[$j++]=Infinity;$k[$j++]=Infinity;var _1z=$_.sbs;for(var _20=0,_21=_1z.length;_20<_21;_20++){$k[$j++]=$g(_1z,_20)-48}var _23=$a();$k[$j++]=Infinity;for(var _25=0,_26=~~(($_.sbs.length+1)/2);_25<_26;_25++){$k[$j++]=$_.height}var _28=$a();$k[$j++]=Infinity;for(var _2A=0,_2B=~~(($_.sbs.length+1)/2);_2A<_2B;_2A++){$k[$j++]=0}var _2C=$a();$k[$j++]="ren";$k[$j++]="renlinear";$k[$j++]="sbs";$k[$j++]=_23;$k[$j++]="bhs";$k[$j++]=_28;$k[$j++]="bbs";$k[$j++]=_2C;if($_.includetext){$k[$j++]="txt";$k[$j++]=$_.txt}$k[$j++]="opt";$k[$j++]=$_.options;var _2G=$d();$k[$j++]=_2G;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_telepennumeric(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];$p($_.options,"dontdraw",true);$p($_.options,"numeric",true);$k[$j++]="args";$k[$j++]=$_.barcode;$k[$j++]=$_.options;bwipp_telepen();var _6=$k[--$j];$_[$k[--$j]]=_6;$p($_.args,"opt",$_.options);$k[$j++]=$_.args;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_posicode(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.includetext=false;$_.textfont="OCR-B";$_.textsize=10;$_.textxoffset=0;$_.textyoffset=-8;$_.height=1;$_.encoding="auto";$_.version="a";$_.checkoffset=0;$_.raw=false;$_.parse=false;$_.parsefnc=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];var _1=$k[--$j];$_.barcode=_1;$_.la0=-1;$_.la1=-2;$_.la2=-3;$_.sf0=-4;$_.sf1=-5;$_.sf2=-6;$_.fn1=-7;$_.fn2=-8;$_.fn3=-9;$_.fn4=-10;var _r=$a([$_.sf1,$_.sf0,$_.fn3]);$_.charmapsnormal=$a([$a(["0","^","'"]),$a(["1",";",27]),$a(["2","<",28]),$a(["3","=",29]),$a(["4",">",30]),$a(["5","?",31]),$a(["6","@","!"]),$a(["7","[",'"']),$a(["8",92,"#"]),$a(["9","]","&"]),$a(["A","a",1]),$a(["B","b",2]),$a(["C","c",3]),$a(["D","d",4]),$a(["E","e",5]),$a(["F","f",6]),$a(["G","g",7]),$a(["H","h",8]),$a(["I","i",9]),$a(["J","j",10]),$a(["K","k",11]),$a(["L","l",12]),$a(["M","m",13]),$a(["N","n",14]),$a(["O","o",15]),$a(["P","p",16]),$a(["Q","q",17]),$a(["R","r",18]),$a(["S","s",19]),$a(["T","t",20]),$a(["U","u",21]),$a(["V","v",22]),$a(["W","w",23]),$a(["X","x",24]),$a(["Y","y",25]),$a(["Z","z",26]),$a(["-","_",40]),$a([".","`",41]),$a([" ",127,0]),$a(["$","{","*"]),$a(["/","|",","]),$a(["+","}",":"]),$a(["%","~",$_.fn1]),$a([$_.la1,$_.la0,$_.fn2]),_r,$a([$_.sf2,$_.sf2,$_.fn4])]);$_.chapmapslimited=$a([$a(["0",-98,-98]),$a(["1",-98,-98]),$a(["2",-98,-98]),$a(["3",-98,-98]),$a(["4",-98,-98]),$a(["5",-98,-98]),$a(["6",-98,-98]),$a(["7",-98,-98]),$a(["8",-98,-98]),$a(["9",-98,-98]),$a(["A",-98,-98]),$a(["B",-98,-98]),$a(["C",-98,-98]),$a(["D",-98,-98]),$a(["E",-98,-98]),$a(["F",-98,-98]),$a(["G",-98,-98]),$a(["H",-98,-98]),$a(["I",-98,-98]),$a(["J",-98,-98]),$a(["K",-98,-98]),$a(["L",-98,-98]),$a(["M",-98,-98]),$a(["N",-98,-98]),$a(["O",-98,-98]),$a(["P",-98,-98]),$a(["Q",-98,-98]),$a(["R",-98,-98]),$a(["S",-98,-98]),$a(["T",-98,-98]),$a(["U",-98,-98]),$a(["V",-98,-98]),$a(["W",-98,-98]),$a(["X",-98,-98]),$a(["Y",-98,-98]),$a(["Z",-98,-98]),$a(["-",-98,-98]),$a([".",-98,-98])]);if($ne($_.version,"a")&&$ne($_.version,"b")&&$ne($_.version,"limiteda")&&$ne($_.version,"limitedb")){$k[$j++]="bwipp.posicodeInvalidVersion#14226";$k[$j++]="The version must be either a, b, limiteda or limitedb";bwipp_raiseerror()}$k[$j++]="charmaps";if($eq($_.version,"a")||$eq($_.version,"b")){$k[$j++]=$_.charmapsnormal}else{$k[$j++]=$_.chapmapslimited}var _1j=$k[--$j];$_[$k[--$j]]=_1j;var _1l=$_.charmaps;var _1m=$_.charmaps;var _1n=$_.charmaps;$_.charvals=$a([new Map,new Map,new Map]);for(var _1r=0,_1q=$_.charmaps.length-1;_1r<=_1q;_1r+=1){$_.i=_1r;$_.encs=$g($_.charmaps,$_.i);for(var _1v=0;_1v<=2;_1v+=1){$_.j=_1v;var _1y=$g($_.encs,$_.j);$k[$j++]=_1y;if($eq($t(_1y),"stringtype")){var _21=$g($k[--$j],0);$k[$j++]=_21}$p($g($_.charvals,$_.j),$k[--$j],$_.i)}}$_.set0=$g($_.charvals,0);$_.set1=$g($_.charvals,1);$_.set2=$g($_.charvals,2);if($eq($_.version,"limiteda")||$eq($_.version,"limitedb")){for(var _2H=0,_2G=$_.barcode.length-1;_2H<=_2G;_2H+=1){var _2M=$g($_.set0,$g($G($_.barcode,_2H,1),0))!==undefined;if(!_2M){$k[$j++]="bwipp.posicodeBadCharacter#14252";$k[$j++]="Posicode limited must contain only digits, capital letters, and the symbols - and .";bwipp_raiseerror()}}}if($_.raw){$_.encoding="raw"}if($eq($_.encoding,"raw")){$_.cws=$a($_.barcode.length);$_.i=0;$_.j=0;for(;;){if($_.i==$_.barcode.length){break}$_.cw=$i($G($_.barcode,$_.i+1,3));$p($_.cws,$_.j,$_.cw);$_.i=$_.i+4;$_.j=$_.j+1}$_.cws=$G($_.cws,0,$_.j);$_.text=""}if($eq($_.encoding,"auto")){var _2k=new Map([["parse",$_.parse],["parsefnc",$_.parsefnc],["FNC1",$_.fn1],["FNC2",$_.fn2],["FNC3",$_.fn3]]);$_.fncvals=_2k;$k[$j++]="msg";$k[$j++]=$_.barcode;$k[$j++]=$_.fncvals;bwipp_parseinput();var _2n=$k[--$j];$_[$k[--$j]]=_2n;$_.msglen=$_.msg.length;$_.text=$s($_.msglen);for(var _2u=0,_2t=$_.msglen-1;_2u<=_2t;_2u+=1){$_.i=_2u;var _2z=$g($_.msg,$_.i);$k[$j++]=$_.text;$k[$j++]=$_.i;$k[$j++]=_2z;if(_2z<0){$k[$j-1]=32}var _30=$k[--$j];var _31=$k[--$j];$p($k[--$j],_31,_30)}$k[$j++]=Infinity;for(var _34=0,_35=$_.msglen;_34<_35;_34++){$k[$j++]=0}$k[$j++]=0;$_.numSA=$a();$k[$j++]=Infinity;for(var _38=0,_39=$_.msglen;_38<_39;_38++){$k[$j++]=0}$k[$j++]=0;$_.numEA=$a();for(var _3C=$_.msglen-1;_3C>=0;_3C-=1){$_.i=_3C;if($g($_.msg,$_.i)>=0){if($g($_.msg,$_.i)>=128){$p($_.numEA,$_.i,$g($_.numEA,$_.i+1)+1)}else{$p($_.numSA,$_.i,$g($_.numSA,$_.i+1)+1)}}}$_.ea=false;$_.msgtmp=$a([]);for(var _3W=0,_3V=$_.msglen-1;_3W<=_3V;_3W+=1){$_.i=_3W;$_.c=$g($_.msg,$_.i);if(!($_.ea!=$_.c<128)&&$_.c>=0){if($_.ea){$k[$j++]=$_.numSA}else{$k[$j++]=$_.numEA}var _3i=$g($k[--$j],$_.i);var _3l=$f(_3i+$_.i)==$_.msglen?3:5;if(_3i<_3l){$k[$j++]=Infinity;$q($_.msgtmp);$k[$j++]=$_.fn4;$_.msgtmp=$a()}else{$k[$j++]=Infinity;$q($_.msgtmp);$k[$j++]=$_.fn4;$k[$j++]=$_.fn4;$_.msgtmp=$a();$_.ea=!$_.ea}}$k[$j++]=Infinity;$q($_.msgtmp);if($_.c>=0){$k[$j++]=$_.c&127}else{$k[$j++]=$_.c}$_.msgtmp=$a()}$_.msg=$_.msgtmp;$_.msglen=$_.msg.length;$_.enc=function(){var _41=$k[--$j];$p($_.cws,$_.j,$g(_41,$k[--$j]));$_.j=$_.j+1};$_.cws=$a($_.msglen*2);$_.i=0;$_.j=0;$_.cset="set0";for(;;){if($_.i==$_.msglen){break}for(;;){$_.char1=$g($_.msg,$_.i);$k[$j++]="char2";if($_.i+1<$_.msglen){$k[$j++]=$g($_.msg,$_.i+1)}else{$k[$j++]=-99}var _4J=$k[--$j];$_[$k[--$j]]=_4J;var _4O=$g($_[$_.cset],$_.char1)!==undefined;if(_4O){$k[$j++]=$_.char1;$k[$j++]=$_[$_.cset];$_.enc();$_.i=$_.i+1;break}var _4V=$g($_.set2,$_.char1)!==undefined;if(_4V){$k[$j++]=$_.sf2;$k[$j++]=$_[$_.cset];$_.enc();$k[$j++]=$_.char1;$k[$j++]=$_.set2;$_.enc();$_.i=$_.i+1;break}var _4f=$g($_[$_.cset],$_.char2)!==undefined;if(!_4f){if($eq($_.cset,"set0")){$k[$j++]=$_.la1;$k[$j++]=$_[$_.cset];$_.enc();$_.cset="set1"}else{$k[$j++]=$_.la0;$k[$j++]=$_[$_.cset];$_.enc();$_.cset="set0"}break}else{if($eq($_.cset,"set0")){$k[$j++]=$_.sf1;$k[$j++]=$_[$_.cset];$_.enc();$k[$j++]=$_.char1;$k[$j++]=$_.set1;$_.enc()}else{$k[$j++]=$_.sf0;$k[$j++]=$_[$_.cset];$_.enc();$k[$j++]=$_.char1;$k[$j++]=$_.set0;$_.enc()}$_.i=$_.i+1;break}break}}$_.cws=$G($_.cws,0,$_.j)}var _56=new Map([["a",$a(["141112","131212","121312","111412","131113","121213","111313","121114","111214","111115","181111","171211","161311","151411","141511","131611","121711","111811","171112","161212","151312","141412","131512","121612","111712","161113","151213","141313","131413","121513","111613","151114","141214","131314","121414","111514","141115","131215","121315","111415","131116","121216","111316","121117","111217","111118","1<111112","111111111;1"])],["b",$a(["151213","141313","131413","121513","141214","131314","121414","131215","121315","121216","191212","181312","171412","161512","151612","141712","131812","121912","181213","171313","161413","151513","141613","131713","121813","171214","161314","151414","141514","131614","121714","161215","151315","141415","131515","121615","151216","141316","131416","121516","141217","131317","121417","131218","121318","121219","1<121312","121212121<1"])],["limiteda",$a(["111411","111312","111213","111114","121311","121212","121113","141111","131211","131112","171111","161211","151311","141411","131511","121611","111711","161112","151212","141312","131412","121512","111612","151113","141213","131313","121413","111513","141114","131214","121314","111414","131115","121215","111315","121116","111216","111117","151111","1"])],["limitedb",$a(["121512","121413","121314","121215","131412","131313","131214","151212","141312","141213","181212","171312","161412","151512","141612","131712","121812","171213","161313","151413","141513","131613","121713","161214","151314","141414","131514","121614","151215","141315","131415","121515","141216","131316","121416","131217","121317","121218","141212","1"])]]);$_.encmaps=_56;$_.encs=$g($_.encmaps,$_.version);$_.c2w=$a([$a([495,330,210,126,70,35,15,5]),$a([165,120,84,56,35,20,10,4]),$a([45,36,28,21,15,10,6,3]),$a([9,8,7,6,5,4,3,2]),$a([1,1,1,1,1,1,1,1])]);$_.v=0;var _5I=$_.cws;for(var _5J=0,_5K=_5I.length;_5J<_5K;_5J++){$_.cw=$g(_5I,_5J);for(var _5M=0;_5M<6;_5M++){if((($_.cw^$_.v)&1)!=0){$_.v=$_.v^7682}$_.v=$_.v>>>1;$_.cw=$_.cw>>>1}}$_.v=$_.v+$_.checkoffset;if($eq($_.version,"limiteda")||$eq($_.version,"limitedb")){$_.v=$_.v&1023;if($_.v>824&&$_.v<853){$_.v=$_.v+292}}else{$_.v=($_.v&1023)+45}$_.d=$a([2,2,2,2,2,2]);$_.r=0;$_.c=0;$_.w=0;$_.sum=0;for(;;){if($_.sum==$_.v){break}$_.t=$f($_.sum+$g($g($_.c2w,$_.r),$_.c));if($_.t==$_.v){$_.w=$_.w+1;$p($_.d,$_.r,$_.w+2);$_.sum=$_.t}if($_.t>$_.v){$p($_.d,$_.r,$_.w+2);$_.r=$_.r+1;$_.w=0}if($_.t<$_.v){$_.c=$_.c+1;$_.w=$_.w+1;$_.sum=$_.t}}$k[$j++]=20;for(var _62=0;_62<=4;_62+=1){var _65=$k[--$j];$k[$j++]=$f(_65-$g($_.d,_62))}$p($_.d,5,$k[--$j]);if($eq($_.version,"b")||$eq($_.version,"limitedb")){$k[$j++]=Infinity;var _6A=$_.d;for(var _6B=0,_6C=_6A.length;_6B<_6C;_6B++){$k[$j++]=$g(_6A,_6B)+1}$_.d=$a()}$_.cbs=$Z($s(12),"111111111111");for(var _6H=5;_6H>=0;_6H-=1){$_.i=_6H;$p($_.cbs,(5-$_.i)*2+1,$g($_.d,$_.i)+47)}$_.sbs=$s($_.cws.length*6+31);var _6R=$g($_.encs,$_.encs.length-2);$P($_.sbs,0,_6R);$_.j=_6R.length;for(var _6V=0,_6U=$_.cws.length-1;_6V<=_6U;_6V+=1){$_.i=_6V;$P($_.sbs,$_.j,$g($_.encs,$g($_.cws,$_.i)));$_.j=$_.j+6}$P($_.sbs,$_.j,$_.cbs);$_.j=$_.j+12;var _6k=$g($_.encs,$_.encs.length-1);$P($_.sbs,$_.j,_6k);$_.j=_6k.length+$_.j;$_.sbs=$G($_.sbs,0,$_.j);$k[$j++]=Infinity;$k[$j++]=Infinity;var _6r=$_.sbs;for(var _6s=0,_6t=_6r.length;_6s<_6t;_6s++){$k[$j++]=$g(_6r,_6s)-48}var _6v=$a();$k[$j++]=Infinity;for(var _6x=0,_6y=~~(($_.sbs.length+1)/2);_6x<_6y;_6x++){$k[$j++]=$_.height}var _70=$a();$k[$j++]=Infinity;for(var _72=0,_73=~~(($_.sbs.length+1)/2);_72<_73;_72++){$k[$j++]=0}var _74=$a();var _7C=new Map([["a",0],["b",0],["limiteda",12],["limitedb",13]]);var _7F=new Map([["a",0],["b",0],["limiteda",12],["limitedb",13]]);$k[$j++]="ren";$k[$j++]="renlinear";$k[$j++]="sbs";$k[$j++]=_6v;$k[$j++]="bhs";$k[$j++]=_70;$k[$j++]="bbs";$k[$j++]=_74;$k[$j++]="txt";$k[$j++]=$a([$a([$_.text,$_.textxoffset,$_.textyoffset,$_.textfont,$_.textsize])]);$k[$j++]="textxalign";$k[$j++]="center";$k[$j++]="borderleft";$k[$j++]=$g(_7C,$_.version);$k[$j++]="borderright";$k[$j++]=$g(_7F,$_.version);$k[$j++]="opt";$k[$j++]=$_.options;var _7J=$d();$k[$j++]=_7J;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_codablockf(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.rows=-1;$_.columns=8;$_.rowheight=10;$_.sepheight=1;$_.parse=false;$_.parsefnc=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.columns<4||$_.columns>62){$k[$j++]="bwipp.codablockfBadColumns#14582";$k[$j++]="Codablock F must have 4 to 62 columns";bwipp_raiseerror()}if($_.rows!=-1&&($_.rows<2||$_.rows>44)){$k[$j++]="bwipp.codablockfBadRows#14586";$k[$j++]="Codablock F must have 2 to 44 rows";bwipp_raiseerror()}if($_.rowheight<8){$k[$j++]="bwipp.codablockfBadRowHeight#14590";$k[$j++]="Codablock F must have rowheight of at least 8";bwipp_raiseerror()}if($_.sepheight<1){$k[$j++]="bwipp.codablockfBadSepHeight#14594";$k[$j++]="Codablock F must have sepheight of at least 1";bwipp_raiseerror()}$k[$j++]="c";if($_.columns>=4&&$_.columns<=62){$k[$j++]=$_.columns}else{$k[$j++]=8}var _C=$k[--$j];$_[$k[--$j]]=_C;$k[$j++]="rows";if($_.rows>=2&&$_.rows<=44){$k[$j++]=$_.rows}else{$k[$j++]=-1}var _H=$k[--$j];$_[$k[--$j]]=_H;$_.swa=-1;$_.swb=-2;$_.swc=-3;$_.sft=-4;$_.fn1=-5;$_.fn2=-6;$_.fn3=-7;$_.fn4=-8;$_.sta=-9;$_.stp=-10;var _N=new Map([["parse",$_.parse],["parsefnc",$_.parsefnc],["FNC1",$_.fn1],["FNC3",$_.fn3]]);$_.fncvals=_N;$k[$j++]="msg";$k[$j++]=$_.barcode;$k[$j++]=$_.fncvals;bwipp_parseinput();var _Q=$k[--$j];$_[$k[--$j]]=_Q;$_.msglen=$_.msg.length;$_.msgtmp=$a([]);var _U=$_.msg;for(var _V=0,_W=_U.length;_V<_W;_V++){$_.char=$g(_U,_V);$k[$j++]=Infinity;$q($_.msgtmp);if($_.char<128){$k[$j++]=$_.char}else{$k[$j++]=$_.fn4;$k[$j++]=$_.char&127}$_.msgtmp=$a()}$_.kmsg=$_.msg;$_.msg=$_.msgtmp;$_.msglen=$_.msg.length;$_.charmaps=$a([$a([32,32,"00"]),$a(["!","!","01"]),$a(['"','"',"02"]),$a(["#","#","03"]),$a(["$","$","04"]),$a(["%","%","05"]),$a(["&","&","06"]),$a(["'","'","07"]),$a([40,40,"08"]),$a([41,41,"09"]),$a(["*","*","10"]),$a(["+","+","11"]),$a([",",",","12"]),$a(["-","-","13"]),$a([".",".","14"]),$a(["/","/","15"]),$a(["0","0","16"]),$a(["1","1","17"]),$a(["2","2","18"]),$a(["3","3","19"]),$a(["4","4","20"]),$a(["5","5","21"]),$a(["6","6","22"]),$a(["7","7","23"]),$a(["8","8","24"]),$a(["9","9","25"]),$a([":",":","26"]),$a([";",";","27"]),$a(["<","<","28"]),$a(["=","=","29"]),$a([">",">","30"]),$a(["?","?","31"]),$a(["@","@","32"]),$a(["A","A","33"]),$a(["B","B","34"]),$a(["C","C","35"]),$a(["D","D","36"]),$a(["E","E","37"]),$a(["F","F","38"]),$a(["G","G","39"]),$a(["H","H","40"]),$a(["I","I","41"]),$a(["J","J","42"]),$a(["K","K","43"]),$a(["L","L","44"]),$a(["M","M","45"]),$a(["N","N","46"]),$a(["O","O","47"]),$a(["P","P","48"]),$a(["Q","Q","49"]),$a(["R","R","50"]),$a(["S","S","51"]),$a(["T","T","52"]),$a(["U","U","53"]),$a(["V","V","54"]),$a(["W","W","55"]),$a(["X","X","56"]),$a(["Y","Y","57"]),$a(["Z","Z","58"]),$a(["[","[","59"]),$a([92,92,"60"]),$a(["]","]","61"]),$a(["^","^","62"]),$a(["_","_","63"]),$a([0,"`","64"]),$a([1,"a","65"]),$a([2,"b","66"]),$a([3,"c","67"]),$a([4,"d","68"]),$a([5,"e","69"]),$a([6,"f","70"]),$a([7,"g","71"]),$a([8,"h","72"]),$a([9,"i","73"]),$a([10,"j","74"]),$a([11,"k","75"]),$a([12,"l","76"]),$a([13,"m","77"]),$a([14,"n","78"]),$a([15,"o","79"]),$a([16,"p","80"]),$a([17,"q","81"]),$a([18,"r","82"]),$a([19,"s","83"]),$a([20,"t","84"]),$a([21,"u","85"]),$a([22,"v","86"]),$a([23,"w","87"]),$a([24,"x","88"]),$a([25,"y","89"]),$a([26,"z","90"]),$a([27,"{","91"]),$a([28,"|","92"]),$a([29,"}","93"]),$a([30,"~","94"]),$a([31,127,"95"]),$a([$_.fn3,$_.fn3,"96"]),$a([$_.fn2,$_.fn2,"97"]),$a([$_.sft,$_.sft,"98"]),$a([$_.swc,$_.swc,"99"]),$a([$_.swb,$_.fn4,$_.swb]),$a([$_.fn4,$_.swa,$_.swa]),$a([$_.fn1,$_.fn1,$_.fn1]),$a([$_.sta,$_.sta,$_.sta]),$a([$_.stp,$_.stp,$_.stp])]);$_.charvals=$a([new Map,new Map,new Map]);for(var _2p=0,_2o=$_.charmaps.length-1;_2p<=_2o;_2p+=1){$_.i=_2p;$_.encs=$g($_.charmaps,$_.i);for(var _2t=0;_2t<=2;_2t+=1){$_.j=_2t;var _2w=$g($_.encs,$_.j);$k[$j++]=_2w;if($eq($t(_2w),"stringtype")){var _2z=$g($k[--$j],0);$k[$j++]=_2z}$p($g($_.charvals,$_.j),$k[--$j],$_.i)}}$_.seta=$g($_.charvals,0);$_.setb=$g($_.charvals,1);$_.setc=$g($_.charvals,2);$_.numsscr=function(){$_.n=0;$_.s=0;$_.p=$k[--$j];for(;;){if($_.p>=$_.msglen){break}if($_.p!=0){if($g($_.msg,$_.p-1)==$_.fn4){break}}var _3M=$g($_.msg,$_.p);var _3O=$g($_.setc,_3M)!==undefined;$k[$j++]=_3M;if(!_3O){$j--;break}if($k[--$j]==$_.fn1){if($_.s%2==0){$_.s=$_.s+1}else{break}}$_.n=$_.n+1;$_.s=$_.s+1;$_.p=$_.p+1}$k[$j++]=$_.n;$k[$j++]=$_.s};$_.enca=function(){$p($_.cws,$_.j,$g($_.seta,$k[--$j]));$_.j=$_.j+1};$_.encb=function(){$p($_.cws,$_.j,$g($_.setb,$k[--$j]));$_.j=$_.j+1};$_.encc=function(){var _3k=$k[$j-1];if($ne($t(_3k),"arraytype")){var _3o=$g($_.setc,$k[--$j]);$k[$j++]=_3o}else{$q($k[--$j]);var _3q=$k[--$j];var _3r=$k[--$j];$k[$j++]=$f(_3q-48+(_3r-48)*10)}$p($_.cws,$_.j,$k[--$j]);$_.j=$_.j+1};$_.anotb=function(){var _3w=$k[--$j];var _3y=$g($_.seta,_3w)!==undefined;var _40=$g($_.setb,_3w)!==undefined;$k[$j++]=_3y&&!_40};$_.bnota=function(){var _41=$k[--$j];var _43=$g($_.setb,_41)!==undefined;var _45=$g($_.seta,_41)!==undefined;$k[$j++]=_43&&!_45};$k[$j++]=Infinity;for(var _47=0,_48=$_.msg.length;_47<_48;_47++){$k[$j++]=0}$k[$j++]=9999;$_.nextanotb=$a();$k[$j++]=Infinity;for(var _4B=0,_4C=$_.msg.length;_4B<_4C;_4B++){$k[$j++]=0}$k[$j++]=9999;$_.nextbnota=$a();for(var _4F=$_.msg.length-1;_4F>=0;_4F-=1){$_.i=_4F;$k[$j++]=$g($_.msg,$_.i);$_.anotb();if($k[--$j]){$p($_.nextanotb,$_.i,0)}else{$p($_.nextanotb,$_.i,$g($_.nextanotb,$_.i+1)+1)}$k[$j++]=$g($_.msg,$_.i);$_.bnota();if($k[--$j]){$p($_.nextbnota,$_.i,0)}else{$p($_.nextbnota,$_.i,$g($_.nextbnota,$_.i+1)+1)}}$_.abeforeb=function(){var _4c=$k[--$j];$k[$j++]=$lt($g($_.nextanotb,_4c),$g($_.nextbnota,_4c))};$_.bbeforea=function(){var _4h=$k[--$j];$k[$j++]=$lt($g($_.nextbnota,_4h),$g($_.nextanotb,_4h))};$_.padrow=function(){for(var _4n=0,_4o=$k[--$j];_4n<_4o;_4n++){for(;;){if($eq($_.cset,"seta")){$k[$j++]=$_.swc;$_.enca();$_.cset="setc";break}if($eq($_.cset,"setb")){$k[$j++]=$_.swc;$_.encb();$_.cset="setc";break}if($eq($_.cset,"setc")){$k[$j++]=$_.swb;$_.encc();$_.cset="setb";break}}}};$_.encafitsrow=function(){if($_.rem<=2&&$g($_.msg,$_.i)==$_.fn4){var _54=$_.rem==2&&$g($_.msg,$_.i+1)<=95;$k[$j++]=_54;if(_54){$k[$j++]=$_.fn4;$_.enca();$k[$j++]=$g($_.msg,$_.i+1);$_.enca();$_.i=$_.i+2}}else{$k[$j++]=$g($_.msg,$_.i);$_.enca();$_.i=$_.i+1;$k[$j++]=true}};$_.encbfitsrow=function(){if($_.rem<=2&&$g($_.msg,$_.i)==$_.fn4){var _5N=$_.rem==2&&$g($_.msg,$_.i+1)>=32;$k[$j++]=_5N;if(_5N){$k[$j++]=$_.fn4;$_.encb();$k[$j++]=$g($_.msg,$_.i+1);$_.encb();$_.i=$_.i+2}}else{$k[$j++]=$g($_.msg,$_.i);$_.encb();$_.i=$_.i+1;$k[$j++]=true}};$_.cws=$a(($_.c+5)*44);$_.i=0;$_.j=0;$_.r=1;$_.lastrow=false;for(;;){if($_.lastrow){break}if($_.r>44){$k[$j++]="bwipp.codablockfTooBig#14803";$k[$j++]="Maximum length exceeded";bwipp_raiseerror()}$k[$j++]=$_.sta;$_.enca();if($_.i<$_.msglen){$k[$j++]=$_.i;$_.numsscr()}else{$k[$j++]=-1;$k[$j++]=-1}$_.nums=$k[--$j];$_.nchars=$k[--$j];for(;;){if($_.msglen==0){$k[$j++]=$_.swb;$_.enca();$_.cset="setb";break}if($_.nums>=2){$k[$j++]=$_.swc;$_.enca();$_.cset="setc";break}$k[$j++]=$_.i;$_.abeforeb();if($k[--$j]){$k[$j++]=$_.sft;$_.enca();$_.cset="seta";break}$k[$j++]=$_.swb;$_.enca();$_.cset="setb";break}$_.j=$_.j+1;$_.endofrow=false;for(;;){$_.rem=$f($_.c+3-$_.j%($_.c+5));if($_.i==$_.msglen||$_.endofrow){break}$k[$j++]=$_.i;$_.numsscr();$_.nums=$k[--$j];$_.nchars=$k[--$j];$k[$j++]="remnums";if($_.nums>$_.rem*2){$k[$j++]=$_.rem*2}else{$k[$j++]=$_.nums}var _63=$k[--$j];$_[$k[--$j]]=_63;for(;;){if(($eq($_.cset,"seta")||$eq($_.cset,"setb"))&&$_.remnums>=4&&$g($_.msg,$_.i)!=$_.fn1){if($_.remnums%2==0&&$_.rem>=3){$k[$j++]=$_.swc;if($eq($_.cset,"seta")){$_.enca()}else{$_.encb()}$_.cset="setc";for(var _6G=0;_6G<2;_6G++){if($g($_.msg,$_.i)==$_.fn1){$k[$j++]=$_.fn1;$_.encc();$_.i=$_.i+1}else{$k[$j++]=$G($_.msg,$_.i,2);$_.encc();$_.i=$_.i+2}}break}if($_.remnums%2!=0&&$_.rem>=4){$k[$j++]=$g($_.msg,$_.i);if($eq($_.cset,"seta")){$_.enca()}else{$_.encb()}$_.i=$_.i+1;$k[$j++]=$_.swc;if($eq($_.cset,"seta")){$_.enca()}else{$_.encb()}$_.cset="setc";for(var _6a=0;_6a<2;_6a++){if($g($_.msg,$_.i)==$_.fn1){$k[$j++]=$_.fn1;$_.encc();$_.i=$_.i+1}else{$k[$j++]=$G($_.msg,$_.i,2);$_.encc();$_.i=$_.i+2}}break}}$k[$j++]=$eq($_.cset,"setb");$k[$j++]=$g($_.msg,$_.i);$_.anotb();var _6p=$k[--$j];var _6q=$k[--$j];if(_6q&&_6p&&$_.rem>=2){if($_.i<$_.msglen-1){$k[$j++]=$_.i+1;$_.bbeforea();if($k[--$j]){$k[$j++]=$_.sft;$_.encb();$k[$j++]=$g($_.msg,$_.i);$_.enca();$_.i=$_.i+1;break}}$k[$j++]=$_.swa;$_.encb();$_.cset="seta";$k[$j++]=$g($_.msg,$_.i);$_.enca();$_.i=$_.i+1;break}$k[$j++]=$eq($_.cset,"seta");$k[$j++]=$g($_.msg,$_.i);$_.bnota();var _7A=$k[--$j];var _7B=$k[--$j];if(_7B&&_7A&&$_.rem>=2){if($_.i<$_.msglen-1){$k[$j++]=$_.i+1;$_.abeforeb();if($k[--$j]){$k[$j++]=$_.sft;$_.enca();$k[$j++]=$g($_.msg,$_.i);$_.encb();$_.i=$_.i+1;break}}$k[$j++]=$_.swb;$_.enca();$_.cset="setb";$k[$j++]=$g($_.msg,$_.i);$_.encb();$_.i=$_.i+1;break}if($eq($_.cset,"setc")&&$_.remnums<2&&$_.rem>=2){$_.rem=$_.rem-1;$k[$j++]=$_.i;$_.abeforeb();if($k[--$j]){$k[$j++]=$_.swa;$_.encc();$_.cset="seta";$_.encafitsrow();if($k[--$j]){break}}else{$k[$j++]=$_.swb;$_.encc();$_.cset="setb";$_.encbfitsrow();if($k[--$j]){break}}}var _7g=$g($_.seta,$g($_.msg,$_.i))!==undefined;if($eq($_.cset,"seta")&&_7g&&$_.rem>=1){$_.encafitsrow();if($k[--$j]){break}}var _7o=$g($_.setb,$g($_.msg,$_.i))!==undefined;if($eq($_.cset,"setb")&&_7o&&$_.rem>=1){$_.encbfitsrow();if($k[--$j]){break}}if($eq($_.cset,"setc")&&$_.remnums>=2&&$_.rem>=1){if($g($_.msg,$_.i)==$_.fn1){$k[$j++]=$_.fn1;$_.encc();$_.i=$_.i+1}else{$k[$j++]=$G($_.msg,$_.i,2);$_.encc();$_.i=$_.i+2}break}$_.endofrow=true;break}}if(($_.r>=$_.rows||$_.rows==-1)&&$_.r>1&&$_.i==$_.msglen&&$_.rem>=2){$k[$j++]=$_.rem-2;$_.padrow();$_.j=$_.j+3;$k[$j++]=$_.stp;$_.enca();$_.lastrow=true}else{$k[$j++]=$_.rem;$_.padrow();$_.j=$_.j+1;$k[$j++]=$_.stp;$_.enca();$_.r=$_.r+1}}$_.cws=$G($_.cws,0,$_.j);$k[$j++]=Infinity;for(var _8L=64;_8L<=95;_8L+=1){$k[$j++]=_8L}for(var _8M=0;_8M<=15;_8M+=1){$k[$j++]=_8M}for(var _8N=26;_8N<=63;_8N+=1){$k[$j++]=_8N}$_.abmap=$a();$k[$j++]=Infinity;for(var _8P=0;_8P<=85;_8P+=1){$k[$j++]=_8P}$_.cmap=$a();$_.chkmsg=$a($_.kmsg.length);$_.j=0;for(var _8W=0,_8V=$_.kmsg.length-1;_8W<=_8V;_8W+=1){$_.i=_8W;$_.char=$g($_.kmsg,$_.i);if($_.char>=0){$p($_.chkmsg,$_.j,$_.char);$_.j=$_.j+1}if($_.char==$_.fn1&&$_.i!=0){$p($_.chkmsg,$_.j,29);$_.j=$_.j+1}}$_.t1=0;$_.t2=0;$_.k1=0;$_.k2=0;for(var _8n=0,_8m=$_.j-1;_8n<=_8m;_8n+=1){$_.i=_8n;$_.t1=$g($_.chkmsg,$_.i)*$_.i%86;$_.t2=$f($_.t1+$g($_.chkmsg,$_.i))%86;$_.k1=$f($_.k1+$_.t2)%86;$_.k2=$f($_.k2+$_.t1)%86}$k[$j++]=$_.cws;$k[$j++]=$_.cws.length-4;if($ne($_.cset,"setc")){$k[$j++]=$_.abmap}else{$k[$j++]=$_.cmap}var _97=$g($k[--$j],$_.k1);var _98=$k[--$j];$p($k[--$j],_98,_97);$k[$j++]=$_.cws;$k[$j++]=$_.cws.length-3;if($ne($_.cset,"setc")){$k[$j++]=$_.abmap}else{$k[$j++]=$_.cmap}var _9H=$g($k[--$j],$_.k2);var _9I=$k[--$j];$p($k[--$j],_9I,_9H);var _9K=$_.cws;$k[$j++]=_9K;$k[$j++]=2;if($g(_9K,2-1)!=99){$k[$j++]=$_.abmap}else{$k[$j++]=$_.cmap}var _9Q=$g($k[--$j],$_.r-2);var _9R=$k[--$j];$p($k[--$j],_9R,_9Q);for(var _9V=1,_9U=$_.r-1;_9V<=_9U;_9V+=1){$_.i=_9V;var _9W=$_.cws;var _9X=$_.i;var _9Y=$_.c;$k[$j++]=_9W;$k[$j++]=_9X*(_9Y+5)+2;if($g(_9W,_9X*(_9Y+5)+2-1)!=99){$k[$j++]=$_.abmap}else{$k[$j++]=$_.cmap}var _9e=$g($k[--$j],$_.i+42);var _9f=$k[--$j];$p($k[--$j],_9f,_9e)}for(var _9j=0,_9i=$_.r-1;_9j<=_9i;_9j+=1){$_.rcws=$G($_.cws,_9j*($_.c+5),$_.c+4);$_.csum=$g($_.rcws,0);for(var _9s=1,_9r=$_.rcws.length-2;_9s<=_9r;_9s+=1){$_.i=_9s;$_.csum=$f($_.csum+$g($_.rcws,$_.i)*$_.i)}$p($_.rcws,$_.rcws.length-1,$_.csum%103)}var _A2=$g($_.options,"debugcws")!==undefined;if(_A2){$k[$j++]="bwipp.debugcws#15016";$k[$j++]=$_.cws;bwipp_raiseerror()}$_.encs=$a(["212222","222122","222221","121223","121322","131222","122213","122312","132212","221213","221312","231212","112232","122132","122231","113222","123122","123221","223211","221132","221231","213212","223112","312131","311222","321122","321221","312212","322112","322211","212123","212321","232121","111323","131123","131321","112313","132113","132311","211313","231113","231311","112133","112331","132131","113123","113321","133121","313121","211331","231131","213113","213311","213131","311123","311321","331121","312113","312311","332111","314111","221411","431111","111224","111422","121124","121421","141122","141221","112214","112412","122114","122411","142112","142211","241211","221114","413111","241112","134111","111242","121142","121241","114212","124112","124211","411212","421112","421211","212141","214121","412121","111143","111341","131141","114113","114311","411113","411311","113141","114131","311141","411131","211412","2331112"]);$_.rowbits=$a($_.r);for(var _AA=0,_A9=$_.r-1;_AA<=_A9;_AA+=1){$_.i=_AA;$k[$j++]=Infinity;var _AF=$G($_.cws,$_.i*($_.c+5),$_.c+5);for(var _AG=0,_AH=_AF.length;_AG<_AH;_AG++){$F($g($_.encs,$g(_AF,_AG)),function(){var _AL=$k[--$j];$k[$j++]=_AL-48})}$_.sbs=$a();$k[$j++]=Infinity;var _AN=$_.sbs;$k[$j++]=0;for(var _AO=0,_AP=_AN.length;_AO<_AP;_AO++){var _AR=$k[$j-1];var _AS=_AR==1?0:1;for(var _AT=0,_AU=$g(_AN,_AO);_AT<_AU;_AT++){$k[$j++]=_AS}}$as($a($m()-1));var _AX=$k[--$j];$k[$j-1]=_AX;var _AZ=$k[--$j];$k[$j-1]=_AZ;$k[$j++]=$_.rowbits;$k[$j++]=$_.i;var _Ad=$k[$j-3];var _Ae=$k[$j-1];$p($k[$j-2],_Ae,_Ad);$j-=3}$_.symwid=$_.c*11+57;$k[$j++]=Infinity;for(var _Aj=0,_Ak=$_.symwid*$_.sepheight;_Aj<_Ak;_Aj++){$k[$j++]=1}for(var _An=0,_Am=$_.r-2;_An<=_Am;_An+=1){$_.i=_An;for(var _Ap=0,_Aq=$_.rowheight;_Ap<_Aq;_Ap++){$q($g($_.rowbits,$_.i))}for(var _Av=0,_Aw=$_.sepheight;_Av<_Aw;_Av++){$k[$j++]=1;$k[$j++]=1;$k[$j++]=0;$k[$j++]=1;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=1;$k[$j++]=0;$k[$j++]=0;for(var _Ay=0,_Az=$_.symwid-24;_Ay<_Az;_Ay++){$k[$j++]=1}$k[$j++]=1;$k[$j++]=1;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$k[$j++]=0;$k[$j++]=1;$k[$j++]=0;$k[$j++]=1;$k[$j++]=1}}for(var _B1=0,_B2=$_.rowheight;_B1<_B2;_B1++){$q($g($_.rowbits,$_.r-1))}for(var _B8=0,_B9=$_.symwid*$_.sepheight;_B8<_B9;_B8++){$k[$j++]=1}$_.pixs=$a();var _BJ=new Map([["ren","renmatrix"],["pixs",$_.pixs],["pixx",$_.symwid],["pixy",~~($_.pixs.length/$_.symwid)],["height",~~($_.pixs.length/$_.symwid)/72],["width",$_.symwid/72],["opt",$_.options]]);$k[$j++]=_BJ;if(!$_.dontdraw){bwipp_renmatrix()}$_=$__}function bwipp_code16k(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.sam=-1;$_.rows=0;$_.rowheight=8;$_.sepheight=1;$_.raw=false;$_.parse=false;$_.parsefnc=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.rows!=0&&($_.rows<2||$_.rows>16)){$k[$j++]="bwipp.code16kBadRows#15133";$k[$j++]="Code 16K must have 2 to 16 rows";bwipp_raiseerror()}if($_.rowheight<8){$k[$j++]="bwipp.code16kBadRowHeight#15137";$k[$j++]="Code 16K must have rowheight of at least 8";bwipp_raiseerror()}if($_.sepheight<1){$k[$j++]="bwipp.code16kBadSepHeight#15141";$k[$j++]="Code 16K must have sepheight of at least 1";bwipp_raiseerror()}if($_.sam!=-1){$k[$j++]=true;for(var _8=0;_8<1;_8++){var _9=$_.sam;if(_9<12||_9>99){$k[$j-1]=false;break}if($_.sam%10<2){$k[$j-1]=false;break}if(~~($_.sam/10)>$_.sam%10){$k[$j-1]=false;break}}if(!$k[--$j]){$k[$j++]="bwipp.code16kBadSAM#15152";$k[$j++]='SAM must be formatted as "NM" for Nth of M symbols, from 2 to 9 symbols';bwipp_raiseerror()}}if($_.sam!=-1){$_.rows=16}$_.swa=-1;$_.swb=-2;$_.swc=-3;$_.sa1=-4;$_.sb1=-5;$_.sc1=-6;$_.sa2=-7;$_.sb2=-8;$_.sc2=-9;$_.pad=-10;$_.sb3=-11;$_.sc3=-12;$_.fn1=-13;$_.fn2=-14;$_.fn3=-15;$_.fn4=-16;$_.charmaps=$a([$a([32,32,"00"]),$a(["!","!","01"]),$a(['"','"',"02"]),$a(["#","#","03"]),$a(["$","$","04"]),$a(["%","%","05"]),$a(["&","&","06"]),$a(["'","'","07"]),$a([40,40,"08"]),$a([41,41,"09"]),$a(["*","*","10"]),$a(["+","+","11"]),$a([",",",","12"]),$a(["-","-","13"]),$a([".",".","14"]),$a(["/","/","15"]),$a(["0","0","16"]),$a(["1","1","17"]),$a(["2","2","18"]),$a(["3","3","19"]),$a(["4","4","20"]),$a(["5","5","21"]),$a(["6","6","22"]),$a(["7","7","23"]),$a(["8","8","24"]),$a(["9","9","25"]),$a([":",":","26"]),$a([";",";","27"]),$a(["<","<","28"]),$a(["=","=","29"]),$a([">",">","30"]),$a(["?","?","31"]),$a(["@","@","32"]),$a(["A","A","33"]),$a(["B","B","34"]),$a(["C","C","35"]),$a(["D","D","36"]),$a(["E","E","37"]),$a(["F","F","38"]),$a(["G","G","39"]),$a(["H","H","40"]),$a(["I","I","41"]),$a(["J","J","42"]),$a(["K","K","43"]),$a(["L","L","44"]),$a(["M","M","45"]),$a(["N","N","46"]),$a(["O","O","47"]),$a(["P","P","48"]),$a(["Q","Q","49"]),$a(["R","R","50"]),$a(["S","S","51"]),$a(["T","T","52"]),$a(["U","U","53"]),$a(["V","V","54"]),$a(["W","W","55"]),$a(["X","X","56"]),$a(["Y","Y","57"]),$a(["Z","Z","58"]),$a(["[","[","59"]),$a([92,92,"60"]),$a(["]","]","61"]),$a(["^","^","62"]),$a(["_","_","63"]),$a([0,"`","64"]),$a([1,"a","65"]),$a([2,"b","66"]),$a([3,"c","67"]),$a([4,"d","68"]),$a([5,"e","69"]),$a([6,"f","70"]),$a([7,"g","71"]),$a([8,"h","72"]),$a([9,"i","73"]),$a([10,"j","74"]),$a([11,"k","75"]),$a([12,"l","76"]),$a([13,"m","77"]),$a([14,"n","78"]),$a([15,"o","79"]),$a([16,"p","80"]),$a([17,"q","81"]),$a([18,"r","82"]),$a([19,"s","83"]),$a([20,"t","84"]),$a([21,"u","85"]),$a([22,"v","86"]),$a([23,"w","87"]),$a([24,"x","88"]),$a([25,"y","89"]),$a([26,"z","90"]),$a([27,"{","91"]),$a([28,"|","92"]),$a([29,"}","93"]),$a([30,"~","94"]),$a([31,127,"95"]),$a([$_.fn3,$_.fn3,"96"]),$a([$_.fn2,$_.fn2,"97"]),$a([$_.sb1,$_.sa1,"98"]),$a([$_.swc,$_.swc,"99"]),$a([$_.swb,$_.fn4,$_.swb]),$a([$_.fn4,$_.swa,$_.swa]),$a([$_.fn1,$_.fn1,$_.fn1]),$a([$_.pad,$_.pad,$_.pad]),$a([$_.sb2,$_.sa2,$_.sb1]),$a([$_.sc2,$_.sc2,$_.sb2]),$a([$_.sc3,$_.sc3,$_.sb3])]);$_.charvals=$a([new Map,new Map,new Map]);for(var _2V=0,_2U=$_.charmaps.length-1;_2V<=_2U;_2V+=1){$_.i=_2V;$_.encs=$g($_.charmaps,$_.i);for(var _2Z=0;_2Z<=2;_2Z+=1){$_.j=_2Z;var _2c=$g($_.encs,$_.j);$k[$j++]=_2c;if($eq($t(_2c),"stringtype")){var _2f=$g($k[--$j],0);$k[$j++]=_2f}$p($g($_.charvals,$_.j),$k[--$j],$_.i)}}$_.seta=$g($_.charvals,0);$_.setb=$g($_.charvals,1);$_.setc=$g($_.charvals,2);if($_.raw){$_.cws=$a($_.barcode.length);$_.i=0;$_.j=0;for(;;){if($_.i>=$_.barcode.length-3){break}if($g($_.barcode,$_.i)!=94){break}var _32=$G($_.barcode,$_.i+1,3);$k[$j++]=_32;$k[$j++]=false;for(var _33=0,_34=_32.length;_33<_34;_33++){var _35=$g(_32,_33);if(_35<48||_35>57){$k[$j-1]=true}}if($k[--$j]){$j--;break}$_.cw=$i($k[--$j]);$p($_.cws,$_.j,$_.cw);$_.i=$_.i+4;$_.j=$_.j+1}if($_.i!=$_.barcode.length){$k[$j++]="bwipp.code16kBadRawFormat#15241";$k[$j++]="raw data must be formatted as ^NNN";bwipp_raiseerror()}$_.cws=$G($_.cws,0,$_.j)}else{var _3N=new Map([["parse",$_.parse],["parsefnc",$_.parsefnc],["eci",true],["FNC1",$_.fn1],["FNC2",$_.fn2],["FNC3",$_.fn3]]);$_.fncvals=_3N;$k[$j++]="msg";$k[$j++]=$_.barcode;$k[$j++]=$_.fncvals;bwipp_parseinput();var _3Q=$k[--$j];$_[$k[--$j]]=_3Q;$_.msglen=$_.msg.length;$k[$j++]=Infinity;for(var _3U=0,_3V=$_.msglen;_3U<_3V;_3U++){$k[$j++]=0}$k[$j++]=0;$_.numSA=$a();$k[$j++]=Infinity;for(var _3Y=0,_3Z=$_.msglen;_3Y<_3Z;_3Y++){$k[$j++]=0}$k[$j++]=0;$_.numEA=$a();for(var _3c=$_.msglen-1;_3c>=0;_3c-=1){$_.i=_3c;if($g($_.msg,$_.i)>=0){if($g($_.msg,$_.i)>=128){$p($_.numEA,$_.i,$g($_.numEA,$_.i+1)+1)}else{$p($_.numSA,$_.i,$g($_.numSA,$_.i+1)+1)}}}$_.ea=false;$_.msgtmp=$a([]);for(var _3w=0,_3v=$_.msglen-1;_3w<=_3v;_3w+=1){$_.i=_3w;$_.c=$g($_.msg,$_.i);if(!($_.ea!=$_.c<128)&&$_.c>=0){if($_.ea){$k[$j++]=$_.numSA}else{$k[$j++]=$_.numEA}var _48=$g($k[--$j],$_.i);var _4B=$f(_48+$_.i)==$_.msglen?3:5;if(_48<_4B){$k[$j++]=Infinity;$q($_.msgtmp);$k[$j++]=$_.fn4;$_.msgtmp=$a()}else{$k[$j++]=Infinity;$q($_.msgtmp);$k[$j++]=$_.fn4;$k[$j++]=$_.fn4;$_.msgtmp=$a();$_.ea=!$_.ea}}$k[$j++]=Infinity;$q($_.msgtmp);if($_.c>=0){$k[$j++]=$_.c&127}else{$k[$j++]=$_.c}$_.msgtmp=$a()}$_.msg=$_.msgtmp;$_.msglen=$_.msg.length;$_.numsscr=function(){$_.n=0;$_.s=0;$_.p=$k[--$j];for(;;){if($_.p>=$_.msglen){break}var _4W=$g($_.msg,$_.p);var _4Y=$g($_.setc,_4W)!==undefined;$k[$j++]=_4W;if(!_4Y){$j--;break}if($k[--$j]==$_.fn1){if($_.s%2==0){$_.s=$_.s+1}else{break}}$_.n=$_.n+1;$_.s=$_.s+1;$_.p=$_.p+1}$k[$j++]=$_.n;$k[$j++]=$_.s};$_.enca=function(){$p($_.cws,$_.j,$g($_.seta,$k[--$j]));$_.j=$_.j+1};$_.encb=function(){$p($_.cws,$_.j,$g($_.setb,$k[--$j]));$_.j=$_.j+1};$_.encc=function(){var _4u=$k[$j-1];if($ne($t(_4u),"arraytype")){var _4y=$g($_.setc,$k[--$j]);$k[$j++]=_4y}else{$q($k[--$j]);var _50=$k[--$j];var _51=$k[--$j];$k[$j++]=$f(_50-48+(_51-48)*10)}$p($_.cws,$_.j,$k[--$j]);$_.j=$_.j+1};$_.anotb=function(){var _56=$k[--$j];var _58=$g($_.seta,_56)!==undefined;var _5A=$g($_.setb,_56)!==undefined;$k[$j++]=_58&&!_5A};$_.bnota=function(){var _5B=$k[--$j];var _5D=$g($_.setb,_5B)!==undefined;var _5F=$g($_.seta,_5B)!==undefined;$k[$j++]=_5D&&!_5F};$k[$j++]=Infinity;for(var _5H=0,_5I=$_.msg.length;_5H<_5I;_5H++){$k[$j++]=0}$k[$j++]=9999;$_.nextanotb=$a();$k[$j++]=Infinity;for(var _5L=0,_5M=$_.msg.length;_5L<_5M;_5L++){$k[$j++]=0}$k[$j++]=9999;$_.nextbnota=$a();for(var _5P=$_.msg.length-1;_5P>=0;_5P-=1){$_.i=_5P;$k[$j++]=$g($_.msg,$_.i);$_.anotb();if($k[--$j]){$p($_.nextanotb,$_.i,0)}else{$p($_.nextanotb,$_.i,$g($_.nextanotb,$_.i+1)+1)}$k[$j++]=$g($_.msg,$_.i);$_.bnota();if($k[--$j]){$p($_.nextbnota,$_.i,0)}else{$p($_.nextbnota,$_.i,$g($_.nextbnota,$_.i+1)+1)}}$_.abeforeb=function(){var _5m=$k[--$j];$k[$j++]=$lt($g($_.nextanotb,_5m),$g($_.nextbnota,_5m))};$_.bbeforea=function(){var _5r=$k[--$j];$k[$j++]=$lt($g($_.nextbnota,_5r),$g($_.nextanotb,_5r))};$_.cws=$a($_.barcode.length*2+3);$_.i=0;$_.j=0;for(;;){if($_.sam!=-1){$p($_.cws,0,~~($_.sam/10)-1);$p($_.cws,1,$_.sam%10-1);$_.j=2;$_.cset="setb";$_.mode=7;break}if($_.msglen==0){$_.cset="setb";$_.mode=1;break}if($_.msglen>=2){$k[$j++]=$g($_.msg,0)==$_.fn1;$k[$j++]=1;$_.numsscr();var _68=$k[--$j];$k[$j-1]=_68;var _6A=$k[--$j];var _6B=$k[--$j];if(_6B&&_6A>=2){$_.cset="setc";$_.mode=4;$_.i=1;break}}if($g($_.msg,0)==$_.fn1){$_.cset="setb";$_.mode=3;$_.i=1;break}if($_.msglen>=2){$k[$j++]=0;$_.numsscr();var _6G=$k[--$j];$k[$j-1]=_6G;var _6I=$k[--$j];if(_6I>=2&&_6I%2==0){$_.cset="setc";$_.mode=2;break}$k[$j++]=0;$_.numsscr();var _6J=$k[--$j];$k[$j-1]=_6J;var _6L=$k[--$j];if(_6L>=3&&_6L%2==1){$k[$j++]=$g($_.msg,0);$_.encb();$_.cset="setc";$_.mode=5;$_.i=1;break}var _6R=$g($_.setb,$g($_.msg,0))!==undefined;$k[$j++]=_6R;$k[$j++]=1;$_.numsscr();var _6S=$k[--$j];$k[$j-1]=_6S;var _6U=$k[--$j];var _6V=$k[--$j];if(_6V&&(_6U>=2&&_6U%2==0)){$k[$j++]=$g($_.msg,0);$_.encb();$_.cset="setc";$_.mode=5;$_.i=1;break}var _6b=$g($_.setb,$g($_.msg,0))!==undefined;$k[$j++]=_6b;$k[$j++]=1;$_.numsscr();var _6c=$k[--$j];$k[$j-1]=_6c;var _6e=$k[--$j];var _6f=$k[--$j];if(_6f&&(_6e>=3&&_6e%2==1)){$k[$j++]=$g($_.msg,0);$_.encb();$k[$j++]=$g($_.msg,1);$_.encb();$_.cset="setc";$_.mode=6;$_.i=2;break}var _6n=$g($_.setb,$g($_.msg,0))!==undefined;var _6r=$g($_.setb,$g($_.msg,1))!==undefined;$k[$j++]=_6n&&_6r;$k[$j++]=2;$_.numsscr();var _6s=$k[--$j];$k[$j-1]=_6s;var _6u=$k[--$j];var _6v=$k[--$j];if(_6v&&(_6u>=2&&_6u%2==0)){$k[$j++]=$g($_.msg,0);$_.encb();$k[$j++]=$g($_.msg,1);$_.encb();$_.cset="setc";$_.mode=6;$_.i=2;break}}$k[$j++]=0;$_.abeforeb();if($k[--$j]){$_.cset="seta";$_.mode=0;break}$_.cset="setb";$_.mode=1;break}for(;;){if($_.i==$_.msglen){break}$k[$j++]=$_.i;$_.numsscr();$_.nums=$k[--$j];$_.nchars=$k[--$j];for(;;){if($eq($_.cset,"seta")){if($_.i<$_.msglen-1){$k[$j++]=$g($_.msg,$_.i);$_.bnota();$k[$j++]=$_.i+1;$_.abeforeb();var _7D=$k[--$j];if($k[--$j]&&_7D){$k[$j++]=$_.sb1;$_.enca();$k[$j++]=$g($_.msg,$_.i);$_.encb();$_.i=$_.i+1;break}}if($_.i<$_.msglen-2){$k[$j++]=$g($_.msg,$_.i);$_.bnota();$k[$j++]=$g($_.msg,$_.i+1);$_.bnota();var _7S=$k[--$j];var _7T=$k[--$j];$k[$j++]=$an(_7T,_7S);$k[$j++]=$_.i+2;$_.abeforeb();var _7V=$k[--$j];if($k[--$j]&&_7V){$k[$j++]=$_.sb2;$_.enca();$k[$j++]=$g($_.msg,$_.i);$_.encb();$k[$j++]=$g($_.msg,$_.i+1);$_.encb();$_.i=$_.i+2;break}}$k[$j++]=$g($_.msg,$_.i);$_.bnota();if($k[--$j]){$k[$j++]=$_.swb;$_.enca();$_.cset="setb";break}if($_.i<$_.msglen-4){var _7r=$g($_.seta,$g($_.msg,$_.i+4))!==undefined;if($_.nums==4&&_7r){$k[$j++]=$_.sc2;$_.enca();for(var _7t=0;_7t<2;_7t++){if($g($_.msg,$_.i)==$_.fn1){$k[$j++]=$_.fn1;$_.encc();$_.i=$_.i+1}else{$k[$j++]=$G($_.msg,$_.i,2);$_.encc();$_.i=$_.i+2}}break}}if($_.i<$_.msglen-6){var _8B=$g($_.seta,$g($_.msg,$_.i+6))!==undefined;if($_.nums==6&&_8B){$k[$j++]=$_.sc3;$_.enca();for(var _8D=0;_8D<3;_8D++){if($g($_.msg,$_.i)==$_.fn1){$k[$j++]=$_.fn1;$_.encc();$_.i=$_.i+1}else{$k[$j++]=$G($_.msg,$_.i,2);$_.encc();$_.i=$_.i+2}}break}}if($_.nums>=4&&$_.nums%2==0){$k[$j++]=$_.swc;$_.enca();$_.cset="setc";break}$k[$j++]=$g($_.msg,$_.i);$_.enca();$_.i=$_.i+1;break}if($eq($_.cset,"setb")){if($_.i<$_.msglen-1){$k[$j++]=$g($_.msg,$_.i);$_.anotb();$k[$j++]=$_.i+1;$_.bbeforea();var _8c=$k[--$j];if($k[--$j]&&_8c){$k[$j++]=$_.sa1;$_.encb();$k[$j++]=$g($_.msg,$_.i);$_.enca();$_.i=$_.i+1;break}}if($_.i<$_.msglen-2){$k[$j++]=$g($_.msg,$_.i);$_.anotb();$k[$j++]=$g($_.msg,$_.i+1);$_.anotb();var _8r=$k[--$j];var _8s=$k[--$j];$k[$j++]=$an(_8s,_8r);$k[$j++]=$_.i+2;$_.bbeforea();var _8u=$k[--$j];if($k[--$j]&&_8u){$k[$j++]=$_.sa2;$_.encb();$k[$j++]=$g($_.msg,$_.i);$_.enca();$k[$j++]=$g($_.msg,$_.i+1);$_.enca();$_.i=$_.i+2;break}}$k[$j++]=$g($_.msg,$_.i);$_.anotb();if($k[--$j]){$k[$j++]=$_.swa;$_.encb();$_.cset="seta";break}if($_.i<$_.msglen-4){var _9G=$g($_.setb,$g($_.msg,$_.i+4))!==undefined;if($_.nums==4&&_9G){$k[$j++]=$_.sc2;$_.encb();for(var _9I=0;_9I<2;_9I++){if($g($_.msg,$_.i)==$_.fn1){$k[$j++]=$_.fn1;$_.encc();$_.i=$_.i+1}else{$k[$j++]=$G($_.msg,$_.i,2);$_.encc();$_.i=$_.i+2}}break}}if($_.i<$_.msglen-6){var _9a=$g($_.setb,$g($_.msg,$_.i+6))!==undefined;if($_.nums==6&&_9a){$k[$j++]=$_.sc3;$_.encb();for(var _9c=0;_9c<3;_9c++){if($g($_.msg,$_.i)==$_.fn1){$k[$j++]=$_.fn1;$_.encc();$_.i=$_.i+1}else{$k[$j++]=$G($_.msg,$_.i,2);$_.encc();$_.i=$_.i+2}}break}}if($_.nums>=4&&$_.nums%2==0){$k[$j++]=$_.swc;$_.encb();$_.cset="setc";break}$k[$j++]=$g($_.msg,$_.i);$_.encb();$_.i=$_.i+1;break}if($eq($_.cset,"setc")){if($_.nums>=2){if($g($_.msg,$_.i)==$_.fn1){$k[$j++]=$_.fn1;$_.encc();$_.i=$_.i+1}else{$k[$j++]=$G($_.msg,$_.i,2);$_.encc();$_.i=$_.i+2}break}if($_.i<$_.msglen-1){var _AC=$g($_.setb,$g($_.msg,$_.i))!==undefined;$k[$j++]=_AC;$k[$j++]=$_.i+1;$_.numsscr();var _AE=$k[--$j];$k[$j-1]=_AE;var _AG=$k[--$j];var _AH=$k[--$j];if(_AH&&(_AG>=2&&_AG%2==0)){$k[$j++]=$_.sb1;$_.encc();$k[$j++]=$g($_.msg,$_.i);$_.encb();$_.i=$_.i+1;break}}if($_.i<$_.msglen-1){var _AT=$g($_.setb,$g($_.msg,$_.i))!==undefined;$k[$j++]=_AT;$k[$j++]=$_.i+1;$_.numsscr();var _AV=$k[--$j];$k[$j-1]=_AV;var _AX=$k[--$j];var _AY=$k[--$j];if(_AY&&(_AX>=3&&_AX%2==1)){$k[$j++]=$_.sb2;$_.encc();$k[$j++]=$g($_.msg,$_.i);$_.encb();$k[$j++]=$g($_.msg,$_.i+1);$_.encb();$_.i=$_.i+2;break}}if($_.i<$_.msglen-2){var _An=$g($_.setb,$g($_.msg,$_.i))!==undefined;var _As=$g($_.setb,$g($_.msg,$_.i+1))!==undefined;$k[$j++]=_An&&_As;$k[$j++]=$_.i+2;$_.numsscr();var _Au=$k[--$j];$k[$j-1]=_Au;var _Aw=$k[--$j];var _Ax=$k[--$j];if(_Ax&&(_Aw>=2&&_Aw%2==0)){$k[$j++]=$_.sb2;$_.encc();$k[$j++]=$g($_.msg,$_.i);$_.encb();$k[$j++]=$g($_.msg,$_.i+1);$_.encb();$_.i=$_.i+2;break}}if($_.i<$_.msglen-3){var _BC=$g($_.setb,$g($_.msg,$_.i))!==undefined;var _BH=$g($_.setb,$g($_.msg,$_.i+1))!==undefined;$k[$j++]=_BC&&_BH;$k[$j++]=$_.i+2;$_.numsscr();var _BJ=$k[--$j];$k[$j-1]=_BJ;var _BL=$k[--$j];var _BM=$k[--$j];if(_BM&&(_BL>=3&&_BL%2==1)){$k[$j++]=$_.sb3;$_.encc();$k[$j++]=$g($_.msg,$_.i);$_.encb();$k[$j++]=$g($_.msg,$_.i+1);$_.encb();$k[$j++]=$g($_.msg,$_.i+2);$_.encb();$_.i=$_.i+3;break}}if($_.i<$_.msglen-3){var _Be=$g($_.setb,$g($_.msg,$_.i))!==undefined;var _Bj=$g($_.setb,$g($_.msg,$_.i+1))!==undefined;var _Bo=$g($_.setb,$g($_.msg,$_.i+2))!==undefined;$k[$j++]=_Be&&_Bj&&_Bo;$k[$j++]=$_.i+3;$_.numsscr();var _Bq=$k[--$j];$k[$j-1]=_Bq;var _Bs=$k[--$j];var _Bt=$k[--$j];if(_Bt&&(_Bs>=2&&_Bs%2==0)){$k[$j++]=$_.sb3;$_.encc();$k[$j++]=$g($_.msg,$_.i);$_.encb();$k[$j++]=$g($_.msg,$_.i+1);$_.encb();$k[$j++]=$g($_.msg,$_.i+2);$_.encb();$_.i=$_.i+3;break}}$k[$j++]=$_.i;$_.abeforeb();if($k[--$j]){$k[$j++]=$_.swa;$_.encc();$_.cset="seta";break}$k[$j++]=$_.swb;$_.encc();$_.cset="setb";break}break}}$_.cws=$G($_.cws,0,$_.j)}$_.metrics=$a([$a([2,7]),$a([3,12]),$a([4,17]),$a([5,22]),$a([6,27]),$a([7,32]),$a([8,37]),$a([9,42]),$a([10,47]),$a([11,52]),$a([12,57]),$a([13,62]),$a([14,67]),$a([15,72]),$a([16,77])]);$_.urows=$_.rows;var _CU=$_.metrics;for(var _CV=0,_CW=_CU.length;_CV<_CW;_CV++){$_.m=$g(_CU,_CV);$_.r=$g($_.m,0);$_.dcws=$g($_.m,1);$_.okay=true;if($_.urows!=0&&$_.urows!=$_.r){$_.okay=false}if($_.cws.length>$_.dcws){$_.okay=false}if($_.okay){break}}if(!$_.okay){$k[$j++]="bwipp.code16kNoValidSymbol#15731";$k[$j++]="Maximum length exceeded or data too large for given options";bwipp_raiseerror()}$k[$j++]=Infinity;$q($_.cws);for(var _Cm=0,_Cn=$f($_.dcws-$_.cws.length);_Cm<_Cn;_Cm++){$k[$j++]=103}$_.cws=$a();$k[$j++]=Infinity;$k[$j++]=$f(($_.r-2)*7+$_.mode);$q($_.cws);$_.cws=$a();$k[$j++]=0;for(var _Cv=0,_Cu=$_.dcws;_Cv<=_Cu;_Cv+=1){var _Cy=$k[--$j];$k[$j++]=$f(_Cy+(_Cv+2)*$g($_.cws,_Cv))}$_.c1=$k[--$j]%107;$k[$j++]=0;for(var _D2=0,_D1=$_.dcws;_D2<=_D1;_D2+=1){var _D5=$k[--$j];$k[$j++]=$f(_D5+(_D2+1)*$g($_.cws,_D2))}$_.c2=$f($k[--$j]+$_.c1*($_.dcws+2))%107;$k[$j++]=Infinity;$q($_.cws);$k[$j++]=$_.c1;$k[$j++]=$_.c2;$_.cws=$a();var _DE=$g($_.options,"debugcws")!==undefined;if(_DE){$k[$j++]="bwipp.debugcws#15747";$k[$j++]=$_.cws;bwipp_raiseerror()}$_.encs=$a(["212222","222122","222221","121223","121322","131222","122213","122312","132212","221213","221312","231212","112232","122132","122231","113222","123122","123221","223211","221132","221231","213212","223112","312131","311222","321122","321221","312212","322112","322211","212123","212321","232121","111323","131123","131321","112313","132113","132311","211313","231113","231311","112133","112331","132131","113123","113321","133121","313121","211331","231131","213113","213311","213131","311123","311321","331121","312113","312311","332111","314111","221411","431111","111224","111422","121124","121421","141122","141221","112214","112412","122114","122411","142112","142211","241211","221114","413111","241112","134111","111242","121142","121241","114212","124112","124211","411212","421112","421211","212141","214121","412121","111143","111341","131141","114113","114311","411113","411311","113141","114131","311141","411131","211412","211214","211232","211133"]);$_.startencs=$a(["3211","2221","2122","1411","1132","1231","1114","3112","3211","2221","2122","1411","1132","1231","1114","3112"]);$_.stopencsodd=$a(["3211","2221","2122","1411","1132","1231","1114","3112","1132","1231","1114","3112","3211","2221","2122","1411"]);$_.stopencseven=$a(["2122","1411","1132","1231","1114","3112","1132","1231","1114","3112","3211","2221","2122","1411","3211","2221"]);if($_.sam==-1||~~($_.sam/10)%2==1){$_.stopencs=$_.stopencsodd}else{$_.stopencs=$_.stopencseven}$_.rowbits=$a($_.r);for(var _DT=0,_DS=$_.r-1;_DT<=_DS;_DT+=1){$_.i=_DT;$k[$j++]=Infinity;$k[$j++]=10;$F($g($_.startencs,$_.i),function(){var _DX=$k[--$j];$k[$j++]=_DX-48});var _Da=$G($_.cws,$_.i*5,5);$k[$j++]=1;for(var _Db=0,_Dc=_Da.length;_Db<_Dc;_Db++){$F($g($_.encs,$g(_Da,_Db)),function(){var _Dg=$k[--$j];$k[$j++]=_Dg-48})}$F($g($_.stopencs,$_.i),function(){var _Dk=$k[--$j];$k[$j++]=_Dk-48});$k[$j++]=1;$_.sbs=$a();$k[$j++]=Infinity;var _Dm=$_.sbs;$k[$j++]=1;for(var _Dn=0,_Do=_Dm.length;_Dn<_Do;_Dn++){var _Dq=$k[$j-1];var _Dr=_Dq==0?1:0;for(var _Ds=0,_Dt=$g(_Dm,_Dn);_Ds<_Dt;_Ds++){$k[$j++]=_Dr}}$as($a($m()-1));var _Dw=$k[--$j];$k[$j-1]=_Dw;var _Dy=$k[--$j];$k[$j-1]=_Dy;$k[$j++]=$_.rowbits;$k[$j++]=$_.i;var _E2=$k[$j-3];var _E3=$k[$j-1];$p($k[$j-2],_E3,_E2);$j-=3}$k[$j++]=Infinity;for(var _E6=0,_E7=81*$_.sepheight;_E6<_E7;_E6++){$k[$j++]=1}for(var _EA=0,_E9=$_.r-2;_EA<=_E9;_EA+=1){$_.i=_EA;for(var _EC=0,_ED=$_.rowheight;_EC<_ED;_EC++){$q($g($_.rowbits,$_.i))}for(var _EI=0,_EJ=$_.sepheight;_EI<_EJ;_EI++){for(var _EK=0;_EK<10;_EK++){$k[$j++]=0}for(var _EL=0;_EL<70;_EL++){$k[$j++]=1}$k[$j++]=0}}for(var _EN=0,_EO=$_.rowheight;_EN<_EO;_EN++){$q($g($_.rowbits,$_.r-1))}for(var _ET=0,_EU=81*$_.sepheight;_ET<_EU;_ET++){$k[$j++]=1}$_.pixs=$a();var _Ea=new Map([["ren","renmatrix"],["pixs",$_.pixs],["pixx",81],["pixy",~~($_.pixs.length/81)],["height",~~($_.pixs.length/81)/72],["width",81/72],["opt",$_.options]]);$k[$j++]=_Ea;if(!$_.dontdraw){bwipp_renmatrix()}$_=$__}function bwipp_code49(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.sam=-1;$_.append=false;$_.rows=0;$_.rowheight=8;$_.sepheight=1;$_.parse=false;$_.parsefnc=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.rows!=0&&($_.rows<2||$_.rows>8)){$k[$j++]="bwipp.code49badRows#15885";$k[$j++]="Code 49 must have 2 to 8 rows";bwipp_raiseerror()}if($_.rowheight<8){$k[$j++]="bwipp.code49badRowHeight#15889";$k[$j++]="Code 49 must have rowheight of at least 8";bwipp_raiseerror()}if($_.sepheight<1){$k[$j++]="bwipp.code49badSepHeight#15893";$k[$j++]="Code 49 must have sepheight of at least 1";bwipp_raiseerror()}if($_.append&&$_.sam!=-1){$k[$j++]="bwipp.code49samAndAppend#15897";$k[$j++]="sam and append cannot be specified together";bwipp_raiseerror()}if($_.sam!=-1){$k[$j++]=true;for(var _A=0;_A<1;_A++){var _B=$_.sam;if(_B<12||_B>99){$k[$j-1]=false;break}if($_.sam%10<2){$k[$j-1]=false;break}if(~~($_.sam/10)>$_.sam%10){$k[$j-1]=false;break}}if(!$k[--$j]){$k[$j++]="bwipp.code49badSAM#15908";$k[$j++]='SAM must be formatted as "NM" for Nth of M symbols, from 2 to 9 symbols';bwipp_raiseerror()}}$_.s1=-1;$_.s2=-2;$_.fn1=-3;$_.fn2=-4;$_.fn3=-5;$_.ns=-6;var _M=new Map([["parse",$_.parse],["parsefnc",$_.parsefnc],["FNC1",$_.fn1],["FNC2",$_.fn2],["FNC3",$_.fn3]]);$_.fncvals=_M;$k[$j++]="msg";$k[$j++]=$_.barcode;$k[$j++]=$_.fncvals;bwipp_parseinput();var _P=$k[--$j];$_[$k[--$j]]=_P;$_.msglen=$_.msg.length;$F($_.msg,function(){if($k[--$j]>127){$k[$j++]="bwipp.code49badCharacter#15931";$k[$j++]="Code 49 can only support ASCII characters with values 0 to 127";bwipp_raiseerror()}});$_.charmap=$a(["0","1","2","3","4","5","6","7","8","9","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z","-","."," ","$","/","+","%",$_.s1,$_.s2,$_.fn1,$_.fn2,$_.fn3,$_.ns]);$_.charvals=new Map;for(var _b=0;_b<=48;_b+=1){$_.i=_b;var _e=$g($_.charmap,$_.i);$k[$j++]=_e;if($eq($t(_e),"stringtype")){var _h=$g($k[--$j],0);$k[$j++]=_h}$p($_.charvals,$k[--$j],$_.i)}$_.combos=$a(["1 ","1A","1B","1C","1D","1E","1F","1G","1H","1I","1J","1K","1L","1M","1N","1O","1P","1Q","1R","1S","1T","1U","1V","1W","1X","1Y","1Z","11","12","13","14","15","  ","16","17","18"," $"," %","19","10","1-","1.","1$"," +","1/"," -"," ."," /"," 0"," 1"," 2"," 3"," 4"," 5"," 6"," 7"," 8"," 9","1+","21","22","23","24","25","26"," A"," B"," C"," D"," E"," F"," G"," H"," I"," J"," K"," L"," M"," N"," O"," P"," Q"," R"," S"," T"," U"," V"," W"," X"," Y"," Z","27","28","29","20","2-","2.","2A","2B","2C","2D","2E","2F","2G","2H","2I","2J","2K","2L","2M","2N","2O","2P","2Q","2R","2S","2T","2U","2V","2W","2X","2Y","2Z","2$","2/","2+","2%","2 "]);for(var _m=0;_m<=127;_m+=1){$_.i=_m;var _p=$g($_.combos,$_.i);$_.c1=$g(_p,0);$_.c2=$g(_p,1);if($_.c1==49){$p($_.charvals,$_.i,$a([$g($_.charvals,$_.s1),$g($_.charvals,$_.c2)]))}if($_.c1==50){$p($_.charvals,$_.i,$a([$g($_.charvals,$_.s2),$g($_.charvals,$_.c2)]))}}$_.encodealpha=function(){var _1F=$g($_.charvals,$k[--$j]);$k[$j++]=_1F;if($ne($t(_1F),"arraytype")){$as($a(1))}var _1I=$k[--$j];$P($_.cws,$_.j,_1I);$_.j=_1I.length+$_.j};$_.base48=function(){var _1M=$k[--$j];$k[$j++]=0;$F(_1M,function(){var _1N=$k[--$j];var _1O=$k[--$j];$k[$j++]=$f(_1N-48+_1O*10)});$k[$j++]=Infinity;var _1P=$k[$j-2];var _1Q=$k[$j-3];$k[$j-3]=$k[$j-1];$j-=2;$k[$j++]=_1P;for(var _1R=0,_1S=_1Q-1;_1R<_1S;_1R++){var _1T=$k[--$j];$k[$j++]=_1T%48;$k[$j++]=~~(_1T/48)}var _1U=$a();var _1V=Infinity;var _1W=_1U;$k[$j++]=_1V;$k[$j++]=_1W;for(var _1X=_1W.length-1;_1X>=0;_1X-=1){var _1Y=$k[--$j];$k[$j++]=$g(_1Y,_1X);$k[$j++]=_1Y}$j--;var _1a=$a();$P($_.cws,$_.j,_1a);$_.j=_1a.length+$_.j};$_.encodenumeric=function(){$_.nums=$k[--$j];var _1g=$_.nums.length;var _1h=_1g%5;$k[$j++]="pre";$k[$j++]=_1g;$k[$j++]=_1h;if(_1h!=2){var _1i=$k[--$j];var _1j=$k[--$j];$k[$j++]=$f(_1j-_1i)}else{var _1k=$k[--$j];var _1l=$k[--$j];$k[$j++]=$f(_1l-_1k)-5}var _1m=$k[--$j];$_[$k[--$j]]=_1m;for(var _1q=0,_1p=$_.pre-1;_1q<=_1p;_1q+=5){$k[$j++]=3;$k[$j++]=$G($_.nums,_1q,5);$_.base48()}$_.nums=$G($_.nums,$_.pre,$f($_.nums.length-$_.pre));var _1z=$_.nums.length;$k[$j++]=_1z;if(_1z==1){$k[$j++]=$g($_.nums,$_.i);$_.encodealpha()}var _23=$k[$j-1];if(_23==3){$k[$j++]=2;$k[$j++]=$_.nums;$_.base48()}var _25=$k[$j-1];if(_25==4){$k[$j++]=3;$k[$j++]=Infinity;$k[$j++]=49;$k[$j++]=48;$q($_.nums);var _27=$a();$k[$j++]=_27;$_.base48()}if($k[--$j]==7){$k[$j++]=3;$k[$j++]=Infinity;$k[$j++]=49;$k[$j++]=48;$q($G($_.nums,0,4));var _2B=$a();$k[$j++]=_2B;$_.base48();$k[$j++]=2;$k[$j++]=$G($_.nums,4,3);$_.base48()}};$k[$j++]=Infinity;for(var _2F=0,_2G=$_.msglen;_2F<_2G;_2F++){$k[$j++]=0}$k[$j++]=0;$_.numericruns=$a();for(var _2J=$_.msglen-1;_2J>=0;_2J-=1){$_.i=_2J;var _2M=$g($_.msg,$_.i);if(_2M>=48&&_2M<=57){$p($_.numericruns,$_.i,$g($_.numericruns,$_.i+1)+1)}else{$p($_.numericruns,$_.i,0)}}$_.cws=$a($_.msglen*2+1);$_.samval=$a([12,22,13,23,33,14,24,34,44,15,25,35,45,55,16,26,36,46,56,66,17,27,37,47,57,67,77,18,28,38,48,58,68,78,88,19,29,39,49,59,69,79,89,99]);for(;;){if($_.append){$_.mode=1;$_.method="alpha";$_.i=0;$_.j=0;break}if($_.sam!=-1){$_.mode=3;$k[$j++]=$_.cws;$k[$j++]=0;for(var _2b=0;_2b<=43;_2b+=1){$k[$j++]=_2b;if($g($_.samval,_2b)!=$_.sam){$j--}}var _2f=$k[--$j];var _2g=$k[--$j];$p($k[--$j],_2g,_2f+1);$_.method="alpha";$_.i=0;$_.j=1;break}if($g($_.numericruns,0)>=5){$_.mode=2;$_.method="numeric";$_.i=0;$_.j=0;break}var _2n=$g($_.charvals,$g($_.msg,0));$k[$j++]=_2n;if($ne($t(_2n),"arraytype")){$j--;$_.mode=0;$_.method="alpha";$_.i=0;$_.j=0;break}var _2r=$g($k[--$j],0)==43?4:5;$_.mode=_2r;$p($_.cws,0,$g($g($_.charvals,$g($_.msg,0)),1));$_.method="alpha";$_.i=1;$_.j=1;break}for(;;){if($_.i==$_.msglen){break}for(;;){if($eq($_.method,"alpha")){if($g($_.numericruns,$_.i)>=5){$k[$j++]=$_.ns;$_.encodealpha();$_.method="numeric";break}$k[$j++]=$g($_.msg,$_.i);$_.encodealpha();$_.i=$_.i+1;break}if($eq($_.method,"numeric")){if($g($_.numericruns,$_.i)<5){$k[$j++]=$_.ns;$_.encodealpha();$_.method="alpha";break}$k[$j++]=$G($_.msg,$_.i,$g($_.numericruns,$_.i));$_.encodenumeric();$_.i=$f($_.i+$g($_.numericruns,$_.i));break}}}$_.cws=$G($_.cws,0,$_.j);$_.metrics=$a([$a([2,9]),$a([3,16]),$a([4,23]),$a([5,30]),$a([6,37]),$a([7,42]),$a([8,49])]);$_.urows=$_.rows;var _3b=$_.metrics;for(var _3c=0,_3d=_3b.length;_3c<_3d;_3c++){$_.m=$g(_3b,_3c);$_.r=$g($_.m,0);$_.dcws=$g($_.m,1);$_.okay=true;if($_.urows!=0&&$_.urows!=$_.r){$_.okay=false}if($_.cws.length>$_.dcws){$_.okay=false}if($_.okay){break}}if(!$_.okay){$k[$j++]="bwipp.code49noValidSymbol#16125";$k[$j++]="Maximum length exceeded";bwipp_raiseerror()}$k[$j++]=Infinity;$q($_.cws);for(var _3t=0,_3u=$f($_.dcws-$_.cws.length);_3t<_3u;_3t++){$k[$j++]=48}$_.cws=$a();$_.ccs=$a($_.r*8);$_.j=0;for(var _40=0,_3z=$_.r-2;_40<=_3z;_40+=1){$_.i=_40;$_.cc=$G($_.cws,$_.j,7);$P($_.ccs,$_.i*8,$_.cc);var _49=$_.cc;$k[$j++]=$_.ccs;$k[$j++]=$_.i*8+7;$k[$j++]=0;for(var _4A=0,_4B=_49.length;_4A<_4B;_4A++){var _4D=$k[--$j];$k[$j++]=$f(_4D+$g(_49,_4A))}var _4E=$k[--$j];var _4F=$k[--$j];$p($k[--$j],_4F,_4E%49);$_.j=$_.j+7}if($_.j<$_.dcws){$P($_.ccs,$_.ccs.length-8,$G($_.cws,$_.j,$f($_.dcws-$_.j)))}$_.cr7=$f(($_.r-2)*7+$_.mode);$p($_.ccs,$_.ccs.length-2,$_.cr7);var _4W=$a([1,9,31,26,2,12,17,23,37,18,22,6,27,44,15,43,39,11,13,5,41,33,36,8,4,32,3,19,40,25,29,10,24,30]);$k[$j++]=_4W;$k[$j++]=_4W;$k[$j++]=Infinity;var _4X=$k[--$j];var _4Z=$G($k[--$j],0,32);$k[$j++]=_4X;$k[$j++]=20;$q(_4Z);$_.weightx=$a();var _4b=$k[$j-1];$k[$j++]=_4b;$k[$j++]=Infinity;var _4c=$k[--$j];var _4e=$G($k[--$j],1,32);$k[$j++]=_4c;$k[$j++]=16;$q(_4e);$_.weighty=$a();$k[$j++]=Infinity;var _4g=$k[--$j];var _4i=$G($k[--$j],2,32);$k[$j++]=_4g;$k[$j++]=38;$q(_4i);$_.weightz=$a();$_.calccheck=function(){$_.weights=$k[--$j];$_.score=0;for(var _4o=0,_4n=~~(($_.r-1)*8/2)-1;_4o<=_4n;_4o+=1){$_.i=_4o;$_.score=$f(($g($_.ccs,$_.i*2)*49+$g($_.ccs,$_.i*2+1))*$g($_.weights,$_.i+1)+$_.score)}$k[$j++]=$_.score};$_.lastrow=$G($_.ccs,$_.ccs.length-8,8);if($_.r>=7){$k[$j++]=$_.cr7*$g($_.weightz,0);$k[$j++]=$_.weightz;$_.calccheck();var _58=$k[--$j];var _5A=$f($k[--$j]+_58)%2401;$k[$j++]=~~(_5A/49);$k[$j++]=_5A%49;$as($a(2));$k[$j++]=$_.lastrow;$k[$j++]=0;var _5D=$k[$j-3];var _5E=$k[$j-1];$P($k[$j-2],_5E,_5D);$j-=3}$_.wr1=$f($g($_.lastrow,0)*49+$g($_.lastrow,1));$k[$j++]=$_.cr7*$g($_.weighty,0);$k[$j++]=$_.weighty;$_.calccheck();var _5O=$k[--$j];var _5U=$f($k[--$j]+_5O+$_.wr1*$g($_.weighty,$_.r*4-3))%2401;$_.wr2=_5U;$k[$j++]=~~(_5U/49);$k[$j++]=_5U%49;$as($a(2));$k[$j++]=$_.lastrow;$k[$j++]=2;var _5X=$k[$j-3];var _5Y=$k[$j-1];$P($k[$j-2],_5Y,_5X);$j-=3;$k[$j++]=$_.cr7*$g($_.weightx,0);$k[$j++]=$_.weightx;$_.calccheck();var _5e=$k[--$j];var _5o=$f($k[--$j]+_5e+$_.wr1*$g($_.weightx,$_.r*4-3)+$_.wr2*$g($_.weightx,$_.r*4-2))%2401;$k[$j++]=~~(_5o/49);$k[$j++]=_5o%49;$as($a(2));$k[$j++]=$_.lastrow;$k[$j++]=4;var _5r=$k[$j-3];var _5s=$k[$j-1];$P($k[$j-2],_5s,_5r);$j-=3;var _5w=$G($_.ccs,$_.ccs.length-8,7);$k[$j++]=0;for(var _5x=0,_5y=_5w.length;_5x<_5y;_5x++){var _60=$k[--$j];$k[$j++]=$f(_60+$g(_5w,_5x))}$p($_.ccs,$_.ccs.length-1,$k[--$j]%49);var _65=$g($_.options,"debugcws")!==undefined;if(_65){$k[$j++]="bwipp.debugcws#16196";$k[$j++]=$_.ccs;bwipp_raiseerror()}$_.patterns=$a([$a(["11521132","25112131","14212132","25121221","14221222","12412132","23321221","12421222","21521221","15112222","15121312","13312222","24221311","13321312","11512222","22421311","11521312","25112311","14212312","23312311","12412312","21512311","16121131","14321131","12521131","15212131","15221221","13412131","13421221","11612131","16112221","16121311","14312221","14321311","12512221","12521311","15212311","13412311","11612311","11131135","31131133","51131131","21122134","41122132","21131224","41131222","11113135","31113133","51113131","11122225","31122223","51122221","11131315","31131313","51131311","21113224","41113222","21122314","41122312","11113315","31113313","51113311","12131134","32131132","21231133","41231131","22122133","42122131","11222134","22131223","42131221","11231224","31231222","12113134","32113132","12122224","32122222","12131314","32131312","21231313","41231311","22113223","42113221","11213224","22122313","42122311","11222314","31222312","12113314","32113312","21213313","41213311","13131133","33131131","22231132","11331133","31331131","23122132","12222133","23131222","12231223","32231221","21331222","13113133","33113131","13122223","33122221","11313133","13131313","33131311","11322223","22231312","11331313","31331311","23113222","12213223","23122312","12222313","32222311","21322312","13113313","33113311","22213312","11313313","31313311","14131132","23231131","12331132","21431131","24122131","13222132","24131221","13231222","11422132","22331221","11431222","14113132","14122222","12313132","14131312","12322222","23231311","12331312","21431311","24113221","13213222","24122311","13222312","11413222","22322311","11422312","14113312","23213311","12313312","21413311","15131131","13331131","14222131","14231221","12422131","12431221","15113131","15122221","13313131","15131311","13322221","11513131","13331311","11522221","14213221","14222311","12413221","12422311","15113311","13313311","11513311","11141134","31141132","21132133","41132131","21141223","41141221","11123134","31123132","11132224","31132222","11141314","31141312","21114133","41114131","21123223","41123221","21132313","41132311","11114224","31114222","11123314","31123312","21114313","41114311","12141133","32141131","21241132","22132132","11232133","22141222","11241223","31241221","12123133","32123131","12132223","32132221","12141313","32141311","21241312","22114132","11214133","22123222","11223223","22132312","11232313","31232311","12114223","32114221","12123313","32123311","21223312","22114312","11214313","31214311","13141132","22241131","11341132","23132131","12232132","23141221","12241222","21341221","13123132","13132222","11323132","13141312","11332222","22241311","11341312","23114131","12214132","23123221","12223222","23132311","12232312","21332311","13114222","13123312","11314222","22223311","11323312","23114311","12214312","21314311","14141131","12341131","13232131","13241221","11432131","14123131","14132221","12323131","14141311","12332221","12341311","13214131","13223221","11414131","13232311","11423221","11432311","14114221","14123311","12314221","12323311","13214311","11414311","11151133","31151131","21142132","21151222","11133133","31133131","11142223","31142221","11151313","31151311","21124132","21133222","21142312","11115133","31115131","11124223","31124221","11133313","31133311","21115222","21124312","12151132","21251131","22142131","11242132","22151221","11251222","12133132","12142222","12151312","21251311","22124131","11224132","22133221","11233222","22142311","11242312","12115132","12124222","12133312","21233311","22115221","11215222","22124311","11224312","13151131","12242131","12251221","13133131","13142221","11333131","13151311","11342221","12224131","12233221","12242311","13115131","13124221","11315131","13133311","11324221","11333311","12215221","12224311","11161132","21152131","21161221","11143132","11152222","11161312","21134131","21143221","21152311","11125132","11134222","11143312","21116131","21125221","21134311","12161131","11252131","12143131","12152221","12161311","11234131","11243221","11252311","12125131","12134221","12143311","11216131","11225221","11234311","11111236","31111234","51111232","21111325","41111323","61111321","11111416","31111414","51111412","31211143","51211141","12111235","32111233","52111231","21211234","41211232","22111324","42111322","11211325","31211323","51211321","12111415","32111413","52111411","21211414","41211412","12211144","32211142","21311143","41311141","13111234","33111232","22211233","42211231","11311234","31311232","23111323","43111321","12211324","32211322","21311323","41311321","13111414","33111412","22211413","42211411","11311414","31311412","13211143","33211141","22311142","11411143","31411141","14111233","34111231","23211232","12311233","32311231","21411232","24111322","13211323","33211321","22311322","11411323","31411321","14111413","34111411","23211412","12311413","32311411","21411412","14211142","23311141","12411142","21511141","15111232","24211231","13311232","22411231","11511232","25111321","14211322","23311321","12411322","21511321","15111412","24211411","13311412","22411411","11511412","15211141","13411141","11611141","16111231","14311231","12511231","15211321","13411321","11611321","16111411","14311411","12511411","21121144","41121142","11112145","31112143","51112141","11121235","31121233","51121231","21112234","41112232","21121324","41121322","11112325","31112323","51112321","11121415","31121413","51121411","21112414","41112412","22121143","42121141","11221144","31221142","12112144","32112142","12121234","32121232","21221233","41221231","22112233","42112231","11212234","22121323","42121321","11221324","31221322","12112324","32112322","12121414","32121412","21221413","41221411","22112413","42112411","11212414","31212412","23121142","12221143","32221141","21321142","13112143","33112141","13121233","33121231","11312143","22221232","11321233","31321231","23112232","12212233","23121322","12221323","32221321","21321322","13112323","33112321","13121413","33121411","11312323","22221412","11321413","31321411","23112412","12212413","32212411","21312412","24121141","13221142","22321141","11421142","14112142","14121232","12312142","23221231","12321232","21421231","24112231","13212232","24121321","13221322","11412232","22321321","11421322","14112322","14121412","12312322","23221411","12321412","21421411","24112411","13212412","22312411","11412412","14221141","12421141","15112141","15121231","13312141","13321231","11512141","11521231","14212231","14221321","12412231","12421321","15112321","15121411","13312321","13321411","11512321","11521411","14212411","12412411","21131143","41131141","11122144","31122142","11131234","31131232","21113143","41113141","21122233","41122231","21131323","41131321","11113234","31113232","11122324","31122322","11131414","31131412","21113323","41113321","21122413","41122411","11113414","31113412","22131142","11231143","31231141","12122143","32122141","12131233","32131231","21231232","22113142","11213143","22122232","11222233","22131322","11231323","31231321","12113233","32113231","12122323","32122321","12131413","32131411","21231412","22113322","11213323","22122412","11222413","31222411","12113413","32113411","21213412","23131141","12231142","21331141","13122142","13131232","11322142","22231231","11331232","23113141","12213142","23122231","12222232","23131321","12231322","21331321","13113232","13122322","11313232","13131412","11322322","22231411","11331412","23113321","12213322","23122411","12222412","21322411","13113412","22213411","11313412","13231141","11431141","14122141","14131231","12322141","12331231","13213141","13222231","11413141","13231321","11422231","11431321","14113231","14122321","12313231","14131411","12322321","12331411","13213321","13222411","11413321","11422411","14113411","12313411","21141142","11132143","31132141","11141233","31141231","21123142","21132232","21141322","11114143","31114141","11123233","31123231","11132323","31132321","11141413","31141411","21114232","21123322","21132412","11114323","31114321","11123413","31123411","22141141","11241142","12132142","12141232","21241231","22123141","11223142","22132231","11232232","22141321","11241322","12114142","12123232","12132322","12141412","21241411","22114231","11214232","22123321","11223322","22132411","11232412","12114322","12123412","21223411","12241141","13132141","13141231","11332141","11341231","12223141","12232231","12241321","13114141","13123231","11314141","13132321","11323231","13141411","11332321","11341411","12214231","12223321","12232411","13114321","13123411","11314321","11323411","21151141","11142142","11151232","21133141","21142231","21151321","11124142","11133232","11142322","11151412","21115141","21124231","21133321","21142411","11115232","11124322","11133412","11251141","12142141","12151231","11233141","11242231","11251321","12124141","12133231","12142321","12151411","11215141","11224231","11233321","11242411","12115231","12124321","12133411","11152141","11161231","11134141","11143231","11152321","11161411","11116141","11125231","11134321","11143411","21111244","41111242","11111335","31111333","51111331","21111424","41111422","11111515","31111513","51111511","21211153","41211151","22111243","42111241","11211244","31211242","12111334","32111332","21211333","41211331","22111423","42111421","11211424","31211422","12111514","32111512","21211513","41211511","22211152","11311153","31311151","23111242","12211243","32211241","21311242","13111333","33111331","22211332","11311333","31311331","23111422","12211423","32211421","21311422","13111513","33111511","22211512","11311513","31311511","23211151","12311152","21411151","24111241","13211242","22311241","11411242","14111332","23211331","12311332","21411331","24111421","13211422","22311421","11411422","14111512","23211511","12311512","21411511","13311151","11511151","14211241","12411241","15111331","13311331","11511331","14211421","12411421","15111511","13311511","11511511","31121152","21112153","41112151","21121243","41121241","11112244","31112242","11121334","31121332","21112333","41112331","21121423","41121421","11112424","31112422","11121514","31121512","21112513","41112511","12121153","32121151","21221152","22112152","11212153","22121242","11221243","31221241","12112243","32112241","12121333","32121331","21221332","22112332","11212333","22121422","11221423","31221421","12112423","32112421","12121513","32121511","21221512","22112512","11212513","31212511","13121152","22221151","11321152","23112151","12212152","23121241","12221242","21321241","13112242","13121332","11312242","22221331","11321332","23112331","12212332","23121421","12221422","21321421","13112422","13121512","11312422","22221511","11321512","23112511","12212512","21312511","14121151","12321151","13212151","13221241","11412151","11421241","14112241","14121331","12312241","12321331","13212331","13221421","11412331","11421421","14112421","14121511","12312421","12321511","13212511","11412511","11131153","31131151","21122152","21131242","11113153","31113151","11122243","31122241","11131333","31131331","21113242","21122332","21131422","11113333","31113331","11122423","31122421","11131513","31131511","21113422","21122512","12131152","21231151","22122151","11222152","22131241","11231242","12113152","12122242","12131332","21231331","22113241","11213242","22122331","11222332","22131421","11231422","12113332","12122422","12131512","21231511","22113421","11213422","22122511","11222512","13131151","11331151","12222151","12231241","13113151","13122241","11313151","13131331","11322241","11331331","12213241","12222331","12231421","13113331","13122421","11313331","13131511","11322421","11331511","12213421","12222511","11141152","21132151","21141241","11123152","11132242","11141332","21114151","21123241","21132331","21141421","11114242","11123332","11132422","11141512","21114331","21123421","21132511","12141151","11232151","11241241","12123151","12132241","12141331","11214151","11223241","11232331","11241421","12114241","12123331","12132421","12141511","11214331","11223421","11232511","11151151","11133151","11142241","11151331","11115151","11124241","11133331","11142421","11151511","11111254","31111252","21111343","41111341","11111434","31111432","21111523","41111521","11111614","31111612","31211161","12111253","32111251","21211252","22111342","11211343","31211341","12111433","32111431","21211432","22111522","11211523","31211521","12111613","32111611","21211612","12211162","21311161","13111252","22211251","11311252","23111341","12211342","21311341","13111432","22211431","11311432","23111521","12211522","21311521","13111612","22211611","11311612","13211161","11411161","14111251","12311251","13211341","11411341","14111431","12311431","13211521","11411521","14111611","12311611","21121162","11112163","31112161","11121253","31121251","21112252","21121342","11112343","31112341","11121433","31121431","21112432","21121522","11112523","31112521","11121613","31121611","22121161","11221162","12112162","12121252","21221251","22112251","11212252","22121341","11221342","12112342","12121432","21221431","22112431","11212432","22121521","11221522","12112522","12121612","21221611","12221161","13112161","13121251","11312161","11321251","32121115","52121113","21221116","41221114","61221112","22112116","42112114","31212115","51212113","13121116","33121114","22221115","42221113","11321116","31321114","51321112","23112115","43112113","12212116","32212114","52212112","21312115","41312113","61312111","14121115","34121113","23221114","43221112","12321115","32321113","52321111","21421114","41421112","24112114","13212115","33212113","22312114","42312112","11412115","31412113","51412111","15121114","24221113","13321114","33321112","22421113","42421111","11521114","31521112","25112113","14212114","34212112","23312113","43312111","12412114","32412112","21512113","41512111","16121113","25221112","14321113","34321111","23421112","12521113","32521111","15212113","24312112","13412113","33412111","22512112","11612113","31612111","31131115","51131113","21122116","41122114","61122112","31113115","51113113","12131116","32131114","52131112","21231115","41231113","61231111","22122115","42122113","11222116","31222114","51222112","12113116","32113114","52113112","21213115","41213113","61213111","13131115","33131113","22231114","42231112","11331115","31331113","51331111","23122114","43122112","12222115","32222113","52222111","21322114","41322112","13113115","33113113","22213114","42213112","11313115","31313113","51313111","14131114","34131112","23231113","43231111","12331114","32331112","21431113","41431111","24122113","13222114","33222112","22322113","42322111","11422114","31422112","14113114","34113112","23213113","43213111","12313114","32313112","21413113","41413111","15131113","24231112","13331113","33331111","22431112","25122112","14222113","34222111","23322112","12422113","32422111","21522112","15113113","24213112","13313113","33313111","22413112","11513113","31513111","16131112","25231111","14331112","23431111","15222112","24322111","13422112","22522111","16113112","25213111","14313112","23413111","12513112","21613111","11141116","31141114","51141112","21132115","41132113","61132111","11123116","31123114","51123112","21114115","41114113","61114111","12141115","32141113","52141111","21241114","41241112","22132114","42132112","11232115","31232113","51232111","12123115","32123113","52123111","21223114","41223112","22114114","42114112","11214115","31214113","51214111","13141114","33141112","22241113","42241111","11341114","31341112","23132113","43132111","12232114","32232112","21332113","41332111","13123114","33123112","22223113","42223111","11323114","31323112","23114113","43114111","12214114","32214112","21314113","41314111","14141113","34141111","23241112","12341113","32341111","24132112","13232113","33232111","22332112","11432113","31432111","14123113","34123111","23223112","12323113","32323111","21423112","24114112","13214113","33214111","22314112","11414113","31414111","15141112","24241111","13341112","25132111","14232112","23332111","12432112","15123112","24223111","13323112","22423111","11523112","25114111","14214112","23314111","12414112","21514111","16141111","14341111","15232111","13432111","16123111","14323111","12523111","15214111","13414111","11614111","11151115","31151113","51151111","21142114","41142112","11133115","31133113","51133111","21124114","41124112","11115115","31115113","51115111","12151114","32151112","21251113","41251111","22142113","42142111","11242114","31242112","12133114","32133112","21233113","41233111","22124113","42124111","11224114","31224112","12115114","32115112","21215113","41215111","13151113","33151111","22251112","23142112","12242113","32242111","21342112","13133113","33133111","22233112","11333113","31333111","23124112","12224113","32224111","21324112","13115113","33115111","22215112","11315113","31315111","14151112","23251111","24142111","13242112","22342111","14133112","23233111","12333112","21433111","24124111","13224112","22324111","11424112","14115112","23215111","12315112","21415111","15151111","14242111","15133111","13333111","14224111","12424111","15115111","13315111","11515111","11161114","31161112","21152113","41152111","11143114","31143112","21134113","41134111","11125114","31125112","21116113","41116111","12161113","32161111","22152112","11252113","31252111","12143113","32143111","21243112","22134112","11234113","31234111","12125113","32125111","21225112","22116112","11216113","31216111","13161112","23152111","12252112","13143112","22243111","11343112","23134111","12234112","21334111","13125112","22225111","11325112","23116111","12216112","21316111","14161111","13252111","14143111","12343111","13234111","11434111","14125111","12325111","13216111","11416111","31111216","51111214","31211125","51211123","32111215","52111213","21211216","41211214","61211212","12211126","32211124","52211122","21311125","41311123","61311121","13111216","33111214","22211215","42211213","11311216","31311214","51311212","13211125","33211123","22311124","42311122","11411125","31411123","51411121","14111215","34111213","23211214","43211212","12311215","32311213","52311211","21411214","41411212","14211124","34211122","23311123","43311121","12411124","32411122","21511123","41511121","15111214","24211213","13311214","33311212","22411213","42411211","11511214","31511212","15211123","24311122","13411123","33411121","22511122","11611123","31611121","16111213","25211212","14311213","34311211","23411212","12511213","32511211","21611212","21121126","41121124","61121122","31112125","51112123","31121215","51121213","21112216","41112214","61112212","22121125","42121123","11221126","31221124","51221122","12112126","32112124","52112122","12121216","32121214","52121212","21221215","41221213","61221211","22112215","42112213","11212216","31212214","51212212","23121124","43121122","12221125","32221123","52221121","21321124","41321122","13112125","33112123","13121215","33121213","11312125","22221214","42221212","11321215","31321213","51321211","23112214","43112212","12212215","32212213","52212211","21312214","41312212","24121123","13221124","33221122","22321123","42321121","11421124","31421122","14112124","34112122","14121214","34121212","12312124","23221213","43221211","12321214","32321212","21421213","41421211","24112213","13212214","33212212","22312213","42312211","11412214","31412212","25121122","14221123","34221121","23321122","12421123","32421121","21521122","15112123","15121213","13312123","24221212","13321213","33321211","11512123","22421212","11521213","31521211","25112212","14212213","34212211","23312212","12412213","32412211","21512212","15221122","24321121","13421122","22521121","16112122","16121212","14312122","25221211","14321212","12512122","23421211","12521212","15212212","24312211","13412212","22512211","11612212","21131125","41131123","61131121","11122126","31122124","51122122","11131216","31131214","51131212","21113125","41113123","61113121","21122215","41122213","61122211","11113216","31113214","51113212","22131124","42131122","11231125","31231123","51231121","12122125","32122123","52122121","12131215","32131213","52131211","21231214","41231212","22113124","42113122","11213125","22122214","42122212","11222215","31222213","51222211","12113215","32113213","52113211","21213214","41213212","23131123","43131121","12231124","32231122","21331123","41331121","13122124","33122122","13131214","33131212","11322124","22231213","42231211","11331214","31331212","23113123","43113121","12213124","23122213","43122211","12222214","32222212","21322213","41322211","13113214","33113212","22213213","42213211","11313214","31313212","24131122","13231123","33231121","22331122","11431123","31431121","14122123","34122121","14131213","34131211","12322123","23231212","12331213","32331211","21431212","24113122","13213123","24122212","13222213","33222211","11413123","22322212","11422213","31422211","14113213","34113211","23213212","12313213","32313211","21413212","25131121","14231122","23331121","12431122","15122122","15131212","13322122","24231211","13331212","11522122","22431211","25113121","14213122","25122211","14222212","12413122","23322211","12422212","21522211","15113212","24213211","13313212","22413211","11513212","15231121","13431121","16122121","16131211","14322121","14331211","12522121","15213121","15222211","13413121","13422211","11613121","16113211","14313211","12513211","21141124","41141122","11132125","31132123","51132121","11141215","31141213","51141211","21123124","41123122","21132214","41132212","11114125","31114123","51114121","11123215","31123213","51123211","21114214","41114212","22141123","42141121","11241124","31241122","12132124","32132122","12141214","32141212","21241213","41241211","22123123","42123121","11223124","22132213","42132211","11232214","31232212","12114124","32114122","12123214","32123212","21223213","41223211","22114213","42114211","11214214","31214212","23141122","12241123","32241121","21341122","13132123","33132121","13141213","33141211","11332123","22241212","11341213","31341211","23123122","12223123","23132212","12232213","32232211","21332212","13114123","33114121","13123213","33123211","11314123","22223212","11323213","31323211","23114212","12214213","32214211","21314212","24141121","13241122","22341121","14132122","14141212","12332122","23241211","12341212","24123121","13223122","24132211","13232212","11423122","22332211","11432212","14114122","14123212","12314122","23223211","12323212","21423211","24114211","13214212","22314211","11414212","14241121","15132121","15141211","13332121","13341211","14223121","14232211","12423121","12432211","15114121","15123211","13314121","13323211","11514121","11523211","14214211","12414211","21151123","41151121","11142124","31142122","11151214","31151212","21133123","41133121","21142213","41142211","11124124","31124122","11133214","31133212","21115123","41115121","21124213","41124211","11115214","31115212","22151122","11251123","31251121","12142123","32142121","12151213","32151211","21251212","22133122","11233123","22142212","11242213","31242211","12124123","32124121","12133213","32133211","21233212","22115122","11215123","22124212","11224213","31224211","12115213","32115211","21215212","23151121","12251122","13142122","13151212","11342122","22251211","23133121","12233122","23142211","12242212","21342211","13124122","13133212","11324122","22233211","11333212","23115121","12215122","23124211","12224212","21324211","13115212","22215211","11315212","13251121","14142121","14151211","12342121","13233121","13242211","11433121","14124121","14133211","12324121","12333211","13215121","13224211","11415121","11424211","14115211","12315211","21161122","11152123","31152121","11161213","31161211","21143122","21152212","11134123","31134121","11143213","31143211","21125122","21134212","11116123","31116121","11125213","31125211","22161121","12152122","12161212","22143121","11243122","22152211","11252212","12134122","12143212","21243211","22125121","11225122","22134211","11234212","12116122","12125212","21225211","13152121","13161211","12243121","12252211","13134121","13143211","11334121","11343211","12225121","12234211","13116121","13125211","11316121","11325211","21111226","41111224","61111222","31111315","51111313","21211135","41211133","61211131","22111225","42111223","11211226","31211224","51211222","12111316","32111314","52111312","21211315","41211313","61211311","22211134","42211132","11311135","31311133","51311131","23111224","43111222","12211225","32211223","52211221","21311224","41311222","13111315","33111313","22211314","42211312","11311315","31311313","51311311","23211133","43211131","12311134","32311132","21411133","41411131","24111223","13211224","33211222","22311223","42311221","11411224","31411222","14111314","34111312","23211313","43211311","12311314","32311312","21411313","41411311","24211132","13311133","33311131","22411132","11511133","31511131","25111222","14211223","34211221","23311222","12411223","32411221","21511222","15111313","24211312","13311313","33311311","22411312","11511313","31511311","25211131","14311132","23411131","12511132","21611131","15211222","24311221","13411222","22511221","11611222","16111312","25211311","14311312","23411311","12511312","21611311","31121134","51121132","21112135","41112133","61112131","21121225","41121223","61121221","11112226","31112224","51112222","11121316","31121314","51121312","21112315","41112313","61112311","12121135","32121133","52121131","21221134","41221132","22112134","42112132","11212135","22121224","42121222","11221225","31221223","51221221","12112225","32112223","52112221","12121315","32121313","52121311","21221314","41221312","22112314","42112312","11212315","31212313","51212311","13121134","33121132","22221133","42221131","11321134","31321132","23112133","43112131","12212134","23121223","43121221","12221224","32221222","21321223","41321221","13112224","33112222","13121314","33121312","11312224","22221313","42221311","11321314","31321312","23112313","43112311","12212314","32212312","21312313","41312311","14121133","34121131","23221132","12321133","32321131","21421132","24112132","13212133","24121222","13221223","33221221","11412133","22321222","11421223","31421221","14112223","34112221","14121313","34121311","12312223","23221312","12321313","32321311","21421312","24112312","13212313","33212311","22312312","11412313","31412311","15121132","24221131","13321132","22421131"]),$a(["22121116","42121114","31221115","51221113","32112115","52112113","21212116","41212114","61212112","23121115","43121113","12221116","32221114","52221112","21321115","41321113","61321111","13112116","33112114","22212115","42212113","11312116","31312114","51312112","24121114","13221115","33221113","22321114","42321112","11421115","31421113","51421111","14112115","34112113","23212114","43212112","12312115","32312113","52312111","21412114","41412112","25121113","14221114","34221112","23321113","43321111","12421114","32421112","21521113","41521111","15112114","24212113","13312114","33312112","22412113","42412111","11512114","31512112","15221113","24321112","13421113","33421111","22521112","16112113","25212112","14312113","34312111","23412112","12512113","32512111","21612112","21131116","41131114","61131112","31122115","51122113","21113116","41113114","61113112","22131115","42131113","11231116","31231114","51231112","12122116","32122114","52122112","21222115","41222113","61222111","22113115","42113113","11213116","31213114","51213112","23131114","43131112","12231115","32231113","52231111","21331114","41331112","13122115","33122113","22222114","42222112","11322115","31322113","51322111","23113114","43113112","12213115","32213113","52213111","21313114","41313112","24131113","13231114","33231112","22331113","42331111","11431114","31431112","14122114","34122112","23222113","43222111","12322114","32322112","21422113","41422111","24113113","13213114","33213112","22313113","42313111","11413114","31413112","25131112","14231113","34231111","23331112","12431113","32431111","15122113","24222112","13322113","33322111","22422112","11522113","31522111","25113112","14213113","34213111","23313112","12413113","32413111","21513112","15231112","24331111","13431112","16122112","25222111","14322112","23422111","12522112","15213112","24313111","13413112","22513111","11613112","21141115","41141113","61141111","11132116","31132114","51132112","21123115","41123113","61123111","11114116","31114114","51114112","22141114","42141112","11241115","31241113","51241111","12132115","32132113","52132111","21232114","41232112","22123114","42123112","11223115","31223113","51223111","12114115","32114113","52114111","21214114","41214112","23141113","43141111","12241114","32241112","21341113","41341111","13132114","33132112","22232113","42232111","11332114","31332112","23123113","43123111","12223114","32223112","21323113","41323111","13114114","33114112","22214113","42214111","11314114","31314112","24141112","13241113","33241111","22341112","14132113","34132111","23232112","12332113","32332111","21432112","24123112","13223113","33223111","22323112","11423113","31423111","14114113","34114111","23214112","12314113","32314111","21414112","25141111","14241112","23341111","15132112","24232111","13332112","22432111","25123111","14223112","23323111","12423112","21523111","15114112","24214111","13314112","22414111","11514112","15241111","16132111","14332111","15223111","13423111","16114111","14314111","12514111","21151114","41151112","11142115","31142113","51142111","21133114","41133112","11124115","31124113","51124111","21115114","41115112","22151113","42151111","11251114","31251112","12142114","32142112","21242113","41242111","22133113","42133111","11233114","31233112","12124114","32124112","21224113","41224111","22115113","42115111","11215114","31215112","23151112","12251113","32251111","13142113","33142111","22242112","11342113","31342111","23133112","12233113","32233111","21333112","13124113","33124111","22224112","11324113","31324111","23115112","12215113","32215111","21315112","24151111","13251112","14142112","23242111","12342112","24133111","13233112","22333111","11433112","14124112","23224111","12324112","21424111","24115111","13215112","22315111","11415112","14251111","15142111","13342111","14233111","12433111","15124111","13324111","11524111","14215111","12415111","21161113","41161111","11152114","31152112","21143113","41143111","11134114","31134112","21125113","41125111","11116114","31116112","22161112","12152113","32152111","21252112","22143112","11243113","31243111","12134113","32134111","21234112","22125112","11225113","31225111","12116113","32116111","21216112","23161111","13152112","22252111","23143111","12243112","21343111","13134112","22234111","11334112","23125111","12225112","21325111","13116112","22216111","11316112","14152111","13243111","14134111","12334111","13225111","11425111","14116111","12316111","41111215","61111213","21211126","41211124","61211122","22111216","42111214","31211215","51211213","22211125","42211123","11311126","31311124","51311122","23111215","43111213","12211216","32211214","52211212","21311215","41311213","61311211","23211124","43211122","12311125","32311123","52311121","21411124","41411122","24111214","13211215","33211213","22311214","42311212","11411215","31411213","51411211","24211123","13311124","33311122","22411123","42411121","11511124","31511122","25111213","14211214","34211212","23311213","43311211","12411214","32411212","21511213","41511211","25211122","14311123","34311121","23411122","12511123","32511121","21611122","15211213","24311212","13411213","33411211","22511212","11611213","31611211","31121125","51121123","21112126","41112124","61112122","21121216","41121214","61121212","31112215","51112213","12121126","32121124","52121122","21221125","41221123","61221121","22112125","42112123","11212126","22121215","42121213","11221216","31221214","51221212","12112216","32112214","52112212","21212215","41212213","61212211","13121125","33121123","22221124","42221122","11321125","31321123","51321121","23112124","43112122","12212125","23121214","43121212","12221215","32221213","52221211","21321214","41321212","13112215","33112213","22212214","42212212","11312215","31312213","51312211","14121124","34121122","23221123","43221121","12321124","32321122","21421123","41421121","24112123","13212124","24121213","13221214","33221212","11412124","22321213","42321211","11421214","31421212","14112214","34112212","23212213","43212211","12312214","32312212","21412213","41412211","15121123","24221122","13321123","33321121","22421122","11521123","31521121","25112122","14212123","25121212","14221213","34221211","12412123","23321212","12421213","32421211","21521212","15112213","24212212","13312213","33312211","22412212","11512213","31512211","16121122","25221121","14321122","23421121","12521122","15212122","15221212","13412122","24321211","13421212","11612122","22521211","16112212","25212211","14312212","23412211","12512212","21612211","11131126","31131124","51131122","21122125","41122123","61122121","21131215","41131213","61131211","11113126","31113124","51113122","11122216","31122214","51122212","21113215","41113213","61113211","12131125","32131123","52131121","21231124","41231122","22122124","42122122","11222125","22131214","42131212","11231215","31231213","51231211","12113125","32113123","52113121","12122215","32122213","52122211","21222214","41222212","22113214","42113212","11213215","31213213","51213211","13131124","33131122","22231123","42231121","11331124","31331122","23122123","43122121","12222124","23131213","43131211","12231214","32231212","21331213","41331211","13113124","33113122","13122214","33122212","11313124","22222213","42222211","11322214","31322212","23113213","43113211","12213214","32213212","21313213","41313211","14131123","34131121","23231122","12331123","32331121","21431122","24122122","13222123","24131212","13231213","33231211","11422123","22331212","11431213","31431211","14113123","34113121","14122213","34122211","12313123","23222212","12322213","32322211","21422212","24113212","13213213","33213211","22313212","11413213","31413211","15131122","24231121","13331122","22431121","25122121","14222122","25131211","14231212","12422122","23331211","12431212","15113122","15122212","13313122","24222211","13322212","11513122","22422211","11522212","25113211","14213212","23313211","12413212","21513211","16131121","14331121","15222121","15231211","13422121","13431211","16113121","16122211","14313121","14322211","12513121","12522211","15213211","13413211","11613211","11141125","31141123","51141121","21132124","41132122","21141214","41141212","11123125","31123123","51123121","11132215","31132213","51132211","21114124","41114122","21123214","41123212","11114215","31114213","51114211","12141124","32141122","21241123","41241121","22132123","42132121","11232124","22141213","42141211","11241214","31241212","12123124","32123122","12132214","32132212","21232213","41232211","22114123","42114121","11214124","22123213","42123211","11223214","31223212","12114214","32114212","21214213","41214211","13141123","33141121","22241122","11341123","31341121","23132122","12232123","23141212","12241213","32241211","21341212","13123123","33123121","13132213","33132211","11323123","22232212","11332213","31332211","23114122","12214123","23123212","12223213","32223211","21323212","13114213","33114211","22214212","11314213","31314211","14141122","23241121","12341122","24132121","13232122","24141211","13241212","11432122","22341211","14123122","14132212","12323122","23232211","12332212","21432211","24114121","13214122","24123211","13223212","11414122","22323211","11423212","14114212","23214211","12314212","21414211","15141121","13341121","14232121","14241211","12432121","15123121","15132211","13323121","13332211","11523121","14214121","14223211","12414121","12423211","15114211","13314211","11514211","11151124","31151122","21142123","41142121","21151213","41151211","11133124","31133122","11142214","31142212","21124123","41124121","21133213","41133211","11115124","31115122","11124214","31124212","21115213","41115211","12151123","32151121","21251122","22142122","11242123","22151212","11251213","31251211","12133123","32133121","12142213","32142211","21242212","22124122","11224123","22133212","11233213","31233211","12115123","32115121","12124213","32124211","21224212","22115212","11215213","31215211","13151122","22251121","23142121","12242122","23151211","12251212","13133122","13142212","11333122","22242211","11342212","23124121","12224122","23133211","12233212","21333211","13115122","13124212","11315122","22224211","11324212","23115211","12215212","21315211","14151121","13242121","13251211","14133121","14142211","12333121","12342211","13224121","13233211","11424121","11433211","14115121","14124211","12315121","12324211","13215211","11415211","11161123","31161121","21152122","21161212","11143123","31143121","11152213","31152211","21134122","21143212","11125123","31125121","11134213","31134211","21116122","21125212","12161122","22152121","11252122","22161211","12143122","12152212","21252211","22134121","11234122","22143211","11243212","12125122","12134212","21234211","22116121","11216122","22125211","11225212","13161121","12252121","13143121","13152211","11343121","12234121","12243211","13125121","13134211","11325121","11334211","12216121","12225211","31111225","51111223","21111316","41111314","61111312","31211134","51211132","12111226","32111224","52111222","21211225","41211223","61211221","22111315","42111313","11211316","31211314","51211312","12211135","32211133","52211131","21311134","41311132","13111225","33111223","22211224","42211222","11311225","31311223","51311221","23111314","43111312","12211315","32211313","52211311","21311314","41311312","13211134","33211132","22311133","42311131","11411134","31411132","14111224","34111222","23211223","43211221","12311224","32311222","21411223","41411221","24111313","13211314","33211312","22311313","42311311","11411314","31411312","14211133","34211131","23311132","12411133","32411131","21511132","15111223","24211222","13311223","33311221","22411222","11511223","31511221","25111312","14211313","34211311","23311312","12411313","32411311","21511312","15211132","24311131","13411132","22511131","11611132","16111222","25211221","14311222","23411221","12511222","21611221","15211312","24311311","13411312","22511311","11611312","21121135","41121133","61121131","11112136","31112134","51112132","11121226","31121224","51121222","21112225","41112223","61112221","21121315","41121313","61121311","11112316","31112314","51112312","22121134","42121132","11221135","31221133","51221131","12112135","32112133","52112131","12121225","32121223","52121221","21221224","41221222","22112224","42112222","11212225","22121314","42121312","11221315","31221313","51221311","12112315","32112313","52112311","21212314","41212312","23121133","43121131","12221134","32221132","21321133","41321131","13112134","33112132","13121224","33121222","11312134","22221223","42221221","11321224","31321222","23112223","43112221","12212224","23121313","43121311","12221314","32221312","21321313","41321311","13112314","33112312","22212313","42212311","11312314","31312312","24121132","13221133","33221131","22321132","11421133","31421131","14112133","34112131","14121223","34121221","12312133","23221222","12321223","32321221","21421222","24112222","13212223","24121312","13221313","33221311","11412223","22321312","11421313","31421311","14112313","34112311","23212312","12312313","32312311","21412312","25121131","14221132","23321131","12421132","21521131","15112132","15121222","13312132","24221221","13321222","11512132","22421221","11521222","25112221","14212222","25121311","14221312","12412222","23321311","12421312","21521311","15112312","24212311","13312312","22412311","11512312","15221131","13421131","16112131","16121221","14312131","14321221","12512131","12521221","15212221","15221311","13412221","13421311","11612221","16112311","14312311","12512311","21131134","41131132","11122135","31122133","51122131","11131225","31131223","51131221","21113134","41113132","21122224","41122222","21131314","41131312","11113225","31113223","51113221","11122315","31122313","51122311","21113314","41113312","22131133","42131131","11231134","31231132","12122134","32122132","12131224","32131222","21231223","41231221","22113133","42113131","11213134","22122223","42122221","11222224","22131313","42131311","11231314","31231312","12113224","32113222","12122314","32122312","21222313","41222311","22113313","42113311","11213314","31213312","23131132","12231133","32231131","21331132","13122133","33122131","13131223","33131221","11322133","22231222","11331223","31331221","23113132","12213133","23122222","12222223","23131312","12231313","32231311","21331312","13113223","33113221","13122313","33122311","11313223","22222312","11322313","31322311","23113312","12213313","32213311","21313312","24131131","13231132","22331131","11431132","14122132","14131222","12322132","23231221","12331222","21431221","24113131","13213132","24122221","13222222","24131311","11413132","13231312","11422222","22331311","11431312","14113222","14122312","12313222","23222311","12322312","21422311","24113311","13213312","22313311","11413312","14231131","12431131","15122131","15131221","13322131","13331221","11522131","14213131","14222221","12413131","14231311","12422221","12431311","15113221","15122311","13313221","13322311","11513221","11522311","14213311","12413311","21141133","41141131","11132134","31132132","11141224","31141222","21123133","41123131","21132223","41132221","21141313","41141311","11114134","31114132","11123224","31123222","11132314","31132312","21114223","41114221","21123313","41123311","11114314","31114312","22141132","11241133","31241131","12132133","32132131","12141223","32141221","21241222","22123132","11223133","22132222","11232223","22141312","11241313","31241311","12114133","32114131","12123223","32123221","12132313","32132311","21232312","22114222","11214223","22123312","11223313","31223311","12114313","32114311","21214312","23141131","12241132","21341131","13132132","13141222","11332132","22241221","11341222","23123131","12223132","23132221","12232222","23141311","12241312","21341311","13114132","13123222","11314132","13132312","11323222","22232311","11332312","23114221","12214222","23123311","12223312","21323311","13114312","22214311","11314312","13241131","14132131","14141221","12332131","12341221","13223131","13232221","11423131","13241311","11432221","14114131","14123221","12314131","14132311","12323221","12332311","13214221","13223311","11414221","11423311","14114311","12314311","21151132","11142133","31142131","11151223","31151221","21133132","21142222","21151312","11124133","31124131","11133223","31133221","11142313","31142311","21115132","21124222","21133312","11115223","31115221","11124313","31124311","22151131","11251132","12142132","12151222","21251221","22133131","11233132","22142221","11242222","22151311","11251312","12124132","12133222","12142312","21242311","22115131","11215132","22124221","11224222","22133311","11233312","12115222","12124312","21224311","12251131","13142131","13151221","11342131","12233131","12242221","12251311","13124131","13133221","11324131","13142311","11333221","11342311","12215131","12224221","12233311","13115221","13124311","11315221","11324311","21161131","11152132","11161222","21143131","21152221","21161311","11134132","11143222","11152312","21125131","21134221","21143311","11116132","11125222","11134312","12152131","12161221","11243131","11252221","12134131","12143221","12152311","11225131","11234221","11243311","12116131","12125221","12134311","21111235","41111233","61111231","11111326","31111324","51111322","21111415","41111413","61111411","21211144","41211142","22111234","42111232","11211235","31211233","51211231","12111325","32111323","52111321","21211324","41211322","22111414","42111412","11211415","31211413","51211411","22211143","42211141","11311144","31311142","23111233","43111231","12211234","32211232","21311233","41311231","13111324","33111322","22211323","42211321","11311324","31311322","23111413","43111411","12211414","32211412","21311413","41311411","23211142","12311143","32311141","21411142","24111232","13211233","33211231","22311232","11411233","31411231","14111323","34111321","23211322","12311323","32311321","21411322","24111412","13211413","33211411","22311412","11411413","31411411","24211141","13311142","22411141","11511142","25111231","14211232","23311231","12411232","21511231","15111322","24211321","13311322","22411321","11511322","25111411","14211412","23311411","12411412","21511411","14311141","12511141","15211231","13411231","11611231","16111321","14311321","12511321","15211411","13411411","11611411","31121143","51121141","21112144","41112142","21121234","41121232","11112235","31112233","51112231","11121325","31121323","51121321","21112324","41112322","21121414","41121412","11112415","31112413","51112411","12121144","32121142","21221143","41221141","22112143","42112141","11212144","22121233","42121231","11221234","31221232","12112234","32112232","12121324","32121322","21221323","41221321","22112323","42112321","11212324","22121413","42121411","11221414","31221412","12112414","32112412","21212413","41212411","13121143","33121141","22221142","11321143","31321141","23112142","12212143","23121232","12221233","32221231","21321232","13112233","33112231","13121323","33121321","11312233","22221322","11321323","31321321","23112322","12212323","23121412","12221413","32221411","21321412","13112413","33112411","22212412","11312413","31312411","14121142","23221141","12321142","21421141","24112141","13212142","24121231","13221232","11412142","22321231","11421232","14112232","14121322","12312232","23221321","12321322","21421321","24112321","13212322","24121411","13221412","11412322","22321411","11421412","14112412","23212411","12312412","21412411","15121141","13321141","11521141","14212141","14221231","12412141","12421231","15112231","15121321","13312231","13321321","11512231","11521321","14212321","14221411","12412321","12421411","15112411","13312411","11512411","11131144","31131142","21122143","41122141","21131233","41131231","11113144","31113142","11122234","31122232","11131324","31131322","21113233","41113231","21122323","41122321","21131413","41131411","11113324","31113322","11122414","31122412","21113413","41113411","12131143","32131141","21231142","22122142","11222143","22131232","11231233","31231231","12113143","32113141","12122233","32122231","12131323","32131321","21231322","22113232","11213233","22122322","11222323","22131412","11231413","31231411","12113323","32113321","12122413","32122411","21222412","22113412","11213413","31213411","13131142","22231141","11331142","23122141","12222142","23131231","12231232","21331231","13113142","13122232","11313142","13131322","11322232","22231321","11331322","23113231","12213232","23122321","12222322","23131411","12231412","21331411","13113322","13122412","11313322","22222411","11322412","23113411","12213412","21313411","14131141","12331141","13222141","13231231","11422141","11431231","14113141","14122231","12313141","14131321","12322231","12331321","13213231","13222321","11413231","13231411","11422321","11431411","14113321","14122411","12313321","12322411","13213411","11413411","11141143","31141141","21132142","21141232","11123143","31123141","11132233","31132231","11141323","31141321","21114142","21123232","21132322","21141412","11114233","31114231","11123323","31123321","11132413","31132411","21114322","21123412","12141142","21241141","22132141","11232142","22141231","11241232","12123142","12132232","12141322","21241321","22114141","11214142","22123231","11223232","22132321","11232322","22141411","11241412","12114232","12123322","12132412","21232411","22114321","11214322","22123411","11223412","13141141","11341141","12232141","12241231","13123141","13132231","11323141","13141321","11332231","11341321","12214141","12223231","12232321","12241411","13114231","13123321","11314231","13132411","11323321","11332411","12214321","12223411","11151142","21142141","21151231","11133142","11142232","11151322","21124141","21133231","21142321","21151411","11115142","11124232","11133322","11142412","21115231","21124321","21133411","12151141","11242141","11251231","12133141","12142231","12151321","11224141","11233231","11242321","11251411","12115141","12124231","12133321","12142411","11215231","11224321","11233411","11161141","11143141","11152231","11161321","11125141","11134231","11143321","11152411","11111245","31111243","51111241","21111334","41111332","11111425","31111423","51111421","21111514","41111512","31211152","12111244","32111242","21211243","41211241","22111333","42111331","11211334","31211332","12111424","32111422","21211423","41211421","22111513","42111511","11211514","31211512","12211153","32211151","21311152","13111243","33111241","22211242","11311243","31311241","23111332","12211333","32211331","21311332","13111423","33111421","22211422","11311423","31311421","23111512","12211513","32211511","21311512","13211152","22311151","11411152","14111242","23211241","12311242","21411241","24111331","13211332","22311331","11411332","14111422","23211421","12311422","21411421","24111511","13211512","22311511","11411512","14211151","12411151","15111241","13311241","11511241","14211331","12411331","15111421","13311421","11511421","14211511","12411511","21121153","41121151","11112154","31112152","11121244","31121242","21112243","41112241","21121333","41121331","11112334","31112332","11121424","31121422","21112423","41112421","21121513","41121511","11112514","31112512","22121152","11221153","31221151","12112153","32112151","12121243","32121241","21221242","22112242","11212243","22121332","11221333","31221331","12112333","32112331","12121423","32121421","21221422","22112422","11212423","22121512","11221513","31221511","12112513","32112511","21212512","23121151","12221152","21321151","13112152","13121242","11312152","22221241","11321242","23112241","12212242","23121331","12221332","21321331","13112332","13121422","11312332","22221421","11321422","23112421","12212422","23121511","12221512","21321511","13112512","22212511","11312512","13221151","11421151","14112151","14121241","12312151","12321241","13212241","13221331","11412241","11421331","14112331","14121421","12312331","12321421","13212421","13221511","11412421","11421511","14112511","12312511","21131152","11122153","31122151","11131243","31131241","21113152","21122242","21131332","11113243","31113241","11122333","31122331","11131423","31131421","21113332","21122422","21131512","11113423","31113421","11122513","31122511","22131151","11231152","12122152","12131242","21231241","22113151","11213152","22122241","11222242","22131331","11231332","12113242","12122332","12131422","21231421","22113331","11213332","22122421","11222422","22131511","11231512","12113422","12122512","21222511","12231151","13122151","13131241","11322151","11331241","12213151","12222241","12231331","13113241","13122331","11313241","13131421","11322331","11331421","12213331","12222421","12231511","13113421","13122511","11313421","11322511","21141151","11132152","11141242","21123151","21132241","21141331","11114152","11123242","11132332","11141422","21114241","21123331","21132421","21141511","11114332","11123422","11132512","11241151","12132151","12141241","11223151","11232241","11241331","12114151","12123241","12132331","12141421","11214241","11223331","11232421","11241511","12114331","12123421","12132511","11142151","11151241","11124151","11133241","11142331","11151421","11115241","11124331","11133421","11142511","21111253","41111251","11111344","31111342","21111433","41111431","11111524","31111522","21111613","41111611","21211162","22111252","11211253","31211251","12111343","32111341","21211342","22111432","11211433","31211431","12111523","32111521","21211522","22111612","11211613","31211611","22211161","11311162","23111251","12211252","21311251","13111342","22211341","11311342","23111431","12211432","21311431","13111522","22211521","11311522","23111611","12211612","21311611","12311161","13211251","11411251","14111341","12311341","13211431","11411431","14111521","12311521","13211611","11411611","31121161","21112162","21121252","11112253","31112251","11121343","31121341","21112342","21121432","11112433","31112431","11121523","31121521","21112522","21121612","12121162","21221161","22112161","11212162","22121251","11221252","12112252","12121342","21221341","22112341","11212342","22121431","11221432","12112432","12121522","21221521","22112521","11212522","22121611","11221612","13121161","11321161","12212161","12221251","13112251","13121341","11312251","11321341","12212341","12221431","13112431","13121521","11312431","11321521","12212521","12221611","11131162","21122161","21131251","11113162"])]);$_.parity=$a(["1001","0101","1100","0011","1010","0110","1111","0000"]);$_.rowbits=$a($_.r);for(var _6G=0,_6F=$_.r-1;_6G<=_6F;_6G+=1){$_.i=_6G;$k[$j++]="p";if($_.i!=$_.r-1){$k[$j++]=$g($_.parity,$_.i)}else{$k[$j++]="0000"}var _6M=$k[--$j];$_[$k[--$j]]=_6M;$_.ccrow=$G($_.ccs,$_.i*8,8);$k[$j++]=Infinity;for(var _6R=0;_6R<=7;_6R+=2){$q($G($_.ccrow,_6R,2));var _6U=$k[--$j];var _6V=$k[--$j];$k[$j++]=$f(_6U+_6V*49)}$_.scrow=$a();$k[$j++]=Infinity;$k[$j++]=10;$k[$j++]=1;$k[$j++]=1;for(var _6X=0;_6X<=3;_6X+=1){$_.j=_6X;$F($g($g($_.patterns,$g($_.p,$_.j)-48),$g($_.scrow,$_.j)),function(){var _6h=$k[--$j];$k[$j++]=_6h-48})}$k[$j++]=4;$k[$j++]=1;$_.sbs=$a();$k[$j++]=Infinity;var _6j=$_.sbs;$k[$j++]=1;for(var _6k=0,_6l=_6j.length;_6k<_6l;_6k++){var _6n=$k[$j-1];var _6o=_6n==0?1:0;for(var _6p=0,_6q=$g(_6j,_6k);_6p<_6q;_6p++){$k[$j++]=_6o}}$as($a($m()-1));var _6t=$k[--$j];$k[$j-1]=_6t;var _6v=$k[--$j];$k[$j-1]=_6v;$k[$j++]=$_.rowbits;$k[$j++]=$_.i;var _6z=$k[$j-3];var _70=$k[$j-1];$p($k[$j-2],_70,_6z);$j-=3}$k[$j++]=Infinity;for(var _73=0,_74=81*$_.sepheight;_73<_74;_73++){$k[$j++]=1}for(var _77=0,_76=$_.r-2;_77<=_76;_77+=1){$_.i=_77;for(var _79=0,_7A=$_.rowheight;_79<_7A;_79++){$q($g($_.rowbits,$_.i))}for(var _7F=0,_7G=$_.sepheight;_7F<_7G;_7F++){for(var _7H=0;_7H<10;_7H++){$k[$j++]=0}for(var _7I=0;_7I<70;_7I++){$k[$j++]=1}$k[$j++]=0}}for(var _7K=0,_7L=$_.rowheight;_7K<_7L;_7K++){$q($g($_.rowbits,$_.r-1))}for(var _7Q=0,_7R=81*$_.sepheight;_7Q<_7R;_7Q++){$k[$j++]=1}$_.pixs=$a();var _7X=new Map([["ren","renmatrix"],["pixs",$_.pixs],["pixx",81],["pixy",~~($_.pixs.length/81)],["height",~~($_.pixs.length/81)/72],["width",81/72],["opt",$_.options]]);$k[$j++]=_7X;if(!$_.dontdraw){bwipp_renmatrix()}$_=$__}function bwipp_flattermarken(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.includetext=false;$_.textfont="OCR-B";$_.textsize=10;$_.textyoffset=-8;$_.height=.3;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];$F($_.barcode,function(){var _3=$k[--$j];if(_3<48||_3>57){$k[$j++]="bwipp.flattermarkenBadCharacter#17258";$k[$j++]="Flattermarken must contain only digits";bwipp_raiseerror()}});$_.encs=$a(["0018","0117","0216","0315","0414","0513","0612","0711","0810","0900"]);$_.barchars="1234567890";$_.barlen=$_.barcode.length;$_.sbs=$s($_.barlen*4);$_.txt=$a($_.barlen);for(var _D=0,_C=$_.barlen-1;_D<=_C;_D+=1){$_.i=_D;$X($_.barchars,$G($_.barcode,$_.i,1));$j--;$_.indx=$k[--$j].length;$j-=2;$_.enc=$g($_.encs,$_.indx);$P($_.sbs,$_.i*4,$_.enc);$p($_.txt,$_.i,$a([$G($_.barcode,$_.i,1),$_.i*9,$_.textyoffset,$_.textfont,$_.textsize]))}$k[$j++]=Infinity;$k[$j++]=Infinity;var _Z=$_.sbs;for(var _a=0,_b=_Z.length;_a<_b;_a++){$k[$j++]=$g(_Z,_a)-48}var _d=$a();$k[$j++]=Infinity;for(var _f=0,_g=~~(($_.sbs.length+1)/2);_f<_g;_f++){$k[$j++]=$_.height}var _i=$a();$k[$j++]=Infinity;for(var _k=0,_l=~~(($_.sbs.length+1)/2);_k<_l;_k++){$k[$j++]=0}var _m=$a();$k[$j++]="ren";$k[$j++]="renlinear";$k[$j++]="sbs";$k[$j++]=_d;$k[$j++]="bhs";$k[$j++]=_i;$k[$j++]="bbs";$k[$j++]=_m;$k[$j++]="txt";$k[$j++]=$_.txt;$k[$j++]="opt";$k[$j++]=$_.options;var _p=$d();$k[$j++]=_p;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_raw(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.height=1;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];$F($_.barcode,function(){var _3=$k[--$j];if(_3<49||_3>57){$k[$j++]="bwipp.rawBadCharacter#17344";$k[$j++]="Raw must contain only digits 1 to 9";bwipp_raiseerror()}});$k[$j++]=Infinity;$k[$j++]=Infinity;$F($_.barcode,function(){var _5=$k[--$j];$k[$j++]=_5-48});var _6=$a();$k[$j++]=Infinity;for(var _8=0,_9=~~(($_.barcode.length+1)/2);_8<_9;_8++){$k[$j++]=$_.height}var _B=$a();$k[$j++]=Infinity;for(var _D=0,_E=~~(($_.barcode.length+1)/2);_D<_E;_D++){$k[$j++]=0}var _F=$a();$k[$j++]="ren";$k[$j++]="renlinear";$k[$j++]="sbs";$k[$j++]=_6;$k[$j++]="bhs";$k[$j++]=_B;$k[$j++]="bbs";$k[$j++]=_F;$k[$j++]="opt";$k[$j++]=$_.options;var _H=$d();$k[$j++]=_H;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_daft(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.height=.175;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.barcode.length==0){$k[$j++]="bwipp.daftEmptyData#17397";$k[$j++]="The data must not be empty";bwipp_raiseerror()}$F($_.barcode,function(){var _4=$k[--$j];if(_4!=68&&(_4!=65&&(_4!=70&&_4!=84))){$k[$j++]="bwipp.daftBadCharacter#17402";$k[$j++]="DAFT must contain only characters D, A, F and T";bwipp_raiseerror()}});$_.barlen=$_.barcode.length;$_.bbs=$a($_.barlen);$_.bhs=$a($_.barlen);for(var _C=0,_B=$_.barlen-1;_C<=_B;_C+=1){$_.i=_C;$_.enc=$G($_.barcode,$_.i,1);if($eq($_.enc,"D")){$p($_.bbs,$_.i,0*$_.height/8);$p($_.bhs,$_.i,5*$_.height/8)}if($eq($_.enc,"A")){$p($_.bbs,$_.i,3*$_.height/8);$p($_.bhs,$_.i,5*$_.height/8)}if($eq($_.enc,"F")){$p($_.bbs,$_.i,0*$_.height/8);$p($_.bhs,$_.i,8*$_.height/8)}if($eq($_.enc,"T")){$p($_.bbs,$_.i,3*$_.height/8);$p($_.bhs,$_.i,2*$_.height/8)}}$k[$j++]=Infinity;var _i=$_.bbs;var _j=$_.bhs;$k[$j++]=Infinity;for(var _l=0,_m=$_.bhs.length-1;_l<_m;_l++){$k[$j++]=1.44;$k[$j++]=1.872}$k[$j++]=1.44;var _n=$a();$k[$j++]="ren";$k[$j++]="renlinear";$k[$j++]="bbs";$k[$j++]=_i;$k[$j++]="bhs";$k[$j++]=_j;$k[$j++]="sbs";$k[$j++]=_n;$k[$j++]="opt";$k[$j++]=$_.options;var _p=$d();$k[$j++]=_p;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_symbol(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];$_.fimasbs=$a([2.25,2.25,2.25,11.25,2.25,11.25,2.25,2.25,2.25]);$k[$j++]=Infinity;for(var _4=0,_5=~~($_.fimasbs.length/2)+1;_4<_5;_4++){$k[$j++]=.625}$_.fimabhs=$a();$k[$j++]=Infinity;for(var _8=0,_9=~~($_.fimasbs.length/2)+1;_8<_9;_8++){$k[$j++]=0}$_.fimabbs=$a();$_.fimbsbs=$a([2.25,6.75,2.25,2.25,2.25,6.25,2.25,2.25,2.25,6.75,2.25]);$k[$j++]=Infinity;for(var _D=0,_E=~~($_.fimbsbs.length/2)+1;_D<_E;_D++){$k[$j++]=.625}$_.fimbbhs=$a();$k[$j++]=Infinity;for(var _H=0,_I=~~($_.fimbsbs.length/2)+1;_H<_I;_H++){$k[$j++]=0}$_.fimbbbs=$a();$_.fimcsbs=$a([2.25,2.25,2.25,6.75,2.25,6.75,2.25,6.75,2.25,2.25,2.25]);$k[$j++]=Infinity;for(var _M=0,_N=~~($_.fimcsbs.length/2)+1;_M<_N;_M++){$k[$j++]=.625}$_.fimcbhs=$a();$k[$j++]=Infinity;for(var _Q=0,_R=~~($_.fimcsbs.length/2)+1;_Q<_R;_Q++){$k[$j++]=0}$_.fimcbbs=$a();$_.fimdsbs=$a([2.25,2.25,2.25,2.25,2.25,6.75,2.25,6.75,2.25,2.25,2.25,2.25,2.25]);$k[$j++]=Infinity;for(var _V=0,_W=~~($_.fimdsbs.length/2)+1;_V<_W;_V++){$k[$j++]=.625}$_.fimdbhs=$a();$k[$j++]=Infinity;for(var _Z=0,_a=~~($_.fimdsbs.length/2)+1;_Z<_a;_Z++){$k[$j++]=0}$_.fimdbbs=$a();$_.fimesbs=$a([2.25,6.75,2.25,15.75,2.25,6.75,2.25]);$k[$j++]=Infinity;for(var _e=0,_f=~~($_.fimesbs.length/2)+1;_e<_f;_e++){$k[$j++]=.625}$_.fimebhs=$a();$k[$j++]=Infinity;for(var _i=0,_j=~~($_.fimesbs.length/2)+1;_i<_j;_i++){$k[$j++]=0}$_.fimebbs=$a();$k[$j++]=Infinity;for(var _l=0;_l<100;_l++){$k[$j++]=1;$k[$j++]=1}$k[$j++]=1;$_.zebrasbs=$a();$k[$j++]=Infinity;for(var _o=0,_p=~~($_.zebrasbs.length/2)+1;_o<_p;_o++){$k[$j++]=1}$_.zebrabhs=$a();$k[$j++]=Infinity;for(var _s=0,_t=~~($_.zebrasbs.length/2)+1;_s<_t;_s++){$k[$j++]=0}$_.zebrabbs=$a();$_.checksize=199;$k[$j++]=Infinity;var _v=$_.checksize;for(var _w=0,_x=~~(_v*_v/2);_w<_x;_w++){$k[$j++]=1;$k[$j++]=0}$k[$j++]=1;$_.checkpixs=$a();var _z=new Map([["renlinear",bwipp_renlinear],["renmatrix",bwipp_renmatrix]]);$_.renmap=_z;var _1V=new Map([["fima",function(){var _14=new Map([["ren","renlinear"],["sbs",$_.fimasbs],["bhs",$_.fimabhs],["bbs",$_.fimabbs]]);$k[$j++]=_14}],["fimb",function(){var _18=new Map([["ren","renlinear"],["sbs",$_.fimbsbs],["bhs",$_.fimbbhs],["bbs",$_.fimbbbs]]);$k[$j++]=_18}],["fimc",function(){var _1C=new Map([["ren","renlinear"],["sbs",$_.fimcsbs],["bhs",$_.fimcbhs],["bbs",$_.fimcbbs]]);$k[$j++]=_1C}],["fimd",function(){var _1G=new Map([["ren","renlinear"],["sbs",$_.fimdsbs],["bhs",$_.fimdbhs],["bbs",$_.fimdbbs]]);$k[$j++]=_1G}],["fime",function(){var _1K=new Map([["ren","renlinear"],["sbs",$_.fimesbs],["bhs",$_.fimebhs],["bbs",$_.fimebbs]]);$k[$j++]=_1K}],["zebra",function(){var _1O=new Map([["ren","renlinear"],["sbs",$_.zebrasbs],["bhs",$_.zebrabhs],["bbs",$_.zebrabbs]]);$k[$j++]=_1O}],["check",function(){var _1U=new Map([["ren","renmatrix"],["pixs",$_.checkpixs],["pixx",$_.checksize],["pixy",$_.checksize],["height",$_.checksize/72],["width",$_.checksize/72]]);$k[$j++]=_1U}]]);$_.symbols=_1V;var _1Y=$g($_.symbols,$_.barcode)!==undefined;if(!_1Y){$k[$j++]="bwipp.symbolUnknownSymbol#17531";$k[$j++]="Unknown symbol name provided";bwipp_raiseerror()}if($g($_.symbols,$_.barcode)()===true){return true}var _1c=$k[$j-1];$p(_1c,"opt",$_.options);if(!$_.dontdraw){var _1f=$k[$j-1];if($g($_.renmap,$g(_1f,"ren"))()===true){return true}}$_=$__}function bwipp_pdf417(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.compact=false;$_.eclevel=-1;$_.fixedeclevel=false;$_.columns=0;$_.rows=0;$_.rowmult=3;$_.ccc=false;$_.raw=false;$_.parse=false;$_.parsefnc=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.barcode.length==0){$k[$j++]="bwipp.pdf417emptyData#17591";$k[$j++]="The data must not be empty";bwipp_raiseerror()}if($_.eclevel!=-1&&($_.eclevel<0||$_.eclevel>8)){$k[$j++]="bwipp.pdf417InvalidErrorCorrectionLevel#17595";$k[$j++]="Valid error correction levels are 0 to 8";bwipp_raiseerror()}if($_.ccc&&$_.raw){$k[$j++]="bwipp.pdf417cccAndRaw#17599";$k[$j++]="Cannot combine ccc and raw";bwipp_raiseerror()}if($_.ccc&&$_.compact){$k[$j++]="bwipp.pdf417cccAndCompact#17603";$k[$j++]="Cannot combine ccc and compact";bwipp_raiseerror()}if($_.rows!=0&&($_.rows<3||$_.rows>90)){$k[$j++]="bwipp.pdf417invalidRows#17607";$k[$j++]="There must be between 3 and 90 rows";bwipp_raiseerror()}if($_.columns!=0&&($_.columns<1||$_.columns>30)){$k[$j++]="bwipp.pdf417invalidColumns#17611";$k[$j++]="There must be between 1 and 30 columns";bwipp_raiseerror()}if($_.rowmult<=0){$k[$j++]="bwipp.pdf417badRowMult#17615";$k[$j++]="The row multiplier must be greater than zero";bwipp_raiseerror()}$_.T=0;$_.N=1;$_.B=2;$_.A=0;$_.L=1;$_.M=2;$_.P=3;$_.tl=-1;$_.nl=-2;$_.bl=-3;$_.bl6=-4;$_.bs=-5;$_.al=-6;$_.ll=-7;$_.ml=-8;$_.pl=-9;$_.as=-10;$_.ps=-11;$_.charmaps=$a([$a(["A","a","0",";"]),$a(["B","b","1","<"]),$a(["C","c","2",">"]),$a(["D","d","3","@"]),$a(["E","e","4","["]),$a(["F","f","5",92]),$a(["G","g","6","]"]),$a(["H","h","7","_"]),$a(["I","i","8","`"]),$a(["J","j","9","~"]),$a(["K","k","&","!"]),$a(["L","l",13,13]),$a(["M","m",9,9]),$a(["N","n",",",","]),$a(["O","o",":",":"]),$a(["P","p","#",10]),$a(["Q","q","-","-"]),$a(["R","r",".","."]),$a(["S","s","$","$"]),$a(["T","t","/","/"]),$a(["U","u","+",'"']),$a(["V","v","%","|"]),$a(["W","w","*","*"]),$a(["X","x","=",40]),$a(["Y","y","^",41]),$a(["Z","z",$_.pl,"?"]),$a([" "," "," ","{"]),$a([$_.ll,$_.as,$_.ll,"}"]),$a([$_.ml,$_.ml,$_.al,"'"]),$a([$_.ps,$_.ps,$_.ps,$_.al])]);$_.charvals=$a([new Map,new Map,new Map,new Map]);$_.alltext=new Map;for(var _10=0,_z=$_.charmaps.length-1;_10<=_z;_10+=1){$_.i=_10;$_.encs=$g($_.charmaps,$_.i);for(var _14=0;_14<=3;_14+=1){$_.j=_14;var _17=$g($_.encs,$_.j);$k[$j++]=_17;if($eq($t(_17),"stringtype")){var _1A=$g($k[--$j],0);$k[$j++]=_1A}var _1B=$k[--$j];$p($g($_.charvals,$_.j),_1B,$_.i);$p($_.alltext,_1B,-1)}}$_.e=1e4;$_.latlen=$a([$a([0,1,1,2]),$a([2,0,1,2]),$a([1,1,0,1]),$a([1,2,2,0])]);$_.latseq=$a([$a([$a([]),$a([$_.ll]),$a([$_.ml]),$a([$_.ml,$_.pl])]),$a([$a([$_.ml,$_.al]),$a([]),$a([$_.ml]),$a([$_.ml,$_.pl])]),$a([$a([$_.al]),$a([$_.ll]),$a([]),$a([$_.pl])]),$a([$a([$_.al]),$a([$_.al,$_.ll]),$a([$_.al,$_.ml]),$a([])])]);$_.shftlen=$a([$a([$_.e,$_.e,$_.e,1]),$a([1,$_.e,$_.e,1]),$a([$_.e,$_.e,$_.e,1]),$a([$_.e,$_.e,$_.e,$_.e])]);$k[$j++]=Infinity;$k[$j++]=$_.tl;$k[$j++]=900;$k[$j++]=$_.bl;$k[$j++]=901;$k[$j++]=$_.bl6;$k[$j++]=924;$k[$j++]=$_.nl;$k[$j++]=902;$k[$j++]=$_.bs;$k[$j++]=913;$_.latchcws=$d();if($_.raw){$_.datcws=$a($_.barcode.length);$_.i=0;$_.j=0;for(;;){if($_.i>=$_.barcode.length-3){break}if($g($_.barcode,$_.i)!=94){break}var _2W=$G($_.barcode,$_.i+1,3);$k[$j++]=_2W;$k[$j++]=false;for(var _2X=0,_2Y=_2W.length;_2X<_2Y;_2X++){var _2Z=$g(_2W,_2X);if(_2Z<48||_2Z>57){$k[$j-1]=true}}if($k[--$j]){$j--;break}$_.cw=$i($k[--$j]);$p($_.datcws,$_.j,$_.cw);$_.i=$_.i+4;$_.j=$_.j+1}if($_.i!=$_.barcode.length){$k[$j++]="bwipp.pdf417badRawFormat#17727";$k[$j++]="raw data must be formatted as ^NNN";bwipp_raiseerror()}$_.datcws=$G($_.datcws,0,$_.j)}$_.encb=function(){$_.in=$k[--$j];$_.inlen=$_.in.length;$_.out=$a(~~($_.inlen/6)*5+$_.inlen%6);for(var _2t=0,_2s=~~($_.inlen/6)-1;_2t<=_2s;_2t+=1){$_.k=_2t;$k[$j++]=Infinity;$q($G($_.in,$_.k*6,3));$_.msbs=$a();$k[$j++]=Infinity;$q($_.msbs);var _2z=$k[--$j];var _30=$k[--$j];var _31=$k[--$j];$k[$j++]=$f(_2z+_30*256+_31*65536);for(var _32=0;_32<3;_32++){var _33=$k[--$j];$k[$j++]=_33%900;$k[$j++]=~~(_33/900)}$_.mscs=$a();$k[$j++]=Infinity;$q($G($_.in,$_.k*6+3,3));$_.lsbs=$a();$k[$j++]=Infinity;$q($_.lsbs);var _3A=$k[--$j];var _3B=$k[--$j];var _3C=$k[--$j];$k[$j++]=$f(_3A+_3B*256+_3C*65536);for(var _3D=0;_3D<3;_3D++){var _3E=$k[--$j];$k[$j++]=_3E%900;$k[$j++]=~~(_3E/900)}$_.lscs=$a();var _3H=$g($_.lscs,0);var _3J=$g($_.mscs,0);$p($_.out,$_.k*5+4,$f(_3H+_3J*316)%900);var _3N=$g($_.lscs,1);var _3P=$g($_.mscs,0);var _3R=$g($_.mscs,1);$p($_.out,$_.k*5+3,$f(~~((_3H+_3J*316)/900)+_3N+_3P*641+_3R*316)%900);var _3V=$g($_.lscs,2);var _3X=$g($_.mscs,0);var _3Z=$g($_.mscs,1);var _3b=$g($_.mscs,2);$p($_.out,$_.k*5+2,$f(~~((~~((_3H+_3J*316)/900)+_3N+_3P*641+_3R*316)/900)+_3V+_3X*20+_3Z*641+_3b*316)%900);var _3f=$g($_.lscs,3);var _3h=$g($_.mscs,1);var _3j=$g($_.mscs,2);$p($_.out,$_.k*5+1,$f(~~((~~((~~((_3H+_3J*316)/900)+_3N+_3P*641+_3R*316)/900)+_3V+_3X*20+_3Z*641+_3b*316)/900)+_3f+_3h*20+_3j*641)%900);$p($_.out,$_.k*5,$f(~~((~~((~~((~~((_3H+_3J*316)/900)+_3N+_3P*641+_3R*316)/900)+_3V+_3X*20+_3Z*641+_3b*316)/900)+_3f+_3h*20+_3j*641)/900)+$g($_.mscs,2)*20)%900)}$_.rem=$_.inlen%6;if($_.rem!=0){$k[$j++]=$_.out;$k[$j++]=$_.out.length-$_.rem;$k[$j++]=Infinity;$q($G($_.in,$_.inlen-$_.rem,$_.rem));var _40=$a();var _41=$k[--$j];$P($k[--$j],_41,_40)}$k[$j++]=$_.out};if($_.ccc){$_.barlen=$_.barcode.length;$_.datcws=$a(~~($_.barlen/6)*5+$_.barlen%6+2);$p($_.datcws,0,920);var _4C=$_.barlen%6==0?924:901;$p($_.datcws,1,_4C);$k[$j++]=$_.datcws;$k[$j++]=2;$k[$j++]=Infinity;$F($_.barcode);var _4F=$a();$k[$j++]=_4F;$_.encb();var _4G=$k[--$j];var _4H=$k[--$j];$P($k[--$j],_4H,_4G)}if(!$_.raw&&!$_.ccc){var _4N=new Map([["parse",$_.parse],["parsefnc",$_.parsefnc],["eci",true]]);$_.fncvals=_4N;$k[$j++]="msg";$k[$j++]=$_.barcode;$k[$j++]=$_.fncvals;bwipp_parseinput();var _4Q=$k[--$j];$_[$k[--$j]]=_4Q;$_.msglen=$_.msg.length;$k[$j++]=Infinity;for(var _4U=0,_4V=$_.msglen;_4U<_4V;_4U++){$k[$j++]=0}$k[$j++]=0;$_.numdigits=$a();$k[$j++]=Infinity;for(var _4Y=0,_4Z=$_.msglen;_4Y<_4Z;_4Y++){$k[$j++]=0}$k[$j++]=0;$_.numtext=$a();$k[$j++]=Infinity;for(var _4c=0,_4d=$_.msglen;_4c<_4d;_4c++){$k[$j++]=0}$k[$j++]=0;$_.numbytes=$a();$k[$j++]=Infinity;for(var _4g=0,_4h=$_.msglen;_4g<_4h;_4g++){$k[$j++]=0}$k[$j++]=0;$_.iseci=$a();for(var _4k=$_.msglen-1;_4k>=0;_4k-=1){$_.i=_4k;var _4n=$g($_.msg,$_.i);if(_4n>=48&&_4n<=57){$p($_.numdigits,$_.i,$g($_.numdigits,$_.i+1)+1)}var _4x=$g($_.alltext,$g($_.msg,$_.i))!==undefined;if(_4x&&$g($_.numdigits,$_.i)<13){$p($_.numtext,$_.i,$g($_.numtext,$_.i+1)+1)}if($g($_.msg,$_.i)>=0&&$g($_.numtext,$_.i)<5&&$g($_.numdigits,$_.i)<13){$p($_.numbytes,$_.i,$g($_.numbytes,$_.i+1)+1)}$p($_.iseci,$_.i,$g($_.msg,$_.i)<=-1e6)}$_.numdigits=$G($_.numdigits,0,$_.msglen);$_.numtext=$G($_.numtext,0,$_.msglen);$_.numbytes=$G($_.numbytes,0,$_.msglen);$_.seq=$a([]);$_.seqlen=0;$_.state=$_.T;$_.p=0;for(;;){if($_.p==$_.msglen){break}if($g($_.iseci,$_.p)){$_.eci=$g($_.msg,$_.p);$k[$j++]=Infinity;$q($_.seq);$k[$j++]=$a([$_.eci]);$_.seq=$a();$_.p=$_.p+1;$k[$j++]="seqlen";$k[$j++]=$_.seqlen;if($_.eci<=-1810900){$k[$j++]=2}else{var _5q=$_.eci<=-1000900?3:2;$k[$j++]=_5q}var _5r=$k[--$j];var _5s=$k[--$j];$_[$k[--$j]]=$f(_5s+_5r)}else{$_.n=$g($_.numdigits,$_.p);if($_.n>=13||$_.n==$_.msglen&&$_.n>=8){$k[$j++]=Infinity;$q($_.seq);$k[$j++]=$_.nl;$k[$j++]=Infinity;$q($G($_.msg,$_.p,$_.n));var _67=$a();$k[$j++]=_67;$_.seq=$a();$_.state=$_.N;$_.p=$f($_.p+$_.n);$_.seqlen=$f($_.seqlen+1+$_.n)}else{$_.t=$g($_.numtext,$_.p);if($_.t>=5){$k[$j++]=Infinity;$q($_.seq);if($_.state!=$_.T){$k[$j++]=$_.tl}$k[$j++]=Infinity;$q($G($_.msg,$_.p,$_.t));var _6Q=$a();$k[$j++]=_6Q;$_.seq=$a();$_.state=$_.T;$_.p=$f($_.p+$_.t);$_.seqlen=$f($_.seqlen+1+$_.t)}else{$_.b=$g($_.numbytes,$_.p);if($_.b==1&&$_.state==$_.T){$k[$j++]=Infinity;$q($_.seq);$k[$j++]=$_.bs;$k[$j++]=$a([$g($_.msg,$_.p)]);$_.seq=$a();$_.p=$f($_.p+$_.b);$_.seqlen=$_.seqlen+2}else{$k[$j++]=Infinity;$q($_.seq);var _6p=$_.b%6!=0?$_.bl:$_.bl6;$k[$j++]=_6p;$k[$j++]=Infinity;$q($G($_.msg,$_.p,$_.b));var _6u=$a();$k[$j++]=_6u;$_.seq=$a();$_.state=$_.B;$_.p=$f($_.p+$_.b);$_.seqlen=$f($_.seqlen+1+$_.b)}}}}}$_.enca=function(){var _75=$g($g($_.charvals,$_.A),$k[--$j]);$k[$j++]=_75};$_.encl=function(){var _7A=$g($g($_.charvals,$_.L),$k[--$j]);$k[$j++]=_7A};$_.encm=function(){var _7F=$g($g($_.charvals,$_.M),$k[--$j]);$k[$j++]=_7F};$_.encp=function(){var _7K=$g($g($_.charvals,$_.P),$k[--$j]);$k[$j++]=_7K};$_.textencfuncs=$a(["enca","encl","encm","encp"]);$_.addtotext=function(){$p($_.text,$_.l,$k[--$j]);$_.l=$_.l+1};$_.enct=function(){$_.in=$k[--$j];$_.curlen=$a([$_.e,$_.e,$_.e,$_.e]);$p($_.curlen,$_.submode,0);$_.curseq=$a([$a([]),$a([]),$a([]),$a([])]);$F($_.in,function(){$_.char=$k[--$j];for(;;){$_.imp=false;var _7j=$a([$_.A,$_.L,$_.M,$_.P]);for(var _7k=0,_7l=_7j.length;_7k<_7l;_7k++){$_.x=$g(_7j,_7k);var _7r=$a([$_.A,$_.L,$_.M,$_.P]);for(var _7s=0,_7t=_7r.length;_7s<_7t;_7s++){$_.y=$g(_7r,_7s);$_.cost=$f($g($_.curlen,$_.x)+$g($g($_.latlen,$_.x),$_.y));if($_.cost<$g($_.curlen,$_.y)){$p($_.curlen,$_.y,$_.cost);$k[$j++]=$_.curseq;$k[$j++]=$_.y;$k[$j++]=Infinity;$q($g($_.curseq,$_.x));$q($g($g($_.latseq,$_.x),$_.y));var _8K=$a();var _8L=$k[--$j];$p($k[--$j],_8L,_8K);$_.imp=true}}}if(!$_.imp){break}}$_.nxtlen=$a([$_.e,$_.e,$_.e,$_.e]);$_.nxtseq=$a(4);var _8Y=$a([$_.A,$_.L,$_.M,$_.P]);for(var _8Z=0,_8a=_8Y.length;_8Z<_8a;_8Z++){$_.x=$g(_8Y,_8Z);for(;;){var _8g=$g($g($_.charvals,$_.x),$_.char)!==undefined;if(!_8g){break}$_.cost=$g($_.curlen,$_.x)+1;if($_.cost<$g($_.nxtlen,$_.x)){$p($_.nxtlen,$_.x,$_.cost);$k[$j++]=$_.nxtseq;$k[$j++]=$_.x;$k[$j++]=Infinity;$q($g($_.curseq,$_.x));$k[$j++]=$_.char;var _8x=$a();var _8y=$k[--$j];$p($k[--$j],_8y,_8x)}var _94=$a([$_.A,$_.L,$_.M,$_.P]);for(var _95=0,_96=_94.length;_95<_96;_95++){$_.y=$g(_94,_95);if($ne($_.x,$_.y)){$_.cost=$f($g($_.curlen,$_.y)+$g($g($_.shftlen,$_.y),$_.x))+1;if($_.cost<$g($_.nxtlen,$_.y)){$p($_.nxtlen,$_.y,$_.cost);$k[$j++]=$_.nxtseq;$k[$j++]=$_.y;$k[$j++]=Infinity;$q($g($_.curseq,$_.y));var _9W=$_.x==$_.A?$_.as:$_.ps;$k[$j++]=_9W;$k[$j++]=$_.char;var _9Y=$a();var _9Z=$k[--$j];$p($k[--$j],_9Z,_9Y)}}}break}}$_.curlen=$_.nxtlen;$_.curseq=$_.nxtseq});$_.minseq=$_.e;var _9i=$a([$_.A,$_.L,$_.M,$_.P]);for(var _9j=0,_9k=_9i.length;_9j<_9k;_9j++){$_.k=$g(_9i,_9j);if($g($_.curlen,$_.k)<$_.minseq){$_.minseq=$g($_.curlen,$_.k);$_.txtseq=$g($_.curseq,$_.k)}}$_.text=$a($_.minseq);$_.k=0;$_.l=0;for(;;){if($_.k>=$_.txtseq.length){break}$_.char=$g($_.txtseq,$_.k);$k[$j++]=$_.char;if($_[$g($_.textencfuncs,$_.submode)]()===true){break}$_.addtotext();$_.k=$_.k+1;if($_.char==$_.as||$_.char==$_.ps){$k[$j++]=$g($_.txtseq,$_.k);if($_.char==$_.as){$_.enca()}else{$_.encp()}$_.addtotext();$_.k=$_.k+1}if($_.char==$_.al){$_.submode=$_.A}if($_.char==$_.ll){$_.submode=$_.L}if($_.char==$_.ml){$_.submode=$_.M}if($_.char==$_.pl){$_.submode=$_.P}}if($_.text.length%2==1){if($_.submode==$_.P){$k[$j++]="pad";$k[$j++]=$_.al;$_.encp();var _AZ=$k[--$j];$_[$k[--$j]]=_AZ;$_.submode=$_.A}else{$_.nextecitext=false;for(var _Af=$_.i+1,_Ae=$_.seq.length-1;_Af<=_Ae;_Af+=1){$_.ti=_Af;if($ne($t($g($_.seq,$_.ti)),"arraytype")){$_.nextecitext=false;break}if($g($g($_.seq,$_.ti),0)>-1e6){break}$_.nextecitext=true}if($_.nextecitext){if($_.submode==$_.A){var _Ay=$g($g($_.charvals,$_.L),$g($g($_.seq,$_.ti),0))!==undefined;if(_Ay){$k[$j++]="pad";$k[$j++]=$_.ll;$_.enca();var _B0=$k[--$j];$_[$k[--$j]]=_B0;$_.submode=$_.L}else{$k[$j++]="pad";$k[$j++]=$_.ml;$_.enca();var _B4=$k[--$j];$_[$k[--$j]]=_B4;$_.submode=$_.M}}else{if($_.submode==$_.M){var _BG=$g($g($_.charvals,$_.L),$g($g($_.seq,$_.ti),0))!==undefined;if(_BG){$k[$j++]="pad";$k[$j++]=$_.ll;$_.encm();var _BI=$k[--$j];$_[$k[--$j]]=_BI;$_.submode=$_.L}else{var _BS=$g($g($_.charvals,$_.P),$g($g($_.seq,$_.ti),0))!==undefined;if(_BS){$k[$j++]="pad";$k[$j++]=$_.pl;$_.encm();var _BU=$k[--$j];$_[$k[--$j]]=_BU;$_.submode=$_.P}else{$k[$j++]="pad";$k[$j++]=$_.al;$_.encm();var _BY=$k[--$j];$_[$k[--$j]]=_BY;$_.submode=$_.A}}}else{$k[$j++]="pad";$k[$j++]=$_.ml;$_.encl();var _Bc=$k[--$j];$_[$k[--$j]]=_Bc;$_.submode=$_.M}}}else{$k[$j++]="pad";$k[$j++]=$_.ps;if($_[$g($_.textencfuncs,$_.submode)]()===true){return true}var _Bk=$k[--$j];$_[$k[--$j]]=_Bk}}$k[$j++]=Infinity;$q($_.text);$k[$j++]=$_.pad;$_.text=$a()}$_.out=$a(~~($_.text.length/2));for(var _Bt=0,_Bs=$_.out.length-1;_Bt<=_Bs;_Bt+=1){$_.k=_Bt;$p($_.out,$_.k,$f($g($_.text,$_.k*2)*30+$g($_.text,$_.k*2+1)))}$k[$j++]=$_.out};$_.encn=function(){$_.in=$k[--$j];$_.out=$a([]);for(var _C7=0,_C6=$_.in.length-1;_C7<=_C6;_C7+=44){$_.k=_C7;$k[$j++]=Infinity;var _CC=$_.in.length-$_.k;$k[$j++]=1;$k[$j++]=$_.in;$k[$j++]=$_.k;$k[$j++]=_CC;if(_CC>44){$k[$j-1]=44}var _CD=$k[--$j];var _CE=$k[--$j];var _CG=$G($k[--$j],_CE,_CD);for(var _CH=0,_CI=_CG.length;_CH<_CI;_CH++){$k[$j++]=$g(_CG,_CH)-48}$_.gmod=$a();$_.cwn=$a([]);for(;;){$_.dv=900;$_.gmul=$a([]);$_.val=0;for(;;){if($_.gmod.length==0){break}$_.val=$f($_.val*10+$g($_.gmod,0));$_.gmod=$G($_.gmod,1,$_.gmod.length-1);if($_.val<$_.dv){if($_.gmul.length!=0){$k[$j++]=Infinity;$q($_.gmul);$k[$j++]=0;$_.gmul=$a()}}else{$k[$j++]=Infinity;$q($_.gmul);$k[$j++]=~~($_.val/$_.dv);$_.gmul=$a()}$_.val=$_.val%$_.dv}$_.dv=$_.val;$k[$j++]=Infinity;$k[$j++]=$_.dv;$q($_.cwn);$_.cwn=$a();$_.gmod=$_.gmul;if($_.gmul.length==0){break}}$k[$j++]=Infinity;$q($_.out);$q($_.cwn);$_.out=$a()}$k[$j++]=$_.out};$_.ence=function(){var _Cr=-$g($k[--$j],0)-1e6;$k[$j++]=_Cr;if(_Cr<=899){var _Cs=$k[--$j];$k[$j++]=927;$k[$j++]=_Cs;$as($a(2))}else{var _Cu=$k[$j-1];if(_Cu<=810899){var _Cv=$k[--$j];$k[$j++]=926;$k[$j++]=~~(_Cv/900)-1;$k[$j++]=_Cv%900;$as($a(3))}else{var _Cx=$k[$j-1];if(_Cx<=811799){var _Cy=$k[--$j];$k[$j++]=925;$k[$j++]=_Cy-810900;$as($a(2))}else{$k[$j++]="bwipp.pdf417badECI#18089";$k[$j++]="PDF417 supports ECIs 000000 to 811799";bwipp_raiseerror()}}}};$_.encfuncs=$a(["enct","encn","encb"]);$_.addtocws=function(){var _D1=$k[--$j];$P($_.datcws,$_.j,_D1);$_.j=_D1.length+$_.j};$_.state=$_.T;$_.submode=$_.A;$_.datcws=$a($_.seqlen);$_.i=0;$_.j=0;for(;;){if($_.i>=$_.seq.length){break}$_.chars=$g($_.seq,$_.i);if($eq($t($_.chars),"arraytype")){if($g($_.chars,0)<=-1e6){$k[$j++]=$_.chars;$_.ence();$_.addtocws()}else{$k[$j++]=$_.chars;if($_[$g($_.encfuncs,$_.state)]()===true){break}$_.addtocws()}}else{$k[$j++]=$a([$g($_.latchcws,$_.chars)]);$_.addtocws();if($_.chars==$_.tl){$_.state=$_.T;$_.submode=$_.A}if($_.chars==$_.nl){$_.state=$_.N}if($_.chars==$_.bl||$_.chars==$_.bl6){$_.state=$_.B}if($_.chars==$_.bs){$_.i=$_.i+1;$k[$j++]=$g($_.seq,$_.i);$_.encb();$_.addtocws()}}$_.i=$_.i+1}$_.datcws=$G($_.datcws,0,$_.j)}$_.m=$_.datcws.length;if($_.m>926){$k[$j++]="bwipp.pdf417dataTooLong#18129";$k[$j++]="The data is too long";bwipp_raiseerror()}if($_.eclevel==-1){if($_.m<=40){$_.eclevel=2}if($_.m>=41&&$_.m<=160){$_.eclevel=3}if($_.m>=161&&$_.m<=320){$_.eclevel=4}if($_.m>=321){$_.eclevel=5}}if(!$_.fixedeclevel){$_.maxeclevel=~~($log(928-1-$_.m)/$log(2))-1;if($_.eclevel>$_.maxeclevel){$_.eclevel=$_.maxeclevel}}$_.k=~~$pow(2,$_.eclevel+1);if($_.columns==0){$_.columns=~~$round($sqrt(($_.m+$_.k)/3))}$k[$j++]="c";if($_.columns>=1){$k[$j++]=$_.columns}else{$k[$j++]=1}var _E8=$k[--$j];$_[$k[--$j]]=_E8;$_.r=~~$ceil(($_.m+$_.k+1)/$_.columns);if($_.r<$_.rows&&$_.rows<=90){$_.r=$_.rows}if($_.r<3){$_.r=3}if($_.r>90){$k[$j++]="bwipp.pdf417insufficientCapacity#18158";$k[$j++]="Insufficient capacity in the symbol";bwipp_raiseerror()}if(!$_.fixedeclevel){var _EK=$_.c;var _EL=$_.r;var _EM=$_.m;var _EN=8;var _EO=~~($log($f(_EK*_EL-1-_EM))/$log(2))-1;if(~~($log($f(_EK*_EL-1-_EM))/$log(2))-1>8){var _=_EN;_EN=_EO;_EO=_}$_.maxeclevel=_EO;if($_.maxeclevel>$_.eclevel){$_.eclevel=$_.maxeclevel;$_.k=~~$pow(2,$_.eclevel+1)}}$_.n=$f($_.c*$_.r-$_.k);$_.cws=$a($_.c*$_.r+1);$p($_.cws,0,$_.n);$P($_.cws,1,$_.datcws);$k[$j++]=$_.cws;$k[$j++]=$_.m+1;$k[$j++]=Infinity;for(var _Eh=0,_Ei=$f($_.n-$_.m)-1;_Eh<_Ei;_Eh++){$k[$j++]=900}var _Ej=$a();var _Ek=$k[--$j];$P($k[--$j],_Ek,_Ej);$k[$j++]=$_.cws;$k[$j++]=$_.n;$k[$j++]=Infinity;for(var _Ep=0,_Eq=$_.k;_Ep<_Eq;_Ep++){$k[$j++]=0}$k[$j++]=0;var _Er=$a();var _Es=$k[--$j];$P($k[--$j],_Es,_Er);$k[$j++]=Infinity;$k[$j++]=1;for(var _Eu=0;_Eu<928;_Eu++){var _Ev=$k[$j-1];$k[$j++]=_Ev*3%929}$_.rsalog=$a();$_.rslog=$a(929);for(var _Ey=1;_Ey<=928;_Ey+=1){$p($_.rslog,$g($_.rsalog,_Ey),_Ey)}$_.rsprod=function(){var _F3=$k[$j-1];var _F4=$k[$j-2];if(_F3!=0&&_F4!=0){var _F7=$g($_.rslog,$k[--$j]);var _FC=$g($_.rsalog,$f(_F7+$g($_.rslog,$k[--$j]))%928);$k[$j++]=_FC}else{$j-=2;$k[$j++]=0}};$k[$j++]=Infinity;$k[$j++]=1;for(var _FE=0,_FF=$_.k;_FE<_FF;_FE++){$k[$j++]=0}$_.coeffs=$a();for(var _FJ=1,_FI=$_.k;_FJ<=_FI;_FJ+=1){$_.i=_FJ;$p($_.coeffs,$_.i,$g($_.coeffs,$_.i-1));for(var _FQ=$_.i-1;_FQ>=1;_FQ-=1){$_.j=_FQ;$k[$j++]=$_.coeffs;$k[$j++]=$_.j;$k[$j++]=$g($_.coeffs,$_.j-1);$k[$j++]=$g($_.coeffs,$_.j);$k[$j++]=$g($_.rsalog,$_.i);$_.rsprod();var _Fc=$k[--$j];var _Fd=$k[--$j];var _Fe=$k[--$j];$p($k[--$j],_Fe,$f(_Fd+_Fc)%929)}$k[$j++]=$_.coeffs;$k[$j++]=0;$k[$j++]=$g($_.coeffs,0);$k[$j++]=$g($_.rsalog,$_.i);$_.rsprod();var _Fm=$k[--$j];var _Fn=$k[--$j];$p($k[--$j],_Fn,_Fm)}$_.coeffs=$G($_.coeffs,0,$_.coeffs.length-1);for(var _Ft=$_.coeffs.length-1;_Ft>=0;_Ft-=2){var _Fu=$_.coeffs;$p(_Fu,_Ft,929-$g(_Fu,_Ft))}for(var _Fy=0,_Fx=$_.n-1;_Fy<=_Fx;_Fy+=1){$_.t=$f($g($_.cws,_Fy)+$g($_.cws,$_.n))%929;for(var _G6=0,_G5=$_.k-1;_G6<=_G5;_G6+=1){$_.j=_G6;$p($_.cws,$f($_.n+$_.j),$f($g($_.cws,$f($_.n+$_.j)+1)+(929-$_.t*$g($_.coeffs,$_.k-$_.j-1)%929))%929)}}for(var _GN=$_.n,_GM=$f($_.n+$_.k);_GN<=_GM;_GN+=1){$p($_.cws,_GN,(929-$g($_.cws,_GN))%929)}$_.cws=$G($_.cws,0,$_.cws.length-1);var _GV=$g($_.options,"debugcws")!==undefined;if(_GV){$k[$j++]="bwipp.debugcws#18221";$k[$j++]=$_.cws;bwipp_raiseerror()}$_.clusters=$a([$a([120256,125680,128380,120032,125560,128318,108736,119920,108640,86080,108592,86048,110016,120560,125820,109792,120440,125758,88256,109680,88160,89536,110320,120700,89312,110200,120638,89200,110140,89840,110460,89720,110398,89980,128506,119520,125304,128190,107712,119408,125244,107616,119352,84032,107568,119324,84e3,107544,83984,108256,119672,125374,85184,108144,119612,85088,108088,119582,85040,108060,85728,108408,119742,85616,108348,85560,108318,85880,108478,85820,85790,107200,119152,125116,107104,119096,125086,83008,107056,119068,82976,107032,82960,82952,83648,107376,119228,83552,107320,119198,83504,107292,83480,83468,83824,107452,83768,107422,83740,83900,106848,118968,125022,82496,106800,118940,82464,106776,118926,82448,106764,82440,106758,82784,106936,119006,82736,106908,82712,106894,82700,82694,106974,82830,82240,106672,118876,82208,106648,118862,82192,106636,82184,106630,82180,82352,82328,82316,82080,118830,106572,106566,82050,117472,124280,127678,103616,117360,124220,103520,117304,124190,75840,103472,75808,104160,117624,124350,76992,104048,117564,76896,103992,76848,76824,77536,104312,117694,77424,104252,77368,77340,77688,104382,77628,77758,121536,126320,128700,121440,126264,128670,111680,121392,126236,111648,121368,126222,111632,121356,103104,117104,124092,112320,103008,117048,124062,112224,121656,126366,93248,74784,102936,117006,93216,112152,93200,75456,103280,117180,93888,75360,103224,117150,93792,112440,121758,93744,75288,93720,75632,103356,94064,75576,103326,94008,112542,93980,75708,94140,75678,94110,121184,126136,128606,111168,121136,126108,111136,121112,126094,111120,121100,111112,111108,102752,116920,123998,111456,102704,116892,91712,74272,121244,116878,91680,74256,102668,91664,111372,102662,74244,74592,102840,116958,92e3,74544,102812,91952,111516,102798,91928,74508,74502,74680,102878,92088,74652,92060,74638,92046,92126,110912,121008,126044,110880,120984,126030,110864,120972,110856,120966,110852,110850,74048,102576,116828,90944,74016,102552,116814,90912,111e3,121038,90896,73992,102534,90888,110982,90884,74160,102620,91056,74136,102606,91032,111054,91020,74118,91014,91100,91086,110752,120920,125998,110736,120908,110728,120902,110724,110722,73888,102488,116782,90528,73872,102476,90512,110796,102470,90504,73860,90500,73858,73944,90584,90572,90566,120876,120870,110658,102444,73800,90312,90308,90306,101056,116080,123580,100960,116024,70720,100912,115996,70688,100888,70672,70664,71360,101232,116156,71264,101176,116126,71216,101148,71192,71180,71536,101308,71480,101278,71452,71612,71582,118112,124600,127838,105024,118064,124572,104992,118040,124558,104976,118028,104968,118022,100704,115896,123486,105312,100656,115868,79424,70176,118172,115854,79392,105240,100620,79376,70152,79368,70496,100792,115934,79712,70448,118238,79664,105372,100750,79640,70412,79628,70584,100830,79800,70556,79772,70542,70622,79838,122176,126640,128860,122144,126616,128846,122128,126604,122120,126598,122116,104768,117936,124508,113472,104736,126684,124494,113440,122264,126670,113424,104712,117894,113416,122246,104706,69952,100528,115804,78656,69920,100504,115790,96064,78624,104856,117966,96032,113560,122318,100486,96016,78600,104838,96008,69890,70064,100572,78768,70040,100558,96176,78744,104910,96152,113614,70022,78726,70108,78812,70094,96220,78798,122016,126552,128814,122e3,126540,121992,126534,121988,121986,104608,117848,124462,113056,104592,126574,113040,122060,117830,113032,104580,113028,104578,113026,69792,100440,115758,78240,69776,100428,95136,78224,104652,100422,95120,113100,69764,95112,78212,69762,78210,69848,100462,78296,69836,95192,78284,69830,95180,78278,69870,95214,121936,126508,121928,126502,121924,121922,104528,117804,112848,104520,117798,112840,121958,112836,104514,112834,69712,100396,78032,69704,100390,94672,78024,104550,94664,112870,69698,94660,78018,94658,78060,94700,94694,126486,121890,117782,104484,104482,69672,77928,94440,69666,77922,99680,68160,99632,68128,99608,115342,68112,99596,68104,99590,68448,99768,115422,68400,99740,68376,99726,68364,68358,68536,99806,68508,68494,68574,101696,116400,123740,101664,116376,101648,116364,101640,116358,101636,67904,99504,115292,72512,67872,116444,115278,72480,101784,116430,72464,67848,99462,72456,101766,67842,68016,99548,72624,67992,99534,72600,101838,72588,67974,68060,72668,68046,72654,118432,124760,127918,118416,124748,118408,124742,118404,118402,101536,116312,105888,101520,116300,105872,118476,116294,105864,101508,105860,101506,105858,67744,99416,72096,67728,116334,80800,72080,101580,99398,80784,105932,67716,80776,72068,67714,72066,67800,99438,72152,67788,80856,72140,67782,80844,72134,67822,72174,80878,126800,128940,126792,128934,126788,126786,118352,124716,122576,126828,124710,122568,126822,122564,118338,122562,101456,116268,105680,101448,116262,114128,105672,118374,114120,122598,101442,114116,105666,114114,67664,99372,71888,67656,99366,80336,71880,101478,97232,80328,105702,67650,97224,114150,71874,97220,67692,71916,67686,80364,71910,97260,80358,97254,126760,128918,126756,126754,118312,124694,122472,126774,122468,118306,122466,101416,116246,105576,101412,113896,105572,101410,113892,105570,113890,67624,99350,71784,101430,80104,71780,67618,96744,80100,71778,96740,80098,96738,71798,96758,126738,122420,122418,105524,113780,113778,71732,79988,96500,96498,66880,66848,98968,66832,66824,66820,66992,66968,66956,66950,67036,67022,1e5,99984,115532,99976,115526,99972,99970,66720,98904,69024,100056,98892,69008,100044,69e3,100038,68996,66690,68994,66776,98926,69080,100078,69068,66758,69062,66798,69102,116560,116552,116548,116546,99920,102096,116588,115494,102088,116582,102084,99906,102082,66640,68816,66632,98854,73168,68808,66628,73160,68804,66626,73156,68802,66668,68844,66662,73196,68838,73190,124840,124836,124834,116520,118632,124854,118628,116514,118626,99880,115478,101992,116534,106216,101988,99874,106212,101986,106210,66600,98838,68712,99894,72936,68708,66594,81384,72932,68706,81380,72930,66614,68726,72950,81398,128980,128978,124820,126900,124818,126898,116500,118580,116498,122740,118578,122738,99860,101940,99858,106100,101938,114420]),$a([128352,129720,125504,128304,129692,125472,128280,129678,125456,128268,125448,128262,125444,125792,128440,129758,120384,125744,128412,120352,125720,128398,120336,125708,120328,125702,120324,120672,125880,128478,110144,120624,125852,110112,120600,125838,110096,120588,110088,120582,110084,110432,120760,125918,89664,110384,120732,89632,110360,120718,89616,110348,89608,110342,89952,110520,120798,89904,110492,89880,110478,89868,90040,110558,90012,89998,125248,128176,129628,125216,128152,129614,125200,128140,125192,128134,125188,125186,119616,125360,128220,119584,125336,128206,119568,125324,119560,125318,119556,119554,108352,119728,125404,108320,119704,125390,108304,119692,108296,119686,108292,108290,85824,108464,119772,85792,108440,119758,85776,108428,85768,108422,85764,85936,108508,85912,108494,85900,85894,85980,85966,125088,128088,129582,125072,128076,125064,128070,125060,125058,119200,125144,128110,119184,125132,119176,125126,119172,119170,107424,119256,125166,107408,119244,107400,119238,107396,107394,83872,107480,119278,83856,107468,83848,107462,83844,83842,83928,107502,83916,83910,83950,125008,128044,125e3,128038,124996,124994,118992,125036,118984,125030,118980,118978,106960,119020,106952,119014,106948,106946,82896,106988,82888,106982,82884,82882,82924,82918,124968,128022,124964,124962,118888,124982,118884,118882,106728,118902,106724,106722,82408,106742,82404,82402,124948,124946,118836,118834,106612,106610,124224,127664,129372,124192,127640,129358,124176,127628,124168,127622,124164,124162,117568,124336,127708,117536,124312,127694,117520,124300,117512,124294,117508,117506,104256,117680,124380,104224,117656,124366,104208,117644,104200,117638,104196,104194,77632,104368,117724,77600,104344,117710,77584,104332,77576,104326,77572,77744,104412,77720,104398,77708,77702,77788,77774,128672,129880,93168,128656,129868,92664,128648,129862,92412,128644,128642,124064,127576,129326,126368,124048,129902,126352,128716,127558,126344,124036,126340,124034,126338,117152,124120,127598,121760,117136,124108,121744,126412,124102,121736,117124,121732,117122,121730,103328,117208,124142,112544,103312,117196,112528,121804,117190,112520,103300,112516,103298,112514,75680,103384,117230,94112,75664,103372,94096,112588,103366,94088,75652,94084,75650,75736,103406,94168,75724,94156,75718,94150,75758,128592,129836,91640,128584,129830,91388,128580,91262,128578,123984,127532,126160,123976,127526,126152,128614,126148,123970,126146,116944,124012,121296,116936,124006,121288,126182,121284,116930,121282,102864,116972,111568,102856,116966,111560,121318,111556,102850,111554,74704,102892,92112,74696,102886,92104,111590,92100,74690,92098,74732,92140,74726,92134,128552,129814,90876,128548,90750,128546,123944,127510,126056,128566,126052,123938,126050,116840,123958,121064,116836,121060,116834,121058,102632,116854,111080,121078,111076,102626,111074,74216,102646,91112,74212,91108,74210,91106,74230,91126,128532,90494,128530,123924,126004,123922,126002,116788,120948,116786,120946,102516,110836,102514,110834,73972,90612,73970,90610,128522,123914,125978,116762,120890,102458,110714,123552,127320,129198,123536,127308,123528,127302,123524,123522,116128,123608,127342,116112,123596,116104,123590,116100,116098,101280,116184,123630,101264,116172,101256,116166,101252,101250,71584,101336,116206,71568,101324,71560,101318,71556,71554,71640,101358,71628,71622,71662,127824,129452,79352,127816,129446,79100,127812,78974,127810,123472,127276,124624,123464,127270,124616,127846,124612,123458,124610,115920,123500,118224,115912,123494,118216,124646,118212,115906,118210,100816,115948,105424,100808,115942,105416,118246,105412,100802,105410,70608,100844,79824,70600,100838,79816,105446,79812,70594,79810,70636,79852,70630,79846,129960,95728,113404,129956,95480,113278,129954,95356,95294,127784,129430,78588,128872,129974,95996,78462,128868,127778,95870,128866,123432,127254,124520,123428,126696,128886,123426,126692,124514,126690,115816,123446,117992,115812,122344,117988,115810,122340,117986,122338,100584,115830,104936,100580,113640,104932,100578,113636,104930,113634,70120,100598,78824,70116,96232,78820,70114,96228,78818,96226,70134,78838,129940,94968,113022,129938,94844,94782,127764,78206,128820,127762,95102,128818,123412,124468,123410,126580,124466,126578,115764,117876,115762,122100,117874,122098,100468,104692,100466,113140,104690,113138,69876,78324,69874,95220,78322,95218,129930,94588,94526,127754,128794,123402,124442,126522,115738,117818,121978,100410,104570,112890,69754,78074,94714,94398,123216,127148,123208,127142,123204,123202,115408,123244,115400,123238,115396,115394,99792,115436,99784,115430,99780,99778,68560,99820,68552,99814,68548,68546,68588,68582,127400,129238,72444,127396,72318,127394,123176,127126,123752,123172,123748,123170,123746,115304,123190,116456,115300,116452,115298,116450,99560,115318,101864,99556,101860,99554,101858,68072,99574,72680,68068,72676,68066,72674,68086,72694,129492,80632,105854,129490,80508,80446,127380,72062,127924,127378,80766,127922,123156,123700,123154,124788,123698,124786,115252,116340,115250,118516,116338,118514,99444,101620,99442,105972,101618,105970,67828,72180,67826,80884,72178,80882,97008,114044,96888,113982,96828,96798,129482,80252,130010,97148,80190,97086,127370,127898,128954,123146,123674,124730,126842,115226,116282,118394,122618,99386,101498,105722,114170,67706,71930,80378,96632,113854,96572,96542,80062,96702,96444,96414,96350,123048,123044,123042,115048,123062,115044,115042,99048,115062,99044,99042,67048,99062,67044,67042,67062,127188,68990,127186,123028,123316,123026,123314,114996,115572,114994,115570,98932,100084,98930,100082,66804,69108,66802,69106,129258,73084,73022,127178,127450,123018,123290,123834,114970,115514,116602,98874,99962,102138,66682,68858,73210,81272,106174,81212,81182,72894,81342,97648,114364,97592,114334,97564,97550,81084,97724,81054,97694,97464,114270,97436,97422,80990,97502,97372,97358,97326,114868,114866,98676,98674,66292,66290,123098,114842,115130,98618,99194,66170,67322,69310,73404,73374,81592,106334,81564,81550,73310,81630,97968,114524,97944,114510,97932,97926,81500,98012,81486,97998,97880,114478,97868,97862,81454,97902,97836,97830,69470,73564,73550,81752,106414,81740,81734,73518,81774,81708,81702]),$a([109536,120312,86976,109040,120060,86496,108792,119934,86256,108668,86136,129744,89056,110072,129736,88560,109820,129732,88312,109694,129730,88188,128464,129772,89592,128456,129766,89340,128452,89214,128450,125904,128492,125896,128486,125892,125890,120784,125932,120776,125926,120772,120770,110544,120812,110536,120806,110532,84928,108016,119548,84448,107768,119422,84208,107644,84088,107582,84028,129640,85488,108284,129636,85240,108158,129634,85116,85054,128232,129654,85756,128228,85630,128226,125416,128246,125412,125410,119784,125430,119780,119778,108520,119798,108516,108514,83424,107256,119166,83184,107132,83064,107070,83004,82974,129588,83704,107390,129586,83580,83518,128116,83838,128114,125172,125170,119284,119282,107508,107506,82672,106876,82552,106814,82492,82462,129562,82812,82750,128058,125050,119034,82296,106686,82236,82206,82366,82108,82078,76736,103920,117500,76256,103672,117374,76016,103548,75896,103486,75836,129384,77296,104188,129380,77048,104062,129378,76924,76862,127720,129398,77564,127716,77438,127714,124392,127734,124388,124386,117736,124406,117732,117730,104424,117750,104420,104418,112096,121592,126334,92608,111856,121468,92384,111736,121406,92272,111676,92216,111646,92188,75232,103160,117118,93664,74992,103036,93424,112252,102974,93304,74812,93244,74782,93214,129332,75512,103294,129908,129330,93944,75388,129906,93820,75326,93758,127604,75646,128756,127602,94078,128754,124148,126452,124146,126450,117236,121844,117234,121842,103412,103410,91584,111344,121212,91360,111224,121150,91248,111164,91192,111134,91164,91150,74480,102780,91888,74360,102718,91768,111422,91708,74270,91678,129306,74620,129850,92028,74558,91966,127546,128634,124026,126202,116986,121338,102906,90848,110968,121022,90736,110908,90680,110878,90652,90638,74104,102590,91e3,74044,90940,74014,90910,74174,91070,90480,110780,90424,110750,90396,90382,73916,90556,73886,90526,90296,110686,90268,90254,73822,90334,90204,90190,71136,101112,116094,70896,100988,70776,100926,70716,70686,129204,71416,101246,129202,71292,71230,127348,71550,127346,123636,123634,116212,116210,101364,101362,79296,105200,118140,79072,105080,118078,78960,105020,78904,104990,78876,78862,70384,100732,79600,70264,100670,79480,105278,79420,70174,79390,129178,70524,129466,79740,70462,79678,127290,127866,123514,124666,115962,118266,100858,113376,122232,126654,95424,113264,122172,95328,113208,122142,95280,113180,95256,113166,95244,78560,104824,117950,95968,78448,104764,95856,113468,104734,95800,78364,95772,78350,95758,70008,100542,78712,69948,96120,78652,69918,96060,78622,96030,70078,78782,96190,94912,113008,122044,94816,112952,122014,94768,112924,94744,112910,94732,94726,78192,104636,95088,78136,104606,95032,113054,95004,78094,94990,69820,78268,69790,95164,78238,95134,94560,112824,121950,94512,112796,94488,112782,94476,94470,78008,104542,94648,77980,94620,77966,94606,69726,78046,94686,94384,112732,94360,112718,94348,94342,77916,94428,77902,94414,94296,112686,94284,94278,77870,94318,94252,94246,68336,99708,68216,99646,68156,68126,68476,68414,127162,123258,115450,99834,72416,101752,116414,72304,101692,72248,101662,72220,72206,67960,99518,72568,67900,72508,67870,72478,68030,72638,80576,105840,118460,80480,105784,118430,80432,105756,80408,105742,80396,80390,72048,101564,80752,71992,101534,80696,71964,80668,71950,80654,67772,72124,67742,80828,72094,80798,114016,122552,126814,96832,113968,122524,96800,113944,122510,96784,113932,96776,113926,96772,80224,105656,118366,97120,80176,105628,97072,114076,105614,97048,80140,97036,80134,97030,71864,101470,80312,71836,97208,80284,71822,97180,80270,97166,67678,71902,80350,97246,96576,113840,122460,96544,113816,122446,96528,113804,96520,113798,96516,96514,80048,105564,96688,80024,105550,96664,113870,96652,80006,96646,71772,80092,71758,96732,80078,96718,96416,113752,122414,96400,113740,96392,113734,96388,96386,79960,105518,96472,79948,96460,79942,96454,71726,79982,96494,96336,113708,96328,113702,96324,96322,79916,96364,79910,96358,96296,113686,96292,96290,79894,96310,66936,99006,66876,66846,67006,68976,100028,68920,99998,68892,68878,66748,69052,66718,69022,73056,102072,116574,73008,102044,72984,102030,72972,72966,68792,99934,73144,68764,73116,68750,73102,66654,68830,73182,81216,106160,118620,81184,106136,118606,81168,106124,81160,106118,81156,81154,72880,101980,81328,72856,101966,81304,106190,81292,72838,81286,68700,72924,68686,81372,72910,81358,114336,122712,126894,114320,122700,114312,122694,114308,114306,81056,106072,118574,97696,81040,106060,97680,114380,106054,97672,81028,97668,81026,97666,72792,101934,81112,72780,97752,81100,72774,97740,81094,97734,68654,72814,81134,97774,114256,122668,114248,122662,114244,114242,80976,106028,97488,80968,106022,97480,114278,97476,80962,97474,72748,81004,72742,97516,80998,97510,114216,122646,114212,114210,80936,106006,97384,80932,97380,80930,97378,72726,80950,97398,114196,114194,80916,97332,80914,97330,66236,66206,67256,99166,67228,67214,66142,67294,69296,100188,69272,100174,69260,69254,67164,69340,67150,69326,73376,102232,116654,73360,102220,73352,102214,73348,73346,69208,100142,73432,102254,73420,69190,73414,67118,69230,73454,106320,118700,106312,118694,106308,106306,73296,102188,81616,106348,102182,81608,73284,81604,73282,81602,69164,73324,69158,81644,73318,81638,122792,126934,122788,122786,106280,118678,114536,106276,114532,106274,114530,73256,102166,81512,73252,98024,81508,73250,98020,81506,98018,69142,73270,81526,98038,122772,122770,106260,114484,106258,114482,73236,81460,73234,97908,81458,97906,122762,106250,114458,73226,81434,97850,66396,66382,67416,99246,67404,67398,66350,67438,69456,100268,69448,100262,69444,69442,67372,69484,67366,69478,102312,116694,102308,102306,69416,100246,73576,102326,73572,69410,73570,67350,69430,73590,118740,118738,102292,106420,102290,106418,69396,73524,69394,81780,73522,81778,118730,102282,106394,69386,73498,81722,66476,66470,67496,99286,67492,67490,66454,67510,100308,100306,67476,69556,67474,69554,116714])]);$_.cwtobits=function(){var _Ge=$g($_.clusters,$k[--$j]);$_.v=$g(_Ge,$k[--$j]);$k[$j++]=Infinity;for(var _Gh=0;_Gh<17;_Gh++){$k[$j++]=0}var _Gk=$R($s(17),$_.v,2);for(var _Gl=0,_Gm=_Gk.length;_Gl<_Gm;_Gl++){$k[$j++]=$g(_Gk,_Gl)-48}var _Go=$a();$k[$j++]=$G(_Go,_Go.length-17,17)};if($_.compact){$_.rwid=17*$_.c+17+17+1}else{$_.rwid=17*$_.c+17+17+17+18}$_.pixs=$a($_.rwid*$_.r*$_.rowmult);for(var _Gz=0,_Gy=$_.r-1;_Gz<=_Gy;_Gz+=1){$_.i=_Gz;if($_.i%3==0){$_.lcw=~~($_.i/3)*30+~~(($_.r-1)/3);$_.rcw=$f(~~($_.i/3)*30+$_.c)-1}if($_.i%3==1){$_.lcw=~~($_.i/3)*30+$_.eclevel*3+($_.r-1)%3;$_.rcw=~~($_.i/3)*30+~~(($_.r-1)/3)}if($_.i%3==2){$_.lcw=$f(~~($_.i/3)*30+$_.c)-1;$_.rcw=~~($_.i/3)*30+$_.eclevel*3+($_.r-1)%3}$k[$j++]=Infinity;$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$k[$j++]=0;$k[$j++]=1;$k[$j++]=0;$k[$j++]=1;$k[$j++]=0;$k[$j++]=1;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=$_.lcw;$k[$j++]=$_.i%3;$_.cwtobits();$q($k[--$j]);var _HO=$G($_.cws,$_.c*$_.i,$_.c);for(var _HP=0,_HQ=_HO.length;_HP<_HQ;_HP++){$k[$j++]=$g(_HO,_HP);$k[$j++]=$_.i%3;$_.cwtobits();$q($k[--$j])}if($_.compact){$k[$j++]=1}else{$k[$j++]=$_.rcw;$k[$j++]=$_.i%3;$_.cwtobits();$q($k[--$j]);$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$k[$j++]=0;$k[$j++]=1;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=1;$k[$j++]=0;$k[$j++]=1;$k[$j++]=0;$k[$j++]=0;$k[$j++]=1}var _HY=$a();$k[$j++]=_HY;for(var _Hb=0,_Ha=$_.rowmult-1;_Hb<=_Ha;_Hb+=1){var _Hg=$k[$j-1];$P($_.pixs,(_Hb+$_.i*$_.rowmult)*$_.rwid,_Hg)}$j--}var _Hp=new Map([["ren","renmatrix"],["pixs",$_.pixs],["pixx",$_.rwid],["pixy",$_.r*$_.rowmult],["height",$_.r*$_.rowmult/72],["width",$_.rwid/72],["borderleft",2],["borderright",2],["bordertop",2],["borderbottom",2],["opt",$_.options]]);$k[$j++]=_Hp;if(!$_.dontdraw){bwipp_renmatrix()}$_=$__}function bwipp_pdf417compact(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];$p($_.options,"dontdraw",true);$p($_.options,"compact",true);$k[$j++]="args";$k[$j++]=$_.barcode;$k[$j++]=$_.options;bwipp_pdf417();var _6=$k[--$j];$_[$k[--$j]]=_6;$p($_.args,"opt",$_.options);$k[$j++]=$_.args;if(!$_.dontdraw){bwipp_renmatrix()}$_=$__}function bwipp_micropdf417(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.version="unset";$_.columns=0;$_.rows=0;$_.rowmult=2;$_.cca=false;$_.ccb=false;$_.raw=false;$_.parse=false;$_.parsefnc=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.barcode.length==0){$k[$j++]="bwipp.micropdf417emptyData#18631";$k[$j++]="The data must not be empty";bwipp_raiseerror()}if($_.rowmult<=0){$k[$j++]="bwipp.micropdf417badRowMult#18635";$k[$j++]="The row multiplier must be greater than zero";bwipp_raiseerror()}if($_.cca&&$_.ccb||($_.cca&&$_.raw||$_.ccb&&$_.raw)){$k[$j++]="bwipp.micropdf417ccaAndCcb#18639";$k[$j++]="Cannot combine cca, ccb and raw";bwipp_raiseerror()}if($ne($_.version,"unset")){$X($_.version,"x");if($k[--$j]){var _D=$k[--$j];$k[$j-1]=_D;var _F=$k[$j-1];var _G=$k[$j-2];$k[$j++]=_G;$k[$j++]=_F;$as($a(2));$F($k[--$j],function(){var _J=$k[$j-1];$k[$j++]=true;if(_J.length==0){$k[$j-1]=false}var _K=$k[--$j];var _L=$k[--$j];$k[$j++]=_K;$F(_L,function(){var _M=$k[--$j];if(_M<48||_M>57){$k[$j-1]=false}});if(!$k[--$j]){$k[$j++]="bwipp.micropdf417BadVersionBadRowOrColumn#18653";$k[$j++]="version must be formatted as RxC";bwipp_raiseerror()}});$_.rows=$i($k[--$j]);$_.columns=$i($k[--$j])}else{$j--;$k[$j++]="bwipp.micropdf417badVersionFormat#18659";$k[$j++]="version must be formatted as RxC";bwipp_raiseerror()}}$_.T=0;$_.N=1;$_.B=2;$_.A=0;$_.L=1;$_.M=2;$_.P=3;$_.tl=-1;$_.nl=-2;$_.bl=-3;$_.bl6=-4;$_.bs=-5;$_.al=-6;$_.ll=-7;$_.ml=-8;$_.pl=-9;$_.as=-10;$_.ps=-11;$_.m05=-12;$_.m06=-13;$_.charmaps=$a([$a(["A","a","0",";"]),$a(["B","b","1","<"]),$a(["C","c","2",">"]),$a(["D","d","3","@"]),$a(["E","e","4","["]),$a(["F","f","5",92]),$a(["G","g","6","]"]),$a(["H","h","7","_"]),$a(["I","i","8","`"]),$a(["J","j","9","~"]),$a(["K","k","&","!"]),$a(["L","l",13,13]),$a(["M","m",9,9]),$a(["N","n",",",","]),$a(["O","o",":",":"]),$a(["P","p","#",10]),$a(["Q","q","-","-"]),$a(["R","r",".","."]),$a(["S","s","$","$"]),$a(["T","t","/","/"]),$a(["U","u","+",'"']),$a(["V","v","%","|"]),$a(["W","w","*","*"]),$a(["X","x","=",40]),$a(["Y","y","^",41]),$a(["Z","z",$_.pl,"?"]),$a([" "," "," ","{"]),$a([$_.ll,$_.as,$_.ll,"}"]),$a([$_.ml,$_.ml,$_.al,"'"]),$a([$_.ps,$_.ps,$_.ps,$_.al])]);$_.charvals=$a([new Map,new Map,new Map,new Map]);$_.alltext=new Map;for(var _19=0,_18=$_.charmaps.length-1;_19<=_18;_19+=1){$_.i=_19;$_.encs=$g($_.charmaps,$_.i);for(var _1D=0;_1D<=3;_1D+=1){$_.j=_1D;var _1G=$g($_.encs,$_.j);$k[$j++]=_1G;if($eq($t(_1G),"stringtype")){var _1J=$g($k[--$j],0);$k[$j++]=_1J}var _1K=$k[--$j];$p($g($_.charvals,$_.j),_1K,$_.i);$p($_.alltext,_1K,-1)}}$_.e=1e4;$_.latlen=$a([$a([0,1,1,2]),$a([2,0,1,2]),$a([1,1,0,1]),$a([1,2,2,0])]);$_.latseq=$a([$a([$a([]),$a([$_.ll]),$a([$_.ml]),$a([$_.ml,$_.pl])]),$a([$a([$_.ml,$_.al]),$a([]),$a([$_.ml]),$a([$_.ml,$_.pl])]),$a([$a([$_.al]),$a([$_.ll]),$a([]),$a([$_.pl])]),$a([$a([$_.al]),$a([$_.al,$_.ll]),$a([$_.al,$_.ml]),$a([])])]);$_.shftlen=$a([$a([$_.e,$_.e,$_.e,1]),$a([1,$_.e,$_.e,1]),$a([$_.e,$_.e,$_.e,1]),$a([$_.e,$_.e,$_.e,$_.e])]);if($_.raw||$_.cca){$_.datcws=$a($_.barcode.length);$_.i=0;$_.j=0;for(;;){if($_.i>=$_.barcode.length-3){break}if($g($_.barcode,$_.i)!=94){break}var _2a=$G($_.barcode,$_.i+1,3);$k[$j++]=_2a;$k[$j++]=false;for(var _2b=0,_2c=_2a.length;_2b<_2c;_2b++){var _2d=$g(_2a,_2b);if(_2d<48||_2d>57){$k[$j-1]=true}}if($k[--$j]){$j--;break}$_.cw=$i($k[--$j]);$p($_.datcws,$_.j,$_.cw);$_.i=$_.i+4;$_.j=$_.j+1}if($_.i!=$_.barcode.length){$k[$j++]="bwipp.micropdf417badCcaRawFormat#18771";$k[$j++]="cca and raw data must be formatted as ^NNN";bwipp_raiseerror()}$_.datcws=$G($_.datcws,0,$_.j)}$_.encb=function(){$_.in=$k[--$j];$_.inlen=$_.in.length;$_.out=$a(~~($_.inlen/6)*5+$_.inlen%6);for(var _2x=0,_2w=~~($_.inlen/6)-1;_2x<=_2w;_2x+=1){$_.k=_2x;$k[$j++]=Infinity;$q($G($_.in,$_.k*6,3));$_.msbs=$a();$k[$j++]=Infinity;$q($_.msbs);var _33=$k[--$j];var _34=$k[--$j];var _35=$k[--$j];$k[$j++]=$f(_33+_34*256+_35*65536);for(var _36=0;_36<3;_36++){var _37=$k[--$j];$k[$j++]=_37%900;$k[$j++]=~~(_37/900)}$_.mscs=$a();$k[$j++]=Infinity;$q($G($_.in,$_.k*6+3,3));$_.lsbs=$a();$k[$j++]=Infinity;$q($_.lsbs);var _3E=$k[--$j];var _3F=$k[--$j];var _3G=$k[--$j];$k[$j++]=$f(_3E+_3F*256+_3G*65536);for(var _3H=0;_3H<3;_3H++){var _3I=$k[--$j];$k[$j++]=_3I%900;$k[$j++]=~~(_3I/900)}$_.lscs=$a();var _3L=$g($_.lscs,0);var _3N=$g($_.mscs,0);$p($_.out,$_.k*5+4,$f(_3L+_3N*316)%900);var _3R=$g($_.lscs,1);var _3T=$g($_.mscs,0);var _3V=$g($_.mscs,1);$p($_.out,$_.k*5+3,$f(~~((_3L+_3N*316)/900)+_3R+_3T*641+_3V*316)%900);var _3Z=$g($_.lscs,2);var _3b=$g($_.mscs,0);var _3d=$g($_.mscs,1);var _3f=$g($_.mscs,2);$p($_.out,$_.k*5+2,$f(~~((~~((_3L+_3N*316)/900)+_3R+_3T*641+_3V*316)/900)+_3Z+_3b*20+_3d*641+_3f*316)%900);var _3j=$g($_.lscs,3);var _3l=$g($_.mscs,1);var _3n=$g($_.mscs,2);$p($_.out,$_.k*5+1,$f(~~((~~((~~((_3L+_3N*316)/900)+_3R+_3T*641+_3V*316)/900)+_3Z+_3b*20+_3d*641+_3f*316)/900)+_3j+_3l*20+_3n*641)%900);$p($_.out,$_.k*5,$f(~~((~~((~~((~~((_3L+_3N*316)/900)+_3R+_3T*641+_3V*316)/900)+_3Z+_3b*20+_3d*641+_3f*316)/900)+_3j+_3l*20+_3n*641)/900)+$g($_.mscs,2)*20)%900)}$_.rem=$_.inlen%6;if($_.rem!=0){$k[$j++]=$_.out;$k[$j++]=$_.out.length-$_.rem;$k[$j++]=Infinity;$q($G($_.in,$_.inlen-$_.rem,$_.rem));var _44=$a();var _45=$k[--$j];$P($k[--$j],_45,_44)}$k[$j++]=$_.out};if($_.ccb){$_.barlen=$_.barcode.length;$_.datcws=$a(~~($_.barlen/6)*5+$_.barlen%6+2);$p($_.datcws,0,920);var _4G=$_.barlen%6==0?924:901;$p($_.datcws,1,_4G);$k[$j++]=$_.datcws;$k[$j++]=2;$k[$j++]=Infinity;$F($_.barcode);var _4J=$a();$k[$j++]=_4J;$_.encb();var _4K=$k[--$j];var _4L=$k[--$j];$P($k[--$j],_4L,_4K)}if(!$_.raw&&!$_.cca&&!$_.ccb){var _4S=new Map([["parse",$_.parse],["parsefnc",$_.parsefnc],["eci",true]]);$_.fncvals=_4S;$k[$j++]="msg";$k[$j++]=$_.barcode;$k[$j++]=$_.fncvals;bwipp_parseinput();var _4V=$k[--$j];$_[$k[--$j]]=_4V;$_.msglen=$_.msg.length;if($_.msglen>=9){$q($G($_.msg,0,7));var _4b=$k[--$j];$k[$j-1]=_4b==29;var _4d=$k[--$j];var _4e=$k[--$j];var _4f=$k[--$j];var _4g=$k[--$j];var _4h=$k[--$j];var _4i=$k[--$j];if(_4d&&_4e==48&&_4f==30&&_4g==62&&_4h==41&&_4i==91){$q($G($_.msg,$_.msglen-2,2));var _4m=$k[--$j];var _4n=$k[--$j];if(_4m==4&&_4n==30){if($g($_.msg,5)==53){$k[$j++]=Infinity;$k[$j++]=$_.m05;$q($G($_.msg,7,$_.msg.length-9));$_.msg=$a()}else{if($g($_.msg,5)==54){$k[$j++]=Infinity;$k[$j++]=$_.m06;$q($G($_.msg,7,$_.msg.length-9));$_.msg=$a()}}}}}$_.msglen=$_.msg.length;$k[$j++]=Infinity;for(var _54=0,_55=$_.msglen;_54<_55;_54++){$k[$j++]=0}$k[$j++]=0;$_.numdigits=$a();$k[$j++]=Infinity;for(var _58=0,_59=$_.msglen;_58<_59;_58++){$k[$j++]=0}$k[$j++]=0;$_.numtext=$a();$k[$j++]=Infinity;for(var _5C=0,_5D=$_.msglen;_5C<_5D;_5C++){$k[$j++]=0}$k[$j++]=0;$_.numbytes=$a();$k[$j++]=Infinity;for(var _5G=0,_5H=$_.msglen;_5G<_5H;_5G++){$k[$j++]=0}$_.iseci=$a();for(var _5K=$_.msglen-1;_5K>=0;_5K-=1){$_.i=_5K;var _5N=$g($_.msg,$_.i);if(_5N>=48&&_5N<=57){$p($_.numdigits,$_.i,$g($_.numdigits,$_.i+1)+1)}var _5X=$g($_.alltext,$g($_.msg,$_.i))!==undefined;if(_5X&&$g($_.numdigits,$_.i)<13){$p($_.numtext,$_.i,$g($_.numtext,$_.i+1)+1)}if($g($_.msg,$_.i)>=0&&$g($_.numtext,$_.i)<5&&$g($_.numdigits,$_.i)<13){$p($_.numbytes,$_.i,$g($_.numbytes,$_.i+1)+1)}$p($_.iseci,$_.i,$g($_.msg,$_.i)<=-1e6)}$_.numdigits=$G($_.numdigits,0,$_.msglen);$_.numtext=$G($_.numtext,0,$_.msglen);$_.numbytes=$G($_.numbytes,0,$_.msglen);$_.seq=$a([]);$_.seqlen=0;$_.state=$_.B;$_.p=0;for(;;){if($_.p==$_.msglen){break}var _6F=$g($_.msg,$_.p);if($_.p==0&&(_6F==$_.m05||_6F==$_.m06)){$k[$j++]=Infinity;$q($_.seq);var _6N=$g($_.msg,$_.p)==$_.m05?$_.m05:$_.m06;$k[$j++]=_6N;$_.seq=$a();$_.p=$_.p+1;$_.seqlen=$_.seqlen+1}else{if($g($_.iseci,$_.p)){$_.eci=$g($_.msg,$_.p);$k[$j++]=Infinity;$q($_.seq);$k[$j++]=$a([$_.eci]);$_.seq=$a();$_.p=$_.p+1;$k[$j++]="seqlen";$k[$j++]=$_.seqlen;if($_.eci<=-1810900){$k[$j++]=2}else{var _6f=$_.eci<=-1000900?3:2;$k[$j++]=_6f}var _6g=$k[--$j];var _6h=$k[--$j];$_[$k[--$j]]=$f(_6h+_6g)}else{$_.n=$g($_.numdigits,$_.p);if($_.n>=13||$_.n==$_.msglen&&$_.n>=8){$k[$j++]=Infinity;$q($_.seq);$k[$j++]=$_.nl;$k[$j++]=Infinity;$q($G($_.msg,$_.p,$_.n));var _6w=$a();$k[$j++]=_6w;$_.seq=$a();$_.state=$_.N;$_.p=$f($_.p+$_.n);$_.seqlen=$f($_.seqlen+1+$_.n)}else{$_.t=$g($_.numtext,$_.p);if($_.t>=5){$k[$j++]=Infinity;$q($_.seq);if($_.state!=$_.T){$k[$j++]=$_.tl}$k[$j++]=Infinity;$q($G($_.msg,$_.p,$_.t));var _7F=$a();$k[$j++]=_7F;$_.seq=$a();$_.state=$_.T;$_.p=$f($_.p+$_.t);$_.seqlen=$f($_.seqlen+1+$_.t)}else{$_.b=$g($_.numbytes,$_.p);if($_.b==1&&$_.state==$_.T){$k[$j++]=Infinity;$q($_.seq);$k[$j++]=$_.bs;$k[$j++]=$a([$g($_.msg,$_.p)]);$_.seq=$a();$_.p=$f($_.p+$_.b);$_.seqlen=$_.seqlen+2}else{$k[$j++]=Infinity;$q($_.seq);var _7e=$_.b%6!=0?$_.bl:$_.bl6;$k[$j++]=_7e;$k[$j++]=Infinity;$q($G($_.msg,$_.p,$_.b));var _7j=$a();$k[$j++]=_7j;$_.seq=$a();$_.state=$_.B;$_.p=$f($_.p+$_.b);$_.seqlen=$f($_.seqlen+1+$_.b)}}}}}}$k[$j++]=Infinity;$k[$j++]=$_.tl;$k[$j++]=900;$k[$j++]=$_.bl;$k[$j++]=901;$k[$j++]=$_.bl6;$k[$j++]=924;$k[$j++]=$_.nl;$k[$j++]=902;$k[$j++]=$_.bs;$k[$j++]=913;$k[$j++]=$_.m05;$k[$j++]=916;$k[$j++]=$_.m06;$k[$j++]=917;$_.latchcws=$d();$_.enca=function(){var _82=$g($g($_.charvals,$_.A),$k[--$j]);$k[$j++]=_82};$_.encl=function(){var _87=$g($g($_.charvals,$_.L),$k[--$j]);$k[$j++]=_87};$_.encm=function(){var _8C=$g($g($_.charvals,$_.M),$k[--$j]);$k[$j++]=_8C};$_.encp=function(){var _8H=$g($g($_.charvals,$_.P),$k[--$j]);$k[$j++]=_8H};$_.textencfuncs=$a(["enca","encl","encm","encp"]);$_.addtotext=function(){$p($_.text,$_.l,$k[--$j]);$_.l=$_.l+1};$_.enct=function(){$_.in=$k[--$j];$_.curlen=$a([$_.e,$_.e,$_.e,$_.e]);$p($_.curlen,$_.submode,0);$_.curseq=$a([$a([]),$a([]),$a([]),$a([])]);$F($_.in,function(){$_.char=$k[--$j];for(;;){$_.imp=false;var _8g=$a([$_.A,$_.L,$_.M,$_.P]);for(var _8h=0,_8i=_8g.length;_8h<_8i;_8h++){$_.x=$g(_8g,_8h);var _8o=$a([$_.A,$_.L,$_.M,$_.P]);for(var _8p=0,_8q=_8o.length;_8p<_8q;_8p++){$_.y=$g(_8o,_8p);$_.cost=$f($g($_.curlen,$_.x)+$g($g($_.latlen,$_.x),$_.y));if($_.cost<$g($_.curlen,$_.y)){$p($_.curlen,$_.y,$_.cost);$k[$j++]=$_.curseq;$k[$j++]=$_.y;$k[$j++]=Infinity;$q($g($_.curseq,$_.x));$q($g($g($_.latseq,$_.x),$_.y));var _9H=$a();var _9I=$k[--$j];$p($k[--$j],_9I,_9H);$_.imp=true}}}if(!$_.imp){break}}$_.nxtlen=$a([$_.e,$_.e,$_.e,$_.e]);$_.nxtseq=$a(4);var _9V=$a([$_.A,$_.L,$_.M,$_.P]);for(var _9W=0,_9X=_9V.length;_9W<_9X;_9W++){$_.x=$g(_9V,_9W);for(;;){var _9d=$g($g($_.charvals,$_.x),$_.char)!==undefined;if(!_9d){break}$_.cost=$g($_.curlen,$_.x)+1;if($_.cost<$g($_.nxtlen,$_.x)){$p($_.nxtlen,$_.x,$_.cost);$k[$j++]=$_.nxtseq;$k[$j++]=$_.x;$k[$j++]=Infinity;$q($g($_.curseq,$_.x));$k[$j++]=$_.char;var _9u=$a();var _9v=$k[--$j];$p($k[--$j],_9v,_9u)}var _A1=$a([$_.A,$_.L,$_.M,$_.P]);for(var _A2=0,_A3=_A1.length;_A2<_A3;_A2++){$_.y=$g(_A1,_A2);if($ne($_.x,$_.y)){$_.cost=$f($g($_.curlen,$_.y)+$g($g($_.shftlen,$_.y),$_.x))+1;if($_.cost<$g($_.nxtlen,$_.y)){$p($_.nxtlen,$_.y,$_.cost);$k[$j++]=$_.nxtseq;$k[$j++]=$_.y;$k[$j++]=Infinity;$q($g($_.curseq,$_.y));var _AT=$_.x==$_.A?$_.as:$_.ps;$k[$j++]=_AT;$k[$j++]=$_.char;var _AV=$a();var _AW=$k[--$j];$p($k[--$j],_AW,_AV)}}}break}}$_.curlen=$_.nxtlen;$_.curseq=$_.nxtseq});$_.minseq=$_.e;var _Af=$a([$_.A,$_.L,$_.M,$_.P]);for(var _Ag=0,_Ah=_Af.length;_Ag<_Ah;_Ag++){$_.k=$g(_Af,_Ag);if($g($_.curlen,$_.k)<$_.minseq){$_.minseq=$g($_.curlen,$_.k);$_.txtseq=$g($_.curseq,$_.k)}}$_.text=$a($_.minseq);$_.k=0;$_.l=0;for(;;){if($_.k>=$_.txtseq.length){break}$_.char=$g($_.txtseq,$_.k);$k[$j++]=$_.char;if($_[$g($_.textencfuncs,$_.submode)]()===true){break}$_.addtotext();$_.k=$_.k+1;if($_.char==$_.as||$_.char==$_.ps){$k[$j++]=$g($_.txtseq,$_.k);if($_.char==$_.as){$_.enca()}else{$_.encp()}$_.addtotext();$_.k=$_.k+1}if($_.char==$_.al){$_.submode=$_.A}if($_.char==$_.ll){$_.submode=$_.L}if($_.char==$_.ml){$_.submode=$_.M}if($_.char==$_.pl){$_.submode=$_.P}}if($_.text.length%2==1){if($_.submode==$_.P){$k[$j++]="pad";$k[$j++]=$_.al;$_.encp();var _BW=$k[--$j];$_[$k[--$j]]=_BW;$_.submode=$_.A}else{$_.nextecitext=false;for(var _Bc=$_.i+1,_Bb=$_.seq.length-1;_Bc<=_Bb;_Bc+=1){$_.ti=_Bc;if($ne($t($g($_.seq,$_.ti)),"arraytype")){$_.nextecitext=false;break}if($g($g($_.seq,$_.ti),0)>-1e6){break}$_.nextecitext=true}if($_.nextecitext){if($_.submode==$_.A){var _Bv=$g($g($_.charvals,$_.L),$g($g($_.seq,$_.ti),0))!==undefined;if(_Bv){$k[$j++]="pad";$k[$j++]=$_.ll;$_.enca();var _Bx=$k[--$j];$_[$k[--$j]]=_Bx;$_.submode=$_.L}else{$k[$j++]="pad";$k[$j++]=$_.ml;$_.enca();var _C1=$k[--$j];$_[$k[--$j]]=_C1;$_.submode=$_.M}}else{if($_.submode==$_.M){var _CD=$g($g($_.charvals,$_.L),$g($g($_.seq,$_.ti),0))!==undefined;if(_CD){$k[$j++]="pad";$k[$j++]=$_.ll;$_.encm();var _CF=$k[--$j];$_[$k[--$j]]=_CF;$_.submode=$_.L}else{var _CP=$g($g($_.charvals,$_.P),$g($g($_.seq,$_.ti),0))!==undefined;if(_CP){$k[$j++]="pad";$k[$j++]=$_.pl;$_.encm();var _CR=$k[--$j];$_[$k[--$j]]=_CR;$_.submode=$_.P}else{$k[$j++]="pad";$k[$j++]=$_.al;$_.encm();var _CV=$k[--$j];$_[$k[--$j]]=_CV;$_.submode=$_.A}}}else{$k[$j++]="pad";$k[$j++]=$_.ml;$_.encl();var _CZ=$k[--$j];$_[$k[--$j]]=_CZ;$_.submode=$_.M}}}else{$k[$j++]="pad";$k[$j++]=$_.ps;if($_[$g($_.textencfuncs,$_.submode)]()===true){return true}var _Ch=$k[--$j];$_[$k[--$j]]=_Ch}}$k[$j++]=Infinity;$q($_.text);$k[$j++]=$_.pad;$_.text=$a()}$_.out=$a(~~($_.text.length/2));for(var _Cq=0,_Cp=$_.out.length-1;_Cq<=_Cp;_Cq+=1){$_.k=_Cq;$p($_.out,$_.k,$f($g($_.text,$_.k*2)*30+$g($_.text,$_.k*2+1)))}$k[$j++]=$_.out};$_.encn=function(){$_.in=$k[--$j];$_.out=$a([]);for(var _D4=0,_D3=$_.in.length-1;_D4<=_D3;_D4+=44){$_.k=_D4;$k[$j++]=Infinity;var _D9=$_.in.length-$_.k;$k[$j++]=1;$k[$j++]=$_.in;$k[$j++]=$_.k;$k[$j++]=_D9;if(_D9>44){$k[$j-1]=44}var _DA=$k[--$j];var _DB=$k[--$j];var _DD=$G($k[--$j],_DB,_DA);for(var _DE=0,_DF=_DD.length;_DE<_DF;_DE++){$k[$j++]=$g(_DD,_DE)-48}$_.gmod=$a();$_.cwn=$a([]);for(;;){$_.dv=900;$_.gmul=$a([]);$_.val=0;for(;;){if($_.gmod.length==0){break}$_.val=$f($_.val*10+$g($_.gmod,0));$_.gmod=$G($_.gmod,1,$_.gmod.length-1);if($_.val<$_.dv){if($_.gmul.length!=0){$k[$j++]=Infinity;$q($_.gmul);$k[$j++]=0;$_.gmul=$a()}}else{$k[$j++]=Infinity;$q($_.gmul);$k[$j++]=~~($_.val/$_.dv);$_.gmul=$a()}$_.val=$_.val%$_.dv}$_.dv=$_.val;$k[$j++]=Infinity;$k[$j++]=$_.dv;$q($_.cwn);$_.cwn=$a();$_.gmod=$_.gmul;if($_.gmul.length==0){break}}$k[$j++]=Infinity;$q($_.out);$q($_.cwn);$_.out=$a()}$k[$j++]=$_.out};$_.ence=function(){var _Do=-$g($k[--$j],0)-1e6;$k[$j++]=_Do;if(_Do<=899){var _Dp=$k[--$j];$k[$j++]=927;$k[$j++]=_Dp;$as($a(2))}else{var _Dr=$k[$j-1];if(_Dr<=810899){var _Ds=$k[--$j];$k[$j++]=926;$k[$j++]=~~(_Ds/900)-1;$k[$j++]=_Ds%900;$as($a(3))}else{var _Du=$k[$j-1];if(_Du<=811799){var _Dv=$k[--$j];$k[$j++]=925;$k[$j++]=_Dv-810900;$as($a(2))}else{$k[$j++]="bwipp.pdf417badECI#19167";$k[$j++]="PDF417 supports ECIs 000000 to 811799";bwipp_raiseerror()}}}};$_.encfuncs=$a(["enct","encn","encb"]);$_.addtocws=function(){var _Dy=$k[--$j];$P($_.datcws,$_.j,_Dy);$_.j=_Dy.length+$_.j};$_.datcws=$a($_.seqlen);$_.i=0;$_.j=0;for(;;){if($_.i>=$_.seq.length){break}$_.chars=$g($_.seq,$_.i);if($eq($t($_.chars),"arraytype")){if($g($_.chars,0)<=-1e6){$k[$j++]=$_.chars;$_.ence();$_.addtocws()}else{$k[$j++]=$_.chars;if($_[$g($_.encfuncs,$_.state)]()===true){break}$_.addtocws()}}else{$k[$j++]=$a([$g($_.latchcws,$_.chars)]);$_.addtocws();if($_.chars==$_.tl){$_.state=$_.T;$_.submode=$_.A}if($_.chars==$_.nl){$_.state=$_.N}if($_.chars==$_.bl||$_.chars==$_.bl6){$_.state=$_.B}if($_.chars==$_.bs){$_.i=$_.i+1;$k[$j++]=$g($_.seq,$_.i);$_.encb();$_.addtocws()}if($_.chars==$_.m05){if($_.i+1<$_.seq.length){if($g($_.seq,$_.i+1)==$_.nl){$_.i=$_.i+1}}$_.state=$_.N}if($_.chars==$_.m06){if($_.i+1<$_.seq.length){if($g($_.seq,$_.i+1)==$_.tl){$_.i=$_.i+1}}$_.state=$_.T;$_.submode=$_.M}}$_.i=$_.i+1}$_.datcws=$G($_.datcws,0,$_.j)}$_.ccametrics=$a([$a([2,5,4,39,0,19]),$a([2,6,4,1,0,33]),$a([2,7,5,32,0,12]),$a([2,8,5,8,0,40]),$a([2,9,6,14,0,46]),$a([2,10,6,43,0,23]),$a([2,12,7,20,0,52]),$a([3,4,4,11,43,23]),$a([3,5,5,1,33,13]),$a([3,6,6,5,37,17]),$a([3,7,7,15,47,27]),$a([3,8,7,21,1,33]),$a([4,3,4,40,20,52]),$a([4,4,5,43,23,3]),$a([4,5,6,46,26,6]),$a([4,6,7,34,14,46]),$a([4,7,8,29,9,41])]);$_.nonccametrics=$a([$a([1,11,7,1,0,9]),$a([1,14,7,8,0,8]),$a([1,17,7,36,0,36]),$a([1,20,8,19,0,19]),$a([1,24,8,9,0,17]),$a([1,28,8,25,0,33]),$a([2,8,8,1,0,1]),$a([2,11,9,1,0,9]),$a([2,14,9,8,0,8]),$a([2,17,10,36,0,36]),$a([2,20,11,19,0,19]),$a([2,23,13,9,0,17]),$a([2,26,15,27,0,35]),$a([3,6,12,1,1,1]),$a([3,8,14,7,7,7]),$a([3,10,16,15,15,15]),$a([3,12,18,25,25,25]),$a([3,15,21,37,37,37]),$a([3,20,26,1,17,33]),$a([3,26,32,1,9,17]),$a([3,32,38,21,29,37]),$a([3,38,44,15,31,47]),$a([3,44,50,1,25,49]),$a([4,4,8,47,19,43]),$a([4,6,12,1,1,1]),$a([4,8,14,7,7,7]),$a([4,10,16,15,15,15]),$a([4,12,18,25,25,25]),$a([4,15,21,37,37,37]),$a([4,20,26,1,17,33]),$a([4,26,32,1,9,17]),$a([4,32,38,21,29,37]),$a([4,38,44,15,31,47]),$a([4,44,50,1,25,49])]);$k[$j++]="metrics";if($_.cca){$k[$j++]=$_.ccametrics}else{$k[$j++]=$_.nonccametrics}var _Fz=$k[--$j];$_[$k[--$j]]=_Fz;$_.urows=$_.rows;$_.ucols=$_.columns;$F($_.metrics,function(){$_.m=$k[--$j];$_.c=$g($_.m,0);$_.r=$g($_.m,1);$_.k=$g($_.m,2);$_.rapl=$g($_.m,3);$_.rapc=$g($_.m,4);$_.rapr=$g($_.m,5);$_.ncws=$f($_.r*$_.c-$_.k);$_.okay=true;if($_.datcws.length>$_.ncws){$_.okay=false}if($_.urows!=0&&$_.urows!=$_.r){$_.okay=false}if($_.ucols!=0&&$_.ucols!=$_.c){$_.okay=false}if($_.okay){return true}});if(!$_.okay){$k[$j++]="bwipp.micropdf417noValidSymbol#19306";$k[$j++]="Maximum length exceeded or invalid size";bwipp_raiseerror()}$_.m=$_.datcws.length;$_.n=$f($_.c*$_.r-$_.k);$_.cws=$a($_.c*$_.r+1);$P($_.cws,0,$_.datcws);$k[$j++]=$_.cws;$k[$j++]=$_.m;$k[$j++]=Infinity;for(var _Gh=0,_Gi=$f($_.n-$_.m);_Gh<_Gi;_Gh++){$k[$j++]=900}var _Gj=$a();var _Gk=$k[--$j];$P($k[--$j],_Gk,_Gj);$k[$j++]=$_.cws;$k[$j++]=$_.n;$k[$j++]=Infinity;for(var _Gp=0,_Gq=$_.k;_Gp<_Gq;_Gp++){$k[$j++]=0}$k[$j++]=0;var _Gr=$a();var _Gs=$k[--$j];$P($k[--$j],_Gs,_Gr);$k[$j++]=Infinity;$k[$j++]=1;for(var _Gu=0;_Gu<928;_Gu++){var _Gv=$k[$j-1];$k[$j++]=_Gv*3%929}$_.rsalog=$a();$_.rslog=$a(929);for(var _Gy=1;_Gy<=928;_Gy+=1){$p($_.rslog,$g($_.rsalog,_Gy),_Gy)}$_.rsprod=function(){var _H3=$k[$j-1];var _H4=$k[$j-2];if(_H3!=0&&_H4!=0){var _H7=$g($_.rslog,$k[--$j]);var _HC=$g($_.rsalog,$f(_H7+$g($_.rslog,$k[--$j]))%928);$k[$j++]=_HC}else{$j-=2;$k[$j++]=0}};$k[$j++]=Infinity;$k[$j++]=1;for(var _HE=0,_HF=$_.k;_HE<_HF;_HE++){$k[$j++]=0}$_.coeffs=$a();for(var _HJ=1,_HI=$_.k;_HJ<=_HI;_HJ+=1){$_.i=_HJ;$p($_.coeffs,$_.i,$g($_.coeffs,$_.i-1));for(var _HQ=$_.i-1;_HQ>=1;_HQ-=1){$_.j=_HQ;$k[$j++]=$_.coeffs;$k[$j++]=$_.j;$k[$j++]=$g($_.coeffs,$_.j-1);$k[$j++]=$g($_.coeffs,$_.j);$k[$j++]=$g($_.rsalog,$_.i);$_.rsprod();var _Hc=$k[--$j];var _Hd=$k[--$j];var _He=$k[--$j];$p($k[--$j],_He,$f(_Hd+_Hc)%929)}$k[$j++]=$_.coeffs;$k[$j++]=0;$k[$j++]=$g($_.coeffs,0);$k[$j++]=$g($_.rsalog,$_.i);$_.rsprod();var _Hm=$k[--$j];var _Hn=$k[--$j];$p($k[--$j],_Hn,_Hm)}$_.coeffs=$G($_.coeffs,0,$_.coeffs.length-1);for(var _Ht=$_.coeffs.length-1;_Ht>=0;_Ht-=2){var _Hu=$_.coeffs;$p(_Hu,_Ht,929-$g(_Hu,_Ht))}for(var _Hy=0,_Hx=$_.n-1;_Hy<=_Hx;_Hy+=1){$_.t=$f($g($_.cws,_Hy)+$g($_.cws,$_.n))%929;for(var _I6=0,_I5=$_.k-1;_I6<=_I5;_I6+=1){$_.j=_I6;$p($_.cws,$f($_.n+$_.j),$f($g($_.cws,$f($_.n+$_.j)+1)+(929-$_.t*$g($_.coeffs,$f($_.k-$_.j)-1)%929))%929)}}for(var _IN=$_.n,_IM=$f($_.n+$_.k);_IN<=_IM;_IN+=1){$p($_.cws,_IN,(929-$g($_.cws,_IN))%929)}$_.cws=$G($_.cws,0,$_.cws.length-1);var _IV=$g($_.options,"debugcws")!==undefined;if(_IV){$k[$j++]="bwipp.debugcws#19360";$k[$j++]=$_.cws;bwipp_raiseerror()}$_.clusters=$a([$a([120256,125680,128380,120032,125560,128318,108736,119920,108640,86080,108592,86048,110016,120560,125820,109792,120440,125758,88256,109680,88160,89536,110320,120700,89312,110200,120638,89200,110140,89840,110460,89720,110398,89980,128506,119520,125304,128190,107712,119408,125244,107616,119352,84032,107568,119324,84e3,107544,83984,108256,119672,125374,85184,108144,119612,85088,108088,119582,85040,108060,85728,108408,119742,85616,108348,85560,108318,85880,108478,85820,85790,107200,119152,125116,107104,119096,125086,83008,107056,119068,82976,107032,82960,82952,83648,107376,119228,83552,107320,119198,83504,107292,83480,83468,83824,107452,83768,107422,83740,83900,106848,118968,125022,82496,106800,118940,82464,106776,118926,82448,106764,82440,106758,82784,106936,119006,82736,106908,82712,106894,82700,82694,106974,82830,82240,106672,118876,82208,106648,118862,82192,106636,82184,106630,82180,82352,82328,82316,82080,118830,106572,106566,82050,117472,124280,127678,103616,117360,124220,103520,117304,124190,75840,103472,75808,104160,117624,124350,76992,104048,117564,76896,103992,76848,76824,77536,104312,117694,77424,104252,77368,77340,77688,104382,77628,77758,121536,126320,128700,121440,126264,128670,111680,121392,126236,111648,121368,126222,111632,121356,103104,117104,124092,112320,103008,117048,124062,112224,121656,126366,93248,74784,102936,117006,93216,112152,93200,75456,103280,117180,93888,75360,103224,117150,93792,112440,121758,93744,75288,93720,75632,103356,94064,75576,103326,94008,112542,93980,75708,94140,75678,94110,121184,126136,128606,111168,121136,126108,111136,121112,126094,111120,121100,111112,111108,102752,116920,123998,111456,102704,116892,91712,74272,121244,116878,91680,74256,102668,91664,111372,102662,74244,74592,102840,116958,92e3,74544,102812,91952,111516,102798,91928,74508,74502,74680,102878,92088,74652,92060,74638,92046,92126,110912,121008,126044,110880,120984,126030,110864,120972,110856,120966,110852,110850,74048,102576,116828,90944,74016,102552,116814,90912,111e3,121038,90896,73992,102534,90888,110982,90884,74160,102620,91056,74136,102606,91032,111054,91020,74118,91014,91100,91086,110752,120920,125998,110736,120908,110728,120902,110724,110722,73888,102488,116782,90528,73872,102476,90512,110796,102470,90504,73860,90500,73858,73944,90584,90572,90566,120876,120870,110658,102444,73800,90312,90308,90306,101056,116080,123580,100960,116024,70720,100912,115996,70688,100888,70672,70664,71360,101232,116156,71264,101176,116126,71216,101148,71192,71180,71536,101308,71480,101278,71452,71612,71582,118112,124600,127838,105024,118064,124572,104992,118040,124558,104976,118028,104968,118022,100704,115896,123486,105312,100656,115868,79424,70176,118172,115854,79392,105240,100620,79376,70152,79368,70496,100792,115934,79712,70448,118238,79664,105372,100750,79640,70412,79628,70584,100830,79800,70556,79772,70542,70622,79838,122176,126640,128860,122144,126616,128846,122128,126604,122120,126598,122116,104768,117936,124508,113472,104736,126684,124494,113440,122264,126670,113424,104712,117894,113416,122246,104706,69952,100528,115804,78656,69920,100504,115790,96064,78624,104856,117966,96032,113560,122318,100486,96016,78600,104838,96008,69890,70064,100572,78768,70040,100558,96176,78744,104910,96152,113614,70022,78726,70108,78812,70094,96220,78798,122016,126552,128814,122e3,126540,121992,126534,121988,121986,104608,117848,124462,113056,104592,126574,113040,122060,117830,113032,104580,113028,104578,113026,69792,100440,115758,78240,69776,100428,95136,78224,104652,100422,95120,113100,69764,95112,78212,69762,78210,69848,100462,78296,69836,95192,78284,69830,95180,78278,69870,95214,121936,126508,121928,126502,121924,121922,104528,117804,112848,104520,117798,112840,121958,112836,104514,112834,69712,100396,78032,69704,100390,94672,78024,104550,94664,112870,69698,94660,78018,94658,78060,94700,94694,126486,121890,117782,104484,104482,69672,77928,94440,69666,77922,99680,68160,99632,68128,99608,115342,68112,99596,68104,99590,68448,99768,115422,68400,99740,68376,99726,68364,68358,68536,99806,68508,68494,68574,101696,116400,123740,101664,116376,101648,116364,101640,116358,101636,67904,99504,115292,72512,67872,116444,115278,72480,101784,116430,72464,67848,99462,72456,101766,67842,68016,99548,72624,67992,99534,72600,101838,72588,67974,68060,72668,68046,72654,118432,124760,127918,118416,124748,118408,124742,118404,118402,101536,116312,105888,101520,116300,105872,118476,116294,105864,101508,105860,101506,105858,67744,99416,72096,67728,116334,80800,72080,101580,99398,80784,105932,67716,80776,72068,67714,72066,67800,99438,72152,67788,80856,72140,67782,80844,72134,67822,72174,80878,126800,128940,126792,128934,126788,126786,118352,124716,122576,126828,124710,122568,126822,122564,118338,122562,101456,116268,105680,101448,116262,114128,105672,118374,114120,122598,101442,114116,105666,114114,67664,99372,71888,67656,99366,80336,71880,101478,97232,80328,105702,67650,97224,114150,71874,97220,67692,71916,67686,80364,71910,97260,80358,97254,126760,128918,126756,126754,118312,124694,122472,126774,122468,118306,122466,101416,116246,105576,101412,113896,105572,101410,113892,105570,113890,67624,99350,71784,101430,80104,71780,67618,96744,80100,71778,96740,80098,96738,71798,96758,126738,122420,122418,105524,113780,113778,71732,79988,96500,96498,66880,66848,98968,66832,66824,66820,66992,66968,66956,66950,67036,67022,1e5,99984,115532,99976,115526,99972,99970,66720,98904,69024,100056,98892,69008,100044,69e3,100038,68996,66690,68994,66776,98926,69080,100078,69068,66758,69062,66798,69102,116560,116552,116548,116546,99920,102096,116588,115494,102088,116582,102084,99906,102082,66640,68816,66632,98854,73168,68808,66628,73160,68804,66626,73156,68802,66668,68844,66662,73196,68838,73190,124840,124836,124834,116520,118632,124854,118628,116514,118626,99880,115478,101992,116534,106216,101988,99874,106212,101986,106210,66600,98838,68712,99894,72936,68708,66594,81384,72932,68706,81380,72930,66614,68726,72950,81398,128980,128978,124820,126900,124818,126898,116500,118580,116498,122740,118578,122738,99860,101940,99858,106100,101938,114420]),$a([128352,129720,125504,128304,129692,125472,128280,129678,125456,128268,125448,128262,125444,125792,128440,129758,120384,125744,128412,120352,125720,128398,120336,125708,120328,125702,120324,120672,125880,128478,110144,120624,125852,110112,120600,125838,110096,120588,110088,120582,110084,110432,120760,125918,89664,110384,120732,89632,110360,120718,89616,110348,89608,110342,89952,110520,120798,89904,110492,89880,110478,89868,90040,110558,90012,89998,125248,128176,129628,125216,128152,129614,125200,128140,125192,128134,125188,125186,119616,125360,128220,119584,125336,128206,119568,125324,119560,125318,119556,119554,108352,119728,125404,108320,119704,125390,108304,119692,108296,119686,108292,108290,85824,108464,119772,85792,108440,119758,85776,108428,85768,108422,85764,85936,108508,85912,108494,85900,85894,85980,85966,125088,128088,129582,125072,128076,125064,128070,125060,125058,119200,125144,128110,119184,125132,119176,125126,119172,119170,107424,119256,125166,107408,119244,107400,119238,107396,107394,83872,107480,119278,83856,107468,83848,107462,83844,83842,83928,107502,83916,83910,83950,125008,128044,125e3,128038,124996,124994,118992,125036,118984,125030,118980,118978,106960,119020,106952,119014,106948,106946,82896,106988,82888,106982,82884,82882,82924,82918,124968,128022,124964,124962,118888,124982,118884,118882,106728,118902,106724,106722,82408,106742,82404,82402,124948,124946,118836,118834,106612,106610,124224,127664,129372,124192,127640,129358,124176,127628,124168,127622,124164,124162,117568,124336,127708,117536,124312,127694,117520,124300,117512,124294,117508,117506,104256,117680,124380,104224,117656,124366,104208,117644,104200,117638,104196,104194,77632,104368,117724,77600,104344,117710,77584,104332,77576,104326,77572,77744,104412,77720,104398,77708,77702,77788,77774,128672,129880,93168,128656,129868,92664,128648,129862,92412,128644,128642,124064,127576,129326,126368,124048,129902,126352,128716,127558,126344,124036,126340,124034,126338,117152,124120,127598,121760,117136,124108,121744,126412,124102,121736,117124,121732,117122,121730,103328,117208,124142,112544,103312,117196,112528,121804,117190,112520,103300,112516,103298,112514,75680,103384,117230,94112,75664,103372,94096,112588,103366,94088,75652,94084,75650,75736,103406,94168,75724,94156,75718,94150,75758,128592,129836,91640,128584,129830,91388,128580,91262,128578,123984,127532,126160,123976,127526,126152,128614,126148,123970,126146,116944,124012,121296,116936,124006,121288,126182,121284,116930,121282,102864,116972,111568,102856,116966,111560,121318,111556,102850,111554,74704,102892,92112,74696,102886,92104,111590,92100,74690,92098,74732,92140,74726,92134,128552,129814,90876,128548,90750,128546,123944,127510,126056,128566,126052,123938,126050,116840,123958,121064,116836,121060,116834,121058,102632,116854,111080,121078,111076,102626,111074,74216,102646,91112,74212,91108,74210,91106,74230,91126,128532,90494,128530,123924,126004,123922,126002,116788,120948,116786,120946,102516,110836,102514,110834,73972,90612,73970,90610,128522,123914,125978,116762,120890,102458,110714,123552,127320,129198,123536,127308,123528,127302,123524,123522,116128,123608,127342,116112,123596,116104,123590,116100,116098,101280,116184,123630,101264,116172,101256,116166,101252,101250,71584,101336,116206,71568,101324,71560,101318,71556,71554,71640,101358,71628,71622,71662,127824,129452,79352,127816,129446,79100,127812,78974,127810,123472,127276,124624,123464,127270,124616,127846,124612,123458,124610,115920,123500,118224,115912,123494,118216,124646,118212,115906,118210,100816,115948,105424,100808,115942,105416,118246,105412,100802,105410,70608,100844,79824,70600,100838,79816,105446,79812,70594,79810,70636,79852,70630,79846,129960,95728,113404,129956,95480,113278,129954,95356,95294,127784,129430,78588,128872,129974,95996,78462,128868,127778,95870,128866,123432,127254,124520,123428,126696,128886,123426,126692,124514,126690,115816,123446,117992,115812,122344,117988,115810,122340,117986,122338,100584,115830,104936,100580,113640,104932,100578,113636,104930,113634,70120,100598,78824,70116,96232,78820,70114,96228,78818,96226,70134,78838,129940,94968,113022,129938,94844,94782,127764,78206,128820,127762,95102,128818,123412,124468,123410,126580,124466,126578,115764,117876,115762,122100,117874,122098,100468,104692,100466,113140,104690,113138,69876,78324,69874,95220,78322,95218,129930,94588,94526,127754,128794,123402,124442,126522,115738,117818,121978,100410,104570,112890,69754,78074,94714,94398,123216,127148,123208,127142,123204,123202,115408,123244,115400,123238,115396,115394,99792,115436,99784,115430,99780,99778,68560,99820,68552,99814,68548,68546,68588,68582,127400,129238,72444,127396,72318,127394,123176,127126,123752,123172,123748,123170,123746,115304,123190,116456,115300,116452,115298,116450,99560,115318,101864,99556,101860,99554,101858,68072,99574,72680,68068,72676,68066,72674,68086,72694,129492,80632,105854,129490,80508,80446,127380,72062,127924,127378,80766,127922,123156,123700,123154,124788,123698,124786,115252,116340,115250,118516,116338,118514,99444,101620,99442,105972,101618,105970,67828,72180,67826,80884,72178,80882,97008,114044,96888,113982,96828,96798,129482,80252,130010,97148,80190,97086,127370,127898,128954,123146,123674,124730,126842,115226,116282,118394,122618,99386,101498,105722,114170,67706,71930,80378,96632,113854,96572,96542,80062,96702,96444,96414,96350,123048,123044,123042,115048,123062,115044,115042,99048,115062,99044,99042,67048,99062,67044,67042,67062,127188,68990,127186,123028,123316,123026,123314,114996,115572,114994,115570,98932,100084,98930,100082,66804,69108,66802,69106,129258,73084,73022,127178,127450,123018,123290,123834,114970,115514,116602,98874,99962,102138,66682,68858,73210,81272,106174,81212,81182,72894,81342,97648,114364,97592,114334,97564,97550,81084,97724,81054,97694,97464,114270,97436,97422,80990,97502,97372,97358,97326,114868,114866,98676,98674,66292,66290,123098,114842,115130,98618,99194,66170,67322,69310,73404,73374,81592,106334,81564,81550,73310,81630,97968,114524,97944,114510,97932,97926,81500,98012,81486,97998,97880,114478,97868,97862,81454,97902,97836,97830,69470,73564,73550,81752,106414,81740,81734,73518,81774,81708,81702]),$a([109536,120312,86976,109040,120060,86496,108792,119934,86256,108668,86136,129744,89056,110072,129736,88560,109820,129732,88312,109694,129730,88188,128464,129772,89592,128456,129766,89340,128452,89214,128450,125904,128492,125896,128486,125892,125890,120784,125932,120776,125926,120772,120770,110544,120812,110536,120806,110532,84928,108016,119548,84448,107768,119422,84208,107644,84088,107582,84028,129640,85488,108284,129636,85240,108158,129634,85116,85054,128232,129654,85756,128228,85630,128226,125416,128246,125412,125410,119784,125430,119780,119778,108520,119798,108516,108514,83424,107256,119166,83184,107132,83064,107070,83004,82974,129588,83704,107390,129586,83580,83518,128116,83838,128114,125172,125170,119284,119282,107508,107506,82672,106876,82552,106814,82492,82462,129562,82812,82750,128058,125050,119034,82296,106686,82236,82206,82366,82108,82078,76736,103920,117500,76256,103672,117374,76016,103548,75896,103486,75836,129384,77296,104188,129380,77048,104062,129378,76924,76862,127720,129398,77564,127716,77438,127714,124392,127734,124388,124386,117736,124406,117732,117730,104424,117750,104420,104418,112096,121592,126334,92608,111856,121468,92384,111736,121406,92272,111676,92216,111646,92188,75232,103160,117118,93664,74992,103036,93424,112252,102974,93304,74812,93244,74782,93214,129332,75512,103294,129908,129330,93944,75388,129906,93820,75326,93758,127604,75646,128756,127602,94078,128754,124148,126452,124146,126450,117236,121844,117234,121842,103412,103410,91584,111344,121212,91360,111224,121150,91248,111164,91192,111134,91164,91150,74480,102780,91888,74360,102718,91768,111422,91708,74270,91678,129306,74620,129850,92028,74558,91966,127546,128634,124026,126202,116986,121338,102906,90848,110968,121022,90736,110908,90680,110878,90652,90638,74104,102590,91e3,74044,90940,74014,90910,74174,91070,90480,110780,90424,110750,90396,90382,73916,90556,73886,90526,90296,110686,90268,90254,73822,90334,90204,90190,71136,101112,116094,70896,100988,70776,100926,70716,70686,129204,71416,101246,129202,71292,71230,127348,71550,127346,123636,123634,116212,116210,101364,101362,79296,105200,118140,79072,105080,118078,78960,105020,78904,104990,78876,78862,70384,100732,79600,70264,100670,79480,105278,79420,70174,79390,129178,70524,129466,79740,70462,79678,127290,127866,123514,124666,115962,118266,100858,113376,122232,126654,95424,113264,122172,95328,113208,122142,95280,113180,95256,113166,95244,78560,104824,117950,95968,78448,104764,95856,113468,104734,95800,78364,95772,78350,95758,70008,100542,78712,69948,96120,78652,69918,96060,78622,96030,70078,78782,96190,94912,113008,122044,94816,112952,122014,94768,112924,94744,112910,94732,94726,78192,104636,95088,78136,104606,95032,113054,95004,78094,94990,69820,78268,69790,95164,78238,95134,94560,112824,121950,94512,112796,94488,112782,94476,94470,78008,104542,94648,77980,94620,77966,94606,69726,78046,94686,94384,112732,94360,112718,94348,94342,77916,94428,77902,94414,94296,112686,94284,94278,77870,94318,94252,94246,68336,99708,68216,99646,68156,68126,68476,68414,127162,123258,115450,99834,72416,101752,116414,72304,101692,72248,101662,72220,72206,67960,99518,72568,67900,72508,67870,72478,68030,72638,80576,105840,118460,80480,105784,118430,80432,105756,80408,105742,80396,80390,72048,101564,80752,71992,101534,80696,71964,80668,71950,80654,67772,72124,67742,80828,72094,80798,114016,122552,126814,96832,113968,122524,96800,113944,122510,96784,113932,96776,113926,96772,80224,105656,118366,97120,80176,105628,97072,114076,105614,97048,80140,97036,80134,97030,71864,101470,80312,71836,97208,80284,71822,97180,80270,97166,67678,71902,80350,97246,96576,113840,122460,96544,113816,122446,96528,113804,96520,113798,96516,96514,80048,105564,96688,80024,105550,96664,113870,96652,80006,96646,71772,80092,71758,96732,80078,96718,96416,113752,122414,96400,113740,96392,113734,96388,96386,79960,105518,96472,79948,96460,79942,96454,71726,79982,96494,96336,113708,96328,113702,96324,96322,79916,96364,79910,96358,96296,113686,96292,96290,79894,96310,66936,99006,66876,66846,67006,68976,100028,68920,99998,68892,68878,66748,69052,66718,69022,73056,102072,116574,73008,102044,72984,102030,72972,72966,68792,99934,73144,68764,73116,68750,73102,66654,68830,73182,81216,106160,118620,81184,106136,118606,81168,106124,81160,106118,81156,81154,72880,101980,81328,72856,101966,81304,106190,81292,72838,81286,68700,72924,68686,81372,72910,81358,114336,122712,126894,114320,122700,114312,122694,114308,114306,81056,106072,118574,97696,81040,106060,97680,114380,106054,97672,81028,97668,81026,97666,72792,101934,81112,72780,97752,81100,72774,97740,81094,97734,68654,72814,81134,97774,114256,122668,114248,122662,114244,114242,80976,106028,97488,80968,106022,97480,114278,97476,80962,97474,72748,81004,72742,97516,80998,97510,114216,122646,114212,114210,80936,106006,97384,80932,97380,80930,97378,72726,80950,97398,114196,114194,80916,97332,80914,97330,66236,66206,67256,99166,67228,67214,66142,67294,69296,100188,69272,100174,69260,69254,67164,69340,67150,69326,73376,102232,116654,73360,102220,73352,102214,73348,73346,69208,100142,73432,102254,73420,69190,73414,67118,69230,73454,106320,118700,106312,118694,106308,106306,73296,102188,81616,106348,102182,81608,73284,81604,73282,81602,69164,73324,69158,81644,73318,81638,122792,126934,122788,122786,106280,118678,114536,106276,114532,106274,114530,73256,102166,81512,73252,98024,81508,73250,98020,81506,98018,69142,73270,81526,98038,122772,122770,106260,114484,106258,114482,73236,81460,73234,97908,81458,97906,122762,106250,114458,73226,81434,97850,66396,66382,67416,99246,67404,67398,66350,67438,69456,100268,69448,100262,69444,69442,67372,69484,67366,69478,102312,116694,102308,102306,69416,100246,73576,102326,73572,69410,73570,67350,69430,73590,118740,118738,102292,106420,102290,106418,69396,73524,69394,81780,73522,81778,118730,102282,106394,69386,73498,81722,66476,66470,67496,99286,67492,67490,66454,67510,100308,100306,67476,69556,67474,69554,116714])]);$_.raps=$a([$a([802,930,946,818,882,890,826,954,922,986,970,906,778,794,786,914,978,982,980,916,948,932,934,942,940,936,808,812,814,806,822,950,918,790,788,820,884,868,870,878,876,872,840,856,860,862,846,844,836,838,834,866]),$a([718,590,622,558,550,566,534,530,538,570,562,546,610,626,634,762,754,758,630,628,612,614,582,578,706,738,742,740,748,620,556,552,616,744,712,716,708,710,646,654,652,668,664,696,688,656,720,592,600,604,732,734])]);$_.cwtobits=function(){var _Ih=$g($_.clusters,$k[--$j]);$_.v=$g(_Ih,$k[--$j]);$k[$j++]=Infinity;for(var _Ik=0;_Ik<17;_Ik++){$k[$j++]=0}var _In=$R($s(17),$_.v,2);for(var _Io=0,_Ip=_In.length;_Io<_Ip;_Io++){$k[$j++]=$g(_In,_Io)-48}var _Ir=$a();$k[$j++]=$G(_Ir,_Ir.length-17,17)};$_.raptobits=function(){var _Iv=$g($_.raps,$k[--$j]);$_.v=$g(_Iv,$k[--$j]);$k[$j++]=Infinity;for(var _Iy=0;_Iy<10;_Iy++){$k[$j++]=0}var _J1=$R($s(10),$_.v,2);for(var _J2=0,_J3=_J1.length;_J2<_J3;_J2++){$k[$j++]=$g(_J1,_J2)-48}var _J5=$a();$k[$j++]=$G(_J5,_J5.length-10,10)};$_.rwid=$g($a([38,55,82,99]),$_.c-1);if($_.c==3&&$_.cca){$_.rwid=72}$_.pixs=$a($_.rwid*$_.r*$_.rowmult);for(var _JI=0,_JH=$_.r-1;_JI<=_JH;_JI+=1){$_.i=_JI;$_.clst=($f($_.i+$_.rapl)-1)%3;$k[$j++]=Infinity;if($_.c==1){$k[$j++]=($f($_.i+$_.rapl)-1)%52;$k[$j++]=0;$_.raptobits();$q($k[--$j]);$k[$j++]=$g($_.cws,$_.i);$k[$j++]=$_.clst;$_.cwtobits();$q($k[--$j]);$k[$j++]=($f($_.i+$_.rapr)-1)%52;$k[$j++]=0;$_.raptobits();$q($k[--$j])}if($_.c==2){$k[$j++]=($f($_.i+$_.rapl)-1)%52;$k[$j++]=0;$_.raptobits();$q($k[--$j]);$k[$j++]=$g($_.cws,$_.i*2);$k[$j++]=$_.clst;$_.cwtobits();$q($k[--$j]);$k[$j++]=$g($_.cws,$_.i*2+1);$k[$j++]=$_.clst;$_.cwtobits();$q($k[--$j]);$k[$j++]=($f($_.i+$_.rapr)-1)%52;$k[$j++]=0;$_.raptobits();$q($k[--$j])}if($_.c==3){if(!$_.cca){$k[$j++]=($f($_.i+$_.rapl)-1)%52;$k[$j++]=0;$_.raptobits();$q($k[--$j])}$k[$j++]=$g($_.cws,$_.i*3);$k[$j++]=$_.clst;$_.cwtobits();$q($k[--$j]);$k[$j++]=($f($_.i+$_.rapc)-1)%52;$k[$j++]=1;$_.raptobits();$q($k[--$j]);$k[$j++]=$g($_.cws,$_.i*3+1);$k[$j++]=$_.clst;$_.cwtobits();$q($k[--$j]);$k[$j++]=$g($_.cws,$_.i*3+2);$k[$j++]=$_.clst;$_.cwtobits();$q($k[--$j]);$k[$j++]=($f($_.i+$_.rapr)-1)%52;$k[$j++]=0;$_.raptobits();$q($k[--$j])}if($_.c==4){$k[$j++]=($f($_.i+$_.rapl)-1)%52;$k[$j++]=0;$_.raptobits();$q($k[--$j]);$k[$j++]=$g($_.cws,$_.i*4);$k[$j++]=$_.clst;$_.cwtobits();$q($k[--$j]);$k[$j++]=$g($_.cws,$_.i*4+1);$k[$j++]=$_.clst;$_.cwtobits();$q($k[--$j]);$k[$j++]=($f($_.i+$_.rapc)-1)%52;$k[$j++]=1;$_.raptobits();$q($k[--$j]);$k[$j++]=$g($_.cws,$_.i*4+2);$k[$j++]=$_.clst;$_.cwtobits();$q($k[--$j]);$k[$j++]=$g($_.cws,$_.i*4+3);$k[$j++]=$_.clst;$_.cwtobits();$q($k[--$j]);$k[$j++]=($f($_.i+$_.rapr)-1)%52;$k[$j++]=0;$_.raptobits();$q($k[--$j])}$k[$j++]=1;var _Ki=$a();$k[$j++]=_Ki;for(var _Kl=0,_Kk=$_.rowmult-1;_Kl<=_Kk;_Kl+=1){var _Kq=$k[$j-1];$P($_.pixs,(_Kl+$_.i*$_.rowmult)*$_.rwid,_Kq)}$j--}var _Kz=new Map([["ren","renmatrix"],["pixs",$_.pixs],["pixx",$_.rwid],["pixy",$_.r*$_.rowmult],["height",$_.r*$_.rowmult/72],["width",$_.rwid/72],["borderleft",1],["borderright",1],["bordertop",1],["borderbottom",1],["opt",$_.options]]);$k[$j++]=_Kz;if(!$_.dontdraw){bwipp_renmatrix()}$_=$__}function bwipp_datamatrix(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.columns=0;$_.rows=0;$_.format="unset";$_.version="unset";$_.parse=false;$_.parsefnc=false;$_.c40headerlength=-1;$_.raw=false;$_.dmre=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.barcode.length==0){$k[$j++]="bwipp.datamatrixEmptyData#19750";$k[$j++]="The data must not be empty";bwipp_raiseerror()}if($ne($_.version,"unset")&&($_.rows!=0||$_.columns!=0)){$k[$j++]="bwipp.datamatrixVersionRowsCols#19754";$k[$j++]="rows and columns must not be given if version is specified";bwipp_raiseerror()}if($ne($_.version,"unset")){$X($_.version,"x");if($k[--$j]){var _9=$k[--$j];$k[$j-1]=_9;var _B=$k[$j-1];var _C=$k[$j-2];$k[$j++]=_C;$k[$j++]=_B;$as($a(2));$F($k[--$j],function(){var _F=$k[$j-1];$k[$j++]=true;if(_F.length==0){$k[$j-1]=false}var _G=$k[--$j];var _H=$k[--$j];$k[$j++]=_G;$F(_H,function(){var _I=$k[--$j];if(_I<48||_I>57){$k[$j-1]=false}});if(!$k[--$j]){$k[$j++]="bwipp.datamatrixVersionBadRowOrColumn#19768";$k[$j++]="version must be formatted as RxC";bwipp_raiseerror()}});$_.rows=$i($k[--$j]);$_.columns=$i($k[--$j]);$k[$j++]="format";if($_.rows==$_.columns){$k[$j++]="square"}else{$k[$j++]="rectangle"}var _O=$k[--$j];$_[$k[--$j]]=_O}else{$j--;$k[$j++]="bwipp.datamatrixVersionFormat#19775";$k[$j++]="version must be formatted as RxC";bwipp_raiseerror()}}else{if($eq($_.format,"unset")){$k[$j++]="format";if($_.dmre){$k[$j++]="rectangle"}else{$k[$j++]="square"}var _S=$k[--$j];$_[$k[--$j]]=_S}}if($ne($_.format,"square")&&$ne($_.format,"rectangle")){$k[$j++]="bwipp.datamatrixInvalidFormat#19784";$k[$j++]="The format must be either square or rectangle";bwipp_raiseerror()}$_.metrics=$a([$a([10,10,1,1,5,1,0]),$a([12,12,1,1,7,1,0]),$a([14,14,1,1,10,1,0]),$a([16,16,1,1,12,1,0]),$a([18,18,1,1,14,1,0]),$a([20,20,1,1,18,1,0]),$a([22,22,1,1,20,1,0]),$a([24,24,1,1,24,1,0]),$a([26,26,1,1,28,1,0]),$a([32,32,2,2,36,1,0]),$a([36,36,2,2,42,1,0]),$a([40,40,2,2,48,1,0]),$a([44,44,2,2,56,1,0]),$a([48,48,2,2,68,1,0]),$a([52,52,2,2,84,2,0]),$a([64,64,4,4,112,2,0]),$a([72,72,4,4,144,4,0]),$a([80,80,4,4,192,4,0]),$a([88,88,4,4,224,4,0]),$a([96,96,4,4,272,4,0]),$a([104,104,4,4,336,6,0]),$a([120,120,6,6,408,6,0]),$a([132,132,6,6,496,8,0]),$a([144,144,6,6,620,10,0]),$a([8,18,1,1,7,1,0]),$a([8,32,1,2,11,1,0]),$a([8,48,1,2,15,1,1]),$a([8,64,1,4,18,1,1]),$a([8,80,1,4,22,1,1]),$a([8,96,1,4,28,1,1]),$a([8,120,1,6,32,1,1]),$a([8,144,1,6,36,1,1]),$a([12,26,1,1,14,1,0]),$a([12,36,1,2,18,1,0]),$a([12,64,1,4,27,1,1]),$a([12,88,1,4,36,1,1]),$a([16,36,1,2,24,1,0]),$a([16,48,1,2,28,1,0]),$a([16,64,1,4,36,1,1]),$a([20,36,1,2,28,1,1]),$a([20,44,1,2,34,1,1]),$a([20,64,1,4,42,1,1]),$a([22,48,1,2,38,1,1]),$a([24,48,1,2,41,1,1]),$a([24,64,1,4,46,1,1]),$a([26,40,1,2,38,1,1]),$a([26,48,1,2,42,1,1]),$a([26,64,1,4,50,1,1])]);$_.urows=$_.rows;$_.ucols=$_.columns;$_.fullcws=$a([]);var _1N=$_.metrics;for(var _1O=0,_1P=_1N.length;_1O<_1P;_1O++){$_.m=$g(_1N,_1O);$_.rows=$g($_.m,0);$_.cols=$g($_.m,1);$_.regh=$g($_.m,2);$_.regv=$g($_.m,3);$_.rscw=$g($_.m,4);$_.rsbl=$g($_.m,5);$_.doly=$g($_.m,6);$_.mrows=$f($_.rows-2*$_.regh);$_.mcols=$f($_.cols-2*$_.regv);$_.ncws=$f(~~($_.mrows*$_.mcols/8)-$_.rscw);$_.okay=true;if($_.urows!=0&&$_.urows!=$_.rows){$_.okay=false}if($_.ucols!=0&&$_.ucols!=$_.cols){$_.okay=false}if($eq($_.format,"square")&&$ne($_.rows,$_.cols)){$_.okay=false}if($eq($_.format,"rectangle")&&$eq($_.rows,$_.cols)){$_.okay=false}if(!$_.dmre&&$_.doly==1){$_.okay=false}if($_.okay){$k[$j++]=Infinity;$q($_.fullcws);$k[$j++]=$_.ncws;$_.fullcws=$a()}}$k[$j++]=Infinity;for(var _24=0;_24<1558;_24++){$k[$j++]=1e4}$_.numremcws=$a();var _26=$_.fullcws;for(var _27=0,_28=_26.length;_27<_28;_27++){$p($_.numremcws,$g(_26,_27)-1,1)}for(var _2B=1556;_2B>=0;_2B-=1){$_.i=_2B;if($g($_.numremcws,$_.i)!=1){$p($_.numremcws,$_.i,$g($_.numremcws,$_.i+1)+1)}}$_.fnc1=-1;$_.prog=-2;$_.m05=-3;$_.m06=-4;$_.lC=-5;$_.lB=-6;$_.lX=-7;$_.lT=-8;$_.lE=-9;$_.unl=-10;$_.sapp=-11;$_.usft=-12;$_.sft1=-13;$_.sft2=-14;$_.sft3=-15;$_.eci=-16;$_.pad=-17;$_.unlcw=254;$k[$j++]=Infinity;for(var _2K=0;_2K<=128;_2K+=1){$k[$j++]=_2K;$k[$j++]=_2K+1}$k[$j++]=$_.pad;$k[$j++]=129;for(var _2M=0;_2M<=99;_2M+=1){var _2O=$R($s(2),_2M,10);var _2Q=$Z($s(2),"00");$P(_2Q,2-_2O.length,_2O);$k[$j++]=_2Q;$k[$j++]=_2M+130}var _2d=$a([$_.lC,$_.lB,$_.fnc1,$_.sapp,$_.prog,$_.usft,$_.m05,$_.m06,$_.lX,$_.lT,$_.lE,$_.eci]);$k[$j++]=229;for(var _2e=0,_2f=_2d.length;_2e<_2f;_2e++){var _2i=$k[--$j]+1;$k[$j++]=$g(_2d,_2e);$k[$j++]=_2i;$k[$j++]=_2i}$j--;$_.Avals=$d();$k[$j++]=Infinity;var _2k=$_.Avals;for(var _2p=_2k.size,_2o=_2k.keys(),_2n=0;_2n<_2p;_2n++){var _2l=_2o.next().value;$k[$j++]=_2l;var _2q=Infinity;var _2r=_2k.get(_2l);$k[$j++]=_2q;$k[$j++]=_2r;var _2s=$a();$k[$j++]=_2s}$_.Avals=$d();$k[$j++]=Infinity;$k[$j++]=$_.sft1;$k[$j++]=0;$k[$j++]=$_.sft2;$k[$j++]=1;$k[$j++]=$_.sft3;$k[$j++]=2;$k[$j++]=32;$k[$j++]=3;for(var _2x=48;_2x<=57;_2x+=1){$k[$j++]=_2x;$k[$j++]=_2x-44}for(var _2y=65;_2y<=90;_2y+=1){$k[$j++]=_2y;$k[$j++]=_2y-51}$_.CNvals=$d();$k[$j++]=Infinity;for(var _30=0;_30<=31;_30+=1){$k[$j++]=_30;$k[$j++]=_30}$_.C1vals=$d();$k[$j++]=Infinity;for(var _32=33;_32<=47;_32+=1){$k[$j++]=_32;$k[$j++]=_32-33}for(var _33=58;_33<=64;_33+=1){$k[$j++]=_33;$k[$j++]=_33-43}for(var _34=91;_34<=95;_34+=1){$k[$j++]=_34;$k[$j++]=_34-69}$k[$j++]=$_.fnc1;$k[$j++]=27;$k[$j++]=$_.usft;$k[$j++]=30;$_.C2vals=$d();$k[$j++]=Infinity;for(var _38=96;_38<=127;_38+=1){$k[$j++]=_38;$k[$j++]=_38-96}$_.C3vals=$d();$k[$j++]=Infinity;var _3A=$_.CNvals;for(var _3F=_3A.size,_3E=_3A.keys(),_3D=0;_3D<_3F;_3D++){var _3B=_3E.next().value;$k[$j++]=_3B;var _3G=Infinity;var _3H=_3A.get(_3B);$k[$j++]=_3G;$k[$j++]=_3H;var _3I=$a();$k[$j++]=_3I}var _3J=$_.C1vals;for(var _3O=_3J.size,_3N=_3J.keys(),_3M=0;_3M<_3O;_3M++){var _3K=_3N.next().value;$k[$j++]=_3K;var _3P=Infinity;var _3Q=_3J.get(_3K);$k[$j++]=_3P;$k[$j++]=$g($_.CNvals,$_.sft1);$k[$j++]=_3Q;var _3U=$a();$k[$j++]=_3U}var _3V=$_.C2vals;for(var _3a=_3V.size,_3Z=_3V.keys(),_3Y=0;_3Y<_3a;_3Y++){var _3W=_3Z.next().value;$k[$j++]=_3W;var _3b=Infinity;var _3c=_3V.get(_3W);$k[$j++]=_3b;$k[$j++]=$g($_.CNvals,$_.sft2);$k[$j++]=_3c;var _3g=$a();$k[$j++]=_3g}var _3h=$_.C3vals;for(var _3m=_3h.size,_3l=_3h.keys(),_3k=0;_3k<_3m;_3k++){var _3i=_3l.next().value;$k[$j++]=_3i;var _3n=Infinity;var _3o=_3h.get(_3i);$k[$j++]=_3n;$k[$j++]=$g($_.CNvals,$_.sft3);$k[$j++]=_3o;var _3s=$a();$k[$j++]=_3s}$_.Cvals=$d();$k[$j++]=Infinity;$k[$j++]=$_.sft1;$k[$j++]=0;$k[$j++]=$_.sft2;$k[$j++]=1;$k[$j++]=$_.sft3;$k[$j++]=2;$k[$j++]=32;$k[$j++]=3;for(var _3x=48;_3x<=57;_3x+=1){$k[$j++]=_3x;$k[$j++]=_3x-44}for(var _3y=97;_3y<=122;_3y+=1){$k[$j++]=_3y;$k[$j++]=_3y-83}$_.TNvals=$d();$k[$j++]=Infinity;for(var _40=0;_40<=31;_40+=1){$k[$j++]=_40;$k[$j++]=_40}$_.T1vals=$d();$k[$j++]=Infinity;for(var _42=33;_42<=47;_42+=1){$k[$j++]=_42;$k[$j++]=_42-33}for(var _43=58;_43<=64;_43+=1){$k[$j++]=_43;$k[$j++]=_43-43}for(var _44=91;_44<=95;_44+=1){$k[$j++]=_44;$k[$j++]=_44-69}$k[$j++]=$_.fnc1;$k[$j++]=27;$k[$j++]=$_.usft;$k[$j++]=30;$_.T2vals=$d();$k[$j++]=Infinity;$k[$j++]=96;$k[$j++]=0;for(var _48=65;_48<=90;_48+=1){$k[$j++]=_48;$k[$j++]=_48-64}for(var _49=123;_49<=127;_49+=1){$k[$j++]=_49;$k[$j++]=_49-96}$_.T3vals=$d();$k[$j++]=Infinity;var _4B=$_.TNvals;for(var _4G=_4B.size,_4F=_4B.keys(),_4E=0;_4E<_4G;_4E++){var _4C=_4F.next().value;$k[$j++]=_4C;var _4H=Infinity;var _4I=_4B.get(_4C);$k[$j++]=_4H;$k[$j++]=_4I;var _4J=$a();$k[$j++]=_4J}var _4K=$_.T1vals;for(var _4P=_4K.size,_4O=_4K.keys(),_4N=0;_4N<_4P;_4N++){var _4L=_4O.next().value;$k[$j++]=_4L;var _4Q=Infinity;var _4R=_4K.get(_4L);$k[$j++]=_4Q;$k[$j++]=$g($_.TNvals,$_.sft1);$k[$j++]=_4R;var _4V=$a();$k[$j++]=_4V}var _4W=$_.T2vals;for(var _4b=_4W.size,_4a=_4W.keys(),_4Z=0;_4Z<_4b;_4Z++){var _4X=_4a.next().value;$k[$j++]=_4X;var _4c=Infinity;var _4d=_4W.get(_4X);$k[$j++]=_4c;$k[$j++]=$g($_.TNvals,$_.sft2);$k[$j++]=_4d;var _4h=$a();$k[$j++]=_4h}var _4i=$_.T3vals;for(var _4n=_4i.size,_4m=_4i.keys(),_4l=0;_4l<_4n;_4l++){var _4j=_4m.next().value;$k[$j++]=_4j;var _4o=Infinity;var _4p=_4i.get(_4j);$k[$j++]=_4o;$k[$j++]=$g($_.TNvals,$_.sft3);$k[$j++]=_4p;var _4t=$a();$k[$j++]=_4t}$_.Tvals=$d();for(var _4v=128;_4v<=255;_4v+=1){$_.i=_4v;$k[$j++]=$_.Avals;$k[$j++]=$_.i;$k[$j++]=Infinity;$q($g($_.Avals,$_.usft));$q($g($_.Avals,$_.i-128));var _54=$a();var _55=$k[--$j];$p($k[--$j],_55,_54);$k[$j++]=$_.Cvals;$k[$j++]=$_.i;$k[$j++]=Infinity;$q($g($_.Cvals,$_.usft));$q($g($_.Cvals,$_.i-128));var _5F=$a();var _5G=$k[--$j];$p($k[--$j],_5G,_5F);$k[$j++]=$_.Tvals;$k[$j++]=$_.i;$k[$j++]=Infinity;$q($g($_.Tvals,$_.usft));$q($g($_.Tvals,$_.i-128));var _5Q=$a();var _5R=$k[--$j];$p($k[--$j],_5R,_5Q)}$k[$j++]=Infinity;$k[$j++]=13;$k[$j++]=0;$k[$j++]=42;$k[$j++]=1;$k[$j++]=62;$k[$j++]=2;$k[$j++]=32;$k[$j++]=3;for(var _5T=48;_5T<=57;_5T+=1){$k[$j++]=_5T;$k[$j++]=_5T-44}for(var _5U=65;_5U<=90;_5U+=1){$k[$j++]=_5U;$k[$j++]=_5U-51}$_.Xvals=$d();$k[$j++]=Infinity;var _5W=$_.Xvals;for(var _5b=_5W.size,_5a=_5W.keys(),_5Z=0;_5Z<_5b;_5Z++){var _5X=_5a.next().value;$k[$j++]=_5X;var _5c=Infinity;var _5d=_5W.get(_5X);$k[$j++]=_5c;$k[$j++]=_5d;var _5e=$a();$k[$j++]=_5e}$_.Xvals=$d();$k[$j++]=Infinity;for(var _5g=64;_5g<=94;_5g+=1){$k[$j++]=_5g;$k[$j++]=_5g-64}$k[$j++]=$_.unl;$k[$j++]=31;for(var _5i=32;_5i<=63;_5i+=1){$k[$j++]=_5i;$k[$j++]=_5i}$_.Evals=$d();$k[$j++]=Infinity;var _5k=$_.Evals;for(var _5p=_5k.size,_5o=_5k.keys(),_5n=0;_5n<_5p;_5n++){var _5l=_5o.next().value;$k[$j++]=_5l;var _5q=Infinity;var _5r=_5k.get(_5l);$k[$j++]=_5q;$k[$j++]=_5r;var _5s=$a();$k[$j++]=_5s}$_.Evals=$d();$k[$j++]=Infinity;for(var _5u=0;_5u<=255;_5u+=1){$k[$j++]=_5u;$k[$j++]=_5u}$_.Bvals=$d();$k[$j++]=Infinity;var _5w=$_.Bvals;for(var _61=_5w.size,_60=_5w.keys(),_5z=0;_5z<_61;_5z++){var _5x=_60.next().value;$k[$j++]=_5x;var _62=Infinity;var _63=_5w.get(_5x);$k[$j++]=_62;$k[$j++]=_63;var _64=$a();$k[$j++]=_64}$_.Bvals=$d();$_.encvals=$a([$_.Avals,$_.Cvals,$_.Tvals,$_.Xvals,$_.Evals,$_.Bvals]);$_.A=0;$_.C=1;$_.T=2;$_.X=3;$_.E=4;$_.B=5;if($_.raw){$_.cws=$a($_.barcode.length);$_.i=0;$_.j=0;for(;;){if($_.i==$_.barcode.length){break}$_.cw=$i($G($_.barcode,$_.i+1,3));$p($_.cws,$_.j,$_.cw);$_.i=$_.i+4;$_.j=$_.j+1}$_.cws=$G($_.cws,0,$_.j)}else{var _6Y=new Map([["parse",$_.parse],["parsefnc",$_.parsefnc],["eci",true],["FNC1",$_.fnc1],["PROG",$_.prog]]);$_.fncvals=_6Y;$k[$j++]="msg";$k[$j++]=$_.barcode;$k[$j++]=$_.fncvals;bwipp_parseinput();var _6b=$k[--$j];$_[$k[--$j]]=_6b;$_.msglen=$_.msg.length;if($_.msglen>=9){$q($G($_.msg,0,7));var _6h=$k[--$j];$k[$j-1]=_6h==29;var _6j=$k[--$j];var _6k=$k[--$j];var _6l=$k[--$j];var _6m=$k[--$j];var _6n=$k[--$j];var _6o=$k[--$j];if(_6j&&_6k==48&&_6l==30&&_6m==62&&_6n==41&&_6o==91){$q($G($_.msg,$_.msglen-2,2));var _6s=$k[--$j];var _6t=$k[--$j];if(_6s==4&&_6t==30){if($g($_.msg,5)==53){$k[$j++]=Infinity;$k[$j++]=$_.m05;$q($G($_.msg,7,$_.msg.length-9));$_.msg=$a()}else{if($g($_.msg,5)==54){$k[$j++]=Infinity;$k[$j++]=$_.m06;$q($G($_.msg,7,$_.msg.length-9));$_.msg=$a()}}}}}$_.msglen=$_.msg.length;$k[$j++]=Infinity;for(var _7A=0,_7B=$_.msglen;_7A<_7B;_7A++){$k[$j++]=0}$k[$j++]=0;$_.numD=$a();$k[$j++]=Infinity;for(var _7E=0,_7F=$_.msglen;_7E<_7F;_7E++){$k[$j++]=0}$k[$j++]=9999;$_.nextXterm=$a();$k[$j++]=Infinity;for(var _7I=0,_7J=$_.msglen;_7I<_7J;_7I++){$k[$j++]=0}$k[$j++]=9999;$_.nextNonX=$a();$k[$j++]=Infinity;for(var _7M=0,_7N=$_.msglen;_7M<_7N;_7M++){$k[$j++]=false}$k[$j++]=false;$_.isECI=$a();for(var _7Q=$_.msglen-1;_7Q>=0;_7Q-=1){$_.i=_7Q;$_.barchar=$g($_.msg,$_.i);if($_.barchar>=48&&$_.barchar<=57){$p($_.numD,$_.i,$g($_.numD,$_.i+1)+1)}if($_.barchar==13||$_.barchar==42||$_.barchar==62){$p($_.nextXterm,$_.i,0)}else{$p($_.nextXterm,$_.i,$g($_.nextXterm,$_.i+1)+1)}var _7n=$g($_.Xvals,$_.barchar)!==undefined;if(!_7n){$p($_.nextNonX,$_.i,0)}else{$p($_.nextNonX,$_.i,$g($_.nextNonX,$_.i+1)+1)}$p($_.isECI,$_.i,$_.barchar<=-1e6)}$k[$j++]=Infinity;var _7y=$_.nextXterm;for(var _7z=0,_80=_7y.length;_7z<_80;_7z++){var _81=$g(_7y,_7z);$k[$j++]=_81;if(_81>1e4){$k[$j-1]=1e4}}$_.nextXterm=$a();$k[$j++]=Infinity;var _83=$_.nextNonX;for(var _84=0,_85=_83.length;_84<_85;_84++){var _86=$g(_83,_84);$k[$j++]=_86;if(_86>1e4){$k[$j-1]=1e4}}$_.nextNonX=$a();$_.isD=function(){$k[$j++]=$_.char>=48&&$_.char<=57};$_.isC=function(){var _8C=$g($_.CNvals,$_.char)!==undefined;$k[$j++]=_8C};$_.isT=function(){var _8F=$g($_.TNvals,$_.char)!==undefined;$k[$j++]=_8F};$_.isX=function(){var _8I=$g($_.Xvals,$_.char)!==undefined;$k[$j++]=_8I};$_.isE=function(){var _8L=$g($_.Evals,$_.char)!==undefined;$k[$j++]=_8L};$_.isEA=function(){$k[$j++]=$_.char>127};$_.isFN=function(){$k[$j++]=$_.char<0};$_.XtermFirst=function(){var _8O=$k[--$j];$k[$j++]=$lt($g($_.nextXterm,_8O),$g($_.nextNonX,_8O))};$_.lookup=function(){$_.ac=1;$_.cc=2;$_.tc=2;$_.xc=2;$_.ec=2;$_.bc=2.25;if($_.mode==$_.A){$_.ac=0;$_.cc=1;$_.tc=1;$_.xc=1;$_.ec=1;$_.bc=1.25}if($_.mode==$_.C){$_.cc=0}if($_.mode==$_.T){$_.tc=0}if($_.mode==$_.X){$_.xc=0}if($_.mode==$_.E){$_.ec=0}if($_.mode==$_.B){$_.bc=0}for(var _8f=0;_8f<1;_8f++){if($g($_.isECI,$_.i)){$k[$j++]=$_.A;break}if($_.c40headerlength!=-1&&$_.i<$_.c40headerlength){$k[$j++]=$_.C;break}$_.k=0;for(;;){if($_.i+$_.k==$_.msglen){var _8r=$a(["ac","cc","tc","xc","ec","bc"]);for(var _8s=0,_8t=_8r.length;_8s<_8t;_8s++){var _8u=$g(_8r,_8s);$_[_8u]=$ceil($_[_8u])}var _91=$a([$_.cc,$_.tc,$_.xc,$_.ec,$_.bc]);$k[$j++]=true;for(var _92=0,_93=_91.length;_92<_93;_92++){var _96=$k[--$j];$k[$j++]=_96&&$_.ac<=$g(_91,_92)}if($k[--$j]){$k[$j++]=$_.A;break}var _9E=$a([$_.ac,$_.cc,$_.tc,$_.xc,$_.ec]);$k[$j++]=true;for(var _9F=0,_9G=_9E.length;_9F<_9G;_9F++){var _9J=$k[--$j];$k[$j++]=_9J&&$_.bc<$g(_9E,_9F)}if($k[--$j]){$k[$j++]=$_.B;break}var _9R=$a([$_.ac,$_.cc,$_.tc,$_.xc,$_.bc]);$k[$j++]=true;for(var _9S=0,_9T=_9R.length;_9S<_9T;_9S++){var _9W=$k[--$j];$k[$j++]=_9W&&$_.ec<$g(_9R,_9S)}if($k[--$j]){$k[$j++]=$_.E;break}var _9e=$a([$_.ac,$_.cc,$_.xc,$_.ec,$_.bc]);$k[$j++]=true;for(var _9f=0,_9g=_9e.length;_9f<_9g;_9f++){var _9j=$k[--$j];$k[$j++]=_9j&&$_.tc<$g(_9e,_9f)}if($k[--$j]){$k[$j++]=$_.T;break}var _9r=$a([$_.ac,$_.cc,$_.tc,$_.ec,$_.bc]);$k[$j++]=true;for(var _9s=0,_9t=_9r.length;_9s<_9t;_9s++){var _9w=$k[--$j];$k[$j++]=_9w&&$_.xc<$g(_9r,_9s)}if($k[--$j]){$k[$j++]=$_.X;break}$k[$j++]=$_.C;break}$_.char=$g($_.msg,$_.i+$_.k);$k[$j++]="ac";$k[$j++]=$_.ac;$_.isD();if($k[--$j]){var _A6=$k[--$j];$k[$j++]=$f(_A6+1/2)}else{$_.isEA();if($k[--$j]){var _A8=$k[--$j];$k[$j++]=$ceil(_A8)+2}else{var _A9=$k[--$j];$k[$j++]=$ceil(_A9)+1}}var _AA=$k[--$j];$_[$k[--$j]]=_AA;$k[$j++]="cc";$k[$j++]=$_.cc;$_.isC();if($k[--$j]){var _AE=$k[--$j];$k[$j++]=$f(_AE+.6666667)}else{$_.isEA();if($k[--$j]){var _AG=$k[--$j];$k[$j++]=$f(_AG+2.6666667)}else{var _AH=$k[--$j];$k[$j++]=$f(_AH+1.3333334)}}var _AI=$k[--$j];$_[$k[--$j]]=_AI;$k[$j++]="tc";$k[$j++]=$_.tc;$_.isT();if($k[--$j]){var _AM=$k[--$j];$k[$j++]=$f(_AM+.6666667)}else{$_.isEA();if($k[--$j]){var _AO=$k[--$j];$k[$j++]=$f(_AO+2.6666667)}else{var _AP=$k[--$j];$k[$j++]=$f(_AP+1.3333334)}}var _AQ=$k[--$j];$_[$k[--$j]]=_AQ;$k[$j++]="xc";$k[$j++]=$_.xc;$_.isX();if($k[--$j]){var _AU=$k[--$j];$k[$j++]=$f(_AU+.6666667)}else{$_.isEA();if($k[--$j]){var _AW=$k[--$j];$k[$j++]=$f(_AW+4.3333334)}else{var _AX=$k[--$j];$k[$j++]=$f(_AX+3.3333334)}}var _AY=$k[--$j];$_[$k[--$j]]=_AY;$k[$j++]="ec";$k[$j++]=$_.ec;$_.isE();if($k[--$j]){var _Ac=$k[--$j];$k[$j++]=$f(_Ac+3/4)}else{$_.isEA();if($k[--$j]){var _Ae=$k[--$j];$k[$j++]=$f(_Ae+17/4)}else{var _Af=$k[--$j];$k[$j++]=$f(_Af+13/4)}}var _Ag=$k[--$j];$_[$k[--$j]]=_Ag;$k[$j++]="bc";$k[$j++]=$_.bc;$_.isFN();if($k[--$j]){var _Ak=$k[--$j];$k[$j++]=_Ak+4}else{var _Al=$k[--$j];$k[$j++]=_Al+1}var _Am=$k[--$j];$_[$k[--$j]]=_Am;if($_.k>=4){var _Au=$a([$_.cc,$_.tc,$_.xc,$_.ec,$_.bc]);$k[$j++]=true;for(var _Av=0,_Aw=_Au.length;_Av<_Aw;_Av++){var _Az=$k[--$j];$k[$j++]=_Az&&$_.ac+1<=$g(_Au,_Av)}if($k[--$j]){$k[$j++]=$_.A;break}if($_.bc+1<=$_.ac){$k[$j++]=$_.B;break}var _B9=$a([$_.cc,$_.tc,$_.xc,$_.ec]);$k[$j++]=true;for(var _BA=0,_BB=_B9.length;_BA<_BB;_BA++){var _BE=$k[--$j];$k[$j++]=_BE&&$_.bc+1<$g(_B9,_BA)}if($k[--$j]){$k[$j++]=$_.B;break}var _BM=$a([$_.ac,$_.cc,$_.tc,$_.xc,$_.bc]);$k[$j++]=true;for(var _BN=0,_BO=_BM.length;_BN<_BO;_BN++){var _BR=$k[--$j];$k[$j++]=_BR&&$_.ec+1<$g(_BM,_BN)}if($k[--$j]){$k[$j++]=$_.E;break}var _BZ=$a([$_.ac,$_.cc,$_.xc,$_.ec,$_.bc]);$k[$j++]=true;for(var _Ba=0,_Bb=_BZ.length;_Ba<_Bb;_Ba++){var _Be=$k[--$j];$k[$j++]=_Be&&$_.tc+1<$g(_BZ,_Ba)}if($k[--$j]){$k[$j++]=$_.T;break}var _Bm=$a([$_.ac,$_.cc,$_.tc,$_.ec,$_.bc]);$k[$j++]=true;for(var _Bn=0,_Bo=_Bm.length;_Bn<_Bo;_Bn++){var _Br=$k[--$j];$k[$j++]=_Br&&$_.xc+1<$g(_Bm,_Bn)}if($k[--$j]){$k[$j++]=$_.X;break}var _By=$a([$_.ac,$_.tc,$_.ec,$_.bc]);$k[$j++]=true;for(var _Bz=0,_C0=_By.length;_Bz<_C0;_Bz++){var _C3=$k[--$j];$k[$j++]=_C3&&$_.cc+1<$g(_By,_Bz)}if($k[--$j]){if($_.cc<$_.xc){$k[$j++]=$_.C;break}if($_.cc==$_.xc){$k[$j++]=$_.i+$_.k+1;$_.XtermFirst();if($k[--$j]){$k[$j++]=$_.X;break}else{$k[$j++]=$_.C;break}}}}$_.k=$_.k+1}}};$_.addtocws=function(){var _CG=$k[--$j];$P($_.cws,$_.j,_CG);$_.j=_CG.length+$_.j};$_.ECItocws=function(){var _CL=-$k[--$j]-1e6;$k[$j++]=_CL;if(_CL<=126){var _CM=$k[--$j];$k[$j++]=_CM+1;$as($a(1))}else{var _CO=$k[$j-1];if(_CO<=16382){var _CQ=$k[--$j]-127;$k[$j++]=~~(_CQ/254)+128;$k[$j++]=_CQ%254+1;$as($a(2))}else{var _CT=$k[--$j]-16383;$k[$j++]=~~(_CT/64516)+192;$k[$j++]=~~(_CT/254)%254+1;$k[$j++]=_CT%254+1;$as($a(3))}}};$_.encA=function(){for(var _CV=0;_CV<1;_CV++){if($g($_.isECI,$_.i)){$k[$j++]=$g($_.Avals,$_.eci);$_.addtocws();$k[$j++]=$g($_.msg,$_.i);$_.ECItocws();$_.addtocws();$_.i=$_.i+1;break}if($g($_.numD,$_.i)>=2){var _Cj=$s(2);$p(_Cj,0,$g($_.msg,$_.i));$p(_Cj,1,$g($_.msg,$_.i+1));$k[$j++]=$g($_.Avals,_Cj);$_.addtocws();$_.i=$_.i+2;break}$k[$j++]="newmode";$_.lookup();var _Ct=$k[--$j];$_[$k[--$j]]=_Ct;if($_.newmode!=$_.mode){$k[$j++]=$g($_.Avals,$g($a([-1,$_.lC,$_.lT,$_.lX,$_.lE,$_.lB]),$_.newmode));$_.addtocws();$_.mode=$_.newmode;break}$k[$j++]=$g($_.Avals,$g($_.msg,$_.i));$_.addtocws();$_.i=$_.i+1;break}};$_.CTXvalstocws=function(){$_.in=$k[--$j];$k[$j++]=Infinity;for(var _DH=0,_DG=$_.in.length-1;_DH<=_DG;_DH+=3){var _DJ=$G($_.in,_DH,3);$k[$j++]=0;for(var _DK=0,_DL=_DJ.length;_DK<_DL;_DK++){var _DN=$k[--$j];$k[$j++]=$f(_DN+$g(_DJ,_DK))*40}var _DP=~~($k[--$j]/40)+1;$k[$j++]=~~(_DP/256);$k[$j++]=_DP%256}$as($a($m()));var _DS=$k[--$j];$k[$j-1]=_DS};$_.encCTX=function(){$_.p=0;$_.ctxvals=$a(2500);$_.done=false;for(;;){if($_.i==$_.msglen){break}var _Dd=$g($g($_.encvals,$_.mode),$g($_.msg,$_.i))!==undefined;if(!_Dd){break}if($_.p%3==0){if($_.p>0){$k[$j++]="newmode";$_.lookup();var _Dg=$k[--$j];$_[$k[--$j]]=_Dg;if($ne($_.newmode,$_.mode)){$k[$j++]=$G($_.ctxvals,0,$_.p);$_.CTXvalstocws();$_.addtocws();$k[$j++]=$a([$_.unlcw]);$_.addtocws();if($_.newmode!=$_.A){$k[$j++]=$g($_.Avals,$g($a([-1,$_.lC,$_.lT,$_.lX,$_.lE,$_.lB]),$_.newmode));$_.addtocws()}$_.mode=$_.newmode;$_.done=true;break}}if($_.msglen-$_.i<=3){$_.remcws=$g($_.numremcws,$_.j+~~($_.p/3)*2);$k[$j++]=Infinity;var _EC=$G($_.msg,$_.i,$_.msglen-$_.i);for(var _ED=0,_EE=_EC.length;_ED<_EE;_ED++){var _EF=$g(_EC,_ED);var _EJ=$g($g($_.encvals,$_.mode),_EF)!==undefined;$k[$j++]=_EF;if(_EJ){$q($g($g($_.encvals,$_.mode),$k[--$j]))}else{$k[$j-1]=-1;$k[$j++]=-1;$k[$j++]=-1;$k[$j++]=-1}}$_.remvals=$a();if($_.remcws==2&&$_.remvals.length==3){$k[$j++]=Infinity;$q($G($_.ctxvals,0,$_.p));$q($_.remvals);var _EW=$a();$k[$j++]=_EW;$_.CTXvalstocws();$_.addtocws();$_.mode=$_.A;$_.i=$_.msglen;$_.done=true;break}if($_.remcws==2&&$_.remvals.length==2&&$_.mode!=$_.X){$k[$j++]=Infinity;$q($G($_.ctxvals,0,$_.p));$q($_.remvals);$q($g($g($_.encvals,$_.mode),$_.sft1));var _Em=$a();$k[$j++]=_Em;$_.CTXvalstocws();$_.addtocws();$_.mode=$_.A;$_.i=$_.msglen;$_.done=true;break}if($_.remcws==2&&$_.remvals.length==1){$k[$j++]=$G($_.ctxvals,0,$_.p);$_.CTXvalstocws();$_.addtocws();$k[$j++]=$a([$_.unlcw]);$_.addtocws();$k[$j++]=$g($_.Avals,$g($_.msg,$_.i));$_.addtocws();$_.mode=$_.A;$_.i=$_.msglen;$_.done=true;break}if($_.remcws==1&&$_.remvals.length==1){$k[$j++]=$G($_.ctxvals,0,$_.p);$_.CTXvalstocws();$_.addtocws();$k[$j++]=$g($_.Avals,$g($_.msg,$_.i));$_.addtocws();$_.mode=$_.A;$_.i=$_.msglen;$_.done=true;break}}}var _FL=$g($g($_.encvals,$_.mode),$g($_.msg,$_.i));$P($_.ctxvals,$_.p,_FL);$_.p=_FL.length+$_.p;$_.i=$_.i+1}if(!$_.done){for(;;){if($_.p%3==0){break}$_.i=$_.i-1;$_.p=$_.p-$g($g($_.encvals,$_.mode),$g($_.msg,$_.i)).length}$k[$j++]=Infinity;$q($G($_.ctxvals,0,$_.p));var _Fe=$a();$k[$j++]=_Fe;$_.CTXvalstocws();$_.addtocws();$k[$j++]=$a([$_.unlcw]);$_.addtocws();$_.mode=$_.A;if($_.i!=$_.msglen&&!$g($_.isECI,$_.i)){if($g($_.numD,$_.i)>=2){var _Fq=$s(2);$p(_Fq,0,$g($_.msg,$_.i));$p(_Fq,1,$g($_.msg,$_.i+1));$k[$j++]=$g($_.Avals,_Fq);$_.addtocws();$_.i=$_.i+2}else{$k[$j++]=$g($_.Avals,$g($_.msg,$_.i));$_.addtocws();$_.i=$_.i+1}}}};$_.Evalstocws=function(){$_.in=$k[--$j];$_.inlen=$_.in.length;$_.outlen=~~$ceil($_.in.length/4*3);$k[$j++]=Infinity;$q($_.in);$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$_.in=$a();$k[$j++]=Infinity;for(var _GD=0,_GC=$_.inlen-1;_GD<=_GC;_GD+=4){var _GF=$G($_.in,_GD,4);$k[$j++]=0;for(var _GG=0,_GH=_GF.length;_GG<_GH;_GG++){var _GJ=$k[--$j];$k[$j++]=$or(_GJ,$g(_GF,_GG))<<6}var _GL=$k[--$j]>>>6;$k[$j++]=_GL>>>16&255;$k[$j++]=_GL>>>8&255;$k[$j++]=_GL&255}$as($a($m()));var _GO=$k[--$j];$k[$j-1]=_GO;var _GS=$G($k[--$j],0,$_.outlen);$k[$j++]=_GS};$_.encE=function(){$_.p=0;$_.edifactvals=$a(2100);for(;;){if($_.i==$_.msglen){break}var _Ga=$g($_.Evals,$g($_.msg,$_.i))!==undefined;if(!_Ga){break}if($_.p%4==0){if($_.msglen-$_.i<=2){$_.remcws=$g($_.numremcws,$_.j+~~($_.p/4)*3);$k[$j++]=Infinity;var _Gm=$G($_.msg,$_.i,$_.msglen-$_.i);for(var _Gn=0,_Go=_Gm.length;_Gn<_Go;_Gn++){$q($g($_.Avals,$g(_Gm,_Gn)))}$_.remvals=$a();if(($_.remcws==1||$_.remcws==2)&&$_.remvals.length<=$_.remcws){$k[$j++]=$G($_.edifactvals,0,$_.p);$_.Evalstocws();$_.addtocws();$k[$j++]=$_.remvals;$_.addtocws();$_.mode=$_.A;$_.i=$_.msglen;break}}$_.lookup();if($k[--$j]!=$_.mode){break}}var _H9=$g($_.Evals,$g($_.msg,$_.i));$P($_.edifactvals,$_.p,_H9);$_.p=_H9.length+$_.p;$_.i=$_.i+1}if($_.mode!=$_.A){$_.remcws=$g($_.numremcws,$_.j+~~($_.p/4)*3-1)-1;if($_.p%4!=0||$_.i!=$_.msglen||$_.remcws>=3){var _HQ=$g($_.Evals,$_.unl);$P($_.edifactvals,$_.p,_HQ);$_.p=_HQ.length+$_.p}$k[$j++]=$G($_.edifactvals,0,$_.p);$_.Evalstocws();$_.addtocws();$_.mode=$_.A;if($_.i!=$_.msglen&&!$g($_.isECI,$_.i)){if($g($_.numD,$_.i)>=2){var _Hg=$s(2);$p(_Hg,0,$g($_.msg,$_.i));$p(_Hg,1,$g($_.msg,$_.i+1));$k[$j++]=$g($_.Avals,_Hg);$_.addtocws();$_.i=$_.i+2}else{$k[$j++]=$g($_.Avals,$g($_.msg,$_.i));$_.addtocws();$_.i=$_.i+1}}}};$_.encB=function(){$_.p=0;$_.bvals=$a(1558);for(;;){if($_.i==$_.msglen){break}$_.lookup();if($k[--$j]!=$_.mode){break}$p($_.bvals,$_.p,$g($_.msg,$_.i));$_.p=$_.p+1;$_.i=$_.i+1}$_.remcws=$g($_.numremcws,$_.j+$_.p)-1;$k[$j++]=Infinity;if($_.remcws==0&&$_.i==$_.msglen){$k[$j++]=0}else{if($_.p<250){$k[$j++]=$_.p}else{$k[$j++]=~~($_.p/250)+249;$k[$j++]=$_.p%250}}$q($G($_.bvals,0,$_.p));$_.bvals=$a();for(var _IP=0,_IO=$_.bvals.length-1;_IP<=_IO;_IP+=1){$_.p=_IP;var _IV=$f(($_.j+$_.p+1)*149%255+1+$g($_.bvals,$_.p));$k[$j++]=_IV;if(_IV>=256){var _IW=$k[--$j];$k[$j++]=_IW-256}$p($_.bvals,$_.p,$k[--$j])}$k[$j++]=$_.bvals;$_.addtocws();$_.mode=$_.A};$_.cws=$a(1558);$_.mode=$_.A;$_.i=0;$_.j=0;for(;;){if($_.i>=$_.msglen){break}if($_[$g($a(["encA","encCTX","encCTX","encCTX","encE","encB"]),$_.mode)]()===true){break}}$_.cws=$G($_.cws,0,$_.j)}$_.datlen=$_.cws.length;$_.remcws=$g($_.numremcws,$_.j-1)-1;if($_.remcws>0){$k[$j++]=Infinity;$q($_.cws);for(var _Iu=0,_Iv=$_.remcws;_Iu<_Iv;_Iu++){$k[$j++]=129}$_.cws=$a();for(var _J1=$_.datlen+1,_J0=$f($_.datlen+$_.remcws)-1;_J1<=_J0;_J1+=1){$_.i=_J1;var _J3=($_.i+1)*149%253+1+129;$k[$j++]=_J3;if(_J3>254){var _J4=$k[--$j];$k[$j++]=_J4-254}$p($_.cws,$_.i,$k[--$j])}}var _J9=$g($_.options,"debugcws")!==undefined;if(_J9){$k[$j++]="bwipp.debugcws#20411";$k[$j++]=$_.cws;bwipp_raiseerror()}var _JB=$_.metrics;for(var _JC=0,_JD=_JB.length;_JC<_JD;_JC++){$_.m=$g(_JB,_JC);$_.rows=$g($_.m,0);$_.cols=$g($_.m,1);$_.regh=$g($_.m,2);$_.regv=$g($_.m,3);$_.rscw=$g($_.m,4);$_.rsbl=$g($_.m,5);$_.doly=$g($_.m,6);$_.mrows=$f($_.rows-2*$_.regh);$_.mcols=$f($_.cols-2*$_.regv);$_.rrows=~~($_.mrows/$_.regh);$_.rcols=~~($_.mcols/$_.regv);$_.ncws=$f(~~($_.mrows*$_.mcols/8)-$_.rscw);$_.okay=true;if($_.cws.length!=$_.ncws){$_.okay=false}if($_.urows!=0&&$_.urows!=$_.rows){$_.okay=false}if($_.ucols!=0&&$_.ucols!=$_.cols){$_.okay=false}if($eq($_.format,"square")&&$ne($_.rows,$_.cols)){$_.okay=false}if($eq($_.format,"rectangle")&&$eq($_.rows,$_.cols)){$_.okay=false}if(!$_.dmre&&$_.doly==1){$_.okay=false}if($_.okay){break}}if(!$_.okay){$k[$j++]="bwipp.datamatrixNoValidSymbol#20439";$k[$j++]="Maximum length exceeded or invalid size";bwipp_raiseerror()}$_.cwbs=$a($_.rsbl);$_.ecbs=$a($_.rsbl);for(var _K2=0,_K1=$_.rsbl-1;_K2<=_K1;_K2+=1){$_.i=_K2;if($_.cws.length!=1558){$_.cwbsize=~~($_.cws.length/$_.rsbl)}else{if($_.i<=7){$_.cwbsize=156}else{$_.cwbsize=155}}$_.cwb=$a($_.cwbsize);for(var _KB=0,_KA=$_.cwbsize-1;_KB<=_KA;_KB+=1){$_.j=_KB;$p($_.cwb,$_.j,$g($_.cws,$f($_.j*$_.rsbl+$_.i)))}$p($_.cwbs,$_.i,$_.cwb);$k[$j++]=$_.ecbs;$k[$j++]=$_.i;$k[$j++]=Infinity;for(var _KQ=0,_KR=~~($_.rscw/$_.rsbl);_KQ<_KR;_KQ++){$k[$j++]=0}var _KS=$a();var _KT=$k[--$j];$p($k[--$j],_KT,_KS)}$k[$j++]=Infinity;$k[$j++]=1;for(var _KV=0;_KV<255;_KV++){var _KW=$k[$j-1];var _KX=_KW*2;$k[$j++]=_KX;if(_KX>=256){var _KY=$k[--$j];$k[$j++]=_KY^301}}$_.rsalog=$a();$_.rslog=$a(256);for(var _Kb=1;_Kb<=255;_Kb+=1){$p($_.rslog,$g($_.rsalog,_Kb),_Kb)}$_.rsprod=function(){var _Kg=$k[$j-1];var _Kh=$k[$j-2];if(_Kg!=0&&_Kh!=0){var _Kk=$g($_.rslog,$k[--$j]);var _Kp=$g($_.rsalog,$f(_Kk+$g($_.rslog,$k[--$j]))%255);$k[$j++]=_Kp}else{$j-=2;$k[$j++]=0}};$k[$j++]=Infinity;$k[$j++]=1;for(var _Ks=0,_Kt=~~($_.rscw/$_.rsbl);_Ks<_Kt;_Ks++){$k[$j++]=0}$_.coeffs=$a();for(var _Ky=1,_Kx=~~($_.rscw/$_.rsbl);_Ky<=_Kx;_Ky+=1){$_.i=_Ky;$p($_.coeffs,$_.i,$g($_.coeffs,$_.i-1));for(var _L5=$_.i-1;_L5>=1;_L5-=1){$_.j=_L5;$k[$j++]=$_.coeffs;$k[$j++]=$_.j;$k[$j++]=$g($_.coeffs,$_.j-1);$k[$j++]=$g($_.coeffs,$_.j);$k[$j++]=$g($_.rsalog,$_.i);$_.rsprod();var _LH=$k[--$j];var _LI=$k[--$j];var _LJ=$k[--$j];$p($k[--$j],_LJ,$xo(_LI,_LH))}$k[$j++]=$_.coeffs;$k[$j++]=0;$k[$j++]=$g($_.coeffs,0);$k[$j++]=$g($_.rsalog,$_.i);$_.rsprod();var _LR=$k[--$j];var _LS=$k[--$j];$p($k[--$j],_LS,_LR)}$_.coeffs=$G($_.coeffs,0,$_.coeffs.length-1);for(var _LZ=0,_LY=$_.cwbs.length-1;_LZ<=_LY;_LZ+=1){$_.i=_LZ;$_.cwb=$g($_.cwbs,$_.i);$_.ecb=$g($_.ecbs,$_.i);for(var _Li=0,_Lh=$_.cwb.length-1;_Li<=_Lh;_Li+=1){$_.t=$xo($g($_.cwb,_Li),$g($_.ecb,0));for(var _Lo=$_.ecb.length-1;_Lo>=0;_Lo-=1){$_.j=_Lo;$_.p=$_.ecb.length-$_.j-1;$k[$j++]=$_.ecb;$k[$j++]=$_.p;$k[$j++]=$_.t;$k[$j++]=$g($_.coeffs,$_.j);$_.rsprod();var _Lx=$k[--$j];var _Ly=$k[--$j];$p($k[--$j],_Ly,_Lx);if($_.j>0){$p($_.ecb,$_.p,$xo($g($_.ecb,$_.p+1),$g($_.ecb,$_.p)))}}}}if($_.ncws==1558){$k[$j++]=Infinity;$q($G($_.ecbs,8,2));$q($G($_.ecbs,0,8));$_.ecbs=$a()}$k[$j++]=Infinity;$q($_.cws);for(var _MH=0,_MI=$_.rscw;_MH<_MI;_MH++){$k[$j++]=0}$_.cws=$a();for(var _MM=0,_ML=$_.rscw-1;_MM<=_ML;_MM+=1){$_.i=_MM;$p($_.cws,$f($_.ncws+$_.i),$g($g($_.ecbs,$_.i%$_.rsbl),~~($_.i/$_.rsbl)))}$_.module=function(){$r(4,-1);var _MY=$Z($s(8),"00000000");$k[$j++]=_MY;$k[$j++]=_MY;var _Mb=$R($s(8),$k[$j-3],2);$P($k[$j-1],8-_Mb.length,_Mb);$k[$j-3]=$k[$j-2];$j-=2;for(var _Md=7;_Md>=0;_Md-=1){var _Me=$k[--$j];$k[$j++]=$g(_Me,_Md)-48;$k[$j++]=_Me}$j--;$r(11,-3);$F($k[--$j],function(){if($k[--$j]()===true){return true}var _Mj=$k[$j-2];if(_Mj<0){var _Mk=$k[--$j];var _Ml=$k[--$j];$k[$j++]=$f(_Ml+$_.mrows);$k[$j++]=$f(_Mk+(4-($_.mrows+4)%8))}var _Mo=$k[$j-1];if(_Mo<0){var _Mq=$k[--$j];var _Mr=$k[--$j];$k[$j++]=$f(_Mr+(4-($_.mcols+4)%8));$k[$j++]=$f(_Mq+$_.mcols)}var _Mu=$k[$j-2];if(_Mu>=$_.mrows){var _Mw=$k[--$j];var _Mx=$k[--$j];$k[$j++]=$f(_Mx-$_.mrows);$k[$j++]=_Mw}var _Mz=$k[--$j];var _N0=$k[--$j];$k[$j++]=$_.mmat;$k[$j++]=$f(_Mz+_N0*$_.mcols);$r(5,-1);var _N3=$k[--$j];var _N4=$k[--$j];$p($k[--$j],_N4,_N3)})};var _NM=$a([function(){var _N6=$k[$j-1];var _N7=$k[$j-2];$k[$j++]=_N7-2;$k[$j++]=_N6-2},function(){var _N8=$k[$j-1];var _N9=$k[$j-2];$k[$j++]=_N9-2;$k[$j++]=_N8-1},function(){var _NA=$k[$j-1];var _NB=$k[$j-2];$k[$j++]=_NB-1;$k[$j++]=_NA-2},function(){var _NC=$k[$j-1];var _ND=$k[$j-2];$k[$j++]=_ND-1;$k[$j++]=_NC-1},function(){var _NE=$k[$j-1];var _NF=$k[$j-2];$k[$j++]=_NF-1;$k[$j++]=_NE},function(){var _NG=$k[$j-1];var _NH=$k[$j-2];$k[$j++]=_NH;$k[$j++]=_NG-2},function(){var _NI=$k[$j-1];var _NJ=$k[$j-2];$k[$j++]=_NJ;$k[$j++]=_NI-1},function(){var _NK=$k[$j-1];var _NL=$k[$j-2];$k[$j++]=_NL;$k[$j++]=_NK}]);$_.dmn=_NM;var _NV=$a([function(){$k[$j++]=$_.mrows-1;$k[$j++]=0},function(){$k[$j++]=$_.mrows-1;$k[$j++]=1},function(){$k[$j++]=$_.mrows-1;$k[$j++]=2},function(){$k[$j++]=0;$k[$j++]=$_.mcols-2},function(){$k[$j++]=0;$k[$j++]=$_.mcols-1},function(){$k[$j++]=1;$k[$j++]=$_.mcols-1},function(){$k[$j++]=2;$k[$j++]=$_.mcols-1},function(){$k[$j++]=3;$k[$j++]=$_.mcols-1}]);$_.dmc1=_NV;var _Ne=$a([function(){$k[$j++]=$_.mrows-3;$k[$j++]=0},function(){$k[$j++]=$_.mrows-2;$k[$j++]=0},function(){$k[$j++]=$_.mrows-1;$k[$j++]=0},function(){$k[$j++]=0;$k[$j++]=$_.mcols-4},function(){$k[$j++]=0;$k[$j++]=$_.mcols-3},function(){$k[$j++]=0;$k[$j++]=$_.mcols-2},function(){$k[$j++]=0;$k[$j++]=$_.mcols-1},function(){$k[$j++]=1;$k[$j++]=$_.mcols-1}]);$_.dmc2=_Ne;var _Nn=$a([function(){$k[$j++]=$_.mrows-3;$k[$j++]=0},function(){$k[$j++]=$_.mrows-2;$k[$j++]=0},function(){$k[$j++]=$_.mrows-1;$k[$j++]=0},function(){$k[$j++]=0;$k[$j++]=$_.mcols-2},function(){$k[$j++]=0;$k[$j++]=$_.mcols-1},function(){$k[$j++]=1;$k[$j++]=$_.mcols-1},function(){$k[$j++]=2;$k[$j++]=$_.mcols-1},function(){$k[$j++]=3;$k[$j++]=$_.mcols-1}]);$_.dmc3=_Nn;var _Nx=$a([function(){$k[$j++]=$_.mrows-1;$k[$j++]=0},function(){$k[$j++]=$_.mrows-1;$k[$j++]=$_.mcols-1},function(){$k[$j++]=0;$k[$j++]=$_.mcols-3},function(){$k[$j++]=0;$k[$j++]=$_.mcols-2},function(){$k[$j++]=0;$k[$j++]=$_.mcols-1},function(){$k[$j++]=1;$k[$j++]=$_.mcols-3},function(){$k[$j++]=1;$k[$j++]=$_.mcols-2},function(){$k[$j++]=1;$k[$j++]=$_.mcols-1}]);$_.dmc4=_Nx;$k[$j++]=Infinity;for(var _O0=0,_O1=$_.mrows*$_.mcols;_O0<_O1;_O0++){$k[$j++]=-1}$_.mmat=$a();for(var _O4=$_.cws.length-1;_O4>=0;_O4-=1){$k[$j++]=$g($_.cws,_O4)}$k[$j++]=4;$k[$j++]=0;for(;;){var _O7=$k[$j-1];var _O8=$k[$j-2];if(_O7==0&&_O8==$_.mrows){$k[$j++]=$_.dmc1;$_.module()}var _OB=$k[$j-1];var _OC=$k[$j-2];if(_OB==0&&_OC==$_.mrows-2&&$_.mcols%4!=0){$k[$j++]=$_.dmc2;$_.module()}var _OG=$k[$j-1];var _OH=$k[$j-2];if(_OG==0&&_OH==$_.mrows-2&&$_.mcols%8==4){$k[$j++]=$_.dmc3;$_.module()}var _OL=$k[$j-1];var _OM=$k[$j-2];if(_OL==2&&_OM==$_.mrows+4&&$_.mcols%8==0){$k[$j++]=$_.dmc4;$_.module()}for(;;){var _OQ=$k[$j-1];var _OR=$k[$j-2];if(_OQ>=0&&_OR<$_.mrows){var _OT=$k[$j-1];var _OU=$k[$j-2];if($g($_.mmat,$f(_OT+_OU*$_.mcols))==-1){$k[$j++]=$_.dmn;$_.module()}}var _OZ=$k[--$j];var _Oa=$k[--$j];$k[$j++]=_Oa-2;$k[$j++]=_OZ+2;if(!(_OZ+2<$_.mcols&&_Oa-2>=0)){break}}var _Oc=$k[--$j];var _Od=$k[--$j];$k[$j++]=_Od+1;$k[$j++]=_Oc+3;for(;;){var _Oe=$k[$j-1];var _Of=$k[$j-2];if(_Oe<$_.mcols&&_Of>=0){var _Oh=$k[$j-1];var _Oi=$k[$j-2];if($g($_.mmat,$f(_Oh+_Oi*$_.mcols))==-1){$k[$j++]=$_.dmn;$_.module()}}var _On=$k[--$j];var _Oo=$k[--$j];$k[$j++]=_Oo+2;$k[$j++]=_On-2;if(!(_On-2>=0&&_Oo+2<$_.mrows)){break}}var _Oq=$k[--$j];var _Or=$k[--$j];$k[$j++]=_Or+3;$k[$j++]=_Oq+1;if(!(_Oq+1<$_.mcols||_Or+3<$_.mrows)){$j-=2;break}}if($g($_.mmat,$_.mrows*$_.mcols-1)==-1){$P($_.mmat,$_.mrows*($_.mcols-1)-2,$a([1,0]));$P($_.mmat,$_.mrows*$_.mcols-2,$a([0,1]))}$_.pixs=$a($_.rows*$_.cols);$_.cwpos=0;for(var _PB=0,_PA=$_.rows-1;_PB<=_PA;_PB+=1){$_.i=_PB;if($_.i%($_.rrows+2)==0){$k[$j++]=$_.pixs;$k[$j++]=$_.i*$_.cols;$k[$j++]=Infinity;for(var _PI=0,_PJ=~~($_.cols/2);_PI<_PJ;_PI++){$k[$j++]=1;$k[$j++]=0}var _PK=$a();var _PL=$k[--$j];$P($k[--$j],_PL,_PK)}if($_.i%($_.rrows+2)==$_.rrows+1){$k[$j++]=$_.pixs;$k[$j++]=$_.i*$_.cols;$k[$j++]=Infinity;for(var _PU=0,_PV=$_.cols;_PU<_PV;_PU++){$k[$j++]=1}var _PW=$a();var _PX=$k[--$j];$P($k[--$j],_PX,_PW)}if($_.i%($_.rrows+2)!=0&&$_.i%($_.rrows+2)!=$_.rrows+1){for(var _Pg=0,_Pf=$_.cols-1;_Pg<=_Pf;_Pg+=1){$_.j=_Pg;if($_.j%($_.rcols+2)==0){$p($_.pixs,$f($_.i*$_.cols+$_.j),1)}if($_.j%($_.rcols+2)==$_.rcols+1){$p($_.pixs,$f($_.i*$_.cols+$_.j),$_.i%2)}if($_.j%($_.rcols+2)!=0&&$_.j%($_.rcols+2)!=$_.rcols+1){$p($_.pixs,$f($_.i*$_.cols+$_.j),$g($_.mmat,$_.cwpos));$_.cwpos=$_.cwpos+1}}}}var _QE=new Map([["ren","renmatrix"],["pixs",$_.pixs],["pixx",$_.cols],["pixy",$_.rows],["height",$_.rows*2/72],["width",$_.cols*2/72],["borderleft",1],["borderright",1],["bordertop",1],["borderbottom",1],["opt",$_.options]]);$k[$j++]=_QE;if(!$_.dontdraw){bwipp_renmatrix()}$_=$__}function bwipp_datamatrixrectangular(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];$p($_.options,"dontdraw",true);$p($_.options,"format","rectangle");$k[$j++]="args";$k[$j++]=$_.barcode;$k[$j++]=$_.options;bwipp_datamatrix();var _6=$k[--$j];$_[$k[--$j]]=_6;$p($_.args,"opt",$_.options);$k[$j++]=$_.args;if(!$_.dontdraw){bwipp_renmatrix()}$_=$__}function bwipp_datamatrixrectangularextension(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];$p($_.options,"dontdraw",true);$p($_.options,"dmre",true);$k[$j++]="args";$k[$j++]=$_.barcode;$k[$j++]=$_.options;bwipp_datamatrix();var _6=$k[--$j];$_[$k[--$j]]=_6;$p($_.args,"opt",$_.options);$k[$j++]=$_.args;if(!$_.dontdraw){bwipp_renmatrix()}$_=$__}function bwipp_mailmark(){var $__=$_;$_=Object.assign({},$_);$_.type="unset";$_.parse=false;$_.dontdraw=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];var _3=new Map([["parse",$_.parse],["parseonly",true],["parsefnc",false]]);$_.fncvals=_3;$k[$j++]="barcode";$k[$j++]=$_.barcode;$k[$j++]=$_.fncvals;bwipp_parseinput();var _6=$k[--$j];$_[$k[--$j]]=_6;$_.barlen=$_.barcode.length;delete $_.options["parse"];var _A=$_["type"];if($ne(_A,"7")&&($ne(_A,"9")&&$ne(_A,"29"))){$k[$j++]="bwipp.mailmarkBadType#20820";$k[$j++]="Royal Mail Mailmark type must be 7, 9 or 29";bwipp_raiseerror()}var _B=new Map([["7","24x24"],["9","32x32"],["29","16x48"]]);$_.version=$g(_B,$_["type"]);var _E=new Map([["7","square"],["9","square"],["29","rectangle"]]);$_.format=$g(_E,$_["type"]);if($_.barcode.length<45){$k[$j++]="bwipp.mailmarkBadLength#20836";$k[$j++]="Royal Mail Mailmark must contain at least 45 characters of Mailmark formatted data, including any required space padding";bwipp_raiseerror()}if($ne($G($_.barcode,0,4),"JGB ")){$k[$j++]="bwipp.mailmarkBadIndicator#20839";$k[$j++]="Royal Mail Mailmark must begin with JGB<space> identifier";bwipp_raiseerror()}$p($_.options,"dontdraw",true);$p($_.options,"version",$_.version);$p($_.options,"format",$_.format);$p($_.options,"c40headerlength",45);$k[$j++]="args";$k[$j++]=$_.barcode;$k[$j++]=$_.options;bwipp_datamatrix();var _S=$k[--$j];$_[$k[--$j]]=_S;$p($_.args,"opt",$_.options);$k[$j++]=$_.args;if(!$_.dontdraw){bwipp_renmatrix()}$_=$__}function bwipp_qrcode(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.format="unset";$_.version="unset";$_.eclevel="unset";$_.fixedeclevel=false;$_.parse=false;$_.parsefnc=false;$_.mask=-1;$_.suppresskanjimode=true;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.barcode.length==0){$k[$j++]="bwipp.qrcodeEmptyData#20904";$k[$j++]="The data must not be empty";bwipp_raiseerror()}if($ne($_.version,"unset")){if($eq($_.format,"unset")){$k[$j++]="full";if($eq($G($_.version,0,1),"M")){$k[$j-1]="micro"}if($eq($G($_.version,0,1),"R")){$k[$j-1]="rmqr"}$_.format=$k[--$j]}}else{if($eq($_.format,"unset")){$_.format="full"}}if($ne($_.format,"full")&&($ne($_.format,"micro")&&$ne($_.format,"rmqr"))){$k[$j++]="bwipp.qrcodeInvalidFormat#20920";$k[$j++]="The format must be either full, micro or rmqr";bwipp_raiseerror()}if($eq($_.format,"rmqr")&&$eq($_.version,"unset")){$k[$j++]="bwipp.qrcodeRMQRwithoutVersion#20924";$k[$j++]="A version must be provided for RMQR";bwipp_raiseerror()}if($eq($_.eclevel,"unset")){$k[$j++]="eclevel";if($ne($_.format,"micro")){$k[$j++]="M"}else{$k[$j++]="L"}var _I=$k[--$j];$_[$k[--$j]]=_I}if($ne($_.eclevel,"L")&&($ne($_.eclevel,"M")&&($ne($_.eclevel,"Q")&&$ne($_.eclevel,"H")))){$k[$j++]="bwipp.qrcodeInvalidEClevel#20931";$k[$j++]="Error correction level must be either L, M, Q, or H";bwipp_raiseerror()}if($_.mask!=-1&&$eq($_.format,"rmqr")){$k[$j++]="bwipp.qrcodeRMQRmask#20935";$k[$j++]="A mask cannot be supplied for RMQR";bwipp_raiseerror()}if($_.mask!=-1){var _U=$eq($_.format,"full")?8:4;if($_.mask<1||$_.mask>_U){$k[$j++]="bwipp.qrcodeBadMask#20940";$k[$j++]="An invalid mask was supplied";bwipp_raiseerror()}}$_.fn1=-1;var _Y=new Map([["parse",$_.parse],["parsefnc",$_.parsefnc],["eci",true],["FNC1",$_.fn1]]);$_.fncvals=_Y;$k[$j++]="msg";$k[$j++]=$_.barcode;$k[$j++]=$_.fncvals;bwipp_parseinput();var _b=$k[--$j];$_[$k[--$j]]=_b;$_.msglen=$_.msg.length;$_.fnc1first=false;if($_.msglen>0){if($g($_.msg,0)==$_.fn1){$_.fnc1first=true;$k[$j++]=Infinity;var _k=$G($_.msg,1,$_.msglen-1);for(var _l=0,_m=_k.length;_l<_m;_l++){var _n=$g(_k,_l);$k[$j++]=_n;if(_n==37){var _o=$k[$j-1];$k[$j++]=_o}}$_.msg=$a();$_.msglen=$_.msg.length}}var _r=$a(["v1to9","v10to26","v27to40","vM1","vM2","vM3","vM4","vR7x43","vR7x59","vR7x77","vR7x99","vR7x139","vR9x43","vR9x59","vR9x77","vR9x99","vR9x139","vR11x27","vR11x43","vR11x59","vR11x77","vR11x99","vR11x139","vR13x27","vR13x43","vR13x59","vR13x77","vR13x99","vR13x139","vR15x43","vR15x59","vR15x77","vR15x99","vR15x139","vR17x43","vR17x59","vR17x77","vR17x99","vR17x139"]);$k[$j++]=0;for(var _s=0,_t=_r.length;_s<_t;_s++){var _v=$k[--$j];$_[$g(_r,_s)]=_v;$k[$j++]=_v+1}$j--;$_.N=0;$_.A=1;$_.B=2;$_.K=3;$_.E=4;$k[$j++]=Infinity;$k[$j++]=Infinity;for(var _w=48;_w<=57;_w+=1){$k[$j++]=_w}var _x=$a();for(var _y=0,_z=_x.length;_y<_z;_y++){$k[$j++]=$g(_x,_y);$k[$j++]=-1}$_.Nexcl=$d();$k[$j++]=Infinity;$k[$j++]=Infinity;$k[$j++]=32;$k[$j++]=36;$k[$j++]=37;$k[$j++]=42;$k[$j++]=43;$k[$j++]=45;$k[$j++]=46;$k[$j++]=47;$k[$j++]=58;for(var _12=65;_12<=90;_12+=1){$k[$j++]=_12}$k[$j++]=$_.fn1;var _14=$a();for(var _15=0,_16=_14.length;_15<_16;_15++){$k[$j++]=$g(_14,_15);$k[$j++]=-1}$_.Aexcl=$d();$k[$j++]=Infinity;$k[$j++]=Infinity;for(var _19=129;_19<=159;_19+=1){$k[$j++]=_19}for(var _1A=224;_1A<=235;_1A+=1){$k[$j++]=_1A}var _1B=$a();for(var _1C=0,_1D=_1B.length;_1C<_1D;_1C++){$k[$j++]=$g(_1B,_1C);$k[$j++]=-1}$_.Kexcl=$d();$k[$j++]=Infinity;$k[$j++]=$a(["0001","0010","0100","1000","0111"]);$k[$j++]=$a(["0001","0010","0100","1000","0111"]);$k[$j++]=$a(["0001","0010","0100","1000","0111"]);$k[$j++]=$a(["",-1,-1,-1,-1]);$k[$j++]=$a(["0","1",-1,-1,-1]);$k[$j++]=$a(["00","01","10","11",-1]);$k[$j++]=$a(["000","001","010","011",-1]);for(var _1N=0;_1N<32;_1N++){$k[$j++]=$a(["001","010","011","100","111"])}$_.mids=$a();$_.cclens=$a([$a([10,9,8,8]),$a([12,11,16,10]),$a([14,13,16,12]),$a([3,-1,-1,-1]),$a([4,3,-1,-1]),$a([5,4,4,3]),$a([6,5,5,4]),$a([4,3,3,2]),$a([5,5,4,3]),$a([6,5,5,4]),$a([7,6,5,5]),$a([7,6,6,5]),$a([5,5,4,3]),$a([6,5,5,4]),$a([7,6,5,5]),$a([7,6,6,5]),$a([8,7,6,6]),$a([4,4,3,2]),$a([6,5,5,4]),$a([7,6,5,5]),$a([7,6,6,5]),$a([8,7,6,6]),$a([8,7,7,6]),$a([5,5,4,3]),$a([6,6,5,5]),$a([7,6,6,5]),$a([7,7,6,6]),$a([8,7,7,6]),$a([8,8,7,7]),$a([7,6,6,5]),$a([7,7,6,5]),$a([8,7,7,6]),$a([8,7,7,6]),$a([9,8,7,7]),$a([7,6,6,5]),$a([8,7,6,6]),$a([8,7,7,6]),$a([8,8,7,6]),$a([9,8,8,7])]);$k[$j++]=Infinity;for(var _24=0;_24<3;_24++){$k[$j++]=4}$k[$j++]=3;$k[$j++]=5;$k[$j++]=7;$k[$j++]=9;for(var _25=0;_25<32;_25++){$k[$j++]=3}$_.termlens=$a();$_.padstrs=$a(["11101100","00010001"]);$_.charmap="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ $%*+-./:";$_.charvals=new Map;for(var _28=0;_28<=44;_28+=1){$p($_.charvals,$g($_.charmap,_28),_28)}$_.tobin=function(){var _2E=$s($k[--$j]);$k[$j++]=_2E;for(var _2G=0,_2F=_2E.length-1;_2G<=_2F;_2G+=1){var _2H=$k[$j-1];$p(_2H,_2G,48)}var _2I=$k[$j-1];$k[$j++]=_2I;var _2J=$k[$j-3];var _2K=$k[$j-1];$k[$j-3]=$k[$j-2];$j-=2;var _2M=$R($s(_2K.length),_2J,2);$P(_2K,_2K.length-_2M.length,_2M)};$_.encA=function(){$_.in=$k[--$j];if($_.fnc1first){$k[$j++]=Infinity;$F($_.in,function(){var _2Q=$k[$j-1];if(_2Q==$_.fn1){$k[$j-1]=37}});$_.in=$a()}$_.out=$s(~~($_.in.length*11/2)+1);$_.k=0;$_.m=0;for(;;){if($_.k==$_.in.length){break}if($_.k<$_.in.length-1){$k[$j++]=$f($g($_.charvals,$g($_.in,$_.k))*45+$g($_.charvals,$g($_.in,$_.k+1)));$k[$j++]=11;$_.tobin();$_.k=$_.k+2}else{$k[$j++]=$g($_.charvals,$g($_.in,$_.k));$k[$j++]=6;$_.tobin();$_.k=$_.k+1}var _2q=$k[--$j];$P($_.out,$_.m,_2q);$_.m=_2q.length+$_.m}$k[$j++]=$G($_.out,0,$_.m)};$_.encN=function(){$_.in=$k[--$j];$_.out=$s(~~($_.in.length*10/3)+1);$_.k=0;$_.m=0;for(;;){if($_.k==$_.in.length){break}if($_.k<$_.in.length-2){var _36=$G($_.in,$_.k,3);$k[$j++]=0;for(var _37=0,_38=_36.length;_37<_38;_37++){var _3A=$k[--$j];$k[$j++]=$f($g(_36,_37)+(_3A*10-48))}$k[$j++]=10;$_.tobin();$_.k=$_.k+3}else{if($_.k==$_.in.length-2){var _3G=$G($_.in,$_.k,2);$k[$j++]=0;for(var _3H=0,_3I=_3G.length;_3H<_3I;_3H++){var _3K=$k[--$j];$k[$j++]=$f($g(_3G,_3H)+(_3K*10-48))}$k[$j++]=7;$_.tobin();$_.k=$_.k+2}else{var _3O=$G($_.in,$_.k,1);$k[$j++]=0;for(var _3P=0,_3Q=_3O.length;_3P<_3Q;_3P++){var _3S=$k[--$j];$k[$j++]=$f($g(_3O,_3P)+(_3S*10-48))}$k[$j++]=4;$_.tobin();$_.k=$_.k+1}}var _3U=$k[--$j];$P($_.out,$_.m,_3U);$_.m=_3U.length+$_.m}$k[$j++]=$G($_.out,0,$_.m)};$_.encB=function(){$_.in=$k[--$j];if($_.fnc1first){$k[$j++]=Infinity;$F($_.in,function(){var _3e=$k[$j-1];if(_3e==$_.fn1){$k[$j-1]=29}});$_.in=$a()}$_.out=$s($_.in.length*8);for(var _3l=0,_3k=$_.in.length-1;_3l<=_3k;_3l+=1){$_.k=_3l;$k[$j++]=$i($g($_.in,$_.k));$k[$j++]=8;$_.tobin();$k[$j++]=$_.out;$k[$j++]=$_.k*8;var _3r=$k[$j-3];var _3s=$k[$j-1];$P($k[$j-2],_3s,_3r);$j-=3}$k[$j++]=$_.out};$_.encK=function(){$_.in=$k[--$j];$_.out=$s(~~($_.in.length/2)*13);$_.k=0;$_.m=0;for(;;){if($_.k==$_.in.length){break}var _46=$f($g($_.in,$_.k)*256+$g($_.in,$_.k+1));$k[$j++]=_46;if(_46<57408){$k[$j++]=33088}else{$k[$j++]=49472}var _47=$k[--$j];var _49=$f($k[--$j]-_47);$k[$j++]=$f((_49>>>8)*192+(_49&255));$k[$j++]=13;$_.tobin();var _4A=$k[--$j];$P($_.out,$_.m,_4A);$_.m=_4A.length+$_.m;$_.k=$_.k+2}$k[$j++]=$_.out};$_.encE=function(){var _4I=-$g($k[--$j],0)-1e6;$k[$j++]=_4I;if(_4I<=127){$k[$j++]=8;$_.tobin()}else{var _4J=$k[$j-1];if(_4J<=16383){var _4K=$k[--$j];$k[$j++]=_4K+32768;$k[$j++]=16;$_.tobin()}else{var _4L=$k[--$j];$k[$j++]=_4L+12582912;$k[$j++]=24;$_.tobin()}}};$_.encfuncs=$a(["encN","encA","encB","encK","encE"]);$_.addtobits=function(){var _4N=$k[--$j];$P($_.bits,$_.j,_4N);$_.j=_4N.length+$_.j};$k[$j++]=Infinity;for(var _4S=0,_4T=$_.msglen;_4S<_4T;_4S++){$k[$j++]=0}$k[$j++]=0;$_.numNs=$a();$k[$j++]=Infinity;for(var _4W=0,_4X=$_.msglen;_4W<_4X;_4W++){$k[$j++]=0}$k[$j++]=0;$_.numAs=$a();$k[$j++]=Infinity;for(var _4a=0,_4b=$_.msglen;_4a<_4b;_4a++){$k[$j++]=0}$k[$j++]=0;$_.numAorNs=$a();$k[$j++]=Infinity;for(var _4e=0,_4f=$_.msglen;_4e<_4f;_4e++){$k[$j++]=0}$k[$j++]=0;$_.numBs=$a();$k[$j++]=Infinity;for(var _4i=0,_4j=$_.msglen;_4i<_4j;_4i++){$k[$j++]=0}$k[$j++]=0;$_.numKs=$a();$k[$j++]=Infinity;for(var _4m=0,_4n=$_.msglen;_4m<_4n;_4m++){$k[$j++]=0}$k[$j++]=9999;$_.nextNs=$a();$k[$j++]=Infinity;for(var _4q=0,_4r=$_.msglen;_4q<_4r;_4q++){$k[$j++]=0}$k[$j++]=9999;$_.nextBs=$a();$k[$j++]=Infinity;for(var _4u=0,_4v=$_.msglen;_4u<_4v;_4u++){$k[$j++]=0}$k[$j++]=9999;$_.nextAs=$a();$k[$j++]=Infinity;for(var _4y=0,_4z=$_.msglen;_4y<_4z;_4y++){$k[$j++]=0}$k[$j++]=9999;$_.nextKs=$a();$_.isECI=$a($_.msglen);for(var _54=$_.msglen-1;_54>=0;_54-=1){$_.i=_54;$_.barchar=$g($_.msg,$_.i);var _5A=$g($_.Kexcl,$_.barchar)!==undefined;if(_5A&&!$_.suppresskanjimode){if($_.i+1<$_.msglen){$k[$j++]=$f($_.barchar*256+$g($_.msg,$_.i+1))}else{$k[$j++]=0}var _5I=$k[--$j];var _5J=_5I&255;if((_5I>=33088&&_5I<=40956||_5I>=57408&&_5I<=60351)&&(_5J>=64&&_5J<=252&&_5J!=127)){$p($_.nextKs,$_.i,0);$p($_.numKs,$_.i,$g($_.numKs,$_.i+2)+1)}else{$p($_.nextKs,$_.i,$g($_.nextKs,$_.i+1)+1)}}else{$p($_.nextKs,$_.i,$g($_.nextKs,$_.i+1)+1)}var _5d=$g($_.Nexcl,$_.barchar)!==undefined;if(_5d){$p($_.nextNs,$_.i,0);$p($_.numNs,$_.i,$g($_.numNs,$_.i+1)+1);$p($_.numAorNs,$_.i,$g($_.numAorNs,$_.i+1)+1)}else{$p($_.nextNs,$_.i,$g($_.nextNs,$_.i+1)+1)}var _5x=$g($_.Aexcl,$_.barchar)!==undefined;if(_5x){$p($_.nextAs,$_.i,0);$p($_.numAs,$_.i,$g($_.numAs,$_.i+1)+1);$p($_.numAorNs,$_.i,$g($_.numAorNs,$_.i+1)+1)}else{$p($_.nextAs,$_.i,$g($_.nextAs,$_.i+1)+1)}$p($_.isECI,$_.i,$_.barchar<=-1e6)}for(var _6K=0,_6J=$_.msglen-1;_6K<=_6J;_6K+=1){$_.i=_6K;if($g($_.numKs,$_.i)>0){$p($_.numKs,$_.i+1,0);$p($_.nextKs,$_.i+1,$g($_.nextKs,$_.i+1)+1)}}for(var _6W=$_.msglen-1;_6W>=0;_6W-=1){$_.i=_6W;if($f($g($_.numNs,$_.i)+($g($_.numAs,$_.i)+$g($_.numKs,$_.i)))==0&&!$g($_.isECI,$_.i)){$p($_.nextBs,$_.i,0);$p($_.numBs,$_.i,$g($_.numBs,$_.i+1)+1)}else{$p($_.nextBs,$_.i,$g($_.nextBs,$_.i+1)+1)}}$_.KbeforeB=function(){var _6y=$g($k[--$j],$_.ver);$k[$j++]=$ge($_.numK,_6y)&&$g($_.nextBs,$f($_.numK*2+$_.i))==0};$_.KbeforeA=function(){var _76=$g($k[--$j],$_.ver);$k[$j++]=$ge($_.numK,_76)&&$g($_.nextAs,$f($_.numK*2+$_.i))==0};$_.KbeforeN=function(){var _7E=$g($k[--$j],$_.ver);$k[$j++]=$ge($_.numK,_7E)&&$g($_.nextNs,$f($_.numK*2+$_.i))==0};$_.KbeforeE=function(){var _7M=$g($k[--$j],$_.ver);$k[$j++]=$ge($_.numK,_7M)&&$f($_.numK*2+$_.i)==$_.msglen};$_.AbeforeK=function(){var _7T=$g($k[--$j],$_.ver);$k[$j++]=$ge($_.numA,_7T)&&$g($_.nextKs,$f($_.numA+$_.i))==0};$_.AbeforeB=function(){var _7b=$g($k[--$j],$_.ver);$k[$j++]=$ge($_.numA,_7b)&&$g($_.nextBs,$f($_.numA+$_.i))==0};$_.AbeforeN=function(){var _7j=$g($k[--$j],$_.ver);$k[$j++]=$ge($_.numA,_7j)&&$g($_.nextNs,$f($_.numA+$_.i))==0};$_.AbeforeE=function(){var _7r=$g($k[--$j],$_.ver);$k[$j++]=$ge($_.numA,_7r)&&$f($_.numA+$_.i)==$_.msglen};$_.NbeforeK=function(){var _7y=$g($k[--$j],$_.ver);$k[$j++]=$ge($_.numN,_7y)&&$g($_.nextKs,$f($_.numN+$_.i))==0};$_.NbeforeB=function(){var _86=$g($k[--$j],$_.ver);$k[$j++]=$ge($_.numN,_86)&&$g($_.nextBs,$f($_.numN+$_.i))==0};$_.NbeforeA=function(){var _8E=$g($k[--$j],$_.ver);$k[$j++]=$ge($_.numN,_8E)&&$g($_.nextAs,$f($_.numN+$_.i))==0};$_.NbeforeE=function(){var _8M=$g($k[--$j],$_.ver);$k[$j++]=$ge($_.numN,_8M)&&$f($_.numN+$_.i)==$_.msglen};$_.AorNbeforeB=function(){var _8T=$g($k[--$j],$_.ver);$k[$j++]=$ge($_.numAorN,_8T)&&$g($_.nextBs,$f($_.numAorN+$_.i))==0};$_.AorNbeforeE=function(){var _8b=$g($k[--$j],$_.ver);$k[$j++]=$ge($_.numAorN,_8b)&&$f($_.numAorN+$_.i)==$_.msglen};$_.nextNslt=function(){if($g($_.nextNs,$_.i)>=$_.msglen){$k[$j-1]=true}else{var _8r=$g($k[--$j],$_.ver);$k[$j++]=$lt($g($_.numNs,$f($g($_.nextNs,$_.i)+$_.i)),_8r)}};$k[$j++]=Infinity;$k[$j++]="full";$k[$j++]=Infinity;for(var _8s=0;_8s<=9;_8s+=1){$k[$j++]=$R($s(2),_8s,10);$k[$j++]=$_.v1to9}for(var _8w=10;_8w<=26;_8w+=1){$k[$j++]=$R($s(2),_8w,10);$k[$j++]=$_.v10to26}for(var _90=27;_90<=40;_90+=1){$k[$j++]=$R($s(2),_90,10);$k[$j++]=$_.v27to40}var _94=$d();var _99=new Map([["M1",$_.vM1],["M2",$_.vM2],["M3",$_.vM3],["M4",$_.vM4]]);var _9g=new Map([["R7x43",$_.vR7x43],["R7x59",$_.vR7x59],["R7x77",$_.vR7x77],["R7x99",$_.vR7x99],["R7x139",$_.vR7x139],["R9x43",$_.vR9x43],["R9x59",$_.vR9x59],["R9x77",$_.vR9x77],["R9x99",$_.vR9x99],["R9x139",$_.vR9x139],["R11x27",$_.vR11x27],["R11x43",$_.vR11x43],["R11x59",$_.vR11x59],["R11x77",$_.vR11x77],["R11x99",$_.vR11x99],["R11x139",$_.vR11x139],["R13x27",$_.vR13x27],["R13x43",$_.vR13x43],["R13x59",$_.vR13x59],["R13x77",$_.vR13x77],["R13x99",$_.vR13x99],["R13x139",$_.vR13x139],["R15x43",$_.vR15x43],["R15x59",$_.vR15x59],["R15x77",$_.vR15x77],["R15x99",$_.vR15x99],["R15x139",$_.vR15x139],["R17x43",$_.vR17x43],["R17x59",$_.vR17x59],["R17x77",$_.vR17x77],["R17x99",$_.vR17x99],["R17x139",$_.vR17x139]]);$k[$j++]=_94;$k[$j++]="micro";$k[$j++]=_99;$k[$j++]="rmqr";$k[$j++]=_9g;$_.versetmap=$d();$_.versetfull=$a([$_.v1to9,$_.v10to26,$_.v27to40]);$_.versetmicro=$a([$_.vM1,$_.vM2,$_.vM3,$_.vM4]);if($ne($_.version,"unset")){var _9v=$g($_.versetmap,$_.format);var _9w=$_.version;var _9x=$g(_9v,_9w)!==undefined;$k[$j++]=_9v;$k[$j++]=_9w;if(!_9x){$j-=2;if($eq($_.format,"full")){$k[$j++]="bwipp.qrcodeInvalidFullVersion#21296";$k[$j++]="Valid versions for QR Code symbols are 1 to 40";bwipp_raiseerror()}else{if($eq($_.format,"micro")){$k[$j++]="bwipp.qrcodeInvalidMicroVersion#21299";$k[$j++]="Valid versions for Micro QR Code symbols are M1 to M4";bwipp_raiseerror()}else{$k[$j++]="bwipp.qrcodeInvalidRMQRversion#21301";$k[$j++]="Invalid version for an RMQR symbol";bwipp_raiseerror()}}}var _A0=$k[--$j];var _A2=$g($k[--$j],_A0);var _A3=Infinity;var _A4=_A2;$k[$j++]=_A3;$k[$j++]=_A4;$_.verset=$a()}else{if($eq($_.format,"full")){$_.verset=$_.versetfull}if($eq($_.format,"micro")){$_.verset=$_.versetmicro}}$k[$j++]=Infinity;for(var _AA=0;_AA<39;_AA++){$k[$j++]=-1}$_.msgbits=$a();$_.e=1e4;$_.mode0forceKB=$a([1,1,1,$_.e,$_.e,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]);$_.mode0forceA=$a([1,1,1,$_.e,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]);$_.mode0forceN=$a([1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]);$_.mode0NbeforeB=$a([4,4,5,$_.e,$_.e,2,3,2,2,3,3,3,2,3,3,3,3,2,3,3,3,3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3]);$_.modeBKbeforeB=$a([9,12,13,$_.e,$_.e,4,6,4,5,6,6,6,5,6,6,6,7,4,6,6,6,7,7,5,6,6,7,7,7,6,6,7,7,7,6,7,7,7,8]);$_.modeBKbeforeA=$a([8,10,11,$_.e,$_.e,4,5,4,5,5,6,6,5,5,6,6,6,4,5,6,6,6,6,5,6,6,6,6,7,6,6,6,6,7,6,6,6,7,7]);$_.modeBKbeforeN=$a([8,9,11,$_.e,$_.e,3,5,3,4,5,5,5,4,5,5,5,6,3,5,5,5,6,6,4,5,5,6,6,6,5,5,6,6,7,5,6,6,6,7]);$_.modeBKbeforeE=$a([5,5,6,$_.e,$_.e,2,3,2,3,3,3,3,3,3,3,3,4,2,3,3,3,4,4,3,3,3,4,4,4,3,3,4,4,4,3,4,4,4,4]);$_.modeBAbeforeK=$a([11,12,14,$_.e,$_.e,5,7,5,6,7,8,8,6,7,8,8,8,6,7,8,8,8,8,6,8,8,8,8,9,8,8,8,8,9,8,8,8,9,9]);$_.modeBAbeforeB=$a([11,15,16,$_.e,$_.e,6,7,6,7,7,8,8,7,7,8,8,8,6,7,8,8,8,9,7,8,8,8,9,9,8,8,9,9,9,8,8,9,9,10]);$_.modeBAbeforeN=$a([12,13,15,$_.e,$_.e,6,8,6,7,8,8,8,7,8,8,8,9,6,8,8,8,9,9,7,8,8,9,9,10,8,9,9,9,10,8,9,9,10,10]);$_.modeBAbeforeE=$a([6,7,8,$_.e,$_.e,3,4,3,4,4,4,4,4,4,4,4,5,4,4,4,4,5,5,4,4,4,5,5,5,4,5,5,5,5,4,5,5,5,5]);$_.modeBNbeforeK=$a([6,7,8,$_.e,$_.e,3,4,3,4,4,5,5,4,4,5,5,5,3,4,5,5,5,5,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5]);$_.modeBNbeforeB=$a([6,8,9,$_.e,$_.e,3,4,3,4,4,5,5,4,4,5,5,5,3,4,5,5,5,5,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,6]);$_.modeBNbeforeA=$a([6,7,8,$_.e,$_.e,3,4,3,4,4,5,5,4,4,5,5,5,4,4,5,5,5,5,4,5,5,5,5,5,5,5,5,5,6,5,5,5,5,6]);$_.modeBNbeforeE=$a([3,4,4,$_.e,$_.e,2,3,2,2,3,3,3,2,3,3,3,3,2,3,3,3,3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3]);$_.modeANbeforeA=$a([13,15,17,$_.e,5,7,9,7,8,9,9,9,8,9,9,9,11,7,9,9,9,11,11,8,9,9,10,11,11,9,10,11,11,11,9,11,11,11,11]);$_.modeANbeforeB=$a([13,17,18,$_.e,$_.e,7,9,7,8,9,9,9,8,9,9,9,10,7,9,9,9,10,11,8,9,9,9,11,11,9,9,11,11,11,9,10,11,11,11]);$_.modeANbeforeE=$a([7,8,9,$_.e,3,4,5,4,5,5,5,5,5,5,5,5,6,4,5,5,5,6,6,5,5,5,5,6,6,5,5,6,6,6,5,6,6,6,6]);var _B3=$_.verset;for(var _B4=0,_B5=_B3.length;_B4<_B5;_B4++){$_.ver=$g(_B3,_B4);$_.mode=-1;$_.seq=$a([]);$_.i=0;for(;;){if($_.i>=$_.msglen){break}$_.numK=$g($_.numKs,$_.i);$_.numB=$g($_.numBs,$_.i);$_.numA=$g($_.numAs,$_.i);$_.numN=$g($_.numNs,$_.i);$_.numAorN=$g($_.numAorNs,$_.i);$_.eci=$g($_.isECI,$_.i);if($eq($_.ver,$_.vM1)&&$_.numA>=1){$_.seq=-1;break}if($eq($_.ver,$_.vM1)&&$_.numB>=1){$_.seq=-1;break}if($eq($_.ver,$_.vM1)&&$_.numK>=1){$_.seq=-1;break}if($eq($_.ver,$_.vM1)&&$_.eci){$_.seq=-1;break}if($eq($_.ver,$_.vM2)&&$_.numB>=1){$_.seq=-1;break}if($eq($_.ver,$_.vM2)&&$_.numK>=1){$_.seq=-1;break}if($eq($_.ver,$_.vM2)&&$_.eci){$_.seq=-1;break}if($eq($_.ver,$_.vM3)&&$_.eci){$_.seq=-1;break}if($eq($_.ver,$_.vM4)&&$_.eci){$_.seq=-1;break}for(;;){if($_.eci){$k[$j++]=$_.E;break}if($_.mode==-1){$k[$j++]=$_.mode0forceKB;$_.KbeforeA();if($k[--$j]){$k[$j++]=$_.K;break}$k[$j++]=$_.mode0forceKB;$_.KbeforeN();if($k[--$j]){$k[$j++]=$_.K;break}$k[$j++]=$_.modeBKbeforeE;$_.KbeforeB();if($k[--$j]){$k[$j++]=$_.K;break}$k[$j++]=$_.mode0forceKB;$_.KbeforeE();if($k[--$j]){$k[$j++]=$_.K;break}if($_.numK>=1){$k[$j++]=$_.B;break}$k[$j++]=$_.mode0NbeforeB;$_.NbeforeK();if($k[--$j]){$k[$j++]=$_.N;break}$k[$j++]=$_.mode0NbeforeB;$_.NbeforeB();if($k[--$j]){$k[$j++]=$_.N;break}$k[$j++]=$_.mode0forceKB;$_.NbeforeB();if($k[--$j]){$k[$j++]=$_.B;break}$k[$j++]=$_.modeANbeforeE;$_.NbeforeA();if($k[--$j]){$k[$j++]=$_.N;break}$k[$j++]=$_.mode0forceN;$_.NbeforeE();if($k[--$j]){$k[$j++]=$_.N;break}$k[$j++]=$_.modeBAbeforeE;$_.AbeforeK();if($k[--$j]){$k[$j++]=$_.A;break}$k[$j++]=$_.modeBAbeforeE;$_.AorNbeforeB();if($k[--$j]){$k[$j++]=$_.A;break}$k[$j++]=$_.mode0forceA;$_.AorNbeforeE();if($k[--$j]){$k[$j++]=$_.A;break}$k[$j++]=$_.B;break}if($_.mode==$_.B){$k[$j++]=$_.modeBKbeforeB;$_.KbeforeB();if($k[--$j]){$k[$j++]=$_.K;break}$k[$j++]=$_.modeBKbeforeA;$_.KbeforeA();if($k[--$j]){$k[$j++]=$_.K;break}$k[$j++]=$_.modeBKbeforeN;$_.KbeforeN();if($k[--$j]){$k[$j++]=$_.K;break}$k[$j++]=$_.modeBKbeforeE;$_.KbeforeE();if($k[--$j]){$k[$j++]=$_.K;break}$k[$j++]=$_.modeBAbeforeK;$_.AbeforeK();if($k[--$j]){$k[$j++]=$_.A;break}$k[$j++]=$_.modeBAbeforeB;$_.AbeforeB();if($k[--$j]){$k[$j++]=$_.A;break}$k[$j++]=$_.modeBAbeforeN;$_.AbeforeN();if($k[--$j]){$k[$j++]=$_.A;break}$k[$j++]=$_.modeBAbeforeE;$_.AbeforeE();if($k[--$j]){$k[$j++]=$_.A;break}$k[$j++]=$_.modeBNbeforeK;$_.NbeforeK();if($k[--$j]){$k[$j++]=$_.N;break}$k[$j++]=$_.modeBNbeforeB;$_.NbeforeB();if($k[--$j]){$k[$j++]=$_.N;break}$k[$j++]=$_.modeBNbeforeA;$_.NbeforeA();if($k[--$j]){$k[$j++]=$_.N;break}$k[$j++]=$_.modeBNbeforeE;$_.NbeforeE();if($k[--$j]){$k[$j++]=$_.N;break}$k[$j++]=$_.modeBAbeforeE;$_.AorNbeforeE();var _DG=$k[--$j];if(_DG&&$le($_.numAorN,$g($_.modeBAbeforeN,$_.ver))){$k[$j++]=$_.modeBNbeforeA;$_.nextNslt();if($k[--$j]){$k[$j++]=$_.A;break}}$k[$j++]=$_.B;break}if($_.mode==$_.A){if($_.numK>=1){$k[$j++]=$_.K;break}if($_.numB>=1){$k[$j++]=$_.B;break}$k[$j++]=$_.modeANbeforeA;$_.NbeforeA();if($k[--$j]){$k[$j++]=$_.N;break}$k[$j++]=$_.modeANbeforeB;$_.NbeforeB();if($k[--$j]){$k[$j++]=$_.N;break}$k[$j++]=$_.modeANbeforeE;$_.NbeforeE();if($k[--$j]){$k[$j++]=$_.N;break}if($_.numA>=1||$_.numN>=1){$k[$j++]=$_.A;break}$k[$j++]=$_.B;break}if($_.mode==$_.N){if($_.numK>=1){$k[$j++]=$_.K;break}if($_.numB>=1){$k[$j++]=$_.B;break}if($_.numA>=1){$k[$j++]=$_.A;break}if($_.numN>=1){$k[$j++]=$_.N;break}$k[$j++]=$_.B;break}if($_.mode==$_.K){if($_.numB>=1){$k[$j++]=$_.B;break}if($_.numA>=1){$k[$j++]=$_.A;break}if($_.numN>=1){$k[$j++]=$_.N;break}if($_.numK>=1){$k[$j++]=$_.K;break}$k[$j++]=$_.B;break}}var _E0=$k[$j-1];if(_E0==$_.K&&$_.fnc1first){$k[$j-1]=$_.B}var _E4=$k[$j-1];if(_E4==$_.mode){$j--;var _EA=$_.mode==$_.K?2:1;$_.dat=$G($_.msg,$_.i,_EA);$k[$j++]=Infinity;$q($_.seq);$k[$j++]=Infinity;var _ED=$k[--$j];var _EE=$k[--$j];$k[$j++]=_ED;$q(_EE);$q($_.dat);var _EG=$a();$k[$j++]=_EG;$_.seq=$a()}else{$_.mode=$k[--$j];if($_.mode==$_.K){$k[$j++]=$_.K;$k[$j++]=$G($_.msg,$_.i,$_.numK*2)}if($_.mode==$_.B){$k[$j++]=$_.B;$k[$j++]=$G($_.msg,$_.i,$_.numB)}if($_.mode==$_.A){$k[$j++]=$_.A;$k[$j++]=$G($_.msg,$_.i,$_.numA)}if($_.mode==$_.N){$k[$j++]=$_.N;$k[$j++]=$G($_.msg,$_.i,$_.numN)}if($_.mode==$_.E){$_.mode=-1;$k[$j++]=$_.E;$k[$j++]=$G($_.msg,$_.i,1)}$_.dat=$k[--$j];$_.sw=$k[--$j];$k[$j++]=Infinity;$q($_.seq);$k[$j++]=$_.sw;$k[$j++]=$_.dat;$_.seq=$a()}$_.i=$_.i+$_.dat.length}for(;;){if($_.seq==-1){break}$_.bits=$s(23648);$_.j=0;if($_.fnc1first){if($lt($_.ver,$_.vR7x43)){$k[$j++]="0101"}else{$k[$j++]="101"}$_.addtobits()}$_.abort=false;for(var _F6=0,_F5=$_.seq.length-1;_F6<=_F5;_F6+=2){$_.i=_F6;$_.mode=$g($_.seq,$_.i);$k[$j++]=$g($g($_.mids,$_.ver),$_.mode);$_.addtobits();$_.chars=$g($_.seq,$_.i+1);$k[$j++]="charslen";$k[$j++]=$_.chars.length;if($_.mode==$_.K){var _FL=$k[--$j];$k[$j++]=~~(_FL/2)}var _FM=$k[--$j];$_[$k[--$j]]=_FM;if($_.mode!=$_.E){$_.cclen=$g($g($_.cclens,$_.ver),$_.mode);if($_.charslen>=~~$pow(2,$_.cclen)){$_.abort=true;break}$k[$j++]=$_.charslen;$k[$j++]=$_.cclen;$_.tobin();$_.addtobits()}$k[$j++]=$_.chars;if($_[$g($_.encfuncs,$_.mode)]()===true){break}$_.addtobits()}if($_.abort){break}$_.bits=$G($_.bits,0,$_.j);$p($_.msgbits,$_.ver,$_.bits);break}}$_.metrics=$a([$a(["micro","M1",$_.vM1,11,11,98,99,36,$a([2,99,99,99]),$a([1,0,-1,-1,-1,-1,-1,-1])]),$a(["micro","M2",$_.vM2,13,13,98,99,80,$a([5,6,99,99]),$a([1,0,1,0,-1,-1,-1,-1])]),$a(["micro","M3",$_.vM3,15,15,98,99,132,$a([6,8,99,99]),$a([1,0,1,0,-1,-1,-1,-1])]),$a(["micro","M4",$_.vM4,17,17,98,99,192,$a([8,10,14,99]),$a([1,0,1,0,1,0,-1,-1])]),$a(["full","1",$_.v1to9,21,21,98,99,208,$a([7,10,13,17]),$a([1,0,1,0,1,0,1,0])]),$a(["full","2",$_.v1to9,25,25,18,99,359,$a([10,16,22,28]),$a([1,0,1,0,1,0,1,0])]),$a(["full","3",$_.v1to9,29,29,22,99,567,$a([15,26,36,44]),$a([1,0,1,0,2,0,2,0])]),$a(["full","4",$_.v1to9,33,33,26,99,807,$a([20,36,52,64]),$a([1,0,2,0,2,0,4,0])]),$a(["full","5",$_.v1to9,37,37,30,99,1079,$a([26,48,72,88]),$a([1,0,2,0,2,2,2,2])]),$a(["full","6",$_.v1to9,41,41,34,99,1383,$a([36,64,96,112]),$a([2,0,4,0,4,0,4,0])]),$a(["full","7",$_.v1to9,45,45,22,38,1568,$a([40,72,108,130]),$a([2,0,4,0,2,4,4,1])]),$a(["full","8",$_.v1to9,49,49,24,42,1936,$a([48,88,132,156]),$a([2,0,2,2,4,2,4,2])]),$a(["full","9",$_.v1to9,53,53,26,46,2336,$a([60,110,160,192]),$a([2,0,3,2,4,4,4,4])]),$a(["full","10",$_.v10to26,57,57,28,50,2768,$a([72,130,192,224]),$a([2,2,4,1,6,2,6,2])]),$a(["full","11",$_.v10to26,61,61,30,54,3232,$a([80,150,224,264]),$a([4,0,1,4,4,4,3,8])]),$a(["full","12",$_.v10to26,65,65,32,58,3728,$a([96,176,260,308]),$a([2,2,6,2,4,6,7,4])]),$a(["full","13",$_.v10to26,69,69,34,62,4256,$a([104,198,288,352]),$a([4,0,8,1,8,4,12,4])]),$a(["full","14",$_.v10to26,73,73,26,46,4651,$a([120,216,320,384]),$a([3,1,4,5,11,5,11,5])]),$a(["full","15",$_.v10to26,77,77,26,48,5243,$a([132,240,360,432]),$a([5,1,5,5,5,7,11,7])]),$a(["full","16",$_.v10to26,81,81,26,50,5867,$a([144,280,408,480]),$a([5,1,7,3,15,2,3,13])]),$a(["full","17",$_.v10to26,85,85,30,54,6523,$a([168,308,448,532]),$a([1,5,10,1,1,15,2,17])]),$a(["full","18",$_.v10to26,89,89,30,56,7211,$a([180,338,504,588]),$a([5,1,9,4,17,1,2,19])]),$a(["full","19",$_.v10to26,93,93,30,58,7931,$a([196,364,546,650]),$a([3,4,3,11,17,4,9,16])]),$a(["full","20",$_.v10to26,97,97,34,62,8683,$a([224,416,600,700]),$a([3,5,3,13,15,5,15,10])]),$a(["full","21",$_.v10to26,101,101,28,50,9252,$a([224,442,644,750]),$a([4,4,17,0,17,6,19,6])]),$a(["full","22",$_.v10to26,105,105,26,50,10068,$a([252,476,690,816]),$a([2,7,17,0,7,16,34,0])]),$a(["full","23",$_.v10to26,109,109,30,54,10916,$a([270,504,750,900]),$a([4,5,4,14,11,14,16,14])]),$a(["full","24",$_.v10to26,113,113,28,54,11796,$a([300,560,810,960]),$a([6,4,6,14,11,16,30,2])]),$a(["full","25",$_.v10to26,117,117,32,58,12708,$a([312,588,870,1050]),$a([8,4,8,13,7,22,22,13])]),$a(["full","26",$_.v10to26,121,121,30,58,13652,$a([336,644,952,1110]),$a([10,2,19,4,28,6,33,4])]),$a(["full","27",$_.v27to40,125,125,34,62,14628,$a([360,700,1020,1200]),$a([8,4,22,3,8,26,12,28])]),$a(["full","28",$_.v27to40,129,129,26,50,15371,$a([390,728,1050,1260]),$a([3,10,3,23,4,31,11,31])]),$a(["full","29",$_.v27to40,133,133,30,54,16411,$a([420,784,1140,1350]),$a([7,7,21,7,1,37,19,26])]),$a(["full","30",$_.v27to40,137,137,26,52,17483,$a([450,812,1200,1440]),$a([5,10,19,10,15,25,23,25])]),$a(["full","31",$_.v27to40,141,141,30,56,18587,$a([480,868,1290,1530]),$a([13,3,2,29,42,1,23,28])]),$a(["full","32",$_.v27to40,145,145,34,60,19723,$a([510,924,1350,1620]),$a([17,0,10,23,10,35,19,35])]),$a(["full","33",$_.v27to40,149,149,30,58,20891,$a([540,980,1440,1710]),$a([17,1,14,21,29,19,11,46])]),$a(["full","34",$_.v27to40,153,153,34,62,22091,$a([570,1036,1530,1800]),$a([13,6,14,23,44,7,59,1])]),$a(["full","35",$_.v27to40,157,157,30,54,23008,$a([570,1064,1590,1890]),$a([12,7,12,26,39,14,22,41])]),$a(["full","36",$_.v27to40,161,161,24,50,24272,$a([600,1120,1680,1980]),$a([6,14,6,34,46,10,2,64])]),$a(["full","37",$_.v27to40,165,165,28,54,25568,$a([630,1204,1770,2100]),$a([17,4,29,14,49,10,24,46])]),$a(["full","38",$_.v27to40,169,169,32,58,26896,$a([660,1260,1860,2220]),$a([4,18,13,32,48,14,42,32])]),$a(["full","39",$_.v27to40,173,173,26,54,28256,$a([720,1316,1950,2310]),$a([20,4,40,7,43,22,10,67])]),$a(["full","40",$_.v27to40,177,177,30,58,29648,$a([750,1372,2040,2430]),$a([19,6,18,31,34,34,20,61])]),$a(["rmqr","R7x43",$_.vR7x43,7,43,22,99,104,$a([99,7,99,10]),$a([-1,-1,1,0,-1,-1,1,0])]),$a(["rmqr","R7x59",$_.vR7x59,7,59,20,40,171,$a([99,9,99,14]),$a([-1,-1,1,0,-1,-1,1,0])]),$a(["rmqr","R7x77",$_.vR7x77,7,77,26,52,261,$a([99,12,99,22]),$a([-1,-1,1,0,-1,-1,1,0])]),$a(["rmqr","R7x99",$_.vR7x99,7,99,24,50,358,$a([99,16,99,30]),$a([-1,-1,1,0,-1,-1,1,0])]),$a(["rmqr","R7x139",$_.vR7x139,7,139,28,56,545,$a([99,24,99,44]),$a([-1,-1,1,0,-1,-1,2,0])]),$a(["rmqr","R9x43",$_.vR9x43,9,43,22,99,170,$a([99,9,99,14]),$a([-1,-1,1,0,-1,-1,1,0])]),$a(["rmqr","R9x59",$_.vR9x59,9,59,20,40,267,$a([99,12,99,22]),$a([-1,-1,1,0,-1,-1,1,0])]),$a(["rmqr","R9x77",$_.vR9x77,9,77,26,52,393,$a([99,18,99,32]),$a([-1,-1,1,0,-1,-1,1,1])]),$a(["rmqr","R9x99",$_.vR9x99,9,99,24,50,532,$a([99,24,99,44]),$a([-1,-1,1,0,-1,-1,2,0])]),$a(["rmqr","R9x139",$_.vR9x139,9,139,28,56,797,$a([99,36,99,66]),$a([-1,-1,1,1,-1,-1,3,0])]),$a(["rmqr","R11x27",$_.vR11x27,11,27,98,99,122,$a([99,8,99,10]),$a([-1,-1,1,0,-1,-1,1,0])]),$a(["rmqr","R11x43",$_.vR11x43,11,43,22,99,249,$a([99,12,99,20]),$a([-1,-1,1,0,-1,-1,1,0])]),$a(["rmqr","R11x59",$_.vR11x59,11,59,20,40,376,$a([99,16,99,32]),$a([-1,-1,1,0,-1,-1,1,1])]),$a(["rmqr","R11x77",$_.vR11x77,11,77,26,52,538,$a([99,24,99,44]),$a([-1,-1,1,0,-1,-1,1,1])]),$a(["rmqr","R11x99",$_.vR11x99,11,99,24,50,719,$a([99,32,99,60]),$a([-1,-1,1,1,-1,-1,1,1])]),$a(["rmqr","R11x139",$_.vR11x139,11,139,28,56,1062,$a([99,48,99,90]),$a([-1,-1,2,0,-1,-1,3,0])]),$a(["rmqr","R13x27",$_.vR13x27,13,27,98,99,172,$a([99,9,99,14]),$a([-1,-1,1,0,-1,-1,1,0])]),$a(["rmqr","R13x43",$_.vR13x43,13,43,22,99,329,$a([99,14,99,28]),$a([-1,-1,1,0,-1,-1,1,0])]),$a(["rmqr","R13x59",$_.vR13x59,13,59,20,40,486,$a([99,22,99,40]),$a([-1,-1,1,0,-1,-1,2,0])]),$a(["rmqr","R13x77",$_.vR13x77,13,77,26,52,684,$a([99,32,99,56]),$a([-1,-1,1,1,-1,-1,1,1])]),$a(["rmqr","R13x99",$_.vR13x99,13,99,24,50,907,$a([99,40,99,78]),$a([-1,-1,1,1,-1,-1,1,2])]),$a(["rmqr","R13x139",$_.vR13x139,13,139,28,56,1328,$a([99,60,99,112]),$a([-1,-1,2,1,-1,-1,2,2])]),$a(["rmqr","R15x43",$_.vR15x43,15,43,22,99,409,$a([99,18,99,36]),$a([-1,-1,1,0,-1,-1,1,1])]),$a(["rmqr","R15x59",$_.vR15x59,15,59,20,40,596,$a([99,26,99,48]),$a([-1,-1,1,0,-1,-1,2,0])]),$a(["rmqr","R15x77",$_.vR15x77,15,77,26,52,830,$a([99,36,99,72]),$a([-1,-1,1,1,-1,-1,2,1])]),$a(["rmqr","R15x99",$_.vR15x99,15,99,24,50,1095,$a([99,48,99,88]),$a([-1,-1,2,0,-1,-1,4,0])]),$a(["rmqr","R15x139",$_.vR15x139,15,139,28,56,1594,$a([99,72,99,130]),$a([-1,-1,2,1,-1,-1,1,4])]),$a(["rmqr","R17x43",$_.vR17x43,17,43,22,99,489,$a([99,22,99,40]),$a([-1,-1,1,0,-1,-1,1,1])]),$a(["rmqr","R17x59",$_.vR17x59,17,59,20,40,706,$a([99,32,99,60]),$a([-1,-1,2,0,-1,-1,2,0])]),$a(["rmqr","R17x77",$_.vR17x77,17,77,26,52,976,$a([99,44,99,84]),$a([-1,-1,2,0,-1,-1,1,2])]),$a(["rmqr","R17x99",$_.vR17x99,17,99,24,50,1283,$a([99,60,99,104]),$a([-1,-1,2,1,-1,-1,4,0])]),$a(["rmqr","R17x139",$_.vR17x139,17,139,28,56,1860,$a([99,80,99,156]),$a([-1,-1,4,0,-1,-1,2,4])])]);$k[$j++]="eclval";$X("LMQH",$_.eclevel);$j--;var _Ki=$k[--$j];$k[$j-1]=_Ki.length;var _Kk=$k[--$j];$k[$j-1]=_Kk;var _Km=$k[--$j];$_[$k[--$j]]=_Km;for(var _Kq=0,_Kp=$_.metrics.length-1;_Kq<=_Kp;_Kq+=1){$_.i=_Kq;$_.m=$g($_.metrics,$_.i);$_.frmt=$g($_.m,0);$_.vers=$g($_.m,1);$_.vergrp=$g($_.m,2);$_.verind=$_.i-44;$_.rows=$g($_.m,3);$_.cols=$g($_.m,4);$_.asp2=$g($_.m,5);$_.asp3=$g($_.m,6);$_.nmod=$g($_.m,7);$_.ncws=~~($_.nmod/8);$_.rbit=$_.nmod%8;$_.lc4b=false;if($eq($_.vers,"M1")||$eq($_.vers,"M3")){$_.ncws=$_.ncws+1;$_.rbit=0;$_.lc4b=true}$_.ecws=$g($g($_.m,8),$_.eclval);$_.dcws=$f($_.ncws-$_.ecws);var _LO=$_.lc4b?4:0;$_.dmod=$f($_.dcws*8-_LO);$_.ecb1=$g($g($_.m,9),$_.eclval*2);$_.ecb2=$g($g($_.m,9),$_.eclval*2+1);$_.okay=true;if($ne($_.format,$_.frmt)){$_.okay=false}if($eq($_.frmt,"micro")&&$_.fnc1first){$_.okay=false}if($ne($_.version,"unset")&&$ne($_.version,$_.vers)){$_.okay=false}if($_.ecb1==-1||$_.ecb2==-1){$_.okay=false}$_.verbits=$g($_.msgbits,$_.vergrp);if($_.verbits==-1){$_.okay=false}else{if($_.verbits.length>$_.dmod){$_.okay=false}}$_.term=$G("000000000",0,$g($_.termlens,$_.vergrp));if($_.okay){break}}if(!$_.okay){$k[$j++]="bwipp.qrcodeNoValidSymbol#21607";$k[$j++]="Maximum length exceeded or invalid content";bwipp_raiseerror()}$_.format=$_.frmt;$_.version=$_.vers;$_.msgbits=$_.verbits;if(!$_.fixedeclevel){for(var _Lx=$_.eclval+1;_Lx<=3;_Lx+=1){$_.eclval_=_Lx;$_.ecws_=$g($g($_.m,8),$_.eclval_);$_.dcws_=$f($_.ncws-$_.ecws_);var _M6=$_.lc4b?4:0;$_.dmod_=$f($_.dcws_*8-_M6);$_.ecb1_=$g($g($_.m,9),$_.eclval_*2);$_.ecb2_=$g($g($_.m,9),$_.eclval_*2+1);$_.okay=true;if($_.ecb1_==-1||$_.ecb2_==-1){$_.okay=false}if($_.msgbits.length>$_.dmod_){$_.okay=false}if($_.okay){$_.eclval=$_.eclval_;$_.dcws=$_.dcws_;$_.dmod=$_.dmod_;$_.ecb1=$_.ecb1_;$_.ecb2=$_.ecb2_}}}$_.dcpb=~~($_.dcws/$f($_.ecb1+$_.ecb2));$_.ecpb=~~($_.ncws/$f($_.ecb1+$_.ecb2))-$_.dcpb;var _MW=$_.term;var _MX=$_.dmod;var _MY=$_.msgbits;var _MZ=$_.term;var _Ma=_MZ.length;var _Mb=$f(_MX-_MY.length);if($f(_MX-_MY.length)>_MZ.length){var _=_Ma;_Ma=_Mb;_Mb=_}$_.term=$G(_MW,0,_Mb);var _Mf=$s($_.msgbits.length+$_.term.length);$P(_Mf,0,$_.msgbits);$P(_Mf,$_.msgbits.length,$_.term);$_.msgbits=_Mf;$_.pad=$s($_.dmod);for(var _Mn=0,_Mm=$_.pad.length-1;_Mn<=_Mm;_Mn+=1){$p($_.pad,_Mn,48)}$P($_.pad,0,$_.msgbits);$_.padnum=0;var _Mu=$_.lc4b?5:1;for(var _Mw=~~($ceil($_.msgbits.length/8)*8),_Mv=$f($_.dmod-_Mu);_Mw<=_Mv;_Mw+=8){$P($_.pad,_Mw,$g($_.padstrs,$_.padnum));$_.padnum=($_.padnum+1)%2}$_.cws=$a($_.dcws);for(var _N6=0,_N5=$_.cws.length-1;_N6<=_N5;_N6+=1){$_.c=_N6;$_.bpcw=8;if($_.lc4b&&$_.c==$_.cws.length-1){$_.bpcw=4}$_.cwb=$G($_.pad,$_.c*8,$_.bpcw);$_.cw=0;for(var _NG=0,_NF=$_.bpcw-1;_NG<=_NF;_NG+=1){$_.i=_NG;$_.cw=$f($_.cw+~~$pow(2,$_.bpcw-$_.i-1)*($g($_.cwb,$_.i)-48))}$p($_.cws,$_.c,$_.cw)}if($_.lc4b){var _NR=$_.cws;var _NS=$_.cws;$p(_NR,_NS.length-1,$g(_NR,_NS.length-1)<<4)}var _NV=$g($_.options,"debugcws")!==undefined;if(_NV){$k[$j++]="bwipp.debugcws#21674";$k[$j++]=$_.cws;bwipp_raiseerror()}$k[$j++]=Infinity;$k[$j++]=1;for(var _NX=0;_NX<255;_NX++){var _NY=$k[$j-1];var _NZ=_NY*2;$k[$j++]=_NZ;if(_NZ>=256){var _Na=$k[--$j];$k[$j++]=_Na^285}}$_.rsalog=$a();$_.rslog=$a(256);for(var _Nd=1;_Nd<=255;_Nd+=1){$p($_.rslog,$g($_.rsalog,_Nd),_Nd)}$_.rsprod=function(){var _Ni=$k[$j-1];var _Nj=$k[$j-2];if(_Ni!=0&&_Nj!=0){var _Nm=$g($_.rslog,$k[--$j]);var _Nr=$g($_.rsalog,$f(_Nm+$g($_.rslog,$k[--$j]))%255);$k[$j++]=_Nr}else{$j-=2;$k[$j++]=0}};$k[$j++]=Infinity;$k[$j++]=1;for(var _Nt=0,_Nu=$_.ecpb;_Nt<_Nu;_Nt++){$k[$j++]=0}$_.coeffs=$a();for(var _Ny=0,_Nx=$_.ecpb-1;_Ny<=_Nx;_Ny+=1){$_.i=_Ny;$p($_.coeffs,$_.i+1,$g($_.coeffs,$_.i));for(var _O5=$_.i;_O5>=1;_O5-=1){$_.j=_O5;$k[$j++]=$_.coeffs;$k[$j++]=$_.j;$k[$j++]=$g($_.coeffs,$_.j-1);$k[$j++]=$g($_.coeffs,$_.j);$k[$j++]=$g($_.rsalog,$_.i);$_.rsprod();var _OH=$k[--$j];var _OI=$k[--$j];var _OJ=$k[--$j];$p($k[--$j],_OJ,$xo(_OI,_OH))}$k[$j++]=$_.coeffs;$k[$j++]=0;$k[$j++]=$g($_.coeffs,0);$k[$j++]=$g($_.rsalog,$_.i);$_.rsprod();var _OR=$k[--$j];var _OS=$k[--$j];$p($k[--$j],_OS,_OR)}$_.coeffs=$G($_.coeffs,0,$_.coeffs.length-1);$_.rscodes=function(){$_.rscws=$k[--$j];$_.rsnd=$_.rscws.length;$k[$j++]=Infinity;$q($_.rscws);for(var _Ob=0,_Oc=$_.ecpb;_Ob<_Oc;_Ob++){$k[$j++]=0}$_.rscws=$a();for(var _Og=0,_Of=$_.rsnd-1;_Og<=_Of;_Og+=1){$_.m=_Og;$_.k=$g($_.rscws,$_.m);for(var _Om=0,_Ol=$_.ecpb-1;_Om<=_Ol;_Om+=1){$_.j=_Om;$k[$j++]=$_.rscws;$k[$j++]=$_.m+$_.j+1;$k[$j++]=$g($_.coeffs,$_.ecpb-$_.j-1);$k[$j++]=$_.k;$_.rsprod();var _Oz=$k[--$j];var _P0=$k[--$j];$p($k[--$j],_P0,$xo(_Oz,$g($_.rscws,$_.m+$_.j+1)))}}$k[$j++]=$G($_.rscws,$_.rsnd,$_.ecpb)};$_.dcwsb=$a($f($_.ecb1+$_.ecb2));$_.ecwsb=$a($f($_.ecb1+$_.ecb2));for(var _PE=0,_PD=$_.ecb1-1;_PE<=_PD;_PE+=1){$_.i=_PE;$p($_.dcwsb,$_.i,$G($_.cws,$_.i*$_.dcpb,$_.dcpb));$k[$j++]=$_.ecwsb;$k[$j++]=$_.i;$k[$j++]=$g($_.dcwsb,$_.i);$_.rscodes();var _PR=$k[--$j];var _PS=$k[--$j];$p($k[--$j],_PS,_PR)}for(var _PW=0,_PV=$_.ecb2-1;_PW<=_PV;_PW+=1){$_.i=_PW;$p($_.dcwsb,$f($_.ecb1+$_.i),$G($_.cws,$f($_.ecb1*$_.dcpb+$_.i*($_.dcpb+1)),$_.dcpb+1));$k[$j++]=$_.ecwsb;$k[$j++]=$f($_.ecb1+$_.i);$k[$j++]=$g($_.dcwsb,$f($_.ecb1+$_.i));$_.rscodes();var _Po=$k[--$j];var _Pp=$k[--$j];$p($k[--$j],_Pp,_Po)}$_.cws=$a($_.ncws);$_.cw=0;for(var _Pv=0,_Pu=$_.dcpb;_Pv<=_Pu;_Pv+=1){$_.i=_Pv;for(var _Pz=0,_Py=$f($_.ecb1+$_.ecb2)-1;_Pz<=_Py;_Pz+=1){$_.j=_Pz;if($_.i<$g($_.dcwsb,$_.j).length){$p($_.cws,$_.cw,$g($g($_.dcwsb,$_.j),$_.i));$_.cw=$_.cw+1}}}for(var _QE=0,_QD=$_.ecpb-1;_QE<=_QD;_QE+=1){$_.i=_QE;for(var _QI=0,_QH=$f($_.ecb1+$_.ecb2)-1;_QI<=_QH;_QI+=1){$_.j=_QI;$p($_.cws,$_.cw,$g($g($_.ecwsb,$_.j),$_.i));$_.cw=$_.cw+1}}if($_.rbit>0){$_.pad=$a($_.cws.length+1);$P($_.pad,0,$_.cws);$p($_.pad,$_.pad.length-1,0);$_.cws=$_.pad}if($_.lc4b){var _Qa=$_.cws;var _Qb=$_.dcws;$p(_Qa,_Qb-1,$g(_Qa,_Qb-1)>>>4);for(var _Qg=$_.dcws-1,_Qf=$_.ncws-2;_Qg<=_Qf;_Qg+=1){$_.i=_Qg;$p($_.cws,$_.i,($g($_.cws,$_.i)&15)<<4);$p($_.cws,$_.i,$g($_.cws,$_.i+1)>>>4&15|$g($_.cws,$_.i))}$p($_.cws,$_.ncws-1,($g($_.cws,$_.ncws-1)&15)<<4)}var _R0=$g($_.options,"debugecc")!==undefined;if(_R0){$k[$j++]="bwipp.debugecc#21776";$k[$j++]=$_.cws;bwipp_raiseerror()}$k[$j++]=Infinity;for(var _R4=0,_R5=$_.rows*$_.cols;_R4<_R5;_R4++){$k[$j++]=-1}$_.pixs=$a();$_.qmv=function(){var _R8=$k[--$j];var _R9=$k[--$j];$k[$j++]=$f(_R9+_R8*$_.cols)};if($eq($_.format,"full")){for(var _RD=8,_RC=$_.cols-9;_RD<=_RC;_RD+=1){$_.i=_RD;$k[$j++]=$_.pixs;$k[$j++]=$_.i;$k[$j++]=6;$_.qmv();var _RH=$k[--$j];$p($k[--$j],_RH,($_.i+1)%2);$k[$j++]=$_.pixs;$k[$j++]=6;$k[$j++]=$_.i;$_.qmv();var _RM=$k[--$j];$p($k[--$j],_RM,($_.i+1)%2)}}if($eq($_.format,"micro")){for(var _RR=8,_RQ=$_.cols-1;_RR<=_RQ;_RR+=1){$_.i=_RR;$k[$j++]=$_.pixs;$k[$j++]=$_.i;$k[$j++]=0;$_.qmv();var _RV=$k[--$j];$p($k[--$j],_RV,($_.i+1)%2);$k[$j++]=$_.pixs;$k[$j++]=0;$k[$j++]=$_.i;$_.qmv();var _Ra=$k[--$j];$p($k[--$j],_Ra,($_.i+1)%2)}}if($eq($_.format,"rmqr")){for(var _Rf=3,_Re=$_.cols-4;_Rf<=_Re;_Rf+=1){$_.i=_Rf;$k[$j++]=$_.pixs;$k[$j++]=$_.i;$k[$j++]=0;$_.qmv();var _Rj=$k[--$j];$p($k[--$j],_Rj,($_.i+1)%2);$k[$j++]=$_.pixs;$k[$j++]=$_.i;$k[$j++]=$_.rows-1;$_.qmv();var _Rp=$k[--$j];$p($k[--$j],_Rp,($_.i+1)%2)}for(var _Rt=3,_Rs=$_.rows-4;_Rt<=_Rs;_Rt+=1){$_.i=_Rt;$k[$j++]=$_.pixs;$k[$j++]=0;$k[$j++]=$_.i;$_.qmv();var _Rx=$k[--$j];$p($k[--$j],_Rx,($_.i+1)%2);$k[$j++]=$_.pixs;$k[$j++]=$_.cols-1;$k[$j++]=$_.i;$_.qmv();var _S3=$k[--$j];$p($k[--$j],_S3,($_.i+1)%2)}for(var _SA=$_.asp2-1,_SB=$f($_.asp3-$_.asp2),_S9=$_.cols-13;_SB<0?_SA>=_S9:_SA<=_S9;_SA+=_SB){$_.i=_SA;for(var _SE=3,_SD=$_.rows-4;_SE<=_SD;_SE+=1){$_.j=_SE;$k[$j++]=$_.pixs;$k[$j++]=$_.i;$k[$j++]=$_.j;$_.qmv();var _SJ=$k[--$j];$p($k[--$j],_SJ,($_.j+1)%2)}}}$_.fpat=$a([$a([1,1,1,1,1,1,1,0]),$a([1,0,0,0,0,0,1,0]),$a([1,0,1,1,1,0,1,0]),$a([1,0,1,1,1,0,1,0]),$a([1,0,1,1,1,0,1,0]),$a([1,0,0,0,0,0,1,0]),$a([1,1,1,1,1,1,1,0]),$a([0,0,0,0,0,0,0,0])]);$_.fsubpat=$a([$a([1,1,1,1,1,9,9,9]),$a([1,0,0,0,1,9,9,9]),$a([1,0,1,0,1,9,9,9]),$a([1,0,0,0,1,9,9,9]),$a([1,1,1,1,1,9,9,9]),$a([9,9,9,9,9,9,9,9]),$a([9,9,9,9,9,9,9,9]),$a([9,9,9,9,9,9,9,9])]);$_.fcorpat=$a([$a([1,1,1,9,9,9,9,9]),$a([1,0,9,9,9,9,9,9]),$a([1,9,9,9,9,9,9,9]),$a([9,9,9,9,9,9,9,9]),$a([9,9,9,9,9,9,9,9]),$a([9,9,9,9,9,9,9,9]),$a([9,9,9,9,9,9,9,9]),$a([9,9,9,9,9,9,9,9])]);$_.fnullpat=$a([$a([9,9,9,9,9,9,9,9]),$a([9,9,9,9,9,9,9,9]),$a([9,9,9,9,9,9,9,9]),$a([9,9,9,9,9,9,9,9]),$a([9,9,9,9,9,9,9,9]),$a([9,9,9,9,9,9,9,9]),$a([9,9,9,9,9,9,9,9]),$a([9,9,9,9,9,9,9,9])]);var _TA=new Map([["full",$a([$_.fpat,$_.fpat,$_.fpat,$_.fnullpat])],["micro",$a([$_.fpat,$_.fnullpat,$_.fnullpat,$_.fnullpat])],["rmqr",$a([$_.fpat,$_.fcorpat,$_.fcorpat,$_.fsubpat])]]);$_.fpatmap=_TA;$_.fpats=$g($_.fpatmap,$_.format);for(var _TF=0;_TF<=7;_TF+=1){$_.y=_TF;for(var _TG=0;_TG<=7;_TG+=1){$_.x=_TG;$_.fpb0=$g($g($g($_.fpats,0),$_.y),$_.x);$_.fpb1=$g($g($g($_.fpats,1),$_.y),$_.x);$_.fpb2=$g($g($g($_.fpats,2),$_.y),$_.x);$_.fpb3=$g($g($g($_.fpats,3),$_.y),$_.x);if($_.fpb0!=9&&$_.y<$_.rows){$k[$j++]=$_.pixs;$k[$j++]=$_.x;$k[$j++]=$_.y;$_.qmv();var _Tm=$k[--$j];$p($k[--$j],_Tm,$_.fpb0)}if($_.fpb1!=9){$k[$j++]=$_.pixs;$k[$j++]=$f($_.cols-$_.x)-1;$k[$j++]=$_.y;$_.qmv();var _Tu=$k[--$j];$p($k[--$j],_Tu,$_.fpb1)}if($_.fpb2!=9){$k[$j++]=$_.pixs;$k[$j++]=$_.x;$k[$j++]=$f($_.rows-$_.y)-1;$_.qmv();var _U2=$k[--$j];$p($k[--$j],_U2,$_.fpb2)}if($_.fpb3!=9){$k[$j++]=$_.pixs;$k[$j++]=$f($_.cols-$_.x)-1;$k[$j++]=$f($_.rows-$_.y)-1;$_.qmv();var _UB=$k[--$j];$p($k[--$j],_UB,$_.fpb3)}}}$_.algnpatfull=$a([$a([1,1,1,1,1]),$a([1,0,0,0,1]),$a([1,0,1,0,1]),$a([1,0,0,0,1]),$a([1,1,1,1,1])]);$_.algnpatrmqr=$a([$a([1,1,1,9,9]),$a([1,0,1,9,9]),$a([1,1,1,9,9]),$a([9,9,9,9,9]),$a([9,9,9,9,9])]);$_.putalgnpat=function(){$_.py=$k[--$j];$_.px=$k[--$j];for(var _US=0;_US<=4;_US+=1){$_.pb=_US;for(var _UT=0;_UT<=4;_UT+=1){$_.pa=_UT;$_.algnb=$g($g($_.algnpat,$_.pb),$_.pa);if($_.algnb!=9){$k[$j++]=$_.pixs;$k[$j++]=$f($_.px+$_.pa);$k[$j++]=$f($_.py+$_.pb);$_.qmv();var _Ug=$k[--$j];$p($k[--$j],_Ug,$_.algnb)}}}};if($eq($_.format,"full")){$_.algnpat=$_.algnpatfull;for(var _Up=$_.asp2-2,_Uq=$f($_.asp3-$_.asp2),_Uo=$_.cols-13;_Uq<0?_Up>=_Uo:_Up<=_Uo;_Up+=_Uq){$_.i=_Up;$k[$j++]=$_.i;$k[$j++]=4;$_.putalgnpat();$k[$j++]=4;$k[$j++]=$_.i;$_.putalgnpat()}for(var _Uy=$_.asp2-2,_Uz=$f($_.asp3-$_.asp2),_Ux=$_.cols-9;_Uz<0?_Uy>=_Ux:_Uy<=_Ux;_Uy+=_Uz){$_.x=_Uy;for(var _V5=$_.asp2-2,_V6=$f($_.asp3-$_.asp2),_V4=$_.rows-9;_V6<0?_V5>=_V4:_V5<=_V4;_V5+=_V6){$_.y=_V5;$k[$j++]=$_.x;$k[$j++]=$_.y;$_.putalgnpat()}}}if($eq($_.format,"rmqr")){$_.algnpat=$_.algnpatrmqr;for(var _VG=$_.asp2-2,_VH=$f($_.asp3-$_.asp2),_VF=$_.cols-13;_VH<0?_VG>=_VF:_VG<=_VF;_VG+=_VH){$_.i=_VG;$k[$j++]=$_.i;$k[$j++]=0;$_.putalgnpat();$k[$j++]=$_.i;$k[$j++]=$_.rows-3;$_.putalgnpat()}}$_.formatmapmicro=$a([$a([$a([1,8])]),$a([$a([2,8])]),$a([$a([3,8])]),$a([$a([4,8])]),$a([$a([5,8])]),$a([$a([6,8])]),$a([$a([7,8])]),$a([$a([8,8])]),$a([$a([8,7])]),$a([$a([8,6])]),$a([$a([8,5])]),$a([$a([8,4])]),$a([$a([8,3])]),$a([$a([8,2])]),$a([$a([8,1])])]);var _YK=new Map([["full",$a([$a([$a([0,8]),$a([8,$_.cols-1])]),$a([$a([1,8]),$a([8,$_.cols-2])]),$a([$a([2,8]),$a([8,$_.cols-3])]),$a([$a([3,8]),$a([8,$_.cols-4])]),$a([$a([4,8]),$a([8,$_.cols-5])]),$a([$a([5,8]),$a([8,$_.cols-6])]),$a([$a([7,8]),$a([8,$_.cols-7])]),$a([$a([8,8]),$a([$_.cols-8,8])]),$a([$a([8,7]),$a([$_.cols-7,8])]),$a([$a([8,5]),$a([$_.cols-6,8])]),$a([$a([8,4]),$a([$_.cols-5,8])]),$a([$a([8,3]),$a([$_.cols-4,8])]),$a([$a([8,2]),$a([$_.cols-3,8])]),$a([$a([8,1]),$a([$_.cols-2,8])]),$a([$a([8,0]),$a([$_.cols-1,8])])])],["micro",$_.formatmapmicro],["rmqr",$a([$a([$a([11,3]),$a([$_.cols-3,$_.rows-6])]),$a([$a([11,2]),$a([$_.cols-4,$_.rows-6])]),$a([$a([11,1]),$a([$_.cols-5,$_.rows-6])]),$a([$a([10,5]),$a([$_.cols-6,$_.rows-2])]),$a([$a([10,4]),$a([$_.cols-6,$_.rows-3])]),$a([$a([10,3]),$a([$_.cols-6,$_.rows-4])]),$a([$a([10,2]),$a([$_.cols-6,$_.rows-5])]),$a([$a([10,1]),$a([$_.cols-6,$_.rows-6])]),$a([$a([9,5]),$a([$_.cols-7,$_.rows-2])]),$a([$a([9,4]),$a([$_.cols-7,$_.rows-3])]),$a([$a([9,3]),$a([$_.cols-7,$_.rows-4])]),$a([$a([9,2]),$a([$_.cols-7,$_.rows-5])]),$a([$a([9,1]),$a([$_.cols-7,$_.rows-6])]),$a([$a([8,5]),$a([$_.cols-8,$_.rows-2])]),$a([$a([8,4]),$a([$_.cols-8,$_.rows-3])]),$a([$a([8,3]),$a([$_.cols-8,$_.rows-4])]),$a([$a([8,2]),$a([$_.cols-8,$_.rows-5])]),$a([$a([8,1]),$a([$_.cols-8,$_.rows-6])])])]]);$_.formatmap=$g(_YK,$_.format);$F($_.formatmap,function(){$F($k[--$j],function(){$q($k[--$j]);$_.qmv();$p($_.pixs,$k[--$j],1)})});if($eq($_.format,"full")&&$_.cols>=45){$_.versionmap=$a([$a([$a([$_.cols-9,5]),$a([5,$_.cols-9])]),$a([$a([$_.cols-10,5]),$a([5,$_.cols-10])]),$a([$a([$_.cols-11,5]),$a([5,$_.cols-11])]),$a([$a([$_.cols-9,4]),$a([4,$_.cols-9])]),$a([$a([$_.cols-10,4]),$a([4,$_.cols-10])]),$a([$a([$_.cols-11,4]),$a([4,$_.cols-11])]),$a([$a([$_.cols-9,3]),$a([3,$_.cols-9])]),$a([$a([$_.cols-10,3]),$a([3,$_.cols-10])]),$a([$a([$_.cols-11,3]),$a([3,$_.cols-11])]),$a([$a([$_.cols-9,2]),$a([2,$_.cols-9])]),$a([$a([$_.cols-10,2]),$a([2,$_.cols-10])]),$a([$a([$_.cols-11,2]),$a([2,$_.cols-11])]),$a([$a([$_.cols-9,1]),$a([1,$_.cols-9])]),$a([$a([$_.cols-10,1]),$a([1,$_.cols-10])]),$a([$a([$_.cols-11,1]),$a([1,$_.cols-11])]),$a([$a([$_.cols-9,0]),$a([0,$_.cols-9])]),$a([$a([$_.cols-10,0]),$a([0,$_.cols-10])]),$a([$a([$_.cols-11,0]),$a([0,$_.cols-11])])])}else{$_.versionmap=$a([])}var _Zy=$_.versionmap;for(var _Zz=0,_a0=_Zy.length;_Zz<_a0;_Zz++){$F($g(_Zy,_Zz),function(){$q($k[--$j]);$_.qmv();$p($_.pixs,$k[--$j],0)})}if($eq($_.format,"full")){$k[$j++]=$_.pixs;$k[$j++]=8;$k[$j++]=$_.rows-8;$_.qmv();var _a8=$k[--$j];$p($k[--$j],_a8,0)}var _aS=$a([function(){var _aA=$k[--$j];var _aB=$k[--$j];$k[$j++]=$f(_aB+_aA)%2},function(){var _aC=$k[--$j];$k[$j-1]=_aC;var _aE=$k[--$j];$k[$j++]=_aE%2},function(){$j--;var _aF=$k[--$j];$k[$j++]=_aF%3},function(){var _aG=$k[--$j];var _aH=$k[--$j];$k[$j++]=$f(_aH+_aG)%3},function(){var _aI=$k[--$j];var _aJ=$k[--$j];$k[$j++]=(~~(_aI/2)+~~(_aJ/3))%2},function(){var _aK=$k[--$j];var _aM=$k[--$j]*_aK;$k[$j++]=$f(_aM%2+_aM%3)},function(){var _aN=$k[--$j];var _aP=$k[--$j]*_aN;$k[$j++]=$f(_aP%2+_aP%3)%2},function(){var _aQ=$k[--$j];var _aR=$k[--$j];$k[$j++]=$f(_aR*_aQ%3+(_aR+_aQ)%2)%2}]);var _ad=$a([function(){var _aT=$k[--$j];$k[$j-1]=_aT;var _aV=$k[--$j];$k[$j++]=_aV%2},function(){var _aW=$k[--$j];var _aX=$k[--$j];$k[$j++]=(~~(_aW/2)+~~(_aX/3))%2},function(){var _aY=$k[--$j];var _aa=$k[--$j]*_aY;$k[$j++]=$f(_aa%2+_aa%3)%2},function(){var _ab=$k[--$j];var _ac=$k[--$j];$k[$j++]=$f(_ac*_ab%3+(_ac+_ab)%2)%2}]);var _ag=$a([function(){var _ae=$k[--$j];var _af=$k[--$j];$k[$j++]=(~~(_ae/2)+~~(_af/3))%2}]);var _ah=new Map([["full",_aS],["micro",_ad],["rmqr",_ag]]);$_.maskfuncs=$g(_ah,$_.format);if($_.mask!=-1){$_.maskfuncs=$a([$g($_.maskfuncs,$_.mask-1)]);$_.bestmaskval=$_.mask-1}$_.masks=$a($_.maskfuncs.length);for(var _au=0,_at=$_.masks.length-1;_au<=_at;_au+=1){$_.m=_au;$_.mask=$a($_.rows*$_.cols);for(var _b0=0,_az=$_.rows-1;_b0<=_az;_b0+=1){$_.j=_b0;for(var _b3=0,_b2=$_.cols-1;_b3<=_b2;_b3+=1){$_.i=_b3;$k[$j++]=$_.i;$k[$j++]=$_.j;if($g($_.maskfuncs,$_.m)()===true){break}var _b9=$k[--$j];$k[$j++]=_b9==0;$k[$j++]=$_.pixs;$k[$j++]=$_.i;$k[$j++]=$_.j;$_.qmv();var _bD=$k[--$j];var _bF=$g($k[--$j],_bD);var _bG=$k[--$j];var _bH=_bG&&_bF==-1?1:0;$k[$j++]=_bH;$k[$j++]=$_.mask;$k[$j++]=$_.i;$k[$j++]=$_.j;$_.qmv();var _bL=$k[$j-3];var _bM=$k[$j-1];$p($k[$j-2],_bM,_bL);$j-=3}}$p($_.masks,$_.m,$_.mask)}var _bT=$ne($_.format,"rmqr")?1:2;$_.posx=$f($_.cols-_bT);$_.posy=$_.rows-1;$_.dir=-1;$_.col=1;$_.num=0;for(;;){if($_.posx<0){break}$k[$j++]=$_.pixs;$k[$j++]=$_.posx;$k[$j++]=$_.posy;$_.qmv();var _bZ=$k[--$j];if($g($k[--$j],_bZ)==-1){var _be=$g($_.cws,~~($_.num/8));var _bg=-(7-$_.num%8);$k[$j++]=(_bg<0?_be>>>-_bg:_be<<_bg)&1;$k[$j++]=$_.pixs;$k[$j++]=$_.posx;$k[$j++]=$_.posy;$_.qmv();var _bk=$k[$j-3];var _bl=$k[$j-1];$p($k[$j-2],_bl,_bk);$j-=3;$_.num=$_.num+1}if($_.col==1){$_.col=0;$_.posx=$_.posx-1}else{$_.col=1;$_.posx=$_.posx+1;$_.posy=$f($_.posy+$_.dir);if($_.posy<0||$_.posy>=$_.rows){$_.dir=$_.dir*-1;$_.posy=$f($_.posy+$_.dir);$_.posx=$_.posx-2;if($eq($_.format,"full")&&$_.posx==6){$_.posx=$_.posx-1}}}}$_.evalfulln1n3=function(){$_.scrle=$k[--$j];$k[$j++]="scr1";$k[$j++]=0;$F($_.scrle,function(){var _c5=$k[$j-1];if(_c5>=5){var _c6=$k[--$j];var _c8=$f($k[--$j]+_c6)-2;$k[$j++]=_c8;$k[$j++]=_c8}$j--});var _c9=$k[--$j];$_[$k[--$j]]=_c9;$_.scr3=0;for(var _cD=3,_cC=$_.scrle.length-3;_cD<=_cC;_cD+=2){$_.j=_cD;if($g($_.scrle,$_.j)%3==0){$_.fact=~~($g($_.scrle,$_.j)/3);var _cM=$G($_.scrle,$_.j-2,5);for(var _cN=0,_cO=_cM.length;_cN<_cO;_cN++){$k[$j++]=$g(_cM,_cN)==$_.fact}var _cR=$k[--$j];var _cS=$k[--$j];$k[$j-1]=$an(_cS,_cR);var _cU=$k[--$j];var _cV=$k[--$j];if($k[--$j]&&(_cV&&_cU)){if($_.j==3||$_.j+4>=$_.scrle.length){$_.scr3=$_.scr3+40}else{if($g($_.scrle,$_.j-3)>=4||$g($_.scrle,$_.j+3)>=4){$_.scr3=$_.scr3+40}}}}}$k[$j++]=$_.scr1;$k[$j++]=$_.scr3};$_.evalfull=function(){$_.sym=$k[--$j];$_.n1=0;$_.n2=0;$_.n3=0;$_.rle=$a($_.cols+1);$_.lastpairs=$a($_.cols);$_.thispairs=$a($_.cols);$_.colsadd1=$_.cols+1;for(var _cu=0,_ct=$_.cols-1;_cu<=_ct;_cu+=1){$_.i=_cu;$k[$j++]=Infinity;var _cw=$_.cols;$k[$j++]=0;$k[$j++]=0;for(var _cy=$_.i,_cz=_cw,_cx=_cw*_cw-1;_cz<0?_cy>=_cx:_cy<=_cx;_cy+=_cz){var _d1=$g($_.sym,_cy);var _d2=$k[--$j];$k[$j++]=_d1;if($eq(_d2,_d1)){var _d3=$k[--$j];var _d4=$k[--$j];$k[$j++]=_d4+1;$k[$j++]=_d3}else{var _d5=$k[--$j];$k[$j++]=1;$k[$j++]=_d5}}$j--;var _d7=$m()+2;$as($G($_.rle,0,_d7-2));$_.evalfulln1n3();$_.n3=$f($k[--$j]+$_.n3);$_.n1=$f($k[--$j]+$_.n1);$j--;$_.symrow=$G($_.sym,$_.i*$_.cols,$_.cols);$k[$j++]=Infinity;var _dI=$_.symrow;$k[$j++]=0;$k[$j++]=0;for(var _dJ=0,_dK=_dI.length;_dJ<_dK;_dJ++){var _dL=$g(_dI,_dJ);var _dM=$k[--$j];$k[$j++]=_dL;if($eq(_dM,_dL)){var _dN=$k[--$j];var _dO=$k[--$j];$k[$j++]=_dO+1;$k[$j++]=_dN}else{var _dP=$k[--$j];$k[$j++]=1;$k[$j++]=_dP}}$j--;var _dR=$m()+2;$as($G($_.rle,0,_dR-2));$_.evalfulln1n3();$_.n3=$f($k[--$j]+$_.n3);$_.n1=$f($k[--$j]+$_.n1);$j--;var _dX=$_.thispairs;$_.thispairs=$_.lastpairs;$_.lastpairs=_dX;var _db=$g($_.symrow,0)==1?0:1;var _dc=$_.symrow;$k[$j++]=_db;for(var _dd=0,_de=_dc.length;_dd<_de;_dd++){var _df=$g(_dc,_dd);var _dg=$k[--$j];$k[$j++]=$f(_dg+_df);$k[$j++]=_df}$j--;$as($_.thispairs);$j--;if($_.i>0){$k[$j++]=Infinity;$q($_.lastpairs);$q($_.thispairs);$k[$j++]=$_.n2;for(var _dn=0,_do=$_.cols;_dn<_do;_dn++){var _dp=$k[--$j];var _dq=$k[--$j];$k[$j++]=_dp;$k[$j++]=_dq;var _ds=$k[$j-1-$_.colsadd1];if(($f($k[--$j]+_ds)&3)==0){var _du=$k[--$j];$k[$j++]=_du+3}}$_.n2=$k[--$j];$l()}}$k[$j++]="dark";$k[$j++]=0;$F($_.sym,function(){var _dx=$k[--$j];var _dy=$k[--$j];$k[$j++]=$f(_dy+_dx)});var _dz=$k[--$j];$_[$k[--$j]]=_dz;var _e2=$_.cols;$_.n4=~~($abs($_.dark*100/(_e2*_e2)-50)/5)*10;$k[$j++]=$f($_.n1+$_.n2+$_.n3+$_.n4)};$_.evalmicro=function(){$_.sym=$k[--$j];$_.dkrhs=0;$_.dkbot=0;for(var _eA=1,_e9=$_.cols-1;_eA<=_e9;_eA+=1){$_.i=_eA;$k[$j++]="dkrhs";$k[$j++]=$_.dkrhs;$k[$j++]=$_.sym;$k[$j++]=$_.cols-1;$k[$j++]=$_.i;$_.qmv();var _eF=$k[--$j];var _eH=$g($k[--$j],_eF);var _eI=$k[--$j];$_[$k[--$j]]=$f(_eI+_eH);$k[$j++]="dkbot";$k[$j++]=$_.dkbot;$k[$j++]=$_.sym;$k[$j++]=$_.i;$k[$j++]=$_.cols-1;$_.qmv();var _eO=$k[--$j];var _eQ=$g($k[--$j],_eO);var _eR=$k[--$j];$_[$k[--$j]]=$f(_eR+_eQ)}if($_.dkrhs<=$_.dkbot){$k[$j++]=-($_.dkrhs*16+$_.dkbot)}else{$k[$j++]=-($_.dkbot*16+$_.dkrhs)}};$_.bestscore=999999999;for(var _eb=0,_ea=$_.masks.length-1;_eb<=_ea;_eb+=1){$_.m=_eb;$_.masksym=$a($_.rows*$_.cols);for(var _ei=0,_eh=$_.rows*$_.cols-1;_ei<=_eh;_ei+=1){$_.i=_ei;$p($_.masksym,$_.i,$xo($g($_.pixs,$_.i),$g($g($_.masks,$_.m),$_.i)))}if($_.masks.length!=1){if($eq($_.format,"full")){$k[$j++]=$_.masksym;$_.evalfull();$_.score=$k[--$j]}else{$k[$j++]=$_.masksym;$_.evalmicro();$_.score=$k[--$j]}if($_.score<$_.bestscore){$_.bestsym=$_.masksym;$_.bestmaskval=$_.m;$_.bestscore=$_.score}}else{$_.bestsym=$_.masksym}}$_.pixs=$_.bestsym;if($eq($_.format,"full")){$k[$j++]=$_.pixs;$k[$j++]=8;$k[$j++]=$_.cols-8;$_.qmv();var _f9=$k[--$j];$p($k[--$j],_f9,1)}$_.fmtvalsfull=$a([21522,20773,24188,23371,17913,16590,20375,19104,30660,29427,32170,30877,26159,25368,27713,26998,5769,5054,7399,6608,1890,597,3340,2107,13663,12392,16177,14854,9396,8579,11994,11245]);$_.fmtvalsmicro=$a([17477,16754,20011,19228,21934,20633,24512,23287,26515,25252,28157,26826,30328,29519,31766,31009,1758,1001,3248,2439,5941,4610,7515,6252,9480,8255,12134,10833,13539,12756,16013,15290]);$_.fmtvalsrmqr1=$a([129714,124311,121821,115960,112748,108361,104707,99878,98062,90155,89697,82244,81360,74485,72895,66458,61898,61167,53413,53120,45844,44081,37499,36190,29814,27475,21785,19004,13992,10637,6087,2274,258919,257090,250376,249133,242105,241308,233686,233459,227035,223742,219060,215185,209925,207648,202090,199247,194591,190266,186736,181845,178881,173540,170926,165003,163235,156294,154828,148457,147325,139352,138770,131383]);$_.fmtvalsrmqr2=$a([133755,136542,142100,144433,149669,153472,158154,161519,167879,168162,175784,176525,183577,184892,191606,193363,196867,204326,204908,212809,213981,220408,221874,228759,230591,236442,239056,244469,247393,252228,255758,260139,942,7307,8897,15844,16752,24149,24607,32570,34322,39223,42877,47192,50380,56297,58787,64134,67798,71667,76217,79516,84488,87341,93031,95298,101738,102991,109573,111392,118708,118929,126683,127486]);if($eq($_.format,"full")){$_.ecid=$g($a([1,0,3,2]),$_.eclval);$_.fmtval=$g($_.fmtvalsfull,($_.ecid<<3)+$_.bestmaskval);for(var _fQ=0,_fP=$_.formatmap.length-1;_fQ<=_fP;_fQ+=1){$_.i=_fQ;$F($g($_.formatmap,$_.i),function(){var _fV=$k[--$j];$k[$j++]=$_.pixs;$q(_fV);$_.qmv();var _fW=$_.fmtval;var _fY=-(14-$_.i);var _fZ=$k[--$j];$p($k[--$j],_fZ,(_fY<0?_fW>>>-_fY:_fW<<_fY)&1)})}}if($eq($_.format,"micro")){$_.symid=$g($g($a([$a([0]),$a([1,2]),$a([3,4]),$a([5,6,7])]),~~(($_.cols-11)/2)),$_.eclval);$_.fmtval=$g($_.fmtvalsmicro,($_.symid<<2)+$_.bestmaskval);for(var _fr=0,_fq=$_.formatmap.length-1;_fr<=_fq;_fr+=1){$_.i=_fr;$k[$j++]=$_.pixs;$q($g($g($_.formatmap,$_.i),0));$_.qmv();var _fx=$_.fmtval;var _fz=-(14-$_.i);var _g0=$k[--$j];$p($k[--$j],_g0,(_fz<0?_fx>>>-_fz:_fx<<_fz)&1)}}if($eq($_.format,"rmqr")){$_.fmtvalu=($g($a([-1,0,-1,1]),$_.eclval)<<5)+$_.verind;$_.fmtval1=$g($_.fmtvalsrmqr1,$_.fmtvalu);$_.fmtval2=$g($_.fmtvalsrmqr2,$_.fmtvalu);for(var _gF=0,_gE=$_.formatmap.length-1;_gF<=_gE;_gF+=1){$_.i=_gF;$k[$j++]=$_.pixs;$q($g($g($_.formatmap,$_.i),0));$_.qmv();var _gL=$_.fmtval1;var _gN=-(17-$_.i);var _gO=$k[--$j];$p($k[--$j],_gO,(_gN<0?_gL>>>-_gN:_gL<<_gN)&1);$k[$j++]=$_.pixs;$q($g($g($_.formatmap,$_.i),1));$_.qmv();var _gV=$_.fmtval2;var _gX=-(17-$_.i);var _gY=$k[--$j];$p($k[--$j],_gY,(_gX<0?_gV>>>-_gX:_gV<<_gX)&1)}}$_.vervals=$a([31892,34236,39577,42195,48118,51042,55367,58893,63784,68472,70749,76311,79154,84390,87683,92361,96236,102084,102881,110507,110734,117786,119615,126325,127568,133589,136944,141498,145311,150283,152622,158308,161089,167017]);if($eq($_.format,"full")&&$_.cols>=45){$_.verval=$g($_.vervals,~~(($_.cols-17)/4)-7);for(var _gj=0,_gi=$_.versionmap.length-1;_gj<=_gi;_gj+=1){$_.i=_gj;$F($g($_.versionmap,$_.i),function(){var _go=$k[--$j];$k[$j++]=$_.pixs;$F(_go);$_.qmv();var _gp=$_.verval;var _gr=-(17-$_.i);var _gs=$k[--$j];$p($k[--$j],_gs,(_gr<0?_gp>>>-_gr:_gp<<_gr)&1)})}}$k[$j++]=Infinity;$k[$j++]="ren";$k[$j++]="renmatrix";$k[$j++]="pixs";$k[$j++]=$_.pixs;$k[$j++]="pixx";$k[$j++]=$_.cols;$k[$j++]="pixy";$k[$j++]=$_.rows;$k[$j++]="height";$k[$j++]=$_.rows*2/72;$k[$j++]="width";$k[$j++]=$_.cols*2/72;$k[$j++]="borderleft";if($eq($_.format,"full")){$k[$j++]=4}else{$k[$j++]=2}$k[$j++]="borderright";if($eq($_.format,"full")){$k[$j++]=4}else{$k[$j++]=2}$k[$j++]="bordertop";if($eq($_.format,"full")){$k[$j++]=4}else{$k[$j++]=2}$k[$j++]="borderbottom";if($eq($_.format,"full")){$k[$j++]=4}else{$k[$j++]=2}$k[$j++]="opt";$k[$j++]=$_.options;var _h4=$d();$k[$j++]=_h4;if(!$_.dontdraw){bwipp_renmatrix()}$_=$__}function bwipp_swissqrcode(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.parse=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];var _3=new Map([["parse",$_.parse],["parseonly",true],["parsefnc",false]]);$_.fncvals=_3;$k[$j++]="barcode";$k[$j++]=$_.barcode;$k[$j++]=$_.fncvals;bwipp_parseinput();var _6=$k[--$j];$_[$k[--$j]]=_6;$_.barlen=$_.barcode.length;delete $_.options["parse"];if($_.barcode.length>997){$k[$j++]="bwipp.swissqrcodeBadLength#22347";$k[$j++]="Swiss QR Code input must not exceed 997 digits";bwipp_raiseerror()}$p($_.options,"dontdraw",true);$k[$j++]="args";$k[$j++]=$_.barcode;$k[$j++]=$_.options;bwipp_qrcode();var _E=$k[--$j];$_[$k[--$j]]=_E;$p($_.args,"opt",$_.options);$k[$j++]=$_.args;if(!$_.dontdraw){$$.save();var _K=$$.currpos();$$.translate(_K.x,_K.y);var _L=72/25.4;$$.scale(_L,_L);$$.save();$$.newpath();$$.moveto(0,0);$$.lineto(46,0);$$.lineto(46,46);$$.lineto(0,46);$$.closepath();$$.moveto(19.5,19.5);$$.lineto(19.5,26.5);$$.lineto(26.5,26.5);$$.lineto(26.5,19.5);$$.closepath();$$.clip();$$.save();$$.moveto(0,0);var _O=46/$g($_.args,"pixx")/2;$$.scale(_O,_O);bwipp_renmatrix();$$.restore();$$.restore();$$.translate(19.5,19.5);var _P=7/83;$$.scale(_P,_P);$$.newpath();$$.moveto(6,6);$$.lineto(6,77);$$.lineto(77,77);$$.lineto(77,6);$$.closepath();$$.moveto(49,18);$$.lineto(49,34);$$.lineto(65,34);$$.lineto(65,49);$$.lineto(49,49);$$.lineto(49,65);$$.lineto(34,65);$$.lineto(34,49);$$.lineto(18,49);$$.lineto(18,34);$$.lineto(34,34);$$.lineto(34,18);$$.closepath();$$.setrgbcolor(0,0,0);$$.fill();$$.restore()}$_=$__}function bwipp_microqrcode(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];$p($_.options,"dontdraw",true);$p($_.options,"format","micro");$k[$j++]="args";$k[$j++]=$_.barcode;$k[$j++]=$_.options;bwipp_qrcode();var _6=$k[--$j];$_[$k[--$j]]=_6;$p($_.args,"opt",$_.options);$k[$j++]=$_.args;if(!$_.dontdraw){bwipp_renmatrix()}$_=$__}function bwipp_rectangularmicroqrcode(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];$p($_.options,"dontdraw",true);$p($_.options,"format","rmqr");$k[$j++]="args";$k[$j++]=$_.barcode;$k[$j++]=$_.options;bwipp_qrcode();var _6=$k[--$j];$_[$k[--$j]]=_6;$p($_.args,"opt",$_.options);$k[$j++]=$_.args;if(!$_.dontdraw){bwipp_renmatrix()}$_=$__}function bwipp_maxicode(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.mode=-1;$_.sam=-1;$_.parse=false;$_.parsefnc=false;$_.legacyencoder=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.barcode.length==0){$k[$j++]="bwipp.maxicodeEmptyData#22566";$k[$j++]="The data must not be empty";bwipp_raiseerror()}if($_.mode!=-1&&($_.mode<2||$_.mode>6)){$k[$j++]="bwipp.maxicodeBadMode#22570";$k[$j++]="Mode must be 2 to 6";bwipp_raiseerror()}if($_.sam!=-1){$k[$j++]=true;for(var _7=0;_7<1;_7++){var _8=$_.sam;if(_8<12||_8>88){$k[$j-1]=false;break}var _A=$_.sam%10;if(_A<2||_A>8){$k[$j-1]=false;break}if(~~($_.sam/10)>$_.sam%10){$k[$j-1]=false;break}}if(!$k[--$j]){$k[$j++]="bwipp.maxicodeBadSAM#22581";$k[$j++]='SAM must be formatted as "NM" for Nth of M symbols, from 2 to 8 symbols';bwipp_raiseerror()}}$_.encoding="new";if($_.legacyencoder){$_.encoding="legacy"}var _H=new Map([["parse",$_.parse],["parsefnc",$_.parsefnc],["eci",true]]);$_.fncvals=_H;$k[$j++]="msg";$k[$j++]=$_.barcode;$k[$j++]=$_.fncvals;bwipp_parseinput();var _K=$k[--$j];$_[$k[--$j]]=_K;$_.msglen=$_.msg.length;if($_.mode==2||$_.mode==3){$_.barcode=$s($_.msglen);$_.barlen=$_.msglen;for(var _U=0,_T=$_.msglen-1;_U<=_T;_U+=1){$_.i=_U;if($g($_.msg,$_.i)<0){$_.barlen=$_.i;break}$p($_.barcode,$_.i,$g($_.msg,$_.i))}$_.difflen=$_.msglen-$_.barlen;$_.fid="";if($_.barlen>=9){var _h=$_.barcode;var _j=$g(_h,7);var _k=$g(_h,8);if($eq($G(_h,0,7),"[)>01")&&(_j>=48&&_j<=57&&(_k>=48&&_k<=57))){$_.fid=$G($_.barcode,0,9);$_.barcode=$G($_.barcode,9,$_.barlen-9)}}$X($_.barcode,"");if($k[--$j]){$_.pcode=$k[--$j];$j--;if($_.mode==2){$k[$j++]=true;for(var _u=0;_u<1;_u++){var _w=$_.pcode.length;if(_w>9||_w==0){$k[$j-1]=false;break}$F($_.pcode,function(){var _y=$k[--$j];if(_y<48||_y>57){$k[$j-1]=false;return true}})}if(!$k[--$j]){$j--;$k[$j++]="bwipp.maxicodeBadMode2PostCode#22635";$k[$j++]="A mode 2 postcode must not be empty or exceed 9 digits";bwipp_raiseerror()}}else{$k[$j++]=true;for(var _10=0;_10<1;_10++){var _12=$_.pcode.length;if(_12>6||_12==0){$k[$j-1]=false;break}$F($_.pcode,function(){var _14=$k[--$j];if(!(_14==32||(_14>=34&&_14<=58||_14>=65&&_14<=90))){$k[$j-1]=false;return true}})}if(!$k[--$j]){$j--;$k[$j++]="bwipp.maxicodeBadMode3PostCode#22649";$k[$j++]="A mode 3 postcode must not be empty or exceed 6 characters";bwipp_raiseerror()}}}else{$j--;$k[$j++]="bwipp.maxicodeExpectedPostCode#22653";$k[$j++]="Expected postcode followed by group separator character";bwipp_raiseerror()}$X($k[--$j],"");if($k[--$j]){$_.ccode=$k[--$j];$k[$j-1]=true;for(var _19=0;_19<1;_19++){if($_.ccode.length!=3){$k[$j-1]=false;break}$F($_.ccode,function(){var _1C=$k[--$j];if(_1C<48||_1C>57){$k[$j-1]=false;return true}})}if(!$k[--$j]){$j--;$k[$j++]="bwipp.maxicodeBadCountryCode#22663";$k[$j++]="Country code must be three digits";bwipp_raiseerror()}}else{$j--;$k[$j++]="bwipp.maxicodeExpectedCountryCode#22666";$k[$j++]="Expected country code followed by group separator character";bwipp_raiseerror()}$X($k[--$j],"");if($k[--$j]){$_.scode=$k[--$j];$k[$j-1]=true;for(var _1H=0;_1H<1;_1H++){if($_.scode.length!=3){$k[$j-1]=false;break}$F($_.scode,function(){var _1K=$k[--$j];if(_1K<48||_1K>57){$k[$j-1]=false;return true}})}if(!$k[--$j]){$j--;$k[$j++]="bwipp.maxicodeBadServiceClass#22676";$k[$j++]="Service class must be three digits";bwipp_raiseerror()}}else{$j--;$k[$j++]="bwipp.maxicodeExpectedServiceClass#22679";$k[$j++]="Expected service class followed by group separator character";bwipp_raiseerror()}$_.barcode=$k[--$j];var _1P=$s($_.barcode.length+$_.fid.length);$P(_1P,0,$_.fid);$P(_1P,$_.fid.length,$_.barcode);$_.barcode=_1P;$_.barlen=$_.barcode.length;$k[$j++]=Infinity;var _1U=$_.barcode;for(var _1V=0,_1W=_1U.length;_1V<_1W;_1V++){$k[$j++]=$g(_1U,_1V)}$q($G($_.msg,$_.msglen-$_.difflen,$_.difflen));$_.msg=$a();$_.msglen=$_.msg.length}$_.eci=-1;$_.pad=-2;$_.ns=-3;$_.la=-4;$_.lb=-5;$_.sa=-6;$_.sb=-7;$_.sc=-8;$_.sd=-9;$_.se=-10;$_.sa2=-11;$_.sa3=-12;$_.lkc=-13;$_.lkd=-14;$_.lke=-15;$_.pd2=-16;$_.pd3=-17;$_.charmaps=$a([$a([13,"`",192,224,0]),$a(["A","a",193,225,1]),$a(["B","b",194,226,2]),$a(["C","c",195,227,3]),$a(["D","d",196,228,4]),$a(["E","e",197,229,5]),$a(["F","f",198,230,6]),$a(["G","g",199,231,7]),$a(["H","h",200,232,8]),$a(["I","i",201,233,9]),$a(["J","j",202,234,10]),$a(["K","k",203,235,11]),$a(["L","l",204,236,12]),$a(["M","m",205,237,13]),$a(["N","n",206,238,14]),$a(["O","o",207,239,15]),$a(["P","p",208,240,16]),$a(["Q","q",209,241,17]),$a(["R","r",210,242,18]),$a(["S","s",211,243,19]),$a(["T","t",212,244,20]),$a(["U","u",213,245,21]),$a(["V","v",214,246,22]),$a(["W","w",215,247,23]),$a(["X","x",216,248,24]),$a(["Y","y",217,249,25]),$a(["Z","z",218,250,26]),$a([$_.eci,$_.eci,$_.eci,$_.eci,$_.eci]),$a([28,28,28,28,$_.pad]),$a([29,29,29,29,$_.pd2]),$a([30,30,30,30,27]),$a([$_.ns,$_.ns,$_.ns,$_.ns,$_.ns]),$a([" ","{",219,251,28]),$a([$_.pad,$_.pad,220,252,29]),$a(['"',"}",221,253,30]),$a(["#","~",222,254,31]),$a(["$",127,223,255,159]),$a(["%",";",170,161,160]),$a(["&","<",172,168,162]),$a(["'","=",177,171,163]),$a([40,">",178,175,164]),$a([41,"?",179,176,165]),$a(["*","[",181,180,166]),$a(["+",92,185,183,167]),$a([",","]",186,184,169]),$a(["-","^",188,187,173]),$a([".","_",189,191,174]),$a(["/"," ",190,138,182]),$a(["0",",",128,139,149]),$a(["1",".",129,140,150]),$a(["2","/",130,141,151]),$a(["3",":",131,142,152]),$a(["4","@",132,143,153]),$a(["5","!",133,144,154]),$a(["6","|",134,145,155]),$a(["7",$_.pd2,135,146,156]),$a(["8",$_.sa2,136,147,157]),$a(["9",$_.sa3,137,148,158]),$a([":",$_.pd3,$_.la,$_.la,$_.la]),$a([$_.sb,$_.sa," "," "," "]),$a([$_.sc,$_.sc,$_.lkc,$_.sc,$_.sc]),$a([$_.sd,$_.sd,$_.sd,$_.lkd,$_.sd]),$a([$_.se,$_.se,$_.se,$_.se,$_.lke]),$a([$_.lb,$_.la,$_.lb,$_.lb,$_.lb])]);$_.charvals=$a([new Map,new Map,new Map,new Map,new Map]);for(var _3S=0,_3R=$_.charmaps.length-1;_3S<=_3R;_3S+=1){$_.i=_3S;$_.encs=$g($_.charmaps,$_.i);for(var _3W=0;_3W<=4;_3W+=1){$_.j=_3W;var _3Z=$g($_.encs,$_.j);$k[$j++]=_3Z;if($eq($t(_3Z),"stringtype")){var _3c=$g($k[--$j],0);$k[$j++]=_3c}$p($g($_.charvals,$_.j),$k[--$j],$_.i)}}$_.seta=$g($_.charvals,0);$_.setb=$g($_.charvals,1);$_.setc=$g($_.charvals,2);$_.setd=$g($_.charvals,3);$_.sete=$g($_.charvals,4);$k[$j++]="maxlen";if($_.mode==5){$k[$j++]=77}else{var _3v=$_.mode<=3?84:93;$k[$j++]=_3v}var _3w=$k[--$j];$_[$k[--$j]]=_3w;if($eq($_.encoding,"legacy")){$k[$j++]=Infinity;for(var _40=0,_41=$_.msglen+1;_40<_41;_40++){$k[$j++]=0}$_.nseq=$a();for(var _44=$_.msglen-1;_44>=0;_44-=1){$_.i=_44;var _47=$g($_.msg,$_.i);if(_47>=48&&_47<=57){$p($_.nseq,$_.i,$g($_.nseq,$_.i+1)+1)}else{$p($_.nseq,$_.i,0)}}$_.nseq=$G($_.nseq,0,$_.msglen);$_.prefixinset=function(){$k[$j++]=0;for(;;){var _4I=$k[$j-1];var _4J=$k[$j-2];if(_4I>=_4J.length){break}var _4K=$k[$j-1];var _4L=$k[$j-2];var _4N=$k[$j-3];var _4O=$g(_4N,$g(_4L,_4K))!==undefined;if(_4O){var _4P=$k[--$j];$k[$j++]=_4P+1}else{break}}var _4Q=$k[--$j];$k[$j-1]=_4Q;var _4S=$k[--$j];$k[$j-1]=_4S};$_.enc=function(){var _4U=$k[--$j];$p($_.out,$_.j,$g(_4U,$k[--$j]));$_.j=$_.j+1};$_.out=$a(144);$_.i=0;$_.j=0;$_.cset="seta";for(;;){if($_.i==$_.msglen){if($ne($_.cset,"seta")&&$ne($_.cset,"setb")&&$_.out.length<$_.maxlen){$k[$j++]=$_.la;$k[$j++]=$_[$_.cset];$_.enc();$_.cset="seta"}break}for(;;){if($g($_.msg,$_.i)<=-1e6){$k[$j++]=$_.eci;$k[$j++]=$_[$_.cset];$_.enc();var _4t=-$g($_.msg,$_.i)-1e6;$k[$j++]=_4t;if(_4t<=31){var _4u=$k[--$j];$k[$j++]=_4u&63;$as($a(1))}else{var _4w=$k[$j-1];if(_4w<=1023){var _4x=$k[--$j];$k[$j++]=_4x>>>6&31|32;$k[$j++]=_4x&63;$as($a(2))}else{var _4z=$k[$j-1];if(_4z<=32767){var _50=$k[--$j];$k[$j++]=_50>>>12&47|48;$k[$j++]=_50>>>6&63;$k[$j++]=_50&63;$as($a(3))}else{var _52=$k[--$j];$k[$j++]=_52>>>18&55|56;$k[$j++]=_52>>>12&63;$k[$j++]=_52>>>6&63;$k[$j++]=_52&63;$as($a(4))}}}var _54=$k[--$j];$P($_.out,$_.j,_54);$_.j=_54.length+$_.j;$_.i=$_.i+1;break}if($g($_.nseq,$_.i)>=9){var _5E=$G($_.msg,$_.i,9);$k[$j++]=0;for(var _5F=0,_5G=_5E.length;_5F<_5G;_5F++){var _5I=$k[--$j];$k[$j++]=$f(_5I+($g(_5E,_5F)-48))*10}var _5J=$k[--$j];$k[$j++]=~~(_5J/10);for(var _5K=0;_5K<4;_5K++){var _5L=$k[--$j];$k[$j++]=_5L&63;$k[$j++]=_5L>>>6}$k[$j++]=$g($_[$_.cset],$_.ns);for(var _5Q=0;_5Q<=10;_5Q+=2){var _5R=$k[$j-1-_5Q];$k[$j++]=_5R}$as($a(6));$r(7,1);for(var _5T=0;_5T<6;_5T++){$j--}$P($_.out,$_.j,$k[--$j]);$_.i=$_.i+9;$_.j=$_.j+6;break}$_.char1=$g($_.msg,$_.i);$k[$j++]="char2";if($_.i+1<$_.msglen){$k[$j++]=$g($_.msg,$_.i+1)}else{$k[$j++]=-99}var _5h=$k[--$j];$_[$k[--$j]]=_5h;$k[$j++]="char3";if($_.i+2<$_.msglen){$k[$j++]=$g($_.msg,$_.i+2)}else{$k[$j++]=-99}var _5o=$k[--$j];$_[$k[--$j]]=_5o;var _5t=$g($_[$_.cset],$_.char1)!==undefined;if(_5t){$k[$j++]=$_.char1;$k[$j++]=$_[$_.cset];$_.enc();$_.i=$_.i+1;break}var _61=$g($_.setb,$_.char1)!==undefined;if($eq($_.cset,"seta")&&_61){var _64=$g($_.setb,$_.char2)!==undefined;if(_64){$k[$j++]=$_.lb;$k[$j++]=$_.seta;$_.enc();$_.cset="setb"}else{$k[$j++]=$_.sb;$k[$j++]=$_.seta;$_.enc();$k[$j++]=$_.char1;$k[$j++]=$_.setb;$_.enc();$_.i=$_.i+1}break}var _6F=$g($_.seta,$_.char1)!==undefined;if($eq($_.cset,"setb")&&_6F){var _6G=$_.seta;var _6H=$_.msg;var _6I=$_.i;var _6J=$_.msglen;var _6K=$_.i;var _6L=_6J-_6K;var _6M=4;if(4>_6J-_6K){var _=_6L;_6L=_6M;_6M=_}$k[$j++]="p";$k[$j++]=_6G;$k[$j++]=$G(_6H,_6I,_6M);$_.prefixinset();var _6O=$k[--$j];$_[$k[--$j]]=_6O;if($_.p==1){$k[$j++]=$_.sa;$k[$j++]=$_.setb;$_.enc();$k[$j++]=$_.char1;$k[$j++]=$_.seta;$_.enc();$_.i=$_.i+1}if($_.p==2){$k[$j++]=$_.sa2;$k[$j++]=$_.setb;$_.enc();$k[$j++]=$_.char1;$k[$j++]=$_.seta;$_.enc();$k[$j++]=$_.char2;$k[$j++]=$_.seta;$_.enc();$_.i=$_.i+2}if($_.p==3){$k[$j++]=$_.sa3;$k[$j++]=$_.setb;$_.enc();$k[$j++]=$_.char1;$k[$j++]=$_.seta;$_.enc();$k[$j++]=$_.char2;$k[$j++]=$_.seta;$_.enc();$k[$j++]=$_.char3;$k[$j++]=$_.seta;$_.enc();$_.i=$_.i+3}if($_.p>=4){$k[$j++]=$_.la;$k[$j++]=$_.setb;$_.enc();$_.cset="seta"}break}var _6t=$g($_.seta,$_.char1)!==undefined;if(_6t){$k[$j++]=$_.la;$k[$j++]=$_[$_.cset];$_.enc();$_.cset="seta";break}var _6z=$g($_.setb,$_.char1)!==undefined;if(_6z){$k[$j++]=$_.lb;$k[$j++]=$_[$_.cset];$_.enc();$_.cset="setb";break}var _75=$g($_.setc,$_.char1)!==undefined;if(_75){$_.setx="setc";$_.sx=$_.sc;$_.lkx=$_.lkc}var _7A=$g($_.setd,$_.char1)!==undefined;if(_7A){$_.setx="setd";$_.sx=$_.sd;$_.lkx=$_.lkd}var _7F=$g($_.sete,$_.char1)!==undefined;if(_7F){$_.setx="sete";$_.sx=$_.se;$_.lkx=$_.lke}var _7J=$_[$_.setx];var _7K=$_.msg;var _7L=$_.i;var _7M=$_.msglen;var _7N=$_.i;var _7O=_7M-_7N;var _7P=4;if(4>_7M-_7N){var _=_7O;_7O=_7P;_7P=_}$k[$j++]="p";$k[$j++]=_7J;$k[$j++]=$G(_7K,_7L,_7P);$_.prefixinset();var _7R=$k[--$j];$_[$k[--$j]]=_7R;if($_.p==1){$k[$j++]=$_.sx;$k[$j++]=$_[$_.cset];$_.enc();$k[$j++]=$_.char1;$k[$j++]=$_[$_.setx];$_.enc();$_.i=$_.i+1}if($_.p==2){$k[$j++]=$_.sx;$k[$j++]=$_[$_.cset];$_.enc();$k[$j++]=$_.char1;$k[$j++]=$_[$_.setx];$_.enc();$k[$j++]=$_.sx;$k[$j++]=$_[$_.cset];$_.enc();$k[$j++]=$_.char2;$k[$j++]=$_[$_.setx];$_.enc();$_.i=$_.i+2}if($_.p==3){$k[$j++]=$_.sx;$k[$j++]=$_[$_.cset];$_.enc();$k[$j++]=$_.char1;$k[$j++]=$_[$_.setx];$_.enc();$k[$j++]=$_.sx;$k[$j++]=$_[$_.cset];$_.enc();$k[$j++]=$_.char2;$k[$j++]=$_[$_.setx];$_.enc();$k[$j++]=$_.sx;$k[$j++]=$_[$_.cset];$_.enc();$k[$j++]=$_.char3;$k[$j++]=$_[$_.setx];$_.enc();$_.i=$_.i+3}if($_.p>=4){$k[$j++]=$_.sx;$k[$j++]=$_[$_.cset];$_.enc();$k[$j++]=$_.lkx;$k[$j++]=$_[$_.setx];$_.enc();$_.cset=$_.setx}break}}$_.encmsg=$G($_.out,0,$_.j);$_.padval=$g($_[$_.cset],$_.pad)}if($eq($_.encoding,"new")){$_.haveb=false;$_.havec=false;$_.haved=false;$_.havee=false;$_.havei=false;for(var _8R=0,_8Q=$_.msglen-1;_8R<=_8Q;_8R+=1){$_.c=$g($_.msg,_8R);if($_.c<=-1e6){$_.havei=true}else{if(($_.c<28||$_.c>30)&&$_.c!=32){var _8a=$g($_.setb,$_.c)!==undefined;if(_8a){$_.haveb=true}var _8d=$g($_.setc,$_.c)!==undefined;if(_8d){$_.havec=true}var _8g=$g($_.setd,$_.c)!==undefined;if(_8g){$_.haved=true}var _8j=$g($_.sete,$_.c)!==undefined;if(_8j){$_.havee=true}}}}$k[$j++]=Infinity;$k[$j++]=0;if($_.haveb){$k[$j++]=1}if($_.havee){$k[$j++]=4}if($_.havec){$k[$j++]=2}if($_.haved){$k[$j++]=3}$_.priority=$a();$_.priority_rest=$G($_.priority,1,$_.priority.length-1);$_.latch_sequence=$a([$a([$a([]),$a([63]),$a([58]),$a([58]),$a([58])]),$a([$a([63]),$a([]),$a([63]),$a([63]),$a([63])]),$a([$a([60,60]),$a([60,60]),$a([]),$a([60,60]),$a([60,60])]),$a([$a([61,61]),$a([61,61]),$a([61,61]),$a([]),$a([61,61])]),$a([$a([62,62]),$a([62,62]),$a([62,62]),$a([62,62]),$a([])])]);$_.latch_length=$a([$a([0,1,1,1,1]),$a([1,0,1,1,1]),$a([2,2,0,2,2]),$a([2,2,2,0,2]),$a([2,2,2,2,0])]);$_.max_int=2147483647;$k[$j++]=Infinity;for(var _9T=0;_9T<16;_9T++){$k[$j++]=$a([0,0,0,0,0])}$_.best_length=$a();$k[$j++]=Infinity;for(var _9W=0;_9W<16;_9W++){$k[$j++]=$a([0,0,0,0,0])}$_.best_origin=$a();$k[$j++]=Infinity;for(var _9a=0,_9b=$_.msglen;_9a<_9b;_9a++){$k[$j++]=Infinity;for(var _9c=0;_9c<5;_9c++){$k[$j++]=0}var _9d=$a();$k[$j++]=_9d}$_.prior_code_set=$a();$k[$j++]=Infinity;for(var _9g=0,_9h=$_.msglen;_9g<_9h;_9g++){$k[$j++]=Infinity;for(var _9i=0;_9i<5;_9i++){$k[$j++]=0}var _9j=$a();$k[$j++]=_9j}$_.path_op=$a();$_.out_eci=function(){var _9m=-$_.c-1e6;$k[$j++]=_9m;if(_9m<1024){var _9o=$k[--$j]<32?2:3;$k[$j++]=_9o}else{var _9q=$k[--$j]<32768?4:5;$k[$j++]=_9q}};$_.enc_eci=function(){var _9s=-$_.c-1e6;$k[$j++]=_9s;if(_9s>=32){var _9t=$k[$j-1];if(_9t<1024){var _9u=$k[--$j];$k[$j++]=_9u>>>6|32;$k[$j++]=_9u&63}else{var _9v=$k[$j-1];if(_9v<32768){var _9w=$k[--$j];$k[$j++]=_9w>>>12|48;$k[$j++]=_9w>>>6&63;$k[$j++]=_9w&63}else{var _9x=$k[--$j];$k[$j++]=_9x>>>18|56;$k[$j++]=_9x>>>12&63;$k[$j++]=_9x>>>6&63;$k[$j++]=_9x&63}}}};$_.enc_ns=function(){var _A0=$G($_.msg,$_.n,9);$k[$j++]=0;for(var _A1=0,_A2=_A0.length;_A1<_A2;_A1++){var _A4=$k[--$j];$k[$j++]=$f($g(_A0,_A1)-48+_A4*10)}var _A5=$k[--$j];$k[$j++]=_A5>>>24;$k[$j++]=_A5>>>18&63;$k[$j++]=_A5>>>12&63;$k[$j++]=_A5>>>6&63;$k[$j++]=_A5&63};$_.enc_sha2=function(){$k[$j++]=$g($_.seta,$_.c);$k[$j++]=$g($_.seta,$g($_.msg,$_.n+1))};$_.enc_sha3=function(){$k[$j++]=$g($_.seta,$_.c);$k[$j++]=$g($_.seta,$g($_.msg,$_.n+1));$k[$j++]=$g($_.seta,$g($_.msg,$_.n+2))};$k[$j++]=Infinity;if($_.havei){var _AT=new Map([["can",function(){$k[$j++]=$_.c<=-1e6}],["intake",1],["output",function(){$_.out_eci()}],["sets",31],["enc",function(){$k[$j++]=27;$_.enc_eci()}]]);$k[$j++]=_AT}var _AV=new Map([["can",function(){$k[$j++]=$_.digits>=9}],["intake",9],["output",function(){$k[$j++]=6}],["sets",31],["enc",function(){$k[$j++]=31;$_.enc_ns()}]]);var _Ac=new Map([["can",function(){var _AY=$g($_.seta,$_.c)!==undefined;$k[$j++]=_AY}],["intake",1],["output",function(){$k[$j++]=1}],["sets",1],["enc",function(){$k[$j++]=$g($_.seta,$_.c)}]]);$k[$j++]=_AV;$k[$j++]=_Ac;if($_.haveb){var _Ak=new Map([["can",function(){var _Ag=$g($_.setb,$_.c)!==undefined;$k[$j++]=_Ag}],["intake",1],["output",function(){$k[$j++]=1}],["sets",2],["enc",function(){$k[$j++]=$g($_.setb,$_.c)}]]);$k[$j++]=_Ak}if($_.havec){var _As=new Map([["can",function(){var _Ao=$g($_.setc,$_.c)!==undefined;$k[$j++]=_Ao}],["intake",1],["output",function(){$k[$j++]=1}],["sets",4],["enc",function(){$k[$j++]=$g($_.setc,$_.c)}]]);$k[$j++]=_As}if($_.haved){var _B0=new Map([["can",function(){var _Aw=$g($_.setd,$_.c)!==undefined;$k[$j++]=_Aw}],["intake",1],["output",function(){$k[$j++]=1}],["sets",8],["enc",function(){$k[$j++]=$g($_.setd,$_.c)}]]);$k[$j++]=_B0}if($_.havee){var _B8=new Map([["can",function(){var _B4=$g($_.sete,$_.c)!==undefined;$k[$j++]=_B4}],["intake",1],["output",function(){$k[$j++]=1}],["sets",16],["enc",function(){$k[$j++]=$g($_.sete,$_.c)}]]);$k[$j++]=_B8}var _BD=new Map([["can",function(){$k[$j++]=$_.num_a>=1}],["intake",1],["output",function(){$k[$j++]=2}],["sets",2],["enc",function(){$k[$j++]=59;$k[$j++]=$g($_.seta,$_.c)}]]);var _BF=new Map([["can",function(){$k[$j++]=$_.num_a>=2}],["intake",2],["output",function(){$k[$j++]=3}],["sets",2],["enc",function(){$k[$j++]=56;$_.enc_sha2()}]]);var _BH=new Map([["can",function(){$k[$j++]=$_.num_a>=3}],["intake",3],["output",function(){$k[$j++]=4}],["sets",2],["enc",function(){$k[$j++]=57;$_.enc_sha3()}]]);$k[$j++]=_BD;$k[$j++]=_BF;$k[$j++]=_BH;if($_.haveb){var _BP=new Map([["can",function(){var _BL=$g($_.setb,$_.c)!==undefined;$k[$j++]=_BL}],["intake",1],["output",function(){$k[$j++]=2}],["sets",1],["enc",function(){$k[$j++]=59;$k[$j++]=$g($_.setb,$_.c)}]]);$k[$j++]=_BP}if($_.havec){var _BX=new Map([["can",function(){var _BT=$g($_.setc,$_.c)!==undefined;$k[$j++]=_BT}],["intake",1],["output",function(){$k[$j++]=2}],["sets",27],["enc",function(){$k[$j++]=60;$k[$j++]=$g($_.setc,$_.c)}]]);$k[$j++]=_BX}if($_.haved){var _Bf=new Map([["can",function(){var _Bb=$g($_.setd,$_.c)!==undefined;$k[$j++]=_Bb}],["intake",1],["output",function(){$k[$j++]=2}],["sets",23],["enc",function(){$k[$j++]=61;$k[$j++]=$g($_.setd,$_.c)}]]);$k[$j++]=_Bf}if($_.havee){var _Bn=new Map([["can",function(){var _Bj=$g($_.sete,$_.c)!==undefined;$k[$j++]=_Bj}],["intake",1],["output",function(){$k[$j++]=2}],["sets",15],["enc",function(){$k[$j++]=62;$k[$j++]=$g($_.sete,$_.c)}]]);$k[$j++]=_Bn}$_.op_tab=$a();var _Bp=$_.op_tab;$k[$j++]=0;for(var _Bq=0,_Br=_Bp.length;_Bq<_Br;_Bq++){var _Bt=$k[--$j];$p($g(_Bp,_Bq),"idx",_Bt);$k[$j++]=_Bt+1}$k[$j-1]=Infinity;var _Bu=$a([1,2,4,8,16]);for(var _Bv=0,_Bw=_Bu.length;_Bv<_Bw;_Bv++){$_.n=$g(_Bu,_Bv);$k[$j++]=Infinity;var _By=$_.op_tab;for(var _Bz=0,_C0=_By.length;_Bz<_C0;_Bz++){var _C1=$g(_By,_Bz);$k[$j++]=_C1;if($an($g(_C1,"sets"),$_.n)==0){$j--}}var _C4=$a();$k[$j++]=_C4}$_.code_set_operations=$a();$_.get_best_length=function(){$_.latch_length_s=$g($_.latch_length,$_.state);$k[$j++]=$_.max_int;$F($g($_.code_set_operations,$_.state),function(){$_.op=$k[--$j];if($g($_.op,"can")()===true){return true}if($k[--$j]){$_.m=$f($_.n-$g($_.op,"intake"))&15;$_.org=$g($g($_.best_origin,$_.m),$_.state);$k[$j++]=$f($g($g($_.best_length,$_.m),$_.org)+$g($_.latch_length_s,$_.org));if($g($_.op,"output")()===true){return true}var _CZ=$k[--$j];var _Ca=$k[--$j];var _Cb=$k[$j-1];$k[$j++]=$f(_Ca+_CZ);if(_Cb>$f(_Ca+_CZ)){var _Cc=$k[--$j];var _Cd=$k[--$j];$p($_.path_op_0,$_.state,$g($_.op,"idx"));$p($_.prior_code_set_0,$_.state,$_.org);$k[$j++]=_Cc;$k[$j++]=_Cd}$j--}})};$_.get_best_origin=function(){$_.latch_length_s=$g($_.latch_length,$_.state);$_.orglen=$f($g($_.best_length_0,0)+$g($_.latch_length_s,0));var _Cs=$_.priority_rest;$k[$j++]=0;for(var _Ct=0,_Cu=_Cs.length;_Ct<_Cu;_Ct++){$_.p=$g(_Cs,_Ct);var _D2=$f($g($_.best_length_0,$_.p)+$g($_.latch_length_s,$_.p));$k[$j++]=_D2;if(_D2<$_.orglen){$_.orglen=$k[--$j];$k[$j-1]=$_.p}else{$j--}}};$_.digits=0;$_.num_a=0;for(var _D8=0,_D7=$_.msglen-1;_D8<=_D7;_D8+=1){$_.n=_D8;$_.c=$g($_.msg,$_.n);$k[$j++]="digits";if($_.c>=48&&$_.c<58){$k[$j++]=$_.digits+1}else{$k[$j++]=0}var _DF=$k[--$j];$_[$k[--$j]]=_DF;var _DJ=$g($_.seta,$_.c)!==undefined;$k[$j++]="num_a";if(_DJ){$k[$j++]=$_.num_a+1}else{$k[$j++]=0}var _DL=$k[--$j];$_[$k[--$j]]=_DL;$_.path_op_0=$g($_.path_op,$_.n);$_.prior_code_set_0=$g($_.prior_code_set,$_.n);$_.best_length_0=$g($_.best_length,$_.n&15);$_.best_origin_0=$g($_.best_origin,$_.n&15);var _DZ=$_.priority;for(var _Da=0,_Db=_DZ.length;_Da<_Db;_Da++){$_.state=$g(_DZ,_Da);$k[$j++]=$_.best_length_0;$k[$j++]=$_.state;$_.get_best_length();var _Df=$k[--$j];var _Dg=$k[--$j];$p($k[--$j],_Dg,_Df)}var _Di=$_.priority;for(var _Dj=0,_Dk=_Di.length;_Dj<_Dk;_Dj++){$_.state=$g(_Di,_Dj);$k[$j++]=$_.best_origin_0;$k[$j++]=$_.state;$_.get_best_origin();var _Do=$k[--$j];var _Dp=$k[--$j];$p($k[--$j],_Dp,_Do)}}$_.n=$_.msglen;var _Dt=$_.priority;$k[$j++]=0;$k[$j++]=$_.max_int;for(var _Du=0,_Dv=_Dt.length;_Du<_Dv;_Du++){var _Dw=$g(_Dt,_Du);var _Dy=$g($_.best_length_0,_Dw);var _Dz=$k[$j-1];$k[$j++]=_Dw;$k[$j++]=_Dy;if($lt(_Dy,_Dz)){$r(4,2)}$j-=2}$_.j=$k[--$j];$_.state=$k[--$j];$_.pad_code=$a([33,33,0,0,28]);$k[$j++]="final_code_set";if($g($_.pad_code,$_.state)==0){$k[$j++]=0}else{$k[$j++]=$_.state}var _E7=$k[--$j];$_[$k[--$j]]=_E7;if($g($_.pad_code,$_.state)==0&&$lt($_.j,$_.maxlen)){var _EF=$a($_.j+1);$p(_EF,$_.j,58);$k[$j++]=_EF}else{$k[$j++]=$a($_.j)}$_.padval=$g($_.pad_code,$_.final_code_set);$_.len=$_.j;for(;;){if($_.n<=0){break}$_.pcs=$g($g($_.prior_code_set,$_.n-1),$_.state);$_.op_idx=$g($g($_.path_op,$_.n-1),$_.state);$_.op=$g($_.op_tab,$_.op_idx);$_.n=$f($_.n-$g($_.op,"intake"));$_.c=$g($_.msg,$_.n);$_.enc=$g($_.op,"enc");$k[$j++]=Infinity;if($_.enc()===true){break}$_.output=$a();$_.latch=$g($g($_.latch_sequence,$_.state),$_.pcs);$_.len=$f($_.len-$_.latch.length-$_.output.length);var _Et=$k[--$j];var _Eu=$_.len;var _Ev=$_.latch;$P(_Et,_Eu,_Ev);$P(_Et,$f(_Eu+_Ev.length),$_.output);$_.state=$_.pcs;$k[$j++]=_Et}$_.encmsg=$k[--$j]}$k[$j++]="sami";if($_.sam!=-1){$k[$j++]=$a([$g($_.seta,$_.pad),(~~($_.sam/10)-1)*8+($_.sam%10-1)])}else{$k[$j++]=$a([])}var _F7=$k[--$j];$_[$k[--$j]]=_F7;$k[$j++]=Infinity;$q($_.sami);$q($_.encmsg);$_.encmsg=$a();if($_.mode==2||$_.mode==3){if($_.encmsg.length>84){$k[$j++]="bwipp.maxicodeMode23TooLong#23176";$k[$j++]="The secondary message is too long";bwipp_raiseerror()}var _FG=$Z($s(4),"0000");var _FJ=$R($s(4),~~$_.mode,2);$P(_FG,4-_FJ.length,_FJ);$_.mdb=_FG;var _FL=$Z($s(10),"0000000000");var _FO=$R($s(10),$i($_.ccode),2);$P(_FL,10-_FO.length,_FO);$_.ccb=_FL;var _FQ=$Z($s(10),"0000000000");var _FT=$R($s(10),$i($_.scode),2);$P(_FQ,10-_FT.length,_FT);$_.scb=_FQ;$_.pcb=$Z($s(36),"000000000000000000000000000000000000");if($_.mode==2){if($eq($_.ccode,"840")&&$_.pcode.length==5){var _Fa=$Z($s(9),"     0000");$P(_Fa,0,$_.pcode);$_.pcode=_Fa}var _Ff=$R($s(6),$_.pcode.length,2);$P($_.pcb,6-_Ff.length,_Ff);var _Fj=$R($s(30),$i($_.pcode),2);$P($_.pcb,36-_Fj.length,_Fj)}else{$k[$j++]=Infinity;var _Fl=$Z($s(6),"      ");$k[$j++]=_Fl;$k[$j++]=_Fl;$k[$j++]=0;if($_.pcode.length>6){$k[$j++]=$G($_.pcode,0,6)}else{$k[$j++]=$_.pcode}var _Fq=$k[--$j];var _Fr=$k[--$j];$P($k[--$j],_Fr,_Fq);$F($k[--$j],function(){var _Fw=$g($_.seta,$k[--$j]);$k[$j++]=_Fw});$_.pccw=$a();for(var _Fy=0;_Fy<=5;_Fy+=1){$_.i=_Fy;var _G4=$R($s(6),$g($_.pccw,$_.i),2);$P($_.pcb,6*$_.i+6-_G4.length,_G4)}}$_.scm=$s(60);$P($_.scm,2,$_.mdb);$P($_.scm,38,$G($_.pcb,0,4));$P($_.scm,30,$G($_.pcb,4,6));$P($_.scm,24,$G($_.pcb,10,6));$P($_.scm,18,$G($_.pcb,16,6));$P($_.scm,12,$G($_.pcb,22,6));$P($_.scm,6,$G($_.pcb,28,6));$P($_.scm,0,$G($_.pcb,34,2));$P($_.scm,52,$G($_.ccb,0,2));$P($_.scm,42,$G($_.ccb,2,6));$P($_.scm,36,$G($_.ccb,8,2));$P($_.scm,54,$G($_.scb,0,6));$P($_.scm,48,$G($_.scb,6,4));$_.pri=$a([0,0,0,0,0,0,0,0,0,0]);for(var _Gk=0;_Gk<=59;_Gk+=1){$_.i=_Gk;$_.ps=~~($_.i/6);$_.ep=~~$pow(2,5-$_.i%6)*($g($_.scm,$_.i)-48);$p($_.pri,$_.ps,$f($g($_.pri,$_.ps)+$_.ep))}$k[$j++]=Infinity;for(var _Gw=0;_Gw<84;_Gw++){$k[$j++]=$_.padval}$_.sec=$a();$P($_.sec,0,$_.encmsg)}if($_.mode==4||$_.mode==5||$_.mode==6||$_.mode==-1){if($_.mode==-1){var _H7=$_.encmsg.length<=77?5:4;$_.mode=_H7}$k[$j++]=Infinity;var _H9=$_.mode==5?78:94;for(var _HA=0,_HB=_H9;_HA<_HB;_HA++){$k[$j++]=$_.padval}$_.cws=$a();if($_.encmsg.length>$_.cws.length-1){$k[$j++]="bwipp.maxicodeMode56TooLong#23243";$k[$j++]="The message is too long";bwipp_raiseerror()}$p($_.cws,0,$_.mode);$P($_.cws,1,$_.encmsg);$_.pri=$G($_.cws,0,10);$_.sec=$G($_.cws,10,$_.cws.length-10)}$k[$j++]=Infinity;$k[$j++]=1;for(var _HP=0;_HP<63;_HP++){var _HQ=$k[$j-1];var _HR=_HQ*2;$k[$j++]=_HR;if(_HR>=64){var _HS=$k[--$j];$k[$j++]=_HS^67}}$_.rsalog=$a();$_.rslog=$a(64);for(var _HV=1;_HV<=63;_HV+=1){$p($_.rslog,$g($_.rsalog,_HV),_HV)}$_.rsprod=function(){var _Ha=$k[$j-1];var _Hb=$k[$j-2];if(_Ha!=0&&_Hb!=0){var _He=$g($_.rslog,$k[--$j]);var _Hj=$g($_.rsalog,$f(_He+$g($_.rslog,$k[--$j]))%63);$k[$j++]=_Hj}else{$j-=2;$k[$j++]=0}};$_.rscodes=function(){$_.rsnum=$k[--$j];$_.cwb=$k[--$j];$k[$j++]=Infinity;$k[$j++]=1;for(var _Hn=0,_Ho=$_.rsnum;_Hn<_Ho;_Hn++){$k[$j++]=0}$_.coeffs=$a();for(var _Hs=1,_Hr=$_.rsnum;_Hs<=_Hr;_Hs+=1){$_.i=_Hs;$p($_.coeffs,$_.i,$g($_.coeffs,$_.i-1));for(var _Hz=$_.i-1;_Hz>=1;_Hz-=1){$_.j=_Hz;$k[$j++]=$_.coeffs;$k[$j++]=$_.j;$k[$j++]=$g($_.coeffs,$_.j-1);$k[$j++]=$g($_.coeffs,$_.j);$k[$j++]=$g($_.rsalog,$_.i);$_.rsprod();var _IB=$k[--$j];var _IC=$k[--$j];var _ID=$k[--$j];$p($k[--$j],_ID,$xo(_IC,_IB))}$k[$j++]=$_.coeffs;$k[$j++]=0;$k[$j++]=$g($_.coeffs,0);$k[$j++]=$g($_.rsalog,$_.i);$_.rsprod();var _IL=$k[--$j];var _IM=$k[--$j];$p($k[--$j],_IM,_IL)}$_.coeffs=$G($_.coeffs,0,$_.coeffs.length-1);$k[$j++]=Infinity;for(var _IS=0,_IT=$_.rsnum;_IS<_IT;_IS++){$k[$j++]=0}$_.ecb=$a();for(var _IX=0,_IW=$_.cwb.length-1;_IX<=_IW;_IX+=1){$_.t=$xo($g($_.cwb,_IX),$g($_.ecb,0));for(var _Id=$_.ecb.length-1;_Id>=0;_Id-=1){$_.i=_Id;$_.p=$_.ecb.length-$_.i-1;$k[$j++]=$_.ecb;$k[$j++]=$_.p;$k[$j++]=$_.t;$k[$j++]=$g($_.coeffs,$_.i);$_.rsprod();var _Im=$k[--$j];var _In=$k[--$j];$p($k[--$j],_In,_Im);if($_.i>0){$p($_.ecb,$_.p,$xo($g($_.ecb,$_.p+1),$g($_.ecb,$_.p)))}}}$k[$j++]=$_.ecb};$k[$j++]=Infinity;for(var _J1=0,_J0=$_.sec.length-1;_J1<=_J0;_J1+=2){$k[$j++]=$g($_.sec,_J1)}$_.seco=$a();$k[$j++]=Infinity;for(var _J7=1,_J6=$_.sec.length-1;_J7<=_J6;_J7+=2){$k[$j++]=$g($_.sec,_J7)}$_.sece=$a();var _JC=$_.sec.length==84?20:28;$_.scodes=_JC;$k[$j++]="secochk";$k[$j++]=$_.seco;$k[$j++]=$_.scodes;$_.rscodes();var _JF=$k[--$j];$_[$k[--$j]]=_JF;$k[$j++]="secechk";$k[$j++]=$_.sece;$k[$j++]=$_.scodes;$_.rscodes();var _JJ=$k[--$j];$_[$k[--$j]]=_JJ;$k[$j++]=Infinity;for(var _JN=0,_JM=$_.scodes-1;_JN<=_JM;_JN+=1){$k[$j++]=$g($_.secochk,_JN);$k[$j++]=$g($_.secechk,_JN)}$_.secchk=$a();$k[$j++]=Infinity;$q($_.pri);$k[$j++]=$_.pri;$k[$j++]=10;$_.rscodes();$q($k[--$j]);$q($_.sec);$q($_.secchk);$_.codewords=$a();var _Ja=$g($_.options,"debugcws")!==undefined;if(_Ja){$k[$j++]="bwipp.debugcws#23325";$k[$j++]=$_.codewords;bwipp_raiseerror()}$k[$j++]=Infinity;for(var _Jc=0;_Jc<864;_Jc++){$k[$j++]=0}$_.mods=$a();for(var _Je=0;_Je<=143;_Je+=1){$_.i=_Je;$k[$j++]=Infinity;var _Jj=$R($s(6),$g($_.codewords,$_.i),2);for(var _Jk=0,_Jl=_Jj.length;_Jk<_Jl;_Jk++){$k[$j++]=$g(_Jj,_Jk)-48}$_.cw=$a();$P($_.mods,6*$_.i+(6-$_.cw.length),$_.cw)}$_.modmap=$a([469,529,286,316,347,346,673,672,703,702,647,676,283,282,313,312,370,610,618,379,378,409,408,439,705,704,559,589,588,619,458,518,640,701,675,674,285,284,315,314,310,340,531,289,288,319,349,348,456,486,517,516,471,470,369,368,399,398,429,428,549,548,579,578,609,608,649,648,679,678,709,708,639,638,669,668,699,698,279,278,309,308,339,338,381,380,411,410,441,440,561,560,591,590,621,620,547,546,577,576,607,606,367,366,397,396,427,426,291,290,321,320,351,350,651,650,681,680,711,710,1,0,31,30,61,60,3,2,33,32,63,62,5,4,35,34,65,64,7,6,37,36,67,66,9,8,39,38,69,68,11,10,41,40,71,70,13,12,43,42,73,72,15,14,45,44,75,74,17,16,47,46,77,76,19,18,49,48,79,78,21,20,51,50,81,80,23,22,53,52,83,82,25,24,55,54,85,84,27,26,57,56,87,86,117,116,147,146,177,176,115,114,145,144,175,174,113,112,143,142,173,172,111,110,141,140,171,170,109,108,139,138,169,168,107,106,137,136,167,166,105,104,135,134,165,164,103,102,133,132,163,162,101,100,131,130,161,160,99,98,129,128,159,158,97,96,127,126,157,156,95,94,125,124,155,154,93,92,123,122,153,152,91,90,121,120,151,150,181,180,211,210,241,240,183,182,213,212,243,242,185,184,215,214,245,244,187,186,217,216,247,246,189,188,219,218,249,248,191,190,221,220,251,250,193,192,223,222,253,252,195,194,225,224,255,254,197,196,227,226,257,256,199,198,229,228,259,258,201,200,231,230,261,260,203,202,233,232,263,262,205,204,235,234,265,264,207,206,237,236,267,266,297,296,327,326,357,356,295,294,325,324,355,354,293,292,323,322,353,352,277,276,307,306,337,336,275,274,305,304,335,334,273,272,303,302,333,332,271,270,301,300,331,330,361,360,391,390,421,420,363,362,393,392,423,422,365,364,395,394,425,424,383,382,413,412,443,442,385,384,415,414,445,444,387,386,417,416,447,446,477,476,507,506,537,536,475,474,505,504,535,534,473,472,503,502,533,532,455,454,485,484,515,514,453,452,483,482,513,512,451,450,481,480,511,510,541,540,571,570,601,600,543,542,573,572,603,602,545,544,575,574,605,604,563,562,593,592,623,622,565,564,595,594,625,624,567,566,597,596,627,626,657,656,687,686,717,716,655,654,685,684,715,714,653,652,683,682,713,712,637,636,667,666,697,696,635,634,665,664,695,694,633,632,663,662,693,692,631,630,661,660,691,690,721,720,751,750,781,780,723,722,753,752,783,782,725,724,755,754,785,784,727,726,757,756,787,786,729,728,759,758,789,788,731,730,761,760,791,790,733,732,763,762,793,792,735,734,765,764,795,794,737,736,767,766,797,796,739,738,769,768,799,798,741,740,771,770,801,800,743,742,773,772,803,802,745,744,775,774,805,804,747,746,777,776,807,806,837,836,867,866,897,896,835,834,865,864,895,894,833,832,863,862,893,892,831,830,861,860,891,890,829,828,859,858,889,888,827,826,857,856,887,886,825,824,855,854,885,884,823,822,853,852,883,882,821,820,851,850,881,880,819,818,849,848,879,878,817,816,847,846,877,876,815,814,845,844,875,874,813,812,843,842,873,872,811,810,841,840,871,870,901,900,931,930,961,960,903,902,933,932,963,962,905,904,935,934,965,964,907,906,937,936,967,966,909,908,939,938,969,968,911,910,941,940,971,970,913,912,943,942,973,972,915,914,945,944,975,974,917,916,947,946,977,976,919,918,949,948,979,978,921,920,951,950,981,980,923,922,953,952,983,982,925,924,955,954,985,984,927,926,957,956,987,986,58,89,88,118,149,148,178,209,208,238,269,268,298,329,328,358,389,388,418,449,448,478,509,508,538,569,568,598,629,628,658,689,688,718,749,748,778,809,808,838,869,868,898,929,928,958,989,988]);$_.pixs=$a(864);$_.j=0;for(var _Jx=0,_Jw=$_.mods.length-1;_Jx<=_Jw;_Jx+=1){$_.i=_Jx;if($g($_.mods,$_.i)==1){$p($_.pixs,$_.j,$g($_.modmap,$_.i));$_.j=$_.j+1}}$k[$j++]=Infinity;$q($G($_.pixs,0,$_.j));$k[$j++]=28;$k[$j++]=29;$k[$j++]=280;$k[$j++]=281;$k[$j++]=311;$k[$j++]=457;$k[$j++]=488;$k[$j++]=500;$k[$j++]=530;$k[$j++]=670;$k[$j++]=700;$k[$j++]=677;$k[$j++]=707;$_.pixs=$a();var _KD=new Map([["ren","renmaximatrix"],["pixs",$_.pixs],["borderleft",1],["borderright",1],["bordertop",1],["borderbottom",1],["opt",$_.options]]);$k[$j++]=_KD;if(!$_.dontdraw){bwipp_renmaximatrix()}$_=$__}function bwipp_azteccode(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.format="full";$_.readerinit=false;$_.layers=-1;$_.eclevel=23;$_.ecaddchars=3;$_.raw=false;$_.parse=false;$_.parsefnc=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.barcode.length==0){$k[$j++]="bwipp.aztecEmptyData#23462";$k[$j++]="The data must not be empty";bwipp_raiseerror()}if($_.eclevel<5||$_.eclevel>95){$k[$j++]="bwipp.aztecInvalidEClevel#23466";$k[$j++]="The EC percentage must be from 5 to 95";bwipp_raiseerror()}if($_.ecaddchars<3){$k[$j++]="bwipp.aztecInvalidECaddChars#23470";$k[$j++]="The number of additional EC codewords must be 3 or more";bwipp_raiseerror()}if($ne($_.format,"full")&&($ne($_.format,"compact")&&$ne($_.format,"rune"))){$k[$j++]="bwipp.aztecInvalidFormat#23474";$k[$j++]="The format must be either full, compact or rune";bwipp_raiseerror()}if($eq($_.format,"full")){if($_.readerinit&&($_.layers<1||$_.layers>22)){$k[$j++]="bwipp.aztecFullInitInvalidLayers#23479";$k[$j++]="Full-range symbols for reader programming must specify from 1 to 22 layers";bwipp_raiseerror()}if($_.layers!=-1&&($_.layers<1||$_.layers>32)){$k[$j++]="bwipp.aztecFullInvalidLayers#23482";$k[$j++]="Layers for full-range symbols must be from 1 to 32";bwipp_raiseerror()}}if($eq($_.format,"compact")){if($_.readerinit){if($_.layers!=-1&&$_.layers!=1){$k[$j++]="bwipp.aztecCompactInitInvalidLayers#23489";$k[$j++]="Compact symbols for reader programming must have 1 layer";bwipp_raiseerror()}$_.layers=1}if($_.layers!=-1&&($_.layers<1||$_.layers>4)){$k[$j++]="bwipp.aztecCompactInvalidLayers#23494";$k[$j++]="Layers for compact symbols must be from 1 to 4";bwipp_raiseerror()}}if($eq($_.format,"rune")){if($_.layers!=-1){$k[$j++]="bwipp.aztecRuneInvalidLayers#23500";$k[$j++]="It is not valid to specify layers for runes";bwipp_raiseerror()}if($_.readerinit){$k[$j++]="bwipp.aztecRuneReaderInit#23503";$k[$j++]="Reader initialisation is not compactible with Aztec Runes";bwipp_raiseerror()}if($_.barcode.length==0){$k[$j++]="bwipp.aztecRuneNotNumeric#23506";$k[$j++]="Aztec runes must be numeric";bwipp_raiseerror()}$F($_.barcode,function(){var _S=$k[--$j];if(_S<48||_S>57){$k[$j++]="bwipp.aztecRuneNotNumeric#23510";$k[$j++]="Aztec runes must be numeric";bwipp_raiseerror()}});var _U=$i($_.barcode);if(_U<0||_U>255){$k[$j++]="bwipp.aztecRuneInvalid#23514";$k[$j++]="Aztec runes must be 0 to 255";bwipp_raiseerror()}}$_.fn1=-1;var _Y=new Map([["parse",$_.parse],["parsefnc",$_.parsefnc],["eci",true],["FNC1",$_.fn1]]);$_.fncvals=_Y;$k[$j++]="msg";$k[$j++]=$_.barcode;$k[$j++]=$_.fncvals;bwipp_parseinput();var _b=$k[--$j];$_[$k[--$j]]=_b;$_.msglen=$_.msg.length;$_.U=0;$_.L=1;$_.M=2;$_.P=3;$_.D=4;$_.B=5;$_.lu=-2;$_.ll=-3;$_.lm=-4;$_.lp=-5;$_.ld=-6;$_.su=-7;$_.sp=-8;$_.sb=-9;$_.fl=-10;$_.p2=-11;$_.p3=-12;$_.p4=-13;$_.p5=-14;$_.charmaps=$a([$a([$_.sp,$_.sp,$_.sp,$_.fl,$_.sp]),$a([32,32,32,13,32]),$a(["A","a",1,$_.p2,"0"]),$a(["B","b",2,$_.p3,"1"]),$a(["C","c",3,$_.p4,"2"]),$a(["D","d",4,$_.p5,"3"]),$a(["E","e",5,"!","4"]),$a(["F","f",6,'"',"5"]),$a(["G","g",7,"#","6"]),$a(["H","h",8,"$","7"]),$a(["I","i",9,"%","8"]),$a(["J","j",10,"&","9"]),$a(["K","k",11,"'",","]),$a(["L","l",12,40,"."]),$a(["M","m",13,41,$_.lu]),$a(["N","n",27,"*",$_.su]),$a(["O","o",28,"+",-99]),$a(["P","p",29,",",-99]),$a(["Q","q",30,"-",-99]),$a(["R","r",31,".",-99]),$a(["S","s","@","/",-99]),$a(["T","t",92,":",-99]),$a(["U","u","^",";",-99]),$a(["V","v","_","<",-99]),$a(["W","w","`","=",-99]),$a(["X","x","|",">",-99]),$a(["Y","y","~","?",-99]),$a(["Z","z",127,"[",-99]),$a([$_.ll,$_.su,$_.ll,"]",-99]),$a([$_.lm,$_.lm,$_.lu,"{",-99]),$a([$_.ld,$_.ld,$_.lp,"}",-99]),$a([$_.sb,$_.sb,$_.sb,$_.lu,-99])]);$_.charvals=$a([new Map,new Map,new Map,new Map,new Map]);for(var _1c=0,_1b=$_.charmaps.length-1;_1c<=_1b;_1c+=1){$_.i=_1c;$_.encs=$g($_.charmaps,$_.i);for(var _1g=0;_1g<=4;_1g+=1){$_.j=_1g;var _1j=$g($_.encs,$_.j);$k[$j++]=_1j;if($eq($t(_1j),"stringtype")){var _1m=$g($k[--$j],0);$k[$j++]=_1m}$p($g($_.charvals,$_.j),$k[--$j],$_.i)}}var _1w=new Map([["\r\n",$_.p2],[". ",$_.p3],[", ",$_.p4],[": ",$_.p5]]);$_.pcomp=_1w;$_.e=1e6;$_.latlen=$a([$a([0,5,5,10,5,10]),$a([9,0,5,10,5,10]),$a([5,5,0,5,10,10]),$a([5,10,10,0,10,15]),$a([4,9,9,14,0,14]),$a([0,0,0,0,0,0])]);$_.latseq=$a([$a([$a([]),$a([$_.ll]),$a([$_.lm]),$a([$_.lm,$_.lp]),$a([$_.ld]),$a([$_.sb])]),$a([$a([$_.ld,$_.lu]),$a([]),$a([$_.lm]),$a([$_.lm,$_.lp]),$a([$_.ld]),$a([$_.sb])]),$a([$a([$_.lu]),$a([$_.ll]),$a([]),$a([$_.lp]),$a([$_.lu,$_.ld]),$a([$_.sb])]),$a([$a([$_.lu]),$a([$_.lu,$_.ll]),$a([$_.lu,$_.lm]),$a([]),$a([$_.lu,$_.ld]),$a([$_.lu,$_.sb])]),$a([$a([$_.lu]),$a([$_.lu,$_.ll]),$a([$_.lu,$_.lm]),$a([$_.lu,$_.lm,$_.lp]),$a([]),$a([$_.lu,$_.sb])]),$a([$a([$_.lu]),$a([$_.ll]),$a([$_.lm]),$a([]),$a([]),$a([])])]);$_.shftlen=$a([$a([$_.e,$_.e,$_.e,5,$_.e]),$a([5,$_.e,$_.e,5,$_.e]),$a([$_.e,$_.e,$_.e,5,$_.e]),$a([$_.e,$_.e,$_.e,$_.e,$_.e]),$a([4,$_.e,$_.e,4,$_.e])]);$_.msgbits="";if($ne($_.format,"rune")&&$_.raw){$_.msgbits=$_.barcode}if($ne($_.format,"rune")&&!$_.raw){$_.charsize=function(){var _3v=$k[$j-1];if(_3v>=0){$j--;var _3y=$g($a([5,5,5,5,4,8]),$k[--$j]);$k[$j++]=_3y}else{var _3z=$k[--$j];$k[$j-1]=_3z;var _41=$k[$j-1];if(_41==$_.fn1){$k[$j-1]=8}else{var _44=-$k[--$j]-1e6;$k[$j++]=_44;if(_44==0){$k[$j-1]=1}var _45=$k[--$j];$k[$j++]=(~~($log(_45)/$log(10))+1)*4+8}}};$_.curlen=$a([0,$_.e,$_.e,$_.e,$_.e,$_.e]);$_.curseq=$a([$a([]),$a([]),$a([]),$a([]),$a([]),$a([])]);$_.backto=$_.U;$_.lastchar="";$F($_.msg,function(){$_.char=$k[--$j];for(;;){$_.imp=false;var _4S=$a([$_.U,$_.L,$_.M,$_.P,$_.D,$_.B]);for(var _4T=0,_4U=_4S.length;_4T<_4U;_4T++){$_.x=$g(_4S,_4T);var _4c=$a([$_.U,$_.L,$_.M,$_.P,$_.D,$_.B]);for(var _4d=0,_4e=_4c.length;_4d<_4e;_4d++){$_.y=$g(_4c,_4d);if($_.x!=$_.B||$_.y==$_.backto){$_.cost=$f($g($_.curlen,$_.x)+$g($g($_.latlen,$_.x),$_.y));if($_.cost<$g($_.curlen,$_.y)){$p($_.curlen,$_.y,$_.cost);$k[$j++]=$_.curseq;$k[$j++]=$_.y;$k[$j++]=Infinity;$q($g($_.curseq,$_.x));$q($g($g($_.latseq,$_.x),$_.y));var _59=$a();var _5A=$k[--$j];$p($k[--$j],_5A,_59);if($_.y==$_.B){$k[$j++]="backto";if($_.x==$_.P||$_.x==$_.D){$k[$j++]=$_.U}else{$k[$j++]=$_.x}var _5K=$k[--$j];$_[$k[--$j]]=_5K}$_.imp=true}}}}if(!$_.imp){break}}$_.nxtlen=$a([$_.e,$_.e,$_.e,$_.e,$_.e,$_.e]);$_.nxtseq=$a(6);var _5b=$a([$_.U,$_.L,$_.M,$_.P,$_.D,$_.B]);for(var _5c=0,_5d=_5b.length;_5c<_5d;_5c++){$_.x=$g(_5b,_5c);for(;;){if($_.char>=0){if($_.x!=$_.B){var _5m=$g($g($_.charvals,$_.x),$_.char)!==undefined;if(!_5m){break}}}else{if($_.x!=$_.P){break}}$k[$j++]="cost";$k[$j++]=$g($_.curlen,$_.x);$k[$j++]=$_.x;$k[$j++]=$_.char;$_.charsize();var _5u=$k[--$j];var _5v=$k[--$j];$_[$k[--$j]]=$f(_5v+_5u);if($_.cost<$g($_.nxtlen,$_.x)){$p($_.nxtlen,$_.x,$_.cost);$k[$j++]=$_.nxtseq;$k[$j++]=$_.x;$k[$j++]=Infinity;$q($g($_.curseq,$_.x));$k[$j++]=$_.char;var _6A=$a();var _6B=$k[--$j];$p($k[--$j],_6B,_6A)}if($_.x==$_.B){break}var _6K=$a([$_.U,$_.L,$_.M,$_.P,$_.D]);for(var _6L=0,_6M=_6K.length;_6L<_6M;_6L++){$_.y=$g(_6K,_6L);if($ne($_.x,$_.y)){$k[$j++]="cost";$k[$j++]=$f($g($_.curlen,$_.y)+$g($g($_.shftlen,$_.y),$_.x));$k[$j++]=$_.x;$k[$j++]=$_.char;$_.charsize();var _6a=$k[--$j];var _6b=$k[--$j];$_[$k[--$j]]=$f(_6b+_6a);if($_.cost<$g($_.nxtlen,$_.y)){$p($_.nxtlen,$_.y,$_.cost);$k[$j++]=$_.nxtseq;$k[$j++]=$_.y;$k[$j++]=Infinity;$q($g($_.curseq,$_.y));var _6r=$_.x==$_.U?$_.su:$_.sp;$k[$j++]=_6r;$k[$j++]=$_.char;var _6t=$a();var _6u=$k[--$j];$p($k[--$j],_6u,_6t)}}}break}}if($_.lastchar.length!=0&&$_.char>=0){var _6y=$s(2);$p(_6y,0,$_.lastchar);$p(_6y,1,$_.char);$_.pchars=_6y;var _73=$g($_.pcomp,$_.pchars)!==undefined;if(_73){var _79=$a([$_.U,$_.L,$_.M,$_.P,$_.D]);for(var _7A=0,_7B=_79.length;_7A<_7B;_7A++){$_.i=$g(_79,_7A);$_.inP=true;if($_.i==$_.M){if($_.lastchar==13){$_.inP=false}}else{if($_.i==$_.D){if($_.lastchar==44||$_.lastchar==46){$_.inP=false}}}if($_.inP&&$lt($g($_.curlen,$_.i),$g($_.nxtlen,$_.i))){$_.curseqi=$g($_.curseq,$_.i);$_.lastld=false;$_.lastsp=false;$_.lastidx=-1;for(var _7V=$_.curseqi.length-1;_7V>=0;_7V-=1){$_.idx=_7V;$_.ch=$g($_.curseqi,$_.idx);if($_.lastidx==-1){if($eq($_.ch,$_.lastchar)){$_.lastidx=$_.idx;if($_.idx>0){if($g($_.curseqi,$_.idx-1)==$_.sp){$_.lastsp=true}}}}else{if($_.ch==$_.sb){$_.lastidx=-1;break}if($_.ch<0&&$_.ch>=$_.ld){if($_.i==$_.P){if($_.ch==$_.ld){$_.lastld=true}}else{if($_.ch!=$_.lp){$_.inP=$_.lastsp}}break}}}if($_.inP&&$_.lastidx>=0){$p($_.nxtlen,$_.i,$g($_.curlen,$_.i));if($_.lastidx<$_.curseqi.length-1){if($_.i==$_.P){if($_.lastld){$p($_.nxtlen,$_.i,$g($_.nxtlen,$_.i)+1)}$k[$j++]=$_.nxtseq;$k[$j++]=$_.i;$k[$j++]=Infinity;$q($_.curseqi);$r($_.curseqi.length-$_.lastidx,-1);$k[$j-1]=$g($_.pcomp,$_.pchars);var _8J=$a();var _8K=$k[--$j];$p($k[--$j],_8K,_8J)}else{$k[$j++]=$_.nxtseq;$k[$j++]=$_.i;$k[$j++]=Infinity;$q($_.curseqi);var _8P=$a();var _8Q=$k[--$j];$p($k[--$j],_8Q,_8P);$p($g($_.nxtseq,$_.i),$_.lastidx,$g($_.pcomp,$_.pchars))}}else{$k[$j++]=$_.nxtseq;$k[$j++]=$_.i;$k[$j++]=Infinity;$q($_.curseqi);$k[$j-1]=$g($_.pcomp,$_.pchars);var _8f=$a();var _8g=$k[--$j];$p($k[--$j],_8g,_8f)}}}}}}if($ne($g($_.nxtseq,$_.B),null)){$_.numbytes=0;$F($g($_.nxtseq,$_.B),function(){if($k[--$j]==$_.sb){$k[$j++]=0}else{$k[$j++]=$_.numbytes+1}$_.numbytes=$k[--$j]});if($_.numbytes==32){$p($_.nxtlen,$_.B,$g($_.nxtlen,$_.B)+11)}}$_.curlen=$_.nxtlen;$_.curseq=$_.nxtseq;$k[$j++]="lastchar";if($_.char>=0){$k[$j++]=$_.char}else{$k[$j++]=""}var _92=$k[--$j];$_[$k[--$j]]=_92});$_.minseq=$_.e;var _9B=$a([$_.U,$_.L,$_.M,$_.P,$_.D,$_.B]);for(var _9C=0,_9D=_9B.length;_9C<_9D;_9C++){$_.i=$g(_9B,_9C);if($g($_.curlen,$_.i)<$_.minseq){$_.minseq=$g($_.curlen,$_.i);$_.seq=$g($_.curseq,$_.i)}}$_.tobin=function(){var _9Q=$s($k[--$j]);$k[$j++]=_9Q;for(var _9S=0,_9R=_9Q.length-1;_9S<=_9R;_9S+=1){var _9T=$k[$j-1];$p(_9T,_9S,48)}var _9U=$k[$j-1];$k[$j++]=_9U;var _9V=$k[$j-3];var _9W=$k[$j-1];$k[$j-3]=$k[$j-2];$j-=2;var _9Y=$R($s(_9W.length),_9V,2);$P(_9W,_9W.length-_9Y.length,_9Y)};$_.encu=function(){var _9d=$g($g($_.charvals,$_.U),$k[--$j]);$k[$j++]=_9d;$k[$j++]=5;$_.tobin()};$_.encl=function(){var _9i=$g($g($_.charvals,$_.L),$k[--$j]);$k[$j++]=_9i;$k[$j++]=5;$_.tobin()};$_.encm=function(){var _9n=$g($g($_.charvals,$_.M),$k[--$j]);$k[$j++]=_9n;$k[$j++]=5;$_.tobin()};$_.encd=function(){var _9s=$g($g($_.charvals,$_.D),$k[--$j]);$k[$j++]=_9s;$k[$j++]=4;$_.tobin()};$_.encp=function(){var _9t=$k[$j-1];if(_9t==$_.fn1){$k[$j-1]="00000000"}else{var _9v=$k[$j-1];if(_9v<=-1e6){var _9x=-$k[--$j]-1e6;$k[$j++]=_9x;$k[$j++]=_9x;if(_9x==0){$k[$j-1]=1}var _9z=~~($log($k[--$j])/$log(10));var _A0=$s((_9z+1)*4+8);$P(_A0,0,"00000");$k[$j++]=_9z;$k[$j++]=_A0;$k[$j++]=_A0;$k[$j++]=_9z+1;$k[$j++]=3;$_.tobin();var _A1=$k[--$j];$P($k[--$j],5,_A1);$r(3,1);$k[$j++]=-1;$k[$j++]=0;if($j<3)throw"--stack-underflow--";$j-=3;for(var _A6=$k[$j],_A7=$k[$j+1],_A5=$k[$j+2];_A7<0?_A6>=_A5:_A6<=_A5;_A6+=_A7){var _A8=$k[--$j];var _A9=$k[$j-1];$k[$j++]=~~(_A8/10);$k[$j++]=_A9;$k[$j++]=_A6*4+8;$k[$j++]=_A8%10+2;$k[$j++]=4;$_.tobin();var _AA=$k[--$j];var _AB=$k[--$j];$P($k[--$j],_AB,_AA)}$j--}else{var _AH=$g($g($_.charvals,$_.P),$k[--$j]);$k[$j++]=_AH;$k[$j++]=5;$_.tobin()}}};$_.encfuncs=$a(["encu","encl","encm","encp","encd"]);$_.addtomsgbits=function(){$_.v=$k[--$j];$P($_.msgbits,$_.j,$_.v);$_.j=$_.j+$_.v.length};$_.state=$_.U;$_.msgbits=$s($_.minseq);$_.i=0;$_.j=0;for(;;){if($_.i>=$_.seq.length){break}if($_.state!=$_.B){$_.char=$g($_.seq,$_.i);$k[$j++]=$_.char;if($_[$g($_.encfuncs,$_.state)]()===true){break}$_.addtomsgbits();$_.i=$_.i+1;if($_.char==$_.su||$_.char==$_.sp){$k[$j++]=$g($_.seq,$_.i);if($_.char==$_.su){$_.encu()}else{$_.encp()}$_.addtomsgbits();$_.i=$_.i+1}if($_.char==$_.lu){$_.state=$_.U}if($_.char==$_.ll){$_.state=$_.L}if($_.char==$_.lm){$_.state=$_.M}if($_.char==$_.lp){$_.state=$_.P}if($_.char==$_.ld){$_.state=$_.D}if($_.char==$_.sb){$_.state=$_.B}}else{$_.numbytes=0;for(;;){if($_.i+$_.numbytes>=$_.seq.length){break}if($g($_.seq,$_.i+$_.numbytes)<0){break}$_.numbytes=$_.numbytes+1}if($_.numbytes<=31){$k[$j++]=$_.numbytes;$k[$j++]=5;$_.tobin();$_.addtomsgbits()}else{$k[$j++]=0;$k[$j++]=5;$_.tobin();$_.addtomsgbits();$k[$j++]=$_.numbytes-31;$k[$j++]=11;$_.tobin();$_.addtomsgbits()}for(var _BJ=0,_BK=$_.numbytes;_BJ<_BK;_BJ++){$k[$j++]=$g($_.seq,$_.i);$k[$j++]=8;$_.tobin();$_.addtomsgbits();$_.i=$_.i+1}if($_.i<$_.seq.length){$_.char=$g($_.seq,$_.i);$_.i=$_.i+1;if($_.char==$_.lu){$_.state=$_.U}if($_.char==$_.ll){$_.state=$_.L}if($_.char==$_.lm){$_.state=$_.M}}}}$_.msgbits=$G($_.msgbits,0,$_.j)}$_.metrics=$a([$a(["rune",0,0,0,6]),$a(["compact",1,1,17,6]),$a(["full",1,1,21,6]),$a(["compact",2,0,40,6]),$a(["full",2,1,48,6]),$a(["compact",3,0,51,8]),$a(["full",3,1,60,8]),$a(["compact",4,0,76,8]),$a(["full",4,1,88,8]),$a(["full",5,1,120,8]),$a(["full",6,1,156,8]),$a(["full",7,1,196,8]),$a(["full",8,1,240,8]),$a(["full",9,1,230,10]),$a(["full",10,1,272,10]),$a(["full",11,1,316,10]),$a(["full",12,1,364,10]),$a(["full",13,1,416,10]),$a(["full",14,1,470,10]),$a(["full",15,1,528,10]),$a(["full",16,1,588,10]),$a(["full",17,1,652,10]),$a(["full",18,1,720,10]),$a(["full",19,1,790,10]),$a(["full",20,1,864,10]),$a(["full",21,1,940,10]),$a(["full",22,1,1020,10]),$a(["full",23,0,920,12]),$a(["full",24,0,992,12]),$a(["full",25,0,1066,12]),$a(["full",26,0,1144,12]),$a(["full",27,0,1224,12]),$a(["full",28,0,1306,12]),$a(["full",29,0,1392,12]),$a(["full",30,0,1480,12]),$a(["full",31,0,1570,12]),$a(["full",32,0,1664,12])]);var _CK=$_.metrics;for(var _CL=0,_CM=_CK.length;_CL<_CM;_CL++){$_.m=$g(_CK,_CL);$_.frmt=$g($_.m,0);$_.mlyr=$g($_.m,1);$_.icap=$g($_.m,2);$_.ncws=$g($_.m,3);$_.bpcw=$g($_.m,4);$_.numecw=~~$ceil($f($_.ncws*$_.eclevel/100+$_.ecaddchars));if($_.msgbits.length==0){$_.numecw=0}$_.numdcw=$f($_.ncws-$_.numecw);$_.okay=true;if($ne($_.format,$_.frmt)){$_.okay=false}if($_.readerinit&&$_.icap!=1){$_.okay=false}if($_.layers!=-1&&$_.layers!=$_.mlyr){$_.okay=false}if(~~$ceil($_.msgbits.length/$_.bpcw)>$_.numdcw){$_.okay=false}if($_.okay){break}}if(!$_.okay){$k[$j++]="bwipp.aztecNoValidSymbol#23967";$k[$j++]="Maximum length exceeded";bwipp_raiseerror()}$_.layers=$_.mlyr;$_.allzero=function(){var _Cr=$k[--$j];$k[$j++]=$eq(_Cr,$G("000000000000",0,_Cr.length))};$_.allones=function(){var _Ct=$k[--$j];$k[$j++]=$eq(_Ct,$G("111111111111",0,_Ct.length))};$_.cws=$a($_.ncws);$_.m=0;$_.c=0;for(;;){if($_.msgbits.length<=$_.m){break}if($_.msgbits.length-$_.m>=$_.bpcw){$_.cwb=$G($_.msgbits,$_.m,$_.bpcw-1);$_.cwf=$G($_.msgbits,$f($_.m+$_.bpcw)-1,1);$k[$j++]=$_.cwb;$_.allzero();if($k[--$j]){$_.cwf="1";$_.m=$_.m-1}$k[$j++]=$_.cwb;$_.allones();if($k[--$j]){$_.cwf="0";$_.m=$_.m-1}var _DG=$s(12);$P(_DG,0,$_.cwb);$P(_DG,$_.bpcw-1,$_.cwf);$_.cwb=$G(_DG,0,$_.bpcw)}else{$_.cwb=$G($_.msgbits,$_.m,$_.msgbits.length-$_.m);var _DS=$Z($s(12),"111111111111");$P(_DS,0,$_.cwb);$_.cwb=$G(_DS,0,$_.bpcw);$k[$j++]=$_.cwb;$_.allones();if($k[--$j]){$P($_.cwb,$_.cwb.length-1,"0")}}$_.cw=0;for(var _Dc=0,_Db=$_.bpcw-1;_Dc<=_Db;_Dc+=1){$_.i=_Dc;$_.cw=$f($_.cw+~~$pow(2,$f($_.bpcw-$_.i)-1)*($g($_.cwb,$_.i)-48))}$p($_.cws,$_.c,$_.cw);$_.m=$f($_.m+$_.bpcw);$_.c=$_.c+1}$_.cws=$G($_.cws,0,$_.c);var _Dt=$g($_.options,"debugcws")!==undefined;if(_Dt){$k[$j++]="bwipp.debugcws#24006";$k[$j++]=$_.cws;bwipp_raiseerror()}$_.rscodes=function(){$_.rspm=$k[--$j];$_.rsgf=$k[--$j];$_.rsnc=$k[--$j];$_.rscws=$k[--$j];$k[$j++]=Infinity;$k[$j++]=1;for(var _E0=0,_E1=$_.rsgf-1;_E0<_E1;_E0++){var _E2=$k[$j-1];var _E3=_E2*2;$k[$j++]=_E3;if(_E3>=$_.rsgf){var _E6=$k[--$j];$k[$j++]=$xo(_E6,$_.rspm)}}$_.rsalog=$a();$_.rslog=$a($_.rsgf);for(var _EC=1,_EB=$_.rsgf-1;_EC<=_EB;_EC+=1){$p($_.rslog,$g($_.rsalog,_EC),_EC)}$_.rsprod=function(){var _EG=$k[$j-1];var _EH=$k[$j-2];if(_EG!=0&&_EH!=0){var _EK=$g($_.rslog,$k[--$j]);var _EQ=$g($_.rsalog,$f(_EK+$g($_.rslog,$k[--$j]))%($_.rsgf-1));$k[$j++]=_EQ}else{$j-=2;$k[$j++]=0}};$k[$j++]=Infinity;$k[$j++]=1;for(var _ES=0,_ET=$_.rsnc;_ES<_ET;_ES++){$k[$j++]=0}$_.coeffs=$a();for(var _EX=1,_EW=$_.rsnc;_EX<=_EW;_EX+=1){$_.i=_EX;$p($_.coeffs,$_.i,$g($_.coeffs,$_.i-1));for(var _Ee=$_.i-1;_Ee>=1;_Ee-=1){$_.j=_Ee;$k[$j++]=$_.coeffs;$k[$j++]=$_.j;$k[$j++]=$g($_.coeffs,$_.j-1);$k[$j++]=$g($_.coeffs,$_.j);$k[$j++]=$g($_.rsalog,$_.i);$_.rsprod();var _Eq=$k[--$j];var _Er=$k[--$j];var _Es=$k[--$j];$p($k[--$j],_Es,$xo(_Er,_Eq))}$k[$j++]=$_.coeffs;$k[$j++]=0;$k[$j++]=$g($_.coeffs,0);$k[$j++]=$g($_.rsalog,$_.i);$_.rsprod();var _F0=$k[--$j];var _F1=$k[--$j];$p($k[--$j],_F1,_F0)}$_.nd=$_.rscws.length;$k[$j++]=Infinity;$q($_.rscws);for(var _F6=0,_F7=$_.rsnc;_F6<_F7;_F6++){$k[$j++]=0}$k[$j++]=0;$_.rscws=$a();for(var _FB=0,_FA=$_.nd-1;_FB<=_FA;_FB+=1){$_.k=$xo($g($_.rscws,_FB),$g($_.rscws,$_.nd));for(var _FJ=0,_FI=$_.rsnc-1;_FJ<=_FI;_FJ+=1){$_.j=_FJ;$k[$j++]=$_.rscws;$k[$j++]=$_.nd+$_.j;$k[$j++]=$g($_.rscws,$_.nd+$_.j+1);$k[$j++]=$_.k;$k[$j++]=$g($_.coeffs,$f($_.rsnc-$_.j)-1);$_.rsprod();var _FW=$k[--$j];var _FX=$k[--$j];var _FY=$k[--$j];$p($k[--$j],_FY,$xo(_FX,_FW))}}$k[$j++]=$G($_.rscws,0,$_.rscws.length-1)};if($eq($_.format,"full")){$_.mode=($_.layers-1<<11)+($_.cws.length-1);if($_.readerinit){$_.mode=$_.mode|1024}$_.mode=$a([($_.mode&61440)>>>12,($_.mode&3840)>>>8,($_.mode&240)>>>4,$_.mode&15]);$k[$j++]="mode";$k[$j++]=$_.mode;$k[$j++]=6;$k[$j++]=16;$k[$j++]=19;$_.rscodes();var _Fo=$k[--$j];$_[$k[--$j]]=_Fo}if($eq($_.format,"compact")){$_.mode=($_.layers-1<<6)+($_.cws.length-1);if($_.readerinit){$_.mode=$_.mode|32}$_.mode=$a([($_.mode&240)>>>4,$_.mode&15]);$k[$j++]="mode";$k[$j++]=$_.mode;$k[$j++]=5;$k[$j++]=16;$k[$j++]=19;$_.rscodes();var _Fz=$k[--$j];$_[$k[--$j]]=_Fz}if($eq($_.format,"rune")){$_.mode=$i($_.barcode);$_.mode=$a([($_.mode&240)>>>4,$_.mode&15]);$k[$j++]="mode";$k[$j++]=$_.mode;$k[$j++]=5;$k[$j++]=16;$k[$j++]=19;$_.rscodes();var _G7=$k[--$j];$_[$k[--$j]]=_G7;$k[$j++]=Infinity;var _G9=$_.mode;for(var _GA=0,_GB=_G9.length;_GA<_GB;_GA++){$k[$j++]=$g(_G9,_GA)^10}$_.mode=$a()}$_.modebits=$s($_.mode.length*4);for(var _GI=0,_GH=$_.modebits.length-1;_GI<=_GH;_GI+=1){$P($_.modebits,_GI,"0")}for(var _GM=0,_GL=$_.mode.length-1;_GM<=_GL;_GM+=1){$_.i=_GM;var _GS=$R($s(4),$g($_.mode,$_.i),2);$P($_.modebits,4-_GS.length+4*$_.i,_GS)}$_.rsparams=$a([$a([]),$a([]),$a([]),$a([]),$a([]),$a([]),$a([64,67]),$a([]),$a([256,301]),$a([]),$a([1024,1033]),$a([]),$a([4096,4201])]);$k[$j++]="cws";$k[$j++]=$_.cws;$k[$j++]=$f($_.ncws-$_.cws.length);$q($g($_.rsparams,$_.bpcw));$_.rscodes();var _Gp=$k[--$j];$_[$k[--$j]]=_Gp;if($eq($_.format,"full")){$_.databits=$s($f($_.layers*$_.layers*16+$_.layers*112))}else{$_.databits=$s($f($_.layers*$_.layers*16+$_.layers*88))}for(var _H2=0,_H1=$_.databits.length-1;_H2<=_H1;_H2+=1){$P($_.databits,_H2,"0")}for(var _H6=0,_H5=$_.ncws-1;_H6<=_H5;_H6+=1){$_.i=_H6;var _HD=$R($s($_.bpcw),$g($_.cws,$_.i),2);$P($_.databits,$f($_.bpcw-_HD.length+$_.bpcw*$_.i+($_.databits.length-$_.ncws*$_.bpcw)),_HD)}$_.cmv=function(){var _HL=$k[--$j];var _HM=$k[--$j];$k[$j++]=$f(_HM-_HL*$_.size+$_.mid)};$_.lmv=function(){$_.lbit=$k[--$j];$_.llyr=$k[--$j];$_.lwid=$f($_.fw+$_.llyr*4);$_.ldir=~~(~~($_.lbit/2)/$_.lwid);if($_.ldir==0){$k[$j++]=$f(-~~(($_.lwid-1)/2)+1+~~($_.lbit/2)%$_.lwid);$k[$j++]=$f(~~(($_.fw-1)/2)+$_.llyr*2+$_.lbit%2);$_.cmv()}if($_.ldir==1){$k[$j++]=$f(~~($_.fw/2)+$_.llyr*2+$_.lbit%2);$k[$j++]=$f(~~(($_.lwid-1)/2)-1-~~($_.lbit/2)%$_.lwid);$_.cmv()}if($_.ldir==2){$k[$j++]=-$f(-~~($_.lwid/2)+1+~~($_.lbit/2)%$_.lwid);$k[$j++]=-$f(~~($_.fw/2)+$_.llyr*2+$_.lbit%2);$_.cmv()}if($_.ldir==3){$k[$j++]=-$f(~~(($_.fw-1)/2)+$_.llyr*2+$_.lbit%2);$k[$j++]=-$f(~~($_.lwid/2)-1-~~($_.lbit/2)%$_.lwid);$_.cmv()}};if($eq($_.format,"full")){$_.fw=12}else{$_.fw=9}$_.size=$f($_.fw+$_.layers*4)+2;$k[$j++]=Infinity;for(var _I1=0,_I2=$_.size*$_.size;_I1<_I2;_I1++){$k[$j++]=-1}$_.pixs=$a();$_.mid=$f(~~(($_.size-1)/2)*$_.size+~~(($_.size-1)/2));$_.i=0;for(var _I9=1,_I8=$_.layers;_I9<=_I8;_I9+=1){$_.layer=_I9;for(var _ID=0,_IC=($_.fw+$_.layer*4)*8-1;_ID<=_IC;_ID+=1){$_.pos=_ID;$k[$j++]=$_.pixs;$k[$j++]=$_.layer;$k[$j++]=$_.pos;$_.lmv();var _IL=$k[--$j];$p($k[--$j],_IL,$g($_.databits,$_.databits.length-$_.i-1)-48);$_.i=$_.i+1}}if($eq($_.format,"full")){$_.fw=13;$_.size=$f($_.fw+$_.layers*4+2+~~(($_.layers+10.5)/7.5-1)*2);$_.mid=~~($_.size*$_.size/2);$k[$j++]=Infinity;for(var _IW=0,_IX=$_.size*$_.size;_IW<_IX;_IW++){$k[$j++]=-2}$_.npixs=$a();for(var _Ib=0,_Ia=~~($_.size/2);_Ib<=_Ia;_Ib+=16){$_.i=_Ib;for(var _Ie=0,_Id=$_.size-1;_Ie<=_Id;_Ie+=1){$_.j=_Ie;$k[$j++]=$_.npixs;$k[$j++]=-~~($_.size/2)+$_.j;$k[$j++]=$_.i;$_.cmv();var _In=$k[--$j];$P($k[--$j],_In,$a([(~~($_.size/2)+$_.j+$_.i+1)%2]));$k[$j++]=$_.npixs;$k[$j++]=-~~($_.size/2)+$_.j;$k[$j++]=-$_.i;$_.cmv();var _Ix=$k[--$j];$P($k[--$j],_Ix,$a([(~~($_.size/2)+$_.j+$_.i+1)%2]));$k[$j++]=$_.npixs;$k[$j++]=$_.i;$k[$j++]=-~~($_.size/2)+$_.j;$_.cmv();var _J7=$k[--$j];$P($k[--$j],_J7,$a([(~~($_.size/2)+$_.j+$_.i+1)%2]));$k[$j++]=$_.npixs;$k[$j++]=-$_.i;$k[$j++]=-~~($_.size/2)+$_.j;$_.cmv();var _JH=$k[--$j];$P($k[--$j],_JH,$a([(~~($_.size/2)+$_.j+$_.i+1)%2]))}}$_.j=0;for(var _JL=0,_JK=$_.npixs.length-1;_JL<=_JK;_JL+=1){$_.i=_JL;if($g($_.npixs,$_.i)==-2){$p($_.npixs,$_.i,$g($_.pixs,$_.j));$_.j=$_.j+1}}$_.pixs=$_.npixs}$_.fw=~~($_.fw/2);for(var _Ja=-$_.fw,_JZ=$_.fw;_Ja<=_JZ;_Ja+=1){$_.i=_Ja;for(var _Je=-$_.fw,_Jd=$_.fw;_Je<=_Jd;_Je+=1){$_.j=_Je;$k[$j++]=$_.pixs;$k[$j++]=$_.i;$k[$j++]=$_.j;$_.cmv();if($abs($_.i)>$abs($_.j)){$k[$j++]=$abs($_.i)}else{$k[$j++]=$abs($_.j)}var _Jm=$k[--$j];var _Jn=$k[--$j];$p($k[--$j],_Jn,(_Jm+1)%2)}}var _KP=$a([$a([-($_.fw+1),$_.fw,1]),$a([-($_.fw+1),$_.fw+1,1]),$a([-$_.fw,$_.fw+1,1]),$a([$_.fw+1,$_.fw+1,1]),$a([$_.fw+1,$_.fw,1]),$a([$_.fw+1,-$_.fw,1]),$a([$_.fw,$_.fw+1,0]),$a([$_.fw+1,-($_.fw+1),0]),$a([$_.fw,-($_.fw+1),0]),$a([-$_.fw,-($_.fw+1),0]),$a([-($_.fw+1),-($_.fw+1),0]),$a([-($_.fw+1),-$_.fw,0])]);for(var _KQ=0,_KR=_KP.length;_KQ<_KR;_KQ++){$k[$j++]=$_.pixs;$q($g(_KP,_KQ));$r(3,1);$_.cmv();var _KU=$k[--$j];var _KV=$k[--$j];$p($k[--$j],_KU,_KV)}$_.modemapfull=$a([$a([-5,7]),$a([-4,7]),$a([-3,7]),$a([-2,7]),$a([-1,7]),$a([1,7]),$a([2,7]),$a([3,7]),$a([4,7]),$a([5,7]),$a([7,5]),$a([7,4]),$a([7,3]),$a([7,2]),$a([7,1]),$a([7,-1]),$a([7,-2]),$a([7,-3]),$a([7,-4]),$a([7,-5]),$a([5,-7]),$a([4,-7]),$a([3,-7]),$a([2,-7]),$a([1,-7]),$a([-1,-7]),$a([-2,-7]),$a([-3,-7]),$a([-4,-7]),$a([-5,-7]),$a([-7,-5]),$a([-7,-4]),$a([-7,-3]),$a([-7,-2]),$a([-7,-1]),$a([-7,1]),$a([-7,2]),$a([-7,3]),$a([-7,4]),$a([-7,5])]);$_.modemapcompact=$a([$a([-3,5]),$a([-2,5]),$a([-1,5]),$a([0,5]),$a([1,5]),$a([2,5]),$a([3,5]),$a([5,3]),$a([5,2]),$a([5,1]),$a([5,0]),$a([5,-1]),$a([5,-2]),$a([5,-3]),$a([3,-5]),$a([2,-5]),$a([1,-5]),$a([0,-5]),$a([-1,-5]),$a([-2,-5]),$a([-3,-5]),$a([-5,-3]),$a([-5,-2]),$a([-5,-1]),$a([-5,0]),$a([-5,1]),$a([-5,2]),$a([-5,3])]);$k[$j++]="modemap";if($eq($_.format,"full")){$k[$j++]=$_.modemapfull}else{$k[$j++]=$_.modemapcompact}var _Lj=$k[--$j];$_[$k[--$j]]=_Lj;for(var _Ln=0,_Lm=$_.modemap.length-1;_Ln<=_Lm;_Ln+=1){$k[$j++]=_Ln;$k[$j++]=$_.pixs;$q($g($_.modemap,_Ln));$_.cmv();var _Ls=$k[--$j];var _Lt=$k[--$j];$p(_Lt,_Ls,$g($_.modebits,$k[--$j])-48)}var _M2=new Map([["ren","renmatrix"],["pixs",$_.pixs],["pixx",$_.size],["pixy",$_.size],["height",$_.size*2/72],["width",$_.size*2/72],["opt",$_.options]]);$k[$j++]=_M2;if(!$_.dontdraw){bwipp_renmatrix()}$_=$__}function bwipp_azteccodecompact(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];$p($_.options,"dontdraw",true);$p($_.options,"format","compact");$k[$j++]="args";$k[$j++]=$_.barcode;$k[$j++]=$_.options;bwipp_azteccode();var _6=$k[--$j];$_[$k[--$j]]=_6;$p($_.args,"opt",$_.options);$k[$j++]=$_.args;if(!$_.dontdraw){bwipp_renmatrix()}$_=$__}function bwipp_aztecrune(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];$p($_.options,"dontdraw",true);$p($_.options,"format","rune");$k[$j++]="args";$k[$j++]=$_.barcode;$k[$j++]=$_.options;bwipp_azteccode();var _6=$k[--$j];$_[$k[--$j]]=_6;$p($_.args,"opt",$_.options);$k[$j++]=$_.args;if(!$_.dontdraw){bwipp_renmatrix()}$_=$__}function bwipp_codeone(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.version="unset";$_.parse=false;$_.parsefnc=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];var _2=$a(["unset","T-16","T-32","T-48","S-10","S-20","S-30","A","B","C","D","E","F","G","H"]);$k[$j++]=false;for(var _3=0,_4=_2.length;_3<_4;_3++){var _7=$k[--$j];$k[$j++]=_7||$eq($g(_2,_3),$_.version)}if(!$k[--$j]){$k[$j++]="bwipp.codeoneBadVersion#24394";$k[$j++]="version must be A to H, T-16, T-32, T-48, S-10, S-20 or S-30";bwipp_raiseerror()}$_.stype=$eq($G($_.version,0,1),"S");$_.ttype=$eq($G($_.version,0,1),"T");$_.stypevals=$a(["1","1010","1100100","1111101000","10011100010000","11000011010100000","11110100001001000000","100110001001011010000000","101111101011110000100000000","111011100110101100101000000000","1001010100000010111110010000000000","1011101001000011101101110100000000000","1110100011010100101001010001000000000000","10010001100001001110011100101010000000000000","10110101111001100010000011110100100000000000000","11100011010111111010100100110001101000000000000000","100011100001101111001001101111110000010000000000000000","101100011010001010111100001011101100010100000000000000000"]);$_.stypemetrics=$a([$a(["S-10",8,11,10,4,4,1,99,99,99]),$a(["S-20",8,21,20,8,8,1,99,99,99]),$a(["S-30",8,31,30,12,12,1,99,99,99])]);$_.nonstypemetrics=$a([$a(["A",16,18,16,10,10,1,4,99,6]),$a(["B",22,22,20,19,16,1,4,99,8]),$a(["C",28,32,28,44,26,1,4,22,11]),$a(["D",40,42,36,91,44,1,4,16,16]),$a(["E",52,54,48,182,70,1,4,22,22]),$a(["F",70,76,68,370,140,2,4,22,31]),$a(["G",104,98,88,732,280,4,6,21,47]),$a(["H",148,134,120,1480,560,8,6,20,69]),$a(["T-16",16,17,16,10,10,1,99,99,99]),$a(["T-32",16,33,32,24,16,1,99,99,99]),$a(["T-48",16,49,48,38,22,1,99,99,99])]);$_.fnc1=-1;$_.fnc3=-2;$_.lC=-5;$_.lB=-6;$_.lX=-7;$_.lT=-8;$_.lD=-9;$_.unl=-10;$_.fnc2=-11;$_.fnc4=-12;$_.sft1=-13;$_.sft2=-14;$_.sft3=-15;$_.eci=-16;$_.pad=-17;$_.fnc1lD=-18;$_.unlcw=255;$k[$j++]=Infinity;for(var _U=0;_U<=128;_U+=1){$k[$j++]=_U;$k[$j++]=_U+1}$k[$j++]=$_.pad;$k[$j++]=129;for(var _W=0;_W<=99;_W+=1){var _Y=$R($s(2),_W,10);var _a=$Z($s(2),"00");$P(_a,2-_Y.length,_Y);$k[$j++]=_a;$k[$j++]=_W+130}var _i=$a([$_.lC,$_.lB,$_.fnc1,$_.fnc2,$_.fnc3,$_.fnc4,$_.fnc1lD]);$k[$j++]=229;for(var _j=0,_k=_i.length;_j<_k;_j++){var _n=$k[--$j]+1;$k[$j++]=$g(_i,_j);$k[$j++]=_n;$k[$j++]=_n}$k[$j-1]=$_.lX;$k[$j++]=238;$k[$j++]=$_.lT;$k[$j++]=239;$_.Avals=$d();$k[$j++]=Infinity;var _r=$_.Avals;for(var _w=_r.size,_v=_r.keys(),_u=0;_u<_w;_u++){var _s=_v.next().value;$k[$j++]=_s;var _x=Infinity;var _y=_r.get(_s);$k[$j++]=_x;$k[$j++]=_y;var _z=$a();$k[$j++]=_z}$_.Avals=$d();$k[$j++]=Infinity;$k[$j++]=$_.sft1;$k[$j++]=0;$k[$j++]=$_.sft2;$k[$j++]=1;$k[$j++]=$_.sft3;$k[$j++]=2;$k[$j++]=32;$k[$j++]=3;for(var _14=48;_14<=57;_14+=1){$k[$j++]=_14;$k[$j++]=_14-44}for(var _15=65;_15<=90;_15+=1){$k[$j++]=_15;$k[$j++]=_15-51}$_.CNvals=$d();$k[$j++]=Infinity;for(var _17=0;_17<=31;_17+=1){$k[$j++]=_17;$k[$j++]=_17}$_.C1vals=$d();$k[$j++]=Infinity;for(var _19=33;_19<=47;_19+=1){$k[$j++]=_19;$k[$j++]=_19-33}for(var _1A=58;_1A<=64;_1A+=1){$k[$j++]=_1A;$k[$j++]=_1A-43}for(var _1B=91;_1B<=95;_1B+=1){$k[$j++]=_1B;$k[$j++]=_1B-69}$k[$j++]=$_.fnc1;$k[$j++]=27;$k[$j++]=$_.fnc2;$k[$j++]=28;$k[$j++]=$_.fnc3;$k[$j++]=29;$k[$j++]=$_.fnc4;$k[$j++]=30;$k[$j++]=$_.pad;$k[$j++]=31;$_.C2vals=$d();$k[$j++]=Infinity;for(var _1I=96;_1I<=127;_1I+=1){$k[$j++]=_1I;$k[$j++]=_1I-96}$_.C3vals=$d();$k[$j++]=Infinity;var _1K=$_.CNvals;for(var _1P=_1K.size,_1O=_1K.keys(),_1N=0;_1N<_1P;_1N++){var _1L=_1O.next().value;$k[$j++]=_1L;var _1Q=Infinity;var _1R=_1K.get(_1L);$k[$j++]=_1Q;$k[$j++]=_1R;var _1S=$a();$k[$j++]=_1S}var _1T=$_.C1vals;for(var _1Y=_1T.size,_1X=_1T.keys(),_1W=0;_1W<_1Y;_1W++){var _1U=_1X.next().value;$k[$j++]=_1U;var _1Z=Infinity;var _1a=_1T.get(_1U);$k[$j++]=_1Z;$k[$j++]=$g($_.CNvals,$_.sft1);$k[$j++]=_1a;var _1e=$a();$k[$j++]=_1e}var _1f=$_.C2vals;for(var _1k=_1f.size,_1j=_1f.keys(),_1i=0;_1i<_1k;_1i++){var _1g=_1j.next().value;$k[$j++]=_1g;var _1l=Infinity;var _1m=_1f.get(_1g);$k[$j++]=_1l;$k[$j++]=$g($_.CNvals,$_.sft2);$k[$j++]=_1m;var _1q=$a();$k[$j++]=_1q}var _1r=$_.C3vals;for(var _1w=_1r.size,_1v=_1r.keys(),_1u=0;_1u<_1w;_1u++){var _1s=_1v.next().value;$k[$j++]=_1s;var _1x=Infinity;var _1y=_1r.get(_1s);$k[$j++]=_1x;$k[$j++]=$g($_.CNvals,$_.sft3);$k[$j++]=_1y;var _22=$a();$k[$j++]=_22}$_.Cvals=$d();$k[$j++]=Infinity;$k[$j++]=$_.sft1;$k[$j++]=0;$k[$j++]=$_.sft2;$k[$j++]=1;$k[$j++]=$_.sft3;$k[$j++]=2;$k[$j++]=32;$k[$j++]=3;for(var _27=48;_27<=57;_27+=1){$k[$j++]=_27;$k[$j++]=_27-44}for(var _28=97;_28<=122;_28+=1){$k[$j++]=_28;$k[$j++]=_28-83}$_.TNvals=$d();$k[$j++]=Infinity;for(var _2A=0;_2A<=31;_2A+=1){$k[$j++]=_2A;$k[$j++]=_2A}$_.T1vals=$d();$k[$j++]=Infinity;for(var _2C=33;_2C<=47;_2C+=1){$k[$j++]=_2C;$k[$j++]=_2C-33}for(var _2D=58;_2D<=64;_2D+=1){$k[$j++]=_2D;$k[$j++]=_2D-43}for(var _2E=91;_2E<=95;_2E+=1){$k[$j++]=_2E;$k[$j++]=_2E-69}$k[$j++]=$_.fnc1;$k[$j++]=27;$k[$j++]=$_.fnc2;$k[$j++]=28;$k[$j++]=$_.fnc3;$k[$j++]=29;$k[$j++]=$_.fnc4;$k[$j++]=30;$k[$j++]=$_.pad;$k[$j++]=31;$_.T2vals=$d();$k[$j++]=Infinity;$k[$j++]=96;$k[$j++]=0;for(var _2L=65;_2L<=90;_2L+=1){$k[$j++]=_2L;$k[$j++]=_2L-64}for(var _2M=123;_2M<=127;_2M+=1){$k[$j++]=_2M;$k[$j++]=_2M-96}$_.T3vals=$d();$k[$j++]=Infinity;var _2O=$_.TNvals;for(var _2T=_2O.size,_2S=_2O.keys(),_2R=0;_2R<_2T;_2R++){var _2P=_2S.next().value;$k[$j++]=_2P;var _2U=Infinity;var _2V=_2O.get(_2P);$k[$j++]=_2U;$k[$j++]=_2V;var _2W=$a();$k[$j++]=_2W}var _2X=$_.T1vals;for(var _2c=_2X.size,_2b=_2X.keys(),_2a=0;_2a<_2c;_2a++){var _2Y=_2b.next().value;$k[$j++]=_2Y;var _2d=Infinity;var _2e=_2X.get(_2Y);$k[$j++]=_2d;$k[$j++]=$g($_.TNvals,$_.sft1);$k[$j++]=_2e;var _2i=$a();$k[$j++]=_2i}var _2j=$_.T2vals;for(var _2o=_2j.size,_2n=_2j.keys(),_2m=0;_2m<_2o;_2m++){var _2k=_2n.next().value;$k[$j++]=_2k;var _2p=Infinity;var _2q=_2j.get(_2k);$k[$j++]=_2p;$k[$j++]=$g($_.TNvals,$_.sft2);$k[$j++]=_2q;var _2u=$a();$k[$j++]=_2u}var _2v=$_.T3vals;for(var _30=_2v.size,_2z=_2v.keys(),_2y=0;_2y<_30;_2y++){var _2w=_2z.next().value;$k[$j++]=_2w;var _31=Infinity;var _32=_2v.get(_2w);$k[$j++]=_31;$k[$j++]=$g($_.TNvals,$_.sft3);$k[$j++]=_32;var _36=$a();$k[$j++]=_36}$_.Tvals=$d();for(var _38=128;_38<=255;_38+=1){$_.i=_38;$k[$j++]=$_.Avals;$k[$j++]=$_.i;$k[$j++]=Infinity;$q($g($_.Avals,$_.fnc4));$q($g($_.Avals,$_.i-128));var _3H=$a();var _3I=$k[--$j];$p($k[--$j],_3I,_3H);$k[$j++]=$_.Cvals;$k[$j++]=$_.i;$k[$j++]=Infinity;$q($g($_.Cvals,$_.fnc4));$q($g($_.Cvals,$_.i-128));var _3S=$a();var _3T=$k[--$j];$p($k[--$j],_3T,_3S);$k[$j++]=$_.Tvals;$k[$j++]=$_.i;$k[$j++]=Infinity;$q($g($_.Tvals,$_.fnc4));$q($g($_.Tvals,$_.i-128));var _3d=$a();var _3e=$k[--$j];$p($k[--$j],_3e,_3d)}$k[$j++]=Infinity;$k[$j++]=13;$k[$j++]=0;$k[$j++]=42;$k[$j++]=1;$k[$j++]=62;$k[$j++]=2;$k[$j++]=32;$k[$j++]=3;for(var _3g=48;_3g<=57;_3g+=1){$k[$j++]=_3g;$k[$j++]=_3g-44}for(var _3h=65;_3h<=90;_3h+=1){$k[$j++]=_3h;$k[$j++]=_3h-51}$_.Xvals=$d();$k[$j++]=Infinity;var _3j=$_.Xvals;for(var _3o=_3j.size,_3n=_3j.keys(),_3m=0;_3m<_3o;_3m++){var _3k=_3n.next().value;$k[$j++]=_3k;var _3p=Infinity;var _3q=_3j.get(_3k);$k[$j++]=_3p;$k[$j++]=_3q;var _3r=$a();$k[$j++]=_3r}$_.Xvals=$d();$k[$j++]=Infinity;for(var _3t=0;_3t<=255;_3t+=1){$k[$j++]=_3t;$k[$j++]=_3t}$_.Bvals=$d();$k[$j++]=Infinity;var _3v=$_.Bvals;for(var _40=_3v.size,_3z=_3v.keys(),_3y=0;_3y<_40;_3y++){var _3w=_3z.next().value;$k[$j++]=_3w;var _41=Infinity;var _42=_3v.get(_3w);$k[$j++]=_41;$k[$j++]=_42;var _43=$a();$k[$j++]=_43}$_.Bvals=$d();$_.encvals=$a([$_.Avals,$_.Cvals,$_.Tvals,$_.Xvals,-1,$_.Bvals]);$_.A=0;$_.C=1;$_.T=2;$_.X=3;$_.D=4;$_.B=5;if($_.stype){$F($_.barcode,function(){var _4E=$k[--$j];if(_4E<48||_4E>57){$k[$j++]="bwipp.codeoneStypeNonDigit#24564";$k[$j++]="S-Type symbols can only contain digits";bwipp_raiseerror()}});$_.barlen=$_.barcode.length;if($_.barlen>18){$k[$j++]="bwipp.codeoneStypeTooLong#24570";$k[$j++]="Maximum length exceeded";bwipp_raiseerror()}$_.normalize=function(){$_.base=$k[--$j];$_.num=$k[--$j];for(var _4K=$_.num.length-1;_4K>=1;_4K-=1){$_.i=_4K;var _4L=$_.num;var _4M=$_.i;$p(_4L,_4M-1,$f($g(_4L,_4M-1)+~~($g($_.num,$_.i)/$_.base)));$p($_.num,$_.i,$g($_.num,$_.i)%$_.base)}for(;;){if($lt($g($_.num,0),$_.base)){break}$k[$j++]=Infinity;$k[$j++]=0;$q($_.num);$_.num=$a();$p($_.num,0,$f($g($_.num,0)+~~($g($_.num,1)/$_.base)));$p($_.num,1,$g($_.num,1)%$_.base)}$k[$j++]=Infinity;$_.i=true;var _4n=$_.num;for(var _4o=0,_4p=_4n.length;_4o<_4p;_4o++){var _4q=$g(_4n,_4o);$k[$j++]=_4q;if(_4q==0&&$_.i){$j--}else{$_.i=false}}$_.num=$a();if($_.num.length==0){$_.num=$a([0])}$k[$j++]=$_.num};$_.bigadd=function(){var _4w=$k[--$j];var _4x=$k[--$j];$_.offset=$abs(_4w.length-_4x.length);if(_4w.length<_4x.length){var _=_4w;_4w=_4x;_4x=_}$_.a=_4w;$_.b=_4x;for(var _50=0,_4z=$_.b.length-1;_50<=_4z;_50+=1){var _51=$_.a;var _52=$_.offset;$p(_51,_50+_52,$f($g(_51,_50+_52)+$g($_.b,_50)))}$k[$j++]=$_.a};$_.barlen=$_.barcode.length;$_.v=$a([1]);for(var _5B=0,_5A=$_.barlen-1;_5B<=_5A;_5B+=1){$_.i=_5B;$k[$j++]=Infinity;$F($g($_.stypevals,$_.i),function(){var _5F=$k[--$j];$k[$j++]=(_5F-48)*($g($_.barcode,$_.barlen-$_.i-1)-48)});var _5K=$a();$k[$j++]=_5K;$k[$j++]=$_.v;$_.bigadd();$_.v=$k[--$j]}$k[$j++]="v";$k[$j++]=$_.v;$k[$j++]=2;$_.normalize();var _5O=$k[--$j];$_[$k[--$j]]=_5O;$k[$j++]=Infinity;for(var _5R=0,_5S=(5-$_.v.length%5)%5;_5R<_5S;_5R++){$k[$j++]=0}$q($_.v);$_.v=$a();$_.cws=$a(~~($_.v.length/5));for(var _5Z=0,_5Y=$_.cws.length-1;_5Z<=_5Y;_5Z+=1){$_.i=_5Z;var _5c=$G($_.v,$_.i*5,5);$k[$j++]=0;for(var _5d=0,_5e=_5c.length;_5d<_5e;_5d++){var _5g=$k[--$j];$k[$j++]=$f(_5g+$g(_5c,_5d))*2}$p($_.cws,$_.i,~~($k[--$j]/2))}$_.metrics=$_.stypemetrics}else{var _5p=new Map([["parse",$_.parse],["parsefnc",$_.parsefnc],["eci",true],["FNC1",$_.fnc1],["FNC3",$_.fnc3]]);$_.fncvals=_5p;$k[$j++]="msg";$k[$j++]=$_.barcode;$k[$j++]=$_.fncvals;bwipp_parseinput();var _5s=$k[--$j];$_[$k[--$j]]=_5s;$_.msglen=$_.msg.length;$_.eciesc=92;var _5v=$_.msg;$k[$j++]="numecis";$k[$j++]=0;for(var _5w=0,_5x=_5v.length;_5w<_5x;_5w++){if($g(_5v,_5w)<=-1e6){var _5z=$k[--$j];$k[$j++]=_5z+1}}var _60=$k[--$j];$_[$k[--$j]]=_60;if($_.numecis>0){$_.msgtmp=$a($f($_.msg.length*2+$_.numecis*6)+2);$p($_.msgtmp,0,$_.pad);$p($_.msgtmp,1,$_.eciesc);$_.j=2;for(var _6C=0,_6B=$_.msg.length-1;_6C<=_6B;_6C+=1){var _6E=$g($_.msg,_6C);$k[$j++]=_6E;if(_6E<=-1e6){var _6I=$G($R($s(7),-$k[--$j],10),1,6);for(var _6J=0,_6K=_6I.length;_6J<_6K;_6J++){$k[$j++]=$g(_6I,_6J)}$as($a(6));$P($_.msgtmp,$_.j+1,$k[--$j]);$p($_.msgtmp,$_.j,$_.eciesc);$_.j=$_.j+7}else{var _6U=$k[$j-1];if(_6U!=$_.eciesc){$p($_.msgtmp,$_.j,$k[--$j]);$_.j=$_.j+1}else{$j--;$p($_.msgtmp,$_.j,$_.eciesc);$p($_.msgtmp,$_.j+1,$_.eciesc);$_.j=$_.j+2}}}$_.msg=$G($_.msgtmp,0,$_.j);$_.msglen=$_.msg.length}$_.metrics=$_.nonstypemetrics;$_.fullcws=$a([]);var _6n=$_.metrics;for(var _6o=0,_6p=_6n.length;_6o<_6p;_6o++){$_.m=$g(_6n,_6o);$_.vers=$g($_.m,0);$_.dcws=$g($_.m,4);$_.okay=true;if($eq($_.version,"unset")){if($_.vers.length!=1){$_.okay=false}}else{if($ne($_.version,$_.vers)){$_.okay=false}}if($_.okay){$k[$j++]=Infinity;$q($_.fullcws);$k[$j++]=$_.dcws;$_.fullcws=$a()}}$k[$j++]=Infinity;for(var _73=0;_73<1480;_73++){$k[$j++]=1e4}$_.numremcws=$a();var _75=$_.fullcws;for(var _76=0,_77=_75.length;_76<_77;_76++){$p($_.numremcws,$g(_75,_76)-1,1)}for(var _7A=1478;_7A>=0;_7A-=1){$_.i=_7A;if($g($_.numremcws,$_.i)!=1){$p($_.numremcws,$_.i,$g($_.numremcws,$_.i+1)+1)}}$k[$j++]=Infinity;for(var _7K=0,_7L=$_.msglen;_7K<_7L;_7K++){$k[$j++]=0}$k[$j++]=0;$_.numD=$a();$k[$j++]=Infinity;for(var _7O=0,_7P=$_.msglen;_7O<_7P;_7O++){$k[$j++]=0}$k[$j++]=9999;$_.nextXterm=$a();$k[$j++]=Infinity;for(var _7S=0,_7T=$_.msglen;_7S<_7T;_7S++){$k[$j++]=0}$k[$j++]=9999;$_.nextNonX=$a();for(var _7W=$_.msglen-1;_7W>=0;_7W-=1){$_.i=_7W;$_.barchar=$g($_.msg,$_.i);if($_.barchar>=48&&$_.barchar<=57){$p($_.numD,$_.i,$g($_.numD,$_.i+1)+1)}if($_.barchar==13||$_.barchar==42||$_.barchar==62){$p($_.nextXterm,$_.i,0)}else{$p($_.nextXterm,$_.i,$g($_.nextXterm,$_.i+1)+1)}var _7t=$g($_.Xvals,$_.barchar)!==undefined;if(!_7t){$p($_.nextNonX,$_.i,0)}else{$p($_.nextNonX,$_.i,$g($_.nextNonX,$_.i+1)+1)}}$k[$j++]=Infinity;var _81=$_.nextXterm;for(var _82=0,_83=_81.length;_82<_83;_82++){var _84=$g(_81,_82);$k[$j++]=_84;if(_84>1e4){$k[$j-1]=1e4}}$_.nextXterm=$a();$k[$j++]=Infinity;var _86=$_.nextNonX;for(var _87=0,_88=_86.length;_87<_88;_87++){var _89=$g(_86,_87);$k[$j++]=_89;if(_89>1e4){$k[$j-1]=1e4}}$_.nextNonX=$a();$_.isD=function(){$k[$j++]=$_.char>=48&&$_.char<=57};$_.isC=function(){var _8F=$g($_.CNvals,$_.char)!==undefined;$k[$j++]=_8F};$_.isT=function(){var _8I=$g($_.TNvals,$_.char)!==undefined;$k[$j++]=_8I};$_.isX=function(){var _8L=$g($_.Xvals,$_.char)!==undefined;$k[$j++]=_8L};$_.isEA=function(){$k[$j++]=$_.char>127};$_.isFN=function(){$k[$j++]=$_.char<0};$_.XtermFirst=function(){var _8O=$k[--$j];$k[$j++]=$lt($g($_.nextXterm,_8O),$g($_.nextNonX,_8O))};$_.lookup=function(){$_.ac=1;$_.cc=2;$_.tc=2;$_.xc=2;$_.bc=3;if($_.mode==$_.A){$_.ac=0;$_.cc=1;$_.tc=1;$_.xc=1;$_.bc=2}if($_.mode==$_.C){$_.cc=0}if($_.mode==$_.T){$_.tc=0}if($_.mode==$_.X){$_.xc=0}if($_.mode==$_.B){$_.bc=0}for(var _8d=0;_8d<1;_8d++){$_.k=0;for(;;){if($_.i+$_.k==$_.msglen){var _8l=$a([$_.ac,$_.cc,$_.tc,$_.xc]);$k[$j++]=true;for(var _8m=0,_8n=_8l.length;_8m<_8n;_8m++){var _8q=$k[--$j];$k[$j++]=_8q&&$_.bc<=$ceil($g(_8l,_8m))}if($k[--$j]){$k[$j++]=$_.B;break}var _8x=$a([$_.cc,$_.tc,$_.xc,$_.bc]);$k[$j++]=true;for(var _8y=0,_8z=_8x.length;_8y<_8z;_8y++){var _92=$k[--$j];$k[$j++]=_92&&$_.ac<=$ceil($g(_8x,_8y))}if($k[--$j]){$k[$j++]=$_.A;break}var _97=$a([$_.tc,$_.xc]);$k[$j++]=true;for(var _98=0,_99=_97.length;_98<_99;_98++){var _9C=$k[--$j];$k[$j++]=_9C&&$ceil($_.cc)<=$ceil($g(_97,_98))}if($k[--$j]){$k[$j++]=$_.C;break}var _9G=$a([$_.xc]);$k[$j++]=true;for(var _9H=0,_9I=_9G.length;_9H<_9I;_9H++){var _9L=$k[--$j];$k[$j++]=_9L&&$ceil($_.tc)<=$ceil($g(_9G,_9H))}if($k[--$j]){$k[$j++]=$_.T;break}$k[$j++]=$_.X;break}$_.char=$g($_.msg,$_.i+$_.k);$k[$j++]="ac";$k[$j++]=$_.ac;$_.isD();if($k[--$j]){var _9V=$k[--$j];$k[$j++]=$f(_9V+1/2)}else{$_.isEA();if($k[--$j]){var _9X=$k[--$j];$k[$j++]=$ceil(_9X)+2}else{var _9Y=$k[--$j];$k[$j++]=$ceil(_9Y)+1}}var _9Z=$k[--$j];$_[$k[--$j]]=_9Z;$k[$j++]="cc";$k[$j++]=$_.cc;$_.isC();if($k[--$j]){var _9d=$k[--$j];$k[$j++]=$f(_9d+.6666667)}else{$_.isEA();if($k[--$j]){var _9f=$k[--$j];$k[$j++]=$f(_9f+2.6666667)}else{var _9g=$k[--$j];$k[$j++]=$f(_9g+1.3333334)}}var _9h=$k[--$j];$_[$k[--$j]]=_9h;$k[$j++]="tc";$k[$j++]=$_.tc;$_.isT();if($k[--$j]){var _9l=$k[--$j];$k[$j++]=$f(_9l+.6666667)}else{$_.isEA();if($k[--$j]){var _9n=$k[--$j];$k[$j++]=$f(_9n+2.6666667)}else{var _9o=$k[--$j];$k[$j++]=$f(_9o+1.3333334)}}var _9p=$k[--$j];$_[$k[--$j]]=_9p;$k[$j++]="xc";$k[$j++]=$_.xc;$_.isX();if($k[--$j]){var _9t=$k[--$j];$k[$j++]=$f(_9t+.6666667)}else{$_.isEA();if($k[--$j]){var _9v=$k[--$j];$k[$j++]=$f(_9v+4.3333334)}else{var _9w=$k[--$j];$k[$j++]=$f(_9w+3.3333334)}}var _9x=$k[--$j];$_[$k[--$j]]=_9x;$k[$j++]="bc";$k[$j++]=$_.bc;$_.isFN();if($k[--$j]){var _A1=$k[--$j];$k[$j++]=_A1+3}else{var _A2=$k[--$j];$k[$j++]=_A2+1}var _A3=$k[--$j];$_[$k[--$j]]=_A3;if($_.k>=3){var _AA=$a([$_.ac,$_.cc,$_.tc,$_.xc]);$k[$j++]=true;for(var _AB=0,_AC=_AA.length;_AB<_AC;_AB++){var _AF=$k[--$j];$k[$j++]=_AF&&$_.bc+1<=$ceil($g(_AA,_AB))}if($k[--$j]){$k[$j++]=$_.B;break}var _AM=$a([$_.cc,$_.tc,$_.xc,$_.bc]);$k[$j++]=true;for(var _AN=0,_AO=_AM.length;_AN<_AO;_AN++){var _AR=$k[--$j];$k[$j++]=_AR&&$_.ac+1<=$ceil($g(_AM,_AN))}if($k[--$j]){$k[$j++]=$_.A;break}var _AY=$a([$_.ac,$_.cc,$_.xc,$_.bc]);$k[$j++]=true;for(var _AZ=0,_Aa=_AY.length;_AZ<_Aa;_AZ++){var _Ad=$k[--$j];$k[$j++]=_Ad&&$ceil($_.tc)+1<=$ceil($g(_AY,_AZ))}if($k[--$j]){$k[$j++]=$_.T;break}var _Ai=$a([$_.ac,$_.tc]);$k[$j++]=true;for(var _Aj=0,_Ak=_Ai.length;_Aj<_Ak;_Aj++){var _An=$k[--$j];$k[$j++]=_An&&$ceil($_.cc)+1<=$ceil($g(_Ai,_Aj))}if($k[--$j]){if($ceil($_.cc)<$ceil($_.xc)){$k[$j++]=$_.C;break}if($_.cc==$_.xc){$k[$j++]=$_.i+$_.k+1;$_.XtermFirst();if($k[--$j]){$k[$j++]=$_.X;break}else{$k[$j++]=$_.C;break}}}var _B3=$a([$_.ac,$_.cc,$_.tc,$_.bc]);$k[$j++]=true;for(var _B4=0,_B5=_B3.length;_B4<_B5;_B4++){var _B8=$k[--$j];$k[$j++]=_B8&&$ceil($_.xc)+1<=$ceil($g(_B3,_B4))}if($k[--$j]){$k[$j++]=$_.X;break}}$_.k=$_.k+1}}};$_.addtocws=function(){var _BC=$k[$j-1];if(_BC.length+$_.j>1480){$j--;$k[$j++]="bwipp.codeoneTooLong#24766";$k[$j++]="Maximum length exceeded";bwipp_raiseerror()}var _BE=$k[--$j];$P($_.cws,$_.j,_BE);$_.j=_BE.length+$_.j};$_.tobin=function(){var _BJ=$s($k[--$j]);$k[$j++]=_BJ;for(var _BL=0,_BK=_BJ.length-1;_BL<=_BK;_BL+=1){var _BM=$k[$j-1];$p(_BM,_BL,48)}var _BN=$k[$j-1];$k[$j++]=_BN;var _BO=$k[$j-3];var _BP=$k[$j-1];$k[$j-3]=$k[$j-2];$j-=2;var _BR=$R($s(_BP.length),_BO,2);$P(_BP,_BP.length-_BR.length,_BR);$k[$j++]=Infinity;var _BS=$k[--$j];var _BT=$k[--$j];$k[$j++]=_BS;$F(_BT,function(){var _BU=$k[--$j];$k[$j++]=_BU-48});var _BV=$a();$k[$j++]=_BV};$_.encA=function(){for(var _BW=0;_BW<1;_BW++){if($g($_.numD,$_.i)>=21){$_.Dbits=$a([1,1,1,1]);$_.mode=$_.D;break}var _Be=$g($_.numD,$_.i);if(_Be>=13&&$f(_Be+$_.i)==$_.msglen){$_.Dbits=$a([1,1,1,1]);$_.mode=$_.D;break}if($g($_.numD,$_.i)>=2){var _Bm=$s(2);$p(_Bm,0,$g($_.msg,$_.i));$p(_Bm,1,$g($_.msg,$_.i+1));$k[$j++]=$g($_.Avals,_Bm);$_.addtocws();$_.i=$_.i+2;break}if($g($_.msg,$_.i)==$_.fnc1){if($g($_.numD,$_.i+1)>=15){$k[$j++]=$g($_.Avals,$_.fnc1lD);$_.addtocws();$_.i=$_.i+1;$_.Dbits=$a([]);$_.mode=$_.D;break}var _CB=$g($_.numD,$_.i+1);if(_CB>=7&&$f(_CB+$_.i)+1==$_.msglen){$k[$j++]=$g($_.Avals,$_.fnc1lD);$_.addtocws();$_.i=$_.i+1;$_.Dbits=$a([]);$_.mode=$_.D;break}}$k[$j++]="newmode";$_.lookup();var _CK=$k[--$j];$_[$k[--$j]]=_CK;if($_.newmode!=$_.mode){$k[$j++]=$g($_.Avals,$g($a([-1,$_.lC,$_.lT,$_.lX,$_.lD,$_.lB]),$_.newmode));$_.addtocws();$_.mode=$_.newmode;break}$k[$j++]=$g($_.Avals,$g($_.msg,$_.i));$_.addtocws();$_.i=$_.i+1;break}};$_.CTXvalstocws=function(){$_.in=$k[--$j];$k[$j++]=Infinity;for(var _Ci=0,_Ch=$_.in.length-1;_Ci<=_Ch;_Ci+=3){var _Ck=$G($_.in,_Ci,3);$k[$j++]=0;for(var _Cl=0,_Cm=_Ck.length;_Cl<_Cm;_Cl++){var _Co=$k[--$j];$k[$j++]=$f(_Co+$g(_Ck,_Cl))*40}var _Cq=~~($k[--$j]/40)+1;$k[$j++]=~~(_Cq/256);$k[$j++]=_Cq%256}$as($a($m()));var _Ct=$k[--$j];$k[$j-1]=_Ct};$_.encCTX=function(){$_.p=0;$_.ctxvals=$a(2220);for(;;){if($_.i==$_.msglen){break}if($_.p%3==0){if($g($_.numD,$_.i)>=12){$k[$j++]=$G($_.ctxvals,0,$_.p);$_.CTXvalstocws();$_.addtocws();$k[$j++]=$a([$_.unlcw]);$_.addtocws();$_.mode=$_.A;break}var _DA=$g($_.numD,$_.i);if(_DA>=8&&$f(_DA+$_.i)==$_.msglen){$k[$j++]=$G($_.ctxvals,0,$_.p);$_.CTXvalstocws();$_.addtocws();$k[$j++]=$a([$_.unlcw]);$_.addtocws();$_.mode=$_.A;break}if($_.mode==$_.X){var _DP=$g($_.Xvals,$g($_.msg,$_.i))!==undefined;if(!_DP){$k[$j++]=$G($_.ctxvals,0,$_.p);$_.CTXvalstocws();$_.addtocws();if($g($_.numremcws,$_.j)!=1||$g($_.msg,$_.i)>127){$k[$j++]=$a([$_.unlcw]);$_.addtocws()}$_.mode=$_.A;break}if($_.i+1<$_.msglen){var _Di=$g($_.Xvals,$g($_.msg,$_.i+1))!==undefined;if(!_Di){break}if($_.i+2<$_.msglen){var _Dp=$g($_.Xvals,$g($_.msg,$_.i+2))!==undefined;if(!_Dp){break}}}}else{$_.lookup();if($k[--$j]!=$_.mode){$k[$j++]=$G($_.ctxvals,0,$_.p);$_.CTXvalstocws();$_.addtocws();$k[$j++]=$a([$_.unlcw]);$_.addtocws();$_.mode=$_.A;break}}if($_.msglen-$_.i<=3){$_.remcws=$g($_.numremcws,$_.j+~~($_.p/3)*2);$k[$j++]=Infinity;var _E8=$G($_.msg,$_.i,$_.msglen-$_.i);for(var _E9=0,_EA=_E8.length;_E9<_EA;_E9++){var _EB=$g(_E8,_E9);var _EF=$g($g($_.encvals,$_.mode),_EB)!==undefined;$k[$j++]=_EB;if(_EF){$q($g($g($_.encvals,$_.mode),$k[--$j]))}else{$k[$j-1]=-1;$k[$j++]=-1;$k[$j++]=-1;$k[$j++]=-1}}$_.remvals=$a();if($_.remcws==2&&$_.remvals.length==3){$k[$j++]=Infinity;$q($G($_.ctxvals,0,$_.p));$q($_.remvals);var _ES=$a();$k[$j++]=_ES;$_.CTXvalstocws();$_.addtocws();$_.mode=$_.A;$_.i=$_.msglen;break}if($_.remcws==2&&$_.remvals.length==2&&$_.mode!=$_.X){$k[$j++]=Infinity;$q($G($_.ctxvals,0,$_.p));$q($_.remvals);$q($g($g($_.encvals,$_.mode),$_.sft1));var _Ei=$a();$k[$j++]=_Ei;$_.CTXvalstocws();$_.addtocws();$_.mode=$_.A;$_.i=$_.msglen;break}if($_.remcws==2&&$_.remvals.length==1){$k[$j++]=$G($_.ctxvals,0,$_.p);$_.CTXvalstocws();$_.addtocws();$k[$j++]=$a([$_.unlcw]);$_.addtocws();$k[$j++]=$g($_.Avals,$g($_.msg,$_.i));$_.addtocws();$_.mode=$_.A;$_.i=$_.msglen;break}if($_.remcws==1&&$_.remvals.length==1){$k[$j++]=$G($_.ctxvals,0,$_.p);$_.CTXvalstocws();$_.addtocws();$k[$j++]=$g($_.Avals,$g($_.msg,$_.i));$_.addtocws();$_.mode=$_.A;$_.i=$_.msglen;break}}}var _FH=$g($g($_.encvals,$_.mode),$g($_.msg,$_.i));$P($_.ctxvals,$_.p,_FH);$_.p=_FH.length+$_.p;$_.i=$_.i+1}if($_.mode!=$_.A){for(;;){if($_.p%3==0){break}$_.i=$_.i-1;$_.p=$_.p-$g($g($_.encvals,$_.mode),$g($_.msg,$_.i)).length}$k[$j++]=Infinity;$q($G($_.ctxvals,0,$_.p));var _Fb=$a();$k[$j++]=_Fb;$_.CTXvalstocws();$_.addtocws();$k[$j++]=$a([$_.unlcw]);$_.addtocws();$_.mode=$_.A;if($_.i!=$_.msglen){if($g($_.numD,$_.i)>=2){var _Fk=$s(2);$p(_Fk,0,$g($_.msg,$_.i));$p(_Fk,1,$g($_.msg,$_.i+1));$k[$j++]=$g($_.Avals,_Fk);$_.addtocws();$_.i=$_.i+2}else{$k[$j++]=$g($_.Avals,$g($_.msg,$_.i));$_.addtocws();$_.i=$_.i+1}}}};$_.encD=function(){for(;;){if($g($_.numD,$_.i)<3){$_.Drem=(8-$_.Dbits.length%8)%8;$_.remcws=$g($_.numremcws,$_.j+~~($_.Dbits.length/8));if(($g($_.numremcws,$_.j+~~($_.Dbits.length/8)-1)-1==0&&$_.Drem==0||$_.remcws==1&&$_.Drem!=0)&&$_.i==$_.msglen){if($_.Drem==4||$_.Drem==6){$k[$j++]=Infinity;$q($_.Dbits);$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$_.Dbits=$a()}if($_.Drem==2||$_.Drem==6){$k[$j++]=Infinity;$q($_.Dbits);$k[$j++]=0;$k[$j++]=1;$_.Dbits=$a()}break}if(($_.i==$_.msglen-1&&$g($_.numD,$_.i)==1||$_.i==$_.msglen-2&&$g($_.numD,$_.i)==2)&&$_.remcws==1&&$_.Drem==0){break}if(!($_.i==$_.msglen-1&&$g($_.numD,$_.i)==1&&$_.remcws==1&&($_.Drem==4||$_.Drem==6))){$k[$j++]=Infinity;$q($_.Dbits);$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$_.Dbits=$a();$_.Drem=(8-$_.Dbits.length%8)%8}if($_.Drem==4||$_.Drem==6){if($g($_.numD,$_.i)>=1){$k[$j++]=Infinity;$q($_.Dbits);$k[$j++]=$g($_.msg,$_.i)-48+1;$k[$j++]=4;$_.tobin();$q($k[--$j]);$_.Dbits=$a();$_.i=$_.i+1}else{$k[$j++]=Infinity;$q($_.Dbits);$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$_.Dbits=$a()}$_.Drem=$_.Drem-4}if($_.Drem==2){$k[$j++]=Infinity;$q($_.Dbits);$k[$j++]=0;$k[$j++]=1;$_.Dbits=$a();$_.Drem=0}break}$k[$j++]=Infinity;$q($_.Dbits);var _H7=$G($_.msg,$_.i,3);$k[$j++]=0;for(var _H8=0,_H9=_H7.length;_H8<_H9;_H8++){var _HB=$k[--$j];$k[$j++]=$f(_HB+($g(_H7,_H8)-48))*10}var _HC=$k[--$j];$k[$j++]=~~(_HC/10)+1;$k[$j++]=10;$_.tobin();$q($k[--$j]);$_.Dbits=$a();$_.i=$_.i+3}$k[$j++]=Infinity;for(var _HI=0,_HH=$_.Dbits.length-1;_HI<=_HH;_HI+=8){var _HK=$G($_.Dbits,_HI,8);$k[$j++]=0;for(var _HL=0,_HM=_HK.length;_HL<_HM;_HL++){var _HO=$k[--$j];$k[$j++]=$f(_HO+$g(_HK,_HL))*2}var _HP=$k[--$j];$k[$j++]=~~(_HP/2)}$as($a($m()));var _HS=$k[--$j];$k[$j-1]=_HS;$_.addtocws();$_.mode=$_.A};$_.encB=function(){$_.p=0;$_.bvals=$a(1480);for(;;){if($_.i==$_.msglen){break}if($g($_.msg,$_.i)<0){break}$_.lookup();if($k[--$j]!=$_.mode){break}$p($_.bvals,$_.p,$g($_.msg,$_.i));$_.p=$_.p+1;$_.i=$_.i+1}$_.remcws=$g($_.numremcws,$_.j+$_.p)-1;$k[$j++]=Infinity;if($_.remcws==0&&$_.i==$_.msglen){$k[$j++]=0}else{if($_.p<250){$k[$j++]=$_.p}else{$k[$j++]=~~($_.p/250)+249;$k[$j++]=$_.p%250}}$q($G($_.bvals,0,$_.p));$_.bvals=$a();$k[$j++]=$_.bvals;$_.addtocws();$_.mode=$_.A};$_.cws=$a(1480);$_.mode=$_.A;$_.i=0;$_.j=0;for(;;){if($_.i>=$_.msglen){break}if($_[$g($a(["encA","encCTX","encCTX","encCTX","encD","encB"]),$_.mode)]()===true){break}}$_.cws=$G($_.cws,0,$_.j)}var _IC=$_.metrics;for(var _ID=0,_IE=_IC.length;_ID<_IE;_ID++){$_.m=$g(_IC,_ID);$_.vers=$g($_.m,0);$_.rows=$g($_.m,1);$_.cols=$g($_.m,2);$_.dcol=$g($_.m,3);$_.dcws=$g($_.m,4);$_.rscw=$g($_.m,5);$_.rsbl=$g($_.m,6);$_.riso=$g($_.m,7);$_.risi=$g($_.m,8);$_.risl=$g($_.m,9);$_.dcpb=~~($_.dcws/$_.rsbl);$_.ecpb=~~($_.rscw/$_.rsbl);$_.okay=true;if($ne($_.version,"unset")&&$ne($_.version,$_.vers)){$_.okay=false}if($_.cws.length>$_.dcws){$_.okay=false}if($_.okay){break}}if(!$_.okay){$k[$j++]="bwipp.codeoneNoValidSymbol#25082";$k[$j++]="Maximum length exceeded";bwipp_raiseerror()}if(!$_.stype){$k[$j++]=Infinity;$q($_.cws);for(var _Ip=0,_Iq=$f($_.dcws-$_.cws.length);_Ip<_Iq;_Ip++){$k[$j++]=129}$_.cws=$a()}else{$k[$j++]=Infinity;for(var _Iu=0,_Iv=$f($_.dcws-$_.cws.length);_Iu<_Iv;_Iu++){$k[$j++]=0}$q($_.cws);$_.cws=$a()}var _Iz=$g($_.options,"debugcws")!==undefined;if(_Iz){$k[$j++]="bwipp.debugcws#25092";$k[$j++]=$_.cws;bwipp_raiseerror()}$_.cwbs=$a($_.rsbl);$_.ecbs=$a($_.rsbl);for(var _J7=0,_J6=$_.rsbl-1;_J7<=_J6;_J7+=1){$_.i=_J7;$_.cwb=$a($_.dcpb);for(var _JC=0,_JB=$_.dcpb-1;_JC<=_JB;_JC+=1){$_.j=_JC;$p($_.cwb,$_.j,$g($_.cws,$f($_.j*$_.rsbl+$_.i)))}$p($_.cwbs,$_.i,$_.cwb)}var _JO=$_.stype?32:256;$_.gf=_JO;$_["gf-1"]=$_.gf-1;var _JR=$_.stype?37:301;$_.pm=_JR;$k[$j++]=Infinity;$k[$j++]=1;for(var _JT=0,_JU=$_["gf-1"];_JT<_JU;_JT++){var _JV=$k[$j-1];var _JW=_JV*2;$k[$j++]=_JW;if(_JW>=$_.gf){var _JZ=$k[--$j];$k[$j++]=_JZ^$_.pm}}$_.rsalog=$a();$_.rslog=$a($_.gf);for(var _Jf=1,_Je=$_["gf-1"];_Jf<=_Je;_Jf+=1){$p($_.rslog,$g($_.rsalog,_Jf),_Jf)}$_.rsprod=function(){var _Jj=$k[$j-1];var _Jk=$k[$j-2];if(_Jj!=0&&_Jk!=0){var _Jn=$g($_.rslog,$k[--$j]);var _Jt=$g($_.rsalog,$f(_Jn+$g($_.rslog,$k[--$j]))%$_["gf-1"]);$k[$j++]=_Jt}else{$j-=2;$k[$j++]=0}};$k[$j++]=Infinity;$k[$j++]=1;for(var _Jv=0,_Jw=$_.ecpb;_Jv<_Jw;_Jv++){$k[$j++]=0}$_.coeffs=$a();for(var _K0=0,_Jz=$_.ecpb-1;_K0<=_Jz;_K0+=1){$_.i=_K0;$p($_.coeffs,$_.i+1,$g($_.coeffs,$_.i));for(var _K7=$_.i;_K7>=1;_K7-=1){$_.j=_K7;$k[$j++]=$_.coeffs;$k[$j++]=$_.j;$k[$j++]=$g($_.coeffs,$_.j-1);$k[$j++]=$g($_.coeffs,$_.j);$k[$j++]=$g($_.rsalog,$_.i);$_.rsprod();var _KJ=$k[--$j];var _KK=$k[--$j];var _KL=$k[--$j];$p($k[--$j],_KL,$xo(_KK,_KJ))}$k[$j++]=$_.coeffs;$k[$j++]=0;$k[$j++]=$g($_.coeffs,0);$k[$j++]=$g($_.rsalog,$_.i);$_.rsprod();var _KT=$k[--$j];var _KU=$k[--$j];$p($k[--$j],_KU,_KT)}$_.coeffs=$G($_.coeffs,0,$_.coeffs.length-1);for(var _Kb=0,_Ka=$_.cwbs.length-1;_Kb<=_Ka;_Kb+=1){$_.i=_Kb;$k[$j++]=Infinity;$q($g($_.cwbs,$_.i));for(var _Kg=0,_Kh=$_.ecpb;_Kg<_Kh;_Kg++){$k[$j++]=0}$_.rscws=$a();for(var _Kl=0,_Kk=$_.dcpb-1;_Kl<=_Kk;_Kl+=1){$_.m=_Kl;$_.k=$g($_.rscws,$_.m);for(var _Kr=0,_Kq=$_.ecpb-1;_Kr<=_Kq;_Kr+=1){$_.j=_Kr;$k[$j++]=$_.rscws;$k[$j++]=$_.m+$_.j+1;$k[$j++]=$g($_.coeffs,$_.ecpb-$_.j-1);$k[$j++]=$_.k;$_.rsprod();var _L4=$k[--$j];var _L5=$k[--$j];$p($k[--$j],_L5,$xo(_L4,$g($_.rscws,$_.m+$_.j+1)))}}$p($_.ecbs,$_.i,$G($_.rscws,$_.dcpb,$_.ecpb))}$k[$j++]=Infinity;$q($_.cws);for(var _LF=0,_LG=$_.rscw;_LF<_LG;_LF++){$k[$j++]=0}$_.cws=$a();for(var _LK=0,_LJ=$_.rscw-1;_LK<=_LJ;_LK+=1){$_.i=_LK;$p($_.cws,$f($_.dcws+$_.i),$g($g($_.ecbs,$_.i%$_.rsbl),~~($_.i/$_.rsbl)))}var _LY=$_.stype?5:8;$_.mmat=$a($f($_.dcws+$_.rscw)*_LY);$_.r=0;$_.c=0;var _Lb=$_.stype?2:1;for(var _Le=0,_Lf=_Lb,_Ld=$_.cws.length-1;_Lf<0?_Le>=_Ld:_Le<=_Ld;_Le+=_Lf){$_.i=_Le;if(!$_.stype){var _Li=$Z($s(8),"00000000");var _Ln=$R($s(8),$g($_.cws,$_.i),2);$P(_Li,8-_Ln.length,_Ln);var _Lo=Infinity;var _Lp=_Li;$k[$j++]=_Lo;$F(_Lp,function(){var _Lq=$k[--$j];$k[$j++]=_Lq-48});var _Lr=$a();$_.top=$G(_Lr,0,4);$_.bot=$G(_Lr,4,4)}else{var _Lv=$Z($s(5),"00000");var _M0=$R($s(5),$g($_.cws,$_.i),2);$P(_Lv,5-_M0.length,_M0);var _M1=Infinity;var _M2=_Lv;$k[$j++]=_M1;$F(_M2,function(){var _M3=$k[--$j];$k[$j++]=_M3-48});$_.c1=$a();var _M6=$Z($s(5),"00000");var _MB=$R($s(5),$g($_.cws,$_.i+1),2);$P(_M6,5-_MB.length,_MB);var _MC=Infinity;var _MD=_M6;$k[$j++]=_MC;$F(_MD,function(){var _ME=$k[--$j];$k[$j++]=_ME-48});$_.c2=$a();$k[$j++]=Infinity;$q($G($_.c1,0,3));$q($G($_.c2,0,2));$_.top=$a();$k[$j++]=Infinity;$q($G($_.c1,3,2));$q($G($_.c2,2,3));$_.bot=$a()}$P($_.mmat,$f($_.r*$_.dcol+$_.c),$_.top);$P($_.mmat,$f(($_.r+1)*$_.dcol+$_.c),$_.bot);$_.c=$_.c+$_.top.length;if($_.c==$_.dcol){$_.c=0;$_.r=$_.r+2}}$_.mmv=function(){var _Mg=$k[--$j];var _Mh=$k[--$j];$k[$j++]=$f(_Mh+_Mg*$_.cols)};$k[$j++]=Infinity;for(var _Mk=0,_Ml=$_.rows*$_.cols;_Mk<_Ml;_Mk++){$k[$j++]=-1}$_.pixs=$a();var _NH=$a([function(){for(var _Mo=0,_Mp=$_.cols;_Mo<_Mp;_Mo++){$k[$j++]=0}},function(){for(var _Mr=0,_Ms=$_.cols;_Mr<_Ms;_Mr++){$k[$j++]=1}},function(){$k[$j++]=0;for(var _Mu=0,_Mv=$_.cols-2;_Mu<_Mv;_Mu++){$k[$j++]=1}$k[$j++]=0},function(){$k[$j++]=0;$k[$j++]=1;for(var _Mx=0,_My=$_.cols-4;_Mx<_My;_Mx++){$k[$j++]=0}$k[$j++]=1;$k[$j++]=0},function(){for(var _N0=0,_N1=~~(($_.cols-1)/2);_N0<_N1;_N0++){$k[$j++]=-1}$k[$j++]=1;for(var _N3=0,_N4=~~(($_.cols-1)/2);_N3<_N4;_N3++){$k[$j++]=-1}},function(){for(var _N6=0,_N7=~~(($_.cols-1)/2);_N6<_N7;_N6++){$k[$j++]=-1}$k[$j++]=0;for(var _N9=0,_NA=~~(($_.cols-1)/2);_N9<_NA;_N9++){$k[$j++]=-1}},function(){$k[$j++]=1;for(var _NC=0,_ND=$_.cols-2;_NC<_ND;_NC++){$k[$j++]=0}$k[$j++]=1},function(){$k[$j++]=1;$k[$j++]=0;for(var _NF=0,_NG=$_.cols-4;_NF<_NG;_NF++){$k[$j++]=1}$k[$j++]=0;$k[$j++]=1}]);$_.artifact=_NH;var _NI=new Map([["A","121343"],["B","12134343"],["C","12121343"],["D","1213434343"],["E","1212134343"],["F","1212121343"],["G","121213434343"],["H","121212134343"],["S","56661278"],["T","5666666666127878"]]);$_.cpatmap=_NI;$_.cpat=$g($_.cpatmap,$G($_.vers,0,1));$k[$j++]=$_.pixs;$k[$j++]=0;$k[$j++]=~~($f($_.rows-$_.cpat.length)/2);$_.mmv();$k[$j++]=Infinity;$F($_.cpat,function(){if($g($_.artifact,$k[--$j]-49)()===true){return true}});var _NV=$a();var _NW=$k[--$j];$P($k[--$j],_NW,_NV);for(var _Na=0,_NZ=$_.risl-1;_Na<=_NZ;_Na+=1){$_.i=_Na;for(var _Nf=$_.riso,_Ng=$_.risi,_Ne=$_.cols-1;_Ng<0?_Nf>=_Ne:_Nf<=_Ne;_Nf+=_Ng){$_.j=_Nf;var _Ni=$_.i%12==0?1:0;var _Nj=$a([1,_Ni]);$k[$j++]=_Nj;$k[$j++]=_Nj;$k[$j++]=$_.pixs;$k[$j++]=$_.j;$k[$j++]=$_.i;$_.mmv();var _Nn=$k[$j-3];var _No=$k[$j-1];$P($k[$j-2],_No,_Nn);$j-=3;if($_.i!=$_.risl-1){$k[$j++]=$_.pixs;$k[$j++]=$f($_.cols-$_.j)-2;$k[$j++]=$f($_.rows-$_.i)-1;$_.mmv();var _Nx=$k[$j-3];var _Ny=$k[$j-1];$P($k[$j-2],_Ny,_Nx);$j-=3}else{$j--}}}var _Od=new Map([["A",$a([$a([12,5])])],["B",$a([$a([16,7])])],["C",$a([$a([26,12])])],["D",$a([])],["E",$a([$a([26,23])])],["F",$a([$a([26,32]),$a([70,32]),$a([26,34]),$a([70,34])])],["G",$a([$a([27,48]),$a([69,48])])],["H",$a([$a([26,70]),$a([66,70]),$a([106,70]),$a([26,72]),$a([66,72]),$a([106,72])])],["S-10",$a([])],["S-20",$a([$a([10,4])])],["S-30",$a([$a([15,4]),$a([15,6])])],["T-16",$a([$a([8,10])])],["T-32",$a([$a([16,10]),$a([16,12])])],["T-48",$a([$a([24,10]),$a([24,12]),$a([24,14])])]]);$_.blackdotmap=_Od;$F($g($_.blackdotmap,$_.vers),function(){var _Oj=$k[--$j];$k[$j++]=$_.pixs;$q(_Oj);$_.mmv();var _Ok=$k[--$j];$p($k[--$j],_Ok,1)});$_.j=0;for(var _Oo=0,_On=$_.pixs.length-1;_Oo<=_On;_Oo+=1){$_.i=_Oo;if($g($_.pixs,$_.i)==-1){$p($_.pixs,$_.i,$g($_.mmat,$_.j));$_.j=$_.j+1}}$k[$j++]=Infinity;$k[$j++]="ren";$k[$j++]="renmatrix";$k[$j++]="pixs";$k[$j++]=$_.pixs;$k[$j++]="pixx";$k[$j++]=$_.cols;$k[$j++]="pixy";$k[$j++]=$_.rows;$k[$j++]="height";$k[$j++]=$_.rows/72*2;$k[$j++]="width";$k[$j++]=$_.cols/72*2;if($_.stype||$_.ttype){$k[$j++]="borderleft";$k[$j++]=1;$k[$j++]="borderright";$k[$j++]=1;$k[$j++]="bordertop";$k[$j++]=0;$k[$j++]="borderbottom";$k[$j++]=1}$k[$j++]="opt";$k[$j++]=$_.options;var _P6=$d();$k[$j++]=_P6;if(!$_.dontdraw){bwipp_renmatrix()}$_=$__}function bwipp_hanxin(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.version="unset";$_.eclevel="L2";$_.parse=false;$_.parsefnc=false;$_.mask=-1;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.barcode.length==0){$k[$j++]="bwipp.hanxinEmptyData#25328";$k[$j++]="The data must not be empty";bwipp_raiseerror()}if($ne($_.version,"unset")){var _5=$_.version.length;var _6=_5>=1&&_5<=2;$k[$j++]=_6;if(_6){$j--;var _7=$_.version;$k[$j++]=true;for(var _8=0,_9=_7.length;_8<_9;_8++){var _A=$g(_7,_8);if(_A<48||_A>57){$k[$j-1]=false}}var _B=$k[$j-1];if(_B){$j--;var _D=$i($_.version);$k[$j++]=_D>=1&&_D<=84}}if(!$k[--$j]){$k[$j++]="bwipp.hanxinInvalidVersion#25339";$k[$j++]="Valid versions are 1 to 84";bwipp_raiseerror()}}var _G=$_.eclevel.length==2;$k[$j++]=_G;if(_G){$j--;var _J=$eq($G($_.eclevel,0,1),"L");$k[$j++]=_J;if(_J){$j--;var _M=$g($_.eclevel,1)-48;$k[$j++]=_M>=1&&_M<=4}}if(!$k[--$j]){$k[$j++]="bwipp.hanxinInvalidErrorCorrectionLevel#25349";$k[$j++]="Valid error correction levels are L1 to L4";bwipp_raiseerror()}if($_.mask!=-1){if($_.mask<1||$_.mask>4){$k[$j++]="bwipp.hanxinInvalidErrorCorrectionLevel#25354";$k[$j++]="The valid masks are 1 to 4";bwipp_raiseerror()}}var _T=new Map([["parse",$_.parse],["parsefnc",$_.parsefnc]]);$_.fncvals=_T;$k[$j++]="msg";$k[$j++]=$_.barcode;$k[$j++]=$_.fncvals;bwipp_parseinput();var _W=$k[--$j];$_[$k[--$j]]=_W;$_.msglen=$_.msg.length;$_.tobin=function(){var _a=$s($k[--$j]);$k[$j++]=_a;for(var _c=0,_b=_a.length-1;_c<=_b;_c+=1){var _d=$k[$j-1];$p(_d,_c,48)}var _e=$k[$j-1];$k[$j++]=_e;var _f=$k[$j-3];var _g=$k[$j-1];$k[$j-3]=$k[$j-2];$j-=2;var _i=$R($s(_g.length),_f,2);$P(_g,_g.length-_i.length,_i)};$_.bits=$s(4+13+$_.msglen*8);$P($_.bits,0,"0011");$k[$j++]=$_.bits;$k[$j++]=4;$k[$j++]=$_.msglen;$k[$j++]=13;$_.tobin();var _o=$k[--$j];var _p=$k[--$j];$P($k[--$j],_p,_o);for(var _t=0,_s=$_.msglen-1;_t<=_s;_t+=1){$_.i=_t;$k[$j++]=$_.bits;$k[$j++]=17+$_.i*8;$k[$j++]=$g($_.msg,$_.i);$k[$j++]=8;$_.tobin();var _z=$k[--$j];var _10=$k[--$j];$P($k[--$j],_10,_z)}$_.metrics=$a([$a(["1",23,-1,0,205,$a([1,21,4]),$a([0,-1,-1]),$a([0,-1,-1]),$a([1,17,8]),$a([0,-1,-1]),$a([0,-1,-1]),$a([1,13,12]),$a([0,-1,-1]),$a([0,-1,-1]),$a([1,9,16]),$a([0,-1,-1]),$a([0,-1,-1])]),$a(["2",25,-1,0,301,$a([1,31,6]),$a([0,-1,-1]),$a([0,-1,-1]),$a([1,25,12]),$a([0,-1,-1]),$a([0,-1,-1]),$a([1,19,18]),$a([0,-1,-1]),$a([0,-1,-1]),$a([1,15,22]),$a([0,-1,-1]),$a([0,-1,-1])]),$a(["3",27,-1,0,405,$a([1,42,8]),$a([0,-1,-1]),$a([0,-1,-1]),$a([1,34,16]),$a([0,-1,-1]),$a([0,-1,-1]),$a([1,26,24]),$a([0,-1,-1]),$a([0,-1,-1]),$a([1,20,30]),$a([0,-1,-1]),$a([0,-1,-1])]),$a(["4",29,14,1,439,$a([1,46,8]),$a([0,-1,-1]),$a([0,-1,-1]),$a([1,38,16]),$a([0,-1,-1]),$a([0,-1,-1]),$a([1,30,24]),$a([0,-1,-1]),$a([0,-1,-1]),$a([1,22,32]),$a([0,-1,-1]),$a([0,-1,-1])]),$a(["5",31,16,1,555,$a([1,57,12]),$a([0,-1,-1]),$a([0,-1,-1]),$a([1,49,20]),$a([0,-1,-1]),$a([0,-1,-1]),$a([1,37,32]),$a([0,-1,-1]),$a([0,-1,-1]),$a([1,14,20]),$a([1,13,22]),$a([0,-1,-1])]),$a(["6",33,16,1,675,$a([1,70,14]),$a([0,-1,-1]),$a([0,-1,-1]),$a([1,58,26]),$a([0,-1,-1]),$a([0,-1,-1]),$a([1,24,20]),$a([1,22,18]),$a([0,-1,-1]),$a([1,16,24]),$a([1,18,26]),$a([0,-1,-1])]),$a(["7",35,17,1,805,$a([1,84,16]),$a([0,-1,-1]),$a([0,-1,-1]),$a([1,70,30]),$a([0,-1,-1]),$a([0,-1,-1]),$a([1,26,22]),$a([1,28,24]),$a([0,-1,-1]),$a([2,14,20]),$a([1,12,20]),$a([0,-1,-1])]),$a(["8",37,18,1,943,$a([1,99,18]),$a([0,-1,-1]),$a([0,-1,-1]),$a([1,40,18]),$a([1,41,18]),$a([0,-1,-1]),$a([1,31,26]),$a([1,32,28]),$a([0,-1,-1]),$a([2,16,24]),$a([1,15,22]),$a([0,-1,-1])]),$a(["9",39,19,1,1089,$a([1,114,22]),$a([0,-1,-1]),$a([0,-1,-1]),$a([2,48,20]),$a([0,-1,-1]),$a([0,-1,-1]),$a([2,24,20]),$a([1,26,22]),$a([0,-1,-1]),$a([2,18,28]),$a([1,18,26]),$a([0,-1,-1])]),$a(["10",41,20,1,1243,$a([1,131,24]),$a([0,-1,-1]),$a([0,-1,-1]),$a([1,52,22]),$a([1,57,24]),$a([0,-1,-1]),$a([2,27,24]),$a([1,29,24]),$a([0,-1,-1]),$a([2,21,32]),$a([1,19,30]),$a([0,-1,-1])]),$a(["11",43,14,2,1289,$a([1,135,26]),$a([0,-1,-1]),$a([0,-1,-1]),$a([1,56,24]),$a([1,57,24]),$a([0,-1,-1]),$a([2,28,24]),$a([1,31,26]),$a([0,-1,-1]),$a([2,22,32]),$a([1,21,32]),$a([0,-1,-1])]),$a(["12",45,15,2,1455,$a([1,153,28]),$a([0,-1,-1]),$a([0,-1,-1]),$a([1,62,26]),$a([1,65,28]),$a([0,-1,-1]),$a([2,32,28]),$a([1,33,28]),$a([0,-1,-1]),$a([3,17,26]),$a([1,22,30]),$a([0,-1,-1])]),$a(["13",47,16,2,1629,$a([1,86,16]),$a([1,85,16]),$a([0,-1,-1]),$a([1,71,30]),$a([1,72,30]),$a([0,-1,-1]),$a([2,37,32]),$a([1,35,30]),$a([0,-1,-1]),$a([3,20,30]),$a([1,21,32]),$a([0,-1,-1])]),$a(["14",49,16,2,1805,$a([1,94,18]),$a([1,95,18]),$a([0,-1,-1]),$a([2,51,22]),$a([1,55,24]),$a([0,-1,-1]),$a([3,30,26]),$a([1,31,26]),$a([0,-1,-1]),$a([4,18,28]),$a([1,17,24]),$a([0,-1,-1])]),$a(["15",51,17,2,1995,$a([1,104,20]),$a([1,105,20]),$a([0,-1,-1]),$a([2,57,24]),$a([1,61,26]),$a([0,-1,-1]),$a([3,33,28]),$a([1,36,30]),$a([0,-1,-1]),$a([4,20,30]),$a([1,19,30]),$a([0,-1,-1])]),$a(["16",53,17,2,2187,$a([1,115,22]),$a([1,114,22]),$a([0,-1,-1]),$a([2,65,28]),$a([1,61,26]),$a([0,-1,-1]),$a([3,38,32]),$a([1,33,30]),$a([0,-1,-1]),$a([5,19,28]),$a([1,14,24]),$a([0,-1,-1])]),$a(["17",55,18,2,2393,$a([1,126,24]),$a([1,125,24]),$a([0,-1,-1]),$a([2,70,30]),$a([1,69,30]),$a([0,-1,-1]),$a([4,33,28]),$a([1,29,26]),$a([0,-1,-1]),$a([5,20,30]),$a([1,19,30]),$a([0,-1,-1])]),$a(["18",57,19,2,2607,$a([1,136,26]),$a([1,137,26]),$a([0,-1,-1]),$a([3,56,24]),$a([1,59,26]),$a([0,-1,-1]),$a([5,35,30]),$a([0,-1,-1]),$a([0,-1,-1]),$a([6,18,28]),$a([1,21,28]),$a([0,-1,-1])]),$a(["19",59,20,2,2829,$a([1,148,28]),$a([1,149,28]),$a([0,-1,-1]),$a([3,61,26]),$a([1,64,28]),$a([0,-1,-1]),$a([7,24,20]),$a([1,23,22]),$a([0,-1,-1]),$a([6,20,30]),$a([1,21,32]),$a([0,-1,-1])]),$a(["20",61,20,2,3053,$a([3,107,20]),$a([0,-1,-1]),$a([0,-1,-1]),$a([3,65,28]),$a([1,72,30]),$a([0,-1,-1]),$a([7,26,22]),$a([1,23,22]),$a([0,-1,-1]),$a([7,19,28]),$a([1,20,32]),$a([0,-1,-1])]),$a(["21",63,21,2,3291,$a([3,115,22]),$a([0,-1,-1]),$a([0,-1,-1]),$a([4,56,24]),$a([1,63,28]),$a([0,-1,-1]),$a([7,28,24]),$a([1,25,22]),$a([0,-1,-1]),$a([8,18,28]),$a([1,21,22]),$a([0,-1,-1])]),$a(["22",65,16,3,3383,$a([2,116,22]),$a([1,122,24]),$a([0,-1,-1]),$a([4,56,24]),$a([1,72,30]),$a([0,-1,-1]),$a([7,28,24]),$a([1,32,26]),$a([0,-1,-1]),$a([8,18,28]),$a([1,24,30]),$a([0,-1,-1])]),$a(["23",67,17,3,3631,$a([3,127,24]),$a([0,-1,-1]),$a([0,-1,-1]),$a([5,51,22]),$a([1,62,26]),$a([0,-1,-1]),$a([7,30,26]),$a([1,35,26]),$a([0,-1,-1]),$a([8,20,30]),$a([1,21,32]),$a([0,-1,-1])]),$a(["24",69,17,3,3887,$a([2,135,26]),$a([1,137,26]),$a([0,-1,-1]),$a([5,56,24]),$a([1,59,26]),$a([0,-1,-1]),$a([7,33,28]),$a([1,30,28]),$a([0,-1,-1]),$a([11,16,24]),$a([1,19,26]),$a([0,-1,-1])]),$a(["25",71,18,3,4151,$a([3,105,20]),$a([1,121,22]),$a([0,-1,-1]),$a([5,61,26]),$a([1,57,26]),$a([0,-1,-1]),$a([9,28,24]),$a([1,28,22]),$a([0,-1,-1]),$a([10,19,28]),$a([1,18,30]),$a([0,-1,-1])]),$a(["26",73,18,3,4423,$a([2,157,30]),$a([1,150,28]),$a([0,-1,-1]),$a([5,65,28]),$a([1,61,26]),$a([0,-1,-1]),$a([8,33,28]),$a([1,34,30]),$a([0,-1,-1]),$a([10,19,28]),$a([2,15,26]),$a([0,-1,-1])]),$a(["27",75,19,3,4703,$a([3,126,24]),$a([1,115,22]),$a([0,-1,-1]),$a([7,51,22]),$a([1,54,22]),$a([0,-1,-1]),$a([8,35,30]),$a([1,37,30]),$a([0,-1,-1]),$a([15,15,22]),$a([1,10,22]),$a([0,-1,-1])]),$a(["28",77,19,3,4991,$a([4,105,20]),$a([1,103,20]),$a([0,-1,-1]),$a([7,56,24]),$a([1,45,18]),$a([0,-1,-1]),$a([10,31,26]),$a([1,27,26]),$a([0,-1,-1]),$a([10,17,26]),$a([3,20,28]),$a([1,21,28])]),$a(["29",79,20,3,5287,$a([3,139,26]),$a([1,137,28]),$a([0,-1,-1]),$a([6,66,28]),$a([1,66,30]),$a([0,-1,-1]),$a([9,36,30]),$a([1,34,32]),$a([0,-1,-1]),$a([13,19,28]),$a([1,17,32]),$a([0,-1,-1])]),$a(["30",81,20,3,5591,$a([6,84,16]),$a([1,82,16]),$a([0,-1,-1]),$a([6,70,30]),$a([1,68,30]),$a([0,-1,-1]),$a([7,35,30]),$a([3,33,28]),$a([1,32,28]),$a([13,20,30]),$a([1,20,28]),$a([0,-1,-1])]),$a(["31",83,21,3,5903,$a([5,105,20]),$a([1,94,18]),$a([0,-1,-1]),$a([6,74,32]),$a([1,71,30]),$a([0,-1,-1]),$a([11,33,28]),$a([1,34,32]),$a([0,-1,-1]),$a([13,19,28]),$a([3,16,26]),$a([0,-1,-1])]),$a(["32",85,17,4,6033,$a([4,127,24]),$a([1,126,24]),$a([0,-1,-1]),$a([7,66,28]),$a([1,66,30]),$a([0,-1,-1]),$a([12,30,24]),$a([1,24,28]),$a([1,24,30]),$a([15,19,28]),$a([1,17,32]),$a([0,-1,-1])]),$a(["33",87,17,4,6353,$a([7,84,16]),$a([1,78,16]),$a([0,-1,-1]),$a([7,70,30]),$a([1,66,28]),$a([0,-1,-1]),$a([12,33,28]),$a([1,32,30]),$a([0,-1,-1]),$a([14,21,32]),$a([1,24,28]),$a([0,-1,-1])]),$a(["34",89,18,4,6689,$a([5,117,22]),$a([1,117,24]),$a([0,-1,-1]),$a([8,66,28]),$a([1,58,26]),$a([0,-1,-1]),$a([11,38,32]),$a([1,34,32]),$a([0,-1,-1]),$a([15,20,30]),$a([2,17,26]),$a([0,-1,-1])]),$a(["35",91,18,4,7025,$a([4,148,28]),$a([1,146,28]),$a([0,-1,-1]),$a([8,68,30]),$a([1,70,24]),$a([0,-1,-1]),$a([10,36,32]),$a([3,38,28]),$a([0,-1,-1]),$a([16,19,28]),$a([3,16,26]),$a([0,-1,-1])]),$a(["36",93,19,4,7377,$a([4,126,24]),$a([2,135,26]),$a([0,-1,-1]),$a([8,70,28]),$a([2,43,26]),$a([0,-1,-1]),$a([13,32,28]),$a([2,41,30]),$a([0,-1,-1]),$a([17,19,28]),$a([3,15,26]),$a([0,-1,-1])]),$a(["37",95,19,4,7729,$a([5,136,26]),$a([1,132,24]),$a([0,-1,-1]),$a([5,67,30]),$a([4,68,28]),$a([1,69,28]),$a([14,35,30]),$a([1,32,24]),$a([0,-1,-1]),$a([18,18,26]),$a([3,16,28]),$a([1,14,28])]),$a(["38",97,19,4,8089,$a([3,142,26]),$a([3,141,28]),$a([0,-1,-1]),$a([8,70,30]),$a([1,73,32]),$a([1,74,32]),$a([12,34,30]),$a([3,34,26]),$a([1,35,28]),$a([18,21,32]),$a([1,27,30]),$a([0,-1,-1])]),$a(["39",99,20,4,8465,$a([5,116,22]),$a([2,103,20]),$a([1,102,20]),$a([9,74,32]),$a([1,74,30]),$a([0,-1,-1]),$a([14,34,28]),$a([2,32,32]),$a([1,32,30]),$a([19,21,32]),$a([1,25,26]),$a([0,-1,-1])]),$a(["40",101,20,4,8841,$a([7,116,22]),$a([1,117,22]),$a([0,-1,-1]),$a([11,65,28]),$a([1,58,24]),$a([0,-1,-1]),$a([15,38,32]),$a([1,27,28]),$a([0,-1,-1]),$a([20,20,30]),$a([1,20,32]),$a([1,21,32])]),$a(["41",103,17,5,9009,$a([6,136,26]),$a([1,130,24]),$a([0,-1,-1]),$a([11,66,28]),$a([1,62,30]),$a([0,-1,-1]),$a([14,34,28]),$a([3,34,32]),$a([1,30,30]),$a([18,20,30]),$a([3,20,28]),$a([2,15,26])]),$a(["42",105,17,5,9401,$a([5,105,20]),$a([2,115,22]),$a([2,116,22]),$a([10,75,32]),$a([1,73,32]),$a([0,-1,-1]),$a([16,38,32]),$a([1,27,28]),$a([0,-1,-1]),$a([22,19,28]),$a([2,16,30]),$a([1,19,30])]),$a(["43",107,18,5,9799,$a([6,147,28]),$a([1,146,28]),$a([0,-1,-1]),$a([11,66,28]),$a([2,65,30]),$a([0,-1,-1]),$a([18,33,28]),$a([2,33,30]),$a([0,-1,-1]),$a([22,21,32]),$a([1,28,30]),$a([0,-1,-1])]),$a(["44",109,18,5,10207,$a([6,116,22]),$a([3,125,24]),$a([0,-1,-1]),$a([11,75,32]),$a([1,68,30]),$a([0,-1,-1]),$a([13,35,28]),$a([6,34,32]),$a([1,30,30]),$a([23,21,32]),$a([1,26,30]),$a([0,-1,-1])]),$a(["45",111,18,5,10623,$a([7,105,20]),$a([4,95,18]),$a([0,-1,-1]),$a([12,67,28]),$a([1,63,30]),$a([1,62,32]),$a([21,31,26]),$a([2,33,32]),$a([0,-1,-1]),$a([23,21,32]),$a([2,24,30]),$a([0,-1,-1])]),$a(["46",113,19,5,11045,$a([10,116,22]),$a([0,-1,-1]),$a([0,-1,-1]),$a([12,74,32]),$a([1,78,30]),$a([0,-1,-1]),$a([18,37,32]),$a([1,39,30]),$a([1,41,28]),$a([25,21,32]),$a([1,27,28]),$a([0,-1,-1])]),$a(["47",115,19,5,11477,$a([5,126,24]),$a([4,115,22]),$a([1,114,22]),$a([12,67,28]),$a([2,66,32]),$a([1,68,30]),$a([21,35,30]),$a([1,39,30]),$a([0,-1,-1]),$a([26,21,32]),$a([1,28,28]),$a([0,-1,-1])]),$a(["48",117,19,5,11917,$a([9,126,24]),$a([1,117,22]),$a([0,-1,-1]),$a([13,75,32]),$a([1,68,30]),$a([0,-1,-1]),$a([20,35,30]),$a([3,35,28]),$a([0,-1,-1]),$a([27,21,32]),$a([1,28,30]),$a([0,-1,-1])]),$a(["49",119,17,6,12111,$a([9,126,24]),$a([1,137,26]),$a([0,-1,-1]),$a([13,71,30]),$a([2,68,32]),$a([0,-1,-1]),$a([20,37,32]),$a([1,39,28]),$a([1,38,28]),$a([24,20,32]),$a([5,25,28]),$a([0,-1,-1])]),$a(["50",121,17,6,12559,$a([8,147,28]),$a([1,141,28]),$a([0,-1,-1]),$a([10,73,32]),$a([4,74,30]),$a([1,73,30]),$a([16,36,32]),$a([6,39,30]),$a([1,37,30]),$a([27,21,32]),$a([3,20,26]),$a([0,-1,-1])]),$a(["51",123,18,6,13025,$a([9,137,26]),$a([1,135,26]),$a([0,-1,-1]),$a([12,70,30]),$a([4,75,32]),$a([0,-1,-1]),$a([24,35,30]),$a([1,40,28]),$a([0,-1,-1]),$a([23,20,32]),$a([8,24,30]),$a([0,-1,-1])]),$a(["52",125,18,6,13489,$a([14,95,18]),$a([1,86,18]),$a([0,-1,-1]),$a([13,73,32]),$a([3,77,30]),$a([0,-1,-1]),$a([24,35,30]),$a([2,35,28]),$a([0,-1,-1]),$a([26,21,32]),$a([5,21,30]),$a([1,23,30])]),$a(["53",127,18,6,13961,$a([9,147,28]),$a([1,142,28]),$a([0,-1,-1]),$a([10,73,30]),$a([6,70,32]),$a([1,71,32]),$a([25,35,30]),$a([2,34,26]),$a([0,-1,-1]),$a([29,21,32]),$a([4,22,30]),$a([0,-1,-1])]),$a(["54",129,18,6,14441,$a([11,126,24]),$a([1,131,24]),$a([0,-1,-1]),$a([16,74,32]),$a([1,79,30]),$a([0,-1,-1]),$a([25,38,32]),$a([1,25,30]),$a([0,-1,-1]),$a([33,21,32]),$a([1,28,28]),$a([0,-1,-1])]),$a(["55",131,19,6,14939,$a([14,105,20]),$a([1,99,18]),$a([0,-1,-1]),$a([19,65,28]),$a([1,72,28]),$a([0,-1,-1]),$a([24,37,32]),$a([2,40,30]),$a([1,41,30]),$a([31,21,32]),$a([4,24,32]),$a([0,-1,-1])]),$a(["56",133,19,6,15435,$a([10,147,28]),$a([1,151,28]),$a([0,-1,-1]),$a([15,71,30]),$a([3,71,32]),$a([1,73,32]),$a([24,37,32]),$a([3,38,30]),$a([1,39,30]),$a([36,19,30]),$a([3,29,26]),$a([0,-1,-1])]),$a(["57",135,19,6,15939,$a([15,105,20]),$a([1,99,18]),$a([0,-1,-1]),$a([19,70,30]),$a([1,64,28]),$a([0,-1,-1]),$a([27,38,32]),$a([2,25,26]),$a([0,-1,-1]),$a([38,20,30]),$a([2,18,28]),$a([0,-1,-1])]),$a(["58",137,17,7,16171,$a([14,105,20]),$a([1,113,22]),$a([1,114,22]),$a([17,67,30]),$a([3,92,32]),$a([0,-1,-1]),$a([30,35,30]),$a([1,41,30]),$a([0,-1,-1]),$a([36,21,32]),$a([1,26,30]),$a([1,27,30])]),$a(["59",139,17,7,16691,$a([11,146,28]),$a([1,146,26]),$a([0,-1,-1]),$a([20,70,30]),$a([1,60,26]),$a([0,-1,-1]),$a([29,38,32]),$a([1,24,32]),$a([0,-1,-1]),$a([40,20,30]),$a([2,17,26]),$a([0,-1,-1])]),$a(["60",141,18,7,17215,$a([3,137,26]),$a([1,136,26]),$a([10,126,24]),$a([22,65,28]),$a([1,75,30]),$a([0,-1,-1]),$a([30,37,32]),$a([1,51,30]),$a([0,-1,-1]),$a([42,20,30]),$a([1,21,30]),$a([0,-1,-1])]),$a(["61",143,18,7,17751,$a([12,126,24]),$a([2,118,22]),$a([1,116,22]),$a([19,74,32]),$a([1,74,30]),$a([1,72,28]),$a([30,38,32]),$a([2,29,30]),$a([0,-1,-1]),$a([39,20,32]),$a([2,37,26]),$a([1,38,26])]),$a(["62",145,18,7,18295,$a([12,126,24]),$a([3,136,26]),$a([0,-1,-1]),$a([21,70,30]),$a([2,65,28]),$a([0,-1,-1]),$a([34,35,30]),$a([1,44,32]),$a([0,-1,-1]),$a([42,20,30]),$a([2,19,28]),$a([2,18,28])]),$a(["63",147,18,7,18847,$a([12,126,24]),$a([3,117,22]),$a([1,116,22]),$a([25,61,26]),$a([2,62,28]),$a([0,-1,-1]),$a([34,35,30]),$a([1,40,32]),$a([1,41,32]),$a([45,20,30]),$a([1,20,32]),$a([1,21,32])]),$a(["64",149,19,7,19403,$a([15,105,20]),$a([2,115,22]),$a([2,116,22]),$a([25,65,28]),$a([1,72,28]),$a([0,-1,-1]),$a([18,35,30]),$a([17,37,32]),$a([1,50,32]),$a([42,20,30]),$a([6,19,28]),$a([1,15,28])]),$a(["65",151,19,7,19971,$a([19,105,20]),$a([1,101,20]),$a([0,-1,-1]),$a([33,51,22]),$a([1,65,22]),$a([0,-1,-1]),$a([40,33,28]),$a([1,28,28]),$a([0,-1,-1]),$a([49,20,30]),$a([1,18,28]),$a([0,-1,-1])]),$a(["66",153,17,8,20229,$a([18,105,20]),$a([2,117,22]),$a([0,-1,-1]),$a([26,65,28]),$a([1,80,30]),$a([0,-1,-1]),$a([35,35,30]),$a([3,35,28]),$a([1,36,28]),$a([52,18,28]),$a([2,38,30]),$a([0,-1,-1])]),$a(["67",155,17,8,20805,$a([26,84,16]),$a([0,-1,-1]),$a([0,-1,-1]),$a([26,70,30]),$a([0,-1,-1]),$a([0,-1,-1]),$a([45,31,26]),$a([1,9,26]),$a([0,-1,-1]),$a([52,20,30]),$a([0,-1,-1]),$a([0,-1,-1])]),$a(["68",157,17,8,21389,$a([16,126,24]),$a([1,114,22]),$a([1,115,22]),$a([23,70,30]),$a([3,65,28]),$a([1,66,28]),$a([40,35,30]),$a([1,43,30]),$a([0,-1,-1]),$a([46,20,30]),$a([7,19,28]),$a([1,16,28])]),$a(["69",159,18,8,21993,$a([19,116,22]),$a([1,105,22]),$a([0,-1,-1]),$a([20,70,30]),$a([7,66,28]),$a([1,63,28]),$a([40,35,30]),$a([1,42,32]),$a([1,43,32]),$a([54,20,30]),$a([1,19,30]),$a([0,-1,-1])]),$a(["70",161,18,8,22593,$a([17,126,24]),$a([2,115,22]),$a([0,-1,-1]),$a([24,70,30]),$a([4,74,32]),$a([0,-1,-1]),$a([48,31,26]),$a([2,18,26]),$a([0,-1,-1]),$a([54,19,28]),$a([6,15,26]),$a([1,14,26])]),$a(["71",163,18,8,23201,$a([29,84,16]),$a([0,-1,-1]),$a([0,-1,-1]),$a([29,70,30]),$a([0,-1,-1]),$a([0,-1,-1]),$a([6,34,30]),$a([3,36,30]),$a([38,33,28]),$a([58,20,30]),$a([0,-1,-1]),$a([0,-1,-1])]),$a(["72",165,18,8,23817,$a([16,147,28]),$a([1,149,28]),$a([0,-1,-1]),$a([31,66,28]),$a([1,37,26]),$a([0,-1,-1]),$a([48,33,28]),$a([1,23,26]),$a([0,-1,-1]),$a([53,20,30]),$a([6,19,28]),$a([1,17,28])]),$a(["73",167,19,8,24453,$a([20,115,22]),$a([2,134,24]),$a([0,-1,-1]),$a([29,66,28]),$a([2,56,26]),$a([2,57,26]),$a([45,36,30]),$a([2,15,28]),$a([0,-1,-1]),$a([59,20,30]),$a([2,21,32]),$a([0,-1,-1])]),$a(["74",169,19,8,25085,$a([17,147,28]),$a([1,134,26]),$a([0,-1,-1]),$a([26,70,30]),$a([5,75,32]),$a([0,-1,-1]),$a([47,35,30]),$a([1,48,32]),$a([0,-1,-1]),$a([64,18,28]),$a([2,33,30]),$a([1,35,30])]),$a(["75",171,17,9,25373,$a([22,115,22]),$a([1,133,24]),$a([0,-1,-1]),$a([33,65,28]),$a([1,74,28]),$a([0,-1,-1]),$a([43,36,30]),$a([5,27,28]),$a([1,30,28]),$a([57,20,30]),$a([5,21,32]),$a([1,24,32])]),$a(["76",173,17,9,26021,$a([18,136,26]),$a([2,142,26]),$a([0,-1,-1]),$a([33,66,28]),$a([2,49,26]),$a([0,-1,-1]),$a([48,35,30]),$a([2,38,28]),$a([0,-1,-1]),$a([64,20,30]),$a([1,20,32]),$a([0,-1,-1])]),$a(["77",175,17,9,26677,$a([19,126,24]),$a([2,135,26]),$a([1,136,26]),$a([32,66,28]),$a([2,55,26]),$a([2,56,26]),$a([49,36,30]),$a([2,18,32]),$a([0,-1,-1]),$a([65,18,28]),$a([5,27,30]),$a([1,29,30])]),$a(["78",177,18,9,27335,$a([20,137,26]),$a([1,130,26]),$a([0,-1,-1]),$a([30,75,32]),$a([2,71,32]),$a([0,-1,-1]),$a([46,35,30]),$a([6,39,32]),$a([0,-1,-1]),$a([3,12,30]),$a([70,19,28]),$a([0,-1,-1])]),$a(["79",179,18,9,28007,$a([20,147,28]),$a([0,-1,-1]),$a([0,-1,-1]),$a([35,70,30]),$a([0,-1,-1]),$a([0,-1,-1]),$a([49,35,30]),$a([5,35,28]),$a([0,-1,-1]),$a([70,20,30]),$a([0,-1,-1]),$a([0,-1,-1])]),$a(["80",181,18,9,28687,$a([21,136,26]),$a([1,155,28]),$a([0,-1,-1]),$a([34,70,30]),$a([1,64,28]),$a([1,65,28]),$a([54,35,30]),$a([1,45,30]),$a([0,-1,-1]),$a([68,20,30]),$a([3,18,28]),$a([1,19,28])]),$a(["81",183,18,9,29375,$a([19,126,24]),$a([5,115,22]),$a([1,114,22]),$a([33,70,30]),$a([3,65,28]),$a([1,64,28]),$a([52,35,30]),$a([3,41,32]),$a([1,40,32]),$a([67,20,30]),$a([5,21,32]),$a([1,24,32])]),$a(["82",185,18,9,30071,$a([2,150,28]),$a([21,136,26]),$a([0,-1,-1]),$a([32,70,30]),$a([6,65,28]),$a([0,-1,-1]),$a([52,38,32]),$a([2,27,32]),$a([0,-1,-1]),$a([73,20,30]),$a([2,22,32]),$a([0,-1,-1])]),$a(["83",187,17,10,30387,$a([21,126,24]),$a([4,136,26]),$a([0,-1,-1]),$a([30,74,32]),$a([6,73,30]),$a([0,-1,-1]),$a([54,35,30]),$a([4,40,32]),$a([0,-1,-1]),$a([75,20,30]),$a([1,20,28]),$a([0,-1,-1])]),$a(["84",189,17,10,31091,$a([30,105,20]),$a([1,114,22]),$a([0,-1,-1]),$a([3,45,22]),$a([55,47,20]),$a([0,-1,-1]),$a([2,26,26]),$a([62,33,28]),$a([0,-1,-1]),$a([79,18,28]),$a([4,33,30]),$a([0,-1,-1])])]);$_.eclval=$g($_.eclevel,1)-49;var _Ii=$_.metrics;for(var _Ij=0,_Ik=_Ii.length;_Ij<_Ik;_Ij++){$_.m=$g(_Ii,_Ij);$_.vers=$g($_.m,0);$_.size=$g($_.m,1);$_.alnk=$g($_.m,2);$_.alnn=$g($_.m,3);$_.alnr=$f($_.size-$_.alnk*$_.alnn);$_.nmod=$g($_.m,4);$_.ncws=~~($_.nmod/8);$_.rbit=$_.nmod%8;$_.ecbs=$G($_.m,5+$_.eclval*3,3);var _J4=$_.ecbs;$k[$j++]="ecws";$k[$j++]=0;for(var _J5=0,_J6=_J4.length;_J5<_J6;_J5++){var _J7=$g(_J4,_J5);var _JA=$k[--$j];$k[$j++]=$f(_JA+$g(_J7,0)*$g(_J7,2))}var _JB=$k[--$j];$_[$k[--$j]]=_JB;$_.dcws=$f($_.ncws-$_.ecws);$_.dmod=$_.dcws*8;$_.okay=true;if($ne($_.version,"unset")&&$ne($_.version,$_.vers)){$_.okay=false}if($_.bits.length>$_.dmod){$_.okay=false}if($_.okay){break}}if(!$_.okay){$k[$j++]="bwipp.hanxinNoValidSymbol#25749";$k[$j++]="Maximum length exceeded or invalid content";bwipp_raiseerror()}$_.version=$_.vers;$_.msgbits=$_.bits;$_.e1nb=$g($g($_.ecbs,0),0);$_.e2nb=$g($g($_.ecbs,1),0);$_.e3nb=$g($g($_.ecbs,2),0);$_.e1dcws=$g($g($_.ecbs,0),1);$_.e2dcws=$g($g($_.ecbs,1),1);$_.e3dcws=$g($g($_.ecbs,2),1);$_.e1ecws=$g($g($_.ecbs,0),2);$_.e2ecws=$g($g($_.ecbs,1),2);$_.e3ecws=$g($g($_.ecbs,2),2);$_.pad=$s($_.dmod);for(var _Ju=0,_Jt=$_.pad.length-1;_Ju<=_Jt;_Ju+=1){$p($_.pad,_Ju,48)}$P($_.pad,0,$_.msgbits);$_.cws=$a($_.dcws);for(var _K2=0,_K1=$_.cws.length-1;_K2<=_K1;_K2+=1){$_.c=_K2;$_.cwb=$G($_.pad,$_.c*8,8);$_.cw=0;for(var _K6=0;_K6<=7;_K6+=1){$_.i=_K6;$_.cw=$f($_.cw+~~$pow(2,8-$_.i-1)*($g($_.cwb,$_.i)-48))}$p($_.cws,$_.c,$_.cw)}$_.rscodes=function(){$_.rspm=$k[--$j];$_.rsgf=$k[--$j];$_.rsnc=$k[--$j];$_.rscws=$k[--$j];$k[$j++]=Infinity;$k[$j++]=1;for(var _KK=0,_KL=$_.rsgf-1;_KK<_KL;_KK++){var _KM=$k[$j-1];var _KN=_KM*2;$k[$j++]=_KN;if(_KN>=$_.rsgf){var _KQ=$k[--$j];$k[$j++]=$xo(_KQ,$_.rspm)}}$_.rsalog=$a();$_.rslog=$a($_.rsgf);for(var _KW=1,_KV=$_.rsgf-1;_KW<=_KV;_KW+=1){$p($_.rslog,$g($_.rsalog,_KW),_KW)}$_.rsprod=function(){var _Ka=$k[$j-1];var _Kb=$k[$j-2];if(_Ka!=0&&_Kb!=0){var _Ke=$g($_.rslog,$k[--$j]);var _Kk=$g($_.rsalog,$f(_Ke+$g($_.rslog,$k[--$j]))%($_.rsgf-1));$k[$j++]=_Kk}else{$j-=2;$k[$j++]=0}};$k[$j++]=Infinity;$k[$j++]=1;for(var _Km=0,_Kn=$_.rsnc;_Km<_Kn;_Km++){$k[$j++]=0}$_.coeffs=$a();for(var _Kr=1,_Kq=$_.rsnc;_Kr<=_Kq;_Kr+=1){$_.i=_Kr;$p($_.coeffs,$_.i,$g($_.coeffs,$_.i-1));for(var _Ky=$_.i-1;_Ky>=1;_Ky-=1){$_.j=_Ky;$k[$j++]=$_.coeffs;$k[$j++]=$_.j;$k[$j++]=$g($_.coeffs,$_.j-1);$k[$j++]=$g($_.coeffs,$_.j);$k[$j++]=$g($_.rsalog,$_.i);$_.rsprod();var _LA=$k[--$j];var _LB=$k[--$j];var _LC=$k[--$j];$p($k[--$j],_LC,$xo(_LB,_LA))}$k[$j++]=$_.coeffs;$k[$j++]=0;$k[$j++]=$g($_.coeffs,0);$k[$j++]=$g($_.rsalog,$_.i);$_.rsprod();var _LK=$k[--$j];var _LL=$k[--$j];$p($k[--$j],_LL,_LK)}$_.nd=$_.rscws.length;$k[$j++]=Infinity;$q($_.rscws);for(var _LQ=0,_LR=$_.rsnc;_LQ<_LR;_LQ++){$k[$j++]=0}$k[$j++]=0;$_.rscws=$a();for(var _LV=0,_LU=$_.nd-1;_LV<=_LU;_LV+=1){$_.k=$xo($g($_.rscws,_LV),$g($_.rscws,$_.nd));for(var _Ld=0,_Lc=$_.rsnc-1;_Ld<=_Lc;_Ld+=1){$_.j=_Ld;$k[$j++]=$_.rscws;$k[$j++]=$_.nd+$_.j;$k[$j++]=$g($_.rscws,$_.nd+$_.j+1);$k[$j++]=$_.k;$k[$j++]=$g($_.coeffs,$f($_.rsnc-$_.j)-1);$_.rsprod();var _Lq=$k[--$j];var _Lr=$k[--$j];var _Ls=$k[--$j];$p($k[--$j],_Ls,$xo(_Lr,_Lq))}}$k[$j++]=$G($_.rscws,0,$_.rscws.length-1)};$_.dcwsb=$a($f($_.e1nb+$_.e2nb+$_.e3nb));$_.ecwsb=$a($_.dcwsb.length);$_.in=0;$_.out=0;for(var _M4=0,_M5=$_.e1nb;_M4<_M5;_M4++){$k[$j++]=$G($_.cws,$_.in,$_.e1dcws);$k[$j++]=$_.e1ecws;$k[$j++]=256;$k[$j++]=355;$_.rscodes();var _MB=$k[--$j];$p($_.dcwsb,$_.out,$G(_MB,0,$_.e1dcws));$p($_.ecwsb,$_.out,$G(_MB,$_.e1dcws,$_.e1ecws));$_.in=$f($_.in+$_.e1dcws);$_.out=$_.out+1}for(var _MP=0,_MQ=$_.e2nb;_MP<_MQ;_MP++){$k[$j++]=$G($_.cws,$_.in,$_.e2dcws);$k[$j++]=$_.e2ecws;$k[$j++]=256;$k[$j++]=355;$_.rscodes();var _MW=$k[--$j];$p($_.dcwsb,$_.out,$G(_MW,0,$_.e2dcws));$p($_.ecwsb,$_.out,$G(_MW,$_.e2dcws,$_.e2ecws));$_.in=$f($_.in+$_.e2dcws);$_.out=$_.out+1}for(var _Mk=0,_Ml=$_.e3nb;_Mk<_Ml;_Mk++){$k[$j++]=$G($_.cws,$_.in,$_.e3dcws);$k[$j++]=$_.e3ecws;$k[$j++]=256;$k[$j++]=355;$_.rscodes();var _Mr=$k[--$j];$p($_.dcwsb,$_.out,$G(_Mr,0,$_.e3dcws));$p($_.ecwsb,$_.out,$G(_Mr,$_.e3dcws,$_.e3ecws));$_.in=$f($_.in+$_.e3dcws);$_.out=$_.out+1}$_.cws=$a($_.ncws);$_.cw=0;for(var _N8=0,_N7=$_.dcwsb.length-1;_N8<=_N7;_N8+=1){$_.i=_N8;var _NB=$g($_.dcwsb,$_.i);$P($_.cws,$_.cw,_NB);$_.cw=_NB.length+$_.cw;var _NH=$g($_.ecwsb,$_.i);$P($_.cws,$_.cw,_NH);$_.cw=_NH.length+$_.cw}$k[$j++]=Infinity;var _NL=$_.ncws;var _NM=12;var _NN=_NL-1;if(_NL-1>12){var _=_NM;_NM=_NN;_NN=_}for(var _NP=0,_NO=_NN;_NP<=_NO;_NP+=1){for(var _NS=_NP,_NR=$_.ncws-1;_NS<=_NR;_NS+=13){$k[$j++]=_NS;if(_NS<$_.ncws){var _NW=$g($_.cws,$k[--$j]);$k[$j++]=_NW}else{$j--}}}$_.cws=$a();if($_.rbit>0){$_.pad=$a($_.cws.length+1);$P($_.pad,0,$_.cws);$p($_.pad,$_.pad.length-1,0);$_.cws=$_.pad}var _Nh=$g($_.options,"debugcws")!==undefined;if(_Nh){$k[$j++]="bwipp.debugcws#25872";$k[$j++]=$_.cws;bwipp_raiseerror()}$k[$j++]=Infinity;for(var _Nl=0,_Nm=$_.size*$_.size;_Nl<_Nm;_Nl++){$k[$j++]=-1}$_.pixs=$a();$_.qmv=function(){var _Np=$k[--$j];var _Nq=$k[--$j];$k[$j++]=$f(_Nq+_Np*$_.size)};if($_.alnn!=0){$_.trmv=function(){var _Nt=$k[--$j];var _Nv=$k[--$j];$k[$j++]=$f(_Nt*$_.size+$_.size-1-_Nv)};$_.aplot=function(){var _Nw=$k[$j-2];var _Nx=$k[$j-3];var _Ny=$k[$j-1];$j-=3;$k[$j++]=_Ny;$k[$j++]=_Nx;$k[$j++]=_Nw;$k[$j++]=_Ny;$k[$j++]=_Nw;$k[$j++]=_Nx;$_.trmv();var _O0=$k[--$j];$k[$j++]=$_.pixs;$k[$j++]=_O0;var _O1=$k[$j-3];var _O2=$k[$j-1];$p($k[$j-2],_O2,_O1);$j-=3;$_.trmv();var _O5=$k[--$j];$k[$j++]=$_.pixs;$k[$j++]=_O5;var _O6=$k[$j-3];var _O7=$k[$j-1];$p($k[$j-2],_O7,_O6);$j-=3};$_.i=0;$_.stag=0;for(;;){if($_.i>=$_.size){break}for(var _OD=0,_OC=$_.size-1;_OD<=_OC;_OD+=1){$_.j=_OD;if($f($_.j+$_.alnr)<$_.size){$k[$j++]=(~~($_.j/$_.alnk)+$_.stag)%2==0&&!($_.i==0&&$_.j<$_.alnk)||$_.j%$_.alnk==0}else{$k[$j++]=$f($_.alnn+$_.stag)%2==0}if($k[--$j]){$k[$j++]=$_.j;$k[$j++]=$_.i;$k[$j++]=1;$_.aplot();var _OU=$_.j;var _OV=$_.i;$k[$j++]=_OU+1;$k[$j++]=_OV+1;if(_OV+1<$_.size&&_OU+1<$_.size){$k[$j++]=0;$_.aplot()}else{$j-=2}}}if($f($_.i+$_.alnr)==$_.size){$_.i=$f($_.i+$_.alnr)-1}else{$_.i=$f($_.i+$_.alnk)}$_.stag=1-$_.stag}for(var _Ok=$_.alnk,_Ol=$_.alnk,_Oj=$_.size-2;_Ol<0?_Ok>=_Oj:_Ok<=_Oj;_Ok+=_Ol){$_.i=_Ok;if(~~($_.i/$_.alnk)%2!=0){$k[$j++]=$_.pixs;$k[$j++]=0;$k[$j++]=$_.i-1;$_.trmv();var _Oq=$k[--$j];$p($k[--$j],_Oq,0);$k[$j++]=$_.pixs;$k[$j++]=0;$k[$j++]=$_.i+1;$_.trmv();var _Ou=$k[--$j];$p($k[--$j],_Ou,0);$k[$j++]=$_.pixs;$k[$j++]=1;$k[$j++]=$_.i-1;$_.trmv();var _Oy=$k[--$j];$p($k[--$j],_Oy,0);$k[$j++]=$_.pixs;$k[$j++]=1;$k[$j++]=$_.i;$_.trmv();var _P2=$k[--$j];$p($k[--$j],_P2,0);$k[$j++]=$_.pixs;$k[$j++]=1;$k[$j++]=$_.i+1;$_.trmv();var _P6=$k[--$j];$p($k[--$j],_P6,0);$k[$j++]=$_.pixs;$k[$j++]=$_.i-1;$k[$j++]=0;$_.trmv();var _PA=$k[--$j];$p($k[--$j],_PA,0);$k[$j++]=$_.pixs;$k[$j++]=$_.i+1;$k[$j++]=0;$_.trmv();var _PE=$k[--$j];$p($k[--$j],_PE,0);$k[$j++]=$_.pixs;$k[$j++]=$_.i-1;$k[$j++]=1;$_.trmv();var _PI=$k[--$j];$p($k[--$j],_PI,0);$k[$j++]=$_.pixs;$k[$j++]=$_.i;$k[$j++]=1;$_.trmv();var _PM=$k[--$j];$p($k[--$j],_PM,0);$k[$j++]=$_.pixs;$k[$j++]=$_.i+1;$k[$j++]=1;$_.trmv();var _PQ=$k[--$j];$p($k[--$j],_PQ,0)}$k[$j++]=$_.pixs;$k[$j++]=$_.size-1;$k[$j++]=$_.i-1;$_.trmv();var _PV=$k[--$j];if($g($k[--$j],_PV)!=1){$k[$j++]=$_.pixs;$k[$j++]=$_.size-1;$k[$j++]=$_.i-1;$_.trmv();var _Pb=$k[--$j];$p($k[--$j],_Pb,0);$k[$j++]=$_.pixs;$k[$j++]=$_.size-2;$k[$j++]=$_.i-1;$_.trmv();var _Pg=$k[--$j];$p($k[--$j],_Pg,0);$k[$j++]=$_.pixs;$k[$j++]=$_.size-2;$k[$j++]=$_.i;$_.trmv();var _Pl=$k[--$j];$p($k[--$j],_Pl,0);$k[$j++]=$_.pixs;$k[$j++]=$_.size-2;$k[$j++]=$_.i+1;$_.trmv();var _Pq=$k[--$j];$p($k[--$j],_Pq,0);$k[$j++]=$_.pixs;$k[$j++]=$_.size-1;$k[$j++]=$_.i+1;$_.trmv();var _Pv=$k[--$j];$p($k[--$j],_Pv,0);$k[$j++]=$_.pixs;$k[$j++]=$_.i-1;$k[$j++]=$_.size-1;$_.trmv();var _Q0=$k[--$j];$p($k[--$j],_Q0,0);$k[$j++]=$_.pixs;$k[$j++]=$_.i-1;$k[$j++]=$_.size-2;$_.trmv();var _Q5=$k[--$j];$p($k[--$j],_Q5,0);$k[$j++]=$_.pixs;$k[$j++]=$_.i;$k[$j++]=$_.size-2;$_.trmv();var _QA=$k[--$j];$p($k[--$j],_QA,0);$k[$j++]=$_.pixs;$k[$j++]=$_.i+1;$k[$j++]=$_.size-2;$_.trmv();var _QF=$k[--$j];$p($k[--$j],_QF,0);$k[$j++]=$_.pixs;$k[$j++]=$_.i+1;$k[$j++]=$_.size-1;$_.trmv();var _QK=$k[--$j];$p($k[--$j],_QK,0)}}}$_.fpat=$a([$a([1,1,1,1,1,1,1,0]),$a([1,0,0,0,0,0,0,0]),$a([1,0,1,1,1,1,1,0]),$a([1,0,1,0,0,0,0,0]),$a([1,0,1,0,1,1,1,0]),$a([1,0,1,0,1,1,1,0]),$a([1,0,1,0,1,1,1,0]),$a([0,0,0,0,0,0,0,0])]);$_.fpat2=$a([$a([1,1,1,0,1,0,1,0]),$a([1,1,1,0,1,0,1,0]),$a([1,1,1,0,1,0,1,0]),$a([0,0,0,0,1,0,1,0]),$a([1,1,1,1,1,0,1,0]),$a([0,0,0,0,0,0,1,0]),$a([1,1,1,1,1,1,1,0]),$a([0,0,0,0,0,0,0,0])]);for(var _Qh=0,_Qg=$_.fpat.length-1;_Qh<=_Qg;_Qh+=1){$_.y=_Qh;for(var _Ql=0,_Qk=$g($_.fpat,0).length-1;_Ql<=_Qk;_Ql+=1){$_.x=_Ql;$_.fpb=$g($g($_.fpat,$_.y),$_.x);$_.fpb2=$g($g($_.fpat2,$_.y),$_.x);$k[$j++]=$_.pixs;$k[$j++]=$_.x;$k[$j++]=$_.y;$_.qmv();var _R0=$k[--$j];$p($k[--$j],_R0,$_.fpb);$k[$j++]=$_.pixs;$k[$j++]=$f($_.size-$_.x)-1;$k[$j++]=$_.y;$_.qmv();var _R7=$k[--$j];$p($k[--$j],_R7,$_.fpb);$k[$j++]=$_.pixs;$k[$j++]=$f($_.size-$_.x)-1;$k[$j++]=$f($_.size-$_.y)-1;$_.qmv();var _RF=$k[--$j];$p($k[--$j],_RF,$_.fpb);$k[$j++]=$_.pixs;$k[$j++]=$_.x;$k[$j++]=$f($_.size-$_.y)-1;$_.qmv();var _RM=$k[--$j];$p($k[--$j],_RM,$_.fpb2)}}$_.functionmap=$a([$a([$a([0,8]),$a([$_.size-1,$_.size-9])]),$a([$a([1,8]),$a([$_.size-2,$_.size-9])]),$a([$a([2,8]),$a([$_.size-3,$_.size-9])]),$a([$a([3,8]),$a([$_.size-4,$_.size-9])]),$a([$a([4,8]),$a([$_.size-5,$_.size-9])]),$a([$a([5,8]),$a([$_.size-6,$_.size-9])]),$a([$a([6,8]),$a([$_.size-7,$_.size-9])]),$a([$a([7,8]),$a([$_.size-8,$_.size-9])]),$a([$a([8,8]),$a([$_.size-9,$_.size-9])]),$a([$a([8,7]),$a([$_.size-9,$_.size-8])]),$a([$a([8,6]),$a([$_.size-9,$_.size-7])]),$a([$a([8,5]),$a([$_.size-9,$_.size-6])]),$a([$a([8,4]),$a([$_.size-9,$_.size-5])]),$a([$a([8,3]),$a([$_.size-9,$_.size-4])]),$a([$a([8,2]),$a([$_.size-9,$_.size-3])]),$a([$a([8,1]),$a([$_.size-9,$_.size-2])]),$a([$a([8,0]),$a([$_.size-9,$_.size-1])]),$a([$a([$_.size-9,0]),$a([8,$_.size-1])]),$a([$a([$_.size-9,1]),$a([8,$_.size-2])]),$a([$a([$_.size-9,2]),$a([8,$_.size-3])]),$a([$a([$_.size-9,3]),$a([8,$_.size-4])]),$a([$a([$_.size-9,4]),$a([8,$_.size-5])]),$a([$a([$_.size-9,5]),$a([8,$_.size-6])]),$a([$a([$_.size-9,6]),$a([8,$_.size-7])]),$a([$a([$_.size-9,7]),$a([8,$_.size-8])]),$a([$a([$_.size-9,8]),$a([8,$_.size-9])]),$a([$a([$_.size-8,8]),$a([7,$_.size-9])]),$a([$a([$_.size-7,8]),$a([6,$_.size-9])]),$a([$a([$_.size-6,8]),$a([5,$_.size-9])]),$a([$a([$_.size-5,8]),$a([4,$_.size-9])]),$a([$a([$_.size-4,8]),$a([3,$_.size-9])]),$a([$a([$_.size-3,8]),$a([2,$_.size-9])]),$a([$a([$_.size-2,8]),$a([1,$_.size-9])]),$a([$a([$_.size-1,8]),$a([0,$_.size-9])])]);var _U9=$_.functionmap;for(var _UA=0,_UB=_U9.length;_UA<_UB;_UA++){$F($g(_U9,_UA),function(){$q($k[--$j]);$_.qmv();$p($_.pixs,$k[--$j],0)})}var _UM=$a([function(){$j-=2;$k[$j++]=1},function(){var _UG=$k[--$j];var _UH=$k[--$j];$k[$j++]=$f(_UH+_UG)%2},function(){var _UI=$k[--$j];var _UJ=$k[--$j];$k[$j++]=$f((_UI+_UJ)%3+_UJ%3)%2},function(){var _UK=$k[--$j];var _UL=$k[--$j];$k[$j++]=$f(_UL%_UK+(_UK%_UL+(_UK%3+_UL%3)))%2}]);$_.maskfuncs=_UM;if($_.mask!=-1){$_.maskfuncs=$a([$g($_.maskfuncs,$_.mask-1)]);$_.bestmaskval=$_.mask-1}$_.masks=$a($_.maskfuncs.length);for(var _UX=0,_UW=$_.masks.length-1;_UX<=_UW;_UX+=1){$_.m=_UX;$_.mask=$a($_.size*$_.size);for(var _Ud=0,_Uc=$_.size-1;_Ud<=_Uc;_Ud+=1){$_.j=_Ud;for(var _Ug=0,_Uf=$_.size-1;_Ug<=_Uf;_Ug+=1){$_.i=_Ug;$k[$j++]=$_.i+1;$k[$j++]=$_.j+1;if($g($_.maskfuncs,$_.m)()===true){break}var _Um=$k[--$j];$k[$j++]=_Um==0;$k[$j++]=$_.pixs;$k[$j++]=$_.i;$k[$j++]=$_.j;$_.qmv();var _Uq=$k[--$j];var _Us=$g($k[--$j],_Uq);var _Ut=$k[--$j];var _Uu=_Ut&&_Us==-1?1:0;$k[$j++]=_Uu;$k[$j++]=$_.mask;$k[$j++]=$_.i;$k[$j++]=$_.j;$_.qmv();var _Uy=$k[$j-3];var _Uz=$k[$j-1];$p($k[$j-2],_Uz,_Uy);$j-=3}}$p($_.masks,$_.m,$_.mask)}$_.posx=0;$_.posy=0;$_.num=0;for(;;){if($_.posy==$_.size){break}$k[$j++]=$_.pixs;$k[$j++]=$_.posx;$k[$j++]=$_.posy;$_.qmv();var _V9=$k[--$j];if($g($k[--$j],_V9)==-1){var _VE=$g($_.cws,~~($_.num/8));var _VG=-(7-$_.num%8);$k[$j++]=(_VG<0?_VE>>>-_VG:_VE<<_VG)&1;$k[$j++]=$_.pixs;$k[$j++]=$_.posx;$k[$j++]=$_.posy;$_.qmv();var _VK=$k[$j-3];var _VL=$k[$j-1];$p($k[$j-2],_VL,_VK);$j-=3;$_.num=$_.num+1}$_.posx=$_.posx+1;if($_.posx==$_.size){$_.posx=0;$_.posy=$_.posy+1}}$_.evalfulln1n3=function(){$_.scrle=$k[--$j];$k[$j++]="scr1";$k[$j++]=0;$F($_.scrle,function(){var _VU=$k[$j-1];if(_VU>=3){var _VV=$k[--$j];var _VX=$f($k[--$j]+_VV*4);$k[$j++]=_VX;$k[$j++]=_VX}$j--});var _VY=$k[--$j];$_[$k[--$j]]=_VY;$_.scr3=0;for(var _Vc=5,_Vb=$_.scrle.length-1;_Vc<=_Vb;_Vc+=2){$_.j=_Vc;if($g($_.scrle,$_.j)%3==0){$_.fact=~~($g($_.scrle,$_.j)/3);var _Vl=$G($_.scrle,$_.j-4,4);for(var _Vm=0,_Vn=_Vl.length;_Vm<_Vn;_Vm++){$k[$j++]=$g(_Vl,_Vm)==$_.fact}var _Vq=$k[--$j];var _Vr=$k[--$j];var _Vs=$k[--$j];if($k[--$j]&&(_Vs&&(_Vr&&_Vq))){if($_.j==5||$_.j+2>=$_.scrle.length){$_.scr3=$_.scr3+50}else{if($g($_.scrle,$_.j-5)>=3||$g($_.scrle,$_.j+1)>=3){$_.scr3=$_.scr3+50}}}}}for(var _W7=1,_W6=$_.scrle.length-5;_W7<=_W6;_W7+=2){$_.j=_W7;if($g($_.scrle,$_.j)%3==0){$_.fact=~~($g($_.scrle,$_.j)/3);var _WG=$G($_.scrle,$_.j+1,4);for(var _WH=0,_WI=_WG.length;_WH<_WI;_WH++){$k[$j++]=$g(_WG,_WH)==$_.fact}var _WL=$k[--$j];var _WM=$k[--$j];var _WN=$k[--$j];if($k[--$j]&&(_WN&&(_WM&&_WL))){if($_.j==1||$_.j+6>=$_.scrle.length){$_.scr3=$_.scr3+50}else{if($g($_.scrle,$_.j-1)>=3||$g($_.scrle,$_.j+5)>=3){$_.scr3=$_.scr3+50}}}}}$k[$j++]=$_.scr1;$k[$j++]=$_.scr3};$_.evalfull=function(){$_.sym=$k[--$j];$_.n1=0;$_.n3=0;$_.rle=$a($_.size+1);$_.lastpairs=$a($_.size);$_.thispairs=$a($_.size);$_.sizeadd1=$_.size+1;for(var _Wm=0,_Wl=$_.size-1;_Wm<=_Wl;_Wm+=1){$_.i=_Wm;$k[$j++]=Infinity;var _Wo=$_.size;$k[$j++]=0;$k[$j++]=0;for(var _Wq=$_.i,_Wr=_Wo,_Wp=_Wo*_Wo-1;_Wr<0?_Wq>=_Wp:_Wq<=_Wp;_Wq+=_Wr){var _Wt=$g($_.sym,_Wq);var _Wu=$k[--$j];$k[$j++]=_Wt;if($eq(_Wu,_Wt)){var _Wv=$k[--$j];var _Ww=$k[--$j];$k[$j++]=_Ww+1;$k[$j++]=_Wv}else{var _Wx=$k[--$j];$k[$j++]=1;$k[$j++]=_Wx}}$j--;var _Wz=$m()+2;$as($G($_.rle,0,_Wz-2));$_.evalfulln1n3();$_.n3=$f($k[--$j]+$_.n3);$_.n1=$f($k[--$j]+$_.n1);$j--;$_.symrow=$G($_.sym,$_.i*$_.size,$_.size);$k[$j++]=Infinity;var _XA=$_.symrow;$k[$j++]=0;$k[$j++]=0;for(var _XB=0,_XC=_XA.length;_XB<_XC;_XB++){var _XD=$g(_XA,_XB);var _XE=$k[--$j];$k[$j++]=_XD;if($eq(_XE,_XD)){var _XF=$k[--$j];var _XG=$k[--$j];$k[$j++]=_XG+1;$k[$j++]=_XF}else{var _XH=$k[--$j];$k[$j++]=1;$k[$j++]=_XH}}$j--;var _XJ=$m()+2;$as($G($_.rle,0,_XJ-2));$_.evalfulln1n3();$_.n3=$f($k[--$j]+$_.n3);$_.n1=$f($k[--$j]+$_.n1);$j--}$k[$j++]=$f($_.n1+$_.n3)};$_.bestscore=999999999;for(var _XT=0,_XS=$_.masks.length-1;_XT<=_XS;_XT+=1){$_.m=_XT;$_.masksym=$a($_.size*$_.size);for(var _Xa=0,_XZ=$_.size*$_.size-1;_Xa<=_XZ;_Xa+=1){$_.i=_Xa;$p($_.masksym,$_.i,$xo($g($_.pixs,$_.i),$g($g($_.masks,$_.m),$_.i)))}if($_.masks.length!=1){$k[$j++]=$_.masksym;$_.evalfull();$_.score=$k[--$j];if($_.score<$_.bestscore){$_.bestsym=$_.masksym;$_.bestmaskval=$_.m;$_.bestscore=$_.score}}else{$_.bestsym=$_.masksym}}$_.pixs=$_.bestsym;$_.funval=((~~(($_.size-21)/2)+20)*4+$_.eclval)*4+$_.bestmaskval;$k[$j++]=$a([($_.funval&3840)>>>8,($_.funval&240)>>>4,$_.funval&15]);$k[$j++]=4;$k[$j++]=16;$k[$j++]=19;$_.rscodes();$_.funvals=$k[--$j];$k[$j++]=Infinity;$F($_.funvals,function(){$k[$j++]=4;$_.tobin();$F($k[--$j],function(){var _Y5=$k[--$j];$k[$j++]=_Y5-48})});$k[$j++]=0;$k[$j++]=1;$k[$j++]=0;$k[$j++]=1;$k[$j++]=0;$k[$j++]=1;$_.funbits=$a();for(var _Y9=0,_Y8=$_.functionmap.length-1;_Y9<=_Y8;_Y9+=1){$_.i=_Y9;$F($g($_.functionmap,$_.i),function(){var _YE=$k[--$j];$k[$j++]=$_.pixs;$q(_YE);$_.qmv();var _YI=$k[--$j];$p($k[--$j],_YI,$g($_.funbits,$_.i))})}var _YQ=new Map([["ren","renmatrix"],["pixs",$_.pixs],["pixx",$_.size],["pixy",$_.size],["height",$_.size*2/72],["width",$_.size*2/72],["borderleft",3],["borderright",3],["bordertop",3],["borderbottom",3],["opt",$_.options]]);$k[$j++]=_YQ;if(!$_.dontdraw){bwipp_renmatrix()}$_=$__}function bwipp_dotcode(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.rows=-1;$_.columns=-1;$_.ratio=-1;$_.parse=false;$_.parsefnc=false;$_.raw=false;$_.fast=false;$_.mask=-1;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.rows!=-1){if($_.rows<5){$k[$j++]="bwipp.dotcodeBadRows#26228";$k[$j++]="There must be at least 5 rows";bwipp_raiseerror()}}if($_.columns!=-1){if($_.columns<5){$k[$j++]="bwipp.dotcodeBadColumns#26234";$k[$j++]="There must be at least 5 columns";bwipp_raiseerror()}}if($_.rows!=-1&&$_.columns!=-1&&($_.rows+$_.columns)%2!=1){$k[$j++]="bwipp.dotcodeRowsColumnsBadParity#26239";$k[$j++]="Sum of rows and columns must be odd";bwipp_raiseerror()}if($_.ratio==-1&&$_.rows==-1&&$_.columns==-1){$_.ratio=3/2}if($_.ratio!=-1){if($_.ratio<=0){$k[$j++]="bwipp.dotcodeRatio#26248";$k[$j++]="The ratio must be greater than 0";bwipp_raiseerror()}}if($_.mask!=-1){if($_.mask<0||$_.mask>3){$k[$j++]="bwipp.dotcodeBadMask#26254";$k[$j++]="Valid mask values are 0 to 3";bwipp_raiseerror()}}$_.laa=-1;$_.lab=-2;$_.lac=-3;$_.bin=-4;$_.sfa=-5;$_.sfb=-6;$_.sb2=-7;$_.sb3=-8;$_.sb4=-9;$_.sb5=-10;$_.sb6=-11;$_.sfc=-12;$_.sc2=-13;$_.sc3=-14;$_.sc4=-15;$_.sc5=-16;$_.sc6=-17;$_.sc7=-18;$_.bsa=-19;$_.bsb=-20;$_.tma=-21;$_.tmb=-22;$_.tmc=-23;$_.tms=-24;$_.fn1=-25;$_.fn2=-26;$_.fn3=-27;$_.crl=-28;$_.aim=-29;$_.m05=-30;$_.m06=-31;$_.m12=-32;$_.mac=-33;var _N=new Map([["parse",$_.parse],["parsefnc",$_.parsefnc],["eci",true],["FNC1",$_.fn1],["FNC3",$_.fn3]]);$_.fncvals=_N;$k[$j++]="msg";$k[$j++]=$_.barcode;$k[$j++]=$_.fncvals;bwipp_parseinput();var _Q=$k[--$j];$_[$k[--$j]]=_Q;$_.msglen=$_.msg.length;var _T=$_.msg;$k[$j++]="numecis";$k[$j++]=0;for(var _U=0,_V=_T.length;_U<_V;_U++){if($g(_T,_U)<=-1e6){var _X=$k[--$j];$k[$j++]=_X+1}}var _Y=$k[--$j];$_[$k[--$j]]=_Y;$_.msgtmp=$a($f($_.msg.length+$_.numecis*6));$_.j=0;for(var _f=0,_e=$_.msg.length-1;_f<=_e;_f+=1){var _h=$g($_.msg,_f);$k[$j++]=_h;if(_h<=-1e6){var _l=$G($R($s(7),-$k[--$j],10),1,6);for(var _m=0,_n=_l.length;_m<_n;_m++){$k[$j++]=$g(_l,_m)}$as($a(6));$P($_.msgtmp,$_.j+1,$k[--$j]);$p($_.msgtmp,$_.j,$_.fn2);$_.j=$_.j+7}else{$p($_.msgtmp,$_.j,$k[--$j]);$_.j=$_.j+1}}$_.msg=$_.msgtmp;$_.msglen=$_.msg.length;$_.charmaps=$a([$a([32,32,"00"]),$a(["!","!","01"]),$a(['"','"',"02"]),$a(["#","#","03"]),$a(["$","$","04"]),$a(["%","%","05"]),$a(["&","&","06"]),$a(["'","'","07"]),$a([40,40,"08"]),$a([41,41,"09"]),$a(["*","*","10"]),$a(["+","+","11"]),$a([",",",","12"]),$a(["-","-","13"]),$a([".",".","14"]),$a(["/","/","15"]),$a(["0","0","16"]),$a(["1","1","17"]),$a(["2","2","18"]),$a(["3","3","19"]),$a(["4","4","20"]),$a(["5","5","21"]),$a(["6","6","22"]),$a(["7","7","23"]),$a(["8","8","24"]),$a(["9","9","25"]),$a([":",":","26"]),$a([";",";","27"]),$a(["<","<","28"]),$a(["=","=","29"]),$a([">",">","30"]),$a(["?","?","31"]),$a(["@","@","32"]),$a(["A","A","33"]),$a(["B","B","34"]),$a(["C","C","35"]),$a(["D","D","36"]),$a(["E","E","37"]),$a(["F","F","38"]),$a(["G","G","39"]),$a(["H","H","40"]),$a(["I","I","41"]),$a(["J","J","42"]),$a(["K","K","43"]),$a(["L","L","44"]),$a(["M","M","45"]),$a(["N","N","46"]),$a(["O","O","47"]),$a(["P","P","48"]),$a(["Q","Q","49"]),$a(["R","R","50"]),$a(["S","S","51"]),$a(["T","T","52"]),$a(["U","U","53"]),$a(["V","V","54"]),$a(["W","W","55"]),$a(["X","X","56"]),$a(["Y","Y","57"]),$a(["Z","Z","58"]),$a(["[","[","59"]),$a([92,92,"60"]),$a(["]","]","61"]),$a(["^","^","62"]),$a(["_","_","63"]),$a([0,"`","64"]),$a([1,"a","65"]),$a([2,"b","66"]),$a([3,"c","67"]),$a([4,"d","68"]),$a([5,"e","69"]),$a([6,"f","70"]),$a([7,"g","71"]),$a([8,"h","72"]),$a([9,"i","73"]),$a([10,"j","74"]),$a([11,"k","75"]),$a([12,"l","76"]),$a([13,"m","77"]),$a([14,"n","78"]),$a([15,"o","79"]),$a([16,"p","80"]),$a([17,"q","81"]),$a([18,"r","82"]),$a([19,"s","83"]),$a([20,"t","84"]),$a([21,"u","85"]),$a([22,"v","86"]),$a([23,"w","87"]),$a([24,"x","88"]),$a([25,"y","89"]),$a([26,"z","90"]),$a([27,"{","91"]),$a([28,"|","92"]),$a([29,"}","93"]),$a([30,"~","94"]),$a([31,127,"95"]),$a([$_.sfb,$_.crl,"96"]),$a([$_.sb2,9,"97"]),$a([$_.sb3,28,"98"]),$a([$_.sb4,29,"99"]),$a([$_.sb5,30,$_.aim]),$a([$_.sb6,$_.sfa,$_.laa]),$a([$_.lab,$_.laa,$_.sfb]),$a([$_.sc2,$_.sc2,$_.sb2]),$a([$_.sc3,$_.sc3,$_.sb3]),$a([$_.sc4,$_.sc4,$_.sb4]),$a([$_.lac,$_.lac,$_.lab]),$a([$_.fn1,$_.fn1,$_.fn1]),$a([$_.fn2,$_.fn2,$_.fn2]),$a([$_.fn3,$_.fn3,$_.fn3]),$a([$_.bsa,$_.bsa,$_.bsa]),$a([$_.bsb,$_.bsb,$_.bsb]),$a([$_.bin,$_.bin,$_.bin])]);$_.charvals=$a([new Map,new Map,new Map]);for(var _3d=0,_3c=$_.charmaps.length-1;_3d<=_3c;_3d+=1){$_.i=_3d;$_.encs=$g($_.charmaps,$_.i);for(var _3h=0;_3h<=2;_3h+=1){$_.j=_3h;var _3k=$g($_.encs,$_.j);$k[$j++]=_3k;if($eq($t(_3k),"stringtype")){var _3n=$g($k[--$j],0);$k[$j++]=_3n}$p($g($_.charvals,$_.j),$k[--$j],$_.i)}}$_.Avals=$g($_.charvals,0);$_.Bvals=$g($_.charvals,1);$p($_.Bvals,$_.m05,97);$p($_.Bvals,$_.m06,98);$p($_.Bvals,$_.m12,99);$p($_.Bvals,$_.mac,100);$_.Cvals=$g($_.charvals,2);$k[$j++]=Infinity;var _4H=$a([$_.sc2,$_.sc3,$_.sc4,$_.sc5,$_.sc6,$_.sc7,$_.tma,$_.tmb,$_.tmc,$_.tms]);$k[$j++]=102;for(var _4I=0,_4J=_4H.length;_4I<_4J;_4I++){var _4M=$k[--$j]+1;$k[$j++]=$g(_4H,_4I);$k[$j++]=_4M;$k[$j++]=_4M}$j--;$_.BINvals=$d();$_.A=0;$_.B=1;$_.C=2;$_.BIN=3;$k[$j++]=Infinity;for(var _4Q=0,_4R=$_.msglen+1;_4Q<_4R;_4Q++){$k[$j++]=0}$_.nDigits=$a();$k[$j++]=Infinity;for(var _4U=0,_4V=$_.msglen+1;_4U<_4V;_4U++){$k[$j++]=false}$_.SeventeenTen=$a();$k[$j++]=Infinity;for(var _4Y=0,_4Z=$_.msglen+1;_4Y<_4Z;_4Y++){$k[$j++]=false}$_.ECI=$a();$k[$j++]=Infinity;for(var _4c=0,_4d=$_.msglen+1;_4c<_4d;_4c++){$k[$j++]=false}$_.DatumA=$a();$k[$j++]=Infinity;for(var _4g=0,_4h=$_.msglen+1;_4g<_4h;_4g++){$k[$j++]=false}$_.DatumB=$a();$k[$j++]=Infinity;for(var _4k=0,_4l=$_.msglen+1;_4k<_4l;_4k++){$k[$j++]=false}$_.DatumC=$a();$k[$j++]=Infinity;for(var _4o=0,_4p=$_.msglen+8;_4o<_4p;_4o++){$k[$j++]=false}$_.Binary=$a();$k[$j++]=Infinity;for(var _4s=0,_4t=$_.msglen+1;_4s<_4t;_4s++){$k[$j++]=0}$_.AheadC=$a();$k[$j++]=Infinity;for(var _4w=0,_4x=$_.msglen+1;_4w<_4x;_4w++){$k[$j++]=0}$_.TryC=$a();$k[$j++]=Infinity;for(var _50=0,_51=$_.msglen+1;_50<_51;_50++){$k[$j++]=0}$_.AheadA=$a();$k[$j++]=Infinity;for(var _54=0,_55=$_.msglen+1;_54<_55;_54++){$k[$j++]=0}$_.AheadB=$a();$k[$j++]=Infinity;for(var _58=0,_59=$_.msglen+1;_58<_59;_58++){$k[$j++]=0}$_.UntilEndSeg=$a();for(var _5C=$_.msglen-1;_5C>=0;_5C-=1){$_.i=_5C;$_.barchar=$g($_.msg,$_.i);if($_.barchar>=48&&$_.barchar<=57){$p($_.nDigits,$_.i,$g($_.nDigits,$_.i+1)+1)}var _5P=$g($_.Avals,$_.barchar)!==undefined;if(_5P){$p($_.DatumA,$_.i,true)}var _5U=$g($_.Bvals,$_.barchar)!==undefined;if(_5U){$p($_.DatumB,$_.i,true)}$_.CRLF=false;if($_.barchar==13&&$_.i<$_.msglen-1){if($g($_.msg,$_.i+1)==10){$_.CRLF=true}}if($_.CRLF){$p($_.DatumB,$_.i,true)}if($g($_.nDigits,$_.i)>=2){$p($_.DatumC,$_.i,true)}if($_.barchar<0){$p($_.DatumC,$_.i,true)}if($_.barchar>=128){$p($_.Binary,$_.i,true)}if($g($_.nDigits,$_.i)>=10){$k[$j++]=Infinity;$q($G($_.msg,$_.i,10));for(var _5x=0;_5x<1;_5x++){if($k[--$j]!=48){$k[$j++]=false;break}if($k[--$j]!=49){$k[$j++]=false;break}$j-=6;if($k[--$j]!=55){$k[$j++]=false;break}if($k[--$j]!=49){$k[$j++]=false;break}$k[$j++]=true}$k[$j++]=$_.SeventeenTen;$k[$j++]=$_.i;var _64=$k[$j-3];var _65=$k[$j-1];$p($k[$j-2],_65,_64);$j-=3;$l()}if($g($_.nDigits,$_.i+1)>=6&&$g($_.msg,$_.i)==$_.fn2){$p($_.ECI,$_.i,true)}if($_.barchar<0&&$_.barchar!=$_.fn3){$p($_.AheadC,$_.i,$g($_.AheadC,$_.i+1)+1)}else{if($g($_.nDigits,$_.i)<=1){$p($_.AheadC,$_.i,0)}else{$p($_.AheadC,$_.i,$g($_.AheadC,$_.i+2)+1)}}if($g($_.nDigits,$_.i)>0&&$gt($g($_.AheadC,$_.i),$g($_.AheadC,$_.i+1))){$p($_.TryC,$_.i,$g($_.AheadC,$_.i))}if($g($_.DatumA,$_.i)&&$g($_.TryC,$_.i)<2&&$_.barchar!=$_.fn3){$p($_.AheadA,$_.i,$g($_.AheadA,$_.i+1)+1)}if($g($_.DatumB,$_.i)&&$g($_.TryC,$_.i)<2&&$_.barchar!=$_.fn3){$k[$j++]=$_.AheadB;$k[$j++]=$_.i;$k[$j++]=$_.AheadB;$k[$j++]=$_.i+1;if($_.CRLF){var _7C=$k[--$j];$k[$j++]=_7C+1}var _7D=$k[--$j];var _7F=$g($k[--$j],_7D);var _7G=$k[--$j];$p($k[--$j],_7G,_7F+1)}if($_.barchar!=$_.fn3){$p($_.UntilEndSeg,$_.i,$g($_.UntilEndSeg,$_.i+1)+1)}}$_.addtocws=function(){var _7P=$k[--$j];$P($_.cws,$_.j,_7P);$_.j=_7P.length+$_.j};$_.base259to103=function(){$_.in=$k[--$j];$_.inlen=$_.in.length;$k[$j++]=Infinity;for(var _7W=0,_7X=5-$_.inlen;_7W<_7X;_7W++){$k[$j++]=0}$q($_.in);$_.in=$a();$_.out=$a(6);$k[$j++]=Infinity;$q($G($_.in,0,2));$_.msbs=$a();$k[$j++]=Infinity;$q($_.msbs);var _7f=$k[--$j];var _7g=$k[--$j];$k[$j++]=$f(_7f+_7g*259);for(var _7h=0;_7h<2;_7h++){var _7i=$k[--$j];$k[$j++]=_7i%103;$k[$j++]=~~(_7i/103)}$_.mscs=$a();$k[$j++]=Infinity;$q($G($_.in,2,3));$_.lsbs=$a();$k[$j++]=Infinity;$q($_.lsbs);var _7o=$k[--$j];var _7p=$k[--$j];var _7q=$k[--$j];$k[$j++]=$f(_7o+_7p*259+_7q*67081);for(var _7r=0;_7r<3;_7r++){var _7s=$k[--$j];$k[$j++]=_7s%103;$k[$j++]=~~(_7s/103)}$_.lscs=$a();var _7v=$g($_.lscs,0);var _7x=$g($_.mscs,0);$p($_.out,5,$f(_7v+_7x*42)%103);var _80=$g($_.lscs,1);var _82=$g($_.mscs,0);var _84=$g($_.mscs,1);$p($_.out,4,$f(~~((_7v+_7x*42)/103)+_80+_82*68+_84*42)%103);var _87=$g($_.lscs,2);var _89=$g($_.mscs,0);var _8B=$g($_.mscs,1);var _8D=$g($_.mscs,2);$p($_.out,3,$f(~~((~~((_7v+_7x*42)/103)+_80+_82*68+_84*42)/103)+_87+_89*92+_8B*68+_8D*42)%103);var _8G=$g($_.lscs,3);var _8I=$g($_.mscs,0);var _8K=$g($_.mscs,1);var _8M=$g($_.mscs,2);$p($_.out,2,$f(~~((~~((~~((_7v+_7x*42)/103)+_80+_82*68+_84*42)/103)+_87+_89*92+_8B*68+_8D*42)/103)+_8G+_8I*15+_8K*92+_8M*68)%103);var _8P=$g($_.mscs,1);var _8R=$g($_.mscs,2);$p($_.out,1,$f(~~((~~((~~((~~((_7v+_7x*42)/103)+_80+_82*68+_84*42)/103)+_87+_89*92+_8B*68+_8D*42)/103)+_8G+_8I*15+_8K*92+_8M*68)/103)+_8P*15+_8R*92)%103);$p($_.out,0,$f(~~((~~((~~((~~((~~((_7v+_7x*42)/103)+_80+_82*68+_84*42)/103)+_87+_89*92+_8B*68+_8D*42)/103)+_8G+_8I*15+_8K*92+_8M*68)/103)+_8P*15+_8R*92)/103)+$g($_.mscs,2)*15)%103);$k[$j++]=$G($_.out,6-$_.inlen-1,$_.inlen+1)};$_.finaliseBIN=function(){if($_.bpos!=0){$k[$j++]=$G($_.bvals,0,$_.bpos);$_.base259to103();$q($k[--$j]);$_.bpos=0}};$_.addtobin=function(){$p($_.bvals,$_.bpos,$k[--$j]);$_.bpos=$_.bpos+1;if($_.bpos==5){$_.finaliseBIN()}};$_.ECIabc=function(){var _8m=$G($_.msg,$_.i+1,6);$k[$j++]=0;for(var _8n=0,_8o=_8m.length;_8n<_8o;_8n++){var _8q=$k[--$j];$k[$j++]=$f(_8q+($g(_8m,_8n)-48))*10}var _8s=~~($k[--$j]/10);$k[$j++]=_8s;if(_8s>=40){var _8u=$k[--$j]-40;var _8v=_8u%12769;$k[$j++]=~~(_8u/12769)+40;$k[$j++]=~~(_8v/113);$k[$j++]=_8v%113}};$_.ECIbin=function(){$k[$j++]=Infinity;var _8y=$G($_.msg,$_.i+1,6);$k[$j++]=0;for(var _8z=0,_90=_8y.length;_8z<_90;_8z++){var _92=$k[--$j];$k[$j++]=$f(_92+($g(_8y,_8z)-48))*10}var _94=~~($k[--$j]/10);$k[$j++]=_94;if(_94>=65536){var _95=$k[--$j];var _96=_95%65536;$k[$j++]=258;$k[$j++]=~~(_95/65536);$k[$j++]=~~(_96/256);$k[$j++]=_96%256}else{var _97=$k[$j-1];if(_97>=256){var _98=$k[--$j];$k[$j++]=257;$k[$j++]=~~(_98/256);$k[$j++]=_98%256}else{var _99=$k[--$j];$k[$j++]=256;$k[$j++]=_99}}var _9A=$a();for(var _9B=0,_9C=_9A.length;_9B<_9C;_9B++){$k[$j++]=$g(_9A,_9B);$_.addtobin()}};$_.encC=function(){for(var _9E=0;_9E<1;_9E++){if($_.i==$_.segstart){for(var _9H=0;_9H<1;_9H++){if($_.i>$_.segend-7){$k[$j++]=0;break}if($g($_.msg,$_.segstart)!=91){$k[$j++]=0;break}if($g($_.msg,$_.segstart+1)!=41){$k[$j++]=0;break}if($g($_.msg,$_.segstart+2)!=62){$k[$j++]=0;break}if($g($_.msg,$_.segstart+3)!=30){$k[$j++]=0;break}var _9Y=$g($_.msg,$_.segstart+4);if(_9Y<48||_9Y>57){$k[$j++]=0;break}var _9b=$g($_.msg,$_.segstart+5);if(_9b<48||_9b>57){$k[$j++]=0;break}if($g($_.msg,$_.segend-1)!=4){$k[$j++]=0;break}var _9l=$f(($g($_.msg,$_.segstart+4)-48)*10+($g($_.msg,$_.segstart+5)-48));$k[$j++]=_9l;if(_9l!=5&&(_9l!=6&&_9l!=12)){$k[$j-1]=$_.mac;break}if($g($_.msg,$_.segstart+6)!=29){$k[$j-1]=0;break}if($g($_.msg,$_.segend-2)!=30){$k[$j-1]=0;break}var _9t=$k[$j-1];if(_9t==5){$k[$j-1]=$_.m05;break}if($k[--$j]==6){$k[$j++]=$_.m06;break}$k[$j++]=$_.m12;break}$_.inmac=$k[--$j];if($_.inmac!=0){$k[$j++]=$a([$g($_.Cvals,$_.lab)]);$_.addtocws();$_.mode=$_.B;$k[$j++]=$a([$g($_.Bvals,$_.inmac)]);$_.addtocws();if($_.inmac==$_.mac){$k[$j++]=$a([$g($_.Bvals,$g($_.msg,$_.segstart+4))]);$_.addtocws();$k[$j++]=$a([$g($_.Bvals,$g($_.msg,$_.segstart+5))]);$_.addtocws();$_.i=$_.i+6}else{$_.i=$_.i+7}break}}if($_.i==$_.segstart){if($g($_.nDigits,$_.i)>=2){$k[$j++]=$a([$g($_.Cvals,$_.fn1)]);$_.addtocws()}if($g($_.msg,$_.i)==$_.fn1&&$g($_.nDigits,$_.i+1)>=2){$_.i=$_.i+1}}if($g($_.SeventeenTen,$_.i)){$k[$j++]=$a([$g($_.Cvals,$_.aim),$f(($g($_.msg,$_.i+2)-48)*10+($g($_.msg,$_.i+3)-48)),$f(($g($_.msg,$_.i+4)-48)*10+($g($_.msg,$_.i+5)-48)),$f(($g($_.msg,$_.i+6)-48)*10+($g($_.msg,$_.i+7)-48))]);$_.addtocws();$_.i=$_.i+10;break}if($g($_.DatumC,$_.i)){var _BB=$g($_.msg,$_.i);if(_BB==$_.fn1||(_BB==$_.fn2||_BB==$_.fn3)){$k[$j++]=$a([$g($_.Cvals,$g($_.msg,$_.i))]);$_.addtocws();if($g($_.ECI,$_.i)){$k[$j++]=Infinity;$_.ECIabc();var _BO=$a();$k[$j++]=_BO;$_.addtocws();$_.i=$_.i+7;break}if($g($_.msg,$_.i)==$_.fn3&&$_.segstart!=$_.i){$_.i=$_.i+1;$_.inmac=0;$_.segstart=$_.i;$_.segend=$f($_.i+$g($_.UntilEndSeg,$_.i));break}$_.i=$_.i+1;break}$k[$j++]=$a([$f(($g($_.msg,$_.i)-48)*10+($g($_.msg,$_.i+1)-48))]);$_.addtocws();$_.i=$_.i+2;break}if($g($_.Binary,$_.i)){if($g($_.nDigits,$_.i+1)>0){if($g($_.msg,$_.i)<160){$k[$j++]=$a([$g($_.Cvals,$_.bsa),$g($_.Avals,$g($_.msg,$_.i)-128)]);$_.addtocws()}else{$k[$j++]=$a([$g($_.Cvals,$_.bsb),$g($_.Bvals,$g($_.msg,$_.i)-128)]);$_.addtocws()}$_.i=$_.i+1;break}$k[$j++]=$a([$g($_.Cvals,$_.bin)]);$_.addtocws();$_.mode=$_.BIN;break}$_.m=$g($_.AheadA,$_.i);$_.n=$g($_.AheadB,$_.i);if($gt($_.m,$_.n)){$k[$j++]=$a([$g($_.Cvals,$_.laa)]);$_.addtocws();$_.mode=$_.A;break}if($_.i==$_.segstart){var _CZ=$g($_.msg,$_.i);if(_CZ==9||(_CZ==28||(_CZ==29||_CZ==30))){$k[$j++]=$a([$g($_.Cvals,$_.laa)]);$_.addtocws();$_.mode=$_.A;break}}if($_.n>4){$k[$j++]=$a([$g($_.Cvals,$_.lab)]);$_.addtocws();$_.mode=$_.B;break}$k[$j++]=$a([$g($_.Cvals,$g($a([$_.sfb,$_.sb2,$_.sb3,$_.sb4]),$_.n-1))]);$_.addtocws();for(var _Cw=0,_Cx=$_.n;_Cw<_Cx;_Cw++){if($g($_.msg,$_.i)==13){$k[$j++]=$a([$g($_.Bvals,$_.crl)]);$_.addtocws();$_.i=$_.i+2}else{$k[$j++]=$a([$g($_.Bvals,$g($_.msg,$_.i))]);$_.addtocws();$_.i=$_.i+1}}break}};$_.encB=function(){for(var _DD=0;_DD<1;_DD++){$_.n=$g($_.TryC,$_.i);if($_.n>=2){if($_.n>4){$k[$j++]=$a([$g($_.Bvals,$_.lac)]);$_.addtocws();$_.mode=$_.C;break}$k[$j++]=$a([$g($_.Bvals,$g($a([$_.sfc,$_.sc2,$_.sc3,$_.sc4]),$_.n-1))]);$_.addtocws();for(var _DZ=0,_Da=$_.n;_DZ<_Da;_DZ++){if($g($_.msg,$_.i)<0){$k[$j++]=$a([$g($_.Cvals,$g($_.msg,$_.i))]);$_.addtocws();$_.i=$_.i+1}else{$k[$j++]=$a([$f(($g($_.msg,$_.i)-48)*10+($g($_.msg,$_.i+1)-48))]);$_.addtocws();$_.i=$_.i+2}}break}if($g($_.DatumB,$_.i)){var _Dy=$g($_.msg,$_.i);if(_Dy==$_.fn1||(_Dy==$_.fn2||_Dy==$_.fn3)){$k[$j++]=$a([$g($_.Bvals,$g($_.msg,$_.i))]);$_.addtocws();if($g($_.ECI,$_.i)){$k[$j++]=Infinity;$_.ECIabc();var _EB=$a();$k[$j++]=_EB;$_.addtocws();$_.i=$_.i+7;break}if($g($_.msg,$_.i)==$_.fn3&&$_.i!=$_.segstart){$_.i=$_.i+1;$_.mode=$_.C;$_.inmac=0;$_.segstart=$_.i;$_.segend=$f($_.i+$g($_.UntilEndSeg,$_.i));break}$_.i=$_.i+1;break}if($g($_.msg,$_.i)==13&&$_.i<$_.msglen-1){if($g($_.msg,$_.i+1)==10){$k[$j++]=$a([$g($_.Bvals,$_.crl)]);$_.addtocws();$_.i=$_.i+2;break}}$k[$j++]=$a([$g($_.Bvals,$g($_.msg,$_.i))]);$_.addtocws();$_.i=$_.i+1;break}if($g($_.Binary,$_.i)){if($g($_.DatumB,$_.i+1)){if($g($_.msg,$_.i)<160){$k[$j++]=$a([$g($_.Bvals,$_.bsa),$g($_.Avals,$g($_.msg,$_.i)-128)]);$_.addtocws()}else{$k[$j++]=$a([$g($_.Bvals,$_.bsb),$g($_.Bvals,$g($_.msg,$_.i)-128)]);$_.addtocws()}$_.i=$_.i+1;break}$k[$j++]=$a([$g($_.Bvals,$_.bin)]);$_.addtocws();$_.mode=$_.BIN;break}if($g($_.AheadA,$_.i)==1){$k[$j++]=$a([$g($_.Bvals,$_.sfa),$g($_.Avals,$g($_.msg,$_.i))]);$_.addtocws();$_.i=$_.i+1;break}$k[$j++]=$a([$g($_.Bvals,$_.laa)]);$_.addtocws();$_.mode=$_.A;break}};$_.encA=function(){for(var _Fa=0;_Fa<1;_Fa++){$_.n=$g($_.TryC,$_.i);if($_.n>=2){if($_.n>4){$k[$j++]=$a([$g($_.Avals,$_.lac)]);$_.addtocws();$_.mode=$_.C;break}$k[$j++]=$a([$g($_.Avals,$g($a([$_.sfc,$_.sc2,$_.sc3,$_.sc4]),$_.n-1))]);$_.addtocws();for(var _Fw=0,_Fx=$_.n;_Fw<_Fx;_Fw++){if($g($_.msg,$_.i)<0){$k[$j++]=$a([$g($_.Cvals,$g($_.msg,$_.i))]);$_.addtocws();$_.i=$_.i+1}else{$k[$j++]=$a([$f(($g($_.msg,$_.i)-48)*10+($g($_.msg,$_.i+1)-48))]);$_.addtocws();$_.i=$_.i+2}}break}if($g($_.DatumA,$_.i)){var _GL=$g($_.msg,$_.i);if(_GL==$_.fn1||(_GL==$_.fn2||_GL==$_.fn3)){$k[$j++]=$a([$g($_.Avals,$g($_.msg,$_.i))]);$_.addtocws();if($g($_.ECI,$_.i)){$k[$j++]=Infinity;$_.ECIabc();var _GY=$a();$k[$j++]=_GY;$_.addtocws();$_.i=$_.i+7;break}if($g($_.msg,$_.i)==$_.fn3&&$_.i!=$_.segstart){$_.i=$_.i+1;$_.mode=$_.C;$_.inmac=0;$_.segstart=$_.i;$_.segend=$f($_.i+$g($_.UntilEndSeg,$_.i));break}$_.i=$_.i+1;break}$k[$j++]=$a([$g($_.Avals,$g($_.msg,$_.i))]);$_.addtocws();$_.i=$_.i+1;break}if($g($_.Binary,$_.i)){if($g($_.DatumA,$_.i+1)){if($g($_.msg,$_.i)<160){$k[$j++]=$a([$g($_.Avals,$_.bsa),$g($_.Avals,$g($_.msg,$_.i)-128)]);$_.addtocws()}else{$k[$j++]=$a([$g($_.Avals,$_.bsb),$g($_.Bvals,$g($_.msg,$_.i)-128)]);$_.addtocws()}$_.i=$_.i+1;break}$k[$j++]=$a([$g($_.Avals,$_.bin)]);$_.addtocws();$_.mode=$_.BIN;break}$_.n=$g($_.AheadB,$_.i);if($_.n>6){$k[$j++]=$a([$g($_.Avals,$_.lab)]);$_.addtocws();$_.mode=$_.B;break}$k[$j++]=$a([$g($_.Avals,$g($a([$_.sfb,$_.sb2,$_.sb3,$_.sb4,$_.sb5,$_.sb6]),$_.n-1))]);$_.addtocws();for(var _Ho=0,_Hp=$_.n;_Ho<_Hp;_Ho++){if($g($_.msg,$_.i)==13){$k[$j++]=$a([$g($_.Bvals,$_.crl)]);$_.addtocws();$_.i=$_.i+2}else{$k[$j++]=$a([$g($_.Bvals,$g($_.msg,$_.i))]);$_.addtocws();$_.i=$_.i+1}}break}};$_.encBIN=function(){for(var _I5=0;_I5<1;_I5++){$_.n=$g($_.TryC,$_.i);if($_.n>=2){$k[$j++]=Infinity;$_.finaliseBIN();var _IA=$a();$k[$j++]=_IA;$_.addtocws();if($_.n>7){$k[$j++]=$a([$g($_.BINvals,$_.tmc)]);$_.addtocws();$_.mode=$_.C;break}$k[$j++]=$a([$g($_.BINvals,$g($a([$_.sc2,$_.sc3,$_.sc4,$_.sc5,$_.sc6,$_.sc7]),$_.n-2))]);$_.addtocws();for(var _IU=0,_IV=$_.n;_IU<_IV;_IU++){if($g($_.msg,$_.i)<0){$k[$j++]=$a([$g($_.Cvals,$g($_.msg,$_.i))]);$_.addtocws();$_.i=$_.i+1}else{$k[$j++]=$a([$f(($g($_.msg,$_.i)-48)*10+($g($_.msg,$_.i+1)-48))]);$_.addtocws();$_.i=$_.i+2}}break}if($g($_.ECI,$_.i)&&$g($_.Binary,$_.i+7)){$k[$j++]=Infinity;$_.ECIbin();var _Iu=$a();$k[$j++]=_Iu;$_.addtocws();$_.i=$_.i+7;if($_.i==$_.msglen){$k[$j++]=Infinity;$_.finaliseBIN();var _Iy=$a();$k[$j++]=_Iy;$_.addtocws()}break}if($g($_.msg,$_.i)>=0){if($g($_.Binary,$_.i)||$g($_.Binary,$_.i+1)||$g($_.Binary,$_.i+2)||$g($_.Binary,$_.i+3)||$g($_.ECI,$_.i+1)&&$g($_.Binary,$_.i+8)){$k[$j++]=Infinity;$k[$j++]=$g($_.msg,$_.i);$_.addtobin();var _JN=$a();$k[$j++]=_JN;$_.addtocws();$_.i=$_.i+1;if($_.i==$_.msglen){$k[$j++]=Infinity;$_.finaliseBIN();var _JR=$a();$k[$j++]=_JR;$_.addtocws()}break}}$k[$j++]=Infinity;$_.finaliseBIN();var _JS=$a();$k[$j++]=_JS;$_.addtocws();if($_.i!=$_.msglen-1){if($g($_.msg,$_.i)==$_.fn3&&$_.i!=$_.segstart){$k[$j++]=$a([$g($_.BINvals,$_.tms)]);$_.addtocws();$_.i=$_.i+1;$_.mode=$_.C;$_.inmac=0;$_.segstart=$_.i;$_.segend=$f($_.i+$g($_.UntilEndSeg,$_.i));break}if($gt($g($_.AheadA,$_.i),$g($_.AheadB,$_.i))){$k[$j++]=$a([$g($_.BINvals,$_.tma)]);$_.addtocws();$_.mode=$_.A}else{$k[$j++]=$a([$g($_.BINvals,$_.tmb)]);$_.addtocws();$_.mode=$_.B}break}break}};$_.cws=$a($_.msglen*2+1);$_.mode=$_.C;$_.bvals=$a(5);$_.bpos=0;$_.inmac=0;$_.segstart=0;$_.segend=$g($_.UntilEndSeg,0);$_.i=0;$_.j=0;for(;;){if($_.i>=$_.msglen){break}if($_.inmac!=0){if($_.inmac!=$_.mac&&$_.i==$_.segend-2){$_.i=$_.i+2;if($_.i>=$_.msglen){break}}if($_.inmac==$_.mac&&$_.i==$_.segend-1){$_.i=$_.i+1;if($_.i>=$_.msglen){break}}}if($_[$g($a(["encA","encB","encC","encBIN"]),$_.mode)]()===true){break}}$_.cws=$G($_.cws,0,$_.j);$_.nd=$_.cws.length;$_.minarea=(($_.nd+3+~~($_.nd/2))*9+2)*2;if($_.ratio!=-1){$_.hgt=$sqrt($_.minarea/$_.ratio);$_.wid=$sqrt($_.minarea*$_.ratio);$_.h=~~$_.hgt;$_.w=~~$_.wid;if(($_.h+$_.w)%2==1){if($_.h*$_.w<$_.minarea){$_.h=$_.h+1;$_.w=$_.w+1}}else{if($_.hgt*$_.w<$_.wid*$_.h){$_.w=$_.w+1;if($_.h*$_.w<$_.minarea){$_.w=$_.w-1;$_.h=$_.h+1;if($_.h*$_.w<$_.minarea){$_.w=$_.w+2}}}else{$_.h=$_.h+1;if($_.h*$_.w<$_.minarea){$_.h=$_.h-1;$_.w=$_.w+1;if($_.h*$_.w<$_.minarea){$_.h=$_.h+2}}}}$_.rows=$_.h;$_.columns=$_.w}else{if($_.columns==-1){var _LH=~~(($_.minarea+$_.rows-1)/$_.rows);$k[$j++]="columns";$k[$j++]=_LH;if((_LH+$_.rows)%2==0){var _LJ=$k[--$j];$k[$j++]=_LJ+1}var _LK=$k[--$j];$_[$k[--$j]]=_LK}if($_.rows==-1){var _LQ=~~(($_.minarea+$_.columns-1)/$_.columns);$k[$j++]="rows";$k[$j++]=_LQ;if((_LQ+$_.columns)%2==0){var _LS=$k[--$j];$k[$j++]=_LS+1}var _LT=$k[--$j];$_[$k[--$j]]=_LT}}$_.ndots=~~($_.rows*$_.columns/2);for(;;){var _LY=$_.nd+1;if((_LY+(~~(_LY/2)+3))*9+2>$_.ndots){break}$_.nd=$_.nd+1}$_.nc=~~($_.nd/2)+3;$_.nw=$_.nd+$_.nc;$_.rembits=$_.ndots-($_.nw*9+2);if($_.nd>$_.cws.length){$k[$j++]=Infinity;$q($_.cws);var _Ll=$_.mode==$_.BIN?109:106;$k[$j++]=_Ll;for(var _Lo=0,_Lp=$_.nd-$_.cws.length-1;_Lo<_Lp;_Lo++){$k[$j++]=106}$_.cws=$a()}var _Ls=$g($_.options,"debugcws")!==undefined;if(_Ls){$k[$j++]="bwipp.debugcws#26927";$k[$j++]=$_.cws;bwipp_raiseerror()}if($_.nw*9>$_.ndots-2){$k[$j++]="bwipp.dotcodeTooLong#26931";$k[$j++]="Maximum length exceeded";bwipp_raiseerror()}$_.encs=$a(["101010101","010101011","010101101","010110101","011010101","101010110","101011010","101101010","110101010","010101110","010110110","010111010","011010110","011011010","011101010","100101011","100101101","100110101","101001011","101001101","101010011","101011001","101100101","101101001","110010101","110100101","110101001","001010111","001011011","001011101","001101011","001101101","001110101","010010111","010011011","010011101","010100111","010110011","010111001","011001011","011001101","011010011","011011001","011100101","011101001","100101110","100110110","100111010","101001110","101011100","101100110","101101100","101110010","101110100","110010110","110011010","110100110","110101100","110110010","110110100","111001010","111010010","111010100","001011110","001101110","001110110","001111010","010011110","010111100","011001110","011011100","011100110","011101100","011110010","011110100","100010111","100011011","100011101","100100111","100110011","100111001","101000111","101100011","101110001","110001011","110001101","110010011","110011001","110100011","110110001","111000101","111001001","111010001","000101111","000110111","000111011","000111101","001001111","001100111","001110011","001111001","010001111","011000111","011100011","011110001","100011110","100111100","101111000","110001110","110011100","110111000","111000110","111001100"]);if($_.rows%2==0){$_.sixedges=$a([$a([$_.columns-1,$_.rows-2]),$a([0,$_.rows-2]),$a([$_.columns-2,$_.rows-1]),$a([1,$_.rows-1]),$a([$_.columns-1,0]),$a([0,0])])}else{$_.sixedges=$a([$a([$_.columns-2,0]),$a([$_.columns-2,$_.rows-1]),$a([$_.columns-1,1]),$a([$_.columns-1,$_.rows-2]),$a([0,0]),$a([0,$_.rows-1])])}$_.dmv=function(){var _MS=$k[--$j];var _MT=$k[--$j];$k[$j++]=$f(_MT+_MS*$_.columns)};$_.outline=$a($_.rows*$_.columns);for(var _MZ=0,_MY=$_.rows-1;_MZ<=_MY;_MZ+=1){$_.y=_MZ;for(var _Mc=0,_Mb=$_.columns-1;_Mc<=_Mb;_Mc+=1){$_.x=_Mc;$k[$j++]=$_.outline;$k[$j++]=$_.x;$k[$j++]=$_.y;$_.dmv();var _Mi=$k[--$j];$p($k[--$j],_Mi,($_.x+$_.y)%2-1)}}var _Mk=$_.sixedges;for(var _Ml=0,_Mm=_Mk.length;_Ml<_Mm;_Ml++){$k[$j++]=$_.outline;$q($g(_Mk,_Ml));$_.dmv();var _Mp=$k[--$j];$p($k[--$j],_Mp,1)}$_.clearcol=function(){$_.x=$k[--$j];$k[$j++]=true;for(var _Mv=$_.x&1,_Mu=$_.rows-1;_Mv<=_Mu;_Mv+=2){$k[$j++]=$_.x;$k[$j++]=_Mv;$_.dmv();if($g($_.sym,$k[--$j])==1){$k[$j-1]=false;break}}};$_.clearrow=function(){$_.y=$k[--$j];$k[$j++]=true;for(var _N4=$_.y&1,_N3=$_.columns-1;_N4<=_N3;_N4+=2){$k[$j++]=_N4;$k[$j++]=$_.y;$_.dmv();if($g($_.sym,$k[--$j])==1){$k[$j-1]=false;break}}};$_.evalsymbol=function(){$_.sym=$k[--$j];$_.worst=9999999;var _NE=$a([$a(["x",0]),$a(["x",1]),$a(["y",0]),$a(["y",1])]);for(var _NF=0,_NG=_NE.length;_NF<_NG;_NF++){$q($g(_NE,_NF));$_.fl=$k[--$j];$_.dir=$k[--$j];$_.sum=0;$_.first=-1;$_.last=-1;var _NL=$eq($_.dir,"x")?$_.columns:$_.rows;for(var _NN=0,_NM=_NL-1;_NN<=_NM;_NN+=1){$_[$_.dir]=_NN;var _NP=$_.sym;var _NR=$_[$_.dir];var _NT=$eq($_.dir,"x")?$_.rows:$_.columns;var _NW=(_NT-1)*$_.fl;if($eq($_.dir,"y")){var _=_NW;_NW=_NR;_NR=_}$k[$j++]=_NP;$k[$j++]=_NR;$k[$j++]=_NW;$_.dmv();var _NX=$k[--$j];if($g($k[--$j],_NX)==1){if($_.first==-1){$_.first=$_[$_.dir]}$_.last=$_[$_.dir];$_.sum=$_.sum+1}}var _Nk=$eq($_.dir,"x")?$_.rows:$_.columns;var _Nl=$f($_.sum+$_.last-$_.first)*_Nk;$k[$j++]=_Nl;if(_Nl<$_.worst){$_.worst=$k[--$j]}else{$j--}}$_.pen=0;if($_.rows%2==1||$_.rows<=12){$_.sum=0;$_.p=0;for(var _Ns=1,_Nr=$_.columns-2;_Ns<=_Nr;_Ns+=1){$k[$j++]=_Ns;$_.clearcol();if($k[--$j]){$_.sum=$_.sum+1;$k[$j++]="p";if($_.sum==1){$k[$j++]=$_.rows}else{$k[$j++]=$_.p*$_.rows}var _Nz=$k[--$j];$_[$k[--$j]]=_Nz}else{$_.sum=0;$_.pen=$_.pen+$_.p;$_.p=0}}$_.pen=$_.pen+$_.p}if($_.rows%2==0||$_.columns<=12){$_.sum=0;$_.p=0;for(var _O9=1,_O8=$_.rows-2;_O9<=_O8;_O9+=1){$k[$j++]=_O9;$_.clearrow();if($k[--$j]){$_.sum=$_.sum+1;$k[$j++]="p";if($_.sum==1){$k[$j++]=$_.columns}else{$k[$j++]=$_.p*$_.columns}var _OG=$k[--$j];$_[$k[--$j]]=_OG}else{$_.sum=0;$_.pen=$_.pen+$_.p;$_.p=0}}$_.pen=$_.pen+$_.p}$k[$j++]=Infinity;for(var _ON=0,_OO=($_.columns+4)*2;_ON<_OO;_ON++){$k[$j++]=0}for(var _OS=0,_OT=$_.columns,_OR=$_.sym.length-1;_OT<0?_OS>=_OR:_OS<=_OR;_OS+=_OT){$k[$j++]=0;$k[$j++]=0;$q($G($_.sym,_OS,$_.columns));$k[$j++]=0;$k[$j++]=0}for(var _OY=0,_OZ=($_.columns+4)*2;_OY<_OZ;_OY++){$k[$j++]=0}$_.symp=$a();$_.columns=$_.columns+4;$_.rows=$_.rows+4;$_.sum=0;for(var _Of=2,_Oe=$_.rows-3;_Of<=_Oe;_Of+=1){$_.y=_Of;for(var _Oj=($_.y&1)+2,_Oi=$_.columns-3;_Oj<=_Oi;_Oj+=2){$_.x=_Oj;for(var _Ok=0;_Ok<1;_Ok++){$k[$j++]=$_.symp;$k[$j++]=$_.x-1;$k[$j++]=$_.y-1;$_.dmv();var _Oo=$k[--$j];if($g($k[--$j],_Oo)==1){break}$k[$j++]=$_.symp;$k[$j++]=$_.x+1;$k[$j++]=$_.y-1;$_.dmv();var _Ou=$k[--$j];if($g($k[--$j],_Ou)==1){break}$k[$j++]=$_.symp;$k[$j++]=$_.x-1;$k[$j++]=$_.y+1;$_.dmv();var _P0=$k[--$j];if($g($k[--$j],_P0)==1){break}$k[$j++]=$_.symp;$k[$j++]=$_.x+1;$k[$j++]=$_.y+1;$_.dmv();var _P6=$k[--$j];if($g($k[--$j],_P6)==1){break}$k[$j++]=$_.symp;$k[$j++]=$_.x;$k[$j++]=$_.y;$_.dmv();var _PC=$k[--$j];if($g($k[--$j],_PC)==0){$_.sum=$_.sum+1;break}$k[$j++]=$_.symp;$k[$j++]=$_.x-2;$k[$j++]=$_.y;$_.dmv();var _PJ=$k[--$j];if($g($k[--$j],_PJ)==1){break}$k[$j++]=$_.symp;$k[$j++]=$_.x;$k[$j++]=$_.y-2;$_.dmv();var _PP=$k[--$j];if($g($k[--$j],_PP)==1){break}$k[$j++]=$_.symp;$k[$j++]=$_.x+2;$k[$j++]=$_.y;$_.dmv();var _PV=$k[--$j];if($g($k[--$j],_PV)==1){break}$k[$j++]=$_.symp;$k[$j++]=$_.x;$k[$j++]=$_.y+2;$_.dmv();var _Pb=$k[--$j];if($g($k[--$j],_Pb)==1){break}$_.sum=$_.sum+1}}}$_.columns=$_.columns-4;$_.rows=$_.rows-4;if($_.worst==0){$k[$j++]=-99999}else{$k[$j++]=$f($_.worst-$_.sum*$_.sum-$_.pen)}};$k[$j++]=Infinity;$k[$j++]=1;for(var _Pm=0;_Pm<112;_Pm++){var _Pn=$k[$j-1];$k[$j++]=_Pn*3%113}$_.rsalog=$a();$_.step=~~($_.nw/112)+1;$_.offset=function(){var _Ps=$k[--$j];$k[$j++]=$f(_Ps*$_.step+$_.start)};$_.bestscore=-99999999;$k[$j++]="masks";if($_.mask!=-1){$k[$j++]=$a([$_.mask])}else{if($_.fast){$k[$j++]=$a([3,2,1,0])}else{$k[$j++]=$a([0,1,2,3])}}var _Q0=$k[--$j];$_[$k[--$j]]=_Q0;$_.litmasks=$a(4);$F($_.masks,function(){$_.mask=$k[--$j];$k[$j++]=Infinity;var _Q9=$_.cws;$k[$j++]=$_.mask;$k[$j++]=$g($a([0,3,7,17]),$_.mask);$k[$j++]=0;for(var _QA=0,_QB=_Q9.length;_QA<_QB;_QA++){var _QD=$k[--$j];var _QE=$k[--$j];$k[$j++]=$f($g(_Q9,_QA)+_QD)%113;$k[$j++]=_QE;$k[$j++]=$f(_QD+_QE)}$j-=2;for(var _QG=0,_QH=$_.nc;_QG<_QH;_QG++){$k[$j++]=0}$_.rscws=$a();for(var _QL=0,_QK=$_.step-1;_QL<=_QK;_QL+=1){$_.start=_QL;$_.ND=~~(($_.nd+1-$_.start+$_.step-1)/$_.step);$_.NW=~~(($_.nw+1-$_.start+$_.step-1)/$_.step);$_.NC=$_.NW-$_.ND;$k[$j++]=Infinity;$k[$j++]=1;for(var _QX=0,_QY=$_.NC;_QX<_QY;_QX++){$k[$j++]=0}$_.coeffs=$a();for(var _Qc=1,_Qb=$_.NC;_Qc<=_Qb;_Qc+=1){$_.i=_Qc;for(var _Qe=$_.NC;_Qe>=1;_Qe-=1){$_.j=_Qe;$p($_.coeffs,$_.j,$f($g($_.coeffs,$_.j)+113-$g($_.rsalog,$_.i)*$g($_.coeffs,$_.j-1)%113)%113)}}for(var _Qs=0,_Qr=$_.ND-1;_Qs<=_Qr;_Qs+=1){$k[$j++]="t";$k[$j++]=$_.rscws;$k[$j++]=_Qs;$_.offset();var _Qu=$k[--$j];var _Qw=$g($k[--$j],_Qu);$k[$j++]=_Qw;$k[$j++]=$_.rscws;$k[$j++]=$_.ND;$_.offset();var _Qz=$k[--$j];var _R1=$g($k[--$j],_Qz);var _R2=$k[--$j];$_[$k[--$j]]=$f(_R2+_R1)%113;for(var _R6=0,_R5=$_.NC-2;_R6<=_R5;_R6+=1){$_.j=_R6;$k[$j++]=$_.rscws;$k[$j++]=$_.ND+$_.j;$_.offset();$k[$j++]=$_.rscws;$k[$j++]=$_.ND+$_.j+1;$_.offset();var _RD=$k[--$j];var _RF=$g($k[--$j],_RD);var _RK=$k[--$j];$p($k[--$j],_RK,$f(_RF+113-$_.t*$g($_.coeffs,$_.j+1)%113)%113)}$k[$j++]=$_.rscws;$k[$j++]=$_.ND+$_.NC-1;$_.offset();var _RT=$k[--$j];$p($k[--$j],_RT,(113-$_.t*$g($_.coeffs,$_.NC)%113)%113)}for(var _RY=$_.ND,_RX=$_.NW-1;_RY<=_RX;_RY+=1){$k[$j++]=_RY;$k[$j++]=$_.rscws;$k[$j++]=_RY;$_.offset();$k[$j++]=113;$k[$j++]=$_.rscws;$r(5,-1);$_.offset();var _Rb=$k[--$j];var _Rd=$g($k[--$j],_Rb);var _Re=$k[--$j];var _Rf=$k[--$j];$p($k[--$j],_Rf,$f(_Re-_Rd)%113)}}$_.bits=$s($_.ndots);$P($_.bits,0,$g($a(["00","01","10","11"]),$_.mask));for(var _Rp=1,_Ro=$_.nw;_Rp<=_Ro;_Rp+=1){$_.i=_Rp;$P($_.bits,($_.i-1)*9+2,$g($_.encs,$g($_.rscws,$_.i)))}if($_.rembits>0){$P($_.bits,$_.nw*9+2,$G("11111111111111111",0,$_.rembits))}var _S2=$_.outline;$_.pixs=$A($a(_S2.length),_S2);$_.posx=0;$k[$j++]="posy";if($_.rows%2==0){$k[$j++]=0}else{$k[$j++]=$_.rows-1}var _S7=$k[--$j];$_[$k[--$j]]=_S7;var _SB=$G($_.bits,0,$_.bits.length-6);for(var _SC=0,_SD=_SB.length;_SC<_SD;_SC++){$k[$j++]=$g(_SB,_SC);for(;;){$k[$j++]=$_.pixs;$k[$j++]=$_.posx;$k[$j++]=$_.posy;$_.dmv();var _SI=$k[--$j];if($g($k[--$j],_SI)==-1){break}if($_.rows%2==0){$_.posy=$_.posy+1;if($_.posy==$_.rows){$_.posy=0;$_.posx=$_.posx+1}}else{$_.posx=$_.posx+1;if($_.posx==$_.columns){$_.posx=0;$_.posy=$_.posy-1}}}$k[$j++]=$_.pixs;$k[$j++]=$_.posx;$k[$j++]=$_.posy;$_.dmv();var _SX=$k[$j-3];var _SY=$k[$j-1];$p($k[$j-2],_SY,_SX-48);$j-=3}for(var _Sa=0;_Sa<=5;_Sa+=1){$_.i=_Sa;$k[$j++]=$_.pixs;$q($g($_.sixedges,$_.i));$_.dmv();var _Sj=$k[--$j];$p($k[--$j],_Sj,$g($_.bits,$_.bits.length-6+$_.i)-48)}$k[$j++]="score";$k[$j++]=$_.pixs;$_.evalsymbol();var _Sm=$k[--$j];$_[$k[--$j]]=_Sm;if($_.score>$_.bestscore){$_.bestsym=$_.pixs;$_.bestscore=$_.score;if($_.fast&&$_.bestscore>~~($_.rows*$_.columns/2)){return true}}var _Sw=$_.pixs;$_.litmask=$A($a(_Sw.length),_Sw);for(var _Sz=0;_Sz<=5;_Sz+=1){$_.i=_Sz;$k[$j++]=$_.litmask;$q($g($_.sixedges,$_.i));$_.dmv();var _T4=$k[--$j];$p($k[--$j],_T4,1)}$p($_.litmasks,$_.mask,$_.litmask);if($_.fast){$k[$j++]="score";$k[$j++]=$_.litmask;$_.evalsymbol();var _TB=$k[--$j];$_[$k[--$j]]=_TB;if($gt($_.score,$_.bestscore)){$_.bestsym=$_.litmask;$_.bestscore=$_.score;if($_.bestscore>~~($_.rows*$_.columns/2)){return true}}}});$_.pixs=$_.bestsym;if(!$_.fast&&$_.bestscore<=~~($_.rows*$_.columns/2)){$_.bestscore=-99999999;$F($_.masks,function(){$_.litmask=$g($_.litmasks,$k[--$j]);$k[$j++]="score";$k[$j++]=$_.litmask;$_.evalsymbol();var _TU=$k[--$j];$_[$k[--$j]]=_TU;if($_.score>$_.bestscore){$_.bestsym=$_.litmask;$_.bestscore=$_.score}});$_.pixs=$_.bestsym}var _Th=new Map([["ren","renmatrix"],["dotty",true],["pixs",$_.pixs],["pixx",$_.columns],["pixy",$_.rows],["height",$_.rows*2/72],["width",$_.columns*2/72],["borderleft",3],["borderright",3],["bordertop",3],["borderbottom",3],["opt",$_.options]]);$k[$j++]=_Th;if(!$_.dontdraw){bwipp_renmatrix()}$_=$__}function bwipp_ultracode(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.eclevel="EC2";$_.parse=false;$_.parsefnc=false;$_.start=257;$_.link1=0;$_.raw=false;$_.rev=2;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];var _2=$_.rev;if(_2!=1&&_2!=2){$k[$j++]="bwipp.ultracodeInvalidRevision#27328";$k[$j++]="Valid revisions are 1 and 2";bwipp_raiseerror()}var _4=$_.eclevel.length==3;$k[$j++]=_4;if(_4){$j--;var _7=$eq($G($_.eclevel,0,2),"EC");$k[$j++]=_7;if(_7){$j--;var _A=$g($_.eclevel,2)-48;var _C=$_.rev==2?1:0;$k[$j++]=_A>=_C&&_A<=5}}if(!$k[--$j]){$k[$j++]="bwipp.ultracodeInvalidErrorCorrectionLevel#27337";$k[$j++]="Valid error correction levels are EC1 to EC5, and EC0 for legacy revision 1";bwipp_raiseerror()}if($_.raw){$_.dcws=$a($_.barcode.length);$_.i=0;$_.j=0;for(;;){if($_.i==$_.barcode.length){break}$_.cw=$i($G($_.barcode,$_.i+1,3));$p($_.dcws,$_.j,$_.cw);$_.i=$_.i+4;$_.j=$_.j+1}$_.dcws=$G($_.dcws,0,$_.j)}else{$_.fn1=-1;$_.fn3=-2;var _Y=new Map([["parse",$_.parse],["parsefnc",$_.parsefnc],["FNC1",$_.fn1],["FNC3",$_.fn3]]);$_.fncvals=_Y;$k[$j++]="msg";$k[$j++]=$_.barcode;$k[$j++]=$_.fncvals;bwipp_parseinput();var _b=$k[--$j];$_[$k[--$j]]=_b;$_.msglen=$_.msg.length;$_.scr=$a([]);$_.scp=$a([]);$k[$j++]=Infinity;$q($_.scr);$q($_.scp);$F($_.msg,function(){var _j=$k[$j-1];if(_j==$_.fn1){$k[$j-1]=268}var _l=$k[$j-1];if(_l==$_.fn3){$k[$j-1]=269}});$_.dcws=$a()}var _p=$g($_.options,"debugcws")!==undefined;if(_p){$k[$j++]="bwipp.debugcws#27381";$k[$j++]=$_.dcws;bwipp_raiseerror()}$_.mcc=$_.dcws.length+3;$_.eclval=$g($_.eclevel,2)-48;if($_.eclval!=0){$k[$j++]="qcc";$k[$j++]=$g($a([0,1,2,4,6,8]),$_.eclval);$k[$j++]=~~($_.mcc/25);if($_.mcc%25!=0){var _10=$k[--$j];$k[$j++]=_10+1}var _11=$k[--$j];var _12=$k[--$j];$_[$k[--$j]]=_12*_11+5}else{$_.qcc=3}$_.acc=$_.qcc-3+78*$_.link1;$_.tcc=$_.mcc+$_.qcc;$_.metrics=$a([$a([2,7,37,5]),$a([3,36,84,13]),$a([4,85,161,22]),$a([5,142,282,29])]);var _1E=$_.metrics;for(var _1F=0,_1G=_1E.length;_1F<_1G;_1F++){$_.m=$g(_1E,_1F);$_.rows=$g($_.m,0);$_.minc=$g($_.m,1);$_.maxc=$g($_.m,2);$_.mcol=$g($_.m,3);$_.okay=true;if($_.tcc<$_.minc||$_.tcc>$_.maxc){$_.okay=false}if($_.okay){break}}if(!$_.okay){$k[$j++]="bwipp.ultracodeNoValidSymbol#27417";$k[$j++]="Maximum length exceeded or invalid content";bwipp_raiseerror()}for(var _1X=$_.mcol;_1X<=61;_1X+=1){$_.columns=_1X;$k[$j++]=$_.columns;if($_.columns>=15){var _1a=$k[--$j];$k[$j++]=_1a-1}if($_.columns>=31){var _1c=$k[--$j];$k[$j++]=_1c-1}if($_.columns>=47){var _1e=$k[--$j];$k[$j++]=_1e-1}var _1i=$f($k[--$j]*$_.rows-3-$_.tcc);$k[$j++]=_1i;if(_1i>=0){$_.pads=$k[--$j];break}$j--}$_.dcc=$f($_.columns-$_.mcol);$k[$j++]=Infinity;$k[$j++]=$_.start;$k[$j++]=$_.mcc;$k[$j++]=$_.acc;$q($_.dcws);for(var _1r=0,_1s=$_.qcc;_1r<_1s;_1r++){$k[$j++]=0}$k[$j++]=0;$_.rsseq=$a();$k[$j++]=Infinity;$k[$j++]=1;for(var _1u=0;_1u<282;_1u++){var _1v=$k[$j-1];$k[$j++]=_1v*3%283}$_.rsalog=$a();$_.rslog=$a(283);for(var _1y=1;_1y<=282;_1y+=1){$p($_.rslog,$g($_.rsalog,_1y),_1y)}$_.rsprod=function(){var _23=$k[$j-1];var _24=$k[$j-2];if(_23!=0&&_24!=0){var _27=$g($_.rslog,$k[--$j]);var _2C=$g($_.rsalog,$f(_27+$g($_.rslog,$k[--$j]))%282);$k[$j++]=_2C}else{$j-=2;$k[$j++]=0}};$_.n=$_.mcc;$_.k=$_.qcc;$k[$j++]=Infinity;$k[$j++]=1;for(var _2G=0,_2H=$_.k;_2G<_2H;_2G++){$k[$j++]=0}$_.coeffs=$a();for(var _2L=1,_2K=$_.k;_2L<=_2K;_2L+=1){$_.i=_2L;$p($_.coeffs,$_.i,$g($_.coeffs,$_.i-1));for(var _2S=$_.i-1;_2S>=1;_2S-=1){$_.j=_2S;$k[$j++]=$_.coeffs;$k[$j++]=$_.j;$k[$j++]=$g($_.coeffs,$_.j-1);$k[$j++]=$g($_.coeffs,$_.j);$k[$j++]=$g($_.rsalog,$_.i);$_.rsprod();var _2e=$k[--$j];var _2f=$k[--$j];var _2g=$k[--$j];$p($k[--$j],_2g,$f(_2f+_2e)%283)}$k[$j++]=$_.coeffs;$k[$j++]=0;$k[$j++]=$g($_.coeffs,0);$k[$j++]=$g($_.rsalog,$_.i);$_.rsprod();var _2o=$k[--$j];var _2p=$k[--$j];$p($k[--$j],_2p,_2o)}$_.coeffs=$G($_.coeffs,0,$_.coeffs.length-1);for(var _2v=$_.coeffs.length-1;_2v>=0;_2v-=2){var _2w=$_.coeffs;$p(_2w,_2v,283-$g(_2w,_2v))}for(var _30=0,_2z=$_.n-1;_30<=_2z;_30+=1){$_.t=$f($g($_.rsseq,_30)+$g($_.rsseq,$_.n))%283;for(var _38=0,_37=$_.k-1;_38<=_37;_38+=1){$_.j=_38;$p($_.rsseq,$_.n+$_.j,$f($g($_.rsseq,$_.n+$_.j+1)+(283-$_.t*$g($_.coeffs,$_.k-$_.j-1)%283))%283)}}for(var _3P=$_.n,_3O=$_.n+$_.k;_3P<=_3O;_3P+=1){$p($_.rsseq,_3P,(283-$g($_.rsseq,_3P))%283)}$_.ecws=$G($_.rsseq,$_.n,$_.k);var _3Y=$g($_.options,"debugecc")!==undefined;if(_3Y){$k[$j++]="bwipp.debugecc#27487";$k[$j++]=$_.ecws;bwipp_raiseerror()}$_.tiles=$a([13135,13136,13153,13156,13163,13165,13513,13515,13516,13531,13535,13536,13561,13563,13565,13613,13615,13616,13631,13635,13636,13651,13653,13656,15135,15136,15153,15163,15165,15313,15315,15316,15351,15353,15356,15361,15363,15365,15613,15615,15616,15631,15635,15636,15651,15653,15656,16135,16136,16153,16156,16165,16313,16315,16316,16351,16353,16356,16361,16363,16365,16513,16515,16516,16531,16535,16536,16561,16563,16565,31315,31316,31351,31356,31361,31365,31513,31515,31516,31531,31535,31536,31561,31563,31565,31613,31615,31631,31635,31636,31651,31653,31656,35131,35135,35136,35151,35153,35156,35161,35163,35165,35315,35316,35351,35356,35361,35365,35613,35615,35616,35631,35635,35636,35651,35653,35656,36131,36135,36136,36151,36153,36156,36163,36165,36315,36316,36351,36356,36361,36365,36513,36515,36516,36531,36535,36536,36561,36563,36565,51313,51315,51316,51351,51353,51356,51361,51363,51365,51513,51516,51531,51536,51561,51563,51613,51615,51616,51631,51635,51636,51651,51653,51656,53131,53135,53136,53151,53153,53156,53161,53163,53165,53513,53516,53531,53536,53561,53563,53613,53615,53616,53631,53635,53636,53651,53653,53656,56131,56135,56136,56151,56153,56156,56161,56163,56165,56313,56315,56316,56351,56353,56356,56361,56363,56365,56513,56516,56531,56536,56561,56563,61313,61315,61316,61351,61353,61356,61361,61363,61365,61513,61515,61516,61531,61535,61536,61561,61563,61565,61615,61631,61635,61651,61653,63131,63135,63136,63151,63153,63156,63161,63163,63165,63513,63515,63516,63531,63535,63536,63561,63563,63565,63613,63615,63631,63635,63651,63653,65131,65135,65136,65151,65153,65156,65161,65163,65165,65313,65315,65316,65351,65353,65356,65361,65363,65365,65613,65615,65631,65635,65651,65653,56565,51515]);$_.dccurev1=$a([51363,51563,51653,53153,53163,53513,53563,53613,53653,56153,56163,56313,56353,56363,56513,56563,51316,51356,51536,51616,53156,53516,53536,53616,53636,53656,56136,56156,56316,56356,56516,56536]);$_.dcclrev1=$a([61351,61361,61531,61561,61631,61651,63131,63151,63161,63531,63561,63631,65131,65161,65351,65631,31351,31361,31531,31561,31631,31651,35131,35151,35161,35361,35631,35651,36131,36151,36351,36531]);$_.dccurev2=$a([15316,16316,13516,16516,13616,15616,13136,15136,16136,13536,16536,13636,13156,16156,15356,13656,15313,16313,13513,16513,13613,15613,13153,15153,16153,16353,13653,15653,13163,15163,15363,13563]);$_.dcclrev2=$a([36315,36515,35615,35135,36135,31535,36535,31635,35635,35165,36165,31365,35365,36365,31565,36565,61315,65315,63515,61615,65135,61535,63535,61635,63635,65635,63165,65165,61365,65365,61565,63565]);$k[$j++]="dccu";if($_.rev==1){$k[$j++]=$_.dccurev1}else{$k[$j++]=$_.dccurev2}var _3j=$k[--$j];$_[$k[--$j]]=_3j;$k[$j++]="dccl";if($_.rev==1){$k[$j++]=$_.dcclrev1}else{$k[$j++]=$_.dcclrev2}var _3o=$k[--$j];$_[$k[--$j]]=_3o;$_.rows=$_.rows*6+1;$_.columns=$_.columns+6;$k[$j++]=Infinity;for(var _3u=0,_3v=$_.rows*$_.columns;_3u<_3v;_3u++){$k[$j++]=-1}$_.pixs=$a();$_.qmv=function(){var _3y=$k[--$j];var _3z=$k[--$j];$k[$j++]=$f(_3z+_3y*$_.columns)};for(var _42=0,_41=$_.columns-1;_42<=_41;_42+=1){$_.i=_42;for(var _45=0,_44=$_.rows-1;_45<=_44;_45+=6){$_.j=_45;if($_.i>=5){$k[$j++]=$_.pixs;$k[$j++]=$_.i;$k[$j++]=$_.j;$_.qmv();var _4B=$k[--$j];$p($k[--$j],_4B,$_.i%2*9)}}$k[$j++]=$_.pixs;$k[$j++]=$_.i;$k[$j++]=0;$_.qmv();var _4F=$k[--$j];$p($k[--$j],_4F,9);$k[$j++]=$_.pixs;$k[$j++]=$_.i;$k[$j++]=$_.rows-1;$_.qmv();var _4K=$k[--$j];$p($k[--$j],_4K,9)}for(var _4O=1,_4N=$_.rows-2;_4O<=_4N;_4O+=1){$_.i=_4O;for(var _4R=3,_4Q=$_.columns-1;_4R<=_4Q;_4R+=16){$_.j=_4R;$k[$j++]=$_.pixs;$k[$j++]=$_.j;$k[$j++]=$_.i;$_.qmv();var _4W=$k[--$j];$p($k[--$j],_4W,(1-$_.i%2)*9)}$k[$j++]=$_.pixs;$k[$j++]=0;$k[$j++]=$_.i;$_.qmv();var _4a=$k[--$j];$p($k[--$j],_4a,9);$k[$j++]=$_.pixs;$k[$j++]=1;$k[$j++]=$_.i;$_.qmv();var _4f=$k[--$j];$p($k[--$j],_4f,(1-$_.i%2)*9);$k[$j++]=$_.pixs;$k[$j++]=2;$k[$j++]=$_.i;$_.qmv();var _4j=$k[--$j];$p($k[--$j],_4j,0);$k[$j++]=$_.pixs;$k[$j++]=3;$k[$j++]=$_.i;$_.qmv();var _4n=$k[--$j];$p($k[--$j],_4n,9);$k[$j++]=$_.pixs;$k[$j++]=4;$k[$j++]=$_.i;$_.qmv();var _4r=$k[--$j];$p($k[--$j],_4r,0);$k[$j++]=$_.pixs;$k[$j++]=$_.columns-1;$k[$j++]=$_.i;$_.qmv();var _4w=$k[--$j];$p($k[--$j],_4w,9)}$_.i=~~($_.rows/2)-5;$k[$j++]=Infinity;var _53=$R($s(5),$g($_.dccu,$_.dcc),10);for(var _54=0,_55=_53.length;_54<_55;_54++){$k[$j++]=$g(_53,_54)-48}var _5B=$R($s(5),$g($_.dccl,$_.dcc),10);$k[$j++]=0;for(var _5C=0,_5D=_5B.length;_5C<_5D;_5C++){$k[$j++]=$g(_5B,_5C)-48}var _5F=$a();for(var _5G=0,_5H=_5F.length;_5G<_5H;_5G++){$k[$j++]=$g(_5F,_5G);$k[$j++]=$_.pixs;$k[$j++]=2;$k[$j++]=$_.i;$_.qmv();var _5L=$k[$j-3];var _5M=$k[$j-1];$p($k[$j-2],_5M,_5L);$j-=3;$_.i=$_.i+1}$k[$j++]=Infinity;$k[$j++]=$_.start;$k[$j++]=$_.mcc;$q($_.ecws);$k[$j++]=$_.tcc;$k[$j++]=283;$k[$j++]=$_.acc;$q($_.dcws);for(var _5W=0,_5X=$_.pads;_5W<_5X;_5W++){$k[$j++]=284}$k[$j++]=$_.qcc;$_.tileseq=$a();$_.x=5;$_.y=1;var _5a=$_.tileseq;for(var _5b=0,_5c=_5a.length;_5b<_5c;_5b++){var _5h=$R($s(5),$g($_.tiles,$g(_5a,_5b)),10);for(var _5i=0,_5j=_5h.length;_5i<_5j;_5i++){$k[$j++]=$g(_5h,_5i);$k[$j++]=$_.pixs;$k[$j++]=$_.x;$k[$j++]=$_.y;$_.qmv();var _5o=$k[$j-3];var _5p=$k[$j-1];$p($k[$j-2],_5p,_5o-48);$j-=3;$_.y=$_.y+1}if($_.y!=$_.rows-1){$_.y=$_.y+1}else{$_.x=$_.x+1;$_.y=1;$k[$j++]=$_.pixs;$k[$j++]=$_.x;$k[$j++]=$_.y;$_.qmv();var _5z=$k[--$j];if($g($k[--$j],_5z)!=-1){$_.x=$_.x+1}}}var _63=new Map([[0,"FFFFFF"],[9,"000000"],[1,"00FFFF"],[3,"FF00FF"],[5,"FFFF00"],[6,"00FF00"]]);$_.colormap=_63;var _6C=new Map([["ren","renmatrix"],["pixs",$_.pixs],["pixx",$_.columns],["pixy",$_.rows],["height",$_.rows/72*2],["width",$_.columns/72*2],["colormap",$_.colormap],["borderleft",1],["borderright",1],["bordertop",1],["borderbottom",1],["opt",$_.options]]);$k[$j++]=_6C;if(!$_.dontdraw){bwipp_renmatrix()}$_=$__}function bwipp_jabcode(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.rows=-1;$_.columns=-1;$_.slave=false;$_.colors=16;$_.eclevel=6;$_.raw=false;$_.parse=false;$_.parsefnc=false;$_.mask=-1;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];$_.databpm=~~$round($log($_.colors)/$log(2));var _3=$_.colors;$k[$j++]="metabpm";$k[$j++]=_3;if(_3>8){$k[$j-1]=8}var _4=$k[--$j];$_[$k[--$j]]=~~$round($log(_4)/$log(2));$_.fn1=-1;var _9=new Map([["parse",$_.parse],["parsefnc",$_.parsefnc],["FNC1",$_.fn1]]);$_.fncvals=_9;$k[$j++]="msg";$k[$j++]=$_.barcode;$k[$j++]=$_.fncvals;bwipp_parseinput();var _C=$k[--$j];$_[$k[--$j]]=_C;$_.msglen=$_.msg.length;$_.addtobits=function(){var _F=$k[--$j];$P($_.bits,$_.j,_F);$_.j=_F.length+$_.j};$_.tofixedbits=function(){var _K=$Z($s(13),"0000000000000");$k[$j++]=_K;$k[$j++]=_K;$r(4,-1);var _N=$R($s(13),$k[--$j],2);var _O=$k[--$j];var _P=$k[--$j];var _Q=$k[--$j];$P(_O,$f(_Q-_N.length),_N);$k[$j++]=$G(_P,0,_Q)};var _T=$_.msglen<=15?4:17;$_.bits=$s(7+_T+$_.msglen*8+12);$_.j=0;$k[$j++]=31;$k[$j++]=5;$_.tofixedbits();$_.addtobits();$k[$j++]="00";$_.addtobits();if($_.msglen<=15){$k[$j++]=$_.msglen;$k[$j++]=4;$_.tofixedbits();$_.addtobits()}else{$k[$j++]="0000";$_.addtobits();$k[$j++]=$_.msglen-16;$k[$j++]=13;$_.tofixedbits();$_.addtobits()}for(var _b=0,_a=$_.msglen-1;_b<=_a;_b+=1){$k[$j++]=$g($_.msg,_b);$k[$j++]=8;$_.tofixedbits();$_.addtobits()}$k[$j++]=28;$k[$j++]=5;$_.tofixedbits();$_.addtobits();$k[$j++]=31;$k[$j++]=5;$_.tofixedbits();$_.addtobits();$k[$j++]="11";$_.addtobits();$_.diffside=21;$_.sameshape=false;$_.sameecc=false;$_.hasslaves=false;$_.metrics=function(){$_.mc=$k[--$j];$_.mr=$k[--$j];var _g=$_.mc;var _h=$_.mr;var _i=$_.mc;var _j=$_.mr;var _k=$_.colors;var _l=64;if(64>_k){var _=_k;_k=_l;_l=_}var _n=$_.slave?7:17;$k[$j++]=_g*_h;$k[$j++]=((~~((_i-25)/16)+2)*(~~((_j-25)/16)+2)-4)*7;$k[$j++]=_l*2;$k[$j++]=_n*4;if(!$_.slave){var _r=$eq($_.mr,$_.mc)?0:1;$_.metass=_r;var _s=$_.mr;var _t=$_.mc;if($lt(_s,_t)){var _=_t;_t=_s;_s=_}$_.metavf=$g($a([0,1,2,2,3,3,3,3]),~~((_s-21)/16));$k[$j++]="metavlen";if($_.metass==0){$k[$j++]=$a([2,2,3,4])}else{$k[$j++]=$a([4,6,8,10])}var _11=$g($k[--$j],$_.metavf);$_[$k[--$j]]=_11;$_.metaelen=$_.metavf*2+10;$k[$j++]=$f(7+$_.metavlen+$_.metaelen);if($_.hasslaves){var _17=$k[--$j];$k[$j++]=_17+4}var _1A=~~$ceil($k[--$j]*2/$_.metabpm);$_.nummetabits=_1A*$_.metabpm+6;$k[$j++]=_1A+6}else{$k[$j++]=3;if(!$_.sameshape){var _1D=$k[--$j];$k[$j++]=_1D+5}if($_.hasslaves){var _1F=$k[--$j];$k[$j++]=_1F+3}if(!$_.sameecc){var _1H=$_.mr;var _1I=$_.mc;if($lt(_1H,_1I)){var _=_1I;_1I=_1H;_1H=_}var _1L=$k[--$j];$k[$j++]=$f(_1L+$g($a([10,12,14,14,16,16,16,16]),~~((_1H-21)/16)))}var _1O=~~$ceil($k[--$j]*2/$_.metabpm);$_.nummetabits=_1O*$_.metabpm;$k[$j++]=_1O}var _1Q=$k[--$j];$_.nummetamodules=_1Q;var _1R=$k[--$j];var _1S=$k[--$j];var _1T=$k[--$j];$_.numdatamodules=$f($k[--$j]-(_1T+(_1S+(_1R+_1Q))));$_.numdatabits=$_.numdatamodules*$_.databpm};$_.coderate=$g($a([.67,.63,.57,.55,.5,.43,.34,.25,.2,.17,.14]),$_.eclevel);$_.grosslen=~~$ceil($_.bits.length/$_.coderate);$_.snapsize=function(){var _1d=~~$ceil($k[--$j])-18;$k[$j++]=_1d;if(_1d<0){$k[$j-1]=0}var _1e=$k[--$j];$k[$j++]=~~(_1e/4)*4+21};if($_.rows==-1&&$_.columns==-1){$k[$j++]="size";$k[$j++]=$sqrt($_.grosslen);$_.snapsize();var _1i=$k[--$j];$_[$k[--$j]]=_1i;for(;;){$k[$j++]=$_.size;$k[$j++]=$_.size;$_.metrics();if($_.grosslen<=$_.numdatabits){break}$_.size=$_.size+4}$_.rows=$_.size;$_.columns=$_.size}else{if($_.columns==-1&&$_.rows!=-1){$k[$j++]="columns";$k[$j++]=$_.grosslen/$_.rows;$_.snapsize();var _1v=$k[--$j];$_[$k[--$j]]=_1v;for(;;){$k[$j++]=$_.rows;$k[$j++]=$_.columns;$_.metrics();if($_.grosslen<=$_.numdatabits){break}$_.columns=$_.columns+4}}if($_.rows==-1&&$_.columns!=-1){$k[$j++]="rows";$k[$j++]=$_.grosslen/$_.columns;$_.snapsize();var _26=$k[--$j];$_[$k[--$j]]=_26;for(;;){$k[$j++]=$_.rows;$k[$j++]=$_.columns;$_.metrics();if($_.grosslen<=$_.numdatabits){break}$_.rows=$_.rows+4}}if($_.rows!=-1&&$_.columns!=-1){$k[$j++]=$_.rows;$k[$j++]=$_.columns;$_.metrics()}}$_.C=$_.numdatabits;$_.cols=$_.columns;if($_.rows>145||$_.cols>145){$k[$j++]="bwipp.jabcodeNoValidSymbol#27844";$k[$j++]="Maximum length exceeded or invalid content";bwipp_raiseerror()}$_.min=$_.C;for(var _2M=3;_2M<=8;_2M+=1){$_.i=_2M;for(var _2O=$_.i+1;_2O<=9;_2O+=1){$_.j=_2O;$_.dist=~~($_.C/$_.j)*$_.j-~~($_.C/$_.j)*$_.i-$_.bits.length;if($_.dist<$_.min&&$_.dist>=0){$_.datawc=$_.i;$_.datawr=$_.j;$_.min=$_.dist}}}$_.tmpbits=$s(~~($_.C/$_.datawr)*$_.datawr-~~($_.C/$_.datawr)*$_.datawc);$P($_.tmpbits,0,$_.bits);for(var _2o=$_.bits.length,_2n=$_.tmpbits.length-1;_2o<=_2n;_2o+=1){var _2q=$g($_.tmpbits,_2o-1);$k[$j++]=_2o;$k[$j++]=_2q;if(_2q%2==0){var _2r=$k[--$j];$k[$j++]=_2r+1}else{var _2s=$k[--$j];$k[$j++]=_2s-1}$k[$j++]=$_.tmpbits;var _2u=$k[$j-2];var _2v=$k[$j-3];$p($k[$j-1],_2v,_2u);$j-=3}$_.bits=$_.tmpbits;$_.m0=22609+1;$_.m1=62509-65536;$_.m2=19605;$_.m3=32557;$_.lcg64_temper=function(){$_.p00=$_.m0*$_.s0;$_.p01=$_.m0*$_.s1;$_.p02=$_.m0*$_.s2;$_.p03=$_.m0*$_.s3;$_.p10=$_.m1*$_.s0;$_.p11=$_.m1*$_.s1;$_.p12=$_.m1*$_.s2;$_.p13=$_.m1*$_.s3;$_.p20=$_.m2*$_.s0;$_.p21=$_.m2*$_.s1;$_.p22=$_.m2*$_.s2;$_.p23=$_.m2*$_.s3;$_.p30=$_.m3*$_.s0;$_.p31=$_.m3*$_.s1;$_.p32=$_.m3*$_.s2;$_.p33=$_.m3*$_.s3;$_.s3=$_.p33%65536+1;$_.s2=$_.p32%65536+~~($_.p33/65536)+$_.p23%65536;$_.s1=$_.p31%65536+~~($_.p32/65536)+($_.p22%65536+~~($_.p23/65536))+$_.p13%65536;$_.s0=$_.p30%65536+~~($_.p31/65536)+($_.p21%65536+~~($_.p22/65536))+($_.p12%65536+~~($_.p13/65536))+$_.p03%65536;$_.s3=$_.s3+65536;$_.s2=$_.s2+65535;$_.s1=$_.s1+65535;$_.s0=$_.s0+65535;$_.s2=~~($_.s3/65536)+$_.s2;$_.s3=$_.s3%65536;$_.s1=~~($_.s2/65536)+$_.s1;$_.s2=$_.s2%65536;$_.s0=~~($_.s1/65536)+$_.s0;$_.s1=$_.s1%65536;$_.s0=$_.s0%65536;var _40=(($_.s0-32768)*65536+$_.s1^2147483648)&4294967295;var _41=_40^_40>>>11;var _42=_41^_41<<7&-1658038656;var _43=(_42^_42<<15&-272236544)&4294967295;$k[$j++]=_43^_43>>>18};$_.createMatrixA=function(){$k[$j++]="nb_pcb";if($_.wr<4){$k[$j++]=~~($_.Pg_sub_block/2)}else{$k[$j++]=~~($_.Pg_sub_block/$_.wr)*$_.wc}var _49=$k[--$j];$_[$k[--$j]]=_49;$_.offset=~~$ceil($_.Pg_sub_block/32);$_.effwidth=$_.offset*32;$_.matrixA=$a($_.offset*$_.nb_pcb);for(var _4J=0,_4I=$_.offset*$_.nb_pcb-1;_4J<=_4I;_4J+=1){$p($_.matrixA,_4J,0)}$_.permutation=$a($_.Pg_sub_block);for(var _4P=0,_4O=$_.Pg_sub_block-1;_4P<=_4O;_4P+=1){$p($_.permutation,_4P,_4P)}for(var _4U=0,_4T=~~($_.Pg_sub_block/$_.wr)-1;_4U<=_4T;_4U+=1){$_.i=_4U;for(var _4X=0,_4W=$_.wr-1;_4X<=_4W;_4X+=1){$_.j=_4X;var _4Y=$_.matrixA;var _4Z=$_.i;var _4a=$_.effwidth;var _4b=$_.wr;var _4c=$_.j;var _4i=31-$f($_.i*($_.effwidth+$_.wr)+$_.j)%32;$p(_4Y,~~($f(_4Z*(_4a+_4b)+_4c)/32),$g(_4Y,~~($f(_4Z*(_4a+_4b)+_4c)/32))|(_4i<0?1>>>-_4i:1<<_4i))}}$_.s0=0;$_.s1=0;$_.s2=11;$_.s3=64569;for(var _4l=1,_4k=$_.wc-1;_4l<=_4k;_4l+=1){$_.i=_4l;$_.off_index=~~($_.Pg_sub_block/$_.wr)*$_.i;for(var _4r=0,_4q=$_.Pg_sub_block-1;_4r<=_4q;_4r+=1){$_.j=_4r;$_.lcg64_temper();var _4s=$k[$j-1];if(_4s<0){var _4t=$k[--$j];$k[$j++]=(_4t^2147483648)+2147483648}$_.pos=~~($k[--$j]/4294967296*($_.Pg_sub_block-$_.j));for(var _50=0,_4z=~~($_.Pg_sub_block/$_.wr)-1;_50<=_4z;_50+=1){$_.k=_50;var _51=$_.matrixA;var _52=$_.off_index;var _53=$_.k;var _54=$_.offset;var _55=$_.j;var _5D=$g($_.matrixA,~~($g($_.permutation,$_.pos)/32)+$_.k*$_.offset);var _5H=-(31-$g($_.permutation,$_.pos)%32);var _5J=31-$_.j%32;$p(_51,(_52+_53)*_54+~~(_55/32),$g(_51,(_52+_53)*_54+~~(_55/32))|(_5J<0?((_5H<0?_5D>>>-_5H:_5D<<_5H)&1)>>>-_5J:((_5H<0?_5D>>>-_5H:_5D<<_5H)&1)<<_5J))}var _5M=$_.permutation;var _5N=$_.Pg_sub_block;var _5O=$_.j;$p(_5M,_5N-1-_5O,$g($_.permutation,$_.pos));$p($_.permutation,$_.pos,$g(_5M,_5N-1-_5O))}}};$_.createMetadataMatrixA=function(){$_.nb_pcb=~~($_.Pg_sub_block/2);$_.offset=~~$ceil($_.Pg_sub_block/32);$_.matrixA=$a($_.offset*$_.nb_pcb);for(var _5b=0,_5a=$_.offset*$_.nb_pcb-1;_5b<=_5a;_5b+=1){$p($_.matrixA,_5b,0)}$_.permutation=$a($_.Pg_sub_block);for(var _5h=0,_5g=$_.Pg_sub_block-1;_5h<=_5g;_5h+=1){$p($_.permutation,_5h,_5h)}$_.s0=0;$_.s1=0;$_.s2=0;$_.s3=38545;$_.nb_once=~~(~~($_.nb_pcb/$_.wc*$_.Pg_sub_block+3)/$_.nb_pcb);for(var _5p=0,_5o=$_.nb_pcb-1;_5p<=_5o;_5p+=1){$_.i=_5p;for(var _5s=0,_5r=$_.nb_once-1;_5s<=_5r;_5s+=1){$_.j=_5s;$_.lcg64_temper();var _5t=$k[$j-1];if(_5t<0){var _5u=$k[--$j];$k[$j++]=(_5u^2147483648)+2147483648}$_.pos=~~($k[--$j]/4294967296*($_.Pg_sub_block-$_.j));var _5y=$_.matrixA;var _5z=$_.i;var _60=$_.offset;var _63=$g($_.permutation,$_.pos);var _68=31-$g($_.permutation,$_.pos)%32;$p(_5y,_5z*_60+~~(_63/32),$g(_5y,_5z*_60+~~(_63/32))|(_68<0?1>>>-_68:1<<_68));var _6B=$_.permutation;var _6C=$_.Pg_sub_block;var _6D=$_.j;$p(_6B,_6C-1-_6D,$g($_.permutation,$_.pos));$p($_.permutation,$_.pos,$g(_6B,_6C-1-_6D))}}};$_.GaussJordan=function(){$k[$j++]="nb_pcb";if($_.wr<4){$k[$j++]=~~($_.Pg_sub_block/2)}else{$k[$j++]=~~($_.Pg_sub_block/$_.wr)*$_.wc}var _6N=$k[--$j];$_[$k[--$j]]=_6N;$_.offset=~~$ceil($_.Pg_sub_block/32);var _6Q=$_.matrixA;$_.matrixH=$A($a(_6Q.length),_6Q);$k[$j++]=Infinity;for(var _6U=0,_6V=$_.Pg_sub_block;_6U<_6V;_6U++){$k[$j++]=0}$_.column_arrangement=$a();$k[$j++]=Infinity;for(var _6Y=0,_6Z=$_.Pg_sub_block;_6Y<_6Z;_6Y++){$k[$j++]=false}$_.processed_column=$a();$k[$j++]=Infinity;for(var _6c=0,_6d=$_.nb_pcb;_6c<_6d;_6c++){$k[$j++]=0}$_.zero_lines_nb=$a();$k[$j++]=Infinity;for(var _6g=0,_6h=$_.Pg_sub_block*2;_6g<_6h;_6g++){$k[$j++]=0}$_.swap_col=$a();$_.zero_lines=0;$_.loop0=0;for(var _6l=0,_6k=$_.nb_pcb-1;_6l<=_6k;_6l+=1){$_.i=_6l;$_.pivot_column=$_.Pg_sub_block+1;for(var _6p=0,_6o=$_.Pg_sub_block-1;_6p<=_6o;_6p+=1){$_.j=_6p;var _6u=$g($_.matrixH,~~(($_.offset*32*$_.i+$_.j)/32));var _6y=-(31-($_.offset*32*$_.i+$_.j)%32);if(((_6y<0?_6u>>>-_6y:_6u<<_6y)&1)==1){$_.pivot_column=$_.j;break}}if($_.pivot_column<$_.Pg_sub_block){$p($_.processed_column,$_.pivot_column,true);$p($_.column_arrangement,$_.pivot_column,$_.i);if($_.pivot_column>=$_.nb_pcb){$p($_.swap_col,$_.loop0*2,$_.pivot_column);$_.loop0=$_.loop0+1}$_.off_index=~~($_.pivot_column/32);$_.off_index1=$_.pivot_column%32;for(var _7H=0,_7G=$_.nb_pcb-1;_7H<=_7G;_7H+=1){$_.j=_7H;if($_.i!=$_.j){var _7O=$g($_.matrixH,$_.off_index+$_.j*$_.offset);var _7Q=-(31-$_.off_index1);if(((_7Q<0?_7O>>>-_7Q:_7O<<_7Q)&1)==1){for(var _7T=0,_7S=$_.offset-1;_7T<=_7S;_7T+=1){$_.k=_7T;var _7U=$_.matrixH;var _7V=$_.offset;var _7W=$_.j;var _7X=$_.k;$p(_7U,_7V*_7W+_7X,$xo($g(_7U,_7V*_7W+_7X),$g($_.matrixH,$_.offset*$_.i+$_.k)))}}}}}else{$p($_.zero_lines_nb,$_.zero_lines,$_.i);$_.zero_lines=$_.zero_lines+1}}$_.matrix_rank=$_.nb_pcb-$_.zero_lines;$_.loop2=0;for(var _7n=$_.matrix_rank,_7m=$_.nb_pcb-1;_7n<=_7m;_7n+=1){$_.i=_7n;if($g($_.column_arrangement,$_.i)>0){for(var _7t=0,_7s=$_.nb_pcb-1;_7t<=_7s;_7t+=1){$_.j=_7t;if(!$g($_.processed_column,$_.j)){$p($_.column_arrangement,$_.j,$g($_.column_arrangement,$_.i));$p($_.column_arrangement,$_.i,0);$p($_.processed_column,$_.j,true);$p($_.processed_column,$_.i,false);$p($_.swap_col,$_.loop0*2,$_.i);$p($_.swap_col,$_.loop0*2+1,$_.j);$p($_.column_arrangement,$_.i,$_.j);$_.loop0=$_.loop0+1;$_.loop2=$_.loop2+1;break}}}}$_.loop1=0;for(var _8L=0,_8K=$_.nb_pcb-1;_8L<=_8K;_8L+=1){$_.kl=_8L;if(!$g($_.processed_column,$_.kl)&&$_.loop1<$_.loop0-$_.loop2){$p($_.column_arrangement,$_.kl,$g($_.column_arrangement,$g($_.swap_col,$_.loop1*2)));$p($_.processed_column,$_.kl,true);$p($_.swap_col,$_.loop1*2+1,$_.kl);$_.loop1=$_.loop1+1}}$_.loop1=0;for(var _8h=0,_8g=$_.nb_pcb-1;_8h<=_8g;_8h+=1){$_.kl=_8h;if(!$g($_.processed_column,$_.kl)){$p($_.column_arrangement,$_.kl,$g($_.zero_lines_nb,$_.loop1));$_.loop1=$_.loop1+1}}for(var _8t=0,_8s=$_.nb_pcb-1;_8t<=_8s;_8t+=1){$_.i=_8t;for(var _8w=0,_8v=$_.offset-1;_8w<=_8v;_8w+=1){$_.j=_8w;$p($_.matrixA,$_.i*$_.offset+$_.j,$g($_.matrixH,$f($g($_.column_arrangement,$_.i)*$_.offset+$_.j)))}}$_.tmp=0;for(var _9A=0,_99=$_.loop0-1;_9A<=_99;_9A+=1){$_.i=_9A;for(var _9D=0,_9C=$_.nb_pcb-1;_9D<=_9C;_9D+=1){$_.j=_9D;var _9K=$g($_.matrixA,~~($g($_.swap_col,$_.i*2)/32)+$_.j*$_.offset);var _9O=-(31-$g($_.swap_col,$_.i*2)%32);$_.tmp=(-((_9O<0?_9K>>>-_9O:_9K<<_9O)&1)^$_.tmp)&1^$_.tmp;var _9R=$_.matrixA;var _9U=$g($_.swap_col,$_.i*2);var _9V=$_.j;var _9W=$_.offset;var _9e=$g($_.matrixA,~~($g($_.swap_col,$_.i*2+1)/32)+$_.j*$_.offset);var _9i=-(31-$g($_.swap_col,$_.i*2+1)%32);var _9t=31-$g($_.swap_col,$_.i*2)%32;$p(_9R,~~(_9U/32)+_9V*_9W,$g(_9R,~~(_9U/32)+_9V*_9W)^(-((_9i<0?_9e>>>-_9i:_9e<<_9i)&1)^$g($_.matrixA,~~($g($_.swap_col,$_.i*2)/32)+$_.j*$_.offset))&(_9t<0?1>>>-_9t:1<<_9t));var _9u=$_.matrixA;var _9x=$g($_.swap_col,$_.i*2+1);var _9y=$_.j;var _9z=$_.offset;var _AC=31-$g($_.swap_col,$_.i*2+1)%32;$p(_9u,~~(_9x/32)+_9y*_9z,$g(_9u,~~(_9x/32)+_9y*_9z)^(-($_.tmp&1)^$g($_.matrixA,~~($g($_.swap_col,$_.i*2+1)/32)+$_.j*$_.offset))&(_AC<0?1>>>-_AC:1<<_AC))}}};$_.createGeneratorMatrix=function(){$_.pn=$_.Pg_sub_block-$_.matrix_rank;$_.offset=~~$ceil($_.pn/32);$_.effwidth=$_.offset*32;$_.offset_cap=~~$ceil($_.Pg_sub_block/32);$_.G=$a($_.offset*$_.Pg_sub_block);for(var _AO=0,_AN=$_.offset*$_.Pg_sub_block-1;_AO<=_AN;_AO+=1){$p($_.G,_AO,0)}for(var _AS=0,_AR=$_.pn-1;_AS<=_AR;_AS+=1){$_.i=_AS;var _AT=$_.G;var _AU=$_.Pg_sub_block;var _AV=$_.pn;var _AW=$_.i;var _AX=$_.offset;var _AY=$_.i;var _Ab=31-$_.i%32;$p(_AT,(_AU-_AV+_AW)*_AX+~~(_AY/32),$g(_AT,(_AU-_AV+_AW)*_AX+~~(_AY/32))|(_Ab<0?1>>>-_Ab:1<<_Ab))}$_.matrix_index=$_.Pg_sub_block-$_.pn;$_.loop0=0;for(var _Ai=0,_Ah=($_.Pg_sub_block-$_.pn)*$_.effwidth-1;_Ai<=_Ah;_Ai+=1){$_.i=_Ai;if($_.matrix_index>=$_.Pg_sub_block){$_.loop0=$_.loop0+1;$_.matrix_index=$_.Pg_sub_block-$_.pn}if($_.i%$_.effwidth<$_.pn){var _Ar=$_.G;var _As=$_.i;var _Ay=$g($_.matrixA,~~($_.matrix_index/32)+$_.offset_cap*$_.loop0);var _B0=-(31-$_.matrix_index%32);var _B5=31-$_.i%32;$p(_Ar,~~(_As/32),$g(_Ar,~~(_As/32))^(-((_B0<0?_Ay>>>-_B0:_Ay<<_B0)&1)^$g($_.G,~~($_.i/32)))&(_B5<0?1>>>-_B5:1<<_B5));$_.matrix_index=$_.matrix_index+1}}};$_.ldpc=function(){$_.wr=$k[--$j];$_.wc=$k[--$j];$k[$j++]=Infinity;var _B9=$k[--$j];var _BA=$k[--$j];$k[$j++]=_B9;$F(_BA,function(){var _BB=$k[--$j];$k[$j++]=_BB-48});$_.data=$a();$_.Pn=$_.data.length;if($_.wr!=-1){$_.Pg=~~($ceil($ceil($_.Pn*$_.wr/$f($_.wr-$_.wc))/$_.wr)*$_.wr);$_.nb_sub_blocks=~~($_.Pg/2700)+1;$_.Pg_sub_block=~~(~~($_.Pg/$_.nb_sub_blocks)/$_.wr)*$_.wr;$_.Pn_sub_block=~~($_.Pg_sub_block*$f($_.wr-$_.wc)/$_.wr);$_.nb_sub_blocks=~~($_.Pg/$_.Pg_sub_block);$k[$j++]="encoding_iterations";$k[$j++]=~~($_.Pg/$_.Pg_sub_block);if($_.Pn_sub_block*$_.nb_sub_blocks<$_.Pn){var _Bb=$k[--$j];$k[$j++]=_Bb-1}var _Bc=$k[--$j];$_[$k[--$j]]=_Bc;$_.createMatrixA()}else{$_.Pg=$_.Pn*2;$_.nb_sub_blocks=1;$_.Pg_sub_block=$_.Pg;$_.Pn_sub_block=$_.Pn;$_.encoding_iterations=1;$_.createMetadataMatrixA()}$_.GaussJordan();$_.createGeneratorMatrix();$_.ecc_encoded_data=$a($_.Pg);$_.offset=~~$ceil(($_.Pg_sub_block-$_.matrix_rank)/32);for(var _Bn=0,_Bm=$_.encoding_iterations-1;_Bn<=_Bm;_Bn+=1){$_.iter=_Bn;for(var _Bq=0,_Bp=$_.Pg_sub_block-1;_Bq<=_Bp;_Bq+=1){$_.i=_Bq;$_.temp=0;$_.loop0=0;$_.offset_index=$_.offset*$_.i;for(var _By=$_.iter*$_.Pn_sub_block,_Bx=($_.iter+1)*$_.Pn_sub_block-1;_By<=_Bx;_By+=1){var _C4=$g($_.G,$_.offset_index+~~($_.loop0/32));var _C6=-(31-$_.loop0%32);$_.temp=$g($_.data,_By)&((_C6<0?_C4>>>-_C6:_C4<<_C6)&1)^$_.temp;$_.loop0=$_.loop0+1}$p($_.ecc_encoded_data,$_.i+$_.iter*$_.Pg_sub_block,$_.temp)}}if($_.encoding_iterations!=$_.nb_sub_blocks){$_.start=$_.encoding_iterations*$_.Pn_sub_block;$_.last_index=$_.encoding_iterations*$_.Pg_sub_block;$_.Pg_sub_block=$_.Pg-$_.encoding_iterations*$_.Pg_sub_block;$_.Pn_sub_block=~~($_.Pg_sub_block*$f($_.wr-$_.wc)/$_.wr);$_.createMatrixA();$_.GaussJordan();$_.createGeneratorMatrix();$_.offset=~~$ceil(($_.Pg_sub_block-$_.matrix_rank)/32);for(var _CV=0,_CU=$_.Pg_sub_block-1;_CV<=_CU;_CV+=1){$_.i=_CV;$_.temp=0;$_.loop0=0;$_.offset_index=$_.offset*$_.i;for(var _Cb=$_.start,_Ca=$_.Pn-1;_Cb<=_Ca;_Cb+=1){var _Ch=$g($_.G,$_.offset_index+~~($_.loop0/32));var _Cj=-(31-$_.loop0%32);$_.temp=$g($_.data,_Cb)&((_Cj<0?_Ch>>>-_Cj:_Ch<<_Cj)&1)^$_.temp;$_.loop0=$_.loop0+1}$p($_.ecc_encoded_data,$_.i+$_.last_index,$_.temp)}}$_.out=$s($_.Pg);for(var _Cu=0,_Ct=$_.Pg-1;_Cu<=_Ct;_Cu+=1){$p($_.out,_Cu,$g($_.ecc_encoded_data,_Cu)+48)}$k[$j++]=$_.out};$k[$j++]="bits";$k[$j++]=$_.bits;$k[$j++]=$_.datawc;$k[$j++]=$_.datawr;$_.ldpc();var _D2=$k[--$j];$_[$k[--$j]]=_D2;$_.s0=0;$_.s1=0;$_.s2=3;$_.s3=30151;for(var _D5=$_.bits.length-1;_D5>=1;_D5-=1){$_.l=_D5;$_.lcg64_temper();var _D6=$k[$j-1];if(_D6<0){var _D7=$k[--$j];$k[$j++]=(_D7^2147483648)+2147483648}$_.r=~~($k[--$j]/4294967296*($_.l+1));$p($_.bits,$_.l,$g($_.bits,$_.r));$p($_.bits,$_.r,$g($_.bits,$_.l))}$_.tmpbits=$s($_.C);$P($_.tmpbits,0,$_.bits);$_.j=$_.bits.length;for(var _DR=0,_DS=~~(($f($_.C-$_.j)+1)/2);_DR<_DS;_DR++){$p($_.tmpbits,$_.j,48);if($_.j+1<$_.C){$p($_.tmpbits,$_.j+1,49)}$_.j=$_.j+2}$_.bits=$_.tmpbits;if($_.colors==4){$_.bi=0;$_.gi=1;$_.mi=2;$_.yi=3;$_.ki=4;$_.wi=5;$k[$j++]=Infinity;$k[$j++]=$_.bi;$k[$j++]="0000FF";$k[$j++]=$_.gi;$k[$j++]="00FF00";$k[$j++]=$_.mi;$k[$j++]="FF00FF";$k[$j++]=$_.yi;$k[$j++]="FFFF00";$k[$j++]=$_.ki;$k[$j++]="000000";$k[$j++]=$_.wi;$k[$j++]="FFFFFF";$_.palette=$d();$_.metacolorindex=$a([$_.bi,$_.gi,$_.mi,$_.yi]);$_.palettelayout=$a([$_.bi,$_.gi,$_.mi,$_.yi])}else{var _Dz=new Map([[8,$a([2,2,2])],[16,$a([4,2,2])],[32,$a([4,4,2])],[64,$a([4,4,4])],[128,$a([8,4,4])],[256,$a([8,8,4])]]);$_.rgbres=$g(_Dz,$_.colors);$k[$j++]="rvals";$k[$j++]=$g($_.rgbres,0);$k[$j++]=Infinity;var _E4=$k[--$j];var _E6=$k[--$j]-1;$k[$j++]=_E4;$k[$j++]=_E6;for(var _E8=0,_E7=_E6;_E8<=_E7;_E8+=1){var _E9=$k[--$j];$k[$j++]=~~$round(_E8*(255/_E9));$k[$j++]=_E9}$j--;var _EA=$a();$_[$k[--$j]]=_EA;$k[$j++]="gvals";$k[$j++]=$g($_.rgbres,1);$k[$j++]=Infinity;var _EE=$k[--$j];var _EG=$k[--$j]-1;$k[$j++]=_EE;$k[$j++]=_EG;for(var _EI=0,_EH=_EG;_EI<=_EH;_EI+=1){var _EJ=$k[--$j];$k[$j++]=~~$round(_EI*(255/_EJ));$k[$j++]=_EJ}$j--;var _EK=$a();$_[$k[--$j]]=_EK;$k[$j++]="bvals";$k[$j++]=$g($_.rgbres,2);$k[$j++]=Infinity;var _EO=$k[--$j];var _EQ=$k[--$j]-1;$k[$j++]=_EO;$k[$j++]=_EQ;for(var _ES=0,_ER=_EQ;_ES<=_ER;_ES+=1){var _ET=$k[--$j];$k[$j++]=~~$round(_ES*(255/_ET));$k[$j++]=_ET}$j--;var _EU=$a();$_[$k[--$j]]=_EU;var _EW=$_.colors;$_.palette=new Map;var _EX=$_.colors;var _EY=64;if(64>_EX){var _=_EX;_EX=_EY;_EY=_}$_.palettelayout=$a(_EY);$_.i=0;$_.j=8;$F($_.rvals,function(){$_.r=$k[--$j];$F($_.gvals,function(){$_.g=$k[--$j];$F($_.bvals,function(){$_.b=$k[--$j];var _Ek=$Z($s(6),"000000");var _Em=$R($s(6),$_.r<<16|$_.g<<8|$_.b,16);$P(_Ek,6-_Em.length,_Em);$k[$j++]=_Ek;$k[$j++]=false;if($eq(_Ek,"000000")){$_.ki=$_.i;$k[$j-1]=true}var _Ep=$k[$j-2];if($eq(_Ep,"0000FF")){$_.bi=$_.i;$k[$j-1]=true}var _Es=$k[$j-2];if($eq(_Es,"00FF00")){$_.gi=$_.i;$k[$j-1]=true}var _Ev=$k[$j-2];if($eq(_Ev,"00FFFF")){$_.ci=$_.i;$k[$j-1]=true}var _Ey=$k[$j-2];if($eq(_Ey,"FF0000")){$_.ri=$_.i;$k[$j-1]=true}var _F1=$k[$j-2];if($eq(_F1,"FF00FF")){$_.mi=$_.i;$k[$j-1]=true}var _F4=$k[$j-2];if($eq(_F4,"FFFF00")){$_.yi=$_.i;$k[$j-1]=true}var _F7=$k[$j-2];if($eq(_F7,"FFFFFF")){$_.wi=$_.i;$k[$j-1]=true}if(!$k[--$j]){if($_.colors<=64||($_.colors==128&&($_.r==0||$_.r==73||$_.r==182||$_.r==255)||$_.colors==256&&($_.r==0||$_.r==73||$_.r==182||$_.r==255)&&($_.g==0||$_.g==73||$_.g==182||$_.g==255))){$p($_.palettelayout,$_.j,$_.i);$_.j=$_.j+1}}$p($_.palette,$_.i,$k[--$j]);$_.i=$_.i+1})})});$P($_.palettelayout,0,$a([$_.ki,$_.bi,$_.gi,$_.ci,$_.ri,$_.mi,$_.yi,$_.wi]));$_.metacolorindex=$a([$_.ki,$_.bi,$_.gi,$_.ci,$_.ri,$_.mi,$_.yi,$_.wi])}$k[$j++]=Infinity;for(var _Fs=0,_Ft=$_.rows*$_.cols;_Fs<_Ft;_Fs++){$k[$j++]=-1}$_.pixs=$a();$_.jmv=function(){var _Fw=$k[--$j];var _Fx=$k[--$j];$k[$j++]=$f(_Fx+_Fw*$_.cols)};if(!$_.slave){$_.fpat=$a([$a([1,1,1,0,0]),$a([1,2,2,0,0]),$a([1,2,1,2,1]),$a([0,0,2,2,1]),$a([0,0,1,1,1])]);$_.fmap=$a([$a([-1,$_.bi,$_.yi]),$a([-1,$_.yi,$_.bi]),$a([-1,$_.gi,$_.mi]),$a([-1,$_.mi,$_.gi])])}else{$_.fpat=$a([$a([0,0,0,0,0]),$a([0,2,2,0,0]),$a([0,2,1,2,0]),$a([0,0,2,2,0]),$a([0,0,0,0,0])]);$_.fmap=$a([$a([-1,$_.ki,$_.wi]),$a([-1,$_.ki,$_.wi]),$a([-1,$_.ki,$_.wi]),$a([-1,$_.ki,$_.wi])])}for(var _Gb=0;_Gb<=4;_Gb+=1){$_.y=_Gb;for(var _Gc=0;_Gc<=4;_Gc+=1){$_.x=_Gc;$_.fpb=$g($g($_.fpat,$_.y),$_.x);$k[$j++]=$_.pixs;$k[$j++]=$_.x+1;$k[$j++]=$_.y+1;$_.jmv();var _Gp=$k[--$j];$p($k[--$j],_Gp,$g($g($_.fmap,0),$_.fpb));$k[$j++]=$_.pixs;$k[$j++]=$_.x+1;$k[$j++]=$f($_.rows-$_.y)-2;$_.jmv();var _Gz=$k[--$j];$p($k[--$j],_Gz,$g($g($_.fmap,1),$_.fpb));$k[$j++]=$_.pixs;$k[$j++]=$f($_.x+$_.cols)-6;$k[$j++]=$_.y+1;$_.jmv();var _H9=$k[--$j];$p($k[--$j],_H9,$g($g($_.fmap,2),$_.fpb));$k[$j++]=$_.pixs;$k[$j++]=$f($_.x+$_.cols)-6;$k[$j++]=$f($_.rows-$_.y)-2;$_.jmv();var _HK=$k[--$j];$p($k[--$j],_HK,$g($g($_.fmap,3),$_.fpb))}}$_.algnpat0=$a([$a([$_.ki,$_.ki,-1]),$a([$_.ki,$_.wi,$_.ki]),$a([-1,$_.ki,$_.ki])]);$_.algnpat1=$a([$a([-1,$_.ki,$_.ki]),$a([$_.ki,$_.wi,$_.ki]),$a([$_.ki,$_.ki,-1])]);$_.num=~~$round($_.cols/16)-1;$_.algnrpos=$a([3,17]);if($_.num>0){$k[$j++]=Infinity;for(var _Hn=0,_Hm=$_.num;_Hn<=_Hm;_Hn+=1){$k[$j++]=~~(_Hn*(($_.cols-7)/$_.num))+3}$_.algnrpos=$a()}$_.num=~~$round($_.rows/16)-1;$_.algncpos=$a([3,17]);if($_.num>0){$k[$j++]=Infinity;for(var _Hw=0,_Hv=$_.num;_Hw<=_Hv;_Hw+=1){$k[$j++]=~~(_Hw*(($_.rows-7)/$_.num))+3}$_.algncpos=$a()}$_.putalgnpat=function(){$_.pp=$k[--$j];$_.py=$k[--$j];$_.px=$k[--$j];for(var _I3=0;_I3<=2;_I3+=1){$_.pb=_I3;for(var _I4=0;_I4<=2;_I4+=1){$_.pa=_I4;$k[$j++]=$_.pixs;$k[$j++]=$f($_.px+$_.pa);$k[$j++]=$f($_.py+$_.pb);$_.jmv();var _IF=$k[--$j];$p($k[--$j],_IF,$g($g($_.pp,$_.pb),$_.pa))}}};for(var _IJ=0,_II=$_.algncpos.length-1;_IJ<=_II;_IJ+=1){$_.j=_IJ;$_.y=$g($_.algncpos,$_.j);for(var _IP=0,_IO=$_.algnrpos.length-1;_IP<=_IO;_IP+=1){$_.i=_IP;$_.x=$g($_.algnrpos,$_.i);$k[$j++]=$_.pixs;$k[$j++]=$_.x;$k[$j++]=$_.y;$_.jmv();var _IW=$k[--$j];if($g($k[--$j],_IW)==-1){$k[$j++]=$_.x-1;$k[$j++]=$_.y-1;if(($_.i+$_.j)%2==0){$k[$j++]=$_.algnpat0}else{$k[$j++]=$_.algnpat1}$_.putalgnpat()}}}if(!$_.slave){var _JO=$a([$a([6,1]),$a([6,2]),$a([6,3]),$a([6,4]),$a([6,5]),$a([6,6]),$a([5,6]),$a([4,6]),$a([3,6]),$a([2,6]),$a([1,6]),$a([7,1]),$a([7,2]),$a([7,3]),$a([7,4]),$a([7,5]),$a([7,6]),$a([7,7]),$a([6,7]),$a([5,7]),$a([4,7]),$a([3,7]),$a([2,7]),$a([1,7]),$a([8,1]),$a([8,2]),$a([8,3]),$a([8,4]),$a([8,5]),$a([8,6]),$a([8,7]),$a([8,8]),$a([7,8]),$a([6,8]),$a([5,8]),$a([4,8]),$a([3,8]),$a([2,8]),$a([1,8]),$a([9,1]),$a([9,2]),$a([9,3]),$a([9,4]),$a([9,5])]);for(var _JP=0,_JQ=_JO.length;_JP<_JQ;_JP++){$q($g(_JO,_JP));$_.y=$k[--$j];$_.x=$k[--$j];$k[$j++]=$a([$_.x,$_.y]);$k[$j++]=$a([-$_.x,$_.y]);$k[$j++]=$a([-$_.x,-$_.y]);$k[$j++]=$a([$_.x,-$_.y])}$as($a(176));$_.metadatamap=$k[--$j];$_.palettemap1=$a([$a([4,1]),$a([4,2]),$a([5,1]),$a([5,2]),$a([2,4]),$a([2,5]),$a([1,4]),$a([1,5]),$a([-2,1]),$a([-2,2]),$a([-1,1]),$a([-1,2]),$a([-4,4]),$a([-4,5]),$a([-5,4]),$a([-5,5])]);$_.palettemap2=$a([$a([-4,-5]),$a([-4,-4]),$a([-5,-5]),$a([-5,-4]),$a([-2,-2]),$a([-2,-1]),$a([-1,-2]),$a([-1,-1]),$a([2,-5]),$a([2,-4]),$a([1,-5]),$a([1,-4]),$a([4,-2]),$a([4,-1]),$a([5,-2]),$a([5,-1])])}else{$k[$j++]=Infinity;for(var _KG=1;_KG<=19;_KG+=1){$_.i=_KG;$k[$j++]=$a([0,$_.i]);$k[$j++]=$a([1,$_.i])}for(var _KL=5;_KL<=12;_KL+=1){$_.i=_KL;$k[$j++]=$a([2,$_.i]);$k[$j++]=$a([3,$_.i])}$_.metadatamap=$a();$k[$j++]=Infinity;for(var _KR=5;_KR<=12;_KR+=1){var _KS=Infinity;var _KT=_KR;$k[$j++]=_KS;$k[$j++]=4;$k[$j++]=_KT;var _KU=$a();$k[$j++]=_KU}for(var _KV=12;_KV>=5;_KV-=1){var _KW=Infinity;var _KX=_KV;$k[$j++]=_KW;$k[$j++]=5;$k[$j++]=_KX;var _KY=$a();$k[$j++]=_KY}for(var _KZ=5;_KZ<=12;_KZ+=1){var _Ka=Infinity;var _Kb=_KZ;$k[$j++]=_Ka;$k[$j++]=6;$k[$j++]=_Kb;var _Kc=$a();$k[$j++]=_Kc}for(var _Kd=12;_Kd>=5;_Kd-=1){var _Ke=Infinity;var _Kf=_Kd;$k[$j++]=_Ke;$k[$j++]=7;$k[$j++]=_Kf;var _Kg=$a();$k[$j++]=_Kg}$_.palettemap1=$a();$k[$j++]=Infinity;var _Ki=$_.palettemap1;for(var _Kj=0,_Kk=_Ki.length;_Kj<_Kk;_Kj++){var _Km=Infinity;var _Kn=$g(_Ki,_Kj);$k[$j++]=_Km;$q(_Kn);var _Ko=$k[--$j];var _Kp=$k[--$j];$k[$j++]=-_Kp;$k[$j++]=-_Ko;var _Kq=$a();$k[$j++]=_Kq}$_.palettemap2=$a()}var _Ks=$_.metadatamap;for(var _Kt=0,_Ku=_Ks.length;_Kt<_Ku;_Kt++){var _Kv=$g(_Ks,_Kt);var _Kw=$g(_Kv,0);$k[$j++]=_Kv;$k[$j++]=_Kw;if(_Kw<0){var _Ky=$k[--$j];var _Kz=$k[$j-1];$p(_Kz,0,$f(_Ky+$_.cols)-1)}else{$j--}var _L0=$k[$j-1];var _L1=$g(_L0,1);$k[$j++]=_L1;if(_L1<0){var _L3=$k[--$j];var _L4=$k[$j-1];$p(_L4,1,$f(_L3+$_.rows)-1)}else{$j--}$j--}var _L5=$_.palettemap1;for(var _L6=0,_L7=_L5.length;_L6<_L7;_L6++){var _L8=$g(_L5,_L6);var _L9=$g(_L8,0);$k[$j++]=_L8;$k[$j++]=_L9;if(_L9<0){var _LB=$k[--$j];var _LC=$k[$j-1];$p(_LC,0,$f(_LB+$_.cols)-1)}else{$j--}var _LD=$k[$j-1];var _LE=$g(_LD,1);$k[$j++]=_LE;if(_LE<0){var _LG=$k[--$j];var _LH=$k[$j-1];$p(_LH,1,$f(_LG+$_.rows)-1)}else{$j--}$j--}var _LI=$_.palettemap2;for(var _LJ=0,_LK=_LI.length;_LJ<_LK;_LJ++){var _LL=$g(_LI,_LJ);var _LM=$g(_LL,0);$k[$j++]=_LL;$k[$j++]=_LM;if(_LM<0){var _LO=$k[--$j];var _LP=$k[$j-1];$p(_LP,0,$f(_LO+$_.cols)-1)}else{$j--}var _LQ=$k[$j-1];var _LR=$g(_LQ,1);$k[$j++]=_LR;if(_LR<0){var _LT=$k[--$j];var _LU=$k[$j-1];$p(_LU,1,$f(_LT+$_.rows)-1)}else{$j--}$j--}for(var _LX=0,_LW=$_.nummetamodules-1;_LX<=_LW;_LX+=1){$k[$j++]=$_.pixs;$q($g($_.metadatamap,_LX));$_.jmv();var _Lb=$k[--$j];$p($k[--$j],_Lb,0)}if(!$_.slave){var _Le=$_.colors;var _Lf=16;if(16>_Le){var _=_Le;_Le=_Lf;_Lf=_}for(var _Lh=0,_Lg=_Lf-1;_Lh<=_Lg;_Lh+=1){$_.i=_Lh;var _Lk=$g($_.palettelayout,$_.i);$k[$j++]=_Lk;$k[$j++]=$_.pixs;$k[$j++]=_Lk;$q($g($_.palettemap1,$_.i));$_.jmv();var _Lp=$k[--$j];var _Lq=$k[--$j];$p($k[--$j],_Lp,_Lq);var _Lt=$k[--$j];$k[$j++]=$_.pixs;$k[$j++]=_Lt;$q($g($_.palettemap2,$_.i));$_.jmv();var _Lx=$k[--$j];var _Ly=$k[--$j];$p($k[--$j],_Lx,_Ly)}$_.i=16}else{$_.i=0}$_.j=$_.nummetamodules;for(var _M4=$_.i,_M3=$_.palettelayout.length-1;_M4<=_M3;_M4+=2){$_.i=_M4;var _M7=$g($_.palettelayout,$_.i);$k[$j++]=_M7;$k[$j++]=$_.pixs;$k[$j++]=_M7;$q($g($_.metadatamap,$_.j));$_.jmv();var _MC=$k[--$j];var _MD=$k[--$j];$p($k[--$j],_MC,_MD);var _MG=$k[--$j];$k[$j++]=$_.pixs;$k[$j++]=_MG;$q($g($_.metadatamap,$_.j+2));$_.jmv();var _MK=$k[--$j];var _ML=$k[--$j];$p($k[--$j],_MK,_ML);var _MP=$g($_.palettelayout,$_.i+1);$k[$j++]=_MP;$k[$j++]=$_.pixs;$k[$j++]=_MP;$q($g($_.metadatamap,$_.j+1));$_.jmv();var _MU=$k[--$j];var _MV=$k[--$j];$p($k[--$j],_MU,_MV);var _MY=$k[--$j];$k[$j++]=$_.pixs;$k[$j++]=_MY;$q($g($_.metadatamap,$_.j+3));$_.jmv();var _Mc=$k[--$j];var _Md=$k[--$j];$p($k[--$j],_Mc,_Md);$_.j=$_.j+4}var _N5=$a([function(){var _Mg=$k[--$j];var _Mh=$k[--$j];$k[$j++]=$f(_Mh+_Mg)%$_.colors},function(){$j--;var _Mk=$k[--$j];$k[$j++]=_Mk%$_.colors},function(){var _Ml=$k[--$j];$k[$j-1]=_Ml;var _Mo=$k[--$j];$k[$j++]=_Mo%$_.colors},function(){var _Mp=$k[--$j];var _Mq=$k[--$j];$k[$j++]=(~~(_Mp/3)+~~(_Mq/2))%$_.colors},function(){var _Ms=$k[--$j];var _Mt=$k[--$j];$k[$j++]=(~~(_Ms/2)+~~(_Mt/3))%$_.colors},function(){var _Mv=$k[--$j];var _Mx=$f($k[--$j]+_Mv);$k[$j++]=(~~(_Mx/2)+~~(_Mx/3))%$_.colors},function(){var _Mz=$k[--$j];var _N0=$k[--$j];$k[$j++]=$f(_Mz*(_N0*_N0)%7+(_Mz+_N0*_N0)*2%19)%$_.colors},function(){var _N2=$k[--$j];var _N3=$k[--$j];$k[$j++]=$f(_N3*(_N2*_N2)%5+(_N2*_N2+_N3*2)%13)%$_.colors}]);$_.maskfuncs=_N5;if($_.mask!=-1){$_.maskfuncs=$a([$g($_.maskfuncs,$_.mask)]);$_.bestmaskval=$_.mask}$_.masks=$a($_.maskfuncs.length);for(var _NG=0,_NF=$_.masks.length-1;_NG<=_NF;_NG+=1){$_.m=_NG;$_.mask=$a($_.rows*$_.cols);for(var _NM=0,_NL=$_.rows-1;_NM<=_NL;_NM+=1){$_.j=_NM;for(var _NP=0,_NO=$_.cols-1;_NP<=_NO;_NP+=1){$_.i=_NP;$k[$j++]=$_.pixs;$k[$j++]=$_.i;$k[$j++]=$_.j;$_.jmv();var _NT=$k[--$j];if($g($k[--$j],_NT)==-1){$k[$j++]=$_.i;$k[$j++]=$_.j;if($g($_.maskfuncs,$_.m)()===true){break}}else{$k[$j++]=0}$k[$j++]=$_.mask;$k[$j++]=$_.i;$k[$j++]=$_.j;$_.jmv();var _Ne=$k[$j-3];var _Nf=$k[$j-1];$p($k[$j-2],_Nf,_Ne);$j-=3}}$p($_.masks,$_.m,$_.mask)}$_.posx=0;$_.posy=0;$_.i=0;for(;;){if($_.posx==$_.cols){break}$k[$j++]=$_.pixs;$k[$j++]=$_.posx;$k[$j++]=$_.posy;$_.jmv();var _Np=$k[--$j];if($g($k[--$j],_Np)==-1){var _Nv=$G($_.bits,$_.i,$_.databpm);$k[$j++]=0;for(var _Nw=0,_Nx=_Nv.length;_Nw<_Nx;_Nw++){var _Nz=$k[--$j];$k[$j++]=$f(_Nz+($g(_Nv,_Nw)-48))*2}var _O0=$k[--$j];$k[$j++]=~~(_O0/2);$k[$j++]=$_.pixs;$k[$j++]=$_.posx;$k[$j++]=$_.posy;$_.jmv();var _O4=$k[$j-3];var _O5=$k[$j-1];$p($k[$j-2],_O5,_O4);$j-=3;$_.i=$_.i+$_.databpm}$_.posy=$_.posy+1;if($_.posy==$_.rows){$_.posy=0;$_.posx=$_.posx+1}}$_.evalrle=function(){$_.scrle=$k[--$j];$_.scr1=0;$_.scr3=0;for(var _OG=0,_OF=$_.scrle.length-2;_OG<=_OF;_OG+=2){$_.j=_OG;if($g($_.scrle,$_.j+1)!=-1){var _OM=$g($_.scrle,$_.j);$k[$j++]=_OM;if(_OM>=5){$_.scr1=$f($k[--$j]-2+$_.scr1)}else{$j--}if($_.j>=4&&$_.j<=$_.scrle.length-5){var _OU=$G($_.scrle,$_.j-4,10);$k[$j++]=_OU;for(var _OV=0,_OW=_OU.length;_OV<_OW;_OV++){$k[$j++]=$g(_OU,_OV)==1}$j--;for(var _OY=0;_OY<4;_OY++){var _OZ=$k[--$j];$k[$j-1]=_OZ;var _Ob=$k[--$j];var _Oc=$k[--$j];$k[$j++]=$an(_Oc,_Ob)}if($k[--$j]){$k[$j++]=Infinity;var _Oe=$k[--$j];var _Of=$k[--$j];$k[$j++]=_Oe;$q(_Of);var _Og=$k[$j-1];var _Oi=$k[$j-3];var _Ok=$k[$j-5];var _Om=$k[$j-7];var _Oo=$k[$j-9];if($eq(_Oo,_Ok)&&$eq(_Oo,_Og)&&$eq(_Om,_Oi)){var _Op=$k[--$j];var _Oq=$k[--$j];var _Or=$k[--$j];$_.c4=_Or;$_.c5=_Op;$k[$j++]=_Or;$k[$j++]=_Oq;if($_.c4==$_.bi&&$_.c5==$_.yi||($_.c4==$_.yi&&$_.c5==$_.bi||($_.c4==$_.gi&&$_.c5==$_.mi||$_.c4==$_.mi&&$_.c5==$_.gi))){$_.scr3=$_.scr3+100}}$l()}else{$j--}}}}$k[$j++]=$_.scr1;$k[$j++]=$_.scr3};$_.evalmask=function(){$_.sym=$k[--$j];$_.n1=0;$_.n2=0;$_.n3=0;var _PC=$_.rows;var _PD=$_.cols;if(_PC<_PD){var _=_PD;_PD=_PC;_PC=_}$_.rle=$a(_PC*2+2);$_.lastpairs=$a($_.cols);$_.thispairs=$a($_.cols);for(var _PL=0,_PK=$_.cols-1;_PL<=_PK;_PL+=1){$_.i=_PL;$k[$j++]=Infinity;$k[$j++]=0;$k[$j++]=-1;for(var _PR=$_.i,_PS=$_.cols,_PQ=$_.rows*$_.cols-1;_PS<0?_PR>=_PQ:_PR<=_PQ;_PR+=_PS){var _PU=$g($_.sym,_PR);var _PV=$k[$j-1];$k[$j++]=_PU;if($eq(_PV,_PU)){$j--;var _PW=$k[--$j];var _PX=$k[--$j];$k[$j++]=_PX+1;$k[$j++]=_PW}else{var _PY=$k[--$j];$k[$j++]=1;$k[$j++]=_PY}}var _Pa=$m()+2;$as($G($_.rle,0,_Pa-2));$_.evalrle();$_.n3=$f($k[--$j]+$_.n3);$_.n1=$f($k[--$j]+$_.n1);$j--}for(var _Pi=0,_Ph=$_.rows-1;_Pi<=_Ph;_Pi+=1){$_.i=_Pi;$_.symrow=$G($_.sym,$_.i*$_.cols,$_.cols);$k[$j++]=Infinity;var _Po=$_.symrow;$k[$j++]=0;$k[$j++]=-1;for(var _Pp=0,_Pq=_Po.length;_Pp<_Pq;_Pp++){var _Pr=$g(_Po,_Pp);var _Ps=$k[$j-1];$k[$j++]=_Pr;if($eq(_Ps,_Pr)){$j--;var _Pt=$k[--$j];var _Pu=$k[--$j];$k[$j++]=_Pu+1;$k[$j++]=_Pt}else{var _Pv=$k[--$j];$k[$j++]=1;$k[$j++]=_Pv}}var _Px=$m()+2;$as($G($_.rle,0,_Px-2));$_.evalrle();$_.n3=$f($k[--$j]+$_.n3);$_.n1=$f($k[--$j]+$_.n1);$j--;var _Q3=$_.thispairs;$_.thispairs=$_.lastpairs;$_.lastpairs=_Q3;var _Q5=$_.symrow;$k[$j++]=-1;for(var _Q6=0,_Q7=_Q5.length;_Q6<_Q7;_Q6++){var _Q8=$g(_Q5,_Q6);var _Q9=$k[--$j];$k[$j++]=_Q8;$k[$j++]=_Q9;if($ne(_Q8,_Q9)){$j--;var _QA=$k[--$j];$k[$j++]=-1;$k[$j++]=_QA}}$j--;$as($_.thispairs);$j--;if($_.i>0){$k[$j++]=Infinity;$q($_.lastpairs);$q($_.thispairs);$k[$j++]=$_.n2;for(var _QH=0,_QI=$_.cols;_QH<_QI;_QH++){var _QJ=$k[--$j];var _QK=$k[--$j];$k[$j++]=_QJ;$k[$j++]=_QK;if(_QK!=-1){var _QM=$k[$j-1-($_.cols+1)];if($eq($k[--$j],_QM)){var _QO=$k[--$j];$k[$j++]=_QO+3}}else{$j--}}$_.n2=$k[--$j];$l()}}$k[$j++]=$f($_.n1+$_.n2+$_.n3)};$_.bestscore=999999999;for(var _QV=0,_QU=$_.masks.length-1;_QV<=_QU;_QV+=1){$_.m=_QV;$_.masksym=$a($_.rows*$_.cols);for(var _Qc=0,_Qb=$_.rows*$_.cols-1;_Qc<=_Qb;_Qc+=1){$_.i=_Qc;$p($_.masksym,$_.i,$xo($g($_.pixs,$_.i),$g($g($_.masks,$_.m),$_.i)))}if($_.masks.length!=1){$k[$j++]=$_.masksym;$_.evalmask();$_.score=$k[--$j];if($_.score<$_.bestscore){$_.bestsym=$_.masksym;$_.bestmaskval=$_.m;$_.bestscore=$_.score}}else{$_.bestsym=$_.masksym}}$_.pixs=$_.bestsym;$_.metamask=$_.bestmaskval;$_.addtometapart=function(){var _Qy=$k[--$j];$P($_.metapart,$_.p,_Qy);$_.p=_Qy.length+$_.p};$_.addtometabits=function(){var _R2=$k[--$j];$P($_.metabits,$_.q,_R2);$_.q=_R2.length+$_.q};$_.metapart=$s(40);$_.metabits=$s($_.nummetabits);$_.p=0;$_.q=0;if(!$_.slave){$k[$j++]=~~$round($log($_.colors)/$log(2))-1;$k[$j++]=3;$_.tofixedbits();$_.addtometapart();$k[$j++]=$G($_.metapart,0,$_.p);$k[$j++]=2;$k[$j++]=-1;$_.ldpc();$_.addtometabits();$_.p=0;$k[$j++]=$_.metass;$k[$j++]=1;$_.tofixedbits();$_.addtometapart();$k[$j++]=$_.metavf;$k[$j++]=2;$_.tofixedbits();$_.addtometapart();$k[$j++]=$_.metamask;$k[$j++]=3;$_.tofixedbits();$_.addtometapart();if($_.hasslaves){$k[$j++]="1"}else{$k[$j++]="0"}$_.addtometapart();$k[$j++]=$G($_.metapart,0,$_.p);$k[$j++]=2;$k[$j++]=-1;$_.ldpc();$_.addtometabits();$_.p=0;if($_.metass==0){$k[$j++]=$f(~~(($_.cols-17)/4)-$g($a([0,4,8,16]),$_.metavf))-1;$k[$j++]=$_.metavlen;$_.tofixedbits();$_.addtometapart()}else{$k[$j++]=~~(($_.cols-17)/4)-1;$k[$j++]=~~($_.metavlen/2);$_.tofixedbits();$_.addtometapart();$k[$j++]=~~(($_.rows-17)/4)-1;$k[$j++]=~~($_.metavlen/2);$_.tofixedbits();$_.addtometapart()}$k[$j++]=$_.datawc-3;$k[$j++]=~~($_.metaelen/2);$_.tofixedbits();$_.addtometapart();$k[$j++]=$_.datawr-4;$k[$j++]=~~($_.metaelen/2);$_.tofixedbits();$_.addtometapart();if($_.hasslaves){$k[$j++]=0;$k[$j++]=4;$_.tofixedbits();$_.addtometapart()}$k[$j++]=$G($_.metapart,0,$_.p);$k[$j++]=2;$k[$j++]=-1;$_.ldpc();$_.addtometabits();$_.p=0}else{var _Re=$_.sameshape?0:1;$k[$j++]=_Re;$k[$j++]=1;$_.tofixedbits();$_.addtometapart();var _Rg=$_.sameecc?0:1;$k[$j++]=_Rg;$k[$j++]=1;$_.tofixedbits();$_.addtometapart();var _Ri=$_.hasslaves?1:0;$k[$j++]=_Ri;$k[$j++]=1;$_.tofixedbits();$_.addtometapart();$k[$j++]=$G($_.metapart,0,$_.p);$k[$j++]=2;$k[$j++]=-1;$_.ldpc();$_.addtometabits();$_.p=0;if(!$_.sameshape){$k[$j++]=~~(($_.diffside-17)/4)-1;$k[$j++]=5;$_.tofixedbits();$_.addtometapart()}if($_.hasslaves){$k[$j++]=0;$k[$j++]=3;$_.tofixedbits();$_.addtometapart()}$k[$j++]=$G($_.metapart,0,$_.p);$k[$j++]=2;$k[$j++]=-1;$_.ldpc();$_.addtometabits();$_.p=0;if(!$_.sameecc){$k[$j++]=$_.datawc-3;$k[$j++]=~~($_.metaelen/2);$_.tofixedbits();$_.addtometapart();$k[$j++]=$_.datawr-4;$k[$j++]=~~($_.metaelen/2);$_.tofixedbits();$_.addtometapart()}$k[$j++]=$G($_.metapart,0,$_.p);$k[$j++]=2;$k[$j++]=-1;$_.ldpc();$_.addtometabits();$_.p=0}for(var _S3=$_.q,_S2=$_.nummetabits-1;_S3<=_S2;_S3+=1){$p($_.metabits,_S3,48)}$_.i=0;$_.j=0;if(!$_.slave){var _S8=$G($_.metabits,$_.i,6);for(var _S9=0,_SA=_S8.length;_S9<_SA;_S9++){$k[$j++]=$g(_S8,_S9);if($_.colors==4){$k[$j++]=$a([$_.bi,$_.yi])}else{$k[$j++]=$a([$_.ki,$_.wi])}var _SJ=$k[--$j];var _SL=$g(_SJ,$k[--$j]-48);$k[$j++]=_SL;$k[$j++]=$_.pixs;$q($g($_.metadatamap,$_.j));$_.jmv();var _SQ=$k[$j-3];var _SR=$k[$j-1];$p($k[$j-2],_SR,_SQ);$j-=3;$_.j=$_.j+1}$_.i=$_.i+6}for(var _SY=0,_SZ=~~($f($_.nummetabits-$_.i)/$_.metabpm);_SY<_SZ;_SY++){var _Sd=$G($_.metabits,$_.i,$_.metabpm);$k[$j++]=0;for(var _Se=0,_Sf=_Sd.length;_Se<_Sf;_Se++){var _Sh=$k[--$j];$k[$j++]=$f(_Sh+($g(_Sd,_Se)-48))*2}var _Sk=$g($_.metacolorindex,~~($k[--$j]/2));$k[$j++]=_Sk;$k[$j++]=$_.pixs;$q($g($_.metadatamap,$_.j));$_.jmv();var _Sp=$k[$j-3];var _Sq=$k[$j-1];$p($k[$j-2],_Sq,_Sp);$j-=3;$_.i=$f($_.i+$_.metabpm);$_.j=$_.j+1}var _T2=new Map([["ren","renmatrix"],["pixs",$_.pixs],["pixx",$_.cols],["pixy",$_.rows],["colormap",$_.palette],["height",$_.rows*2/72],["width",$_.cols*2/72],["borderleft",0],["borderright",0],["bordertop",0],["borderbottom",0],["opt",$_.options]]);$k[$j++]=_T2;if(!$_.dontdraw){bwipp_renmatrix()}$_=$__}function bwipp_gs1_cc(){var $__=$_;$_=Object.assign({},$_);$_.parse=false;$_.dontlint=false;$_.lintreqs=false;$_.dontdraw=false;$_.ccversion="a";$_.cccolumns=-1;$_.lintype="";$_.linwidth=-1;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($ne($_.ccversion,"a")&&$ne($_.ccversion,"b")&&$ne($_.ccversion,"c")){$k[$j++]="bwipp.gs1ccBadCCversion#28834";$k[$j++]="ccversion must be a, b or c";bwipp_raiseerror()}if($_.cccolumns>30){$k[$j++]="bwipp.gs1ccColumnsTooBig#28838";$k[$j++]="The maximum number of composite component columns is 30";bwipp_raiseerror()}var _6=new Map([["ean13",4],["upca",4],["ean8",3],["upce",2],["gs1-128",4],["databaromni",4],["databarstacked",2],["databarstackedomni",2],["databartruncated",4],["databarlimited",3],["databarexpanded",4],["databarexpandedstacked",4]]);$_.lintypecccolumns=_6;if($_.lintype.length!=0){var _B=$g($_.lintypecccolumns,$_.lintype)!==undefined;if(!_B){$k[$j++]="bwipp.gs1ccBadLinType#28860";$k[$j++]="The lintype is not recognised";bwipp_raiseerror()}}if($_.cccolumns==-1){if($eq($_.lintype,"gs1-128")&&$eq($_.ccversion,"c")){if($_.linwidth<0){$k[$j++]="bwipp.gs1ccMissingLinWidth#28868";$k[$j++]="linwidth must be set for a GS1-128 with a CC-C composite component";bwipp_raiseerror()}if($_.linwidth<68){$k[$j++]="bwipp.gs1ccMinimumLinWidth#28871";$k[$j++]="Minimum linwidth for a GS1-128 with a CC-C composite component is 68";bwipp_raiseerror()}if($_.linwidth==68){$k[$j++]=1}else{$k[$j++]=~~(($_.linwidth-52)/17)}}else{if($_.lintype.length!=0){$k[$j++]=$g($_.lintypecccolumns,$_.lintype)}else{$k[$j++]=2}}$_.cccolumns=$k[--$j]}$k[$j++]=$_.barcode;$k[$j++]="ai";bwipp_gs1process();$_.fncs=$k[--$j];$_.vals=$k[--$j];$_.ais=$k[--$j];$_.isupper=function(){var _S=$k[--$j];$k[$j++]=_S>=65&&_S<=90};$_.isnum0=function(){var _T=$k[--$j];$k[$j++]=_T>=48&&_T<=57};$_.isnum1=function(){var _U=$k[--$j];$k[$j++]=_U>=49&&_U<=57};for(;;){if($_.ais.length>=1){if($eq($g($_.ais,0),"10")||$eq($g($_.ais,0),"11")||$eq($g($_.ais,0),"17")){$k[$j++]=-1;$k[$j++]="10";break}}if($_.ais.length>=1){if($eq($g($_.ais,0),"90")){$_.v=$g($_.vals,0);if($_.v.length>=1){$k[$j++]=$g($_.v,0);$_.isupper();if($k[--$j]){$k[$j++]=0;$k[$j++]="11";break}}if($_.v.length>=2){$k[$j++]=$g($_.v,0);$_.isnum1();$k[$j++]=$g($_.v,1);$_.isupper();var _q=$k[--$j];if($k[--$j]&&_q){$k[$j++]=1;$k[$j++]="11";break}}if($_.v.length>=3){$k[$j++]=$g($_.v,0);$_.isnum1();$k[$j++]=$g($_.v,1);$_.isnum0();var _x=$k[--$j];var _y=$k[--$j];$k[$j++]=$an(_y,_x);$k[$j++]=$g($_.v,2);$_.isupper();var _11=$k[--$j];if($k[--$j]&&_11){$k[$j++]=2;$k[$j++]="11";break}}if($_.v.length>=4){$k[$j++]=$g($_.v,0);$_.isnum1();$k[$j++]=$g($_.v,1);$_.isnum0();var _18=$k[--$j];var _19=$k[--$j];$k[$j++]=$an(_19,_18);$k[$j++]=$g($_.v,2);$_.isnum0();var _1C=$k[--$j];var _1D=$k[--$j];$k[$j++]=$an(_1D,_1C);$k[$j++]=$g($_.v,3);$_.isupper();var _1G=$k[--$j];if($k[--$j]&&_1G){$k[$j++]=3;$k[$j++]="11";break}}}}$k[$j++]=-1;$k[$j++]="0";break}$_.method=$k[--$j];$_.npre=$k[--$j];$_.tobin=function(){var _1L=$s($k[--$j]);$k[$j++]=_1L;for(var _1N=0,_1M=_1L.length-1;_1N<=_1M;_1N+=1){var _1O=$k[$j-1];$p(_1O,_1N,48)}var _1P=$k[$j-1];$k[$j++]=_1P;var _1Q=$k[$j-3];var _1R=$k[$j-1];$k[$j-3]=$k[$j-2];$j-=2;var _1T=$R($s(_1R.length),_1Q,2);$P(_1R,_1R.length-_1T.length,_1T)};$_.fnc1=-1;$_.lnumeric=-2;$_.lalphanumeric=-3;$_.liso646=-4;$k[$j++]=Infinity;for(var _1U=65;_1U<=90;_1U+=1){$k[$j++]=_1U;$k[$j++]=_1U-65;$k[$j++]=5;$_.tobin()}for(var _1V=48;_1V<=57;_1V+=1){$k[$j++]=_1V;$k[$j++]=_1V+4;$k[$j++]=6;$_.tobin()}$k[$j++]=$_.fnc1;$k[$j++]="11111";$_.alpha=$d();$k[$j++]=Infinity;for(var _1Y=0;_1Y<=119;_1Y+=1){var _1a=$Z($s(2),"00");var _1c=$R($s(2),_1Y,11);$P(_1a,2-_1c.length,_1c);$k[$j++]=_1Y;$k[$j++]=_1a;if($g(_1a,0)==65){var _1e=$k[$j-1];$p(_1e,0,94)}var _1f=$k[$j-1];if($g(_1f,1)==65){var _1h=$k[$j-1];$p(_1h,1,94)}var _1i=$k[--$j];var _1l=$Z($s(7),"0000000");var _1n=$R($s(7),$k[--$j]+8,2);$P(_1l,7-_1n.length,_1n);$k[$j++]=_1i;$k[$j++]=_1l}$k[$j++]=$_.lalphanumeric;$k[$j++]="0000";$_.numeric=$d();$k[$j++]=Infinity;for(var _1q=48;_1q<=57;_1q+=1){$k[$j++]=_1q;$k[$j++]=_1q-43;$k[$j++]=5;$_.tobin()}$k[$j++]=$_.fnc1;$k[$j++]="01111";for(var _1s=65;_1s<=90;_1s+=1){$k[$j++]=_1s;$k[$j++]=_1s-33;$k[$j++]=6;$_.tobin()}$k[$j++]=42;$k[$j++]="111010";for(var _1t=44;_1t<=47;_1t+=1){$k[$j++]=_1t;$k[$j++]=_1t+15;$k[$j++]=6;$_.tobin()}$k[$j++]=$_.lnumeric;$k[$j++]="000";$k[$j++]=$_.liso646;$k[$j++]="00100";$_.alphanumeric=$d();$k[$j++]=Infinity;for(var _1x=48;_1x<=57;_1x+=1){$k[$j++]=_1x;$k[$j++]=_1x-43;$k[$j++]=5;$_.tobin()}$k[$j++]=$_.fnc1;$k[$j++]="01111";for(var _1z=65;_1z<=90;_1z+=1){$k[$j++]=_1z;$k[$j++]=_1z-1;$k[$j++]=7;$_.tobin()}for(var _20=97;_20<=122;_20+=1){$k[$j++]=_20;$k[$j++]=_20-7;$k[$j++]=7;$_.tobin()}$k[$j++]=33;$k[$j++]="11101000";$k[$j++]=34;$k[$j++]="11101001";for(var _21=37;_21<=47;_21+=1){$k[$j++]=_21;$k[$j++]=_21+197;$k[$j++]=8;$_.tobin()}for(var _22=58;_22<=63;_22+=1){$k[$j++]=_22;$k[$j++]=_22+187;$k[$j++]=8;$_.tobin()}$k[$j++]=95;$k[$j++]="11111011";$k[$j++]=32;$k[$j++]="11111100";$k[$j++]=$_.lnumeric;$k[$j++]="000";$k[$j++]=$_.lalphanumeric;$k[$j++]="00100";$_.iso646=$d();if($eq($_.method,"10")){if($eq($g($_.ais,0),"11")||$eq($g($_.ais,0),"17")){var _2D=$g($_.vals,0);var _2I=$Z($s(16),"0000000000000000");var _2K=$R($s(16),$i($G(_2D,0,2))*384+(($i($G(_2D,2,2))-1)*32+$i($G(_2D,4,2))),2);$P(_2I,16-_2K.length,_2K);$k[$j++]=_2I;$k[$j++]=Infinity;$k[$j++]=1;$k[$j++]=0;$r(4,-1);$F($k[--$j],function(){var _2M=$k[--$j];$k[$j++]=_2M-48});var _2P=$eq($g($_.ais,0),"11")?0:1;$k[$j++]=_2P;$_.cdf=$a();$_.ais=$G($_.ais,1,$_.ais.length-1);$_.vals=$G($_.vals,1,$_.vals.length-1);$_.fncs=$G($_.fncs,1,$_.fncs.length-1)}else{$_.cdf=$a([1,0,1,1])}if($_.ais.length!=0){if($eq($g($_.ais,0),"10")){$k[$j++]=Infinity;$F($g($_.vals,0));$_.gpf=$a();if($_.ais.length>1){$k[$j++]=Infinity;$q($_.gpf);$k[$j++]=$_.fnc1;$_.gpf=$a()}$_.ais=$G($_.ais,1,$_.ais.length-1);$_.vals=$G($_.vals,1,$_.vals.length-1);$_.fncs=$G($_.fncs,1,$_.fncs.length-1)}else{$_.gpf=$a([$_.fnc1])}}else{$k[$j++]=Infinity;$q($_.cdf);$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$_.cdf=$a();$_.gpf=$a([])}$_.mode="numeric"}if($eq($_.method,"11")){$_.cdf=$a([1,1]);$_.ai90=$g($_.vals,0);if($_.npre+1!=$_.ai90.length){$k[$j++]=$G($_.ai90,$_.npre+1,$f($_.ai90.length-$_.npre)-1)}else{$k[$j++]=""}$_.ai90rem=$k[--$j];$k[$j++]="nalpha";$k[$j++]=0;$F($_.ai90rem,function(){var _3C=$k[--$j];if(_3C>=65&&_3C<=90){var _3D=$k[--$j];$k[$j++]=_3D+1}});var _3E=$k[--$j];$_[$k[--$j]]=_3E;$k[$j++]="nnums";$k[$j++]=0;$F($_.ai90rem,function(){var _3H=$k[--$j];if(_3H>=48&&_3H<=57){var _3I=$k[--$j];$k[$j++]=_3I+1}});var _3J=$k[--$j];$_[$k[--$j]]=_3J;$k[$j++]="mode";if($gt($_.nalpha,$_.nnums)){$k[$j++]="alpha"}else{if($_.nalpha==0){$k[$j++]="numeric"}else{$k[$j++]="alphanumeric"}}var _3O=$k[--$j];$_[$k[--$j]]=_3O;if($f($_.nalpha+$_.nnums)!=$_.ai90rem.length){$_.mode="alphanumeric"}$k[$j++]=Infinity;$q($_.cdf);if($eq($_.mode,"alphanumeric")){$k[$j++]=0}if($eq($_.mode,"numeric")){$k[$j++]=1;$k[$j++]=0}if($eq($_.mode,"alpha")){$k[$j++]=1;$k[$j++]=1}$_.cdf=$a();$k[$j++]="ais1";if($_.ais.length>1){$k[$j++]=$g($_.ais,1)}else{$k[$j++]=-1}var _3b=$k[--$j];$_[$k[--$j]]=_3b;$k[$j++]="vals1";if($_.vals.length>1){$k[$j++]=$g($_.vals,1)}else{$k[$j++]=-1}var _3g=$k[--$j];$_[$k[--$j]]=_3g;if($eq($_.ais1,"21")||$eq($_.ais1,"8004")){$k[$j++]=Infinity;$q($_.cdf);if($eq($_.ais1,"21")){$k[$j++]=1;$k[$j++]=0}else{$k[$j++]=1;$k[$j++]=1}$_.cdf=$a()}else{$k[$j++]=Infinity;$q($_.cdf);$k[$j++]=0;$_.cdf=$a()}$k[$j++]="nval";if($_.npre!=0){$k[$j++]=$i($G($_.ai90,0,$_.npre))}else{$k[$j++]=0}var _3t=$k[--$j];$_[$k[--$j]]=_3t;$X("BDHIJKLNPQRSTVXZ",$G($_.ai90,$_.npre,1));if($k[--$j]){var _3z=$k[--$j];$k[$j-1]=_3z.length;var _41=$k[--$j];$k[$j-1]=_41;$_.aval=$k[--$j]}else{$j--;$_.aval=-1}if($_.nval<31&&$_.aval!=-1){var _47=$Z($s(5),"00000");var _4A=$R($s(5),$_.nval,2);$P(_47,5-_4A.length,_4A);var _4B=Infinity;var _4C=_47;$k[$j++]=_4B;$F(_4C,function(){var _4D=$k[--$j];$k[$j++]=_4D-48});$_.nbits=$a();var _4G=$Z($s(4),"0000");var _4J=$R($s(4),$_.aval,2);$P(_4G,4-_4J.length,_4J);var _4K=Infinity;var _4L=_4G;$k[$j++]=_4K;$F(_4L,function(){var _4M=$k[--$j];$k[$j++]=_4M-48});$_.abits=$a();$k[$j++]=Infinity;$q($_.cdf);$q($_.nbits);$q($_.abits);$_.cdf=$a()}else{var _4T=$Z($s(10),"0000000000");var _4W=$R($s(10),$_.nval,2);$P(_4T,10-_4W.length,_4W);var _4X=Infinity;var _4Y=_4T;$k[$j++]=_4X;$F(_4Y,function(){var _4Z=$k[--$j];$k[$j++]=_4Z-48});$_.nbits=$a();var _4c=$Z($s(5),"00000");var _4h=$R($s(5),$g($_.ai90,$_.npre)-65,2);$P(_4c,5-_4h.length,_4h);var _4i=Infinity;var _4j=_4c;$k[$j++]=_4i;$F(_4j,function(){var _4k=$k[--$j];$k[$j++]=_4k-48});$_.abits=$a();$k[$j++]=Infinity;$q($_.cdf);$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$q($_.nbits);$q($_.abits);$_.cdf=$a()}if($ne($_.mode,"alpha")){$k[$j++]=Infinity;$F($_.ai90rem);if($_.ais.length>1){$k[$j++]=$_.fnc1}$_.gpf=$a()}else{$k[$j++]=Infinity;$F($_.ai90rem);if($_.ais.length>1){$k[$j++]=$_.fnc1}$_.in=$a();$_.out=$a($_.in.length*6);$_.j=0;for(var _53=0,_52=$_.in.length-1;_53<=_52;_53+=1){var _57=$g($_.alpha,$g($_.in,_53));$k[$j++]=_57;var _58=Infinity;var _59=_57;$k[$j++]=_58;$F(_59,function(){var _5A=$k[--$j];$k[$j++]=_5A-48});$P($_.out,$_.j,$a());$_.j=$k[--$j].length+$_.j}$k[$j++]=Infinity;$q($_.cdf);$q($G($_.out,0,$_.j));$_.cdf=$a();$_.gpf=$a([]);if($_.ais.length>1){$_.mode="numeric"}}$_.ais=$G($_.ais,1,$_.ais.length-1);$_.vals=$G($_.vals,1,$_.vals.length-1);$_.fncs=$G($_.fncs,1,$_.fncs.length-1);if($_.ais.length!=0){if($eq($_.ais1,"21")||$eq($_.ais1,"8004")){$k[$j++]=Infinity;$q($_.gpf);$F($_.vals1);$_.gpf=$a();$_.ais=$G($_.ais,1,$_.ais.length-1);$_.vals=$G($_.vals,1,$_.vals.length-1);$_.fncs=$G($_.fncs,1,$_.fncs.length-1);if($_.ais.length!=0){$k[$j++]=Infinity;$q($_.gpf);$k[$j++]=$_.fnc1;$_.gpf=$a()}}}}if($eq($_.method,"0")){$_.cdf=$a([0]);$_.gpf=$a([]);$_.mode="numeric"}for(var _5u=0,_5t=$_.ais.length-1;_5u<=_5t;_5u+=1){$_.i=_5u;$_.ai=$g($_.ais,$_.i);$_.val=$g($_.vals,$_.i);var _64=$a($_.gpf.length+$_.ai.length+$_.val.length);$P(_64,0,$_.gpf);$k[$j++]=_64;$k[$j++]=_64;$k[$j++]=$_.gpf.length;var _68=Infinity;var _69=$_.ai;$k[$j++]=_68;$F(_69);var _6A=$a();var _6B=$k[--$j];$P($k[--$j],_6B,_6A);var _6D=$k[$j-1];$k[$j++]=_6D;$k[$j++]=$_.gpf.length+$_.ai.length;var _6H=Infinity;var _6I=$_.val;$k[$j++]=_6H;$F(_6I);var _6J=$a();var _6K=$k[--$j];$P($k[--$j],_6K,_6J);$_.gpf=$k[--$j];if($_.i!=$_.ais.length-1&&$g($_.fncs,$_.i)){var _6T=$a($_.gpf.length+1);$P(_6T,0,$_.gpf);$p(_6T,$_.gpf.length,$_.fnc1);$_.gpf=_6T}}var _6f=new Map([["a",$a([$a([167,138,118,108,88,78,59]),$a([167,138,118,98,78]),$a([197,167,138,108,78])])],["b",$a([$a([336,296,256,208,160,104,56]),$a([768,648,536,416,304,208,152,112,72,32]),$a([1184,1016,840,672,496,352,264,208,152,96,56])])]]);$_.bitcapsmaps=_6f;$_.rembits=function(){$_.used=$k[--$j];if($ne($_.ccversion,"c")){$_.bitcaps=$g($g($_.bitcapsmaps,$_.ccversion),$_.cccolumns-2);$k[$j++]=-1;$F($_.bitcaps,function(){var _6p=$k[$j-1];if($ge(_6p,$_.used)){var _6r=$k[--$j];var _6s=$k[--$j];$k[$j++]=_6r;$k[$j++]=_6s}$j--});var _6t=$k[$j-1];if(_6t!=-1){var _6v=$k[--$j];$k[$j++]=$f(_6v-$_.used)}}else{var _6w=new Map([["c",-1]]);var _6y=$g(_6w,$_.ccversion);var _70=~~$ceil($_.used/8);$_.m=~~(_70/6)*5+_70%6;if($_.m<=40){$k[$j++]=8}if($_.m>=41&&$_.m<=160){$k[$j++]=16}if($_.m>=161&&$_.m<=320){$k[$j++]=32}if($_.m>=321&&$_.m<=833){$k[$j++]=64}if($_.m>=834){$k[$j++]=32}$_.eccws=$k[--$j];$_.m=$f($_.m+$_.eccws)+3;if($_.cccolumns>30){$_.cccolumns=30}for(;;){if(~~$ceil($_.m/$_.cccolumns)<=30||$_.cccolumns>=30){break}$_.cccolumns=$_.cccolumns+1}$_.r=~~$ceil($_.m/$_.cccolumns);if($_.r<3){$_.r=3}var _7N=$f($_.cccolumns*$_.r-$_.eccws)-3;$_.tgt=$f(~~(_7N/5)*6+_7N%5)*8;if($_.used<=8304){$k[$j++]=$f($_.tgt-$_.used)}else{$k[$j++]=-1}}var _7R=$k[$j-1];if(_7R==-1){$j--;if($eq($_.ccversion,"a")){$_.ccversion="b"}else{if($eq($_.ccversion,"b")&&$eq($_.lintype,"gs1-128")){$_.ccversion="c";$_.cccolumns=~~(($_.linwidth-52)/17)}else{$_.ccversion=-1}}$k[$j++]=$_.used;$_.rembits()}};$_.encode=function(){var _7X=$k[$j-1];if($ne(_7X,"raw")){var _7Y=$k[--$j];var _7a=$g(_7Y,$k[--$j]);$k[$j++]=_7a}else{$j--}$k[$j++]=Infinity;var _7b=$k[--$j];var _7c=$k[--$j];$k[$j++]=_7b;$F(_7c,function(){var _7d=$k[--$j];$k[$j++]=_7d-48});var _7e=$a();$P($_.gpfenc,$_.j,_7e);$_.j=_7e.length+$_.j};$k[$j++]=Infinity;for(var _7j=0,_7k=$_.gpf.length;_7j<_7k;_7j++){$k[$j++]=0}$k[$j++]=0;$k[$j++]=-1;$_.numericruns=$a();$k[$j++]=Infinity;for(var _7n=0,_7o=$_.gpf.length;_7n<_7o;_7n++){$k[$j++]=0}$k[$j++]=0;$_.alphanumericruns=$a();$k[$j++]=Infinity;for(var _7r=0,_7s=$_.gpf.length;_7r<_7s;_7r++){$k[$j++]=0}$k[$j++]=9999;$_.nextiso646only=$a();for(var _7v=$_.gpf.length-1;_7v>=0;_7v-=1){$_.i=_7v;var _80=$Z($s(2),"00");var _83=$g($_.gpf,$_.i);$k[$j++]=$g($_.gpf,$_.i);$k[$j++]=_80;$k[$j++]=_80;$k[$j++]=0;$k[$j++]=_83;if(_83==$_.fnc1){$k[$j-1]=94}var _85=$k[--$j];var _86=$k[--$j];$p($k[--$j],_86,_85);if($_.i<$_.gpf.length-1){var _8A=$k[$j-1];var _8D=$g($_.gpf,$_.i+1);$k[$j++]=_8A;$k[$j++]=1;$k[$j++]=_8D;if(_8D==$_.fnc1){$k[$j-1]=94}var _8F=$k[--$j];var _8G=$k[--$j];$p($k[--$j],_8G,_8F)}var _8K=$g($_.numeric,$k[--$j])!==undefined;if(_8K){$p($_.numericruns,$_.i,$g($_.numericruns,$_.i+2)+2)}else{$p($_.numericruns,$_.i,0)}var _8S=$k[$j-1];var _8U=$g($_.alphanumeric,_8S)!==undefined;if(_8U){$p($_.alphanumericruns,$_.i,$g($_.alphanumericruns,$_.i+1)+1)}else{$p($_.alphanumericruns,$_.i,0)}var _8c=$k[--$j];var _8e=$g($_.iso646,_8c)!==undefined;var _8g=$g($_.alphanumeric,_8c)!==undefined;if(_8e&&!_8g){$p($_.nextiso646only,$_.i,0)}else{$p($_.nextiso646only,$_.i,$g($_.nextiso646only,$_.i+1)+1)}}$_.gpfenc=$a(8304);$_.i=0;$_.j=0;for(;;){if($_.i==$_.gpf.length){break}for(;;){if($eq($_.mode,"numeric")){if($_.i<=$_.gpf.length-2){var _8u=$s(2);var _8x=$g($_.gpf,$_.i);$k[$j++]=_8u;$k[$j++]=_8u;$k[$j++]=0;$k[$j++]=_8x;if(_8x==$_.fnc1){$k[$j-1]=94}var _8z=$k[--$j];var _90=$k[--$j];$p($k[--$j],_90,_8z);var _92=$k[$j-1];var _95=$g($_.gpf,$_.i+1);$k[$j++]=_92;$k[$j++]=1;$k[$j++]=_95;if(_95==$_.fnc1){$k[$j-1]=94}var _97=$k[--$j];var _98=$k[--$j];$p($k[--$j],_98,_97);var _9A=$k[$j-1];var _9C=$g($_.numeric,_9A)!==undefined;if(_9C){$k[$j++]=$_.numeric;$_.encode();$_.i=$_.i+2;break}$k[$j-1]=$_.lalphanumeric;$k[$j++]=$_.numeric;$_.encode();$_.mode="alphanumeric";break}else{var _9J=$g($_.gpf,$_.i);if(_9J<48||_9J>57){$k[$j++]=$_.lalphanumeric;$k[$j++]=$_.numeric;$_.encode();$_.mode="alphanumeric";break}$k[$j++]="rem";$k[$j++]=$_.cdf.length+$_.j;$_.rembits();var _9O=$k[--$j];$_[$k[--$j]]=_9O;if($_.rem>=4&&$_.rem<=6){var _9V=$G($Z($s(6),"000000"),0,$_.rem);var _9a=$R($s(4),$g($_.gpf,$_.i)-47,2);$P(_9V,4-_9a.length,_9a);$k[$j++]=_9V;$k[$j++]="raw";$_.encode();$_.i=$_.i+1;break}else{var _9c=$s(2);$p(_9c,0,$g($_.gpf,$_.i));$p(_9c,1,94);$k[$j++]=_9c;$k[$j++]=$_.numeric;$_.encode();$_.i=$_.i+1;break}}}if($eq($_.mode,"alphanumeric")){if($g($_.gpf,$_.i)==$_.fnc1){$k[$j++]=$_.fnc1;$k[$j++]=$_.alphanumeric;$_.encode();$_.mode="numeric";$_.i=$_.i+1;break}var _9s=$g($_.gpf,$_.i);var _9u=$g($_.iso646,_9s)!==undefined;var _9w=$g($_.alphanumeric,_9s)!==undefined;if(_9u&&!_9w){$k[$j++]=$_.liso646;$k[$j++]=$_.alphanumeric;$_.encode();$_.mode="iso646";break}if($g($_.numericruns,$_.i)>=6){$k[$j++]=$_.lnumeric;$k[$j++]=$_.alphanumeric;$_.encode();$_.mode="numeric";break}var _A6=$g($_.numericruns,$_.i);if(_A6>=4&&$f(_A6+$_.i)==$_.gpf.length){$k[$j++]=$_.lnumeric;$k[$j++]=$_.alphanumeric;$_.encode();$_.mode="numeric";break}$k[$j++]=$g($_.gpf,$_.i);$k[$j++]=$_.alphanumeric;$_.encode();$_.i=$_.i+1;break}if($eq($_.mode,"iso646")){if($g($_.gpf,$_.i)==$_.fnc1){$k[$j++]=$_.fnc1;$k[$j++]=$_.iso646;$_.encode();$_.mode="numeric";$_.i=$_.i+1;break}if($g($_.numericruns,$_.i)>=4&&$g($_.nextiso646only,$_.i)>=10){$k[$j++]=$_.lnumeric;$k[$j++]=$_.iso646;$_.encode();$_.mode="numeric";break}if($g($_.alphanumericruns,$_.i)>=5&&$g($_.nextiso646only,$_.i)>=10){$k[$j++]=$_.lalphanumeric;$k[$j++]=$_.iso646;$_.encode();$_.mode="alphanumeric";break}$k[$j++]=$g($_.gpf,$_.i);$k[$j++]=$_.iso646;$_.encode();$_.i=$_.i+1;break}}}$_.gpf=$G($_.gpfenc,0,$_.j);$k[$j++]="pad";$k[$j++]=$_.cdf.length+$_.gpf.length;$_.rembits();var _Ap=$a($k[--$j]);$_[$k[--$j]]=_Ap;if($_.pad.length>0){for(var _Au=0,_At=$_.pad.length-1;_Au<=_At;_Au+=5){$_.i=_Au;var _Av=$_.pad;var _Aw=$_.i;var _Ax=$a([0,0,1,0,0]);var _Ay=$_.pad;var _Az=$_.i;var _B0=5;var _B1=_Ay.length-_Az;if(_Ay.length-_Az>5){var _=_B0;_B0=_B1;_B1=_}$P(_Av,_Aw,$G(_Ax,0,_B1))}if($eq($_.mode,"numeric")){$k[$j++]=Infinity;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$q($_.pad);$_.pad=$G($a(),0,$_.pad.length)}if($eq($_.mode,"alpha")){$k[$j++]=Infinity;$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$k[$j++]=1;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$q($_.pad);$_.pad=$G($a(),0,$_.pad.length)}}$k[$j++]=Infinity;$q($_.cdf);$q($_.gpf);$q($_.pad);$_.bits=$a();$k[$j++]=Infinity;$k[$j++]=$a([0,0,0,0,0,0,1]);for(var _BI=0;_BI<68;_BI++){$k[$j++]=$a(7)}$_.pwr928=$a();for(var _BL=1;_BL<=68;_BL+=1){$_.j=_BL;$_.v=0;for(var _BM=6;_BM>=1;_BM-=1){$_.i=_BM;$_.v=$f($g($g($_.pwr928,$_.j-1),$_.i)*2+~~($_.v/928));$p($g($_.pwr928,$_.j),$_.i,$_.v%928)}$p($g($_.pwr928,$_.j),0,$f($g($g($_.pwr928,$_.j-1),0)*2+~~($_.v/928)))}if($_.ccversion=="a"){$k[$j++]=Infinity;for(var _Bi=0;_Bi<28;_Bi++){$k[$j++]=0}$_.cws=$a();$_.b=0;$_.c=0;for(;;){if($_.b==$_.bits.length){break}var _Bm=$_.bits;var _Bn=$_.b;var _Bo=$_.bits;var _Bp=$_.b;var _Bq=_Bo.length-_Bp;var _Br=69;if(69>_Bo.length-_Bp){var _=_Bq;_Bq=_Br;_Br=_}$_.bs=$G(_Bm,_Bn,_Br);$_.bsl=$_.bs.length;$_.cs=$G($_.cws,$_.c,~~($_.bsl/10)+1);$_.csl=$_.cs.length;for(var _C1=0,_C0=$_.bsl-1;_C1<=_C0;_C1+=1){$_.i=_C1;for(var _C4=0,_C3=$_.csl-1;_C4<=_C3;_C4+=1){$_.j=_C4;var _C5=$_.cs;var _C6=$_.j;$p(_C5,_C6,$f($g(_C5,_C6)+$g($g($_.pwr928,$_.i),$_.j+7-$_.csl)*$g($_.bs,$_.bsl-$_.i-1)))}}for(var _CJ=$_.csl-1;_CJ>=1;_CJ-=1){$_.i=_CJ;var _CK=$_.cs;var _CL=$_.i;$p(_CK,_CL-1,$f($g(_CK,_CL-1)+~~($g($_.cs,$_.i)/928)));var _CQ=$_.cs;var _CR=$_.i;$p(_CQ,_CR,$g(_CQ,_CR)%928)}$_.b=$_.b+$_.bsl;$_.c=$_.c+$_.csl}$_.cws=$G($_.cws,0,$_.c);$_.barcode=$s($_.cws.length*4);for(var _Ce=0,_Cd=$_.cws.length-1;_Ce<=_Cd;_Ce+=1){$_.i=_Ce;var _Cg=$Z($s(4),"^000");var _Cl=$R($s(4),$g($_.cws,$_.i),10);$P(_Cg,4-_Cl.length,_Cl);$P($_.barcode,$_.i*4,_Cg)}delete $_.options["parse"];$p($_.options,"dontdraw",true);$p($_.options,"cca",true);$p($_.options,"columns",$_.cccolumns);$k[$j++]="args";$k[$j++]=$_.barcode;$k[$j++]=$_.options;bwipp_micropdf417();var _Cv=$k[--$j];$_[$k[--$j]]=_Cv}if($_.ccversion=="b"){$_.barcode=$s(~~($_.bits.length/8));for(var _D2=0,_D1=$_.barcode.length-1;_D2<=_D1;_D2+=1){$_.i=_D2;var _D5=$G($_.bits,$_.i*8,8);$k[$j++]=0;for(var _D6=0,_D7=_D5.length;_D6<_D7;_D6++){var _D9=$k[--$j];$k[$j++]=$f(_D9+$g(_D5,_D6))*2}$p($_.barcode,$_.i,~~($k[--$j]/2))}delete $_.options["parse"];$p($_.options,"dontdraw",true);$p($_.options,"ccb",true);$p($_.options,"columns",$_.cccolumns);$k[$j++]="args";$k[$j++]=$_.barcode;$k[$j++]=$_.options;bwipp_micropdf417();var _DK=$k[--$j];$_[$k[--$j]]=_DK}if($_.ccversion=="c"){$_.barcode=$s(~~($_.bits.length/8));for(var _DR=0,_DQ=$_.barcode.length-1;_DR<=_DQ;_DR+=1){$_.i=_DR;var _DU=$G($_.bits,$_.i*8,8);$k[$j++]=0;for(var _DV=0,_DW=_DU.length;_DV<_DW;_DV++){var _DY=$k[--$j];$k[$j++]=$f(_DY+$g(_DU,_DV))*2}$p($_.barcode,$_.i,~~($k[--$j]/2))}delete $_.options["parse"];$p($_.options,"dontdraw",true);$p($_.options,"ccc",true);$p($_.options,"columns",$_.cccolumns);$p($_.options,"eclevel",~~($log($_.eccws)/$log(2))-1);$k[$j++]="args";$k[$j++]=$_.barcode;$k[$j++]=$_.options;bwipp_pdf417();var _Dl=$k[--$j];$_[$k[--$j]]=_Dl}$k[$j++]=$_.args;if(!$_.dontdraw){bwipp_renmatrix()}$_=$__}function bwipp_ean13composite(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.usematrix=false;$_.parse=false;$_.dontlint=false;$_.lintreqs=true;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.dontdraw){$_.usematrix=true}$X($_.barcode,"|");if($k[--$j]){$_.linear=$k[--$j];$j--;$_.comp=$k[--$j]}else{$j--;$k[$j++]="bwipp.missingCompositeComponent#29501";$k[$j++]="A Composite Component must be provided following a pipe character";bwipp_raiseerror()}$p($_.options,"lintype","ean13");$p($_.options,"inkspreadv",0);$p($_.options,"dontdraw",true);$p($_.options,"dontlint",true);var _C=$s($_.comp.length+18);$P(_C,0,"(01)00000000000000");$P(_C,18,$_.comp);$k[$j++]=_C;$k[$j++]="ai";bwipp_gs1process();$j-=3;$k[$j++]=$_.linear;$k[$j++]=$_.options;bwipp_ean13();if(!$_.usematrix){$$.save();bwipp_renlinear();var _H=$$.currpos();$$.rmoveto(-3,78);$k[$j++]=_H.x;$k[$j++]=_H.y;$k[$j++]=$_.comp;$k[$j++]=$_.options;bwipp_gs1_cc();bwipp_renmatrix();var _K=$k[--$j];$$.moveto($k[--$j]-1,_K+72);$k[$j++]=Infinity;$k[$j++]=Infinity;$k[$j++]=0;$k[$j++]=1;for(var _M=0;_M<93;_M++){$k[$j++]=0}$k[$j++]=1;$k[$j++]=0;$k[$j++]=1;$k[$j++]=0;for(var _N=0;_N<93;_N++){$k[$j++]=0}$k[$j++]=0;$k[$j++]=1;$k[$j++]=0;$k[$j++]=1;for(var _O=0;_O<93;_O++){$k[$j++]=0}$k[$j++]=1;$k[$j++]=0;var _P=$a();$k[$j++]="ren";$k[$j++]="renmatrix";$k[$j++]="pixs";$k[$j++]=_P;$k[$j++]="pixx";$k[$j++]=97;$k[$j++]="pixy";$k[$j++]=3;$k[$j++]="height";$k[$j++]=6/72;$k[$j++]="width";$k[$j++]=97/72;$k[$j++]="opt";$k[$j++]=$_.options;var _R=$d();$k[$j++]=_R;bwipp_renmatrix();$$.restore()}else{$_.linsym=$k[--$j];$_.sbs=$g($_.linsym,"sbs");$_.bhs=$g($_.linsym,"bhs");$_.bbs=$g($_.linsym,"bbs");$k[$j++]="linwidth";$k[$j++]=0;$F($_.sbs,function(){var _a=$k[--$j];var _b=$k[--$j];$k[$j++]=$f(_b+$i(_a))});var _c=$k[--$j];$_[$k[--$j]]=_c;$k[$j++]="compsym";$k[$j++]=$_.comp;$k[$j++]=$_.options;bwipp_gs1_cc();var _g=$k[--$j];$_[$k[--$j]]=_g;$_.ccpixs=$g($_.compsym,"pixs");$_.ccpixx=$g($_.compsym,"pixx");$k[$j++]=Infinity;for(var _n=0,_o=$_.ccpixx-97;_n<_o;_n++){$k[$j++]=0}$_.linpad=$a();$_.diff=$f($_.linwidth+$_.linpad.length+1-$_.ccpixx);if($_.diff>0){$k[$j++]=Infinity;for(var _v=0,_w=$_.diff;_v<_w;_v++){$k[$j++]=0}$_.ccrpad=$a();$_.pixx=$f($_.ccpixx+$_.diff)}else{$_.ccrpad=$a(0);$_.pixx=$_.ccpixx}$k[$j++]=Infinity;for(var _15=0,_16=$_.ccpixx,_14=$_.ccpixs.length-1;_16<0?_15>=_14:_15<=_14;_15+=_16){$_.i=_15;$q($G($_.ccpixs,$_.i,$_.ccpixx));$q($_.ccrpad)}for(var _1C=0;_1C<2;_1C++){$q($_.linpad);$k[$j++]=0;$k[$j++]=1;for(var _1E=0;_1E<93;_1E++){$k[$j++]=0}$k[$j++]=1;$k[$j++]=0;$q($_.ccrpad)}for(var _1G=0;_1G<2;_1G++){$q($_.linpad);$k[$j++]=1;$k[$j++]=0;for(var _1I=0;_1I<93;_1I++){$k[$j++]=0}$k[$j++]=0;$k[$j++]=1;$q($_.ccrpad)}for(var _1K=0;_1K<2;_1K++){$q($_.linpad);$k[$j++]=0;$k[$j++]=1;for(var _1M=0;_1M<93;_1M++){$k[$j++]=0}$k[$j++]=1;$k[$j++]=0;$q($_.ccrpad)}for(var _1O=71;_1O>=0;_1O-=1){$_.y=_1O;$q($_.linpad);$k[$j++]=0;for(var _1S=0,_1R=$_.sbs.length-1;_1S<=_1R;_1S+=1){$_.i=_1S;if($_.i%2==0){var _1X=$g($_.bbs,~~($_.i/2))*72;if(_1X>$_.y||$f(_1X+$g($_.bhs,~~($_.i/2))*72)<$_.y){for(var _1g=0,_1h=$i($g($_.sbs,$_.i));_1g<_1h;_1g++){$k[$j++]=0}}else{for(var _1l=0,_1m=$i($g($_.sbs,$_.i));_1l<_1m;_1l++){$k[$j++]=1}}}else{for(var _1q=0,_1r=$i($g($_.sbs,$_.i));_1q<_1r;_1q++){$k[$j++]=0}}}if($_.diff<0){$k[$j++]=0}}$_.pixs=$a();$_.pixy=~~($_.pixs.length/$_.pixx);var _22=new Map([["ren","renmatrix"],["pixs",$_.pixs],["pixx",$_.pixx],["pixy",$_.pixy],["height",$_.pixy/72],["width",$_.pixx/72],["opt",$_.options]]);$k[$j++]=_22;if(!$_.dontdraw){$$.save();bwipp_renmatrix();$$.restore()}}$_=$__}function bwipp_ean8composite(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.usematrix=false;$_.parse=false;$_.dontlint=false;$_.lintreqs=true;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.dontdraw){$_.usematrix=true}$X($_.barcode,"|");if($k[--$j]){$_.linear=$k[--$j];$j--;$_.comp=$k[--$j]}else{$j--;$k[$j++]="bwipp.missingCompositeComponent#29664";$k[$j++]="A Composite Component must be provided following a pipe character";bwipp_raiseerror()}$p($_.options,"lintype","ean8");$p($_.options,"inkspreadv",0);$p($_.options,"dontdraw",true);$p($_.options,"dontlint",true);var _C=$s($_.comp.length+18);$P(_C,0,"(01)00000000000000");$P(_C,18,$_.comp);$k[$j++]=_C;$k[$j++]="ai";bwipp_gs1process();$j-=3;$k[$j++]=$_.linear;$k[$j++]=$_.options;bwipp_ean8();if(!$_.usematrix){$$.save();bwipp_renlinear();var _H=$$.currpos();$k[$j++]=_H.x;$k[$j++]=_H.y;$k[$j++]=$_.comp;$k[$j++]=$_.options;bwipp_gs1_cc();var _K=$k[--$j];$$.rmoveto(70-$g(_K,"pixx"),78);$k[$j++]=_K;bwipp_renmatrix();var _M=$k[--$j];$$.moveto($k[--$j]-1,_M+72);$k[$j++]=Infinity;$k[$j++]=Infinity;$k[$j++]=0;$k[$j++]=1;for(var _O=0;_O<65;_O++){$k[$j++]=0}$k[$j++]=1;$k[$j++]=0;$k[$j++]=1;$k[$j++]=0;for(var _P=0;_P<65;_P++){$k[$j++]=0}$k[$j++]=0;$k[$j++]=1;$k[$j++]=0;$k[$j++]=1;for(var _Q=0;_Q<65;_Q++){$k[$j++]=0}$k[$j++]=1;$k[$j++]=0;var _R=$a();$k[$j++]="ren";$k[$j++]="renmatrix";$k[$j++]="pixs";$k[$j++]=_R;$k[$j++]="pixx";$k[$j++]=69;$k[$j++]="pixy";$k[$j++]=3;$k[$j++]="height";$k[$j++]=6/72;$k[$j++]="width";$k[$j++]=69/72;$k[$j++]="opt";$k[$j++]=$_.options;var _T=$d();$k[$j++]=_T;bwipp_renmatrix();$$.restore()}else{$_.linsym=$k[--$j];$_.sbs=$g($_.linsym,"sbs");$_.bhs=$g($_.linsym,"bhs");$_.bbs=$g($_.linsym,"bbs");$k[$j++]="linwidth";$k[$j++]=0;$F($_.sbs,function(){var _c=$k[--$j];var _d=$k[--$j];$k[$j++]=$f(_d+$i(_c))});var _e=$k[--$j];$_[$k[--$j]]=_e;var _g=$_.comp;$k[$j++]="compsym";$k[$j++]=_g;$k[$j++]=$_.options;bwipp_gs1_cc();var _i=$k[--$j];$_[$k[--$j]]=_i;$_.ccpixs=$g($_.compsym,"pixs");$_.ccpixx=$g($_.compsym,"pixx");$k[$j++]=Infinity;for(var _p=0,_q=$_.ccpixx-69;_p<_q;_p++){$k[$j++]=0}$_.linpad=$a();$_.diff=$f($_.linwidth+$_.linpad.length+1-$_.ccpixx);if($_.diff>0){$k[$j++]=Infinity;for(var _x=0,_y=$_.diff;_x<_y;_x++){$k[$j++]=0}$_.ccrpad=$a();$_.pixx=$f($_.ccpixx+$_.diff)}else{$_.ccrpad=$a(0);$_.pixx=$_.ccpixx}$k[$j++]=Infinity;for(var _17=0,_18=$_.ccpixx,_16=$_.ccpixs.length-1;_18<0?_17>=_16:_17<=_16;_17+=_18){$_.i=_17;$q($G($_.ccpixs,$_.i,$_.ccpixx));$q($_.ccrpad)}for(var _1E=0;_1E<2;_1E++){$q($_.linpad);$k[$j++]=0;$k[$j++]=1;for(var _1G=0;_1G<65;_1G++){$k[$j++]=0}$k[$j++]=1;$k[$j++]=0;$q($_.ccrpad)}for(var _1I=0;_1I<2;_1I++){$q($_.linpad);$k[$j++]=1;$k[$j++]=0;for(var _1K=0;_1K<65;_1K++){$k[$j++]=0}$k[$j++]=0;$k[$j++]=1;$q($_.ccrpad)}for(var _1M=0;_1M<2;_1M++){$q($_.linpad);$k[$j++]=0;$k[$j++]=1;for(var _1O=0;_1O<65;_1O++){$k[$j++]=0}$k[$j++]=1;$k[$j++]=0;$q($_.ccrpad)}for(var _1Q=71;_1Q>=0;_1Q-=1){$_.y=_1Q;$q($_.linpad);$k[$j++]=0;for(var _1U=0,_1T=$_.sbs.length-1;_1U<=_1T;_1U+=1){$_.i=_1U;if($_.i%2==0){var _1Z=$g($_.bbs,~~($_.i/2))*72;if(_1Z>$_.y||$f(_1Z+$g($_.bhs,~~($_.i/2))*72)<$_.y){for(var _1i=0,_1j=$i($g($_.sbs,$_.i));_1i<_1j;_1i++){$k[$j++]=0}}else{for(var _1n=0,_1o=$i($g($_.sbs,$_.i));_1n<_1o;_1n++){$k[$j++]=1}}}else{for(var _1s=0,_1t=$i($g($_.sbs,$_.i));_1s<_1t;_1s++){$k[$j++]=0}}}if($_.diff<0){$k[$j++]=0}}$_.pixs=$a();$_.pixy=~~($_.pixs.length/$_.pixx);var _24=new Map([["ren","renmatrix"],["pixs",$_.pixs],["pixx",$_.pixx],["pixy",$_.pixy],["height",$_.pixy/72],["width",$_.pixx/72],["opt",$_.options]]);$k[$j++]=_24;if(!$_.dontdraw){$$.save();bwipp_renmatrix();$$.restore()}}$_=$__}function bwipp_upcacomposite(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.usematrix=false;$_.parse=false;$_.dontlint=false;$_.lintreqs=true;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.dontdraw){$_.usematrix=true}$X($_.barcode,"|");if($k[--$j]){$_.linear=$k[--$j];$j--;$_.comp=$k[--$j]}else{$j--;$k[$j++]="bwipp.missingCompositeComponent#29830";$k[$j++]="A Composite Component must be provided following a pipe character";bwipp_raiseerror()}$p($_.options,"lintype","ean13");$p($_.options,"inkspreadv",0);$p($_.options,"dontdraw",true);$p($_.options,"dontlint",true);var _C=$s($_.comp.length+18);$P(_C,0,"(01)00000000000000");$P(_C,18,$_.comp);$k[$j++]=_C;$k[$j++]="ai";bwipp_gs1process();$j-=3;$k[$j++]=$_.linear;$k[$j++]=$_.options;bwipp_upca();if(!$_.usematrix){$$.save();bwipp_renlinear();var _H=$$.currpos();$$.rmoveto(-3,78);$k[$j++]=_H.x;$k[$j++]=_H.y;$k[$j++]=$_.comp;$k[$j++]=$_.options;bwipp_gs1_cc();bwipp_renmatrix();var _K=$k[--$j];$$.moveto($k[--$j]-1,_K+72);$k[$j++]=Infinity;$k[$j++]=Infinity;$k[$j++]=0;$k[$j++]=1;for(var _M=0;_M<93;_M++){$k[$j++]=0}$k[$j++]=1;$k[$j++]=0;$k[$j++]=1;$k[$j++]=0;for(var _N=0;_N<93;_N++){$k[$j++]=0}$k[$j++]=0;$k[$j++]=1;$k[$j++]=0;$k[$j++]=1;for(var _O=0;_O<93;_O++){$k[$j++]=0}$k[$j++]=1;$k[$j++]=0;var _P=$a();$k[$j++]="ren";$k[$j++]="renmatrix";$k[$j++]="pixs";$k[$j++]=_P;$k[$j++]="pixx";$k[$j++]=97;$k[$j++]="pixy";$k[$j++]=3;$k[$j++]="height";$k[$j++]=6/72;$k[$j++]="width";$k[$j++]=97/72;$k[$j++]="opt";$k[$j++]=$_.options;var _R=$d();$k[$j++]=_R;bwipp_renmatrix();$$.restore()}else{$_.linsym=$k[--$j];$_.sbs=$g($_.linsym,"sbs");$_.bhs=$g($_.linsym,"bhs");$_.bbs=$g($_.linsym,"bbs");$k[$j++]="linwidth";$k[$j++]=0;$F($_.sbs,function(){var _a=$k[--$j];var _b=$k[--$j];$k[$j++]=$f(_b+$i(_a))});var _c=$k[--$j];$_[$k[--$j]]=_c;$k[$j++]="compsym";$k[$j++]=$_.comp;$k[$j++]=$_.options;bwipp_gs1_cc();var _g=$k[--$j];$_[$k[--$j]]=_g;$_.ccpixs=$g($_.compsym,"pixs");$_.ccpixx=$g($_.compsym,"pixx");$k[$j++]=Infinity;for(var _n=0,_o=$_.ccpixx-97;_n<_o;_n++){$k[$j++]=0}$_.linpad=$a();$_.diff=$f($_.linwidth+$_.linpad.length+1-$_.ccpixx);if($_.diff>0){$k[$j++]=Infinity;for(var _v=0,_w=$_.diff;_v<_w;_v++){$k[$j++]=0}$_.ccrpad=$a();$_.pixx=$f($_.ccpixx+$_.diff)}else{$_.ccrpad=$a(0);$_.pixx=$_.ccpixx}$k[$j++]=Infinity;for(var _15=0,_16=$_.ccpixx,_14=$_.ccpixs.length-1;_16<0?_15>=_14:_15<=_14;_15+=_16){$_.i=_15;$q($G($_.ccpixs,$_.i,$_.ccpixx));$q($_.ccrpad)}for(var _1C=0;_1C<2;_1C++){$q($_.linpad);$k[$j++]=0;$k[$j++]=1;for(var _1E=0;_1E<93;_1E++){$k[$j++]=0}$k[$j++]=1;$k[$j++]=0;$q($_.ccrpad)}for(var _1G=0;_1G<2;_1G++){$q($_.linpad);$k[$j++]=1;$k[$j++]=0;for(var _1I=0;_1I<93;_1I++){$k[$j++]=0}$k[$j++]=0;$k[$j++]=1;$q($_.ccrpad)}for(var _1K=0;_1K<2;_1K++){$q($_.linpad);$k[$j++]=0;$k[$j++]=1;for(var _1M=0;_1M<93;_1M++){$k[$j++]=0}$k[$j++]=1;$k[$j++]=0;$q($_.ccrpad)}for(var _1O=71;_1O>=0;_1O-=1){$_.y=_1O;$q($_.linpad);$k[$j++]=0;for(var _1S=0,_1R=$_.sbs.length-1;_1S<=_1R;_1S+=1){$_.i=_1S;if($_.i%2==0){var _1X=$g($_.bbs,~~($_.i/2))*72;if(_1X>$_.y||$f(_1X+$g($_.bhs,~~($_.i/2))*72)<$_.y){for(var _1g=0,_1h=$i($g($_.sbs,$_.i));_1g<_1h;_1g++){$k[$j++]=0}}else{for(var _1l=0,_1m=$i($g($_.sbs,$_.i));_1l<_1m;_1l++){$k[$j++]=1}}}else{for(var _1q=0,_1r=$i($g($_.sbs,$_.i));_1q<_1r;_1q++){$k[$j++]=0}}}if($_.diff<0){$k[$j++]=0}}$_.pixs=$a();$_.pixy=~~($_.pixs.length/$_.pixx);var _22=new Map([["ren","renmatrix"],["pixs",$_.pixs],["pixx",$_.pixx],["pixy",$_.pixy],["height",$_.pixy/72],["width",$_.pixx/72],["opt",$_.options]]);$k[$j++]=_22;if(!$_.dontdraw){$$.save();bwipp_renmatrix();$$.restore()}}$_=$__}function bwipp_upcecomposite(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.usematrix=false;$_.parse=false;$_.dontlint=false;$_.lintreqs=true;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.dontdraw){$_.usematrix=true}$X($_.barcode,"|");if($k[--$j]){$_.linear=$k[--$j];$j--;$_.comp=$k[--$j]}else{$j--;$k[$j++]="bwipp.missingCompositeComponent#29993";$k[$j++]="A Composite Component must be provided following a pipe character";bwipp_raiseerror()}$p($_.options,"lintype","upce");$p($_.options,"inkspreadv",0);$p($_.options,"dontdraw",true);$p($_.options,"dontlint",true);var _C=$s($_.comp.length+18);$P(_C,0,"(01)00000000000000");$P(_C,18,$_.comp);$k[$j++]=_C;$k[$j++]="ai";bwipp_gs1process();$j-=3;$k[$j++]=$_.linear;$k[$j++]=$_.options;bwipp_upce();if(!$_.usematrix){$$.save();bwipp_renlinear();var _H=$$.currpos();$$.rmoveto(-3,78);$k[$j++]=_H.x;$k[$j++]=_H.y;$k[$j++]=$_.comp;$k[$j++]=$_.options;bwipp_gs1_cc();bwipp_renmatrix();var _K=$k[--$j];$$.moveto($k[--$j]-1,_K+72);$k[$j++]=Infinity;$k[$j++]=Infinity;$k[$j++]=0;$k[$j++]=1;for(var _M=0;_M<49;_M++){$k[$j++]=0}$k[$j++]=1;$k[$j++]=0;$k[$j++]=1;$k[$j++]=0;for(var _N=0;_N<49;_N++){$k[$j++]=0}$k[$j++]=0;$k[$j++]=1;$k[$j++]=0;$k[$j++]=1;for(var _O=0;_O<49;_O++){$k[$j++]=0}$k[$j++]=1;$k[$j++]=0;var _P=$a();$k[$j++]="ren";$k[$j++]="renmatrix";$k[$j++]="pixs";$k[$j++]=_P;$k[$j++]="pixx";$k[$j++]=53;$k[$j++]="pixy";$k[$j++]=3;$k[$j++]="height";$k[$j++]=6/72;$k[$j++]="width";$k[$j++]=53/72;$k[$j++]="opt";$k[$j++]=$_.options;var _R=$d();$k[$j++]=_R;bwipp_renmatrix();$$.restore()}else{$_.linsym=$k[--$j];$_.sbs=$g($_.linsym,"sbs");$_.bhs=$g($_.linsym,"bhs");$_.bbs=$g($_.linsym,"bbs");$k[$j++]="linwidth";$k[$j++]=0;$F($_.sbs,function(){var _a=$k[--$j];var _b=$k[--$j];$k[$j++]=$f(_b+$i(_a))});var _c=$k[--$j];$_[$k[--$j]]=_c;$k[$j++]="compsym";$k[$j++]=$_.comp;$k[$j++]=$_.options;bwipp_gs1_cc();var _g=$k[--$j];$_[$k[--$j]]=_g;$_.ccpixs=$g($_.compsym,"pixs");$_.ccpixx=$g($_.compsym,"pixx");$k[$j++]=Infinity;for(var _n=0,_o=$_.ccpixx-53;_n<_o;_n++){$k[$j++]=0}$_.linpad=$a();$_.diff=$f($_.linwidth+$_.linpad.length+1-$_.ccpixx);if($_.diff>0){$k[$j++]=Infinity;for(var _v=0,_w=$_.diff;_v<_w;_v++){$k[$j++]=0}$_.ccrpad=$a();$_.pixx=$f($_.ccpixx+$_.diff)}else{$_.ccrpad=$a(0);$_.pixx=$_.ccpixx}$k[$j++]=Infinity;for(var _15=0,_16=$_.ccpixx,_14=$_.ccpixs.length-1;_16<0?_15>=_14:_15<=_14;_15+=_16){$_.i=_15;$q($G($_.ccpixs,$_.i,$_.ccpixx));$q($_.ccrpad)}for(var _1C=0;_1C<2;_1C++){$q($_.linpad);$k[$j++]=0;$k[$j++]=1;for(var _1E=0;_1E<49;_1E++){$k[$j++]=0}$k[$j++]=1;$k[$j++]=0;$q($_.ccrpad)}for(var _1G=0;_1G<2;_1G++){$q($_.linpad);$k[$j++]=1;$k[$j++]=0;for(var _1I=0;_1I<49;_1I++){$k[$j++]=0}$k[$j++]=0;$k[$j++]=1;$q($_.ccrpad)}for(var _1K=0;_1K<2;_1K++){$q($_.linpad);$k[$j++]=0;$k[$j++]=1;for(var _1M=0;_1M<49;_1M++){$k[$j++]=0}$k[$j++]=1;$k[$j++]=0;$q($_.ccrpad)}for(var _1O=71;_1O>=0;_1O-=1){$_.y=_1O;$q($_.linpad);$k[$j++]=0;for(var _1S=0,_1R=$_.sbs.length-1;_1S<=_1R;_1S+=1){$_.i=_1S;if($_.i%2==0){var _1X=$g($_.bbs,~~($_.i/2))*72;if(_1X>$_.y||$f(_1X+$g($_.bhs,~~($_.i/2))*72)<$_.y){for(var _1g=0,_1h=$i($g($_.sbs,$_.i));_1g<_1h;_1g++){$k[$j++]=0}}else{for(var _1l=0,_1m=$i($g($_.sbs,$_.i));_1l<_1m;_1l++){$k[$j++]=1}}}else{for(var _1q=0,_1r=$i($g($_.sbs,$_.i));_1q<_1r;_1q++){$k[$j++]=0}}}if($_.diff<0){$k[$j++]=0}}$_.pixs=$a();$_.pixy=~~($_.pixs.length/$_.pixx);var _22=new Map([["ren","renmatrix"],["pixs",$_.pixs],["pixx",$_.pixx],["pixy",$_.pixy],["height",$_.pixy/72],["width",$_.pixx/72],["opt",$_.options]]);$k[$j++]=_22;if(!$_.dontdraw){$$.save();bwipp_renmatrix();$$.restore()}}$_=$__}function bwipp_databaromnicomposite(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.usematrix=false;$_.parse=false;$_.dontlint=false;$_.lintreqs=true;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.dontdraw){$_.usematrix=true}$X($_.barcode,"|");if($k[--$j]){$_.linear=$k[--$j];$j--;$_.comp=$k[--$j]}else{$j--;$k[$j++]="bwipp.missingCompositeComponent#30156";$k[$j++]="A Composite Component must be provided following a pipe character";bwipp_raiseerror()}if(!$_.usematrix){$$.save()}$p($_.options,"lintype","databaromni");$p($_.options,"linkage",true);$p($_.options,"inkspreadv",0);$p($_.options,"dontdraw",true);$p($_.options,"dontlint",true);var _F=$s($_.linear.length+$_.comp.length);$P(_F,0,$_.linear);$P(_F,$_.linear.length,$_.comp);$k[$j++]=_F;$k[$j++]="ai";bwipp_gs1process();$j-=3;$k[$j++]=$_.linear;$k[$j++]=$_.options;bwipp_databaromni();var _L=$k[--$j];$_.linsbs=$g(_L,"sbs");$_.linheight=$g($g(_L,"bhs"),0)*72;$k[$j++]=_L;if(!$_.usematrix){bwipp_renlinear()}else{$j--}$_.sepfinder=function(){$_.fp=$k[--$j];for(var _U=$_.fp,_T=$_.fp+12;_U<=_T;_U+=1){$_.i=_U;if($g($_.bot,$_.i)==0){if($g($_.bot,$_.i-1)==1){$k[$j++]=1}else{var _e=$g($_.sep,$_.i-1)==0?1:0;$k[$j++]=_e}}else{$k[$j++]=0}$p($_.sep,$_.i,$k[--$j])}$_.f3=$a([1,1,1,1,1,1,1,1,1,0,1,1,1]);$k[$j++]=true;for(var _j=0;_j<=12;_j+=1){var _p=$k[--$j];$k[$j++]=_p&&$eq($g($_.bot,$f(_j+$_.fp)),$g($_.f3,_j))}if($k[--$j]){$P($_.sep,$_.fp,$a([0,0,0,0,0,0,0,0,0,0,1,0,0]))}};$k[$j++]=Infinity;$k[$j++]=0;$F($_.linsbs,function(){var _v=$k[--$j];var _w=$k[$j-1];var _x=_w==1?0:1;for(var _y=0,_z=_v;_y<_z;_y++){$k[$j++]=_x}});$as($a($m()-1));$_.bot=$k[--$j];$j-=2;$k[$j++]=Infinity;$F($_.bot,function(){var _14=$k[--$j];$k[$j++]=1-_14});$_.sep=$a();$P($_.sep,0,$a([0,0,0]));$P($_.sep,$_.sep.length-4,$a([0,0,0,0]));$k[$j++]=18;$_.sepfinder();$k[$j++]=64;$_.sepfinder();if(!$_.usematrix){var _1C=$$.currpos();$$.rmoveto(-5,$_.linheight+1);$k[$j++]=_1C.x;$k[$j++]=_1C.y;$k[$j++]=$_.comp;$k[$j++]=$_.options;bwipp_gs1_cc();bwipp_renmatrix();var _1H=$k[--$j];$$.moveto($k[--$j],$f(_1H+$_.linheight));var _1N=new Map([["ren","renmatrix"],["pixs",$_.sep],["pixx",$_.sep.length],["pixy",1],["height",1/72],["width",$_.sep.length/72],["opt",$_.options]]);$k[$j++]=_1N;bwipp_renmatrix();$$.restore()}else{$k[$j++]="compsym";$k[$j++]=$_.comp;$k[$j++]=$_.options;bwipp_gs1_cc();var _1Q=$k[--$j];$_[$k[--$j]]=_1Q;$_.ccpixs=$g($_.compsym,"pixs");$_.ccpixx=$g($_.compsym,"pixx");$k[$j++]=Infinity;$k[$j++]=0;$F($_.linsbs,function(){var _1X=$k[--$j];var _1Y=$k[$j-1];var _1Z=_1Y==0?1:0;for(var _1a=0,_1b=$i(_1X);_1a<_1b;_1a++){$k[$j++]=_1Z}});$_.linpixs=$a();$k[$j++]=Infinity;$k[$j++]=0;$q($_.sep);$_.sep=$a();$_.linheight=~~$_.linheight;$k[$j++]=Infinity;for(var _1j=0,_1k=$_.ccpixx,_1i=$_.ccpixs.length-1;_1k<0?_1j>=_1i:_1j<=_1i;_1j+=_1k){$_.i=_1j;$q($G($_.ccpixs,$_.i,$_.ccpixx));$k[$j++]=0}$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$q($_.sep);for(var _1r=0,_1s=$_.linheight;_1r<_1s;_1r++){$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$q($_.linpixs)}$_.pixs=$a();$_.pixx=$_.ccpixx+1;$_.pixy=~~($_.pixs.length/$_.pixx);var _24=new Map([["ren","renmatrix"],["pixs",$_.pixs],["pixx",$_.pixx],["pixy",$_.pixy],["height",$_.pixy/72],["width",$_.pixx/72],["opt",$_.options]]);$k[$j++]=_24;if(!$_.dontdraw){$$.save();bwipp_renmatrix();$$.restore()}}$_=$__}function bwipp_databarstackedcomposite(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.usematrix=false;$_.parse=false;$_.dontlint=false;$_.lintreqs=true;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.dontdraw){$_.usematrix=true}$X($_.barcode,"|");if($k[--$j]){$_.linear=$k[--$j];$j--;$_.comp=$k[--$j]}else{$j--;$k[$j++]="bwipp.missingCompositeComponent#30317";$k[$j++]="A Composite Component must be provided following a pipe character";bwipp_raiseerror()}if(!$_.usematrix){$$.save()}$p($_.options,"lintype","databarstacked");$p($_.options,"linkage",true);$p($_.options,"inkspreadv",0);$p($_.options,"dontdraw",true);$p($_.options,"dontlint",true);var _F=$s($_.linear.length+$_.comp.length);$P(_F,0,$_.linear);$P(_F,$_.linear.length,$_.comp);$k[$j++]=_F;$k[$j++]="ai";bwipp_gs1process();$j-=3;$k[$j++]=$_.linear;$k[$j++]=$_.options;bwipp_databarstacked();var _L=$k[--$j];$_.bot=$G($g(_L,"pixs"),0,$g(_L,"pixx"));$_.linheight=$g(_L,"pixy");$k[$j++]=_L;if(!$_.usematrix){bwipp_renmatrix()}else{$_.linpixs=$g($k[--$j],"pixs")}$_.sepfinder=function(){$_.fp=$k[--$j];for(var _X=$_.fp,_W=$_.fp+12;_X<=_W;_X+=1){$_.i=_X;if($g($_.bot,$_.i)==0){if($g($_.bot,$_.i-1)==1){$k[$j++]=1}else{var _h=$g($_.sep,$_.i-1)==0?1:0;$k[$j++]=_h}}else{$k[$j++]=0}$p($_.sep,$_.i,$k[--$j])}$_.f3=$a([1,1,1,1,1,1,1,1,1,0,1,1,1]);$k[$j++]=true;for(var _m=0;_m<=12;_m+=1){var _s=$k[--$j];$k[$j++]=_s&&$eq($g($_.bot,$f(_m+$_.fp)),$g($_.f3,_m))}if($k[--$j]){$P($_.sep,$_.fp,$a([0,0,0,0,0,0,0,0,0,0,1,0,0]))}};$k[$j++]=Infinity;var _x=$_.bot;for(var _y=0,_z=_x.length;_y<_z;_y++){$k[$j++]=1-$g(_x,_y)}$_.sep=$a();$P($_.sep,0,$a([0,0,0,0]));$P($_.sep,$_.sep.length-4,$a([0,0,0,0]));$k[$j++]=18;$_.sepfinder();if(!$_.usematrix){var _18=$$.currpos();$$.rmoveto(1,$_.linheight+1);$k[$j++]=_18.x;$k[$j++]=_18.y;$k[$j++]=$_.comp;$k[$j++]=$_.options;bwipp_gs1_cc();bwipp_renmatrix();var _1D=$k[--$j];$$.moveto($k[--$j],$f(_1D+$_.linheight));var _1J=new Map([["ren","renmatrix"],["pixs",$_.sep],["pixx",$_.sep.length],["pixy",1],["height",1/72],["width",$_.sep.length/72],["opt",$_.options]]);$k[$j++]=_1J;bwipp_renmatrix();$$.restore()}else{$k[$j++]="compsym";$k[$j++]=$_.comp;$k[$j++]=$_.options;bwipp_gs1_cc();var _1M=$k[--$j];$_[$k[--$j]]=_1M;$_.ccpixs=$g($_.compsym,"pixs");$_.ccpixx=$g($_.compsym,"pixx");$_.linwidth=$_.sep.length;$k[$j++]=Infinity;for(var _1W=0,_1X=$_.ccpixx,_1V=$_.ccpixs.length-1;_1X<0?_1W>=_1V:_1W<=_1V;_1W+=_1X){$_.i=_1W;$k[$j++]=0;$q($G($_.ccpixs,$_.i,$_.ccpixx))}$q($_.sep);$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;for(var _1g=0,_1h=$_.linwidth,_1f=$_.linpixs.length-1;_1h<0?_1g>=_1f:_1g<=_1f;_1g+=_1h){$_.i=_1g;$q($G($_.linpixs,$_.i,$_.linwidth));$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0}$_.pixs=$a();$_.pixx=$_.ccpixx+1;$_.pixy=~~($_.pixs.length/$_.pixx);var _1w=new Map([["ren","renmatrix"],["pixs",$_.pixs],["pixx",$_.pixx],["pixy",$_.pixy],["height",$_.pixy/72],["width",$_.pixx/72],["opt",$_.options]]);$k[$j++]=_1w;if(!$_.dontdraw){$$.save();bwipp_renmatrix();$$.restore()}}$_=$__}function bwipp_databarstackedomnicomposite(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.usematrix=false;$_.parse=false;$_.dontlint=false;$_.lintreqs=true;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.dontdraw){$_.usematrix=true}$X($_.barcode,"|");if($k[--$j]){$_.linear=$k[--$j];$j--;$_.comp=$k[--$j]}else{$j--;$k[$j++]="bwipp.missingCompositeComponent#30474";$k[$j++]="A Composite Component must be provided following a pipe character";bwipp_raiseerror()}if(!$_.usematrix){$$.save()}$p($_.options,"lintype","databarstackedomni");$p($_.options,"linkage",true);$p($_.options,"inkspreadv",0);$p($_.options,"dontdraw",true);$p($_.options,"dontlint",true);var _F=$s($_.linear.length+$_.comp.length);$P(_F,0,$_.linear);$P(_F,$_.linear.length,$_.comp);$k[$j++]=_F;$k[$j++]="ai";bwipp_gs1process();$j-=3;$k[$j++]=$_.linear;$k[$j++]=$_.options;bwipp_databarstackedomni();var _L=$k[--$j];$_.bot=$G($g(_L,"pixs"),0,$g(_L,"pixx"));$_.linheight=$g(_L,"pixy");$k[$j++]=_L;if(!$_.usematrix){bwipp_renmatrix()}else{$_.linpixs=$g($k[--$j],"pixs")}$_.sepfinder=function(){$_.fp=$k[--$j];for(var _X=$_.fp,_W=$_.fp+12;_X<=_W;_X+=1){$_.i=_X;if($g($_.bot,$_.i)==0){if($g($_.bot,$_.i-1)==1){$k[$j++]=1}else{var _h=$g($_.sep,$_.i-1)==0?1:0;$k[$j++]=_h}}else{$k[$j++]=0}$p($_.sep,$_.i,$k[--$j])}$_.f3=$a([1,1,1,1,1,1,1,1,1,0,1,1,1]);$k[$j++]=true;for(var _m=0;_m<=12;_m+=1){var _s=$k[--$j];$k[$j++]=_s&&$eq($g($_.bot,$f(_m+$_.fp)),$g($_.f3,_m))}if($k[--$j]){$P($_.sep,$_.fp,$a([0,0,0,0,0,0,0,0,0,0,1,0,0]))}};$k[$j++]=Infinity;var _x=$_.bot;for(var _y=0,_z=_x.length;_y<_z;_y++){$k[$j++]=1-$g(_x,_y)}$_.sep=$a();$P($_.sep,0,$a([0,0,0,0]));$P($_.sep,$_.sep.length-4,$a([0,0,0,0]));$k[$j++]=18;$_.sepfinder();if(!$_.usematrix){var _18=$$.currpos();$$.rmoveto(1,$_.linheight+1);$k[$j++]=_18.x;$k[$j++]=_18.y;$k[$j++]=$_.comp;$k[$j++]=$_.options;bwipp_gs1_cc();bwipp_renmatrix();var _1D=$k[--$j];$$.moveto($k[--$j],$f(_1D+$_.linheight));var _1J=new Map([["ren","renmatrix"],["pixs",$_.sep],["pixx",$_.sep.length],["pixy",1],["height",1/72],["width",$_.sep.length/72],["opt",$_.options]]);$k[$j++]=_1J;bwipp_renmatrix();$$.restore()}else{$k[$j++]="compsym";$k[$j++]=$_.comp;$k[$j++]=$_.options;bwipp_gs1_cc();var _1M=$k[--$j];$_[$k[--$j]]=_1M;$_.ccpixs=$g($_.compsym,"pixs");$_.ccpixx=$g($_.compsym,"pixx");$_.linwidth=$_.sep.length;$k[$j++]=Infinity;for(var _1W=0,_1X=$_.ccpixx,_1V=$_.ccpixs.length-1;_1X<0?_1W>=_1V:_1W<=_1V;_1W+=_1X){$_.i=_1W;$k[$j++]=0;$q($G($_.ccpixs,$_.i,$_.ccpixx))}$q($_.sep);$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;for(var _1g=0,_1h=$_.linwidth,_1f=$_.linpixs.length-1;_1h<0?_1g>=_1f:_1g<=_1f;_1g+=_1h){$_.i=_1g;$q($G($_.linpixs,$_.i,$_.linwidth));$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0}$_.pixs=$a();$_.pixx=$_.ccpixx+1;$_.pixy=~~($_.pixs.length/$_.pixx);var _1w=new Map([["ren","renmatrix"],["pixs",$_.pixs],["pixx",$_.pixx],["pixy",$_.pixy],["height",$_.pixy/72],["width",$_.pixx/72],["opt",$_.options]]);$k[$j++]=_1w;if(!$_.dontdraw){$$.save();bwipp_renmatrix();$$.restore()}}$_=$__}function bwipp_databartruncatedcomposite(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.usematrix=false;$_.parse=false;$_.dontlint=false;$_.lintreqs=true;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.dontdraw){$_.usematrix=true}$X($_.barcode,"|");if($k[--$j]){$_.linear=$k[--$j];$j--;$_.comp=$k[--$j]}else{$j--;$k[$j++]="bwipp.missingCompositeComponent#30632";$k[$j++]="A Composite Component must be provided following a pipe character";bwipp_raiseerror()}if(!$_.usematrix){$$.save()}$p($_.options,"lintype","databartruncated");$p($_.options,"linkage",true);$p($_.options,"inkspreadv",0);$p($_.options,"dontdraw",true);$p($_.options,"dontlint",true);var _F=$s($_.linear.length+$_.comp.length);$P(_F,0,$_.linear);$P(_F,$_.linear.length,$_.comp);$k[$j++]=_F;$k[$j++]="ai";bwipp_gs1process();$j-=3;$k[$j++]=$_.linear;$k[$j++]=$_.options;bwipp_databartruncated();var _L=$k[--$j];$_.linsbs=$g(_L,"sbs");$_.linheight=$g($g(_L,"bhs"),0)*72;$k[$j++]=_L;if(!$_.usematrix){bwipp_renlinear()}else{$j--}$_.sepfinder=function(){$_.fp=$k[--$j];for(var _U=$_.fp,_T=$_.fp+12;_U<=_T;_U+=1){$_.i=_U;if($g($_.bot,$_.i)==0){if($g($_.bot,$_.i-1)==1){$k[$j++]=1}else{var _e=$g($_.sep,$_.i-1)==0?1:0;$k[$j++]=_e}}else{$k[$j++]=0}$p($_.sep,$_.i,$k[--$j])}$_.f3=$a([1,1,1,1,1,1,1,1,1,0,1,1,1]);$k[$j++]=true;for(var _j=0;_j<=12;_j+=1){var _p=$k[--$j];$k[$j++]=_p&&$eq($g($_.bot,$f(_j+$_.fp)),$g($_.f3,_j))}if($k[--$j]){$P($_.sep,$_.fp,$a([0,0,0,0,0,0,0,0,0,0,1,0,0]))}};$k[$j++]=Infinity;$k[$j++]=0;$F($_.linsbs,function(){var _v=$k[--$j];var _w=$k[$j-1];var _x=_w==1?0:1;for(var _y=0,_z=_v;_y<_z;_y++){$k[$j++]=_x}});$as($a($m()-1));$_.bot=$k[--$j];$j-=2;$k[$j++]=Infinity;$F($_.bot,function(){var _14=$k[--$j];$k[$j++]=1-_14});$_.sep=$a();$P($_.sep,0,$a([0,0,0]));$P($_.sep,$_.sep.length-4,$a([0,0,0,0]));$k[$j++]=18;$_.sepfinder();$k[$j++]=64;$_.sepfinder();if(!$_.usematrix){var _1C=$$.currpos();$$.rmoveto(-5,$_.linheight+1);$k[$j++]=_1C.x;$k[$j++]=_1C.y;$k[$j++]=$_.comp;$k[$j++]=$_.options;bwipp_gs1_cc();bwipp_renmatrix();var _1H=$k[--$j];$$.moveto($k[--$j],$f(_1H+$_.linheight));var _1N=new Map([["ren","renmatrix"],["pixs",$_.sep],["pixx",$_.sep.length],["pixy",1],["height",1/72],["width",$_.sep.length/72],["opt",$_.options]]);$k[$j++]=_1N;bwipp_renmatrix();$$.restore()}else{$k[$j++]="compsym";$k[$j++]=$_.comp;$k[$j++]=$_.options;bwipp_gs1_cc();var _1Q=$k[--$j];$_[$k[--$j]]=_1Q;$_.ccpixs=$g($_.compsym,"pixs");$_.ccpixx=$g($_.compsym,"pixx");$k[$j++]=Infinity;$k[$j++]=0;$F($_.linsbs,function(){var _1X=$k[--$j];var _1Y=$k[$j-1];var _1Z=_1Y==0?1:0;for(var _1a=0,_1b=$i(_1X);_1a<_1b;_1a++){$k[$j++]=_1Z}});$_.linpixs=$a();$k[$j++]=Infinity;$k[$j++]=0;$q($_.sep);$_.sep=$a();$_.linheight=~~$_.linheight;$k[$j++]=Infinity;for(var _1j=0,_1k=$_.ccpixx,_1i=$_.ccpixs.length-1;_1k<0?_1j>=_1i:_1j<=_1i;_1j+=_1k){$_.i=_1j;$q($G($_.ccpixs,$_.i,$_.ccpixx));$k[$j++]=0}$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$q($_.sep);for(var _1r=0,_1s=$_.linheight;_1r<_1s;_1r++){$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$q($_.linpixs)}$_.pixs=$a();$_.pixx=$_.ccpixx+1;$_.pixy=~~($_.pixs.length/$_.pixx);var _24=new Map([["ren","renmatrix"],["pixs",$_.pixs],["pixx",$_.pixx],["pixy",$_.pixy],["height",$_.pixy/72],["width",$_.pixx/72],["opt",$_.options]]);$k[$j++]=_24;if(!$_.dontdraw){$$.save();bwipp_renmatrix();$$.restore()}}$_=$__}function bwipp_databarlimitedcomposite(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.usematrix=false;$_.parse=false;$_.dontlint=false;$_.lintreqs=true;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.dontdraw){$_.usematrix=true}$X($_.barcode,"|");if($k[--$j]){$_.linear=$k[--$j];$j--;$_.comp=$k[--$j]}else{$j--;$k[$j++]="bwipp.missingCompositeComponent#30794";$k[$j++]="A Composite Component must be provided following a pipe character";bwipp_raiseerror()}if(!$_.usematrix){$$.save()}$p($_.options,"lintype","databarlimited");$p($_.options,"linkage",true);$p($_.options,"inkspreadv",0);$p($_.options,"dontdraw",true);$p($_.options,"dontlint",true);var _F=$s($_.linear.length+$_.comp.length);$P(_F,0,$_.linear);$P(_F,$_.linear.length,$_.comp);$k[$j++]=_F;$k[$j++]="ai";bwipp_gs1process();$j-=3;$k[$j++]=$_.linear;$k[$j++]=$_.options;bwipp_databarlimited();var _L=$k[--$j];$_.linsbs=$g(_L,"sbs");$_.linheight=$g($g(_L,"bhs"),0)*72;$k[$j++]=_L;if(!$_.usematrix){bwipp_renlinear()}else{$j--}$k[$j++]=Infinity;$k[$j++]=1;$F($_.linsbs,function(){var _R=$k[--$j];var _S=$k[$j-1];var _T=_S==0?1:0;for(var _U=0,_V=_R;_U<_V;_U++){$k[$j++]=_T}});$as($a($m()-1));$_.sep=$k[--$j];$j-=2;$P($_.sep,0,$a([0,0,0]));var _c=$_.sep;$P($_.sep,_c.length-9,$a([0,0,0,0,0,0,0,0,0]));if(!$_.usematrix){var _f=$$.currpos();var _g=$_.comp;$k[$j++]=_f.x;$k[$j++]=_f.y;$k[$j++]=_g;$k[$j++]=$_.options;bwipp_gs1_cc();var _i=$k[--$j];$$.rmoveto(72-$g(_i,"pixx"),$_.linheight+1);$k[$j++]=_i;bwipp_renmatrix();var _m=$k[--$j];$$.moveto($k[--$j],$f(_m+$_.linheight));var _r=$_.options;var _s=new Map([["ren","renmatrix"],["pixs",$_.sep],["pixx",$_.sep.length],["pixy",1],["height",1/72],["width",$_.sep.length/72],["opt",_r]]);$k[$j++]=_s;bwipp_renmatrix();$$.restore()}else{$k[$j++]="compsym";$k[$j++]=$_.comp;$k[$j++]=$_.options;bwipp_gs1_cc();var _v=$k[--$j];$_[$k[--$j]]=_v;$_.ccpixs=$g($_.compsym,"pixs");$_.ccpixx=$g($_.compsym,"pixx");$k[$j++]=Infinity;$k[$j++]=0;$F($_.linsbs,function(){var _12=$k[--$j];var _13=$k[$j-1];var _14=_13==0?1:0;for(var _15=0,_16=$i(_12);_15<_16;_15++){$k[$j++]=_14}});$_.linpixs=$a();$k[$j++]=Infinity;$k[$j++]=0;$q($_.sep);$_.sep=$a();$_.linheight=~~$_.linheight;if($_.ccpixx==72){$k[$j++]=Infinity;for(var _1F=0,_1G=$_.ccpixx,_1E=$_.ccpixs.length-1;_1G<0?_1F>=_1E:_1F<=_1E;_1F+=_1G){$_.i=_1F;$k[$j++]=0;$q($G($_.ccpixs,$_.i,$_.ccpixx));$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0}$q($_.sep);for(var _1N=0,_1O=$_.linheight;_1N<_1O;_1N++){$q($_.linpixs)}$_.pixs=$a();$_.pixx=$_.linpixs.length}else{$k[$j++]=Infinity;for(var _1V=0,_1W=$_.ccpixx,_1U=$_.ccpixs.length-1;_1W<0?_1V>=_1U:_1V<=_1U;_1V+=_1W){$_.i=_1V;$q($G($_.ccpixs,$_.i,$_.ccpixx));$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0}$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$q($_.sep);for(var _1d=0,_1e=$_.linheight;_1d<_1e;_1d++){$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$k[$j++]=0;$q($_.linpixs)}$_.pixs=$a();$_.pixx=$_.ccpixx+6}$_.pixy=~~($_.pixs.length/$_.pixx);var _1q=new Map([["ren","renmatrix"],["pixs",$_.pixs],["pixx",$_.pixx],["pixy",$_.pixy],["height",$_.pixy/72],["width",$_.pixx/72],["opt",$_.options]]);$k[$j++]=_1q;if(!$_.dontdraw){$$.save();bwipp_renmatrix();$$.restore()}}$_=$__}function bwipp_databarexpandedcomposite(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.usematrix=false;$_.parse=false;$_.dontlint=false;$_.lintreqs=true;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.dontdraw){$_.usematrix=true}$X($_.barcode,"|");if($k[--$j]){$_.linear=$k[--$j];$j--;$_.comp=$k[--$j]}else{$j--;$k[$j++]="bwipp.missingCompositeComponent#30946";$k[$j++]="A Composite Component must be provided following a pipe character";bwipp_raiseerror()}if(!$_.usematrix){$$.save()}$p($_.options,"lintype","databarexpanded");$p($_.options,"linkage",true);$p($_.options,"inkspreadv",0);$p($_.options,"dontdraw",true);$p($_.options,"dontlint",true);var _F=$s($_.linear.length+$_.comp.length);$P(_F,0,$_.linear);$P(_F,$_.linear.length,$_.comp);$k[$j++]=_F;$k[$j++]="ai";bwipp_gs1process();$j-=3;$k[$j++]=$_.linear;$k[$j++]=$_.options;bwipp_databarexpanded();var _L=$k[--$j];$_.linsbs=$g(_L,"sbs");$_.linheight=$g($g(_L,"bhs"),0)*72;$k[$j++]=_L;if(!$_.usematrix){bwipp_renlinear()}else{$j--}$_.sepfinder=function(){$_.fp=$k[--$j];for(var _U=$_.fp,_T=$_.fp+12;_U<=_T;_U+=1){$_.i=_U;if($g($_.bot,$_.i)==0){if($g($_.bot,$_.i-1)==1){$k[$j++]=1}else{var _e=$g($_.sep,$_.i-1)==0?1:0;$k[$j++]=_e}}else{$k[$j++]=0}$p($_.sep,$_.i,$k[--$j])}};$k[$j++]=Infinity;$k[$j++]=0;$F($_.linsbs,function(){var _j=$k[--$j];var _k=$k[$j-1];var _l=_k==1?0:1;for(var _m=0,_n=_j;_m<_n;_m++){$k[$j++]=_l}});$as($a($m()-1));$_.bot=$k[--$j];$j-=2;$k[$j++]=Infinity;$F($_.bot,function(){var _s=$k[--$j];$k[$j++]=1-_s});$_.sep=$a();$P($_.sep,0,$a([0,0,0]));$P($_.sep,$_.sep.length-4,$a([0,0,0,0]));$k[$j++]=Infinity;for(var _11=18,_10=$_.bot.length-13;_11<=_10;_11+=98){$k[$j++]=_11}for(var _14=69,_13=$_.bot.length-13;_14<=_13;_14+=98){$k[$j++]=_14}var _15=$a();for(var _16=0,_17=_15.length;_16<_17;_16++){$k[$j++]=$g(_15,_16);$_.sepfinder()}if(!$_.usematrix){var _1A=$$.currpos();$$.rmoveto(1,$_.linheight+1);$k[$j++]=_1A.x;$k[$j++]=_1A.y;$k[$j++]=$_.comp;$k[$j++]=$_.options;bwipp_gs1_cc();bwipp_renmatrix();var _1F=$k[--$j];$$.moveto($k[--$j],$f(_1F+$_.linheight));var _1L=new Map([["ren","renmatrix"],["pixs",$_.sep],["pixx",$_.sep.length],["pixy",1],["height",1/72],["width",$_.sep.length/72],["opt",$_.options]]);$k[$j++]=_1L;bwipp_renmatrix();$$.restore()}else{$k[$j++]="compsym";$k[$j++]=$_.comp;$k[$j++]=$_.options;bwipp_gs1_cc();var _1O=$k[--$j];$_[$k[--$j]]=_1O;$_.ccpixs=$g($_.compsym,"pixs");$_.ccpixx=$g($_.compsym,"pixx");$k[$j++]=Infinity;$k[$j++]=0;$F($_.linsbs,function(){var _1V=$k[--$j];var _1W=$k[$j-1];var _1X=_1W==0?1:0;for(var _1Y=0,_1Z=$i(_1V);_1Y<_1Z;_1Y++){$k[$j++]=_1X}});$_.linpixs=$a();$k[$j++]=Infinity;$k[$j++]=0;$q($_.sep);$_.sep=$a();$_.linheight=~~$_.linheight;$_.diff=$f($_.linpixs.length-$_.ccpixx);$k[$j++]=Infinity;for(var _1h=0,_1i=$_.diff-2;_1h<_1i;_1h++){$k[$j++]=0}$_.ccrpad=$a();$k[$j++]=Infinity;for(var _1n=0,_1o=$_.ccpixx,_1m=$_.ccpixs.length-1;_1o<0?_1n>=_1m:_1n<=_1m;_1n+=_1o){$_.i=_1n;$k[$j++]=0;$k[$j++]=0;$q($G($_.ccpixs,$_.i,$_.ccpixx));$q($_.ccrpad)}$q($_.sep);for(var _1w=0,_1x=$_.linheight;_1w<_1x;_1w++){$q($_.linpixs)}$_.pixs=$a();$_.pixx=$_.linpixs.length;$_.pixy=~~($_.pixs.length/$_.pixx);var _29=new Map([["ren","renmatrix"],["pixs",$_.pixs],["pixx",$_.pixx],["pixy",$_.pixy],["height",$_.pixy/72],["width",$_.pixx/72],["opt",$_.options]]);$k[$j++]=_29;if(!$_.dontdraw){$$.save();bwipp_renmatrix();$$.restore()}}$_=$__}function bwipp_databarexpandedstackedcomposite(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.usematrix=false;$_.parse=false;$_.dontlint=false;$_.lintreqs=true;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.dontdraw){$_.usematrix=true}$X($_.barcode,"|");if($k[--$j]){$_.linear=$k[--$j];$j--;$_.comp=$k[--$j]}else{$j--;$k[$j++]="bwipp.missingCompositeComponent#31106";$k[$j++]="A Composite Component must be provided following a pipe character";bwipp_raiseerror()}if(!$_.usematrix){$$.save()}$p($_.options,"lintype","databarexpandedstacked");$p($_.options,"linkage",true);$p($_.options,"inkspreadv",0);$p($_.options,"dontdraw",true);$p($_.options,"dontlint",true);var _F=$s($_.linear.length+$_.comp.length);$P(_F,0,$_.linear);$P(_F,$_.linear.length,$_.comp);$k[$j++]=_F;$k[$j++]="ai";bwipp_gs1process();$j-=3;$k[$j++]=$_.linear;$k[$j++]=$_.options;bwipp_databarexpandedstacked();var _L=$k[--$j];$_.bot=$G($g(_L,"pixs"),0,$g(_L,"pixx"));$_.linheight=$g(_L,"pixy");$k[$j++]=_L;if(!$_.usematrix){bwipp_renmatrix()}else{$_.linpixs=$g($k[--$j],"pixs")}$_.sepfinder=function(){$_.fp=$k[--$j];for(var _X=$_.fp,_W=$_.fp+12;_X<=_W;_X+=1){$_.i=_X;if($g($_.bot,$_.i)==0){if($g($_.bot,$_.i-1)==1){$k[$j++]=1}else{var _h=$g($_.sep,$_.i-1)==0?1:0;$k[$j++]=_h}}else{$k[$j++]=0}$p($_.sep,$_.i,$k[--$j])}};$k[$j++]=Infinity;var _l=$_.bot;for(var _m=0,_n=_l.length;_m<_n;_m++){$k[$j++]=1-$g(_l,_m)}$_.sep=$a();$P($_.sep,0,$a([0,0,0,0]));$P($_.sep,$_.sep.length-4,$a([0,0,0,0]));$k[$j++]=Infinity;for(var _x=19,_w=$_.bot.length-13;_x<=_w;_x+=98){$k[$j++]=_x}for(var _10=70,_z=$_.bot.length-13;_10<=_z;_10+=98){$k[$j++]=_10}var _11=$a();for(var _12=0,_13=_11.length;_12<_13;_12++){$k[$j++]=$g(_11,_12);$_.sepfinder()}if(!$_.usematrix){var _16=$$.currpos();var _19=$g($_.bot,0)==0?2:0;$$.rmoveto(_19,$_.linheight+1);$k[$j++]=_16.x;$k[$j++]=_16.y;$k[$j++]=$_.comp;$k[$j++]=$_.options;bwipp_gs1_cc();bwipp_renmatrix();var _1E=$k[--$j];$$.moveto($k[--$j],$f(_1E+$_.linheight));var _1K=new Map([["ren","renmatrix"],["pixs",$_.sep],["pixx",$_.sep.length],["pixy",1],["height",1/72],["width",$_.sep.length/72],["opt",$_.options]]);$k[$j++]=_1K;bwipp_renmatrix();$$.restore()}else{$k[$j++]="compsym";$k[$j++]=$_.comp;$k[$j++]=$_.options;bwipp_gs1_cc();var _1N=$k[--$j];$_[$k[--$j]]=_1N;$_.ccpixs=$g($_.compsym,"pixs");$_.ccpixx=$g($_.compsym,"pixx");$_.pixx=$_.sep.length;$k[$j++]=Infinity;for(var _1W=0,_1X=~~(($f($_.pixx-$_.ccpixx)+1)/2);_1W<_1X;_1W++){$k[$j++]=0}$_.cclpad=$a();$k[$j++]=Infinity;for(var _1b=0,_1c=~~($f($_.pixx-$_.ccpixx)/2);_1b<_1c;_1b++){$k[$j++]=0}$_.ccrpad=$a();$k[$j++]=Infinity;for(var _1h=0,_1i=$_.ccpixx,_1g=$_.ccpixs.length-1;_1i<0?_1h>=_1g:_1h<=_1g;_1h+=_1i){$_.i=_1h;$q($_.cclpad);$q($G($_.ccpixs,$_.i,$_.ccpixx));$q($_.ccrpad)}$q($_.sep);$q($_.linpixs);$_.pixs=$a();$_.pixy=~~($_.pixs.length/$_.pixx);var _20=new Map([["ren","renmatrix"],["pixs",$_.pixs],["pixx",$_.pixx],["pixy",$_.pixy],["height",$_.pixy/72],["width",$_.pixx/72],["opt",$_.options]]);$k[$j++]=_20;if(!$_.dontdraw){$$.save();bwipp_renmatrix();$$.restore()}}$_=$__}function bwipp_gs1_128composite(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.usematrix=false;$_.parse=false;$_.dontlint=false;$_.lintreqs=true;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.dontdraw){$_.usematrix=true}$X($_.barcode,"|");if($k[--$j]){$_.linear=$k[--$j];$j--;$_.comp=$k[--$j]}else{$j--;$k[$j++]="bwipp.missingCompositeComponent#31259";$k[$j++]="A Composite Component must be provided following a pipe character";bwipp_raiseerror()}if(!$_.usematrix){$$.save()}$p($_.options,"inkspreadv",0);$p($_.options,"dontdraw",true);$p($_.options,"dontlint",true);var _D=$s($_.linear.length+$_.comp.length);$P(_D,0,$_.linear);$P(_D,$_.linear.length,$_.comp);$k[$j++]=_D;$k[$j++]="ai";bwipp_gs1process();$j-=3;$p($_.options,"linkagea",true);$k[$j++]=$_.linear;$k[$j++]=Infinity;$F($_.options);var _K=$d();$k[$j++]=_K;bwipp_gs1_128();var _M=$g($k[--$j],"sbs");$k[$j++]=0;$F(_M,function(){var _N=$k[--$j];var _O=$k[--$j];$k[$j++]=$f(_O+_N)});$_.linwidth=$k[--$j];$p($_.options,"lintype","gs1-128");$p($_.options,"linwidth",$_.linwidth);$k[$j++]=$_.comp;$k[$j++]=Infinity;$F($_.options);var _V=$d();$k[$j++]=_V;bwipp_gs1_cc();$_.compsym=$k[--$j];if($g($_.compsym,"pixx")==99){$k[$j++]="a"}else{$k[$j++]="c"}$_.linktype=$k[--$j];$p($_.compsym,"borderbottom",0);if($eq($_.linktype,"a")){$p($_.options,"linkagea",true);$p($_.options,"linkagec",false)}else{$p($_.options,"linkagea",false);$p($_.options,"linkagec",true)}var _g=$_.linear;$k[$j++]=_g;$k[$j++]=Infinity;$F($_.options);var _i=$d();$k[$j++]=_i;bwipp_gs1_128();var _j=$k[--$j];$_.linsbs=$g(_j,"sbs");$_.linheight=$g($g(_j,"bhs"),0)*72;$k[$j++]=_j;if(!$_.usematrix){bwipp_renlinear()}else{$j--}$k[$j++]=Infinity;$k[$j++]=1;$F($_.linsbs,function(){var _p=$k[--$j];var _q=$k[$j-1];var _r=_q==0?1:0;for(var _s=0,_t=_p;_s<_t;_s++){$k[$j++]=_r}});$as($a($m()-1));$_.sep=$k[--$j];$j-=2;if($eq($_.linktype,"a")){$_.s=~~(($_.linwidth-2)/11);$_.p=~~(($_.s-9)/2);$k[$j++]="x";$k[$j++]=($_.s-$_.p-1)*11+10;if($_.p==0){var _13=$k[--$j];$k[$j++]=_13+2}var _14=$k[--$j];$_[$k[--$j]]=_14-99}else{$_.x=-7}if(!$_.usematrix){var _17=$$.currpos();$$.rmoveto($_.x,$_.linheight+1);$k[$j++]=_17.x;$k[$j++]=_17.y;$k[$j++]=$_.compsym;bwipp_renmatrix();var _1C=$k[--$j];$$.moveto($k[--$j],$f(_1C+$_.linheight));var _1I=new Map([["ren","renmatrix"],["pixs",$_.sep],["pixx",$_.sep.length],["pixy",1],["height",1/72],["width",$_.sep.length/72],["opt",$_.options]]);$k[$j++]=_1I;bwipp_renmatrix();$$.restore()}else{$_.ccpixs=$g($_.compsym,"pixs");$_.ccpixx=$g($_.compsym,"pixx");$k[$j++]=Infinity;$F($_.linsbs,function(){var _1O=$k[--$j];var _1P=$k[$j-1];var _1Q=_1P==1?0:1;for(var _1R=0,_1S=_1O;_1R<_1S;_1R++){$k[$j++]=_1Q}});$_.linpixs=$a();if($_.x>0){$k[$j++]=Infinity;for(var _1W=0,_1X=$_.x;_1W<_1X;_1W++){$k[$j++]=0}$_.cclpad=$a();$_.linlpad=$a(0)}else{$_.cclpad=$a(0);$k[$j++]=Infinity;for(var _1c=0,_1d=-$_.x;_1c<_1d;_1c++){$k[$j++]=0}$_.linlpad=$a()}$_.diff=$f($_.linwidth-($_.ccpixx+$_.x));if($_.diff>0){$k[$j++]=Infinity;for(var _1k=0,_1l=$_.diff;_1k<_1l;_1k++){$k[$j++]=0}$_.ccrpad=$a();$_.linrpad=$a(0)}else{$_.ccrpad=$a(0);$k[$j++]=Infinity;for(var _1q=0,_1r=-$_.diff;_1q<_1r;_1q++){$k[$j++]=0}$_.linrpad=$a()}$_.linheight=~~$_.linheight;$k[$j++]=Infinity;for(var _1x=0,_1y=$_.ccpixx,_1w=$_.ccpixs.length-1;_1y<0?_1x>=_1w:_1x<=_1w;_1x+=_1y){$_.i=_1x;$q($_.cclpad);$q($G($_.ccpixs,$_.i,$_.ccpixx));$q($_.ccrpad)}$q($_.linlpad);$q($_.sep);$q($_.linrpad);for(var _29=0,_2A=$_.linheight;_29<_2A;_29++){$q($_.linlpad);$q($_.linpixs);$q($_.linrpad)}$_.pixs=$a();$_.pixx=$f($_.cclpad.length+$_.ccpixx+$_.ccrpad.length);$_.pixy=~~($_.pixs.length/$_.pixx);var _2Q=new Map([["ren","renmatrix"],["pixs",$_.pixs],["pixx",$_.pixx],["pixy",$_.pixy],["height",$_.pixy/72],["width",$_.pixx/72],["opt",$_.options]]);$k[$j++]=_2Q;if(!$_.dontdraw){$$.save();bwipp_renmatrix();$$.restore()}}$_=$__}function bwipp_gs1datamatrix(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.parse=false;$_.dontlint=false;$_.lintreqs=true;$_.gssep=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];$k[$j++]=$_.barcode;$k[$j++]="ai";bwipp_gs1process();$_.fncs=$k[--$j];$_.vals=$k[--$j];$_.ais=$k[--$j];$_.fnc1=-1;$_.dmtx=$a([$_.fnc1]);for(var _A=0,_9=$_.ais.length-1;_A<=_9;_A+=1){$_.i=_A;$_.ai=$g($_.ais,$_.i);$_.val=$g($_.vals,$_.i);var _K=$a($_.dmtx.length+$_.ai.length+$_.val.length);$P(_K,0,$_.dmtx);$k[$j++]=_K;$k[$j++]=_K;$k[$j++]=$_.dmtx.length;var _O=Infinity;var _P=$_.ai;$k[$j++]=_O;$F(_P);var _Q=$a();var _R=$k[--$j];$P($k[--$j],_R,_Q);var _T=$k[$j-1];$k[$j++]=_T;$k[$j++]=$_.dmtx.length+$_.ai.length;var _X=Infinity;var _Y=$_.val;$k[$j++]=_X;$F(_Y);var _Z=$a();var _a=$k[--$j];$P($k[--$j],_a,_Z);$_.dmtx=$k[--$j];if($_.i!=$_.ais.length-1&&$g($_.fncs,$_.i)){var _j=$a($_.dmtx.length+1);$P(_j,0,$_.dmtx);$k[$j++]=_j;$k[$j++]=_j;$k[$j++]=$_.dmtx.length;if($_.gssep){$k[$j++]=29}else{$k[$j++]=$_.fnc1}var _o=$k[--$j];var _p=$k[--$j];$p($k[--$j],_p,_o);$_.dmtx=$k[--$j]}}$_.barcode=$s(($_.dmtx.length+1)*5);$_.i=0;$_.j=0;for(;;){if($_.i==$_.dmtx.length){break}var _y=$g($_.dmtx,$_.i);$k[$j++]=_y;if(_y==$_.fnc1){$j--;$P($_.barcode,$_.j,"^FNC1");$_.j=$_.j+4}else{$p($_.barcode,$_.j,$k[--$j])}$_.i=$_.i+1;$_.j=$_.j+1}$_.barcode=$G($_.barcode,0,$_.j);delete $_.options["parse"];$p($_.options,"dontdraw",true);$p($_.options,"parsefnc",true);$k[$j++]="args";$k[$j++]=$_.barcode;$k[$j++]=$_.options;bwipp_datamatrix();var _1G=$k[--$j];$_[$k[--$j]]=_1G;$p($_.args,"opt",$_.options);$k[$j++]=$_.args;if(!$_.dontdraw){bwipp_renmatrix()}$_=$__}function bwipp_gs1datamatrixrectangular(){var $__=$_;$_=Object.assign({},$_);$_.parse=false;$_.dontlint=false;$_.lintreqs=true;$_.dontdraw=false;$_.gssep=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];$k[$j++]=$_.barcode;$k[$j++]="ai";bwipp_gs1process();$_.fncs=$k[--$j];$_.vals=$k[--$j];$_.ais=$k[--$j];$_.fnc1=-1;$_.dmtx=$a([$_.fnc1]);for(var _A=0,_9=$_.ais.length-1;_A<=_9;_A+=1){$_.i=_A;$_.ai=$g($_.ais,$_.i);$_.val=$g($_.vals,$_.i);var _K=$a($_.dmtx.length+$_.ai.length+$_.val.length);$P(_K,0,$_.dmtx);$k[$j++]=_K;$k[$j++]=_K;$k[$j++]=$_.dmtx.length;var _O=Infinity;var _P=$_.ai;$k[$j++]=_O;$F(_P);var _Q=$a();var _R=$k[--$j];$P($k[--$j],_R,_Q);var _T=$k[$j-1];$k[$j++]=_T;$k[$j++]=$_.dmtx.length+$_.ai.length;var _X=Infinity;var _Y=$_.val;$k[$j++]=_X;$F(_Y);var _Z=$a();var _a=$k[--$j];$P($k[--$j],_a,_Z);$_.dmtx=$k[--$j];if($_.i!=$_.ais.length-1&&$g($_.fncs,$_.i)){var _j=$a($_.dmtx.length+1);$P(_j,0,$_.dmtx);$k[$j++]=_j;$k[$j++]=_j;$k[$j++]=$_.dmtx.length;if($_.gssep){$k[$j++]=29}else{$k[$j++]=$_.fnc1}var _o=$k[--$j];var _p=$k[--$j];$p($k[--$j],_p,_o);$_.dmtx=$k[--$j]}}$_.barcode=$s(($_.dmtx.length+1)*5);$_.i=0;$_.j=0;for(;;){if($_.i==$_.dmtx.length){break}var _y=$g($_.dmtx,$_.i);$k[$j++]=_y;if(_y==$_.fnc1){$j--;$P($_.barcode,$_.j,"^FNC1");$_.j=$_.j+4}else{$p($_.barcode,$_.j,$k[--$j])}$_.i=$_.i+1;$_.j=$_.j+1}$_.barcode=$G($_.barcode,0,$_.j);delete $_.options["parse"];$p($_.options,"dontdraw",true);$p($_.options,"parsefnc",true);$p($_.options,"format","rectangle");$k[$j++]="args";$k[$j++]=$_.barcode;$k[$j++]=$_.options;bwipp_datamatrix();var _1H=$k[--$j];$_[$k[--$j]]=_1H;$p($_.args,"opt",$_.options);$k[$j++]=$_.args;if(!$_.dontdraw){bwipp_renmatrix()}$_=$__}function bwipp_gs1dldatamatrix(){var $__=$_;$_=Object.assign({},$_);$_.parse=false;$_.dontlint=false;$_.lintreqs=true;$_.dontdraw=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];var _3=new Map([["parse",$_.parse],["parseonly",true],["parsefnc",false]]);$_.fncvals=_3;$k[$j++]="barcode";$k[$j++]=$_.barcode;$k[$j++]=$_.fncvals;bwipp_parseinput();var _6=$k[--$j];$_[$k[--$j]]=_6;$k[$j++]=$_.barcode;$k[$j++]="dl";bwipp_gs1process();$j--;$_.val=$g($k[--$j],0);$_.key=$g($k[--$j],0);$_.hri=$s($_.key.length+$_.val.length+2);$p($_.hri,0,40);$P($_.hri,1,$_.key);$p($_.hri,$_.key.length+1,41);$P($_.hri,$_.key.length+2,$_.val);delete $_.options["parse"];$p($_.options,"dontdraw",true);$k[$j++]="args";$k[$j++]=$_.barcode;$k[$j++]=$_.options;bwipp_datamatrix();var _S=$k[--$j];$_[$k[--$j]]=_S;$p($_.args,"opt",$_.options);$p($_.args,"alttext",$_.hri);$p($_.args,"textyoffset",-1);$p($_.args,"textfont","OCR-B");$p($_.args,"textsize",5);$k[$j++]=$_.args;if(!$_.dontdraw){bwipp_renmatrix()}$_=$__}function bwipp_gs1qrcode(){var $__=$_;$_=Object.assign({},$_);$_.parse=false;$_.dontlint=false;$_.lintreqs=true;$_.dontdraw=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];$k[$j++]=$_.barcode;$k[$j++]="ai";bwipp_gs1process();$_.fncs=$k[--$j];$_.vals=$k[--$j];$_.ais=$k[--$j];$_.fnc1=-1;$_.qrc=$a([$_.fnc1]);for(var _A=0,_9=$_.ais.length-1;_A<=_9;_A+=1){$_.i=_A;$_.ai=$g($_.ais,$_.i);$_.val=$g($_.vals,$_.i);var _K=$a($_.qrc.length+$_.ai.length+$_.val.length);$P(_K,0,$_.qrc);$k[$j++]=_K;$k[$j++]=_K;$k[$j++]=$_.qrc.length;var _O=Infinity;var _P=$_.ai;$k[$j++]=_O;$F(_P);var _Q=$a();var _R=$k[--$j];$P($k[--$j],_R,_Q);var _T=$k[$j-1];$k[$j++]=_T;$k[$j++]=$_.qrc.length+$_.ai.length;var _X=Infinity;var _Y=$_.val;$k[$j++]=_X;$F(_Y);var _Z=$a();var _a=$k[--$j];$P($k[--$j],_a,_Z);$_.qrc=$k[--$j];if($_.i!=$_.ais.length-1&&$g($_.fncs,$_.i)){var _j=$a($_.qrc.length+1);$P(_j,0,$_.qrc);$p(_j,$_.qrc.length,$_.fnc1);$_.qrc=_j}}$_.barcode=$s(($_.qrc.length+1)*5);$_.i=0;$_.j=0;for(;;){if($_.i==$_.qrc.length){break}var _t=$g($_.qrc,$_.i);$k[$j++]=_t;if(_t==$_.fnc1){$j--;$P($_.barcode,$_.j,"^FNC1");$_.j=$_.j+4}else{$p($_.barcode,$_.j,$k[--$j])}$_.i=$_.i+1;$_.j=$_.j+1}$_.barcode=$G($_.barcode,0,$_.j);delete $_.options["parse"];$p($_.options,"dontdraw",true);$p($_.options,"parsefnc",true);$k[$j++]="args";$k[$j++]=$_.barcode;$k[$j++]=$_.options;bwipp_qrcode();var _1B=$k[--$j];$_[$k[--$j]]=_1B;$p($_.args,"opt",$_.options);$k[$j++]=$_.args;if(!$_.dontdraw){bwipp_renmatrix()}$_=$__}function bwipp_gs1dlqrcode(){var $__=$_;$_=Object.assign({},$_);$_.parse=false;$_.dontlint=false;$_.lintreqs=true;$_.dontdraw=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];var _3=new Map([["parse",$_.parse],["parseonly",true],["parsefnc",false]]);$_.fncvals=_3;$k[$j++]="barcode";$k[$j++]=$_.barcode;$k[$j++]=$_.fncvals;bwipp_parseinput();var _6=$k[--$j];$_[$k[--$j]]=_6;$k[$j++]=$_.barcode;$k[$j++]="dl";bwipp_gs1process();$j--;$_.val=$g($k[--$j],0);$_.key=$g($k[--$j],0);$_.hri=$s($_.key.length+$_.val.length+2);$p($_.hri,0,40);$P($_.hri,1,$_.key);$p($_.hri,$_.key.length+1,41);$P($_.hri,$_.key.length+2,$_.val);delete $_.options["parse"];$p($_.options,"dontdraw",true);$k[$j++]="args";$k[$j++]=$_.barcode;$k[$j++]=$_.options;bwipp_qrcode();var _S=$k[--$j];$_[$k[--$j]]=_S;$p($_.args,"opt",$_.options);$p($_.args,"alttext",$_.hri);$p($_.args,"textyoffset",-4);$p($_.args,"textfont","OCR-B");$p($_.args,"textsize",5);$k[$j++]=$_.args;if(!$_.dontdraw){bwipp_renmatrix()}$_=$__}function bwipp_gs1dotcode(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.parse=false;$_.dontlint=false;$_.lintreqs=true;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];$k[$j++]=$_.barcode;$k[$j++]="ai";bwipp_gs1process();$_.fncs=$k[--$j];$_.vals=$k[--$j];$_.ais=$k[--$j];$_.fnc1=-1;$_.dmtx=$a([$_.fnc1]);for(var _A=0,_9=$_.ais.length-1;_A<=_9;_A+=1){$_.i=_A;$_.ai=$g($_.ais,$_.i);$_.val=$g($_.vals,$_.i);var _K=$a($_.dmtx.length+$_.ai.length+$_.val.length);$P(_K,0,$_.dmtx);$k[$j++]=_K;$k[$j++]=_K;$k[$j++]=$_.dmtx.length;var _O=Infinity;var _P=$_.ai;$k[$j++]=_O;$F(_P);var _Q=$a();var _R=$k[--$j];$P($k[--$j],_R,_Q);var _T=$k[$j-1];$k[$j++]=_T;$k[$j++]=$_.dmtx.length+$_.ai.length;var _X=Infinity;var _Y=$_.val;$k[$j++]=_X;$F(_Y);var _Z=$a();var _a=$k[--$j];$P($k[--$j],_a,_Z);$_.dmtx=$k[--$j];if($_.i!=$_.ais.length-1&&$g($_.fncs,$_.i)){var _j=$a($_.dmtx.length+1);$P(_j,0,$_.dmtx);$p(_j,$_.dmtx.length,$_.fnc1);$_.dmtx=_j}}$_.barcode=$s(($_.dmtx.length+1)*5);$_.i=0;$_.j=0;for(;;){if($_.i==$_.dmtx.length){break}var _t=$g($_.dmtx,$_.i);$k[$j++]=_t;if(_t==$_.fnc1){$j--;$P($_.barcode,$_.j,"^FNC1");$_.j=$_.j+4}else{$p($_.barcode,$_.j,$k[--$j])}$_.i=$_.i+1;$_.j=$_.j+1}$_.barcode=$G($_.barcode,0,$_.j);delete $_.options["parse"];$p($_.options,"dontdraw",true);$p($_.options,"parsefnc",true);$k[$j++]="args";$k[$j++]=$_.barcode;$k[$j++]=$_.options;bwipp_dotcode();var _1B=$k[--$j];$_[$k[--$j]]=_1B;$p($_.args,"opt",$_.options);$k[$j++]=$_.args;if(!$_.dontdraw){bwipp_renmatrix()}$_=$__}function bwipp_hibccode39(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.textfont="OCR-B";$_.textsize=10;$_.textyoffset=-8;$_.textxoffset=0;$_.validatecheck=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.barcode.length==0){$k[$j++]="bwipp.hibccode39emptyData#31945";$k[$j++]="The data must not be empty";bwipp_raiseerror()}$_.barchars="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%";$_.charvals=new Map;for(var _3=0;_3<=42;_3+=1){$p($_.charvals,$G($_.barchars,_3,1),_3)}for(var _A=0,_9=$_.barcode.length-1;_A<=_9;_A+=1){var _E=$g($_.charvals,$G($_.barcode,_A,1))!==undefined;if(!_E){$k[$j++]="bwipp.hibccode39badCharacter#31960";$k[$j++]="HIBC Code 39 must contain only digits, capital letters, spaces and the symbols -.$/+%";bwipp_raiseerror()}}$k[$j++]="barlen";$k[$j++]=$_.barcode.length;if($_.validatecheck){var _H=$k[--$j];$k[$j++]=_H-1}var _I=$k[--$j];$_[$k[--$j]]=_I;$_.checksum=41;for(var _M=0,_L=$_.barlen-1;_M<=_L;_M+=1){$_.checksum=$f($g($_.charvals,$G($_.barcode,_M,1))+$_.checksum)}$_.checksum=$_.checksum%43;if($_.validatecheck){if($g($_.barcode,$_.barlen)!=$g($_.barchars,$_.checksum)){$k[$j++]="bwipp.hibccode39badCheckDigit#31974";$k[$j++]="Incorrect HIBC Code 39 check digit provided";bwipp_raiseerror()}$_.barcode=$G($_.barcode,0,$_.barlen)}var _e=$s($_.barlen+2);$P(_e,1,$_.barcode);$_.barcode=_e;$p($_.barcode,0,43);$p($_.barcode,$_.barlen+1,$g($_.barchars,$_.checksum));$_.text=$s($_.barlen+4);$p($_.text,0,42);$P($_.text,1,$_.barcode);var _v=$g($_.barcode,$_.barlen+1);$k[$j++]=$_.text;$k[$j++]=$_.barlen+2;$k[$j++]=_v;if(_v==32){$k[$j-1]=95}var _w=$k[--$j];var _x=$k[--$j];$p($k[--$j],_x,_w);$p($_.text,$_.barlen+3,42);$p($_.options,"dontdraw",true);$p($_.options,"includecheck",false);$p($_.options,"validatecheck",false);$k[$j++]="args";$k[$j++]=$_.barcode;$k[$j++]=$_.options;bwipp_code39();var _16=$k[--$j];$_[$k[--$j]]=_16;$p($_.args,"txt",$a([$a([$_.text,$_.textxoffset,$_.textyoffset,$_.textfont,$_.textsize])]));$p($_.args,"textxalign","center");$p($_.args,"opt",$_.options);$k[$j++]=$_.args;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_hibccode128(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.textfont="OCR-B";$_.textsize=10;$_.textyoffset=-8;$_.textxoffset=0;$_.validatecheck=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.barcode.length==0){$k[$j++]="bwipp.hibccode128emptyData#32049";$k[$j++]="The data must not be empty";bwipp_raiseerror()}$_.barchars="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%";$_.charvals=new Map;for(var _3=0;_3<=42;_3+=1){$p($_.charvals,$G($_.barchars,_3,1),_3)}for(var _A=0,_9=$_.barcode.length-1;_A<=_9;_A+=1){var _E=$g($_.charvals,$G($_.barcode,_A,1))!==undefined;if(!_E){$k[$j++]="bwipp.hibccode128badCharacter#32064";$k[$j++]="HIBC Code 128 must contain only digits, capital letters, spaces and the symbols -.$/+%";bwipp_raiseerror()}}$k[$j++]="barlen";$k[$j++]=$_.barcode.length;if($_.validatecheck){var _H=$k[--$j];$k[$j++]=_H-1}var _I=$k[--$j];$_[$k[--$j]]=_I;$_.checksum=41;for(var _M=0,_L=$_.barlen-1;_M<=_L;_M+=1){$_.checksum=$f($g($_.charvals,$G($_.barcode,_M,1))+$_.checksum)}$_.checksum=$_.checksum%43;if($_.validatecheck){if($g($_.barcode,$_.barlen)!=$g($_.barchars,$_.checksum)){$k[$j++]="bwipp.hibccode128badCheckDigit#32078";$k[$j++]="Incorrect HIBC Code 128 check digit provided";bwipp_raiseerror()}$_.barcode=$G($_.barcode,0,$_.barlen)}var _e=$s($_.barlen+2);$P(_e,1,$_.barcode);$_.barcode=_e;$p($_.barcode,0,43);$p($_.barcode,$_.barlen+1,$g($_.barchars,$_.checksum));$_.text=$s($_.barlen+4);$p($_.text,0,42);$P($_.text,1,$_.barcode);var _v=$g($_.barcode,$_.barlen+1);$k[$j++]=$_.text;$k[$j++]=$_.barlen+2;$k[$j++]=_v;if(_v==32){$k[$j-1]=95}var _w=$k[--$j];var _x=$k[--$j];$p($k[--$j],_x,_w);$p($_.text,$_.barlen+3,42);$p($_.options,"dontdraw",true);$p($_.options,"validatecheck",false);$k[$j++]="args";$k[$j++]=$_.barcode;$k[$j++]=$_.options;bwipp_code128();var _15=$k[--$j];$_[$k[--$j]]=_15;$p($_.args,"txt",$a([$a([$_.text,$_.textxoffset,$_.textyoffset,$_.textfont,$_.textsize])]));$p($_.args,"textxalign","center");$p($_.args,"opt",$_.options);$k[$j++]=$_.args;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_hibcdatamatrix(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.validatecheck=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.barcode.length==0){$k[$j++]="bwipp.hibcdatamatrixEmptyData#32148";$k[$j++]="The data must not be empty";bwipp_raiseerror()}$_.barchars="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%";$_.charvals=new Map;for(var _3=0;_3<=42;_3+=1){$p($_.charvals,$G($_.barchars,_3,1),_3)}for(var _A=0,_9=$_.barcode.length-1;_A<=_9;_A+=1){var _E=$g($_.charvals,$G($_.barcode,_A,1))!==undefined;if(!_E){$k[$j++]="bwipp.hibcdatamatrixBadCharacter#32163";$k[$j++]="HIBC Data Matrix must contain only digits, capital letters, spaces and the symbols -.$/+%";bwipp_raiseerror()}}$k[$j++]="barlen";$k[$j++]=$_.barcode.length;if($_.validatecheck){var _H=$k[--$j];$k[$j++]=_H-1}var _I=$k[--$j];$_[$k[--$j]]=_I;$_.checksum=41;for(var _M=0,_L=$_.barlen-1;_M<=_L;_M+=1){$_.checksum=$f($g($_.charvals,$G($_.barcode,_M,1))+$_.checksum)}$_.checksum=$_.checksum%43;if($_.validatecheck){if($g($_.barcode,$_.barlen)!=$g($_.barchars,$_.checksum)){$k[$j++]="bwipp.hibcdatamatrixBadCheckDigit#32177";$k[$j++]="Incorrect HIBC Data Matrix check digit provided";bwipp_raiseerror()}$_.barcode=$G($_.barcode,0,$_.barlen)}var _d=$_.barlen;var _e=$s(_d+2);$P(_e,1,$_.barcode);$_.barcode=_e;$p($_.barcode,0,43);$p($_.barcode,$_.barlen+1,$g($_.barchars,$_.checksum));$p($_.options,"dontdraw",true);$p($_.options,"validatecheck",false);$k[$j++]="args";$k[$j++]=$_.barcode;$k[$j++]=$_.options;bwipp_datamatrix();var _q=$k[--$j];var _r=$k[--$j];$_[_r]=_q;$p($_.args,"opt",$_.options);$k[$j++]=$_.args;if(!$_.dontdraw){bwipp_renmatrix()}$_=$__}function bwipp_hibcdatamatrixrectangular(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.validatecheck=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.barcode.length==0){$k[$j++]="bwipp.hibcdatamatrixrectangularEmptyData#32239";$k[$j++]="The data must not be empty";bwipp_raiseerror()}$_.barchars="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%";$_.charvals=new Map;for(var _3=0;_3<=42;_3+=1){$p($_.charvals,$G($_.barchars,_3,1),_3)}for(var _A=0,_9=$_.barcode.length-1;_A<=_9;_A+=1){var _E=$g($_.charvals,$G($_.barcode,_A,1))!==undefined;if(!_E){$k[$j++]="bwipp.hibcdatamatrixrectangularBadCharacter#32254";$k[$j++]="HIBC Data Matrix Rectangular must contain only digits, capital letters, spaces and the symbols -.$/+%";bwipp_raiseerror()}}$k[$j++]="barlen";$k[$j++]=$_.barcode.length;if($_.validatecheck){var _H=$k[--$j];$k[$j++]=_H-1}var _I=$k[--$j];$_[$k[--$j]]=_I;$_.checksum=41;for(var _M=0,_L=$_.barlen-1;_M<=_L;_M+=1){$_.checksum=$f($g($_.charvals,$G($_.barcode,_M,1))+$_.checksum)}$_.checksum=$_.checksum%43;if($_.validatecheck){if($g($_.barcode,$_.barlen)!=$g($_.barchars,$_.checksum)){$k[$j++]="bwipp.hibcdatamatrixrectangularBadCheckDigit#32268";$k[$j++]="Incorrect HIBC Data Matrix Rectangular check digit provided";bwipp_raiseerror()}$_.barcode=$G($_.barcode,0,$_.barlen)}var _d=$_.barlen;var _e=$s(_d+2);$P(_e,1,$_.barcode);$_.barcode=_e;$p($_.barcode,0,43);$p($_.barcode,$_.barlen+1,$g($_.barchars,$_.checksum));$p($_.options,"dontdraw",true);$p($_.options,"validatecheck",false);$p($_.options,"format","rectangle");$k[$j++]="args";$k[$j++]=$_.barcode;$k[$j++]=$_.options;bwipp_datamatrix();var _r=$k[--$j];$_[$k[--$j]]=_r;$p($_.args,"opt",$_.options);$k[$j++]=$_.args;if(!$_.dontdraw){bwipp_renmatrix()}$_=$__}function bwipp_hibcpdf417(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.columns=2;$_.validatecheck=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.barcode.length==0){$k[$j++]="bwipp.hibcpdf417EmptyData#32332";$k[$j++]="The data must not be empty";bwipp_raiseerror()}$_.barchars="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%";$_.charvals=new Map;for(var _3=0;_3<=42;_3+=1){$p($_.charvals,$G($_.barchars,_3,1),_3)}for(var _A=0,_9=$_.barcode.length-1;_A<=_9;_A+=1){var _E=$g($_.charvals,$G($_.barcode,_A,1))!==undefined;if(!_E){$k[$j++]="bwipp.hibcpdf417BadCharacter#32347";$k[$j++]="HIBC PDF417 must contain only digits, capital letters, spaces and the symbols -.$/+%";bwipp_raiseerror()}}$k[$j++]="barlen";$k[$j++]=$_.barcode.length;if($_.validatecheck){var _H=$k[--$j];$k[$j++]=_H-1}var _I=$k[--$j];$_[$k[--$j]]=_I;$_.checksum=41;for(var _M=0,_L=$_.barlen-1;_M<=_L;_M+=1){$_.checksum=$f($g($_.charvals,$G($_.barcode,_M,1))+$_.checksum)}$_.checksum=$_.checksum%43;if($_.validatecheck){if($g($_.barcode,$_.barlen)!=$g($_.barchars,$_.checksum)){$k[$j++]="bwipp.hibcpdf417BadCheckDigit#32361";$k[$j++]="Incorrect HIBC PDF417 check digit provided";bwipp_raiseerror()}$_.barcode=$G($_.barcode,0,$_.barlen)}var _e=$s($_.barlen+2);$P(_e,1,$_.barcode);$_.barcode=_e;$p($_.barcode,0,43);$p($_.barcode,$_.barlen+1,$g($_.barchars,$_.checksum));$p($_.options,"dontdraw",true);$p($_.options,"columns",$_.columns);var _p=$_.options;$p(_p,"validatecheck",false);var _r=$_.options;$k[$j++]="args";$k[$j++]=$_.barcode;$k[$j++]=_r;bwipp_pdf417();var _s=$k[--$j];$_[$k[--$j]]=_s;$p($_.args,"opt",$_.options);$k[$j++]=$_.args;if(!$_.dontdraw){bwipp_renmatrix()}$_=$__}function bwipp_hibcmicropdf417(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.columns=2;$_.validatecheck=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.barcode.length==0){$k[$j++]="bwipp.hibcmicropdf417EmptyData#32425";$k[$j++]="The data must not be empty";bwipp_raiseerror()}$_.barchars="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%";$_.charvals=new Map;for(var _3=0;_3<=42;_3+=1){$p($_.charvals,$G($_.barchars,_3,1),_3)}for(var _A=0,_9=$_.barcode.length-1;_A<=_9;_A+=1){var _E=$g($_.charvals,$G($_.barcode,_A,1))!==undefined;if(!_E){$k[$j++]="bwipp.hibcmicropdf417BadCharacter#32440";$k[$j++]="HIBC MicroPDF417 must contain only digits, capital letters, spaces and the symbols -.$/+%";bwipp_raiseerror()}}$k[$j++]="barlen";$k[$j++]=$_.barcode.length;if($_.validatecheck){var _H=$k[--$j];$k[$j++]=_H-1}var _I=$k[--$j];$_[$k[--$j]]=_I;$_.checksum=41;for(var _M=0,_L=$_.barlen-1;_M<=_L;_M+=1){$_.checksum=$f($g($_.charvals,$G($_.barcode,_M,1))+$_.checksum)}$_.checksum=$_.checksum%43;if($_.validatecheck){if($g($_.barcode,$_.barlen)!=$g($_.barchars,$_.checksum)){$k[$j++]="bwipp.hibcmicropdf417BadCheckDigit#32454";$k[$j++]="Incorrect HIBC MicroPDF417 check digit provided";bwipp_raiseerror()}$_.barcode=$G($_.barcode,0,$_.barlen)}var _e=$s($_.barlen+2);$P(_e,1,$_.barcode);$_.barcode=_e;$p($_.barcode,0,43);$p($_.barcode,$_.barlen+1,$g($_.barchars,$_.checksum));var _m=$_.options;$p(_m,"dontdraw",true);$p($_.options,"columns",$_.columns);$p($_.options,"validatecheck",false);var _r=$_.options;$k[$j++]="args";$k[$j++]=$_.barcode;$k[$j++]=_r;bwipp_micropdf417();var _s=$k[--$j];$_[$k[--$j]]=_s;$p($_.args,"opt",$_.options);$k[$j++]=$_.args;if(!$_.dontdraw){bwipp_renmatrix()}$_=$__}function bwipp_hibcqrcode(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.validatecheck=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.barcode.length==0){$k[$j++]="bwipp.hibcqrcodeEmptyData#32517";$k[$j++]="The data must not be empty";bwipp_raiseerror()}$_.barchars="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%";$_.charvals=new Map;for(var _3=0;_3<=42;_3+=1){$p($_.charvals,$G($_.barchars,_3,1),_3)}for(var _A=0,_9=$_.barcode.length-1;_A<=_9;_A+=1){var _E=$g($_.charvals,$G($_.barcode,_A,1))!==undefined;if(!_E){$k[$j++]="bwipp.hibcqrcodeBadCharacter#32532";$k[$j++]="HIBC QR Code must contain only digits, capital letters, spaces and the symbols -.$/+%";bwipp_raiseerror()}}$k[$j++]="barlen";$k[$j++]=$_.barcode.length;if($_.validatecheck){var _H=$k[--$j];$k[$j++]=_H-1}var _I=$k[--$j];$_[$k[--$j]]=_I;$_.checksum=41;for(var _M=0,_L=$_.barlen-1;_M<=_L;_M+=1){$_.checksum=$f($g($_.charvals,$G($_.barcode,_M,1))+$_.checksum)}$_.checksum=$_.checksum%43;if($_.validatecheck){if($g($_.barcode,$_.barlen)!=$g($_.barchars,$_.checksum)){$k[$j++]="bwipp.hibcqrcodeBadCheckDigit#32546";$k[$j++]="Incorrect HIBC QR Code check digit provided";bwipp_raiseerror()}$_.barcode=$G($_.barcode,0,$_.barlen)}var _e=$s($_.barlen+2);$P(_e,1,$_.barcode);$_.barcode=_e;$p($_.barcode,0,43);$p($_.barcode,$_.barlen+1,$g($_.barchars,$_.checksum));$p($_.options,"dontdraw",true);$p($_.options,"validatecheck",false);$k[$j++]="args";$k[$j++]=$_.barcode;$k[$j++]=$_.options;bwipp_qrcode();var _q=$k[--$j];var _r=$k[--$j];$_[_r]=_q;$p($_.args,"opt",$_.options);$k[$j++]=$_.args;if(!$_.dontdraw){bwipp_renmatrix()}$_=$__}function bwipp_hibccodablockf(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.validatecheck=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.barcode.length==0){$k[$j++]="bwipp.hibccodablockfEmptyData#32608";$k[$j++]="The data must not be empty";bwipp_raiseerror()}$_.barchars="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%";$_.charvals=new Map;for(var _3=0;_3<=42;_3+=1){$p($_.charvals,$G($_.barchars,_3,1),_3)}for(var _A=0,_9=$_.barcode.length-1;_A<=_9;_A+=1){var _E=$g($_.charvals,$G($_.barcode,_A,1))!==undefined;if(!_E){$k[$j++]="bwipp.hibccodablockfBadCharacter#32623";$k[$j++]="HIBC Codablock F must contain only digits, capital letters, spaces and the symbols -.$/+%";bwipp_raiseerror()}}$k[$j++]="barlen";$k[$j++]=$_.barcode.length;if($_.validatecheck){var _H=$k[--$j];$k[$j++]=_H-1}var _I=$k[--$j];$_[$k[--$j]]=_I;$_.checksum=41;for(var _M=0,_L=$_.barlen-1;_M<=_L;_M+=1){$_.checksum=$f($g($_.charvals,$G($_.barcode,_M,1))+$_.checksum)}$_.checksum=$_.checksum%43;if($_.validatecheck){if($g($_.barcode,$_.barlen)!=$g($_.barchars,$_.checksum)){$k[$j++]="bwipp.hibccodablockfBadCheckDigit#32637";$k[$j++]="Incorrect HIBC Codablock F check digit provided";bwipp_raiseerror()}$_.barcode=$G($_.barcode,0,$_.barlen)}var _e=$s($_.barlen+2);$P(_e,1,$_.barcode);$_.barcode=_e;$p($_.barcode,0,43);$p($_.barcode,$_.barlen+1,$g($_.barchars,$_.checksum));$p($_.options,"dontdraw",true);$p($_.options,"validatecheck",false);$k[$j++]="args";$k[$j++]=$_.barcode;$k[$j++]=$_.options;bwipp_codablockf();var _q=$k[--$j];var _r=$k[--$j];$_[_r]=_q;$p($_.args,"opt",$_.options);$k[$j++]=$_.args;if(!$_.dontdraw){bwipp_renmatrix()}$_=$__}function bwipp_hibcazteccode(){var $__=$_;$_=Object.assign({},$_);$_.dontdraw=false;$_.validatecheck=false;$k[$j++]=$_;bwipp_processoptions();$_.options=$k[--$j];$_.barcode=$k[--$j];if($_.barcode.length==0){$k[$j++]="bwipp.hibcazteccodeEmptyData#32699";$k[$j++]="The data must not be empty";bwipp_raiseerror()}$_.barchars="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%";$_.charvals=new Map;for(var _3=0;_3<=42;_3+=1){$p($_.charvals,$G($_.barchars,_3,1),_3)}for(var _A=0,_9=$_.barcode.length-1;_A<=_9;_A+=1){var _E=$g($_.charvals,$G($_.barcode,_A,1))!==undefined;if(!_E){$k[$j++]="bwipp.hibcazteccodeBadCharacter#32714";$k[$j++]="HIBC Aztec Code must contain only digits, capital letters, spaces and the symbols -.$/+%";bwipp_raiseerror()}}$k[$j++]="barlen";$k[$j++]=$_.barcode.length;if($_.validatecheck){var _H=$k[--$j];$k[$j++]=_H-1}var _I=$k[--$j];$_[$k[--$j]]=_I;$_.checksum=41;for(var _M=0,_L=$_.barlen-1;_M<=_L;_M+=1){$_.checksum=$f($g($_.charvals,$G($_.barcode,_M,1))+$_.checksum)}$_.checksum=$_.checksum%43;if($_.validatecheck){if($g($_.barcode,$_.barlen)!=$g($_.barchars,$_.checksum)){$k[$j++]="bwipp.hibcazteccodeBadCheckDigit#32728";$k[$j++]="Incorrect HIBC Aztec Code check digit provided";bwipp_raiseerror()}$_.barcode=$G($_.barcode,0,$_.barlen)}var _e=$s($_.barlen+2);$P(_e,1,$_.barcode);$_.barcode=_e;$p($_.barcode,0,43);$p($_.barcode,$_.barlen+1,$g($_.barchars,$_.checksum));$p($_.options,"dontdraw",true);$p($_.options,"validatecheck",false);$k[$j++]="args";$k[$j++]=$_.barcode;$k[$j++]=$_.options;bwipp_azteccode();var _q=$k[--$j];var _r=$k[--$j];$_[_r]=_q;$p($_.args,"opt",$_.options);$k[$j++]=$_.args;if(!$_.dontdraw){bwipp_renmatrix()}$_=$__}function bwipp_channelcode(){var $__=$_;$_=Object.assign({},$_);$_.options=$k[--$j];$_.barcode=$k[--$j];$_.dontdraw=false;$_.shortfinder=false;$_.includetext=false;$_.includecheck=false;$_.height=1;$F($_.options,function(){var _3=$k[--$j];$_[$k[--$j]]=_3});$_.height=+$_.height;if($_.barcode.length<2||$_.barcode.length>7){$k[$j++]="bwipp.channelcodeBadLength#32803";$k[$j++]="Channel Code must be 2 to 7 digits";bwipp_raiseerror()}$F($_.barcode,function(){var _9=$k[--$j];if(_9<48||_9>57){$k[$j++]="bwipp.channelcodeBadCharacter#32807";$k[$j++]="Channel Code must contain only digits";bwipp_raiseerror()}});if($i($_.barcode)>$g($a([26,292,3493,44072,576688,7742862]),$_.barcode.length-2)){$k[$j++]="bwipp.channelcodeTooBig#32811";$k[$j++]="The Channel Code value is too big for the number of channels";bwipp_raiseerror()}$_.nextb=function(){var _E=$k[$j-1];var _N=$f($g($_.s,_E)+($g($_.b,_E-1)+($g($_.b,_E-2)+$g($_.s,_E-1))))>4?1:2;$k[$j++]=_N;if(_E<$_.chan+2){var _P=$k[$j-1];var _R=$k[$j-3];for(var _T=_P,_S=_R;_T<=_S;_T+=1){var _W=$k[$j-2];$p($_.b,_W,_T);var _X=$k[$j-3];var _Y=$k[$j-4];$k[$j++]=$f(_X-_T)+1;$k[$j++]=_Y;$k[$j++]=_W+1;$_.nexts()}}else{var _Z=$k[$j-1];var _b=$k[$j-3];if($le(_Z,_b)){var _e=$k[$j-2];var _f=$k[$j-3];$p($_.b,_e,_f);if($_.value==$_.target){$k[$j++]=Infinity;for(var _i=3;_i<=10;_i+=1){$k[$j++]=$g($_.s,_i);$k[$j++]=$g($_.b,_i)}$_.out=$G($a(),0,$_.chan*2)}$_.value=$_.value+1}}$j-=4};$_.nexts=function(){var _r=$k[$j-1];if(_r<$_.chan+2){$k[$j++]=1}else{var _u=$k[$j-2];$k[$j++]=_u}var _v=$k[--$j];var _x=$k[$j-2];for(var _z=_v,_y=_x;_z<=_y;_z+=1){var _11=$k[$j-1];$p($_.s,_11,_z);var _12=$k[$j-2];var _13=$k[$j-3];$k[$j++]=$f(_12-_z)+1;$k[$j++]=_13;$k[$j++]=_11;$_.nextb()}$j-=3};$_.encode=function(){$_.chan=$k[--$j];$_.target=$k[--$j];$_.value=0;$_.out=-1;$_.b=$a([1,1,1,0,0,0,0,0,0,0,0]);$_.s=$a([0,1,1,0,0,0,0,0,0,0,0]);var _18=$_.chan;$k[$j++]=_18;$k[$j++]=_18;$k[$j++]=3;$_.nexts();$k[$j++]=$_.out};$_.barlen=$_.barcode.length;$k[$j++]="finder";if($_.shortfinder){$k[$j++]=$a([1,1,1,1,1])}else{$k[$j++]=$a([1,1,1,1,1,1,1,1,1])}var _1E=$k[--$j];$_[$k[--$j]]=_1E;$k[$j++]="data";$k[$j++]=$i($_.barcode);$k[$j++]=$_.barlen+1;$_.encode();var _1I=$k[--$j];$_[$k[--$j]]=_1I;$_.check=$a([]);if($_.includecheck){$_.mod23=$g($a([$a([]),$a([]),$a([13,12,4,9,3,1]),$a([13,2,12,3,18,16,4,1]),$a([11,16,17,8,20,4,10,2,5,1]),$a([1,4,16,18,3,12,2,8,9,13,6,1]),$a([20,16,22,13,15,12,5,4,8,9,21,3,7,1]),$a([2,6,18,8,1,3,9,4,12,13,16,2,6,18,8,1])]),$_.barlen);$k[$j++]=0;for(var _1Z=0,_1Y=$_.data.length-1;_1Z<=_1Y;_1Z+=1){var _1e=$k[--$j];$k[$j++]=$f(_1e+($g($_.data,_1Z)-1)*$g($_.mod23,_1Z))}var _1f=$k[--$j];$k[$j++]=_1f%23;$k[$j++]=3;$_.encode();$_.check=$k[--$j]}$k[$j++]=Infinity;$q($_.finder);$q($_.data);$q($_.check);$_.sbs=$a();$_.txt=$a($_.barlen);for(var _1p=0,_1o=$_.barlen-1;_1p<=_1o;_1p+=1){$_.i=_1p;$p($_.txt,$_.i,$a([$G($_.barcode,$_.i,1),0,0,"",0]))}$k[$j++]=Infinity;var _1w=$_.sbs;$k[$j++]=Infinity;for(var _1y=0,_1z=~~(($_.sbs.length+1)/2);_1y<_1z;_1y++){$k[$j++]=$_.height}var _21=$a();$k[$j++]=Infinity;for(var _23=0,_24=~~(($_.sbs.length+1)/2);_23<_24;_23++){$k[$j++]=0}var _25=$a();$k[$j++]="ren";$k[$j++]=bwipp_renlinear;$k[$j++]="sbs";$k[$j++]=_1w;$k[$j++]="bhs";$k[$j++]=_21;$k[$j++]="bbs";$k[$j++]=_25;$k[$j++]="txt";$k[$j++]=$_.txt;$k[$j++]="textxalign";$k[$j++]="center";$k[$j++]="opt";$k[$j++]=$_.options;var _28=$d();$k[$j++]=_28;if(!$_.dontdraw){bwipp_renlinear()}$_=$__}function bwipp_renlinear(){if($_.bwipjs_rawstack){$_.bwipjs_rawstack.push($k[--$j]);return}var $__=$_;$_=Object.assign({},$_);$_.sbs=$a([]);$_.bhs=$a([]);$_.bbs=$a([]);$_.txt=$a([]);$_.barcolor="unset";$_.includetext=false;$_.textcolor="unset";$_.textxalign="unset";$_.textyalign="unset";$_.textfont="OCR-B";$_.textdirection="forward";$_.textsize=10;$_.textxoffset=0;$_.textyoffset=0;$_.textgaps=0;$_.textlinegaps=1.2;$_.alttext="";$_.alttextsplit="";$_.alttextsubspace="";$_.extratext="";$_.extratextsubspace="";$_.extratextsplit="";$_.extratextlinegaps=1.2;$_.extratextcolor="unset";$_.extratextxalign="left";$_.extratextyalign="above";$_.extratextfont="OCR-B";$_.extratextdirection="forward";$_.extratextsize=10;$_.extratextxoffset=0;$_.extratextyoffset=0;$_.extratextgaps=0;$_.bordercolor="unset";$_.inkspread=0;$_.width=0;$_.barratio=1;$_.spaceratio=1;$_.showborder=false;$_.showbearer=false;$_.borderleft=10;$_.borderright=10;$_.bordertop=1;$_.borderbottom=1;$_.borderwidth=.5;$_.guardwhitespace=false;$_.guardleftpos=0;$_.guardleftypos=0;$_.guardrightpos=0;$_.guardrightypos=0;$_.guardwidth=7;$_.guardheight=7;$F($k[--$j],function(){var _5=$k[--$j];$_[$k[--$j]]=_5});$k[$j++]=$_.opt;delete $_["opt"];$k[$j++]=$_;bwipp_processoptions();$j--;if($ne($_.textxalign,"unset")){$k[$j++]=Infinity;var _9="offleft";var _A="left";var _B="center";var _C="right";var _D="offright";$k[$j++]=_9;$k[$j++]=_9;$k[$j++]=_A;$k[$j++]=_A;$k[$j++]=_B;$k[$j++]=_B;$k[$j++]=_C;$k[$j++]=_C;$k[$j++]=_D;$k[$j++]=_D;var _G=$g($d(),$_.textxalign)!==undefined;if(!_G){$k[$j++]="bwipp.renmatrixBadTextxalign#33005";$k[$j++]="textxalign must be offleft, left, center, right or offright";bwipp_raiseerror()}}if($ne($_.textyalign,"unset")){$k[$j++]=Infinity;var _I="above";var _J="top";var _K="center";var _L="bottom";var _M="below";$k[$j++]=_I;$k[$j++]=_I;$k[$j++]=_J;$k[$j++]=_J;$k[$j++]=_K;$k[$j++]=_K;$k[$j++]=_L;$k[$j++]=_L;$k[$j++]=_M;$k[$j++]=_M;var _P=$g($d(),$_.textyalign)!==undefined;if(!_P){$k[$j++]="bwipp.renmatrixBadTextyalign#33011";$k[$j++]="textyalign must be above, top, center, bottom or below";bwipp_raiseerror()}}$k[$j++]=Infinity;var _Q="forward";var _R="backward";var _S="upward";var _T="downward";$k[$j++]=_Q;$k[$j++]=_Q;$k[$j++]=_R;$k[$j++]=_R;$k[$j++]=_S;$k[$j++]=_S;$k[$j++]=_T;$k[$j++]=_T;var _W=$g($d(),$_.textdirection)!==undefined;if(!_W){$k[$j++]="bwipp.renmatrixBadTextdirection#33016";$k[$j++]="textdirection must be forward, backward, upward or downward";bwipp_raiseerror()}if($_.textsize<=0||$_.textsize>=25){$k[$j++]="bwipp.renmatrixBadTextsize#33020";$k[$j++]="textsize must be greater than zero and less that 25";bwipp_raiseerror()}$k[$j++]=Infinity;var _Z="offleft";var _a="left";var _b="center";var _c="right";var _d="offright";$k[$j++]=_Z;$k[$j++]=_Z;$k[$j++]=_a;$k[$j++]=_a;$k[$j++]=_b;$k[$j++]=_b;$k[$j++]=_c;$k[$j++]=_c;$k[$j++]=_d;$k[$j++]=_d;var _g=$g($d(),$_.extratextxalign)!==undefined;if(!_g){$k[$j++]="bwipp.renmatrixBadExtratextxalign#33024";$k[$j++]="extratextxalign must be offleft, left, center, right or offright";bwipp_raiseerror()}$k[$j++]=Infinity;var _h="above";var _i="top";var _j="center";var _k="bottom";var _l="below";$k[$j++]=_h;$k[$j++]=_h;$k[$j++]=_i;$k[$j++]=_i;$k[$j++]=_j;$k[$j++]=_j;$k[$j++]=_k;$k[$j++]=_k;$k[$j++]=_l;$k[$j++]=_l;var _o=$g($d(),$_.extratextyalign)!==undefined;if(!_o){$k[$j++]="bwipp.renmatrixBadExtratextyalign#33028";$k[$j++]="extratextyalign must be above, top, center, bottom or below";bwipp_raiseerror()}$k[$j++]=Infinity;var _p="forward";var _q="backward";var _r="upward";var _s="downward";$k[$j++]=_p;$k[$j++]=_p;$k[$j++]=_q;$k[$j++]=_q;$k[$j++]=_r;$k[$j++]=_r;$k[$j++]=_s;$k[$j++]=_s;var _v=$g($d(),$_.extratextdirection)!==undefined;if(!_v){$k[$j++]="bwipp.renmatrixBadExtratextdirection#33032";$k[$j++]="extratextdirection must be forward, backward, upward or downward";bwipp_raiseerror()}if($_.extratextsize<=0||$_.extratextsize>=25){$k[$j++]="bwipp.renmatrixBadTextsize#33036";$k[$j++]="extratextsize must be greater than zero and less that 25";bwipp_raiseerror()}$_.bars=$a(~~(($_.sbs.length+1)/2));$_.pixx=0;$_.pixy=0;for(var _12=0,_11=~~(($_.sbs.length+1)/2)*2-2;_12<=_11;_12+=1){$_.i=_12;if($_.i%2==0){$_.d=$f($g($_.sbs,$_.i)*$_.barratio-$_.barratio)+1;if($g($_.sbs,$_.i)!=0){$_.h=$g($_.bhs,~~($_.i/2))*72;$_.c=$f($_.d/2+$_.pixx);$_.y=$g($_.bbs,~~($_.i/2))*72;$_.w=$f($_.d-$_.inkspread);$p($_.bars,~~($_.i/2),$a([$_.h,$_.c,$_.y,$_.w]));if($f($_.h+$_.y)>$_.pixy){$_.pixy=$f($_.h+$_.y)}}else{$p($_.bars,~~($_.i/2),-1)}}else{$_.d=$f($g($_.sbs,$_.i)*$_.spaceratio-$_.spaceratio)+1}$_.pixx=$f($_.pixx+$_.d)}$$.save();var _1h=$$.currpos();$$.translate(_1h.x,_1h.y);if($_.width!=0){$$.scale($_.width*72/$_.pixx,1)}$_.tl=$a([-$f($_.borderleft+$_.borderwidth/2),$f($_.pixy+$_.bordertop+$_.borderwidth/2)]);$_.tr=$a([$f($_.pixx+$_.borderright+$_.borderwidth/2),$f($_.pixy+$_.bordertop+$_.borderwidth/2)]);$_.bl=$a([-$f($_.borderleft+$_.borderwidth/2),-$f($_.borderbottom+$_.borderwidth/2)]);$_.br=$a([$f($_.pixx+$_.borderright+$_.borderwidth/2),-$f($_.borderbottom+$_.borderwidth/2)]);if($_.showbearer){$$.save();$$.newpath();$q($_.bl);var _2B=$k[--$j];$$.moveto($k[--$j],_2B);$q($_.br);var _2E=$k[--$j];$$.lineto($k[--$j],_2E);$q($_.tl);var _2H=$k[--$j];$$.moveto($k[--$j],_2H);$q($_.tr);var _2K=$k[--$j];$$.lineto($k[--$j],_2K);if($ne($_.bordercolor,"unset")){$$.setcolor($_.bordercolor)}$$.setlinewidth($f($_.borderwidth-$_.inkspread*2));$$.stroke();$$.restore()}else{if($_.showborder){$$.save();$$.newpath();$q($_.bl);var _2S=$k[--$j];$$.moveto($k[--$j],_2S);var _2X=$a([$_.br,$_.tr,$_.tl]);for(var _2Y=0,_2Z=_2X.length;_2Y<_2Z;_2Y++){$q($g(_2X,_2Y));var _2b=$k[--$j];$$.lineto($k[--$j],_2b)}$$.closepath();if($ne($_.bordercolor,"unset")){$$.setcolor($_.bordercolor)}$$.setlinewidth($_.borderwidth);$$.stroke();$$.restore()}}$$.save();if($ne($_.barcolor,"unset")){$$.setcolor($_.barcolor)}var _2i=$_.bars;for(var _2j=0,_2k=_2i.length;_2j<_2k;_2j++){var _2l=$g(_2i,_2j);$k[$j++]=_2l;if(_2l!=-1){$q($k[--$j]);$$.newpath();$$.setlinewidth($k[--$j]);var _2o=$k[--$j];$$.moveto($k[--$j],_2o);$$.rlineto(0,$k[--$j]);$$.stroke()}else{$j--}}$$.restore();var _37=new Map([["offleft",function(){$k[$j++]=$f(-$_.tw-$_.nudge)}],["below",function(){$k[$j++]=$f(-$_.th-$_.nudge)}],["left",function(){$k[$j++]=0}],["bottom",function(){$k[$j++]=0}],["xcenter",function(){$k[$j++]=$f($_.pixx-$_.tw)/2}],["ycenter",function(){$k[$j++]=$f($_.pixy-$_.th)/2}],["right",function(){$k[$j++]=$f($_.pixx-$_.tw)}],["top",function(){$k[$j++]=$f($_.pixy-$_.th)}],["offright",function(){$k[$j++]=$f($_.pixx+$_.nudge)}],["above",function(){$k[$j++]=$f($_.pixy+$_.nudge)}]]);var _3O=new Map([["offleft",function(){$k[$j++]=0-$_.nudge}],["below",function(){$k[$j++]=0-$_.nudge}],["left",function(){$k[$j++]=$_.tw}],["bottom",function(){$k[$j++]=$_.th}],["xcenter",function(){$k[$j++]=$f($_.pixx+$_.tw)/2}],["ycenter",function(){$k[$j++]=$f($_.pixy+$_.th)/2}],["right",function(){$k[$j++]=$_.pixx}],["top",function(){$k[$j++]=$_.pixy}],["offright",function(){$k[$j++]=$f($_.pixx+$_.tw+$_.nudge)}],["above",function(){$k[$j++]=$f($_.pixy+$_.th+$_.nudge)}]]);var _3f=new Map([["offleft",function(){$k[$j++]=0-$_.nudge}],["below",function(){$k[$j++]=$f(-$_.tw-$_.nudge)}],["left",function(){$k[$j++]=$_.th}],["bottom",function(){$k[$j++]=0}],["xcenter",function(){$k[$j++]=$f($_.pixx+$_.th)/2}],["ycenter",function(){$k[$j++]=$f($_.pixy-$_.tw)/2}],["right",function(){$k[$j++]=$_.pixx}],["top",function(){$k[$j++]=$f($_.pixy-$_.tw)}],["offright",function(){$k[$j++]=$f($_.pixx+$_.th+$_.nudge)}],["above",function(){$k[$j++]=$f($_.pixy+$_.nudge)}]]);var _3w=new Map([["offleft",function(){$k[$j++]=$f(-$_.th-$_.nudge)}],["below",function(){$k[$j++]=0-$_.nudge}],["left",function(){$k[$j++]=0}],["bottom",function(){$k[$j++]=$_.tw}],["xcenter",function(){$k[$j++]=$f($_.pixx-$_.th)/2}],["ycenter",function(){$k[$j++]=$f($_.pixy+$_.tw)/2}],["right",function(){$k[$j++]=$f($_.pixx-$_.th)}],["top",function(){$k[$j++]=$_.pixy}],["offright",function(){$k[$j++]=$f($_.pixx+$_.nudge)}],["above",function(){$k[$j++]=$f($_.pixy+$_.tw+$_.nudge)}]]);var _3x=new Map([["forward",_37],["backward",_3O],["upward",_3f],["downward",_3w]]);$_.positions=_3x;$_.positiontext=function(){$_.th=$k[--$j];$_.tw=$k[--$j];$_.nudge=1;var _42=$g($_.positions,$k[--$j]);$k[$j++]=_42;$k[$j++]=_42;$r(4,-1);var _43=$k[$j-1];if($eq(_43,"center")){$k[$j-1]="xcenter"}var _44=$k[--$j];if($g($k[--$j],_44)()===true){return true}var _47=$k[--$j];var _48=$k[--$j];$k[$j++]=_47;$k[$j++]=_48;$r(3,-1);var _49=$k[$j-1];if($eq(_49,"center")){$k[$j-1]="ycenter"}var _4A=$k[--$j];if($g($k[--$j],_4A)()===true){return true}};if($_.includetext){if($ne($_.textcolor,"unset")){$$.setcolor($_.textcolor)}if($eq($_.textxalign,"unset")&&$eq($_.textyalign,"unset")&&$_.alttext.length==0){$_.s=0;$_.fn="";var _4J=$_.txt;for(var _4K=0,_4L=_4J.length;_4K<_4L;_4K++){$q($g(_4J,_4K));var _4N=$k[$j-1];var _4O=$k[$j-2];if(_4N!=$_.s||$ne(_4O,$_.fn)){var _4R=$k[$j-1];if(_4R<=0){$j-=5;$k[$j++]="bwipp.renlinearFontTooSmall#33178";$k[$j++]="The font size is too small";bwipp_raiseerror()}var _4S=$k[--$j];var _4T=$k[--$j];$_.s=_4S;$_.fn=_4T;$$.selectfont(_4T,_4S)}else{$j-=2}var _4U=$k[--$j];$$.moveto($k[--$j],_4U);$$.show($k[--$j],0,0)}}else{if($_.alttext.length==0){$k[$j++]=Infinity;var _4Y=$_.txt;for(var _4Z=0,_4a=_4Y.length;_4Z<_4a;_4Z++){$F($g($g(_4Y,_4Z),0))}$_.txt=$a();$_.tstr=$s($_.txt.length);for(var _4i=0,_4h=$_.txt.length-1;_4i<=_4h;_4i+=1){$p($_.tstr,_4i,$g($_.txt,_4i))}}else{$_.tstr=$_.alttext;for(var _4p=0,_4o=$_.alttext.length-1;_4p<=_4o;_4p+=1){$k[$j++]=_4p;$X($_.alttextsubspace,$G($_.alttext,_4p,1));if($k[--$j]){$j--;$j--;var _4y=$k[$j-2];$p($_.alttext,_4y,32)}$j-=2}}if($_.alttext.length!=0&&$_.alttextsplit.length!=0){if($_.alttextsplit.length!=1){$k[$j++]="bwipp.alttextsplitBad#33206";$k[$j++]="The alttextsplit option must be a single character";bwipp_raiseerror()}$k[$j++]=Infinity;$k[$j++]=$_.tstr;for(;;){$X($k[--$j],$_.alttextsplit);if($k[--$j]){var _56=$k[--$j];$k[$j-1]=_56;var _58=$k[--$j];var _59=$k[--$j];$k[$j++]=_58;$k[$j++]=_59}else{break}}$_.textlines=$a()}else{$_.textlines=$a([$_.tstr])}$$.selectfont($_.textfont,$_.textsize);if($_.tstr.length==0){$k[$j++]=0}else{$$.save();$$.newpath();$$.moveto(0,0);$$.charpath("0",false);var _5G=$$.pathbbox();$$.restore();$k[$j++]=_5G.ury}$_.textascent=$k[--$j];var _5I=$_.textlines;$k[$j++]="textwidth";$k[$j++]=0;for(var _5J=0,_5K=_5I.length;_5J<_5K;_5J++){var _5M=$$.stringwidth($g(_5I,_5J));var _5N=$k[--$j];var _5O=_5M.w;if(_5N<_5M.w){var _=_5O;_5O=_5N;_5N=_}$k[$j++]=_5N}var _5R=$k[--$j];$_[$k[--$j]]=$f(_5R+($_.tstr.length-1)*$_.textgaps);var _5U=$_.textlines.length;$_.textheight=$f(_5U*$_.textascent+(_5U-1)*$_.textlinegaps);if($eq($_.textxalign,"unset")){$_.textxalign="center"}if($eq($_.textyalign,"unset")){$_.textyalign="below"}if($eq($_.textxalign,"justify")){if($ne($_.textdirection,"forward")&&$ne($_.textdirection,"backward")){$k[$j++]="bwipp.textxjustify#33243";$k[$j++]="textxalign=justify requires forward or backward text";bwipp_raiseerror()}if($_.textwidth<$_.pixx){$_.textgaps=$f($_.pixx-$_.textwidth)/($_.tstr.length-1);$k[$j++]="textxalign";if($eq($_.textdirection,"forward")){$k[$j++]="left"}else{$k[$j++]="right"}var _5i=$k[--$j];$_[$k[--$j]]=_5i}else{$_.textgaps=0;$_.textxalign="center"}}if($eq($_.textyalign,"justify")){if($ne($_.textdirection,"upward")&&$ne($_.textdirection,"downward")){$k[$j++]="bwipp.textyjustify#33256";$k[$j++]="textyalign=justify requires upward or downward text";bwipp_raiseerror()}if($_.textwidth<$_.pixy){$_.textgaps=$f($_.pixy-$_.textwidth)/($_.tstr.length-1);$k[$j++]="textyalign";if($eq($_.textdirection,"upward")){$k[$j++]="bottom"}else{$k[$j++]="top"}var _5t=$k[--$j];$_[$k[--$j]]=_5t}else{$_.textgaps=0;$_.textyalign="center"}}$k[$j++]=$_.textxalign;$k[$j++]=$_.textyalign;$k[$j++]=$_.textdirection;$k[$j++]=$_.textwidth;$k[$j++]=$_.textheight;$_.positiontext();var _60=$k[--$j];$$.moveto($k[--$j],_60);$$.rmoveto($_.textxoffset,$_.textyoffset);$$.save();var _64=new Map([["forward",0],["upward",90],["backward",180],["downward",270]]);$$.rotate($g(_64,$_.textdirection));var _67=$$.currpos();$$.translate(_67.x,_67.y);for(var _6A=0,_69=$_.textlines.length-1;_6A<=_69;_6A+=1){$_.i=_6A;$$.moveto(0,0+$f($_.textascent+$_.textlinegaps)*$_.i);var _6F=$_.textlines;$$.show($g(_6F,_6F.length-$_.i-1),$_.textgaps,0)}$$.restore()}}if($_.guardwhitespace){$$.selectfont("OCR-B",$_.guardheight*2);if($_.guardleftpos!=0){$$.moveto(-$_.guardleftpos-2,$f($_.guardleftypos-$_.guardheight/2-1.25));$$.show("<",0,0)}if($_.guardrightpos!=0){$$.moveto($f($_.guardrightpos+$_.pixx-$_.guardwidth)+1,$f($_.guardrightypos-$_.guardheight/2-1.25));$$.show(">",0,0)}}if($_.extratext.length!=0){for(var _6X=0,_6W=$_.extratext.length-1;_6X<=_6W;_6X+=1){$k[$j++]=_6X;$X($_.extratextsubspace,$G($_.extratext,_6X,1));if($k[--$j]){$j--;$j--;var _6g=$k[$j-2];$p($_.extratext,_6g,32)}$j-=2}if($_.extratextsplit.length!=0){if($_.extratextsplit.length!=1){$k[$j++]="bwipp.extratextsplitBad#33309";$k[$j++]="The extratextsplit option must be a single character";bwipp_raiseerror()}$k[$j++]=Infinity;$k[$j++]=$_.extratext;for(;;){$X($k[--$j],$_.extratextsplit);if($k[--$j]){var _6n=$k[--$j];$k[$j-1]=_6n;var _6p=$k[--$j];var _6q=$k[--$j];$k[$j++]=_6p;$k[$j++]=_6q}else{break}}$_.textlines=$a()}else{$_.textlines=$a([$_.extratext])}if($ne($_.extratextcolor,"unset")){$$.setcolor($_.extratextcolor)}$$.selectfont($_.extratextfont,$_.extratextsize);$$.save();$$.newpath();$$.moveto(0,0);$$.charpath("0",false);var _6y=$$.pathbbox();$$.restore();$_.textascent=_6y.ury;var _6z=$_.textlines;$k[$j++]="textwidth";$k[$j++]=0;for(var _70=0,_71=_6z.length;_70<_71;_70++){var _73=$$.stringwidth($g(_6z,_70));var _74=$k[--$j];var _75=_73.w;if(_74<_73.w){var _=_75;_75=_74;_74=_}$k[$j++]=_74}var _78=$k[--$j];$_[$k[--$j]]=$f(_78+($_.extratext.length-1)*$_.extratextgaps);var _7B=$_.textlines.length;$_.textheight=$f(_7B*$_.textascent+(_7B-1)*$_.extratextlinegaps);if($eq($_.extratextxalign,"justify")){if($ne($_.extratextdirection,"forward")&&$ne($_.extratextdirection,"backward")){$k[$j++]="bwipp.extratextxjustify#33340";$k[$j++]="extratextxalign=justify requires forward or backward text";bwipp_raiseerror()}if($_.textwidth<$_.pixx){$_.extratextgaps=$f($_.pixx-$_.textwidth)/($_.extratext.length-1);$k[$j++]="extratextxalign";if($eq($_.extratextdirection,"forward")){$k[$j++]="left"}else{$k[$j++]="right"}var _7N=$k[--$j];$_[$k[--$j]]=_7N}else{$_.extratextgaps=0;$_.extratextxalign="center"}}if($eq($_.extratextyalign,"justify")){if($ne($_.extratextdirection,"upward")&&$ne($_.extratextdirection,"downward")){$k[$j++]="bwipp.extratextyjustify#33353";$k[$j++]="extratextyalign=justify requires upward or downward text";bwipp_raiseerror()}if($_.textwidth<$_.pixy){$_.extratextgaps=$f($_.pixy-$_.textwidth)/($_.extratext.length-1);$k[$j++]="extratextyalign";if($eq($_.extratextdirection,"upward")){$k[$j++]="bottom"}else{$k[$j++]="top"}var _7Y=$k[--$j];$_[$k[--$j]]=_7Y}else{$_.extratextgaps=0;$_.extratextyalign="center"}}$k[$j++]=$_.extratextxalign;$k[$j++]=$_.extratextyalign;$k[$j++]=$_.extratextdirection;$k[$j++]=$_.textwidth;$k[$j++]=$_.textheight;$_.positiontext();var _7f=$k[--$j];$$.moveto($k[--$j],_7f);$$.rmoveto($_.extratextxoffset,$_.extratextyoffset);$$.save();var _7j=new Map([["forward",0],["upward",90],["backward",180],["downward",270]]);$$.rotate($g(_7j,$_.extratextdirection));var _7m=$$.currpos();$$.translate(_7m.x,_7m.y);for(var _7p=0,_7o=$_.textlines.length-1;_7p<=_7o;_7p+=1){$_.i=_7p;$$.moveto(0,0+$f($_.textascent+$_.extratextlinegaps)*$_.i);var _7u=$_.textlines;$$.show($g(_7u,_7u.length-$_.i-1),$_.extratextgaps,0)}$$.restore()}$$.restore();$_=$__}function bwipp_renmatrix(){if($_.bwipjs_rawstack){$_.bwipjs_rawstack.push($k[--$j]);return}var $__=$_;$_=Object.assign({},$_);$_.width=1;$_.height=1;$_.barcolor="unset";$_.bordercolor="unset";$_.colormap="unset";$_.dotty=false;$_.inkspread=0;$_.inkspreadh=null;$_.inkspreadv=null;$_.txt=$a([]);$_.includetext=false;$_.textcolor="unset";$_.textxalign="unset";$_.textyalign="unset";$_.textfont="OCR-B";$_.textdirection="forward";$_.textsize=10;$_.textxoffset=0;$_.textyoffset=0;$_.textgaps=0;$_.textlinegaps=1.2;$_.alttext="";$_.alttextsplit="";$_.alttextsubspace="";$_.extratext="";$_.extratextsubspace="";$_.extratextsplit="";$_.extratextlinegaps=1.2;$_.extratextcolor="unset";$_.extratextxalign="left";$_.extratextyalign="above";$_.extratextfont="OCR-B";$_.extratextdirection="forward";$_.extratextsize=10;$_.extratextxoffset=0;$_.extratextyoffset=0;$_.extratextgaps=0;$_.showborder=false;$_.borderleft=0;$_.borderright=0;$_.bordertop=0;$_.borderbottom=0;$_.borderwidth=.25;$F($k[--$j],function(){var _2=$k[--$j];$_[$k[--$j]]=_2});$k[$j++]=$_.opt;delete $_["opt"];$k[$j++]=$_;bwipp_processoptions();$j--;if($_.inkspreadh==null){$_.inkspreadh=$_.inkspread}if($_.inkspreadv==null){$_.inkspreadv=$_.inkspread}if($ne($_.textxalign,"unset")){$k[$j++]=Infinity;var _A="offleft";var _B="left";var _C="center";var _D="right";var _E="offright";$k[$j++]=_A;$k[$j++]=_A;$k[$j++]=_B;$k[$j++]=_B;$k[$j++]=_C;$k[$j++]=_C;$k[$j++]=_D;$k[$j++]=_D;$k[$j++]=_E;$k[$j++]=_E;var _H=$g($d(),$_.textxalign)!==undefined;if(!_H){$k[$j++]="bwipp.renmatrixBadTextxalign#33458";$k[$j++]="textxalign must be offleft, left, center, right or offright";bwipp_raiseerror()}}if($ne($_.textyalign,"unset")){$k[$j++]=Infinity;var _J="above";var _K="top";var _L="center";var _M="bottom";var _N="below";$k[$j++]=_J;$k[$j++]=_J;$k[$j++]=_K;$k[$j++]=_K;$k[$j++]=_L;$k[$j++]=_L;$k[$j++]=_M;$k[$j++]=_M;$k[$j++]=_N;$k[$j++]=_N;var _Q=$g($d(),$_.textyalign)!==undefined;if(!_Q){$k[$j++]="bwipp.renmatrixBadTextyalign#33464";$k[$j++]="textyalign must be above, top, center, bottom or below";bwipp_raiseerror()}}$k[$j++]=Infinity;var _R="forward";var _S="backward";var _T="upward";var _U="downward";$k[$j++]=_R;$k[$j++]=_R;$k[$j++]=_S;$k[$j++]=_S;$k[$j++]=_T;$k[$j++]=_T;$k[$j++]=_U;$k[$j++]=_U;var _X=$g($d(),$_.textdirection)!==undefined;if(!_X){$k[$j++]="bwipp.renmatrixBadTextdirection#33469";$k[$j++]="textdirection must be forward, backward, upward or downward";bwipp_raiseerror()}if($_.textsize<=0||$_.textsize>=25){$k[$j++]="bwipp.renmatrixBadTextsize#33473";$k[$j++]="textsize must be greater than zero and less that 25";bwipp_raiseerror()}$k[$j++]=Infinity;var _a="offleft";var _b="left";var _c="center";var _d="right";var _e="offright";$k[$j++]=_a;$k[$j++]=_a;$k[$j++]=_b;$k[$j++]=_b;$k[$j++]=_c;$k[$j++]=_c;$k[$j++]=_d;$k[$j++]=_d;$k[$j++]=_e;$k[$j++]=_e;var _h=$g($d(),$_.extratextxalign)!==undefined;if(!_h){$k[$j++]="bwipp.renmatrixBadExtratextxalign#33477";$k[$j++]="extratextxalign must be offleft, left, center, right or offright";bwipp_raiseerror()}$k[$j++]=Infinity;var _i="above";var _j="top";var _k="center";var _l="bottom";var _m="below";$k[$j++]=_i;$k[$j++]=_i;$k[$j++]=_j;$k[$j++]=_j;$k[$j++]=_k;$k[$j++]=_k;$k[$j++]=_l;$k[$j++]=_l;$k[$j++]=_m;$k[$j++]=_m;var _p=$g($d(),$_.extratextyalign)!==undefined;if(!_p){$k[$j++]="bwipp.renmatrixBadExtratextyalign#33481";$k[$j++]="extratextyalign must be above, top, center, bottom or below";bwipp_raiseerror()}$k[$j++]=Infinity;var _q="forward";var _r="backward";var _s="upward";var _t="downward";$k[$j++]=_q;$k[$j++]=_q;$k[$j++]=_r;$k[$j++]=_r;$k[$j++]=_s;$k[$j++]=_s;$k[$j++]=_t;$k[$j++]=_t;var _w=$g($d(),$_.extratextdirection)!==undefined;if(!_w){$k[$j++]="bwipp.renmatrixBadExtratextdirection#33485";$k[$j++]="extratextdirection must be forward, backward, upward or downward";bwipp_raiseerror()}if($_.extratextsize<=0||$_.extratextsize>=25){$k[$j++]="bwipp.renmatrixBadTextsize#33489";$k[$j++]="extratextsize must be greater than zero and less that 25";bwipp_raiseerror()}$_.xyget=function(){var _10=$k[--$j];var _13=$g($_.pixs,$f($k[--$j]+_10*$_.pixx));$k[$j++]=_13};$_.drawlayerdots=function(){$_.pixsorig=$_.pixs;$_.pixs=$k[--$j];$$.newpath();for(var _18=0,_17=$_.pixs.length-1;_18<=_17;_18+=1){$_.x=_18%$_.pixx;$_.y=~~(_18/$_.pixx);$k[$j++]=$_.x;$k[$j++]=$_.y;$_.xyget();if($k[--$j]==1){$$.moveto($f($_.x+.5),$f($_.pixy-$_.y-.5));$$.arc($f($_.x+.5),$f($_.pixy-$_.y-.5),$f(.5-$_.inkspread),0,360,1)}}$$.fill();$_.pixs=$_.pixsorig};$$.save();var _1M=$$.currpos();$$.translate(_1M.x,_1M.y);$_.inkspread=$_.inkspread/2;$_.inkspreadh=$_.inkspreadh/2;$_.inkspreadv=$_.inkspreadv/2;$$.scale($_.width/$_.pixx*72,$_.height/$_.pixy*72);if($_.showborder){$_.tl=$a([-$f($_.borderleft+$_.borderwidth/2),$f($_.pixy+$_.bordertop+$_.borderwidth/2)]);$_.tr=$a([$f($_.pixx+$_.borderright+$_.borderwidth/2),$f($_.pixy+$_.bordertop+$_.borderwidth/2)]);$_.bl=$a([-$f($_.borderleft+$_.borderwidth/2),-$f($_.borderbottom+$_.borderwidth/2)]);$_.br=$a([$f($_.pixx+$_.borderright+$_.borderwidth/2),-$f($_.borderbottom+$_.borderwidth/2)])}else{$_.tl=$a([$f(-$_.borderleft+$_.inkspread),$f($_.pixy+$_.bordertop-$_.inkspread)]);$_.tr=$a([$f($_.pixx+$_.borderright-$_.inkspread),$f($_.pixy+$_.bordertop-$_.inkspread)]);$_.bl=$a([$f(-$_.borderleft+$_.inkspread),$f(-$_.borderbottom+$_.inkspread)]);$_.br=$a([$f($_.pixx+$_.borderright-$_.inkspread),$f(-$_.borderbottom+$_.inkspread)])}if($_.showborder){$$.save();$$.newpath();$q($_.bl);var _2J=$k[--$j];$$.moveto($k[--$j],_2J);var _2O=$a([$_.br,$_.tr,$_.tl]);for(var _2P=0,_2Q=_2O.length;_2P<_2Q;_2P++){$q($g(_2O,_2P));var _2S=$k[--$j];$$.lineto($k[--$j],_2S)}$$.closepath();if($ne($_.bordercolor,"unset")){$$.setcolor($_.bordercolor)}$$.setlinewidth($f($_.borderwidth-$_.inkspread*2));$$.stroke();$$.restore()}if($eq($_.colormap,"unset")){var _2a=new Map([[1,$_.barcolor]]);$_.colormap=_2a}var _2b=$_.colormap;for(var _2g=_2b.size,_2f=_2b.keys(),_2e=0;_2e<_2g;_2e++){var _2c=_2f.next().value;var _2d=_2b.get(_2c);$k[$j++]=_2c;$k[$j++]=_2d;if($ne(_2d,"unset")){$$.setcolor($k[--$j])}else{$j--}$_.key=$k[--$j];$k[$j++]=Infinity;var _2j=$_.pixs;for(var _2k=0,_2l=_2j.length;_2k<_2l;_2k++){var _2o=$eq($g(_2j,_2k),$_.key)?1:0;$k[$j++]=_2o}var _2p=$a();$k[$j++]=_2p;if($_.dotty){$_.drawlayerdots()}else{$$.drawlayer($k[--$j],$_.pixx,$_.pixy,$_.inkspreadh,$_.inkspreadv)}}var _38=new Map([["offleft",function(){$k[$j++]=$f(-$_.tw-$_.nudge)}],["below",function(){$k[$j++]=$f(-$_.th-$_.nudge)}],["left",function(){$k[$j++]=0}],["bottom",function(){$k[$j++]=0}],["xcenter",function(){$k[$j++]=$f($_.pixx-$_.tw)/2}],["ycenter",function(){$k[$j++]=$f($_.pixy-$_.th)/2}],["right",function(){$k[$j++]=$f($_.pixx-$_.tw)}],["top",function(){$k[$j++]=$f($_.pixy-$_.th)}],["offright",function(){$k[$j++]=$_.pixx+$_.nudge}],["above",function(){$k[$j++]=$_.pixy+$_.nudge}]]);var _3P=new Map([["offleft",function(){$k[$j++]=0-$_.nudge}],["below",function(){$k[$j++]=0-$_.nudge}],["left",function(){$k[$j++]=$_.tw}],["bottom",function(){$k[$j++]=$_.th}],["xcenter",function(){$k[$j++]=$f($_.pixx+$_.tw)/2}],["ycenter",function(){$k[$j++]=$f($_.pixy+$_.th)/2}],["right",function(){$k[$j++]=$_.pixx}],["top",function(){$k[$j++]=$_.pixy}],["offright",function(){$k[$j++]=$f($_.pixx+$_.tw+$_.nudge)}],["above",function(){$k[$j++]=$f($_.pixy+$_.th+$_.nudge)}]]);var _3g=new Map([["offleft",function(){$k[$j++]=0-$_.nudge}],["below",function(){$k[$j++]=$f(-$_.tw-$_.nudge)}],["left",function(){$k[$j++]=$_.th}],["bottom",function(){$k[$j++]=0}],["xcenter",function(){$k[$j++]=$f($_.pixx+$_.th)/2}],["ycenter",function(){$k[$j++]=$f($_.pixy-$_.tw)/2}],["right",function(){$k[$j++]=$_.pixx}],["top",function(){$k[$j++]=$f($_.pixy-$_.tw)}],["offright",function(){$k[$j++]=$f($_.pixx+$_.th+$_.nudge)}],["above",function(){$k[$j++]=$_.pixy+$_.nudge}]]);var _3x=new Map([["offleft",function(){$k[$j++]=$f(-$_.th-$_.nudge)}],["below",function(){$k[$j++]=0-$_.nudge}],["left",function(){$k[$j++]=0}],["bottom",function(){$k[$j++]=$_.tw}],["xcenter",function(){$k[$j++]=$f($_.pixx-$_.th)/2}],["ycenter",function(){$k[$j++]=$f($_.pixy+$_.tw)/2}],["right",function(){$k[$j++]=$f($_.pixx-$_.th)}],["top",function(){$k[$j++]=$_.pixy}],["offright",function(){$k[$j++]=$_.pixx+$_.nudge}],["above",function(){$k[$j++]=$f($_.pixy+$_.tw+$_.nudge)}]]);var _3y=new Map([["forward",_38],["backward",_3P],["upward",_3g],["downward",_3x]]);$_.positions=_3y;$_.positiontext=function(){$_.th=$k[--$j];$_.tw=$k[--$j];$_.nudge=1;var _43=$g($_.positions,$k[--$j]);$k[$j++]=_43;$k[$j++]=_43;$r(4,-1);var _44=$k[$j-1];if($eq(_44,"center")){$k[$j-1]="xcenter"}var _45=$k[--$j];if($g($k[--$j],_45)()===true){return true}var _48=$k[--$j];var _49=$k[--$j];$k[$j++]=_48;$k[$j++]=_49;$r(3,-1);var _4A=$k[$j-1];if($eq(_4A,"center")){$k[$j-1]="ycenter"}var _4B=$k[--$j];if($g($k[--$j],_4B)()===true){return true}};if($_.includetext){if($ne($_.textcolor,"unset")){$$.setcolor($_.textcolor)}if($eq($_.textxalign,"unset")&&$eq($_.textyalign,"unset")&&$_.alttext.length==0){$_.s=0;$_.fn="";var _4K=$_.txt;for(var _4L=0,_4M=_4K.length;_4L<_4M;_4L++){$q($g(_4K,_4L));var _4O=$k[$j-1];var _4P=$k[$j-2];if(_4O!=$_.s||$ne(_4P,$_.fn)){var _4S=$k[$j-1];if(_4S<=0){$j-=5;$k[$j++]="bwipp.renmatrixFontTooSmall#33793";$k[$j++]="The font size is too small";bwipp_raiseerror()}var _4T=$k[--$j];var _4U=$k[--$j];$_.s=_4T;$_.fn=_4U;$$.selectfont(_4U,_4T)}else{$j-=2}var _4V=$k[--$j];$$.moveto($k[--$j],_4V);$$.show($k[--$j],0,0)}}else{if($_.alttext.length==0){$k[$j++]=Infinity;var _4Z=$_.txt;for(var _4a=0,_4b=_4Z.length;_4a<_4b;_4a++){$F($g($g(_4Z,_4a),0))}$_.txt=$a();$_.tstr=$s($_.txt.length);for(var _4j=0,_4i=$_.txt.length-1;_4j<=_4i;_4j+=1){$p($_.tstr,_4j,$g($_.txt,_4j))}}else{$_.tstr=$_.alttext;for(var _4q=0,_4p=$_.alttext.length-1;_4q<=_4p;_4q+=1){$k[$j++]=_4q;$X($_.alttextsubspace,$G($_.alttext,_4q,1));if($k[--$j]){$j--;$j--;var _4z=$k[$j-2];$p($_.alttext,_4z,32)}$j-=2}}if($_.alttext.length!=0&&$_.alttextsplit.length!=0){if($_.alttextsplit.length!=1){$k[$j++]="bwipp.alttextsplitBad#33821";$k[$j++]="The alttextsplit option must be a single character";bwipp_raiseerror()}$k[$j++]=Infinity;$k[$j++]=$_.tstr;for(;;){$X($k[--$j],$_.alttextsplit);if($k[--$j]){var _57=$k[--$j];$k[$j-1]=_57;var _59=$k[--$j];var _5A=$k[--$j];$k[$j++]=_59;$k[$j++]=_5A}else{break}}$_.textlines=$a()}else{$_.textlines=$a([$_.tstr])}$$.selectfont($_.textfont,$_.textsize);if($_.tstr.length==0){$k[$j++]=0}else{$$.save();$$.newpath();$$.moveto(0,0);$$.charpath("0",false);var _5H=$$.pathbbox();$$.restore();$k[$j++]=_5H.ury}$_.textascent=$k[--$j];var _5J=$_.textlines;$k[$j++]="textwidth";$k[$j++]=0;for(var _5K=0,_5L=_5J.length;_5K<_5L;_5K++){var _5N=$$.stringwidth($g(_5J,_5K));var _5O=$k[--$j];var _5P=_5N.w;if(_5O<_5N.w){var _=_5P;_5P=_5O;_5O=_}$k[$j++]=_5O}var _5S=$k[--$j];$_[$k[--$j]]=$f(_5S+($_.tstr.length-1)*$_.textgaps);var _5V=$_.textlines.length;$_.textheight=$f(_5V*$_.textascent+(_5V-1)*$_.textlinegaps);if($eq($_.textxalign,"unset")){$_.textxalign="center"}if($eq($_.textyalign,"unset")){$_.textyalign="below"}if($eq($_.textxalign,"justify")){if($ne($_.textdirection,"forward")&&$ne($_.textdirection,"backward")){$k[$j++]="bwipp.textxjustify#33858";$k[$j++]="textxalign=justify requires forward or backward text";bwipp_raiseerror()}if($_.textwidth<$_.pixx){$_.textgaps=$f($_.pixx-$_.textwidth)/($_.tstr.length-1);$k[$j++]="textxalign";if($eq($_.textdirection,"forward")){$k[$j++]="left"}else{$k[$j++]="right"}var _5j=$k[--$j];$_[$k[--$j]]=_5j}else{$_.textgaps=0;$_.textxalign="center"}}if($eq($_.textyalign,"justify")){if($ne($_.textdirection,"upward")&&$ne($_.textdirection,"downward")){$k[$j++]="bwipp.textyjustify#33871";$k[$j++]="textyalign=justify requires upward or downward text";bwipp_raiseerror()}if($_.textwidth<$_.pixy){$_.textgaps=$f($_.pixy-$_.textwidth)/($_.tstr.length-1);$k[$j++]="textyalign";if($eq($_.textdirection,"upward")){$k[$j++]="bottom"}else{$k[$j++]="top"}var _5u=$k[--$j];$_[$k[--$j]]=_5u}else{$_.textgaps=0;$_.textyalign="center"}}$k[$j++]=$_.textxalign;$k[$j++]=$_.textyalign;$k[$j++]=$_.textdirection;$k[$j++]=$_.textwidth;$k[$j++]=$_.textheight;$_.positiontext();var _61=$k[--$j];$$.moveto($k[--$j],_61);$$.rmoveto($_.textxoffset,$_.textyoffset);$$.save();var _65=new Map([["forward",0],["upward",90],["backward",180],["downward",270]]);$$.rotate($g(_65,$_.textdirection));var _68=$$.currpos();$$.translate(_68.x,_68.y);for(var _6B=0,_6A=$_.textlines.length-1;_6B<=_6A;_6B+=1){$_.i=_6B;$$.moveto(0,0+$f($_.textascent+$_.textlinegaps)*$_.i);var _6G=$_.textlines;$$.show($g(_6G,_6G.length-$_.i-1),$_.textgaps,0)}$$.restore()}}if($_.extratext.length!=0){for(var _6M=0,_6L=$_.extratext.length-1;_6M<=_6L;_6M+=1){$k[$j++]=_6M;$X($_.extratextsubspace,$G($_.extratext,_6M,1));if($k[--$j]){$j--;$j--;var _6V=$k[$j-2];$p($_.extratext,_6V,32)}$j-=2}if($_.extratextsplit.length!=0){if($_.extratextsplit.length!=1){$k[$j++]="bwipp.extratextsplitBad#33911";$k[$j++]="The extratextsplit option must be a single character";bwipp_raiseerror()}$k[$j++]=Infinity;$k[$j++]=$_.extratext;for(;;){$X($k[--$j],$_.extratextsplit);if($k[--$j]){var _6c=$k[--$j];$k[$j-1]=_6c;var _6e=$k[--$j];var _6f=$k[--$j];$k[$j++]=_6e;$k[$j++]=_6f}else{break}}$_.textlines=$a()}else{$_.textlines=$a([$_.extratext])}if($ne($_.extratextcolor,"unset")){$$.setcolor($_.extratextcolor)}$$.selectfont($_.extratextfont,$_.extratextsize);$$.save();$$.newpath();$$.moveto(0,0);$$.charpath("0",false);var _6n=$$.pathbbox();$$.restore();$_.textascent=_6n.ury;var _6o=$_.textlines;$k[$j++]="textwidth";$k[$j++]=0;for(var _6p=0,_6q=_6o.length;_6p<_6q;_6p++){var _6s=$$.stringwidth($g(_6o,_6p));var _6t=$k[--$j];var _6u=_6s.w;if(_6t<_6s.w){var _=_6u;_6u=_6t;_6t=_}$k[$j++]=_6t}var _6x=$k[--$j];$_[$k[--$j]]=$f(_6x+($_.extratext.length-1)*$_.extratextgaps);var _70=$_.textlines.length;$_.textheight=$f(_70*$_.textascent+(_70-1)*$_.extratextlinegaps);if($eq($_.extratextxalign,"justify")){if($ne($_.extratextdirection,"forward")&&$ne($_.extratextdirection,"backward")){$k[$j++]="bwipp.extratextxjustify#33942";$k[$j++]="extratextxalign=justify requires forward or backward text";bwipp_raiseerror()}if($_.textwidth<$_.pixx){$_.extratextgaps=$f($_.pixx-$_.textwidth)/($_.extratext.length-1);$k[$j++]="extratextxalign";if($eq($_.extratextdirection,"forward")){$k[$j++]="left"}else{$k[$j++]="right"}var _7C=$k[--$j];$_[$k[--$j]]=_7C}else{$_.extratextgaps=0;$_.extratextxalign="center"}}if($eq($_.extratextyalign,"justify")){if($ne($_.extratextdirection,"upward")&&$ne($_.extratextdirection,"downward")){$k[$j++]="bwipp.extratextyjustify#33955";$k[$j++]="extratextyalign=justify requires upward or downward text";bwipp_raiseerror()}if($_.textwidth<$_.pixy){$_.extratextgaps=$f($_.pixy-$_.textwidth)/($_.extratext.length-1);$k[$j++]="extratextyalign";if($eq($_.extratextdirection,"upward")){$k[$j++]="bottom"}else{$k[$j++]="top"}var _7N=$k[--$j];$_[$k[--$j]]=_7N}else{$_.extratextgaps=0;$_.extratextyalign="center"}}$k[$j++]=$_.extratextxalign;$k[$j++]=$_.extratextyalign;$k[$j++]=$_.extratextdirection;$k[$j++]=$_.textwidth;$k[$j++]=$_.textheight;$_.positiontext();var _7U=$k[--$j];$$.moveto($k[--$j],_7U);$$.rmoveto($_.extratextxoffset,$_.extratextyoffset);$$.save();var _7Y=new Map([["forward",0],["upward",90],["backward",180],["downward",270]]);$$.rotate($g(_7Y,$_.extratextdirection));var _7b=$$.currpos();$$.translate(_7b.x,_7b.y);for(var _7e=0,_7d=$_.textlines.length-1;_7e<=_7d;_7e+=1){$_.i=_7e;$$.moveto(0,0+$f($_.textascent+$_.extratextlinegaps)*$_.i);var _7j=$_.textlines;$$.show($g(_7j,_7j.length-$_.i-1),$_.extratextgaps,0)}$$.restore()}$$.restore();$_=$__}function bwipp_renmaximatrix(){if($_.bwipjs_rawstack){$_.bwipjs_rawstack.push($k[--$j]);return}var $__=$_;$_=Object.assign({},$_);$_.barcolor="unset";$_.bordercolor="unset";$_.inkspread=0;$_.showborder=false;$_.borderleft=0;$_.borderright=0;$_.bordertop=0;$_.borderbottom=0;$_.borderwidth=.25;$F($k[--$j],function(){var _1=$k[--$j];$_[$k[--$j]]=_1});$k[$j++]=$_.opt;delete $_["opt"];$k[$j++]=$_;bwipp_processoptions();$j--;$$.save();if($_.showborder){$_.tl=$a([-$f($_.borderleft+$_.borderwidth/2),$f(29+$_.bordertop+$_.borderwidth/2)]);$_.tr=$a([$f(30+$_.borderright+$_.borderwidth/2),$f(29+$_.bordertop+$_.borderwidth/2)]);$_.bl=$a([-$f($_.borderleft+$_.borderwidth/2),-$f($_.borderbottom+$_.borderwidth/2)]);$_.br=$a([$f(30+$_.borderright+$_.borderwidth/2),-$f($_.borderbottom+$_.borderwidth/2)])}else{$_.tl=$a([-$_.borderleft+$_.inkspread,29+$_.bordertop-$_.inkspread]);$_.tr=$a([30+$_.borderright-$_.inkspread,29+$_.bordertop-$_.inkspread]);$_.bl=$a([-$_.borderleft+$_.inkspread,-$_.borderbottom+$_.inkspread]);$_.br=$a([30+$_.borderright-$_.inkspread,-$_.borderbottom+$_.inkspread])}if($_.showborder){$$.save();$$.newpath();$q($_.bl);var _l=$k[--$j];$$.moveto($k[--$j],_l);var _q=$a([$_.br,$_.tr,$_.tl]);for(var _r=0,_s=_q.length;_r<_s;_r++){$q($g(_q,_r));var _u=$k[--$j];$$.lineto($k[--$j],_u)}$$.closepath();if($ne($_.bordercolor,"unset")){$$.setcolor($_.bordercolor)}$$.setlinewidth($f($_.borderwidth-$_.inkspread*2));$$.stroke();$$.restore()}if($ne($_.barcolor,"unset")){$$.setcolor($_.barcolor)}$$.showmaxicode($_.pixs);$$.restore();$_=$__}function bwipp_encode(bwipjs,encoder,text,opts,dontdraw){if(typeof text!=="string"){throw new Error("bwipp.typeError: barcode text not a string ("+text+")")}opts=opts||{};if(typeof opts==="string"){var tmp=opts.split(" ");opts={};for(var i=0;i<tmp.length;i++){if(!tmp[i]){continue}var eq=tmp[i].indexOf("=");if(eq==-1){if(tmp[i][0]=="!"){opts[tmp[i].substr(1)]=false}else{opts[tmp[i]]=true}}else{opts[tmp[i].substr(0,eq)]=tmp[i].substr(eq+1)}}}else if(typeof opts!=="object"||opts.constructor!==Object){throw new Error("bwipp.typeError: options not an object")}if(opts.binarytext){if(/[\u0100-\uffff]/.test(text)){throw new Error("bwip-js: 16-bit chars not allowed with binarytext")}}else if(/[\u0080-\uffff]/.test(text)){text=unescape(encodeURIComponent(text))}var map=new Map;for(var id in opts){if(opts.hasOwnProperty(id)){map.set(id,opts[id])}}$$=bwipjs;$k=[text,map];$j=2;$_={bwipjs_rawstack:opts.dontdraw||dontdraw?[]:false};encoder();if($_.bwipjs_rawstack){return $_.bwipjs_rawstack}return true}function bwipp_lookup(symbol){if(!symbol){throw new Error("bwipp.undefinedEncoder: bcid is not defined")}switch(symbol.replace(/-/g,"_")){case"auspost":return bwipp_auspost;case"azteccode":return bwipp_azteccode;case"azteccodecompact":return bwipp_azteccodecompact;case"aztecrune":return bwipp_aztecrune;case"bc412":return bwipp_bc412;case"channelcode":return bwipp_channelcode;case"codablockf":return bwipp_codablockf;case"code11":return bwipp_code11;case"code128":return bwipp_code128;case"code16k":return bwipp_code16k;case"code2of5":return bwipp_code2of5;case"code32":return bwipp_code32;case"code39":return bwipp_code39;case"code39ext":return bwipp_code39ext;case"code49":return bwipp_code49;case"code93":return bwipp_code93;case"code93ext":return bwipp_code93ext;case"codeone":return bwipp_codeone;case"coop2of5":return bwipp_coop2of5;case"daft":return bwipp_daft;case"databarexpanded":return bwipp_databarexpanded;case"databarexpandedcomposite":return bwipp_databarexpandedcomposite;case"databarexpandedstacked":return bwipp_databarexpandedstacked;case"databarexpandedstackedcomposite":return bwipp_databarexpandedstackedcomposite;case"databarlimited":return bwipp_databarlimited;case"databarlimitedcomposite":return bwipp_databarlimitedcomposite;case"databaromni":return bwipp_databaromni;case"databaromnicomposite":return bwipp_databaromnicomposite;case"databarstacked":return bwipp_databarstacked;case"databarstackedcomposite":return bwipp_databarstackedcomposite;case"databarstackedomni":return bwipp_databarstackedomni;case"databarstackedomnicomposite":return bwipp_databarstackedomnicomposite;case"databartruncated":return bwipp_databartruncated;case"databartruncatedcomposite":return bwipp_databartruncatedcomposite;case"datalogic2of5":return bwipp_datalogic2of5;case"datamatrix":return bwipp_datamatrix;case"datamatrixrectangular":return bwipp_datamatrixrectangular;case"datamatrixrectangularextension":return bwipp_datamatrixrectangularextension;case"dotcode":return bwipp_dotcode;case"ean13":return bwipp_ean13;case"ean13composite":return bwipp_ean13composite;case"ean14":return bwipp_ean14;case"ean2":return bwipp_ean2;case"ean5":return bwipp_ean5;case"ean8":return bwipp_ean8;case"ean8composite":return bwipp_ean8composite;case"flattermarken":return bwipp_flattermarken;case"gs1_128":return bwipp_gs1_128;case"gs1_128composite":return bwipp_gs1_128composite;case"gs1_cc":return bwipp_gs1_cc;case"gs1datamatrix":return bwipp_gs1datamatrix;case"gs1datamatrixrectangular":return bwipp_gs1datamatrixrectangular;case"gs1dldatamatrix":return bwipp_gs1dldatamatrix;case"gs1dlqrcode":return bwipp_gs1dlqrcode;case"gs1dotcode":return bwipp_gs1dotcode;case"gs1northamericancoupon":return bwipp_gs1northamericancoupon;case"gs1qrcode":return bwipp_gs1qrcode;case"hanxin":return bwipp_hanxin;case"hibcazteccode":return bwipp_hibcazteccode;case"hibccodablockf":return bwipp_hibccodablockf;case"hibccode128":return bwipp_hibccode128;case"hibccode39":return bwipp_hibccode39;case"hibcdatamatrix":return bwipp_hibcdatamatrix;case"hibcdatamatrixrectangular":return bwipp_hibcdatamatrixrectangular;case"hibcmicropdf417":return bwipp_hibcmicropdf417;case"hibcpdf417":return bwipp_hibcpdf417;case"hibcqrcode":return bwipp_hibcqrcode;case"iata2of5":return bwipp_iata2of5;case"identcode":return bwipp_identcode;case"industrial2of5":return bwipp_industrial2of5;case"interleaved2of5":return bwipp_interleaved2of5;case"isbn":return bwipp_isbn;case"ismn":return bwipp_ismn;case"issn":return bwipp_issn;case"itf14":return bwipp_itf14;case"jabcode":return bwipp_jabcode;case"japanpost":return bwipp_japanpost;case"kix":return bwipp_kix;case"leitcode":return bwipp_leitcode;case"mailmark":return bwipp_mailmark;case"mands":return bwipp_mands;case"matrix2of5":return bwipp_matrix2of5;case"maxicode":return bwipp_maxicode;case"micropdf417":return bwipp_micropdf417;case"microqrcode":return bwipp_microqrcode;case"msi":return bwipp_msi;case"onecode":return bwipp_onecode;case"pdf417":return bwipp_pdf417;case"pdf417compact":return bwipp_pdf417compact;case"pharmacode":return bwipp_pharmacode;case"pharmacode2":return bwipp_pharmacode2;case"planet":return bwipp_planet;case"plessey":return bwipp_plessey;case"posicode":return bwipp_posicode;case"postnet":return bwipp_postnet;case"pzn":return bwipp_pzn;case"qrcode":return bwipp_qrcode;case"rationalizedCodabar":return bwipp_rationalizedCodabar;case"raw":return bwipp_raw;case"rectangularmicroqrcode":return bwipp_rectangularmicroqrcode;case"royalmail":return bwipp_royalmail;case"sscc18":return bwipp_sscc18;case"swissqrcode":return bwipp_swissqrcode;case"symbol":return bwipp_symbol;case"telepen":return bwipp_telepen;case"telepennumeric":return bwipp_telepennumeric;case"ultracode":return bwipp_ultracode;case"upca":return bwipp_upca;case"upcacomposite":return bwipp_upcacomposite;case"upce":return bwipp_upce;case"upcecomposite":return bwipp_upcecomposite}throw new Error("bwipp.unknownEncoder: unknown encoder name: "+symbol)}var BWIPP_VERSION="2025-10-24";
const BWIPJS_VERSION="4.8.0 (2025-11-11)";function IsCanvas(r){return r&&/HTMLCanvasElement|OffscreenCanvas/.test(Object.getPrototypeOf(r).constructor.name)}function ToCanvas(t,e){if(typeof e=="string"||IsCanvas(e)){let r=t;t=e;e=r}return _ToAny(bwipp_lookup(e.bcid),e,t)}function _ToAny(r,t,e){if(typeof t=="string"){var i=document.getElementById(t)||document.querySelector(t);if(!IsCanvas(i)){throw new Error("bwipjs: `"+t+"`: not a canvas")}t=e;e=DrawingCanvas(i)}else if(IsCanvas(t)){var i=t;t=e;e=DrawingCanvas(i)}else if(typeof e=="string"){var i=document.getElementById(e)||document.querySelector(e);if(!IsCanvas(i)){throw new Error("bwipjs: `"+e+"`: not a canvas")}e=DrawingCanvas(i)}else if(IsCanvas(e)){e=DrawingCanvas(e)}else if(!e||typeof e!="object"||!e.init){throw new Error("bwipjs: not a canvas or drawing object")}return _Render(r,t,e)}function ToSVG(r){return _Render(bwipp_lookup(r.bcid),r,DrawingSVG())}function FixupOptions(r){var t=r.scale||2;var e=+r.scaleX||t;var i=+r.scaleY||e;r.paddingleft=u(r.paddingleft,r.paddingwidth,r.padding,e);r.paddingright=u(r.paddingright,r.paddingwidth,r.padding,e);r.paddingtop=u(r.paddingtop,r.paddingheight,r.padding,i);r.paddingbottom=u(r.paddingbottom,r.paddingheight,r.padding,i);if(r.backgroundcolor){var n=""+r.backgroundcolor;if(/^[0-9a-fA-F]{8}$/.test(n)){var a=parseInt(n.substr(0,2),16)/255;var s=parseInt(n.substr(2,2),16)/255;var f=parseInt(n.substr(4,2),16)/255;var o=parseInt(n.substr(6,2),16)/255;var h=Math.floor((1-a)*(1-o)*255).toString(16);var v=Math.floor((1-s)*(1-o)*255).toString(16);var l=Math.floor((1-f)*(1-o)*255).toString(16);r.backgroundcolor=(h.length==1?"0":"")+h+(v.length==1?"0":"")+v+(l.length==1?"0":"")+l}else{if(n[0]=="#"){n=n.substr(1)}if(/^[0-9a-fA-F]{6}$/.test(n)){r.backgroundcolor=n}else if(/^[0-9a-fA-F]{3}$/.test(n)){r.backgroundcolor=n[0]+n[0]+n[1]+n[1]+n[2]+n[2]}else{throw new Error("bwip-js: invalid backgroundcolor: "+r.backgroundcolor)}}}return r;function u(r,t,e,i){if(r!=null){r=r>>>0;return r*i>>>0}if(t!=null){t=t>>>0;return t*i>>>0}e=e>>>0;return e*i>>>0||0}}var BWIPJS_OPTIONS={bcid:1,text:1,scale:1,scaleX:1,scaleY:1,rotate:1,padding:1,paddingwidth:1,paddingheight:1,paddingtop:1,paddingleft:1,paddingright:1,paddingbottom:1,backgroundcolor:1};function Render(r,t){return _Render(bwipp_lookup(r.bcid),r,t)}function _Render(r,t,e){var i=t.text;if(!i){throw new ReferenceError("bwip-js: bar code text not specified.")}FixupOptions(t);e.setopts&&e.setopts(t);var n=t.scale||2;var a=+t.scaleX||n;var s=+t.scaleY||a;var f=t.rotate||"N";var o=new BWIPJS(e);var h={};for(var v in t){if(!BWIPJS_OPTIONS[v]){h[v]=t[v]}}if(h.alttext){h.includetext=true}if(+h.height&&r!=bwipp_pharmacode2){h.height=h.height/25.4||.5}if(+h.width){h.width=h.width/25.4||0}o.scale(a,s);bwipp_encode(o,r,i,h);return o.render()}function ToRaw(r,t,e){if(arguments.length==1){e=r;r=e.bcid;t=e.text}var i=DrawingBuiltin();i.setopts(e);var n=new BWIPJS(i);var a=bwipp_encode(n,bwipp_lookup(r),t,e,true);var s={pixs:1,pixx:1,pixy:1,sbs:1,bbs:1,bhs:1,width:1,height:1};for(var f=0;f<a.length;f++){var o=a[f];if(o instanceof Map){var h={};for(var v=o.keys(),l=o.size,u=0;u<l;u++){var c=v.next().value;if(s[c]){var p=o.get(c);if(p instanceof Array){h[c]=p.b.slice(p.o,p.o+p.length)}else{h[c]=p}}}a[f]=h}else{a.splice(f--,1)}}return a}var BWIPJS=function(){var M=Math.floor;var o=Math.round;var A=Math.ceil;var j=Math.min;var T=Math.max;function t(r){if(this.constructor!==t){return new t(r)}this.gstk=[];this.cmds=[];this.drawing=r;this.reset();this.minx=this.miny=Infinity;this.maxx=this.maxy=-Infinity}t.prototype.reset=function(){this.g_m0=1;this.g_m1=0;this.g_m2=0;this.g_m3=1;this.g_m4=0;this.g_m5=0;this.g_tsx=1;this.g_tsy=1;this.g_rot=0;this.g_posx=0;this.g_posy=0;this.g_penw=1;this.g_path=[];this.g_font=null;this.g_rgb=[0,0,0];this.g_clip=false};t.prototype.save=function(){var r={};for(var t in this){if(t.indexOf("g_")==0){r[t]=n(this[t])}}this.gstk.push(r);function n(r){if(r instanceof Array){var t=[];for(var e=0;e<r.length;e++)t[e]=n(r[e]);return t}if(r instanceof Object){var t={};for(var i in r)t[i]=n(r[i]);return t}return r}};t.prototype.restore=function(){if(!this.gstk.length){throw new Error("grestore: stack underflow")}var r=this.gstk.pop();var t=this;if(this.g_clip&&!r.g_clip){this.cmds.push(function(){t.drawing.unclip()})}for(var e in r){this[e]=r[e]}};t.prototype.currpos=function(){return{x:(this.g_posx-this.g_m4)/this.g_tsx,y:(this.g_posy-this.g_m5)/this.g_tsy}};t.prototype.currfont=function(){return this.g_font};t.prototype.rotate=function(r){this.g_rot+=r;var t=o(Math.cos(r*Math.PI/180));var e=o(Math.sin(r*Math.PI/180));var i=this.g_m0*t+this.g_m2*e;var n=this.g_m1*t+this.g_m3*e;var a=this.g_m0*-e+this.g_m2*t;var s=this.g_m1*-e+this.g_m3*t;this.g_m0=i;this.g_m1=n;this.g_m2=a;this.g_m3=s};t.prototype.translate=function(r,t){this.g_m4+=this.g_tsx*r;this.g_m5+=this.g_tsy*t};t.prototype.scale=function(r,t){var e=this.g_tsx;var i=this.g_tsy;this.g_tsx*=r;this.g_tsy*=t;var n=this.drawing.scale(this.g_tsx,this.g_tsy);if(n&&n[0]&&n[1]){this.g_tsx=n[0];this.g_tsy=n[1]}this.g_m0*=this.g_tsx/e;this.g_m1*=this.g_tsx/e;this.g_m2*=this.g_tsy/i;this.g_m3*=this.g_tsy/i};t.prototype.setlinewidth=function(r){this.g_penw=r};t.prototype.selectfont=function(r,t){this.g_font={FontName:this.jsstring(r),FontSize:+t}};t.prototype.getfont=function(){return this.g_font.FontName};t.prototype.jsstring=function(r){if(r instanceof Uint8Array){return String.fromCharCode.apply(null,r)}return""+r};t.prototype.setcolor=function(r){if(r instanceof Uint8Array){r=this.jsstring(r)}if(!r){return}if(!/^(?:#?[0-9a-fA-F]{3}(?:[0-9a-fA-F]{3})?|[0-9a-fA-F]{8})$/.test(r)){throw new Error("bwip-js: invalid color: "+r)}if(r[0]=="#"){r=r.substr(1)}if(r.length==3){var t=parseInt(r[0],16);var e=parseInt(r[1],16);var i=parseInt(r[2],16);this.g_rgb=[t<<4|t,e<<4|e,i<<4|i]}else if(r.length==6){var t=parseInt(r.substr(0,2),16);var e=parseInt(r.substr(2,2),16);var i=parseInt(r.substr(4,2),16);this.g_rgb=[t,e,i]}else{var n=parseInt(r.substr(0,2),16)/255;var a=parseInt(r.substr(2,2),16)/255;var s=parseInt(r.substr(4,2),16)/255;var f=parseInt(r.substr(6,2),16)/255;var t=o((1-n)*(1-f)*255);var e=o((1-a)*(1-f)*255);var i=o((1-s)*(1-f)*255);this.g_rgb=[t,e,i]}};t.prototype.setrgbcolor=function(r,t,e){this.g_rgb=[r,t,e]};t.prototype.getRGB=function(){var r=this.g_rgb[0].toString(16);var t=this.g_rgb[1].toString(16);var e=this.g_rgb[2].toString(16);return"00".substr(r.length)+r+"00".substr(t.length)+t+"00".substr(e.length)+e};t.prototype.newpath=function(){this.g_path=[]};t.prototype.closepath=function(){var r=this.g_path;var t=r.length;if(!t)return;var e=t-1;for(;e>=0&&r[e].op=="l";e--);e++;if(e<t-1){var i=[];var n=Infinity;var a=Infinity;var s=-Infinity;var f=-Infinity;for(var o=e;o<t;o++){var h=r[o];i.push([h.x0,h.y0]);if(n>h.x0)n=h.x0;if(s<h.x0)s=h.x0;if(a>h.y0)a=h.y0;if(f<h.y0)f=h.y0}var h=r[t-1];var v=r[e];if(h.x1!=v.x0||h.y1!=v.y0){i.push([h.x1,h.y1]);if(n>h.x1)n=h.x1;if(s<h.x1)s=h.x1;if(a>h.y1)a=h.y1;if(f<h.y1)f=h.y1}r.splice(e,t-e,{op:"p",x0:n,y0:a,x1:s,y1:f,poly:i})}else{r.push({op:"c"})}};t.prototype.moveto=function(r,t){this.g_posx=this.g_m0*r+this.g_m2*t+this.g_m4;this.g_posy=this.g_m1*r+this.g_m3*t+this.g_m5};t.prototype.rmoveto=function(r,t){this.g_posx+=this.g_m0*r+this.g_m2*t+this.g_m4;this.g_posy+=this.g_m1*r+this.g_m3*t+this.g_m5};t.prototype.lineto=function(r,t){var e=o(this.g_posx);var i=o(this.g_posy);this.g_posx=this.g_m0*r+this.g_m2*t+this.g_m4;this.g_posy=this.g_m1*r+this.g_m3*t+this.g_m5;var n=o(this.g_posx);var a=o(this.g_posy);this.g_path.push({op:"l",x0:e,y0:i,x1:n,y1:a})};t.prototype.rlineto=function(r,t){var e=o(this.g_posx);var i=o(this.g_posy);this.g_posx+=this.g_m0*r+this.g_m2*t+this.g_m4;this.g_posy+=this.g_m1*r+this.g_m3*t+this.g_m5;var n=o(this.g_posx);var a=o(this.g_posy);this.g_path.push({op:"l",x0:e,y0:i,x1:n,y1:a})};t.prototype.arc=function(r,t,e,i,n,a){if(i==n){return}if(i!=0&&i!=360||n!=0&&n!=360){throw new Error("arc: not a full circle ("+i+","+n+")")}var s=this.g_m0*r+this.g_m2*t+this.g_m4;var f=this.g_m1*r+this.g_m3*t+this.g_m5;var o=e*this.g_tsx;var h=e*this.g_tsy;this.g_path.push({op:"e",x0:s-o,y0:f-h,x1:s+o,y1:f+h,x:s,y:f,rx:o,ry:h,sa:i,ea:n,ccw:a})};t.prototype.stringwidth=function(r){var t=this.g_tsx;var e=this.g_tsy;var i=+this.g_font.FontSize||10;r=this.toUCS2(this.jsstring(r));var n=this.drawing.measure(r,this.g_font.FontName,i*t,i*e);return{w:n.width/t,h:(n.ascent+n.descent)/e,a:n.ascent/e,d:n.descent/e}};t.prototype.charpath=function(r,t){var e=this.stringwidth(r);this.rlineto(0,e.a);this.rlineto(e.w,0);this.rlineto(0,-e.h)};t.prototype.pathbbox=function(){if(!this.g_path.length)throw new Error("pathbbox: --nocurrentpoint--");var r=this.g_path;var t=Infinity;var e=Infinity;var i=-Infinity;var n=-Infinity;for(var a=0;a<r.length;a++){var s=r[a];if(s.op=="c"){continue}if(s.x0<s.x1){if(t>s.x0)t=s.x0;if(i<s.x1)i=s.x1}else{if(t>s.x1)t=s.x1;if(i<s.x0)i=s.x0}if(s.y0<s.y1){if(e>s.y0)e=s.y0;if(n<s.y1)n=s.y1}else{if(e>s.y1)e=s.y1;if(n<s.y0)n=s.y0}}var f={llx:(t-this.g_m4)/this.g_tsx,lly:(e-this.g_m5)/this.g_tsy,urx:(i-this.g_m4)/this.g_tsx,ury:(n-this.g_m5)/this.g_tsy};return f};t.prototype.transform=function(r){var t=this.minx;var e=this.maxy;for(var i=0;i<r.length;i++){var n=r[i];n[0]=n[0]-t;n[1]=e-n[1]}};t.prototype.stroke=function(){var r=this.g_tsx;var t=this.g_tsy;var l=this.g_path;var u=this.getRGB();this.g_path=[];var c=M(this.g_penw*r+.66);var p=M(this.g_penw*t+.66);var e=0,i=0;for(var n=0;n<l.length;n++){var a=l[n];if(a.op=="l"){if(a.x0!=a.x1&&a.y0!=a.y1){throw new Error("stroke: --not-orthogonal--")}var s=a.x0;var f=a.y0;var o=a.x1;var h=a.y1;var v=c/2;var g=p/2;if(s>o){var y=s;s=o;o=y}if(f>h){var y=f;f=h;h=y}if(s==o){this.bbox(s-v,f,s+c-v-1,h)}else{this.bbox(s,f-p+g+1,o,h+g)}e++}else if(a.op=="p"){var d=Infinity;var x=Infinity;var _=-Infinity;var m=-Infinity;var b=a.poly;if(b.length!=4){throw new Error("stroke: --not-a-rect--")}for(var n=0,w=b.length-1;n<b.length;w=n++){var k=b[w][0];var I=b[w][1];var F=b[n][0];var C=b[n][1];if(F!=k&&C!=I){throw new Error("stroke: --not-orthogonal--")}if(F<d)d=F;if(F>_)_=F;if(C<x)x=C;if(C>m)m=C}var v=A(c/2);var g=A(p/2);this.bbox(d-v,x-g,_+v,m+g);i++}else{throw new Error("stroke: --not-a-line--")}}var S=this;this.cmds.push(function(){var r=A(c/2);var t=A(p/2);var e=c-r;var i=p-t;for(var n=0;n<l.length;n++){var a=l[n];if(a.op=="l"){var s=[[a.x0,a.y0],[a.x1,a.y1]];S.transform(s);S.drawing.line(s[0][0],s[0][1],s[1][0],s[1][1],a.x0==a.x1?c:p,u);S.fill(u)}else{var s=a.poly;S.transform(s);var f=j(s[0][0],s[2][0]);var o=T(s[0][0],s[2][0]);var h=j(s[0][1],s[2][1]);var v=T(s[0][1],s[2][1]);S.drawing.polygon([[f-r,h-t],[f-r,v+t+1],[o+r+1,v+t+1],[o+r+1,h-t]]);S.drawing.polygon([[f+e,h+i],[o-e+1,h+i],[o-e+1,v-i+1],[f+e,v-i+1]]);S.drawing.fill(u)}}})};t.prototype.fill=function(){var i=this.g_path;var n=this.getRGB();this.g_path=[];for(var r=0;r<i.length;r++){var t=i[r];if(t.op=="p"){var e=Infinity;var a=Infinity;var s=-Infinity;var f=-Infinity;var o=t.poly;for(var h=0;h<o.length;h++){var v=o[h][0];var l=o[h][1];if(v<e)e=v;if(v>s)s=v;if(l<a)a=l;if(l>f)f=l}this.bbox(e,a+1,s-1,f)}else if(t.op=="e"){this.bbox(t.x-t.rx,t.y-t.ry,t.x+t.rx,t.y+t.ry)}else{throw new Error("fill: --not-a-polygon--")}}var u=this;this.cmds.push(function(){for(var r=0;r<i.length;r++){var t=i[r];if(t.op=="p"){var e=t.poly;u.transform(e);u.drawing.polygon(e)}else if(t.op=="e"){var e=[[t.x,t.y]];u.transform(e);u.drawing.ellipse(e[0][0],e[0][1],t.rx,t.ry,t.ccw)}}u.drawing.fill(n)})};t.prototype.clip=function(){var n=this.g_path;this.g_path=[];this.g_clip=true;var a=this;this.cmds.push(function(){var r=[];for(var t=0;t<n.length;t++){var e=n[t];if(e.op=="p"){var i=e.poly;a.transform(i);r.push(i)}else{throw new Error("clip: only polygon regions supported")}}a.drawing.clip(r)})};t.prototype.drawlayer=function(r,t,e){let i=tracepaths(r,t,e);this.newpath();for(let r=0,t=i.length;r<t;r++){let e=i[r];this.moveto(e[0][0],e[0][1]);for(let t=1,r=e.length;t<r;t++){let r=e[t];this.lineto(r[0],r[1])}this.closepath()}this.fill()};t.prototype.showmaxicode=function(a){var s=this.g_tsx;var f=this.g_tsy;var o=this.getRGB();var r=1.04*s*100;var h=r/30|0;if(r-(h*30-1)>9){h++}var t,v,e,i;e=s/2|0;i=f/2|0;t=h-e;if(t&1){t--}v=(4*f|0)-i;var l=t/2-1;var u=(l+1)/2|0;var c=v-2-2*u;this.bbox(0,0,h*30-e,f*3*32+f*4-i);var p=this;this.cmds.push(function(){for(var r=0;r<a.length;r++){var t=a[r];var e=t%30;var i=t/30|0;e*=h;e+=i&1?h:h/2;e=e|0;i=33-i;i*=f*3;i+=f*2-v/2;i=i|0;var n=[[e-.5,i--]];i-=u-1;n.push([e-1-l,i--]);i-=c;n.push([e-1-l,i--]);i-=u-1;n.push([e-.5,i++]);i+=u-1;n.push([e+l,i++]);i+=c;n.push([e+l,i++]);p.transform(n);p.drawing.hexagon(n,o)}p.drawing.fill(o);var e=14*h+h/2+.01|0;var i=(12*4+3)*f-u/2+.01|0;p.drawing.ellipse(e,i,.5774*3.5*s+.01|0,.5774*3.5*f+.01|0,true);p.drawing.ellipse(e,i,1.3359*3.5*s+.01|0,1.3359*3.5*f+.01|0,false);p.drawing.fill(o);p.drawing.ellipse(e,i,2.1058*3.5*s+.01|0,2.1058*3.5*f+.01|0,true);p.drawing.ellipse(e,i,2.8644*3.5*s+.01|0,2.8644*3.5*f+.01|0,false);p.drawing.fill(o);p.drawing.ellipse(e,i,3.6229*3.5*s+.01|0,3.6229*3.5*f+.01|0,true);p.drawing.ellipse(e,i,4.3814*3.5*s+.01|0,4.3814*3.5*f+.01|0,false);p.drawing.fill(o)})};t.prototype.toUCS2=function(r){return r.replace(/[\xc0-\xdf][\x80-\xbf]|[\xe0-\xff][\x80-\xbf]{2}/g,function(r){var t;if(r.length==2){t=(r.charCodeAt(0)&31)<<6|r.charCodeAt(1)&63}else{t=(r.charCodeAt(0)&15)<<12|(r.charCodeAt(1)&63)<<6|r.charCodeAt(2)&63}return String.fromCharCode(t)})};t.prototype.show=function(e,i,r){if(!e.length){return}var n=this.g_rot;var t=n==90||n==270?this.g_tsy:this.g_tsx;var a=n==90||n==270?this.g_tsx:this.g_tsy;var s=this.g_font.FontName||"OCR-B";var f=this.g_font.FontSize||10;var o=f*t;var h=f*a;var v=this.g_posx;var l=this.g_posy;var u=this.getRGB();i=t*i||0;r=a*r||0;e=this.toUCS2(this.jsstring(e));var c=this.drawing.measure(e,s,o,h);var p=c.width+(e.length-1)*i;if(n==90){this.bbox(v-r+c.descent-1,l,v-r-c.ascent,l+p-1)}else if(n==180){this.bbox(v,l-r+c.descent-1,v-p+1,l-r-c.ascent)}else if(n==270){this.bbox(v+r-c.descent+1,l,v+r+c.ascent,l-p+1)}else{n=0;this.bbox(v,l+r-c.descent+1,v+p-1,l+r+c.ascent);this.g_posx+=p}var g=this;g.cmds.push(function(){var r=v-g.minx;var t=g.maxy-l;g.drawing.text(r,t,e,u,{name:s,width:o,height:h,rotate:n,dx:i})})};t.prototype.bbox=function(r,t,e,i){if(r>e){var n=r;r=e;e=n}if(t>i){var n=t;t=i;i=n}r=M(r);t=M(t);e=A(e);i=A(i);if(this.minx>r)this.minx=r;if(this.maxx<e)this.maxx=e;if(this.miny>t)this.miny=t;if(this.maxy<i)this.maxy=i};t.prototype.render=function(){if(this.minx===Infinity){return false}this.drawing.init(this.maxx-this.minx+1,this.maxy-this.miny+1,this.g_tsx,this.g_tsy);for(var r=0,t=this.cmds.length;r<t;r++){this.cmds[r]()}return this.drawing.end()};return t}();function tracepaths(e,i,t,r,n){let a=r||0;let s=n||0;let f=new Array(t+1);let o=0;for(let r=t-1;r>=0;r--){let t=new Uint8Array(i);for(let r=0;r<i;r++){t[r]=e[o+r]?1:0}f[r]=t;o+=i}f[-1]=[];f[t]=[];let h=[];for(let e=0;e<t;e++){let t=0;for(let r=0;r<i;r++){if((t&9)==0&&f[e][r]==1){h.push(v(r,e,[]))}else if((t&5)==1&&f[e][r]==0){h.push(l(r,e,[]))}t=f[e][r]}}return h;function v(r,t,e){e.push([r+a,t+s]);let i=2;for(;;){if(f[t][r]&i){e.pop();return e}f[t][r]|=i;if(i==2){if(f[t][r+1]&1){if(f[t-1][r+1]&1){e.push([r+1-a,t+s,"H"]);i=16}r++}else{e.push([r+1-a,t+s,"H"]);i=4}}else if(i==4){if(f[t+1][r]&1){if(f[t+1][r+1]&1){e.push([r+1-a,t+1-s,"V"]);i=2}t++}else{e.push([r+1-a,t+1-s,"V"]);i=8}}else if(i==8){if(f[t][r-1]&1){if(f[t+1][r-1]&1){e.push([r+a,t+1-s,"H"]);i=4}r--}else{e.push([r+a,t+1-s,"H"]);i=16}}else{if(f[t-1][r]&1){if(f[t-1][r-1]&1){e.push([r+a,t+s,"V"]);i=8}t--}else{e.push([r+a,t+s,"V"]);i=2}}}}function l(r,t,e){e.push([r-a,t-s]);let i=2;for(;;){if(f[t][r]&i){e.pop();return e}f[t][r]|=i;if(i==2){if((f[t+1][r]&1)==0){if((f[t+1][r-1]&1)==0){e.push([r-a,t+1+s]);i=16}t++}else{e.push([r-a,t+1+s]);i=4}}else if(i==4){if((f[t][r+1]&1)==0){if((f[t+1][r+1]&1)==0){e.push([r+1+a,t+1+s]);i=2}r++}else{e.push([r+1+a,t+1+s]);i=8}}else if(i==8){if((f[t-1][r]&1)==0){if((f[t-1][r+1]&1)==0){e.push([r+1+a,t-s]);i=4}t--}else{e.push([r+1+a,t-s]);i=16}}else{if((f[t][r-1]&1)==0){if((f[t-1][r-1]&1)==0){e.push([r-a,t-s]);i=8}r--}else{e.push([r-a,t-s]);i=2}}}}}function DrawingBuiltin(){var r=Math.floor;var v=0,l=0,u=0,c=0;var p=0,g=0,y=0,d=0;var h;var x,_;var m,b;var w,k;var j,T,B;var I;var F;return{setopts(r){h=r},scale:function(r,t){if(h.bcid=="swissqrcode"){return[r,t]}else{return[r|0||1,t|0||1]}},measure:function(r,t,e,i){e=e|0;i=i|0;var n=FontLib.lookup(t);var a=0;var s=0;var f=0;for(var o=0,h=r.length;o<h;o++){var v=r.charCodeAt(o);var l=FontLib.getglyph(n,v,e,i);s=Math.max(s,l.top);f=Math.max(f,l.height-l.top);if(o==h-1){a+=l.left+l.width}else{a+=l.advance}}return{width:a,ascent:s,descent:f}},init:function(r,t){var e=h.paddingleft;var i=h.paddingright;var n=h.paddingtop;var a=h.paddingbottom;var s=h.rotate||"N";r+=e+i;t+=n+a;if(+h.sizelimit&&+h.sizelimit<r*t){throw new Error("Image size over limit")}switch(s){case"R":l=-1;u=1;p=1;break;case"I":v=-1;u=1;g=-1;d=1;break;case"L":l=1;p=-1;d=1;break;default:v=g=1;break}var f=s=="L"||s=="R";m=f?t:r;b=f?r:t;w=e;k=n;I=[];I.min=Infinity;F=null;j=T=B=0;var o=this.image(m,b);x=o.buffer;_=o.ispng?1:0},line:function(r,t,e,i,n,a){r=r|0;t=t|0;e=e|0;i=i|0;n=Math.round(n)||1;if(i<t){var s=t;t=i;i=s}if(e<r){var s=r;r=e;e=s}j=parseInt(a.substr(0,2),16);T=parseInt(a.substr(2,2),16);B=parseInt(a.substr(4,2),16);var f=n/2|0;if(r==e){r=r-n+f;e=e+f-1}else{t=t-f;i=i+n-f-1}for(var o=t;o<=i;o++){for(var h=r;h<=e;h++){L(h,o,255)}}},polygon:function(r){var t=r.length;for(var e=t-1,i=0;i<t;e=i++){if(r[e][0]==r[i][0]){var n=r[e][0]|0;var a=r[e][1]|0;var s=r[i][1]|0;if(a>s){for(var f=s+1;f<a;f++){C(n,f)}}else{for(var f=a+1;f<s;f++){C(n,f)}}}else{var n=r[e][0]|0;var o=r[i][0]|0;var a=r[e][1]|0;if(n<o){var h=r[e==0?t-1:e-1][1];var v=r[i==t-1?0:i+1][1];if(h>a){C(n,a)}if(v>a){C(o,a)}}else{var h=r[i==t-1?0:i+1][1];var v=r[e==0?t-1:e-1][1];if(h>a){C(o,a)}if(v>a){C(n,a)}}}}},hexagon:function(r,t){var e=r[0][0]|0;var i=r[0][1]|0;var n=r[1][1]-r[0][1]|0;var a=r[2][1]-r[1][1]-1|0;var s=r[2][0]|0;var f=r[4][0]|0;j=parseInt(t.substr(0,2),16);T=parseInt(t.substr(2,2),16);B=parseInt(t.substr(4,2),16);S(e,e+1,i++);for(var o=1;o<n;o++){S(e-2*o,e+1+2*o,i++)}for(var o=0;o<=a;o++){S(s,f,i++)}for(var o=n-1;o>=1;o--){S(e-2*o,e+1+2*o,i++)}S(e,e+1,i)},ellipse:function(r,t,e,i,n){a(r-e|0,t-i|0,r+e|0,t+i|0,n)},fill:function(r){j=parseInt(r.substr(0,2),16);T=parseInt(r.substr(2,2),16);B=parseInt(r.substr(4,2),16);t();I=[];I.min=Infinity},clip:function(r){if(!F){F=[];F.min=Infinity}var t=I;I=F;for(var e=0,i=r.length;e<i;e++){this.polygon(r[e])}I=t},unclip:function(){F=null},text:function(r,t,e,i,n){r=r|0;t=t|0;j=parseInt(i.substr(0,2),16);T=parseInt(i.substr(2,2),16);B=parseInt(i.substr(4,2),16);var a=FontLib.lookup(n.name);var s=n.width|0;var f=n.height|0;var o=n.dx|0;var h=0,v=0,l=0,u=0;switch(n.rotate){case 90:v=1;l=-1;break;case 180:h=-1;u=-1;break;case 270:v=-1;l=1;break;default:h=1;u=1;break}var c=0;for(var p=0;p<e.length;p++){var g=e.charCodeAt(p);var y=FontLib.getglyph(a,g,s,f);var d=-y.top;var x=y.left;var _=y.width;var m=y.height;var b=y.bytes;var w=y.offset;for(var k=0;k<_;k++){for(var I=0;I<m;I++){var F=b[w+I*_+k];if(F){var C=c+x+k;var S=d+I;var M=h*C+v*S;var A=l*C+u*S;L(r+M,t+A,F)}}}c+=y.advance+o}},end:function(){}};function L(r,t,e){if(F&&M(r,t)){return}r+=w;t+=k;var i=v*r+l*t+u*(m-1)+c*(b-1);var n=p*r+g*t+y*(m-1)+d*(b-1);var a=(n*m+i)*4+(n+1)*_;var s=x[a+3]/255;var f=e/255;var o=(1-f)*s;var h=f+o;x[a+0]=(j*f+x[a+0]*o)/h|0;x[a+1]=(T*f+x[a+1]*o)/h|0;x[a+2]=(B*f+x[a+2]*o)/h|0;x[a+3]=255*h|0}function C(r,t){if(I.min>t)I.min=t;if(!I[t]){I[t]=[r]}else{I[t].push(r)}}function S(r,t,e){while(r<=t){L(r++,e,255)}}function t(){var r=I.min;var t=I.length-1;for(var e=r;e<=t;e++){var i=I[e];if(!i){continue}i.sort(function(r,t){return r-t});var n=false;var a=0;for(var s=0,f=i.length;s<f;s++){var o=i[s];if(n){S(a,o-1,e)}else{a=o}n=!n}}}function a(r,t,e,i,n){r=r|0;t=t|0;e=e|0;i=i|0;var a=Math.abs(e-r);var s=Math.abs(i-t);var f=s&1;var o=4*(1-a)*s*s;var h=4*(f+1)*a*a;var v=o+h+f*a*a;var l;var u=[],c=[];u.min=c.min=Infinity;if(r>e){r=e;e+=a}if(t>i)t=i;t+=(s+1)/2|0;i=t-f;a*=8*a;f=8*s*s;do{d(c,e,t);y(u,r,t);y(u,r,i);d(c,e,i);l=2*v;if(l>=o){r++;e--;o+=f;v+=o}if(l<=h){t++;i--;h+=a;v+=h}}while(r<=e);while(t-i<s){d(c,e+1,t);y(u,r-1,t++);y(u,r-1,i);d(c,e+1,i--)}for(var p=u.min,g=u.length-1;p<=g;p++){C(u[p],p)}for(var p=c.min,g=c.length-1;p<=g;p++){C(c[p]+1,p)}function y(r,t,e){if(r.min>e)r.min=e;var i=r[e];if(i==null||i>t){r[e]=t}}function d(r,t,e){if(r.min>e)r.min=e;var i=r[e];if(i==null||i<t){r[e]=t}}}function M(r,t){var e=F[t];if(!e){return true}if(!e.sorted){e.sort(function(r,t){return r-t});e.sorted=true}var i=false;for(var n=0,a=e.length;n<a;n++){var s=e[n];if(s>r){return!i}else if(s==r){return i}i=!i}return true}function e(r){var t=0;for(var e=0,i=r.length,n=i-1;e<i;n=e++){t+=r[n][0]*r[e][1]-r[e][0]*r[n][1]}return t>0?1:-1}}function DrawingCanvas(e,r){if(IsCanvas(r)){e=r}var i;var n=e.getContext("2d",{willReadFrequently:true});var t=DrawingBuiltin();t.image=f;t.end=o;var a;var s=t.setopts;t.setopts=function(r){a=r;s&&s.call(t,r)};return t;function f(r,t){e.width=r;e.height=t;n.setTransform(1,0,0,1,0,0);if(/^[0-9a-fA-F]{6}$/.test(""+a.backgroundcolor)){n.fillStyle="#"+a.backgroundcolor;n.fillRect(0,0,r,t)}else{n.clearRect(0,0,r,t)}i=n.getImageData(0,0,r,t);return{buffer:i.data,ispng:false}}function o(){n.putImageData(i,0,0);return e}}function DrawingSVG(){var o=0,h=0,v=0,n=0;var l=0,u=0,a=0,c=0;var p;var d="";var f;var t="";var g=[];var y={};var x,_;var m=.55228475-45e-5;var b,w;var k,I;return{setopts(r){p=r},scale(r,t){x=r;_=t},measure(r,t,e,i){e=e|0;i=i|0;var n=FontLib.lookup(t);var a=0;var s=0;var f=0;for(var o=0,h=r.length;o<h;o++){var v=r.charCodeAt(o);var l=FontLib.getglyph(n,v,e,i);if(!l){continue}s=Math.max(s,l.top);f=Math.max(f,l.height-l.top);if(o==h-1){a+=l.left+l.width}else{a+=l.advance}}return{width:a,ascent:s,descent:f}},init(r,t){var e=p.paddingleft;var i=p.paddingright;var n=p.paddingtop;var a=p.paddingbottom;var s=p.rotate||"N";r+=e+i;t+=n+a;switch(s){case"R":h=-1;v=1;l=1;break;case"I":o=-1;v=1;u=-1;c=1;break;case"L":h=1;l=-1;c=1;break;default:o=u=1;break}var f=s=="L"||s=="R";b=f?t:r;w=f?r:t;k=e;I=n},line(t,e,i,n,r,a){t=t|0;e=e|0;i=i|0;n=n|0;r=Math.round(r)||1;if(r&1){if(t==i){let r=x&1?-.5:.5;t+=r;i+=r}if(e==n){let r=_&1?-.5:.5;e+=r;n+=r}}if(t==i){e++}else if(e==n){t++}var s=""+r+"#"+a;if(!y[s]){y[s]='<path stroke="#'+a+'" stroke-width="'+r+'" d="'}y[s]+="M"+F(t,e)+"L"+F(i,n)},polygon(r){if(!f){f='<path d="'}f+="M"+F(r[0][0],r[0][1]);for(var t=1,e=r.length;t<e;t++){var i=r[t];f+="L"+F(i[0],i[1])}f+="Z"},hexagon(r,t){this.polygon(r)},ellipse(r,t,e,i,n){if(!f){f='<path d="'}var a=e*m;var s=i*m;f+="M"+F(r-e,t)+"C"+F(r-e,t-s)+" "+F(r-a,t-i)+" "+F(r,t-i)+"C"+F(r+a,t-i)+" "+F(r+e,t-s)+" "+F(r+e,t)+"C"+F(r+e,t+s)+" "+F(r+a,t+i)+" "+F(r,t+i)+"C"+F(r-a,t+i)+" "+F(r-e,t+s)+" "+F(r-e,t)+"Z"},fill(r){if(f){d+=f+'" fill="#'+r+'" fill-rule="evenodd"'+(t?' clip-path="url(#'+t+')"':"")+" />\n";f=null}},clip:function(e){var i='<clipPath id="clip'+g.length+'"><path d="';for(let t=0;t<e.length;t++){let r=e[t];i+="M"+F(r[0][0],r[0][1]);for(var n=1,a=r.length;n<a;n++){var s=r[n];i+="L"+F(s[0],s[1])}i+="Z"}i+='" clip-rule="nonzero" /></clipPath>';t="clip"+g.length;g.push(i)},unclip:function(){t=""},text(t,e,r,i,n){t=t|0;e=e|0;var a=t,s=e;var f=FontLib.lookup(n.name);var o=n.width|0;var h=n.height|0;var v=n.dx|0;var l="";for(var u=0;u<r.length;u++){var c=r.charCodeAt(u);var p=FontLib.getpaths(f,c,o,h);if(!p){continue}if(p.length){for(var g=0,y=p.length;g<y;g++){let r=p[g];if(r.type=="M"||r.type=="L"){l+=r.type+F(r.x+t,e-r.y)}else if(r.type=="Q"){l+=r.type+F(r.cx+t,e-r.cy)+" "+F(r.x+t,e-r.y)}else if(r.type=="C"){l+=r.type+F(r.cx1+t,e-r.cy1)+" "+F(r.cx2+t,e-r.cy2)+" "+F(r.x+t,e-r.y)}}l+="Z"}t+=FontLib.getglyph(f,c,o,h).advance+v}if(l){if(n.rotate){d+='<path d="'+l+'" fill="#'+i+'" transform="rotate(-'+n.rotate+" "+F(a,s)+')" />\n'}else{d+='<path d="'+l+'" fill="#'+i+'" />\n'}}},end(){var r="";for(var t in y){r+=y[t]+'" />\n'}var e=p.backgroundcolor;return'<svg viewBox="0 0 '+b+" "+w+'" xmlns="http://www.w3.org/2000/svg">\n'+(g.length?"<defs>"+g.join("")+"</defs>":"")+(/^[0-9A-Fa-f]{6}$/.test(""+e)?'<rect width="100%" height="100%" fill="#'+e+'" />\n':"")+r+d+"</svg>\n"}};function F(r,t){r+=k;t+=I;var e=o*r+h*t+v*(b-1)+n*(w-1);var i=l*r+u*t+a*(b-1)+c*(w-1);return""+((e|0)==e?e:e.toFixed(2))+" "+((i|0)==i?i:i.toFixed(2))}}var FontLib=function(){var h=[];var s={};var v={};var l={};var u=0;l.next=l;l.prev=l;return{lookup:t,monochrome:e,getglyph:i,getpaths:n,loadFont:r};function r(r){var t=100;var e=100;var i=null;if(arguments.length==2){i=arguments[1]}else if(arguments.length==3){t=e=+arguments[1]||100;i=arguments[2]}else if(arguments.length==4){e=+arguments[1]||100;t=+arguments[2]||100;i=arguments[3]}else{throw new Error("bwipjs: loadFont: invalid number of arguments")}var n=STBTT.InitFont(toUint8Array(i));n.bwipjs_name=r;n.bwipjs_multx=t;n.bwipjs_multy=e;var a=h.push(n)-1;s[r.toUpperCase()]=a;return a}function t(r){var t=s[r.toUpperCase()];return t===undefined?1:t}function e(r){if(r){throw new Error("bwipjs: monochrome fonts not implemented")}}function i(r,t,e,i){r=r|0;t=t|0;e=+e;i=+i;if(!e||e<8){e=8}if(!i||i<8){i=e}if(r<0||r>=h.length){r=1}if(!t||t<32){t=32}var n=""+r+"c"+t+"w"+e+"h"+i;var a=v[n];if(a){a.prev.next=a.next;a.next.prev=a.prev;var s=l;s.next.prev=a;a.next=s.next;a.prev=s;s.next=a;return a}var f=h[r];var a=STBTT.GetGlyph(f,t,e*f.bwipjs_multx/100,i*f.bwipjs_multy/100)||STBTT.GetGlyph(f,0,e*f.bwipjs_multx/100,i*f.bwipjs_multy/100);a.bytes=a.pixels;a.cachekey=n;a.offset=0;if(u>250){var s=l;var o=s.prev;o.prev.next=s;s.prev=o.prev;o.next=o.prev=null;delete v[o.cachekey]}else{u++}v[n]=a;var s=l;s.next.prev=a;a.next=s.next;a.prev=s;s.next=a;return a}function n(r,t,e,i){r=r|0;t=t|0;e=+e;i=+i;if(!e||e<8){e=8}if(!i||i<8){i=e}if(r<0||r>=h.length){r=1}if(!t||t<32){t=32}var n=h[r];return STBTT.GetPaths(n,t,e*n.bwipjs_multx/100,i*n.bwipjs_multy/100)}}();function LoadFont(){return FontLib.loadFont.apply(FontLib,Array.prototype.slice.call(arguments))}var STBTT=function(){var O=1,D=2,W=3,y=4,C=0,r=1,t=2,S=3,e=0,i=1,n=2,a=3,s=4,o=0,A=1,v=2,j=10;var N=Math.floor;var f=Math.ceil;var U=Math.sqrt;var B=Math.abs;function Y(r){var t=[];for(var e=0;e<r;e++){t.push({})}return t}function V(r){return r[r.cursor++]||0}function g(r){return r[r.cursor]}function d(r,t){r.cursor=t>r.length||t<0?r.length:t}function L(r,t){d(r,r.cursor+t)}function E(r,t){var e=0;for(var i=0;i<t;i++){e=e<<8|V(r)}return e}function x(){return{length:0}}function _(r,t,e){if(t<0||e<0||t>r.length||e>r.length-t){return x()}var i=r.subarray(t,t+e);i.cursor=0;return i}function m(r){var t=r.cursor;var e=E(r,2);if(e){var i=V(r);L(r,i*e);L(r,E(r,i)-1)}return _(r,t,r.cursor-t)}function R(r){var t=V(r);if(t>=32&&t<=246){return t-139}else if(t>=247&&t<=250){return(t-247)*256+V(r)+108}else if(t>=251&&t<=254){return-(t-251)*256-V(r)-108}else if(t==28){return E(r,2)}else if(t==29){return E(r,4)}return 0}function T(r){var t=g(r);if(t==30){L(r,1);while(r.cursor<r.length){var e=V(r);if((e&15)==15||e>>4==15){break}}}else{R(r)}}function Q(r,t){d(r,0);while(r.cursor<r.length){var e=r.cursor,i,n;while(g(r)>=28){T(r)}i=r.cursor;n=V(r);if(n==12){n=V(r)|256}if(n==t){return _(r,e,i-e)}}return _(r,0,0)}function K(r,t,e,i){var n=Q(r,t);for(var a=0;a<e&&n.cursor<n.length;a++){i[a]=R(n)}}function b(r,t,e){var i=Q(r,t);if(i.cursor<i.length){e=R(i)}return e}function rr(r){d(r,0);return E(r,2)}function G(r,t){var e,i,n,a;d(r,0);e=E(r,2);i=V(r);L(r,t*i);n=E(r,i);a=E(r,i);return _(r,2+(e+1)*i+n,a-n)}function tr(r){return r&32768?(4294901760|r)>>0:r}function z(r,t){return r[t]*256+r[t+1]}function J(r,t){var e=r[t]*256+r[t+1];return e&32768?(4294901760|e)>>0:e}function F(r,t){return(r[t]<<24)+(r[t+1]<<16)+(r[t+2]<<8)+r[t+3]}function w(r,t,e){var i=z(r,t+4);var n=t+12;for(var a=0;a<i;++a){var s=n+16*a;if(r[s]==e[0]&&r[s+1]==e[1]&&r[s+2]==e[2]&&r[s+3]==e[3]){return F(r,s+8)}}return 0}function er(r,t){var e=[0,0];K(t,18,2,e);if(!e[1]||!e[0]){return x()}var i=_(r,e[1],e[0]);var n=b(i,19,0);if(!n){return x()}d(r,e[1]+n);return m(r)}function ir(r,t,e){var i,n,a,s;r.data=t;r.fontstart=e;r.cff=x();i=w(t,e,[99,109,97,112]);r.loca=w(t,e,[108,111,99,97]);r.head=w(t,e,[104,101,97,100]);r.glyf=w(t,e,[103,108,121,102]);r.hhea=w(t,e,[104,104,101,97]);r.hmtx=w(t,e,[104,109,116,120]);r.kern=w(t,e,[107,101,114,110]);if(!i||!r.head||!r.hhea||!r.hmtx){return 0}if(r.glyf){if(!r.loca){return 0}}else{var f,o,h,v,l=2,u=0,c=0,p=0;v=w(t,e,[67,70,70,32]);if(!v){return 0}r.fontdicts=x();r.fdselect=x();r.cff=t.subarray(v);r.cff.cursor=0;f=r.cff;L(f,2);d(f,V(f));m(f);h=m(f);o=G(h,0);m(f);r.gsubrs=m(f);u=b(o,17,u);l=b(o,256|6,l);c=b(o,256|36,c);p=b(o,256|37,p);r.subrs=er(f,o);if(l!=2){return 0}if(u==0){return 0}if(c){if(!p){return 0}d(f,c);r.fontdicts=m(f);r.fdselect=_(f,p,f.length-p)}d(f,u);r.charstrings=m(f)}n=w(t,e,[109,97,120,112]);if(n){r.numGlyphs=z(t,n+4)}else{r.numGlyphs=65535}s=z(t,i+2);r.index_map=0;for(a=0;a<s;++a){var g=i+4+8*a;switch(z(t,g)){case S:switch(z(t,g+2)){case A:case j:r.index_map=i+F(t,g+4);break}break;case C:r.index_map=i+F(t,g+4);break}}if(r.index_map==0){return 0}r.indexToLocFormat=z(t,r.head+50);return 1}function k(r,t){var e=r.data,i=r.index_map;var n=z(e,i+0);if(n==0){var a=z(e,i+2);if(t<a-6){return e[i+6+t]}return 0}else if(n==6){var s=z(e,i+6),f=z(e,i+8);if(t>=s&&t<s+f){return z(e,i+10+(t-s)*2)}return 0}else if(n==2){return 0}else if(n==4){var o=z(e,i+6)>>1,h=z(e,i+8)>>1,v=z(e,i+10),l=z(e,i+12)>>1,u=i+14,c=u;if(t>65535){return 0}if(t>=z(e,c+l*2)){c+=l*2}c-=2;while(v){h>>=1;var p=z(e,c+h*2);if(t>p){c+=h*2}--v}c+=2;var g,y,d=c-u>>>1;y=z(e,i+14+o*2+2+2*d);if(t<y){return 0}g=z(e,i+14+o*6+2+2*d);if(g==0){return t+J(e,i+14+o*4+2+2*d)}return z(e,g+(t-y)*2+i+14+o*6+2+2*d)}else if(n==12||n==13){var x=F(e,i+12),_=0,m=x;while(_<m){var b=_+(m-_>>1);var w=F(e,i+16+b*12);var k=F(e,i+16+b*12+4);if(t<w){m=b}else if(t>k){_=b+1}else{var I=F(e,i+16+b*12+8);if(n==12){return I+t-w}else{return I}}}return 0}return 0}function $(r,t,e,i,n,a){r.type=t;r.x=e;r.y=i;r.cx=n;r.cy=a}function nr(r,t){var e,i;if(t>=r.numGlyphs){return-1}if(r.indexToLocFormat>=2){return-1}if(r.indexToLocFormat==0){e=r.glyf+z(r.data,r.loca+t*2)*2;i=r.glyf+z(r.data,r.loca+t*2+2)*2}else{e=r.glyf+F(r.data,r.loca+t*4);i=r.glyf+F(r.data,r.loca+t*4+4)}return e==i?-1:e}function ar(r,t,e){if(r.cff.length){pr(r,t,e)}else{var i=nr(r,t);if(i<0){return 0}e.x0=J(r.data,i+2);e.y0=J(r.data,i+4);e.x1=J(r.data,i+6);e.y1=J(r.data,i+8)}return 1}function sr(r,t,e,i,n,a,s,f,o,h){if(i){if(e){$(r[t++],W,o+s>>1,h+f>>1,o,h)}$(r[t++],W,n,a,s,f)}else{if(e){$(r[t++],W,n,a,o,h)}else{$(r[t++],D,n,a,0,0)}}return t}function fr(r,t){var e=r.data,i=nr(r,t);if(i<0){return null}var n=[];var a=J(e,i);if(a>0){var s=0,f,o,h=0,v,l,u,c=0,p,g=0,y,d,x,_,m,b,w,k;var I=i+10;var G=z(e,i+10+a*2);var F=e.subarray(i+10+a*2+2+G);var C=0;l=1+z(e,I+a*2-2);v=l+2*a;n=Y(v);u=0;f=0;p=v-l;for(o=0;o<l;++o){if(f==0){s=F[C++];if(s&8){f=F[C++]}}else{--f}n[p+o].type=s}y=0;for(o=0;o<l;++o){s=n[p+o].type;if(s&2){var S=F[C++];y+=s&16?S:-S}else{if(!(s&16)){y=y+tr(F[C]*256+F[C+1]);C+=2}}n[p+o].x=y}d=0;for(o=0;o<l;++o){s=n[p+o].type;if(s&4){var M=F[C++];d+=s&32?M:-M}else{if(!(s&32)){d=d+tr(F[C]*256+F[C+1]);C+=2}}n[p+o].y=d}var A=0;m=b=x=_=w=k=0;for(o=0;o<l;++o){s=n[p+o].type;y=n[p+o].x;d=n[p+o].y;if(u==o){if(o!=0){A=sr(n,A,c,g,m,b,w,k,x,_)}g=!(s&1);if(g){w=y;k=d;if(!(n[p+o+1].type&1)){m=y+n[p+o+1].x>>1;b=d+n[p+o+1].y>>1}else{m=n[p+o+1].x;b=n[p+o+1].y;++o}}else{m=y;b=d}$(n[A++],O,m,b,0,0);c=0;u=1+z(e,I+h*2);++h}else{if(!(s&1)){if(c){$(n[A++],W,x+y>>1,_+d>>1,x,_)}x=y;_=d;c=1}else{if(c){$(n[A++],W,y,d,x,_)}else{$(n[A++],D,y,d,0,0)}c=0}}}n.length=sr(n,A,c,g,m,b,w,k,x,_)}else if(a==-1){var j=1;var T=i+10;while(j){var s,B,L=[1,0,0,1,0,0];s=J(e,T);T+=2;B=J(e,T);T+=2;if(s&2){if(s&1){L[4]=J(e,T);T+=2;L[5]=J(e,T);T+=2}else{L[4]=V(e,T);T+=1;L[5]=V(e,T);T+=1}}if(s&1<<3){L[0]=L[3]=J(e,T)/16384;T+=2;L[1]=L[2]=0}else if(s&1<<6){L[0]=J(e,T)/16384;T+=2;L[1]=L[2]=0;L[3]=J(e,T)/16384;T+=2}else if(s&1<<7){L[0]=J(e,T)/16384;T+=2;L[1]=J(e,T)/16384;T+=2;L[2]=J(e,T)/16384;T+=2;L[3]=J(e,T)/16384;T+=2}var v=U(L[0]*L[0]+L[1]*L[1]);var l=U(L[2]*L[2]+L[3]*L[3]);var E=Z(r,B);if(E.length>0){for(var o=0,P=E.length;o<P;++o){var R=E[o],y,d;y=R.x;d=R.y;R.x=N(v*(L[0]*y+L[2]*d+L[4]));R.y=N(l*(L[1]*y+L[3]*d+L[5]));y=R.cx;d=R.cy;R.cx=N(v*(L[0]*y+L[2]*d+L[4]));R.cy=N(l*(L[1]*y+L[3]*d+L[5]))}n=n.concat(E)}j=s&1<<5}}return n}function h(r,t,e){if(t>r.max_x||!r.started){r.max_x=t}if(e>r.max_y||!r.started){r.max_y=e}if(t<r.min_x||!r.started){r.min_x=t}if(e<r.min_y||!r.started){r.min_y=e}r.started=1}function l(r,t,e,i,n,a,s,f){h(r,e,i);if(t==y){h(r,n,a);h(r,s,f)}var o={};$(o,t,e,i,n,a);o.cx1=s;o.cy1=f;r.vertices.push(o)}function or(r){if(r.first_x!=r.x||r.first_y!=r.y){l(r,D,r.first_x,r.first_y,0,0,0,0)}}function P(r,t,e){or(r);r.first_x=r.x=r.x+t;r.first_y=r.y=r.y+e;l(r,O,r.x,r.y,0,0,0,0)}function q(r,t,e){r.x+=t;r.y+=e;l(r,D,r.x,r.y,0,0,0,0)}function H(r,t,e,i,n,a,s){var f=r.x+t,o=r.y+e,h=f+i,v=o+n;r.x=h+a;r.y=v+s;l(r,y,r.x,r.y,f,o,h,v)}function hr(r,t){var e=rr(r);var i=107;if(e>=33900){i=32768}else if(e>=1240){i=1131}t+=i;if(t<0||t>=e){return x()}return G(r,t)}function vr(r,t){var e=r.fdselect;var i,n,a,s,f,o=-1,h;d(e,0);f=V(e);if(f==0){L(e,t);o=V(e)}else if(f==3){i=E(e,2);n=E(e,2);for(h=0;h<i;h++){s=V(e);a=E(e,2);if(t>=n&&t<a){o=s;break}n=a}}if(o==-1){x()}return er(r.cff,G(r.fontdicts,o))}function lr(r,t,e){var i=1,n=0,a=0,s=0,f,o,h,v=0,l,u=[],c=[],p=r.subrs,g,y;g=G(r.charstrings,t);while(g.cursor<g.length){o=0;l=1;h=V(g);switch(h){case 19:case 20:if(i){n+=s/2|0}i=0;L(g,(n+7)/8|0);break;case 1:case 3:case 18:case 23:n+=s/2|0;break;case 21:i=0;if(s<2){return 0}P(e,u[s-2],u[s-1]);break;case 4:i=0;if(s<1){return 0}P(e,0,u[s-1]);break;case 22:i=0;if(s<1){return 0}P(e,u[s-1],0);break;case 5:if(s<2){return 0}for(;o+1<s;o+=2){q(e,u[o],u[o+1])}break;case 7:if(s<1){return 0}for(;;){if(o>=s){break}q(e,0,u[o]);o++;if(o>=s){break}q(e,u[o],0);o++}break;case 6:if(s<1){return 0}for(;;){if(o>=s){break}q(e,u[o],0);o++;if(o>=s){break}q(e,0,u[o]);o++}break;case 31:if(s<4){return 0}for(;;){if(o+3>=s){break}H(e,u[o],0,u[o+1],u[o+2],s-o==5?u[o+4]:0,u[o+3]);o+=4;if(o+3>=s){break}H(e,0,u[o],u[o+1],u[o+2],u[o+3],s-o==5?u[o+4]:0);o+=4}break;case 30:if(s<4){return 0}for(;;){if(o+3>=s){break}H(e,0,u[o],u[o+1],u[o+2],u[o+3],s-o==5?u[o+4]:0);o+=4;if(o+3>=s){break}H(e,u[o],0,u[o+1],u[o+2],s-o==5?u[o+4]:0,u[o+3]);o+=4}break;case 8:if(s<6){return 0}for(;o+5<s;o+=6){H(e,u[o],u[o+1],u[o+2],u[o+3],u[o+4],u[o+5])}break;case 24:if(s<8){return 0}for(;o+5<s-2;o+=6){H(e,u[o],u[o+1],u[o+2],u[o+3],u[o+4],u[o+5])}if(o+1>=s){return 0}q(e,u[o],u[o+1]);break;case 25:if(s<8){return 0}for(;o+1<s-6;o+=2){q(e,u[o],u[o+1])}if(o+5>=s){return 0}H(e,u[o],u[o+1],u[o+2],u[o+3],u[o+4],u[o+5]);break;case 26:case 27:if(s<4){return 0}y=0;if(s&1){y=u[o];o++}for(;o+3<s;o+=4){if(h==27){H(e,u[o],y,u[o+1],u[o+2],u[o+3],0)}else{H(e,y,u[o],u[o+1],u[o+2],0,u[o+3])}y=0}break;case 10:if(!v){if(r.fdselect.length){p=vr(r,t)}v=1}case 29:if(s<1){return 0}f=u[--s]|0;if(a>=10){return 0}c[a++]=g;g=hr(h==10?p:r.gsubrs,f);if(g.length==0){return 0}g.cursor=0;l=0;break;case 11:if(a<=0){return 0}g=c[--a];l=0;break;case 14:or(e);return 1;case 12:var d,x,_,m,b,w,k,I,F,C,S,M,A,j,T=V(g);switch(T){case 34:if(s<7){return 0}d=u[0];x=u[1];I=u[2];_=u[3];m=u[4];b=u[5];w=u[6];H(e,d,0,x,I,_,0);H(e,m,0,b,-I,w,0);break;case 35:if(s<13){return 0}d=u[0];k=u[1];x=u[2];I=u[3];_=u[4];F=u[5];m=u[6];C=u[7];b=u[8];S=u[9];w=u[10];M=u[11];H(e,d,k,x,I,_,F);H(e,m,C,b,S,w,M);break;case 36:if(s<9){return 0}d=u[0];k=u[1];x=u[2];I=u[3];_=u[4];m=u[5];b=u[6];S=u[7];w=u[8];H(e,d,k,x,I,_,0);H(e,m,0,b,S,w,-(k+I+S));break;case 37:if(s<11){return 0}d=u[0];k=u[1];x=u[2];I=u[3];_=u[4];F=u[5];m=u[6];C=u[7];b=u[8];S=u[9];w=M=u[10];A=d+x+_+m+b;j=k+I+F+C+S;if(B(A)>B(j)){M=-j}else{w=-A}H(e,d,k,x,I,_,F);H(e,m,C,b,S,w,M);break;default:return 0}break;default:if(h!=255&&h!=28&&(h<32||h>254)){return 0}if(h==255){y=(E(g,4)|0)/65536}else{L(g,-1);y=(R(g)<<16|0)>>16}if(s>=48){return 0}u[s++]=y;l=0;break}if(l){s=0}}return 0}function ur(){return{started:0,first_x:0,first_y:0,x:0,y:0,min_x:0,max_x:0,min_y:0,max_y:0,vertices:[]}}function cr(r,t){var e=ur();if(lr(r,t,e)){return e.vertices}return null}function pr(r,t,e){var i=ur();var n=lr(r,t,i);e.x0=n?i.min_x:0;e.y0=n?i.min_y:0;e.x1=n?i.max_x:0;e.y1=n?i.max_y:0;return n&&i.vertices?i.vertices.length:0}function Z(r,t){if(!r.cff.length){return fr(r,t)}else{return cr(r,t)}}function I(r,t){var e=z(r.data,r.hhea+34);if(t<e){return{advanceWidth:J(r.data,r.hmtx+4*t),leftSideBearing:J(r.data,r.hmtx+4*t+2)}}else{return{advanceWidth:J(r.data,r.hmtx+4*(e-1)),leftSideBearing:J(r.data,r.hmtx+4*e+2*(t-e))}}}function gr(r,t){return I(r,k(r,t))}function yr(r){return{ascent:J(r.data,r.hhea+4),descent:J(r.data,r.hhea+6),linegap:J(r.data,r.hhea+8)}}function p(r,t,e,i,n,a){var s={};if(!ar(r,t,s)){return{x0:0,y0:0,x1:0,y1:0}}return{x0:N(s.x0*e+n),y0:N(-s.y1*i+a),x1:f(s.x1*e+n),y1:f(-s.y0*i+a)}}function dr(r,t,e,i,n,a){return p(r,k(r,t),e,i,n,a)}function xr(r,t,e,i){return dr(r,t,e,i,0,0)}function _r(r,t,e){var i=(r.x1-r.x0)/(r.y1-r.y0);return{fdx:i,fdy:i!=0?1/i:0,fx:r.x0+i*(e-r.y0)-(t|0),direction:r.invert?1:-1,sy:r.y0,ey:r.y1,next:0}}function M(r,t,e,i,n,a,s){t=t|0;if(n==s){return}if(n>e.ey){return}if(s<e.sy){return}if(n<e.sy){i+=(a-i)*(e.sy-n)/(s-n);n=e.sy}if(s>e.ey){a+=(a-i)*(e.ey-s)/(s-n);s=e.ey}if(i<=t&&a<=t){r[t]+=e.direction*(s-n)}else if(i>=t+1&&a>=t+1){}else{r[t]+=e.direction*(s-n)*(1-(i-t+(a-t))/2)}}function mr(r,t,e,i,n){var a=n+1;while(i){if(i.fdx==0){var s=i.fx;if(s<e){if(s>=0){M(r,s,i,s,n,s,a);M(t,s+1,i,s,n,s,a)}else{M(t,0,i,s,n,s,a)}}}else{var s=i.fx,f=i.fdx,o=s+f,h,v,l,u,c=i.fdy;if(i.sy>n){h=s+f*(i.sy-n);l=i.sy}else{h=s;l=n}if(i.ey<a){v=s+f*(i.ey-n);u=i.ey}else{v=o;u=a}if(h>=0&&v>=0&&h<e&&v<e){if((h|0)==(v|0)){var p=u-l,g=h|0;r[g]+=i.direction*(1-(h-g+(v-g))/2)*p;t[g+1]+=i.direction*p}else{var y,g,d,x,_,m,b,w;if(h>v){l=a-(l-n);u=a-(u-n);y=l,l=u,u=y;y=v,v=h,h=y;f=-f;c=-c;y=s,s=o,o=y}d=h|0;x=v|0;_=(d+1-s)*c+n;b=i.direction;w=b*(_-l);r[d]+=w*(1-(h-d+(d+1-d))/2);m=b*c;for(g=d+1;g<x;++g){r[g]+=w+m/2;w+=m}_+=c*(x-(d+1));r[x]+=w+b*(1-(x-x+(v-x))/2)*(u-_);t[x+1]+=b*(u-l)}}else{for(var g=0;g<e;++g){var k=n,d=g,x=g+1,I=o,F=a,C=(g-s)/f+n,S=(g+1-s)/f+n;if(s<d&&I>x){M(r,g,i,s,k,d,C);M(r,g,i,d,C,x,S);M(r,g,i,x,S,I,F)}else if(I<d&&s>x){M(r,g,i,s,k,x,S);M(r,g,i,x,S,d,C);M(r,g,i,d,C,I,F)}else if(s<d&&I>d){M(r,g,i,s,k,d,C);M(r,g,i,d,C,I,F)}else if(I<d&&s>d){M(r,g,i,s,k,d,C);M(r,g,i,d,C,I,F)}else if(s<x&&I>x){M(r,g,i,s,k,x,S);M(r,g,i,x,S,I,F)}else if(I<x&&s>x){M(r,g,i,s,k,x,S);M(r,g,i,x,S,I,F)}else{M(r,g,i,s,k,I,F)}}}}i=i.next}}function br(r,t,e,i,n,a){i|=0,n|=0,a|=0;var s=null,f;var o=a,h=0,v;var l=new Float32Array(r.w*2+1);var u=l.subarray(r.w);var c=0;t[e].y0=a+r.h+1;while(h<r.h){var p=o+0,g=o+1,y=s;if(l.fill){l.fill(0)}else{for(var d=0,x=l.length;d<x;d++)l[d]=0}while(y){f=y;y=f.next;if(f.ey<=p){f.direction=0}else{}}while(t[c].y0<=g){if(t[c].y0!=t[c].y1){f=_r(t[c],n,p);f.next=s;s=f}++c}if(s){mr(l,u,r.w,s,p)}for(var v=0,_=0;v<r.w;++v){var m,b;_+=u[v];m=l[v]+_;m=B(m)*255+.5;b=m>>>0;if(b>255){b=255}r.pixels[h*r.stride+v]=b}y=s;while(y){f=y;f.fx+=f.fdx;y=f.next}++o;++h}}function wr(r,t){for(var e=1;e<t;++e){var i=r[e],n=e;while(n>0&&i.y0<r[n-1].y0){r[n]=r[n-1];--n}if(e!=n){r[n]=i}}}function u(r,t,e){while(e>12){var i,n,a,s,f,o=e>>1,h=r[t].y0<r[t+o].y0,v=r[t+o].y0<r[t+e-1].y0;if(h!=v){n=r[t].y0<r[t+e-11].y0;f=n==v?0:e-1;i=r[t+f];r[t+f]=r[t+o];r[t+o]=i}i=r[t];r[t]=r[t+o];r[t+o]=i;a=1;s=e-1;for(;;){for(;r[t+a].y0<r[t].y0;++a){}for(;r[t].y0<r[t+s].y0;--s){}if(a>=s){break}i=r[t+a];r[t+a]=r[t+s];r[t+s]=i;++a;--s}if(s<e-a){u(r,t,s);t+=a;e-=a}else{u(r,t+a,e-a);e=s}}}function kr(r,t){u(r,0,t);wr(r,t)}function Ir(r,t,e,i,n,a,s,f,o,h){var v=h?-n:n,l,u,c,p,g,y,d=1;u=0;for(c=0;c<e.length;++c){u+=e[c]}l=Y(u+1);u=0;y=0;for(c=0;c<e.length;++c){var x=y;y+=e[c];p=e[c]-1;for(g=0;g<e[c];p=g++){var _=g,m=p;if(t[x+p].y==t[x+g].y){continue}l[u].invert=0;if(h?t[x+p].y>t[x+g].y:t[x+p].y<t[x+g].y){l[u].invert=1;_=p,m=g}l[u].x0=t[x+_].x*i+a;l[u].y0=(t[x+_].y*v+s)*d;l[u].x1=t[x+m].x*i+a;l[u].y1=(t[x+m].y*v+s)*d;++u}}kr(l,u);br(r,l,u,d,f,o)}function c(r,t,e,i,n,a,s,f,o){var h=(t+2*i+a)/4,v=(e+2*n+s)/4,l=(t+a)/2-h,u=(e+s)/2-v;if(o>16){return 1}if(l*l+u*u>f){c(r,t,e,(t+i)/2,(e+n)/2,h,v,f,o+1);c(r,h,v,(i+a)/2,(n+s)/2,a,s,f,o+1)}else{r.push({x:a,y:s})}return 1}function X(r,t,e,i,n,a,s,f,o,h,v){var l=i-t,u=n-e,c=a-i,p=s-n,g=f-a,y=o-s,d=f-t,x=o-e,_=U(l*l+u*u)+U(c*c+p*p)+U(g*g+y*y),m=U(d*d+x*x),b=_*_-m*m;if(v>16){return}if(b>h){var w=(t+i)/2,k=(e+n)/2,I=(i+a)/2,F=(n+s)/2,C=(a+f)/2,S=(s+o)/2,M=(w+I)/2,A=(k+F)/2,j=(I+C)/2,T=(F+S)/2,B=(M+j)/2,L=(A+T)/2;X(r,t,e,w,k,M,A,B,L,h,v+1);X(r,B,L,j,T,C,S,f,o,h,v+1)}else{r.push({x:f,y:o})}}function Fr(r,t,e){var i=[],n=t*t,a=-1,s=0,f=0,o=0;for(var h=0,v=r.length;h<v;++h){switch(r[h].type){case O:if(a>=0){e[a]=i.length-s}++a;s=i.length;f=r[h].x,o=r[h].y;i.push({x:f,y:o});break;case D:f=r[h].x,o=r[h].y;i.push({x:f,y:o});break;case W:c(i,f,o,r[h].cx,r[h].cy,r[h].x,r[h].y,n,0);f=r[h].x,o=r[h].y;break;case y:X(i,f,o,r[h].cx,r[h].cy,r[h].cx1,r[h].cy1,r[h].x,r[h].y,n,0);f=r[h].x,o=r[h].y;break}}e[a]=i.length-s;return i}function Cr(r,t,e,i,n,a,s,f,o,h){f|=0,o|=0;var v=i>n?n:i,l=[],u=Fr(e,t/v,l);if(u){Ir(r,u,l,i,n,a,s,f,o,h)}}function Sr(r,t,e,i,n,a,s,f,o,h){var v=Z(r,h);var l={};var u=p(r,h,a,s,f,o);l.pixels=t;l.w=e|0;l.h=i|0;l.stride=n|0;if(l.w&&l.h){Cr(l,.35,v,a,s,f,o,u.x0,u.y0,1)}}function Mr(r,t,e,i,n,a,s,f,o,h){Sr(r,t,e,i,n,a,s,f,o,k(r,h))}function Ar(r,t,e){return ir(r,t,e)}function jr(r){var t={};if(!ir(t,r,0)){return null}var e=yr(t);t.ascent=e.ascent;t.descent=e.descent;t.linegap=e.linegap;return t}function Tr(r,t,e,i){i=i||e;var n=e/r.ascent;var a=i/r.ascent;var s=k(r,t);if(!s&&t){return null}var f=Z(r,s);var o=p(r,s,n,a,0,0);var h=o.x1-o.x0;var v=o.y1-o.y0;var l=null;if(h&&v){var u={pixels:l=new Uint8Array(h*v),w:h,h:v,stride:h};Cr(u,.35,f,n,a,0,0,o.x0,o.y0,1)}var c=I(r,s);return{glyph:s,pixels:l,width:h,height:v,top:-o.y0,left:o.x0,advance:N(c.advanceWidth*n)}}function Br(r,t,e,i){i=i||e;var n=e/r.ascent;var a=i/r.ascent;var s=k(r,t);if(!s&&t){return null}var f=Z(r,s);var o=I(r,s);var h=0;var v=0;var l=[];if(f){for(var u=0,c=f.length;u<c;u++){var p=f[u];var g;if(p.type==O){g={type:"M",x:p.x*n,y:p.y*a}}else if(p.type==D){g={type:"L",x:p.x*n,y:p.y*a}}else if(p.type==W){g={type:"Q",x:p.x*n,y:p.y*a,cx:p.cx*n,cy:p.cy*a}}else if(p.type==y){g={type:"C",x:p.x*n,y:p.y*a,cx1:p.cx*n,cy1:p.cy*a,cx2:p.cx1*n,cy2:p.cy1*a}}else{continue}if(g.y>h)h=g.y;if(g.y<v)v=g.y;l.push(g)}}l.advance=o.advanceWidth*n;l.ascent=h;l.descent=v;return l}return{InitFont:jr,GetGlyph:Tr,GetPaths:Br}}();
function toUint8Array(data) {
    if (typeof data == "string") {
        var binary = /[^A-Za-z0-9+\/=\s]/.test(data);
        var bstr = binary ? data : atob(data),
            len = bstr.length,
            bytes = new Uint8Array(len);
        for (var i = 0; i < len; i++) {
            bytes[i] = bstr.charCodeAt(i);
        }
        return bytes;
    } else if (data instanceof Uint8Array) {
        return data;
    } else if (data instanceof ArrayBuffer) {
        return new Uint8Array(data);
    }
    throw new ReferenceError("data must be a binary or base64 encoded string or Uint8Array");
}

FontLib.loadFont("OCR-A", 100, 100, "AAEAAAAPAIAAAwBwRkZUTXxHoksAADPIAAAAHEdERUYAmQAGAAAyIAAAACBHUE9TuP+4/gAAM5gAAAAwR1NVQuq3l/0AADJAAAABWE9TLzKDm4kvAAABeAAAAGBjbWFwO6GiGgAAArgAAAFaZ2FzcP//AAMAADIYAAAACGdseWYfHUemAAAE8AAAKUBoZWFkFeCL3QAAAPwAAAA2aGhlYQcqAgQAAAE0AAAAJGhtdHgagBVHAAAB2AAAAOBsb2NhH+IWRAAABBQAAADabWF4cACxAF0AAAFYAAAAIG5hbWUIp3NfAAAuMAAAAoJwb3N0oJoboAAAMLQAAAFkAAEAAAACAAAhYPsHXw889QALA+gAAAAA2gMjvQAAAADaAyO9AD7/LAJ8BFIAAAAIAAIAAAAAAAAAAQAABFL/LABaAtMAAAAAAnwAAQAAAAAAAAAAAAAAAAAAAAQAAQAAAGwAWgADAAAAAAACAAAAAQABAAAAQAAAAAAAAAACAtMBkAAFAAACigK8AAAAjAKKArwAAAHgADEBAgAAAgAFCQAAAAAAAAAAACMAACoAAAAAAAAAAABQZkVkAEAAICWgAyD/OABaBFIA1AAAAAEAAAAAAjgDDAAAACAAAQLTAAAAAAAAAtMAAALTAAAA9gBJAEkASQBJAEkA3QDdAKwASQBJAKwASQDdAEkASQBJAEkASQBhAEkASQBJAEkASQDdAKwASQBJAEkASQBJAEYASQBJAEkASQBJAEkASQBJAHoASQBJAEkASQBJAEkASQBJAEkASQBJAEkASQBJAEkASABJAEkASQBIAEkAegBJAEkASQBJAEkAYQBJAEkAegB6AEkAegBBAEkASQBJAEkASQBJAEkASQBJAD4ASQBJAEkASQEPAEkASQBxAHEAcQE3AFcA7QBxAQMA1ABxAAAAAwAAAAMAAAAcAAEAAAAAAFQAAwABAAAAHAAEADgAAAAKAAgAAgACAH4kQiUCJaD//wAAACAkQCUCJaD////j3CLbY9rGAAEAAAAAAAAAAAAAAAABBgAAAQAAAAAAAAABAgAAAAIAAAAAAAAAAAAAAAAAAAABAAADBAUGBwgJCgsMDQ4PEBESExQVFhcYGRobHB0eHyAhIiMkJSYnKCkqKywtLi8wMTIzNDU2Nzg5Ojs8PT4/QEFCQ0RFRkdISUpLTE1OT1BRUlNUVVZXWFlaW1xdXl9gYQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAwAFIApgDoAS4BigGqAdYCAgJKAnQCkAKsAsYC5AMIAzIDYAOcA8gD+gQmBFIEggSuBNwFDAU0BVwFhAXEBhIGPgZwBqgG5AcKBy4HageWB8QH7gggCDoIZgiICMoI8glMCYIJwAnmChAKNAp0Cq4K1gr6CyYLRAtwC5QLrgvODBYMdAysDRANag2eDhYOSA6EDsYO+A8iD2YPmA/yEFgQvBDqETQRbhGgEcwSDhJEEnoSqBLiEwITPBNyE5ITthPeE+wT+hQUFEYUaBSIFKAAAAACAPYAAAGNAwwADwAfAAA3NTQ2OwEyFh0BFAYrASImETQ2OwEyFh0BAxQGIyImJ/YeFTEVHh4VMRUeHhUxFB8ZHhQVHAIzKhUdHRUqFR4eArwUHhwTA/6BFR0dFQAAAAABAEkBqAI7AwwAEwAAEychFQYHBiMiJjUnIwcOASMiJidKAQHyJgsMKBQgKHIqAxwSExwDAsJKSrkvMhoS09YRGBgRAAIASQB/AjsDDAA9AEEAABM0NjsBNSMiJjQ2OwE1NDYyFh0BMzU0NjIWHQEzMhYUBisBFTMyFhUUBisBFRQGIiY9ASMVFAYiJj0BIyImNzM1I0kdFTExFR0dFTEdKh5hHiodMRUeHhUxMRUeHhUxHSoeYR4qHTEVHchhYQFcFB5vHiodeBQeHhR4eBQeHhR4HSoebx4UFR53FR4eFXd3FR4eFXceR28AAAEASQAAAjsDDAAxAAA2NDYzITUhIiY9ATQ2OwE1NDYzMhYdATMyFhQGIyEVITIWHQEUBisBFRQGIyImPQEjIkkdFQFb/qUVHR0VlB4VFB6UFR4eFf6lAVsVHh4VlB4UFR6UFccqHkQeFaoVHXgUHh4UeB0qHkQeFaoVHXcVHh4VdwAAAAMASQAAAjsDDAAPAB8ALwAANzQ3ATYzMhYVFAcBBiMiJhE1NDY7ATIWHQEUBisBIiYBNTQ2OwEyFh0BFAYrASImSQoBjQ4aFR4L/nMOGhUdHRVjFR4eFWMVHQEpHhVjFR4eFWMVHocUCwH+Ex0VEg3+AhMdAhNVFB4eFFUVHh79w1QVHh4VVBUeHgAAAwBJAAACOwK3AC4ANgBBAAA3NTQ/AScmPQE0NjsBMhYdARQPARc3NjMyFhUUDgIHFxYVFAYjIi8BBwYrASImNxQWOwE3JwcRFzc1NCYrASIGFUkRXGANWT5gPlkRfWszDxIVHhAPIQI0Dh4VFw43Sg8RYj5ZZR4UTzhrTlVvHhRgFB6XRRgPT2YPFEU+WVk+RRkOa3IsDB4VDRoOGAI4EBIVHhA7PwxZPhUdMHJCASpbXi4UHh0VAAEA3QFUAaYDDAARAAATETQ2OwEyFhcUBg8BDgEjIibdHhVjFRwCMhoZBRoSFR4BhgFUFB4dFQawVVURFR0AAAABAN0AAAHZAwwAGwAAEzU0PwE2MzIWFRQPAQYdARQfARYVFAYjIi8BJt0rdRAYFR8MdRYWdQodFRgQdSsBJsBFOJYTHhQOEpUdIsAiHZUPEBUeE5Y4AAAAAQCsAAABpgMMABsAADc0PwE2PQE0LwEmNTQ2MzIfARYdARQPAQYjIiasCnUWFnUKHRUYEHUrK3UQGBUdMxAPlR0iwCIdlQ8RFB4TljhFwEU4lhMeAAAAAAEASQBVAjsCtwAzAAA3ND8BJyY1NDYzMh8BNTQ2MzIWHQE3NjMyFhUUDwEXFhUUBiMiLwEVFAYjIiY9AQcGIyImSRGZmREdFRMOcx4VFB5zDRQVHhKZmRIeFRQNcx4UFR5zDhMVHdwYD4ODDxgVHQxikRUdHRWRYgwdFRcQg4MQFxUdDGKRFR0dFZFiDB0AAAEASQCNAjsCfwAdAAASNDY7ATU0NjMyFh0BMzIWFAYrARUUBiMiJj0BIyJJHRWUHhUUHpQVHh4VlB4UFR6UFQFxKh6UFB4eFJQeKh2UFR4eFZQAAAEArAAAAdcBZAAQAAASNDY7ATIWHQEUBiImPQEjIqwdFccVHR0qHpQVARwqHh4V/hUeHhXMAAAAAQBJASkCOwG5AA8AABM1NDYzITIWHQEUBiMhIiZJHRUBjRUeHhX+cxUdAVwqFR4eFSoVHh4AAAABAN0AfwGmATkADwAANzU0NjsBMhYdARQGKwEiJt0eFWMVHh4VYxUeslUVHR0VVRUeHgAAAQBJAAACOwMMAA8AADc0NwE2MzIWFRQHAQYjIiZJBgGNDx0VHgf+cw8dFR0zDQwCpxkeFAwO/VkZHgAAAgBJAAACOwMMAA8AEwAANxE0NjMhMhYVERQGIyEiJjchESFJPCkBKCg9PSj+2Ck8ZQEo/thlAkIpPDwp/b4pPDwpAkIAAAAAAQBJAAACOwMMABwAADc0NjsBESMiJjU0NjsBETM1NDYyFh0BFAYjISImSR0VlJQVHR0V+WIdKh4eFf5zFR0zFB4CQh4VFB79WcwVHh4V/hUeHgAAAQBJAAACOwMMAB4AADMRNDYzITUhIiY1NDYzITIWHQEUBiMhFSEyFhUUBiNJPCkBKP6lFR0dFQFbKD08Kf7YAVoVHh4VAVQpO+8eFRQePCnvKDzvHhQVHgAAAAABAEkAAAI7AwwAKgAANzQ2MyE1NCYrASImNDY7ATI2PQEhIiY1NDYzITIWHQEUBxYdARQGIyEiJkkdFQFbHxTFFR0dFcUVHv6lFR0dFQFbKD0oKD0o/qUVHTMUHrwUHx0qHh4UvB4VFB48Kbw6Kys6vCk8HgAAAAABAGEAAAIiAwwAHQAAExE0NjIWFREzETQ2MzIWFREyFhQGIxUUBiMiJj0BYR4qHcUeFRQeFR0dFR4UFR4A/wHbFB4eFP6KASEVHR0V/t8eKh3MFR4eFcwAAQBJAAACOwMMACIAADc0NjMyHwEzNSERITIWFRQGKwEVMzIWHQEUBisBIi4CJyZJHRUMCFrt/tYBXBUeHhX3xSg9PSjjFCkaLAkeXRUdBCbvAbgeFBUe7j0o7yk8CgsVBA0AAAIASQAAAjsDDAAXABsAADcRNDY7ATIWFRQGIxEhMhYdARQGIyEiJjchNSFJHRUyFR0dFQFbFR4eFf5zFR1kASn+1zMCpxQeHhQVHv69HhX+FR4eR5oAAAABAEkAAAI7AwwAGwAAEzU0NjMhERQPARUUBiMiJj0BND8BNSEOASMiJkkdFQHAErUeFBUeErX+1wMcExUdAq8rFB7+zxcQmucVHh4V/hcQmrUSGB0AAAAAAwBJAAACOwMMABcAGwAfAAA3NTQ2MxE0NjsBMhYVETIWHQEUBiMhIiY3ITUhNzM1I0k7KRwVxxUcKD09KP7XKTtkASn+12RhYWXvKTwBIRUdHRX+3z0o7yk8PCnvZe4AAgBJAAACOwMMABcAGwAAExE0NjMhMhYVERQGKwEiJjU0NjMRISImNyE1IUkdFQGNFR4eFTIVHR0V/qUVHWQBKf7XAdsA/xQeHhT9WRUeHhUUHgFDHkeaAAIA3QB/AaYCjQAPAB8AADc1NDY7ATIWHQEUBisBIiYRNTQ2OwEyFh0BFAYrASIm3R4VYxUeHhVjFR4eFWMVHh4VYxUeslUVHR0VVRUeHgFoVRUeHhVVFR0dAAAAAgCsAAAB1wK3ABAAIAAAEjQ2OwEyFh0BFAYiJj0BIyIDNTQ2OwEyFh0BFAYrASImrB0VxxUdHSoelBUdHRVkFB4eFGQVHQEcKh4eFf4VHh4VzAExVRUdHRVVFR4eAAAAAQBJAFUCOwK3ABYAABM1NDclNjMyFhUUBw0BFhUUBiMiJyUmSRgBjQsPFR4Z/pkBZxkeFQ8L/nMYAXArHQ/pBx0VHBDT0xAcFR0H6Q8AAAACAEkA/wI7AjgACwAXAAASNDYzITIWFAYjISImNDYzITIWFAYjISJJHRUBjRUeHhX+cxUdHRUBjRUeHhX+cxUBHCoeHiod8SoeHiodAAAAAAEASQBVAjsCtwAWAAA3NDctASY1NDYzMhcFFh0BFAcFBiMiJkkYAWj+mBgdFQ8LAY0ZFP5uCw8VHYcdD9PTDx0VHQfpEBwqHQzsBx0AAAAAAgBJAAACOwMMAB4AKAAAEzQ3ATYyHwEWHQEUBwUVFAYiJj0BNDclNScFBiMiJhM0NjIWFRQGIiZJEQEqDyQPYxIS/ugeKh0RARkx/vcPEhUdYx0qHh4qHQHbGA4A/wwMVQ8XVRcQ7z4VHR0VVRkO7yYq4wwe/m0UHh4UFR4eAAACAEkAAAI7AwwALQA4AAA3NTQ2OwEyFhURFBYyNjURNCYrASIGBwYjIiY1NDc2OwEyFhURFAYjIicGIyImNxQWMjY9ASMiBhVJWD1kFB4dKB0uH48ZLQwOHxUdNjdEj0lpWT05Kiw4PVhlHCgdMRQclrc+WB4V/uYUHR0UAcQgLSMXGx4VJDEyakj+PD1ZJydYPhQdHRToHRQAAAACAEYAAAI8AwwAFQAYAAA3Ez4BMhYXExQGIyImLwEjBw4BIyImNzMDRssFGiIcBMofFREaBSffJwUbERUfqqNSMwK1EBQUEP1LFR4UEIaGEBQe8QEWAAAAAwBJAAACOwMMAA4AGAAiAAAzESEyFh0BFAcWHQEUBiMnMzI2PQE0JisBNTMyNj0BNCYrAUkBKFJ4RkZ4UsPDKTw8KcPDKTw8KcMDDHhSJVk+PlklUnhlPSglKTxlPCglKD0AAAEASQAAAjsDDAAlAAATND8BPgE7ATIWFRQGKwEiDwEGFB8BFjsBMhYVFAYrASImJyYnJkkYZRBLLboVHh4Vuh8NZw0NZw0fuhUeHhW6LEkSShwYAYY1MswkLx4UFR4cyxw8HMscHhQVHjAkjT4zAAACAEkAAAI7AwwAGwAoAAA3NDY7AREjIiY1NDY7ATIWHwEWFA8BDgErASImNzMyPwE2NTQvASYrAUkdFTExFR0dFbosSRJmGRllEEstuhUdyCQfDWcODmcNHyQzFB4CQh4VFB4wJMs0ZjTMJC8eRxzLIhgeHMscAAABAEkAAAI7AwwAGQAAMxEhMhYVFAYjIRUzMhYUBisBFSEyFhUUBiNJAb8VHh4V/qaUFB4eFJQBWhUeHhUDDB4UFR7uHiod7x4UFR4AAQBJAAACOwMMABYAADcRITIWFRQGIyEVMzIWFAYrAREUBiImSQG/FR4eFf6m9xUdHRX3HiodMwLZHhQVHpodKh7+ixUeHgAAAQBJAAACOwMMACoAADcRND8BNjsBMhYVFAYrASIPAQYVERQWOwEyNj0BIyImNDY7ARUUBisBIiZJKogtS5UVHh4VlRkPiBUeFMMUH2MVHR0VyFo+wz9YmAEPRTawOh4UFR4Urhwi/vEVHh4VZx0qHsw+WlkAAAAAAQBJAAACOwMMABsAADcRNDYyFhURIRE0NjIWFREUBiImNREhERQGIiZJHSoeASgdKh4eKh3+2B4qHTMCpxQeHhT+3wEhFB4eFP1ZFR4eFQEh/t8VHh4AAAEASQAAAjsDDAAfAAA3NDY7AREjIiY1NDYzITIWFRQGKwERMzIWFRQGIyEiJkkdFZSUFR0dFQGNFR4eFZSUFR4eFf5zFR0zFB4CQh4VFB4eFBUe/b4eFBUeHgAAAQB6AAACCQMMABsAADc1NDYyFh0BFBY7ATI2NRE0NjIWFREUBisBIiZ6HiodHhVfFR4dKh5aPl8+WpeaFR4eFZoVHR4UAkMUHh4U/b0+WVkAAAAAAQBJAAACOwMMAB4AADcRNDYyFh0BATYzMhYVFAcJARYVFAYjIicBFRQGIiZJHSoeATkPEhUeEv6gAWASHhUSD/7HHiodMwKnFB4eFOYBDAweFBgP/tP+0w8XFR4MAQzlFR4eAAEASQAAAjsDDAAOAAAzETQ2MhYVESEyFhUUBiNJHSoeAVoVHh4VAtoUHh4U/YseFBUeAAABAEkAAAI7AwwAGwAANxEzFzczERQGIiY1EQcVFAYjIiY9AScRFAYiJkl+e3p/HiodYh4UFR5hHiodMwLZr6/9JxUeHhUCTowaFR4eFRqK/bQVHh4AAAAAAQBJAAACOwMMABEAADcRMwERNDYyFhURIwERFAYiJkmFAQgdKh6G/vkeKh0zAtn9pgIoFB4eFP0mAlj92xUeHgAAAAACAEkAAAI7AwwAFgApAAATND8BPgEzMhYfARYUDwEOASMiJi8BJjcGFB8BFjMyPwE2NTQvASYjIgdJGGsQPyYnPxBrGRlrED8nJj8QaxhyDQ1sCBIUCGsODmwIExEJAYY1MtcfKSkf1zRmNNcfKSkf1y5zHDwc1hEQ1yIYHhzVEhIAAAACAEkAAAI7AwwADwAZAAA3ESEyFh0BFAYrARUUBiImEzMyNj0BNCYrAUkBWj5aWj71HiodZfUUHx8U9TMC2Vk+tD5a9hUeHgFwHhW0FB4AAAIASQAAAjsDDAAhAEAAADcRND8BNjMyFhURFA4FBxczMhYVFAYrAScHBiMiJjcUOwE3JyY1NDYzMh4DFz4ENRE0JisBBwYVSUbhIC8ySggUDiMOLAUYQRUeHhWGJUsiLTJIZRUIbCUDHhUNFA8IDAIEHw4UCQ0KB+giewEaXj2+Hkky/uYXKSUZIg0kBD0eFBUeXkAeSTIWXF4HCxUeCxoRJAQEGQ0aHBEBGgkMwx4wAAAAAAIASQAAAjsDDAAZACMAADcRITIWHQEUBisBExYVFAYjIicDIxEUBiImEzMyNj0BNCYrAUkBWj5aWz06ywceFR0P6UUeKh1l9RQfHxT1MwLZWj40Plr+pA4LFR4ZAY/+ixUeHgHvHxQ0FR4AAAEASQAAAjsDDAAsAAA3NDYyFhUUFjsBMjUBJj0BNDY7ATIWFRQGIiY1NCYrASIdAgEWFQ4BKwEiJkkdKh4UDvkN/ooXQy75N1EeKh0VDvkMAXQZAkEv+TdQhxUeHhUOFA0B4iAmAy1CUDcVHh4VDRUKAwT+Ih4oL0NQAAABAEkAAAI7AwwAGAAAEzUhFRQGIiY9ASMRFAYjIiY1ESMVFAYiJkkB8h4qHWIeFBUeYR4qHQKFh4cVHh4VIv2MFR4eFQJ0IhUeHgAAAQBJAAACOwMMABsAADcRNDYyFhURFBY7ATI2NRE0NjIWFREUBisBIiZJHSoeHhTDFB8dKh5aPsM+WZcCQxQeHhT9vRUdHhQCQxQeHhT9vT5ZWQAAAQBJAAACOwMMABUAABM1NDYyFh0BGwE1NDYyFh0BAwYjIidJHSoelJQdKh7KDSIjDQIltRQeHhSh/oYBeqEUHh4UtP36ICAAAQBJAAACOwMMACsAADcRNDYyFhURFzM+ATcRNDYzMhYVER4BFzM3ETQ2MhYVEQcGKwEiJwYrASInSR0qHhwpAhQGHhUUHgYUAikdHSoeOQ8dYiASFR5hHg96AmAUHh4U/bswAyYKAUMVHR0V/r0KJgMwAkUUHh4U/aBhGSMjGQABAEkAAAI7AwwAIwAANzQ3EwMmNTQ2MzIXGwE2MzIWFRQHAxMWFRQGIyInCwEGIyImSQa4uAYdFR0Pm5oPHRUeB7i4Bx4VHQ+amw8dFR0zDQwBOgE6DA4UHhn++AEIGR4UDA7+xv7GDgsVHhkBCP74GR4AAAEASQAAAjsDDAAZAAATNTQ2MhYdARc3NTQ2MhYdAQcRFAYjIiY1EUkdKh6Ukx4qHsceFBUeAnNnFB4eFES+vkQUHh4UZ/7+vhUeHhUBQgAAAQBIAAACOwMMABMAADcBISImNTQ2MyEVASEyFhUUBiMhSAFo/ssVHR0VAcD+mAE1FR4eFf5BQAJnHhUUHkD9mR4UFR4AAAAAAgBJAAACOwMMABcAGwAANxE0NjMhMhYVFAYrAREzMhYVFAYjISImNzMRI0kdFQGNFR4eFcbGFR4eFf5zFR1kMDAzAqcUHh4UFR79vh4UFR4eRwJCAAAAAAEASQAAAjsDDAAPAAATNDYzMhcBFhUUBiMiJwEmSR0VHQ8BjQceFR0P/nMGAtoUHhn9WQ4LFR4ZAqcMAAIASQAAAjsDDAAXABsAADc0NjsBESMiJjU0NjMhMhYVERQGIyEiJiUzESNJHRXGxhUdHRUBjRUeHhX+cxUdAV0wMDMUHgJCHhUUHh4U/VkVHh5HAkIAAAABAEgAfwI7AmIAFAAANxM2MzIXExYVFAYjIi8BBwYjIiY1SM0NIB4OyAUeFRsOnZ4OGxUdvgGJGxv+gAwJFR4V7OwVHhUAAAABAEn/mwI7AAAADQAAFzQ2MyEyFhUUBiMhIiZJHRUBjRUeHhX+cxUdMhQeHhQVHh4AAAAAAQB6AagCCQMMABAAABM0NjsBMhcTFhUUBiMiJwEmeh4VYxoOywYeFRAQ/tYSAtoUHhP++gsNFR4MAP8PAAAAAAIASQAAAjsCOAAmADQAADc1NDY7ATIXNC4FKwEiJjQ2OwEyFhcTFAYjIiY1BwYrASImNxQWOwE3NTQmKwEiBhVJWD3BGBQBAQMGCxEMuhUdHRW6PVcCDR8VFB1KCg+VPVhlHBSHax8SwRMdljg+WAcHIQ8cDRAGHSoeVTz+ixUdHhQrB1g+FB0/LBIdHRQAAAIASQAAAjsDDAApAEMAADcRNDYyFh0BNjsBMh4FFxYdARQOBA8BBisBIi4BJxUUBiImNxQfARY7ATI+ATc2PQE0LgEnJisBIg8BBhVJHSoeRENLDRgYDhgHGwE1BA4HGgURESk4Sx02HRceKh1lEVYMFEsOFh4CEg0fARUUSxQMVhEzAqcUHh4U4kADCwUTBRcBLkTOEBsaDxoGDw4kFhcVDxUeHsIXDkoMDB4BDhfODhQaARMMSgsaAAAAAQBJAAACOwI4ACYAADc1NDc+AzsBMhYUBisBIg8BBh0BFB8BFjsBMhYVFAYrASIvASZJNAszITof0xUeHhXTFAxWERFWDBTTFR4eFdM5KVY04HhFLQkxGxkeKh0MSgsaeBcPSQweFBUeJEotAAAAAAIASQAAAjsDDAAtAEgAADc1NDY3Njc2OwEyHgQXNTQ2MhYVERQGIiY9AQ4CKwEiLgcnJjcUHgIXFjsBMj8BNj0BNC8BJisBIg4BBwYVSSonBQMpOEsQHhMeCB8CHSoeHiodFx02HksLExMOEQoRBhMCNGUMDRgEDxFLEg5WEhJWDBRLDhcaBBK1zjA7IAQCJAcHFAYcAecUHh4U/VkVHh4VEBYXFgIGBQoGDgURAitHDBYMEwMMDEoNGHgVEEoMDRoDEBYAAAAAAgBJAAACOwI4ADQAQQAANzU0PgE3NjsBMh4GHwEWHQEUBiMhFRQeAhcWMyEyFhUUBiMhIi4HJyY3ITU0JisBIg4BBwYVSSAaHyk4fQoTFAwUBxQECws1HhX+pgwNGAQPEQEFFR4eFf77CxMTDhEKEQYTAjRlASg8Gn0OFh4CEbXOIzwYGiQCBgQMBBECCgouRHwVHh8MFgwTAwweFBUeAgYFCgYOBRECK8tKGjYMHgEOFwAAAQBhAAACIQMMACQAABI0NjsBNTQ2OwEyFhUUBisBIgYdATMyFhQGKwERFAYiJjURIyJhHRUxaEp5FR0dFXkgLWMUHh4UYx0qHjEVAfAqHiJKaB4UFR4tICIeKh3+YBUeHhUBoAAAAAACAEn/LAI7AjgAQgBZAAA3NTQ+CDc2OwEyHgQXNTQ2MhYVERQOBA8BBisBIiY0NjsBMj4BNzY9AQ4CKwEiLgMvASY3FBY7ATI/ATY9ATQvASYrASIOAQcGFUkDAwsEEAQVAxcBKThLEB4THggfAh0qHgQOBxoFEREpONMVHh4V0w4XHAMSFx42HUsPHxIeBxARNGQ7G0sUDFYSElYMFEsPFxgGEuCjCxYQFAoTBhIDEwEkBwcUBhwBEhUeHhX93BAbGg8aBg8OJB0qHg4aAw4XjRUYFwcGFQUPDi1FGzYMSg4XThUQSgwOGAQSFAAAAAABAEkAAAI6AwwAIAAANxE0NjIWHQE3NjsBMhYXExQGIyImNQMuASsBBxEUBiImSR0qHmAmKzk9VwIMHRUUHg0CGxRHox4qHTMCpxQeHhT3PRhVPP6MFR4dFAFzExxp/skVHh4AAgB6AAACCQM2ABoAKgAANzQ2OwERIyImNDY7ATIWFREzMhYVFAYjISImEzU0NjsBMhYdARQGKwEiJnoeFWNjFR4eFZUUHmIVHh4V/tcVHmMeFTIUHh4UMhUeMxQeAW4dKh4eFf5gHhQVHh4CvCoVHR0VKhUeHgAAAgB6/ywCCQM2AB8ALwAAFzQ2MzIeAjsBMjY1ESMiJjQ2OwEyFhURFAYrASImJxM1NDY7ATIWHQEUBisBIiZ6HhUUGAkZFWIUH5UVHh4VxhUeWT5iOFYI+B4VMRUeHhUxFR5NFR4bHxsdFAIRHSoeHhX9vT5YSjUDLyoVHR0VKhUeHgAAAQBJAAACOwMMAB8AADcRNDYyFhURJTYzMhYVFA8BFxYVFAYjIiclBxUUBiImSR0qHgEIDhIVHhLL/RIdFRMP/vcwHiodMwKnFB4eFP5x4QweFRcPrtgPFxUeDOMqkhUeHgAAAAEAegAAAgkDDAAbAAA3NDY7AREjIiY1NDY7ATIWFREzMhYVFAYjISImeh4VYmIVHh4VlRQeYhUeHhX+1xUeMxQeAkIeFRQeHhT9ix4UFR4eAAAAAAEAQQAAAkICOAAuAAA3ETQ2MzIWFzYzMhc3NjMyFhcTFAYjIiYnAyYrAQcRFAYjIiY1ETQrAQcRFAYiJkEdFRAbBSktPSQWISovSAEPHRUUHgEOAg8GRB4UFR4WCEseKh0zAdIVHhQPIzASG0Iv/m8VHh0UAY8TOv6aFR4eFQGKFkH+oRUeHgABAEkAAAI6AjgAIAAANxE0NjIWHQE3NjsBMhYXExQGIyImNQMuASsBBxEUBiImSR0qHmAmKzk9VwIMHRUUHg0CGxRHox4qHTMB0hUeHhUiPRhVPP6MFR4dFAFzExxp/skVHh4AAgBJAAACOwI4ACYAQAAANzU0PgE3NjsBMh4FFxYdARQOBA8BBisBIi4EJyY3FB4CFxY7ATI+ATc2PQE0JisBIg4BBwYVSSAaHyk4fQ0YGA4YBxsBNQQOBxoFEREpOH0QHRQbCxsENGUMDRgEDxF9DhYeAhI8Gn0OFh4CEbXOIzwYGiQDCwUTBRcBLkTOEBsaDxoGDw4kBwcSCBgDK0cMFgwTAwwMHgEOF84aNgweAQ4XAAAAAgBJ/ywCOwJNACwASgAAFxE0NjIWHQE+CDsBMh4BFx4EHQEUDwEGKwEiLgEnFRQGIiYTFB4CFx4CFxY7ATI/ATY9ATQvASYrASIPAQYVSR0qHgITBhIKEg8TFQsVHTcbGQIwDB0KNVYpORUfNyAVHiodZQoKFQMHGBQJDhUVFAxXERFXDBQVFQ5aDqICvRQeHhQbAhQFEQYNBQcCGBUXAikPJiYXoUQuSiQYHBfYFR0dAZIMFQsSAwcZFAgODEoNGKEYDUsMDlsLFwAAAgBJ/ywCOwI4AC0ASAAANzU0Njc2NzY7ATIeBBc1NDYyFhURFAYiJj0BDgIrASIuBycmNxQeAhcWOwEyPwE2PQE0LwEmKwEiDgEHBhVJKicFAyk4SxAeEx4IHwIdKh4eKh0XHTYeSwsTEw4RChEGEwI0ZQwNGAQPEUsSDlYSElYMFEsOFxoEErXOMDsgBAIkBwcUBhwBEhUeHhX9WRUdHRXlFhcWAgYFCgYOBRECK0cMFgwTAwwMSg0YeBUQSgwNGgMQFgAAAAABAEkAAAI7AjgAHwAANxE0NjIWHQE3NjsBMhYdARQGIiY9ATQmKwEHERQGIiZJHSoedwsSYz1ZHiodHRRRph4qHTMB0hUeHhU7ZghZPRwVHR0VHBQdj/7vFR4eAAEASQAAAjoCOAA0AAA3NDYzMhYXHgE7ATI2NTQnJS4BNTQ3NjsBMhcWFRQGIyImKwEiBhUUFwUeAR0BDgErASInJkkcFRImCQIUBMsYGx3+6yIqJSY11kswCh4VEi0T1g0PEAEWJjUBWj+9ST4TXRUdHQMBCSAWIg14D0MnMyQmPw0RFR4rEgsSBngRTS4CP1k1EAABAEkAAAI7AuIAKgAAEjQ2OwE1NDYyFh0BMzIWFAYrAREUFjsBMj4CMzIWHQEOASsBIiY1ESMiSR0VMR0qHsUVHR0VxRwUZBQZCRkUFR4KVTdkPVgxFQHwKh53FR4eFXceKh3+wxQdGx8bHhUINEtZPQE9AAEASQAAAjsCOAAgAAATNDYzMhYVEx4BOwE3ETQ2MhYVERQGIiY9AQcGKwEiJidJHRUUHg0CGxRHpB0qHh4qHWEmKzk8WAICBRUeHRT+jRQbaAE4FR4eFf4uFR4eFSM+GFU7AAABAEkAAAI7AjgAGgAAEzU0NjIWHQEbATU0NjIWHQEUBwMGKwEiJwMmSR0qHpOVHSoeBacNIT8hDacEAbBVFR4eFUr+rQFTShUeHhVVCgr+gh4eAX4IAAAAAQA+AAACRQI4ACsAABM0NjMyFhcTFzc1NDYzMhYdARc3Ez4BMhYdAQMHDgErASIvAQcGKwEiJi8BPh4VFB0BCiBCHhUUHkIgCgEdKB8LMwUbETEdDzc4Dx0xERsFNAIEFR8dFP7dbHJyFB4eFHJybAEjFB0eFAL+yqoQFBlfXxkUELYAAQBJAAACOwI4ACMAADc0PwEnJjU0NjMyHwE3NjMyFhUUDwEXFhUUBiMiLwEHBiMiJkkKraEMHhUXEJWUEBcVHgyhrQseFRgPn6APGBUdMxMN0MIPERUeE7OzEx4VEQ/C0A4SFR4SwcESHgAAAQBJ/ywCOwI4ACMAABY0NjsBNyMiJwMmPQE0NjIWHQETMxM1NDYyFh0BFAcBBisBIkkdFWdDFSIMlQQdKh6DIIQeKh4F/vwNIogVtyoemR8BUwgMVRUeHhVK/tQBLEoVHh4VVQoK/a4eAAAAAQBJAAACOwI4ABwAADc1NDcBISImNDYzITIWHQEUBwEhMhYVFAYjISImSQ8BYP7bFR0dFQF1FR4Q/qEBPBUeHhX+cxUdMyoXDQFSHSoeHhUqFRD+rx4UFR4eAAABAEkAAAI7AwwAKgAAEjQ2OwEyNj0BNDY7ATIWFRQGKwEVFAcWHQEzMhYVFAYrASImPQE0JisBIkkdFWEWHT0olBUeHhWUJyeUFR4eFZQoPR4VYRUBcSoeHRW8KTweFBUevDksLDm8HhQVHjwpvBQfAAAAAAIBDwAAAXQDDAAIABEAACURMxEUBiMiJhkBNDYzMhYVEQEPZR4UFR4eFRQeMwEh/t8VHh4BmwEhFB4eFP7fAAABAEkAAAI7AwwAKgAANzQ2OwE1NDcmPQEjIiY1NDY7ATIWHQEUFjsBMhYUBisBIgYdARQGKwEiJkkdFZQnJ5QVHR0VlCk8HRViFR4eFWIVHTwplBUdMxQevDksLDm8HhUUHjwpvBQeHiodHxS8KTweAAAAAAEASQGqAjsDCwAmAAATNTQ2MzIWHQEUFjI2PQE0NjIWHQEUBiMiJyY9ATQmIgYdARQGIiZJXTw6WB0oHR0qHlw9PCssHSgcHiodAgVvQVZYPzQUHx8UbxUeHhVvQVUrLj00FB4eFG8VHR0AAAEAcQAAAmMDDAATAAAzETQ2MhYdATMRIREUBiImPQEjEXEdKh5hASweKh1iATEVHh4VzAKn/s8VHh4VzP1ZAAABAHEAAAJjAwwAFQAANxEhETQ2MhYVERQGIiY1ESERFAYiJnEBjR0qHh4qHf7YHiodMwGGASEUHh4U/VkVHh4VASH+3xUeHgABAHEAAAJjAwwAGAAAExE0NjIWFREhETQ2MhYVESMRFAYjIiY1EXEdKh4BKB0qHsceFBUeAVQBhhQeHhT+3wEhFB4eFP56/t8VHh4VASEAAAEBN/+bAZwEUgADAAAFETMRATdlZQS3+0kAAAABAFf/5wJ8AyUAAwAAFxEhEVcCJRkDPvzCAAAAAQDtAAAB5gD6AA8AADc1NDY7ATIWHQEUBisBIibtHRWVFR0dFZUVHTOUFR4eFZQVHh4AAAEAcQAAAmMDDAAeAAATNDcBNjIfARYdARQHBRUUBiImPQE0NyU1JwUGIyImcREBKg8kD2MSEv7oHiodEQEZMf73DxIVHQHbGA4A/wwMVQ8XVRcQ7+cVHh4V/hkO7yYq4wweAAABAQMBqAHRAwwAEwAAATQ2OwEyFhUUBhUDFAYiJjU0NjUBAyAVYxQiATMfKCEBAtoUHhoSAQQB/wAUHhoSAQQBAAAAAAEA1AAAAf8BZAAUAAATNTQ2OwEyFh0BFAYrASImPQEjIibUHRXHFR0dFTIVHWMVHQEHKhUeHhX+FR4eFaEeAAABAHEBVAJjAbkACwAAEjQ2MyEyFhQGIyEicR0VAY0VHh4V/nMVAXEqHh4qHQAAAAAAAA4ArgABAAAAAAAAAFYArgABAAAAAAABAAQBDwABAAAAAAACAAcBJAABAAAAAAADACEBcAABAAAAAAAEAAUBngABAAAAAAAFAAoBugABAAAAAAAGAAQBzwADAAEECQAAAKwAAAADAAEECQABAAgBBQADAAEECQACAA4BFAADAAEECQADAEIBLAADAAEECQAEAAoBkgADAAEECQAFABQBpAADAAEECQAGAAgBxQBNAGEAdAB0AGgAZQB3ACAAUwBrAGEAbABhACAAKAAyADAAMQAxAC0AMQAyACkAOwAgAGIAYQBzAGUAZAAgAG8AbgAgAGMAbwBkAGUAIABiAHkAIABSAGkAYwBoAGEAcgBkACAAQgAuACAAVwBhAGwAZQBzACAAKAAxADkAOAA4AC0AOAA5ACkAIABhAG4AZAAgAFQAbwByACAATABpAGwAbABxAHYAaQBzAHQAAE1hdHRoZXcgU2thbGEgKDIwMTEtMTIpOyBiYXNlZCBvbiBjb2RlIGJ5IFJpY2hhcmQgQi4gV2FsZXMgKDE5ODgtODkpIGFuZCBUb3IgTGlsbHF2aXN0AABPAEMAUgBBAABPQ1JBAABSAGUAZwB1AGwAYQByAABSZWd1bGFyAABGAG8AbgB0AEYAbwByAGcAZQAgADIALgAwACAAOgAgAE8AQwBSACAAQQAgADoAIAAyADcALQA5AC0AMgAwADEAMgAARm9udEZvcmdlIDIuMCA6IE9DUiBBIDogMjctOS0yMDEyAABPAEMAUgAgAEEAAE9DUiBBAABWAGUAcgBzAGkAbwBuACAAMgAgAABWZXJzaW9uIDIgAABPAEMAUgBBAABPQ1JBAAAAAAIAAAAAAAAAAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAbAAAAAEAAgADAAQABQAGAAcACAAJALcACwAMAA0ADgAPABAAEQASABMAFAAVABYAFwAYABkAGgAbABwAHQAeAB8AIAAhACIAIwAkACUAJgAnACgAKQAqACsALAAtAC4ALwAwADEAMgAzADQANQA2ADcAOAA5ADoAOwA8AD0APgA/AEAAQQBCALYARABFAEYARwBIAEkASgBLAEwATQBOAE8AUABRAFIAUwBUAFUAVgBXAFgAWQBaAFsAXABdAF4AXwBgAGEBAgEDAQQBBQEGAQcBCAEJAQoBCwd1bmkyNDQwB3VuaTI0NDEHdW5pMjQ0MghTRjExMDAwMAtibGFja3NxdWFyZQpwZXJpb2QuYWx0DHF1ZXN0aW9uLmFsdA9xdW90ZXNpbmdsZS5hbHQJY29tbWEuYWx0Cmh5cGhlbi5hbHQAAAAB//8AAgABAAAADgAAABgAAAAAAAIAAQADAGsAAQAEAAAAAgAAAAEAAAAKAEQAogACREZMVAAObGF0bgAkAAQAAAAA//8ABgAAAAEAAgADAAQABQAEAAAAAP//AAYAAAABAAIAAwAEAAUABmFhbHQAJnNzMDEALHNzMDIAMnNzMDMAOHNzMDQAPnNzMDUARAAAAAEAAAAeAAEAAQAcAAEAAgAaAAEAAwAYAAEABAAWAAEABQAAAQAAAAEBAAABAgAAAQMAAAEEAAYADgAWAB4AJgAuADYAAwAAAAEAMAABAAAAAQBkAAEAAAABAGgAAQAAAAEAbAABAAAAAQBwAAEAAAABAHQAAQAuAAUAEAAWABwAIgAoAAIACgBpAAIADwBqAAIAEABrAAIAEQBnAAIAIgBoAAEABQAKAA8AEAARACIAAQAGAFYAAQABABEAAQAGAEYAAQABACIAAQAGAF8AAQABAAoAAQAGAFsAAQABAA8AAQAGAFsAAQABABAAAQAAAAoALAAuAAJERkxUAA5sYXRuABgABAAAAAD//wAAAAQAAAAA//8AAAAAAAAAAAABAAAAAMw9os8AAAAA1gbbzAAAAADaAyOv");
FontLib.loadFont("OCR-B", 96, 100, "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