import { Routes, Route, Outlet } from "react-router-dom";
import { ToastContainer } from "react-toastify";
import Navbar from "./components/Navbar";
import SideBar from "./components/SideBar";
import CompanyInformation from "./pages/CompanyInformation";
import SaleProducts from "./pages/SaleProducts";
import RegisterProducts from "./pages/RegisterProducts";
import ExistProducts from "./pages/ExistProducts";
import Expenses from "./pages/Expenses";
import LoanManagement from "./pages/LoanManagement";
import Employee from "./pages/Employee";
import Report from "./pages/Report";
import CustomerRegistration from "./pages/CustomerRegistration";
import RegistredCustomers from "./pages/RegistredCustomers";
import Spent from "./pages/Spent";
import Login from "./pages/Login";
import PrivatePage from "./pages/PrivatePage";
import BuyProduct from "./pages/BuyProduct";
import AddSupplier from "./pages/AddSupplier";
import AddProductMaster from "./pages/AddProductMaster";
import SupplierList from "./pages/SupplierList";
import ProductMasterList from "./pages/ProductMasterList";
import WareHouse from "./pages/WareHouse";
import DailyRegistredProduct from "./pages/DailyRegistredProduct";
import SoldProduct from "./pages/SoldProduct";
import SupplierTransaction from "./pages/SupplierTransaction";
import RemainProductMaster from "./pages/RemainProductMaster";
import SupplierBelance from "./pages/SupplierBelance";
import DailyReport from "./pages/DailyReport";
import BuyProductFromSupplier from "./pages/suppliers/BuyProductFromSupplier";
import RegisterSupplierProduct from "./pages/suppliers/RegisterSupplierProduct";
import Trader from "./pages/traderInfo/Trader";
import ExistTrader from "./pages/traderInfo/ExistTrader";
import NewTrade from "./pages/traderInfo/NewTrade";
import DailyExpense from "./pages/daily/DailyExpense";
import DailyTrade from "./pages/daily/DailyTrade";
import AddFragment from "./pages/fragment/AddFragment";
import ExistFragment from "./pages/fragment/ExistFragment";
import ExistFragmentMain from "./pages/fragment/ExistFragmentMain";
import FragmentReport from "./pages/fragment/FragmentReport";
import ShowFragmentReport from "./pages/fragment/ShowFragmentReport";
import OldTrasansaction from "./pages/suppliers/OldTrasansaction";
import Person from "./pages/personallyExpense/Person";
import PersonExpense from "./pages/personallyExpense/PersonExpense";
import ShowExpense from "./pages/personallyExpense/ShowExpense";
import ShowPerson from "./pages/personallyExpense/ShowPerson";
import Loan from "./pages/loanReport/Loan";
import ReportList from "./pages/loanReport/ReportList";


function App() {
  return (

    <div className="h-screen">
      <ToastContainer />

      <Routes>


        <Route path="/login" element={<Login />} />

        <Route element={<PrivatePage />}>

          {/* Layout */}
          <Route
            element={
              <div className="relative">
                <div className="absolute top-0 z-10 w-full">
                  <Navbar />
                </div>

                <div className="flex h-screen relative">
                  <div className="absolute top-14 right-0 z-20">
                    <SideBar />
                  </div>

                  <div className="pr-12 absolute top-18 w-full">
                    <Outlet />
                  </div>
                </div>
              </div>
            }
          >
            <Route path="/sale-product" element={<SaleProducts />} />
            <Route path="/company-information" element={<CompanyInformation />} />
            <Route path="/register-product" element={<RegisterProducts />} />
            <Route path="/exist-product" element={<ExistProducts />} />
            <Route path="/expenses" element={<Expenses />} />
            <Route path="/loan-management" element={<LoanManagement />} />
            <Route path="/employee" element={<Employee />} />
            <Route path="/report" element={<Report />} />
            <Route path="/customer-registration" element={<CustomerRegistration />} />
            <Route path="/registred-customers" element={<RegistredCustomers />} />
            <Route path="/spent" element={<Spent />} />
            <Route path="/buy-product" element={<BuyProduct />} />
            <Route path="/add-supplier" element={<AddSupplier />} />
            <Route path="/add-product-master" element={<AddProductMaster />} />
            <Route path="/supplier-list" element={<SupplierList />} />
            <Route path="/product-master-list" element={<ProductMasterList />} />
            <Route path="/ware-house" element={<WareHouse />} />
            <Route path="/daily" element={<DailyRegistredProduct />} />
            <Route path="/sold-product" element={<SoldProduct />} />
            <Route path="/supplier-transaction" element={<SupplierTransaction />} />
            <Route path="/remain" element={<RemainProductMaster />} />
            <Route path="/supplier-belance" element={<SupplierBelance />} />
            <Route path="/daily-report" element={<DailyReport />} />
            <Route path="/product-from-supplier" element={< BuyProductFromSupplier />} />
            <Route path="/register-supplier-product" element={< RegisterSupplierProduct />} />
            <Route path="/trader" element={< Trader />} />
            <Route path="/exist-trader" element={< ExistTrader />} />
            <Route path="/new-trade" element={< NewTrade />} />
            <Route path="/daily-expense" element={< DailyExpense />} />
            <Route path="/daily-trade" element={< DailyTrade />} />
            <Route path="/add-fragment" element={< AddFragment />} />
            <Route path="/exist-fragment" element={< ExistFragment />} />
            <Route path="/fragment" element={< ExistFragmentMain />} />
            <Route path="/fragment-report" element={< FragmentReport />} />
            <Route path="/show-fragment-report" element={< ShowFragmentReport />} />
            <Route path="/old" element={< OldTrasansaction />} />
            <Route path="/person" element={< Person />} />
            <Route path="/person-expense" element={< PersonExpense />} />
            <Route path="/show-expense" element={< ShowExpense />} />
            <Route path="/show-person" element={< ShowPerson />} />
            <Route path="/loan" element={<Loan />} />
            <Route path="/report-list" element={<ReportList />} />
          </Route>
        </Route>

      </Routes>
    </div>

  );
}

export default App;