import axios from 'axios'
import { createContext, useEffect } from 'react';
import { toast } from "react-toastify";
import { useState } from 'react';

export const AppContext = createContext()

const AppContextProvider = (props) => {

    const backendUrl = import.meta.env.VITE_BACKEND_URL
    const [companyData, setCompanyData] = useState([])
    const [existProduct, setExistProduct] = useState([])
    const [customers, setCustomers] = useState([])
    const [spents, setSpents] = useState([])
    const [token, setToken] = useState(localStorage.getItem('token') ? localStorage.getItem('token') : false)
    const [loanData, setLoanData] = useState([])
    const [rate, setRate] = useState("")
    const [saved, setSaved] = useState(false)
    const [usdRate ,setUsdRate ] = useState("")
    const [afnRate , setAfnRate] = useState("")
    const [AllSales, setAllSales] = useState([])

    const [companyInformation, setCompanyInformation] = useState({
        CompanyName: "دستگاه زرگری نصیر احمد",
        slogan: "باما بدرخشید",
        phone: '0788121212',
        email: "nasir@gmail.com",
        address: "مزارشریف",
        logo: "img"
    })

    useEffect(() => {
        const storedRate = localStorage.getItem("dollerRate")
        if (storedRate) {
            setRate(storedRate)
        }
    }, [])

    const saveRate = () => {
        localStorage.setItem("dollerRate", rate)
        setSaved(true)
        setTimeout(() => setSaved(false), 2000)
    }

    useEffect(()=>{
        const storedRate = localStorage.getItem('usdRate')
        if(storedRate){
            setUsdRate(storedRate)
        }
    },[])

    useEffect(()=>{
        const storedRate = localStorage.getItem('afnRate')
        if(storedRate){
            setAfnRate(storedRate)
        }
    },[])

    const saveStorageRate = () => {
        localStorage.setItem("usdRate", usdRate)
        localStorage.setItem("afnRate" , afnRate)
        setSaved(true)
        setTimeout(() => setSaved(false), 2000)
    }

    const getCompanyData = async () => {
        try {

            const response = await axios.get(backendUrl + '/api/company/company-data')

            if (response.data.success) {
                setCompanyData(response.data.companyData)
            }

        } catch (error) {
            console.log(error)
            toast.error(error.message)
        }
    }

    const getExistProduct = async () => {
        try {

            const { data } = await axios.get(backendUrl + '/api/product/exist-product')

            if (data) {
                setExistProduct(data.products)
            }


        } catch (error) {
            console.log(error)
            toast.error(error.message)
        }
    }

    const getCustomers = async () => {
        try {

            const { data } = await axios.get(backendUrl + '/api/customer/registred-customers')

            if (data) {
                setCustomers(data.customers)
            }


        } catch (error) {
            console.log(error)
            toast.error(error.message)
        }
    }

    const getSpents = async () => {
        try {

            const { data } = await axios.get(backendUrl + '/api/expense/get-spent')

            if (data.success) {
                setSpents(data.spent)
            }

        } catch (error) {
            console.log(error)
            toast.error(error.message)
        }
    }

    const getLoan = async () => {
        try {

            const { data } = await axios.get(backendUrl + '/api/transaction/loan-transaction')

            if (!data.success) {
                toast.error("قرضدار وجود ندارد")
            }

            if (data.success) {
                console.log(data)
                setLoanData(data.loans)
            }

        } catch (error) {
            console.log(error)
            toast.error(error.message)
        }
    }
    const getAllSaleReport = async () => {
        try {
    
          const { data } = await axios.get(
            `${backendUrl}/api/transaction/sale-report`);
          if (!data.success) {
            toast.error(data.message)
          }
          if (data.success) {
            setAllSales(data)
          }
    
        } catch (error) {
          console.log(error)
          toast.error(error.message)
        }
      }

    

    useEffect(() => {
        getCompanyData()

    }, [])

    const value = {
        companyInformation, setCompanyInformation,
        backendUrl, companyData, setCompanyData,
        getExistProduct, existProduct, setExistProduct,
        customers, setCustomers, getCustomers,
        spents, setSpents, getSpents, token, setToken,
        getLoan, setLoanData, loanData,
        rate , setRate , saved , setSaved , saveRate,
        getAllSaleReport , AllSales,
        usdRate , setUsdRate , afnRate , setAfnRate,saveStorageRate
    }

    return (
        <AppContext.Provider value={value} >
            {props.children}
        </AppContext.Provider >
    )
}

export default AppContextProvider
