import { createContext, useContext, useState, useEffect } from "react";
import { toast } from "react-toastify";


const BuyProductContext = createContext()

export const useBuyCart = () => {
    const context = useContext(BuyProductContext)

    if (!context) {
        toast.error("داخل پرووایدر استفاده کنید")
    }
    return context
}

export const BuyProductProvider = ({ children }) => {

    const [buyCart, setBuyCart] = useState([])

useEffect(()=> {
    const savedCart = localStorage.getItem('buyCart')
    if (savedCart) {
        try {
            setBuyCart(JSON.parse(savedCart))
        } catch (error) {
            toast.error(error)
        }
    }

}, [])

useEffect(() =>{
    localStorage.setItem('buyCart' , JSON.stringify(buyCart))
} , [buyCart])

const addToBuyCart = (product, price, quantity) => {
  setBuyCart(prevCart => {
    // پیدا کردن آیتم با همان محصول و همان قیمت
    const index = prevCart.findIndex(
      item => item.product._id === product._id && item.price === price
    );

    if (index !== -1) {
     
      const updatedCart = [...prevCart];
      updatedCart[index] = {
        ...updatedCart[index],
        quantity: (updatedCart[index].quantity || 0) + quantity
      };
      return updatedCart;
    }


    return [
      ...prevCart,
      {
        product,
        price,
        quantity
      }
    ];
  });
};



const removeFromCart = (productId)=>{
    setBuyCart(prevCart => prevCart.filter(item => item._id !== productId ))
}

const updateQuantity = (productId , newQuantity) =>{
    if(newQuantity<1){
        removeFromCart(productId);
        return;
    }
    setBuyCart(prevCart => prevCart.map(item=> item._id === productId ? {...item , quantity : newQuantity} : item))
}

const clearCart = ()=>{
    setBuyCart([]);
    localStorage.removeItem('buyCart')
}

const getTotalPrice = ()=>{
    return buyCart.reduce((total , item)=>total + item.price * item.quantity,0)
}

const getTotalItems = ()=>{
    return buyCart.length
}
const savePrice =(id , price , discount)=>{
    setBuyCart(prev => 
      prev.map(item => item._id === id 
        ?  {...item , price , discount} : item ))
  }

const value = {
    buyCart,
    setBuyCart,
    addToBuyCart,
    removeFromCart,
    updateQuantity,
    clearCart,
    getTotalPrice,
    getTotalItems,
    savePrice
}


return <BuyProductContext.Provider value={value}>{children}</BuyProductContext.Provider>
}