import { createContext, useContext, useState, useEffect } from "react";
import { toast } from "react-toastify";


const CartContext = createContext()

export const useCart = () => {
    const context = useContext(CartContext)

    if (!context) {
        toast.error("داخل پرووایدر استفاده کنید")
    }
    return context
}

export const CartProvider = ({ children }) => {

    const [cart, setCart] = useState([])

useEffect(()=> {
    const savedCart = localStorage.getItem('jwelryCart')
    if (savedCart) {
        try {
            setCart(JSON.parse(savedCart))
        } catch (error) {
            toast.error(error)
        }
    }

}, [])

useEffect(() =>{
    localStorage.setItem('jwelryCart' , JSON.stringify(cart))
} , [cart])

const addToCart = (product, price , currency) => {
  setCart(prevCart => {
    const exists = prevCart.some(item => item._id === product._id)

    if (exists) {
      return prevCart
    }

    return [
      ...prevCart,
      {
        ...product,
        salePrice: price, 
        saleCurrency:currency
      }
    ]
  })
}


const removeFromCart = (productId)=>{
    setCart(prevCart => prevCart.filter(item => item._id !== productId))
}

const updateQuantity = (productId , newQuantity) =>{
    if(newQuantity<1){
        removeFromCart(productId);
        return;
    }
    setCart(prevCart => prevCart.map(item=> item._id === productId ? {...item , quantity : newQuantity} : item))
}

const clearCart = ()=>{
    setCart([]);
    localStorage.removeItem('jwelry')
}

const getTotalPrice = ()=>{
    return cart.reduce((total , item)=>total + item.salePrice,0)
}

const getTotalItems = ()=>{
    return cart.length
}
const savePrice =(id , price , discount)=>{
    setCart(prev => 
      prev.map(item => item._id === id 
        ?  {...item , price , discount} : item ))
  }

const value = {
    cart,
    setCart,
    addToCart,
    removeFromCart,
    updateQuantity,
    clearCart,
    getTotalPrice,
    getTotalItems,
    savePrice
}


return <CartContext.Provider value={value}>{children}</CartContext.Provider>
}