import { StrictMode } from 'react'
import { createRoot } from 'react-dom/client'
import './index.css'
import App from './App.jsx'
import { BrowserRouter } from 'react-router-dom'
import AppContextProvider from './context/AppContext.jsx'
import { CartProvider } from './context/CartContext.jsx'
import { BuyProductProvider } from './context/BuyProductContext.jsx'
import { SupplierProductProvider } from './context/SupplierProduct.jsx'

createRoot(document.getElementById('root')).render(
  <AppContextProvider>
    <SupplierProductProvider>
    <CartProvider>
      <BuyProductProvider>
        <BrowserRouter>
          <App />
        </BrowserRouter>
      </BuyProductProvider>
    </CartProvider>
    </SupplierProductProvider>
  </AppContextProvider>


)
