import React from 'react'
import { useContext } from 'react'
import { useState } from 'react'
import { AppContext } from '../context/AppContext'
import { toast } from 'react-toastify'
import axios from 'axios'
import { useNavigate } from 'react-router-dom'

const AddProductMaster = () => {const {backendUrl} = useContext(AppContext)

    const [name , setName] = useState("")
    const [type , setType] = useState("")
    const [gram , setGram] = useState("")
    const [karat , setKarat] = useState("")

    const submitHandler = async(e)=>{
        e.preventDefault()
        try {

            const {data} = await axios.post(backendUrl+'/api/product-master/create' , {name , type , gram , karat})
            
            if(data.success){
                console.log(data)
                toast.success(data.message)
            }
        } catch (error) {
            console.log(error)
            toast.error(error.message)
        }
    }

    const navigate = useNavigate()

    const convertToEnglish = (str) => {
    const map = {
      "۰": "0", "۱": "1", "۲": "2", "۳": "3", "۴": "4",
      "۵": "5", "۶": "6", "۷": "7", "۸": "8", "۹": "9",
      "٠": "0", "١": "1", "٢": "2", "٣": "3", "٤": "4",
      "٥": "5", "٦": "6", "٧": "7", "٨": "8", "٩": "9"
    };
    return str.replace(/[۰-۹٠-٩]/g, d => map[d]);
  };

  return (
    <div className='w-full py-20 px-16 flex justify-center'>
      <form onSubmit={(e)=>submitHandler(e)} action="" className='flex flex-col items-center w-sm gap-4 '>
        <div className='flex flex-col text-gray-700 gap-1'>
            <label htmlFor="">نام محصول</label>
            <input onChange={(e)=>setName(e.target.value)} value={name} type="text" className='border border-gray-400 py-0.5 px-2 rounded-xs w-60' />
        </div>

        <div className='flex flex-col text-gray-700 gap-1'>
            <label htmlFor="">نوعیت محصول</label>
            <input onChange={(e)=>{setType(e.target.value)}} value={type} type="text" className='border border-gray-400 py-0.5 px-2 rounded-xs w-60' />
        </div>

        <div className='flex flex-col text-gray-700 gap-1'>
            <label htmlFor="">گرام</label>
            <input onChange={(e)=>setGram(convertToEnglish(e.target.value))} value={gram} type="text" inputMode='numeric' className='border border-gray-400 py-0.5 px-2 rounded-xs w-60' />
        </div>

        <div className='flex flex-col text-gray-700 gap-1'>
            <label htmlFor="">عیار</label>
            <input onChange={(e)=>setKarat(convertToEnglish(e.target.value))} value={karat} type="text" inputMode='numeric' className='border border-gray-400 py-0.5 px-2 rounded-xs w-60' />
        </div>
        <p onClick={(e)=>navigate('/product-master-list')} className='text-xs underline text-green-600 cursor-pointer'>محصولات قبلا ثبت شده</p>

        <button type='submit' className='bg-sky-600 text-white w-60 py-0.5 rounded-xs -mt-1 cursor-pointer'>ثبت محصول</button>
      </form>
    </div>
  )
}

export default AddProductMaster
