import React from 'react'
import { useContext } from 'react'
import { useState } from 'react'
import { AppContext } from '../context/AppContext'
import { toast } from 'react-toastify'
import axios from 'axios'
import {useNavigate} from 'react-router-dom'

const AddSupplier = () => {

    const {backendUrl} = useContext(AppContext)

    const [name , setName] = useState("")
    const [phone , setPhone] = useState("")
    const [address , setAddress] = useState("")

    const navigate = useNavigate()

    const submitHandler = async(e)=>{
        e.preventDefault()
        try {

            const {data} = await axios.post(backendUrl+'/api/supplier/create' , {name , phone , address})
            
            if(data.success){
                console.log(data)
                toast.success(data.message)
            }
        } catch (error) {
            console.log(error)
            toast.error(error.message)
        }
    }

  return (
    <div className='w-full py-20 px-16 flex justify-center'>
      <form onSubmit={(e)=>submitHandler(e)} action="" className='flex flex-col items-center w-sm gap-6 '>
        <div className='flex flex-col text-gray-700'>
            <label htmlFor="">نام تمویل کننده</label>
            <input onChange={(e)=>setName(e.target.value)} value={name} type="text" className='border border-gray-400 py-0.5 px-2 rounded-xs w-60' />
        </div>

        <div className='flex flex-col text-gray-700'>
            <label htmlFor="">شماره تماس تمویل کننده</label>
            <input onChange={(e)=>{setPhone(e.target.value)}} value={phone} type="text" className='border border-gray-400 py-0.5 px-2 rounded-xs w-60' />
        </div>

        <div className='flex flex-col text-gray-700'>
            <label htmlFor="">آدرس تمویل کننده</label>
            <input onChange={(e)=>setAddress(e.target.value)} value={address} type="text" className='border border-gray-400 py-0.5 px-2 rounded-xs w-60' />
        </div>
        
        <div className='flex text-xs -mt-2'>
          <p onClick={()=>navigate('/supplier-list')} className='cursor-pointer text-green-600 underline'>تمویل کننده گان ثبت شده</p>
        </div>

        <button type='submit' className='bg-sky-600 text-white w-60 py-0.5 rounded-xs -mt-2'>ثبت اطلاعات</button>
      </form>
    </div>
  )
}

export default AddSupplier
