import React, { useState } from 'react'
import { assets } from '../assets/assets'
import ProductInfo from '../components/ProductInfo'
import { useBuyCart } from '../context/BuyProductContext'
import BuyCart from '../components/BuyCart'
import { useNavigate } from 'react-router-dom'
import axios from 'axios'
import { useContext } from 'react'
import { AppContext } from '../context/AppContext'
import { useEffect } from 'react'
import { toast } from 'react-toastify'

const BuyProduct = () => {

  const {backendUrl} = useContext(AppContext)
  const [isProductOn, setIsProductOn] = useState(false)
  const { buyCart , clearCart} = useBuyCart()
  const [search, setSearch] = useState("")
  const [supplier , setSupplier] = useState([])
  const [selectedSupplier , setSelectedSupplier] = useState('')
  const [showDropdown, setShowDropdown] = useState(false)
  const [date , setDate]= useState(null)
  const [bellNumber , setBullNumber] = useState("")
  const [currency , setCurrency]= useState("")
  const [isTogggle , setIsToggle] = useState(false)
  const [paidAmount , setPaidAmount] = useState("")

  const purchaseItems = buyCart.map(item=>({
    productMasterId:item.product._id,
    name:item.product.name,
    type:item.product.type,
    gram:item.product.gram,
    karat:item.product.karat,
    price:item.price,
    quantity:item.quantity
  }))



  const handlePurchase = async()=>{

    if(!currency || currency ===""){
      return toast.error("لطفا واحد پولی را انتخاب کنید")
    }

    try {

      const {data} = await axios.post(backendUrl+'/api/purchase/create' , {supplierId:selectedSupplier , items:purchaseItems , date:date , bellNumber:Number(bellNumber) , currency , paidAmount:Number(paidAmount)})
      if(data.success){
        toast.success(data.message)
        clearCart()
        setBullNumber('')
        setDate(null)
        setCurrency('')
        setPaidAmount('')
      }

    } catch (error) {
      console.log(error)
      toast.error(error.message)
    }
  }


  const fetchSupplier = async () => {
    try {

      const { data } = await axios.get(backendUrl+`/api/supplier/get?search=${search}`)
      return data

    } catch (error) {
      console.log(error)
      toast.error(error.message)
    }
  }

  useEffect(()=>{
    if(!search.trim()){
      setSupplier([])
      return
    }

    const delay = setTimeout(async()=>{
      console.log("worked")
      try {
      const data = await fetchSupplier()
      if(data.success){
        setSupplier(data.supplier)
        console.log("the founded supplier",data)
      }
      } catch (error) {
        console.log(error)
      }
    },300)

    return () => clearTimeout(delay);

  },[search])

 
const convertToEnglish = (str) => {
  const map = {
    "۰": "0", "۱": "1", "۲": "2", "۳": "3", "۴": "4",
    "۵": "5", "۶": "6", "۷": "7", "۸": "8", "۹": "9",
    "٠": "0", "١": "1", "٢": "2", "٣": "3", "٤": "4",
    "٥": "5", "٦": "6", "٧": "7", "٨": "8", "٩": "9"
  };
  return str.replace(/[۰-۹٠-٩]/g, d => map[d]);
};


  const navigate = useNavigate()

  return (
    <div className='w-full py-8 px-16 relative '>
      <img onClick={()=>setIsToggle(!isTogggle)} src={assets.drop_down_icon} className='absolute w-6 top-12 right-18 cursor-pointer' alt="" />
      <div className={`flex flex-col gap-2 absolute top-20 right-20 bg-sky-700 rounded px-2 py-8  z-10 ${isTogggle ? 'block' : 'hidden'}`}>
        <button onClick={() => navigate('/supplier-transaction')} className=' text-gray-200 py-0.5 px-2 rounded cursor-pointer w-36  text-start hover:text-white'>اجناس خریده شده</button>
        <button onClick={() => navigate('/add-supplier')} className=' text-gray-200 py-0.5 px-2 rounded cursor-pointer w-36 text-start hover:text-white'>افزودن تمویل کننده</button>
        <button onClick={() => navigate('/add-product-master')} className=' text-gray-200 py-0.5 px-2 rounded cursor-pointer w-36 text-start hover:text-white'>افزودن محصول</button>
      </div>
      {/* --- header ---- */}
      <div className='flex justify-center flex-wrap gap-8'>
        <div className='flex flex-col gap-1 relative'>
          <label className='text-gray-700' htmlFor="">اسم تمویل کننده</label>
          <input onChange={(e) => {
            setSearch(e.target.value)
            setShowDropdown(true)
            }} value={search} className='border border-gray-400 rounded py-1 px-2 w-60' type="text" id='' />
          <div className=' w-full flex flex-col gap-2 absolute top-16 right-0 z-10 bg-white text-gray-700'>
            {showDropdown && supplier.length >0 && supplier.map((item)=>(
              <p
              onClick={(e)=>{
                e.preventDefault()
                setSearch(item.name)
                setSelectedSupplier(item._id)
                setSupplier([])
                setShowDropdown(false)
              }
              }
              className='border-b border-gray-300 cursor-pointer hover:bg-gray-100 p-3'>{item.name}</p>
            ))}
          </div>
        </div>

        <div className='flex flex-col gap-1'>
          <label className='text-gray-700' htmlFor="">نمبر بل</label>
          <input onChange={(e)=>setBullNumber(convertToEnglish(e.target.value))} value={bellNumber} className='border border-gray-400 rounded py-1 px-2 w-40' type="text" inputMode="numeric" id='' />
        </div>

        <div className='flex flex-col gap-1'>
          <label className='text-gray-700' htmlFor="">تاریخ</label>
          <input onChange={(e)=>setDate(e.target.value)} value={date} className='border border-gray-400 rounded py-1 px-2 w-40' type="date" id='' />
        </div>

        <div className='flex flex-col gap-1'>
          <label className='text-gray-700' htmlFor="">واحد پول</label>
          <select onChange={(e)=>setCurrency(e.target.value)} value={currency} className='border border-gray-400 rounded py-1 px-2 w-40 text-sm' type="text" id='' >
            <option value="">واحد پولی</option>
            <option value="دالر">دالر</option>
            <option value="افغانی">افغانی</option>
          </select>
        </div>

        <div className='flex flex-col gap-1'>
          <label className='text-gray-700' htmlFor="">پرداخت</label>
          <input onChange={(e)=>setPaidAmount(convertToEnglish(e.target.value))} value={paidAmount} className='border border-gray-400 rounded py-1 px-2 w-40' type="text" inputMode="numeric" id='' />
        </div>

      </div>

      <div>{buyCart && <BuyCart />}</div>

      {isProductOn && <ProductInfo isProductOn={isProductOn} setIsProductOn={setIsProductOn}></ProductInfo>}
      {/* --- add To cart ----  */}
      <div className='w-full flex items-center justify-center mt-8 gap-8'>
        <img src={assets.sell_icon} onClick={handlePurchase} className='w-20 opacity-30 cursor-pointer' alt="" />
        <img src={assets.add_icon} onClick={() => setIsProductOn(true)} className='w-20 opacity-30 cursor-pointer' alt="" />
      </div>
      
    </div>
  )
}

export default BuyProduct
