import React, { useContext } from 'react'
import { assets } from '../assets/assets'
import { useState } from 'react'
import DatePicker from "react-multi-date-picker";
import persian from "react-date-object/calendars/persian";
import persian_fa from "react-date-object/locales/persian_fa";
import { toast } from 'react-toastify';
import axios from 'axios'
import { AppContext } from '../context/AppContext';
import DateObject from "react-date-object";



const CompanyInformation = () => {

  const { backendUrl, companyData, setCompanyData } = useContext(AppContext)
  const [isEdit, setIsEdit] = useState(false)


  const [companyName, setCompanyName] = useState("نصیر کریمی")
  const [slogan, setSlogan] = useState("باما بدرخشید")
  const [phone, setPhone] = useState("0788888888")
  const [email, setEmail] = useState("zargar@gmail.com")
  const [address, setAddress] = useState("مزار شریف")
  const [date, setDate] = useState()
  const [image, setImage] = useState(null)

  const mongoDate = companyData.date

  const persianDate = new DateObject({
    date:mongoDate ,
    calendar: persian,
    locale: persian_fa,
  }).format("YYYY/MM/DD");

  const editCompanyInfo = async () => {
    try {
      const formData = new FormData();

      formData.append("companyName", companyName);
      formData.append("slogan", slogan);
      formData.append("phone", phone);
      formData.append("email", email);
      formData.append("address", address);
      formData.append("date", date)
      image && formData.append("image", image);

      const { data } = await axios.post(backendUrl + '/api/company/edit-company', formData)

      if (data.success) {
        toast.success(data.message)
        setIsEdit(false)
        setImage(null)
      } else {
        toast.error(data.message)
      }

    } catch (error) {
      console.log(error)
      toast.error(error.message)

    }
  }


  return (
    <div className='w-full py-8 px-16'>
      {/* ---- company logo ---- */}
      <div className='flex justify-center'>
        {isEdit ? <label htmlFor="image">
          <div className='inline-block relative cursor-pointer'>
            <img className='w-40 rounded-full opacity-60 ' src={image ? URL.createObjectURL(image) : `http://localhost:3000/${companyData.image}`} alt="" />
            <img className='w-10 absolute top-15 right-15 opacity-80' src={image ? '' : assets.upload_icon} alt="" />
          </div>
          <input onChange={(e) => setImage(e.target.files[0])} type="file" id="image" hidden />
          <p className='text-sm text-gray-500 text-center'>لوگوی خودرا آپلود کنید</p>
        </label> : <img className='w-40 h-40 object-cover rounded-full cursor-pointer' src={`http://localhost:3000/${companyData.image}`} alt="" />}
      </div>

      {/* ---- company Infromation ---- */}
      <div className='w-full flex justify-center mt-12 '>
        <div>
          <div className='grid grid-cols-[1fr_1fr_1fr] gap-x-12 gap-y-4'>
            <div className=''>
              <p className='pb-1 text-gray-700'>نام زرگری</p>
              {isEdit ? <input onChange={e => setCompanyData(prev => ({ ...prev, companyName: e.target.value }))} value={companyData.companyName} className='border border-gray-300 rounded h-8 w-72 px-2' type="text" /> : <p className='font-semibold text-blue-500'>{companyData.companyName}</p>}
            </div>


            <div>
              <p className='pb-1 text-gray-700'>شعار زرگری</p>
              {isEdit ? <input onChange={e => setCompanyData(prev => ({ ...prev, slogan: e.target.value }))} value={companyData.slogan} className='border border-gray-300 rounded h-8 w-72 px-2' type="text" /> : <p className='font-semibold text-blue-500'>{companyData.slogan}</p>}
            </div>

            <div>
              <p className='pb-1 text-gray-700'>شماره تماس</p>
              {isEdit ? <input onChange={e => setCompanyData(prev => ({ ...prev, phone: e.target.value }))} value={companyData.phone} className='border border-gray-300 rounded h-8 w-72 px-2' type="text" /> : <p className='font-semibold text-blue-500'>{companyData.phone}</p>}
            </div>

            <div>
              <p className='pb-1 text-gray-700'>ایمیل</p>
              {isEdit ? <input onChange={e => setCompanyData(prev => ({ ...prev, email: e.target.value }))} value={companyData.email} className='border border-gray-300 rounded h-8 w-72 px-2' type="email" /> : <p className='font-semibold text-blue-500'>{companyData.email}</p>}
            </div>

            <div>
              <p className='pb-1 text-gray-700'>آدرس</p>
              {isEdit ? <input onChange={e => setCompanyData(prev => ({ ...prev, address: e.target.value }))} value={companyData.address} className='border border-gray-300 rounded h-8 w-72 px-2' type="text" /> : <p className='font-semibold text-blue-500'>{companyData.address}</p>}
            </div>

            <div>
              <p className='pb-1 text-gray-700'>تاریخ</p>
              {isEdit ? <DatePicker
                value={date}
                onChange={(value) => setDate(value.toDate())}
                calendar={persian}
                locale={persian_fa}
                format="YYYY/MM/DD"
                inputClass="border border-gray-300 rounded h-8 w-72 px-2"
              /> : <p className='font-semibold text-blue-500'>{persianDate}</p>}
            </div>

          </div>
          <div className='flex gap-4 mt-6'>
            {isEdit ? <button onClick={editCompanyInfo} className='border border-gray-100 rounded-md py-1 px-4 cursor-pointer bg-blue-600 text-white text-sm'>ثبت</button> : <button onClick={() => setIsEdit(true)} className='border border-gray-200 rounded-md py-1 px-2 cursor-pointer bg-blue-600 text-white text-sm '>ویرایش</button>}

          </div>
        </div>
      </div>
    </div>
  )
}

export default CompanyInformation
