import React, { useContext, useState } from 'react'
import { AppContext } from '../context/AppContext'
import { toast } from 'react-toastify';
import DatePicker from "react-multi-date-picker";
import persian from "react-date-object/calendars/persian";
import persian_fa from "react-date-object/locales/persian_fa";
import axios from 'axios'
import { NavLink, useNavigate } from 'react-router-dom'

const CustomerRegistration = () => {

  const { backendUrl } = useContext(AppContext)

  const [customerName, setCustomerName] = useState("")
  const [phone, setPhone] = useState("")
  const [email, setEmail] = useState("")
  const [address, setAddress] = useState("")
  const [date, setDate] = useState(null);

  const handleSubmit = async (event) => {
    event.preventDefault()
    
    try {

      const {data} = await axios.post(backendUrl + '/api/customer/new-customer', {
        customerName,
        phone,
        email,
        address,
        date
      })
      

      if (data.success) {
        toast.success(data.message)
      } else {
        toast.error(data.message)
      }

    } catch (error) {
      console.log(error)
      toast.error(error.message)
    }
  }

  const navigate = useNavigate()


  return (
    <div className='w-full py-8 px-16'>
      <form action="" onSubmit={handleSubmit}>
        <div className='flex justify-center pb-12 font-bold text-3xl '>
          <h1>ثبت مشتریان</h1>
        </div>
        <div>
          {/* ---- expenses of company ---- */}
          <div className='w-full flex justify-center '>
            <div>
              <div className='grid grid-cols-[1fr_1fr_1fr] gap-x-20 gap-y-4'>
                <div className=''>
                  <p className='pb-1 text-gray-700'>نام</p>
                  <input onChange={(e) => setCustomerName(e.target.value)} className='border border-gray-300 rounded h-8 w-72' type="text" />
                </div>

                <div>
                  <p className='pb-1 text-gray-700'>شماره تماس</p>
                  <input onChange={(e) => setPhone(e.target.value)} className='border border-gray-300 rounded h-8 w-72' type="text" />
                </div>

                <div>
                  <p className='pb-1 text-gray-700'>ایمیل</p>
                  <input onChange={(e) => setEmail(e.target.value)} className='border border-gray-300 rounded w-72 h-8' type="email" />
                </div>

                <div>
                  <p className='pb-1 text-gray-700'> آدرس</p>
                  <input onChange={(e) => setAddress(e.target.value)} className='border border-gray-300 rounded h-8 w-72' type="text" />
                </div>

                <div>
                  <p className='pb-1 text-gray-700'>تاریخ</p>
                  <DatePicker
                    value={date}
                    onChange={(value) => setDate(value.toDate())}
                    calendar={persian}
                    locale={persian_fa}
                    format="YYYY/MM/DD"
                    inputClass="border border-gray-300 rounded h-8 w-72"
                  />
                </div>


              </div>



              {/* buttons ---- */}
              <div className='grid grid-cols-[2fr_4fr_2fr] gap-8 mt-8'>
                <button type='reset' className='border border-gray-200 rounded-md py-0.5 px-2 cursor-pointer bg-green-600 text-white '>ریسیت</button>
                <button type='submit' className='border border-gray-100 rounded-md py-0.5 px-4 cursor-pointer bg-blue-600 text-white'>ذخیره</button>
                <button type='button' onClick={()=>navigate('/registred-customers')} className='border border-gray-100 rounded-md py-0.5 px-4 cursor-pointer bg-green-600 text-white '>مشتریان ثبت شده</button>
              </div>
            </div>
          </div>
        </div>
      </form>
    </div>
  )
}

export default CustomerRegistration
