import React from 'react'
import { useContext } from 'react'
import { AppContext } from '../context/AppContext'
import { useState } from 'react'
import axios from 'axios'
import { useEffect } from 'react'
import { toast } from 'react-toastify'
import Barcode from "react-barcode";
import { assets } from '../assets/assets'
import { Navigate, useNavigate } from 'react-router-dom'
import jsPDF from "jspdf";
import html2canvas from "html2canvas";


const DailyReport = () => {

    const { backendUrl, rate, usdRate, afnRate } = useContext(AppContext)
    const [report, setReport] = useState([])
    const [sumReport, setSumReport] = useState([])
    const [isTogggle, setIsToggle] = useState(false)
    const [dailyExpense, setDailyExpense] = useState([])
    const [dailyTotal, setDailyTotal] = useState(null)
    const [totalOfTrade, setTotalOfTrade] = useState([])
    const [todayFragment, setTodayFragment] = useState([])
    const [personal, setPersonal] = useState([])
    const [loanReportTotal , setLoanReportTotal] = useState([])


    const downloadPDF = async () => {
        const element = document.getElementById("daily-report");

        const canvas = await html2canvas(element, { scale: 2 });
        const imgData = canvas.toDataURL("image/png");

        const pdf = new jsPDF("p", "mm", "a4");
        const pdfWidth = 210;
        const pdfHeight = (canvas.height * pdfWidth) / canvas.width;

        pdf.addImage(imgData, "PNG", 0, 0, pdfWidth, pdfHeight);
        pdf.save("daily-report.pdf");
    };


    const getTodayFragment = async (req, res) => {
        try {
            const { data } = await axios.get(backendUrl + '/api/fragment-report/today')
            if (data.success) {
                console.log("fragment is ", data)
                setTodayFragment(data.today)
            }
        } catch (error) {
            console.log(error)
            toast.error(error.message)
        }
    }
    const getDailyReport = async () => {

        try {
            const { data } = await axios.get(backendUrl + '/api/transaction/daily-report')

            if (data.success) {
                setReport(data.daily)
            }

        } catch (error) {
            console.log(error)
            toast.error(error.message)
        }
    }

    const getSumReport = async () => {
        try {
            const { data } = await axios.get(backendUrl + '/api/transaction/daily-sum')

            if (!data.success) {
                return toast.warn(data.message)
            } else {

                setSumReport(data)
            }

        } catch (error) {
            console.log(error)
            toast.error(error.message)
        }
    }

    const toPersianDate = (date) =>
        new Date(date).toLocaleDateString("fa-IR");



    const getDaily = async () => {
        try {
            const { data } = await axios.get(backendUrl + '/api/expense/daily')
            if (data.success) {
                setDailyExpense(data.total)
            }
        } catch (error) {
            console.log(error)
            toast.error(error.message)
        }
    }

    const getDailyTotalOfSupplier = async () => {
        try {
            const { data } = await axios.get(backendUrl + '/api/supplier-product/daily-total')
            if (data.success) {
                setDailyTotal(data.total)
            }
        } catch (error) {
            console.log(error)
            toast.error(error.message)
        }
    }

    const GetTotalOfTrade = async () => {
        try {
            const { data } = await axios.get(backendUrl + '/api/trade/total')
            if (data.success) {
                setTotalOfTrade(data.total)
            }
        } catch (error) {
            console.log(error)
            toast.error(error.message)
        }


    }

    const getDailyPersonal = async (req, res) => {
        try {
            const { data } = await axios.get(backendUrl + '/api/personal-expense/daily-total')
            if (data.success) {
                setPersonal(data.total)
            }
        } catch (error) {
            console.log(error)
            toast.error(error.message)
        }
    }

    const getloanReportTotal = async () => {
        try {
            const { data } = await axios.get(backendUrl + '/api/loan-report/total')
            if (data.success) {
                console.log(data)
                setLoanReportTotal(data.total)
            }
        } catch (error) {
            console.log(error)
            toast.error(error.message)
        }
    }

    useEffect(() => {
        getDailyReport()
        getSumReport()
        getDaily()
        getDailyTotalOfSupplier()
        GetTotalOfTrade()
        getTodayFragment()
        getDailyPersonal()
        getloanReportTotal()
    }, [])

    const navigate = useNavigate()

    return (
        <div className='py-12 px-16 h-[90vh] overflow-y-scroll relative'>
            <img src={assets.drop_down_icon} onClick={() => setIsToggle(!isTogggle)} className='w-6 absolute top-4' alt="" />
            <div id='daily-report' className={`absolute z-20 shadow-2xl w-[80%] h-[70vh] px-2 overflow-y-scroll bg-white py-2 ${isTogggle ? 'block' : 'hidden'}`}>
                <p className='text-center pt-4'>معادل افغانی</p>
                <ul className='grid grid-cols-5 text-center py-2'>
                    <li>مجموع</li>
                    <li>خرید</li>
                    <li>طلبات</li>
                    <li>گرام</li>
                    <li>مفاد</li>
                </ul>

                {sumReport && <ul className='grid grid-cols-5 text-center py-2 bg-sky-600 text-white'>
                    <li className=' border-l border-gray-100'>{parseFloat(sumReport.totalAmount).toFixed(0)}</li>
                    <li className=' border-l border-gray-100'>{parseFloat(sumReport.totalPurchase).toFixed(0)}</li>
                    <li className=' border-l border-gray-100'>{parseFloat(sumReport.remainAmount).toFixed(0)}</li>
                    <li className=' border-l border-gray-100'>{parseFloat(sumReport.totalGram).toFixed(3)}</li>
                    <li className=' border-gray-100'>{parseFloat(sumReport.totalAmount - sumReport.totalPurchase - sumReport.totalDiscount).toFixed(0)}</li>
                </ul>}
                <p className='text-center py-4'>معادل دالری</p>
                {sumReport && <ul className='grid grid-cols-5 text-center py-2 bg-sky-600 text-white'>
                    <li className=' border-l border-gray-100'>{parseFloat(sumReport.totalAmount / rate).toFixed(2)}</li>
                    <li className=' border-l border-gray-100'>{parseFloat(sumReport.totalPurchase / rate).toFixed(2)}</li>
                    <li className=' border-l border-gray-100'>{parseFloat(sumReport.remainAmount / rate).toFixed(2)}</li>
                    <li className=' border-l border-gray-100'>{parseFloat(sumReport.totalGram).toFixed(0)}</li>
                    <li className=' border-gray-100'>{parseFloat((sumReport.totalAmount - sumReport.totalPurchase - sumReport.totalDiscount) / rate).toFixed(2)}</li>
                </ul>}

                {/* total expense */}
                <div className='grid grid-cols-2 text-center mt-4 bg-sky-600 text-white'>
                    <div>
                        <p>مجموع مصارف دالر</p>
                        {dailyExpense.filter(item => item.currency === "دالر").map(e => (<p className='font-bold'>{e.price}</p>))}
                    </div>

                    <div>
                        <p>مجموع مصارف افغانی</p>
                        {dailyExpense.filter(item => item.currency === "افغانی").map(e => (<p className='font-bold'>{e.price}</p>))}
                    </div>

                </div>

                {/* personal expense */}
                <div className='flex flex-col items-center text-center mt-4 bg-sky-600 text-white'>
                    <h1 className='text-lg'>مصارف شخصی</h1>
                    {personal && personal.map((item, index) => (
                        <ul>
                            <li>{item.amount} - {item._id}</li>
                        </ul>
                    ))}

                </div>

                {/* daily supplier Product total */}

                <div className='my-4'>
                    <h1 className='text text-center text-sky-700 font-bold  '>بیلانس خرید از تمویل کننده</h1>

                    <ul className='grid grid-cols-7 text-center py-2'>
                        <li>مجموع وزن</li>
                        <li>مجموع پاسه</li>
                        <li>رسید پاسه</li>
                        <li>باقی پاسه</li>
                        <li>مجموع وجوره</li>
                        <li>رسید وجوره</li>
                        <li>باقی وجوره</li>
                    </ul>

                    {dailyTotal && <ul className='grid grid-cols-7 text-center py-2 bg-sky-600 text-white'>
                        <li className=' border-l border-gray-100'>{(dailyTotal.totalWeight).toFixed(0)}</li>
                        <li className=' border-l border-gray-100'>{(dailyTotal.totalPasa).toFixed(3)}</li>
                        <li className=' border-l border-gray-100'>{(dailyTotal.pasaReceipt).toFixed(3)}</li>
                        <li className=' border-l border-gray-100'>{(dailyTotal.remainPasa).toFixed(3)}</li>
                        <li className=' border-l border-gray-100'>{(dailyTotal.totalWage).toFixed(3)}</li>
                        <li className=' border-l border-gray-100'>{(dailyTotal.wageReceipt).toFixed(3)}</li>
                        <li className=' border-gray-100'>{parseFloat(dailyTotal.remainWage).toFixed(3)}</li>
                    </ul>}

                </div>

                <div>
                    
                    <div className='grid grid-cols-4 gap-0.5'>{totalOfTrade.length>0 &&
                    <h1>مجموع معاملات</h1>
                    
                    }
                    {totalOfTrade.length>0 && totalOfTrade.map((item, index) => (
                        <div>
                            <ul className='grid grid-cols-3 text-center py-2'>
                                <li>مجموع</li>
                                <li>نوعیت</li>
                                <li>واحد</li>
                            </ul>
                            <ul className='grid grid-cols-3 text-center py-2 bg-sky-700 text-white'>
                                <li>{item.totalAmount}</li>
                                <li>{item.type}</li>
                                <li>{item.currency}</li>
                            </ul>
                        </div>
                    ))}
                    </div>

                </div>

                    {/* loan report */}
                <div className='bg-sky-600 text-white flex justify-center py-2 '>
                    {loanReportTotal && <div>
                        <h1 className='text-lg'>رسید امروز از درک قرضه فروشات </h1>
                        {loanReportTotal.map((item , index)=>(
                            <ul>
                                <li className='white font-bold text-center'>{item.amount} - {item.currency}</li>
                            </ul>
                        ))}
                        </div>}
                </div>

                {/* storage report */}
                <div className='flex flex-col items-center'>
                    <h1 className='mb-2'>موجودی دخل</h1>
                    <div className='grid grid-cols-2 bg-sky-600 text-white w-full text-center py-1'>
                        <p>مبلغ دالری</p>
                        <p>مبلغ افغانی</p>
                        <p>{usdRate}$</p>
                        <p>{afnRate}</p>
                    </div>
                </div>


                {/* گزارش شکسته */}

                <div className='border border-sky-600 my-8'>
                    <h1 className='text-center bg-sky-600 text-white py-1'>شکسته امروز</h1>
                    <ul className='grid grid-cols-5 text-center py-1'>
                        <li>گرام</li>
                        <li>پول</li>
                        <li>به گدام</li>
                        <li>آب شده</li>
                        <li>جزئیات</li>
                    </ul>
                    {
                        todayFragment && todayFragment.map((item, index) => (
                            <ul key={item._id} className='grid grid-cols-5 text-center py-1 bg-sky-600 text-white'>
                                <li>{item.totalGram}</li>
                                <li>{item.totalAmount}</li>
                                <li>{item.toWareHouse}</li>
                                <li>{item.toPasa}</li>
                                <li>{item.detail}</li>
                            </ul>
                        ))
                    }
                </div>
                <div>

                </div>
                {/* buttons */}
                <div className='flex justify-center gap-4 mt-4'>
                    <button onClick={() => navigate('/daily-expense')} className='bg-sky-700 text-white w-40 py-0.5 rounded-xs cursor-pointer '>مصارف شرکت</button>
                    <button onClick={() => navigate('/daily-trade')} className='bg-sky-700 text-white w-40 py-0.5 rounded-xs cursor-pointer '>معامله داران</button>
                    <button onClick={downloadPDF} className='bg-sky-700 text-white w-40 py-0.5 rounded-xs cursor-pointer '>دانلود پی دی اف</button>
                </div>
            </div>



            {report.map((p, index) => (
                <div key={index} className="mb-12 border border-gray-300/80 rounded-xs ">

                    <ul key={index} className="grid grid-cols-6 text-center gap-2 p-4 gap-x-12 w-full bg-sky-600  rounded-xs text-gray-200 mb-8">
                        <li>نام مشتری:</li>
                        <li className='border-b border-gray-300/50'>{p.customerName}</li>

                        <li>شماره مشتری:</li>
                        <li className='border-b border-gray-300/50'>{p.customerPhone}</li>

                        <li>تاریخ:</li>
                        <li className='border-b border-gray-300/50'>{toPersianDate(p.date)}</li>

                        <li>تعداد اقلام:</li>
                        <li className='border-b border-gray-300/50'>{p.product.length}</li>

                        <li>بیل نمبر:</li>
                        <li className='border-b border-gray-300/50'>{p.bellNumber}</li>

                        <li>واحد پولی:</li>
                        <li className='border-b border-gray-300/50'>افغانی</li>

                        <li>مجموع:</li>
                        <li className='border-b border-gray-300/50'>{parseFloat(p.totalAmount).toFixed(0)}</li>


                        <li>رسید:</li>
                        <li className='border-b border-gray-300/50'>{parseFloat(p.paidAmount).toFixed(0)}</li>

                        <li>باقی:</li>
                        <li className='border-b border-gray-300/50'>{parseFloat(p.remainingAmount).toFixed(0)}</li>

                    </ul>

                    <ul className="grid grid-cols-7 font-bold px-2">
                        <li>#</li>
                        <li>نام جنس</li>
                        <li>گرام</li>
                        <li>عیار</li>
                        <li>خرید</li>
                        <li>فروش</li>
                        <li>بارکود</li>
                    </ul>

                    {p.product.map((item, i) => (
                        <ul key={item._id} className="grid grid-cols-7 border-t py-1 text-gray-700 px-2">
                            <li>{i + 1}</li>
                            <li>{item.name}</li>
                            <li>{item.gram}</li>
                            <li>{item.karat}</li>
                            <li>{parseFloat(item.purchase).toFixed(0)}</li>
                            <li>{parseFloat(item.sold).toFixed(0)}</li>
                            <li className='px-2 border h-24 border-gray-300 flex justify-center'><Barcode
                                value={item.barcode}
                                format="CODE128"
                                width={0.8}
                                height={50}
                                displayValue={true}
                                fontSize={16}
                                margin={2}
                            /></li>
                        </ul>
                    ))}
                </div>
            ))}

        </div>
    )
}

export default DailyReport
