import React, { useContext, useEffect, useRef, useState } from 'react'
import { AppContext } from '../context/AppContext'
import Barcode from 'react-barcode'
import { assets } from '../assets/assets'
import { toast } from 'react-toastify'
import axios from 'axios'

const ExistProducts = () => {
  const { getExistProduct, existProduct, setExistProduct, backendUrl } = useContext(AppContext)
  const [editId, setEditId] = useState(null) 
  const printRef = useRef()

  useEffect(() => {
    getExistProduct()
  }, [])

 console.log(existProduct)
  const toPersianDate = (date) => {
  if (!date) return "";
  const d = new Date(date);
  return d.toLocaleDateString("fa-IR"); 
};


  const handleChange = (id, field, value) => {
    setExistProduct(prev =>
      prev.map(p => p._id === id ? { ...p, [field]: value } : p)
    )
  }

  const updateProduct = async (id) => {
    const product = existProduct.find(p => p._id === id)
    if (!product) return toast.error("محصول وجود ندارد")

    try {
      const { data } = await axios.put(`${backendUrl}/api/product/${id}`, product, {
        headers: { "Content-Type": "application/json" }
      })

      if (data.success) {
        toast.success("محصول ویرایش شد")
        setEditId(null)
        getExistProduct()
      } else {
        toast.error(data.message)
      }
    } catch (error) {
      console.log(error)
      toast.error(error.message)
    }
  }

  const deleteProduct = async (productId)=>{
    
    try {

      const {data} = await axios.delete(backendUrl + `/api/product/delete-product/${productId}`)

      if (data.success){
        console.log(data)
        toast.success(data.message)
        setExistProduct(prev => prev.filter(item => item._id !== productId) )
      }
      
    } catch (error) {
      console.log(error)
      toast.error(error.message)
    }
  }

  const handlePrint = () => {
    const printContent = printRef.current.innerHTML
    const originalContent = document.body.innerHTML
    document.body.innerHTML = printContent
    window.print()
    document.body.innerHTML = originalContent
  }

  const filteredExistProduct = existProduct.filter(product => product.isSold === false)
  

  return (
    <div className='w-full px-20 py-8 h-[90vh] overflow-y-scroll'>
      <div className='flex justify-center pb-2 font-bold text-3xl'>
        <h1>اجناس موجود</h1>
      </div>

      {/* table header */}
      <div className='grid grid-cols-[1fr_3fr_3fr_2fr_2fr_2fr_2fr_2fr_4fr_4fr_1.5fr] text-center justify-center items-center text-white'>
        <p className='border bg-sky-800 border-white py-2 text-sm'>شماره</p>
        <p className='border bg-sky-800 border-white py-2 text-sm'>نام جنس</p>
        <p className='border bg-sky-800 border-white py-2 text-sm'>نوعیت جنس</p>
        <p className='border bg-sky-800 border-white py-2 text-sm'>وزن</p>
        <p className='border bg-sky-800 border-white py-2 text-sm'>عیار</p>
        <p className='border bg-sky-800 border-white py-2 text-sm'>خرید</p>
        <p className='border bg-sky-800 border-white py-2 text-sm'>واحد پول</p>
        <p className='border bg-sky-800 border-white py-2 text-sm'>تاریخ</p>
        <p className='border bg-sky-800 border-white py-2 text-sm'>عکس</p>
        <p className='border bg-sky-800 border-white py-2 text-sm'>بارکود</p>
        <p className='border bg-sky-800 border-white py-2 text-sm'>ویرایش</p>
      </div>

      {/* table rows */}
      {filteredExistProduct.map((product, index) => (
        <div key={product._id} className='grid grid-cols-[1fr_3fr_3fr_2fr_2fr_2fr_2fr_2fr_4fr_4fr_1.5fr] text-center items-center'>
          <p className='border border-gray-300 py-12 text-sm'>{index + 1}</p>

          {/* editable fields */}
          {editId === product._id ? (
            <>
              <input className='w-full py-1.5 px-4 border border-gray-300' value={product.productName} onChange={e => handleChange(product._id, "productName", e.target.value)} />
              <input className='w-full py-1.5 px-4 border border-gray-300' value={product.type} onChange={e => handleChange(product._id, "type", e.target.value)} />
              <input className='w-full py-1.5 px-4 border border-gray-300' type='number' value={product.weight} onChange={e => handleChange(product._id, "weight", e.target.value)} />
              <input className='w-full py-1.5 px-4 border border-gray-300' type='number' value={product.karat} onChange={e => handleChange(product._id, "karat", e.target.value)} />
              <input className='w-full py-1.5 px-4 border border-gray-300' type='number' value={product.purchasePrice} onChange={e => handleChange(product._id, "purchasePrice", e.target.value)} />
              <input className='w-full py-1.5 px-4 border border-gray-300' value={product.currency} onChange={e => handleChange(product._id, "currency", e.target.value)} />
            </>
          ) : (
            <>
              <p className='border border-gray-300 py-12 text-sm'>{product.productName}</p>
              <p className='border border-gray-300 py-12 text-sm'>{product.type}</p>
              <p className='border border-gray-300 py-12 text-sm'>{product.gram}</p>
              <p className='border border-gray-300 py-12 text-sm'>{product.karat}</p>
              <p className='border border-gray-300 py-12 text-sm'>{parseFloat(product.purchasePriceToAfn).toFixed(0)}</p>
              <p className='border border-gray-300 py-12 text-sm'>افغانی</p>
            </>
          )}

          <p className='border border-gray-300 py-12 text-sm'>{toPersianDate(product.createdAt)}</p>
          <div className='flex justify-center'>
            <img className='w-28 h-28 object-cover' src={`http://localhost:3000/${product.image}`} alt='' />
          </div>

          <div className='h-28 text-sm'>
            <div ref={printRef}>
              <Barcode value={product.barcode} format="CODE128" width={0.8} height={50} displayValue fontSize={16} margin={2} />
            </div>
            <button className='bg-sky-800 mt-1 py-0.5 px-2 text-white rounded-sm cursor-pointer' onClick={handlePrint}>چاپ</button>
          </div>

          {/* edit buttons */}
          <div className='flex justify-center items-center border border-gray-300 py-6'>
            {editId === product._id ? (
              <div className='flex flex-col items-center gap-2'>
                <img src={assets.sell_icon} className='w-6 cursor-pointer' onClick={() => updateProduct(editId)} alt='' />
                <img src={assets.back_icon} className='w-6 cursor-pointer' onClick={() => setEditId(null)} alt='' />
              </div>
            ) : (
              <div className='felx felx-col items-center justify-center'>
                <img src={assets.edit_icon} className='w-6 cursor-pointer py-1 ' onClick={() => setEditId(product._id)} alt='' />
              </div>
            )}
          </div>

        </div>
      ))}
    </div>
  )
}

export default ExistProducts
