import React, { useState } from 'react'
import DatePicker from "react-multi-date-picker";
import persian from "react-date-object/calendars/persian";
import persian_fa from "react-date-object/locales/persian_fa";
import axios from 'axios'
import { useContext } from 'react';
import { AppContext } from '../context/AppContext';
import { toast } from 'react-toastify';
import { useNavigate } from 'react-router-dom';
import { assets } from '../assets/assets';

const Expenses = () => {

  const { backendUrl } = useContext(AppContext)
  

  const [type, setType] = useState("")
  const [detail, setDetail] = useState("")
  const [quantity, setQuantity] = useState(null)
  const [price, setPrice] = useState("")
  const [sum, setSum] = useState(null)
  const [currency, setCurrency] = useState("")
  const [rate, setRate] = useState(null)
  const [date, setDate] = useState(null)
  const [isToggle, setIsToggle] = useState(false)


  const handleSubmit = async (e) => {
    e.preventDefault()
    if(type === ""){
      return toast.warn("لطفا نوعیت اش را پر نمایید")
    }

  try {

    const { data } = await axios.post(backendUrl + "/api/expense/add-expense", {
      type,
      detail,
      price,
      currency,
      date

    })

    if(data.success){
      toast.success(data.message)
      console.log()
    }else{
      toast.error(data.message)
    }

  } catch (error) {
    console.log(error)
    toast.error(error.message)
  }
}

const navigate = useNavigate()

const convertToEnglish = (str) => {
    const map = {
      "۰": "0", "۱": "1", "۲": "2", "۳": "3", "۴": "4",
      "۵": "5", "۶": "6", "۷": "7", "۸": "8", "۹": "9",
      "٠": "0", "١": "1", "٢": "2", "٣": "3", "٤": "4",
      "٥": "5", "٦": "6", "٧": "7", "٨": "8", "٩": "9"
    };
    return str.replace(/[۰-۹٠-٩]/g, d => map[d]);
  };

return (
  <div className='w-full py-8 px-16 relative'>
    <div>
      <img src={assets.drop_down_icon} className='w-8 cursor-pointer' onClick={()=>setIsToggle(!isToggle)} alt="" />
      <div className={`flex flex-col absolute top-18 right-20 w-40 py-2 px-2 rounded-xs bg-sky-700 text-white ${isToggle ? 'block' : 'hidden'}`}>
          <p onClick={()=>navigate('/person-expense')} className="p-2 cursor-pointer" >مصارف شخصی</p>
      </div>
    </div>
    <form onSubmit={handleSubmit} action="">
      <div className='flex justify-center pb-12 font-bold text-3xl '>
        <h1>مصارف شرکت</h1>
      </div>
      <div className=''>

        {/* ---- expenses of company ---- */}
        <div className='flex justify-center'>
          <div>
            <div className='grid grid-cols-[1fr_1fr_1fr] gap-x-12 gap-y-4'>
              <div className=''>
                <p className='pb-1 text-gray-700'>نوعیت مصرف</p>
                <select onChange={(e) => setType(e.target.value)} value={type} className='border border-gray-300 rounded h-8 w-72 px-2' type="text" name="" id="">
                  <option value="">نوعیت مصرف</option>
                  <option value="خانه">مصارف خانه</option>
                  <option value="دوکان">مصارف دوکان</option>
                  <option value="شخصی">مصارف شخصی</option>
                </select>
              </div>

              <div>
                <p className='pb-1 text-gray-700'>توضیحات</p>
                <textarea onChange={(e) => setDetail(e.target.value)} value={detail} className='border border-gray-300 rounded h-8 w-72 px-2' type="text" />
              </div>

              <div>
                <p className='pb-1 text-gray-700'>مقدار</p>
                <input onChange={(e) => setPrice(convertToEnglish(e.target.value))} value={price} className='border border-gray-300 rounded h-8 w-72 px-2' type="text" inputMode='numeric' />
              </div>

              <div>
                <p className='pb-1 text-gray-700'>واحد پول</p>
                <select onChange={(e) => setCurrency(e.target.value)} className='border border-gray-300 rounded h-8 w-72' name="" id="">
                  <option value="">واحد پولی</option>
                  <option value="دالر">دالر</option>
                  <option value="افغانی">افغانی</option>
                </select>
              </div>

              <div>
                <p className='pb-1 text-gray-700'>تاریخ</p>
                <DatePicker
                  value={date}
                  onChange={(value) => setDate(value.toDate())}
                  calendar={persian}
                  locale={persian_fa}
                  format="YYYY/MM/DD"
                  inputClass="border border-gray-300 rounded h-8 w-72 px-2"
                />
              </div>
            </div>
            <div className='flex justify-between mt-6'>
            <div className='flex gap-4 '>
              <button type='reset' className='border border-gray-200 rounded-md py-0.5 px-2 cursor-pointer bg-gray-200 '>ریسیت</button>
              <button type='submit' className='border border-gray-100 rounded-md py-0.5 px-4 cursor-pointer bg-blue-600 text-gray-200 '>ثبت</button>
            </div>
            <div><button onClick={()=>navigate('/spent')} type='button' className='bg-green-600 text-white py-0.5 px-2 rounded-sm cursor-pointer'>مصارف ثبت شده</button></div>
            </div>
          </div>
        </div>
      </div>
    </form>
  </div>
)}


export default Expenses
