import React, { useState } from 'react'
import { useContext } from 'react';
import { AppContext } from '../context/AppContext';
import axios from 'axios';
import { toast } from 'react-toastify';
import { useEffect } from 'react';
import { useNavigate } from 'react-router-dom';
import { assets } from '../assets/assets';

const Login = () => {

    const { backendUrl, token, setToken } = useContext(AppContext)

    const navigate = useNavigate()

    const [name, setName] = useState("");
    const [email, setEmail] = useState("");
    const [password, setPassword] = useState("");

    const onSubmitHandler = async (event) => {

        event.preventDefault()

        try {

            const { data } = await axios.post(backendUrl + '/api/admin/login', { password, email })
            if (data.success) {
                console.log(data)
                localStorage.setItem('token', data.token)
                setToken(data.token)
            } else {
                toast.error(data.message)
            }

        } catch (error) {
            console.log(error)
            toast.error(error.message)
        }
    }
    useEffect(() => {
        if (token) {
            navigate('/company-information')
        }
    }, [token])


    return (
        <div className='h-screen w-full bg-teal-100/70 flex justify-center items-center '>
            <div className='h-[70vh] shadow-teal-900 shadow-2xl rounded-xl relative w-3xl border-8 border-cyan-200/50'>
                <img src={assets.jwelry_image} className='absolute top-0 w-full h-full object-cover rounded-xl' alt="" />

                {/* ----LoginPage Form ---- */}
                <form onSubmit={onSubmitHandler} className='flex bg-white items-center w-72 h-[90%] absolute top-5 right-4 z-10 rounded-xl' action="">
                    <div className='flex flex-col gap-6 mt-8 items-end px-8 py-4 rounded-r-xl text-zinc-600 text-sm relative'>

                        <img src={assets.gemify_icon} className='absolute -top-28 right-23 w-24' alt="" />

                        <div className='w-full'>
                            <p>نام کاربری</p>
                            <input className='border border-zinc-300 rounded w-full p-2 mt-1' type="email" onChange={e => setEmail(e.target.value)} value={email} required />
                        </div>
                        <div className='w-full'>
                            <p>رمز</p>
                            <input className='border border-zinc-300 rounded w-full p-2 mt-1' type="password" onChange={e => setPassword(e.target.value)} value={password} required />
                        </div>
                        <button className='bg-teal-800 text-white w-full py-2 rounded-md text-base'>ورود</button>
                        <div className='w-full text-gray-500'>
                            <p><span>©
                            </span> <span>تمام حقوق متعلق به شرکت گلگسی تکنالوچی میباشد </span></p>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    )
}

export default Login
