import React, { useContext, useEffect } from 'react'
import { useState } from 'react'
import { AppContext } from '../context/AppContext'
import { toast } from 'react-toastify'
import axios from 'axios'
import { assets } from '../assets/assets'

const ProductMasterList = () => {

    const { backendUrl } = useContext(AppContext)
    const [search, setSearch] = useState("")
    const [product, setProduct] = useState([])
    const [allProduct, setAllProduct] = useState([])
    const [editId, setEditId] = useState(null)
    const [editForm, setEditForm] = useState({
        name: "",
        type: "",
        gram: "",
        karat: ""
    })

    const getAllProductMaster = async (req, res) => {

        try {

            const { data } = await axios.get(backendUrl + '/api/product-master/get-all')
            if (data.success) {
                console.log(data)
                setAllProduct(data.allProductMaster)
            }

        } catch (error) {
            console.log(error)
            toast.error(error.message)
        }
    }


    const fetchProduct = async (req, res) => {
        try {

            const { data } = await axios.get(backendUrl + `/api/product-master/get?search=${search}`)
            return data

        } catch (error) {
            console.log(error)
            toast.error(error.message)
        }
    }

    const handleEdit = (product) => {
        setEditId(product._id)

        setEditForm({
            name: product.name,
            type: product.type,
            gram: Number(product.gram),
            karat: Number(product.karat)
        })
    }

    useEffect(() => {
        getAllProductMaster()
    }, [])

    useEffect(() => {

        if (!search.trim()) {
            setProduct([])
            return
        }

        const delay = setTimeout(async () => {
            try {
                const data = await fetchProduct()
                if (data.success) {
                    setProduct(data.productMaster || 0)
                }

            } catch (error) {
                console.log(error)
            }

        }, 300)
        return () => clearTimeout(delay);

    }, [search])

    const handleUpdate = async()=>{
        try {
            const {data} = await axios.put(backendUrl+`/api/product-master/update/${editId}` , editForm)
            if(data.success){
                toast.success(data.message)
                setEditId(null)
                getAllProductMaster() // لیست ریفریش
            }
        } catch (error) {
            console.log(error)
            toast.error(error.message)
        }
    }

    return (
        <div className='w-full py-4 px-16'>
            <div className='flex justify-center'>
                <input onChange={(e) => setSearch(e.target.value)} value={search} className='border border-gray-400 rounded-xs py-1 px-2' type="text" placeholder='جستجوی محصول' />
            </div>

            <div className='mt-4'>
                <div>
                    <ul className='grid grid-cols-[3fr_3fr_3fr_3fr_1fr] text-center'>
                        <li className='bg-gray-300 border border-white py-1'>نام</li>
                        <li className='bg-gray-300 border border-white py-1'>نوعیت جنس</li>
                        <li className='bg-gray-300 border border-white py-1'>گرام</li>
                        <li className='bg-gray-300 border border-white py-1'>عیار</li>
                        <li className='bg-gray-300 border border-white py-1'>ویرایش</li>
                    </ul>
                    {(product.length > 0 ? product : allProduct).map((item, index) => (
                        <ul key={item._id} className='grid grid-cols-[3fr_3fr_3fr_3fr_1fr] text-center'>
                            {editId === item._id ? (
                                <>
                                    <input className='border border-gray-500 py-0.5 px-2' type="text" value={editForm.name}
                                    onChange={(e)=>setEditForm({...editForm , name : e.target.value})}
                                    />
                                    <input className='border border-gray-500 py-0.5 px-2' type="text" value={editForm.type}
                                    onChange={(e)=>setEditForm({...editForm , type : e.target.value})}
                                    />

                                    <input className='border border-gray-500 py-0.5 px-2' type="text" value={editForm.gram} inputMode='numeric'
                                    onChange={(e)=>setEditForm({...editForm , gram : Number(e.target.value)})}
                                    />
                                    <input className='border border-gray-500 py-0.5 px-2' type="text" value={editForm.karat} inputMode='numeric'
                                    onChange={(e)=>setEditForm({...editForm , karat : Number(e.target.value)})}
                                    />
                                    <div className='flex justify-center gap-2 py-1'>
                                        <img onClick={handleUpdate} src={assets.sell_icon} className='w-6 cursor-pointer' alt="" />
                                        <img onClick={()=>setEditId(null)} src={assets.back_icon} className='w-6 cursor-pointer' alt="" />
                                    </div>
                                </>
                            ) : (
                                <>
                                    <li className='bg-gray-200/70 border border-white py-1'>{item.name}</li>
                                    <li className='bg-gray-200/70 border border-white py-1'>{item.type}</li>
                                    <li className='bg-gray-200/70 border border-white py-1'>{item.gram}</li>
                                    <li className='bg-gray-200/70 border border-white py-1'>{item.karat}</li>
                                    <div className='flex justify-center gap-2 py-1'>
                                        <img onClick={()=>handleEdit(item)} src={assets.edit_icon} className='w-6 cursor-pointer' alt="" />
                                        <img src={assets.delete_icon} className='w-6 cursor-pointer' alt="" />
                                    </div>
                                </>
                            )}
                        </ul>
                    ))
                    }
                </div>
            </div>
        </div>
    )
}

export default ProductMasterList
