import React, { useContext, useEffect } from 'react'
import { AppContext } from '../context/AppContext'
import DateObject from "react-date-object";
import persian from "react-date-object/calendars/persian";
import persian_fa from "react-date-object/locales/persian_fa";
import DatePicker from "react-multi-date-picker";
import SearchCustomer from '../components/SearchCustomer';
import { useState } from 'react';
import { assets } from '../assets/assets';
import axios from 'axios'
import { toast } from 'react-toastify';

const RegistredCustomers = () => {

    const { customers, setCustomers, getCustomers, backendUrl } = useContext(AppContext)
    const [editId, setEditId] = useState(null)

    const updateCustomer = async (customerId) => {
        const selectedCustomer = customers.find(c => c._id === customerId)
        if (!selectedCustomer) {
            toast.error("دیتا وجود ندارد")
        }
        console.log("submited")

        try {

            const { data } = await axios.put(backendUrl + `/api/customer/update-customer/${customerId}`, selectedCustomer)

            if (data.success) {
                toast.success(data.message)
                setEditId(null)
                getCustomers()
            }
            console.log(error)
            toast.error(error.message)
        } catch (error) {
            console.log(error)
        }
    }

    const deleteCustomer = async (customerId) => {

        try {

            const {data} = await axios.delete(backendUrl + `/api/customer/delete-customer/${customerId}`)

            if (data.success) {
                toast.success(data.message)
                setCustomers(prev => prev.filter(item => item._id !== customerId))
            }

        } catch (error) {
            console.log(error)
            toast.error(error.message)
        }
    }

    const toPersianDate = (date) => {
        if (!date) return "-"
        const d = new Date(date)
        if (isNaN(d.getTime())) return "-"
        return new Intl.DateTimeFormat('fa-IR', { year: 'numeric', month: '2-digit', day: '2-digit' }).format(d)
    }

    const handleChange = (id, field, value) => {
        setCustomers(prev =>
            prev.map(item =>
                item._id === id
                    ? { ...item, [field]: value }
                    : item
            )
        );
    }

    useEffect(() => {
        getCustomers()
    }, [])


    return (
        <div className='px-12 py-8 w-full flex flex-col items-center text-center'>
            <div className='grid grid-cols-[1fr_3fr_3fr_5fr_3fr_3fr_2fr] w-full'>
                <p className='py-1 px-2 bg-green-600 text-white border border-white'>شماره</p>
                <p className='py-1 px-2 bg-green-600 text-white border border-white'>نام</p>
                <p className='py-1 px-2 bg-green-600 text-white border border-white'>شماره تماس</p>
                <p className='py-1 px-2 bg-green-600 text-white border border-white'>ایمیل آدرس</p>
                <p className='py-1 px-2 bg-green-600 text-white border border-white'>آدرس</p>
                <p className='py-1 px-2 bg-green-600 text-white border border-white'>تاریخ ثبت</p>
                <p className='py-1 px-2 bg-green-600 text-white border border-white'>ویرایش</p>
            </div>

            {customers.map((customer, index) => (
                <div key={index} className='grid grid-cols-[1fr_3fr_3fr_5fr_3fr_3fr_2fr] w-full'>
                    <p className='py-1 px-2 border border-gray-300'>{index + 1}</p>
                    {/* ---- editable field ---- */}
                    {editId === customer._id ?
                        (
                            <>
                                <input onChange={(e) => handleChange(customer._id, "customerName", e.target.value)} value={customer.customerName} type="text" />
                                <input onChange={(e) => handleChange(customer._id, "phone", e.target.value)} value={customer.phone} type="text" />
                                <input onChange={(e) => handleChange(customer._id, "email", e.target.value)} value={customer.email} type="text" />
                                <input onChange={(e) => handleChange(customer._id, "address", e.target.value)} value={customer.address} type="text" />
                            </>
                        ) : (
                            <>
                                <p className='py-1 px-2 text-gray-700 border border-gray-300'>{customer.customerName}</p>
                                <p className='py-1 px-2 text-gray-700 border border-gray-300'>{customer.phone}</p>
                                <p className='py-1 px-2 text-gray-700 border border-gray-300'>{customer.email}</p>
                                <p className='py-1 px-2 text-gray-700 border border-gray-300'>{customer.address}</p>
                            </>
                        )
                    }
                    <p className='py-1 px-2 border border-gray-300'>{toPersianDate(customer.date)}</p>
                    <div className='border border-gray-300 py-2 flex items-center justify-center'>
                        {/* ---- editable buttons ---- */}
                        {editId === customer._id ? (
                            <div className='flex items-center justify-center gap-2'>
                                <img src={assets.sell_icon} className='w-6 cursor-pointer' onClick={() => updateCustomer(editId)} alt='' />
                                <img src={assets.back_icon} className='w-6 cursor-pointer' onClick={() => setEditId(null)} alt='' />
                            </div>
                        ) : (
                            <div className='flex justify-center items-center gap-2'>
                                <img src={assets.edit_icon} className='w-6 cursor-pointer' onClick={() => setEditId(customer._id)} alt='' />
                                <img src={assets.delete_icon} onClick={() => deleteCustomer(customer._id)} className='w-6 cursor-pointer' alt="" />
                            </div>
                        )}</div>
                </div >))}

        </div >
    )
}

export default RegistredCustomers
