import axios from 'axios'
import React from 'react'
import { useContext } from 'react'
import { AppContext } from '../context/AppContext'
import { useState } from 'react'
import { useEffect } from 'react'
import { toast } from 'react-toastify'

const RemainProductMaster = () => {
    const { backendUrl } = useContext(AppContext)
    const [purchaseProduct, setPurchaseProduct] = useState([])

    const getSupplierProduct = async () => {

        try {
            const { data } = await axios.get(backendUrl + '/api/supplier-product/remain')
            if (data.success) {
                console.log(data)
                setPurchaseProduct(data.product)
            }
            if (!data.success) {
                toast.error(data.message)
            }
        } catch (error) {
            console.log(error)
            toast.error(error.message)
        }
    }

    useEffect(() => {
        getSupplierProduct()
    }, [])

    const toPersianDate = (date) =>
        new Date(date).toLocaleDateString("fa-IR");

    return (
        <div className='py-8 px-16 h-[90vh] overflow-y-scroll'>
            {purchaseProduct.map((p, index) => (
                <div key={index} className="mb-12">

                    <ul key={index} className="grid grid-cols-2 gap-2 w-sm">
                        <li>نام تمویل کننده:</li>
                        <li>{p.supplierName}</li>

                        <li>بیل نمبر:</li>
                        <li>{p.bellNumber}</li>
                    </ul>

                    <ul className="grid grid-cols-8 font-bold mt-4">
                        <li>نام جنس</li>
                        <li>نوعیت</li>
                        <li>عیار</li>
                        <li>گرام</li>
                        <li>ثبت شده</li>
                        <li>ثبت نا شده</li>
                        <li>پاسه</li>
                        <li> وجوره</li>
  
                    </ul>
                    <ul className="grid grid-cols-8 border-t py-1 text-gray-700">

                        <li>{p.products.name}</li>
                        <li>{p.products.type}</li>
                        <li>{p.products.karat}</li>
                        <li>{p.products.weight}</li>
                        <li>{(p.products.registeredWeight).toFixed(3)}</li>
                        <li>{(p.products.remainWeight).toFixed(2)}</li>
                        <li>{p.products.pasa}</li>
                        <li>{p.products.wagePerGram}</li>
                    </ul>
                </div>
            ))}

        </div>
    )
}

export default RemainProductMaster
