import React, { useContext, useEffect, useState } from 'react'
import { AppContext } from '../context/AppContext'
import { assets } from '../assets/assets'
import DatePicker from "react-multi-date-picker";
import persian from "react-date-object/calendars/persian";
import persian_fa from "react-date-object/locales/persian_fa";
import { toast } from 'react-toastify';
import axios from 'axios'

const Report = () => {

  const { backendUrl, rate } = useContext(AppContext)
  const [dateFrom, setDateFrom] = useState(null)
  const [dateTo, setDateTo] = useState(null)
  const [AllSales, setAllSales] = useState([])
  const [allPurchase, setAllPurchase] = useState([])
  const [total, setTotal] = useState(null);
  const [totalOfExpense, setTotalOfExpense] = useState([])
  const [allTrade , setAllTrade]= useState([])
  const getAllSaleReport = async () => {
    try {

      const { data } = await axios.get(
        `${backendUrl}/api/transaction/sale-report`,
        {
          params: {
            dateFrom,
            dateTo
          }
        }
      );
      if (!data.success) {
        toast.error(data.message)
      }
      if (data.success) {
        setAllSales(data)
      }

    } catch (error) {
      console.log(error)
      toast.error(error.message)
    }
  }

  const getAllPurchase = async () => {
    try {
      const { data } = await axios.get(
        `${backendUrl}/api/purchase/total-purchase`,
        {
          params: {
            dateFrom,
            dateTo
          }
        }
      );

      if (!data.success) {
        toast.error(data.message)
      }
      if (data.success) {
        setAllPurchase(data.data)
      }

    } catch (error) {
      console.log(error)
      toast.error(error.message)
    }
  }

  const getTotal = async () => {
    try {
      const { data } = await axios.get(backendUrl + `/api/supplier-product/total`)
      if (data.success) {
        setTotal(data.total)
      }
    } catch (error) {
      console.log(error)
      toast.error(error.message)
    }
  }

  const getAll = async (req, res) => {
    try {
      const { data } = await axios.get(backendUrl + '/api/expense/all')
      if (data.success) {
        console.log(data)
        setTotalOfExpense(data.total)
      }
    } catch (error) {
      console.log(error)
      toast.error(error.message)
    }
  }

  const getAllTrade = async(req , res)=>{
    try {
      const {data} = await axios.get(backendUrl+'/api/trade/all')
      if(data.success){
        setAllTrade(data.total)
      }
    } catch (error) {
       console.log(error)
      toast.error(error.message)
    }
  }


  useEffect(() => {
    getAllSaleReport()
    getAllPurchase()
    getTotal()
    getAll()
    getAllTrade()
  }, [])

  return (
    <div className='px-12 py-8 w-full items-center text-center'>
      <div className='flex gap-4 justify-center mb-4'>
        <DatePicker
          value={dateFrom}
          onChange={(value) => setDateFrom(value.toDate())}
          calendar={persian}
          locale={persian_fa}
          format="YYYY/MM/DD"
          inputClass="border border-gray-300 rounded h-8 w-72 px-4"
          placeholder='شروع تاریخ'
        />
        <DatePicker
          value={dateTo}
          onChange={(value) => setDateTo(value.toDate())}
          calendar={persian}
          locale={persian_fa}
          format="YYYY/MM/DD"
          inputClass="border border-gray-300 rounded h-8 w-72 px-4"
          placeholder='ختم تاریخ'
        />
      </div>
      <div className='flex flex-col bg-gray-200 rounded-sm'>
        <div className='w-full bg-sky-700 rounded-t-sm'>
          <h1 className='py-4 text-2xl font-bold text-gray-100'>داشبورد مدیریتی سیستم</h1>
        </div>
        <div className='flex flex-col px-8'>

          {/* sold report */}
          <h1 className=' text-xl mt-8'>گزارش فروشات</h1>
          <div className='flex justify-center gap-4'>
            {/* total Sale */}
            <div className='bg-blue-500 flex flex-col py-2 px-4 rounded relative text-gray-100 w-40 h-32'>

              <p className='mt-6 text-sm text-gray-200'>بیلانس فروش طلا</p>
              <p className='font-bold text-xl pt-2'>{AllSales.totalGram} - <span>گرام</span></p>
            </div>

            {/* total items */}
            <div className='bg-blue-500 flex flex-col py-2 px-4 rounded relative text-gray-100 w-40 h-32'>

              <p className='mt-6 text-sm text-gray-200'>تعداد اجناس فروخته شده</p>
              <p className='font-bold text-xl pt-2'>{AllSales.totalProducts} - <span>قلم</span></p>
            </div>

            {/* total amount */}
            <div className='bg-blue-500 flex flex-col py-2 px-4 rounded relative text-gray-100 w-40 h-32'>
              <p className='mt-6 text-sm text-gray-200'>بیلانس پول فروشات</p>
              <p className='font-bold text-xl pt-2'>{parseFloat(AllSales.totalAmount).toFixed(0)} - <span>افغانی</span></p>
            </div>

            {/* total remain */}
            <div className='bg-blue-500 flex flex-col py-2 px-4 rounded relative text-gray-100 w-40 h-32'>
              <p className='mt-6 text-sm text-gray-200'>طلبات از درک فروشات</p>
              <p className='font-bold text-xl pt-2'>{parseFloat(AllSales.remainAmount).toFixed(0)} - <span>افغانی</span></p>
            </div>

          </div>

          {/* trade report */}
          <div>
            <h1 className=' text-xl mt-8'>گزارش معاملات</h1>
            <div className='flex flex-wrap justify-center gap-4 '>
            {allTrade && allTrade.map((item , index)=>(
              <div className='bg-blue-500 text-white p-4 rounded'>
                <ul className='grid grid-cols-3 gap-4'>
                  <li>مبلغ</li>
                  <li>واحد</li>
                  <li>نوعیت</li>
                </ul>
                <ul className='grid grid-cols-3 gap-4'>
                  <li>{item.totalAmount}</li>
                  <li>{item.currency}</li>
                  <li>{item.type}</li>
                </ul>
              </div>
            ))}
            </div>
          </div>

          {/* supplier report */}
          <h1 className='mt-8 text-xl'>گزارش تادیات</h1>
          <div className='flex justify-center gap-4'>
            {/* remain pasa */}
            <div className='bg-blue-500 flex flex-col py-2 px-4 rounded relative text-gray-100 w-40 h-32'>
              <p className='mt-6 text-sm text-gray-200'>تادیه پاسه </p>
              <p className='font-bold text-xl pt-2'>{total && (total.remainPasa).toFixed(3)} - گرام</p>
            </div>

            {/* remain pasa */}
            <div className='bg-blue-500 flex flex-col py-2 px-4 rounded relative text-gray-100 w-40 h-32'>
              <p className='mt-6 text-sm text-gray-200'>تادیه وجوره </p>
              <p className='font-bold text-xl pt-2'>{total && (total.remainWage).toFixed(2)} - دالر</p>
            </div>
          </div>

          {/* expense report */}
          <h1 className='mt-8 text-xl'>گزارش مصارف</h1>
          <div className='flex justify-center gap-4'>
             {totalOfExpense && totalOfExpense.map((item , index)=>(
            <div className='bg-blue-500 flex flex-col py-2 px-4 rounded relative text-gray-100 w-40 h-32'>
              <p>مجموع مصارف</p>
              <p className='font-bold text-xl pt-2'>{(item.price)} - {item.currency}</p>
            </div>
          ))}
          </div>

          {/* trade report */}
          <div>

          </div>

        </div>

      </div>
    </div>
  )
}

export default Report
