import React, { useContext, useEffect, useState } from 'react'
import { AppContext } from '../context/AppContext'
import { toast } from 'react-toastify'
import axios from 'axios'
import Barcode from 'react-barcode'
import { assets } from '../assets/assets'

const SoldProduct = () => {

  const { backendUrl } = useContext(AppContext)
  const [sold, setSold] = useState([])
  const [isTogggle, setIsToggle] = useState(false)
  const { getAllSaleReport, AllSales, rate } = useContext(AppContext)
  const [showConfirm, setShowConfirm] = useState(false)
  const [transactionId, setTransactionId] = useState("")
  const [productId, setProductId] = useState("")

  console.log("all sales :", sold)


  const getAllSoldProduct = async () => {
    try {

      const { data } = await axios.get(backendUrl + '/api/transaction/sold')
      if (!data.success) {
        return toast.error(data.message)
      } else {
        setSold(data.soldProduct)
        console.log(data)
      }

    } catch (error) {
      console.log(error)
      toast.error(error.message)
    }
  }

  const returnFunction = async () => {
    try {
      const { data } = await axios.post(
        backendUrl + "/api/transaction/return",
        null,
        {
          params: {
            transactionId,
            productId
          }
        }
      );

      if (data.success) {
        toast.success(data.message)
      }

    } catch (error) {
      console.log(error)
      toast.error(error.message)
    }
  }

  useEffect(() => {
    getAllSoldProduct()
    getAllSaleReport()
  }, [])

  return (
    <div className='w-full px-12 py-8 text-center h-[90vh] overflow-y-scroll relative'>
      <h1 className='mb-2 text-2xl font-medium'>اجناس فروخته شده</h1>
      <img onClick={() => setIsToggle(!isTogggle)} src={assets.drop_down_icon} className='w-6 absolute top-8 right-13 cursor-pointer ' alt="" />
      <div className={`bg-white w-md absolute top-16 right-16 z-10 rounded ${isTogggle ? 'block' : 'hidden'}`}>
        <div className=' rounded-t py-2'>
          <ul className='grid grid-cols-5 text-center text-sm p-3'>
            <li className='border-l'>بیلانس طلا</li>
            <li className='border-l'>بیلانس پول</li>
            <li className='border-l'> تخفیف</li>
            <li className='border-l'>بیلانس نهایی</li>
            <li>اقلام</li>
          </ul>
          <ul className='  bg-blue-500 grid grid-cols-5 text-center text-sm p-3 text-white'>
            <li className='border-l border-gray-100'>{AllSales.totalGram} - گرام</li>
            <li className='border-l border-gray-100'>{parseFloat(AllSales.totalAmount).toFixed(0)} - افغانی</li>
            <li className='border-l border-gray-100'> {parseFloat(AllSales.totalDiscount).toFixed(0)}</li>
            <li className='border-l border-gray-100'>{parseFloat(AllSales.totalAmount - AllSales.totalDiscount).toFixed(0)}</li>
            <li>{AllSales.totalProducts}</li>
          </ul>
        </div>

      </div>
      <ul className='grid grid-cols-[1fr_3fr_3fr_3fr_2fr_2fr_2fr_3fr_5fr_2fr] text-center text-sm text-white'>
        <li className='bg-sky-700 border border-gray-100 py-1'>#</li>
        <li className='bg-sky-700 border border-gray-100 py-1'>نام جنس</li>
        <li className='bg-sky-700 border border-gray-100 py-1'>نام مشتری</li>
        <li className='bg-sky-700 border border-gray-100 py-1'>شماره مشتری</li>
        <li className='bg-sky-700 border border-gray-100 py-1'>وزن(گرام)</li>
        <li className='bg-sky-700 border border-gray-100 py-1'>عیار</li>
        <li className='bg-sky-700 border border-gray-100 py-1'>قیمت</li>
        <li className='bg-sky-700 border border-gray-100 py-1'>واحد پولی</li>
        <li className='bg-sky-700 border border-gray-100 py-1'>بارکود</li>
        <li className='bg-sky-700 border border-gray-100 py-1'>#</li>
      </ul>
      {setSold.length > 0 && sold.map((item, index) => (
        <ul className='grid grid-cols-[1fr_3fr_3fr_3fr_2fr_2fr_2fr_3fr_5fr_2fr] text-center text-sm'>
          <li className='bg-gray-50 border border-gray-300 py-8'>{index + 1}</li>
          <li className='bg-gray-50 border border-gray-300 py-8'>{item.productName}</li>
          <li className='bg-gray-50 border border-gray-300 py-8'>{item.customerName}</li>
          <li className='bg-gray-50 border border-gray-300 py-8'>{item.customerPhone}</li>
          <li className='bg-gray-50 border border-gray-300 py-8'>{item.gram}</li>
          <li className='bg-gray-50 border border-gray-300 py-8'>{item.karat}</li>
          <li className='bg-gray-50 border border-gray-300 py-8'>{parseFloat(item.salePrice.price).toFixed(0)}</li>
          <li className='bg-gray-50 border border-gray-300 py-8'>{item.salePrice.currency}</li>
          <li className='bg-gray-50 border border-gray-300 '><Barcode value={item.barcode} format="CODE128" width={0.9} height={50} displayValue fontSize={16} margin={2} /></li>
          <li className='bg-gray-50 border border-gray-300 py-8 flex justify-center cursor-pointer'><img
            src={assets.return_icon}
            onClick={() => {
              setShowConfirm(true)
              setTransactionId(item.transactionId)
              setProductId(item.productId)
            }} className='w-6' alt="" /></li>
        </ul>
      ))}

      {showConfirm && (
        <div className="fixed inset-0 bg-black/50 flex items-center justify-center">
          <div className="bg-white p-4 rounded w-80">
            <p className="mb-4">آیا مطمئن هستید؟</p>

            <div className="flex justify-center gap-2">
              <button
                onClick={() => setShowConfirm(false)}
                className="px-3 py-1 bg-gray-300 rounded"
              >
                خیر
              </button>

              <button
                onClick={() => {
                  returnFunction();
                  setShowConfirm(false);
                }}
                className="px-3 py-1 bg-red-500 text-white rounded"
              >
                بلی
              </button>
            </div>
          </div>
        </div>
      )}

    </div>
  )
}

export default SoldProduct
