import axios from 'axios'
import React from 'react'
import { useContext } from 'react'
import { AppContext } from '../context/AppContext'
import { useState } from 'react'
import { useEffect } from 'react'

const SupplierBelance = () => {
   const { backendUrl } = useContext(AppContext)
    const [purchaseProduct, setPurchaseProduct] = useState([])

    const getSupplierProduct = async () => {

        try {
            const { data } = await axios.get(backendUrl + '/api/purchase/get-purchase')
            if (data.success) {
                console.log(data)
                setPurchaseProduct(data.purchase)
            }

        } catch (error) {
            console.log(error)
            toast.error(error.message)
        }
    }

    useEffect(() => {
        getSupplierProduct()
    }, [])

    const toPersianDate = (date) =>
        new Date(date).toLocaleDateString("fa-IR");

    return (
        <div className='py-8 px-16'>
            {purchaseProduct.map((p, index) => (
                <div key={index} className="mb-6">

                    <ul key={index} className="grid grid-cols-2 gap-2 w-sm">
                        <li>نام تمویل کننده:</li>
                        <li>{p.supplierName}</li>

                        <li>تعداد اقلام:</li>
                        <li>{p.items.length}</li>

                        <li>مجموع:</li>
                        <li>{p.totalAmount}</li>

                        <li>پرداخت:</li>
                        <li>{p.paidAmount}</li>

                        <li>باقی:</li>
                        <li>{p.totalAmount - p.paidAmount}</li>
                        
                        <li>بیل نمبر:</li>
                        <li>{p.bellNumber}</li>

                        <li>واحد پولی:</li>
                        <li>{p.currency}</li>

                        <li>تاریخ:</li>
                        <li>{toPersianDate(p.date)}</li>
                    </ul>

                    <ul className="grid grid-cols-7 font-bold mt-8">
                        <li>#</li>
                        <li>نام جنس</li>
                        <li>نوعیت</li>
                        <li>گرام</li>
                        <li>عیار</li>
                        <li>تعداد</li>
                        <li>قیمت</li>
                    </ul>

                    {p.items
                        .filter(item => !item.isCompleted)
                        .map((item, i) => (
                            <ul key={item._id} className="grid grid-cols-7 border-t py-1 text-gray-700">
                                <li>{i + 1}</li>
                                <li>{item.name}</li>
                                <li>{item.type}</li>
                                <li>{item.gram}</li>
                                <li>{item.karat}</li>
                                <li>{item.quantity}</li>
                                <li>{item.price}</li>
                            </ul>
                        ))}
                </div>
            ))}

        </div>
    )
}

export default SupplierBelance
