import React, { useContext, useState, useEffect } from 'react'
import { AppContext } from '../context/AppContext'
import axios from 'axios'
import { toast } from 'react-toastify'
import { assets } from '../assets/assets'

const SupplierList = () => {

    const { backendUrl } = useContext(AppContext)
    const [search, setSearch] = useState("")
    const [products, setProducts] = useState([])
    const [loading, setLoading] = useState(false)
    const [allSupplier, setAllSupplier] = useState([])
    const [showDelete, setShowDelete] = useState(false)
    const [deleteItemId, setDeleteItemId] = useState("")
    const [editId, setEditId] = useState(null)
    const [supplierBlance, setSupplierBlance] = useState([])
    const [showBlance, setShowBlance] = useState(false)
    const [showPay, setShowPay] = useState(false)
    const [productId, setProductId] = useState("")
    const [transactionId, setTransactionId] = useState('')
    const [pasa, setPasa] = useState("")
    const [wage, setWage] = useState("")
    const [isToggle, setIsToggle] = useState(false)
    const [total, setTotal] = useState([])
    const [editForm, setEditForm] = useState({
        name: "",
        phone: "",
        address: ""
    })
    console.log(supplierBlance)

    const updateLoan = async (req, res) => {
        try {

            const { data } = await axios.put(backendUrl + '/api/supplier-product/update-loan', { pasa, wage }, { params: { transactionId, productId } })
            if (!data.success) {
                toast.error(data.message)
            }
            if (data.success) {
                toast.success(data.message)
                setShowPay(false)
            }
        } catch (error) {
            console.log(error)
            toast.error(error.message)
        }
    }

    const getAllSupplier = async () => {

        try {
            const { data } = await axios.get(backendUrl + '/api/supplier/get-all')
            if (data.success) {

                setAllSupplier(data.data)
                console.log(data)
            }

        } catch (error) {
            console.log(error)
            toast.error(error.message)
        }
    }

    const fetchSupplier = async () => {
        const data = await axios.get(
            `${backendUrl}/api/supplier/get?search=${search}`
        );
        return data;
    };

    useEffect(() => {
        if (!search.trim()) {
            setProducts([]);
            return;
        }
        console.log("worked")

        const delay = setTimeout(async () => {
            try {
                setLoading(true);
                const { data } = await fetchSupplier();
                if (data.success) {
                    setProducts(data.supplier || []);
                }
            } catch (error) {
                console.log(error);
            } finally {
                setLoading(false);
            }
        }, 300);

        return () => clearTimeout(delay);
    }, [search]);

    const handleEdit = async (supplier) => {
        setEditId(supplier._id)
        setEditForm({
            name: supplier.name,
            phone: supplier.phone,
            address: supplier.address
        })
    }

    const updateSupplier = async () => {
        try {
            const { data } = await axios.put(
                `${backendUrl}/api/supplier/update/${editId}`,
                editForm
            );

            if (data.success) {
                toast.success("تمویل‌کننده موفقانه آپدیت شد");
                setEditId(null);
                getAllSupplier(); // refresh لیست
            }
        } catch (error) {
            console.log(error);
            toast.error(error.message);
        }
    };

    const deleteSupplier = async () => {
        try {
            const { data } = await axios.delete(backendUrl + `/api/supplier/delete/${deleteItemId}`)
            if (data.success) {
                toast.success(data.message)
            }
        } catch (error) {
            console.log(error);
            toast.error(error.message);
        }
    }

    const getTotalBlance = async (supplierId) => {
        try {
            const { data } = await axios.get(backendUrl + `/api/supplier-product/get-by-supplier?supplierId=${supplierId}`)
            if (data.success) {
                console.log("data is ", data)
                setTotal(data.total)
            }
            if (!data.success) {
                toast.error(data.message)
            }
        } catch (error) {
            console.log(error);
            toast.error(error.message);
        }
    }



    useEffect(() => {
        getAllSupplier()
    }, [])

    const getSupplierBlance = async (supplierId) => {
        try {
            const { data } = await axios.get(backendUrl + `/api/supplier-product/get/?supplierId=${supplierId}`)
            if (data.success) {
                console.log(data)
                setSupplierBlance(data.data)
            }
        } catch (error) {
            console.log(error);
            toast.error(error.message);
        }
    }

    const convertToEnglish = (str) => {
        const map = {
            "۰": "0", "۱": "1", "۲": "2", "۳": "3", "۴": "4",
            "۵": "5", "۶": "6", "۷": "7", "۸": "8", "۹": "9",
            "٠": "0", "١": "1", "٢": "2", "٣": "3", "٤": "4",
            "٥": "5", "٦": "6", "٧": "7", "٨": "8", "٩": "9"
        };
        return str.replace(/[۰-۹٠-٩]/g, d => map[d]);
    };

    const toPersianDate = (date) =>
        new Date(date).toLocaleDateString("fa-IR");

    return (
        <div className='w-full py-8 px-16'>
            <div className='flex justify-center'>
                <input onChange={(e) => setSearch(e.target.value)} className='border border-gray-400 rounded-xs py-1 px-2' type="text" placeholder='جستحوی تمویل کننده گان' />
            </div>

            <div className="flex justify-center mt-10">
                <div className="relative w-80">

                    <div
                        className={`absolute left-0 w-full bg-white shadow-lg p-8 rounded transition-all duration-300 ease-in-out ${showPay ? "top-8 opacity-100" : "top-0 opacity-0 pointer-events-none"} z-50 `}>
                        <div className="mb-4">
                            <p>پاسه</p>
                            <input onChange={(e) => setPasa(convertToEnglish(e.target.value))} value={pasa} className="border border-gray-500 rounded-xs w-full py-0.5" type="text" inputMode='numeric' />
                        </div>

                        <div>
                            <p>وجوره</p>
                            <input onChange={(e) => setWage(convertToEnglish(e.target.value))} value={wage} className="border border-gray-500 rounded-xs w-full py-0.5" type="text" inputMode='numeric' />
                        </div>
                        <div className='flex gap-2 mt-4'>
                            <button onClick={() => setShowPay(false)} className='text-white w-40 rounded py-0.5 bg-red-600'>لغو</button>
                            <button onClick={updateLoan} className='text-white w-40 rounded py-0.5 bg-green-600'>ذخیره</button>
                        </div>
                    </div>

                </div>
            </div>


            <div className='flex justify-center'>
                <div className='flex justify-center w-60 relative'>
                    <div className={`flex flex-col gap-8 items-center absolute shadow-2xl py-8 px-8 rounded-md transition-all duration-500 z-20 bg-white ${showDelete ? '-right-12 top-24' : '-right-12 -top-160'}`}>
                        <p>آیا میخواهید حذف نمایید</p>
                        <div className='flex justify-center gap-4'>
                            <button onClick={() => setShowDelete(false)} className='bg-red-600 text-white rounded w-32 py-0.5 cursor-pointer'>لغو</button>
                            <button onClick={deleteSupplier} className='bg-red-600 text-white rounded w-32 py-0.5 cursor-pointer'>حذف</button>
                        </div>
                    </div>
                </div>
            </div>

            <div className='mt-8'>
                <div>
                    <ul className='grid grid-cols-[3fr_3fr_3fr_1fr] text-center'>
                        <li className='bg-gray-300 border border-white py-1'>نام</li>
                        <li className='bg-gray-300 border border-white py-1'>شماره تماس</li>
                        <li className='bg-gray-300 border border-white py-1'>آدرس</li>
                        <li className='bg-gray-300 border border-white py-1'>ویرایش</li>
                    </ul>
                    {(products.length > 0 ? products : allSupplier).map(item => (
                        <ul key={item._id} onClick={() => {


                        }

                        } className="grid grid-cols-[3fr_3fr_3fr_1fr] text-center">

                            {editId === item._id ? (
                                <>
                                    <input
                                        className="border px-1 py-0.5"
                                        value={editForm.name}
                                        onChange={e => setEditForm({ ...editForm, name: e.target.value })}
                                    />
                                    <input
                                        className="border px-1 py-0.5"
                                        value={editForm.phone}
                                        onChange={e => setEditForm({ ...editForm, phone: e.target.value })}
                                    />
                                    <input
                                        className="border px-1 py-0.5"
                                        value={editForm.address}
                                        onChange={e => setEditForm({ ...editForm, address: e.target.value })}
                                    />
                                    <div className='flex justify-center gap-2 py-0.5'>
                                        {/* update button */}
                                        <img onClick={updateSupplier} src={assets.sell_icon} className='w-6 cursor-pointer' alt="" />
                                        {/* back button */}
                                        <img onClick={() => setEditId(null)} src={assets.back_icon} className='w-6 cursor-pointer' alt="" />

                                    </div>
                                </>
                            ) : (
                                <>
                                    <li onClick={() => {
                                        getSupplierBlance(item._id)
                                        getTotalBlance(item._id)
                                        setShowBlance(true)
                                    }
                                    } className="bg-gray-200 py-1 ">{item.name}</li>
                                    <li className="bg-gray-200 py-1 ">{item.phone}</li>
                                    <li className="bg-gray-200 py-1 ">{item.address}</li>
                                    <div className='flex justify-center gap-2 bg-gray-200 py-1 '>
                                        {/* edit button */}
                                        <img onClick={() => handleEdit(item)} src={assets.edit_icon} className='w-6 cursor-pointer' alt="" />
                                        {/* delete button */}
                                        <img onClick={() => {
                                            setDeleteItemId(item._id)
                                            setShowDelete(true)
                                            showPay(true)
                                        }} src={assets.delete_icon} className='w-6 cursor-pointer' alt="" />
                                    </div>
                                </>
                            )}
                        </ul>
                    ))}



                </div>
            </div>
            {/* show blance */}
            {showBlance && <div className='fixed inset-0 bg-black/50 flex justify-center items-center'>
                <div className='bg-white px-8 pt-12 pb-2 rounded w-[90%] h-[80%] overflow-y-auto relative'>
                    <div className='flex justify-between relative'>
                        <img src={assets.cancel_icon} onClick={() => setShowBlance(false)} className='w-6 cursor-pointer' alt="" />
                        <img src={assets.drop_down_icon} onClick={() => setIsToggle(!isToggle)} className='w-6 cursor-pointer' alt="" />
                        <div className={` bg-white w-[80%] absolute p-4 top-8 shadow-2xl shadow-sky-700 border-sky-700 border left-4 ${isToggle ? 'block' : 'hidden'}`}>
                            {total && <ul className='grid grid-cols-7 text-center py-2'>
                                <li>مجموع وزن</li>
                                <li>پاسه</li>
                                <li>رسید پاسه</li>
                                <li>باقی پاسه</li>
                                <li>مجموع وجوره</li>
                                <li>رسید وجوره</li>
                                <li>باقی وجوره</li>
                            </ul>}
                            {total && total.map((item, index) => (
                            <ul className='grid grid-cols-7 text-center bg-sky-700 text-white py-2 border-b border-white'>

                                <li>{item.totalWeight}</li>
                                <li>{item.totalPasa}</li>
                                <li>{item.pasaReceipt}</li>
                                <li>{(item.pasaRemaining).toFixed(2)}</li>
                                <li>{item.totalWage}</li>
                                <li>{item.wageReceipt}</li>
                                <li>{item.wageRemaining}</li>
                            </ul>
                            ))}
                        </div>
                    </div>
                    {supplierBlance && supplierBlance.map((item, index) => (
                        <div className='my-8'>
                            <ul className='grid grid-cols-8 mb-4 py-4 bg-sky-700 text-white text-center'>
                                <li>نام مشتری</li>
                                <li>{item.supplierName}</li>
                                <li>بیل نمبر</li>
                                <li>{item.bellNumber}</li>
                                <li>توضحات</li>
                                <li>{item.detail}</li>
                                <li>تاریخ</li>
                                <li>{toPersianDate(item.createdAt)}</li>
                            </ul>

                            <ul className='grid grid-cols-12 text-center mb-2 bg-gray-300'>
                                <li>نام </li>
                                <li>نوعیت</li>
                                <li>عیار</li>
                                <li>گرام</li>
                                <li>پاسه</li>
                                <li>پرداخت پاسه</li>
                                <li>باقی پاسه</li>
                                <li>وجوره</li>
                                <li>مجموع وجوره</li>
                                <li>رسید وجوره</li>
                                <li>باقی وجوره</li>
                                <li>توضیحات</li>
                                <li>#</li>
                            </ul>
                            {item.products.map((p, i) => (
                                <>

                                    <ul className='grid grid-cols-12 text-center my-1'>
                                        <li>{p.name}</li>
                                        <li>{p.type}</li>
                                        <li>{p.karat}</li>
                                        <li>{p.weight}</li>
                                        <li>{p.pasa}</li>
                                        <li>{p.pasaReceipt}</li>
                                        <li>{(p.pasaRemaining).toFixed(3)}</li>
                                        <li>{p.wagePerGram}</li>
                                        <li>{p.totalWage}</li>
                                        <li>{p.wageReceipt}</li>
                                        <li>{p.wageRemaining}</li>
                                        <li className='flex justify-center'><img onClick={() => {
                                            setTransactionId(item._id)
                                            setProductId(p.productId)
                                            setShowPay(true)
                                        }} src={assets.add_icon} className='w-6 cursor-pointer' alt="" /></li>
                                    </ul>
                                </>

                            ))}
                        </div>
                    ))}
                </div>
            </div>}

        </div>
    )
}

export default SupplierList
